
MACRO(CHECK_SIZEOF TYPE DEFAULT)

INCLUDE(CheckTypeSize)
INCLUDE(CheckIncludeFile)

STRING(REPLACE " " "_" VARTYPE "${TYPE}" )
STRING(REPLACE "*" "p" TMP "${VARTYPE}" )
STRING(TOUPPER   "${TMP}" VARTYPE )

IF("${SIZEOF_${VARTYPE}}" STREQUAL "")
CHECK_INCLUDE_FILE(sys/types.h HAVE_SYS_TYPES_H)
CHECK_INCLUDE_FILE(stdint.h HAVE_STDINT_H)
CHECK_INCLUDE_FILE(stddef.h HAVE_STDDEF_H)

#MESSAGE("var name SIZEOF_${VARTYPE}")
CHECK_TYPE_SIZE("${TYPE}" SIZEOF_${VARTYPE})
ENDIF("${SIZEOF_${VARTYPE}}" STREQUAL "")
 
IF(NOT SIZEOF_${VARTYPE})
SET(HAVE_${VARTYPE} 0)
SET(SIZEOF_${VARTYPE} ${DEFAULT})
ELSE(NOT  SIZEOF_${VARTYPE})
SET(HAVE_${VARTYPE} 1)
ENDIF(NOT SIZEOF_${VARTYPE})

MESSAGE(STATUS "Sizeof type ${TYPE} is  ${SIZEOF_${VARTYPE}}!")

ENDMACRO(CHECK_SIZEOF TYPE DEFAULT)
