import { CartesianFrame } from "../canvas/cartesian_frame";
import { CanvasView, FrameBox } from "../canvas/canvas";
import { Renderer, RendererView } from "../renderers/renderer";
import { DataRenderer } from "../renderers/data_renderer";
import { Tool, ToolView } from "../tools/tool";
import { Selection } from "../selections/selection";
import { LayoutDOM, LayoutDOMView, DOMBoxSizing, FullDisplay } from "../layouts/layout_dom";
import { Plot } from "./plot";
import { Title } from "../annotations/title";
import { AxisView } from "../axes/axis";
import { ToolbarPanel, ToolbarPanelView } from "../annotations/toolbar_panel";
import { Renderable } from "../../core/visuals";
import { RenderLevel } from "../../core/enums";
import { SerializableState } from "../../core/view";
import { Context2d, CanvasLayer } from "../../core/util/canvas";
import { Layoutable } from "../../core/layout";
import { BorderLayout } from "../../core/layout/border";
import { BBox } from "../../core/util/bbox";
import { RangeInfo, RangeOptions, RangeManager } from "./range_manager";
import { StateInfo, StateManager } from "./state_manager";
import { StyleSheet, StyleSheetLike } from "../../core/dom";
export declare class PlotView extends LayoutDOMView implements Renderable {
    model: Plot;
    visuals: Plot.Visuals;
    layout: BorderLayout;
    frame: CartesianFrame;
    canvas_view: CanvasView;
    get canvas(): CanvasView;
    protected _computed_style: StyleSheet;
    styles(): StyleSheetLike[];
    protected _title?: Title;
    protected _toolbar?: ToolbarPanel;
    get toolbar_panel(): ToolbarPanelView | undefined;
    protected _outer_bbox: BBox;
    protected _inner_bbox: BBox;
    protected _needs_paint: boolean;
    protected _invalidated_painters: Set<RendererView>;
    protected _invalidate_all: boolean;
    protected _state_manager: StateManager;
    protected _range_manager: RangeManager;
    get state(): StateManager;
    set invalidate_dataranges(value: boolean);
    protected _is_paused?: number;
    protected lod_started: boolean;
    protected _initial_state: StateInfo;
    protected throttled_paint: () => void;
    computed_renderers: Renderer[];
    renderer_view<T extends Renderer>(renderer: T): T["__view_type__"] | undefined;
    get base_font_size(): number | null;
    renderer_views: Map<Renderer, RendererView>;
    tool_views: Map<Tool, ToolView>;
    get is_paused(): boolean;
    get child_models(): LayoutDOM[];
    pause(): void;
    unpause(no_render?: boolean): void;
    private _needs_notify;
    notify_finished_after_paint(): void;
    request_render(): void;
    request_paint(to_invalidate: RendererView[] | RendererView | "everything"): void;
    invalidate_painters(to_invalidate: RendererView[] | RendererView | "everything"): void;
    schedule_paint(): void;
    request_layout(): void;
    reset(): void;
    remove(): void;
    render(): void;
    initialize(): void;
    lazy_initialize(): Promise<void>;
    box_sizing(): DOMBoxSizing;
    protected _intrinsic_display(): FullDisplay;
    _update_layout(): void;
    protected _measure_layout(): void;
    get axis_views(): AxisView[];
    update_range(range_info: RangeInfo | null, options?: RangeOptions): void;
    reset_range(): void;
    trigger_ranges_update_event(): void;
    get_selection(): Map<DataRenderer, Selection>;
    update_selection(selections: Map<DataRenderer, Selection> | null): void;
    reset_selection(): void;
    protected _invalidate_layout_if_needed(): void;
    get_renderer_views(): RendererView[];
    protected _compute_renderers(): Generator<Renderer, void, undefined>;
    build_renderer_views(): Promise<void>;
    build_tool_views(): Promise<void>;
    connect_signals(): void;
    has_finished(): boolean;
    _after_layout(): void;
    repaint(): void;
    paint(): void;
    protected _actual_paint(): void;
    protected _paint_levels(ctx: Context2d, level: RenderLevel, clip_region: FrameBox, global_clip: boolean): void;
    protected _paint_layout(ctx: Context2d, layout: Layoutable): void;
    protected _paint_empty(ctx: Context2d, frame_box: FrameBox): void;
    protected _paint_outline(ctx: Context2d, frame_box: FrameBox): void;
    export(type?: "auto" | "png" | "svg", hidpi?: boolean): CanvasLayer;
    serializable_state(): SerializableState;
    protected _hold_render_changed(): void;
}
//# sourceMappingURL=plot_canvas.d.ts.map