/*!
 * Copyright (c) 2012 - 2022, Anaconda, Inc., and Bokeh Contributors
 * All rights reserved.
 * 
 * Redistribution and use in source and binary forms, with or without modification,
 * are permitted provided that the following conditions are met:
 * 
 * Redistributions of source code must retain the above copyright notice,
 * this list of conditions and the following disclaimer.
 * 
 * Redistributions in binary form must reproduce the above copyright notice,
 * this list of conditions and the following disclaimer in the documentation
 * and/or other materials provided with the distribution.
 * 
 * Neither the name of Anaconda nor the names of any contributors
 * may be used to endorse or promote products derived from this software
 * without specific prior written permission.
 * 
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS"
 * AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
 * ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT OWNER OR CONTRIBUTORS BE
 * LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR
 * CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF
 * SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS
 * INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN
 * CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE)
 * ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF
 * THE POSSIBILITY OF SUCH DAMAGE.
 */
(function(root, factory) {
  factory(root["Bokeh"], "3.0.0-dev.18");
})(this, function(Bokeh, version) {
  let define;
  return (function(modules, entry, aliases, externals) {
    const bokeh = typeof Bokeh !== "undefined" && (version != null ? Bokeh[version] : Bokeh);
    if (bokeh != null) {
      return bokeh.register_plugin(modules, entry, aliases);
    } else {
      throw new Error("Cannot find Bokeh " + version + ". You have to load it prior to loading plugins.");
    }
  })
({
623: /* models/text/mathjax/main.js */ function _(require, module, exports, __esModule, __esExport) {
    __esModule();
    require(624) /* ./index */;
},
624: /* models/text/mathjax/index.js */ function _(require, module, exports, __esModule, __esExport) {
    __esModule();
    const mathjax_js_1 = require(625) /* mathjax-full/js/mathjax.js */;
    const tex_js_1 = require(630) /* mathjax-full/js/input/tex.js */;
    const mathml_1 = require(668) /* mathjax-full/js/input/mathml */;
    // import {AsciiMath} from "mathjax-full/js/input/asciimath"
    const svg_js_1 = require(671) /* mathjax-full/js/output/svg.js */;
    const browserAdaptor_1 = require(820) /* mathjax-full/js/adaptors/browserAdaptor */;
    const html_js_1 = require(823) /* mathjax-full/js/handlers/html.js */;
    const AllPackages_js_1 = require(841) /* mathjax-full/js/input/tex/AllPackages.js */;
    const FindTeX_js_1 = require(634) /* mathjax-full/js/input/tex/FindTeX.js */;
    const adaptor = (0, browserAdaptor_1.browserAdaptor)();
    (0, html_js_1.RegisterHTMLHandler)(adaptor);
    const svg = new svg_js_1.SVG({ fontCache: "local" });
    const defaults = {
        display: true,
        em: 16,
        ex: 8,
        containerWidth: 80 * 16,
    };
    function tex2svg(formula, options, macros = {}) {
        const tex = new tex_js_1.TeX({ packages: AllPackages_js_1.AllPackages, macros });
        const tex_to_svg = mathjax_js_1.mathjax.document("", { InputJax: tex, OutputJax: svg });
        return tex_to_svg.convert(formula, Object.assign(Object.assign({}, defaults), options));
    }
    exports.tex2svg = tex2svg;
    function ascii2svg(_formula) {
        // TODO:
        // const ascii = new AsciiMath({})
        // const ascii_to_svg = mathjax.document("", {InputJax: ascii, OutputJax: svg})
        // return ascii_to_svg.convert(formula, options)
        throw new Error("not implemented");
    }
    exports.ascii2svg = ascii2svg;
    function mathml2svg(formula) {
        const mathml = new mathml_1.MathML({});
        const mathml_to_svg = mathjax_js_1.mathjax.document("", { InputJax: mathml, OutputJax: svg });
        return mathml_to_svg.convert(formula, defaults);
    }
    exports.mathml2svg = mathml2svg;
    function find_tex(text) {
        const find_text = new FindTeX_js_1.FindTeX({
            processEnvironments: false,
            processEscapes: false,
            processRefs: false,
        });
        return find_text.findMath([text]);
    }
    exports.find_tex = find_tex;
},
625: /* mathjax-full/js/mathjax.js */ function _(require, module, exports, __esModule, __esExport) {
    __esModule();
    var version_js_1 = require(626) /* ./components/version.js */;
    var HandlerList_js_1 = require(627) /* ./core/HandlerList.js */;
    var Retries_js_1 = require(629) /* ./util/Retries.js */;
    exports.mathjax = {
        version: version_js_1.VERSION,
        handlers: new HandlerList_js_1.HandlerList(),
        document: function (document, options) {
            return exports.mathjax.handlers.document(document, options);
        },
        handleRetriesFor: Retries_js_1.handleRetriesFor,
        retryAfter: Retries_js_1.retryAfter,
        asyncLoad: null,
    };
},
626: /* mathjax-full/js/components/version.js */ function _(require, module, exports, __esModule, __esExport) {
    __esModule();
    exports.VERSION = "0.0.0";
},
627: /* mathjax-full/js/core/HandlerList.js */ function _(require, module, exports, __esModule, __esExport) {
    var __extends = (this && this.__extends) || (function () {
        var extendStatics = function (d, b) {
            extendStatics = Object.setPrototypeOf ||
                ({ __proto__: [] } instanceof Array && function (d, b) { d.__proto__ = b; }) ||
                function (d, b) { for (var p in b)
                    if (Object.prototype.hasOwnProperty.call(b, p))
                        d[p] = b[p]; };
            return extendStatics(d, b);
        };
        return function (d, b) {
            if (typeof b !== "function" && b !== null)
                throw new TypeError("Class extends value " + String(b) + " is not a constructor or null");
            extendStatics(d, b);
            function __() { this.constructor = d; }
            d.prototype = b === null ? Object.create(b) : (__.prototype = b.prototype, new __());
        };
    })();
    var __values = (this && this.__values) || function (o) {
        var s = typeof Symbol === "function" && Symbol.iterator, m = s && o[s], i = 0;
        if (m)
            return m.call(o);
        if (o && typeof o.length === "number")
            return {
                next: function () {
                    if (o && i >= o.length)
                        o = void 0;
                    return { value: o && o[i++], done: !o };
                }
            };
        throw new TypeError(s ? "Object is not iterable." : "Symbol.iterator is not defined.");
    };
    __esModule();
    var PrioritizedList_js_1 = require(628) /* ../util/PrioritizedList.js */;
    var HandlerList = (function (_super) {
        __extends(HandlerList, _super);
        function HandlerList() {
            return _super !== null && _super.apply(this, arguments) || this;
        }
        HandlerList.prototype.register = function (handler) {
            return this.add(handler, handler.priority);
        };
        HandlerList.prototype.unregister = function (handler) {
            this.remove(handler);
        };
        HandlerList.prototype.handlesDocument = function (document) {
            var e_1, _a;
            try {
                for (var _b = __values(this), _c = _b.next(); !_c.done; _c = _b.next()) {
                    var item = _c.value;
                    var handler = item.item;
                    if (handler.handlesDocument(document)) {
                        return handler;
                    }
                }
            }
            catch (e_1_1) {
                e_1 = { error: e_1_1 };
            }
            finally {
                try {
                    if (_c && !_c.done && (_a = _b.return))
                        _a.call(_b);
                }
                finally {
                    if (e_1)
                        throw e_1.error;
                }
            }
            throw new Error("Can't find handler for document");
        };
        HandlerList.prototype.document = function (document, options) {
            if (options === void 0) {
                options = null;
            }
            return this.handlesDocument(document).create(document, options);
        };
        return HandlerList;
    }(PrioritizedList_js_1.PrioritizedList));
    exports.HandlerList = HandlerList;
},
628: /* mathjax-full/js/util/PrioritizedList.js */ function _(require, module, exports, __esModule, __esExport) {
    __esModule();
    var PrioritizedList = (function () {
        function PrioritizedList() {
            this.items = [];
            this.items = [];
        }
        PrioritizedList.prototype[Symbol.iterator] = function () {
            var i = 0;
            var items = this.items;
            return {
                next: function () {
                    return { value: items[i++], done: (i > items.length) };
                }
            };
        };
        PrioritizedList.prototype.add = function (item, priority) {
            if (priority === void 0) {
                priority = PrioritizedList.DEFAULTPRIORITY;
            }
            var i = this.items.length;
            do {
                i--;
            } while (i >= 0 && priority < this.items[i].priority);
            this.items.splice(i + 1, 0, { item: item, priority: priority });
            return item;
        };
        PrioritizedList.prototype.remove = function (item) {
            var i = this.items.length;
            do {
                i--;
            } while (i >= 0 && this.items[i].item !== item);
            if (i >= 0) {
                this.items.splice(i, 1);
            }
        };
        PrioritizedList.DEFAULTPRIORITY = 5;
        return PrioritizedList;
    }());
    exports.PrioritizedList = PrioritizedList;
},
629: /* mathjax-full/js/util/Retries.js */ function _(require, module, exports, __esModule, __esExport) {
    __esModule();
    function handleRetriesFor(code) {
        return new Promise(function run(ok, fail) {
            try {
                ok(code());
            }
            catch (err) {
                if (err.retry && err.retry instanceof Promise) {
                    err.retry.then(function () { return run(ok, fail); })
                        .catch(function (perr) { return fail(perr); });
                }
                else if (err.restart && err.restart.isCallback) {
                    MathJax.Callback.After(function () { return run(ok, fail); }, err.restart);
                }
                else {
                    fail(err);
                }
            }
        });
    }
    exports.handleRetriesFor = handleRetriesFor;
    function retryAfter(promise) {
        var err = new Error('MathJax retry');
        err.retry = promise;
        throw err;
    }
    exports.retryAfter = retryAfter;
},
630: /* mathjax-full/js/input/tex.js */ function _(require, module, exports, __esModule, __esExport) {
    var __extends = (this && this.__extends) || (function () {
        var extendStatics = function (d, b) {
            extendStatics = Object.setPrototypeOf ||
                ({ __proto__: [] } instanceof Array && function (d, b) { d.__proto__ = b; }) ||
                function (d, b) { for (var p in b)
                    if (Object.prototype.hasOwnProperty.call(b, p))
                        d[p] = b[p]; };
            return extendStatics(d, b);
        };
        return function (d, b) {
            if (typeof b !== "function" && b !== null)
                throw new TypeError("Class extends value " + String(b) + " is not a constructor or null");
            extendStatics(d, b);
            function __() { this.constructor = d; }
            d.prototype = b === null ? Object.create(b) : (__.prototype = b.prototype, new __());
        };
    })();
    var __assign = (this && this.__assign) || function () {
        __assign = Object.assign || function (t) {
            for (var s, i = 1, n = arguments.length; i < n; i++) {
                s = arguments[i];
                for (var p in s)
                    if (Object.prototype.hasOwnProperty.call(s, p))
                        t[p] = s[p];
            }
            return t;
        };
        return __assign.apply(this, arguments);
    };
    var __read = (this && this.__read) || function (o, n) {
        var m = typeof Symbol === "function" && o[Symbol.iterator];
        if (!m)
            return o;
        var i = m.call(o), r, ar = [], e;
        try {
            while ((n === void 0 || n-- > 0) && !(r = i.next()).done)
                ar.push(r.value);
        }
        catch (error) {
            e = { error: error };
        }
        finally {
            try {
                if (r && !r.done && (m = i["return"]))
                    m.call(i);
            }
            finally {
                if (e)
                    throw e.error;
            }
        }
        return ar;
    };
    var __importDefault = (this && this.__importDefault) || function (mod) {
        return (mod && mod.__esModule) ? mod : { "default": mod };
    };
    __esModule();
    var InputJax_js_1 = require(631) /* ../core/InputJax.js */;
    var Options_js_1 = require(632) /* ../util/Options.js */;
    var FindTeX_js_1 = require(634) /* ./tex/FindTeX.js */;
    var FilterUtil_js_1 = __importDefault(require(638) /* ./tex/FilterUtil.js */);
    var NodeUtil_js_1 = __importDefault(require(642) /* ./tex/NodeUtil.js */);
    var TexParser_js_1 = __importDefault(require(645) /* ./tex/TexParser.js */);
    var TexError_js_1 = __importDefault(require(647) /* ./tex/TexError.js */);
    var ParseOptions_js_1 = __importDefault(require(651) /* ./tex/ParseOptions.js */);
    var Tags_js_1 = require(656) /* ./tex/Tags.js */;
    var Configuration_js_1 = require(657) /* ./tex/Configuration.js */;
    require(659) /* ./tex/base/BaseConfiguration.js */;
    var TeX = (function (_super) {
        __extends(TeX, _super);
        function TeX(options) {
            if (options === void 0) {
                options = {};
            }
            var _this = this;
            var _a = __read((0, Options_js_1.separateOptions)(options, TeX.OPTIONS, FindTeX_js_1.FindTeX.OPTIONS), 3), rest = _a[0], tex = _a[1], find = _a[2];
            _this = _super.call(this, tex) || this;
            _this.findTeX = _this.options['FindTeX'] || new FindTeX_js_1.FindTeX(find);
            var packages = _this.options.packages;
            var configuration = _this.configuration = TeX.configure(packages);
            var parseOptions = _this._parseOptions =
                new ParseOptions_js_1.default(configuration, [_this.options, Tags_js_1.TagsFactory.OPTIONS]);
            (0, Options_js_1.userOptions)(parseOptions.options, rest);
            configuration.config(_this);
            TeX.tags(parseOptions, configuration);
            _this.postFilters.add(FilterUtil_js_1.default.cleanSubSup, -6);
            _this.postFilters.add(FilterUtil_js_1.default.setInherited, -5);
            _this.postFilters.add(FilterUtil_js_1.default.moveLimits, -4);
            _this.postFilters.add(FilterUtil_js_1.default.cleanStretchy, -3);
            _this.postFilters.add(FilterUtil_js_1.default.cleanAttributes, -2);
            _this.postFilters.add(FilterUtil_js_1.default.combineRelations, -1);
            return _this;
        }
        TeX.configure = function (packages) {
            var configuration = new Configuration_js_1.ParserConfiguration(packages, ['tex']);
            configuration.init();
            return configuration;
        };
        TeX.tags = function (options, configuration) {
            Tags_js_1.TagsFactory.addTags(configuration.tags);
            Tags_js_1.TagsFactory.setDefault(options.options.tags);
            options.tags = Tags_js_1.TagsFactory.getDefault();
            options.tags.configuration = options;
        };
        TeX.prototype.setMmlFactory = function (mmlFactory) {
            _super.prototype.setMmlFactory.call(this, mmlFactory);
            this._parseOptions.nodeFactory.setMmlFactory(mmlFactory);
        };
        Object.defineProperty(TeX.prototype, "parseOptions", {
            get: function () {
                return this._parseOptions;
            },
            enumerable: false,
            configurable: true
        });
        TeX.prototype.reset = function (tag) {
            if (tag === void 0) {
                tag = 0;
            }
            this.parseOptions.tags.reset(tag);
        };
        TeX.prototype.compile = function (math, document) {
            this.parseOptions.clear();
            this.executeFilters(this.preFilters, math, document, this.parseOptions);
            var display = math.display;
            this.latex = math.math;
            var node;
            this.parseOptions.tags.startEquation(math);
            var globalEnv;
            try {
                var parser = new TexParser_js_1.default(this.latex, { display: display, isInner: false }, this.parseOptions);
                node = parser.mml();
                globalEnv = parser.stack.global;
            }
            catch (err) {
                if (!(err instanceof TexError_js_1.default)) {
                    throw err;
                }
                this.parseOptions.error = true;
                node = this.options.formatError(this, err);
            }
            node = this.parseOptions.nodeFactory.create('node', 'math', [node]);
            if (globalEnv === null || globalEnv === void 0 ? void 0 : globalEnv.indentalign) {
                NodeUtil_js_1.default.setAttribute(node, 'indentalign', globalEnv.indentalign);
            }
            if (display) {
                NodeUtil_js_1.default.setAttribute(node, 'display', 'block');
            }
            this.parseOptions.tags.finishEquation(math);
            this.parseOptions.root = node;
            this.executeFilters(this.postFilters, math, document, this.parseOptions);
            this.mathNode = this.parseOptions.root;
            return this.mathNode;
        };
        TeX.prototype.findMath = function (strings) {
            return this.findTeX.findMath(strings);
        };
        TeX.prototype.formatError = function (err) {
            var message = err.message.replace(/\n.*/, '');
            return this.parseOptions.nodeFactory.create('error', message, err.id, this.latex);
        };
        TeX.NAME = 'TeX';
        TeX.OPTIONS = __assign(__assign({}, InputJax_js_1.AbstractInputJax.OPTIONS), { FindTeX: null, packages: ['base'], digits: /^(?:[0-9]+(?:\{,\}[0-9]{3})*(?:\.[0-9]*)?|\.[0-9]+)/, maxBuffer: 5 * 1024, formatError: function (jax, err) { return jax.formatError(err); } });
        return TeX;
    }(InputJax_js_1.AbstractInputJax));
    exports.TeX = TeX;
},
631: /* mathjax-full/js/core/InputJax.js */ function _(require, module, exports, __esModule, __esExport) {
    __esModule();
    var Options_js_1 = require(632) /* ../util/Options.js */;
    var FunctionList_js_1 = require(633) /* ../util/FunctionList.js */;
    var AbstractInputJax = (function () {
        function AbstractInputJax(options) {
            if (options === void 0) {
                options = {};
            }
            this.adaptor = null;
            this.mmlFactory = null;
            var CLASS = this.constructor;
            this.options = (0, Options_js_1.userOptions)((0, Options_js_1.defaultOptions)({}, CLASS.OPTIONS), options);
            this.preFilters = new FunctionList_js_1.FunctionList();
            this.postFilters = new FunctionList_js_1.FunctionList();
        }
        Object.defineProperty(AbstractInputJax.prototype, "name", {
            get: function () {
                return this.constructor.NAME;
            },
            enumerable: false,
            configurable: true
        });
        AbstractInputJax.prototype.setAdaptor = function (adaptor) {
            this.adaptor = adaptor;
        };
        AbstractInputJax.prototype.setMmlFactory = function (mmlFactory) {
            this.mmlFactory = mmlFactory;
        };
        AbstractInputJax.prototype.initialize = function () {
        };
        AbstractInputJax.prototype.reset = function () {
            var _args = [];
            for (var _i = 0; _i < arguments.length; _i++) {
                _args[_i] = arguments[_i];
            }
        };
        Object.defineProperty(AbstractInputJax.prototype, "processStrings", {
            get: function () {
                return true;
            },
            enumerable: false,
            configurable: true
        });
        AbstractInputJax.prototype.findMath = function (_node, _options) {
            return [];
        };
        AbstractInputJax.prototype.executeFilters = function (filters, math, document, data) {
            var args = { math: math, document: document, data: data };
            filters.execute(args);
            return args.data;
        };
        AbstractInputJax.NAME = 'generic';
        AbstractInputJax.OPTIONS = {};
        return AbstractInputJax;
    }());
    exports.AbstractInputJax = AbstractInputJax;
},
632: /* mathjax-full/js/util/Options.js */ function _(require, module, exports, __esModule, __esExport) {
    var __values = (this && this.__values) || function (o) {
        var s = typeof Symbol === "function" && Symbol.iterator, m = s && o[s], i = 0;
        if (m)
            return m.call(o);
        if (o && typeof o.length === "number")
            return {
                next: function () {
                    if (o && i >= o.length)
                        o = void 0;
                    return { value: o && o[i++], done: !o };
                }
            };
        throw new TypeError(s ? "Object is not iterable." : "Symbol.iterator is not defined.");
    };
    var __read = (this && this.__read) || function (o, n) {
        var m = typeof Symbol === "function" && o[Symbol.iterator];
        if (!m)
            return o;
        var i = m.call(o), r, ar = [], e;
        try {
            while ((n === void 0 || n-- > 0) && !(r = i.next()).done)
                ar.push(r.value);
        }
        catch (error) {
            e = { error: error };
        }
        finally {
            try {
                if (r && !r.done && (m = i["return"]))
                    m.call(i);
            }
            finally {
                if (e)
                    throw e.error;
            }
        }
        return ar;
    };
    var __spreadArray = (this && this.__spreadArray) || function (to, from, pack) {
        if (pack || arguments.length === 2)
            for (var i = 0, l = from.length, ar; i < l; i++) {
                if (ar || !(i in from)) {
                    if (!ar)
                        ar = Array.prototype.slice.call(from, 0, i);
                    ar[i] = from[i];
                }
            }
        return to.concat(ar || Array.prototype.slice.call(from));
    };
    __esModule();
    var OBJECT = {}.constructor;
    function isObject(obj) {
        return typeof obj === 'object' && obj !== null &&
            (obj.constructor === OBJECT || obj.constructor === Expandable);
    }
    exports.isObject = isObject;
    exports.APPEND = '[+]';
    exports.REMOVE = '[-]';
    exports.OPTIONS = {
        invalidOption: 'warn',
        optionError: function (message, _key) {
            if (exports.OPTIONS.invalidOption === 'fatal') {
                throw new Error(message);
            }
            console.warn('MathJax: ' + message);
        }
    };
    var Expandable = (function () {
        function Expandable() {
        }
        return Expandable;
    }());
    exports.Expandable = Expandable;
    function expandable(def) {
        return Object.assign(Object.create(Expandable.prototype), def);
    }
    exports.expandable = expandable;
    function makeArray(x) {
        return Array.isArray(x) ? x : [x];
    }
    exports.makeArray = makeArray;
    function keys(def) {
        if (!def) {
            return [];
        }
        return Object.keys(def).concat(Object.getOwnPropertySymbols(def));
    }
    exports.keys = keys;
    function copy(def) {
        var e_1, _a;
        var props = {};
        try {
            for (var _b = __values(keys(def)), _c = _b.next(); !_c.done; _c = _b.next()) {
                var key = _c.value;
                var prop = Object.getOwnPropertyDescriptor(def, key);
                var value = prop.value;
                if (Array.isArray(value)) {
                    prop.value = insert([], value, false);
                }
                else if (isObject(value)) {
                    prop.value = copy(value);
                }
                if (prop.enumerable) {
                    props[key] = prop;
                }
            }
        }
        catch (e_1_1) {
            e_1 = { error: e_1_1 };
        }
        finally {
            try {
                if (_c && !_c.done && (_a = _b.return))
                    _a.call(_b);
            }
            finally {
                if (e_1)
                    throw e_1.error;
            }
        }
        return Object.defineProperties(def.constructor === Expandable ? expandable({}) : {}, props);
    }
    exports.copy = copy;
    function insert(dst, src, warn) {
        var e_2, _a;
        if (warn === void 0) {
            warn = true;
        }
        var _loop_1 = function (key) {
            if (warn && dst[key] === undefined && dst.constructor !== Expandable) {
                if (typeof key === 'symbol') {
                    key = key.toString();
                }
                exports.OPTIONS.optionError("Invalid option \"".concat(key, "\" (no default value)."), key);
                return "continue";
            }
            var sval = src[key], dval = dst[key];
            if (isObject(sval) && dval !== null &&
                (typeof dval === 'object' || typeof dval === 'function')) {
                var ids = keys(sval);
                if (Array.isArray(dval) &&
                    ((ids.length === 1 && (ids[0] === exports.APPEND || ids[0] === exports.REMOVE) && Array.isArray(sval[ids[0]])) ||
                        (ids.length === 2 && ids.sort().join(',') === exports.APPEND + ',' + exports.REMOVE &&
                            Array.isArray(sval[exports.APPEND]) && Array.isArray(sval[exports.REMOVE])))) {
                    if (sval[exports.REMOVE]) {
                        dval = dst[key] = dval.filter(function (x) { return sval[exports.REMOVE].indexOf(x) < 0; });
                    }
                    if (sval[exports.APPEND]) {
                        dst[key] = __spreadArray(__spreadArray([], __read(dval), false), __read(sval[exports.APPEND]), false);
                    }
                }
                else {
                    insert(dval, sval, warn);
                }
            }
            else if (Array.isArray(sval)) {
                dst[key] = [];
                insert(dst[key], sval, false);
            }
            else if (isObject(sval)) {
                dst[key] = copy(sval);
            }
            else {
                dst[key] = sval;
            }
        };
        try {
            for (var _b = __values(keys(src)), _c = _b.next(); !_c.done; _c = _b.next()) {
                var key = _c.value;
                _loop_1(key);
            }
        }
        catch (e_2_1) {
            e_2 = { error: e_2_1 };
        }
        finally {
            try {
                if (_c && !_c.done && (_a = _b.return))
                    _a.call(_b);
            }
            finally {
                if (e_2)
                    throw e_2.error;
            }
        }
        return dst;
    }
    exports.insert = insert;
    function defaultOptions(options) {
        var defs = [];
        for (var _i = 1; _i < arguments.length; _i++) {
            defs[_i - 1] = arguments[_i];
        }
        defs.forEach(function (def) { return insert(options, def, false); });
        return options;
    }
    exports.defaultOptions = defaultOptions;
    function userOptions(options) {
        var defs = [];
        for (var _i = 1; _i < arguments.length; _i++) {
            defs[_i - 1] = arguments[_i];
        }
        defs.forEach(function (def) { return insert(options, def, true); });
        return options;
    }
    exports.userOptions = userOptions;
    function selectOptions(options) {
        var e_3, _a;
        var keys = [];
        for (var _i = 1; _i < arguments.length; _i++) {
            keys[_i - 1] = arguments[_i];
        }
        var subset = {};
        try {
            for (var keys_1 = __values(keys), keys_1_1 = keys_1.next(); !keys_1_1.done; keys_1_1 = keys_1.next()) {
                var key = keys_1_1.value;
                if (options.hasOwnProperty(key)) {
                    subset[key] = options[key];
                }
            }
        }
        catch (e_3_1) {
            e_3 = { error: e_3_1 };
        }
        finally {
            try {
                if (keys_1_1 && !keys_1_1.done && (_a = keys_1.return))
                    _a.call(keys_1);
            }
            finally {
                if (e_3)
                    throw e_3.error;
            }
        }
        return subset;
    }
    exports.selectOptions = selectOptions;
    function selectOptionsFromKeys(options, object) {
        return selectOptions.apply(void 0, __spreadArray([options], __read(Object.keys(object)), false));
    }
    exports.selectOptionsFromKeys = selectOptionsFromKeys;
    function separateOptions(options) {
        var e_4, _a, e_5, _b;
        var objects = [];
        for (var _i = 1; _i < arguments.length; _i++) {
            objects[_i - 1] = arguments[_i];
        }
        var results = [];
        try {
            for (var objects_1 = __values(objects), objects_1_1 = objects_1.next(); !objects_1_1.done; objects_1_1 = objects_1.next()) {
                var object = objects_1_1.value;
                var exists = {}, missing = {};
                try {
                    for (var _c = (e_5 = void 0, __values(Object.keys(options || {}))), _d = _c.next(); !_d.done; _d = _c.next()) {
                        var key = _d.value;
                        (object[key] === undefined ? missing : exists)[key] = options[key];
                    }
                }
                catch (e_5_1) {
                    e_5 = { error: e_5_1 };
                }
                finally {
                    try {
                        if (_d && !_d.done && (_b = _c.return))
                            _b.call(_c);
                    }
                    finally {
                        if (e_5)
                            throw e_5.error;
                    }
                }
                results.push(exists);
                options = missing;
            }
        }
        catch (e_4_1) {
            e_4 = { error: e_4_1 };
        }
        finally {
            try {
                if (objects_1_1 && !objects_1_1.done && (_a = objects_1.return))
                    _a.call(objects_1);
            }
            finally {
                if (e_4)
                    throw e_4.error;
            }
        }
        results.unshift(options);
        return results;
    }
    exports.separateOptions = separateOptions;
    function lookup(name, lookup, def) {
        if (def === void 0) {
            def = null;
        }
        return (lookup.hasOwnProperty(name) ? lookup[name] : def);
    }
    exports.lookup = lookup;
},
633: /* mathjax-full/js/util/FunctionList.js */ function _(require, module, exports, __esModule, __esExport) {
    var __extends = (this && this.__extends) || (function () {
        var extendStatics = function (d, b) {
            extendStatics = Object.setPrototypeOf ||
                ({ __proto__: [] } instanceof Array && function (d, b) { d.__proto__ = b; }) ||
                function (d, b) { for (var p in b)
                    if (Object.prototype.hasOwnProperty.call(b, p))
                        d[p] = b[p]; };
            return extendStatics(d, b);
        };
        return function (d, b) {
            if (typeof b !== "function" && b !== null)
                throw new TypeError("Class extends value " + String(b) + " is not a constructor or null");
            extendStatics(d, b);
            function __() { this.constructor = d; }
            d.prototype = b === null ? Object.create(b) : (__.prototype = b.prototype, new __());
        };
    })();
    var __values = (this && this.__values) || function (o) {
        var s = typeof Symbol === "function" && Symbol.iterator, m = s && o[s], i = 0;
        if (m)
            return m.call(o);
        if (o && typeof o.length === "number")
            return {
                next: function () {
                    if (o && i >= o.length)
                        o = void 0;
                    return { value: o && o[i++], done: !o };
                }
            };
        throw new TypeError(s ? "Object is not iterable." : "Symbol.iterator is not defined.");
    };
    var __read = (this && this.__read) || function (o, n) {
        var m = typeof Symbol === "function" && o[Symbol.iterator];
        if (!m)
            return o;
        var i = m.call(o), r, ar = [], e;
        try {
            while ((n === void 0 || n-- > 0) && !(r = i.next()).done)
                ar.push(r.value);
        }
        catch (error) {
            e = { error: error };
        }
        finally {
            try {
                if (r && !r.done && (m = i["return"]))
                    m.call(i);
            }
            finally {
                if (e)
                    throw e.error;
            }
        }
        return ar;
    };
    var __spreadArray = (this && this.__spreadArray) || function (to, from, pack) {
        if (pack || arguments.length === 2)
            for (var i = 0, l = from.length, ar; i < l; i++) {
                if (ar || !(i in from)) {
                    if (!ar)
                        ar = Array.prototype.slice.call(from, 0, i);
                    ar[i] = from[i];
                }
            }
        return to.concat(ar || Array.prototype.slice.call(from));
    };
    __esModule();
    var PrioritizedList_js_1 = require(628) /* ./PrioritizedList.js */;
    var FunctionList = (function (_super) {
        __extends(FunctionList, _super);
        function FunctionList() {
            return _super !== null && _super.apply(this, arguments) || this;
        }
        FunctionList.prototype.execute = function () {
            var e_1, _a;
            var data = [];
            for (var _i = 0; _i < arguments.length; _i++) {
                data[_i] = arguments[_i];
            }
            try {
                for (var _b = __values(this), _c = _b.next(); !_c.done; _c = _b.next()) {
                    var item = _c.value;
                    var result = item.item.apply(item, __spreadArray([], __read(data), false));
                    if (result === false) {
                        return false;
                    }
                }
            }
            catch (e_1_1) {
                e_1 = { error: e_1_1 };
            }
            finally {
                try {
                    if (_c && !_c.done && (_a = _b.return))
                        _a.call(_b);
                }
                finally {
                    if (e_1)
                        throw e_1.error;
                }
            }
            return true;
        };
        FunctionList.prototype.asyncExecute = function () {
            var data = [];
            for (var _i = 0; _i < arguments.length; _i++) {
                data[_i] = arguments[_i];
            }
            var i = -1;
            var items = this.items;
            return new Promise(function (ok, fail) {
                (function execute() {
                    var _a;
                    while (++i < items.length) {
                        var result = (_a = items[i]).item.apply(_a, __spreadArray([], __read(data), false));
                        if (result instanceof Promise) {
                            result.then(execute).catch(function (err) { return fail(err); });
                            return;
                        }
                        if (result === false) {
                            ok(false);
                            return;
                        }
                    }
                    ok(true);
                })();
            });
        };
        return FunctionList;
    }(PrioritizedList_js_1.PrioritizedList));
    exports.FunctionList = FunctionList;
},
634: /* mathjax-full/js/input/tex/FindTeX.js */ function _(require, module, exports, __esModule, __esExport) {
    var __extends = (this && this.__extends) || (function () {
        var extendStatics = function (d, b) {
            extendStatics = Object.setPrototypeOf ||
                ({ __proto__: [] } instanceof Array && function (d, b) { d.__proto__ = b; }) ||
                function (d, b) { for (var p in b)
                    if (Object.prototype.hasOwnProperty.call(b, p))
                        d[p] = b[p]; };
            return extendStatics(d, b);
        };
        return function (d, b) {
            if (typeof b !== "function" && b !== null)
                throw new TypeError("Class extends value " + String(b) + " is not a constructor or null");
            extendStatics(d, b);
            function __() { this.constructor = d; }
            d.prototype = b === null ? Object.create(b) : (__.prototype = b.prototype, new __());
        };
    })();
    var __read = (this && this.__read) || function (o, n) {
        var m = typeof Symbol === "function" && o[Symbol.iterator];
        if (!m)
            return o;
        var i = m.call(o), r, ar = [], e;
        try {
            while ((n === void 0 || n-- > 0) && !(r = i.next()).done)
                ar.push(r.value);
        }
        catch (error) {
            e = { error: error };
        }
        finally {
            try {
                if (r && !r.done && (m = i["return"]))
                    m.call(i);
            }
            finally {
                if (e)
                    throw e.error;
            }
        }
        return ar;
    };
    __esModule();
    var FindMath_js_1 = require(635) /* ../../core/FindMath.js */;
    var string_js_1 = require(636) /* ../../util/string.js */;
    var MathItem_js_1 = require(637) /* ../../core/MathItem.js */;
    var FindTeX = (function (_super) {
        __extends(FindTeX, _super);
        function FindTeX(options) {
            var _this = _super.call(this, options) || this;
            _this.getPatterns();
            return _this;
        }
        FindTeX.prototype.getPatterns = function () {
            var _this = this;
            var options = this.options;
            var starts = [], parts = [], subparts = [];
            this.end = {};
            this.env = this.sub = 0;
            var i = 1;
            options['inlineMath'].forEach(function (delims) { return _this.addPattern(starts, delims, false); });
            options['displayMath'].forEach(function (delims) { return _this.addPattern(starts, delims, true); });
            if (starts.length) {
                parts.push(starts.sort(string_js_1.sortLength).join('|'));
            }
            if (options['processEnvironments']) {
                parts.push('\\\\begin\\s*\\{([^}]*)\\}');
                this.env = i;
                i++;
            }
            if (options['processEscapes']) {
                subparts.push('\\\\([\\\\$])');
            }
            if (options['processRefs']) {
                subparts.push('(\\\\(?:eq)?ref\\s*\\{[^}]*\\})');
            }
            if (subparts.length) {
                parts.push('(' + subparts.join('|') + ')');
                this.sub = i;
            }
            this.start = new RegExp(parts.join('|'), 'g');
            this.hasPatterns = (parts.length > 0);
        };
        FindTeX.prototype.addPattern = function (starts, delims, display) {
            var _a = __read(delims, 2), open = _a[0], close = _a[1];
            starts.push((0, string_js_1.quotePattern)(open));
            this.end[open] = [close, display, this.endPattern(close)];
        };
        FindTeX.prototype.endPattern = function (end, endp) {
            return new RegExp((endp || (0, string_js_1.quotePattern)(end)) + '|\\\\(?:[a-zA-Z]|.)|[{}]', 'g');
        };
        FindTeX.prototype.findEnd = function (text, n, start, end) {
            var _a = __read(end, 3), close = _a[0], display = _a[1], pattern = _a[2];
            var i = pattern.lastIndex = start.index + start[0].length;
            var match, braces = 0;
            while ((match = pattern.exec(text))) {
                if ((match[1] || match[0]) === close && braces === 0) {
                    return (0, MathItem_js_1.protoItem)(start[0], text.substr(i, match.index - i), match[0], n, start.index, match.index + match[0].length, display);
                }
                else if (match[0] === '{') {
                    braces++;
                }
                else if (match[0] === '}' && braces) {
                    braces--;
                }
            }
            return null;
        };
        FindTeX.prototype.findMathInString = function (math, n, text) {
            var start, match;
            this.start.lastIndex = 0;
            while ((start = this.start.exec(text))) {
                if (start[this.env] !== undefined && this.env) {
                    var end = '\\\\end\\s*(\\{' + (0, string_js_1.quotePattern)(start[this.env]) + '\\})';
                    match = this.findEnd(text, n, start, ['{' + start[this.env] + '}', true, this.endPattern(null, end)]);
                    if (match) {
                        match.math = match.open + match.math + match.close;
                        match.open = match.close = '';
                    }
                }
                else if (start[this.sub] !== undefined && this.sub) {
                    var math_1 = start[this.sub];
                    var end = start.index + start[this.sub].length;
                    if (math_1.length === 2) {
                        match = (0, MathItem_js_1.protoItem)('', math_1.substr(1), '', n, start.index, end);
                    }
                    else {
                        match = (0, MathItem_js_1.protoItem)('', math_1, '', n, start.index, end, false);
                    }
                }
                else {
                    match = this.findEnd(text, n, start, this.end[start[0]]);
                }
                if (match) {
                    math.push(match);
                    this.start.lastIndex = match.end.n;
                }
            }
        };
        FindTeX.prototype.findMath = function (strings) {
            var math = [];
            if (this.hasPatterns) {
                for (var i = 0, m = strings.length; i < m; i++) {
                    this.findMathInString(math, i, strings[i]);
                }
            }
            return math;
        };
        FindTeX.OPTIONS = {
            inlineMath: [
                ['\\(', '\\)']
            ],
            displayMath: [
                ['$$', '$$'],
                ['\\[', '\\]']
            ],
            processEscapes: true,
            processEnvironments: true,
            processRefs: true,
        };
        return FindTeX;
    }(FindMath_js_1.AbstractFindMath));
    exports.FindTeX = FindTeX;
},
635: /* mathjax-full/js/core/FindMath.js */ function _(require, module, exports, __esModule, __esExport) {
    __esModule();
    var Options_js_1 = require(632) /* ../util/Options.js */;
    var AbstractFindMath = (function () {
        function AbstractFindMath(options) {
            var CLASS = this.constructor;
            this.options = (0, Options_js_1.userOptions)((0, Options_js_1.defaultOptions)({}, CLASS.OPTIONS), options);
        }
        AbstractFindMath.OPTIONS = {};
        return AbstractFindMath;
    }());
    exports.AbstractFindMath = AbstractFindMath;
},
636: /* mathjax-full/js/util/string.js */ function _(require, module, exports, __esModule, __esExport) {
    var __read = (this && this.__read) || function (o, n) {
        var m = typeof Symbol === "function" && o[Symbol.iterator];
        if (!m)
            return o;
        var i = m.call(o), r, ar = [], e;
        try {
            while ((n === void 0 || n-- > 0) && !(r = i.next()).done)
                ar.push(r.value);
        }
        catch (error) {
            e = { error: error };
        }
        finally {
            try {
                if (r && !r.done && (m = i["return"]))
                    m.call(i);
            }
            finally {
                if (e)
                    throw e.error;
            }
        }
        return ar;
    };
    var __spreadArray = (this && this.__spreadArray) || function (to, from, pack) {
        if (pack || arguments.length === 2)
            for (var i = 0, l = from.length, ar; i < l; i++) {
                if (ar || !(i in from)) {
                    if (!ar)
                        ar = Array.prototype.slice.call(from, 0, i);
                    ar[i] = from[i];
                }
            }
        return to.concat(ar || Array.prototype.slice.call(from));
    };
    __esModule();
    function sortLength(a, b) {
        return a.length !== b.length ? b.length - a.length : a === b ? 0 : a < b ? -1 : 1;
    }
    exports.sortLength = sortLength;
    function quotePattern(text) {
        return text.replace(/([\^$(){}+*?\-|\[\]\:\\])/g, '\\$1');
    }
    exports.quotePattern = quotePattern;
    function unicodeChars(text) {
        return Array.from(text).map(function (c) { return c.codePointAt(0); });
    }
    exports.unicodeChars = unicodeChars;
    function unicodeString(data) {
        return String.fromCodePoint.apply(String, __spreadArray([], __read(data), false));
    }
    exports.unicodeString = unicodeString;
    function isPercent(x) {
        return !!x.match(/%\s*$/);
    }
    exports.isPercent = isPercent;
    function split(x) {
        return x.trim().split(/\s+/);
    }
    exports.split = split;
},
637: /* mathjax-full/js/core/MathItem.js */ function _(require, module, exports, __esModule, __esExport) {
    __esModule();
    function protoItem(open, math, close, n, start, end, display) {
        if (display === void 0) {
            display = null;
        }
        var item = { open: open, math: math, close: close,
            n: n, start: { n: start }, end: { n: end }, display: display };
        return item;
    }
    exports.protoItem = protoItem;
    var AbstractMathItem = (function () {
        function AbstractMathItem(math, jax, display, start, end) {
            if (display === void 0) {
                display = true;
            }
            if (start === void 0) {
                start = { i: 0, n: 0, delim: '' };
            }
            if (end === void 0) {
                end = { i: 0, n: 0, delim: '' };
            }
            this.root = null;
            this.typesetRoot = null;
            this.metrics = {};
            this.inputData = {};
            this.outputData = {};
            this._state = exports.STATE.UNPROCESSED;
            this.math = math;
            this.inputJax = jax;
            this.display = display;
            this.start = start;
            this.end = end;
            this.root = null;
            this.typesetRoot = null;
            this.metrics = {};
            this.inputData = {};
            this.outputData = {};
        }
        Object.defineProperty(AbstractMathItem.prototype, "isEscaped", {
            get: function () {
                return this.display === null;
            },
            enumerable: false,
            configurable: true
        });
        AbstractMathItem.prototype.render = function (document) {
            document.renderActions.renderMath(this, document);
        };
        AbstractMathItem.prototype.rerender = function (document, start) {
            if (start === void 0) {
                start = exports.STATE.RERENDER;
            }
            if (this.state() >= start) {
                this.state(start - 1);
            }
            document.renderActions.renderMath(this, document, start);
        };
        AbstractMathItem.prototype.convert = function (document, end) {
            if (end === void 0) {
                end = exports.STATE.LAST;
            }
            document.renderActions.renderConvert(this, document, end);
        };
        AbstractMathItem.prototype.compile = function (document) {
            if (this.state() < exports.STATE.COMPILED) {
                this.root = this.inputJax.compile(this, document);
                this.state(exports.STATE.COMPILED);
            }
        };
        AbstractMathItem.prototype.typeset = function (document) {
            if (this.state() < exports.STATE.TYPESET) {
                this.typesetRoot = document.outputJax[this.isEscaped ? 'escaped' : 'typeset'](this, document);
                this.state(exports.STATE.TYPESET);
            }
        };
        AbstractMathItem.prototype.updateDocument = function (_document) { };
        AbstractMathItem.prototype.removeFromDocument = function (_restore) {
            if (_restore === void 0) {
                _restore = false;
            }
        };
        AbstractMathItem.prototype.setMetrics = function (em, ex, cwidth, lwidth, scale) {
            this.metrics = {
                em: em, ex: ex,
                containerWidth: cwidth,
                lineWidth: lwidth,
                scale: scale
            };
        };
        AbstractMathItem.prototype.state = function (state, restore) {
            if (state === void 0) {
                state = null;
            }
            if (restore === void 0) {
                restore = false;
            }
            if (state != null) {
                if (state < exports.STATE.INSERTED && this._state >= exports.STATE.INSERTED) {
                    this.removeFromDocument(restore);
                }
                if (state < exports.STATE.TYPESET && this._state >= exports.STATE.TYPESET) {
                    this.outputData = {};
                }
                if (state < exports.STATE.COMPILED && this._state >= exports.STATE.COMPILED) {
                    this.inputData = {};
                }
                this._state = state;
            }
            return this._state;
        };
        AbstractMathItem.prototype.reset = function (restore) {
            if (restore === void 0) {
                restore = false;
            }
            this.state(exports.STATE.UNPROCESSED, restore);
        };
        return AbstractMathItem;
    }());
    exports.AbstractMathItem = AbstractMathItem;
    exports.STATE = {
        UNPROCESSED: 0,
        FINDMATH: 10,
        COMPILED: 20,
        CONVERT: 100,
        METRICS: 110,
        RERENDER: 125,
        TYPESET: 150,
        INSERTED: 200,
        LAST: 10000
    };
    function newState(name, state) {
        if (name in exports.STATE) {
            throw Error('State ' + name + ' already exists');
        }
        exports.STATE[name] = state;
    }
    exports.newState = newState;
},
638: /* mathjax-full/js/input/tex/FilterUtil.js */ function _(require, module, exports, __esModule, __esExport) {
    var __values = (this && this.__values) || function (o) {
        var s = typeof Symbol === "function" && Symbol.iterator, m = s && o[s], i = 0;
        if (m)
            return m.call(o);
        if (o && typeof o.length === "number")
            return {
                next: function () {
                    if (o && i >= o.length)
                        o = void 0;
                    return { value: o && o[i++], done: !o };
                }
            };
        throw new TypeError(s ? "Object is not iterable." : "Symbol.iterator is not defined.");
    };
    var __importDefault = (this && this.__importDefault) || function (mod) {
        return (mod && mod.__esModule) ? mod : { "default": mod };
    };
    __esModule();
    var MmlNode_js_1 = require(639) /* ../../core/MmlTree/MmlNode.js */;
    var NodeUtil_js_1 = __importDefault(require(642) /* ./NodeUtil.js */);
    var FilterUtil;
    (function (FilterUtil) {
        FilterUtil.cleanStretchy = function (arg) {
            var e_1, _a;
            var options = arg.data;
            try {
                for (var _b = __values(options.getList('fixStretchy')), _c = _b.next(); !_c.done; _c = _b.next()) {
                    var mo = _c.value;
                    if (NodeUtil_js_1.default.getProperty(mo, 'fixStretchy')) {
                        var symbol = NodeUtil_js_1.default.getForm(mo);
                        if (symbol && symbol[3] && symbol[3]['stretchy']) {
                            NodeUtil_js_1.default.setAttribute(mo, 'stretchy', false);
                        }
                        var parent_1 = mo.parent;
                        if (!NodeUtil_js_1.default.getTexClass(mo) && (!symbol || !symbol[2])) {
                            var texAtom = options.nodeFactory.create('node', 'TeXAtom', [mo]);
                            parent_1.replaceChild(texAtom, mo);
                            texAtom.inheritAttributesFrom(mo);
                        }
                        NodeUtil_js_1.default.removeProperties(mo, 'fixStretchy');
                    }
                }
            }
            catch (e_1_1) {
                e_1 = { error: e_1_1 };
            }
            finally {
                try {
                    if (_c && !_c.done && (_a = _b.return))
                        _a.call(_b);
                }
                finally {
                    if (e_1)
                        throw e_1.error;
                }
            }
        };
        FilterUtil.cleanAttributes = function (arg) {
            var node = arg.data.root;
            node.walkTree(function (mml, _d) {
                var e_2, _a;
                var attribs = mml.attributes;
                if (!attribs) {
                    return;
                }
                var keep = new Set((attribs.get('mjx-keep-attrs') || '').split(/ /));
                delete (attribs.getAllAttributes())['mjx-keep-attrs'];
                try {
                    for (var _b = __values(attribs.getExplicitNames()), _c = _b.next(); !_c.done; _c = _b.next()) {
                        var key = _c.value;
                        if (!keep.has(key) && attribs.attributes[key] === mml.attributes.getInherited(key)) {
                            delete attribs.attributes[key];
                        }
                    }
                }
                catch (e_2_1) {
                    e_2 = { error: e_2_1 };
                }
                finally {
                    try {
                        if (_c && !_c.done && (_a = _b.return))
                            _a.call(_b);
                    }
                    finally {
                        if (e_2)
                            throw e_2.error;
                    }
                }
            }, {});
        };
        FilterUtil.combineRelations = function (arg) {
            var e_3, _a, e_4, _b;
            var remove = [];
            try {
                for (var _c = __values(arg.data.getList('mo')), _e = _c.next(); !_e.done; _e = _c.next()) {
                    var mo = _e.value;
                    if (mo.getProperty('relationsCombined') || !mo.parent ||
                        (mo.parent && !NodeUtil_js_1.default.isType(mo.parent, 'mrow')) ||
                        NodeUtil_js_1.default.getTexClass(mo) !== MmlNode_js_1.TEXCLASS.REL) {
                        continue;
                    }
                    var mml = mo.parent;
                    var m2 = void 0;
                    var children = mml.childNodes;
                    var next = children.indexOf(mo) + 1;
                    var variantForm = NodeUtil_js_1.default.getProperty(mo, 'variantForm');
                    while (next < children.length && (m2 = children[next]) &&
                        NodeUtil_js_1.default.isType(m2, 'mo') &&
                        NodeUtil_js_1.default.getTexClass(m2) === MmlNode_js_1.TEXCLASS.REL) {
                        if (variantForm === NodeUtil_js_1.default.getProperty(m2, 'variantForm') &&
                            _compareExplicit(mo, m2)) {
                            NodeUtil_js_1.default.appendChildren(mo, NodeUtil_js_1.default.getChildren(m2));
                            _copyExplicit(['stretchy', 'rspace'], mo, m2);
                            try {
                                for (var _f = (e_4 = void 0, __values(m2.getPropertyNames())), _g = _f.next(); !_g.done; _g = _f.next()) {
                                    var name_1 = _g.value;
                                    mo.setProperty(name_1, m2.getProperty(name_1));
                                }
                            }
                            catch (e_4_1) {
                                e_4 = { error: e_4_1 };
                            }
                            finally {
                                try {
                                    if (_g && !_g.done && (_b = _f.return))
                                        _b.call(_f);
                                }
                                finally {
                                    if (e_4)
                                        throw e_4.error;
                                }
                            }
                            children.splice(next, 1);
                            remove.push(m2);
                            m2.parent = null;
                            m2.setProperty('relationsCombined', true);
                        }
                        else {
                            if (mo.attributes.getExplicit('rspace') == null) {
                                NodeUtil_js_1.default.setAttribute(mo, 'rspace', '0pt');
                            }
                            if (m2.attributes.getExplicit('lspace') == null) {
                                NodeUtil_js_1.default.setAttribute(m2, 'lspace', '0pt');
                            }
                            break;
                        }
                    }
                    mo.attributes.setInherited('form', mo.getForms()[0]);
                }
            }
            catch (e_3_1) {
                e_3 = { error: e_3_1 };
            }
            finally {
                try {
                    if (_e && !_e.done && (_a = _c.return))
                        _a.call(_c);
                }
                finally {
                    if (e_3)
                        throw e_3.error;
                }
            }
            arg.data.removeFromList('mo', remove);
        };
        var _copyExplicit = function (attrs, node1, node2) {
            var attr1 = node1.attributes;
            var attr2 = node2.attributes;
            attrs.forEach(function (x) {
                var attr = attr2.getExplicit(x);
                if (attr != null) {
                    attr1.set(x, attr);
                }
            });
        };
        var _compareExplicit = function (node1, node2) {
            var e_5, _a;
            var filter = function (attr, space) {
                var exp = attr.getExplicitNames();
                return exp.filter(function (x) {
                    return x !== space &&
                        (x !== 'stretchy' ||
                            attr.getExplicit('stretchy'));
                });
            };
            var attr1 = node1.attributes;
            var attr2 = node2.attributes;
            var exp1 = filter(attr1, 'lspace');
            var exp2 = filter(attr2, 'rspace');
            if (exp1.length !== exp2.length) {
                return false;
            }
            try {
                for (var exp1_1 = __values(exp1), exp1_1_1 = exp1_1.next(); !exp1_1_1.done; exp1_1_1 = exp1_1.next()) {
                    var name_2 = exp1_1_1.value;
                    if (attr1.getExplicit(name_2) !== attr2.getExplicit(name_2)) {
                        return false;
                    }
                }
            }
            catch (e_5_1) {
                e_5 = { error: e_5_1 };
            }
            finally {
                try {
                    if (exp1_1_1 && !exp1_1_1.done && (_a = exp1_1.return))
                        _a.call(exp1_1);
                }
                finally {
                    if (e_5)
                        throw e_5.error;
                }
            }
            return true;
        };
        var _cleanSubSup = function (options, low, up) {
            var e_6, _a;
            var remove = [];
            try {
                for (var _b = __values(options.getList('m' + low + up)), _c = _b.next(); !_c.done; _c = _b.next()) {
                    var mml = _c.value;
                    var children = mml.childNodes;
                    if (children[mml[low]] && children[mml[up]]) {
                        continue;
                    }
                    var parent_2 = mml.parent;
                    var newNode = (children[mml[low]] ?
                        options.nodeFactory.create('node', 'm' + low, [children[mml.base], children[mml[low]]]) :
                        options.nodeFactory.create('node', 'm' + up, [children[mml.base], children[mml[up]]]));
                    NodeUtil_js_1.default.copyAttributes(mml, newNode);
                    if (parent_2) {
                        parent_2.replaceChild(newNode, mml);
                    }
                    else {
                        options.root = newNode;
                    }
                    remove.push(mml);
                }
            }
            catch (e_6_1) {
                e_6 = { error: e_6_1 };
            }
            finally {
                try {
                    if (_c && !_c.done && (_a = _b.return))
                        _a.call(_b);
                }
                finally {
                    if (e_6)
                        throw e_6.error;
                }
            }
            options.removeFromList('m' + low + up, remove);
        };
        FilterUtil.cleanSubSup = function (arg) {
            var options = arg.data;
            if (options.error) {
                return;
            }
            _cleanSubSup(options, 'sub', 'sup');
            _cleanSubSup(options, 'under', 'over');
        };
        var _moveLimits = function (options, underover, subsup) {
            var e_7, _a;
            var remove = [];
            try {
                for (var _b = __values(options.getList(underover)), _c = _b.next(); !_c.done; _c = _b.next()) {
                    var mml = _c.value;
                    if (mml.attributes.get('displaystyle')) {
                        continue;
                    }
                    var base = mml.childNodes[mml.base];
                    var mo = base.coreMO();
                    if (base.getProperty('movablelimits') && !mo.attributes.getExplicit('movablelimits')) {
                        var node = options.nodeFactory.create('node', subsup, mml.childNodes);
                        NodeUtil_js_1.default.copyAttributes(mml, node);
                        if (mml.parent) {
                            mml.parent.replaceChild(node, mml);
                        }
                        else {
                            options.root = node;
                        }
                        remove.push(mml);
                    }
                }
            }
            catch (e_7_1) {
                e_7 = { error: e_7_1 };
            }
            finally {
                try {
                    if (_c && !_c.done && (_a = _b.return))
                        _a.call(_b);
                }
                finally {
                    if (e_7)
                        throw e_7.error;
                }
            }
            options.removeFromList(underover, remove);
        };
        FilterUtil.moveLimits = function (arg) {
            var options = arg.data;
            _moveLimits(options, 'munderover', 'msubsup');
            _moveLimits(options, 'munder', 'msub');
            _moveLimits(options, 'mover', 'msup');
        };
        FilterUtil.setInherited = function (arg) {
            arg.data.root.setInheritedAttributes({}, arg.math['display'], 0, false);
        };
    })(FilterUtil || (FilterUtil = {}));
    exports.default = FilterUtil;
},
639: /* mathjax-full/js/core/MmlTree/MmlNode.js */ function _(require, module, exports, __esModule, __esExport) {
    var __extends = (this && this.__extends) || (function () {
        var extendStatics = function (d, b) {
            extendStatics = Object.setPrototypeOf ||
                ({ __proto__: [] } instanceof Array && function (d, b) { d.__proto__ = b; }) ||
                function (d, b) { for (var p in b)
                    if (Object.prototype.hasOwnProperty.call(b, p))
                        d[p] = b[p]; };
            return extendStatics(d, b);
        };
        return function (d, b) {
            if (typeof b !== "function" && b !== null)
                throw new TypeError("Class extends value " + String(b) + " is not a constructor or null");
            extendStatics(d, b);
            function __() { this.constructor = d; }
            d.prototype = b === null ? Object.create(b) : (__.prototype = b.prototype, new __());
        };
    })();
    var __assign = (this && this.__assign) || function () {
        __assign = Object.assign || function (t) {
            for (var s, i = 1, n = arguments.length; i < n; i++) {
                s = arguments[i];
                for (var p in s)
                    if (Object.prototype.hasOwnProperty.call(s, p))
                        t[p] = s[p];
            }
            return t;
        };
        return __assign.apply(this, arguments);
    };
    var __values = (this && this.__values) || function (o) {
        var s = typeof Symbol === "function" && Symbol.iterator, m = s && o[s], i = 0;
        if (m)
            return m.call(o);
        if (o && typeof o.length === "number")
            return {
                next: function () {
                    if (o && i >= o.length)
                        o = void 0;
                    return { value: o && o[i++], done: !o };
                }
            };
        throw new TypeError(s ? "Object is not iterable." : "Symbol.iterator is not defined.");
    };
    var __read = (this && this.__read) || function (o, n) {
        var m = typeof Symbol === "function" && o[Symbol.iterator];
        if (!m)
            return o;
        var i = m.call(o), r, ar = [], e;
        try {
            while ((n === void 0 || n-- > 0) && !(r = i.next()).done)
                ar.push(r.value);
        }
        catch (error) {
            e = { error: error };
        }
        finally {
            try {
                if (r && !r.done && (m = i["return"]))
                    m.call(i);
            }
            finally {
                if (e)
                    throw e.error;
            }
        }
        return ar;
    };
    __esModule();
    var Attributes_js_1 = require(640) /* ./Attributes.js */;
    var Node_js_1 = require(641) /* ../Tree/Node.js */;
    exports.TEXCLASS = {
        ORD: 0,
        OP: 1,
        BIN: 2,
        REL: 3,
        OPEN: 4,
        CLOSE: 5,
        PUNCT: 6,
        INNER: 7,
        VCENTER: 8,
        NONE: -1
    };
    exports.TEXCLASSNAMES = ['ORD', 'OP', 'BIN', 'REL', 'OPEN', 'CLOSE', 'PUNCT', 'INNER', 'VCENTER'];
    var TEXSPACELENGTH = ['', 'thinmathspace', 'mediummathspace', 'thickmathspace'];
    var TEXSPACE = [
        [0, -1, 2, 3, 0, 0, 0, 1],
        [-1, -1, 0, 3, 0, 0, 0, 1],
        [2, 2, 0, 0, 2, 0, 0, 2],
        [3, 3, 0, 0, 3, 0, 0, 3],
        [0, 0, 0, 0, 0, 0, 0, 0],
        [0, -1, 2, 3, 0, 0, 0, 1],
        [1, 1, 0, 1, 1, 1, 1, 1],
        [1, -1, 2, 3, 1, 0, 1, 1]
    ];
    exports.indentAttributes = [
        'indentalign', 'indentalignfirst',
        'indentshift', 'indentshiftfirst'
    ];
    var AbstractMmlNode = (function (_super) {
        __extends(AbstractMmlNode, _super);
        function AbstractMmlNode(factory, attributes, children) {
            if (attributes === void 0) {
                attributes = {};
            }
            if (children === void 0) {
                children = [];
            }
            var _this = _super.call(this, factory) || this;
            _this.prevClass = null;
            _this.prevLevel = null;
            _this.texclass = null;
            if (_this.arity < 0) {
                _this.childNodes = [factory.create('inferredMrow')];
                _this.childNodes[0].parent = _this;
            }
            _this.setChildren(children);
            _this.attributes = new Attributes_js_1.Attributes(factory.getNodeClass(_this.kind).defaults, factory.getNodeClass('math').defaults);
            _this.attributes.setList(attributes);
            return _this;
        }
        AbstractMmlNode.prototype.copy = function (keepIds) {
            var e_1, _a, e_2, _b;
            if (keepIds === void 0) {
                keepIds = false;
            }
            var node = this.factory.create(this.kind);
            node.properties = __assign({}, this.properties);
            if (this.attributes) {
                var attributes = this.attributes.getAllAttributes();
                try {
                    for (var _c = __values(Object.keys(attributes)), _d = _c.next(); !_d.done; _d = _c.next()) {
                        var name_1 = _d.value;
                        if (name_1 !== 'id' || keepIds) {
                            node.attributes.set(name_1, attributes[name_1]);
                        }
                    }
                }
                catch (e_1_1) {
                    e_1 = { error: e_1_1 };
                }
                finally {
                    try {
                        if (_d && !_d.done && (_a = _c.return))
                            _a.call(_c);
                    }
                    finally {
                        if (e_1)
                            throw e_1.error;
                    }
                }
            }
            if (this.childNodes && this.childNodes.length) {
                var children = this.childNodes;
                if (children.length === 1 && children[0].isInferred) {
                    children = children[0].childNodes;
                }
                try {
                    for (var children_1 = __values(children), children_1_1 = children_1.next(); !children_1_1.done; children_1_1 = children_1.next()) {
                        var child = children_1_1.value;
                        if (child) {
                            node.appendChild(child.copy());
                        }
                        else {
                            node.childNodes.push(null);
                        }
                    }
                }
                catch (e_2_1) {
                    e_2 = { error: e_2_1 };
                }
                finally {
                    try {
                        if (children_1_1 && !children_1_1.done && (_b = children_1.return))
                            _b.call(children_1);
                    }
                    finally {
                        if (e_2)
                            throw e_2.error;
                    }
                }
            }
            return node;
        };
        Object.defineProperty(AbstractMmlNode.prototype, "texClass", {
            get: function () {
                return this.texclass;
            },
            set: function (texClass) {
                this.texclass = texClass;
            },
            enumerable: false,
            configurable: true
        });
        Object.defineProperty(AbstractMmlNode.prototype, "isToken", {
            get: function () {
                return false;
            },
            enumerable: false,
            configurable: true
        });
        Object.defineProperty(AbstractMmlNode.prototype, "isEmbellished", {
            get: function () {
                return false;
            },
            enumerable: false,
            configurable: true
        });
        Object.defineProperty(AbstractMmlNode.prototype, "isSpacelike", {
            get: function () {
                return false;
            },
            enumerable: false,
            configurable: true
        });
        Object.defineProperty(AbstractMmlNode.prototype, "linebreakContainer", {
            get: function () {
                return false;
            },
            enumerable: false,
            configurable: true
        });
        Object.defineProperty(AbstractMmlNode.prototype, "hasNewLine", {
            get: function () {
                return false;
            },
            enumerable: false,
            configurable: true
        });
        Object.defineProperty(AbstractMmlNode.prototype, "arity", {
            get: function () {
                return Infinity;
            },
            enumerable: false,
            configurable: true
        });
        Object.defineProperty(AbstractMmlNode.prototype, "isInferred", {
            get: function () {
                return false;
            },
            enumerable: false,
            configurable: true
        });
        Object.defineProperty(AbstractMmlNode.prototype, "Parent", {
            get: function () {
                var parent = this.parent;
                while (parent && parent.notParent) {
                    parent = parent.Parent;
                }
                return parent;
            },
            enumerable: false,
            configurable: true
        });
        Object.defineProperty(AbstractMmlNode.prototype, "notParent", {
            get: function () {
                return false;
            },
            enumerable: false,
            configurable: true
        });
        AbstractMmlNode.prototype.setChildren = function (children) {
            if (this.arity < 0) {
                return this.childNodes[0].setChildren(children);
            }
            return _super.prototype.setChildren.call(this, children);
        };
        AbstractMmlNode.prototype.appendChild = function (child) {
            var e_3, _a;
            var _this = this;
            if (this.arity < 0) {
                this.childNodes[0].appendChild(child);
                return child;
            }
            if (child.isInferred) {
                if (this.arity === Infinity) {
                    child.childNodes.forEach(function (node) { return _super.prototype.appendChild.call(_this, node); });
                    return child;
                }
                var original = child;
                child = this.factory.create('mrow');
                child.setChildren(original.childNodes);
                child.attributes = original.attributes;
                try {
                    for (var _b = __values(original.getPropertyNames()), _c = _b.next(); !_c.done; _c = _b.next()) {
                        var name_2 = _c.value;
                        child.setProperty(name_2, original.getProperty(name_2));
                    }
                }
                catch (e_3_1) {
                    e_3 = { error: e_3_1 };
                }
                finally {
                    try {
                        if (_c && !_c.done && (_a = _b.return))
                            _a.call(_b);
                    }
                    finally {
                        if (e_3)
                            throw e_3.error;
                    }
                }
            }
            return _super.prototype.appendChild.call(this, child);
        };
        AbstractMmlNode.prototype.replaceChild = function (newChild, oldChild) {
            if (this.arity < 0) {
                this.childNodes[0].replaceChild(newChild, oldChild);
                return newChild;
            }
            return _super.prototype.replaceChild.call(this, newChild, oldChild);
        };
        AbstractMmlNode.prototype.core = function () {
            return this;
        };
        AbstractMmlNode.prototype.coreMO = function () {
            return this;
        };
        AbstractMmlNode.prototype.coreIndex = function () {
            return 0;
        };
        AbstractMmlNode.prototype.childPosition = function () {
            var e_4, _a;
            var child = this;
            var parent = child.parent;
            while (parent && parent.notParent) {
                child = parent;
                parent = parent.parent;
            }
            if (parent) {
                var i = 0;
                try {
                    for (var _b = __values(parent.childNodes), _c = _b.next(); !_c.done; _c = _b.next()) {
                        var node = _c.value;
                        if (node === child) {
                            return i;
                        }
                        i++;
                    }
                }
                catch (e_4_1) {
                    e_4 = { error: e_4_1 };
                }
                finally {
                    try {
                        if (_c && !_c.done && (_a = _b.return))
                            _a.call(_b);
                    }
                    finally {
                        if (e_4)
                            throw e_4.error;
                    }
                }
            }
            return null;
        };
        AbstractMmlNode.prototype.setTeXclass = function (prev) {
            this.getPrevClass(prev);
            return (this.texClass != null ? this : prev);
        };
        AbstractMmlNode.prototype.updateTeXclass = function (core) {
            if (core) {
                this.prevClass = core.prevClass;
                this.prevLevel = core.prevLevel;
                core.prevClass = core.prevLevel = null;
                this.texClass = core.texClass;
            }
        };
        AbstractMmlNode.prototype.getPrevClass = function (prev) {
            if (prev) {
                this.prevClass = prev.texClass;
                this.prevLevel = prev.attributes.get('scriptlevel');
            }
        };
        AbstractMmlNode.prototype.texSpacing = function () {
            var prevClass = (this.prevClass != null ? this.prevClass : exports.TEXCLASS.NONE);
            var texClass = this.texClass || exports.TEXCLASS.ORD;
            if (prevClass === exports.TEXCLASS.NONE || texClass === exports.TEXCLASS.NONE) {
                return '';
            }
            if (prevClass === exports.TEXCLASS.VCENTER) {
                prevClass = exports.TEXCLASS.ORD;
            }
            if (texClass === exports.TEXCLASS.VCENTER) {
                texClass = exports.TEXCLASS.ORD;
            }
            var space = TEXSPACE[prevClass][texClass];
            if ((this.prevLevel > 0 || this.attributes.get('scriptlevel') > 0) && space >= 0) {
                return '';
            }
            return TEXSPACELENGTH[Math.abs(space)];
        };
        AbstractMmlNode.prototype.hasSpacingAttributes = function () {
            return this.isEmbellished && this.coreMO().hasSpacingAttributes();
        };
        AbstractMmlNode.prototype.setInheritedAttributes = function (attributes, display, level, prime) {
            var e_5, _a;
            if (attributes === void 0) {
                attributes = {};
            }
            if (display === void 0) {
                display = false;
            }
            if (level === void 0) {
                level = 0;
            }
            if (prime === void 0) {
                prime = false;
            }
            var defaults = this.attributes.getAllDefaults();
            try {
                for (var _b = __values(Object.keys(attributes)), _c = _b.next(); !_c.done; _c = _b.next()) {
                    var key = _c.value;
                    if (defaults.hasOwnProperty(key) || AbstractMmlNode.alwaysInherit.hasOwnProperty(key)) {
                        var _d = __read(attributes[key], 2), node = _d[0], value = _d[1];
                        var noinherit = (AbstractMmlNode.noInherit[node] || {})[this.kind] || {};
                        if (!noinherit[key]) {
                            this.attributes.setInherited(key, value);
                        }
                    }
                }
            }
            catch (e_5_1) {
                e_5 = { error: e_5_1 };
            }
            finally {
                try {
                    if (_c && !_c.done && (_a = _b.return))
                        _a.call(_b);
                }
                finally {
                    if (e_5)
                        throw e_5.error;
                }
            }
            var displaystyle = this.attributes.getExplicit('displaystyle');
            if (displaystyle === undefined) {
                this.attributes.setInherited('displaystyle', display);
            }
            var scriptlevel = this.attributes.getExplicit('scriptlevel');
            if (scriptlevel === undefined) {
                this.attributes.setInherited('scriptlevel', level);
            }
            if (prime) {
                this.setProperty('texprimestyle', prime);
            }
            var arity = this.arity;
            if (arity >= 0 && arity !== Infinity && ((arity === 1 && this.childNodes.length === 0) ||
                (arity !== 1 && this.childNodes.length !== arity))) {
                if (arity < this.childNodes.length) {
                    this.childNodes = this.childNodes.slice(0, arity);
                }
                else {
                    while (this.childNodes.length < arity) {
                        this.appendChild(this.factory.create('mrow'));
                    }
                }
            }
            this.setChildInheritedAttributes(attributes, display, level, prime);
        };
        AbstractMmlNode.prototype.setChildInheritedAttributes = function (attributes, display, level, prime) {
            var e_6, _a;
            try {
                for (var _b = __values(this.childNodes), _c = _b.next(); !_c.done; _c = _b.next()) {
                    var child = _c.value;
                    child.setInheritedAttributes(attributes, display, level, prime);
                }
            }
            catch (e_6_1) {
                e_6 = { error: e_6_1 };
            }
            finally {
                try {
                    if (_c && !_c.done && (_a = _b.return))
                        _a.call(_b);
                }
                finally {
                    if (e_6)
                        throw e_6.error;
                }
            }
        };
        AbstractMmlNode.prototype.addInheritedAttributes = function (current, attributes) {
            var e_7, _a;
            var updated = __assign({}, current);
            try {
                for (var _b = __values(Object.keys(attributes)), _c = _b.next(); !_c.done; _c = _b.next()) {
                    var name_3 = _c.value;
                    if (name_3 !== 'displaystyle' && name_3 !== 'scriptlevel' && name_3 !== 'style') {
                        updated[name_3] = [this.kind, attributes[name_3]];
                    }
                }
            }
            catch (e_7_1) {
                e_7 = { error: e_7_1 };
            }
            finally {
                try {
                    if (_c && !_c.done && (_a = _b.return))
                        _a.call(_b);
                }
                finally {
                    if (e_7)
                        throw e_7.error;
                }
            }
            return updated;
        };
        AbstractMmlNode.prototype.inheritAttributesFrom = function (node) {
            var attributes = node.attributes;
            var display = attributes.get('displaystyle');
            var scriptlevel = attributes.get('scriptlevel');
            var defaults = (!attributes.isSet('mathsize') ? {} : {
                mathsize: ['math', attributes.get('mathsize')]
            });
            var prime = node.getProperty('texprimestyle') || false;
            this.setInheritedAttributes(defaults, display, scriptlevel, prime);
        };
        AbstractMmlNode.prototype.verifyTree = function (options) {
            if (options === void 0) {
                options = null;
            }
            if (options === null) {
                return;
            }
            this.verifyAttributes(options);
            var arity = this.arity;
            if (options['checkArity']) {
                if (arity >= 0 && arity !== Infinity &&
                    ((arity === 1 && this.childNodes.length === 0) ||
                        (arity !== 1 && this.childNodes.length !== arity))) {
                    this.mError('Wrong number of children for "' + this.kind + '" node', options, true);
                }
            }
            this.verifyChildren(options);
        };
        AbstractMmlNode.prototype.verifyAttributes = function (options) {
            var e_8, _a;
            if (options['checkAttributes']) {
                var attributes = this.attributes;
                var bad = [];
                try {
                    for (var _b = __values(attributes.getExplicitNames()), _c = _b.next(); !_c.done; _c = _b.next()) {
                        var name_4 = _c.value;
                        if (name_4.substr(0, 5) !== 'data-' && attributes.getDefault(name_4) === undefined &&
                            !name_4.match(/^(?:class|style|id|(?:xlink:)?href)$/)) {
                            bad.push(name_4);
                        }
                    }
                }
                catch (e_8_1) {
                    e_8 = { error: e_8_1 };
                }
                finally {
                    try {
                        if (_c && !_c.done && (_a = _b.return))
                            _a.call(_b);
                    }
                    finally {
                        if (e_8)
                            throw e_8.error;
                    }
                }
                if (bad.length) {
                    this.mError('Unknown attributes for ' + this.kind + ' node: ' + bad.join(', '), options);
                }
            }
        };
        AbstractMmlNode.prototype.verifyChildren = function (options) {
            var e_9, _a;
            try {
                for (var _b = __values(this.childNodes), _c = _b.next(); !_c.done; _c = _b.next()) {
                    var child = _c.value;
                    child.verifyTree(options);
                }
            }
            catch (e_9_1) {
                e_9 = { error: e_9_1 };
            }
            finally {
                try {
                    if (_c && !_c.done && (_a = _b.return))
                        _a.call(_b);
                }
                finally {
                    if (e_9)
                        throw e_9.error;
                }
            }
        };
        AbstractMmlNode.prototype.mError = function (message, options, short) {
            if (short === void 0) {
                short = false;
            }
            if (this.parent && this.parent.isKind('merror')) {
                return null;
            }
            var merror = this.factory.create('merror');
            merror.attributes.set('data-mjx-message', message);
            if (options['fullErrors'] || short) {
                var mtext = this.factory.create('mtext');
                var text = this.factory.create('text');
                text.setText(options['fullErrors'] ? message : this.kind);
                mtext.appendChild(text);
                merror.appendChild(mtext);
                this.parent.replaceChild(merror, this);
            }
            else {
                this.parent.replaceChild(merror, this);
                merror.appendChild(this);
            }
            return merror;
        };
        AbstractMmlNode.defaults = {
            mathbackground: Attributes_js_1.INHERIT,
            mathcolor: Attributes_js_1.INHERIT,
            mathsize: Attributes_js_1.INHERIT,
            dir: Attributes_js_1.INHERIT
        };
        AbstractMmlNode.noInherit = {
            mstyle: {
                mpadded: { width: true, height: true, depth: true, lspace: true, voffset: true },
                mtable: { width: true, height: true, depth: true, align: true }
            },
            maligngroup: {
                mrow: { groupalign: true },
                mtable: { groupalign: true }
            }
        };
        AbstractMmlNode.alwaysInherit = {
            scriptminsize: true,
            scriptsizemultiplier: true
        };
        AbstractMmlNode.verifyDefaults = {
            checkArity: true,
            checkAttributes: false,
            fullErrors: false,
            fixMmultiscripts: true,
            fixMtables: true
        };
        return AbstractMmlNode;
    }(Node_js_1.AbstractNode));
    exports.AbstractMmlNode = AbstractMmlNode;
    var AbstractMmlTokenNode = (function (_super) {
        __extends(AbstractMmlTokenNode, _super);
        function AbstractMmlTokenNode() {
            return _super !== null && _super.apply(this, arguments) || this;
        }
        Object.defineProperty(AbstractMmlTokenNode.prototype, "isToken", {
            get: function () {
                return true;
            },
            enumerable: false,
            configurable: true
        });
        AbstractMmlTokenNode.prototype.getText = function () {
            var e_10, _a;
            var text = '';
            try {
                for (var _b = __values(this.childNodes), _c = _b.next(); !_c.done; _c = _b.next()) {
                    var child = _c.value;
                    if (child instanceof TextNode) {
                        text += child.getText();
                    }
                }
            }
            catch (e_10_1) {
                e_10 = { error: e_10_1 };
            }
            finally {
                try {
                    if (_c && !_c.done && (_a = _b.return))
                        _a.call(_b);
                }
                finally {
                    if (e_10)
                        throw e_10.error;
                }
            }
            return text;
        };
        AbstractMmlTokenNode.prototype.setChildInheritedAttributes = function (attributes, display, level, prime) {
            var e_11, _a;
            try {
                for (var _b = __values(this.childNodes), _c = _b.next(); !_c.done; _c = _b.next()) {
                    var child = _c.value;
                    if (child instanceof AbstractMmlNode) {
                        child.setInheritedAttributes(attributes, display, level, prime);
                    }
                }
            }
            catch (e_11_1) {
                e_11 = { error: e_11_1 };
            }
            finally {
                try {
                    if (_c && !_c.done && (_a = _b.return))
                        _a.call(_b);
                }
                finally {
                    if (e_11)
                        throw e_11.error;
                }
            }
        };
        AbstractMmlTokenNode.prototype.walkTree = function (func, data) {
            var e_12, _a;
            func(this, data);
            try {
                for (var _b = __values(this.childNodes), _c = _b.next(); !_c.done; _c = _b.next()) {
                    var child = _c.value;
                    if (child instanceof AbstractMmlNode) {
                        child.walkTree(func, data);
                    }
                }
            }
            catch (e_12_1) {
                e_12 = { error: e_12_1 };
            }
            finally {
                try {
                    if (_c && !_c.done && (_a = _b.return))
                        _a.call(_b);
                }
                finally {
                    if (e_12)
                        throw e_12.error;
                }
            }
            return data;
        };
        AbstractMmlTokenNode.defaults = __assign(__assign({}, AbstractMmlNode.defaults), { mathvariant: 'normal', mathsize: Attributes_js_1.INHERIT });
        return AbstractMmlTokenNode;
    }(AbstractMmlNode));
    exports.AbstractMmlTokenNode = AbstractMmlTokenNode;
    var AbstractMmlLayoutNode = (function (_super) {
        __extends(AbstractMmlLayoutNode, _super);
        function AbstractMmlLayoutNode() {
            return _super !== null && _super.apply(this, arguments) || this;
        }
        Object.defineProperty(AbstractMmlLayoutNode.prototype, "isSpacelike", {
            get: function () {
                return this.childNodes[0].isSpacelike;
            },
            enumerable: false,
            configurable: true
        });
        Object.defineProperty(AbstractMmlLayoutNode.prototype, "isEmbellished", {
            get: function () {
                return this.childNodes[0].isEmbellished;
            },
            enumerable: false,
            configurable: true
        });
        Object.defineProperty(AbstractMmlLayoutNode.prototype, "arity", {
            get: function () {
                return -1;
            },
            enumerable: false,
            configurable: true
        });
        AbstractMmlLayoutNode.prototype.core = function () {
            return this.childNodes[0];
        };
        AbstractMmlLayoutNode.prototype.coreMO = function () {
            return this.childNodes[0].coreMO();
        };
        AbstractMmlLayoutNode.prototype.setTeXclass = function (prev) {
            prev = this.childNodes[0].setTeXclass(prev);
            this.updateTeXclass(this.childNodes[0]);
            return prev;
        };
        AbstractMmlLayoutNode.defaults = AbstractMmlNode.defaults;
        return AbstractMmlLayoutNode;
    }(AbstractMmlNode));
    exports.AbstractMmlLayoutNode = AbstractMmlLayoutNode;
    var AbstractMmlBaseNode = (function (_super) {
        __extends(AbstractMmlBaseNode, _super);
        function AbstractMmlBaseNode() {
            return _super !== null && _super.apply(this, arguments) || this;
        }
        Object.defineProperty(AbstractMmlBaseNode.prototype, "isEmbellished", {
            get: function () {
                return this.childNodes[0].isEmbellished;
            },
            enumerable: false,
            configurable: true
        });
        AbstractMmlBaseNode.prototype.core = function () {
            return this.childNodes[0];
        };
        AbstractMmlBaseNode.prototype.coreMO = function () {
            return this.childNodes[0].coreMO();
        };
        AbstractMmlBaseNode.prototype.setTeXclass = function (prev) {
            var e_13, _a;
            this.getPrevClass(prev);
            this.texClass = exports.TEXCLASS.ORD;
            var base = this.childNodes[0];
            if (base) {
                if (this.isEmbellished || base.isKind('mi')) {
                    prev = base.setTeXclass(prev);
                    this.updateTeXclass(this.core());
                }
                else {
                    base.setTeXclass(null);
                    prev = this;
                }
            }
            else {
                prev = this;
            }
            try {
                for (var _b = __values(this.childNodes.slice(1)), _c = _b.next(); !_c.done; _c = _b.next()) {
                    var child = _c.value;
                    if (child) {
                        child.setTeXclass(null);
                    }
                }
            }
            catch (e_13_1) {
                e_13 = { error: e_13_1 };
            }
            finally {
                try {
                    if (_c && !_c.done && (_a = _b.return))
                        _a.call(_b);
                }
                finally {
                    if (e_13)
                        throw e_13.error;
                }
            }
            return prev;
        };
        AbstractMmlBaseNode.defaults = AbstractMmlNode.defaults;
        return AbstractMmlBaseNode;
    }(AbstractMmlNode));
    exports.AbstractMmlBaseNode = AbstractMmlBaseNode;
    var AbstractMmlEmptyNode = (function (_super) {
        __extends(AbstractMmlEmptyNode, _super);
        function AbstractMmlEmptyNode() {
            return _super !== null && _super.apply(this, arguments) || this;
        }
        Object.defineProperty(AbstractMmlEmptyNode.prototype, "isToken", {
            get: function () {
                return false;
            },
            enumerable: false,
            configurable: true
        });
        Object.defineProperty(AbstractMmlEmptyNode.prototype, "isEmbellished", {
            get: function () {
                return false;
            },
            enumerable: false,
            configurable: true
        });
        Object.defineProperty(AbstractMmlEmptyNode.prototype, "isSpacelike", {
            get: function () {
                return false;
            },
            enumerable: false,
            configurable: true
        });
        Object.defineProperty(AbstractMmlEmptyNode.prototype, "linebreakContainer", {
            get: function () {
                return false;
            },
            enumerable: false,
            configurable: true
        });
        Object.defineProperty(AbstractMmlEmptyNode.prototype, "hasNewLine", {
            get: function () {
                return false;
            },
            enumerable: false,
            configurable: true
        });
        Object.defineProperty(AbstractMmlEmptyNode.prototype, "arity", {
            get: function () {
                return 0;
            },
            enumerable: false,
            configurable: true
        });
        Object.defineProperty(AbstractMmlEmptyNode.prototype, "isInferred", {
            get: function () {
                return false;
            },
            enumerable: false,
            configurable: true
        });
        Object.defineProperty(AbstractMmlEmptyNode.prototype, "notParent", {
            get: function () {
                return false;
            },
            enumerable: false,
            configurable: true
        });
        Object.defineProperty(AbstractMmlEmptyNode.prototype, "Parent", {
            get: function () {
                return this.parent;
            },
            enumerable: false,
            configurable: true
        });
        Object.defineProperty(AbstractMmlEmptyNode.prototype, "texClass", {
            get: function () {
                return exports.TEXCLASS.NONE;
            },
            enumerable: false,
            configurable: true
        });
        Object.defineProperty(AbstractMmlEmptyNode.prototype, "prevClass", {
            get: function () {
                return exports.TEXCLASS.NONE;
            },
            enumerable: false,
            configurable: true
        });
        Object.defineProperty(AbstractMmlEmptyNode.prototype, "prevLevel", {
            get: function () {
                return 0;
            },
            enumerable: false,
            configurable: true
        });
        AbstractMmlEmptyNode.prototype.hasSpacingAttributes = function () {
            return false;
        };
        Object.defineProperty(AbstractMmlEmptyNode.prototype, "attributes", {
            get: function () {
                return null;
            },
            enumerable: false,
            configurable: true
        });
        AbstractMmlEmptyNode.prototype.core = function () {
            return this;
        };
        AbstractMmlEmptyNode.prototype.coreMO = function () {
            return this;
        };
        AbstractMmlEmptyNode.prototype.coreIndex = function () {
            return 0;
        };
        AbstractMmlEmptyNode.prototype.childPosition = function () {
            return 0;
        };
        AbstractMmlEmptyNode.prototype.setTeXclass = function (prev) {
            return prev;
        };
        AbstractMmlEmptyNode.prototype.texSpacing = function () {
            return '';
        };
        AbstractMmlEmptyNode.prototype.setInheritedAttributes = function (_attributes, _display, _level, _prime) { };
        AbstractMmlEmptyNode.prototype.inheritAttributesFrom = function (_node) { };
        AbstractMmlEmptyNode.prototype.verifyTree = function (_options) { };
        AbstractMmlEmptyNode.prototype.mError = function (_message, _options, _short) {
            if (_short === void 0) {
                _short = false;
            }
            return null;
        };
        return AbstractMmlEmptyNode;
    }(Node_js_1.AbstractEmptyNode));
    exports.AbstractMmlEmptyNode = AbstractMmlEmptyNode;
    var TextNode = (function (_super) {
        __extends(TextNode, _super);
        function TextNode() {
            var _this = _super !== null && _super.apply(this, arguments) || this;
            _this.text = '';
            return _this;
        }
        Object.defineProperty(TextNode.prototype, "kind", {
            get: function () {
                return 'text';
            },
            enumerable: false,
            configurable: true
        });
        TextNode.prototype.getText = function () {
            return this.text;
        };
        TextNode.prototype.setText = function (text) {
            this.text = text;
            return this;
        };
        TextNode.prototype.copy = function () {
            return this.factory.create(this.kind).setText(this.getText());
        };
        TextNode.prototype.toString = function () {
            return this.text;
        };
        return TextNode;
    }(AbstractMmlEmptyNode));
    exports.TextNode = TextNode;
    var XMLNode = (function (_super) {
        __extends(XMLNode, _super);
        function XMLNode() {
            var _this = _super !== null && _super.apply(this, arguments) || this;
            _this.xml = null;
            _this.adaptor = null;
            return _this;
        }
        Object.defineProperty(XMLNode.prototype, "kind", {
            get: function () {
                return 'XML';
            },
            enumerable: false,
            configurable: true
        });
        XMLNode.prototype.getXML = function () {
            return this.xml;
        };
        XMLNode.prototype.setXML = function (xml, adaptor) {
            if (adaptor === void 0) {
                adaptor = null;
            }
            this.xml = xml;
            this.adaptor = adaptor;
            return this;
        };
        XMLNode.prototype.getSerializedXML = function () {
            return this.adaptor.serializeXML(this.xml);
        };
        XMLNode.prototype.copy = function () {
            return this.factory.create(this.kind).setXML(this.adaptor.clone(this.xml));
        };
        XMLNode.prototype.toString = function () {
            return 'XML data';
        };
        return XMLNode;
    }(AbstractMmlEmptyNode));
    exports.XMLNode = XMLNode;
},
640: /* mathjax-full/js/core/MmlTree/Attributes.js */ function _(require, module, exports, __esModule, __esExport) {
    var __values = (this && this.__values) || function (o) {
        var s = typeof Symbol === "function" && Symbol.iterator, m = s && o[s], i = 0;
        if (m)
            return m.call(o);
        if (o && typeof o.length === "number")
            return {
                next: function () {
                    if (o && i >= o.length)
                        o = void 0;
                    return { value: o && o[i++], done: !o };
                }
            };
        throw new TypeError(s ? "Object is not iterable." : "Symbol.iterator is not defined.");
    };
    __esModule();
    exports.INHERIT = '_inherit_';
    var Attributes = (function () {
        function Attributes(defaults, global) {
            this.global = global;
            this.defaults = Object.create(global);
            this.inherited = Object.create(this.defaults);
            this.attributes = Object.create(this.inherited);
            Object.assign(this.defaults, defaults);
        }
        Attributes.prototype.set = function (name, value) {
            this.attributes[name] = value;
        };
        Attributes.prototype.setList = function (list) {
            Object.assign(this.attributes, list);
        };
        Attributes.prototype.get = function (name) {
            var value = this.attributes[name];
            if (value === exports.INHERIT) {
                value = this.global[name];
            }
            return value;
        };
        Attributes.prototype.getExplicit = function (name) {
            if (!this.attributes.hasOwnProperty(name)) {
                return undefined;
            }
            return this.attributes[name];
        };
        Attributes.prototype.getList = function () {
            var e_1, _a;
            var names = [];
            for (var _i = 0; _i < arguments.length; _i++) {
                names[_i] = arguments[_i];
            }
            var values = {};
            try {
                for (var names_1 = __values(names), names_1_1 = names_1.next(); !names_1_1.done; names_1_1 = names_1.next()) {
                    var name_1 = names_1_1.value;
                    values[name_1] = this.get(name_1);
                }
            }
            catch (e_1_1) {
                e_1 = { error: e_1_1 };
            }
            finally {
                try {
                    if (names_1_1 && !names_1_1.done && (_a = names_1.return))
                        _a.call(names_1);
                }
                finally {
                    if (e_1)
                        throw e_1.error;
                }
            }
            return values;
        };
        Attributes.prototype.setInherited = function (name, value) {
            this.inherited[name] = value;
        };
        Attributes.prototype.getInherited = function (name) {
            return this.inherited[name];
        };
        Attributes.prototype.getDefault = function (name) {
            return this.defaults[name];
        };
        Attributes.prototype.isSet = function (name) {
            return this.attributes.hasOwnProperty(name) || this.inherited.hasOwnProperty(name);
        };
        Attributes.prototype.hasDefault = function (name) {
            return (name in this.defaults);
        };
        Attributes.prototype.getExplicitNames = function () {
            return Object.keys(this.attributes);
        };
        Attributes.prototype.getInheritedNames = function () {
            return Object.keys(this.inherited);
        };
        Attributes.prototype.getDefaultNames = function () {
            return Object.keys(this.defaults);
        };
        Attributes.prototype.getGlobalNames = function () {
            return Object.keys(this.global);
        };
        Attributes.prototype.getAllAttributes = function () {
            return this.attributes;
        };
        Attributes.prototype.getAllInherited = function () {
            return this.inherited;
        };
        Attributes.prototype.getAllDefaults = function () {
            return this.defaults;
        };
        Attributes.prototype.getAllGlobals = function () {
            return this.global;
        };
        return Attributes;
    }());
    exports.Attributes = Attributes;
},
641: /* mathjax-full/js/core/Tree/Node.js */ function _(require, module, exports, __esModule, __esExport) {
    var __extends = (this && this.__extends) || (function () {
        var extendStatics = function (d, b) {
            extendStatics = Object.setPrototypeOf ||
                ({ __proto__: [] } instanceof Array && function (d, b) { d.__proto__ = b; }) ||
                function (d, b) { for (var p in b)
                    if (Object.prototype.hasOwnProperty.call(b, p))
                        d[p] = b[p]; };
            return extendStatics(d, b);
        };
        return function (d, b) {
            if (typeof b !== "function" && b !== null)
                throw new TypeError("Class extends value " + String(b) + " is not a constructor or null");
            extendStatics(d, b);
            function __() { this.constructor = d; }
            d.prototype = b === null ? Object.create(b) : (__.prototype = b.prototype, new __());
        };
    })();
    var __assign = (this && this.__assign) || function () {
        __assign = Object.assign || function (t) {
            for (var s, i = 1, n = arguments.length; i < n; i++) {
                s = arguments[i];
                for (var p in s)
                    if (Object.prototype.hasOwnProperty.call(s, p))
                        t[p] = s[p];
            }
            return t;
        };
        return __assign.apply(this, arguments);
    };
    var __values = (this && this.__values) || function (o) {
        var s = typeof Symbol === "function" && Symbol.iterator, m = s && o[s], i = 0;
        if (m)
            return m.call(o);
        if (o && typeof o.length === "number")
            return {
                next: function () {
                    if (o && i >= o.length)
                        o = void 0;
                    return { value: o && o[i++], done: !o };
                }
            };
        throw new TypeError(s ? "Object is not iterable." : "Symbol.iterator is not defined.");
    };
    __esModule();
    var AbstractNode = (function () {
        function AbstractNode(factory, properties, children) {
            var e_1, _a;
            if (properties === void 0) {
                properties = {};
            }
            if (children === void 0) {
                children = [];
            }
            this.factory = factory;
            this.parent = null;
            this.properties = {};
            this.childNodes = [];
            try {
                for (var _b = __values(Object.keys(properties)), _c = _b.next(); !_c.done; _c = _b.next()) {
                    var name_1 = _c.value;
                    this.setProperty(name_1, properties[name_1]);
                }
            }
            catch (e_1_1) {
                e_1 = { error: e_1_1 };
            }
            finally {
                try {
                    if (_c && !_c.done && (_a = _b.return))
                        _a.call(_b);
                }
                finally {
                    if (e_1)
                        throw e_1.error;
                }
            }
            if (children.length) {
                this.setChildren(children);
            }
        }
        Object.defineProperty(AbstractNode.prototype, "kind", {
            get: function () {
                return 'unknown';
            },
            enumerable: false,
            configurable: true
        });
        AbstractNode.prototype.setProperty = function (name, value) {
            this.properties[name] = value;
        };
        AbstractNode.prototype.getProperty = function (name) {
            return this.properties[name];
        };
        AbstractNode.prototype.getPropertyNames = function () {
            return Object.keys(this.properties);
        };
        AbstractNode.prototype.getAllProperties = function () {
            return this.properties;
        };
        AbstractNode.prototype.removeProperty = function () {
            var e_2, _a;
            var names = [];
            for (var _i = 0; _i < arguments.length; _i++) {
                names[_i] = arguments[_i];
            }
            try {
                for (var names_1 = __values(names), names_1_1 = names_1.next(); !names_1_1.done; names_1_1 = names_1.next()) {
                    var name_2 = names_1_1.value;
                    delete this.properties[name_2];
                }
            }
            catch (e_2_1) {
                e_2 = { error: e_2_1 };
            }
            finally {
                try {
                    if (names_1_1 && !names_1_1.done && (_a = names_1.return))
                        _a.call(names_1);
                }
                finally {
                    if (e_2)
                        throw e_2.error;
                }
            }
        };
        AbstractNode.prototype.isKind = function (kind) {
            return this.factory.nodeIsKind(this, kind);
        };
        AbstractNode.prototype.setChildren = function (children) {
            var e_3, _a;
            this.childNodes = [];
            try {
                for (var children_1 = __values(children), children_1_1 = children_1.next(); !children_1_1.done; children_1_1 = children_1.next()) {
                    var child = children_1_1.value;
                    this.appendChild(child);
                }
            }
            catch (e_3_1) {
                e_3 = { error: e_3_1 };
            }
            finally {
                try {
                    if (children_1_1 && !children_1_1.done && (_a = children_1.return))
                        _a.call(children_1);
                }
                finally {
                    if (e_3)
                        throw e_3.error;
                }
            }
        };
        AbstractNode.prototype.appendChild = function (child) {
            this.childNodes.push(child);
            child.parent = this;
            return child;
        };
        AbstractNode.prototype.replaceChild = function (newChild, oldChild) {
            var i = this.childIndex(oldChild);
            if (i !== null) {
                this.childNodes[i] = newChild;
                newChild.parent = this;
                oldChild.parent = null;
            }
            return newChild;
        };
        AbstractNode.prototype.removeChild = function (child) {
            var i = this.childIndex(child);
            if (i !== null) {
                this.childNodes.splice(i, 1);
                child.parent = null;
            }
            return child;
        };
        AbstractNode.prototype.childIndex = function (node) {
            var i = this.childNodes.indexOf(node);
            return (i === -1 ? null : i);
        };
        AbstractNode.prototype.copy = function () {
            var e_4, _a;
            var node = this.factory.create(this.kind);
            node.properties = __assign({}, this.properties);
            try {
                for (var _b = __values(this.childNodes || []), _c = _b.next(); !_c.done; _c = _b.next()) {
                    var child = _c.value;
                    if (child) {
                        node.appendChild(child.copy());
                    }
                }
            }
            catch (e_4_1) {
                e_4 = { error: e_4_1 };
            }
            finally {
                try {
                    if (_c && !_c.done && (_a = _b.return))
                        _a.call(_b);
                }
                finally {
                    if (e_4)
                        throw e_4.error;
                }
            }
            return node;
        };
        AbstractNode.prototype.findNodes = function (kind) {
            var nodes = [];
            this.walkTree(function (node) {
                if (node.isKind(kind)) {
                    nodes.push(node);
                }
            });
            return nodes;
        };
        AbstractNode.prototype.walkTree = function (func, data) {
            var e_5, _a;
            func(this, data);
            try {
                for (var _b = __values(this.childNodes), _c = _b.next(); !_c.done; _c = _b.next()) {
                    var child = _c.value;
                    if (child) {
                        child.walkTree(func, data);
                    }
                }
            }
            catch (e_5_1) {
                e_5 = { error: e_5_1 };
            }
            finally {
                try {
                    if (_c && !_c.done && (_a = _b.return))
                        _a.call(_b);
                }
                finally {
                    if (e_5)
                        throw e_5.error;
                }
            }
            return data;
        };
        AbstractNode.prototype.toString = function () {
            return this.kind + '(' + this.childNodes.join(',') + ')';
        };
        return AbstractNode;
    }());
    exports.AbstractNode = AbstractNode;
    var AbstractEmptyNode = (function (_super) {
        __extends(AbstractEmptyNode, _super);
        function AbstractEmptyNode() {
            return _super !== null && _super.apply(this, arguments) || this;
        }
        AbstractEmptyNode.prototype.setChildren = function (_children) {
        };
        AbstractEmptyNode.prototype.appendChild = function (child) {
            return child;
        };
        AbstractEmptyNode.prototype.replaceChild = function (_newChild, oldChild) {
            return oldChild;
        };
        AbstractEmptyNode.prototype.childIndex = function (_node) {
            return null;
        };
        AbstractEmptyNode.prototype.walkTree = function (func, data) {
            func(this, data);
            return data;
        };
        AbstractEmptyNode.prototype.toString = function () {
            return this.kind;
        };
        return AbstractEmptyNode;
    }(AbstractNode));
    exports.AbstractEmptyNode = AbstractEmptyNode;
},
642: /* mathjax-full/js/input/tex/NodeUtil.js */ function _(require, module, exports, __esModule, __esExport) {
    var __values = (this && this.__values) || function (o) {
        var s = typeof Symbol === "function" && Symbol.iterator, m = s && o[s], i = 0;
        if (m)
            return m.call(o);
        if (o && typeof o.length === "number")
            return {
                next: function () {
                    if (o && i >= o.length)
                        o = void 0;
                    return { value: o && o[i++], done: !o };
                }
            };
        throw new TypeError(s ? "Object is not iterable." : "Symbol.iterator is not defined.");
    };
    var __read = (this && this.__read) || function (o, n) {
        var m = typeof Symbol === "function" && o[Symbol.iterator];
        if (!m)
            return o;
        var i = m.call(o), r, ar = [], e;
        try {
            while ((n === void 0 || n-- > 0) && !(r = i.next()).done)
                ar.push(r.value);
        }
        catch (error) {
            e = { error: error };
        }
        finally {
            try {
                if (r && !r.done && (m = i["return"]))
                    m.call(i);
            }
            finally {
                if (e)
                    throw e.error;
            }
        }
        return ar;
    };
    var __spreadArray = (this && this.__spreadArray) || function (to, from, pack) {
        if (pack || arguments.length === 2)
            for (var i = 0, l = from.length, ar; i < l; i++) {
                if (ar || !(i in from)) {
                    if (!ar)
                        ar = Array.prototype.slice.call(from, 0, i);
                    ar[i] = from[i];
                }
            }
        return to.concat(ar || Array.prototype.slice.call(from));
    };
    __esModule();
    var MmlNode_js_1 = require(639) /* ../../core/MmlTree/MmlNode.js */;
    var mo_js_1 = require(643) /* ../../core/MmlTree/MmlNodes/mo.js */;
    var NodeUtil;
    (function (NodeUtil) {
        var attrs = new Map([
            ['autoOP', true],
            ['fnOP', true],
            ['movesupsub', true],
            ['subsupOK', true],
            ['texprimestyle', true],
            ['useHeight', true],
            ['variantForm', true],
            ['withDelims', true],
            ['mathaccent', true],
            ['open', true],
            ['close', true]
        ]);
        function createEntity(code) {
            return String.fromCodePoint(parseInt(code, 16));
        }
        NodeUtil.createEntity = createEntity;
        function getChildren(node) {
            return node.childNodes;
        }
        NodeUtil.getChildren = getChildren;
        function getText(node) {
            return node.getText();
        }
        NodeUtil.getText = getText;
        function appendChildren(node, children) {
            var e_1, _a;
            try {
                for (var children_1 = __values(children), children_1_1 = children_1.next(); !children_1_1.done; children_1_1 = children_1.next()) {
                    var child = children_1_1.value;
                    node.appendChild(child);
                }
            }
            catch (e_1_1) {
                e_1 = { error: e_1_1 };
            }
            finally {
                try {
                    if (children_1_1 && !children_1_1.done && (_a = children_1.return))
                        _a.call(children_1);
                }
                finally {
                    if (e_1)
                        throw e_1.error;
                }
            }
        }
        NodeUtil.appendChildren = appendChildren;
        function setAttribute(node, attribute, value) {
            node.attributes.set(attribute, value);
        }
        NodeUtil.setAttribute = setAttribute;
        function setProperty(node, property, value) {
            node.setProperty(property, value);
        }
        NodeUtil.setProperty = setProperty;
        function setProperties(node, properties) {
            var e_2, _a;
            try {
                for (var _b = __values(Object.keys(properties)), _c = _b.next(); !_c.done; _c = _b.next()) {
                    var name_1 = _c.value;
                    var value = properties[name_1];
                    if (name_1 === 'texClass') {
                        node.texClass = value;
                        node.setProperty(name_1, value);
                    }
                    else if (name_1 === 'movablelimits') {
                        node.setProperty('movablelimits', value);
                        if (node.isKind('mo') || node.isKind('mstyle')) {
                            node.attributes.set('movablelimits', value);
                        }
                    }
                    else if (name_1 === 'inferred') {
                    }
                    else if (attrs.has(name_1)) {
                        node.setProperty(name_1, value);
                    }
                    else {
                        node.attributes.set(name_1, value);
                    }
                }
            }
            catch (e_2_1) {
                e_2 = { error: e_2_1 };
            }
            finally {
                try {
                    if (_c && !_c.done && (_a = _b.return))
                        _a.call(_b);
                }
                finally {
                    if (e_2)
                        throw e_2.error;
                }
            }
        }
        NodeUtil.setProperties = setProperties;
        function getProperty(node, property) {
            return node.getProperty(property);
        }
        NodeUtil.getProperty = getProperty;
        function getAttribute(node, attr) {
            return node.attributes.get(attr);
        }
        NodeUtil.getAttribute = getAttribute;
        function removeProperties(node) {
            var properties = [];
            for (var _i = 1; _i < arguments.length; _i++) {
                properties[_i - 1] = arguments[_i];
            }
            node.removeProperty.apply(node, __spreadArray([], __read(properties), false));
        }
        NodeUtil.removeProperties = removeProperties;
        function getChildAt(node, position) {
            return node.childNodes[position];
        }
        NodeUtil.getChildAt = getChildAt;
        function setChild(node, position, child) {
            var children = node.childNodes;
            children[position] = child;
            if (child) {
                child.parent = node;
            }
        }
        NodeUtil.setChild = setChild;
        function copyChildren(oldNode, newNode) {
            var children = oldNode.childNodes;
            for (var i = 0; i < children.length; i++) {
                setChild(newNode, i, children[i]);
            }
        }
        NodeUtil.copyChildren = copyChildren;
        function copyAttributes(oldNode, newNode) {
            newNode.attributes = oldNode.attributes;
            setProperties(newNode, oldNode.getAllProperties());
        }
        NodeUtil.copyAttributes = copyAttributes;
        function isType(node, kind) {
            return node.isKind(kind);
        }
        NodeUtil.isType = isType;
        function isEmbellished(node) {
            return node.isEmbellished;
        }
        NodeUtil.isEmbellished = isEmbellished;
        function getTexClass(node) {
            return node.texClass;
        }
        NodeUtil.getTexClass = getTexClass;
        function getCoreMO(node) {
            return node.coreMO();
        }
        NodeUtil.getCoreMO = getCoreMO;
        function isNode(item) {
            return item instanceof MmlNode_js_1.AbstractMmlNode || item instanceof MmlNode_js_1.AbstractMmlEmptyNode;
        }
        NodeUtil.isNode = isNode;
        function isInferred(node) {
            return node.isInferred;
        }
        NodeUtil.isInferred = isInferred;
        function getForm(node) {
            var e_3, _a;
            if (!isType(node, 'mo')) {
                return null;
            }
            var mo = node;
            var forms = mo.getForms();
            try {
                for (var forms_1 = __values(forms), forms_1_1 = forms_1.next(); !forms_1_1.done; forms_1_1 = forms_1.next()) {
                    var form = forms_1_1.value;
                    var symbol = mo_js_1.MmlMo.OPTABLE[form][mo.getText()];
                    if (symbol) {
                        return symbol;
                    }
                }
            }
            catch (e_3_1) {
                e_3 = { error: e_3_1 };
            }
            finally {
                try {
                    if (forms_1_1 && !forms_1_1.done && (_a = forms_1.return))
                        _a.call(forms_1);
                }
                finally {
                    if (e_3)
                        throw e_3.error;
                }
            }
            return null;
        }
        NodeUtil.getForm = getForm;
    })(NodeUtil || (NodeUtil = {}));
    exports.default = NodeUtil;
},
643: /* mathjax-full/js/core/MmlTree/MmlNodes/mo.js */ function _(require, module, exports, __esModule, __esExport) {
    var __extends = (this && this.__extends) || (function () {
        var extendStatics = function (d, b) {
            extendStatics = Object.setPrototypeOf ||
                ({ __proto__: [] } instanceof Array && function (d, b) { d.__proto__ = b; }) ||
                function (d, b) { for (var p in b)
                    if (Object.prototype.hasOwnProperty.call(b, p))
                        d[p] = b[p]; };
            return extendStatics(d, b);
        };
        return function (d, b) {
            if (typeof b !== "function" && b !== null)
                throw new TypeError("Class extends value " + String(b) + " is not a constructor or null");
            extendStatics(d, b);
            function __() { this.constructor = d; }
            d.prototype = b === null ? Object.create(b) : (__.prototype = b.prototype, new __());
        };
    })();
    var __assign = (this && this.__assign) || function () {
        __assign = Object.assign || function (t) {
            for (var s, i = 1, n = arguments.length; i < n; i++) {
                s = arguments[i];
                for (var p in s)
                    if (Object.prototype.hasOwnProperty.call(s, p))
                        t[p] = s[p];
            }
            return t;
        };
        return __assign.apply(this, arguments);
    };
    var __read = (this && this.__read) || function (o, n) {
        var m = typeof Symbol === "function" && o[Symbol.iterator];
        if (!m)
            return o;
        var i = m.call(o), r, ar = [], e;
        try {
            while ((n === void 0 || n-- > 0) && !(r = i.next()).done)
                ar.push(r.value);
        }
        catch (error) {
            e = { error: error };
        }
        finally {
            try {
                if (r && !r.done && (m = i["return"]))
                    m.call(i);
            }
            finally {
                if (e)
                    throw e.error;
            }
        }
        return ar;
    };
    var __values = (this && this.__values) || function (o) {
        var s = typeof Symbol === "function" && Symbol.iterator, m = s && o[s], i = 0;
        if (m)
            return m.call(o);
        if (o && typeof o.length === "number")
            return {
                next: function () {
                    if (o && i >= o.length)
                        o = void 0;
                    return { value: o && o[i++], done: !o };
                }
            };
        throw new TypeError(s ? "Object is not iterable." : "Symbol.iterator is not defined.");
    };
    __esModule();
    var MmlNode_js_1 = require(639) /* ../MmlNode.js */;
    var OperatorDictionary_js_1 = require(644) /* ../OperatorDictionary.js */;
    var string_js_1 = require(636) /* ../../../util/string.js */;
    var MmlMo = (function (_super) {
        __extends(MmlMo, _super);
        function MmlMo() {
            var _this = _super !== null && _super.apply(this, arguments) || this;
            _this._texClass = null;
            _this.lspace = 5 / 18;
            _this.rspace = 5 / 18;
            return _this;
        }
        Object.defineProperty(MmlMo.prototype, "texClass", {
            get: function () {
                if (this._texClass === null) {
                    var mo = this.getText();
                    var _a = __read(this.handleExplicitForm(this.getForms()), 3), form1 = _a[0], form2 = _a[1], form3 = _a[2];
                    var OPTABLE_1 = this.constructor.OPTABLE;
                    var def = OPTABLE_1[form1][mo] || OPTABLE_1[form2][mo] || OPTABLE_1[form3][mo];
                    return def ? def[2] : MmlNode_js_1.TEXCLASS.REL;
                }
                return this._texClass;
            },
            set: function (value) {
                this._texClass = value;
            },
            enumerable: false,
            configurable: true
        });
        Object.defineProperty(MmlMo.prototype, "kind", {
            get: function () {
                return 'mo';
            },
            enumerable: false,
            configurable: true
        });
        Object.defineProperty(MmlMo.prototype, "isEmbellished", {
            get: function () {
                return true;
            },
            enumerable: false,
            configurable: true
        });
        Object.defineProperty(MmlMo.prototype, "hasNewLine", {
            get: function () {
                return this.attributes.get('linebreak') === 'newline';
            },
            enumerable: false,
            configurable: true
        });
        MmlMo.prototype.coreParent = function () {
            var embellished = this;
            var parent = this;
            var math = this.factory.getNodeClass('math');
            while (parent && parent.isEmbellished && parent.coreMO() === this && !(parent instanceof math)) {
                embellished = parent;
                parent = parent.parent;
            }
            return embellished;
        };
        MmlMo.prototype.coreText = function (parent) {
            if (!parent) {
                return '';
            }
            if (parent.isEmbellished) {
                return parent.coreMO().getText();
            }
            while ((((parent.isKind('mrow') ||
                (parent.isKind('TeXAtom') && parent.texClass !== MmlNode_js_1.TEXCLASS.VCENTER) ||
                parent.isKind('mstyle') ||
                parent.isKind('mphantom')) && parent.childNodes.length === 1) ||
                parent.isKind('munderover')) && parent.childNodes[0]) {
                parent = parent.childNodes[0];
            }
            return (parent.isToken ? parent.getText() : '');
        };
        MmlMo.prototype.hasSpacingAttributes = function () {
            return this.attributes.isSet('lspace') ||
                this.attributes.isSet('rspace');
        };
        Object.defineProperty(MmlMo.prototype, "isAccent", {
            get: function () {
                var accent = false;
                var node = this.coreParent().parent;
                if (node) {
                    var key = (node.isKind('mover') ?
                        (node.childNodes[node.over].coreMO() ?
                            'accent' : '') :
                        node.isKind('munder') ?
                            (node.childNodes[node.under].coreMO() ?
                                'accentunder' : '') :
                            node.isKind('munderover') ?
                                (this === node.childNodes[node.over].coreMO() ?
                                    'accent' :
                                    this === node.childNodes[node.under].coreMO() ?
                                        'accentunder' : '') :
                                '');
                    if (key) {
                        var value = node.attributes.getExplicit(key);
                        accent = (value !== undefined ? accent : this.attributes.get('accent'));
                    }
                }
                return accent;
            },
            enumerable: false,
            configurable: true
        });
        MmlMo.prototype.setTeXclass = function (prev) {
            var _a = this.attributes.getList('form', 'fence'), form = _a.form, fence = _a.fence;
            if (this.getProperty('texClass') === undefined &&
                (this.attributes.isSet('lspace') || this.attributes.isSet('rspace'))) {
                return null;
            }
            if (fence && this.texClass === MmlNode_js_1.TEXCLASS.REL) {
                if (form === 'prefix') {
                    this.texClass = MmlNode_js_1.TEXCLASS.OPEN;
                }
                if (form === 'postfix') {
                    this.texClass = MmlNode_js_1.TEXCLASS.CLOSE;
                }
            }
            return this.adjustTeXclass(prev);
        };
        MmlMo.prototype.adjustTeXclass = function (prev) {
            var texClass = this.texClass;
            var prevClass = this.prevClass;
            if (texClass === MmlNode_js_1.TEXCLASS.NONE) {
                return prev;
            }
            if (prev) {
                if (prev.getProperty('autoOP') && (texClass === MmlNode_js_1.TEXCLASS.BIN || texClass === MmlNode_js_1.TEXCLASS.REL)) {
                    prevClass = prev.texClass = MmlNode_js_1.TEXCLASS.ORD;
                }
                prevClass = this.prevClass = (prev.texClass || MmlNode_js_1.TEXCLASS.ORD);
                this.prevLevel = this.attributes.getInherited('scriptlevel');
            }
            else {
                prevClass = this.prevClass = MmlNode_js_1.TEXCLASS.NONE;
            }
            if (texClass === MmlNode_js_1.TEXCLASS.BIN &&
                (prevClass === MmlNode_js_1.TEXCLASS.NONE || prevClass === MmlNode_js_1.TEXCLASS.BIN || prevClass === MmlNode_js_1.TEXCLASS.OP ||
                    prevClass === MmlNode_js_1.TEXCLASS.REL || prevClass === MmlNode_js_1.TEXCLASS.OPEN || prevClass === MmlNode_js_1.TEXCLASS.PUNCT)) {
                this.texClass = MmlNode_js_1.TEXCLASS.ORD;
            }
            else if (prevClass === MmlNode_js_1.TEXCLASS.BIN &&
                (texClass === MmlNode_js_1.TEXCLASS.REL || texClass === MmlNode_js_1.TEXCLASS.CLOSE || texClass === MmlNode_js_1.TEXCLASS.PUNCT)) {
                prev.texClass = this.prevClass = MmlNode_js_1.TEXCLASS.ORD;
            }
            else if (texClass === MmlNode_js_1.TEXCLASS.BIN) {
                var child = this;
                var parent_1 = this.parent;
                while (parent_1 && parent_1.parent && parent_1.isEmbellished &&
                    (parent_1.childNodes.length === 1 ||
                        (!parent_1.isKind('mrow') && parent_1.core() === child))) {
                    child = parent_1;
                    parent_1 = parent_1.parent;
                }
                if (parent_1.childNodes[parent_1.childNodes.length - 1] === child) {
                    this.texClass = MmlNode_js_1.TEXCLASS.ORD;
                }
            }
            return this;
        };
        MmlMo.prototype.setInheritedAttributes = function (attributes, display, level, prime) {
            if (attributes === void 0) {
                attributes = {};
            }
            if (display === void 0) {
                display = false;
            }
            if (level === void 0) {
                level = 0;
            }
            if (prime === void 0) {
                prime = false;
            }
            _super.prototype.setInheritedAttributes.call(this, attributes, display, level, prime);
            var mo = this.getText();
            this.checkOperatorTable(mo);
            this.checkPseudoScripts(mo);
            this.checkPrimes(mo);
            this.checkMathAccent(mo);
        };
        MmlMo.prototype.checkOperatorTable = function (mo) {
            var e_1, _a;
            var _b = __read(this.handleExplicitForm(this.getForms()), 3), form1 = _b[0], form2 = _b[1], form3 = _b[2];
            this.attributes.setInherited('form', form1);
            var OPTABLE = this.constructor.OPTABLE;
            var def = OPTABLE[form1][mo] || OPTABLE[form2][mo] || OPTABLE[form3][mo];
            if (def) {
                if (this.getProperty('texClass') === undefined) {
                    this.texClass = def[2];
                }
                try {
                    for (var _c = __values(Object.keys(def[3] || {})), _d = _c.next(); !_d.done; _d = _c.next()) {
                        var name_1 = _d.value;
                        this.attributes.setInherited(name_1, def[3][name_1]);
                    }
                }
                catch (e_1_1) {
                    e_1 = { error: e_1_1 };
                }
                finally {
                    try {
                        if (_d && !_d.done && (_a = _c.return))
                            _a.call(_c);
                    }
                    finally {
                        if (e_1)
                            throw e_1.error;
                    }
                }
                this.lspace = (def[0] + 1) / 18;
                this.rspace = (def[1] + 1) / 18;
            }
            else {
                var range = (0, OperatorDictionary_js_1.getRange)(mo);
                if (range) {
                    if (this.getProperty('texClass') === undefined) {
                        this.texClass = range[2];
                    }
                    var spacing = this.constructor.MMLSPACING[range[2]];
                    this.lspace = (spacing[0] + 1) / 18;
                    this.rspace = (spacing[1] + 1) / 18;
                }
            }
        };
        MmlMo.prototype.getForms = function () {
            var core = this;
            var parent = this.parent;
            var Parent = this.Parent;
            while (Parent && Parent.isEmbellished) {
                core = parent;
                parent = Parent.parent;
                Parent = Parent.Parent;
            }
            if (parent && parent.isKind('mrow') && parent.nonSpaceLength() !== 1) {
                if (parent.firstNonSpace() === core) {
                    return ['prefix', 'infix', 'postfix'];
                }
                if (parent.lastNonSpace() === core) {
                    return ['postfix', 'infix', 'prefix'];
                }
            }
            return ['infix', 'prefix', 'postfix'];
        };
        MmlMo.prototype.handleExplicitForm = function (forms) {
            if (this.attributes.isSet('form')) {
                var form_1 = this.attributes.get('form');
                forms = [form_1].concat(forms.filter(function (name) { return (name !== form_1); }));
            }
            return forms;
        };
        MmlMo.prototype.checkPseudoScripts = function (mo) {
            var PSEUDOSCRIPTS = this.constructor.pseudoScripts;
            if (!mo.match(PSEUDOSCRIPTS))
                return;
            var parent = this.coreParent().Parent;
            var isPseudo = !parent || !(parent.isKind('msubsup') && !parent.isKind('msub'));
            this.setProperty('pseudoscript', isPseudo);
            if (isPseudo) {
                this.attributes.setInherited('lspace', 0);
                this.attributes.setInherited('rspace', 0);
            }
        };
        MmlMo.prototype.checkPrimes = function (mo) {
            var PRIMES = this.constructor.primes;
            if (!mo.match(PRIMES))
                return;
            var REMAP = this.constructor.remapPrimes;
            var primes = (0, string_js_1.unicodeString)((0, string_js_1.unicodeChars)(mo).map(function (c) { return REMAP[c]; }));
            this.setProperty('primes', primes);
        };
        MmlMo.prototype.checkMathAccent = function (mo) {
            var parent = this.Parent;
            if (this.getProperty('mathaccent') !== undefined || !parent || !parent.isKind('munderover'))
                return;
            var base = parent.childNodes[0];
            if (base.isEmbellished && base.coreMO() === this)
                return;
            var MATHACCENT = this.constructor.mathaccents;
            if (mo.match(MATHACCENT)) {
                this.setProperty('mathaccent', true);
            }
        };
        MmlMo.defaults = __assign(__assign({}, MmlNode_js_1.AbstractMmlTokenNode.defaults), { form: 'infix', fence: false, separator: false, lspace: 'thickmathspace', rspace: 'thickmathspace', stretchy: false, symmetric: false, maxsize: 'infinity', minsize: '0em', largeop: false, movablelimits: false, accent: false, linebreak: 'auto', lineleading: '1ex', linebreakstyle: 'before', indentalign: 'auto', indentshift: '0', indenttarget: '', indentalignfirst: 'indentalign', indentshiftfirst: 'indentshift', indentalignlast: 'indentalign', indentshiftlast: 'indentshift' });
        MmlMo.MMLSPACING = OperatorDictionary_js_1.MMLSPACING;
        MmlMo.OPTABLE = OperatorDictionary_js_1.OPTABLE;
        MmlMo.pseudoScripts = new RegExp([
            '^["\'*`',
            '\u00AA',
            '\u00B0',
            '\u00B2-\u00B4',
            '\u00B9',
            '\u00BA',
            '\u2018-\u201F',
            '\u2032-\u2037\u2057',
            '\u2070\u2071',
            '\u2074-\u207F',
            '\u2080-\u208E',
            ']+$'
        ].join(''));
        MmlMo.primes = new RegExp([
            '^["\'`',
            '\u2018-\u201F',
            ']+$'
        ].join(''));
        MmlMo.remapPrimes = {
            0x0022: 0x2033,
            0x0027: 0x2032,
            0x0060: 0x2035,
            0x2018: 0x2035,
            0x2019: 0x2032,
            0x201A: 0x2032,
            0x201B: 0x2035,
            0x201C: 0x2036,
            0x201D: 0x2033,
            0x201E: 0x2033,
            0x201F: 0x2036,
        };
        MmlMo.mathaccents = new RegExp([
            '^[',
            '\u00B4\u0301\u02CA',
            '\u0060\u0300\u02CB',
            '\u00A8\u0308',
            '\u007E\u0303\u02DC',
            '\u00AF\u0304\u02C9',
            '\u02D8\u0306',
            '\u02C7\u030C',
            '\u005E\u0302\u02C6',
            '\u2192\u20D7',
            '\u02D9\u0307',
            '\u02DA\u030A',
            '\u20DB',
            '\u20DC',
            ']$'
        ].join(''));
        return MmlMo;
    }(MmlNode_js_1.AbstractMmlTokenNode));
    exports.MmlMo = MmlMo;
},
644: /* mathjax-full/js/core/MmlTree/OperatorDictionary.js */ function _(require, module, exports, __esModule, __esExport) {
    var __values = (this && this.__values) || function (o) {
        var s = typeof Symbol === "function" && Symbol.iterator, m = s && o[s], i = 0;
        if (m)
            return m.call(o);
        if (o && typeof o.length === "number")
            return {
                next: function () {
                    if (o && i >= o.length)
                        o = void 0;
                    return { value: o && o[i++], done: !o };
                }
            };
        throw new TypeError(s ? "Object is not iterable." : "Symbol.iterator is not defined.");
    };
    __esModule();
    var MmlNode_js_1 = require(639) /* ./MmlNode.js */;
    function OPDEF(lspace, rspace, texClass, properties) {
        if (texClass === void 0) {
            texClass = MmlNode_js_1.TEXCLASS.BIN;
        }
        if (properties === void 0) {
            properties = null;
        }
        return [lspace, rspace, texClass, properties];
    }
    exports.OPDEF = OPDEF;
    exports.MO = {
        ORD: OPDEF(0, 0, MmlNode_js_1.TEXCLASS.ORD),
        ORD11: OPDEF(1, 1, MmlNode_js_1.TEXCLASS.ORD),
        ORD21: OPDEF(2, 1, MmlNode_js_1.TEXCLASS.ORD),
        ORD02: OPDEF(0, 2, MmlNode_js_1.TEXCLASS.ORD),
        ORD55: OPDEF(5, 5, MmlNode_js_1.TEXCLASS.ORD),
        NONE: OPDEF(0, 0, MmlNode_js_1.TEXCLASS.NONE),
        OP: OPDEF(1, 2, MmlNode_js_1.TEXCLASS.OP, { largeop: true, movablelimits: true, symmetric: true }),
        OPFIXED: OPDEF(1, 2, MmlNode_js_1.TEXCLASS.OP, { largeop: true, movablelimits: true }),
        INTEGRAL: OPDEF(0, 1, MmlNode_js_1.TEXCLASS.OP, { largeop: true, symmetric: true }),
        INTEGRAL2: OPDEF(1, 2, MmlNode_js_1.TEXCLASS.OP, { largeop: true, symmetric: true }),
        BIN3: OPDEF(3, 3, MmlNode_js_1.TEXCLASS.BIN),
        BIN4: OPDEF(4, 4, MmlNode_js_1.TEXCLASS.BIN),
        BIN01: OPDEF(0, 1, MmlNode_js_1.TEXCLASS.BIN),
        BIN5: OPDEF(5, 5, MmlNode_js_1.TEXCLASS.BIN),
        TALLBIN: OPDEF(4, 4, MmlNode_js_1.TEXCLASS.BIN, { stretchy: true }),
        BINOP: OPDEF(4, 4, MmlNode_js_1.TEXCLASS.BIN, { largeop: true, movablelimits: true }),
        REL: OPDEF(5, 5, MmlNode_js_1.TEXCLASS.REL),
        REL1: OPDEF(1, 1, MmlNode_js_1.TEXCLASS.REL, { stretchy: true }),
        REL4: OPDEF(4, 4, MmlNode_js_1.TEXCLASS.REL),
        RELSTRETCH: OPDEF(5, 5, MmlNode_js_1.TEXCLASS.REL, { stretchy: true }),
        RELACCENT: OPDEF(5, 5, MmlNode_js_1.TEXCLASS.REL, { accent: true }),
        WIDEREL: OPDEF(5, 5, MmlNode_js_1.TEXCLASS.REL, { accent: true, stretchy: true }),
        OPEN: OPDEF(0, 0, MmlNode_js_1.TEXCLASS.OPEN, { fence: true, stretchy: true, symmetric: true }),
        CLOSE: OPDEF(0, 0, MmlNode_js_1.TEXCLASS.CLOSE, { fence: true, stretchy: true, symmetric: true }),
        INNER: OPDEF(0, 0, MmlNode_js_1.TEXCLASS.INNER),
        PUNCT: OPDEF(0, 3, MmlNode_js_1.TEXCLASS.PUNCT),
        ACCENT: OPDEF(0, 0, MmlNode_js_1.TEXCLASS.ORD, { accent: true }),
        WIDEACCENT: OPDEF(0, 0, MmlNode_js_1.TEXCLASS.ORD, { accent: true, stretchy: true })
    };
    exports.RANGES = [
        [0x0020, 0x007F, MmlNode_js_1.TEXCLASS.REL, 'mo'],
        [0x00A0, 0x00BF, MmlNode_js_1.TEXCLASS.ORD, 'mo'],
        [0x00C0, 0x024F, MmlNode_js_1.TEXCLASS.ORD, 'mi'],
        [0x02B0, 0x036F, MmlNode_js_1.TEXCLASS.ORD, 'mo'],
        [0x0370, 0x1A20, MmlNode_js_1.TEXCLASS.ORD, 'mi'],
        [0x1AB0, 0x1AFF, MmlNode_js_1.TEXCLASS.ORD, 'mo'],
        [0x1B00, 0x1DBF, MmlNode_js_1.TEXCLASS.ORD, 'mi'],
        [0x1DC0, 0x1DFF, MmlNode_js_1.TEXCLASS.ORD, 'mo'],
        [0x1E00, 0x1FFF, MmlNode_js_1.TEXCLASS.ORD, 'mi'],
        [0x2000, 0x206F, MmlNode_js_1.TEXCLASS.ORD, 'mo'],
        [0x2070, 0x209F, MmlNode_js_1.TEXCLASS.ORD, 'mo'],
        [0x2100, 0x214F, MmlNode_js_1.TEXCLASS.ORD, 'mi'],
        [0x2150, 0x218F, MmlNode_js_1.TEXCLASS.ORD, 'mn'],
        [0x2190, 0x21FF, MmlNode_js_1.TEXCLASS.REL, 'mo'],
        [0x2200, 0x22FF, MmlNode_js_1.TEXCLASS.BIN, 'mo'],
        [0x2300, 0x23FF, MmlNode_js_1.TEXCLASS.ORD, 'mo'],
        [0x2460, 0x24FF, MmlNode_js_1.TEXCLASS.ORD, 'mn'],
        [0x2500, 0x27EF, MmlNode_js_1.TEXCLASS.ORD, 'mo'],
        [0x27F0, 0x27FF, MmlNode_js_1.TEXCLASS.REL, 'mo'],
        [0x2800, 0x28FF, MmlNode_js_1.TEXCLASS.ORD, 'mtext'],
        [0x2900, 0x297F, MmlNode_js_1.TEXCLASS.REL, 'mo'],
        [0x2980, 0x29FF, MmlNode_js_1.TEXCLASS.ORD, 'mo'],
        [0x2A00, 0x2AFF, MmlNode_js_1.TEXCLASS.BIN, 'mo'],
        [0x2B00, 0x2B2F, MmlNode_js_1.TEXCLASS.ORD, 'mo'],
        [0x2B30, 0x2B4F, MmlNode_js_1.TEXCLASS.REL, 'mo'],
        [0x2B50, 0x2BFF, MmlNode_js_1.TEXCLASS.ORD, 'mo'],
        [0x2C00, 0x2DE0, MmlNode_js_1.TEXCLASS.ORD, 'mi'],
        [0x2E00, 0x2E7F, MmlNode_js_1.TEXCLASS.ORD, 'mo'],
        [0x2E80, 0x2FDF, MmlNode_js_1.TEXCLASS.ORD, 'mi', 'normal'],
        [0x2FF0, 0x303F, MmlNode_js_1.TEXCLASS.ORD, 'mo'],
        [0x3040, 0xA49F, MmlNode_js_1.TEXCLASS.ORD, 'mi', 'normal'],
        [0xA4D0, 0xA82F, MmlNode_js_1.TEXCLASS.ORD, 'mi'],
        [0xA830, 0xA83F, MmlNode_js_1.TEXCLASS.ORD, 'mn'],
        [0xA840, 0xD7FF, MmlNode_js_1.TEXCLASS.ORD, 'mi'],
        [0xF900, 0xFAFF, MmlNode_js_1.TEXCLASS.ORD, 'mi', 'normal'],
        [0xFB00, 0xFDFF, MmlNode_js_1.TEXCLASS.ORD, 'mi'],
        [0xFE00, 0xFE6F, MmlNode_js_1.TEXCLASS.ORD, 'mo'],
        [0xFE70, 0x100FF, MmlNode_js_1.TEXCLASS.ORD, 'mi'],
        [0x10100, 0x1018F, MmlNode_js_1.TEXCLASS.ORD, 'mn'],
        [0x10190, 0x123FF, MmlNode_js_1.TEXCLASS.ORD, 'mi', 'normal'],
        [0x12400, 0x1247F, MmlNode_js_1.TEXCLASS.ORD, 'mn'],
        [0x12480, 0x1BC9F, MmlNode_js_1.TEXCLASS.ORD, 'mi', 'normal'],
        [0x1BCA0, 0x1D25F, MmlNode_js_1.TEXCLASS.ORD, 'mo'],
        [0x1D360, 0x1D37F, MmlNode_js_1.TEXCLASS.ORD, 'mn'],
        [0x1D400, 0x1D7CD, MmlNode_js_1.TEXCLASS.ORD, 'mi'],
        [0x1D7CE, 0x1D7FF, MmlNode_js_1.TEXCLASS.ORD, 'mn'],
        [0x1DF00, 0x1F7FF, MmlNode_js_1.TEXCLASS.ORD, 'mo'],
        [0x1F800, 0x1F8FF, MmlNode_js_1.TEXCLASS.REL, 'mo'],
        [0x1F900, 0x1F9FF, MmlNode_js_1.TEXCLASS.ORD, 'mo'],
        [0x20000, 0x2FA1F, MmlNode_js_1.TEXCLASS.ORD, 'mi', 'normnal'],
    ];
    function getRange(text) {
        var e_1, _a;
        var n = text.codePointAt(0);
        try {
            for (var RANGES_1 = __values(exports.RANGES), RANGES_1_1 = RANGES_1.next(); !RANGES_1_1.done; RANGES_1_1 = RANGES_1.next()) {
                var range = RANGES_1_1.value;
                if (n <= range[1]) {
                    if (n >= range[0]) {
                        return range;
                    }
                    break;
                }
            }
        }
        catch (e_1_1) {
            e_1 = { error: e_1_1 };
        }
        finally {
            try {
                if (RANGES_1_1 && !RANGES_1_1.done && (_a = RANGES_1.return))
                    _a.call(RANGES_1);
            }
            finally {
                if (e_1)
                    throw e_1.error;
            }
        }
        return null;
    }
    exports.getRange = getRange;
    exports.MMLSPACING = [
        [0, 0],
        [1, 2],
        [3, 3],
        [4, 4],
        [0, 0],
        [0, 0],
        [0, 3]
    ];
    exports.OPTABLE = {
        prefix: {
            '(': exports.MO.OPEN,
            '+': exports.MO.BIN01,
            '-': exports.MO.BIN01,
            '[': exports.MO.OPEN,
            '{': exports.MO.OPEN,
            '|': exports.MO.OPEN,
            '||': [0, 0, MmlNode_js_1.TEXCLASS.BIN, { fence: true, stretchy: true, symmetric: true }],
            '|||': [0, 0, MmlNode_js_1.TEXCLASS.ORD, { fence: true, stretchy: true, symmetric: true }],
            '\u00AC': exports.MO.ORD21,
            '\u00B1': exports.MO.BIN01,
            '\u2016': [0, 0, MmlNode_js_1.TEXCLASS.ORD, { fence: true, stretchy: true }],
            '\u2018': [0, 0, MmlNode_js_1.TEXCLASS.OPEN, { fence: true }],
            '\u201C': [0, 0, MmlNode_js_1.TEXCLASS.OPEN, { fence: true }],
            '\u2145': exports.MO.ORD21,
            '\u2146': OPDEF(2, 0, MmlNode_js_1.TEXCLASS.ORD),
            '\u2200': exports.MO.ORD21,
            '\u2202': exports.MO.ORD21,
            '\u2203': exports.MO.ORD21,
            '\u2204': exports.MO.ORD21,
            '\u2207': exports.MO.ORD21,
            '\u220F': exports.MO.OP,
            '\u2210': exports.MO.OP,
            '\u2211': exports.MO.OP,
            '\u2212': exports.MO.BIN01,
            '\u2213': exports.MO.BIN01,
            '\u221A': [1, 1, MmlNode_js_1.TEXCLASS.ORD, { stretchy: true }],
            '\u221B': exports.MO.ORD11,
            '\u221C': exports.MO.ORD11,
            '\u2220': exports.MO.ORD,
            '\u2221': exports.MO.ORD,
            '\u2222': exports.MO.ORD,
            '\u222B': exports.MO.INTEGRAL,
            '\u222C': exports.MO.INTEGRAL,
            '\u222D': exports.MO.INTEGRAL,
            '\u222E': exports.MO.INTEGRAL,
            '\u222F': exports.MO.INTEGRAL,
            '\u2230': exports.MO.INTEGRAL,
            '\u2231': exports.MO.INTEGRAL,
            '\u2232': exports.MO.INTEGRAL,
            '\u2233': exports.MO.INTEGRAL,
            '\u22C0': exports.MO.OP,
            '\u22C1': exports.MO.OP,
            '\u22C2': exports.MO.OP,
            '\u22C3': exports.MO.OP,
            '\u2308': exports.MO.OPEN,
            '\u230A': exports.MO.OPEN,
            '\u2329': exports.MO.OPEN,
            '\u2772': exports.MO.OPEN,
            '\u27E6': exports.MO.OPEN,
            '\u27E8': exports.MO.OPEN,
            '\u27EA': exports.MO.OPEN,
            '\u27EC': exports.MO.OPEN,
            '\u27EE': exports.MO.OPEN,
            '\u2980': [0, 0, MmlNode_js_1.TEXCLASS.ORD, { fence: true, stretchy: true }],
            '\u2983': exports.MO.OPEN,
            '\u2985': exports.MO.OPEN,
            '\u2987': exports.MO.OPEN,
            '\u2989': exports.MO.OPEN,
            '\u298B': exports.MO.OPEN,
            '\u298D': exports.MO.OPEN,
            '\u298F': exports.MO.OPEN,
            '\u2991': exports.MO.OPEN,
            '\u2993': exports.MO.OPEN,
            '\u2995': exports.MO.OPEN,
            '\u2997': exports.MO.OPEN,
            '\u29FC': exports.MO.OPEN,
            '\u2A00': exports.MO.OP,
            '\u2A01': exports.MO.OP,
            '\u2A02': exports.MO.OP,
            '\u2A03': exports.MO.OP,
            '\u2A04': exports.MO.OP,
            '\u2A05': exports.MO.OP,
            '\u2A06': exports.MO.OP,
            '\u2A07': exports.MO.OP,
            '\u2A08': exports.MO.OP,
            '\u2A09': exports.MO.OP,
            '\u2A0A': exports.MO.OP,
            '\u2A0B': exports.MO.INTEGRAL2,
            '\u2A0C': exports.MO.INTEGRAL,
            '\u2A0D': exports.MO.INTEGRAL2,
            '\u2A0E': exports.MO.INTEGRAL2,
            '\u2A0F': exports.MO.INTEGRAL2,
            '\u2A10': exports.MO.OP,
            '\u2A11': exports.MO.OP,
            '\u2A12': exports.MO.OP,
            '\u2A13': exports.MO.OP,
            '\u2A14': exports.MO.OP,
            '\u2A15': exports.MO.INTEGRAL2,
            '\u2A16': exports.MO.INTEGRAL2,
            '\u2A17': exports.MO.INTEGRAL2,
            '\u2A18': exports.MO.INTEGRAL2,
            '\u2A19': exports.MO.INTEGRAL2,
            '\u2A1A': exports.MO.INTEGRAL2,
            '\u2A1B': exports.MO.INTEGRAL2,
            '\u2A1C': exports.MO.INTEGRAL2,
            '\u2AFC': exports.MO.OP,
            '\u2AFF': exports.MO.OP,
        },
        postfix: {
            '!!': OPDEF(1, 0),
            '!': [1, 0, MmlNode_js_1.TEXCLASS.CLOSE, null],
            '"': exports.MO.ACCENT,
            '&': exports.MO.ORD,
            ')': exports.MO.CLOSE,
            '++': OPDEF(0, 0),
            '--': OPDEF(0, 0),
            '..': OPDEF(0, 0),
            '...': exports.MO.ORD,
            '\'': exports.MO.ACCENT,
            ']': exports.MO.CLOSE,
            '^': exports.MO.WIDEACCENT,
            '_': exports.MO.WIDEACCENT,
            '`': exports.MO.ACCENT,
            '|': exports.MO.CLOSE,
            '}': exports.MO.CLOSE,
            '~': exports.MO.WIDEACCENT,
            '||': [0, 0, MmlNode_js_1.TEXCLASS.BIN, { fence: true, stretchy: true, symmetric: true }],
            '|||': [0, 0, MmlNode_js_1.TEXCLASS.ORD, { fence: true, stretchy: true, symmetric: true }],
            '\u00A8': exports.MO.ACCENT,
            '\u00AA': exports.MO.ACCENT,
            '\u00AF': exports.MO.WIDEACCENT,
            '\u00B0': exports.MO.ORD,
            '\u00B2': exports.MO.ACCENT,
            '\u00B3': exports.MO.ACCENT,
            '\u00B4': exports.MO.ACCENT,
            '\u00B8': exports.MO.ACCENT,
            '\u00B9': exports.MO.ACCENT,
            '\u00BA': exports.MO.ACCENT,
            '\u02C6': exports.MO.WIDEACCENT,
            '\u02C7': exports.MO.WIDEACCENT,
            '\u02C9': exports.MO.WIDEACCENT,
            '\u02CA': exports.MO.ACCENT,
            '\u02CB': exports.MO.ACCENT,
            '\u02CD': exports.MO.WIDEACCENT,
            '\u02D8': exports.MO.ACCENT,
            '\u02D9': exports.MO.ACCENT,
            '\u02DA': exports.MO.ACCENT,
            '\u02DC': exports.MO.WIDEACCENT,
            '\u02DD': exports.MO.ACCENT,
            '\u02F7': exports.MO.WIDEACCENT,
            '\u0302': exports.MO.WIDEACCENT,
            '\u0311': exports.MO.ACCENT,
            '\u03F6': exports.MO.REL,
            '\u2016': [0, 0, MmlNode_js_1.TEXCLASS.ORD, { fence: true, stretchy: true }],
            '\u2019': [0, 0, MmlNode_js_1.TEXCLASS.CLOSE, { fence: true }],
            '\u201A': exports.MO.ACCENT,
            '\u201B': exports.MO.ACCENT,
            '\u201D': [0, 0, MmlNode_js_1.TEXCLASS.CLOSE, { fence: true }],
            '\u201E': exports.MO.ACCENT,
            '\u201F': exports.MO.ACCENT,
            '\u2032': exports.MO.ORD,
            '\u2033': exports.MO.ACCENT,
            '\u2034': exports.MO.ACCENT,
            '\u2035': exports.MO.ACCENT,
            '\u2036': exports.MO.ACCENT,
            '\u2037': exports.MO.ACCENT,
            '\u203E': exports.MO.WIDEACCENT,
            '\u2057': exports.MO.ACCENT,
            '\u20DB': exports.MO.ACCENT,
            '\u20DC': exports.MO.ACCENT,
            '\u2309': exports.MO.CLOSE,
            '\u230B': exports.MO.CLOSE,
            '\u232A': exports.MO.CLOSE,
            '\u23B4': exports.MO.WIDEACCENT,
            '\u23B5': exports.MO.WIDEACCENT,
            '\u23DC': exports.MO.WIDEACCENT,
            '\u23DD': exports.MO.WIDEACCENT,
            '\u23DE': exports.MO.WIDEACCENT,
            '\u23DF': exports.MO.WIDEACCENT,
            '\u23E0': exports.MO.WIDEACCENT,
            '\u23E1': exports.MO.WIDEACCENT,
            '\u25A0': exports.MO.BIN3,
            '\u25A1': exports.MO.BIN3,
            '\u25AA': exports.MO.BIN3,
            '\u25AB': exports.MO.BIN3,
            '\u25AD': exports.MO.BIN3,
            '\u25AE': exports.MO.BIN3,
            '\u25AF': exports.MO.BIN3,
            '\u25B0': exports.MO.BIN3,
            '\u25B1': exports.MO.BIN3,
            '\u25B2': exports.MO.BIN4,
            '\u25B4': exports.MO.BIN4,
            '\u25B6': exports.MO.BIN4,
            '\u25B7': exports.MO.BIN4,
            '\u25B8': exports.MO.BIN4,
            '\u25BC': exports.MO.BIN4,
            '\u25BE': exports.MO.BIN4,
            '\u25C0': exports.MO.BIN4,
            '\u25C1': exports.MO.BIN4,
            '\u25C2': exports.MO.BIN4,
            '\u25C4': exports.MO.BIN4,
            '\u25C5': exports.MO.BIN4,
            '\u25C6': exports.MO.BIN4,
            '\u25C7': exports.MO.BIN4,
            '\u25C8': exports.MO.BIN4,
            '\u25C9': exports.MO.BIN4,
            '\u25CC': exports.MO.BIN4,
            '\u25CD': exports.MO.BIN4,
            '\u25CE': exports.MO.BIN4,
            '\u25CF': exports.MO.BIN4,
            '\u25D6': exports.MO.BIN4,
            '\u25D7': exports.MO.BIN4,
            '\u25E6': exports.MO.BIN4,
            '\u266D': exports.MO.ORD02,
            '\u266E': exports.MO.ORD02,
            '\u266F': exports.MO.ORD02,
            '\u2773': exports.MO.CLOSE,
            '\u27E7': exports.MO.CLOSE,
            '\u27E9': exports.MO.CLOSE,
            '\u27EB': exports.MO.CLOSE,
            '\u27ED': exports.MO.CLOSE,
            '\u27EF': exports.MO.CLOSE,
            '\u2980': [0, 0, MmlNode_js_1.TEXCLASS.ORD, { fence: true, stretchy: true }],
            '\u2984': exports.MO.CLOSE,
            '\u2986': exports.MO.CLOSE,
            '\u2988': exports.MO.CLOSE,
            '\u298A': exports.MO.CLOSE,
            '\u298C': exports.MO.CLOSE,
            '\u298E': exports.MO.CLOSE,
            '\u2990': exports.MO.CLOSE,
            '\u2992': exports.MO.CLOSE,
            '\u2994': exports.MO.CLOSE,
            '\u2996': exports.MO.CLOSE,
            '\u2998': exports.MO.CLOSE,
            '\u29FD': exports.MO.CLOSE,
        },
        infix: {
            '!=': exports.MO.BIN4,
            '#': exports.MO.ORD,
            '$': exports.MO.ORD,
            '%': [3, 3, MmlNode_js_1.TEXCLASS.ORD, null],
            '&&': exports.MO.BIN4,
            '': exports.MO.ORD,
            '*': exports.MO.BIN3,
            '**': OPDEF(1, 1),
            '*=': exports.MO.BIN4,
            '+': exports.MO.BIN4,
            '+=': exports.MO.BIN4,
            ',': [0, 3, MmlNode_js_1.TEXCLASS.PUNCT, { linebreakstyle: 'after', separator: true }],
            '-': exports.MO.BIN4,
            '-=': exports.MO.BIN4,
            '->': exports.MO.BIN5,
            '.': [0, 3, MmlNode_js_1.TEXCLASS.PUNCT, { separator: true }],
            '/': exports.MO.ORD11,
            '//': OPDEF(1, 1),
            '/=': exports.MO.BIN4,
            ':': [1, 2, MmlNode_js_1.TEXCLASS.REL, null],
            ':=': exports.MO.BIN4,
            ';': [0, 3, MmlNode_js_1.TEXCLASS.PUNCT, { linebreakstyle: 'after', separator: true }],
            '<': exports.MO.REL,
            '<=': exports.MO.BIN5,
            '<>': OPDEF(1, 1),
            '=': exports.MO.REL,
            '==': exports.MO.BIN4,
            '>': exports.MO.REL,
            '>=': exports.MO.BIN5,
            '?': [1, 1, MmlNode_js_1.TEXCLASS.CLOSE, null],
            '@': exports.MO.ORD11,
            '\\': exports.MO.ORD,
            '^': exports.MO.ORD11,
            '_': exports.MO.ORD11,
            '|': [2, 2, MmlNode_js_1.TEXCLASS.ORD, { fence: true, stretchy: true, symmetric: true }],
            '||': [2, 2, MmlNode_js_1.TEXCLASS.BIN, { fence: true, stretchy: true, symmetric: true }],
            '|||': [2, 2, MmlNode_js_1.TEXCLASS.ORD, { fence: true, stretchy: true, symmetric: true }],
            '\u00B1': exports.MO.BIN4,
            '\u00B7': exports.MO.BIN4,
            '\u00D7': exports.MO.BIN4,
            '\u00F7': exports.MO.BIN4,
            '\u02B9': exports.MO.ORD,
            '\u0300': exports.MO.ACCENT,
            '\u0301': exports.MO.ACCENT,
            '\u0303': exports.MO.WIDEACCENT,
            '\u0304': exports.MO.ACCENT,
            '\u0306': exports.MO.ACCENT,
            '\u0307': exports.MO.ACCENT,
            '\u0308': exports.MO.ACCENT,
            '\u030C': exports.MO.ACCENT,
            '\u0332': exports.MO.WIDEACCENT,
            '\u0338': exports.MO.REL4,
            '\u2015': [0, 0, MmlNode_js_1.TEXCLASS.ORD, { stretchy: true }],
            '\u2017': [0, 0, MmlNode_js_1.TEXCLASS.ORD, { stretchy: true }],
            '\u2020': exports.MO.BIN3,
            '\u2021': exports.MO.BIN3,
            '\u2022': exports.MO.BIN4,
            '\u2026': exports.MO.INNER,
            '\u2043': exports.MO.BIN4,
            '\u2044': exports.MO.TALLBIN,
            '\u2061': exports.MO.NONE,
            '\u2062': exports.MO.NONE,
            '\u2063': [0, 0, MmlNode_js_1.TEXCLASS.NONE, { linebreakstyle: 'after', separator: true }],
            '\u2064': exports.MO.NONE,
            '\u20D7': exports.MO.ACCENT,
            '\u2111': exports.MO.ORD,
            '\u2113': exports.MO.ORD,
            '\u2118': exports.MO.ORD,
            '\u211C': exports.MO.ORD,
            '\u2190': exports.MO.WIDEREL,
            '\u2191': exports.MO.RELSTRETCH,
            '\u2192': exports.MO.WIDEREL,
            '\u2193': exports.MO.RELSTRETCH,
            '\u2194': exports.MO.WIDEREL,
            '\u2195': exports.MO.RELSTRETCH,
            '\u2196': exports.MO.RELSTRETCH,
            '\u2197': exports.MO.RELSTRETCH,
            '\u2198': exports.MO.RELSTRETCH,
            '\u2199': exports.MO.RELSTRETCH,
            '\u219A': exports.MO.RELACCENT,
            '\u219B': exports.MO.RELACCENT,
            '\u219C': exports.MO.WIDEREL,
            '\u219D': exports.MO.WIDEREL,
            '\u219E': exports.MO.WIDEREL,
            '\u219F': exports.MO.WIDEREL,
            '\u21A0': exports.MO.WIDEREL,
            '\u21A1': exports.MO.RELSTRETCH,
            '\u21A2': exports.MO.WIDEREL,
            '\u21A3': exports.MO.WIDEREL,
            '\u21A4': exports.MO.WIDEREL,
            '\u21A5': exports.MO.RELSTRETCH,
            '\u21A6': exports.MO.WIDEREL,
            '\u21A7': exports.MO.RELSTRETCH,
            '\u21A8': exports.MO.RELSTRETCH,
            '\u21A9': exports.MO.WIDEREL,
            '\u21AA': exports.MO.WIDEREL,
            '\u21AB': exports.MO.WIDEREL,
            '\u21AC': exports.MO.WIDEREL,
            '\u21AD': exports.MO.WIDEREL,
            '\u21AE': exports.MO.RELACCENT,
            '\u21AF': exports.MO.RELSTRETCH,
            '\u21B0': exports.MO.RELSTRETCH,
            '\u21B1': exports.MO.RELSTRETCH,
            '\u21B2': exports.MO.RELSTRETCH,
            '\u21B3': exports.MO.RELSTRETCH,
            '\u21B4': exports.MO.RELSTRETCH,
            '\u21B5': exports.MO.RELSTRETCH,
            '\u21B6': exports.MO.RELACCENT,
            '\u21B7': exports.MO.RELACCENT,
            '\u21B8': exports.MO.REL,
            '\u21B9': exports.MO.WIDEREL,
            '\u21BA': exports.MO.REL,
            '\u21BB': exports.MO.REL,
            '\u21BC': exports.MO.WIDEREL,
            '\u21BD': exports.MO.WIDEREL,
            '\u21BE': exports.MO.RELSTRETCH,
            '\u21BF': exports.MO.RELSTRETCH,
            '\u21C0': exports.MO.WIDEREL,
            '\u21C1': exports.MO.WIDEREL,
            '\u21C2': exports.MO.RELSTRETCH,
            '\u21C3': exports.MO.RELSTRETCH,
            '\u21C4': exports.MO.WIDEREL,
            '\u21C5': exports.MO.RELSTRETCH,
            '\u21C6': exports.MO.WIDEREL,
            '\u21C7': exports.MO.WIDEREL,
            '\u21C8': exports.MO.RELSTRETCH,
            '\u21C9': exports.MO.WIDEREL,
            '\u21CA': exports.MO.RELSTRETCH,
            '\u21CB': exports.MO.WIDEREL,
            '\u21CC': exports.MO.WIDEREL,
            '\u21CD': exports.MO.RELACCENT,
            '\u21CE': exports.MO.RELACCENT,
            '\u21CF': exports.MO.RELACCENT,
            '\u21D0': exports.MO.WIDEREL,
            '\u21D1': exports.MO.RELSTRETCH,
            '\u21D2': exports.MO.WIDEREL,
            '\u21D3': exports.MO.RELSTRETCH,
            '\u21D4': exports.MO.WIDEREL,
            '\u21D5': exports.MO.RELSTRETCH,
            '\u21D6': exports.MO.RELSTRETCH,
            '\u21D7': exports.MO.RELSTRETCH,
            '\u21D8': exports.MO.RELSTRETCH,
            '\u21D9': exports.MO.RELSTRETCH,
            '\u21DA': exports.MO.WIDEREL,
            '\u21DB': exports.MO.WIDEREL,
            '\u21DC': exports.MO.WIDEREL,
            '\u21DD': exports.MO.WIDEREL,
            '\u21DE': exports.MO.REL,
            '\u21DF': exports.MO.REL,
            '\u21E0': exports.MO.WIDEREL,
            '\u21E1': exports.MO.RELSTRETCH,
            '\u21E2': exports.MO.WIDEREL,
            '\u21E3': exports.MO.RELSTRETCH,
            '\u21E4': exports.MO.WIDEREL,
            '\u21E5': exports.MO.WIDEREL,
            '\u21E6': exports.MO.WIDEREL,
            '\u21E7': exports.MO.RELSTRETCH,
            '\u21E8': exports.MO.WIDEREL,
            '\u21E9': exports.MO.RELSTRETCH,
            '\u21EA': exports.MO.RELSTRETCH,
            '\u21EB': exports.MO.RELSTRETCH,
            '\u21EC': exports.MO.RELSTRETCH,
            '\u21ED': exports.MO.RELSTRETCH,
            '\u21EE': exports.MO.RELSTRETCH,
            '\u21EF': exports.MO.RELSTRETCH,
            '\u21F0': exports.MO.WIDEREL,
            '\u21F1': exports.MO.REL,
            '\u21F2': exports.MO.REL,
            '\u21F3': exports.MO.RELSTRETCH,
            '\u21F4': exports.MO.RELACCENT,
            '\u21F5': exports.MO.RELSTRETCH,
            '\u21F6': exports.MO.WIDEREL,
            '\u21F7': exports.MO.RELACCENT,
            '\u21F8': exports.MO.RELACCENT,
            '\u21F9': exports.MO.RELACCENT,
            '\u21FA': exports.MO.RELACCENT,
            '\u21FB': exports.MO.RELACCENT,
            '\u21FC': exports.MO.RELACCENT,
            '\u21FD': exports.MO.WIDEREL,
            '\u21FE': exports.MO.WIDEREL,
            '\u21FF': exports.MO.WIDEREL,
            '\u2201': OPDEF(1, 2, MmlNode_js_1.TEXCLASS.ORD),
            '\u2205': exports.MO.ORD,
            '\u2206': exports.MO.BIN3,
            '\u2208': exports.MO.REL,
            '\u2209': exports.MO.REL,
            '\u220A': exports.MO.REL,
            '\u220B': exports.MO.REL,
            '\u220C': exports.MO.REL,
            '\u220D': exports.MO.REL,
            '\u220E': exports.MO.BIN3,
            '\u2212': exports.MO.BIN4,
            '\u2213': exports.MO.BIN4,
            '\u2214': exports.MO.BIN4,
            '\u2215': exports.MO.TALLBIN,
            '\u2216': exports.MO.BIN4,
            '\u2217': exports.MO.BIN4,
            '\u2218': exports.MO.BIN4,
            '\u2219': exports.MO.BIN4,
            '\u221D': exports.MO.REL,
            '\u221E': exports.MO.ORD,
            '\u221F': exports.MO.REL,
            '\u2223': exports.MO.REL,
            '\u2224': exports.MO.REL,
            '\u2225': exports.MO.REL,
            '\u2226': exports.MO.REL,
            '\u2227': exports.MO.BIN4,
            '\u2228': exports.MO.BIN4,
            '\u2229': exports.MO.BIN4,
            '\u222A': exports.MO.BIN4,
            '\u2234': exports.MO.REL,
            '\u2235': exports.MO.REL,
            '\u2236': exports.MO.REL,
            '\u2237': exports.MO.REL,
            '\u2238': exports.MO.BIN4,
            '\u2239': exports.MO.REL,
            '\u223A': exports.MO.BIN4,
            '\u223B': exports.MO.REL,
            '\u223C': exports.MO.REL,
            '\u223D': exports.MO.REL,
            '\u223D\u0331': exports.MO.BIN3,
            '\u223E': exports.MO.REL,
            '\u223F': exports.MO.BIN3,
            '\u2240': exports.MO.BIN4,
            '\u2241': exports.MO.REL,
            '\u2242': exports.MO.REL,
            '\u2242\u0338': exports.MO.REL,
            '\u2243': exports.MO.REL,
            '\u2244': exports.MO.REL,
            '\u2245': exports.MO.REL,
            '\u2246': exports.MO.REL,
            '\u2247': exports.MO.REL,
            '\u2248': exports.MO.REL,
            '\u2249': exports.MO.REL,
            '\u224A': exports.MO.REL,
            '\u224B': exports.MO.REL,
            '\u224C': exports.MO.REL,
            '\u224D': exports.MO.REL,
            '\u224E': exports.MO.REL,
            '\u224E\u0338': exports.MO.REL,
            '\u224F': exports.MO.REL,
            '\u224F\u0338': exports.MO.REL,
            '\u2250': exports.MO.REL,
            '\u2251': exports.MO.REL,
            '\u2252': exports.MO.REL,
            '\u2253': exports.MO.REL,
            '\u2254': exports.MO.REL,
            '\u2255': exports.MO.REL,
            '\u2256': exports.MO.REL,
            '\u2257': exports.MO.REL,
            '\u2258': exports.MO.REL,
            '\u2259': exports.MO.REL,
            '\u225A': exports.MO.REL,
            '\u225B': exports.MO.REL,
            '\u225C': exports.MO.REL,
            '\u225D': exports.MO.REL,
            '\u225E': exports.MO.REL,
            '\u225F': exports.MO.REL,
            '\u2260': exports.MO.REL,
            '\u2261': exports.MO.REL,
            '\u2262': exports.MO.REL,
            '\u2263': exports.MO.REL,
            '\u2264': exports.MO.REL,
            '\u2265': exports.MO.REL,
            '\u2266': exports.MO.REL,
            '\u2266\u0338': exports.MO.REL,
            '\u2267': exports.MO.REL,
            '\u2268': exports.MO.REL,
            '\u2269': exports.MO.REL,
            '\u226A': exports.MO.REL,
            '\u226A\u0338': exports.MO.REL,
            '\u226B': exports.MO.REL,
            '\u226B\u0338': exports.MO.REL,
            '\u226C': exports.MO.REL,
            '\u226D': exports.MO.REL,
            '\u226E': exports.MO.REL,
            '\u226F': exports.MO.REL,
            '\u2270': exports.MO.REL,
            '\u2271': exports.MO.REL,
            '\u2272': exports.MO.REL,
            '\u2273': exports.MO.REL,
            '\u2274': exports.MO.REL,
            '\u2275': exports.MO.REL,
            '\u2276': exports.MO.REL,
            '\u2277': exports.MO.REL,
            '\u2278': exports.MO.REL,
            '\u2279': exports.MO.REL,
            '\u227A': exports.MO.REL,
            '\u227B': exports.MO.REL,
            '\u227C': exports.MO.REL,
            '\u227D': exports.MO.REL,
            '\u227E': exports.MO.REL,
            '\u227F': exports.MO.REL,
            '\u227F\u0338': exports.MO.REL,
            '\u2280': exports.MO.REL,
            '\u2281': exports.MO.REL,
            '\u2282': exports.MO.REL,
            '\u2282\u20D2': exports.MO.REL,
            '\u2283': exports.MO.REL,
            '\u2283\u20D2': exports.MO.REL,
            '\u2284': exports.MO.REL,
            '\u2285': exports.MO.REL,
            '\u2286': exports.MO.REL,
            '\u2287': exports.MO.REL,
            '\u2288': exports.MO.REL,
            '\u2289': exports.MO.REL,
            '\u228A': exports.MO.REL,
            '\u228B': exports.MO.REL,
            '\u228C': exports.MO.BIN4,
            '\u228D': exports.MO.BIN4,
            '\u228E': exports.MO.BIN4,
            '\u228F': exports.MO.REL,
            '\u228F\u0338': exports.MO.REL,
            '\u2290': exports.MO.REL,
            '\u2290\u0338': exports.MO.REL,
            '\u2291': exports.MO.REL,
            '\u2292': exports.MO.REL,
            '\u2293': exports.MO.BIN4,
            '\u2294': exports.MO.BIN4,
            '\u2295': exports.MO.BIN4,
            '\u2296': exports.MO.BIN4,
            '\u2297': exports.MO.BIN4,
            '\u2298': exports.MO.BIN4,
            '\u2299': exports.MO.BIN4,
            '\u229A': exports.MO.BIN4,
            '\u229B': exports.MO.BIN4,
            '\u229C': exports.MO.BIN4,
            '\u229D': exports.MO.BIN4,
            '\u229E': exports.MO.BIN4,
            '\u229F': exports.MO.BIN4,
            '\u22A0': exports.MO.BIN4,
            '\u22A1': exports.MO.BIN4,
            '\u22A2': exports.MO.REL,
            '\u22A3': exports.MO.REL,
            '\u22A4': exports.MO.ORD55,
            '\u22A5': exports.MO.REL,
            '\u22A6': exports.MO.REL,
            '\u22A7': exports.MO.REL,
            '\u22A8': exports.MO.REL,
            '\u22A9': exports.MO.REL,
            '\u22AA': exports.MO.REL,
            '\u22AB': exports.MO.REL,
            '\u22AC': exports.MO.REL,
            '\u22AD': exports.MO.REL,
            '\u22AE': exports.MO.REL,
            '\u22AF': exports.MO.REL,
            '\u22B0': exports.MO.REL,
            '\u22B1': exports.MO.REL,
            '\u22B2': exports.MO.REL,
            '\u22B3': exports.MO.REL,
            '\u22B4': exports.MO.REL,
            '\u22B5': exports.MO.REL,
            '\u22B6': exports.MO.REL,
            '\u22B7': exports.MO.REL,
            '\u22B8': exports.MO.REL,
            '\u22B9': exports.MO.REL,
            '\u22BA': exports.MO.BIN4,
            '\u22BB': exports.MO.BIN4,
            '\u22BC': exports.MO.BIN4,
            '\u22BD': exports.MO.BIN4,
            '\u22BE': exports.MO.BIN3,
            '\u22BF': exports.MO.BIN3,
            '\u22C4': exports.MO.BIN4,
            '\u22C5': exports.MO.BIN4,
            '\u22C6': exports.MO.BIN4,
            '\u22C7': exports.MO.BIN4,
            '\u22C8': exports.MO.REL,
            '\u22C9': exports.MO.BIN4,
            '\u22CA': exports.MO.BIN4,
            '\u22CB': exports.MO.BIN4,
            '\u22CC': exports.MO.BIN4,
            '\u22CD': exports.MO.REL,
            '\u22CE': exports.MO.BIN4,
            '\u22CF': exports.MO.BIN4,
            '\u22D0': exports.MO.REL,
            '\u22D1': exports.MO.REL,
            '\u22D2': exports.MO.BIN4,
            '\u22D3': exports.MO.BIN4,
            '\u22D4': exports.MO.REL,
            '\u22D5': exports.MO.REL,
            '\u22D6': exports.MO.REL,
            '\u22D7': exports.MO.REL,
            '\u22D8': exports.MO.REL,
            '\u22D9': exports.MO.REL,
            '\u22DA': exports.MO.REL,
            '\u22DB': exports.MO.REL,
            '\u22DC': exports.MO.REL,
            '\u22DD': exports.MO.REL,
            '\u22DE': exports.MO.REL,
            '\u22DF': exports.MO.REL,
            '\u22E0': exports.MO.REL,
            '\u22E1': exports.MO.REL,
            '\u22E2': exports.MO.REL,
            '\u22E3': exports.MO.REL,
            '\u22E4': exports.MO.REL,
            '\u22E5': exports.MO.REL,
            '\u22E6': exports.MO.REL,
            '\u22E7': exports.MO.REL,
            '\u22E8': exports.MO.REL,
            '\u22E9': exports.MO.REL,
            '\u22EA': exports.MO.REL,
            '\u22EB': exports.MO.REL,
            '\u22EC': exports.MO.REL,
            '\u22ED': exports.MO.REL,
            '\u22EE': exports.MO.ORD55,
            '\u22EF': exports.MO.INNER,
            '\u22F0': exports.MO.REL,
            '\u22F1': [5, 5, MmlNode_js_1.TEXCLASS.INNER, null],
            '\u22F2': exports.MO.REL,
            '\u22F3': exports.MO.REL,
            '\u22F4': exports.MO.REL,
            '\u22F5': exports.MO.REL,
            '\u22F6': exports.MO.REL,
            '\u22F7': exports.MO.REL,
            '\u22F8': exports.MO.REL,
            '\u22F9': exports.MO.REL,
            '\u22FA': exports.MO.REL,
            '\u22FB': exports.MO.REL,
            '\u22FC': exports.MO.REL,
            '\u22FD': exports.MO.REL,
            '\u22FE': exports.MO.REL,
            '\u22FF': exports.MO.REL,
            '\u2305': exports.MO.BIN3,
            '\u2306': exports.MO.BIN3,
            '\u2322': exports.MO.REL4,
            '\u2323': exports.MO.REL4,
            '\u2329': exports.MO.OPEN,
            '\u232A': exports.MO.CLOSE,
            '\u23AA': exports.MO.ORD,
            '\u23AF': [0, 0, MmlNode_js_1.TEXCLASS.ORD, { stretchy: true }],
            '\u23B0': exports.MO.OPEN,
            '\u23B1': exports.MO.CLOSE,
            '\u2500': exports.MO.ORD,
            '\u25B3': exports.MO.BIN4,
            '\u25B5': exports.MO.BIN4,
            '\u25B9': exports.MO.BIN4,
            '\u25BD': exports.MO.BIN4,
            '\u25BF': exports.MO.BIN4,
            '\u25C3': exports.MO.BIN4,
            '\u25EF': exports.MO.BIN3,
            '\u2660': exports.MO.ORD,
            '\u2661': exports.MO.ORD,
            '\u2662': exports.MO.ORD,
            '\u2663': exports.MO.ORD,
            '\u2758': exports.MO.REL,
            '\u27F0': exports.MO.RELSTRETCH,
            '\u27F1': exports.MO.RELSTRETCH,
            '\u27F5': exports.MO.WIDEREL,
            '\u27F6': exports.MO.WIDEREL,
            '\u27F7': exports.MO.WIDEREL,
            '\u27F8': exports.MO.WIDEREL,
            '\u27F9': exports.MO.WIDEREL,
            '\u27FA': exports.MO.WIDEREL,
            '\u27FB': exports.MO.WIDEREL,
            '\u27FC': exports.MO.WIDEREL,
            '\u27FD': exports.MO.WIDEREL,
            '\u27FE': exports.MO.WIDEREL,
            '\u27FF': exports.MO.WIDEREL,
            '\u2900': exports.MO.RELACCENT,
            '\u2901': exports.MO.RELACCENT,
            '\u2902': exports.MO.RELACCENT,
            '\u2903': exports.MO.RELACCENT,
            '\u2904': exports.MO.RELACCENT,
            '\u2905': exports.MO.RELACCENT,
            '\u2906': exports.MO.RELACCENT,
            '\u2907': exports.MO.RELACCENT,
            '\u2908': exports.MO.REL,
            '\u2909': exports.MO.REL,
            '\u290A': exports.MO.RELSTRETCH,
            '\u290B': exports.MO.RELSTRETCH,
            '\u290C': exports.MO.WIDEREL,
            '\u290D': exports.MO.WIDEREL,
            '\u290E': exports.MO.WIDEREL,
            '\u290F': exports.MO.WIDEREL,
            '\u2910': exports.MO.WIDEREL,
            '\u2911': exports.MO.RELACCENT,
            '\u2912': exports.MO.RELSTRETCH,
            '\u2913': exports.MO.RELSTRETCH,
            '\u2914': exports.MO.RELACCENT,
            '\u2915': exports.MO.RELACCENT,
            '\u2916': exports.MO.RELACCENT,
            '\u2917': exports.MO.RELACCENT,
            '\u2918': exports.MO.RELACCENT,
            '\u2919': exports.MO.RELACCENT,
            '\u291A': exports.MO.RELACCENT,
            '\u291B': exports.MO.RELACCENT,
            '\u291C': exports.MO.RELACCENT,
            '\u291D': exports.MO.RELACCENT,
            '\u291E': exports.MO.RELACCENT,
            '\u291F': exports.MO.RELACCENT,
            '\u2920': exports.MO.RELACCENT,
            '\u2921': exports.MO.RELSTRETCH,
            '\u2922': exports.MO.RELSTRETCH,
            '\u2923': exports.MO.REL,
            '\u2924': exports.MO.REL,
            '\u2925': exports.MO.REL,
            '\u2926': exports.MO.REL,
            '\u2927': exports.MO.REL,
            '\u2928': exports.MO.REL,
            '\u2929': exports.MO.REL,
            '\u292A': exports.MO.REL,
            '\u292B': exports.MO.REL,
            '\u292C': exports.MO.REL,
            '\u292D': exports.MO.REL,
            '\u292E': exports.MO.REL,
            '\u292F': exports.MO.REL,
            '\u2930': exports.MO.REL,
            '\u2931': exports.MO.REL,
            '\u2932': exports.MO.REL,
            '\u2933': exports.MO.RELACCENT,
            '\u2934': exports.MO.REL,
            '\u2935': exports.MO.REL,
            '\u2936': exports.MO.REL,
            '\u2937': exports.MO.REL,
            '\u2938': exports.MO.REL,
            '\u2939': exports.MO.REL,
            '\u293A': exports.MO.RELACCENT,
            '\u293B': exports.MO.RELACCENT,
            '\u293C': exports.MO.RELACCENT,
            '\u293D': exports.MO.RELACCENT,
            '\u293E': exports.MO.REL,
            '\u293F': exports.MO.REL,
            '\u2940': exports.MO.REL,
            '\u2941': exports.MO.REL,
            '\u2942': exports.MO.RELACCENT,
            '\u2943': exports.MO.RELACCENT,
            '\u2944': exports.MO.RELACCENT,
            '\u2945': exports.MO.RELACCENT,
            '\u2946': exports.MO.RELACCENT,
            '\u2947': exports.MO.RELACCENT,
            '\u2948': exports.MO.RELACCENT,
            '\u2949': exports.MO.REL,
            '\u294A': exports.MO.RELACCENT,
            '\u294B': exports.MO.RELACCENT,
            '\u294C': exports.MO.REL,
            '\u294D': exports.MO.REL,
            '\u294E': exports.MO.WIDEREL,
            '\u294F': exports.MO.RELSTRETCH,
            '\u2950': exports.MO.WIDEREL,
            '\u2951': exports.MO.RELSTRETCH,
            '\u2952': exports.MO.WIDEREL,
            '\u2953': exports.MO.WIDEREL,
            '\u2954': exports.MO.RELSTRETCH,
            '\u2955': exports.MO.RELSTRETCH,
            '\u2956': exports.MO.RELSTRETCH,
            '\u2957': exports.MO.RELSTRETCH,
            '\u2958': exports.MO.RELSTRETCH,
            '\u2959': exports.MO.RELSTRETCH,
            '\u295A': exports.MO.WIDEREL,
            '\u295B': exports.MO.WIDEREL,
            '\u295C': exports.MO.RELSTRETCH,
            '\u295D': exports.MO.RELSTRETCH,
            '\u295E': exports.MO.WIDEREL,
            '\u295F': exports.MO.WIDEREL,
            '\u2960': exports.MO.RELSTRETCH,
            '\u2961': exports.MO.RELSTRETCH,
            '\u2962': exports.MO.RELACCENT,
            '\u2963': exports.MO.REL,
            '\u2964': exports.MO.RELACCENT,
            '\u2965': exports.MO.REL,
            '\u2966': exports.MO.RELACCENT,
            '\u2967': exports.MO.RELACCENT,
            '\u2968': exports.MO.RELACCENT,
            '\u2969': exports.MO.RELACCENT,
            '\u296A': exports.MO.RELACCENT,
            '\u296B': exports.MO.RELACCENT,
            '\u296C': exports.MO.RELACCENT,
            '\u296D': exports.MO.RELACCENT,
            '\u296E': exports.MO.RELSTRETCH,
            '\u296F': exports.MO.RELSTRETCH,
            '\u2970': exports.MO.RELACCENT,
            '\u2971': exports.MO.RELACCENT,
            '\u2972': exports.MO.RELACCENT,
            '\u2973': exports.MO.RELACCENT,
            '\u2974': exports.MO.RELACCENT,
            '\u2975': exports.MO.RELACCENT,
            '\u2976': exports.MO.RELACCENT,
            '\u2977': exports.MO.RELACCENT,
            '\u2978': exports.MO.RELACCENT,
            '\u2979': exports.MO.RELACCENT,
            '\u297A': exports.MO.RELACCENT,
            '\u297B': exports.MO.RELACCENT,
            '\u297C': exports.MO.RELACCENT,
            '\u297D': exports.MO.RELACCENT,
            '\u297E': exports.MO.REL,
            '\u297F': exports.MO.REL,
            '\u2981': exports.MO.BIN3,
            '\u2982': exports.MO.BIN3,
            '\u2999': exports.MO.BIN3,
            '\u299A': exports.MO.BIN3,
            '\u299B': exports.MO.BIN3,
            '\u299C': exports.MO.BIN3,
            '\u299D': exports.MO.BIN3,
            '\u299E': exports.MO.BIN3,
            '\u299F': exports.MO.BIN3,
            '\u29A0': exports.MO.BIN3,
            '\u29A1': exports.MO.BIN3,
            '\u29A2': exports.MO.BIN3,
            '\u29A3': exports.MO.BIN3,
            '\u29A4': exports.MO.BIN3,
            '\u29A5': exports.MO.BIN3,
            '\u29A6': exports.MO.BIN3,
            '\u29A7': exports.MO.BIN3,
            '\u29A8': exports.MO.BIN3,
            '\u29A9': exports.MO.BIN3,
            '\u29AA': exports.MO.BIN3,
            '\u29AB': exports.MO.BIN3,
            '\u29AC': exports.MO.BIN3,
            '\u29AD': exports.MO.BIN3,
            '\u29AE': exports.MO.BIN3,
            '\u29AF': exports.MO.BIN3,
            '\u29B0': exports.MO.BIN3,
            '\u29B1': exports.MO.BIN3,
            '\u29B2': exports.MO.BIN3,
            '\u29B3': exports.MO.BIN3,
            '\u29B4': exports.MO.BIN3,
            '\u29B5': exports.MO.BIN3,
            '\u29B6': exports.MO.BIN4,
            '\u29B7': exports.MO.BIN4,
            '\u29B8': exports.MO.BIN4,
            '\u29B9': exports.MO.BIN4,
            '\u29BA': exports.MO.BIN4,
            '\u29BB': exports.MO.BIN4,
            '\u29BC': exports.MO.BIN4,
            '\u29BD': exports.MO.BIN4,
            '\u29BE': exports.MO.BIN4,
            '\u29BF': exports.MO.BIN4,
            '\u29C0': exports.MO.REL,
            '\u29C1': exports.MO.REL,
            '\u29C2': exports.MO.BIN3,
            '\u29C3': exports.MO.BIN3,
            '\u29C4': exports.MO.BIN4,
            '\u29C5': exports.MO.BIN4,
            '\u29C6': exports.MO.BIN4,
            '\u29C7': exports.MO.BIN4,
            '\u29C8': exports.MO.BIN4,
            '\u29C9': exports.MO.BIN3,
            '\u29CA': exports.MO.BIN3,
            '\u29CB': exports.MO.BIN3,
            '\u29CC': exports.MO.BIN3,
            '\u29CD': exports.MO.BIN3,
            '\u29CE': exports.MO.REL,
            '\u29CF': exports.MO.REL,
            '\u29CF\u0338': exports.MO.REL,
            '\u29D0': exports.MO.REL,
            '\u29D0\u0338': exports.MO.REL,
            '\u29D1': exports.MO.REL,
            '\u29D2': exports.MO.REL,
            '\u29D3': exports.MO.REL,
            '\u29D4': exports.MO.REL,
            '\u29D5': exports.MO.REL,
            '\u29D6': exports.MO.BIN4,
            '\u29D7': exports.MO.BIN4,
            '\u29D8': exports.MO.BIN3,
            '\u29D9': exports.MO.BIN3,
            '\u29DB': exports.MO.BIN3,
            '\u29DC': exports.MO.BIN3,
            '\u29DD': exports.MO.BIN3,
            '\u29DE': exports.MO.REL,
            '\u29DF': exports.MO.BIN3,
            '\u29E0': exports.MO.BIN3,
            '\u29E1': exports.MO.REL,
            '\u29E2': exports.MO.BIN4,
            '\u29E3': exports.MO.REL,
            '\u29E4': exports.MO.REL,
            '\u29E5': exports.MO.REL,
            '\u29E6': exports.MO.REL,
            '\u29E7': exports.MO.BIN3,
            '\u29E8': exports.MO.BIN3,
            '\u29E9': exports.MO.BIN3,
            '\u29EA': exports.MO.BIN3,
            '\u29EB': exports.MO.BIN3,
            '\u29EC': exports.MO.BIN3,
            '\u29ED': exports.MO.BIN3,
            '\u29EE': exports.MO.BIN3,
            '\u29EF': exports.MO.BIN3,
            '\u29F0': exports.MO.BIN3,
            '\u29F1': exports.MO.BIN3,
            '\u29F2': exports.MO.BIN3,
            '\u29F3': exports.MO.BIN3,
            '\u29F4': exports.MO.REL,
            '\u29F5': exports.MO.BIN4,
            '\u29F6': exports.MO.BIN4,
            '\u29F7': exports.MO.BIN4,
            '\u29F8': exports.MO.BIN3,
            '\u29F9': exports.MO.BIN3,
            '\u29FA': exports.MO.BIN3,
            '\u29FB': exports.MO.BIN3,
            '\u29FE': exports.MO.BIN4,
            '\u29FF': exports.MO.BIN4,
            '\u2A1D': exports.MO.BIN3,
            '\u2A1E': exports.MO.BIN3,
            '\u2A1F': exports.MO.BIN3,
            '\u2A20': exports.MO.BIN3,
            '\u2A21': exports.MO.BIN3,
            '\u2A22': exports.MO.BIN4,
            '\u2A23': exports.MO.BIN4,
            '\u2A24': exports.MO.BIN4,
            '\u2A25': exports.MO.BIN4,
            '\u2A26': exports.MO.BIN4,
            '\u2A27': exports.MO.BIN4,
            '\u2A28': exports.MO.BIN4,
            '\u2A29': exports.MO.BIN4,
            '\u2A2A': exports.MO.BIN4,
            '\u2A2B': exports.MO.BIN4,
            '\u2A2C': exports.MO.BIN4,
            '\u2A2D': exports.MO.BIN4,
            '\u2A2E': exports.MO.BIN4,
            '\u2A2F': exports.MO.BIN4,
            '\u2A30': exports.MO.BIN4,
            '\u2A31': exports.MO.BIN4,
            '\u2A32': exports.MO.BIN4,
            '\u2A33': exports.MO.BIN4,
            '\u2A34': exports.MO.BIN4,
            '\u2A35': exports.MO.BIN4,
            '\u2A36': exports.MO.BIN4,
            '\u2A37': exports.MO.BIN4,
            '\u2A38': exports.MO.BIN4,
            '\u2A39': exports.MO.BIN4,
            '\u2A3A': exports.MO.BIN4,
            '\u2A3B': exports.MO.BIN4,
            '\u2A3C': exports.MO.BIN4,
            '\u2A3D': exports.MO.BIN4,
            '\u2A3E': exports.MO.BIN4,
            '\u2A3F': exports.MO.BIN4,
            '\u2A40': exports.MO.BIN4,
            '\u2A41': exports.MO.BIN4,
            '\u2A42': exports.MO.BIN4,
            '\u2A43': exports.MO.BIN4,
            '\u2A44': exports.MO.BIN4,
            '\u2A45': exports.MO.BIN4,
            '\u2A46': exports.MO.BIN4,
            '\u2A47': exports.MO.BIN4,
            '\u2A48': exports.MO.BIN4,
            '\u2A49': exports.MO.BIN4,
            '\u2A4A': exports.MO.BIN4,
            '\u2A4B': exports.MO.BIN4,
            '\u2A4C': exports.MO.BIN4,
            '\u2A4D': exports.MO.BIN4,
            '\u2A4E': exports.MO.BIN4,
            '\u2A4F': exports.MO.BIN4,
            '\u2A50': exports.MO.BIN4,
            '\u2A51': exports.MO.BIN4,
            '\u2A52': exports.MO.BIN4,
            '\u2A53': exports.MO.BIN4,
            '\u2A54': exports.MO.BIN4,
            '\u2A55': exports.MO.BIN4,
            '\u2A56': exports.MO.BIN4,
            '\u2A57': exports.MO.BIN4,
            '\u2A58': exports.MO.BIN4,
            '\u2A59': exports.MO.REL,
            '\u2A5A': exports.MO.BIN4,
            '\u2A5B': exports.MO.BIN4,
            '\u2A5C': exports.MO.BIN4,
            '\u2A5D': exports.MO.BIN4,
            '\u2A5E': exports.MO.BIN4,
            '\u2A5F': exports.MO.BIN4,
            '\u2A60': exports.MO.BIN4,
            '\u2A61': exports.MO.BIN4,
            '\u2A62': exports.MO.BIN4,
            '\u2A63': exports.MO.BIN4,
            '\u2A64': exports.MO.BIN4,
            '\u2A65': exports.MO.BIN4,
            '\u2A66': exports.MO.REL,
            '\u2A67': exports.MO.REL,
            '\u2A68': exports.MO.REL,
            '\u2A69': exports.MO.REL,
            '\u2A6A': exports.MO.REL,
            '\u2A6B': exports.MO.REL,
            '\u2A6C': exports.MO.REL,
            '\u2A6D': exports.MO.REL,
            '\u2A6E': exports.MO.REL,
            '\u2A6F': exports.MO.REL,
            '\u2A70': exports.MO.REL,
            '\u2A71': exports.MO.BIN4,
            '\u2A72': exports.MO.BIN4,
            '\u2A73': exports.MO.REL,
            '\u2A74': exports.MO.REL,
            '\u2A75': exports.MO.REL,
            '\u2A76': exports.MO.REL,
            '\u2A77': exports.MO.REL,
            '\u2A78': exports.MO.REL,
            '\u2A79': exports.MO.REL,
            '\u2A7A': exports.MO.REL,
            '\u2A7B': exports.MO.REL,
            '\u2A7C': exports.MO.REL,
            '\u2A7D': exports.MO.REL,
            '\u2A7D\u0338': exports.MO.REL,
            '\u2A7E': exports.MO.REL,
            '\u2A7E\u0338': exports.MO.REL,
            '\u2A7F': exports.MO.REL,
            '\u2A80': exports.MO.REL,
            '\u2A81': exports.MO.REL,
            '\u2A82': exports.MO.REL,
            '\u2A83': exports.MO.REL,
            '\u2A84': exports.MO.REL,
            '\u2A85': exports.MO.REL,
            '\u2A86': exports.MO.REL,
            '\u2A87': exports.MO.REL,
            '\u2A88': exports.MO.REL,
            '\u2A89': exports.MO.REL,
            '\u2A8A': exports.MO.REL,
            '\u2A8B': exports.MO.REL,
            '\u2A8C': exports.MO.REL,
            '\u2A8D': exports.MO.REL,
            '\u2A8E': exports.MO.REL,
            '\u2A8F': exports.MO.REL,
            '\u2A90': exports.MO.REL,
            '\u2A91': exports.MO.REL,
            '\u2A92': exports.MO.REL,
            '\u2A93': exports.MO.REL,
            '\u2A94': exports.MO.REL,
            '\u2A95': exports.MO.REL,
            '\u2A96': exports.MO.REL,
            '\u2A97': exports.MO.REL,
            '\u2A98': exports.MO.REL,
            '\u2A99': exports.MO.REL,
            '\u2A9A': exports.MO.REL,
            '\u2A9B': exports.MO.REL,
            '\u2A9C': exports.MO.REL,
            '\u2A9D': exports.MO.REL,
            '\u2A9E': exports.MO.REL,
            '\u2A9F': exports.MO.REL,
            '\u2AA0': exports.MO.REL,
            '\u2AA1': exports.MO.REL,
            '\u2AA1\u0338': exports.MO.REL,
            '\u2AA2': exports.MO.REL,
            '\u2AA2\u0338': exports.MO.REL,
            '\u2AA3': exports.MO.REL,
            '\u2AA4': exports.MO.REL,
            '\u2AA5': exports.MO.REL,
            '\u2AA6': exports.MO.REL,
            '\u2AA7': exports.MO.REL,
            '\u2AA8': exports.MO.REL,
            '\u2AA9': exports.MO.REL,
            '\u2AAA': exports.MO.REL,
            '\u2AAB': exports.MO.REL,
            '\u2AAC': exports.MO.REL,
            '\u2AAD': exports.MO.REL,
            '\u2AAE': exports.MO.REL,
            '\u2AAF': exports.MO.REL,
            '\u2AAF\u0338': exports.MO.REL,
            '\u2AB0': exports.MO.REL,
            '\u2AB0\u0338': exports.MO.REL,
            '\u2AB1': exports.MO.REL,
            '\u2AB2': exports.MO.REL,
            '\u2AB3': exports.MO.REL,
            '\u2AB4': exports.MO.REL,
            '\u2AB5': exports.MO.REL,
            '\u2AB6': exports.MO.REL,
            '\u2AB7': exports.MO.REL,
            '\u2AB8': exports.MO.REL,
            '\u2AB9': exports.MO.REL,
            '\u2ABA': exports.MO.REL,
            '\u2ABB': exports.MO.REL,
            '\u2ABC': exports.MO.REL,
            '\u2ABD': exports.MO.REL,
            '\u2ABE': exports.MO.REL,
            '\u2ABF': exports.MO.REL,
            '\u2AC0': exports.MO.REL,
            '\u2AC1': exports.MO.REL,
            '\u2AC2': exports.MO.REL,
            '\u2AC3': exports.MO.REL,
            '\u2AC4': exports.MO.REL,
            '\u2AC5': exports.MO.REL,
            '\u2AC6': exports.MO.REL,
            '\u2AC7': exports.MO.REL,
            '\u2AC8': exports.MO.REL,
            '\u2AC9': exports.MO.REL,
            '\u2ACA': exports.MO.REL,
            '\u2ACB': exports.MO.REL,
            '\u2ACC': exports.MO.REL,
            '\u2ACD': exports.MO.REL,
            '\u2ACE': exports.MO.REL,
            '\u2ACF': exports.MO.REL,
            '\u2AD0': exports.MO.REL,
            '\u2AD1': exports.MO.REL,
            '\u2AD2': exports.MO.REL,
            '\u2AD3': exports.MO.REL,
            '\u2AD4': exports.MO.REL,
            '\u2AD5': exports.MO.REL,
            '\u2AD6': exports.MO.REL,
            '\u2AD7': exports.MO.REL,
            '\u2AD8': exports.MO.REL,
            '\u2AD9': exports.MO.REL,
            '\u2ADA': exports.MO.REL,
            '\u2ADB': exports.MO.REL,
            '\u2ADD': exports.MO.REL,
            '\u2ADD\u0338': exports.MO.REL,
            '\u2ADE': exports.MO.REL,
            '\u2ADF': exports.MO.REL,
            '\u2AE0': exports.MO.REL,
            '\u2AE1': exports.MO.REL,
            '\u2AE2': exports.MO.REL,
            '\u2AE3': exports.MO.REL,
            '\u2AE4': exports.MO.REL,
            '\u2AE5': exports.MO.REL,
            '\u2AE6': exports.MO.REL,
            '\u2AE7': exports.MO.REL,
            '\u2AE8': exports.MO.REL,
            '\u2AE9': exports.MO.REL,
            '\u2AEA': exports.MO.REL,
            '\u2AEB': exports.MO.REL,
            '\u2AEC': exports.MO.REL,
            '\u2AED': exports.MO.REL,
            '\u2AEE': exports.MO.REL,
            '\u2AEF': exports.MO.REL,
            '\u2AF0': exports.MO.REL,
            '\u2AF1': exports.MO.REL,
            '\u2AF2': exports.MO.REL,
            '\u2AF3': exports.MO.REL,
            '\u2AF4': exports.MO.BIN4,
            '\u2AF5': exports.MO.BIN4,
            '\u2AF6': exports.MO.BIN4,
            '\u2AF7': exports.MO.REL,
            '\u2AF8': exports.MO.REL,
            '\u2AF9': exports.MO.REL,
            '\u2AFA': exports.MO.REL,
            '\u2AFB': exports.MO.BIN4,
            '\u2AFD': exports.MO.BIN4,
            '\u2AFE': exports.MO.BIN3,
            '\u2B45': exports.MO.RELSTRETCH,
            '\u2B46': exports.MO.RELSTRETCH,
            '\u3008': exports.MO.OPEN,
            '\u3009': exports.MO.CLOSE,
            '\uFE37': exports.MO.WIDEACCENT,
            '\uFE38': exports.MO.WIDEACCENT,
        }
    };
    exports.OPTABLE.infix['^'] = exports.MO.WIDEREL;
    exports.OPTABLE.infix['_'] = exports.MO.WIDEREL;
    exports.OPTABLE.infix['\u2ADC'] = exports.MO.REL;
},
645: /* mathjax-full/js/input/tex/TexParser.js */ function _(require, module, exports, __esModule, __esExport) {
    var __values = (this && this.__values) || function (o) {
        var s = typeof Symbol === "function" && Symbol.iterator, m = s && o[s], i = 0;
        if (m)
            return m.call(o);
        if (o && typeof o.length === "number")
            return {
                next: function () {
                    if (o && i >= o.length)
                        o = void 0;
                    return { value: o && o[i++], done: !o };
                }
            };
        throw new TypeError(s ? "Object is not iterable." : "Symbol.iterator is not defined.");
    };
    var __read = (this && this.__read) || function (o, n) {
        var m = typeof Symbol === "function" && o[Symbol.iterator];
        if (!m)
            return o;
        var i = m.call(o), r, ar = [], e;
        try {
            while ((n === void 0 || n-- > 0) && !(r = i.next()).done)
                ar.push(r.value);
        }
        catch (error) {
            e = { error: error };
        }
        finally {
            try {
                if (r && !r.done && (m = i["return"]))
                    m.call(i);
            }
            finally {
                if (e)
                    throw e.error;
            }
        }
        return ar;
    };
    var __spreadArray = (this && this.__spreadArray) || function (to, from, pack) {
        if (pack || arguments.length === 2)
            for (var i = 0, l = from.length, ar; i < l; i++) {
                if (ar || !(i in from)) {
                    if (!ar)
                        ar = Array.prototype.slice.call(from, 0, i);
                    ar[i] = from[i];
                }
            }
        return to.concat(ar || Array.prototype.slice.call(from));
    };
    var __importDefault = (this && this.__importDefault) || function (mod) {
        return (mod && mod.__esModule) ? mod : { "default": mod };
    };
    __esModule();
    var ParseUtil_js_1 = __importDefault(require(646) /* ./ParseUtil.js */);
    var Stack_js_1 = __importDefault(require(650) /* ./Stack.js */);
    var TexError_js_1 = __importDefault(require(647) /* ./TexError.js */);
    var MmlNode_js_1 = require(639) /* ../../core/MmlTree/MmlNode.js */;
    var TexParser = (function () {
        function TexParser(_string, env, configuration) {
            var e_1, _a;
            this._string = _string;
            this.configuration = configuration;
            this.macroCount = 0;
            this.i = 0;
            this.currentCS = '';
            var inner = env.hasOwnProperty('isInner');
            var isInner = env['isInner'];
            delete env['isInner'];
            var ENV;
            if (env) {
                ENV = {};
                try {
                    for (var _b = __values(Object.keys(env)), _c = _b.next(); !_c.done; _c = _b.next()) {
                        var id = _c.value;
                        ENV[id] = env[id];
                    }
                }
                catch (e_1_1) {
                    e_1 = { error: e_1_1 };
                }
                finally {
                    try {
                        if (_c && !_c.done && (_a = _b.return))
                            _a.call(_b);
                    }
                    finally {
                        if (e_1)
                            throw e_1.error;
                    }
                }
            }
            this.configuration.pushParser(this);
            this.stack = new Stack_js_1.default(this.itemFactory, ENV, inner ? isInner : true);
            this.Parse();
            this.Push(this.itemFactory.create('stop'));
        }
        Object.defineProperty(TexParser.prototype, "options", {
            get: function () {
                return this.configuration.options;
            },
            enumerable: false,
            configurable: true
        });
        Object.defineProperty(TexParser.prototype, "itemFactory", {
            get: function () {
                return this.configuration.itemFactory;
            },
            enumerable: false,
            configurable: true
        });
        Object.defineProperty(TexParser.prototype, "tags", {
            get: function () {
                return this.configuration.tags;
            },
            enumerable: false,
            configurable: true
        });
        Object.defineProperty(TexParser.prototype, "string", {
            get: function () {
                return this._string;
            },
            set: function (str) {
                this._string = str;
            },
            enumerable: false,
            configurable: true
        });
        TexParser.prototype.parse = function (kind, input) {
            return this.configuration.handlers.get(kind).parse(input);
        };
        TexParser.prototype.lookup = function (kind, symbol) {
            return this.configuration.handlers.get(kind).lookup(symbol);
        };
        TexParser.prototype.contains = function (kind, symbol) {
            return this.configuration.handlers.get(kind).contains(symbol);
        };
        TexParser.prototype.toString = function () {
            var e_2, _a;
            var str = '';
            try {
                for (var _b = __values(Array.from(this.configuration.handlers.keys())), _c = _b.next(); !_c.done; _c = _b.next()) {
                    var config = _c.value;
                    str += config + ': ' +
                        this.configuration.handlers.get(config) + '\n';
                }
            }
            catch (e_2_1) {
                e_2 = { error: e_2_1 };
            }
            finally {
                try {
                    if (_c && !_c.done && (_a = _b.return))
                        _a.call(_b);
                }
                finally {
                    if (e_2)
                        throw e_2.error;
                }
            }
            return str;
        };
        TexParser.prototype.Parse = function () {
            var c;
            while (this.i < this.string.length) {
                c = this.getCodePoint();
                this.i += c.length;
                this.parse('character', [this, c]);
            }
        };
        TexParser.prototype.Push = function (arg) {
            if (arg instanceof MmlNode_js_1.AbstractMmlNode && arg.isInferred) {
                this.PushAll(arg.childNodes);
            }
            else {
                this.stack.Push(arg);
            }
        };
        TexParser.prototype.PushAll = function (args) {
            var e_3, _a;
            try {
                for (var args_1 = __values(args), args_1_1 = args_1.next(); !args_1_1.done; args_1_1 = args_1.next()) {
                    var arg = args_1_1.value;
                    this.stack.Push(arg);
                }
            }
            catch (e_3_1) {
                e_3 = { error: e_3_1 };
            }
            finally {
                try {
                    if (args_1_1 && !args_1_1.done && (_a = args_1.return))
                        _a.call(args_1);
                }
                finally {
                    if (e_3)
                        throw e_3.error;
                }
            }
        };
        TexParser.prototype.mml = function () {
            if (!this.stack.Top().isKind('mml')) {
                return null;
            }
            var node = this.stack.Top().First;
            this.configuration.popParser();
            return node;
        };
        TexParser.prototype.convertDelimiter = function (c) {
            var symbol = this.lookup('delimiter', c);
            return symbol ? symbol.char : null;
        };
        TexParser.prototype.getCodePoint = function () {
            var code = this.string.codePointAt(this.i);
            return code === undefined ? '' : String.fromCodePoint(code);
        };
        TexParser.prototype.nextIsSpace = function () {
            return !!this.string.charAt(this.i).match(/\s/);
        };
        TexParser.prototype.GetNext = function () {
            while (this.nextIsSpace()) {
                this.i++;
            }
            return this.getCodePoint();
        };
        TexParser.prototype.GetCS = function () {
            var CS = this.string.slice(this.i).match(/^(([a-z]+) ?|[\uD800-\uDBFF].|.)/i);
            if (CS) {
                this.i += CS[0].length;
                return CS[2] || CS[1];
            }
            else {
                this.i++;
                return ' ';
            }
        };
        TexParser.prototype.GetArgument = function (_name, noneOK) {
            switch (this.GetNext()) {
                case '':
                    if (!noneOK) {
                        throw new TexError_js_1.default('MissingArgFor', 'Missing argument for %1', this.currentCS);
                    }
                    return null;
                case '}':
                    if (!noneOK) {
                        throw new TexError_js_1.default('ExtraCloseMissingOpen', 'Extra close brace or missing open brace');
                    }
                    return null;
                case '\\':
                    this.i++;
                    return '\\' + this.GetCS();
                case '{':
                    var j = ++this.i, parens = 1;
                    while (this.i < this.string.length) {
                        switch (this.string.charAt(this.i++)) {
                            case '\\':
                                this.i++;
                                break;
                            case '{':
                                parens++;
                                break;
                            case '}':
                                if (--parens === 0) {
                                    return this.string.slice(j, this.i - 1);
                                }
                                break;
                        }
                    }
                    throw new TexError_js_1.default('MissingCloseBrace', 'Missing close brace');
            }
            var c = this.getCodePoint();
            this.i += c.length;
            return c;
        };
        TexParser.prototype.GetBrackets = function (_name, def) {
            if (this.GetNext() !== '[') {
                return def;
            }
            var j = ++this.i, parens = 0;
            while (this.i < this.string.length) {
                switch (this.string.charAt(this.i++)) {
                    case '{':
                        parens++;
                        break;
                    case '\\':
                        this.i++;
                        break;
                    case '}':
                        if (parens-- <= 0) {
                            throw new TexError_js_1.default('ExtraCloseLooking', 'Extra close brace while looking for %1', '\']\'');
                        }
                        break;
                    case ']':
                        if (parens === 0) {
                            return this.string.slice(j, this.i - 1);
                        }
                        break;
                }
            }
            throw new TexError_js_1.default('MissingCloseBracket', 'Could not find closing \']\' for argument to %1', this.currentCS);
        };
        TexParser.prototype.GetDelimiter = function (name, braceOK) {
            var c = this.GetNext();
            this.i += c.length;
            if (this.i <= this.string.length) {
                if (c === '\\') {
                    c += this.GetCS();
                }
                else if (c === '{' && braceOK) {
                    this.i--;
                    c = this.GetArgument(name).trim();
                }
                if (this.contains('delimiter', c)) {
                    return this.convertDelimiter(c);
                }
            }
            throw new TexError_js_1.default('MissingOrUnrecognizedDelim', 'Missing or unrecognized delimiter for %1', this.currentCS);
        };
        TexParser.prototype.GetDimen = function (name) {
            if (this.GetNext() === '{') {
                var dimen = this.GetArgument(name);
                var _a = __read(ParseUtil_js_1.default.matchDimen(dimen), 2), value = _a[0], unit = _a[1];
                if (value) {
                    return value + unit;
                }
            }
            else {
                var dimen = this.string.slice(this.i);
                var _b = __read(ParseUtil_js_1.default.matchDimen(dimen, true), 3), value = _b[0], unit = _b[1], length_1 = _b[2];
                if (value) {
                    this.i += length_1;
                    return value + unit;
                }
            }
            throw new TexError_js_1.default('MissingDimOrUnits', 'Missing dimension or its units for %1', this.currentCS);
        };
        TexParser.prototype.GetUpTo = function (_name, token) {
            while (this.nextIsSpace()) {
                this.i++;
            }
            var j = this.i;
            var parens = 0;
            while (this.i < this.string.length) {
                var k = this.i;
                var c = this.GetNext();
                this.i += c.length;
                switch (c) {
                    case '\\':
                        c += this.GetCS();
                        break;
                    case '{':
                        parens++;
                        break;
                    case '}':
                        if (parens === 0) {
                            throw new TexError_js_1.default('ExtraCloseLooking', 'Extra close brace while looking for %1', token);
                        }
                        parens--;
                        break;
                }
                if (parens === 0 && c === token) {
                    return this.string.slice(j, k);
                }
            }
            throw new TexError_js_1.default('TokenNotFoundForCommand', 'Could not find %1 for %2', token, this.currentCS);
        };
        TexParser.prototype.ParseArg = function (name) {
            return new TexParser(this.GetArgument(name), this.stack.env, this.configuration).mml();
        };
        TexParser.prototype.ParseUpTo = function (name, token) {
            return new TexParser(this.GetUpTo(name, token), this.stack.env, this.configuration).mml();
        };
        TexParser.prototype.GetDelimiterArg = function (name) {
            var c = ParseUtil_js_1.default.trimSpaces(this.GetArgument(name));
            if (c === '') {
                return null;
            }
            if (this.contains('delimiter', c)) {
                return c;
            }
            throw new TexError_js_1.default('MissingOrUnrecognizedDelim', 'Missing or unrecognized delimiter for %1', this.currentCS);
        };
        TexParser.prototype.GetStar = function () {
            var star = (this.GetNext() === '*');
            if (star) {
                this.i++;
            }
            return star;
        };
        TexParser.prototype.create = function (kind) {
            var _a;
            var rest = [];
            for (var _i = 1; _i < arguments.length; _i++) {
                rest[_i - 1] = arguments[_i];
            }
            return (_a = this.configuration.nodeFactory).create.apply(_a, __spreadArray([kind], __read(rest), false));
        };
        return TexParser;
    }());
    exports.default = TexParser;
},
646: /* mathjax-full/js/input/tex/ParseUtil.js */ function _(require, module, exports, __esModule, __esExport) {
    var __read = (this && this.__read) || function (o, n) {
        var m = typeof Symbol === "function" && o[Symbol.iterator];
        if (!m)
            return o;
        var i = m.call(o), r, ar = [], e;
        try {
            while ((n === void 0 || n-- > 0) && !(r = i.next()).done)
                ar.push(r.value);
        }
        catch (error) {
            e = { error: error };
        }
        finally {
            try {
                if (r && !r.done && (m = i["return"]))
                    m.call(i);
            }
            finally {
                if (e)
                    throw e.error;
            }
        }
        return ar;
    };
    var __values = (this && this.__values) || function (o) {
        var s = typeof Symbol === "function" && Symbol.iterator, m = s && o[s], i = 0;
        if (m)
            return m.call(o);
        if (o && typeof o.length === "number")
            return {
                next: function () {
                    if (o && i >= o.length)
                        o = void 0;
                    return { value: o && o[i++], done: !o };
                }
            };
        throw new TypeError(s ? "Object is not iterable." : "Symbol.iterator is not defined.");
    };
    var __importDefault = (this && this.__importDefault) || function (mod) {
        return (mod && mod.__esModule) ? mod : { "default": mod };
    };
    __esModule();
    var MmlNode_js_1 = require(639) /* ../../core/MmlTree/MmlNode.js */;
    var NodeUtil_js_1 = __importDefault(require(642) /* ./NodeUtil.js */);
    var TexParser_js_1 = __importDefault(require(645) /* ./TexParser.js */);
    var TexError_js_1 = __importDefault(require(647) /* ./TexError.js */);
    var Entities_js_1 = require(648) /* ../../util/Entities.js */;
    var ParseUtil;
    (function (ParseUtil) {
        var emPerInch = 7.2;
        var pxPerInch = 72;
        var UNIT_CASES = {
            'em': function (m) { return m; },
            'ex': function (m) { return m * .43; },
            'pt': function (m) { return m / 10; },
            'pc': function (m) { return m * 1.2; },
            'px': function (m) { return m * emPerInch / pxPerInch; },
            'in': function (m) { return m * emPerInch; },
            'cm': function (m) { return m * emPerInch / 2.54; },
            'mm': function (m) { return m * emPerInch / 25.4; },
            'mu': function (m) { return m / 18; },
        };
        var num = '([-+]?([.,]\\d+|\\d+([.,]\\d*)?))';
        var unit = '(pt|em|ex|mu|px|mm|cm|in|pc)';
        var dimenEnd = RegExp('^\\s*' + num + '\\s*' + unit + '\\s*$');
        var dimenRest = RegExp('^\\s*' + num + '\\s*' + unit + ' ?');
        function matchDimen(dim, rest) {
            if (rest === void 0) {
                rest = false;
            }
            var match = dim.match(rest ? dimenRest : dimenEnd);
            return match ?
                muReplace([match[1].replace(/,/, '.'), match[4], match[0].length]) :
                [null, null, 0];
        }
        ParseUtil.matchDimen = matchDimen;
        function muReplace(_a) {
            var _b = __read(_a, 3), value = _b[0], unit = _b[1], length = _b[2];
            if (unit !== 'mu') {
                return [value, unit, length];
            }
            var em = Em(UNIT_CASES[unit](parseFloat(value || '1')));
            return [em.slice(0, -2), 'em', length];
        }
        function dimen2em(dim) {
            var _a = __read(matchDimen(dim), 2), value = _a[0], unit = _a[1];
            var m = parseFloat(value || '1');
            var func = UNIT_CASES[unit];
            return func ? func(m) : 0;
        }
        ParseUtil.dimen2em = dimen2em;
        function Em(m) {
            if (Math.abs(m) < .0006) {
                return '0em';
            }
            return m.toFixed(3).replace(/\.?0+$/, '') + 'em';
        }
        ParseUtil.Em = Em;
        function cols() {
            var W = [];
            for (var _i = 0; _i < arguments.length; _i++) {
                W[_i] = arguments[_i];
            }
            return W.map(function (n) { return Em(n); }).join(' ');
        }
        ParseUtil.cols = cols;
        function fenced(configuration, open, mml, close, big, color) {
            if (big === void 0) {
                big = '';
            }
            if (color === void 0) {
                color = '';
            }
            var nf = configuration.nodeFactory;
            var mrow = nf.create('node', 'mrow', [], { open: open, close: close, texClass: MmlNode_js_1.TEXCLASS.INNER });
            var mo;
            if (big) {
                mo = new TexParser_js_1.default('\\' + big + 'l' + open, configuration.parser.stack.env, configuration).mml();
            }
            else {
                var openNode = nf.create('text', open);
                mo = nf.create('node', 'mo', [], { fence: true, stretchy: true, symmetric: true, texClass: MmlNode_js_1.TEXCLASS.OPEN }, openNode);
            }
            NodeUtil_js_1.default.appendChildren(mrow, [mo, mml]);
            if (big) {
                mo = new TexParser_js_1.default('\\' + big + 'r' + close, configuration.parser.stack.env, configuration).mml();
            }
            else {
                var closeNode = nf.create('text', close);
                mo = nf.create('node', 'mo', [], { fence: true, stretchy: true, symmetric: true, texClass: MmlNode_js_1.TEXCLASS.CLOSE }, closeNode);
            }
            color && mo.attributes.set('mathcolor', color);
            NodeUtil_js_1.default.appendChildren(mrow, [mo]);
            return mrow;
        }
        ParseUtil.fenced = fenced;
        function fixedFence(configuration, open, mml, close) {
            var mrow = configuration.nodeFactory.create('node', 'mrow', [], { open: open, close: close, texClass: MmlNode_js_1.TEXCLASS.ORD });
            if (open) {
                NodeUtil_js_1.default.appendChildren(mrow, [mathPalette(configuration, open, 'l')]);
            }
            if (NodeUtil_js_1.default.isType(mml, 'mrow')) {
                NodeUtil_js_1.default.appendChildren(mrow, NodeUtil_js_1.default.getChildren(mml));
            }
            else {
                NodeUtil_js_1.default.appendChildren(mrow, [mml]);
            }
            if (close) {
                NodeUtil_js_1.default.appendChildren(mrow, [mathPalette(configuration, close, 'r')]);
            }
            return mrow;
        }
        ParseUtil.fixedFence = fixedFence;
        function mathPalette(configuration, fence, side) {
            if (fence === '{' || fence === '}') {
                fence = '\\' + fence;
            }
            var D = '{\\bigg' + side + ' ' + fence + '}';
            var T = '{\\big' + side + ' ' + fence + '}';
            return new TexParser_js_1.default('\\mathchoice' + D + T + T + T, {}, configuration).mml();
        }
        ParseUtil.mathPalette = mathPalette;
        function fixInitialMO(configuration, nodes) {
            for (var i = 0, m = nodes.length; i < m; i++) {
                var child = nodes[i];
                if (child && (!NodeUtil_js_1.default.isType(child, 'mspace') &&
                    (!NodeUtil_js_1.default.isType(child, 'TeXAtom') ||
                        (NodeUtil_js_1.default.getChildren(child)[0] &&
                            NodeUtil_js_1.default.getChildren(NodeUtil_js_1.default.getChildren(child)[0]).length)))) {
                    if (NodeUtil_js_1.default.isEmbellished(child) ||
                        (NodeUtil_js_1.default.isType(child, 'TeXAtom') && NodeUtil_js_1.default.getTexClass(child) === MmlNode_js_1.TEXCLASS.REL)) {
                        var mi = configuration.nodeFactory.create('node', 'mi');
                        nodes.unshift(mi);
                    }
                    break;
                }
            }
        }
        ParseUtil.fixInitialMO = fixInitialMO;
        function internalMath(parser, text, level, font) {
            if (parser.configuration.options.internalMath) {
                return parser.configuration.options.internalMath(parser, text, level, font);
            }
            var mathvariant = font || parser.stack.env.font;
            var def = (mathvariant ? { mathvariant: mathvariant } : {});
            var mml = [], i = 0, k = 0, c, node, match = '', braces = 0;
            if (text.match(/\\?[${}\\]|\\\(|\\(eq)?ref\s*\{/)) {
                while (i < text.length) {
                    c = text.charAt(i++);
                    if (c === '$') {
                        if (match === '$' && braces === 0) {
                            node = parser.create('node', 'TeXAtom', [(new TexParser_js_1.default(text.slice(k, i - 1), {}, parser.configuration)).mml()]);
                            mml.push(node);
                            match = '';
                            k = i;
                        }
                        else if (match === '') {
                            if (k < i - 1) {
                                mml.push(internalText(parser, text.slice(k, i - 1), def));
                            }
                            match = '$';
                            k = i;
                        }
                    }
                    else if (c === '{' && match !== '') {
                        braces++;
                    }
                    else if (c === '}') {
                        if (match === '}' && braces === 0) {
                            var atom = (new TexParser_js_1.default(text.slice(k, i), {}, parser.configuration)).mml();
                            node = parser.create('node', 'TeXAtom', [atom], def);
                            mml.push(node);
                            match = '';
                            k = i;
                        }
                        else if (match !== '') {
                            if (braces) {
                                braces--;
                            }
                        }
                    }
                    else if (c === '\\') {
                        if (match === '' && text.substr(i).match(/^(eq)?ref\s*\{/)) {
                            var len = RegExp['$&'].length;
                            if (k < i - 1) {
                                mml.push(internalText(parser, text.slice(k, i - 1), def));
                            }
                            match = '}';
                            k = i - 1;
                            i += len;
                        }
                        else {
                            c = text.charAt(i++);
                            if (c === '(' && match === '') {
                                if (k < i - 2) {
                                    mml.push(internalText(parser, text.slice(k, i - 2), def));
                                }
                                match = ')';
                                k = i;
                            }
                            else if (c === ')' && match === ')' && braces === 0) {
                                node = parser.create('node', 'TeXAtom', [(new TexParser_js_1.default(text.slice(k, i - 2), {}, parser.configuration)).mml()]);
                                mml.push(node);
                                match = '';
                                k = i;
                            }
                            else if (c.match(/[${}\\]/) && match === '') {
                                i--;
                                text = text.substr(0, i - 1) + text.substr(i);
                            }
                        }
                    }
                }
                if (match !== '') {
                    throw new TexError_js_1.default('MathNotTerminated', 'Math not terminated in text box');
                }
            }
            if (k < text.length) {
                mml.push(internalText(parser, text.slice(k), def));
            }
            if (level != null) {
                mml = [parser.create('node', 'mstyle', mml, { displaystyle: false, scriptlevel: level })];
            }
            else if (mml.length > 1) {
                mml = [parser.create('node', 'mrow', mml)];
            }
            return mml;
        }
        ParseUtil.internalMath = internalMath;
        function internalText(parser, text, def) {
            text = text.replace(/^\s+/, Entities_js_1.entities.nbsp).replace(/\s+$/, Entities_js_1.entities.nbsp);
            var textNode = parser.create('text', text);
            return parser.create('node', 'mtext', [], def, textNode);
        }
        ParseUtil.internalText = internalText;
        function underOver(parser, base, script, pos, stack) {
            ParseUtil.checkMovableLimits(base);
            if (NodeUtil_js_1.default.isType(base, 'munderover') && NodeUtil_js_1.default.isEmbellished(base)) {
                NodeUtil_js_1.default.setProperties(NodeUtil_js_1.default.getCoreMO(base), { lspace: 0, rspace: 0 });
                var mo = parser.create('node', 'mo', [], { rspace: 0 });
                base = parser.create('node', 'mrow', [mo, base]);
            }
            var mml = parser.create('node', 'munderover', [base]);
            NodeUtil_js_1.default.setChild(mml, pos === 'over' ? mml.over : mml.under, script);
            var node = mml;
            if (stack) {
                node = parser.create('node', 'TeXAtom', [mml], { texClass: MmlNode_js_1.TEXCLASS.OP, movesupsub: true });
            }
            NodeUtil_js_1.default.setProperty(node, 'subsupOK', true);
            return node;
        }
        ParseUtil.underOver = underOver;
        function checkMovableLimits(base) {
            var symbol = (NodeUtil_js_1.default.isType(base, 'mo') ? NodeUtil_js_1.default.getForm(base) : null);
            if (NodeUtil_js_1.default.getProperty(base, 'movablelimits') || (symbol && symbol[3] && symbol[3].movablelimits)) {
                NodeUtil_js_1.default.setProperties(base, { movablelimits: false });
            }
        }
        ParseUtil.checkMovableLimits = checkMovableLimits;
        function trimSpaces(text) {
            if (typeof (text) !== 'string') {
                return text;
            }
            var TEXT = text.trim();
            if (TEXT.match(/\\$/) && text.match(/ $/)) {
                TEXT += ' ';
            }
            return TEXT;
        }
        ParseUtil.trimSpaces = trimSpaces;
        function setArrayAlign(array, align) {
            align = ParseUtil.trimSpaces(align || '');
            if (align === 't') {
                array.arraydef.align = 'baseline 1';
            }
            else if (align === 'b') {
                array.arraydef.align = 'baseline -1';
            }
            else if (align === 'c') {
                array.arraydef.align = 'axis';
            }
            else if (align) {
                array.arraydef.align = align;
            }
            return array;
        }
        ParseUtil.setArrayAlign = setArrayAlign;
        function substituteArgs(parser, args, str) {
            var text = '';
            var newstring = '';
            var i = 0;
            while (i < str.length) {
                var c = str.charAt(i++);
                if (c === '\\') {
                    text += c + str.charAt(i++);
                }
                else if (c === '#') {
                    c = str.charAt(i++);
                    if (c === '#') {
                        text += c;
                    }
                    else {
                        if (!c.match(/[1-9]/) || parseInt(c, 10) > args.length) {
                            throw new TexError_js_1.default('IllegalMacroParam', 'Illegal macro parameter reference');
                        }
                        newstring = addArgs(parser, addArgs(parser, newstring, text), args[parseInt(c, 10) - 1]);
                        text = '';
                    }
                }
                else {
                    text += c;
                }
            }
            return addArgs(parser, newstring, text);
        }
        ParseUtil.substituteArgs = substituteArgs;
        function addArgs(parser, s1, s2) {
            if (s2.match(/^[a-z]/i) && s1.match(/(^|[^\\])(\\\\)*\\[a-z]+$/i)) {
                s1 += ' ';
            }
            if (s1.length + s2.length > parser.configuration.options['maxBuffer']) {
                throw new TexError_js_1.default('MaxBufferSize', 'MathJax internal buffer size exceeded; is there a' +
                    ' recursive macro call?');
            }
            return s1 + s2;
        }
        ParseUtil.addArgs = addArgs;
        function checkMaxMacros(parser, isMacro) {
            if (isMacro === void 0) {
                isMacro = true;
            }
            if (++parser.macroCount <= parser.configuration.options['maxMacros']) {
                return;
            }
            if (isMacro) {
                throw new TexError_js_1.default('MaxMacroSub1', 'MathJax maximum macro substitution count exceeded; ' +
                    'is here a recursive macro call?');
            }
            else {
                throw new TexError_js_1.default('MaxMacroSub2', 'MathJax maximum substitution count exceeded; ' +
                    'is there a recursive latex environment?');
            }
        }
        ParseUtil.checkMaxMacros = checkMaxMacros;
        function checkEqnEnv(parser) {
            if (parser.stack.global.eqnenv) {
                throw new TexError_js_1.default('ErroneousNestingEq', 'Erroneous nesting of equation structures');
            }
            parser.stack.global.eqnenv = true;
        }
        ParseUtil.checkEqnEnv = checkEqnEnv;
        function copyNode(node, parser) {
            var tree = node.copy();
            var options = parser.configuration;
            tree.walkTree(function (n) {
                var e_1, _a;
                options.addNode(n.kind, n);
                var lists = (n.getProperty('in-lists') || '').split(/,/);
                try {
                    for (var lists_1 = __values(lists), lists_1_1 = lists_1.next(); !lists_1_1.done; lists_1_1 = lists_1.next()) {
                        var list = lists_1_1.value;
                        list && options.addNode(list, n);
                    }
                }
                catch (e_1_1) {
                    e_1 = { error: e_1_1 };
                }
                finally {
                    try {
                        if (lists_1_1 && !lists_1_1.done && (_a = lists_1.return))
                            _a.call(lists_1);
                    }
                    finally {
                        if (e_1)
                            throw e_1.error;
                    }
                }
            });
            return tree;
        }
        ParseUtil.copyNode = copyNode;
        function MmlFilterAttribute(_parser, _name, value) {
            return value;
        }
        ParseUtil.MmlFilterAttribute = MmlFilterAttribute;
        function getFontDef(parser) {
            var font = parser.stack.env['font'];
            return (font ? { mathvariant: font } : {});
        }
        ParseUtil.getFontDef = getFontDef;
        function keyvalOptions(attrib, allowed, error) {
            var e_2, _a;
            if (allowed === void 0) {
                allowed = null;
            }
            if (error === void 0) {
                error = false;
            }
            var def = readKeyval(attrib);
            if (allowed) {
                try {
                    for (var _b = __values(Object.keys(def)), _c = _b.next(); !_c.done; _c = _b.next()) {
                        var key = _c.value;
                        if (!allowed.hasOwnProperty(key)) {
                            if (error) {
                                throw new TexError_js_1.default('InvalidOption', 'Invalid option: %1', key);
                            }
                            delete def[key];
                        }
                    }
                }
                catch (e_2_1) {
                    e_2 = { error: e_2_1 };
                }
                finally {
                    try {
                        if (_c && !_c.done && (_a = _b.return))
                            _a.call(_b);
                    }
                    finally {
                        if (e_2)
                            throw e_2.error;
                    }
                }
            }
            return def;
        }
        ParseUtil.keyvalOptions = keyvalOptions;
        function readKeyval(text) {
            var _a, _b;
            var options = {};
            var rest = text;
            var end, key, val;
            while (rest) {
                _a = __read(readValue(rest, ['=', ',']), 3), key = _a[0], end = _a[1], rest = _a[2];
                if (end === '=') {
                    _b = __read(readValue(rest, [',']), 3), val = _b[0], end = _b[1], rest = _b[2];
                    val = (val === 'false' || val === 'true') ?
                        JSON.parse(val) : val;
                    options[key] = val;
                }
                else if (key) {
                    options[key] = true;
                }
            }
            return options;
        }
        function removeBraces(text, count) {
            while (count > 0) {
                text = text.trim().slice(1, -1);
                count--;
            }
            return text.trim();
        }
        function readValue(text, end) {
            var length = text.length;
            var braces = 0;
            var value = '';
            var index = 0;
            var start = 0;
            var startCount = true;
            var stopCount = false;
            while (index < length) {
                var c = text[index++];
                switch (c) {
                    case ' ':
                        break;
                    case '{':
                        if (startCount) {
                            start++;
                        }
                        else {
                            stopCount = false;
                            if (start > braces) {
                                start = braces;
                            }
                        }
                        braces++;
                        break;
                    case '}':
                        if (braces) {
                            braces--;
                        }
                        if (startCount || stopCount) {
                            start--;
                            stopCount = true;
                        }
                        startCount = false;
                        break;
                    default:
                        if (!braces && end.indexOf(c) !== -1) {
                            return [stopCount ? 'true' :
                                    removeBraces(value, start), c, text.slice(index)];
                        }
                        startCount = false;
                        stopCount = false;
                }
                value += c;
            }
            if (braces) {
                throw new TexError_js_1.default('ExtraOpenMissingClose', 'Extra open brace or missing close brace');
            }
            return [stopCount ? 'true' : removeBraces(value, start), '', text.slice(index)];
        }
    })(ParseUtil || (ParseUtil = {}));
    exports.default = ParseUtil;
},
647: /* mathjax-full/js/input/tex/TexError.js */ function _(require, module, exports, __esModule, __esExport) {
    __esModule();
    var TexError = (function () {
        function TexError(id, message) {
            var rest = [];
            for (var _i = 2; _i < arguments.length; _i++) {
                rest[_i - 2] = arguments[_i];
            }
            this.id = id;
            this.message = TexError.processString(message, rest);
        }
        TexError.processString = function (str, args) {
            var parts = str.split(TexError.pattern);
            for (var i = 1, m = parts.length; i < m; i += 2) {
                var c = parts[i].charAt(0);
                if (c >= '0' && c <= '9') {
                    parts[i] = args[parseInt(parts[i], 10) - 1];
                    if (typeof parts[i] === 'number') {
                        parts[i] = parts[i].toString();
                    }
                }
                else if (c === '{') {
                    c = parts[i].substr(1);
                    if (c >= '0' && c <= '9') {
                        parts[i] = args[parseInt(parts[i].substr(1, parts[i].length - 2), 10) - 1];
                        if (typeof parts[i] === 'number') {
                            parts[i] = parts[i].toString();
                        }
                    }
                    else {
                        var match = parts[i].match(/^\{([a-z]+):%(\d+)\|(.*)\}$/);
                        if (match) {
                            parts[i] = '%' + parts[i];
                        }
                    }
                }
                if (parts[i] == null) {
                    parts[i] = '???';
                }
            }
            return parts.join('');
        };
        TexError.pattern = /%(\d+|\{\d+\}|\{[a-z]+:\%\d+(?:\|(?:%\{\d+\}|%.|[^\}])*)+\}|.)/g;
        return TexError;
    }());
    exports.default = TexError;
},
648: /* mathjax-full/js/util/Entities.js */ function _(require, module, exports, __esModule, __esExport) {
    __esModule();
    var Retries_js_1 = require(629) /* ./Retries.js */;
    var AsyncLoad_js_1 = require(649) /* ./AsyncLoad.js */;
    exports.options = {
        loadMissingEntities: true
    };
    exports.entities = {
        ApplyFunction: '\u2061',
        Backslash: '\u2216',
        Because: '\u2235',
        Breve: '\u02D8',
        Cap: '\u22D2',
        CenterDot: '\u00B7',
        CircleDot: '\u2299',
        CircleMinus: '\u2296',
        CirclePlus: '\u2295',
        CircleTimes: '\u2297',
        Congruent: '\u2261',
        ContourIntegral: '\u222E',
        Coproduct: '\u2210',
        Cross: '\u2A2F',
        Cup: '\u22D3',
        CupCap: '\u224D',
        Dagger: '\u2021',
        Del: '\u2207',
        Delta: '\u0394',
        Diamond: '\u22C4',
        DifferentialD: '\u2146',
        DotEqual: '\u2250',
        DoubleDot: '\u00A8',
        DoubleRightTee: '\u22A8',
        DoubleVerticalBar: '\u2225',
        DownArrow: '\u2193',
        DownLeftVector: '\u21BD',
        DownRightVector: '\u21C1',
        DownTee: '\u22A4',
        Downarrow: '\u21D3',
        Element: '\u2208',
        EqualTilde: '\u2242',
        Equilibrium: '\u21CC',
        Exists: '\u2203',
        ExponentialE: '\u2147',
        FilledVerySmallSquare: '\u25AA',
        ForAll: '\u2200',
        Gamma: '\u0393',
        Gg: '\u22D9',
        GreaterEqual: '\u2265',
        GreaterEqualLess: '\u22DB',
        GreaterFullEqual: '\u2267',
        GreaterLess: '\u2277',
        GreaterSlantEqual: '\u2A7E',
        GreaterTilde: '\u2273',
        Hacek: '\u02C7',
        Hat: '\u005E',
        HumpDownHump: '\u224E',
        HumpEqual: '\u224F',
        Im: '\u2111',
        ImaginaryI: '\u2148',
        Integral: '\u222B',
        Intersection: '\u22C2',
        InvisibleComma: '\u2063',
        InvisibleTimes: '\u2062',
        Lambda: '\u039B',
        Larr: '\u219E',
        LeftAngleBracket: '\u27E8',
        LeftArrow: '\u2190',
        LeftArrowRightArrow: '\u21C6',
        LeftCeiling: '\u2308',
        LeftDownVector: '\u21C3',
        LeftFloor: '\u230A',
        LeftRightArrow: '\u2194',
        LeftTee: '\u22A3',
        LeftTriangle: '\u22B2',
        LeftTriangleEqual: '\u22B4',
        LeftUpVector: '\u21BF',
        LeftVector: '\u21BC',
        Leftarrow: '\u21D0',
        Leftrightarrow: '\u21D4',
        LessEqualGreater: '\u22DA',
        LessFullEqual: '\u2266',
        LessGreater: '\u2276',
        LessSlantEqual: '\u2A7D',
        LessTilde: '\u2272',
        Ll: '\u22D8',
        Lleftarrow: '\u21DA',
        LongLeftArrow: '\u27F5',
        LongLeftRightArrow: '\u27F7',
        LongRightArrow: '\u27F6',
        Longleftarrow: '\u27F8',
        Longleftrightarrow: '\u27FA',
        Longrightarrow: '\u27F9',
        Lsh: '\u21B0',
        MinusPlus: '\u2213',
        NestedGreaterGreater: '\u226B',
        NestedLessLess: '\u226A',
        NotDoubleVerticalBar: '\u2226',
        NotElement: '\u2209',
        NotEqual: '\u2260',
        NotExists: '\u2204',
        NotGreater: '\u226F',
        NotGreaterEqual: '\u2271',
        NotLeftTriangle: '\u22EA',
        NotLeftTriangleEqual: '\u22EC',
        NotLess: '\u226E',
        NotLessEqual: '\u2270',
        NotPrecedes: '\u2280',
        NotPrecedesSlantEqual: '\u22E0',
        NotRightTriangle: '\u22EB',
        NotRightTriangleEqual: '\u22ED',
        NotSubsetEqual: '\u2288',
        NotSucceeds: '\u2281',
        NotSucceedsSlantEqual: '\u22E1',
        NotSupersetEqual: '\u2289',
        NotTilde: '\u2241',
        NotVerticalBar: '\u2224',
        Omega: '\u03A9',
        OverBar: '\u203E',
        OverBrace: '\u23DE',
        PartialD: '\u2202',
        Phi: '\u03A6',
        Pi: '\u03A0',
        PlusMinus: '\u00B1',
        Precedes: '\u227A',
        PrecedesEqual: '\u2AAF',
        PrecedesSlantEqual: '\u227C',
        PrecedesTilde: '\u227E',
        Product: '\u220F',
        Proportional: '\u221D',
        Psi: '\u03A8',
        Rarr: '\u21A0',
        Re: '\u211C',
        ReverseEquilibrium: '\u21CB',
        RightAngleBracket: '\u27E9',
        RightArrow: '\u2192',
        RightArrowLeftArrow: '\u21C4',
        RightCeiling: '\u2309',
        RightDownVector: '\u21C2',
        RightFloor: '\u230B',
        RightTee: '\u22A2',
        RightTeeArrow: '\u21A6',
        RightTriangle: '\u22B3',
        RightTriangleEqual: '\u22B5',
        RightUpVector: '\u21BE',
        RightVector: '\u21C0',
        Rightarrow: '\u21D2',
        Rrightarrow: '\u21DB',
        Rsh: '\u21B1',
        Sigma: '\u03A3',
        SmallCircle: '\u2218',
        Sqrt: '\u221A',
        Square: '\u25A1',
        SquareIntersection: '\u2293',
        SquareSubset: '\u228F',
        SquareSubsetEqual: '\u2291',
        SquareSuperset: '\u2290',
        SquareSupersetEqual: '\u2292',
        SquareUnion: '\u2294',
        Star: '\u22C6',
        Subset: '\u22D0',
        SubsetEqual: '\u2286',
        Succeeds: '\u227B',
        SucceedsEqual: '\u2AB0',
        SucceedsSlantEqual: '\u227D',
        SucceedsTilde: '\u227F',
        SuchThat: '\u220B',
        Sum: '\u2211',
        Superset: '\u2283',
        SupersetEqual: '\u2287',
        Supset: '\u22D1',
        Therefore: '\u2234',
        Theta: '\u0398',
        Tilde: '\u223C',
        TildeEqual: '\u2243',
        TildeFullEqual: '\u2245',
        TildeTilde: '\u2248',
        UnderBar: '\u005F',
        UnderBrace: '\u23DF',
        Union: '\u22C3',
        UnionPlus: '\u228E',
        UpArrow: '\u2191',
        UpDownArrow: '\u2195',
        UpTee: '\u22A5',
        Uparrow: '\u21D1',
        Updownarrow: '\u21D5',
        Upsilon: '\u03A5',
        Vdash: '\u22A9',
        Vee: '\u22C1',
        VerticalBar: '\u2223',
        VerticalTilde: '\u2240',
        Vvdash: '\u22AA',
        Wedge: '\u22C0',
        Xi: '\u039E',
        amp: '\u0026',
        acute: '\u00B4',
        aleph: '\u2135',
        alpha: '\u03B1',
        amalg: '\u2A3F',
        and: '\u2227',
        ang: '\u2220',
        angmsd: '\u2221',
        angsph: '\u2222',
        ape: '\u224A',
        backprime: '\u2035',
        backsim: '\u223D',
        backsimeq: '\u22CD',
        beta: '\u03B2',
        beth: '\u2136',
        between: '\u226C',
        bigcirc: '\u25EF',
        bigodot: '\u2A00',
        bigoplus: '\u2A01',
        bigotimes: '\u2A02',
        bigsqcup: '\u2A06',
        bigstar: '\u2605',
        bigtriangledown: '\u25BD',
        bigtriangleup: '\u25B3',
        biguplus: '\u2A04',
        blacklozenge: '\u29EB',
        blacktriangle: '\u25B4',
        blacktriangledown: '\u25BE',
        blacktriangleleft: '\u25C2',
        bowtie: '\u22C8',
        boxdl: '\u2510',
        boxdr: '\u250C',
        boxminus: '\u229F',
        boxplus: '\u229E',
        boxtimes: '\u22A0',
        boxul: '\u2518',
        boxur: '\u2514',
        bsol: '\u005C',
        bull: '\u2022',
        cap: '\u2229',
        check: '\u2713',
        chi: '\u03C7',
        circ: '\u02C6',
        circeq: '\u2257',
        circlearrowleft: '\u21BA',
        circlearrowright: '\u21BB',
        circledR: '\u00AE',
        circledS: '\u24C8',
        circledast: '\u229B',
        circledcirc: '\u229A',
        circleddash: '\u229D',
        clubs: '\u2663',
        colon: '\u003A',
        comp: '\u2201',
        ctdot: '\u22EF',
        cuepr: '\u22DE',
        cuesc: '\u22DF',
        cularr: '\u21B6',
        cup: '\u222A',
        curarr: '\u21B7',
        curlyvee: '\u22CE',
        curlywedge: '\u22CF',
        dagger: '\u2020',
        daleth: '\u2138',
        ddarr: '\u21CA',
        deg: '\u00B0',
        delta: '\u03B4',
        digamma: '\u03DD',
        div: '\u00F7',
        divideontimes: '\u22C7',
        dot: '\u02D9',
        doteqdot: '\u2251',
        dotplus: '\u2214',
        dotsquare: '\u22A1',
        dtdot: '\u22F1',
        ecir: '\u2256',
        efDot: '\u2252',
        egs: '\u2A96',
        ell: '\u2113',
        els: '\u2A95',
        empty: '\u2205',
        epsi: '\u03B5',
        epsiv: '\u03F5',
        erDot: '\u2253',
        eta: '\u03B7',
        eth: '\u00F0',
        flat: '\u266D',
        fork: '\u22D4',
        frown: '\u2322',
        gEl: '\u2A8C',
        gamma: '\u03B3',
        gap: '\u2A86',
        gimel: '\u2137',
        gnE: '\u2269',
        gnap: '\u2A8A',
        gne: '\u2A88',
        gnsim: '\u22E7',
        gt: '\u003E',
        gtdot: '\u22D7',
        harrw: '\u21AD',
        hbar: '\u210F',
        hellip: '\u2026',
        hookleftarrow: '\u21A9',
        hookrightarrow: '\u21AA',
        imath: '\u0131',
        infin: '\u221E',
        intcal: '\u22BA',
        iota: '\u03B9',
        jmath: '\u0237',
        kappa: '\u03BA',
        kappav: '\u03F0',
        lEg: '\u2A8B',
        lambda: '\u03BB',
        lap: '\u2A85',
        larrlp: '\u21AB',
        larrtl: '\u21A2',
        lbrace: '\u007B',
        lbrack: '\u005B',
        le: '\u2264',
        leftleftarrows: '\u21C7',
        leftthreetimes: '\u22CB',
        lessdot: '\u22D6',
        lmoust: '\u23B0',
        lnE: '\u2268',
        lnap: '\u2A89',
        lne: '\u2A87',
        lnsim: '\u22E6',
        longmapsto: '\u27FC',
        looparrowright: '\u21AC',
        lowast: '\u2217',
        loz: '\u25CA',
        lt: '\u003C',
        ltimes: '\u22C9',
        ltri: '\u25C3',
        macr: '\u00AF',
        malt: '\u2720',
        mho: '\u2127',
        mu: '\u03BC',
        multimap: '\u22B8',
        nLeftarrow: '\u21CD',
        nLeftrightarrow: '\u21CE',
        nRightarrow: '\u21CF',
        nVDash: '\u22AF',
        nVdash: '\u22AE',
        natur: '\u266E',
        nearr: '\u2197',
        nharr: '\u21AE',
        nlarr: '\u219A',
        not: '\u00AC',
        nrarr: '\u219B',
        nu: '\u03BD',
        nvDash: '\u22AD',
        nvdash: '\u22AC',
        nwarr: '\u2196',
        omega: '\u03C9',
        omicron: '\u03BF',
        or: '\u2228',
        osol: '\u2298',
        period: '\u002E',
        phi: '\u03C6',
        phiv: '\u03D5',
        pi: '\u03C0',
        piv: '\u03D6',
        prap: '\u2AB7',
        precnapprox: '\u2AB9',
        precneqq: '\u2AB5',
        precnsim: '\u22E8',
        prime: '\u2032',
        psi: '\u03C8',
        quot: '\u0022',
        rarrtl: '\u21A3',
        rbrace: '\u007D',
        rbrack: '\u005D',
        rho: '\u03C1',
        rhov: '\u03F1',
        rightrightarrows: '\u21C9',
        rightthreetimes: '\u22CC',
        ring: '\u02DA',
        rmoust: '\u23B1',
        rtimes: '\u22CA',
        rtri: '\u25B9',
        scap: '\u2AB8',
        scnE: '\u2AB6',
        scnap: '\u2ABA',
        scnsim: '\u22E9',
        sdot: '\u22C5',
        searr: '\u2198',
        sect: '\u00A7',
        sharp: '\u266F',
        sigma: '\u03C3',
        sigmav: '\u03C2',
        simne: '\u2246',
        smile: '\u2323',
        spades: '\u2660',
        sub: '\u2282',
        subE: '\u2AC5',
        subnE: '\u2ACB',
        subne: '\u228A',
        supE: '\u2AC6',
        supnE: '\u2ACC',
        supne: '\u228B',
        swarr: '\u2199',
        tau: '\u03C4',
        theta: '\u03B8',
        thetav: '\u03D1',
        tilde: '\u02DC',
        times: '\u00D7',
        triangle: '\u25B5',
        triangleq: '\u225C',
        upsi: '\u03C5',
        upuparrows: '\u21C8',
        veebar: '\u22BB',
        vellip: '\u22EE',
        weierp: '\u2118',
        xi: '\u03BE',
        yen: '\u00A5',
        zeta: '\u03B6',
        zigrarr: '\u21DD',
        nbsp: '\u00A0',
        rsquo: '\u2019',
        lsquo: '\u2018'
    };
    var loaded = {};
    function add(additions, file) {
        Object.assign(exports.entities, additions);
        loaded[file] = true;
    }
    exports.add = add;
    function remove(entity) {
        delete exports.entities[entity];
    }
    exports.remove = remove;
    function translate(text) {
        return text.replace(/&([a-z][a-z0-9]*|#(?:[0-9]+|x[0-9a-f]+));/ig, replace);
    }
    exports.translate = translate;
    function replace(match, entity) {
        if (entity.charAt(0) === '#') {
            return numeric(entity.slice(1));
        }
        if (exports.entities[entity]) {
            return exports.entities[entity];
        }
        if (exports.options['loadMissingEntities']) {
            var file = (entity.match(/^[a-zA-Z](fr|scr|opf)$/) ? RegExp.$1 : entity.charAt(0).toLowerCase());
            if (!loaded[file]) {
                loaded[file] = true;
                (0, Retries_js_1.retryAfter)((0, AsyncLoad_js_1.asyncLoad)('./util/entities/' + file + '.js'));
            }
        }
        return match;
    }
    function numeric(entity) {
        var n = (entity.charAt(0) === 'x' ?
            parseInt(entity.slice(1), 16) :
            parseInt(entity));
        return String.fromCodePoint(n);
    }
    exports.numeric = numeric;
},
649: /* mathjax-full/js/util/AsyncLoad.js */ function _(require, module, exports, __esModule, __esExport) {
    __esModule();
    var mathjax_js_1 = require(625) /* ../mathjax.js */;
    function asyncLoad(name) {
        if (!mathjax_js_1.mathjax.asyncLoad) {
            return Promise.reject("Can't load '".concat(name, "': No asyncLoad method specified"));
        }
        return new Promise(function (ok, fail) {
            var result = mathjax_js_1.mathjax.asyncLoad(name);
            if (result instanceof Promise) {
                result.then(function (value) { return ok(value); }).catch(function (err) { return fail(err); });
            }
            else {
                ok(result);
            }
        });
    }
    exports.asyncLoad = asyncLoad;
},
650: /* mathjax-full/js/input/tex/Stack.js */ function _(require, module, exports, __esModule, __esExport) {
    var __values = (this && this.__values) || function (o) {
        var s = typeof Symbol === "function" && Symbol.iterator, m = s && o[s], i = 0;
        if (m)
            return m.call(o);
        if (o && typeof o.length === "number")
            return {
                next: function () {
                    if (o && i >= o.length)
                        o = void 0;
                    return { value: o && o[i++], done: !o };
                }
            };
        throw new TypeError(s ? "Object is not iterable." : "Symbol.iterator is not defined.");
    };
    var __read = (this && this.__read) || function (o, n) {
        var m = typeof Symbol === "function" && o[Symbol.iterator];
        if (!m)
            return o;
        var i = m.call(o), r, ar = [], e;
        try {
            while ((n === void 0 || n-- > 0) && !(r = i.next()).done)
                ar.push(r.value);
        }
        catch (error) {
            e = { error: error };
        }
        finally {
            try {
                if (r && !r.done && (m = i["return"]))
                    m.call(i);
            }
            finally {
                if (e)
                    throw e.error;
            }
        }
        return ar;
    };
    var __spreadArray = (this && this.__spreadArray) || function (to, from, pack) {
        if (pack || arguments.length === 2)
            for (var i = 0, l = from.length, ar; i < l; i++) {
                if (ar || !(i in from)) {
                    if (!ar)
                        ar = Array.prototype.slice.call(from, 0, i);
                    ar[i] = from[i];
                }
            }
        return to.concat(ar || Array.prototype.slice.call(from));
    };
    var __importDefault = (this && this.__importDefault) || function (mod) {
        return (mod && mod.__esModule) ? mod : { "default": mod };
    };
    __esModule();
    var NodeUtil_js_1 = __importDefault(require(642) /* ./NodeUtil.js */);
    var Stack = (function () {
        function Stack(_factory, _env, inner) {
            this._factory = _factory;
            this._env = _env;
            this.global = {};
            this.stack = [];
            this.global = { isInner: inner };
            this.stack = [this._factory.create('start', this.global)];
            if (_env) {
                this.stack[0].env = _env;
            }
            this.env = this.stack[0].env;
        }
        Object.defineProperty(Stack.prototype, "env", {
            get: function () {
                return this._env;
            },
            set: function (env) {
                this._env = env;
            },
            enumerable: false,
            configurable: true
        });
        Stack.prototype.Push = function () {
            var e_1, _a;
            var args = [];
            for (var _i = 0; _i < arguments.length; _i++) {
                args[_i] = arguments[_i];
            }
            try {
                for (var args_1 = __values(args), args_1_1 = args_1.next(); !args_1_1.done; args_1_1 = args_1.next()) {
                    var node = args_1_1.value;
                    if (!node) {
                        continue;
                    }
                    var item = NodeUtil_js_1.default.isNode(node) ?
                        this._factory.create('mml', node) : node;
                    item.global = this.global;
                    var _b = __read(this.stack.length ? this.Top().checkItem(item) : [null, true], 2), top_1 = _b[0], success = _b[1];
                    if (!success) {
                        continue;
                    }
                    if (top_1) {
                        this.Pop();
                        this.Push.apply(this, __spreadArray([], __read(top_1), false));
                        continue;
                    }
                    this.stack.push(item);
                    if (item.env) {
                        if (item.copyEnv) {
                            Object.assign(item.env, this.env);
                        }
                        this.env = item.env;
                    }
                    else {
                        item.env = this.env;
                    }
                }
            }
            catch (e_1_1) {
                e_1 = { error: e_1_1 };
            }
            finally {
                try {
                    if (args_1_1 && !args_1_1.done && (_a = args_1.return))
                        _a.call(args_1);
                }
                finally {
                    if (e_1)
                        throw e_1.error;
                }
            }
        };
        Stack.prototype.Pop = function () {
            var item = this.stack.pop();
            if (!item.isOpen) {
                delete item.env;
            }
            this.env = (this.stack.length ? this.Top().env : {});
            return item;
        };
        Stack.prototype.Top = function (n) {
            if (n === void 0) {
                n = 1;
            }
            return this.stack.length < n ? null : this.stack[this.stack.length - n];
        };
        Stack.prototype.Prev = function (noPop) {
            var top = this.Top();
            return noPop ? top.First : top.Pop();
        };
        Stack.prototype.toString = function () {
            return 'stack[\n  ' + this.stack.join('\n  ') + '\n]';
        };
        return Stack;
    }());
    exports.default = Stack;
},
651: /* mathjax-full/js/input/tex/ParseOptions.js */ function _(require, module, exports, __esModule, __esExport) {
    var __read = (this && this.__read) || function (o, n) {
        var m = typeof Symbol === "function" && o[Symbol.iterator];
        if (!m)
            return o;
        var i = m.call(o), r, ar = [], e;
        try {
            while ((n === void 0 || n-- > 0) && !(r = i.next()).done)
                ar.push(r.value);
        }
        catch (error) {
            e = { error: error };
        }
        finally {
            try {
                if (r && !r.done && (m = i["return"]))
                    m.call(i);
            }
            finally {
                if (e)
                    throw e.error;
            }
        }
        return ar;
    };
    var __spreadArray = (this && this.__spreadArray) || function (to, from, pack) {
        if (pack || arguments.length === 2)
            for (var i = 0, l = from.length, ar; i < l; i++) {
                if (ar || !(i in from)) {
                    if (!ar)
                        ar = Array.prototype.slice.call(from, 0, i);
                    ar[i] = from[i];
                }
            }
        return to.concat(ar || Array.prototype.slice.call(from));
    };
    var __values = (this && this.__values) || function (o) {
        var s = typeof Symbol === "function" && Symbol.iterator, m = s && o[s], i = 0;
        if (m)
            return m.call(o);
        if (o && typeof o.length === "number")
            return {
                next: function () {
                    if (o && i >= o.length)
                        o = void 0;
                    return { value: o && o[i++], done: !o };
                }
            };
        throw new TypeError(s ? "Object is not iterable." : "Symbol.iterator is not defined.");
    };
    var __importDefault = (this && this.__importDefault) || function (mod) {
        return (mod && mod.__esModule) ? mod : { "default": mod };
    };
    __esModule();
    var StackItemFactory_js_1 = __importDefault(require(652) /* ./StackItemFactory.js */);
    var NodeFactory_js_1 = require(655) /* ./NodeFactory.js */;
    var NodeUtil_js_1 = __importDefault(require(642) /* ./NodeUtil.js */);
    var Options_js_1 = require(632) /* ../../util/Options.js */;
    var ParseOptions = (function () {
        function ParseOptions(configuration, options) {
            if (options === void 0) {
                options = [];
            }
            this.options = {};
            this.packageData = new Map();
            this.parsers = [];
            this.root = null;
            this.nodeLists = {};
            this.error = false;
            this.handlers = configuration.handlers;
            this.nodeFactory = new NodeFactory_js_1.NodeFactory();
            this.nodeFactory.configuration = this;
            this.nodeFactory.setCreators(configuration.nodes);
            this.itemFactory = new StackItemFactory_js_1.default(configuration.items);
            this.itemFactory.configuration = this;
            Options_js_1.defaultOptions.apply(void 0, __spreadArray([this.options], __read(options), false));
            (0, Options_js_1.defaultOptions)(this.options, configuration.options);
        }
        ParseOptions.prototype.pushParser = function (parser) {
            this.parsers.unshift(parser);
        };
        ParseOptions.prototype.popParser = function () {
            this.parsers.shift();
        };
        Object.defineProperty(ParseOptions.prototype, "parser", {
            get: function () {
                return this.parsers[0];
            },
            enumerable: false,
            configurable: true
        });
        ParseOptions.prototype.clear = function () {
            this.parsers = [];
            this.root = null;
            this.nodeLists = {};
            this.error = false;
            this.tags.resetTag();
        };
        ParseOptions.prototype.addNode = function (property, node) {
            var list = this.nodeLists[property];
            if (!list) {
                list = this.nodeLists[property] = [];
            }
            list.push(node);
            if (node.kind !== property) {
                var inlists = (NodeUtil_js_1.default.getProperty(node, 'in-lists') || '');
                var lists = (inlists ? inlists.split(/,/) : []).concat(property).join(',');
                NodeUtil_js_1.default.setProperty(node, 'in-lists', lists);
            }
        };
        ParseOptions.prototype.getList = function (property) {
            var e_1, _a;
            var list = this.nodeLists[property] || [];
            var result = [];
            try {
                for (var list_1 = __values(list), list_1_1 = list_1.next(); !list_1_1.done; list_1_1 = list_1.next()) {
                    var node = list_1_1.value;
                    if (this.inTree(node)) {
                        result.push(node);
                    }
                }
            }
            catch (e_1_1) {
                e_1 = { error: e_1_1 };
            }
            finally {
                try {
                    if (list_1_1 && !list_1_1.done && (_a = list_1.return))
                        _a.call(list_1);
                }
                finally {
                    if (e_1)
                        throw e_1.error;
                }
            }
            this.nodeLists[property] = result;
            return result;
        };
        ParseOptions.prototype.removeFromList = function (property, nodes) {
            var e_2, _a;
            var list = this.nodeLists[property] || [];
            try {
                for (var nodes_1 = __values(nodes), nodes_1_1 = nodes_1.next(); !nodes_1_1.done; nodes_1_1 = nodes_1.next()) {
                    var node = nodes_1_1.value;
                    var i = list.indexOf(node);
                    if (i >= 0) {
                        list.splice(i, 1);
                    }
                }
            }
            catch (e_2_1) {
                e_2 = { error: e_2_1 };
            }
            finally {
                try {
                    if (nodes_1_1 && !nodes_1_1.done && (_a = nodes_1.return))
                        _a.call(nodes_1);
                }
                finally {
                    if (e_2)
                        throw e_2.error;
                }
            }
        };
        ParseOptions.prototype.inTree = function (node) {
            while (node && node !== this.root) {
                node = node.parent;
            }
            return !!node;
        };
        return ParseOptions;
    }());
    exports.default = ParseOptions;
},
652: /* mathjax-full/js/input/tex/StackItemFactory.js */ function _(require, module, exports, __esModule, __esExport) {
    var __extends = (this && this.__extends) || (function () {
        var extendStatics = function (d, b) {
            extendStatics = Object.setPrototypeOf ||
                ({ __proto__: [] } instanceof Array && function (d, b) { d.__proto__ = b; }) ||
                function (d, b) { for (var p in b)
                    if (Object.prototype.hasOwnProperty.call(b, p))
                        d[p] = b[p]; };
            return extendStatics(d, b);
        };
        return function (d, b) {
            if (typeof b !== "function" && b !== null)
                throw new TypeError("Class extends value " + String(b) + " is not a constructor or null");
            extendStatics(d, b);
            function __() { this.constructor = d; }
            d.prototype = b === null ? Object.create(b) : (__.prototype = b.prototype, new __());
        };
    })();
    var _a;
    __esModule();
    var StackItem_js_1 = require(653) /* ./StackItem.js */;
    var Factory_js_1 = require(654) /* ../../core/Tree/Factory.js */;
    var DummyItem = (function (_super) {
        __extends(DummyItem, _super);
        function DummyItem() {
            return _super !== null && _super.apply(this, arguments) || this;
        }
        return DummyItem;
    }(StackItem_js_1.BaseItem));
    var StackItemFactory = (function (_super) {
        __extends(StackItemFactory, _super);
        function StackItemFactory() {
            var _this = _super !== null && _super.apply(this, arguments) || this;
            _this.defaultKind = 'dummy';
            _this.configuration = null;
            return _this;
        }
        StackItemFactory.DefaultStackItems = (_a = {},
            _a[DummyItem.prototype.kind] = DummyItem,
            _a);
        return StackItemFactory;
    }(Factory_js_1.AbstractFactory));
    exports.default = StackItemFactory;
},
653: /* mathjax-full/js/input/tex/StackItem.js */ function _(require, module, exports, __esModule, __esExport) {
    var __extends = (this && this.__extends) || (function () {
        var extendStatics = function (d, b) {
            extendStatics = Object.setPrototypeOf ||
                ({ __proto__: [] } instanceof Array && function (d, b) { d.__proto__ = b; }) ||
                function (d, b) { for (var p in b)
                    if (Object.prototype.hasOwnProperty.call(b, p))
                        d[p] = b[p]; };
            return extendStatics(d, b);
        };
        return function (d, b) {
            if (typeof b !== "function" && b !== null)
                throw new TypeError("Class extends value " + String(b) + " is not a constructor or null");
            extendStatics(d, b);
            function __() { this.constructor = d; }
            d.prototype = b === null ? Object.create(b) : (__.prototype = b.prototype, new __());
        };
    })();
    var __read = (this && this.__read) || function (o, n) {
        var m = typeof Symbol === "function" && o[Symbol.iterator];
        if (!m)
            return o;
        var i = m.call(o), r, ar = [], e;
        try {
            while ((n === void 0 || n-- > 0) && !(r = i.next()).done)
                ar.push(r.value);
        }
        catch (error) {
            e = { error: error };
        }
        finally {
            try {
                if (r && !r.done && (m = i["return"]))
                    m.call(i);
            }
            finally {
                if (e)
                    throw e.error;
            }
        }
        return ar;
    };
    var __spreadArray = (this && this.__spreadArray) || function (to, from, pack) {
        if (pack || arguments.length === 2)
            for (var i = 0, l = from.length, ar; i < l; i++) {
                if (ar || !(i in from)) {
                    if (!ar)
                        ar = Array.prototype.slice.call(from, 0, i);
                    ar[i] = from[i];
                }
            }
        return to.concat(ar || Array.prototype.slice.call(from));
    };
    var __values = (this && this.__values) || function (o) {
        var s = typeof Symbol === "function" && Symbol.iterator, m = s && o[s], i = 0;
        if (m)
            return m.call(o);
        if (o && typeof o.length === "number")
            return {
                next: function () {
                    if (o && i >= o.length)
                        o = void 0;
                    return { value: o && o[i++], done: !o };
                }
            };
        throw new TypeError(s ? "Object is not iterable." : "Symbol.iterator is not defined.");
    };
    var __importDefault = (this && this.__importDefault) || function (mod) {
        return (mod && mod.__esModule) ? mod : { "default": mod };
    };
    __esModule();
    var TexError_js_1 = __importDefault(require(647) /* ./TexError.js */);
    var MmlStack = (function () {
        function MmlStack(_nodes) {
            this._nodes = _nodes;
        }
        Object.defineProperty(MmlStack.prototype, "nodes", {
            get: function () {
                return this._nodes;
            },
            enumerable: false,
            configurable: true
        });
        MmlStack.prototype.Push = function () {
            var _a;
            var nodes = [];
            for (var _i = 0; _i < arguments.length; _i++) {
                nodes[_i] = arguments[_i];
            }
            (_a = this._nodes).push.apply(_a, __spreadArray([], __read(nodes), false));
        };
        MmlStack.prototype.Pop = function () {
            return this._nodes.pop();
        };
        Object.defineProperty(MmlStack.prototype, "First", {
            get: function () {
                return this._nodes[this.Size() - 1];
            },
            set: function (node) {
                this._nodes[this.Size() - 1] = node;
            },
            enumerable: false,
            configurable: true
        });
        Object.defineProperty(MmlStack.prototype, "Last", {
            get: function () {
                return this._nodes[0];
            },
            set: function (node) {
                this._nodes[0] = node;
            },
            enumerable: false,
            configurable: true
        });
        MmlStack.prototype.Peek = function (n) {
            if (n == null) {
                n = 1;
            }
            return this._nodes.slice(this.Size() - n);
        };
        MmlStack.prototype.Size = function () {
            return this._nodes.length;
        };
        MmlStack.prototype.Clear = function () {
            this._nodes = [];
        };
        MmlStack.prototype.toMml = function (inferred, forceRow) {
            if (inferred === void 0) {
                inferred = true;
            }
            if (this._nodes.length === 1 && !forceRow) {
                return this.First;
            }
            return this.create('node', inferred ? 'inferredMrow' : 'mrow', this._nodes, {});
        };
        MmlStack.prototype.create = function (kind) {
            var _a;
            var rest = [];
            for (var _i = 1; _i < arguments.length; _i++) {
                rest[_i - 1] = arguments[_i];
            }
            return (_a = this.factory.configuration.nodeFactory).create.apply(_a, __spreadArray([kind], __read(rest), false));
        };
        return MmlStack;
    }());
    exports.MmlStack = MmlStack;
    var BaseItem = (function (_super) {
        __extends(BaseItem, _super);
        function BaseItem(factory) {
            var nodes = [];
            for (var _i = 1; _i < arguments.length; _i++) {
                nodes[_i - 1] = arguments[_i];
            }
            var _this = _super.call(this, nodes) || this;
            _this.factory = factory;
            _this.global = {};
            _this._properties = {};
            if (_this.isOpen) {
                _this._env = {};
            }
            return _this;
        }
        Object.defineProperty(BaseItem.prototype, "kind", {
            get: function () {
                return 'base';
            },
            enumerable: false,
            configurable: true
        });
        Object.defineProperty(BaseItem.prototype, "env", {
            get: function () {
                return this._env;
            },
            set: function (value) {
                this._env = value;
            },
            enumerable: false,
            configurable: true
        });
        Object.defineProperty(BaseItem.prototype, "copyEnv", {
            get: function () {
                return true;
            },
            enumerable: false,
            configurable: true
        });
        BaseItem.prototype.getProperty = function (key) {
            return this._properties[key];
        };
        BaseItem.prototype.setProperty = function (key, value) {
            this._properties[key] = value;
            return this;
        };
        Object.defineProperty(BaseItem.prototype, "isOpen", {
            get: function () {
                return false;
            },
            enumerable: false,
            configurable: true
        });
        Object.defineProperty(BaseItem.prototype, "isClose", {
            get: function () {
                return false;
            },
            enumerable: false,
            configurable: true
        });
        Object.defineProperty(BaseItem.prototype, "isFinal", {
            get: function () {
                return false;
            },
            enumerable: false,
            configurable: true
        });
        BaseItem.prototype.isKind = function (kind) {
            return kind === this.kind;
        };
        BaseItem.prototype.checkItem = function (item) {
            if (item.isKind('over') && this.isOpen) {
                item.setProperty('num', this.toMml(false));
                this.Clear();
            }
            if (item.isKind('cell') && this.isOpen) {
                if (item.getProperty('linebreak')) {
                    return BaseItem.fail;
                }
                throw new TexError_js_1.default('Misplaced', 'Misplaced %1', item.getName());
            }
            if (item.isClose && this.getErrors(item.kind)) {
                var _a = __read(this.getErrors(item.kind), 2), id = _a[0], message = _a[1];
                throw new TexError_js_1.default(id, message, item.getName());
            }
            if (!item.isFinal) {
                return BaseItem.success;
            }
            this.Push(item.First);
            return BaseItem.fail;
        };
        BaseItem.prototype.clearEnv = function () {
            var e_1, _a;
            try {
                for (var _b = __values(Object.keys(this.env)), _c = _b.next(); !_c.done; _c = _b.next()) {
                    var id = _c.value;
                    delete this.env[id];
                }
            }
            catch (e_1_1) {
                e_1 = { error: e_1_1 };
            }
            finally {
                try {
                    if (_c && !_c.done && (_a = _b.return))
                        _a.call(_b);
                }
                finally {
                    if (e_1)
                        throw e_1.error;
                }
            }
        };
        BaseItem.prototype.setProperties = function (def) {
            Object.assign(this._properties, def);
            return this;
        };
        BaseItem.prototype.getName = function () {
            return this.getProperty('name');
        };
        BaseItem.prototype.toString = function () {
            return this.kind + '[' + this.nodes.join('; ') + ']';
        };
        BaseItem.prototype.getErrors = function (kind) {
            var CLASS = this.constructor;
            return (CLASS.errors || {})[kind] || BaseItem.errors[kind];
        };
        BaseItem.fail = [null, false];
        BaseItem.success = [null, true];
        BaseItem.errors = {
            end: ['MissingBeginExtraEnd', 'Missing \\begin{%1} or extra \\end{%1}'],
            close: ['ExtraCloseMissingOpen', 'Extra close brace or missing open brace'],
            right: ['MissingLeftExtraRight', 'Missing \\left or extra \\right'],
            middle: ['ExtraMiddle', 'Extra \\middle']
        };
        return BaseItem;
    }(MmlStack));
    exports.BaseItem = BaseItem;
},
654: /* mathjax-full/js/core/Tree/Factory.js */ function _(require, module, exports, __esModule, __esExport) {
    var __values = (this && this.__values) || function (o) {
        var s = typeof Symbol === "function" && Symbol.iterator, m = s && o[s], i = 0;
        if (m)
            return m.call(o);
        if (o && typeof o.length === "number")
            return {
                next: function () {
                    if (o && i >= o.length)
                        o = void 0;
                    return { value: o && o[i++], done: !o };
                }
            };
        throw new TypeError(s ? "Object is not iterable." : "Symbol.iterator is not defined.");
    };
    var __read = (this && this.__read) || function (o, n) {
        var m = typeof Symbol === "function" && o[Symbol.iterator];
        if (!m)
            return o;
        var i = m.call(o), r, ar = [], e;
        try {
            while ((n === void 0 || n-- > 0) && !(r = i.next()).done)
                ar.push(r.value);
        }
        catch (error) {
            e = { error: error };
        }
        finally {
            try {
                if (r && !r.done && (m = i["return"]))
                    m.call(i);
            }
            finally {
                if (e)
                    throw e.error;
            }
        }
        return ar;
    };
    var __spreadArray = (this && this.__spreadArray) || function (to, from, pack) {
        if (pack || arguments.length === 2)
            for (var i = 0, l = from.length, ar; i < l; i++) {
                if (ar || !(i in from)) {
                    if (!ar)
                        ar = Array.prototype.slice.call(from, 0, i);
                    ar[i] = from[i];
                }
            }
        return to.concat(ar || Array.prototype.slice.call(from));
    };
    __esModule();
    var AbstractFactory = (function () {
        function AbstractFactory(nodes) {
            var e_1, _a;
            if (nodes === void 0) {
                nodes = null;
            }
            this.defaultKind = 'unknown';
            this.nodeMap = new Map();
            this.node = {};
            if (nodes === null) {
                nodes = this.constructor.defaultNodes;
            }
            try {
                for (var _b = __values(Object.keys(nodes)), _c = _b.next(); !_c.done; _c = _b.next()) {
                    var kind = _c.value;
                    this.setNodeClass(kind, nodes[kind]);
                }
            }
            catch (e_1_1) {
                e_1 = { error: e_1_1 };
            }
            finally {
                try {
                    if (_c && !_c.done && (_a = _b.return))
                        _a.call(_b);
                }
                finally {
                    if (e_1)
                        throw e_1.error;
                }
            }
        }
        AbstractFactory.prototype.create = function (kind) {
            var args = [];
            for (var _i = 1; _i < arguments.length; _i++) {
                args[_i - 1] = arguments[_i];
            }
            return (this.node[kind] || this.node[this.defaultKind]).apply(void 0, __spreadArray([], __read(args), false));
        };
        AbstractFactory.prototype.setNodeClass = function (kind, nodeClass) {
            this.nodeMap.set(kind, nodeClass);
            var THIS = this;
            var KIND = this.nodeMap.get(kind);
            this.node[kind] = function () {
                var args = [];
                for (var _i = 0; _i < arguments.length; _i++) {
                    args[_i] = arguments[_i];
                }
                return new (KIND.bind.apply(KIND, __spreadArray([void 0, THIS], __read(args), false)))();
            };
        };
        AbstractFactory.prototype.getNodeClass = function (kind) {
            return this.nodeMap.get(kind);
        };
        AbstractFactory.prototype.deleteNodeClass = function (kind) {
            this.nodeMap.delete(kind);
            delete this.node[kind];
        };
        AbstractFactory.prototype.nodeIsKind = function (node, kind) {
            return (node instanceof this.getNodeClass(kind));
        };
        AbstractFactory.prototype.getKinds = function () {
            return Array.from(this.nodeMap.keys());
        };
        AbstractFactory.defaultNodes = {};
        return AbstractFactory;
    }());
    exports.AbstractFactory = AbstractFactory;
},
655: /* mathjax-full/js/input/tex/NodeFactory.js */ function _(require, module, exports, __esModule, __esExport) {
    var __read = (this && this.__read) || function (o, n) {
        var m = typeof Symbol === "function" && o[Symbol.iterator];
        if (!m)
            return o;
        var i = m.call(o), r, ar = [], e;
        try {
            while ((n === void 0 || n-- > 0) && !(r = i.next()).done)
                ar.push(r.value);
        }
        catch (error) {
            e = { error: error };
        }
        finally {
            try {
                if (r && !r.done && (m = i["return"]))
                    m.call(i);
            }
            finally {
                if (e)
                    throw e.error;
            }
        }
        return ar;
    };
    var __spreadArray = (this && this.__spreadArray) || function (to, from, pack) {
        if (pack || arguments.length === 2)
            for (var i = 0, l = from.length, ar; i < l; i++) {
                if (ar || !(i in from)) {
                    if (!ar)
                        ar = Array.prototype.slice.call(from, 0, i);
                    ar[i] = from[i];
                }
            }
        return to.concat(ar || Array.prototype.slice.call(from));
    };
    var __importDefault = (this && this.__importDefault) || function (mod) {
        return (mod && mod.__esModule) ? mod : { "default": mod };
    };
    __esModule();
    var NodeUtil_js_1 = __importDefault(require(642) /* ./NodeUtil.js */);
    var NodeFactory = (function () {
        function NodeFactory() {
            this.mmlFactory = null;
            this.factory = { 'node': NodeFactory.createNode,
                'token': NodeFactory.createToken,
                'text': NodeFactory.createText,
                'error': NodeFactory.createError
            };
        }
        NodeFactory.createNode = function (factory, kind, children, def, text) {
            if (children === void 0) {
                children = [];
            }
            if (def === void 0) {
                def = {};
            }
            var node = factory.mmlFactory.create(kind);
            node.setChildren(children);
            if (text) {
                node.appendChild(text);
            }
            NodeUtil_js_1.default.setProperties(node, def);
            return node;
        };
        NodeFactory.createToken = function (factory, kind, def, text) {
            if (def === void 0) {
                def = {};
            }
            if (text === void 0) {
                text = '';
            }
            var textNode = factory.create('text', text);
            return factory.create('node', kind, [], def, textNode);
        };
        NodeFactory.createText = function (factory, text) {
            if (text == null) {
                return null;
            }
            return factory.mmlFactory.create('text').setText(text);
        };
        NodeFactory.createError = function (factory, message) {
            var text = factory.create('text', message);
            var mtext = factory.create('node', 'mtext', [], {}, text);
            var error = factory.create('node', 'merror', [mtext], { 'data-mjx-error': message });
            return error;
        };
        NodeFactory.prototype.setMmlFactory = function (mmlFactory) {
            this.mmlFactory = mmlFactory;
        };
        NodeFactory.prototype.set = function (kind, func) {
            this.factory[kind] = func;
        };
        NodeFactory.prototype.setCreators = function (maps) {
            for (var kind in maps) {
                this.set(kind, maps[kind]);
            }
        };
        NodeFactory.prototype.create = function (kind) {
            var rest = [];
            for (var _i = 1; _i < arguments.length; _i++) {
                rest[_i - 1] = arguments[_i];
            }
            var func = this.factory[kind] || this.factory['node'];
            var node = func.apply(void 0, __spreadArray([this, rest[0]], __read(rest.slice(1)), false));
            if (kind === 'node') {
                this.configuration.addNode(rest[0], node);
            }
            return node;
        };
        NodeFactory.prototype.get = function (kind) {
            return this.factory[kind];
        };
        return NodeFactory;
    }());
    exports.NodeFactory = NodeFactory;
},
656: /* mathjax-full/js/input/tex/Tags.js */ function _(require, module, exports, __esModule, __esExport) {
    var __extends = (this && this.__extends) || (function () {
        var extendStatics = function (d, b) {
            extendStatics = Object.setPrototypeOf ||
                ({ __proto__: [] } instanceof Array && function (d, b) { d.__proto__ = b; }) ||
                function (d, b) { for (var p in b)
                    if (Object.prototype.hasOwnProperty.call(b, p))
                        d[p] = b[p]; };
            return extendStatics(d, b);
        };
        return function (d, b) {
            if (typeof b !== "function" && b !== null)
                throw new TypeError("Class extends value " + String(b) + " is not a constructor or null");
            extendStatics(d, b);
            function __() { this.constructor = d; }
            d.prototype = b === null ? Object.create(b) : (__.prototype = b.prototype, new __());
        };
    })();
    var __values = (this && this.__values) || function (o) {
        var s = typeof Symbol === "function" && Symbol.iterator, m = s && o[s], i = 0;
        if (m)
            return m.call(o);
        if (o && typeof o.length === "number")
            return {
                next: function () {
                    if (o && i >= o.length)
                        o = void 0;
                    return { value: o && o[i++], done: !o };
                }
            };
        throw new TypeError(s ? "Object is not iterable." : "Symbol.iterator is not defined.");
    };
    var __importDefault = (this && this.__importDefault) || function (mod) {
        return (mod && mod.__esModule) ? mod : { "default": mod };
    };
    __esModule();
    var TexParser_js_1 = __importDefault(require(645) /* ./TexParser.js */);
    var Label = (function () {
        function Label(tag, id) {
            if (tag === void 0) {
                tag = '???';
            }
            if (id === void 0) {
                id = '';
            }
            this.tag = tag;
            this.id = id;
        }
        return Label;
    }());
    exports.Label = Label;
    var TagInfo = (function () {
        function TagInfo(env, taggable, defaultTags, tag, tagId, tagFormat, noTag, labelId) {
            if (env === void 0) {
                env = '';
            }
            if (taggable === void 0) {
                taggable = false;
            }
            if (defaultTags === void 0) {
                defaultTags = false;
            }
            if (tag === void 0) {
                tag = null;
            }
            if (tagId === void 0) {
                tagId = '';
            }
            if (tagFormat === void 0) {
                tagFormat = '';
            }
            if (noTag === void 0) {
                noTag = false;
            }
            if (labelId === void 0) {
                labelId = '';
            }
            this.env = env;
            this.taggable = taggable;
            this.defaultTags = defaultTags;
            this.tag = tag;
            this.tagId = tagId;
            this.tagFormat = tagFormat;
            this.noTag = noTag;
            this.labelId = labelId;
        }
        return TagInfo;
    }());
    exports.TagInfo = TagInfo;
    var AbstractTags = (function () {
        function AbstractTags() {
            this.counter = 0;
            this.allCounter = 0;
            this.configuration = null;
            this.ids = {};
            this.allIds = {};
            this.labels = {};
            this.allLabels = {};
            this.redo = false;
            this.refUpdate = false;
            this.currentTag = new TagInfo();
            this.history = [];
            this.stack = [];
            this.enTag = function (node, tag) {
                var nf = this.configuration.nodeFactory;
                var cell = nf.create('node', 'mtd', [node]);
                var row = nf.create('node', 'mlabeledtr', [tag, cell]);
                var table = nf.create('node', 'mtable', [row], {
                    side: this.configuration.options['tagSide'],
                    minlabelspacing: this.configuration.options['tagIndent'],
                    displaystyle: true
                });
                return table;
            };
        }
        AbstractTags.prototype.start = function (env, taggable, defaultTags) {
            if (this.currentTag) {
                this.stack.push(this.currentTag);
            }
            this.currentTag = new TagInfo(env, taggable, defaultTags);
        };
        Object.defineProperty(AbstractTags.prototype, "env", {
            get: function () {
                return this.currentTag.env;
            },
            enumerable: false,
            configurable: true
        });
        AbstractTags.prototype.end = function () {
            this.history.push(this.currentTag);
            this.currentTag = this.stack.pop();
        };
        AbstractTags.prototype.tag = function (tag, noFormat) {
            this.currentTag.tag = tag;
            this.currentTag.tagFormat = noFormat ? tag : this.formatTag(tag);
            this.currentTag.noTag = false;
        };
        AbstractTags.prototype.notag = function () {
            this.tag('', true);
            this.currentTag.noTag = true;
        };
        Object.defineProperty(AbstractTags.prototype, "noTag", {
            get: function () {
                return this.currentTag.noTag;
            },
            enumerable: false,
            configurable: true
        });
        Object.defineProperty(AbstractTags.prototype, "label", {
            get: function () {
                return this.currentTag.labelId;
            },
            set: function (label) {
                this.currentTag.labelId = label;
            },
            enumerable: false,
            configurable: true
        });
        AbstractTags.prototype.formatUrl = function (id, base) {
            return base + '#' + encodeURIComponent(id);
        };
        AbstractTags.prototype.formatTag = function (tag) {
            return '(' + tag + ')';
        };
        AbstractTags.prototype.formatId = function (id) {
            return 'mjx-eqn:' + id.replace(/\s/g, '_');
        };
        AbstractTags.prototype.formatNumber = function (n) {
            return n.toString();
        };
        AbstractTags.prototype.autoTag = function () {
            if (this.currentTag.tag == null) {
                this.counter++;
                this.tag(this.formatNumber(this.counter), false);
            }
        };
        AbstractTags.prototype.clearTag = function () {
            this.label = '';
            this.tag(null, true);
            this.currentTag.tagId = '';
        };
        AbstractTags.prototype.getTag = function (force) {
            if (force === void 0) {
                force = false;
            }
            if (force) {
                this.autoTag();
                return this.makeTag();
            }
            var ct = this.currentTag;
            if (ct.taggable && !ct.noTag) {
                if (ct.defaultTags) {
                    this.autoTag();
                }
                if (ct.tag) {
                    return this.makeTag();
                }
            }
            return null;
        };
        AbstractTags.prototype.resetTag = function () {
            this.history = [];
            this.redo = false;
            this.refUpdate = false;
            this.clearTag();
        };
        AbstractTags.prototype.reset = function (offset) {
            if (offset === void 0) {
                offset = 0;
            }
            this.resetTag();
            this.counter = this.allCounter = offset;
            this.allLabels = {};
            this.allIds = {};
        };
        AbstractTags.prototype.startEquation = function (math) {
            this.history = [];
            this.stack = [];
            this.clearTag();
            this.currentTag = new TagInfo('', undefined, undefined);
            this.labels = {};
            this.ids = {};
            this.counter = this.allCounter;
            this.redo = false;
            var recompile = math.inputData.recompile;
            if (recompile) {
                this.refUpdate = true;
                this.counter = recompile.counter;
            }
        };
        AbstractTags.prototype.finishEquation = function (math) {
            if (this.redo) {
                math.inputData.recompile = {
                    state: math.state(),
                    counter: this.allCounter
                };
            }
            if (!this.refUpdate) {
                this.allCounter = this.counter;
            }
            Object.assign(this.allIds, this.ids);
            Object.assign(this.allLabels, this.labels);
        };
        AbstractTags.prototype.finalize = function (node, env) {
            if (!env.display || this.currentTag.env ||
                this.currentTag.tag == null) {
                return node;
            }
            var tag = this.makeTag();
            var table = this.enTag(node, tag);
            return table;
        };
        AbstractTags.prototype.makeId = function () {
            this.currentTag.tagId = this.formatId(this.configuration.options['useLabelIds'] ?
                (this.label || this.currentTag.tag) : this.currentTag.tag);
        };
        AbstractTags.prototype.makeTag = function () {
            this.makeId();
            if (this.label) {
                this.labels[this.label] = new Label(this.currentTag.tag, this.currentTag.tagId);
            }
            var mml = new TexParser_js_1.default('\\text{' + this.currentTag.tagFormat + '}', {}, this.configuration).mml();
            return this.configuration.nodeFactory.create('node', 'mtd', [mml], { id: this.currentTag.tagId });
        };
        return AbstractTags;
    }());
    exports.AbstractTags = AbstractTags;
    var NoTags = (function (_super) {
        __extends(NoTags, _super);
        function NoTags() {
            return _super !== null && _super.apply(this, arguments) || this;
        }
        NoTags.prototype.autoTag = function () { };
        NoTags.prototype.getTag = function () {
            return !this.currentTag.tag ? null : _super.prototype.getTag.call(this);
        };
        return NoTags;
    }(AbstractTags));
    exports.NoTags = NoTags;
    var AllTags = (function (_super) {
        __extends(AllTags, _super);
        function AllTags() {
            return _super !== null && _super.apply(this, arguments) || this;
        }
        AllTags.prototype.finalize = function (node, env) {
            if (!env.display || this.history.find(function (x) { return x.taggable; })) {
                return node;
            }
            var tag = this.getTag(true);
            return this.enTag(node, tag);
        };
        return AllTags;
    }(AbstractTags));
    exports.AllTags = AllTags;
    var TagsFactory;
    (function (TagsFactory) {
        var tagsMapping = new Map([
            ['none', NoTags],
            ['all', AllTags]
        ]);
        var defaultTags = 'none';
        TagsFactory.OPTIONS = {
            tags: defaultTags,
            tagSide: 'right',
            tagIndent: '0.8em',
            useLabelIds: true,
            ignoreDuplicateLabels: false
        };
        TagsFactory.add = function (name, constr) {
            tagsMapping.set(name, constr);
        };
        TagsFactory.addTags = function (tags) {
            var e_1, _a;
            try {
                for (var _b = __values(Object.keys(tags)), _c = _b.next(); !_c.done; _c = _b.next()) {
                    var key = _c.value;
                    TagsFactory.add(key, tags[key]);
                }
            }
            catch (e_1_1) {
                e_1 = { error: e_1_1 };
            }
            finally {
                try {
                    if (_c && !_c.done && (_a = _b.return))
                        _a.call(_b);
                }
                finally {
                    if (e_1)
                        throw e_1.error;
                }
            }
        };
        TagsFactory.create = function (name) {
            var constr = tagsMapping.get(name) || tagsMapping.get(defaultTags);
            if (!constr) {
                throw Error('Unknown tags class');
            }
            return new constr();
        };
        TagsFactory.setDefault = function (name) {
            defaultTags = name;
        };
        TagsFactory.getDefault = function () {
            return TagsFactory.create(defaultTags);
        };
    })(TagsFactory = exports.TagsFactory || (exports.TagsFactory = {}));
},
657: /* mathjax-full/js/input/tex/Configuration.js */ function _(require, module, exports, __esModule, __esExport) {
    var __values = (this && this.__values) || function (o) {
        var s = typeof Symbol === "function" && Symbol.iterator, m = s && o[s], i = 0;
        if (m)
            return m.call(o);
        if (o && typeof o.length === "number")
            return {
                next: function () {
                    if (o && i >= o.length)
                        o = void 0;
                    return { value: o && o[i++], done: !o };
                }
            };
        throw new TypeError(s ? "Object is not iterable." : "Symbol.iterator is not defined.");
    };
    var __read = (this && this.__read) || function (o, n) {
        var m = typeof Symbol === "function" && o[Symbol.iterator];
        if (!m)
            return o;
        var i = m.call(o), r, ar = [], e;
        try {
            while ((n === void 0 || n-- > 0) && !(r = i.next()).done)
                ar.push(r.value);
        }
        catch (error) {
            e = { error: error };
        }
        finally {
            try {
                if (r && !r.done && (m = i["return"]))
                    m.call(i);
            }
            finally {
                if (e)
                    throw e.error;
            }
        }
        return ar;
    };
    __esModule();
    var Options_js_1 = require(632) /* ../../util/Options.js */;
    var MapHandler_js_1 = require(658) /* ./MapHandler.js */;
    var FunctionList_js_1 = require(633) /* ../../util/FunctionList.js */;
    var PrioritizedList_js_1 = require(628) /* ../../util/PrioritizedList.js */;
    var Tags_js_1 = require(656) /* ./Tags.js */;
    var Configuration = (function () {
        function Configuration(name, handler, fallback, items, tags, options, nodes, preprocessors, postprocessors, initMethod, configMethod, priority, parser) {
            if (handler === void 0) {
                handler = {};
            }
            if (fallback === void 0) {
                fallback = {};
            }
            if (items === void 0) {
                items = {};
            }
            if (tags === void 0) {
                tags = {};
            }
            if (options === void 0) {
                options = {};
            }
            if (nodes === void 0) {
                nodes = {};
            }
            if (preprocessors === void 0) {
                preprocessors = [];
            }
            if (postprocessors === void 0) {
                postprocessors = [];
            }
            if (initMethod === void 0) {
                initMethod = null;
            }
            if (configMethod === void 0) {
                configMethod = null;
            }
            this.name = name;
            this.handler = handler;
            this.fallback = fallback;
            this.items = items;
            this.tags = tags;
            this.options = options;
            this.nodes = nodes;
            this.preprocessors = preprocessors;
            this.postprocessors = postprocessors;
            this.initMethod = initMethod;
            this.configMethod = configMethod;
            this.priority = priority;
            this.parser = parser;
            this.handler = Object.assign({ character: [], delimiter: [], macro: [], environment: [] }, handler);
        }
        Configuration.makeProcessor = function (func, priority) {
            return Array.isArray(func) ? func : [func, priority];
        };
        Configuration._create = function (name, config) {
            var _this = this;
            if (config === void 0) {
                config = {};
            }
            var priority = config.priority || PrioritizedList_js_1.PrioritizedList.DEFAULTPRIORITY;
            var init = config.init ? this.makeProcessor(config.init, priority) : null;
            var conf = config.config ? this.makeProcessor(config.config, priority) : null;
            var preprocessors = (config.preprocessors || []).map(function (pre) { return _this.makeProcessor(pre, priority); });
            var postprocessors = (config.postprocessors || []).map(function (post) { return _this.makeProcessor(post, priority); });
            var parser = config.parser || 'tex';
            return new Configuration(name, config.handler || {}, config.fallback || {}, config.items || {}, config.tags || {}, config.options || {}, config.nodes || {}, preprocessors, postprocessors, init, conf, priority, parser);
        };
        Configuration.create = function (name, config) {
            if (config === void 0) {
                config = {};
            }
            var configuration = Configuration._create(name, config);
            ConfigurationHandler.set(name, configuration);
            return configuration;
        };
        Configuration.local = function (config) {
            if (config === void 0) {
                config = {};
            }
            return Configuration._create('', config);
        };
        Object.defineProperty(Configuration.prototype, "init", {
            get: function () {
                return this.initMethod ? this.initMethod[0] : null;
            },
            enumerable: false,
            configurable: true
        });
        Object.defineProperty(Configuration.prototype, "config", {
            get: function () {
                return this.configMethod ? this.configMethod[0] : null;
            },
            enumerable: false,
            configurable: true
        });
        return Configuration;
    }());
    exports.Configuration = Configuration;
    var ConfigurationHandler;
    (function (ConfigurationHandler) {
        var maps = new Map();
        ConfigurationHandler.set = function (name, map) {
            maps.set(name, map);
        };
        ConfigurationHandler.get = function (name) {
            return maps.get(name);
        };
        ConfigurationHandler.keys = function () {
            return maps.keys();
        };
    })(ConfigurationHandler = exports.ConfigurationHandler || (exports.ConfigurationHandler = {}));
    var ParserConfiguration = (function () {
        function ParserConfiguration(packages, parsers) {
            var e_1, _a, e_2, _b;
            if (parsers === void 0) {
                parsers = ['tex'];
            }
            this.initMethod = new FunctionList_js_1.FunctionList();
            this.configMethod = new FunctionList_js_1.FunctionList();
            this.configurations = new PrioritizedList_js_1.PrioritizedList();
            this.parsers = [];
            this.handlers = new MapHandler_js_1.SubHandlers();
            this.items = {};
            this.tags = {};
            this.options = {};
            this.nodes = {};
            this.parsers = parsers;
            try {
                for (var _c = __values(packages.slice().reverse()), _d = _c.next(); !_d.done; _d = _c.next()) {
                    var pkg = _d.value;
                    this.addPackage(pkg);
                }
            }
            catch (e_1_1) {
                e_1 = { error: e_1_1 };
            }
            finally {
                try {
                    if (_d && !_d.done && (_a = _c.return))
                        _a.call(_c);
                }
                finally {
                    if (e_1)
                        throw e_1.error;
                }
            }
            try {
                for (var _e = __values(this.configurations), _f = _e.next(); !_f.done; _f = _e.next()) {
                    var _g = _f.value, config = _g.item, priority = _g.priority;
                    this.append(config, priority);
                }
            }
            catch (e_2_1) {
                e_2 = { error: e_2_1 };
            }
            finally {
                try {
                    if (_f && !_f.done && (_b = _e.return))
                        _b.call(_e);
                }
                finally {
                    if (e_2)
                        throw e_2.error;
                }
            }
        }
        ParserConfiguration.prototype.init = function () {
            this.initMethod.execute(this);
        };
        ParserConfiguration.prototype.config = function (jax) {
            var e_3, _a;
            this.configMethod.execute(this, jax);
            try {
                for (var _b = __values(this.configurations), _c = _b.next(); !_c.done; _c = _b.next()) {
                    var config = _c.value;
                    this.addFilters(jax, config.item);
                }
            }
            catch (e_3_1) {
                e_3 = { error: e_3_1 };
            }
            finally {
                try {
                    if (_c && !_c.done && (_a = _b.return))
                        _a.call(_b);
                }
                finally {
                    if (e_3)
                        throw e_3.error;
                }
            }
        };
        ParserConfiguration.prototype.addPackage = function (pkg) {
            var name = typeof pkg === 'string' ? pkg : pkg[0];
            var conf = this.getPackage(name);
            conf && this.configurations.add(conf, typeof pkg === 'string' ? conf.priority : pkg[1]);
        };
        ParserConfiguration.prototype.add = function (name, jax, options) {
            var e_4, _a;
            if (options === void 0) {
                options = {};
            }
            var config = this.getPackage(name);
            this.append(config);
            this.configurations.add(config, config.priority);
            this.init();
            var parser = jax.parseOptions;
            parser.nodeFactory.setCreators(config.nodes);
            try {
                for (var _b = __values(Object.keys(config.items)), _c = _b.next(); !_c.done; _c = _b.next()) {
                    var kind = _c.value;
                    parser.itemFactory.setNodeClass(kind, config.items[kind]);
                }
            }
            catch (e_4_1) {
                e_4 = { error: e_4_1 };
            }
            finally {
                try {
                    if (_c && !_c.done && (_a = _b.return))
                        _a.call(_b);
                }
                finally {
                    if (e_4)
                        throw e_4.error;
                }
            }
            Tags_js_1.TagsFactory.addTags(config.tags);
            (0, Options_js_1.defaultOptions)(parser.options, config.options);
            (0, Options_js_1.userOptions)(parser.options, options);
            this.addFilters(jax, config);
            if (config.config) {
                config.config(this, jax);
            }
        };
        ParserConfiguration.prototype.getPackage = function (name) {
            var config = ConfigurationHandler.get(name);
            if (config && this.parsers.indexOf(config.parser) < 0) {
                throw Error("Package ".concat(name, " doesn't target the proper parser"));
            }
            return config;
        };
        ParserConfiguration.prototype.append = function (config, priority) {
            priority = priority || config.priority;
            if (config.initMethod) {
                this.initMethod.add(config.initMethod[0], config.initMethod[1]);
            }
            if (config.configMethod) {
                this.configMethod.add(config.configMethod[0], config.configMethod[1]);
            }
            this.handlers.add(config.handler, config.fallback, priority);
            Object.assign(this.items, config.items);
            Object.assign(this.tags, config.tags);
            (0, Options_js_1.defaultOptions)(this.options, config.options);
            Object.assign(this.nodes, config.nodes);
        };
        ParserConfiguration.prototype.addFilters = function (jax, config) {
            var e_5, _a, e_6, _b;
            try {
                for (var _c = __values(config.preprocessors), _d = _c.next(); !_d.done; _d = _c.next()) {
                    var _e = __read(_d.value, 2), pre = _e[0], priority = _e[1];
                    jax.preFilters.add(pre, priority);
                }
            }
            catch (e_5_1) {
                e_5 = { error: e_5_1 };
            }
            finally {
                try {
                    if (_d && !_d.done && (_a = _c.return))
                        _a.call(_c);
                }
                finally {
                    if (e_5)
                        throw e_5.error;
                }
            }
            try {
                for (var _f = __values(config.postprocessors), _g = _f.next(); !_g.done; _g = _f.next()) {
                    var _h = __read(_g.value, 2), post = _h[0], priority = _h[1];
                    jax.postFilters.add(post, priority);
                }
            }
            catch (e_6_1) {
                e_6 = { error: e_6_1 };
            }
            finally {
                try {
                    if (_g && !_g.done && (_b = _f.return))
                        _b.call(_f);
                }
                finally {
                    if (e_6)
                        throw e_6.error;
                }
            }
        };
        return ParserConfiguration;
    }());
    exports.ParserConfiguration = ParserConfiguration;
},
658: /* mathjax-full/js/input/tex/MapHandler.js */ function _(require, module, exports, __esModule, __esExport) {
    var __values = (this && this.__values) || function (o) {
        var s = typeof Symbol === "function" && Symbol.iterator, m = s && o[s], i = 0;
        if (m)
            return m.call(o);
        if (o && typeof o.length === "number")
            return {
                next: function () {
                    if (o && i >= o.length)
                        o = void 0;
                    return { value: o && o[i++], done: !o };
                }
            };
        throw new TypeError(s ? "Object is not iterable." : "Symbol.iterator is not defined.");
    };
    var __read = (this && this.__read) || function (o, n) {
        var m = typeof Symbol === "function" && o[Symbol.iterator];
        if (!m)
            return o;
        var i = m.call(o), r, ar = [], e;
        try {
            while ((n === void 0 || n-- > 0) && !(r = i.next()).done)
                ar.push(r.value);
        }
        catch (error) {
            e = { error: error };
        }
        finally {
            try {
                if (r && !r.done && (m = i["return"]))
                    m.call(i);
            }
            finally {
                if (e)
                    throw e.error;
            }
        }
        return ar;
    };
    __esModule();
    var PrioritizedList_js_1 = require(628) /* ../../util/PrioritizedList.js */;
    var FunctionList_js_1 = require(633) /* ../../util/FunctionList.js */;
    var MapHandler;
    (function (MapHandler) {
        var maps = new Map();
        MapHandler.register = function (map) {
            maps.set(map.name, map);
        };
        MapHandler.getMap = function (name) {
            return maps.get(name);
        };
    })(MapHandler = exports.MapHandler || (exports.MapHandler = {}));
    var SubHandler = (function () {
        function SubHandler() {
            this._configuration = new PrioritizedList_js_1.PrioritizedList();
            this._fallback = new FunctionList_js_1.FunctionList();
        }
        SubHandler.prototype.add = function (maps, fallback, priority) {
            var e_1, _a;
            if (priority === void 0) {
                priority = PrioritizedList_js_1.PrioritizedList.DEFAULTPRIORITY;
            }
            try {
                for (var _b = __values(maps.slice().reverse()), _c = _b.next(); !_c.done; _c = _b.next()) {
                    var name_1 = _c.value;
                    var map = MapHandler.getMap(name_1);
                    if (!map) {
                        this.warn('Configuration ' + name_1 + ' not found! Omitted.');
                        return;
                    }
                    this._configuration.add(map, priority);
                }
            }
            catch (e_1_1) {
                e_1 = { error: e_1_1 };
            }
            finally {
                try {
                    if (_c && !_c.done && (_a = _b.return))
                        _a.call(_b);
                }
                finally {
                    if (e_1)
                        throw e_1.error;
                }
            }
            if (fallback) {
                this._fallback.add(fallback, priority);
            }
        };
        SubHandler.prototype.parse = function (input) {
            var e_2, _a;
            try {
                for (var _b = __values(this._configuration), _c = _b.next(); !_c.done; _c = _b.next()) {
                    var map = _c.value.item;
                    var result = map.parse(input);
                    if (result) {
                        return result;
                    }
                }
            }
            catch (e_2_1) {
                e_2 = { error: e_2_1 };
            }
            finally {
                try {
                    if (_c && !_c.done && (_a = _b.return))
                        _a.call(_b);
                }
                finally {
                    if (e_2)
                        throw e_2.error;
                }
            }
            var _d = __read(input, 2), env = _d[0], symbol = _d[1];
            Array.from(this._fallback)[0].item(env, symbol);
        };
        SubHandler.prototype.lookup = function (symbol) {
            var map = this.applicable(symbol);
            return map ? map.lookup(symbol) : null;
        };
        SubHandler.prototype.contains = function (symbol) {
            return this.applicable(symbol) ? true : false;
        };
        SubHandler.prototype.toString = function () {
            var e_3, _a;
            var names = [];
            try {
                for (var _b = __values(this._configuration), _c = _b.next(); !_c.done; _c = _b.next()) {
                    var map = _c.value.item;
                    names.push(map.name);
                }
            }
            catch (e_3_1) {
                e_3 = { error: e_3_1 };
            }
            finally {
                try {
                    if (_c && !_c.done && (_a = _b.return))
                        _a.call(_b);
                }
                finally {
                    if (e_3)
                        throw e_3.error;
                }
            }
            return names.join(', ');
        };
        SubHandler.prototype.applicable = function (symbol) {
            var e_4, _a;
            try {
                for (var _b = __values(this._configuration), _c = _b.next(); !_c.done; _c = _b.next()) {
                    var map = _c.value.item;
                    if (map.contains(symbol)) {
                        return map;
                    }
                }
            }
            catch (e_4_1) {
                e_4 = { error: e_4_1 };
            }
            finally {
                try {
                    if (_c && !_c.done && (_a = _b.return))
                        _a.call(_b);
                }
                finally {
                    if (e_4)
                        throw e_4.error;
                }
            }
            return null;
        };
        SubHandler.prototype.retrieve = function (name) {
            var e_5, _a;
            try {
                for (var _b = __values(this._configuration), _c = _b.next(); !_c.done; _c = _b.next()) {
                    var map = _c.value.item;
                    if (map.name === name) {
                        return map;
                    }
                }
            }
            catch (e_5_1) {
                e_5 = { error: e_5_1 };
            }
            finally {
                try {
                    if (_c && !_c.done && (_a = _b.return))
                        _a.call(_b);
                }
                finally {
                    if (e_5)
                        throw e_5.error;
                }
            }
            return null;
        };
        SubHandler.prototype.warn = function (message) {
            console.log('TexParser Warning: ' + message);
        };
        return SubHandler;
    }());
    exports.SubHandler = SubHandler;
    var SubHandlers = (function () {
        function SubHandlers() {
            this.map = new Map();
        }
        SubHandlers.prototype.add = function (handlers, fallbacks, priority) {
            var e_6, _a;
            if (priority === void 0) {
                priority = PrioritizedList_js_1.PrioritizedList.DEFAULTPRIORITY;
            }
            try {
                for (var _b = __values(Object.keys(handlers)), _c = _b.next(); !_c.done; _c = _b.next()) {
                    var key = _c.value;
                    var name_2 = key;
                    var subHandler = this.get(name_2);
                    if (!subHandler) {
                        subHandler = new SubHandler();
                        this.set(name_2, subHandler);
                    }
                    subHandler.add(handlers[name_2], fallbacks[name_2], priority);
                }
            }
            catch (e_6_1) {
                e_6 = { error: e_6_1 };
            }
            finally {
                try {
                    if (_c && !_c.done && (_a = _b.return))
                        _a.call(_b);
                }
                finally {
                    if (e_6)
                        throw e_6.error;
                }
            }
        };
        SubHandlers.prototype.set = function (name, subHandler) {
            this.map.set(name, subHandler);
        };
        SubHandlers.prototype.get = function (name) {
            return this.map.get(name);
        };
        SubHandlers.prototype.retrieve = function (name) {
            var e_7, _a;
            try {
                for (var _b = __values(this.map.values()), _c = _b.next(); !_c.done; _c = _b.next()) {
                    var handler = _c.value;
                    var map = handler.retrieve(name);
                    if (map) {
                        return map;
                    }
                }
            }
            catch (e_7_1) {
                e_7 = { error: e_7_1 };
            }
            finally {
                try {
                    if (_c && !_c.done && (_a = _b.return))
                        _a.call(_b);
                }
                finally {
                    if (e_7)
                        throw e_7.error;
                }
            }
            return null;
        };
        SubHandlers.prototype.keys = function () {
            return this.map.keys();
        };
        return SubHandlers;
    }());
    exports.SubHandlers = SubHandlers;
},
659: /* mathjax-full/js/input/tex/base/BaseConfiguration.js */ function _(require, module, exports, __esModule, __esExport) {
    var __extends = (this && this.__extends) || (function () {
        var extendStatics = function (d, b) {
            extendStatics = Object.setPrototypeOf ||
                ({ __proto__: [] } instanceof Array && function (d, b) { d.__proto__ = b; }) ||
                function (d, b) { for (var p in b)
                    if (Object.prototype.hasOwnProperty.call(b, p))
                        d[p] = b[p]; };
            return extendStatics(d, b);
        };
        return function (d, b) {
            if (typeof b !== "function" && b !== null)
                throw new TypeError("Class extends value " + String(b) + " is not a constructor or null");
            extendStatics(d, b);
            function __() { this.constructor = d; }
            d.prototype = b === null ? Object.create(b) : (__.prototype = b.prototype, new __());
        };
    })();
    var __createBinding = (this && this.__createBinding) || (Object.create ? (function (o, m, k, k2) {
        if (k2 === undefined)
            k2 = k;
        var desc = Object.getOwnPropertyDescriptor(m, k);
        if (!desc || ("get" in desc ? !m.__esModule : desc.writable || desc.configurable)) {
            desc = { enumerable: true, get: function () { return m[k]; } };
        }
        Object.defineProperty(o, k2, desc);
    }) : (function (o, m, k, k2) {
        if (k2 === undefined)
            k2 = k;
        o[k2] = m[k];
    }));
    var __setModuleDefault = (this && this.__setModuleDefault) || (Object.create ? (function (o, v) {
        Object.defineProperty(o, "default", { enumerable: true, value: v });
    }) : function (o, v) {
        o["default"] = v;
    });
    var __importStar = (this && this.__importStar) || function (mod) {
        if (mod && mod.__esModule)
            return mod;
        var result = {};
        if (mod != null)
            for (var k in mod)
                if (k !== "default" && Object.prototype.hasOwnProperty.call(mod, k))
                    __createBinding(result, mod, k);
        __setModuleDefault(result, mod);
        return result;
    };
    var __values = (this && this.__values) || function (o) {
        var s = typeof Symbol === "function" && Symbol.iterator, m = s && o[s], i = 0;
        if (m)
            return m.call(o);
        if (o && typeof o.length === "number")
            return {
                next: function () {
                    if (o && i >= o.length)
                        o = void 0;
                    return { value: o && o[i++], done: !o };
                }
            };
        throw new TypeError(s ? "Object is not iterable." : "Symbol.iterator is not defined.");
    };
    var __importDefault = (this && this.__importDefault) || function (mod) {
        return (mod && mod.__esModule) ? mod : { "default": mod };
    };
    var _a;
    __esModule();
    var Configuration_js_1 = require(657) /* ../Configuration.js */;
    var MapHandler_js_1 = require(658) /* ../MapHandler.js */;
    var TexError_js_1 = __importDefault(require(647) /* ../TexError.js */);
    var NodeUtil_js_1 = __importDefault(require(642) /* ../NodeUtil.js */);
    var SymbolMap_js_1 = require(660) /* ../SymbolMap.js */;
    var bitem = __importStar(require(662) /* ./BaseItems.js */);
    var Tags_js_1 = require(656) /* ../Tags.js */;
    require(663) /* ./BaseMappings.js */;
    var OperatorDictionary_js_1 = require(644) /* ../../../core/MmlTree/OperatorDictionary.js */;
    new SymbolMap_js_1.CharacterMap('remap', null, {
        '-': '\u2212',
        '*': '\u2217',
        '`': '\u2018'
    });
    function Other(parser, char) {
        var font = parser.stack.env['font'];
        var def = font ?
            { mathvariant: parser.stack.env['font'] } : {};
        var remap = MapHandler_js_1.MapHandler.getMap('remap').lookup(char);
        var range = (0, OperatorDictionary_js_1.getRange)(char);
        var type = (range ? range[3] : 'mo');
        var mo = parser.create('token', type, def, (remap ? remap.char : char));
        range[4] && mo.attributes.set('mathvariant', range[4]);
        if (type === 'mo') {
            NodeUtil_js_1.default.setProperty(mo, 'fixStretchy', true);
            parser.configuration.addNode('fixStretchy', mo);
        }
        parser.Push(mo);
    }
    exports.Other = Other;
    function csUndefined(_parser, name) {
        throw new TexError_js_1.default('UndefinedControlSequence', 'Undefined control sequence %1', '\\' + name);
    }
    function envUndefined(_parser, env) {
        throw new TexError_js_1.default('UnknownEnv', 'Unknown environment \'%1\'', env);
    }
    function filterNonscript(_a) {
        var e_1, _b;
        var data = _a.data;
        try {
            for (var _c = __values(data.getList('nonscript')), _d = _c.next(); !_d.done; _d = _c.next()) {
                var mml = _d.value;
                if (mml.attributes.get('scriptlevel') > 0) {
                    var parent_1 = mml.parent;
                    parent_1.childNodes.splice(parent_1.childIndex(mml), 1);
                    data.removeFromList(mml.kind, [mml]);
                    if (mml.isKind('mrow')) {
                        var mstyle = mml.childNodes[0];
                        data.removeFromList('mstyle', [mstyle]);
                        data.removeFromList('mspace', mstyle.childNodes[0].childNodes);
                    }
                }
                else if (mml.isKind('mrow')) {
                    mml.parent.replaceChild(mml.childNodes[0], mml);
                    data.removeFromList('mrow', [mml]);
                }
            }
        }
        catch (e_1_1) {
            e_1 = { error: e_1_1 };
        }
        finally {
            try {
                if (_d && !_d.done && (_b = _c.return))
                    _b.call(_c);
            }
            finally {
                if (e_1)
                    throw e_1.error;
            }
        }
    }
    var BaseTags = (function (_super) {
        __extends(BaseTags, _super);
        function BaseTags() {
            return _super !== null && _super.apply(this, arguments) || this;
        }
        return BaseTags;
    }(Tags_js_1.AbstractTags));
    exports.BaseTags = BaseTags;
    exports.BaseConfiguration = Configuration_js_1.Configuration.create('base', {
        handler: {
            character: ['command', 'special', 'letter', 'digit'],
            delimiter: ['delimiter'],
            macro: ['delimiter', 'macros', 'mathchar0mi', 'mathchar0mo', 'mathchar7'],
            environment: ['environment']
        },
        fallback: {
            character: Other,
            macro: csUndefined,
            environment: envUndefined
        },
        items: (_a = {},
            _a[bitem.StartItem.prototype.kind] = bitem.StartItem,
            _a[bitem.StopItem.prototype.kind] = bitem.StopItem,
            _a[bitem.OpenItem.prototype.kind] = bitem.OpenItem,
            _a[bitem.CloseItem.prototype.kind] = bitem.CloseItem,
            _a[bitem.PrimeItem.prototype.kind] = bitem.PrimeItem,
            _a[bitem.SubsupItem.prototype.kind] = bitem.SubsupItem,
            _a[bitem.OverItem.prototype.kind] = bitem.OverItem,
            _a[bitem.LeftItem.prototype.kind] = bitem.LeftItem,
            _a[bitem.Middle.prototype.kind] = bitem.Middle,
            _a[bitem.RightItem.prototype.kind] = bitem.RightItem,
            _a[bitem.BeginItem.prototype.kind] = bitem.BeginItem,
            _a[bitem.EndItem.prototype.kind] = bitem.EndItem,
            _a[bitem.StyleItem.prototype.kind] = bitem.StyleItem,
            _a[bitem.PositionItem.prototype.kind] = bitem.PositionItem,
            _a[bitem.CellItem.prototype.kind] = bitem.CellItem,
            _a[bitem.MmlItem.prototype.kind] = bitem.MmlItem,
            _a[bitem.FnItem.prototype.kind] = bitem.FnItem,
            _a[bitem.NotItem.prototype.kind] = bitem.NotItem,
            _a[bitem.NonscriptItem.prototype.kind] = bitem.NonscriptItem,
            _a[bitem.DotsItem.prototype.kind] = bitem.DotsItem,
            _a[bitem.ArrayItem.prototype.kind] = bitem.ArrayItem,
            _a[bitem.EqnArrayItem.prototype.kind] = bitem.EqnArrayItem,
            _a[bitem.EquationItem.prototype.kind] = bitem.EquationItem,
            _a),
        options: {
            maxMacros: 1000,
            baseURL: (typeof (document) === 'undefined' ||
                document.getElementsByTagName('base').length === 0) ?
                '' : String(document.location).replace(/#.*$/, '')
        },
        tags: {
            base: BaseTags
        },
        postprocessors: [[filterNonscript, -4]]
    });
},
660: /* mathjax-full/js/input/tex/SymbolMap.js */ function _(require, module, exports, __esModule, __esExport) {
    var __extends = (this && this.__extends) || (function () {
        var extendStatics = function (d, b) {
            extendStatics = Object.setPrototypeOf ||
                ({ __proto__: [] } instanceof Array && function (d, b) { d.__proto__ = b; }) ||
                function (d, b) { for (var p in b)
                    if (Object.prototype.hasOwnProperty.call(b, p))
                        d[p] = b[p]; };
            return extendStatics(d, b);
        };
        return function (d, b) {
            if (typeof b !== "function" && b !== null)
                throw new TypeError("Class extends value " + String(b) + " is not a constructor or null");
            extendStatics(d, b);
            function __() { this.constructor = d; }
            d.prototype = b === null ? Object.create(b) : (__.prototype = b.prototype, new __());
        };
    })();
    var __read = (this && this.__read) || function (o, n) {
        var m = typeof Symbol === "function" && o[Symbol.iterator];
        if (!m)
            return o;
        var i = m.call(o), r, ar = [], e;
        try {
            while ((n === void 0 || n-- > 0) && !(r = i.next()).done)
                ar.push(r.value);
        }
        catch (error) {
            e = { error: error };
        }
        finally {
            try {
                if (r && !r.done && (m = i["return"]))
                    m.call(i);
            }
            finally {
                if (e)
                    throw e.error;
            }
        }
        return ar;
    };
    var __values = (this && this.__values) || function (o) {
        var s = typeof Symbol === "function" && Symbol.iterator, m = s && o[s], i = 0;
        if (m)
            return m.call(o);
        if (o && typeof o.length === "number")
            return {
                next: function () {
                    if (o && i >= o.length)
                        o = void 0;
                    return { value: o && o[i++], done: !o };
                }
            };
        throw new TypeError(s ? "Object is not iterable." : "Symbol.iterator is not defined.");
    };
    var __spreadArray = (this && this.__spreadArray) || function (to, from, pack) {
        if (pack || arguments.length === 2)
            for (var i = 0, l = from.length, ar; i < l; i++) {
                if (ar || !(i in from)) {
                    if (!ar)
                        ar = Array.prototype.slice.call(from, 0, i);
                    ar[i] = from[i];
                }
            }
        return to.concat(ar || Array.prototype.slice.call(from));
    };
    __esModule();
    var Symbol_js_1 = require(661) /* ./Symbol.js */;
    var MapHandler_js_1 = require(658) /* ./MapHandler.js */;
    function parseResult(result) {
        return result === void 0 ? true : result;
    }
    exports.parseResult = parseResult;
    var AbstractSymbolMap = (function () {
        function AbstractSymbolMap(_name, _parser) {
            this._name = _name;
            this._parser = _parser;
            MapHandler_js_1.MapHandler.register(this);
        }
        Object.defineProperty(AbstractSymbolMap.prototype, "name", {
            get: function () {
                return this._name;
            },
            enumerable: false,
            configurable: true
        });
        AbstractSymbolMap.prototype.parserFor = function (symbol) {
            return this.contains(symbol) ? this.parser : null;
        };
        AbstractSymbolMap.prototype.parse = function (_a) {
            var _b = __read(_a, 2), env = _b[0], symbol = _b[1];
            var parser = this.parserFor(symbol);
            var mapped = this.lookup(symbol);
            return (parser && mapped) ? parseResult(parser(env, mapped)) : null;
        };
        Object.defineProperty(AbstractSymbolMap.prototype, "parser", {
            get: function () {
                return this._parser;
            },
            set: function (parser) {
                this._parser = parser;
            },
            enumerable: false,
            configurable: true
        });
        return AbstractSymbolMap;
    }());
    exports.AbstractSymbolMap = AbstractSymbolMap;
    var RegExpMap = (function (_super) {
        __extends(RegExpMap, _super);
        function RegExpMap(name, parser, _regExp) {
            var _this = _super.call(this, name, parser) || this;
            _this._regExp = _regExp;
            return _this;
        }
        RegExpMap.prototype.contains = function (symbol) {
            return this._regExp.test(symbol);
        };
        RegExpMap.prototype.lookup = function (symbol) {
            return this.contains(symbol) ? symbol : null;
        };
        return RegExpMap;
    }(AbstractSymbolMap));
    exports.RegExpMap = RegExpMap;
    var AbstractParseMap = (function (_super) {
        __extends(AbstractParseMap, _super);
        function AbstractParseMap() {
            var _this = _super !== null && _super.apply(this, arguments) || this;
            _this.map = new Map();
            return _this;
        }
        AbstractParseMap.prototype.lookup = function (symbol) {
            return this.map.get(symbol);
        };
        AbstractParseMap.prototype.contains = function (symbol) {
            return this.map.has(symbol);
        };
        AbstractParseMap.prototype.add = function (symbol, object) {
            this.map.set(symbol, object);
        };
        AbstractParseMap.prototype.remove = function (symbol) {
            this.map.delete(symbol);
        };
        return AbstractParseMap;
    }(AbstractSymbolMap));
    exports.AbstractParseMap = AbstractParseMap;
    var CharacterMap = (function (_super) {
        __extends(CharacterMap, _super);
        function CharacterMap(name, parser, json) {
            var e_1, _a;
            var _this = _super.call(this, name, parser) || this;
            try {
                for (var _b = __values(Object.keys(json)), _c = _b.next(); !_c.done; _c = _b.next()) {
                    var key = _c.value;
                    var value = json[key];
                    var _d = __read((typeof (value) === 'string') ? [value, null] : value, 2), char = _d[0], attrs = _d[1];
                    var character = new Symbol_js_1.Symbol(key, char, attrs);
                    _this.add(key, character);
                }
            }
            catch (e_1_1) {
                e_1 = { error: e_1_1 };
            }
            finally {
                try {
                    if (_c && !_c.done && (_a = _b.return))
                        _a.call(_b);
                }
                finally {
                    if (e_1)
                        throw e_1.error;
                }
            }
            return _this;
        }
        return CharacterMap;
    }(AbstractParseMap));
    exports.CharacterMap = CharacterMap;
    var DelimiterMap = (function (_super) {
        __extends(DelimiterMap, _super);
        function DelimiterMap() {
            return _super !== null && _super.apply(this, arguments) || this;
        }
        DelimiterMap.prototype.parse = function (_a) {
            var _b = __read(_a, 2), env = _b[0], symbol = _b[1];
            return _super.prototype.parse.call(this, [env, '\\' + symbol]);
        };
        return DelimiterMap;
    }(CharacterMap));
    exports.DelimiterMap = DelimiterMap;
    var MacroMap = (function (_super) {
        __extends(MacroMap, _super);
        function MacroMap(name, json, functionMap) {
            var e_2, _a;
            var _this = _super.call(this, name, null) || this;
            try {
                for (var _b = __values(Object.keys(json)), _c = _b.next(); !_c.done; _c = _b.next()) {
                    var key = _c.value;
                    var value = json[key];
                    var _d = __read((typeof (value) === 'string') ? [value] : value), func = _d[0], attrs = _d.slice(1);
                    var character = new Symbol_js_1.Macro(key, functionMap[func], attrs);
                    _this.add(key, character);
                }
            }
            catch (e_2_1) {
                e_2 = { error: e_2_1 };
            }
            finally {
                try {
                    if (_c && !_c.done && (_a = _b.return))
                        _a.call(_b);
                }
                finally {
                    if (e_2)
                        throw e_2.error;
                }
            }
            return _this;
        }
        MacroMap.prototype.parserFor = function (symbol) {
            var macro = this.lookup(symbol);
            return macro ? macro.func : null;
        };
        MacroMap.prototype.parse = function (_a) {
            var _b = __read(_a, 2), env = _b[0], symbol = _b[1];
            var macro = this.lookup(symbol);
            var parser = this.parserFor(symbol);
            if (!macro || !parser) {
                return null;
            }
            return parseResult(parser.apply(void 0, __spreadArray([env, macro.symbol], __read(macro.args), false)));
        };
        return MacroMap;
    }(AbstractParseMap));
    exports.MacroMap = MacroMap;
    var CommandMap = (function (_super) {
        __extends(CommandMap, _super);
        function CommandMap() {
            return _super !== null && _super.apply(this, arguments) || this;
        }
        CommandMap.prototype.parse = function (_a) {
            var _b = __read(_a, 2), env = _b[0], symbol = _b[1];
            var macro = this.lookup(symbol);
            var parser = this.parserFor(symbol);
            if (!macro || !parser) {
                return null;
            }
            var saveCommand = env.currentCS;
            env.currentCS = '\\' + symbol;
            var result = parser.apply(void 0, __spreadArray([env, '\\' + macro.symbol], __read(macro.args), false));
            env.currentCS = saveCommand;
            return parseResult(result);
        };
        return CommandMap;
    }(MacroMap));
    exports.CommandMap = CommandMap;
    var EnvironmentMap = (function (_super) {
        __extends(EnvironmentMap, _super);
        function EnvironmentMap(name, parser, json, functionMap) {
            var _this = _super.call(this, name, json, functionMap) || this;
            _this.parser = parser;
            return _this;
        }
        EnvironmentMap.prototype.parse = function (_a) {
            var _b = __read(_a, 2), env = _b[0], symbol = _b[1];
            var macro = this.lookup(symbol);
            var envParser = this.parserFor(symbol);
            if (!macro || !envParser) {
                return null;
            }
            return parseResult(this.parser(env, macro.symbol, envParser, macro.args));
        };
        return EnvironmentMap;
    }(MacroMap));
    exports.EnvironmentMap = EnvironmentMap;
},
661: /* mathjax-full/js/input/tex/Symbol.js */ function _(require, module, exports, __esModule, __esExport) {
    __esModule();
    var Symbol = (function () {
        function Symbol(_symbol, _char, _attributes) {
            this._symbol = _symbol;
            this._char = _char;
            this._attributes = _attributes;
        }
        Object.defineProperty(Symbol.prototype, "symbol", {
            get: function () {
                return this._symbol;
            },
            enumerable: false,
            configurable: true
        });
        Object.defineProperty(Symbol.prototype, "char", {
            get: function () {
                return this._char;
            },
            enumerable: false,
            configurable: true
        });
        Object.defineProperty(Symbol.prototype, "attributes", {
            get: function () {
                return this._attributes;
            },
            enumerable: false,
            configurable: true
        });
        return Symbol;
    }());
    exports.Symbol = Symbol;
    var Macro = (function () {
        function Macro(_symbol, _func, _args) {
            if (_args === void 0) {
                _args = [];
            }
            this._symbol = _symbol;
            this._func = _func;
            this._args = _args;
        }
        Object.defineProperty(Macro.prototype, "symbol", {
            get: function () {
                return this._symbol;
            },
            enumerable: false,
            configurable: true
        });
        Object.defineProperty(Macro.prototype, "func", {
            get: function () {
                return this._func;
            },
            enumerable: false,
            configurable: true
        });
        Object.defineProperty(Macro.prototype, "args", {
            get: function () {
                return this._args;
            },
            enumerable: false,
            configurable: true
        });
        return Macro;
    }());
    exports.Macro = Macro;
},
662: /* mathjax-full/js/input/tex/base/BaseItems.js */ function _(require, module, exports, __esModule, __esExport) {
    var __extends = (this && this.__extends) || (function () {
        var extendStatics = function (d, b) {
            extendStatics = Object.setPrototypeOf ||
                ({ __proto__: [] } instanceof Array && function (d, b) { d.__proto__ = b; }) ||
                function (d, b) { for (var p in b)
                    if (Object.prototype.hasOwnProperty.call(b, p))
                        d[p] = b[p]; };
            return extendStatics(d, b);
        };
        return function (d, b) {
            if (typeof b !== "function" && b !== null)
                throw new TypeError("Class extends value " + String(b) + " is not a constructor or null");
            extendStatics(d, b);
            function __() { this.constructor = d; }
            d.prototype = b === null ? Object.create(b) : (__.prototype = b.prototype, new __());
        };
    })();
    var __read = (this && this.__read) || function (o, n) {
        var m = typeof Symbol === "function" && o[Symbol.iterator];
        if (!m)
            return o;
        var i = m.call(o), r, ar = [], e;
        try {
            while ((n === void 0 || n-- > 0) && !(r = i.next()).done)
                ar.push(r.value);
        }
        catch (error) {
            e = { error: error };
        }
        finally {
            try {
                if (r && !r.done && (m = i["return"]))
                    m.call(i);
            }
            finally {
                if (e)
                    throw e.error;
            }
        }
        return ar;
    };
    var __spreadArray = (this && this.__spreadArray) || function (to, from, pack) {
        if (pack || arguments.length === 2)
            for (var i = 0, l = from.length, ar; i < l; i++) {
                if (ar || !(i in from)) {
                    if (!ar)
                        ar = Array.prototype.slice.call(from, 0, i);
                    ar[i] = from[i];
                }
            }
        return to.concat(ar || Array.prototype.slice.call(from));
    };
    var __importDefault = (this && this.__importDefault) || function (mod) {
        return (mod && mod.__esModule) ? mod : { "default": mod };
    };
    __esModule();
    var MapHandler_js_1 = require(658) /* ../MapHandler.js */;
    var Entities_js_1 = require(648) /* ../../../util/Entities.js */;
    var MmlNode_js_1 = require(639) /* ../../../core/MmlTree/MmlNode.js */;
    var TexError_js_1 = __importDefault(require(647) /* ../TexError.js */);
    var ParseUtil_js_1 = __importDefault(require(646) /* ../ParseUtil.js */);
    var NodeUtil_js_1 = __importDefault(require(642) /* ../NodeUtil.js */);
    var StackItem_js_1 = require(653) /* ../StackItem.js */;
    var StartItem = (function (_super) {
        __extends(StartItem, _super);
        function StartItem(factory, global) {
            var _this = _super.call(this, factory) || this;
            _this.global = global;
            return _this;
        }
        Object.defineProperty(StartItem.prototype, "kind", {
            get: function () {
                return 'start';
            },
            enumerable: false,
            configurable: true
        });
        Object.defineProperty(StartItem.prototype, "isOpen", {
            get: function () {
                return true;
            },
            enumerable: false,
            configurable: true
        });
        StartItem.prototype.checkItem = function (item) {
            if (item.isKind('stop')) {
                var node = this.toMml();
                if (!this.global.isInner) {
                    node = this.factory.configuration.tags.finalize(node, this.env);
                }
                return [[this.factory.create('mml', node)], true];
            }
            return _super.prototype.checkItem.call(this, item);
        };
        return StartItem;
    }(StackItem_js_1.BaseItem));
    exports.StartItem = StartItem;
    var StopItem = (function (_super) {
        __extends(StopItem, _super);
        function StopItem() {
            return _super !== null && _super.apply(this, arguments) || this;
        }
        Object.defineProperty(StopItem.prototype, "kind", {
            get: function () {
                return 'stop';
            },
            enumerable: false,
            configurable: true
        });
        Object.defineProperty(StopItem.prototype, "isClose", {
            get: function () {
                return true;
            },
            enumerable: false,
            configurable: true
        });
        return StopItem;
    }(StackItem_js_1.BaseItem));
    exports.StopItem = StopItem;
    var OpenItem = (function (_super) {
        __extends(OpenItem, _super);
        function OpenItem() {
            return _super !== null && _super.apply(this, arguments) || this;
        }
        Object.defineProperty(OpenItem.prototype, "kind", {
            get: function () {
                return 'open';
            },
            enumerable: false,
            configurable: true
        });
        Object.defineProperty(OpenItem.prototype, "isOpen", {
            get: function () {
                return true;
            },
            enumerable: false,
            configurable: true
        });
        OpenItem.prototype.checkItem = function (item) {
            if (item.isKind('close')) {
                var mml = this.toMml();
                var node = this.create('node', 'TeXAtom', [mml]);
                return [[this.factory.create('mml', node)], true];
            }
            return _super.prototype.checkItem.call(this, item);
        };
        OpenItem.errors = Object.assign(Object.create(StackItem_js_1.BaseItem.errors), {
            'stop': ['ExtraOpenMissingClose',
                'Extra open brace or missing close brace']
        });
        return OpenItem;
    }(StackItem_js_1.BaseItem));
    exports.OpenItem = OpenItem;
    var CloseItem = (function (_super) {
        __extends(CloseItem, _super);
        function CloseItem() {
            return _super !== null && _super.apply(this, arguments) || this;
        }
        Object.defineProperty(CloseItem.prototype, "kind", {
            get: function () {
                return 'close';
            },
            enumerable: false,
            configurable: true
        });
        Object.defineProperty(CloseItem.prototype, "isClose", {
            get: function () {
                return true;
            },
            enumerable: false,
            configurable: true
        });
        return CloseItem;
    }(StackItem_js_1.BaseItem));
    exports.CloseItem = CloseItem;
    var PrimeItem = (function (_super) {
        __extends(PrimeItem, _super);
        function PrimeItem() {
            return _super !== null && _super.apply(this, arguments) || this;
        }
        Object.defineProperty(PrimeItem.prototype, "kind", {
            get: function () {
                return 'prime';
            },
            enumerable: false,
            configurable: true
        });
        PrimeItem.prototype.checkItem = function (item) {
            var _a = __read(this.Peek(2), 2), top0 = _a[0], top1 = _a[1];
            if (!NodeUtil_js_1.default.isType(top0, 'msubsup') || NodeUtil_js_1.default.isType(top0, 'msup')) {
                var node = this.create('node', 'msup', [top0, top1]);
                return [[node, item], true];
            }
            NodeUtil_js_1.default.setChild(top0, top0.sup, top1);
            return [[top0, item], true];
        };
        return PrimeItem;
    }(StackItem_js_1.BaseItem));
    exports.PrimeItem = PrimeItem;
    var SubsupItem = (function (_super) {
        __extends(SubsupItem, _super);
        function SubsupItem() {
            return _super !== null && _super.apply(this, arguments) || this;
        }
        Object.defineProperty(SubsupItem.prototype, "kind", {
            get: function () {
                return 'subsup';
            },
            enumerable: false,
            configurable: true
        });
        SubsupItem.prototype.checkItem = function (item) {
            if (item.isKind('open') || item.isKind('left')) {
                return StackItem_js_1.BaseItem.success;
            }
            var top = this.First;
            var position = this.getProperty('position');
            if (item.isKind('mml')) {
                if (this.getProperty('primes')) {
                    if (position !== 2) {
                        NodeUtil_js_1.default.setChild(top, 2, this.getProperty('primes'));
                    }
                    else {
                        NodeUtil_js_1.default.setProperty(this.getProperty('primes'), 'variantForm', true);
                        var node = this.create('node', 'mrow', [this.getProperty('primes'), item.First]);
                        item.First = node;
                    }
                }
                NodeUtil_js_1.default.setChild(top, position, item.First);
                if (this.getProperty('movesupsub') != null) {
                    NodeUtil_js_1.default.setProperty(top, 'movesupsub', this.getProperty('movesupsub'));
                }
                var result = this.factory.create('mml', top);
                return [[result], true];
            }
            if (_super.prototype.checkItem.call(this, item)[1]) {
                var error = this.getErrors(['', 'sub', 'sup'][position]);
                throw new (TexError_js_1.default.bind.apply(TexError_js_1.default, __spreadArray([void 0, error[0], error[1]], __read(error.splice(2)), false)))();
            }
            return null;
        };
        SubsupItem.errors = Object.assign(Object.create(StackItem_js_1.BaseItem.errors), {
            'stop': ['MissingScript',
                'Missing superscript or subscript argument'],
            'sup': ['MissingOpenForSup',
                'Missing open brace for superscript'],
            'sub': ['MissingOpenForSub',
                'Missing open brace for subscript']
        });
        return SubsupItem;
    }(StackItem_js_1.BaseItem));
    exports.SubsupItem = SubsupItem;
    var OverItem = (function (_super) {
        __extends(OverItem, _super);
        function OverItem(factory) {
            var _this = _super.call(this, factory) || this;
            _this.setProperty('name', '\\over');
            return _this;
        }
        Object.defineProperty(OverItem.prototype, "kind", {
            get: function () {
                return 'over';
            },
            enumerable: false,
            configurable: true
        });
        Object.defineProperty(OverItem.prototype, "isClose", {
            get: function () {
                return true;
            },
            enumerable: false,
            configurable: true
        });
        OverItem.prototype.checkItem = function (item) {
            if (item.isKind('over')) {
                throw new TexError_js_1.default('AmbiguousUseOf', 'Ambiguous use of %1', item.getName());
            }
            if (item.isClose) {
                var mml = this.create('node', 'mfrac', [this.getProperty('num'), this.toMml(false)]);
                if (this.getProperty('thickness') != null) {
                    NodeUtil_js_1.default.setAttribute(mml, 'linethickness', this.getProperty('thickness'));
                }
                if (this.getProperty('open') || this.getProperty('close')) {
                    NodeUtil_js_1.default.setProperty(mml, 'withDelims', true);
                    mml = ParseUtil_js_1.default.fixedFence(this.factory.configuration, this.getProperty('open'), mml, this.getProperty('close'));
                }
                return [[this.factory.create('mml', mml), item], true];
            }
            return _super.prototype.checkItem.call(this, item);
        };
        OverItem.prototype.toString = function () {
            return 'over[' + this.getProperty('num') +
                ' / ' + this.nodes.join('; ') + ']';
        };
        return OverItem;
    }(StackItem_js_1.BaseItem));
    exports.OverItem = OverItem;
    var LeftItem = (function (_super) {
        __extends(LeftItem, _super);
        function LeftItem(factory, delim) {
            var _this = _super.call(this, factory) || this;
            _this.setProperty('delim', delim);
            return _this;
        }
        Object.defineProperty(LeftItem.prototype, "kind", {
            get: function () {
                return 'left';
            },
            enumerable: false,
            configurable: true
        });
        Object.defineProperty(LeftItem.prototype, "isOpen", {
            get: function () {
                return true;
            },
            enumerable: false,
            configurable: true
        });
        LeftItem.prototype.checkItem = function (item) {
            if (item.isKind('right')) {
                return [[this.factory.create('mml', ParseUtil_js_1.default.fenced(this.factory.configuration, this.getProperty('delim'), this.toMml(), item.getProperty('delim'), '', item.getProperty('color')))], true];
            }
            if (item.isKind('middle')) {
                var def = { stretchy: true };
                if (item.getProperty('color')) {
                    def.mathcolor = item.getProperty('color');
                }
                this.Push(this.create('node', 'TeXAtom', [], { texClass: MmlNode_js_1.TEXCLASS.CLOSE }), this.create('token', 'mo', def, item.getProperty('delim')), this.create('node', 'TeXAtom', [], { texClass: MmlNode_js_1.TEXCLASS.OPEN }));
                this.env = {};
                return [[this], true];
            }
            return _super.prototype.checkItem.call(this, item);
        };
        LeftItem.errors = Object.assign(Object.create(StackItem_js_1.BaseItem.errors), {
            'stop': ['ExtraLeftMissingRight',
                'Extra \\left or missing \\right']
        });
        return LeftItem;
    }(StackItem_js_1.BaseItem));
    exports.LeftItem = LeftItem;
    var Middle = (function (_super) {
        __extends(Middle, _super);
        function Middle(factory, delim, color) {
            var _this = _super.call(this, factory) || this;
            _this.setProperty('delim', delim);
            color && _this.setProperty('color', color);
            return _this;
        }
        Object.defineProperty(Middle.prototype, "kind", {
            get: function () {
                return 'middle';
            },
            enumerable: false,
            configurable: true
        });
        Object.defineProperty(Middle.prototype, "isClose", {
            get: function () {
                return true;
            },
            enumerable: false,
            configurable: true
        });
        return Middle;
    }(StackItem_js_1.BaseItem));
    exports.Middle = Middle;
    var RightItem = (function (_super) {
        __extends(RightItem, _super);
        function RightItem(factory, delim, color) {
            var _this = _super.call(this, factory) || this;
            _this.setProperty('delim', delim);
            color && _this.setProperty('color', color);
            return _this;
        }
        Object.defineProperty(RightItem.prototype, "kind", {
            get: function () {
                return 'right';
            },
            enumerable: false,
            configurable: true
        });
        Object.defineProperty(RightItem.prototype, "isClose", {
            get: function () {
                return true;
            },
            enumerable: false,
            configurable: true
        });
        return RightItem;
    }(StackItem_js_1.BaseItem));
    exports.RightItem = RightItem;
    var BeginItem = (function (_super) {
        __extends(BeginItem, _super);
        function BeginItem() {
            return _super !== null && _super.apply(this, arguments) || this;
        }
        Object.defineProperty(BeginItem.prototype, "kind", {
            get: function () {
                return 'begin';
            },
            enumerable: false,
            configurable: true
        });
        Object.defineProperty(BeginItem.prototype, "isOpen", {
            get: function () {
                return true;
            },
            enumerable: false,
            configurable: true
        });
        BeginItem.prototype.checkItem = function (item) {
            if (item.isKind('end')) {
                if (item.getName() !== this.getName()) {
                    throw new TexError_js_1.default('EnvBadEnd', '\\begin{%1} ended with \\end{%2}', this.getName(), item.getName());
                }
                if (!this.getProperty('end')) {
                    return [[this.factory.create('mml', this.toMml())], true];
                }
                return StackItem_js_1.BaseItem.fail;
            }
            if (item.isKind('stop')) {
                throw new TexError_js_1.default('EnvMissingEnd', 'Missing \\end{%1}', this.getName());
            }
            return _super.prototype.checkItem.call(this, item);
        };
        return BeginItem;
    }(StackItem_js_1.BaseItem));
    exports.BeginItem = BeginItem;
    var EndItem = (function (_super) {
        __extends(EndItem, _super);
        function EndItem() {
            return _super !== null && _super.apply(this, arguments) || this;
        }
        Object.defineProperty(EndItem.prototype, "kind", {
            get: function () {
                return 'end';
            },
            enumerable: false,
            configurable: true
        });
        Object.defineProperty(EndItem.prototype, "isClose", {
            get: function () {
                return true;
            },
            enumerable: false,
            configurable: true
        });
        return EndItem;
    }(StackItem_js_1.BaseItem));
    exports.EndItem = EndItem;
    var StyleItem = (function (_super) {
        __extends(StyleItem, _super);
        function StyleItem() {
            return _super !== null && _super.apply(this, arguments) || this;
        }
        Object.defineProperty(StyleItem.prototype, "kind", {
            get: function () {
                return 'style';
            },
            enumerable: false,
            configurable: true
        });
        StyleItem.prototype.checkItem = function (item) {
            if (!item.isClose) {
                return _super.prototype.checkItem.call(this, item);
            }
            var mml = this.create('node', 'mstyle', this.nodes, this.getProperty('styles'));
            return [[this.factory.create('mml', mml), item], true];
        };
        return StyleItem;
    }(StackItem_js_1.BaseItem));
    exports.StyleItem = StyleItem;
    var PositionItem = (function (_super) {
        __extends(PositionItem, _super);
        function PositionItem() {
            return _super !== null && _super.apply(this, arguments) || this;
        }
        Object.defineProperty(PositionItem.prototype, "kind", {
            get: function () {
                return 'position';
            },
            enumerable: false,
            configurable: true
        });
        PositionItem.prototype.checkItem = function (item) {
            if (item.isClose) {
                throw new TexError_js_1.default('MissingBoxFor', 'Missing box for %1', this.getName());
            }
            if (item.isFinal) {
                var mml = item.toMml();
                switch (this.getProperty('move')) {
                    case 'vertical':
                        mml = this.create('node', 'mpadded', [mml], { height: this.getProperty('dh'),
                            depth: this.getProperty('dd'),
                            voffset: this.getProperty('dh') });
                        return [[this.factory.create('mml', mml)], true];
                    case 'horizontal':
                        return [[this.factory.create('mml', this.getProperty('left')), item,
                                this.factory.create('mml', this.getProperty('right'))], true];
                }
            }
            return _super.prototype.checkItem.call(this, item);
        };
        return PositionItem;
    }(StackItem_js_1.BaseItem));
    exports.PositionItem = PositionItem;
    var CellItem = (function (_super) {
        __extends(CellItem, _super);
        function CellItem() {
            return _super !== null && _super.apply(this, arguments) || this;
        }
        Object.defineProperty(CellItem.prototype, "kind", {
            get: function () {
                return 'cell';
            },
            enumerable: false,
            configurable: true
        });
        Object.defineProperty(CellItem.prototype, "isClose", {
            get: function () {
                return true;
            },
            enumerable: false,
            configurable: true
        });
        return CellItem;
    }(StackItem_js_1.BaseItem));
    exports.CellItem = CellItem;
    var MmlItem = (function (_super) {
        __extends(MmlItem, _super);
        function MmlItem() {
            return _super !== null && _super.apply(this, arguments) || this;
        }
        Object.defineProperty(MmlItem.prototype, "isFinal", {
            get: function () {
                return true;
            },
            enumerable: false,
            configurable: true
        });
        Object.defineProperty(MmlItem.prototype, "kind", {
            get: function () {
                return 'mml';
            },
            enumerable: false,
            configurable: true
        });
        return MmlItem;
    }(StackItem_js_1.BaseItem));
    exports.MmlItem = MmlItem;
    var FnItem = (function (_super) {
        __extends(FnItem, _super);
        function FnItem() {
            return _super !== null && _super.apply(this, arguments) || this;
        }
        Object.defineProperty(FnItem.prototype, "kind", {
            get: function () {
                return 'fn';
            },
            enumerable: false,
            configurable: true
        });
        FnItem.prototype.checkItem = function (item) {
            var top = this.First;
            if (top) {
                if (item.isOpen) {
                    return StackItem_js_1.BaseItem.success;
                }
                if (!item.isKind('fn')) {
                    var mml = item.First;
                    if (!item.isKind('mml') || !mml) {
                        return [[top, item], true];
                    }
                    if ((NodeUtil_js_1.default.isType(mml, 'mstyle') && mml.childNodes.length &&
                        NodeUtil_js_1.default.isType(mml.childNodes[0].childNodes[0], 'mspace')) ||
                        NodeUtil_js_1.default.isType(mml, 'mspace')) {
                        return [[top, item], true];
                    }
                    if (NodeUtil_js_1.default.isEmbellished(mml)) {
                        mml = NodeUtil_js_1.default.getCoreMO(mml);
                    }
                    var form = NodeUtil_js_1.default.getForm(mml);
                    if (form != null && [0, 0, 1, 1, 0, 1, 1, 0, 0, 0][form[2]]) {
                        return [[top, item], true];
                    }
                }
                var node = this.create('token', 'mo', { texClass: MmlNode_js_1.TEXCLASS.NONE }, Entities_js_1.entities.ApplyFunction);
                return [[top, node, item], true];
            }
            return _super.prototype.checkItem.apply(this, arguments);
        };
        return FnItem;
    }(StackItem_js_1.BaseItem));
    exports.FnItem = FnItem;
    var NotItem = (function (_super) {
        __extends(NotItem, _super);
        function NotItem() {
            var _this = _super !== null && _super.apply(this, arguments) || this;
            _this.remap = MapHandler_js_1.MapHandler.getMap('not_remap');
            return _this;
        }
        Object.defineProperty(NotItem.prototype, "kind", {
            get: function () {
                return 'not';
            },
            enumerable: false,
            configurable: true
        });
        NotItem.prototype.checkItem = function (item) {
            var mml;
            var c;
            var textNode;
            if (item.isKind('open') || item.isKind('left')) {
                return StackItem_js_1.BaseItem.success;
            }
            if (item.isKind('mml') &&
                (NodeUtil_js_1.default.isType(item.First, 'mo') || NodeUtil_js_1.default.isType(item.First, 'mi') ||
                    NodeUtil_js_1.default.isType(item.First, 'mtext'))) {
                mml = item.First;
                c = NodeUtil_js_1.default.getText(mml);
                if (c.length === 1 && !NodeUtil_js_1.default.getProperty(mml, 'movesupsub') &&
                    NodeUtil_js_1.default.getChildren(mml).length === 1) {
                    if (this.remap.contains(c)) {
                        textNode = this.create('text', this.remap.lookup(c).char);
                        NodeUtil_js_1.default.setChild(mml, 0, textNode);
                    }
                    else {
                        textNode = this.create('text', '\u0338');
                        NodeUtil_js_1.default.appendChildren(mml, [textNode]);
                    }
                    return [[item], true];
                }
            }
            textNode = this.create('text', '\u29F8');
            var mtextNode = this.create('node', 'mtext', [], {}, textNode);
            var paddedNode = this.create('node', 'mpadded', [mtextNode], { width: 0 });
            mml = this.create('node', 'TeXAtom', [paddedNode], { texClass: MmlNode_js_1.TEXCLASS.REL });
            return [[mml, item], true];
        };
        return NotItem;
    }(StackItem_js_1.BaseItem));
    exports.NotItem = NotItem;
    var NonscriptItem = (function (_super) {
        __extends(NonscriptItem, _super);
        function NonscriptItem() {
            return _super !== null && _super.apply(this, arguments) || this;
        }
        Object.defineProperty(NonscriptItem.prototype, "kind", {
            get: function () {
                return 'nonscript';
            },
            enumerable: false,
            configurable: true
        });
        NonscriptItem.prototype.checkItem = function (item) {
            if (item.isKind('mml') && item.Size() === 1) {
                var mml = item.First;
                if (mml.isKind('mstyle') && mml.notParent) {
                    mml = NodeUtil_js_1.default.getChildren(NodeUtil_js_1.default.getChildren(mml)[0])[0];
                }
                if (mml.isKind('mspace')) {
                    if (mml !== item.First) {
                        var mrow = this.create('node', 'mrow', [item.Pop()]);
                        item.Push(mrow);
                    }
                    this.factory.configuration.addNode('nonscript', item.First);
                }
            }
            return [[item], true];
        };
        return NonscriptItem;
    }(StackItem_js_1.BaseItem));
    exports.NonscriptItem = NonscriptItem;
    var DotsItem = (function (_super) {
        __extends(DotsItem, _super);
        function DotsItem() {
            return _super !== null && _super.apply(this, arguments) || this;
        }
        Object.defineProperty(DotsItem.prototype, "kind", {
            get: function () {
                return 'dots';
            },
            enumerable: false,
            configurable: true
        });
        DotsItem.prototype.checkItem = function (item) {
            if (item.isKind('open') || item.isKind('left')) {
                return StackItem_js_1.BaseItem.success;
            }
            var dots = this.getProperty('ldots');
            var top = item.First;
            if (item.isKind('mml') && NodeUtil_js_1.default.isEmbellished(top)) {
                var tclass = NodeUtil_js_1.default.getTexClass(NodeUtil_js_1.default.getCoreMO(top));
                if (tclass === MmlNode_js_1.TEXCLASS.BIN || tclass === MmlNode_js_1.TEXCLASS.REL) {
                    dots = this.getProperty('cdots');
                }
            }
            return [[dots, item], true];
        };
        return DotsItem;
    }(StackItem_js_1.BaseItem));
    exports.DotsItem = DotsItem;
    var ArrayItem = (function (_super) {
        __extends(ArrayItem, _super);
        function ArrayItem() {
            var _this = _super !== null && _super.apply(this, arguments) || this;
            _this.table = [];
            _this.row = [];
            _this.frame = [];
            _this.hfill = [];
            _this.arraydef = {};
            _this.dashed = false;
            return _this;
        }
        Object.defineProperty(ArrayItem.prototype, "kind", {
            get: function () {
                return 'array';
            },
            enumerable: false,
            configurable: true
        });
        Object.defineProperty(ArrayItem.prototype, "isOpen", {
            get: function () {
                return true;
            },
            enumerable: false,
            configurable: true
        });
        Object.defineProperty(ArrayItem.prototype, "copyEnv", {
            get: function () {
                return false;
            },
            enumerable: false,
            configurable: true
        });
        ArrayItem.prototype.checkItem = function (item) {
            if (item.isClose && !item.isKind('over')) {
                if (item.getProperty('isEntry')) {
                    this.EndEntry();
                    this.clearEnv();
                    return StackItem_js_1.BaseItem.fail;
                }
                if (item.getProperty('isCR')) {
                    this.EndEntry();
                    this.EndRow();
                    this.clearEnv();
                    return StackItem_js_1.BaseItem.fail;
                }
                this.EndTable();
                this.clearEnv();
                var newItem = this.factory.create('mml', this.createMml());
                if (this.getProperty('requireClose')) {
                    if (item.isKind('close')) {
                        return [[newItem], true];
                    }
                    throw new TexError_js_1.default('MissingCloseBrace', 'Missing close brace');
                }
                return [[newItem, item], true];
            }
            return _super.prototype.checkItem.call(this, item);
        };
        ArrayItem.prototype.createMml = function () {
            var scriptlevel = this.arraydef['scriptlevel'];
            delete this.arraydef['scriptlevel'];
            var mml = this.create('node', 'mtable', this.table, this.arraydef);
            if (scriptlevel) {
                mml.setProperty('scriptlevel', scriptlevel);
            }
            if (this.frame.length === 4) {
                NodeUtil_js_1.default.setAttribute(mml, 'frame', this.dashed ? 'dashed' : 'solid');
            }
            else if (this.frame.length) {
                if (this.arraydef['rowlines']) {
                    this.arraydef['rowlines'] =
                        this.arraydef['rowlines'].replace(/none( none)+$/, 'none');
                }
                NodeUtil_js_1.default.setAttribute(mml, 'frame', '');
                mml = this.create('node', 'menclose', [mml], { notation: this.frame.join(' ') });
                if ((this.arraydef['columnlines'] || 'none') !== 'none' ||
                    (this.arraydef['rowlines'] || 'none') !== 'none') {
                    NodeUtil_js_1.default.setAttribute(mml, 'data-padding', 0);
                }
            }
            if (this.getProperty('open') || this.getProperty('close')) {
                mml = ParseUtil_js_1.default.fenced(this.factory.configuration, this.getProperty('open'), mml, this.getProperty('close'));
            }
            return mml;
        };
        ArrayItem.prototype.EndEntry = function () {
            var mtd = this.create('node', 'mtd', this.nodes);
            if (this.hfill.length) {
                if (this.hfill[0] === 0) {
                    NodeUtil_js_1.default.setAttribute(mtd, 'columnalign', 'right');
                }
                if (this.hfill[this.hfill.length - 1] === this.Size()) {
                    NodeUtil_js_1.default.setAttribute(mtd, 'columnalign', NodeUtil_js_1.default.getAttribute(mtd, 'columnalign') ? 'center' : 'left');
                }
            }
            this.row.push(mtd);
            this.Clear();
            this.hfill = [];
        };
        ArrayItem.prototype.EndRow = function () {
            var node;
            if (this.getProperty('isNumbered') && this.row.length === 3) {
                this.row.unshift(this.row.pop());
                node = this.create('node', 'mlabeledtr', this.row);
            }
            else {
                node = this.create('node', 'mtr', this.row);
            }
            this.table.push(node);
            this.row = [];
        };
        ArrayItem.prototype.EndTable = function () {
            if (this.Size() || this.row.length) {
                this.EndEntry();
                this.EndRow();
            }
            this.checkLines();
        };
        ArrayItem.prototype.checkLines = function () {
            if (this.arraydef['rowlines']) {
                var lines = this.arraydef['rowlines'].split(/ /);
                if (lines.length === this.table.length) {
                    this.frame.push('bottom');
                    lines.pop();
                    this.arraydef['rowlines'] = lines.join(' ');
                }
                else if (lines.length < this.table.length - 1) {
                    this.arraydef['rowlines'] += ' none';
                }
            }
            if (this.getProperty('rowspacing')) {
                var rows = this.arraydef['rowspacing'].split(/ /);
                while (rows.length < this.table.length) {
                    rows.push(this.getProperty('rowspacing') + 'em');
                }
                this.arraydef['rowspacing'] = rows.join(' ');
            }
        };
        ArrayItem.prototype.addRowSpacing = function (spacing) {
            if (this.arraydef['rowspacing']) {
                var rows = this.arraydef['rowspacing'].split(/ /);
                if (!this.getProperty('rowspacing')) {
                    var dimem = ParseUtil_js_1.default.dimen2em(rows[0]);
                    this.setProperty('rowspacing', dimem);
                }
                var rowspacing = this.getProperty('rowspacing');
                while (rows.length < this.table.length) {
                    rows.push(ParseUtil_js_1.default.Em(rowspacing));
                }
                rows[this.table.length - 1] = ParseUtil_js_1.default.Em(Math.max(0, rowspacing + ParseUtil_js_1.default.dimen2em(spacing)));
                this.arraydef['rowspacing'] = rows.join(' ');
            }
        };
        return ArrayItem;
    }(StackItem_js_1.BaseItem));
    exports.ArrayItem = ArrayItem;
    var EqnArrayItem = (function (_super) {
        __extends(EqnArrayItem, _super);
        function EqnArrayItem(factory) {
            var args = [];
            for (var _i = 1; _i < arguments.length; _i++) {
                args[_i - 1] = arguments[_i];
            }
            var _this = _super.call(this, factory) || this;
            _this.maxrow = 0;
            _this.factory.configuration.tags.start(args[0], args[2], args[1]);
            return _this;
        }
        Object.defineProperty(EqnArrayItem.prototype, "kind", {
            get: function () {
                return 'eqnarray';
            },
            enumerable: false,
            configurable: true
        });
        EqnArrayItem.prototype.EndEntry = function () {
            if (this.row.length) {
                ParseUtil_js_1.default.fixInitialMO(this.factory.configuration, this.nodes);
            }
            var node = this.create('node', 'mtd', this.nodes);
            this.row.push(node);
            this.Clear();
        };
        EqnArrayItem.prototype.EndRow = function () {
            if (this.row.length > this.maxrow) {
                this.maxrow = this.row.length;
            }
            var mtr = 'mtr';
            var tag = this.factory.configuration.tags.getTag();
            if (tag) {
                this.row = [tag].concat(this.row);
                mtr = 'mlabeledtr';
            }
            this.factory.configuration.tags.clearTag();
            var node = this.create('node', mtr, this.row);
            this.table.push(node);
            this.row = [];
        };
        EqnArrayItem.prototype.EndTable = function () {
            _super.prototype.EndTable.call(this);
            this.factory.configuration.tags.end();
            this.extendArray('columnalign', this.maxrow);
            this.extendArray('columnwidth', this.maxrow);
            this.extendArray('columnspacing', this.maxrow - 1);
        };
        EqnArrayItem.prototype.extendArray = function (name, max) {
            if (!this.arraydef[name])
                return;
            var repeat = this.arraydef[name].split(/ /);
            var columns = __spreadArray([], __read(repeat), false);
            if (columns.length > 1) {
                while (columns.length < max) {
                    columns.push.apply(columns, __spreadArray([], __read(repeat), false));
                }
                this.arraydef[name] = columns.slice(0, max).join(' ');
            }
        };
        return EqnArrayItem;
    }(ArrayItem));
    exports.EqnArrayItem = EqnArrayItem;
    var EquationItem = (function (_super) {
        __extends(EquationItem, _super);
        function EquationItem(factory) {
            var args = [];
            for (var _i = 1; _i < arguments.length; _i++) {
                args[_i - 1] = arguments[_i];
            }
            var _this = _super.call(this, factory) || this;
            _this.factory.configuration.tags.start('equation', true, args[0]);
            return _this;
        }
        Object.defineProperty(EquationItem.prototype, "kind", {
            get: function () {
                return 'equation';
            },
            enumerable: false,
            configurable: true
        });
        Object.defineProperty(EquationItem.prototype, "isOpen", {
            get: function () {
                return true;
            },
            enumerable: false,
            configurable: true
        });
        EquationItem.prototype.checkItem = function (item) {
            if (item.isKind('end')) {
                var mml = this.toMml();
                var tag = this.factory.configuration.tags.getTag();
                this.factory.configuration.tags.end();
                return [[tag ? this.factory.configuration.tags.enTag(mml, tag) : mml, item], true];
            }
            if (item.isKind('stop')) {
                throw new TexError_js_1.default('EnvMissingEnd', 'Missing \\end{%1}', this.getName());
            }
            return _super.prototype.checkItem.call(this, item);
        };
        return EquationItem;
    }(StackItem_js_1.BaseItem));
    exports.EquationItem = EquationItem;
},
663: /* mathjax-full/js/input/tex/base/BaseMappings.js */ function _(require, module, exports, __esModule, __esExport) {
    var __createBinding = (this && this.__createBinding) || (Object.create ? (function (o, m, k, k2) {
        if (k2 === undefined)
            k2 = k;
        var desc = Object.getOwnPropertyDescriptor(m, k);
        if (!desc || ("get" in desc ? !m.__esModule : desc.writable || desc.configurable)) {
            desc = { enumerable: true, get: function () { return m[k]; } };
        }
        Object.defineProperty(o, k2, desc);
    }) : (function (o, m, k, k2) {
        if (k2 === undefined)
            k2 = k;
        o[k2] = m[k];
    }));
    var __setModuleDefault = (this && this.__setModuleDefault) || (Object.create ? (function (o, v) {
        Object.defineProperty(o, "default", { enumerable: true, value: v });
    }) : function (o, v) {
        o["default"] = v;
    });
    var __importStar = (this && this.__importStar) || function (mod) {
        if (mod && mod.__esModule)
            return mod;
        var result = {};
        if (mod != null)
            for (var k in mod)
                if (k !== "default" && Object.prototype.hasOwnProperty.call(mod, k))
                    __createBinding(result, mod, k);
        __setModuleDefault(result, mod);
        return result;
    };
    var __importDefault = (this && this.__importDefault) || function (mod) {
        return (mod && mod.__esModule) ? mod : { "default": mod };
    };
    __esModule();
    var sm = __importStar(require(660) /* ../SymbolMap.js */);
    var TexConstants_js_1 = require(664) /* ../TexConstants.js */;
    var BaseMethods_js_1 = __importDefault(require(665) /* ./BaseMethods.js */);
    var ParseMethods_js_1 = __importDefault(require(667) /* ../ParseMethods.js */);
    var ParseUtil_js_1 = __importDefault(require(646) /* ../ParseUtil.js */);
    var MmlNode_js_1 = require(639) /* ../../../core/MmlTree/MmlNode.js */;
    var lengths_js_1 = require(666) /* ../../../util/lengths.js */;
    new sm.RegExpMap('letter', ParseMethods_js_1.default.variable, /[a-z]/i);
    new sm.RegExpMap('digit', ParseMethods_js_1.default.digit, /[0-9.,]/);
    new sm.RegExpMap('command', ParseMethods_js_1.default.controlSequence, /^\\/);
    new sm.MacroMap('special', {
        '{': 'Open',
        '}': 'Close',
        '~': 'Tilde',
        '^': 'Superscript',
        '_': 'Subscript',
        ' ': 'Space',
        '\t': 'Space',
        '\r': 'Space',
        '\n': 'Space',
        '\'': 'Prime',
        '%': 'Comment',
        '&': 'Entry',
        '#': 'Hash',
        '\u00A0': 'Space',
        '\u2019': 'Prime'
    }, BaseMethods_js_1.default);
    new sm.CharacterMap('mathchar0mi', ParseMethods_js_1.default.mathchar0mi, {
        alpha: '\u03B1',
        beta: '\u03B2',
        gamma: '\u03B3',
        delta: '\u03B4',
        epsilon: '\u03F5',
        zeta: '\u03B6',
        eta: '\u03B7',
        theta: '\u03B8',
        iota: '\u03B9',
        kappa: '\u03BA',
        lambda: '\u03BB',
        mu: '\u03BC',
        nu: '\u03BD',
        xi: '\u03BE',
        omicron: '\u03BF',
        pi: '\u03C0',
        rho: '\u03C1',
        sigma: '\u03C3',
        tau: '\u03C4',
        upsilon: '\u03C5',
        phi: '\u03D5',
        chi: '\u03C7',
        psi: '\u03C8',
        omega: '\u03C9',
        varepsilon: '\u03B5',
        vartheta: '\u03D1',
        varpi: '\u03D6',
        varrho: '\u03F1',
        varsigma: '\u03C2',
        varphi: '\u03C6',
        S: ['\u00A7', { mathvariant: TexConstants_js_1.TexConstant.Variant.NORMAL }],
        aleph: ['\u2135', { mathvariant: TexConstants_js_1.TexConstant.Variant.NORMAL }],
        hbar: ['\u210F', { variantForm: true }],
        imath: '\u0131',
        jmath: '\u0237',
        ell: '\u2113',
        wp: ['\u2118', { mathvariant: TexConstants_js_1.TexConstant.Variant.NORMAL }],
        Re: ['\u211C', { mathvariant: TexConstants_js_1.TexConstant.Variant.NORMAL }],
        Im: ['\u2111', { mathvariant: TexConstants_js_1.TexConstant.Variant.NORMAL }],
        partial: ['\u2202', { mathvariant: TexConstants_js_1.TexConstant.Variant.ITALIC }],
        infty: ['\u221E', { mathvariant: TexConstants_js_1.TexConstant.Variant.NORMAL }],
        prime: ['\u2032', { variantForm: true }],
        emptyset: ['\u2205', { mathvariant: TexConstants_js_1.TexConstant.Variant.NORMAL }],
        nabla: ['\u2207', { mathvariant: TexConstants_js_1.TexConstant.Variant.NORMAL }],
        top: ['\u22A4', { mathvariant: TexConstants_js_1.TexConstant.Variant.NORMAL }],
        bot: ['\u22A5', { mathvariant: TexConstants_js_1.TexConstant.Variant.NORMAL }],
        angle: ['\u2220', { mathvariant: TexConstants_js_1.TexConstant.Variant.NORMAL }],
        triangle: ['\u25B3', { mathvariant: TexConstants_js_1.TexConstant.Variant.NORMAL }],
        backslash: ['\u2216', { mathvariant: TexConstants_js_1.TexConstant.Variant.NORMAL }],
        forall: ['\u2200', { mathvariant: TexConstants_js_1.TexConstant.Variant.NORMAL }],
        exists: ['\u2203', { mathvariant: TexConstants_js_1.TexConstant.Variant.NORMAL }],
        neg: ['\u00AC', { mathvariant: TexConstants_js_1.TexConstant.Variant.NORMAL }],
        lnot: ['\u00AC', { mathvariant: TexConstants_js_1.TexConstant.Variant.NORMAL }],
        flat: ['\u266D', { mathvariant: TexConstants_js_1.TexConstant.Variant.NORMAL }],
        natural: ['\u266E', { mathvariant: TexConstants_js_1.TexConstant.Variant.NORMAL }],
        sharp: ['\u266F', { mathvariant: TexConstants_js_1.TexConstant.Variant.NORMAL }],
        clubsuit: ['\u2663', { mathvariant: TexConstants_js_1.TexConstant.Variant.NORMAL }],
        diamondsuit: ['\u2662', { mathvariant: TexConstants_js_1.TexConstant.Variant.NORMAL }],
        heartsuit: ['\u2661', { mathvariant: TexConstants_js_1.TexConstant.Variant.NORMAL }],
        spadesuit: ['\u2660', { mathvariant: TexConstants_js_1.TexConstant.Variant.NORMAL }]
    });
    new sm.CharacterMap('mathchar0mo', ParseMethods_js_1.default.mathchar0mo, {
        surd: '\u221A',
        coprod: ['\u2210', { texClass: MmlNode_js_1.TEXCLASS.OP,
                movesupsub: true }],
        bigvee: ['\u22C1', { texClass: MmlNode_js_1.TEXCLASS.OP,
                movesupsub: true }],
        bigwedge: ['\u22C0', { texClass: MmlNode_js_1.TEXCLASS.OP,
                movesupsub: true }],
        biguplus: ['\u2A04', { texClass: MmlNode_js_1.TEXCLASS.OP,
                movesupsub: true }],
        bigcap: ['\u22C2', { texClass: MmlNode_js_1.TEXCLASS.OP,
                movesupsub: true }],
        bigcup: ['\u22C3', { texClass: MmlNode_js_1.TEXCLASS.OP,
                movesupsub: true }],
        'int': ['\u222B', { texClass: MmlNode_js_1.TEXCLASS.OP }],
        intop: ['\u222B', { texClass: MmlNode_js_1.TEXCLASS.OP,
                movesupsub: true, movablelimits: true }],
        iint: ['\u222C', { texClass: MmlNode_js_1.TEXCLASS.OP }],
        iiint: ['\u222D', { texClass: MmlNode_js_1.TEXCLASS.OP }],
        prod: ['\u220F', { texClass: MmlNode_js_1.TEXCLASS.OP,
                movesupsub: true }],
        sum: ['\u2211', { texClass: MmlNode_js_1.TEXCLASS.OP,
                movesupsub: true }],
        bigotimes: ['\u2A02', { texClass: MmlNode_js_1.TEXCLASS.OP,
                movesupsub: true }],
        bigoplus: ['\u2A01', { texClass: MmlNode_js_1.TEXCLASS.OP,
                movesupsub: true }],
        bigodot: ['\u2A00', { texClass: MmlNode_js_1.TEXCLASS.OP,
                movesupsub: true }],
        oint: ['\u222E', { texClass: MmlNode_js_1.TEXCLASS.OP }],
        bigsqcup: ['\u2A06', { texClass: MmlNode_js_1.TEXCLASS.OP,
                movesupsub: true }],
        smallint: ['\u222B', { largeop: false }],
        triangleleft: '\u25C3',
        triangleright: '\u25B9',
        bigtriangleup: '\u25B3',
        bigtriangledown: '\u25BD',
        wedge: '\u2227',
        land: '\u2227',
        vee: '\u2228',
        lor: '\u2228',
        cap: '\u2229',
        cup: '\u222A',
        ddagger: '\u2021',
        dagger: '\u2020',
        sqcap: '\u2293',
        sqcup: '\u2294',
        uplus: '\u228E',
        amalg: '\u2A3F',
        diamond: '\u22C4',
        bullet: '\u2219',
        wr: '\u2240',
        div: '\u00F7',
        divsymbol: '\u00F7',
        odot: ['\u2299', { largeop: false }],
        oslash: ['\u2298', { largeop: false }],
        otimes: ['\u2297', { largeop: false }],
        ominus: ['\u2296', { largeop: false }],
        oplus: ['\u2295', { largeop: false }],
        mp: '\u2213',
        pm: '\u00B1',
        circ: '\u2218',
        bigcirc: '\u25EF',
        setminus: '\u2216',
        cdot: '\u22C5',
        ast: '\u2217',
        times: '\u00D7',
        star: '\u22C6',
        propto: '\u221D',
        sqsubseteq: '\u2291',
        sqsupseteq: '\u2292',
        parallel: '\u2225',
        mid: '\u2223',
        dashv: '\u22A3',
        vdash: '\u22A2',
        leq: '\u2264',
        le: '\u2264',
        geq: '\u2265',
        ge: '\u2265',
        lt: '\u003C',
        gt: '\u003E',
        succ: '\u227B',
        prec: '\u227A',
        approx: '\u2248',
        succeq: '\u2AB0',
        preceq: '\u2AAF',
        supset: '\u2283',
        subset: '\u2282',
        supseteq: '\u2287',
        subseteq: '\u2286',
        'in': '\u2208',
        ni: '\u220B',
        notin: '\u2209',
        owns: '\u220B',
        gg: '\u226B',
        ll: '\u226A',
        sim: '\u223C',
        simeq: '\u2243',
        perp: '\u22A5',
        equiv: '\u2261',
        asymp: '\u224D',
        smile: '\u2323',
        frown: '\u2322',
        ne: '\u2260',
        neq: '\u2260',
        cong: '\u2245',
        doteq: '\u2250',
        bowtie: '\u22C8',
        models: '\u22A8',
        notChar: '\u29F8',
        Leftrightarrow: '\u21D4',
        Leftarrow: '\u21D0',
        Rightarrow: '\u21D2',
        leftrightarrow: '\u2194',
        leftarrow: '\u2190',
        gets: '\u2190',
        rightarrow: '\u2192',
        to: ['\u2192', { accent: false }],
        mapsto: '\u21A6',
        leftharpoonup: '\u21BC',
        leftharpoondown: '\u21BD',
        rightharpoonup: '\u21C0',
        rightharpoondown: '\u21C1',
        nearrow: '\u2197',
        searrow: '\u2198',
        nwarrow: '\u2196',
        swarrow: '\u2199',
        rightleftharpoons: '\u21CC',
        hookrightarrow: '\u21AA',
        hookleftarrow: '\u21A9',
        longleftarrow: '\u27F5',
        Longleftarrow: '\u27F8',
        longrightarrow: '\u27F6',
        Longrightarrow: '\u27F9',
        Longleftrightarrow: '\u27FA',
        longleftrightarrow: '\u27F7',
        longmapsto: '\u27FC',
        ldots: '\u2026',
        cdots: '\u22EF',
        vdots: '\u22EE',
        ddots: '\u22F1',
        dotsc: '\u2026',
        dotsb: '\u22EF',
        dotsm: '\u22EF',
        dotsi: '\u22EF',
        dotso: '\u2026',
        ldotp: ['\u002E', { texClass: MmlNode_js_1.TEXCLASS.PUNCT }],
        cdotp: ['\u22C5', { texClass: MmlNode_js_1.TEXCLASS.PUNCT }],
        colon: ['\u003A', { texClass: MmlNode_js_1.TEXCLASS.PUNCT }]
    });
    new sm.CharacterMap('mathchar7', ParseMethods_js_1.default.mathchar7, {
        Gamma: '\u0393',
        Delta: '\u0394',
        Theta: '\u0398',
        Lambda: '\u039B',
        Xi: '\u039E',
        Pi: '\u03A0',
        Sigma: '\u03A3',
        Upsilon: '\u03A5',
        Phi: '\u03A6',
        Psi: '\u03A8',
        Omega: '\u03A9',
        '_': '\u005F',
        '#': '\u0023',
        '$': '\u0024',
        '%': '\u0025',
        '&': '\u0026',
        And: '\u0026'
    });
    new sm.DelimiterMap('delimiter', ParseMethods_js_1.default.delimiter, {
        '(': '(',
        ')': ')',
        '[': '[',
        ']': ']',
        '<': '\u27E8',
        '>': '\u27E9',
        '\\lt': '\u27E8',
        '\\gt': '\u27E9',
        '/': '/',
        '|': ['|', { texClass: MmlNode_js_1.TEXCLASS.ORD }],
        '.': '',
        '\\\\': '\\',
        '\\lmoustache': '\u23B0',
        '\\rmoustache': '\u23B1',
        '\\lgroup': '\u27EE',
        '\\rgroup': '\u27EF',
        '\\arrowvert': '\u23D0',
        '\\Arrowvert': '\u2016',
        '\\bracevert': '\u23AA',
        '\\Vert': ['\u2016', { texClass: MmlNode_js_1.TEXCLASS.ORD }],
        '\\|': ['\u2016', { texClass: MmlNode_js_1.TEXCLASS.ORD }],
        '\\vert': ['|', { texClass: MmlNode_js_1.TEXCLASS.ORD }],
        '\\uparrow': '\u2191',
        '\\downarrow': '\u2193',
        '\\updownarrow': '\u2195',
        '\\Uparrow': '\u21D1',
        '\\Downarrow': '\u21D3',
        '\\Updownarrow': '\u21D5',
        '\\backslash': '\\',
        '\\rangle': '\u27E9',
        '\\langle': '\u27E8',
        '\\rbrace': '}',
        '\\lbrace': '{',
        '\\}': '}',
        '\\{': '{',
        '\\rceil': '\u2309',
        '\\lceil': '\u2308',
        '\\rfloor': '\u230B',
        '\\lfloor': '\u230A',
        '\\lbrack': '[',
        '\\rbrack': ']'
    });
    new sm.CommandMap('macros', {
        displaystyle: ['SetStyle', 'D', true, 0],
        textstyle: ['SetStyle', 'T', false, 0],
        scriptstyle: ['SetStyle', 'S', false, 1],
        scriptscriptstyle: ['SetStyle', 'SS', false, 2],
        rm: ['SetFont', TexConstants_js_1.TexConstant.Variant.NORMAL],
        mit: ['SetFont', TexConstants_js_1.TexConstant.Variant.ITALIC],
        oldstyle: ['SetFont', TexConstants_js_1.TexConstant.Variant.OLDSTYLE],
        cal: ['SetFont', TexConstants_js_1.TexConstant.Variant.CALLIGRAPHIC],
        it: ['SetFont', TexConstants_js_1.TexConstant.Variant.MATHITALIC],
        bf: ['SetFont', TexConstants_js_1.TexConstant.Variant.BOLD],
        bbFont: ['SetFont', TexConstants_js_1.TexConstant.Variant.DOUBLESTRUCK],
        scr: ['SetFont', TexConstants_js_1.TexConstant.Variant.SCRIPT],
        frak: ['SetFont', TexConstants_js_1.TexConstant.Variant.FRAKTUR],
        sf: ['SetFont', TexConstants_js_1.TexConstant.Variant.SANSSERIF],
        tt: ['SetFont', TexConstants_js_1.TexConstant.Variant.MONOSPACE],
        mathrm: ['MathFont', TexConstants_js_1.TexConstant.Variant.NORMAL],
        mathup: ['MathFont', TexConstants_js_1.TexConstant.Variant.NORMAL],
        mathnormal: ['MathFont', ''],
        mathbf: ['MathFont', TexConstants_js_1.TexConstant.Variant.BOLD],
        mathbfup: ['MathFont', TexConstants_js_1.TexConstant.Variant.BOLD],
        mathit: ['MathFont', TexConstants_js_1.TexConstant.Variant.MATHITALIC],
        mathbfit: ['MathFont', TexConstants_js_1.TexConstant.Variant.BOLDITALIC],
        mathbb: ['MathFont', TexConstants_js_1.TexConstant.Variant.DOUBLESTRUCK],
        Bbb: ['MathFont', TexConstants_js_1.TexConstant.Variant.DOUBLESTRUCK],
        mathfrak: ['MathFont', TexConstants_js_1.TexConstant.Variant.FRAKTUR],
        mathbffrak: ['MathFont', TexConstants_js_1.TexConstant.Variant.BOLDFRAKTUR],
        mathscr: ['MathFont', TexConstants_js_1.TexConstant.Variant.SCRIPT],
        mathbfscr: ['MathFont', TexConstants_js_1.TexConstant.Variant.BOLDSCRIPT],
        mathsf: ['MathFont', TexConstants_js_1.TexConstant.Variant.SANSSERIF],
        mathsfup: ['MathFont', TexConstants_js_1.TexConstant.Variant.SANSSERIF],
        mathbfsf: ['MathFont', TexConstants_js_1.TexConstant.Variant.BOLDSANSSERIF],
        mathbfsfup: ['MathFont', TexConstants_js_1.TexConstant.Variant.BOLDSANSSERIF],
        mathsfit: ['MathFont', TexConstants_js_1.TexConstant.Variant.SANSSERIFITALIC],
        mathbfsfit: ['MathFont', TexConstants_js_1.TexConstant.Variant.SANSSERIFBOLDITALIC],
        mathtt: ['MathFont', TexConstants_js_1.TexConstant.Variant.MONOSPACE],
        mathcal: ['MathFont', TexConstants_js_1.TexConstant.Variant.CALLIGRAPHIC],
        mathbfcal: ['MathFont', TexConstants_js_1.TexConstant.Variant.BOLDCALLIGRAPHIC],
        symrm: ['MathFont', TexConstants_js_1.TexConstant.Variant.NORMAL],
        symup: ['MathFont', TexConstants_js_1.TexConstant.Variant.NORMAL],
        symnormal: ['MathFont', ''],
        symbf: ['MathFont', TexConstants_js_1.TexConstant.Variant.BOLD],
        symbfup: ['MathFont', TexConstants_js_1.TexConstant.Variant.BOLD],
        symit: ['MathFont', TexConstants_js_1.TexConstant.Variant.ITALIC],
        symbfit: ['MathFont', TexConstants_js_1.TexConstant.Variant.BOLDITALIC],
        symbb: ['MathFont', TexConstants_js_1.TexConstant.Variant.DOUBLESTRUCK],
        symfrak: ['MathFont', TexConstants_js_1.TexConstant.Variant.FRAKTUR],
        symbffrak: ['MathFont', TexConstants_js_1.TexConstant.Variant.BOLDFRAKTUR],
        symscr: ['MathFont', TexConstants_js_1.TexConstant.Variant.SCRIPT],
        symbfscr: ['MathFont', TexConstants_js_1.TexConstant.Variant.BOLDSCRIPT],
        symsf: ['MathFont', TexConstants_js_1.TexConstant.Variant.SANSSERIF],
        symsfup: ['MathFont', TexConstants_js_1.TexConstant.Variant.SANSSERIF],
        symbfsf: ['MathFont', TexConstants_js_1.TexConstant.Variant.BOLDSANSSERIF],
        symbfsfup: ['MathFont', TexConstants_js_1.TexConstant.Variant.BOLDSANSSERIF],
        symsfit: ['MathFont', TexConstants_js_1.TexConstant.Variant.SANSSERIFITALIC],
        symbfsfit: ['MathFont', TexConstants_js_1.TexConstant.Variant.SANSSERIFBOLDITALIC],
        symtt: ['MathFont', TexConstants_js_1.TexConstant.Variant.MONOSPACE],
        symcal: ['MathFont', TexConstants_js_1.TexConstant.Variant.CALLIGRAPHIC],
        symbfcal: ['MathFont', TexConstants_js_1.TexConstant.Variant.BOLDCALLIGRAPHIC],
        textrm: ['HBox', null, TexConstants_js_1.TexConstant.Variant.NORMAL],
        textup: ['HBox', null, TexConstants_js_1.TexConstant.Variant.NORMAL],
        textnormal: ['HBox'],
        textit: ['HBox', null, TexConstants_js_1.TexConstant.Variant.ITALIC],
        textbf: ['HBox', null, TexConstants_js_1.TexConstant.Variant.BOLD],
        textsf: ['HBox', null, TexConstants_js_1.TexConstant.Variant.SANSSERIF],
        texttt: ['HBox', null, TexConstants_js_1.TexConstant.Variant.MONOSPACE],
        tiny: ['SetSize', 0.5],
        Tiny: ['SetSize', 0.6],
        scriptsize: ['SetSize', 0.7],
        small: ['SetSize', 0.85],
        normalsize: ['SetSize', 1.0],
        large: ['SetSize', 1.2],
        Large: ['SetSize', 1.44],
        LARGE: ['SetSize', 1.73],
        huge: ['SetSize', 2.07],
        Huge: ['SetSize', 2.49],
        arcsin: 'NamedFn',
        arccos: 'NamedFn',
        arctan: 'NamedFn',
        arg: 'NamedFn',
        cos: 'NamedFn',
        cosh: 'NamedFn',
        cot: 'NamedFn',
        coth: 'NamedFn',
        csc: 'NamedFn',
        deg: 'NamedFn',
        det: 'NamedOp',
        dim: 'NamedFn',
        exp: 'NamedFn',
        gcd: 'NamedOp',
        hom: 'NamedFn',
        inf: 'NamedOp',
        ker: 'NamedFn',
        lg: 'NamedFn',
        lim: 'NamedOp',
        liminf: ['NamedOp', 'lim&thinsp;inf'],
        limsup: ['NamedOp', 'lim&thinsp;sup'],
        ln: 'NamedFn',
        log: 'NamedFn',
        max: 'NamedOp',
        min: 'NamedOp',
        Pr: 'NamedOp',
        sec: 'NamedFn',
        sin: 'NamedFn',
        sinh: 'NamedFn',
        sup: 'NamedOp',
        tan: 'NamedFn',
        tanh: 'NamedFn',
        limits: ['Limits', 1],
        nolimits: ['Limits', 0],
        overline: ['UnderOver', '2015'],
        underline: ['UnderOver', '2015'],
        overbrace: ['UnderOver', '23DE', 1],
        underbrace: ['UnderOver', '23DF', 1],
        overparen: ['UnderOver', '23DC'],
        underparen: ['UnderOver', '23DD'],
        overrightarrow: ['UnderOver', '2192'],
        underrightarrow: ['UnderOver', '2192'],
        overleftarrow: ['UnderOver', '2190'],
        underleftarrow: ['UnderOver', '2190'],
        overleftrightarrow: ['UnderOver', '2194'],
        underleftrightarrow: ['UnderOver', '2194'],
        overset: 'Overset',
        underset: 'Underset',
        overunderset: 'Overunderset',
        stackrel: ['Macro', '\\mathrel{\\mathop{#2}\\limits^{#1}}', 2],
        stackbin: ['Macro', '\\mathbin{\\mathop{#2}\\limits^{#1}}', 2],
        over: 'Over',
        overwithdelims: 'Over',
        atop: 'Over',
        atopwithdelims: 'Over',
        above: 'Over',
        abovewithdelims: 'Over',
        brace: ['Over', '{', '}'],
        brack: ['Over', '[', ']'],
        choose: ['Over', '(', ')'],
        frac: 'Frac',
        sqrt: 'Sqrt',
        root: 'Root',
        uproot: ['MoveRoot', 'upRoot'],
        leftroot: ['MoveRoot', 'leftRoot'],
        left: 'LeftRight',
        right: 'LeftRight',
        middle: 'LeftRight',
        llap: 'Lap',
        rlap: 'Lap',
        raise: 'RaiseLower',
        lower: 'RaiseLower',
        moveleft: 'MoveLeftRight',
        moveright: 'MoveLeftRight',
        ',': ['Spacer', lengths_js_1.MATHSPACE.thinmathspace],
        ':': ['Spacer', lengths_js_1.MATHSPACE.mediummathspace],
        '>': ['Spacer', lengths_js_1.MATHSPACE.mediummathspace],
        ';': ['Spacer', lengths_js_1.MATHSPACE.thickmathspace],
        '!': ['Spacer', lengths_js_1.MATHSPACE.negativethinmathspace],
        enspace: ['Spacer', .5],
        quad: ['Spacer', 1],
        qquad: ['Spacer', 2],
        thinspace: ['Spacer', lengths_js_1.MATHSPACE.thinmathspace],
        negthinspace: ['Spacer', lengths_js_1.MATHSPACE.negativethinmathspace],
        hskip: 'Hskip',
        hspace: 'Hskip',
        kern: 'Hskip',
        mskip: 'Hskip',
        mspace: 'Hskip',
        mkern: 'Hskip',
        rule: 'rule',
        Rule: ['Rule'],
        Space: ['Rule', 'blank'],
        nonscript: 'Nonscript',
        big: ['MakeBig', MmlNode_js_1.TEXCLASS.ORD, 0.85],
        Big: ['MakeBig', MmlNode_js_1.TEXCLASS.ORD, 1.15],
        bigg: ['MakeBig', MmlNode_js_1.TEXCLASS.ORD, 1.45],
        Bigg: ['MakeBig', MmlNode_js_1.TEXCLASS.ORD, 1.75],
        bigl: ['MakeBig', MmlNode_js_1.TEXCLASS.OPEN, 0.85],
        Bigl: ['MakeBig', MmlNode_js_1.TEXCLASS.OPEN, 1.15],
        biggl: ['MakeBig', MmlNode_js_1.TEXCLASS.OPEN, 1.45],
        Biggl: ['MakeBig', MmlNode_js_1.TEXCLASS.OPEN, 1.75],
        bigr: ['MakeBig', MmlNode_js_1.TEXCLASS.CLOSE, 0.85],
        Bigr: ['MakeBig', MmlNode_js_1.TEXCLASS.CLOSE, 1.15],
        biggr: ['MakeBig', MmlNode_js_1.TEXCLASS.CLOSE, 1.45],
        Biggr: ['MakeBig', MmlNode_js_1.TEXCLASS.CLOSE, 1.75],
        bigm: ['MakeBig', MmlNode_js_1.TEXCLASS.REL, 0.85],
        Bigm: ['MakeBig', MmlNode_js_1.TEXCLASS.REL, 1.15],
        biggm: ['MakeBig', MmlNode_js_1.TEXCLASS.REL, 1.45],
        Biggm: ['MakeBig', MmlNode_js_1.TEXCLASS.REL, 1.75],
        mathord: ['TeXAtom', MmlNode_js_1.TEXCLASS.ORD],
        mathop: ['TeXAtom', MmlNode_js_1.TEXCLASS.OP],
        mathopen: ['TeXAtom', MmlNode_js_1.TEXCLASS.OPEN],
        mathclose: ['TeXAtom', MmlNode_js_1.TEXCLASS.CLOSE],
        mathbin: ['TeXAtom', MmlNode_js_1.TEXCLASS.BIN],
        mathrel: ['TeXAtom', MmlNode_js_1.TEXCLASS.REL],
        mathpunct: ['TeXAtom', MmlNode_js_1.TEXCLASS.PUNCT],
        mathinner: ['TeXAtom', MmlNode_js_1.TEXCLASS.INNER],
        vcenter: ['TeXAtom', MmlNode_js_1.TEXCLASS.VCENTER],
        buildrel: 'BuildRel',
        hbox: ['HBox', 0],
        text: 'HBox',
        mbox: ['HBox', 0],
        fbox: 'FBox',
        boxed: ['Macro', '\\fbox{$\\displaystyle{#1}$}', 1],
        framebox: 'FrameBox',
        strut: 'Strut',
        mathstrut: ['Macro', '\\vphantom{(}'],
        phantom: 'Phantom',
        vphantom: ['Phantom', 1, 0],
        hphantom: ['Phantom', 0, 1],
        smash: 'Smash',
        acute: ['Accent', '00B4'],
        grave: ['Accent', '0060'],
        ddot: ['Accent', '00A8'],
        tilde: ['Accent', '007E'],
        bar: ['Accent', '00AF'],
        breve: ['Accent', '02D8'],
        check: ['Accent', '02C7'],
        hat: ['Accent', '005E'],
        vec: ['Accent', '2192'],
        dot: ['Accent', '02D9'],
        widetilde: ['Accent', '007E', 1],
        widehat: ['Accent', '005E', 1],
        matrix: 'Matrix',
        array: 'Matrix',
        pmatrix: ['Matrix', '(', ')'],
        cases: ['Matrix', '{', '', 'left left', null, '.1em', null,
            true],
        eqalign: ['Matrix', null, null, 'right left',
            (0, lengths_js_1.em)(lengths_js_1.MATHSPACE.thickmathspace), '.5em', 'D'],
        displaylines: ['Matrix', null, null, 'center', null, '.5em', 'D'],
        cr: 'Cr',
        '\\': 'CrLaTeX',
        newline: ['CrLaTeX', true],
        hline: ['HLine', 'solid'],
        hdashline: ['HLine', 'dashed'],
        eqalignno: ['Matrix', null, null, 'right left',
            (0, lengths_js_1.em)(lengths_js_1.MATHSPACE.thickmathspace), '.5em', 'D', null,
            'right'],
        leqalignno: ['Matrix', null, null, 'right left',
            (0, lengths_js_1.em)(lengths_js_1.MATHSPACE.thickmathspace), '.5em', 'D', null,
            'left'],
        hfill: 'HFill',
        hfil: 'HFill',
        hfilll: 'HFill',
        bmod: ['Macro', '\\mmlToken{mo}[lspace="thickmathspace"' +
                ' rspace="thickmathspace"]{mod}'],
        pmod: ['Macro', '\\pod{\\mmlToken{mi}{mod}\\kern 6mu #1}', 1],
        mod: ['Macro', '\\mathchoice{\\kern18mu}{\\kern12mu}' +
                '{\\kern12mu}{\\kern12mu}\\mmlToken{mi}{mod}\\,\\,#1',
            1],
        pod: ['Macro', '\\mathchoice{\\kern18mu}{\\kern8mu}' +
                '{\\kern8mu}{\\kern8mu}(#1)', 1],
        iff: ['Macro', '\\;\\Longleftrightarrow\\;'],
        skew: ['Macro', '{{#2{#3\\mkern#1mu}\\mkern-#1mu}{}}', 3],
        pmb: ['Macro', '\\rlap{#1}\\kern1px{#1}', 1],
        TeX: ['Macro', 'T\\kern-.14em\\lower.5ex{E}\\kern-.115em X'],
        LaTeX: ['Macro', 'L\\kern-.325em\\raise.21em' +
                '{\\scriptstyle{A}}\\kern-.17em\\TeX'],
        ' ': ['Macro', '\\text{ }'],
        not: 'Not',
        dots: 'Dots',
        space: 'Tilde',
        '\u00A0': 'Tilde',
        begin: 'BeginEnd',
        end: 'BeginEnd',
        label: 'HandleLabel',
        ref: 'HandleRef',
        nonumber: 'HandleNoTag',
        mathchoice: 'MathChoice',
        mmlToken: 'MmlToken'
    }, BaseMethods_js_1.default);
    new sm.EnvironmentMap('environment', ParseMethods_js_1.default.environment, {
        array: ['AlignedArray'],
        equation: ['Equation', null, true],
        eqnarray: ['EqnArray', null, true, true, 'rcl',
            ParseUtil_js_1.default.cols(0, lengths_js_1.MATHSPACE.thickmathspace), '.5em']
    }, BaseMethods_js_1.default);
    new sm.CharacterMap('not_remap', null, {
        '\u2190': '\u219A',
        '\u2192': '\u219B',
        '\u2194': '\u21AE',
        '\u21D0': '\u21CD',
        '\u21D2': '\u21CF',
        '\u21D4': '\u21CE',
        '\u2208': '\u2209',
        '\u220B': '\u220C',
        '\u2223': '\u2224',
        '\u2225': '\u2226',
        '\u223C': '\u2241',
        '\u007E': '\u2241',
        '\u2243': '\u2244',
        '\u2245': '\u2247',
        '\u2248': '\u2249',
        '\u224D': '\u226D',
        '\u003D': '\u2260',
        '\u2261': '\u2262',
        '\u003C': '\u226E',
        '\u003E': '\u226F',
        '\u2264': '\u2270',
        '\u2265': '\u2271',
        '\u2272': '\u2274',
        '\u2273': '\u2275',
        '\u2276': '\u2278',
        '\u2277': '\u2279',
        '\u227A': '\u2280',
        '\u227B': '\u2281',
        '\u2282': '\u2284',
        '\u2283': '\u2285',
        '\u2286': '\u2288',
        '\u2287': '\u2289',
        '\u22A2': '\u22AC',
        '\u22A8': '\u22AD',
        '\u22A9': '\u22AE',
        '\u22AB': '\u22AF',
        '\u227C': '\u22E0',
        '\u227D': '\u22E1',
        '\u2291': '\u22E2',
        '\u2292': '\u22E3',
        '\u22B2': '\u22EA',
        '\u22B3': '\u22EB',
        '\u22B4': '\u22EC',
        '\u22B5': '\u22ED',
        '\u2203': '\u2204'
    });
},
664: /* mathjax-full/js/input/tex/TexConstants.js */ function _(require, module, exports, __esModule, __esExport) {
    __esModule();
    var TexConstant;
    (function (TexConstant) {
        TexConstant.Variant = {
            NORMAL: 'normal',
            BOLD: 'bold',
            ITALIC: 'italic',
            BOLDITALIC: 'bold-italic',
            DOUBLESTRUCK: 'double-struck',
            FRAKTUR: 'fraktur',
            BOLDFRAKTUR: 'bold-fraktur',
            SCRIPT: 'script',
            BOLDSCRIPT: 'bold-script',
            SANSSERIF: 'sans-serif',
            BOLDSANSSERIF: 'bold-sans-serif',
            SANSSERIFITALIC: 'sans-serif-italic',
            SANSSERIFBOLDITALIC: 'sans-serif-bold-italic',
            MONOSPACE: 'monospace',
            INITIAL: 'inital',
            TAILED: 'tailed',
            LOOPED: 'looped',
            STRETCHED: 'stretched',
            CALLIGRAPHIC: '-tex-calligraphic',
            BOLDCALLIGRAPHIC: '-tex-bold-calligraphic',
            OLDSTYLE: '-tex-oldstyle',
            BOLDOLDSTYLE: '-tex-bold-oldstyle',
            MATHITALIC: '-tex-mathit'
        };
        TexConstant.Form = {
            PREFIX: 'prefix',
            INFIX: 'infix',
            POSTFIX: 'postfix'
        };
        TexConstant.LineBreak = {
            AUTO: 'auto',
            NEWLINE: 'newline',
            NOBREAK: 'nobreak',
            GOODBREAK: 'goodbreak',
            BADBREAK: 'badbreak'
        };
        TexConstant.LineBreakStyle = {
            BEFORE: 'before',
            AFTER: 'after',
            DUPLICATE: 'duplicate',
            INFIXLINBREAKSTYLE: 'infixlinebreakstyle'
        };
        TexConstant.IndentAlign = {
            LEFT: 'left',
            CENTER: 'center',
            RIGHT: 'right',
            AUTO: 'auto',
            ID: 'id',
            INDENTALIGN: 'indentalign'
        };
        TexConstant.IndentShift = {
            INDENTSHIFT: 'indentshift'
        };
        TexConstant.LineThickness = {
            THIN: 'thin',
            MEDIUM: 'medium',
            THICK: 'thick'
        };
        TexConstant.Notation = {
            LONGDIV: 'longdiv',
            ACTUARIAL: 'actuarial',
            PHASORANGLE: 'phasorangle',
            RADICAL: 'radical',
            BOX: 'box',
            ROUNDEDBOX: 'roundedbox',
            CIRCLE: 'circle',
            LEFT: 'left',
            RIGHT: 'right',
            TOP: 'top',
            BOTTOM: 'bottom',
            UPDIAGONALSTRIKE: 'updiagonalstrike',
            DOWNDIAGONALSTRIKE: 'downdiagonalstrike',
            VERTICALSTRIKE: 'verticalstrike',
            HORIZONTALSTRIKE: 'horizontalstrike',
            NORTHEASTARROW: 'northeastarrow',
            MADRUWB: 'madruwb',
            UPDIAGONALARROW: 'updiagonalarrow'
        };
        TexConstant.Align = {
            TOP: 'top',
            BOTTOM: 'bottom',
            CENTER: 'center',
            BASELINE: 'baseline',
            AXIS: 'axis',
            LEFT: 'left',
            RIGHT: 'right'
        };
        TexConstant.Lines = {
            NONE: 'none',
            SOLID: 'solid',
            DASHED: 'dashed'
        };
        TexConstant.Side = {
            LEFT: 'left',
            RIGHT: 'right',
            LEFTOVERLAP: 'leftoverlap',
            RIGHTOVERLAP: 'rightoverlap'
        };
        TexConstant.Width = {
            AUTO: 'auto',
            FIT: 'fit'
        };
        TexConstant.Actiontype = {
            TOGGLE: 'toggle',
            STATUSLINE: 'statusline',
            TOOLTIP: 'tooltip',
            INPUT: 'input'
        };
        TexConstant.Overflow = {
            LINBREAK: 'linebreak',
            SCROLL: 'scroll',
            ELIDE: 'elide',
            TRUNCATE: 'truncate',
            SCALE: 'scale'
        };
        TexConstant.Unit = {
            EM: 'em',
            EX: 'ex',
            PX: 'px',
            IN: 'in',
            CM: 'cm',
            MM: 'mm',
            PT: 'pt',
            PC: 'pc'
        };
    })(TexConstant = exports.TexConstant || (exports.TexConstant = {}));
},
665: /* mathjax-full/js/input/tex/base/BaseMethods.js */ function _(require, module, exports, __esModule, __esExport) {
    var __assign = (this && this.__assign) || function () {
        __assign = Object.assign || function (t) {
            for (var s, i = 1, n = arguments.length; i < n; i++) {
                s = arguments[i];
                for (var p in s)
                    if (Object.prototype.hasOwnProperty.call(s, p))
                        t[p] = s[p];
            }
            return t;
        };
        return __assign.apply(this, arguments);
    };
    var __createBinding = (this && this.__createBinding) || (Object.create ? (function (o, m, k, k2) {
        if (k2 === undefined)
            k2 = k;
        var desc = Object.getOwnPropertyDescriptor(m, k);
        if (!desc || ("get" in desc ? !m.__esModule : desc.writable || desc.configurable)) {
            desc = { enumerable: true, get: function () { return m[k]; } };
        }
        Object.defineProperty(o, k2, desc);
    }) : (function (o, m, k, k2) {
        if (k2 === undefined)
            k2 = k;
        o[k2] = m[k];
    }));
    var __setModuleDefault = (this && this.__setModuleDefault) || (Object.create ? (function (o, v) {
        Object.defineProperty(o, "default", { enumerable: true, value: v });
    }) : function (o, v) {
        o["default"] = v;
    });
    var __importStar = (this && this.__importStar) || function (mod) {
        if (mod && mod.__esModule)
            return mod;
        var result = {};
        if (mod != null)
            for (var k in mod)
                if (k !== "default" && Object.prototype.hasOwnProperty.call(mod, k))
                    __createBinding(result, mod, k);
        __setModuleDefault(result, mod);
        return result;
    };
    var __read = (this && this.__read) || function (o, n) {
        var m = typeof Symbol === "function" && o[Symbol.iterator];
        if (!m)
            return o;
        var i = m.call(o), r, ar = [], e;
        try {
            while ((n === void 0 || n-- > 0) && !(r = i.next()).done)
                ar.push(r.value);
        }
        catch (error) {
            e = { error: error };
        }
        finally {
            try {
                if (r && !r.done && (m = i["return"]))
                    m.call(i);
            }
            finally {
                if (e)
                    throw e.error;
            }
        }
        return ar;
    };
    var __importDefault = (this && this.__importDefault) || function (mod) {
        return (mod && mod.__esModule) ? mod : { "default": mod };
    };
    __esModule();
    var sitem = __importStar(require(662) /* ./BaseItems.js */);
    var NodeUtil_js_1 = __importDefault(require(642) /* ../NodeUtil.js */);
    var TexError_js_1 = __importDefault(require(647) /* ../TexError.js */);
    var TexParser_js_1 = __importDefault(require(645) /* ../TexParser.js */);
    var TexConstants_js_1 = require(664) /* ../TexConstants.js */;
    var ParseUtil_js_1 = __importDefault(require(646) /* ../ParseUtil.js */);
    var MmlNode_js_1 = require(639) /* ../../../core/MmlTree/MmlNode.js */;
    var Tags_js_1 = require(656) /* ../Tags.js */;
    var lengths_js_1 = require(666) /* ../../../util/lengths.js */;
    var Entities_js_1 = require(648) /* ../../../util/Entities.js */;
    var Options_js_1 = require(632) /* ../../../util/Options.js */;
    var BaseMethods = {};
    var P_HEIGHT = 1.2 / .85;
    var MmlTokenAllow = {
        fontfamily: 1, fontsize: 1, fontweight: 1, fontstyle: 1,
        color: 1, background: 1,
        id: 1, 'class': 1, href: 1, style: 1
    };
    BaseMethods.Open = function (parser, _c) {
        parser.Push(parser.itemFactory.create('open'));
    };
    BaseMethods.Close = function (parser, _c) {
        parser.Push(parser.itemFactory.create('close'));
    };
    BaseMethods.Tilde = function (parser, _c) {
        parser.Push(parser.create('token', 'mtext', {}, Entities_js_1.entities.nbsp));
    };
    BaseMethods.Space = function (_parser, _c) { };
    BaseMethods.Superscript = function (parser, _c) {
        var _a;
        if (parser.GetNext().match(/\d/)) {
            parser.string = parser.string.substr(0, parser.i + 1) +
                ' ' + parser.string.substr(parser.i + 1);
        }
        var primes;
        var base;
        var top = parser.stack.Top();
        if (top.isKind('prime')) {
            _a = __read(top.Peek(2), 2), base = _a[0], primes = _a[1];
            parser.stack.Pop();
        }
        else {
            base = parser.stack.Prev();
            if (!base) {
                base = parser.create('token', 'mi', {}, '');
            }
        }
        var movesupsub = NodeUtil_js_1.default.getProperty(base, 'movesupsub');
        var position = NodeUtil_js_1.default.isType(base, 'msubsup') ? base.sup :
            base.over;
        if ((NodeUtil_js_1.default.isType(base, 'msubsup') && !NodeUtil_js_1.default.isType(base, 'msup') &&
            NodeUtil_js_1.default.getChildAt(base, base.sup)) ||
            (NodeUtil_js_1.default.isType(base, 'munderover') && !NodeUtil_js_1.default.isType(base, 'mover') &&
                NodeUtil_js_1.default.getChildAt(base, base.over) &&
                !NodeUtil_js_1.default.getProperty(base, 'subsupOK'))) {
            throw new TexError_js_1.default('DoubleExponent', 'Double exponent: use braces to clarify');
        }
        if (!NodeUtil_js_1.default.isType(base, 'msubsup') || NodeUtil_js_1.default.isType(base, 'msup')) {
            if (movesupsub) {
                if (!NodeUtil_js_1.default.isType(base, 'munderover') || NodeUtil_js_1.default.isType(base, 'mover') ||
                    NodeUtil_js_1.default.getChildAt(base, base.over)) {
                    base = parser.create('node', 'munderover', [base], { movesupsub: true });
                }
                position = base.over;
            }
            else {
                base = parser.create('node', 'msubsup', [base]);
                position = base.sup;
            }
        }
        parser.Push(parser.itemFactory.create('subsup', base).setProperties({
            position: position, primes: primes, movesupsub: movesupsub
        }));
    };
    BaseMethods.Subscript = function (parser, _c) {
        var _a;
        if (parser.GetNext().match(/\d/)) {
            parser.string =
                parser.string.substr(0, parser.i + 1) + ' ' +
                    parser.string.substr(parser.i + 1);
        }
        var primes, base;
        var top = parser.stack.Top();
        if (top.isKind('prime')) {
            _a = __read(top.Peek(2), 2), base = _a[0], primes = _a[1];
            parser.stack.Pop();
        }
        else {
            base = parser.stack.Prev();
            if (!base) {
                base = parser.create('token', 'mi', {}, '');
            }
        }
        var movesupsub = NodeUtil_js_1.default.getProperty(base, 'movesupsub');
        var position = NodeUtil_js_1.default.isType(base, 'msubsup') ?
            base.sub : base.under;
        if ((NodeUtil_js_1.default.isType(base, 'msubsup') && !NodeUtil_js_1.default.isType(base, 'msup') &&
            NodeUtil_js_1.default.getChildAt(base, base.sub)) ||
            (NodeUtil_js_1.default.isType(base, 'munderover') && !NodeUtil_js_1.default.isType(base, 'mover') &&
                NodeUtil_js_1.default.getChildAt(base, base.under) &&
                !NodeUtil_js_1.default.getProperty(base, 'subsupOK'))) {
            throw new TexError_js_1.default('DoubleSubscripts', 'Double subscripts: use braces to clarify');
        }
        if (!NodeUtil_js_1.default.isType(base, 'msubsup') || NodeUtil_js_1.default.isType(base, 'msup')) {
            if (movesupsub) {
                if (!NodeUtil_js_1.default.isType(base, 'munderover') || NodeUtil_js_1.default.isType(base, 'mover') ||
                    NodeUtil_js_1.default.getChildAt(base, base.under)) {
                    base = parser.create('node', 'munderover', [base], { movesupsub: true });
                }
                position = base.under;
            }
            else {
                base = parser.create('node', 'msubsup', [base]);
                position = base.sub;
            }
        }
        parser.Push(parser.itemFactory.create('subsup', base).setProperties({
            position: position, primes: primes, movesupsub: movesupsub
        }));
    };
    BaseMethods.Prime = function (parser, c) {
        var base = parser.stack.Prev();
        if (!base) {
            base = parser.create('node', 'mi');
        }
        if (NodeUtil_js_1.default.isType(base, 'msubsup') && !NodeUtil_js_1.default.isType(base, 'msup') &&
            NodeUtil_js_1.default.getChildAt(base, base.sup)) {
            throw new TexError_js_1.default('DoubleExponentPrime', 'Prime causes double exponent: use braces to clarify');
        }
        var sup = '';
        parser.i--;
        do {
            sup += Entities_js_1.entities.prime;
            parser.i++, c = parser.GetNext();
        } while (c === '\'' || c === Entities_js_1.entities.rsquo);
        sup = ['', '\u2032', '\u2033', '\u2034', '\u2057'][sup.length] || sup;
        var node = parser.create('token', 'mo', { variantForm: true }, sup);
        parser.Push(parser.itemFactory.create('prime', base, node));
    };
    BaseMethods.Comment = function (parser, _c) {
        while (parser.i < parser.string.length && parser.string.charAt(parser.i) !== '\n') {
            parser.i++;
        }
    };
    BaseMethods.Hash = function (_parser, _c) {
        throw new TexError_js_1.default('CantUseHash1', 'You can\'t use \'macro parameter character #\' in math mode');
    };
    BaseMethods.MathFont = function (parser, name, variant) {
        var text = parser.GetArgument(name);
        var mml = new TexParser_js_1.default(text, __assign(__assign({}, parser.stack.env), { font: variant, multiLetterIdentifiers: /^[a-zA-Z]+/, noAutoOP: true }), parser.configuration).mml();
        parser.Push(parser.create('node', 'TeXAtom', [mml]));
    };
    BaseMethods.SetFont = function (parser, _name, font) {
        parser.stack.env['font'] = font;
    };
    BaseMethods.SetStyle = function (parser, _name, texStyle, style, level) {
        parser.stack.env['style'] = texStyle;
        parser.stack.env['level'] = level;
        parser.Push(parser.itemFactory.create('style').setProperty('styles', { displaystyle: style, scriptlevel: level }));
    };
    BaseMethods.SetSize = function (parser, _name, size) {
        parser.stack.env['size'] = size;
        parser.Push(parser.itemFactory.create('style').setProperty('styles', { mathsize: (0, lengths_js_1.em)(size) }));
    };
    BaseMethods.Spacer = function (parser, _name, space) {
        var node = parser.create('node', 'mspace', [], { width: (0, lengths_js_1.em)(space) });
        var style = parser.create('node', 'mstyle', [node], { scriptlevel: 0 });
        parser.Push(style);
    };
    BaseMethods.LeftRight = function (parser, name) {
        var first = name.substr(1);
        parser.Push(parser.itemFactory.create(first, parser.GetDelimiter(name), parser.stack.env.color));
    };
    BaseMethods.NamedFn = function (parser, name, id) {
        if (!id) {
            id = name.substr(1);
        }
        var mml = parser.create('token', 'mi', { texClass: MmlNode_js_1.TEXCLASS.OP }, id);
        parser.Push(parser.itemFactory.create('fn', mml));
    };
    BaseMethods.NamedOp = function (parser, name, id) {
        if (!id) {
            id = name.substr(1);
        }
        id = id.replace(/&thinsp;/, '\u2006');
        var mml = parser.create('token', 'mo', {
            movablelimits: true,
            movesupsub: true,
            form: TexConstants_js_1.TexConstant.Form.PREFIX,
            texClass: MmlNode_js_1.TEXCLASS.OP
        }, id);
        parser.Push(mml);
    };
    BaseMethods.Limits = function (parser, _name, limits) {
        var op = parser.stack.Prev(true);
        if (!op || (NodeUtil_js_1.default.getTexClass(NodeUtil_js_1.default.getCoreMO(op)) !== MmlNode_js_1.TEXCLASS.OP &&
            NodeUtil_js_1.default.getProperty(op, 'movesupsub') == null)) {
            throw new TexError_js_1.default('MisplacedLimits', '%1 is allowed only on operators', parser.currentCS);
        }
        var top = parser.stack.Top();
        var node;
        if (NodeUtil_js_1.default.isType(op, 'munderover') && !limits) {
            node = parser.create('node', 'msubsup');
            NodeUtil_js_1.default.copyChildren(op, node);
            op = top.Last = node;
        }
        else if (NodeUtil_js_1.default.isType(op, 'msubsup') && limits) {
            node = parser.create('node', 'munderover');
            NodeUtil_js_1.default.copyChildren(op, node);
            op = top.Last = node;
        }
        NodeUtil_js_1.default.setProperty(op, 'movesupsub', limits ? true : false);
        NodeUtil_js_1.default.setProperties(NodeUtil_js_1.default.getCoreMO(op), { 'movablelimits': false });
        if (NodeUtil_js_1.default.getAttribute(op, 'movablelimits') ||
            NodeUtil_js_1.default.getProperty(op, 'movablelimits')) {
            NodeUtil_js_1.default.setProperties(op, { 'movablelimits': false });
        }
    };
    BaseMethods.Over = function (parser, name, open, close) {
        var mml = parser.itemFactory.create('over').setProperty('name', parser.currentCS);
        if (open || close) {
            mml.setProperty('open', open);
            mml.setProperty('close', close);
        }
        else if (name.match(/withdelims$/)) {
            mml.setProperty('open', parser.GetDelimiter(name));
            mml.setProperty('close', parser.GetDelimiter(name));
        }
        if (name.match(/^\\above/)) {
            mml.setProperty('thickness', parser.GetDimen(name));
        }
        else if (name.match(/^\\atop/) || open || close) {
            mml.setProperty('thickness', 0);
        }
        parser.Push(mml);
    };
    BaseMethods.Frac = function (parser, name) {
        var num = parser.ParseArg(name);
        var den = parser.ParseArg(name);
        var node = parser.create('node', 'mfrac', [num, den]);
        parser.Push(node);
    };
    BaseMethods.Sqrt = function (parser, name) {
        var n = parser.GetBrackets(name);
        var arg = parser.GetArgument(name);
        if (arg === '\\frac') {
            arg += '{' + parser.GetArgument(arg) + '}{' + parser.GetArgument(arg) + '}';
        }
        var mml = new TexParser_js_1.default(arg, parser.stack.env, parser.configuration).mml();
        if (!n) {
            mml = parser.create('node', 'msqrt', [mml]);
        }
        else {
            mml = parser.create('node', 'mroot', [mml, parseRoot(parser, n)]);
        }
        parser.Push(mml);
    };
    function parseRoot(parser, n) {
        var env = parser.stack.env;
        var inRoot = env['inRoot'];
        env['inRoot'] = true;
        var newParser = new TexParser_js_1.default(n, env, parser.configuration);
        var node = newParser.mml();
        var global = newParser.stack.global;
        if (global['leftRoot'] || global['upRoot']) {
            var def = {};
            if (global['leftRoot']) {
                def['width'] = global['leftRoot'];
            }
            if (global['upRoot']) {
                def['voffset'] = global['upRoot'];
                def['height'] = global['upRoot'];
            }
            node = parser.create('node', 'mpadded', [node], def);
        }
        env['inRoot'] = inRoot;
        return node;
    }
    BaseMethods.Root = function (parser, name) {
        var n = parser.GetUpTo(name, '\\of');
        var arg = parser.ParseArg(name);
        var node = parser.create('node', 'mroot', [arg, parseRoot(parser, n)]);
        parser.Push(node);
    };
    BaseMethods.MoveRoot = function (parser, name, id) {
        if (!parser.stack.env['inRoot']) {
            throw new TexError_js_1.default('MisplacedMoveRoot', '%1 can appear only within a root', parser.currentCS);
        }
        if (parser.stack.global[id]) {
            throw new TexError_js_1.default('MultipleMoveRoot', 'Multiple use of %1', parser.currentCS);
        }
        var n = parser.GetArgument(name);
        if (!n.match(/-?[0-9]+/)) {
            throw new TexError_js_1.default('IntegerArg', 'The argument to %1 must be an integer', parser.currentCS);
        }
        n = (parseInt(n, 10) / 15) + 'em';
        if (n.substr(0, 1) !== '-') {
            n = '+' + n;
        }
        parser.stack.global[id] = n;
    };
    BaseMethods.Accent = function (parser, name, accent, stretchy) {
        var c = parser.ParseArg(name);
        var def = __assign(__assign({}, ParseUtil_js_1.default.getFontDef(parser)), { accent: true, mathaccent: true });
        var entity = NodeUtil_js_1.default.createEntity(accent);
        var moNode = parser.create('token', 'mo', def, entity);
        var mml = moNode;
        NodeUtil_js_1.default.setAttribute(mml, 'stretchy', stretchy ? true : false);
        var mo = (NodeUtil_js_1.default.isEmbellished(c) ? NodeUtil_js_1.default.getCoreMO(c) : c);
        if (NodeUtil_js_1.default.isType(mo, 'mo') || NodeUtil_js_1.default.getProperty(mo, 'movablelimits')) {
            NodeUtil_js_1.default.setProperties(mo, { 'movablelimits': false });
        }
        var muoNode = parser.create('node', 'munderover');
        NodeUtil_js_1.default.setChild(muoNode, 0, c);
        NodeUtil_js_1.default.setChild(muoNode, 1, null);
        NodeUtil_js_1.default.setChild(muoNode, 2, mml);
        var texAtom = parser.create('node', 'TeXAtom', [muoNode]);
        parser.Push(texAtom);
    };
    BaseMethods.UnderOver = function (parser, name, c, stack) {
        var entity = NodeUtil_js_1.default.createEntity(c);
        var mo = parser.create('token', 'mo', { stretchy: true, accent: true }, entity);
        var pos = (name.charAt(1) === 'o' ? 'over' : 'under');
        var base = parser.ParseArg(name);
        parser.Push(ParseUtil_js_1.default.underOver(parser, base, mo, pos, stack));
    };
    BaseMethods.Overset = function (parser, name) {
        var top = parser.ParseArg(name);
        var base = parser.ParseArg(name);
        ParseUtil_js_1.default.checkMovableLimits(base);
        if (top.isKind('mo')) {
            NodeUtil_js_1.default.setAttribute(top, 'accent', false);
        }
        var node = parser.create('node', 'mover', [base, top]);
        parser.Push(node);
    };
    BaseMethods.Underset = function (parser, name) {
        var bot = parser.ParseArg(name);
        var base = parser.ParseArg(name);
        ParseUtil_js_1.default.checkMovableLimits(base);
        if (bot.isKind('mo')) {
            NodeUtil_js_1.default.setAttribute(bot, 'accent', false);
        }
        var node = parser.create('node', 'munder', [base, bot], { accentunder: false });
        parser.Push(node);
    };
    BaseMethods.Overunderset = function (parser, name) {
        var top = parser.ParseArg(name);
        var bot = parser.ParseArg(name);
        var base = parser.ParseArg(name);
        ParseUtil_js_1.default.checkMovableLimits(base);
        if (top.isKind('mo')) {
            NodeUtil_js_1.default.setAttribute(top, 'accent', false);
        }
        if (bot.isKind('mo')) {
            NodeUtil_js_1.default.setAttribute(bot, 'accent', false);
        }
        var node = parser.create('node', 'munderover', [base, bot, top], { accent: false, accentunder: false });
        parser.Push(node);
    };
    BaseMethods.TeXAtom = function (parser, name, mclass) {
        var def = { texClass: mclass };
        var mml;
        var node;
        var parsed;
        if (mclass === MmlNode_js_1.TEXCLASS.OP) {
            def['movesupsub'] = def['movablelimits'] = true;
            var arg = parser.GetArgument(name);
            var match = arg.match(/^\s*\\rm\s+([a-zA-Z0-9 ]+)$/);
            if (match) {
                def['mathvariant'] = TexConstants_js_1.TexConstant.Variant.NORMAL;
                node = parser.create('token', 'mi', def, match[1]);
            }
            else {
                parsed = new TexParser_js_1.default(arg, parser.stack.env, parser.configuration).mml();
                node = parser.create('node', 'TeXAtom', [parsed], def);
            }
            mml = parser.itemFactory.create('fn', node);
        }
        else {
            parsed = parser.ParseArg(name);
            mml = parser.create('node', 'TeXAtom', [parsed], def);
        }
        parser.Push(mml);
    };
    BaseMethods.MmlToken = function (parser, name) {
        var kind = parser.GetArgument(name);
        var attr = parser.GetBrackets(name, '').replace(/^\s+/, '');
        var text = parser.GetArgument(name);
        var def = {};
        var keep = [];
        var node;
        try {
            node = parser.create('node', kind);
        }
        catch (e) {
            node = null;
        }
        if (!node || !node.isToken) {
            throw new TexError_js_1.default('NotMathMLToken', '%1 is not a token element', kind);
        }
        while (attr !== '') {
            var match = attr.match(/^([a-z]+)\s*=\s*('[^']*'|"[^"]*"|[^ ,]*)\s*,?\s*/i);
            if (!match) {
                throw new TexError_js_1.default('InvalidMathMLAttr', 'Invalid MathML attribute: %1', attr);
            }
            if (!node.attributes.hasDefault(match[1]) && !MmlTokenAllow[match[1]]) {
                throw new TexError_js_1.default('UnknownAttrForElement', '%1 is not a recognized attribute for %2', match[1], kind);
            }
            var value = ParseUtil_js_1.default.MmlFilterAttribute(parser, match[1], match[2].replace(/^(['"])(.*)\1$/, '$2'));
            if (value) {
                if (value.toLowerCase() === 'true') {
                    value = true;
                }
                else if (value.toLowerCase() === 'false') {
                    value = false;
                }
                def[match[1]] = value;
                keep.push(match[1]);
            }
            attr = attr.substr(match[0].length);
        }
        if (keep.length) {
            def['mjx-keep-attrs'] = keep.join(' ');
        }
        var textNode = parser.create('text', text);
        node.appendChild(textNode);
        NodeUtil_js_1.default.setProperties(node, def);
        parser.Push(node);
    };
    BaseMethods.Strut = function (parser, _name) {
        var row = parser.create('node', 'mrow');
        var padded = parser.create('node', 'mpadded', [row], { height: '8.6pt', depth: '3pt', width: 0 });
        parser.Push(padded);
    };
    BaseMethods.Phantom = function (parser, name, v, h) {
        var box = parser.create('node', 'mphantom', [parser.ParseArg(name)]);
        if (v || h) {
            box = parser.create('node', 'mpadded', [box]);
            if (h) {
                NodeUtil_js_1.default.setAttribute(box, 'height', 0);
                NodeUtil_js_1.default.setAttribute(box, 'depth', 0);
            }
            if (v) {
                NodeUtil_js_1.default.setAttribute(box, 'width', 0);
            }
        }
        var atom = parser.create('node', 'TeXAtom', [box]);
        parser.Push(atom);
    };
    BaseMethods.Smash = function (parser, name) {
        var bt = ParseUtil_js_1.default.trimSpaces(parser.GetBrackets(name, ''));
        var smash = parser.create('node', 'mpadded', [parser.ParseArg(name)]);
        switch (bt) {
            case 'b':
                NodeUtil_js_1.default.setAttribute(smash, 'depth', 0);
                break;
            case 't':
                NodeUtil_js_1.default.setAttribute(smash, 'height', 0);
                break;
            default:
                NodeUtil_js_1.default.setAttribute(smash, 'height', 0);
                NodeUtil_js_1.default.setAttribute(smash, 'depth', 0);
        }
        var atom = parser.create('node', 'TeXAtom', [smash]);
        parser.Push(atom);
    };
    BaseMethods.Lap = function (parser, name) {
        var mml = parser.create('node', 'mpadded', [parser.ParseArg(name)], { width: 0 });
        if (name === '\\llap') {
            NodeUtil_js_1.default.setAttribute(mml, 'lspace', '-1width');
        }
        var atom = parser.create('node', 'TeXAtom', [mml]);
        parser.Push(atom);
    };
    BaseMethods.RaiseLower = function (parser, name) {
        var h = parser.GetDimen(name);
        var item = parser.itemFactory.create('position').setProperties({ name: parser.currentCS, move: 'vertical' });
        if (h.charAt(0) === '-') {
            h = h.slice(1);
            name = name.substr(1) === 'raise' ? '\\lower' : '\\raise';
        }
        if (name === '\\lower') {
            item.setProperty('dh', '-' + h);
            item.setProperty('dd', '+' + h);
        }
        else {
            item.setProperty('dh', '+' + h);
            item.setProperty('dd', '-' + h);
        }
        parser.Push(item);
    };
    BaseMethods.MoveLeftRight = function (parser, name) {
        var h = parser.GetDimen(name);
        var nh = (h.charAt(0) === '-' ? h.slice(1) : '-' + h);
        if (name === '\\moveleft') {
            var tmp = h;
            h = nh;
            nh = tmp;
        }
        parser.Push(parser.itemFactory.create('position').setProperties({
            name: parser.currentCS, move: 'horizontal',
            left: parser.create('node', 'mspace', [], { width: h }),
            right: parser.create('node', 'mspace', [], { width: nh })
        }));
    };
    BaseMethods.Hskip = function (parser, name) {
        var node = parser.create('node', 'mspace', [], { width: parser.GetDimen(name) });
        parser.Push(node);
    };
    BaseMethods.Nonscript = function (parser, _name) {
        parser.Push(parser.itemFactory.create('nonscript'));
    };
    BaseMethods.Rule = function (parser, name, style) {
        var w = parser.GetDimen(name), h = parser.GetDimen(name), d = parser.GetDimen(name);
        var def = { width: w, height: h, depth: d };
        if (style !== 'blank') {
            def['mathbackground'] = (parser.stack.env['color'] || 'black');
        }
        var node = parser.create('node', 'mspace', [], def);
        parser.Push(node);
    };
    BaseMethods.rule = function (parser, name) {
        var v = parser.GetBrackets(name), w = parser.GetDimen(name), h = parser.GetDimen(name);
        var mml = parser.create('node', 'mspace', [], {
            width: w, height: h,
            mathbackground: (parser.stack.env['color'] || 'black')
        });
        if (v) {
            mml = parser.create('node', 'mpadded', [mml], { voffset: v });
            if (v.match(/^\-/)) {
                NodeUtil_js_1.default.setAttribute(mml, 'height', v);
                NodeUtil_js_1.default.setAttribute(mml, 'depth', '+' + v.substr(1));
            }
            else {
                NodeUtil_js_1.default.setAttribute(mml, 'height', '+' + v);
            }
        }
        parser.Push(mml);
    };
    BaseMethods.MakeBig = function (parser, name, mclass, size) {
        size *= P_HEIGHT;
        var sizeStr = String(size).replace(/(\.\d\d\d).+/, '$1') + 'em';
        var delim = parser.GetDelimiter(name, true);
        var mo = parser.create('token', 'mo', {
            minsize: sizeStr, maxsize: sizeStr,
            fence: true, stretchy: true, symmetric: true
        }, delim);
        var node = parser.create('node', 'TeXAtom', [mo], { texClass: mclass });
        parser.Push(node);
    };
    BaseMethods.BuildRel = function (parser, name) {
        var top = parser.ParseUpTo(name, '\\over');
        var bot = parser.ParseArg(name);
        var node = parser.create('node', 'munderover');
        NodeUtil_js_1.default.setChild(node, 0, bot);
        NodeUtil_js_1.default.setChild(node, 1, null);
        NodeUtil_js_1.default.setChild(node, 2, top);
        var atom = parser.create('node', 'TeXAtom', [node], { texClass: MmlNode_js_1.TEXCLASS.REL });
        parser.Push(atom);
    };
    BaseMethods.HBox = function (parser, name, style, font) {
        parser.PushAll(ParseUtil_js_1.default.internalMath(parser, parser.GetArgument(name), style, font));
    };
    BaseMethods.FBox = function (parser, name) {
        var internal = ParseUtil_js_1.default.internalMath(parser, parser.GetArgument(name));
        var node = parser.create('node', 'menclose', internal, { notation: 'box' });
        parser.Push(node);
    };
    BaseMethods.FrameBox = function (parser, name) {
        var width = parser.GetBrackets(name);
        var pos = parser.GetBrackets(name) || 'c';
        var mml = ParseUtil_js_1.default.internalMath(parser, parser.GetArgument(name));
        if (width) {
            mml = [parser.create('node', 'mpadded', mml, {
                    width: width,
                    'data-align': (0, Options_js_1.lookup)(pos, { l: 'left', r: 'right' }, 'center')
                })];
        }
        var node = parser.create('node', 'TeXAtom', [parser.create('node', 'menclose', mml, { notation: 'box' })], { texClass: MmlNode_js_1.TEXCLASS.ORD });
        parser.Push(node);
    };
    BaseMethods.Not = function (parser, _name) {
        parser.Push(parser.itemFactory.create('not'));
    };
    BaseMethods.Dots = function (parser, _name) {
        var ldotsEntity = NodeUtil_js_1.default.createEntity('2026');
        var cdotsEntity = NodeUtil_js_1.default.createEntity('22EF');
        var ldots = parser.create('token', 'mo', { stretchy: false }, ldotsEntity);
        var cdots = parser.create('token', 'mo', { stretchy: false }, cdotsEntity);
        parser.Push(parser.itemFactory.create('dots').setProperties({
            ldots: ldots,
            cdots: cdots
        }));
    };
    BaseMethods.Matrix = function (parser, _name, open, close, align, spacing, vspacing, style, cases, numbered) {
        var c = parser.GetNext();
        if (c === '') {
            throw new TexError_js_1.default('MissingArgFor', 'Missing argument for %1', parser.currentCS);
        }
        if (c === '{') {
            parser.i++;
        }
        else {
            parser.string = c + '}' + parser.string.slice(parser.i + 1);
            parser.i = 0;
        }
        var array = parser.itemFactory.create('array').setProperty('requireClose', true);
        array.arraydef = {
            rowspacing: (vspacing || '4pt'),
            columnspacing: (spacing || '1em')
        };
        if (cases) {
            array.setProperty('isCases', true);
        }
        if (numbered) {
            array.setProperty('isNumbered', true);
            array.arraydef.side = numbered;
        }
        if (open || close) {
            array.setProperty('open', open);
            array.setProperty('close', close);
        }
        if (style === 'D') {
            array.arraydef.displaystyle = true;
        }
        if (align != null) {
            array.arraydef.columnalign = align;
        }
        parser.Push(array);
    };
    BaseMethods.Entry = function (parser, name) {
        parser.Push(parser.itemFactory.create('cell').setProperties({ isEntry: true, name: name }));
        var top = parser.stack.Top();
        var env = top.getProperty('casesEnv');
        var cases = top.getProperty('isCases');
        if (!cases && !env)
            return;
        var str = parser.string;
        var braces = 0, close = -1, i = parser.i, m = str.length;
        var end = (env ? new RegExp("^\\\\end\\s*\\{".concat(env.replace(/\*/, '\\*'), "\\}")) : null);
        while (i < m) {
            var c = str.charAt(i);
            if (c === '{') {
                braces++;
                i++;
            }
            else if (c === '}') {
                if (braces === 0) {
                    m = 0;
                }
                else {
                    braces--;
                    if (braces === 0 && close < 0) {
                        close = i - parser.i;
                    }
                    i++;
                }
            }
            else if (c === '&' && braces === 0) {
                throw new TexError_js_1.default('ExtraAlignTab', 'Extra alignment tab in \\cases text');
            }
            else if (c === '\\') {
                var rest = str.substr(i);
                if (rest.match(/^((\\cr)[^a-zA-Z]|\\\\)/) || (end && rest.match(end))) {
                    m = 0;
                }
                else {
                    i += 2;
                }
            }
            else {
                i++;
            }
        }
        var text = str.substr(parser.i, i - parser.i);
        if (!text.match(/^\s*\\text[^a-zA-Z]/) || close !== text.replace(/\s+$/, '').length - 1) {
            var internal = ParseUtil_js_1.default.internalMath(parser, ParseUtil_js_1.default.trimSpaces(text), 0);
            parser.PushAll(internal);
            parser.i = i;
        }
    };
    BaseMethods.Cr = function (parser, name) {
        parser.Push(parser.itemFactory.create('cell').setProperties({ isCR: true, name: name }));
    };
    BaseMethods.CrLaTeX = function (parser, name, nobrackets) {
        if (nobrackets === void 0) {
            nobrackets = false;
        }
        var n;
        if (!nobrackets) {
            if (parser.string.charAt(parser.i) === '*') {
                parser.i++;
            }
            if (parser.string.charAt(parser.i) === '[') {
                var dim = parser.GetBrackets(name, '');
                var _a = __read(ParseUtil_js_1.default.matchDimen(dim), 2), value = _a[0], unit = _a[1];
                if (dim && !value) {
                    throw new TexError_js_1.default('BracketMustBeDimension', 'Bracket argument to %1 must be a dimension', parser.currentCS);
                }
                n = value + unit;
            }
        }
        parser.Push(parser.itemFactory.create('cell').setProperties({ isCR: true, name: name, linebreak: true }));
        var top = parser.stack.Top();
        var node;
        if (top instanceof sitem.ArrayItem) {
            if (n) {
                top.addRowSpacing(n);
            }
        }
        else {
            if (n) {
                node = parser.create('node', 'mspace', [], { depth: n });
                parser.Push(node);
            }
            node = parser.create('node', 'mspace', [], { linebreak: TexConstants_js_1.TexConstant.LineBreak.NEWLINE });
            parser.Push(node);
        }
    };
    BaseMethods.HLine = function (parser, _name, style) {
        if (style == null) {
            style = 'solid';
        }
        var top = parser.stack.Top();
        if (!(top instanceof sitem.ArrayItem) || top.Size()) {
            throw new TexError_js_1.default('Misplaced', 'Misplaced %1', parser.currentCS);
        }
        if (!top.table.length) {
            top.frame.push('top');
        }
        else {
            var lines = (top.arraydef['rowlines'] ? top.arraydef['rowlines'].split(/ /) : []);
            while (lines.length < top.table.length) {
                lines.push('none');
            }
            lines[top.table.length - 1] = style;
            top.arraydef['rowlines'] = lines.join(' ');
        }
    };
    BaseMethods.HFill = function (parser, _name) {
        var top = parser.stack.Top();
        if (top instanceof sitem.ArrayItem) {
            top.hfill.push(top.Size());
        }
        else {
            throw new TexError_js_1.default('UnsupportedHFill', 'Unsupported use of %1', parser.currentCS);
        }
    };
    BaseMethods.BeginEnd = function (parser, name) {
        var env = parser.GetArgument(name);
        if (env.match(/\\/i)) {
            throw new TexError_js_1.default('InvalidEnv', 'Invalid environment name \'%1\'', env);
        }
        var macro = parser.configuration.handlers.get('environment').lookup(env);
        if (macro && name === '\\end') {
            if (!macro.args[0]) {
                var mml = parser.itemFactory.create('end').setProperty('name', env);
                parser.Push(mml);
                return;
            }
            parser.stack.env['closing'] = env;
        }
        ParseUtil_js_1.default.checkMaxMacros(parser, false);
        parser.parse('environment', [parser, env]);
    };
    BaseMethods.Array = function (parser, begin, open, close, align, spacing, vspacing, style, raggedHeight) {
        if (!align) {
            align = parser.GetArgument('\\begin{' + begin.getName() + '}');
        }
        var lines = ('c' + align).replace(/[^clr|:]/g, '').replace(/[^|:]([|:])+/g, '$1');
        align = align.replace(/[^clr]/g, '').split('').join(' ');
        align = align.replace(/l/g, 'left').replace(/r/g, 'right').replace(/c/g, 'center');
        var array = parser.itemFactory.create('array');
        array.arraydef = {
            columnalign: align,
            columnspacing: (spacing || '1em'),
            rowspacing: (vspacing || '4pt')
        };
        if (lines.match(/[|:]/)) {
            if (lines.charAt(0).match(/[|:]/)) {
                array.frame.push('left');
                array.dashed = lines.charAt(0) === ':';
            }
            if (lines.charAt(lines.length - 1).match(/[|:]/)) {
                array.frame.push('right');
            }
            lines = lines.substr(1, lines.length - 2);
            array.arraydef.columnlines =
                lines.split('').join(' ').replace(/[^|: ]/g, 'none').replace(/\|/g, 'solid').replace(/:/g, 'dashed');
        }
        if (open) {
            array.setProperty('open', parser.convertDelimiter(open));
        }
        if (close) {
            array.setProperty('close', parser.convertDelimiter(close));
        }
        if ((style || '').charAt(1) === '\'') {
            array.arraydef['data-cramped'] = true;
            style = style.charAt(0);
        }
        if (style === 'D') {
            array.arraydef['displaystyle'] = true;
        }
        else if (style) {
            array.arraydef['displaystyle'] = false;
        }
        if (style === 'S') {
            array.arraydef['scriptlevel'] = 1;
        }
        if (raggedHeight) {
            array.arraydef['useHeight'] = false;
        }
        parser.Push(begin);
        return array;
    };
    BaseMethods.AlignedArray = function (parser, begin) {
        var align = parser.GetBrackets('\\begin{' + begin.getName() + '}');
        var item = BaseMethods.Array(parser, begin);
        return ParseUtil_js_1.default.setArrayAlign(item, align);
    };
    BaseMethods.Equation = function (parser, begin, numbered) {
        parser.Push(begin);
        ParseUtil_js_1.default.checkEqnEnv(parser);
        return parser.itemFactory.create('equation', numbered).
            setProperty('name', begin.getName());
    };
    BaseMethods.EqnArray = function (parser, begin, numbered, taggable, align, spacing) {
        parser.Push(begin);
        if (taggable) {
            ParseUtil_js_1.default.checkEqnEnv(parser);
        }
        align = align.replace(/[^clr]/g, '').split('').join(' ');
        align = align.replace(/l/g, 'left').replace(/r/g, 'right').replace(/c/g, 'center');
        var newItem = parser.itemFactory.create('eqnarray', begin.getName(), numbered, taggable, parser.stack.global);
        newItem.arraydef = {
            displaystyle: true,
            columnalign: align,
            columnspacing: (spacing || '1em'),
            rowspacing: '3pt',
            side: parser.options['tagSide'],
            minlabelspacing: parser.options['tagIndent']
        };
        return newItem;
    };
    BaseMethods.HandleNoTag = function (parser, _name) {
        parser.tags.notag();
    };
    BaseMethods.HandleLabel = function (parser, name) {
        var label = parser.GetArgument(name);
        if (label === '') {
            return;
        }
        if (!parser.tags.refUpdate) {
            if (parser.tags.label) {
                throw new TexError_js_1.default('MultipleCommand', 'Multiple %1', parser.currentCS);
            }
            parser.tags.label = label;
            if ((parser.tags.allLabels[label] || parser.tags.labels[label]) && !parser.options['ignoreDuplicateLabels']) {
                throw new TexError_js_1.default('MultipleLabel', 'Label \'%1\' multiply defined', label);
            }
            parser.tags.labels[label] = new Tags_js_1.Label();
        }
    };
    BaseMethods.HandleRef = function (parser, name, eqref) {
        var label = parser.GetArgument(name);
        var ref = parser.tags.allLabels[label] || parser.tags.labels[label];
        if (!ref) {
            if (!parser.tags.refUpdate) {
                parser.tags.redo = true;
            }
            ref = new Tags_js_1.Label();
        }
        var tag = ref.tag;
        if (eqref) {
            tag = parser.tags.formatTag(tag);
        }
        var node = parser.create('node', 'mrow', ParseUtil_js_1.default.internalMath(parser, tag), {
            href: parser.tags.formatUrl(ref.id, parser.options.baseURL), 'class': 'MathJax_ref'
        });
        parser.Push(node);
    };
    BaseMethods.Macro = function (parser, name, macro, argcount, def) {
        if (argcount) {
            var args = [];
            if (def != null) {
                var optional = parser.GetBrackets(name);
                args.push(optional == null ? def : optional);
            }
            for (var i = args.length; i < argcount; i++) {
                args.push(parser.GetArgument(name));
            }
            macro = ParseUtil_js_1.default.substituteArgs(parser, args, macro);
        }
        parser.string = ParseUtil_js_1.default.addArgs(parser, macro, parser.string.slice(parser.i));
        parser.i = 0;
        ParseUtil_js_1.default.checkMaxMacros(parser);
    };
    BaseMethods.MathChoice = function (parser, name) {
        var D = parser.ParseArg(name);
        var T = parser.ParseArg(name);
        var S = parser.ParseArg(name);
        var SS = parser.ParseArg(name);
        parser.Push(parser.create('node', 'MathChoice', [D, T, S, SS]));
    };
    exports.default = BaseMethods;
},
666: /* mathjax-full/js/util/lengths.js */ function _(require, module, exports, __esModule, __esExport) {
    __esModule();
    exports.BIGDIMEN = 1000000;
    exports.UNITS = {
        px: 1,
        'in': 96,
        cm: 96 / 2.54,
        mm: 96 / 25.4
    };
    exports.RELUNITS = {
        em: 1,
        ex: .431,
        pt: 1 / 10,
        pc: 12 / 10,
        mu: 1 / 18
    };
    exports.MATHSPACE = {
        veryverythinmathspace: 1 / 18,
        verythinmathspace: 2 / 18,
        thinmathspace: 3 / 18,
        mediummathspace: 4 / 18,
        thickmathspace: 5 / 18,
        verythickmathspace: 6 / 18,
        veryverythickmathspace: 7 / 18,
        negativeveryverythinmathspace: -1 / 18,
        negativeverythinmathspace: -2 / 18,
        negativethinmathspace: -3 / 18,
        negativemediummathspace: -4 / 18,
        negativethickmathspace: -5 / 18,
        negativeverythickmathspace: -6 / 18,
        negativeveryverythickmathspace: -7 / 18,
        thin: .04,
        medium: .06,
        thick: .1,
        normal: 1,
        big: 2,
        small: 1 / Math.sqrt(2),
        infinity: exports.BIGDIMEN
    };
    function length2em(length, size, scale, em) {
        if (size === void 0) {
            size = 0;
        }
        if (scale === void 0) {
            scale = 1;
        }
        if (em === void 0) {
            em = 16;
        }
        if (typeof length !== 'string') {
            length = String(length);
        }
        if (length === '' || length == null) {
            return size;
        }
        if (exports.MATHSPACE[length]) {
            return exports.MATHSPACE[length];
        }
        var match = length.match(/^\s*([-+]?(?:\.\d+|\d+(?:\.\d*)?))?(pt|em|ex|mu|px|pc|in|mm|cm|%)?/);
        if (!match) {
            return size;
        }
        var m = parseFloat(match[1] || '1'), unit = match[2];
        if (exports.UNITS.hasOwnProperty(unit)) {
            return m * exports.UNITS[unit] / em / scale;
        }
        if (exports.RELUNITS.hasOwnProperty(unit)) {
            return m * exports.RELUNITS[unit];
        }
        if (unit === '%') {
            return m / 100 * size;
        }
        return m * size;
    }
    exports.length2em = length2em;
    function percent(m) {
        return (100 * m).toFixed(1).replace(/\.?0+$/, '') + '%';
    }
    exports.percent = percent;
    function em(m) {
        if (Math.abs(m) < .001)
            return '0';
        return (m.toFixed(3).replace(/\.?0+$/, '')) + 'em';
    }
    exports.em = em;
    function emRounded(m, em) {
        if (em === void 0) {
            em = 16;
        }
        m = (Math.round(m * em) + .05) / em;
        if (Math.abs(m) < .001)
            return '0em';
        return m.toFixed(3).replace(/\.?0+$/, '') + 'em';
    }
    exports.emRounded = emRounded;
    function px(m, M, em) {
        if (M === void 0) {
            M = -exports.BIGDIMEN;
        }
        if (em === void 0) {
            em = 16;
        }
        m *= em;
        if (M && m < M)
            m = M;
        if (Math.abs(m) < .1)
            return '0';
        return m.toFixed(1).replace(/\.0$/, '') + 'px';
    }
    exports.px = px;
},
667: /* mathjax-full/js/input/tex/ParseMethods.js */ function _(require, module, exports, __esModule, __esExport) {
    var __read = (this && this.__read) || function (o, n) {
        var m = typeof Symbol === "function" && o[Symbol.iterator];
        if (!m)
            return o;
        var i = m.call(o), r, ar = [], e;
        try {
            while ((n === void 0 || n-- > 0) && !(r = i.next()).done)
                ar.push(r.value);
        }
        catch (error) {
            e = { error: error };
        }
        finally {
            try {
                if (r && !r.done && (m = i["return"]))
                    m.call(i);
            }
            finally {
                if (e)
                    throw e.error;
            }
        }
        return ar;
    };
    var __spreadArray = (this && this.__spreadArray) || function (to, from, pack) {
        if (pack || arguments.length === 2)
            for (var i = 0, l = from.length, ar; i < l; i++) {
                if (ar || !(i in from)) {
                    if (!ar)
                        ar = Array.prototype.slice.call(from, 0, i);
                    ar[i] = from[i];
                }
            }
        return to.concat(ar || Array.prototype.slice.call(from));
    };
    var __importDefault = (this && this.__importDefault) || function (mod) {
        return (mod && mod.__esModule) ? mod : { "default": mod };
    };
    __esModule();
    var NodeUtil_js_1 = __importDefault(require(642) /* ./NodeUtil.js */);
    var TexConstants_js_1 = require(664) /* ./TexConstants.js */;
    var ParseUtil_js_1 = __importDefault(require(646) /* ./ParseUtil.js */);
    var ParseMethods;
    (function (ParseMethods) {
        function variable(parser, c) {
            var def = ParseUtil_js_1.default.getFontDef(parser);
            var env = parser.stack.env;
            if (env.multiLetterIdentifiers && env.font !== '') {
                c = parser.string.substr(parser.i - 1).match(env.multiLetterIdentifiers)[0];
                parser.i += c.length - 1;
                if (def.mathvariant === TexConstants_js_1.TexConstant.Variant.NORMAL && env.noAutoOP && c.length > 1) {
                    def.autoOP = false;
                }
            }
            var node = parser.create('token', 'mi', def, c);
            parser.Push(node);
        }
        ParseMethods.variable = variable;
        function digit(parser, c) {
            var mml;
            var pattern = parser.configuration.options['digits'];
            var n = parser.string.slice(parser.i - 1).match(pattern);
            var def = ParseUtil_js_1.default.getFontDef(parser);
            if (n) {
                mml = parser.create('token', 'mn', def, n[0].replace(/[{}]/g, ''));
                parser.i += n[0].length - 1;
            }
            else {
                mml = parser.create('token', 'mo', def, c);
            }
            parser.Push(mml);
        }
        ParseMethods.digit = digit;
        function controlSequence(parser, _c) {
            var name = parser.GetCS();
            parser.parse('macro', [parser, name]);
        }
        ParseMethods.controlSequence = controlSequence;
        function mathchar0mi(parser, mchar) {
            var def = mchar.attributes || { mathvariant: TexConstants_js_1.TexConstant.Variant.ITALIC };
            var node = parser.create('token', 'mi', def, mchar.char);
            parser.Push(node);
        }
        ParseMethods.mathchar0mi = mathchar0mi;
        function mathchar0mo(parser, mchar) {
            var def = mchar.attributes || {};
            def['stretchy'] = false;
            var node = parser.create('token', 'mo', def, mchar.char);
            NodeUtil_js_1.default.setProperty(node, 'fixStretchy', true);
            parser.configuration.addNode('fixStretchy', node);
            parser.Push(node);
        }
        ParseMethods.mathchar0mo = mathchar0mo;
        function mathchar7(parser, mchar) {
            var def = mchar.attributes || { mathvariant: TexConstants_js_1.TexConstant.Variant.NORMAL };
            if (parser.stack.env['font']) {
                def['mathvariant'] = parser.stack.env['font'];
            }
            var node = parser.create('token', 'mi', def, mchar.char);
            parser.Push(node);
        }
        ParseMethods.mathchar7 = mathchar7;
        function delimiter(parser, delim) {
            var def = delim.attributes || {};
            def = Object.assign({ fence: false, stretchy: false }, def);
            var node = parser.create('token', 'mo', def, delim.char);
            parser.Push(node);
        }
        ParseMethods.delimiter = delimiter;
        function environment(parser, env, func, args) {
            var end = args[0];
            var mml = parser.itemFactory.create('begin').setProperties({ name: env, end: end });
            mml = func.apply(void 0, __spreadArray([parser, mml], __read(args.slice(1)), false));
            parser.Push(mml);
        }
        ParseMethods.environment = environment;
    })(ParseMethods || (ParseMethods = {}));
    exports.default = ParseMethods;
},
668: /* mathjax-full/js/input/mathml.js */ function _(require, module, exports, __esModule, __esExport) {
    var __extends = (this && this.__extends) || (function () {
        var extendStatics = function (d, b) {
            extendStatics = Object.setPrototypeOf ||
                ({ __proto__: [] } instanceof Array && function (d, b) { d.__proto__ = b; }) ||
                function (d, b) { for (var p in b)
                    if (Object.prototype.hasOwnProperty.call(b, p))
                        d[p] = b[p]; };
            return extendStatics(d, b);
        };
        return function (d, b) {
            if (typeof b !== "function" && b !== null)
                throw new TypeError("Class extends value " + String(b) + " is not a constructor or null");
            extendStatics(d, b);
            function __() { this.constructor = d; }
            d.prototype = b === null ? Object.create(b) : (__.prototype = b.prototype, new __());
        };
    })();
    var __read = (this && this.__read) || function (o, n) {
        var m = typeof Symbol === "function" && o[Symbol.iterator];
        if (!m)
            return o;
        var i = m.call(o), r, ar = [], e;
        try {
            while ((n === void 0 || n-- > 0) && !(r = i.next()).done)
                ar.push(r.value);
        }
        catch (error) {
            e = { error: error };
        }
        finally {
            try {
                if (r && !r.done && (m = i["return"]))
                    m.call(i);
            }
            finally {
                if (e)
                    throw e.error;
            }
        }
        return ar;
    };
    __esModule();
    var InputJax_js_1 = require(631) /* ../core/InputJax.js */;
    var Options_js_1 = require(632) /* ../util/Options.js */;
    var FunctionList_js_1 = require(633) /* ../util/FunctionList.js */;
    var FindMathML_js_1 = require(669) /* ./mathml/FindMathML.js */;
    var MathMLCompile_js_1 = require(670) /* ./mathml/MathMLCompile.js */;
    var MathML = (function (_super) {
        __extends(MathML, _super);
        function MathML(options) {
            if (options === void 0) {
                options = {};
            }
            var _this = this;
            var _a = __read((0, Options_js_1.separateOptions)(options, FindMathML_js_1.FindMathML.OPTIONS, MathMLCompile_js_1.MathMLCompile.OPTIONS), 3), mml = _a[0], find = _a[1], compile = _a[2];
            _this = _super.call(this, mml) || this;
            _this.findMathML = _this.options['FindMathML'] || new FindMathML_js_1.FindMathML(find);
            _this.mathml = _this.options['MathMLCompile'] || new MathMLCompile_js_1.MathMLCompile(compile);
            _this.mmlFilters = new FunctionList_js_1.FunctionList();
            return _this;
        }
        MathML.prototype.setAdaptor = function (adaptor) {
            _super.prototype.setAdaptor.call(this, adaptor);
            this.findMathML.adaptor = adaptor;
            this.mathml.adaptor = adaptor;
        };
        MathML.prototype.setMmlFactory = function (mmlFactory) {
            _super.prototype.setMmlFactory.call(this, mmlFactory);
            this.mathml.setMmlFactory(mmlFactory);
        };
        Object.defineProperty(MathML.prototype, "processStrings", {
            get: function () {
                return false;
            },
            enumerable: false,
            configurable: true
        });
        MathML.prototype.compile = function (math, document) {
            var mml = math.start.node;
            if (!mml || !math.end.node || this.options['forceReparse'] || this.adaptor.kind(mml) === '#text') {
                var mathml = this.executeFilters(this.preFilters, math, document, (math.math || '<math></math>').trim());
                var doc = this.checkForErrors(this.adaptor.parse(mathml, 'text/' + this.options['parseAs']));
                var body = this.adaptor.body(doc);
                if (this.adaptor.childNodes(body).length !== 1) {
                    this.error('MathML must consist of a single element');
                }
                mml = this.adaptor.remove(this.adaptor.firstChild(body));
                if (this.adaptor.kind(mml).replace(/^[a-z]+:/, '') !== 'math') {
                    this.error('MathML must be formed by a <math> element, not <' + this.adaptor.kind(mml) + '>');
                }
            }
            mml = this.executeFilters(this.mmlFilters, math, document, mml);
            return this.executeFilters(this.postFilters, math, document, this.mathml.compile(mml));
        };
        MathML.prototype.checkForErrors = function (doc) {
            var err = this.adaptor.tags(this.adaptor.body(doc), 'parsererror')[0];
            if (err) {
                if (this.adaptor.textContent(err) === '') {
                    this.error('Error processing MathML');
                }
                this.options['parseError'].call(this, err);
            }
            return doc;
        };
        MathML.prototype.error = function (message) {
            throw new Error(message);
        };
        MathML.prototype.findMath = function (node) {
            return this.findMathML.findMath(node);
        };
        MathML.NAME = 'MathML';
        MathML.OPTIONS = (0, Options_js_1.defaultOptions)({
            parseAs: 'html',
            forceReparse: false,
            FindMathML: null,
            MathMLCompile: null,
            parseError: function (node) {
                this.error(this.adaptor.textContent(node).replace(/\n.*/g, ''));
            }
        }, InputJax_js_1.AbstractInputJax.OPTIONS);
        return MathML;
    }(InputJax_js_1.AbstractInputJax));
    exports.MathML = MathML;
},
669: /* mathjax-full/js/input/mathml/FindMathML.js */ function _(require, module, exports, __esModule, __esExport) {
    var __extends = (this && this.__extends) || (function () {
        var extendStatics = function (d, b) {
            extendStatics = Object.setPrototypeOf ||
                ({ __proto__: [] } instanceof Array && function (d, b) { d.__proto__ = b; }) ||
                function (d, b) { for (var p in b)
                    if (Object.prototype.hasOwnProperty.call(b, p))
                        d[p] = b[p]; };
            return extendStatics(d, b);
        };
        return function (d, b) {
            if (typeof b !== "function" && b !== null)
                throw new TypeError("Class extends value " + String(b) + " is not a constructor or null");
            extendStatics(d, b);
            function __() { this.constructor = d; }
            d.prototype = b === null ? Object.create(b) : (__.prototype = b.prototype, new __());
        };
    })();
    var __values = (this && this.__values) || function (o) {
        var s = typeof Symbol === "function" && Symbol.iterator, m = s && o[s], i = 0;
        if (m)
            return m.call(o);
        if (o && typeof o.length === "number")
            return {
                next: function () {
                    if (o && i >= o.length)
                        o = void 0;
                    return { value: o && o[i++], done: !o };
                }
            };
        throw new TypeError(s ? "Object is not iterable." : "Symbol.iterator is not defined.");
    };
    __esModule();
    var FindMath_js_1 = require(635) /* ../../core/FindMath.js */;
    var NAMESPACE = 'http://www.w3.org/1998/Math/MathML';
    var FindMathML = (function (_super) {
        __extends(FindMathML, _super);
        function FindMathML() {
            return _super !== null && _super.apply(this, arguments) || this;
        }
        FindMathML.prototype.findMath = function (node) {
            var set = new Set();
            this.findMathNodes(node, set);
            this.findMathPrefixed(node, set);
            var html = this.adaptor.root(this.adaptor.document);
            if (this.adaptor.kind(html) === 'html' && set.size === 0) {
                this.findMathNS(node, set);
            }
            return this.processMath(set);
        };
        FindMathML.prototype.findMathNodes = function (node, set) {
            var e_1, _a;
            try {
                for (var _b = __values(this.adaptor.tags(node, 'math')), _c = _b.next(); !_c.done; _c = _b.next()) {
                    var math = _c.value;
                    set.add(math);
                }
            }
            catch (e_1_1) {
                e_1 = { error: e_1_1 };
            }
            finally {
                try {
                    if (_c && !_c.done && (_a = _b.return))
                        _a.call(_b);
                }
                finally {
                    if (e_1)
                        throw e_1.error;
                }
            }
        };
        FindMathML.prototype.findMathPrefixed = function (node, set) {
            var e_2, _a, e_3, _b;
            var html = this.adaptor.root(this.adaptor.document);
            try {
                for (var _c = __values(this.adaptor.allAttributes(html)), _d = _c.next(); !_d.done; _d = _c.next()) {
                    var attr = _d.value;
                    if (attr.name.substr(0, 6) === 'xmlns:' && attr.value === NAMESPACE) {
                        var prefix = attr.name.substr(6);
                        try {
                            for (var _e = (e_3 = void 0, __values(this.adaptor.tags(node, prefix + ':math'))), _f = _e.next(); !_f.done; _f = _e.next()) {
                                var math = _f.value;
                                set.add(math);
                            }
                        }
                        catch (e_3_1) {
                            e_3 = { error: e_3_1 };
                        }
                        finally {
                            try {
                                if (_f && !_f.done && (_b = _e.return))
                                    _b.call(_e);
                            }
                            finally {
                                if (e_3)
                                    throw e_3.error;
                            }
                        }
                    }
                }
            }
            catch (e_2_1) {
                e_2 = { error: e_2_1 };
            }
            finally {
                try {
                    if (_d && !_d.done && (_a = _c.return))
                        _a.call(_c);
                }
                finally {
                    if (e_2)
                        throw e_2.error;
                }
            }
        };
        FindMathML.prototype.findMathNS = function (node, set) {
            var e_4, _a;
            try {
                for (var _b = __values(this.adaptor.tags(node, 'math', NAMESPACE)), _c = _b.next(); !_c.done; _c = _b.next()) {
                    var math = _c.value;
                    set.add(math);
                }
            }
            catch (e_4_1) {
                e_4 = { error: e_4_1 };
            }
            finally {
                try {
                    if (_c && !_c.done && (_a = _b.return))
                        _a.call(_b);
                }
                finally {
                    if (e_4)
                        throw e_4.error;
                }
            }
        };
        FindMathML.prototype.processMath = function (set) {
            var e_5, _a;
            var math = [];
            try {
                for (var _b = __values(Array.from(set)), _c = _b.next(); !_c.done; _c = _b.next()) {
                    var mml = _c.value;
                    var display = (this.adaptor.getAttribute(mml, 'display') === 'block' ||
                        this.adaptor.getAttribute(mml, 'mode') === 'display');
                    var start = { node: mml, n: 0, delim: '' };
                    var end = { node: mml, n: 0, delim: '' };
                    math.push({ math: this.adaptor.outerHTML(mml), start: start, end: end, display: display });
                }
            }
            catch (e_5_1) {
                e_5 = { error: e_5_1 };
            }
            finally {
                try {
                    if (_c && !_c.done && (_a = _b.return))
                        _a.call(_b);
                }
                finally {
                    if (e_5)
                        throw e_5.error;
                }
            }
            return math;
        };
        FindMathML.OPTIONS = {};
        return FindMathML;
    }(FindMath_js_1.AbstractFindMath));
    exports.FindMathML = FindMathML;
},
670: /* mathjax-full/js/input/mathml/MathMLCompile.js */ function _(require, module, exports, __esModule, __esExport) {
    var __assign = (this && this.__assign) || function () {
        __assign = Object.assign || function (t) {
            for (var s, i = 1, n = arguments.length; i < n; i++) {
                s = arguments[i];
                for (var p in s)
                    if (Object.prototype.hasOwnProperty.call(s, p))
                        t[p] = s[p];
            }
            return t;
        };
        return __assign.apply(this, arguments);
    };
    var __createBinding = (this && this.__createBinding) || (Object.create ? (function (o, m, k, k2) {
        if (k2 === undefined)
            k2 = k;
        var desc = Object.getOwnPropertyDescriptor(m, k);
        if (!desc || ("get" in desc ? !m.__esModule : desc.writable || desc.configurable)) {
            desc = { enumerable: true, get: function () { return m[k]; } };
        }
        Object.defineProperty(o, k2, desc);
    }) : (function (o, m, k, k2) {
        if (k2 === undefined)
            k2 = k;
        o[k2] = m[k];
    }));
    var __setModuleDefault = (this && this.__setModuleDefault) || (Object.create ? (function (o, v) {
        Object.defineProperty(o, "default", { enumerable: true, value: v });
    }) : function (o, v) {
        o["default"] = v;
    });
    var __importStar = (this && this.__importStar) || function (mod) {
        if (mod && mod.__esModule)
            return mod;
        var result = {};
        if (mod != null)
            for (var k in mod)
                if (k !== "default" && Object.prototype.hasOwnProperty.call(mod, k))
                    __createBinding(result, mod, k);
        __setModuleDefault(result, mod);
        return result;
    };
    var __values = (this && this.__values) || function (o) {
        var s = typeof Symbol === "function" && Symbol.iterator, m = s && o[s], i = 0;
        if (m)
            return m.call(o);
        if (o && typeof o.length === "number")
            return {
                next: function () {
                    if (o && i >= o.length)
                        o = void 0;
                    return { value: o && o[i++], done: !o };
                }
            };
        throw new TypeError(s ? "Object is not iterable." : "Symbol.iterator is not defined.");
    };
    __esModule();
    var MmlNode_js_1 = require(639) /* ../../core/MmlTree/MmlNode.js */;
    var Options_js_1 = require(632) /* ../../util/Options.js */;
    var Entities = __importStar(require(648) /* ../../util/Entities.js */);
    var MathMLCompile = (function () {
        function MathMLCompile(options) {
            if (options === void 0) {
                options = {};
            }
            var Class = this.constructor;
            this.options = (0, Options_js_1.userOptions)((0, Options_js_1.defaultOptions)({}, Class.OPTIONS), options);
        }
        MathMLCompile.prototype.setMmlFactory = function (mmlFactory) {
            this.factory = mmlFactory;
        };
        MathMLCompile.prototype.compile = function (node) {
            var mml = this.makeNode(node);
            mml.verifyTree(this.options['verify']);
            mml.setInheritedAttributes({}, false, 0, false);
            mml.walkTree(this.markMrows);
            return mml;
        };
        MathMLCompile.prototype.makeNode = function (node) {
            var e_1, _a;
            var adaptor = this.adaptor;
            var limits = false;
            var kind = adaptor.kind(node).replace(/^.*:/, '');
            var texClass = adaptor.getAttribute(node, 'data-mjx-texclass') || '';
            if (texClass) {
                texClass = this.filterAttribute('data-mjx-texclass', texClass) || '';
            }
            var type = texClass && kind === 'mrow' ? 'TeXAtom' : kind;
            try {
                for (var _b = __values(this.filterClassList(adaptor.allClasses(node))), _c = _b.next(); !_c.done; _c = _b.next()) {
                    var name_1 = _c.value;
                    if (name_1.match(/^MJX-TeXAtom-/) && kind === 'mrow') {
                        texClass = name_1.substr(12);
                        type = 'TeXAtom';
                    }
                    else if (name_1 === 'MJX-fixedlimits') {
                        limits = true;
                    }
                }
            }
            catch (e_1_1) {
                e_1 = { error: e_1_1 };
            }
            finally {
                try {
                    if (_c && !_c.done && (_a = _b.return))
                        _a.call(_b);
                }
                finally {
                    if (e_1)
                        throw e_1.error;
                }
            }
            this.factory.getNodeClass(type) || this.error('Unknown node type "' + type + '"');
            var mml = this.factory.create(type);
            if (type === 'TeXAtom' && texClass === 'OP' && !limits) {
                mml.setProperty('movesupsub', true);
                mml.attributes.setInherited('movablelimits', true);
            }
            if (texClass) {
                mml.texClass = MmlNode_js_1.TEXCLASS[texClass];
                mml.setProperty('texClass', mml.texClass);
            }
            this.addAttributes(mml, node);
            this.checkClass(mml, node);
            this.addChildren(mml, node);
            return mml;
        };
        MathMLCompile.prototype.addAttributes = function (mml, node) {
            var e_2, _a;
            var ignoreVariant = false;
            try {
                for (var _b = __values(this.adaptor.allAttributes(node)), _c = _b.next(); !_c.done; _c = _b.next()) {
                    var attr = _c.value;
                    var name_2 = attr.name;
                    var value = this.filterAttribute(name_2, attr.value);
                    if (value === null || name_2 === 'xmlns') {
                        continue;
                    }
                    if (name_2.substr(0, 9) === 'data-mjx-') {
                        switch (name_2.substr(9)) {
                            case 'alternate':
                                mml.setProperty('variantForm', true);
                                break;
                            case 'variant':
                                mml.attributes.set('mathvariant', value);
                                ignoreVariant = true;
                                break;
                            case 'smallmatrix':
                                mml.setProperty('scriptlevel', 1);
                                mml.setProperty('useHeight', false);
                                break;
                            case 'accent':
                                mml.setProperty('mathaccent', value === 'true');
                                break;
                            case 'auto-op':
                                mml.setProperty('autoOP', value === 'true');
                                break;
                            case 'script-align':
                                mml.setProperty('scriptalign', value);
                                break;
                        }
                    }
                    else if (name_2 !== 'class') {
                        var val = value.toLowerCase();
                        if (val === 'true' || val === 'false') {
                            mml.attributes.set(name_2, val === 'true');
                        }
                        else if (!ignoreVariant || name_2 !== 'mathvariant') {
                            mml.attributes.set(name_2, value);
                        }
                    }
                }
            }
            catch (e_2_1) {
                e_2 = { error: e_2_1 };
            }
            finally {
                try {
                    if (_c && !_c.done && (_a = _b.return))
                        _a.call(_b);
                }
                finally {
                    if (e_2)
                        throw e_2.error;
                }
            }
        };
        MathMLCompile.prototype.filterAttribute = function (_name, value) {
            return value;
        };
        MathMLCompile.prototype.filterClassList = function (list) {
            return list;
        };
        MathMLCompile.prototype.addChildren = function (mml, node) {
            var e_3, _a;
            if (mml.arity === 0) {
                return;
            }
            var adaptor = this.adaptor;
            try {
                for (var _b = __values(adaptor.childNodes(node)), _c = _b.next(); !_c.done; _c = _b.next()) {
                    var child = _c.value;
                    var name_3 = adaptor.kind(child);
                    if (name_3 === '#comment') {
                        continue;
                    }
                    if (name_3 === '#text') {
                        this.addText(mml, child);
                    }
                    else if (mml.isKind('annotation-xml')) {
                        mml.appendChild(this.factory.create('XML').setXML(child, adaptor));
                    }
                    else {
                        var childMml = mml.appendChild(this.makeNode(child));
                        if (childMml.arity === 0 && adaptor.childNodes(child).length) {
                            if (this.options['fixMisplacedChildren']) {
                                this.addChildren(mml, child);
                            }
                            else {
                                childMml.mError('There should not be children for ' + childMml.kind + ' nodes', this.options['verify'], true);
                            }
                        }
                    }
                }
            }
            catch (e_3_1) {
                e_3 = { error: e_3_1 };
            }
            finally {
                try {
                    if (_c && !_c.done && (_a = _b.return))
                        _a.call(_b);
                }
                finally {
                    if (e_3)
                        throw e_3.error;
                }
            }
        };
        MathMLCompile.prototype.addText = function (mml, child) {
            var text = this.adaptor.value(child);
            if ((mml.isToken || mml.getProperty('isChars')) && mml.arity) {
                if (mml.isToken) {
                    text = Entities.translate(text);
                    text = this.trimSpace(text);
                }
                mml.appendChild(this.factory.create('text').setText(text));
            }
            else if (text.match(/\S/)) {
                this.error('Unexpected text node "' + text + '"');
            }
        };
        MathMLCompile.prototype.checkClass = function (mml, node) {
            var e_4, _a;
            var classList = [];
            try {
                for (var _b = __values(this.filterClassList(this.adaptor.allClasses(node))), _c = _b.next(); !_c.done; _c = _b.next()) {
                    var name_4 = _c.value;
                    if (name_4.substr(0, 4) === 'MJX-') {
                        if (name_4 === 'MJX-variant') {
                            mml.setProperty('variantForm', true);
                        }
                        else if (name_4.substr(0, 11) !== 'MJX-TeXAtom') {
                            mml.attributes.set('mathvariant', this.fixCalligraphic(name_4.substr(3)));
                        }
                    }
                    else {
                        classList.push(name_4);
                    }
                }
            }
            catch (e_4_1) {
                e_4 = { error: e_4_1 };
            }
            finally {
                try {
                    if (_c && !_c.done && (_a = _b.return))
                        _a.call(_b);
                }
                finally {
                    if (e_4)
                        throw e_4.error;
                }
            }
            if (classList.length) {
                mml.attributes.set('class', classList.join(' '));
            }
        };
        MathMLCompile.prototype.fixCalligraphic = function (variant) {
            return variant.replace(/caligraphic/, 'calligraphic');
        };
        MathMLCompile.prototype.markMrows = function (mml) {
            if (mml.isKind('mrow') && !mml.isInferred && mml.childNodes.length >= 2) {
                var first = mml.childNodes[0];
                var last = mml.childNodes[mml.childNodes.length - 1];
                if (first.isKind('mo') && first.attributes.get('fence') && first.attributes.get('stretchy') &&
                    last.isKind('mo') && last.attributes.get('fence') && last.attributes.get('stretchy')) {
                    if (first.childNodes.length) {
                        mml.setProperty('open', first.getText());
                    }
                    if (last.childNodes.length) {
                        mml.setProperty('close', last.getText());
                    }
                }
            }
        };
        MathMLCompile.prototype.trimSpace = function (text) {
            return text.replace(/[\t\n\r]/g, ' ')
                .replace(/^ +/, '')
                .replace(/ +$/, '')
                .replace(/  +/g, ' ');
        };
        MathMLCompile.prototype.error = function (message) {
            throw new Error(message);
        };
        MathMLCompile.OPTIONS = {
            MmlFactory: null,
            fixMisplacedChildren: true,
            verify: __assign({}, MmlNode_js_1.AbstractMmlNode.verifyDefaults),
            translateEntities: true
        };
        return MathMLCompile;
    }());
    exports.MathMLCompile = MathMLCompile;
},
671: /* mathjax-full/js/output/svg.js */ function _(require, module, exports, __esModule, __esExport) {
    var __extends = (this && this.__extends) || (function () {
        var extendStatics = function (d, b) {
            extendStatics = Object.setPrototypeOf ||
                ({ __proto__: [] } instanceof Array && function (d, b) { d.__proto__ = b; }) ||
                function (d, b) { for (var p in b)
                    if (Object.prototype.hasOwnProperty.call(b, p))
                        d[p] = b[p]; };
            return extendStatics(d, b);
        };
        return function (d, b) {
            if (typeof b !== "function" && b !== null)
                throw new TypeError("Class extends value " + String(b) + " is not a constructor or null");
            extendStatics(d, b);
            function __() { this.constructor = d; }
            d.prototype = b === null ? Object.create(b) : (__.prototype = b.prototype, new __());
        };
    })();
    var __assign = (this && this.__assign) || function () {
        __assign = Object.assign || function (t) {
            for (var s, i = 1, n = arguments.length; i < n; i++) {
                s = arguments[i];
                for (var p in s)
                    if (Object.prototype.hasOwnProperty.call(s, p))
                        t[p] = s[p];
            }
            return t;
        };
        return __assign.apply(this, arguments);
    };
    var __read = (this && this.__read) || function (o, n) {
        var m = typeof Symbol === "function" && o[Symbol.iterator];
        if (!m)
            return o;
        var i = m.call(o), r, ar = [], e;
        try {
            while ((n === void 0 || n-- > 0) && !(r = i.next()).done)
                ar.push(r.value);
        }
        catch (error) {
            e = { error: error };
        }
        finally {
            try {
                if (r && !r.done && (m = i["return"]))
                    m.call(i);
            }
            finally {
                if (e)
                    throw e.error;
            }
        }
        return ar;
    };
    __esModule();
    var OutputJax_js_1 = require(672) /* ./common/OutputJax.js */;
    var WrapperFactory_js_1 = require(676) /* ./svg/WrapperFactory.js */;
    var tex_js_1 = require(767) /* ./svg/fonts/tex.js */;
    var FontCache_js_1 = require(819) /* ./svg/FontCache.js */;
    var string_js_1 = require(636) /* ../util/string.js */;
    var lengths_js_1 = require(666) /* ../util/lengths.js */;
    exports.SVGNS = 'http://www.w3.org/2000/svg';
    exports.XLINKNS = 'http://www.w3.org/1999/xlink';
    var SVG = (function (_super) {
        __extends(SVG, _super);
        function SVG(options) {
            if (options === void 0) {
                options = null;
            }
            var _this = _super.call(this, options, WrapperFactory_js_1.SVGWrapperFactory, tex_js_1.TeXFont) || this;
            _this.minwidth = 0;
            _this.shift = 0;
            _this.container = null;
            _this.svgStyles = null;
            _this.fontCache = new FontCache_js_1.FontCache(_this);
            return _this;
        }
        SVG.prototype.initialize = function () {
            if (this.options.fontCache === 'global') {
                this.fontCache.clearCache();
            }
        };
        SVG.prototype.clearFontCache = function () {
            this.fontCache.clearCache();
        };
        SVG.prototype.reset = function () {
            this.clearFontCache();
        };
        SVG.prototype.setScale = function (node) {
            if (this.options.scale !== 1) {
                this.adaptor.setStyle(node, 'fontSize', (0, lengths_js_1.percent)(this.options.scale));
            }
        };
        SVG.prototype.escaped = function (math, html) {
            this.setDocument(html);
            return this.html('span', {}, [this.text(math.math)]);
        };
        SVG.prototype.styleSheet = function (html) {
            if (this.svgStyles) {
                return this.svgStyles;
            }
            var sheet = this.svgStyles = _super.prototype.styleSheet.call(this, html);
            this.adaptor.setAttribute(sheet, 'id', SVG.STYLESHEETID);
            return sheet;
        };
        SVG.prototype.pageElements = function (html) {
            if (this.options.fontCache === 'global' && !this.findCache(html)) {
                return this.svg('svg', { id: SVG.FONTCACHEID, style: { display: 'none' } }, [this.fontCache.getCache()]);
            }
            return null;
        };
        SVG.prototype.findCache = function (html) {
            var adaptor = this.adaptor;
            var svgs = adaptor.tags(adaptor.body(html.document), 'svg');
            for (var i = svgs.length - 1; i >= 0; i--) {
                if (this.adaptor.getAttribute(svgs[i], 'id') === SVG.FONTCACHEID) {
                    return true;
                }
            }
            return false;
        };
        SVG.prototype.processMath = function (math, parent) {
            var container = this.container;
            this.container = parent;
            var wrapper = this.factory.wrap(math);
            var _a = __read(this.createRoot(wrapper), 2), svg = _a[0], g = _a[1];
            this.typesetSVG(wrapper, svg, g);
            this.container = container;
        };
        SVG.prototype.createRoot = function (wrapper) {
            var _a = wrapper.getOuterBBox(), w = _a.w, h = _a.h, d = _a.d, pwidth = _a.pwidth;
            var px = wrapper.metrics.em / 1000;
            var W = Math.max(w, px);
            var H = Math.max(h + d, px);
            var g = this.svg('g', {
                stroke: 'currentColor', fill: 'currentColor',
                'stroke-width': 0, transform: 'scale(1,-1)'
            });
            var adaptor = this.adaptor;
            var svg = adaptor.append(this.container, this.svg('svg', {
                xmlns: exports.SVGNS,
                width: this.ex(W), height: this.ex(H),
                role: 'img', focusable: false,
                style: { 'vertical-align': this.ex(-d) },
                viewBox: [0, this.fixed(-h * 1000, 1), this.fixed(W * 1000, 1), this.fixed(H * 1000, 1)].join(' ')
            }, [g]));
            if (W === .001) {
                adaptor.setAttribute(svg, 'preserveAspectRatio', 'xMidYMid slice');
                if (w < 0) {
                    adaptor.setStyle(this.container, 'margin-right', this.ex(w));
                }
            }
            if (pwidth) {
                adaptor.setStyle(svg, 'min-width', this.ex(W));
                adaptor.setAttribute(svg, 'width', pwidth);
                adaptor.removeAttribute(svg, 'viewBox');
                var scale = this.fixed(wrapper.metrics.ex / (this.font.params.x_height * 1000), 6);
                adaptor.setAttribute(g, 'transform', "scale(".concat(scale, ",-").concat(scale, ") translate(0, ").concat(this.fixed(-h * 1000, 1), ")"));
            }
            if (this.options.fontCache !== 'none') {
                adaptor.setAttribute(svg, 'xmlns:xlink', exports.XLINKNS);
            }
            return [svg, g];
        };
        SVG.prototype.typesetSVG = function (wrapper, svg, g) {
            var adaptor = this.adaptor;
            this.minwidth = this.shift = 0;
            if (this.options.fontCache === 'local') {
                this.fontCache.clearCache();
                this.fontCache.useLocalID(this.options.localID);
                adaptor.insert(this.fontCache.getCache(), g);
            }
            wrapper.toSVG(g);
            this.fontCache.clearLocalID();
            if (this.minwidth) {
                adaptor.setStyle(svg, 'minWidth', this.ex(this.minwidth));
                adaptor.setStyle(this.container, 'minWidth', this.ex(this.minwidth));
            }
            else if (this.shift) {
                var align = adaptor.getAttribute(this.container, 'justify') || 'center';
                this.setIndent(svg, align, this.shift);
            }
        };
        SVG.prototype.setIndent = function (svg, align, shift) {
            if (align === 'center' || align === 'left') {
                this.adaptor.setStyle(svg, 'margin-left', this.ex(shift));
            }
            if (align === 'center' || align === 'right') {
                this.adaptor.setStyle(svg, 'margin-right', this.ex(-shift));
            }
        };
        SVG.prototype.ex = function (m) {
            m /= this.font.params.x_height;
            return (Math.abs(m) < .001 ? '0' : m.toFixed(3).replace(/\.?0+$/, '') + 'ex');
        };
        SVG.prototype.svg = function (kind, properties, children) {
            if (properties === void 0) {
                properties = {};
            }
            if (children === void 0) {
                children = [];
            }
            return this.html(kind, properties, children, exports.SVGNS);
        };
        SVG.prototype.unknownText = function (text, variant) {
            var metrics = this.math.metrics;
            var scale = this.font.params.x_height / metrics.ex * metrics.em * 1000;
            var svg = this.svg('text', {
                'data-variant': variant,
                transform: 'scale(1,-1)', 'font-size': this.fixed(scale, 1) + 'px'
            }, [this.text(text)]);
            var adaptor = this.adaptor;
            if (variant !== '-explicitFont') {
                var c = (0, string_js_1.unicodeChars)(text);
                if (c.length !== 1 || c[0] < 0x1D400 || c[0] > 0x1D7FF) {
                    var _a = __read(this.font.getCssFont(variant), 3), family = _a[0], italic = _a[1], bold = _a[2];
                    adaptor.setAttribute(svg, 'font-family', family);
                    if (italic) {
                        adaptor.setAttribute(svg, 'font-style', 'italic');
                    }
                    if (bold) {
                        adaptor.setAttribute(svg, 'font-weight', 'bold');
                    }
                }
            }
            return svg;
        };
        SVG.prototype.measureTextNode = function (text) {
            var adaptor = this.adaptor;
            text = adaptor.clone(text);
            adaptor.removeAttribute(text, 'transform');
            var ex = this.fixed(this.font.params.x_height * 1000, 1);
            var svg = this.svg('svg', {
                position: 'absolute', visibility: 'hidden',
                width: '1ex', height: '1ex',
                viewBox: [0, 0, ex, ex].join(' ')
            }, [text]);
            adaptor.append(adaptor.body(adaptor.document), svg);
            var w = adaptor.nodeSize(text, 1000, true)[0];
            adaptor.remove(svg);
            return { w: w, h: .75, d: .2 };
        };
        SVG.NAME = 'SVG';
        SVG.OPTIONS = __assign(__assign({}, OutputJax_js_1.CommonOutputJax.OPTIONS), { internalSpeechTitles: true, titleID: 0, fontCache: 'local', localID: null });
        SVG.commonStyles = {
            'mjx-container[jax="SVG"]': {
                direction: 'ltr'
            },
            'mjx-container[jax="SVG"] > svg': {
                overflow: 'visible',
                'min-height': '1px',
                'min-width': '1px'
            },
            'mjx-container[jax="SVG"] > svg a': {
                fill: 'blue', stroke: 'blue'
            }
        };
        SVG.FONTCACHEID = 'MJX-SVG-global-cache';
        SVG.STYLESHEETID = 'MJX-SVG-styles';
        return SVG;
    }(OutputJax_js_1.CommonOutputJax));
    exports.SVG = SVG;
},
672: /* mathjax-full/js/output/common/OutputJax.js */ function _(require, module, exports, __esModule, __esExport) {
    var __extends = (this && this.__extends) || (function () {
        var extendStatics = function (d, b) {
            extendStatics = Object.setPrototypeOf ||
                ({ __proto__: [] } instanceof Array && function (d, b) { d.__proto__ = b; }) ||
                function (d, b) { for (var p in b)
                    if (Object.prototype.hasOwnProperty.call(b, p))
                        d[p] = b[p]; };
            return extendStatics(d, b);
        };
        return function (d, b) {
            if (typeof b !== "function" && b !== null)
                throw new TypeError("Class extends value " + String(b) + " is not a constructor or null");
            extendStatics(d, b);
            function __() { this.constructor = d; }
            d.prototype = b === null ? Object.create(b) : (__.prototype = b.prototype, new __());
        };
    })();
    var __assign = (this && this.__assign) || function () {
        __assign = Object.assign || function (t) {
            for (var s, i = 1, n = arguments.length; i < n; i++) {
                s = arguments[i];
                for (var p in s)
                    if (Object.prototype.hasOwnProperty.call(s, p))
                        t[p] = s[p];
            }
            return t;
        };
        return __assign.apply(this, arguments);
    };
    var __read = (this && this.__read) || function (o, n) {
        var m = typeof Symbol === "function" && o[Symbol.iterator];
        if (!m)
            return o;
        var i = m.call(o), r, ar = [], e;
        try {
            while ((n === void 0 || n-- > 0) && !(r = i.next()).done)
                ar.push(r.value);
        }
        catch (error) {
            e = { error: error };
        }
        finally {
            try {
                if (r && !r.done && (m = i["return"]))
                    m.call(i);
            }
            finally {
                if (e)
                    throw e.error;
            }
        }
        return ar;
    };
    var __values = (this && this.__values) || function (o) {
        var s = typeof Symbol === "function" && Symbol.iterator, m = s && o[s], i = 0;
        if (m)
            return m.call(o);
        if (o && typeof o.length === "number")
            return {
                next: function () {
                    if (o && i >= o.length)
                        o = void 0;
                    return { value: o && o[i++], done: !o };
                }
            };
        throw new TypeError(s ? "Object is not iterable." : "Symbol.iterator is not defined.");
    };
    __esModule();
    var OutputJax_js_1 = require(673) /* ../../core/OutputJax.js */;
    var MathItem_js_1 = require(637) /* ../../core/MathItem.js */;
    var Options_js_1 = require(632) /* ../../util/Options.js */;
    var lengths_js_1 = require(666) /* ../../util/lengths.js */;
    var Styles_js_1 = require(674) /* ../../util/Styles.js */;
    var StyleList_js_1 = require(675) /* ../../util/StyleList.js */;
    var CommonOutputJax = (function (_super) {
        __extends(CommonOutputJax, _super);
        function CommonOutputJax(options, defaultFactory, defaultFont) {
            if (options === void 0) {
                options = null;
            }
            if (defaultFactory === void 0) {
                defaultFactory = null;
            }
            if (defaultFont === void 0) {
                defaultFont = null;
            }
            var _this = this;
            var _a = __read((0, Options_js_1.separateOptions)(options, defaultFont.OPTIONS), 2), jaxOptions = _a[0], fontOptions = _a[1];
            _this = _super.call(this, jaxOptions) || this;
            _this.factory = _this.options.wrapperFactory ||
                new defaultFactory();
            _this.factory.jax = _this;
            _this.cssStyles = _this.options.cssStyles || new StyleList_js_1.CssStyles();
            _this.font = _this.options.font || new defaultFont(fontOptions);
            _this.unknownCache = new Map();
            return _this;
        }
        CommonOutputJax.prototype.typeset = function (math, html) {
            this.setDocument(html);
            var node = this.createNode();
            this.toDOM(math, node, html);
            return node;
        };
        CommonOutputJax.prototype.createNode = function () {
            var jax = this.constructor.NAME;
            return this.html('mjx-container', { 'class': 'MathJax', jax: jax });
        };
        CommonOutputJax.prototype.setScale = function (node) {
            var scale = this.math.metrics.scale * this.options.scale;
            if (scale !== 1) {
                this.adaptor.setStyle(node, 'fontSize', (0, lengths_js_1.percent)(scale));
            }
        };
        CommonOutputJax.prototype.toDOM = function (math, node, html) {
            if (html === void 0) {
                html = null;
            }
            this.setDocument(html);
            this.math = math;
            this.pxPerEm = math.metrics.ex / this.font.params.x_height;
            math.root.setTeXclass(null);
            this.setScale(node);
            this.nodeMap = new Map();
            this.container = node;
            this.processMath(math.root, node);
            this.nodeMap = null;
            this.executeFilters(this.postFilters, math, html, node);
        };
        CommonOutputJax.prototype.getBBox = function (math, html) {
            this.setDocument(html);
            this.math = math;
            math.root.setTeXclass(null);
            this.nodeMap = new Map();
            var bbox = this.factory.wrap(math.root).getOuterBBox();
            this.nodeMap = null;
            return bbox;
        };
        CommonOutputJax.prototype.getMetrics = function (html) {
            var e_1, _a;
            this.setDocument(html);
            var adaptor = this.adaptor;
            var maps = this.getMetricMaps(html);
            try {
                for (var _b = __values(html.math), _c = _b.next(); !_c.done; _c = _b.next()) {
                    var math = _c.value;
                    var parent_1 = adaptor.parent(math.start.node);
                    if (math.state() < MathItem_js_1.STATE.METRICS && parent_1) {
                        var map = maps[math.display ? 1 : 0];
                        var _d = map.get(parent_1), em = _d.em, ex = _d.ex, containerWidth = _d.containerWidth, lineWidth = _d.lineWidth, scale = _d.scale, family = _d.family;
                        math.setMetrics(em, ex, containerWidth, lineWidth, scale);
                        if (this.options.mtextInheritFont) {
                            math.outputData.mtextFamily = family;
                        }
                        if (this.options.merrorInheritFont) {
                            math.outputData.merrorFamily = family;
                        }
                        math.state(MathItem_js_1.STATE.METRICS);
                    }
                }
            }
            catch (e_1_1) {
                e_1 = { error: e_1_1 };
            }
            finally {
                try {
                    if (_c && !_c.done && (_a = _b.return))
                        _a.call(_b);
                }
                finally {
                    if (e_1)
                        throw e_1.error;
                }
            }
        };
        CommonOutputJax.prototype.getMetricsFor = function (node, display) {
            var getFamily = (this.options.mtextInheritFont || this.options.merrorInheritFont);
            var test = this.getTestElement(node, display);
            var metrics = this.measureMetrics(test, getFamily);
            this.adaptor.remove(test);
            return metrics;
        };
        CommonOutputJax.prototype.getMetricMaps = function (html) {
            var e_2, _a, e_3, _b, e_4, _c, e_5, _d, e_6, _e;
            var adaptor = this.adaptor;
            var domMaps = [new Map(), new Map()];
            try {
                for (var _f = __values(html.math), _g = _f.next(); !_g.done; _g = _f.next()) {
                    var math = _g.value;
                    var node = adaptor.parent(math.start.node);
                    if (node && math.state() < MathItem_js_1.STATE.METRICS) {
                        var map = domMaps[math.display ? 1 : 0];
                        if (!map.has(node)) {
                            map.set(node, this.getTestElement(node, math.display));
                        }
                    }
                }
            }
            catch (e_2_1) {
                e_2 = { error: e_2_1 };
            }
            finally {
                try {
                    if (_g && !_g.done && (_a = _f.return))
                        _a.call(_f);
                }
                finally {
                    if (e_2)
                        throw e_2.error;
                }
            }
            var getFamily = this.options.mtextInheritFont || this.options.merrorInheritFont;
            var maps = [new Map(), new Map()];
            try {
                for (var _h = __values(maps.keys()), _j = _h.next(); !_j.done; _j = _h.next()) {
                    var i = _j.value;
                    try {
                        for (var _k = (e_4 = void 0, __values(domMaps[i].keys())), _l = _k.next(); !_l.done; _l = _k.next()) {
                            var node = _l.value;
                            maps[i].set(node, this.measureMetrics(domMaps[i].get(node), getFamily));
                        }
                    }
                    catch (e_4_1) {
                        e_4 = { error: e_4_1 };
                    }
                    finally {
                        try {
                            if (_l && !_l.done && (_c = _k.return))
                                _c.call(_k);
                        }
                        finally {
                            if (e_4)
                                throw e_4.error;
                        }
                    }
                }
            }
            catch (e_3_1) {
                e_3 = { error: e_3_1 };
            }
            finally {
                try {
                    if (_j && !_j.done && (_b = _h.return))
                        _b.call(_h);
                }
                finally {
                    if (e_3)
                        throw e_3.error;
                }
            }
            try {
                for (var _m = __values(maps.keys()), _o = _m.next(); !_o.done; _o = _m.next()) {
                    var i = _o.value;
                    try {
                        for (var _p = (e_6 = void 0, __values(domMaps[i].values())), _q = _p.next(); !_q.done; _q = _p.next()) {
                            var node = _q.value;
                            adaptor.remove(node);
                        }
                    }
                    catch (e_6_1) {
                        e_6 = { error: e_6_1 };
                    }
                    finally {
                        try {
                            if (_q && !_q.done && (_e = _p.return))
                                _e.call(_p);
                        }
                        finally {
                            if (e_6)
                                throw e_6.error;
                        }
                    }
                }
            }
            catch (e_5_1) {
                e_5 = { error: e_5_1 };
            }
            finally {
                try {
                    if (_o && !_o.done && (_d = _m.return))
                        _d.call(_m);
                }
                finally {
                    if (e_5)
                        throw e_5.error;
                }
            }
            return maps;
        };
        CommonOutputJax.prototype.getTestElement = function (node, display) {
            var adaptor = this.adaptor;
            if (!this.testInline) {
                this.testInline = this.html('mjx-test', { style: {
                        display: 'inline-block',
                        width: '100%',
                        'font-style': 'normal',
                        'font-weight': 'normal',
                        'font-size': '100%',
                        'font-size-adjust': 'none',
                        'text-indent': 0,
                        'text-transform': 'none',
                        'letter-spacing': 'normal',
                        'word-spacing': 'normal',
                        overflow: 'hidden',
                        height: '1px',
                        'margin-right': '-1px'
                    } }, [
                    this.html('mjx-left-box', { style: {
                            display: 'inline-block',
                            width: 0,
                            'float': 'left'
                        } }),
                    this.html('mjx-ex-box', { style: {
                            position: 'absolute',
                            overflow: 'hidden',
                            width: '1px', height: '60ex'
                        } }),
                    this.html('mjx-right-box', { style: {
                            display: 'inline-block',
                            width: 0,
                            'float': 'right'
                        } })
                ]);
                this.testDisplay = adaptor.clone(this.testInline);
                adaptor.setStyle(this.testDisplay, 'display', 'table');
                adaptor.setStyle(this.testDisplay, 'margin-right', '');
                adaptor.setStyle(adaptor.firstChild(this.testDisplay), 'display', 'none');
                var right = adaptor.lastChild(this.testDisplay);
                adaptor.setStyle(right, 'display', 'table-cell');
                adaptor.setStyle(right, 'width', '10000em');
                adaptor.setStyle(right, 'float', '');
            }
            return adaptor.append(node, adaptor.clone(display ? this.testDisplay : this.testInline));
        };
        CommonOutputJax.prototype.measureMetrics = function (node, getFamily) {
            var adaptor = this.adaptor;
            var family = (getFamily ? adaptor.fontFamily(node) : '');
            var em = adaptor.fontSize(node);
            var _a = __read(adaptor.nodeSize(adaptor.childNode(node, 1)), 2), w = _a[0], h = _a[1];
            var ex = (w ? h / 60 : em * this.options.exFactor);
            var containerWidth = (!w ? 1000000 : adaptor.getStyle(node, 'display') === 'table' ?
                adaptor.nodeSize(adaptor.lastChild(node))[0] - 1 :
                adaptor.nodeBBox(adaptor.lastChild(node)).left -
                    adaptor.nodeBBox(adaptor.firstChild(node)).left - 2);
            var scale = Math.max(this.options.minScale, this.options.matchFontHeight ? ex / this.font.params.x_height / em : 1);
            var lineWidth = 1000000;
            return { em: em, ex: ex, containerWidth: containerWidth, lineWidth: lineWidth, scale: scale, family: family };
        };
        CommonOutputJax.prototype.styleSheet = function (html) {
            var e_7, _a;
            this.setDocument(html);
            this.cssStyles.clear();
            this.cssStyles.addStyles(this.constructor.commonStyles);
            if ('getStyles' in html) {
                try {
                    for (var _b = __values(html.getStyles()), _c = _b.next(); !_c.done; _c = _b.next()) {
                        var styles = _c.value;
                        this.cssStyles.addStyles(styles);
                    }
                }
                catch (e_7_1) {
                    e_7 = { error: e_7_1 };
                }
                finally {
                    try {
                        if (_c && !_c.done && (_a = _b.return))
                            _a.call(_b);
                    }
                    finally {
                        if (e_7)
                            throw e_7.error;
                    }
                }
            }
            this.addWrapperStyles(this.cssStyles);
            this.addFontStyles(this.cssStyles);
            var sheet = this.html('style', { id: 'MJX-styles' }, [this.text('\n' + this.cssStyles.cssText + '\n')]);
            return sheet;
        };
        CommonOutputJax.prototype.addFontStyles = function (styles) {
            styles.addStyles(this.font.styles);
        };
        CommonOutputJax.prototype.addWrapperStyles = function (styles) {
            var e_8, _a;
            try {
                for (var _b = __values(this.factory.getKinds()), _c = _b.next(); !_c.done; _c = _b.next()) {
                    var kind = _c.value;
                    this.addClassStyles(this.factory.getNodeClass(kind), styles);
                }
            }
            catch (e_8_1) {
                e_8 = { error: e_8_1 };
            }
            finally {
                try {
                    if (_c && !_c.done && (_a = _b.return))
                        _a.call(_b);
                }
                finally {
                    if (e_8)
                        throw e_8.error;
                }
            }
        };
        CommonOutputJax.prototype.addClassStyles = function (CLASS, styles) {
            styles.addStyles(CLASS.styles);
        };
        CommonOutputJax.prototype.setDocument = function (html) {
            if (html) {
                this.document = html;
                this.adaptor.document = html.document;
            }
        };
        CommonOutputJax.prototype.html = function (type, def, content, ns) {
            if (def === void 0) {
                def = {};
            }
            if (content === void 0) {
                content = [];
            }
            return this.adaptor.node(type, def, content, ns);
        };
        CommonOutputJax.prototype.text = function (text) {
            return this.adaptor.text(text);
        };
        CommonOutputJax.prototype.fixed = function (m, n) {
            if (n === void 0) {
                n = 3;
            }
            if (Math.abs(m) < .0006) {
                return '0';
            }
            return m.toFixed(n).replace(/\.?0+$/, '');
        };
        CommonOutputJax.prototype.measureText = function (text, variant, font) {
            if (font === void 0) {
                font = ['', false, false];
            }
            var node = this.unknownText(text, variant);
            if (variant === '-explicitFont') {
                var styles = this.cssFontStyles(font);
                this.adaptor.setAttributes(node, { style: styles });
            }
            return this.measureTextNodeWithCache(node, text, variant, font);
        };
        CommonOutputJax.prototype.measureTextNodeWithCache = function (text, chars, variant, font) {
            if (font === void 0) {
                font = ['', false, false];
            }
            if (variant === '-explicitFont') {
                variant = [font[0], font[1] ? 'T' : 'F', font[2] ? 'T' : 'F', ''].join('-');
            }
            if (!this.unknownCache.has(variant)) {
                this.unknownCache.set(variant, new Map());
            }
            var map = this.unknownCache.get(variant);
            var cached = map.get(chars);
            if (cached)
                return cached;
            var bbox = this.measureTextNode(text);
            map.set(chars, bbox);
            return bbox;
        };
        CommonOutputJax.prototype.measureXMLnode = function (xml) {
            var adaptor = this.adaptor;
            var content = this.html('mjx-xml-block', { style: { display: 'inline-block' } }, [adaptor.clone(xml)]);
            var base = this.html('mjx-baseline', { style: { display: 'inline-block', width: 0, height: 0 } });
            var style = {
                position: 'absolute',
                display: 'inline-block',
                'font-family': 'initial',
                'line-height': 'normal'
            };
            var node = this.html('mjx-measure-xml', { style: style }, [base, content]);
            adaptor.append(adaptor.parent(this.math.start.node), this.container);
            adaptor.append(this.container, node);
            var em = this.math.metrics.em * this.math.metrics.scale;
            var _a = adaptor.nodeBBox(content), left = _a.left, right = _a.right, bottom = _a.bottom, top = _a.top;
            var w = (right - left) / em;
            var h = (adaptor.nodeBBox(base).top - top) / em;
            var d = (bottom - top) / em - h;
            adaptor.remove(this.container);
            adaptor.remove(node);
            return { w: w, h: h, d: d };
        };
        CommonOutputJax.prototype.cssFontStyles = function (font, styles) {
            if (styles === void 0) {
                styles = {};
            }
            var _a = __read(font, 3), family = _a[0], italic = _a[1], bold = _a[2];
            styles['font-family'] = this.font.getFamily(family);
            if (italic)
                styles['font-style'] = 'italic';
            if (bold)
                styles['font-weight'] = 'bold';
            return styles;
        };
        CommonOutputJax.prototype.getFontData = function (styles) {
            if (!styles) {
                styles = new Styles_js_1.Styles();
            }
            return [this.font.getFamily(styles.get('font-family')),
                styles.get('font-style') === 'italic',
                styles.get('font-weight') === 'bold'];
        };
        CommonOutputJax.NAME = 'Common';
        CommonOutputJax.OPTIONS = __assign(__assign({}, OutputJax_js_1.AbstractOutputJax.OPTIONS), { scale: 1, minScale: .5, mtextInheritFont: false, merrorInheritFont: false, mtextFont: '', merrorFont: 'serif', mathmlSpacing: false, skipAttributes: {}, exFactor: .5, displayAlign: 'center', displayIndent: '0', wrapperFactory: null, font: null, cssStyles: null });
        CommonOutputJax.commonStyles = {};
        return CommonOutputJax;
    }(OutputJax_js_1.AbstractOutputJax));
    exports.CommonOutputJax = CommonOutputJax;
},
673: /* mathjax-full/js/core/OutputJax.js */ function _(require, module, exports, __esModule, __esExport) {
    __esModule();
    var Options_js_1 = require(632) /* ../util/Options.js */;
    var FunctionList_js_1 = require(633) /* ../util/FunctionList.js */;
    var AbstractOutputJax = (function () {
        function AbstractOutputJax(options) {
            if (options === void 0) {
                options = {};
            }
            this.adaptor = null;
            var CLASS = this.constructor;
            this.options = (0, Options_js_1.userOptions)((0, Options_js_1.defaultOptions)({}, CLASS.OPTIONS), options);
            this.postFilters = new FunctionList_js_1.FunctionList();
        }
        Object.defineProperty(AbstractOutputJax.prototype, "name", {
            get: function () {
                return this.constructor.NAME;
            },
            enumerable: false,
            configurable: true
        });
        AbstractOutputJax.prototype.setAdaptor = function (adaptor) {
            this.adaptor = adaptor;
        };
        AbstractOutputJax.prototype.initialize = function () {
        };
        AbstractOutputJax.prototype.reset = function () {
            var _args = [];
            for (var _i = 0; _i < arguments.length; _i++) {
                _args[_i] = arguments[_i];
            }
        };
        AbstractOutputJax.prototype.getMetrics = function (_document) {
        };
        AbstractOutputJax.prototype.styleSheet = function (_document) {
            return null;
        };
        AbstractOutputJax.prototype.pageElements = function (_document) {
            return null;
        };
        AbstractOutputJax.prototype.executeFilters = function (filters, math, document, data) {
            var args = { math: math, document: document, data: data };
            filters.execute(args);
            return args.data;
        };
        AbstractOutputJax.NAME = 'generic';
        AbstractOutputJax.OPTIONS = {};
        return AbstractOutputJax;
    }());
    exports.AbstractOutputJax = AbstractOutputJax;
},
674: /* mathjax-full/js/util/Styles.js */ function _(require, module, exports, __esModule, __esExport) {
    var __values = (this && this.__values) || function (o) {
        var s = typeof Symbol === "function" && Symbol.iterator, m = s && o[s], i = 0;
        if (m)
            return m.call(o);
        if (o && typeof o.length === "number")
            return {
                next: function () {
                    if (o && i >= o.length)
                        o = void 0;
                    return { value: o && o[i++], done: !o };
                }
            };
        throw new TypeError(s ? "Object is not iterable." : "Symbol.iterator is not defined.");
    };
    var __read = (this && this.__read) || function (o, n) {
        var m = typeof Symbol === "function" && o[Symbol.iterator];
        if (!m)
            return o;
        var i = m.call(o), r, ar = [], e;
        try {
            while ((n === void 0 || n-- > 0) && !(r = i.next()).done)
                ar.push(r.value);
        }
        catch (error) {
            e = { error: error };
        }
        finally {
            try {
                if (r && !r.done && (m = i["return"]))
                    m.call(i);
            }
            finally {
                if (e)
                    throw e.error;
            }
        }
        return ar;
    };
    var __spreadArray = (this && this.__spreadArray) || function (to, from, pack) {
        if (pack || arguments.length === 2)
            for (var i = 0, l = from.length, ar; i < l; i++) {
                if (ar || !(i in from)) {
                    if (!ar)
                        ar = Array.prototype.slice.call(from, 0, i);
                    ar[i] = from[i];
                }
            }
        return to.concat(ar || Array.prototype.slice.call(from));
    };
    __esModule();
    var TRBL = ['top', 'right', 'bottom', 'left'];
    var WSC = ['width', 'style', 'color'];
    function splitSpaces(text) {
        var parts = text.split(/((?:'[^']*'|"[^"]*"|,[\s\n]|[^\s\n])*)/g);
        var split = [];
        while (parts.length > 1) {
            parts.shift();
            split.push(parts.shift());
        }
        return split;
    }
    function splitTRBL(name) {
        var e_1, _a;
        var parts = splitSpaces(this.styles[name]);
        if (parts.length === 0) {
            parts.push('');
        }
        if (parts.length === 1) {
            parts.push(parts[0]);
        }
        if (parts.length === 2) {
            parts.push(parts[0]);
        }
        if (parts.length === 3) {
            parts.push(parts[1]);
        }
        try {
            for (var _b = __values(Styles.connect[name].children), _c = _b.next(); !_c.done; _c = _b.next()) {
                var child = _c.value;
                this.setStyle(this.childName(name, child), parts.shift());
            }
        }
        catch (e_1_1) {
            e_1 = { error: e_1_1 };
        }
        finally {
            try {
                if (_c && !_c.done && (_a = _b.return))
                    _a.call(_b);
            }
            finally {
                if (e_1)
                    throw e_1.error;
            }
        }
    }
    function combineTRBL(name) {
        var e_2, _a;
        var children = Styles.connect[name].children;
        var parts = [];
        try {
            for (var children_1 = __values(children), children_1_1 = children_1.next(); !children_1_1.done; children_1_1 = children_1.next()) {
                var child = children_1_1.value;
                var part = this.styles[name + '-' + child];
                if (!part) {
                    delete this.styles[name];
                    return;
                }
                parts.push(part);
            }
        }
        catch (e_2_1) {
            e_2 = { error: e_2_1 };
        }
        finally {
            try {
                if (children_1_1 && !children_1_1.done && (_a = children_1.return))
                    _a.call(children_1);
            }
            finally {
                if (e_2)
                    throw e_2.error;
            }
        }
        if (parts[3] === parts[1]) {
            parts.pop();
            if (parts[2] === parts[0]) {
                parts.pop();
                if (parts[1] === parts[0]) {
                    parts.pop();
                }
            }
        }
        this.styles[name] = parts.join(' ');
    }
    function splitSame(name) {
        var e_3, _a;
        try {
            for (var _b = __values(Styles.connect[name].children), _c = _b.next(); !_c.done; _c = _b.next()) {
                var child = _c.value;
                this.setStyle(this.childName(name, child), this.styles[name]);
            }
        }
        catch (e_3_1) {
            e_3 = { error: e_3_1 };
        }
        finally {
            try {
                if (_c && !_c.done && (_a = _b.return))
                    _a.call(_b);
            }
            finally {
                if (e_3)
                    throw e_3.error;
            }
        }
    }
    function combineSame(name) {
        var e_4, _a;
        var children = __spreadArray([], __read(Styles.connect[name].children), false);
        var value = this.styles[this.childName(name, children.shift())];
        try {
            for (var children_2 = __values(children), children_2_1 = children_2.next(); !children_2_1.done; children_2_1 = children_2.next()) {
                var child = children_2_1.value;
                if (this.styles[this.childName(name, child)] !== value) {
                    delete this.styles[name];
                    return;
                }
            }
        }
        catch (e_4_1) {
            e_4 = { error: e_4_1 };
        }
        finally {
            try {
                if (children_2_1 && !children_2_1.done && (_a = children_2.return))
                    _a.call(children_2);
            }
            finally {
                if (e_4)
                    throw e_4.error;
            }
        }
        this.styles[name] = value;
    }
    var BORDER = {
        width: /^(?:[\d.]+(?:[a-z]+)|thin|medium|thick|inherit|initial|unset)$/,
        style: /^(?:none|hidden|dotted|dashed|solid|double|groove|ridge|inset|outset|inherit|initial|unset)$/
    };
    function splitWSC(name) {
        var e_5, _a, e_6, _b;
        var parts = { width: '', style: '', color: '' };
        try {
            for (var _c = __values(splitSpaces(this.styles[name])), _d = _c.next(); !_d.done; _d = _c.next()) {
                var part = _d.value;
                if (part.match(BORDER.width) && parts.width === '') {
                    parts.width = part;
                }
                else if (part.match(BORDER.style) && parts.style === '') {
                    parts.style = part;
                }
                else {
                    parts.color = part;
                }
            }
        }
        catch (e_5_1) {
            e_5 = { error: e_5_1 };
        }
        finally {
            try {
                if (_d && !_d.done && (_a = _c.return))
                    _a.call(_c);
            }
            finally {
                if (e_5)
                    throw e_5.error;
            }
        }
        try {
            for (var _e = __values(Styles.connect[name].children), _f = _e.next(); !_f.done; _f = _e.next()) {
                var child = _f.value;
                this.setStyle(this.childName(name, child), parts[child]);
            }
        }
        catch (e_6_1) {
            e_6 = { error: e_6_1 };
        }
        finally {
            try {
                if (_f && !_f.done && (_b = _e.return))
                    _b.call(_e);
            }
            finally {
                if (e_6)
                    throw e_6.error;
            }
        }
    }
    function combineWSC(name) {
        var e_7, _a;
        var parts = [];
        try {
            for (var _b = __values(Styles.connect[name].children), _c = _b.next(); !_c.done; _c = _b.next()) {
                var child = _c.value;
                var value = this.styles[this.childName(name, child)];
                if (value) {
                    parts.push(value);
                }
            }
        }
        catch (e_7_1) {
            e_7 = { error: e_7_1 };
        }
        finally {
            try {
                if (_c && !_c.done && (_a = _b.return))
                    _a.call(_b);
            }
            finally {
                if (e_7)
                    throw e_7.error;
            }
        }
        if (parts.length) {
            this.styles[name] = parts.join(' ');
        }
        else {
            delete this.styles[name];
        }
    }
    var FONT = {
        style: /^(?:normal|italic|oblique|inherit|initial|unset)$/,
        variant: new RegExp('^(?:' +
            ['normal|none',
                'inherit|initial|unset',
                'common-ligatures|no-common-ligatures',
                'discretionary-ligatures|no-discretionary-ligatures',
                'historical-ligatures|no-historical-ligatures',
                'contextual|no-contextual',
                '(?:stylistic|character-variant|swash|ornaments|annotation)\\([^)]*\\)',
                'small-caps|all-small-caps|petite-caps|all-petite-caps|unicase|titling-caps',
                'lining-nums|oldstyle-nums|proportional-nums|tabular-nums',
                'diagonal-fractions|stacked-fractions',
                'ordinal|slashed-zero',
                'jis78|jis83|jis90|jis04|simplified|traditional',
                'full-width|proportional-width',
                'ruby'].join('|') + ')$'),
        weight: /^(?:normal|bold|bolder|lighter|[1-9]00|inherit|initial|unset)$/,
        stretch: new RegExp('^(?:' +
            ['normal',
                '(?:(?:ultra|extra|semi)-)?condensed',
                '(?:(?:semi|extra|ulta)-)?expanded',
                'inherit|initial|unset'].join('|') + ')$'),
        size: new RegExp('^(?:' +
            ['xx-small|x-small|small|medium|large|x-large|xx-large|larger|smaller',
                '[\d.]+%|[\d.]+[a-z]+',
                'inherit|initial|unset'].join('|') + ')' +
            '(?:\/(?:normal|[\d.\+](?:%|[a-z]+)?))?$')
    };
    function splitFont(name) {
        var e_8, _a, e_9, _b;
        var parts = splitSpaces(this.styles[name]);
        var value = {
            style: '', variant: [], weight: '', stretch: '',
            size: '', family: '', 'line-height': ''
        };
        try {
            for (var parts_1 = __values(parts), parts_1_1 = parts_1.next(); !parts_1_1.done; parts_1_1 = parts_1.next()) {
                var part = parts_1_1.value;
                value.family = part;
                try {
                    for (var _c = (e_9 = void 0, __values(Object.keys(FONT))), _d = _c.next(); !_d.done; _d = _c.next()) {
                        var name_1 = _d.value;
                        if ((Array.isArray(value[name_1]) || value[name_1] === '') && part.match(FONT[name_1])) {
                            if (name_1 === 'size') {
                                var _e = __read(part.split(/\//), 2), size = _e[0], height = _e[1];
                                value[name_1] = size;
                                if (height) {
                                    value['line-height'] = height;
                                }
                            }
                            else if (value.size === '') {
                                if (Array.isArray(value[name_1])) {
                                    value[name_1].push(part);
                                }
                                else {
                                    value[name_1] = part;
                                }
                            }
                        }
                    }
                }
                catch (e_9_1) {
                    e_9 = { error: e_9_1 };
                }
                finally {
                    try {
                        if (_d && !_d.done && (_b = _c.return))
                            _b.call(_c);
                    }
                    finally {
                        if (e_9)
                            throw e_9.error;
                    }
                }
            }
        }
        catch (e_8_1) {
            e_8 = { error: e_8_1 };
        }
        finally {
            try {
                if (parts_1_1 && !parts_1_1.done && (_a = parts_1.return))
                    _a.call(parts_1);
            }
            finally {
                if (e_8)
                    throw e_8.error;
            }
        }
        saveFontParts(name, value);
        delete this.styles[name];
    }
    function saveFontParts(name, value) {
        var e_10, _a;
        try {
            for (var _b = __values(Styles.connect[name].children), _c = _b.next(); !_c.done; _c = _b.next()) {
                var child = _c.value;
                var cname = this.childName(name, child);
                if (Array.isArray(value[child])) {
                    var values = value[child];
                    if (values.length) {
                        this.styles[cname] = values.join(' ');
                    }
                }
                else if (value[child] !== '') {
                    this.styles[cname] = value[child];
                }
            }
        }
        catch (e_10_1) {
            e_10 = { error: e_10_1 };
        }
        finally {
            try {
                if (_c && !_c.done && (_a = _b.return))
                    _a.call(_b);
            }
            finally {
                if (e_10)
                    throw e_10.error;
            }
        }
    }
    function combineFont(_name) { }
    var Styles = (function () {
        function Styles(cssText) {
            if (cssText === void 0) {
                cssText = '';
            }
            this.parse(cssText);
        }
        Object.defineProperty(Styles.prototype, "cssText", {
            get: function () {
                var e_11, _a;
                var styles = [];
                try {
                    for (var _b = __values(Object.keys(this.styles)), _c = _b.next(); !_c.done; _c = _b.next()) {
                        var name_2 = _c.value;
                        var parent_1 = this.parentName(name_2);
                        if (!this.styles[parent_1]) {
                            styles.push(name_2 + ': ' + this.styles[name_2] + ';');
                        }
                    }
                }
                catch (e_11_1) {
                    e_11 = { error: e_11_1 };
                }
                finally {
                    try {
                        if (_c && !_c.done && (_a = _b.return))
                            _a.call(_b);
                    }
                    finally {
                        if (e_11)
                            throw e_11.error;
                    }
                }
                return styles.join(' ');
            },
            enumerable: false,
            configurable: true
        });
        Styles.prototype.set = function (name, value) {
            name = this.normalizeName(name);
            this.setStyle(name, value);
            if (Styles.connect[name] && !Styles.connect[name].combine) {
                this.combineChildren(name);
                delete this.styles[name];
            }
            while (name.match(/-/)) {
                name = this.parentName(name);
                if (!Styles.connect[name])
                    break;
                Styles.connect[name].combine.call(this, name);
            }
        };
        Styles.prototype.get = function (name) {
            name = this.normalizeName(name);
            return (this.styles.hasOwnProperty(name) ? this.styles[name] : '');
        };
        Styles.prototype.setStyle = function (name, value) {
            this.styles[name] = value;
            if (Styles.connect[name] && Styles.connect[name].children) {
                Styles.connect[name].split.call(this, name);
            }
            if (value === '') {
                delete this.styles[name];
            }
        };
        Styles.prototype.combineChildren = function (name) {
            var e_12, _a;
            var parent = this.parentName(name);
            try {
                for (var _b = __values(Styles.connect[name].children), _c = _b.next(); !_c.done; _c = _b.next()) {
                    var child = _c.value;
                    var cname = this.childName(parent, child);
                    Styles.connect[cname].combine.call(this, cname);
                }
            }
            catch (e_12_1) {
                e_12 = { error: e_12_1 };
            }
            finally {
                try {
                    if (_c && !_c.done && (_a = _b.return))
                        _a.call(_b);
                }
                finally {
                    if (e_12)
                        throw e_12.error;
                }
            }
        };
        Styles.prototype.parentName = function (name) {
            var parent = name.replace(/-[^-]*$/, '');
            return (name === parent ? '' : parent);
        };
        Styles.prototype.childName = function (name, child) {
            if (child.match(/-/)) {
                return child;
            }
            if (Styles.connect[name] && !Styles.connect[name].combine) {
                child += name.replace(/.*-/, '-');
                name = this.parentName(name);
            }
            return name + '-' + child;
        };
        Styles.prototype.normalizeName = function (name) {
            return name.replace(/[A-Z]/g, function (c) { return '-' + c.toLowerCase(); });
        };
        Styles.prototype.parse = function (cssText) {
            if (cssText === void 0) {
                cssText = '';
            }
            var PATTERN = this.constructor.pattern;
            this.styles = {};
            var parts = cssText.replace(PATTERN.comment, '').split(PATTERN.style);
            while (parts.length > 1) {
                var _a = __read(parts.splice(0, 3), 3), space = _a[0], name_3 = _a[1], value = _a[2];
                if (space.match(/[^\s\n]/))
                    return;
                this.set(name_3, value);
            }
        };
        Styles.pattern = {
            style: /([-a-z]+)[\s\n]*:[\s\n]*((?:'[^']*'|"[^"]*"|\n|.)*?)[\s\n]*(?:;|$)/g,
            comment: /\/\*[^]*?\*\//g
        };
        Styles.connect = {
            padding: {
                children: TRBL,
                split: splitTRBL,
                combine: combineTRBL
            },
            border: {
                children: TRBL,
                split: splitSame,
                combine: combineSame
            },
            'border-top': {
                children: WSC,
                split: splitWSC,
                combine: combineWSC
            },
            'border-right': {
                children: WSC,
                split: splitWSC,
                combine: combineWSC
            },
            'border-bottom': {
                children: WSC,
                split: splitWSC,
                combine: combineWSC
            },
            'border-left': {
                children: WSC,
                split: splitWSC,
                combine: combineWSC
            },
            'border-width': {
                children: TRBL,
                split: splitTRBL,
                combine: null
            },
            'border-style': {
                children: TRBL,
                split: splitTRBL,
                combine: null
            },
            'border-color': {
                children: TRBL,
                split: splitTRBL,
                combine: null
            },
            font: {
                children: ['style', 'variant', 'weight', 'stretch', 'line-height', 'size', 'family'],
                split: splitFont,
                combine: combineFont
            }
        };
        return Styles;
    }());
    exports.Styles = Styles;
},
675: /* mathjax-full/js/util/StyleList.js */ function _(require, module, exports, __esModule, __esExport) {
    var __values = (this && this.__values) || function (o) {
        var s = typeof Symbol === "function" && Symbol.iterator, m = s && o[s], i = 0;
        if (m)
            return m.call(o);
        if (o && typeof o.length === "number")
            return {
                next: function () {
                    if (o && i >= o.length)
                        o = void 0;
                    return { value: o && o[i++], done: !o };
                }
            };
        throw new TypeError(s ? "Object is not iterable." : "Symbol.iterator is not defined.");
    };
    __esModule();
    var CssStyles = (function () {
        function CssStyles(styles) {
            if (styles === void 0) {
                styles = null;
            }
            this.styles = {};
            this.addStyles(styles);
        }
        Object.defineProperty(CssStyles.prototype, "cssText", {
            get: function () {
                return this.getStyleString();
            },
            enumerable: false,
            configurable: true
        });
        CssStyles.prototype.addStyles = function (styles) {
            var e_1, _a;
            if (!styles)
                return;
            try {
                for (var _b = __values(Object.keys(styles)), _c = _b.next(); !_c.done; _c = _b.next()) {
                    var style = _c.value;
                    if (!this.styles[style]) {
                        this.styles[style] = {};
                    }
                    Object.assign(this.styles[style], styles[style]);
                }
            }
            catch (e_1_1) {
                e_1 = { error: e_1_1 };
            }
            finally {
                try {
                    if (_c && !_c.done && (_a = _b.return))
                        _a.call(_b);
                }
                finally {
                    if (e_1)
                        throw e_1.error;
                }
            }
        };
        CssStyles.prototype.removeStyles = function () {
            var e_2, _a;
            var selectors = [];
            for (var _i = 0; _i < arguments.length; _i++) {
                selectors[_i] = arguments[_i];
            }
            try {
                for (var selectors_1 = __values(selectors), selectors_1_1 = selectors_1.next(); !selectors_1_1.done; selectors_1_1 = selectors_1.next()) {
                    var selector = selectors_1_1.value;
                    delete this.styles[selector];
                }
            }
            catch (e_2_1) {
                e_2 = { error: e_2_1 };
            }
            finally {
                try {
                    if (selectors_1_1 && !selectors_1_1.done && (_a = selectors_1.return))
                        _a.call(selectors_1);
                }
                finally {
                    if (e_2)
                        throw e_2.error;
                }
            }
        };
        CssStyles.prototype.clear = function () {
            this.styles = {};
        };
        CssStyles.prototype.getStyleString = function () {
            return this.getStyleRules().join('\n\n');
        };
        CssStyles.prototype.getStyleRules = function () {
            var e_3, _a;
            var selectors = Object.keys(this.styles);
            var defs = new Array(selectors.length);
            var i = 0;
            try {
                for (var selectors_2 = __values(selectors), selectors_2_1 = selectors_2.next(); !selectors_2_1.done; selectors_2_1 = selectors_2.next()) {
                    var selector = selectors_2_1.value;
                    defs[i++] = selector + ' {\n' + this.getStyleDefString(this.styles[selector]) + '\n}';
                }
            }
            catch (e_3_1) {
                e_3 = { error: e_3_1 };
            }
            finally {
                try {
                    if (selectors_2_1 && !selectors_2_1.done && (_a = selectors_2.return))
                        _a.call(selectors_2);
                }
                finally {
                    if (e_3)
                        throw e_3.error;
                }
            }
            return defs;
        };
        CssStyles.prototype.getStyleDefString = function (styles) {
            var e_4, _a;
            var properties = Object.keys(styles);
            var values = new Array(properties.length);
            var i = 0;
            try {
                for (var properties_1 = __values(properties), properties_1_1 = properties_1.next(); !properties_1_1.done; properties_1_1 = properties_1.next()) {
                    var property = properties_1_1.value;
                    values[i++] = '  ' + property + ': ' + styles[property] + ';';
                }
            }
            catch (e_4_1) {
                e_4 = { error: e_4_1 };
            }
            finally {
                try {
                    if (properties_1_1 && !properties_1_1.done && (_a = properties_1.return))
                        _a.call(properties_1);
                }
                finally {
                    if (e_4)
                        throw e_4.error;
                }
            }
            return values.join('\n');
        };
        return CssStyles;
    }());
    exports.CssStyles = CssStyles;
},
676: /* mathjax-full/js/output/svg/WrapperFactory.js */ function _(require, module, exports, __esModule, __esExport) {
    var __extends = (this && this.__extends) || (function () {
        var extendStatics = function (d, b) {
            extendStatics = Object.setPrototypeOf ||
                ({ __proto__: [] } instanceof Array && function (d, b) { d.__proto__ = b; }) ||
                function (d, b) { for (var p in b)
                    if (Object.prototype.hasOwnProperty.call(b, p))
                        d[p] = b[p]; };
            return extendStatics(d, b);
        };
        return function (d, b) {
            if (typeof b !== "function" && b !== null)
                throw new TypeError("Class extends value " + String(b) + " is not a constructor or null");
            extendStatics(d, b);
            function __() { this.constructor = d; }
            d.prototype = b === null ? Object.create(b) : (__.prototype = b.prototype, new __());
        };
    })();
    __esModule();
    var WrapperFactory_js_1 = require(677) /* ../common/WrapperFactory.js */;
    var Wrappers_js_1 = require(679) /* ./Wrappers.js */;
    var SVGWrapperFactory = (function (_super) {
        __extends(SVGWrapperFactory, _super);
        function SVGWrapperFactory() {
            var _this = _super !== null && _super.apply(this, arguments) || this;
            _this.jax = null;
            return _this;
        }
        SVGWrapperFactory.defaultNodes = Wrappers_js_1.SVGWrappers;
        return SVGWrapperFactory;
    }(WrapperFactory_js_1.CommonWrapperFactory));
    exports.SVGWrapperFactory = SVGWrapperFactory;
},
677: /* mathjax-full/js/output/common/WrapperFactory.js */ function _(require, module, exports, __esModule, __esExport) {
    var __extends = (this && this.__extends) || (function () {
        var extendStatics = function (d, b) {
            extendStatics = Object.setPrototypeOf ||
                ({ __proto__: [] } instanceof Array && function (d, b) { d.__proto__ = b; }) ||
                function (d, b) { for (var p in b)
                    if (Object.prototype.hasOwnProperty.call(b, p))
                        d[p] = b[p]; };
            return extendStatics(d, b);
        };
        return function (d, b) {
            if (typeof b !== "function" && b !== null)
                throw new TypeError("Class extends value " + String(b) + " is not a constructor or null");
            extendStatics(d, b);
            function __() { this.constructor = d; }
            d.prototype = b === null ? Object.create(b) : (__.prototype = b.prototype, new __());
        };
    })();
    __esModule();
    var WrapperFactory_js_1 = require(678) /* ../../core/Tree/WrapperFactory.js */;
    var CommonWrapperFactory = (function (_super) {
        __extends(CommonWrapperFactory, _super);
        function CommonWrapperFactory() {
            var _this = _super !== null && _super.apply(this, arguments) || this;
            _this.jax = null;
            return _this;
        }
        Object.defineProperty(CommonWrapperFactory.prototype, "Wrappers", {
            get: function () {
                return this.node;
            },
            enumerable: false,
            configurable: true
        });
        CommonWrapperFactory.defaultNodes = {};
        return CommonWrapperFactory;
    }(WrapperFactory_js_1.AbstractWrapperFactory));
    exports.CommonWrapperFactory = CommonWrapperFactory;
},
678: /* mathjax-full/js/core/Tree/WrapperFactory.js */ function _(require, module, exports, __esModule, __esExport) {
    var __extends = (this && this.__extends) || (function () {
        var extendStatics = function (d, b) {
            extendStatics = Object.setPrototypeOf ||
                ({ __proto__: [] } instanceof Array && function (d, b) { d.__proto__ = b; }) ||
                function (d, b) { for (var p in b)
                    if (Object.prototype.hasOwnProperty.call(b, p))
                        d[p] = b[p]; };
            return extendStatics(d, b);
        };
        return function (d, b) {
            if (typeof b !== "function" && b !== null)
                throw new TypeError("Class extends value " + String(b) + " is not a constructor or null");
            extendStatics(d, b);
            function __() { this.constructor = d; }
            d.prototype = b === null ? Object.create(b) : (__.prototype = b.prototype, new __());
        };
    })();
    var __read = (this && this.__read) || function (o, n) {
        var m = typeof Symbol === "function" && o[Symbol.iterator];
        if (!m)
            return o;
        var i = m.call(o), r, ar = [], e;
        try {
            while ((n === void 0 || n-- > 0) && !(r = i.next()).done)
                ar.push(r.value);
        }
        catch (error) {
            e = { error: error };
        }
        finally {
            try {
                if (r && !r.done && (m = i["return"]))
                    m.call(i);
            }
            finally {
                if (e)
                    throw e.error;
            }
        }
        return ar;
    };
    var __spreadArray = (this && this.__spreadArray) || function (to, from, pack) {
        if (pack || arguments.length === 2)
            for (var i = 0, l = from.length, ar; i < l; i++) {
                if (ar || !(i in from)) {
                    if (!ar)
                        ar = Array.prototype.slice.call(from, 0, i);
                    ar[i] = from[i];
                }
            }
        return to.concat(ar || Array.prototype.slice.call(from));
    };
    __esModule();
    var Factory_js_1 = require(654) /* ./Factory.js */;
    var AbstractWrapperFactory = (function (_super) {
        __extends(AbstractWrapperFactory, _super);
        function AbstractWrapperFactory() {
            return _super !== null && _super.apply(this, arguments) || this;
        }
        AbstractWrapperFactory.prototype.wrap = function (node) {
            var args = [];
            for (var _i = 1; _i < arguments.length; _i++) {
                args[_i - 1] = arguments[_i];
            }
            return this.create.apply(this, __spreadArray([node.kind, node], __read(args), false));
        };
        return AbstractWrapperFactory;
    }(Factory_js_1.AbstractFactory));
    exports.AbstractWrapperFactory = AbstractWrapperFactory;
},
679: /* mathjax-full/js/output/svg/Wrappers.js */ function _(require, module, exports, __esModule, __esExport) {
    var _a;
    __esModule();
    var Wrapper_js_1 = require(680) /* ./Wrapper.js */;
    var math_js_1 = require(685) /* ./Wrappers/math.js */;
    var mrow_js_1 = require(688) /* ./Wrappers/mrow.js */;
    var mi_js_1 = require(691) /* ./Wrappers/mi.js */;
    var mo_js_1 = require(694) /* ./Wrappers/mo.js */;
    var mn_js_1 = require(696) /* ./Wrappers/mn.js */;
    var ms_js_1 = require(699) /* ./Wrappers/ms.js */;
    var mtext_js_1 = require(702) /* ./Wrappers/mtext.js */;
    var merror_js_1 = require(705) /* ./Wrappers/merror.js */;
    var mspace_js_1 = require(707) /* ./Wrappers/mspace.js */;
    var mpadded_js_1 = require(710) /* ./Wrappers/mpadded.js */;
    var mphantom_js_1 = require(713) /* ./Wrappers/mphantom.js */;
    var mfrac_js_1 = require(715) /* ./Wrappers/mfrac.js */;
    var msqrt_js_1 = require(718) /* ./Wrappers/msqrt.js */;
    var mroot_js_1 = require(721) /* ./Wrappers/mroot.js */;
    var mfenced_js_1 = require(724) /* ./Wrappers/mfenced.js */;
    var msubsup_js_1 = require(727) /* ./Wrappers/msubsup.js */;
    var munderover_js_1 = require(732) /* ./Wrappers/munderover.js */;
    var mmultiscripts_js_1 = require(735) /* ./Wrappers/mmultiscripts.js */;
    var mtable_js_1 = require(738) /* ./Wrappers/mtable.js */;
    var mtr_js_1 = require(742) /* ./Wrappers/mtr.js */;
    var mtd_js_1 = require(745) /* ./Wrappers/mtd.js */;
    var maction_js_1 = require(748) /* ./Wrappers/maction.js */;
    var menclose_js_1 = require(751) /* ./Wrappers/menclose.js */;
    var semantics_js_1 = require(756) /* ./Wrappers/semantics.js */;
    var mglyph_js_1 = require(759) /* ./Wrappers/mglyph.js */;
    var TeXAtom_js_1 = require(762) /* ./Wrappers/TeXAtom.js */;
    var TextNode_js_1 = require(765) /* ./Wrappers/TextNode.js */;
    exports.SVGWrappers = (_a = {},
        _a[math_js_1.SVGmath.kind] = math_js_1.SVGmath,
        _a[mrow_js_1.SVGmrow.kind] = mrow_js_1.SVGmrow,
        _a[mrow_js_1.SVGinferredMrow.kind] = mrow_js_1.SVGinferredMrow,
        _a[mi_js_1.SVGmi.kind] = mi_js_1.SVGmi,
        _a[mo_js_1.SVGmo.kind] = mo_js_1.SVGmo,
        _a[mn_js_1.SVGmn.kind] = mn_js_1.SVGmn,
        _a[ms_js_1.SVGms.kind] = ms_js_1.SVGms,
        _a[mtext_js_1.SVGmtext.kind] = mtext_js_1.SVGmtext,
        _a[merror_js_1.SVGmerror.kind] = merror_js_1.SVGmerror,
        _a[mspace_js_1.SVGmspace.kind] = mspace_js_1.SVGmspace,
        _a[mpadded_js_1.SVGmpadded.kind] = mpadded_js_1.SVGmpadded,
        _a[mphantom_js_1.SVGmphantom.kind] = mphantom_js_1.SVGmphantom,
        _a[mfrac_js_1.SVGmfrac.kind] = mfrac_js_1.SVGmfrac,
        _a[msqrt_js_1.SVGmsqrt.kind] = msqrt_js_1.SVGmsqrt,
        _a[mroot_js_1.SVGmroot.kind] = mroot_js_1.SVGmroot,
        _a[mfenced_js_1.SVGmfenced.kind] = mfenced_js_1.SVGmfenced,
        _a[msubsup_js_1.SVGmsub.kind] = msubsup_js_1.SVGmsub,
        _a[msubsup_js_1.SVGmsup.kind] = msubsup_js_1.SVGmsup,
        _a[msubsup_js_1.SVGmsubsup.kind] = msubsup_js_1.SVGmsubsup,
        _a[munderover_js_1.SVGmunder.kind] = munderover_js_1.SVGmunder,
        _a[munderover_js_1.SVGmover.kind] = munderover_js_1.SVGmover,
        _a[munderover_js_1.SVGmunderover.kind] = munderover_js_1.SVGmunderover,
        _a[mmultiscripts_js_1.SVGmmultiscripts.kind] = mmultiscripts_js_1.SVGmmultiscripts,
        _a[mtable_js_1.SVGmtable.kind] = mtable_js_1.SVGmtable,
        _a[mtr_js_1.SVGmtr.kind] = mtr_js_1.SVGmtr,
        _a[mtr_js_1.SVGmlabeledtr.kind] = mtr_js_1.SVGmlabeledtr,
        _a[mtd_js_1.SVGmtd.kind] = mtd_js_1.SVGmtd,
        _a[maction_js_1.SVGmaction.kind] = maction_js_1.SVGmaction,
        _a[menclose_js_1.SVGmenclose.kind] = menclose_js_1.SVGmenclose,
        _a[semantics_js_1.SVGsemantics.kind] = semantics_js_1.SVGsemantics,
        _a[semantics_js_1.SVGannotation.kind] = semantics_js_1.SVGannotation,
        _a[semantics_js_1.SVGannotationXML.kind] = semantics_js_1.SVGannotationXML,
        _a[semantics_js_1.SVGxml.kind] = semantics_js_1.SVGxml,
        _a[mglyph_js_1.SVGmglyph.kind] = mglyph_js_1.SVGmglyph,
        _a[TeXAtom_js_1.SVGTeXAtom.kind] = TeXAtom_js_1.SVGTeXAtom,
        _a[TextNode_js_1.SVGTextNode.kind] = TextNode_js_1.SVGTextNode,
        _a[Wrapper_js_1.SVGWrapper.kind] = Wrapper_js_1.SVGWrapper,
        _a);
},
680: /* mathjax-full/js/output/svg/Wrapper.js */ function _(require, module, exports, __esModule, __esExport) {
    var __extends = (this && this.__extends) || (function () {
        var extendStatics = function (d, b) {
            extendStatics = Object.setPrototypeOf ||
                ({ __proto__: [] } instanceof Array && function (d, b) { d.__proto__ = b; }) ||
                function (d, b) { for (var p in b)
                    if (Object.prototype.hasOwnProperty.call(b, p))
                        d[p] = b[p]; };
            return extendStatics(d, b);
        };
        return function (d, b) {
            if (typeof b !== "function" && b !== null)
                throw new TypeError("Class extends value " + String(b) + " is not a constructor or null");
            extendStatics(d, b);
            function __() { this.constructor = d; }
            d.prototype = b === null ? Object.create(b) : (__.prototype = b.prototype, new __());
        };
    })();
    var __values = (this && this.__values) || function (o) {
        var s = typeof Symbol === "function" && Symbol.iterator, m = s && o[s], i = 0;
        if (m)
            return m.call(o);
        if (o && typeof o.length === "number")
            return {
                next: function () {
                    if (o && i >= o.length)
                        o = void 0;
                    return { value: o && o[i++], done: !o };
                }
            };
        throw new TypeError(s ? "Object is not iterable." : "Symbol.iterator is not defined.");
    };
    var __read = (this && this.__read) || function (o, n) {
        var m = typeof Symbol === "function" && o[Symbol.iterator];
        if (!m)
            return o;
        var i = m.call(o), r, ar = [], e;
        try {
            while ((n === void 0 || n-- > 0) && !(r = i.next()).done)
                ar.push(r.value);
        }
        catch (error) {
            e = { error: error };
        }
        finally {
            try {
                if (r && !r.done && (m = i["return"]))
                    m.call(i);
            }
            finally {
                if (e)
                    throw e.error;
            }
        }
        return ar;
    };
    __esModule();
    var BBox_js_1 = require(681) /* ../../util/BBox.js */;
    var Wrapper_js_1 = require(682) /* ../common/Wrapper.js */;
    var svg_js_1 = require(671) /* ../svg.js */;
    var SVGWrapper = (function (_super) {
        __extends(SVGWrapper, _super);
        function SVGWrapper() {
            var _this = _super !== null && _super.apply(this, arguments) || this;
            _this.element = null;
            _this.dx = 0;
            return _this;
        }
        SVGWrapper.prototype.toSVG = function (parent) {
            this.addChildren(this.standardSVGnode(parent));
        };
        SVGWrapper.prototype.addChildren = function (parent) {
            var e_1, _a;
            var x = 0;
            try {
                for (var _b = __values(this.childNodes), _c = _b.next(); !_c.done; _c = _b.next()) {
                    var child = _c.value;
                    child.toSVG(parent);
                    var bbox = child.getOuterBBox();
                    if (child.element) {
                        child.place(x + bbox.L * bbox.rscale, 0);
                    }
                    x += (bbox.L + bbox.w + bbox.R) * bbox.rscale;
                }
            }
            catch (e_1_1) {
                e_1 = { error: e_1_1 };
            }
            finally {
                try {
                    if (_c && !_c.done && (_a = _b.return))
                        _a.call(_b);
                }
                finally {
                    if (e_1)
                        throw e_1.error;
                }
            }
        };
        SVGWrapper.prototype.standardSVGnode = function (parent) {
            var svg = this.createSVGnode(parent);
            this.handleStyles();
            this.handleScale();
            this.handleBorder();
            this.handleColor();
            this.handleAttributes();
            return svg;
        };
        SVGWrapper.prototype.createSVGnode = function (parent) {
            this.element = this.svg('g', { 'data-mml-node': this.node.kind });
            var href = this.node.attributes.get('href');
            if (href) {
                parent = this.adaptor.append(parent, this.svg('a', { href: href }));
                var _a = this.getOuterBBox(), h = _a.h, d = _a.d, w = _a.w;
                this.adaptor.append(this.element, this.svg('rect', {
                    'data-hitbox': true, fill: 'none', stroke: 'none', 'pointer-events': 'all',
                    width: this.fixed(w), height: this.fixed(h + d), y: this.fixed(-d)
                }));
            }
            this.adaptor.append(parent, this.element);
            return this.element;
        };
        SVGWrapper.prototype.handleStyles = function () {
            var _this = this;
            if (!this.styles)
                return;
            var styles = this.styles.cssText;
            if (styles) {
                this.adaptor.setAttribute(this.element, 'style', styles);
            }
            BBox_js_1.BBox.StyleAdjust.forEach(function (_a) {
                var _b = __read(_a, 3), name = _b[0], lr = _b[2];
                if (lr !== 0)
                    return;
                var x = _this.styles.get(name);
                if (x) {
                    _this.dx += _this.length2em(x, 1, _this.bbox.rscale);
                }
            });
        };
        SVGWrapper.prototype.handleScale = function () {
            if (this.bbox.rscale !== 1) {
                var scale = 'scale(' + this.fixed(this.bbox.rscale / 1000, 3) + ')';
                this.adaptor.setAttribute(this.element, 'transform', scale);
            }
        };
        SVGWrapper.prototype.handleColor = function () {
            var _a;
            var adaptor = this.adaptor;
            var attributes = this.node.attributes;
            var mathcolor = attributes.getExplicit('mathcolor');
            var color = attributes.getExplicit('color');
            var mathbackground = attributes.getExplicit('mathbackground');
            var background = attributes.getExplicit('background');
            var bgcolor = (((_a = this.styles) === null || _a === void 0 ? void 0 : _a.get('background-color')) || '');
            if (mathcolor || color) {
                adaptor.setAttribute(this.element, 'fill', mathcolor || color);
                adaptor.setAttribute(this.element, 'stroke', mathcolor || color);
            }
            if (mathbackground || background || bgcolor) {
                var _b = this.getOuterBBox(), h = _b.h, d = _b.d, w = _b.w;
                var rect = this.svg('rect', {
                    fill: mathbackground || background || bgcolor,
                    x: this.fixed(-this.dx), y: this.fixed(-d),
                    width: this.fixed(w),
                    height: this.fixed(h + d),
                    'data-bgcolor': true
                });
                var child = adaptor.firstChild(this.element);
                if (child) {
                    adaptor.insert(rect, child);
                }
                else {
                    adaptor.append(this.element, rect);
                }
            }
        };
        SVGWrapper.prototype.handleBorder = function () {
            var e_2, _a, e_3, _b;
            if (!this.styles)
                return;
            var width = Array(4).fill(0);
            var style = Array(4);
            var color = Array(4);
            try {
                for (var _c = __values([['Top', 0], ['Right', 1], ['Bottom', 2], ['Left', 3]]), _d = _c.next(); !_d.done; _d = _c.next()) {
                    var _e = __read(_d.value, 2), name_1 = _e[0], i = _e[1];
                    var key = 'border' + name_1;
                    var w_1 = this.styles.get(key + 'Width');
                    if (!w_1)
                        continue;
                    width[i] = Math.max(0, this.length2em(w_1, 1, this.bbox.rscale));
                    style[i] = this.styles.get(key + 'Style') || 'solid';
                    color[i] = this.styles.get(key + 'Color') || 'currentColor';
                }
            }
            catch (e_2_1) {
                e_2 = { error: e_2_1 };
            }
            finally {
                try {
                    if (_d && !_d.done && (_a = _c.return))
                        _a.call(_c);
                }
                finally {
                    if (e_2)
                        throw e_2.error;
                }
            }
            var f = SVGWrapper.borderFuzz;
            var bbox = this.getOuterBBox();
            var _f = __read([bbox.h + f, bbox.d + f, bbox.w + f], 3), h = _f[0], d = _f[1], w = _f[2];
            var outerRT = [w, h];
            var outerLT = [-f, h];
            var outerRB = [w, -d];
            var outerLB = [-f, -d];
            var innerRT = [w - width[1], h - width[0]];
            var innerLT = [-f + width[3], h - width[0]];
            var innerRB = [w - width[1], -d + width[2]];
            var innerLB = [-f + width[3], -d + width[2]];
            var paths = [
                [outerLT, outerRT, innerRT, innerLT],
                [outerRB, outerRT, innerRT, innerRB],
                [outerLB, outerRB, innerRB, innerLB],
                [outerLB, outerLT, innerLT, innerLB]
            ];
            var adaptor = this.adaptor;
            var child = adaptor.firstChild(this.element);
            try {
                for (var _g = __values([0, 1, 2, 3]), _h = _g.next(); !_h.done; _h = _g.next()) {
                    var i = _h.value;
                    if (!width[i])
                        continue;
                    var path = paths[i];
                    if (style[i] === 'dashed' || style[i] === 'dotted') {
                        this.addBorderBroken(path, color[i], style[i], width[i], i);
                    }
                    else {
                        this.addBorderSolid(path, color[i], child);
                    }
                }
            }
            catch (e_3_1) {
                e_3 = { error: e_3_1 };
            }
            finally {
                try {
                    if (_h && !_h.done && (_b = _g.return))
                        _b.call(_g);
                }
                finally {
                    if (e_3)
                        throw e_3.error;
                }
            }
        };
        SVGWrapper.prototype.addBorderSolid = function (path, color, child) {
            var _this = this;
            var border = this.svg('polygon', {
                points: path.map(function (_a) {
                    var _b = __read(_a, 2), x = _b[0], y = _b[1];
                    return "".concat(_this.fixed(x - _this.dx), ",").concat(_this.fixed(y));
                }).join(' '),
                stroke: 'none',
                fill: color
            });
            if (child) {
                this.adaptor.insert(border, child);
            }
            else {
                this.adaptor.append(this.element, border);
            }
        };
        SVGWrapper.prototype.addBorderBroken = function (path, color, style, t, i) {
            var dot = (style === 'dotted');
            var t2 = t / 2;
            var _a = __read([[t2, -t2, -t2, -t2], [-t2, t2, -t2, -t2], [t2, t2, -t2, t2], [t2, t2, t2, -t2]][i], 4), tx1 = _a[0], ty1 = _a[1], tx2 = _a[2], ty2 = _a[3];
            var _b = __read(path, 2), A = _b[0], B = _b[1];
            var x1 = A[0] + tx1 - this.dx, y1 = A[1] + ty1;
            var x2 = B[0] + tx2 - this.dx, y2 = B[1] + ty2;
            var W = Math.abs(i % 2 ? y2 - y1 : x2 - x1);
            var n = (dot ? Math.ceil(W / (2 * t)) : Math.ceil((W - t) / (4 * t)));
            var m = W / (4 * n + 1);
            var line = this.svg('line', {
                x1: this.fixed(x1), y1: this.fixed(y1),
                x2: this.fixed(x2), y2: this.fixed(y2),
                'stroke-width': this.fixed(t), stroke: color, 'stroke-linecap': dot ? 'round' : 'square',
                'stroke-dasharray': dot ? [1, this.fixed(W / n - .002)].join(' ') : [this.fixed(m), this.fixed(3 * m)].join(' ')
            });
            var adaptor = this.adaptor;
            var child = adaptor.firstChild(this.element);
            if (child) {
                adaptor.insert(line, child);
            }
            else {
                adaptor.append(this.element, line);
            }
        };
        SVGWrapper.prototype.handleAttributes = function () {
            var e_4, _a, e_5, _b;
            var attributes = this.node.attributes;
            var defaults = attributes.getAllDefaults();
            var skip = SVGWrapper.skipAttributes;
            try {
                for (var _c = __values(attributes.getExplicitNames()), _d = _c.next(); !_d.done; _d = _c.next()) {
                    var name_2 = _d.value;
                    if (skip[name_2] === false || (!(name_2 in defaults) && !skip[name_2] &&
                        !this.adaptor.hasAttribute(this.element, name_2))) {
                        this.adaptor.setAttribute(this.element, name_2, attributes.getExplicit(name_2));
                    }
                }
            }
            catch (e_4_1) {
                e_4 = { error: e_4_1 };
            }
            finally {
                try {
                    if (_d && !_d.done && (_a = _c.return))
                        _a.call(_c);
                }
                finally {
                    if (e_4)
                        throw e_4.error;
                }
            }
            if (attributes.get('class')) {
                var names = attributes.get('class').trim().split(/ +/);
                try {
                    for (var names_1 = __values(names), names_1_1 = names_1.next(); !names_1_1.done; names_1_1 = names_1.next()) {
                        var name_3 = names_1_1.value;
                        this.adaptor.addClass(this.element, name_3);
                    }
                }
                catch (e_5_1) {
                    e_5 = { error: e_5_1 };
                }
                finally {
                    try {
                        if (names_1_1 && !names_1_1.done && (_b = names_1.return))
                            _b.call(names_1);
                    }
                    finally {
                        if (e_5)
                            throw e_5.error;
                    }
                }
            }
        };
        SVGWrapper.prototype.place = function (x, y, element) {
            if (element === void 0) {
                element = null;
            }
            x += this.dx;
            if (!(x || y))
                return;
            if (!element) {
                element = this.element;
                y = this.handleId(y);
            }
            var translate = "translate(".concat(this.fixed(x), ",").concat(this.fixed(y), ")");
            var transform = this.adaptor.getAttribute(element, 'transform') || '';
            this.adaptor.setAttribute(element, 'transform', translate + (transform ? ' ' + transform : ''));
        };
        SVGWrapper.prototype.handleId = function (y) {
            if (!this.node.attributes || !this.node.attributes.get('id')) {
                return y;
            }
            var adaptor = this.adaptor;
            var h = this.getBBox().h;
            var children = adaptor.childNodes(this.element);
            children.forEach(function (child) { return adaptor.remove(child); });
            var g = this.svg('g', { 'data-idbox': true, transform: "translate(0,".concat(this.fixed(-h), ")") }, children);
            adaptor.append(this.element, this.svg('text', { 'data-id-align': true }, [this.text('')]));
            adaptor.append(this.element, g);
            return y + h;
        };
        SVGWrapper.prototype.firstChild = function () {
            var adaptor = this.adaptor;
            var child = adaptor.firstChild(this.element);
            if (child && adaptor.kind(child) === 'text' && adaptor.getAttribute(child, 'data-id-align')) {
                child = adaptor.firstChild(adaptor.next(child));
            }
            if (child && adaptor.kind(child) === 'rect' && adaptor.getAttribute(child, 'data-hitbox')) {
                child = adaptor.next(child);
            }
            return child;
        };
        SVGWrapper.prototype.placeChar = function (n, x, y, parent, variant) {
            var e_6, _a;
            if (variant === void 0) {
                variant = null;
            }
            if (variant === null) {
                variant = this.variant;
            }
            var C = n.toString(16).toUpperCase();
            var _b = __read(this.getVariantChar(variant, n), 4), w = _b[2], data = _b[3];
            if ('p' in data) {
                var path = (data.p ? 'M' + data.p + 'Z' : '');
                this.place(x, y, this.adaptor.append(parent, this.charNode(variant, C, path)));
            }
            else if ('c' in data) {
                var g = this.adaptor.append(parent, this.svg('g', { 'data-c': C }));
                this.place(x, y, g);
                x = 0;
                try {
                    for (var _c = __values(this.unicodeChars(data.c, variant)), _d = _c.next(); !_d.done; _d = _c.next()) {
                        var n_1 = _d.value;
                        x += this.placeChar(n_1, x, y, g, variant);
                    }
                }
                catch (e_6_1) {
                    e_6 = { error: e_6_1 };
                }
                finally {
                    try {
                        if (_d && !_d.done && (_a = _c.return))
                            _a.call(_c);
                    }
                    finally {
                        if (e_6)
                            throw e_6.error;
                    }
                }
            }
            else if (data.unknown) {
                var char = String.fromCodePoint(n);
                var text = this.adaptor.append(parent, this.jax.unknownText(char, variant));
                this.place(x, y, text);
                return this.jax.measureTextNodeWithCache(text, char, variant).w;
            }
            return w;
        };
        SVGWrapper.prototype.charNode = function (variant, C, path) {
            var cache = this.jax.options.fontCache;
            return (cache !== 'none' ? this.useNode(variant, C, path) : this.pathNode(C, path));
        };
        SVGWrapper.prototype.pathNode = function (C, path) {
            return this.svg('path', { 'data-c': C, d: path });
        };
        SVGWrapper.prototype.useNode = function (variant, C, path) {
            var use = this.svg('use', { 'data-c': C });
            var id = '#' + this.jax.fontCache.cachePath(variant, C, path);
            this.adaptor.setAttribute(use, 'href', id, svg_js_1.XLINKNS);
            return use;
        };
        SVGWrapper.prototype.drawBBox = function () {
            var _a = this.getBBox(), w = _a.w, h = _a.h, d = _a.d;
            var box = this.svg('g', { style: {
                    opacity: .25
                } }, [
                this.svg('rect', {
                    fill: 'red',
                    height: this.fixed(h),
                    width: this.fixed(w)
                }),
                this.svg('rect', {
                    fill: 'green',
                    height: this.fixed(d),
                    width: this.fixed(w),
                    y: this.fixed(-d)
                })
            ]);
            var node = this.element || this.parent.element;
            this.adaptor.append(node, box);
        };
        SVGWrapper.prototype.html = function (type, def, content) {
            if (def === void 0) {
                def = {};
            }
            if (content === void 0) {
                content = [];
            }
            return this.jax.html(type, def, content);
        };
        SVGWrapper.prototype.svg = function (type, def, content) {
            if (def === void 0) {
                def = {};
            }
            if (content === void 0) {
                content = [];
            }
            return this.jax.svg(type, def, content);
        };
        SVGWrapper.prototype.text = function (text) {
            return this.jax.text(text);
        };
        SVGWrapper.prototype.fixed = function (x, n) {
            if (n === void 0) {
                n = 1;
            }
            return this.jax.fixed(x * 1000, n);
        };
        SVGWrapper.kind = 'unknown';
        SVGWrapper.borderFuzz = 0.005;
        return SVGWrapper;
    }(Wrapper_js_1.CommonWrapper));
    exports.SVGWrapper = SVGWrapper;
},
681: /* mathjax-full/js/util/BBox.js */ function _(require, module, exports, __esModule, __esExport) {
    __esModule();
    var lengths_js_1 = require(666) /* ./lengths.js */;
    var BBox = (function () {
        function BBox(def) {
            if (def === void 0) {
                def = { w: 0, h: -lengths_js_1.BIGDIMEN, d: -lengths_js_1.BIGDIMEN };
            }
            this.w = def.w || 0;
            this.h = ('h' in def ? def.h : -lengths_js_1.BIGDIMEN);
            this.d = ('d' in def ? def.d : -lengths_js_1.BIGDIMEN);
            this.L = this.R = this.ic = this.sk = this.dx = 0;
            this.scale = this.rscale = 1;
            this.pwidth = '';
        }
        BBox.zero = function () {
            return new BBox({ h: 0, d: 0, w: 0 });
        };
        BBox.empty = function () {
            return new BBox();
        };
        BBox.prototype.empty = function () {
            this.w = 0;
            this.h = this.d = -lengths_js_1.BIGDIMEN;
            return this;
        };
        BBox.prototype.clean = function () {
            if (this.w === -lengths_js_1.BIGDIMEN)
                this.w = 0;
            if (this.h === -lengths_js_1.BIGDIMEN)
                this.h = 0;
            if (this.d === -lengths_js_1.BIGDIMEN)
                this.d = 0;
        };
        BBox.prototype.rescale = function (scale) {
            this.w *= scale;
            this.h *= scale;
            this.d *= scale;
        };
        BBox.prototype.combine = function (cbox, x, y) {
            if (x === void 0) {
                x = 0;
            }
            if (y === void 0) {
                y = 0;
            }
            var rscale = cbox.rscale;
            var w = x + rscale * (cbox.w + cbox.L + cbox.R);
            var h = y + rscale * cbox.h;
            var d = rscale * cbox.d - y;
            if (w > this.w)
                this.w = w;
            if (h > this.h)
                this.h = h;
            if (d > this.d)
                this.d = d;
        };
        BBox.prototype.append = function (cbox) {
            var scale = cbox.rscale;
            this.w += scale * (cbox.w + cbox.L + cbox.R);
            if (scale * cbox.h > this.h) {
                this.h = scale * cbox.h;
            }
            if (scale * cbox.d > this.d) {
                this.d = scale * cbox.d;
            }
        };
        BBox.prototype.updateFrom = function (cbox) {
            this.h = cbox.h;
            this.d = cbox.d;
            this.w = cbox.w;
            if (cbox.pwidth) {
                this.pwidth = cbox.pwidth;
            }
        };
        BBox.fullWidth = '100%';
        BBox.StyleAdjust = [
            ['borderTopWidth', 'h'],
            ['borderRightWidth', 'w'],
            ['borderBottomWidth', 'd'],
            ['borderLeftWidth', 'w', 0],
            ['paddingTop', 'h'],
            ['paddingRight', 'w'],
            ['paddingBottom', 'd'],
            ['paddingLeft', 'w', 0]
        ];
        return BBox;
    }());
    exports.BBox = BBox;
},
682: /* mathjax-full/js/output/common/Wrapper.js */ function _(require, module, exports, __esModule, __esExport) {
    var __extends = (this && this.__extends) || (function () {
        var extendStatics = function (d, b) {
            extendStatics = Object.setPrototypeOf ||
                ({ __proto__: [] } instanceof Array && function (d, b) { d.__proto__ = b; }) ||
                function (d, b) { for (var p in b)
                    if (Object.prototype.hasOwnProperty.call(b, p))
                        d[p] = b[p]; };
            return extendStatics(d, b);
        };
        return function (d, b) {
            if (typeof b !== "function" && b !== null)
                throw new TypeError("Class extends value " + String(b) + " is not a constructor or null");
            extendStatics(d, b);
            function __() { this.constructor = d; }
            d.prototype = b === null ? Object.create(b) : (__.prototype = b.prototype, new __());
        };
    })();
    var __createBinding = (this && this.__createBinding) || (Object.create ? (function (o, m, k, k2) {
        if (k2 === undefined)
            k2 = k;
        var desc = Object.getOwnPropertyDescriptor(m, k);
        if (!desc || ("get" in desc ? !m.__esModule : desc.writable || desc.configurable)) {
            desc = { enumerable: true, get: function () { return m[k]; } };
        }
        Object.defineProperty(o, k2, desc);
    }) : (function (o, m, k, k2) {
        if (k2 === undefined)
            k2 = k;
        o[k2] = m[k];
    }));
    var __setModuleDefault = (this && this.__setModuleDefault) || (Object.create ? (function (o, v) {
        Object.defineProperty(o, "default", { enumerable: true, value: v });
    }) : function (o, v) {
        o["default"] = v;
    });
    var __importStar = (this && this.__importStar) || function (mod) {
        if (mod && mod.__esModule)
            return mod;
        var result = {};
        if (mod != null)
            for (var k in mod)
                if (k !== "default" && Object.prototype.hasOwnProperty.call(mod, k))
                    __createBinding(result, mod, k);
        __setModuleDefault(result, mod);
        return result;
    };
    var __values = (this && this.__values) || function (o) {
        var s = typeof Symbol === "function" && Symbol.iterator, m = s && o[s], i = 0;
        if (m)
            return m.call(o);
        if (o && typeof o.length === "number")
            return {
                next: function () {
                    if (o && i >= o.length)
                        o = void 0;
                    return { value: o && o[i++], done: !o };
                }
            };
        throw new TypeError(s ? "Object is not iterable." : "Symbol.iterator is not defined.");
    };
    var __read = (this && this.__read) || function (o, n) {
        var m = typeof Symbol === "function" && o[Symbol.iterator];
        if (!m)
            return o;
        var i = m.call(o), r, ar = [], e;
        try {
            while ((n === void 0 || n-- > 0) && !(r = i.next()).done)
                ar.push(r.value);
        }
        catch (error) {
            e = { error: error };
        }
        finally {
            try {
                if (r && !r.done && (m = i["return"]))
                    m.call(i);
            }
            finally {
                if (e)
                    throw e.error;
            }
        }
        return ar;
    };
    var __spreadArray = (this && this.__spreadArray) || function (to, from, pack) {
        if (pack || arguments.length === 2)
            for (var i = 0, l = from.length, ar; i < l; i++) {
                if (ar || !(i in from)) {
                    if (!ar)
                        ar = Array.prototype.slice.call(from, 0, i);
                    ar[i] = from[i];
                }
            }
        return to.concat(ar || Array.prototype.slice.call(from));
    };
    __esModule();
    var Wrapper_js_1 = require(683) /* ../../core/Tree/Wrapper.js */;
    var MmlNode_js_1 = require(639) /* ../../core/MmlTree/MmlNode.js */;
    var string_js_1 = require(636) /* ../../util/string.js */;
    var LENGTHS = __importStar(require(666) /* ../../util/lengths.js */);
    var Styles_js_1 = require(674) /* ../../util/Styles.js */;
    var BBox_js_1 = require(681) /* ../../util/BBox.js */;
    var FontData_js_1 = require(684) /* ./FontData.js */;
    var SMALLSIZE = 2 / 18;
    function MathMLSpace(script, size) {
        return (script ? size < SMALLSIZE ? 0 : SMALLSIZE : size);
    }
    var CommonWrapper = (function (_super) {
        __extends(CommonWrapper, _super);
        function CommonWrapper(factory, node, parent) {
            if (parent === void 0) {
                parent = null;
            }
            var _this = _super.call(this, factory, node) || this;
            _this.parent = null;
            _this.removedStyles = null;
            _this.styles = null;
            _this.variant = '';
            _this.bboxComputed = false;
            _this.stretch = FontData_js_1.NOSTRETCH;
            _this.font = null;
            _this.parent = parent;
            _this.font = factory.jax.font;
            _this.bbox = BBox_js_1.BBox.zero();
            _this.getStyles();
            _this.getVariant();
            _this.getScale();
            _this.getSpace();
            _this.childNodes = node.childNodes.map(function (child) {
                var wrapped = _this.wrap(child);
                if (wrapped.bbox.pwidth && (node.notParent || node.isKind('math'))) {
                    _this.bbox.pwidth = BBox_js_1.BBox.fullWidth;
                }
                return wrapped;
            });
            return _this;
        }
        Object.defineProperty(CommonWrapper.prototype, "jax", {
            get: function () {
                return this.factory.jax;
            },
            enumerable: false,
            configurable: true
        });
        Object.defineProperty(CommonWrapper.prototype, "adaptor", {
            get: function () {
                return this.factory.jax.adaptor;
            },
            enumerable: false,
            configurable: true
        });
        Object.defineProperty(CommonWrapper.prototype, "metrics", {
            get: function () {
                return this.factory.jax.math.metrics;
            },
            enumerable: false,
            configurable: true
        });
        Object.defineProperty(CommonWrapper.prototype, "fixesPWidth", {
            get: function () {
                return !this.node.notParent && !this.node.isToken;
            },
            enumerable: false,
            configurable: true
        });
        CommonWrapper.prototype.wrap = function (node, parent) {
            if (parent === void 0) {
                parent = null;
            }
            var wrapped = this.factory.wrap(node, parent || this);
            if (parent) {
                parent.childNodes.push(wrapped);
            }
            this.jax.nodeMap.set(node, wrapped);
            return wrapped;
        };
        CommonWrapper.prototype.getBBox = function (save) {
            if (save === void 0) {
                save = true;
            }
            if (this.bboxComputed) {
                return this.bbox;
            }
            var bbox = (save ? this.bbox : BBox_js_1.BBox.zero());
            this.computeBBox(bbox);
            this.bboxComputed = save;
            return bbox;
        };
        CommonWrapper.prototype.getOuterBBox = function (save) {
            var e_1, _a;
            if (save === void 0) {
                save = true;
            }
            var bbox = this.getBBox(save);
            if (!this.styles)
                return bbox;
            var obox = new BBox_js_1.BBox();
            Object.assign(obox, bbox);
            try {
                for (var _b = __values(BBox_js_1.BBox.StyleAdjust), _c = _b.next(); !_c.done; _c = _b.next()) {
                    var _d = __read(_c.value, 2), name_1 = _d[0], side = _d[1];
                    var x = this.styles.get(name_1);
                    if (x) {
                        obox[side] += this.length2em(x, 1, obox.rscale);
                    }
                }
            }
            catch (e_1_1) {
                e_1 = { error: e_1_1 };
            }
            finally {
                try {
                    if (_c && !_c.done && (_a = _b.return))
                        _a.call(_b);
                }
                finally {
                    if (e_1)
                        throw e_1.error;
                }
            }
            return obox;
        };
        CommonWrapper.prototype.computeBBox = function (bbox, recompute) {
            var e_2, _a;
            if (recompute === void 0) {
                recompute = false;
            }
            bbox.empty();
            try {
                for (var _b = __values(this.childNodes), _c = _b.next(); !_c.done; _c = _b.next()) {
                    var child = _c.value;
                    bbox.append(child.getOuterBBox());
                }
            }
            catch (e_2_1) {
                e_2 = { error: e_2_1 };
            }
            finally {
                try {
                    if (_c && !_c.done && (_a = _b.return))
                        _a.call(_b);
                }
                finally {
                    if (e_2)
                        throw e_2.error;
                }
            }
            bbox.clean();
            if (this.fixesPWidth && this.setChildPWidths(recompute)) {
                this.computeBBox(bbox, true);
            }
        };
        CommonWrapper.prototype.setChildPWidths = function (recompute, w, clear) {
            var e_3, _a;
            if (w === void 0) {
                w = null;
            }
            if (clear === void 0) {
                clear = true;
            }
            if (recompute) {
                return false;
            }
            if (clear) {
                this.bbox.pwidth = '';
            }
            var changed = false;
            try {
                for (var _b = __values(this.childNodes), _c = _b.next(); !_c.done; _c = _b.next()) {
                    var child = _c.value;
                    var cbox = child.getOuterBBox();
                    if (cbox.pwidth && child.setChildPWidths(recompute, w === null ? cbox.w : w, clear)) {
                        changed = true;
                    }
                }
            }
            catch (e_3_1) {
                e_3 = { error: e_3_1 };
            }
            finally {
                try {
                    if (_c && !_c.done && (_a = _b.return))
                        _a.call(_b);
                }
                finally {
                    if (e_3)
                        throw e_3.error;
                }
            }
            return changed;
        };
        CommonWrapper.prototype.invalidateBBox = function () {
            if (this.bboxComputed) {
                this.bboxComputed = false;
                if (this.parent) {
                    this.parent.invalidateBBox();
                }
            }
        };
        CommonWrapper.prototype.copySkewIC = function (bbox) {
            var first = this.childNodes[0];
            if (first === null || first === void 0 ? void 0 : first.bbox.sk) {
                bbox.sk = first.bbox.sk;
            }
            if (first === null || first === void 0 ? void 0 : first.bbox.dx) {
                bbox.dx = first.bbox.dx;
            }
            var last = this.childNodes[this.childNodes.length - 1];
            if (last === null || last === void 0 ? void 0 : last.bbox.ic) {
                bbox.ic = last.bbox.ic;
                bbox.w += bbox.ic;
            }
        };
        CommonWrapper.prototype.getStyles = function () {
            var styleString = this.node.attributes.getExplicit('style');
            if (!styleString)
                return;
            var style = this.styles = new Styles_js_1.Styles(styleString);
            for (var i = 0, m = CommonWrapper.removeStyles.length; i < m; i++) {
                var id = CommonWrapper.removeStyles[i];
                if (style.get(id)) {
                    if (!this.removedStyles)
                        this.removedStyles = {};
                    this.removedStyles[id] = style.get(id);
                    style.set(id, '');
                }
            }
        };
        CommonWrapper.prototype.getVariant = function () {
            if (!this.node.isToken)
                return;
            var attributes = this.node.attributes;
            var variant = attributes.get('mathvariant');
            if (!attributes.getExplicit('mathvariant')) {
                var values = attributes.getList('fontfamily', 'fontweight', 'fontstyle');
                if (this.removedStyles) {
                    var style = this.removedStyles;
                    if (style.fontFamily)
                        values.family = style.fontFamily;
                    if (style.fontWeight)
                        values.weight = style.fontWeight;
                    if (style.fontStyle)
                        values.style = style.fontStyle;
                }
                if (values.fontfamily)
                    values.family = values.fontfamily;
                if (values.fontweight)
                    values.weight = values.fontweight;
                if (values.fontstyle)
                    values.style = values.fontstyle;
                if (values.weight && values.weight.match(/^\d+$/)) {
                    values.weight = (parseInt(values.weight) > 600 ? 'bold' : 'normal');
                }
                if (values.family) {
                    variant = this.explicitVariant(values.family, values.weight, values.style);
                }
                else {
                    if (this.node.getProperty('variantForm'))
                        variant = '-tex-variant';
                    variant = (CommonWrapper.BOLDVARIANTS[values.weight] || {})[variant] || variant;
                    variant = (CommonWrapper.ITALICVARIANTS[values.style] || {})[variant] || variant;
                }
            }
            this.variant = variant;
        };
        CommonWrapper.prototype.explicitVariant = function (fontFamily, fontWeight, fontStyle) {
            var style = this.styles;
            if (!style)
                style = this.styles = new Styles_js_1.Styles();
            style.set('fontFamily', fontFamily);
            if (fontWeight)
                style.set('fontWeight', fontWeight);
            if (fontStyle)
                style.set('fontStyle', fontStyle);
            return '-explicitFont';
        };
        CommonWrapper.prototype.getScale = function () {
            var scale = 1, parent = this.parent;
            var pscale = (parent ? parent.bbox.scale : 1);
            var attributes = this.node.attributes;
            var scriptlevel = Math.min(attributes.get('scriptlevel'), 2);
            var fontsize = attributes.get('fontsize');
            var mathsize = (this.node.isToken || this.node.isKind('mstyle') ?
                attributes.get('mathsize') : attributes.getInherited('mathsize'));
            if (scriptlevel !== 0) {
                scale = Math.pow(attributes.get('scriptsizemultiplier'), scriptlevel);
                var scriptminsize = this.length2em(attributes.get('scriptminsize'), .8, 1);
                if (scale < scriptminsize)
                    scale = scriptminsize;
            }
            if (this.removedStyles && this.removedStyles.fontSize && !fontsize) {
                fontsize = this.removedStyles.fontSize;
            }
            if (fontsize && !attributes.getExplicit('mathsize')) {
                mathsize = fontsize;
            }
            if (mathsize !== '1') {
                scale *= this.length2em(mathsize, 1, 1);
            }
            this.bbox.scale = scale;
            this.bbox.rscale = scale / pscale;
        };
        CommonWrapper.prototype.getSpace = function () {
            var isTop = this.isTopEmbellished();
            var hasSpacing = this.node.hasSpacingAttributes();
            if (this.jax.options.mathmlSpacing || hasSpacing) {
                isTop && this.getMathMLSpacing();
            }
            else {
                this.getTeXSpacing(isTop, hasSpacing);
            }
        };
        CommonWrapper.prototype.getMathMLSpacing = function () {
            var node = this.node.coreMO();
            var child = node.coreParent();
            var parent = child.parent;
            if (!parent || !parent.isKind('mrow') || parent.childNodes.length === 1)
                return;
            var attributes = node.attributes;
            var isScript = (attributes.get('scriptlevel') > 0);
            this.bbox.L = (attributes.isSet('lspace') ?
                Math.max(0, this.length2em(attributes.get('lspace'))) :
                MathMLSpace(isScript, node.lspace));
            this.bbox.R = (attributes.isSet('rspace') ?
                Math.max(0, this.length2em(attributes.get('rspace'))) :
                MathMLSpace(isScript, node.rspace));
            var n = parent.childIndex(child);
            if (n === 0)
                return;
            var prev = parent.childNodes[n - 1];
            if (!prev.isEmbellished)
                return;
            var bbox = this.jax.nodeMap.get(prev).getBBox();
            if (bbox.R) {
                this.bbox.L = Math.max(0, this.bbox.L - bbox.R);
            }
        };
        CommonWrapper.prototype.getTeXSpacing = function (isTop, hasSpacing) {
            if (!hasSpacing) {
                var space = this.node.texSpacing();
                if (space) {
                    this.bbox.L = this.length2em(space);
                }
            }
            if (isTop || hasSpacing) {
                var attributes = this.node.coreMO().attributes;
                if (attributes.isSet('lspace')) {
                    this.bbox.L = Math.max(0, this.length2em(attributes.get('lspace')));
                }
                if (attributes.isSet('rspace')) {
                    this.bbox.R = Math.max(0, this.length2em(attributes.get('rspace')));
                }
            }
        };
        CommonWrapper.prototype.isTopEmbellished = function () {
            return (this.node.isEmbellished &&
                !(this.node.parent && this.node.parent.isEmbellished));
        };
        CommonWrapper.prototype.core = function () {
            return this.jax.nodeMap.get(this.node.core());
        };
        CommonWrapper.prototype.coreMO = function () {
            return this.jax.nodeMap.get(this.node.coreMO());
        };
        CommonWrapper.prototype.getText = function () {
            var e_4, _a;
            var text = '';
            if (this.node.isToken) {
                try {
                    for (var _b = __values(this.node.childNodes), _c = _b.next(); !_c.done; _c = _b.next()) {
                        var child = _c.value;
                        if (child instanceof MmlNode_js_1.TextNode) {
                            text += child.getText();
                        }
                    }
                }
                catch (e_4_1) {
                    e_4 = { error: e_4_1 };
                }
                finally {
                    try {
                        if (_c && !_c.done && (_a = _b.return))
                            _a.call(_b);
                    }
                    finally {
                        if (e_4)
                            throw e_4.error;
                    }
                }
            }
            return text;
        };
        CommonWrapper.prototype.canStretch = function (direction) {
            this.stretch = FontData_js_1.NOSTRETCH;
            if (this.node.isEmbellished) {
                var core = this.core();
                if (core && core.node !== this.node) {
                    if (core.canStretch(direction)) {
                        this.stretch = core.stretch;
                    }
                }
            }
            return this.stretch.dir !== 0;
        };
        CommonWrapper.prototype.getAlignShift = function () {
            var _a;
            var _b = (_a = this.node.attributes).getList.apply(_a, __spreadArray([], __read(MmlNode_js_1.indentAttributes), false)), indentalign = _b.indentalign, indentshift = _b.indentshift, indentalignfirst = _b.indentalignfirst, indentshiftfirst = _b.indentshiftfirst;
            if (indentalignfirst !== 'indentalign') {
                indentalign = indentalignfirst;
            }
            if (indentalign === 'auto') {
                indentalign = this.jax.options.displayAlign;
            }
            if (indentshiftfirst !== 'indentshift') {
                indentshift = indentshiftfirst;
            }
            if (indentshift === 'auto') {
                indentshift = this.jax.options.displayIndent;
                if (indentalign === 'right' && !indentshift.match(/^\s*0[a-z]*\s*$/)) {
                    indentshift = ('-' + indentshift.trim()).replace(/^--/, '');
                }
            }
            var shift = this.length2em(indentshift, this.metrics.containerWidth);
            return [indentalign, shift];
        };
        CommonWrapper.prototype.getAlignX = function (W, bbox, align) {
            return (align === 'right' ? W - (bbox.w + bbox.R) * bbox.rscale :
                align === 'left' ? bbox.L * bbox.rscale :
                    (W - bbox.w * bbox.rscale) / 2);
        };
        CommonWrapper.prototype.getAlignY = function (H, D, h, d, align) {
            return (align === 'top' ? H - h :
                align === 'bottom' ? d - D :
                    align === 'center' ? ((H - h) - (D - d)) / 2 :
                        0);
        };
        CommonWrapper.prototype.getWrapWidth = function (i) {
            return this.childNodes[i].getBBox().w;
        };
        CommonWrapper.prototype.getChildAlign = function (_i) {
            return 'left';
        };
        CommonWrapper.prototype.percent = function (m) {
            return LENGTHS.percent(m);
        };
        CommonWrapper.prototype.em = function (m) {
            return LENGTHS.em(m);
        };
        CommonWrapper.prototype.px = function (m, M) {
            if (M === void 0) {
                M = -LENGTHS.BIGDIMEN;
            }
            return LENGTHS.px(m, M, this.metrics.em);
        };
        CommonWrapper.prototype.length2em = function (length, size, scale) {
            if (size === void 0) {
                size = 1;
            }
            if (scale === void 0) {
                scale = null;
            }
            if (scale === null) {
                scale = this.bbox.scale;
            }
            return LENGTHS.length2em(length, size, scale, this.jax.pxPerEm);
        };
        CommonWrapper.prototype.unicodeChars = function (text, name) {
            if (name === void 0) {
                name = this.variant;
            }
            var chars = (0, string_js_1.unicodeChars)(text);
            var variant = this.font.getVariant(name);
            if (variant && variant.chars) {
                var map_1 = variant.chars;
                chars = chars.map(function (n) { return ((map_1[n] || [])[3] || {}).smp || n; });
            }
            return chars;
        };
        CommonWrapper.prototype.remapChars = function (chars) {
            return chars;
        };
        CommonWrapper.prototype.mmlText = function (text) {
            return this.node.factory.create('text').setText(text);
        };
        CommonWrapper.prototype.mmlNode = function (kind, properties, children) {
            if (properties === void 0) {
                properties = {};
            }
            if (children === void 0) {
                children = [];
            }
            return this.node.factory.create(kind, properties, children);
        };
        CommonWrapper.prototype.createMo = function (text) {
            var mmlFactory = this.node.factory;
            var textNode = mmlFactory.create('text').setText(text);
            var mml = mmlFactory.create('mo', { stretchy: true }, [textNode]);
            mml.inheritAttributesFrom(this.node);
            var node = this.wrap(mml);
            node.parent = this;
            return node;
        };
        CommonWrapper.prototype.getVariantChar = function (variant, n) {
            var char = this.font.getChar(variant, n) || [0, 0, 0, { unknown: true }];
            if (char.length === 3) {
                char[3] = {};
            }
            return char;
        };
        CommonWrapper.kind = 'unknown';
        CommonWrapper.styles = {};
        CommonWrapper.removeStyles = [
            'fontSize', 'fontFamily', 'fontWeight',
            'fontStyle', 'fontVariant', 'font'
        ];
        CommonWrapper.skipAttributes = {
            fontfamily: true, fontsize: true, fontweight: true, fontstyle: true,
            color: true, background: true,
            'class': true, href: true, style: true,
            xmlns: true
        };
        CommonWrapper.BOLDVARIANTS = {
            bold: {
                normal: 'bold',
                italic: 'bold-italic',
                fraktur: 'bold-fraktur',
                script: 'bold-script',
                'sans-serif': 'bold-sans-serif',
                'sans-serif-italic': 'sans-serif-bold-italic'
            },
            normal: {
                bold: 'normal',
                'bold-italic': 'italic',
                'bold-fraktur': 'fraktur',
                'bold-script': 'script',
                'bold-sans-serif': 'sans-serif',
                'sans-serif-bold-italic': 'sans-serif-italic'
            }
        };
        CommonWrapper.ITALICVARIANTS = {
            italic: {
                normal: 'italic',
                bold: 'bold-italic',
                'sans-serif': 'sans-serif-italic',
                'bold-sans-serif': 'sans-serif-bold-italic'
            },
            normal: {
                italic: 'normal',
                'bold-italic': 'bold',
                'sans-serif-italic': 'sans-serif',
                'sans-serif-bold-italic': 'bold-sans-serif'
            }
        };
        return CommonWrapper;
    }(Wrapper_js_1.AbstractWrapper));
    exports.CommonWrapper = CommonWrapper;
},
683: /* mathjax-full/js/core/Tree/Wrapper.js */ function _(require, module, exports, __esModule, __esExport) {
    __esModule();
    var AbstractWrapper = (function () {
        function AbstractWrapper(factory, node) {
            this.factory = factory;
            this.node = node;
        }
        Object.defineProperty(AbstractWrapper.prototype, "kind", {
            get: function () {
                return this.node.kind;
            },
            enumerable: false,
            configurable: true
        });
        AbstractWrapper.prototype.wrap = function (node) {
            return this.factory.wrap(node);
        };
        return AbstractWrapper;
    }());
    exports.AbstractWrapper = AbstractWrapper;
},
684: /* mathjax-full/js/output/common/FontData.js */ function _(require, module, exports, __esModule, __esExport) {
    var __assign = (this && this.__assign) || function () {
        __assign = Object.assign || function (t) {
            for (var s, i = 1, n = arguments.length; i < n; i++) {
                s = arguments[i];
                for (var p in s)
                    if (Object.prototype.hasOwnProperty.call(s, p))
                        t[p] = s[p];
            }
            return t;
        };
        return __assign.apply(this, arguments);
    };
    var __read = (this && this.__read) || function (o, n) {
        var m = typeof Symbol === "function" && o[Symbol.iterator];
        if (!m)
            return o;
        var i = m.call(o), r, ar = [], e;
        try {
            while ((n === void 0 || n-- > 0) && !(r = i.next()).done)
                ar.push(r.value);
        }
        catch (error) {
            e = { error: error };
        }
        finally {
            try {
                if (r && !r.done && (m = i["return"]))
                    m.call(i);
            }
            finally {
                if (e)
                    throw e.error;
            }
        }
        return ar;
    };
    var __spreadArray = (this && this.__spreadArray) || function (to, from, pack) {
        if (pack || arguments.length === 2)
            for (var i = 0, l = from.length, ar; i < l; i++) {
                if (ar || !(i in from)) {
                    if (!ar)
                        ar = Array.prototype.slice.call(from, 0, i);
                    ar[i] = from[i];
                }
            }
        return to.concat(ar || Array.prototype.slice.call(from));
    };
    var __values = (this && this.__values) || function (o) {
        var s = typeof Symbol === "function" && Symbol.iterator, m = s && o[s], i = 0;
        if (m)
            return m.call(o);
        if (o && typeof o.length === "number")
            return {
                next: function () {
                    if (o && i >= o.length)
                        o = void 0;
                    return { value: o && o[i++], done: !o };
                }
            };
        throw new TypeError(s ? "Object is not iterable." : "Symbol.iterator is not defined.");
    };
    __esModule();
    var Options_js_1 = require(632) /* ../../util/Options.js */;
    exports.V = 1;
    exports.H = 2;
    exports.NOSTRETCH = { dir: 0 };
    var FontData = (function () {
        function FontData(options) {
            var e_1, _a, e_2, _b;
            if (options === void 0) {
                options = null;
            }
            this.variant = {};
            this.delimiters = {};
            this.cssFontMap = {};
            this.remapChars = {};
            this.skewIcFactor = .75;
            var CLASS = this.constructor;
            this.options = (0, Options_js_1.userOptions)((0, Options_js_1.defaultOptions)({}, CLASS.OPTIONS), options);
            this.params = __assign({}, CLASS.defaultParams);
            this.sizeVariants = __spreadArray([], __read(CLASS.defaultSizeVariants), false);
            this.stretchVariants = __spreadArray([], __read(CLASS.defaultStretchVariants), false);
            this.cssFontMap = __assign({}, CLASS.defaultCssFonts);
            try {
                for (var _c = __values(Object.keys(this.cssFontMap)), _d = _c.next(); !_d.done; _d = _c.next()) {
                    var name_1 = _d.value;
                    if (this.cssFontMap[name_1][0] === 'unknown') {
                        this.cssFontMap[name_1][0] = this.options.unknownFamily;
                    }
                }
            }
            catch (e_1_1) {
                e_1 = { error: e_1_1 };
            }
            finally {
                try {
                    if (_d && !_d.done && (_a = _c.return))
                        _a.call(_c);
                }
                finally {
                    if (e_1)
                        throw e_1.error;
                }
            }
            this.cssFamilyPrefix = CLASS.defaultCssFamilyPrefix;
            this.createVariants(CLASS.defaultVariants);
            this.defineDelimiters(CLASS.defaultDelimiters);
            try {
                for (var _e = __values(Object.keys(CLASS.defaultChars)), _f = _e.next(); !_f.done; _f = _e.next()) {
                    var name_2 = _f.value;
                    this.defineChars(name_2, CLASS.defaultChars[name_2]);
                }
            }
            catch (e_2_1) {
                e_2 = { error: e_2_1 };
            }
            finally {
                try {
                    if (_f && !_f.done && (_b = _e.return))
                        _b.call(_e);
                }
                finally {
                    if (e_2)
                        throw e_2.error;
                }
            }
            this.defineRemap('accent', CLASS.defaultAccentMap);
            this.defineRemap('mo', CLASS.defaultMoMap);
            this.defineRemap('mn', CLASS.defaultMnMap);
        }
        FontData.charOptions = function (font, n) {
            var char = font[n];
            if (char.length === 3) {
                char[3] = {};
            }
            return char[3];
        };
        Object.defineProperty(FontData.prototype, "styles", {
            get: function () {
                return this._styles;
            },
            set: function (style) {
                this._styles = style;
            },
            enumerable: false,
            configurable: true
        });
        FontData.prototype.createVariant = function (name, inherit, link) {
            if (inherit === void 0) {
                inherit = null;
            }
            if (link === void 0) {
                link = null;
            }
            var variant = {
                linked: [],
                chars: (inherit ? Object.create(this.variant[inherit].chars) : {})
            };
            if (link && this.variant[link]) {
                Object.assign(variant.chars, this.variant[link].chars);
                this.variant[link].linked.push(variant.chars);
                variant.chars = Object.create(variant.chars);
            }
            this.remapSmpChars(variant.chars, name);
            this.variant[name] = variant;
        };
        FontData.prototype.remapSmpChars = function (chars, name) {
            var e_3, _a, e_4, _b;
            var CLASS = this.constructor;
            if (CLASS.VariantSmp[name]) {
                var SmpRemap = CLASS.SmpRemap;
                var SmpGreek = [null, null, CLASS.SmpRemapGreekU, CLASS.SmpRemapGreekL];
                try {
                    for (var _c = __values(CLASS.SmpRanges), _d = _c.next(); !_d.done; _d = _c.next()) {
                        var _e = __read(_d.value, 3), i = _e[0], lo = _e[1], hi = _e[2];
                        var base = CLASS.VariantSmp[name][i];
                        if (!base)
                            continue;
                        for (var n = lo; n <= hi; n++) {
                            if (n === 0x3A2)
                                continue;
                            var smp = base + n - lo;
                            chars[n] = this.smpChar(SmpRemap[smp] || smp);
                        }
                        if (SmpGreek[i]) {
                            try {
                                for (var _f = (e_4 = void 0, __values(Object.keys(SmpGreek[i]).map(function (x) { return parseInt(x); }))), _g = _f.next(); !_g.done; _g = _f.next()) {
                                    var n = _g.value;
                                    chars[n] = this.smpChar(base + SmpGreek[i][n]);
                                }
                            }
                            catch (e_4_1) {
                                e_4 = { error: e_4_1 };
                            }
                            finally {
                                try {
                                    if (_g && !_g.done && (_b = _f.return))
                                        _b.call(_f);
                                }
                                finally {
                                    if (e_4)
                                        throw e_4.error;
                                }
                            }
                        }
                    }
                }
                catch (e_3_1) {
                    e_3 = { error: e_3_1 };
                }
                finally {
                    try {
                        if (_d && !_d.done && (_a = _c.return))
                            _a.call(_c);
                    }
                    finally {
                        if (e_3)
                            throw e_3.error;
                    }
                }
            }
            if (name === 'bold') {
                chars[0x3DC] = this.smpChar(0x1D7CA);
                chars[0x3DD] = this.smpChar(0x1D7CB);
            }
        };
        FontData.prototype.smpChar = function (n) {
            return [, , , { smp: n }];
        };
        FontData.prototype.createVariants = function (variants) {
            var e_5, _a;
            try {
                for (var variants_1 = __values(variants), variants_1_1 = variants_1.next(); !variants_1_1.done; variants_1_1 = variants_1.next()) {
                    var variant = variants_1_1.value;
                    this.createVariant(variant[0], variant[1], variant[2]);
                }
            }
            catch (e_5_1) {
                e_5 = { error: e_5_1 };
            }
            finally {
                try {
                    if (variants_1_1 && !variants_1_1.done && (_a = variants_1.return))
                        _a.call(variants_1);
                }
                finally {
                    if (e_5)
                        throw e_5.error;
                }
            }
        };
        FontData.prototype.defineChars = function (name, chars) {
            var e_6, _a;
            var variant = this.variant[name];
            Object.assign(variant.chars, chars);
            try {
                for (var _b = __values(variant.linked), _c = _b.next(); !_c.done; _c = _b.next()) {
                    var link = _c.value;
                    Object.assign(link, chars);
                }
            }
            catch (e_6_1) {
                e_6 = { error: e_6_1 };
            }
            finally {
                try {
                    if (_c && !_c.done && (_a = _b.return))
                        _a.call(_b);
                }
                finally {
                    if (e_6)
                        throw e_6.error;
                }
            }
        };
        FontData.prototype.defineDelimiters = function (delims) {
            Object.assign(this.delimiters, delims);
        };
        FontData.prototype.defineRemap = function (name, remap) {
            if (!this.remapChars.hasOwnProperty(name)) {
                this.remapChars[name] = {};
            }
            Object.assign(this.remapChars[name], remap);
        };
        FontData.prototype.getDelimiter = function (n) {
            return this.delimiters[n];
        };
        FontData.prototype.getSizeVariant = function (n, i) {
            if (this.delimiters[n].variants) {
                i = this.delimiters[n].variants[i];
            }
            return this.sizeVariants[i];
        };
        FontData.prototype.getStretchVariant = function (n, i) {
            return this.stretchVariants[this.delimiters[n].stretchv ? this.delimiters[n].stretchv[i] : 0];
        };
        FontData.prototype.getChar = function (name, n) {
            return this.variant[name].chars[n];
        };
        FontData.prototype.getVariant = function (name) {
            return this.variant[name];
        };
        FontData.prototype.getCssFont = function (variant) {
            return this.cssFontMap[variant] || ['serif', false, false];
        };
        FontData.prototype.getFamily = function (family) {
            return (this.cssFamilyPrefix ? this.cssFamilyPrefix + ', ' + family : family);
        };
        FontData.prototype.getRemappedChar = function (name, c) {
            var map = this.remapChars[name] || {};
            return map[c];
        };
        FontData.OPTIONS = {
            unknownFamily: 'serif'
        };
        FontData.JAX = 'common';
        FontData.NAME = '';
        FontData.defaultVariants = [
            ['normal'],
            ['bold', 'normal'],
            ['italic', 'normal'],
            ['bold-italic', 'italic', 'bold'],
            ['double-struck', 'bold'],
            ['fraktur', 'normal'],
            ['bold-fraktur', 'bold', 'fraktur'],
            ['script', 'italic'],
            ['bold-script', 'bold-italic', 'script'],
            ['sans-serif', 'normal'],
            ['bold-sans-serif', 'bold', 'sans-serif'],
            ['sans-serif-italic', 'italic', 'sans-serif'],
            ['sans-serif-bold-italic', 'bold-italic', 'bold-sans-serif'],
            ['monospace', 'normal']
        ];
        FontData.defaultCssFonts = {
            normal: ['unknown', false, false],
            bold: ['unknown', false, true],
            italic: ['unknown', true, false],
            'bold-italic': ['unknown', true, true],
            'double-struck': ['unknown', false, true],
            fraktur: ['unknown', false, false],
            'bold-fraktur': ['unknown', false, true],
            script: ['cursive', false, false],
            'bold-script': ['cursive', false, true],
            'sans-serif': ['sans-serif', false, false],
            'bold-sans-serif': ['sans-serif', false, true],
            'sans-serif-italic': ['sans-serif', true, false],
            'sans-serif-bold-italic': ['sans-serif', true, true],
            monospace: ['monospace', false, false]
        };
        FontData.defaultCssFamilyPrefix = '';
        FontData.VariantSmp = {
            bold: [0x1D400, 0x1D41A, 0x1D6A8, 0x1D6C2, 0x1D7CE],
            italic: [0x1D434, 0x1D44E, 0x1D6E2, 0x1D6FC],
            'bold-italic': [0x1D468, 0x1D482, 0x1D71C, 0x1D736],
            script: [0x1D49C, 0x1D4B6],
            'bold-script': [0x1D4D0, 0x1D4EA],
            fraktur: [0x1D504, 0x1D51E],
            'double-struck': [0x1D538, 0x1D552, , , 0x1D7D8],
            'bold-fraktur': [0x1D56C, 0x1D586],
            'sans-serif': [0x1D5A0, 0x1D5BA, , , 0x1D7E2],
            'bold-sans-serif': [0x1D5D4, 0x1D5EE, 0x1D756, 0x1D770, 0x1D7EC],
            'sans-serif-italic': [0x1D608, 0x1D622],
            'sans-serif-bold-italic': [0x1D63C, 0x1D656, 0x1D790, 0x1D7AA],
            'monospace': [0x1D670, 0x1D68A, , , 0x1D7F6]
        };
        FontData.SmpRanges = [
            [0, 0x41, 0x5A],
            [1, 0x61, 0x7A],
            [2, 0x391, 0x3A9],
            [3, 0x3B1, 0x3C9],
            [4, 0x30, 0x39]
        ];
        FontData.SmpRemap = {
            0x1D455: 0x210E,
            0x1D49D: 0x212C,
            0x1D4A0: 0x2130,
            0x1D4A1: 0x2131,
            0x1D4A3: 0x210B,
            0x1D4A4: 0x2110,
            0x1D4A7: 0x2112,
            0x1D4A8: 0x2133,
            0x1D4AD: 0x211B,
            0x1D4BA: 0x212F,
            0x1D4BC: 0x210A,
            0x1D4C4: 0x2134,
            0x1D506: 0x212D,
            0x1D50B: 0x210C,
            0x1D50C: 0x2111,
            0x1D515: 0x211C,
            0x1D51D: 0x2128,
            0x1D53A: 0x2102,
            0x1D53F: 0x210D,
            0x1D545: 0x2115,
            0x1D547: 0x2119,
            0x1D548: 0x211A,
            0x1D549: 0x211D,
            0x1D551: 0x2124,
        };
        FontData.SmpRemapGreekU = {
            0x2207: 0x19,
            0x03F4: 0x11
        };
        FontData.SmpRemapGreekL = {
            0x3D1: 0x1B,
            0x3D5: 0x1D,
            0x3D6: 0x1F,
            0x3F0: 0x1C,
            0x3F1: 0x1E,
            0x3F5: 0x1A,
            0x2202: 0x19
        };
        FontData.defaultAccentMap = {
            0x0300: '\u02CB',
            0x0301: '\u02CA',
            0x0302: '\u02C6',
            0x0303: '\u02DC',
            0x0304: '\u02C9',
            0x0306: '\u02D8',
            0x0307: '\u02D9',
            0x0308: '\u00A8',
            0x030A: '\u02DA',
            0x030C: '\u02C7',
            0x2192: '\u20D7',
            0x2032: '\'',
            0x2033: '\'\'',
            0x2034: '\'\'\'',
            0x2035: '`',
            0x2036: '``',
            0x2037: '```',
            0x2057: '\'\'\'\'',
            0x20D0: '\u21BC',
            0x20D1: '\u21C0',
            0x20D6: '\u2190',
            0x20E1: '\u2194',
            0x20F0: '*',
            0x20DB: '...',
            0x20DC: '....',
            0x20EC: '\u21C1',
            0x20ED: '\u21BD',
            0x20EE: '\u2190',
            0x20EF: '\u2192'
        };
        FontData.defaultMoMap = {
            0x002D: '\u2212'
        };
        FontData.defaultMnMap = {
            0x002D: '\u2212'
        };
        FontData.defaultParams = {
            x_height: .442,
            quad: 1,
            num1: .676,
            num2: .394,
            num3: .444,
            denom1: .686,
            denom2: .345,
            sup1: .413,
            sup2: .363,
            sup3: .289,
            sub1: .15,
            sub2: .247,
            sup_drop: .386,
            sub_drop: .05,
            delim1: 2.39,
            delim2: 1.0,
            axis_height: .25,
            rule_thickness: .06,
            big_op_spacing1: .111,
            big_op_spacing2: .167,
            big_op_spacing3: .2,
            big_op_spacing4: .6,
            big_op_spacing5: .1,
            surd_height: .075,
            scriptspace: .05,
            nulldelimiterspace: .12,
            delimiterfactor: 901,
            delimitershortfall: .3,
            min_rule_thickness: 1.25,
            separation_factor: 1.75,
            extra_ic: .033
        };
        FontData.defaultDelimiters = {};
        FontData.defaultChars = {};
        FontData.defaultSizeVariants = [];
        FontData.defaultStretchVariants = [];
        return FontData;
    }());
    exports.FontData = FontData;
},
685: /* mathjax-full/js/output/svg/Wrappers/math.js */ function _(require, module, exports, __esModule, __esExport) {
    var __extends = (this && this.__extends) || (function () {
        var extendStatics = function (d, b) {
            extendStatics = Object.setPrototypeOf ||
                ({ __proto__: [] } instanceof Array && function (d, b) { d.__proto__ = b; }) ||
                function (d, b) { for (var p in b)
                    if (Object.prototype.hasOwnProperty.call(b, p))
                        d[p] = b[p]; };
            return extendStatics(d, b);
        };
        return function (d, b) {
            if (typeof b !== "function" && b !== null)
                throw new TypeError("Class extends value " + String(b) + " is not a constructor or null");
            extendStatics(d, b);
            function __() { this.constructor = d; }
            d.prototype = b === null ? Object.create(b) : (__.prototype = b.prototype, new __());
        };
    })();
    var __read = (this && this.__read) || function (o, n) {
        var m = typeof Symbol === "function" && o[Symbol.iterator];
        if (!m)
            return o;
        var i = m.call(o), r, ar = [], e;
        try {
            while ((n === void 0 || n-- > 0) && !(r = i.next()).done)
                ar.push(r.value);
        }
        catch (error) {
            e = { error: error };
        }
        finally {
            try {
                if (r && !r.done && (m = i["return"]))
                    m.call(i);
            }
            finally {
                if (e)
                    throw e.error;
            }
        }
        return ar;
    };
    var __values = (this && this.__values) || function (o) {
        var s = typeof Symbol === "function" && Symbol.iterator, m = s && o[s], i = 0;
        if (m)
            return m.call(o);
        if (o && typeof o.length === "number")
            return {
                next: function () {
                    if (o && i >= o.length)
                        o = void 0;
                    return { value: o && o[i++], done: !o };
                }
            };
        throw new TypeError(s ? "Object is not iterable." : "Symbol.iterator is not defined.");
    };
    __esModule();
    var Wrapper_js_1 = require(680) /* ../Wrapper.js */;
    var math_js_1 = require(686) /* ../../common/Wrappers/math.js */;
    var math_js_2 = require(687) /* ../../../core/MmlTree/MmlNodes/math.js */;
    var BBox_js_1 = require(681) /* ../../../util/BBox.js */;
    var SVGmath = (function (_super) {
        __extends(SVGmath, _super);
        function SVGmath() {
            return _super !== null && _super.apply(this, arguments) || this;
        }
        SVGmath.prototype.toSVG = function (parent) {
            _super.prototype.toSVG.call(this, parent);
            var adaptor = this.adaptor;
            var display = (this.node.attributes.get('display') === 'block');
            if (display) {
                adaptor.setAttribute(this.jax.container, 'display', 'true');
                this.handleDisplay();
            }
            if (this.jax.document.options.internalSpeechTitles) {
                this.handleSpeech();
            }
        };
        SVGmath.prototype.handleDisplay = function () {
            var _a = __read(this.getAlignShift(), 2), align = _a[0], shift = _a[1];
            if (align !== 'center') {
                this.adaptor.setAttribute(this.jax.container, 'justify', align);
            }
            if (this.bbox.pwidth === BBox_js_1.BBox.fullWidth) {
                this.adaptor.setAttribute(this.jax.container, 'width', 'full');
                if (this.jax.table) {
                    var _b = this.jax.table.getOuterBBox(), L = _b.L, w = _b.w, R = _b.R;
                    if (align === 'right') {
                        R = Math.max(R || -shift, -shift);
                    }
                    else if (align === 'left') {
                        L = Math.max(L || shift, shift);
                    }
                    else if (align === 'center') {
                        w += 2 * Math.abs(shift);
                    }
                    this.jax.minwidth = Math.max(0, L + w + R);
                }
            }
            else {
                this.jax.shift = shift;
            }
        };
        SVGmath.prototype.handleSpeech = function () {
            var e_1, _a;
            var adaptor = this.adaptor;
            var attributes = this.node.attributes;
            var speech = (attributes.get('aria-label') || attributes.get('data-semantic-speech'));
            if (speech) {
                var id = this.getTitleID();
                var label = this.svg('title', { id: id }, [this.text(speech)]);
                adaptor.insert(label, adaptor.firstChild(this.element));
                adaptor.setAttribute(this.element, 'aria-labeledby', id);
                adaptor.removeAttribute(this.element, 'aria-label');
                try {
                    for (var _b = __values(this.childNodes[0].childNodes), _c = _b.next(); !_c.done; _c = _b.next()) {
                        var child = _c.value;
                        adaptor.setAttribute(child.element, 'aria-hidden', 'true');
                    }
                }
                catch (e_1_1) {
                    e_1 = { error: e_1_1 };
                }
                finally {
                    try {
                        if (_c && !_c.done && (_a = _b.return))
                            _a.call(_b);
                    }
                    finally {
                        if (e_1)
                            throw e_1.error;
                    }
                }
            }
        };
        SVGmath.prototype.getTitleID = function () {
            return 'mjx-svg-title-' + String(this.jax.options.titleID++);
        };
        SVGmath.prototype.setChildPWidths = function (recompute, w, _clear) {
            if (w === void 0) {
                w = null;
            }
            if (_clear === void 0) {
                _clear = true;
            }
            return _super.prototype.setChildPWidths.call(this, recompute, this.parent ? w : this.metrics.containerWidth / this.jax.pxPerEm, false);
        };
        SVGmath.kind = math_js_2.MmlMath.prototype.kind;
        SVGmath.styles = {
            'mjx-container[jax="SVG"][display="true"]': {
                display: 'block',
                'text-align': 'center',
                margin: '1em 0'
            },
            'mjx-container[jax="SVG"][display="true"][width="full"]': {
                display: 'flex'
            },
            'mjx-container[jax="SVG"][justify="left"]': {
                'text-align': 'left'
            },
            'mjx-container[jax="SVG"][justify="right"]': {
                'text-align': 'right'
            }
        };
        return SVGmath;
    }((0, math_js_1.CommonMathMixin)(Wrapper_js_1.SVGWrapper)));
    exports.SVGmath = SVGmath;
},
686: /* mathjax-full/js/output/common/Wrappers/math.js */ function _(require, module, exports, __esModule, __esExport) {
    var __extends = (this && this.__extends) || (function () {
        var extendStatics = function (d, b) {
            extendStatics = Object.setPrototypeOf ||
                ({ __proto__: [] } instanceof Array && function (d, b) { d.__proto__ = b; }) ||
                function (d, b) { for (var p in b)
                    if (Object.prototype.hasOwnProperty.call(b, p))
                        d[p] = b[p]; };
            return extendStatics(d, b);
        };
        return function (d, b) {
            if (typeof b !== "function" && b !== null)
                throw new TypeError("Class extends value " + String(b) + " is not a constructor or null");
            extendStatics(d, b);
            function __() { this.constructor = d; }
            d.prototype = b === null ? Object.create(b) : (__.prototype = b.prototype, new __());
        };
    })();
    __esModule();
    function CommonMathMixin(Base) {
        return (function (_super) {
            __extends(class_1, _super);
            function class_1() {
                return _super !== null && _super.apply(this, arguments) || this;
            }
            class_1.prototype.getWrapWidth = function (_i) {
                return (this.parent ? this.getBBox().w : this.metrics.containerWidth / this.jax.pxPerEm);
            };
            return class_1;
        }(Base));
    }
    exports.CommonMathMixin = CommonMathMixin;
},
687: /* mathjax-full/js/core/MmlTree/MmlNodes/math.js */ function _(require, module, exports, __esModule, __esExport) {
    var __extends = (this && this.__extends) || (function () {
        var extendStatics = function (d, b) {
            extendStatics = Object.setPrototypeOf ||
                ({ __proto__: [] } instanceof Array && function (d, b) { d.__proto__ = b; }) ||
                function (d, b) { for (var p in b)
                    if (Object.prototype.hasOwnProperty.call(b, p))
                        d[p] = b[p]; };
            return extendStatics(d, b);
        };
        return function (d, b) {
            if (typeof b !== "function" && b !== null)
                throw new TypeError("Class extends value " + String(b) + " is not a constructor or null");
            extendStatics(d, b);
            function __() { this.constructor = d; }
            d.prototype = b === null ? Object.create(b) : (__.prototype = b.prototype, new __());
        };
    })();
    var __assign = (this && this.__assign) || function () {
        __assign = Object.assign || function (t) {
            for (var s, i = 1, n = arguments.length; i < n; i++) {
                s = arguments[i];
                for (var p in s)
                    if (Object.prototype.hasOwnProperty.call(s, p))
                        t[p] = s[p];
            }
            return t;
        };
        return __assign.apply(this, arguments);
    };
    __esModule();
    var MmlNode_js_1 = require(639) /* ../MmlNode.js */;
    var MmlMath = (function (_super) {
        __extends(MmlMath, _super);
        function MmlMath() {
            return _super !== null && _super.apply(this, arguments) || this;
        }
        Object.defineProperty(MmlMath.prototype, "kind", {
            get: function () {
                return 'math';
            },
            enumerable: false,
            configurable: true
        });
        Object.defineProperty(MmlMath.prototype, "linebreakContainer", {
            get: function () {
                return true;
            },
            enumerable: false,
            configurable: true
        });
        MmlMath.prototype.setChildInheritedAttributes = function (attributes, display, level, prime) {
            if (this.attributes.get('mode') === 'display') {
                this.attributes.setInherited('display', 'block');
            }
            attributes = this.addInheritedAttributes(attributes, this.attributes.getAllAttributes());
            display = (!!this.attributes.get('displaystyle') ||
                (!this.attributes.get('displaystyle') && this.attributes.get('display') === 'block'));
            this.attributes.setInherited('displaystyle', display);
            level = (this.attributes.get('scriptlevel') ||
                this.constructor.defaults['scriptlevel']);
            _super.prototype.setChildInheritedAttributes.call(this, attributes, display, level, prime);
        };
        MmlMath.defaults = __assign(__assign({}, MmlNode_js_1.AbstractMmlLayoutNode.defaults), { mathvariant: 'normal', mathsize: 'normal', mathcolor: '', mathbackground: 'transparent', dir: 'ltr', scriptlevel: 0, displaystyle: false, display: 'inline', maxwidth: '', overflow: 'linebreak', altimg: '', 'altimg-width': '', 'altimg-height': '', 'altimg-valign': '', alttext: '', cdgroup: '', scriptsizemultiplier: 1 / Math.sqrt(2), scriptminsize: '8px', infixlinebreakstyle: 'before', lineleading: '1ex', linebreakmultchar: '\u2062', indentshift: 'auto', indentalign: 'auto', indenttarget: '', indentalignfirst: 'indentalign', indentshiftfirst: 'indentshift', indentalignlast: 'indentalign', indentshiftlast: 'indentshift' });
        return MmlMath;
    }(MmlNode_js_1.AbstractMmlLayoutNode));
    exports.MmlMath = MmlMath;
},
688: /* mathjax-full/js/output/svg/Wrappers/mrow.js */ function _(require, module, exports, __esModule, __esExport) {
    var __extends = (this && this.__extends) || (function () {
        var extendStatics = function (d, b) {
            extendStatics = Object.setPrototypeOf ||
                ({ __proto__: [] } instanceof Array && function (d, b) { d.__proto__ = b; }) ||
                function (d, b) { for (var p in b)
                    if (Object.prototype.hasOwnProperty.call(b, p))
                        d[p] = b[p]; };
            return extendStatics(d, b);
        };
        return function (d, b) {
            if (typeof b !== "function" && b !== null)
                throw new TypeError("Class extends value " + String(b) + " is not a constructor or null");
            extendStatics(d, b);
            function __() { this.constructor = d; }
            d.prototype = b === null ? Object.create(b) : (__.prototype = b.prototype, new __());
        };
    })();
    __esModule();
    var Wrapper_js_1 = require(680) /* ../Wrapper.js */;
    var mrow_js_1 = require(689) /* ../../common/Wrappers/mrow.js */;
    var mrow_js_2 = require(689) /* ../../common/Wrappers/mrow.js */;
    var mrow_js_3 = require(690) /* ../../../core/MmlTree/MmlNodes/mrow.js */;
    var SVGmrow = (function (_super) {
        __extends(SVGmrow, _super);
        function SVGmrow() {
            return _super !== null && _super.apply(this, arguments) || this;
        }
        SVGmrow.prototype.toSVG = function (parent) {
            var svg = (this.node.isInferred ? (this.element = parent) : this.standardSVGnode(parent));
            this.addChildren(svg);
        };
        SVGmrow.kind = mrow_js_3.MmlMrow.prototype.kind;
        return SVGmrow;
    }((0, mrow_js_1.CommonMrowMixin)(Wrapper_js_1.SVGWrapper)));
    exports.SVGmrow = SVGmrow;
    var SVGinferredMrow = (function (_super) {
        __extends(SVGinferredMrow, _super);
        function SVGinferredMrow() {
            return _super !== null && _super.apply(this, arguments) || this;
        }
        SVGinferredMrow.kind = mrow_js_3.MmlInferredMrow.prototype.kind;
        return SVGinferredMrow;
    }((0, mrow_js_2.CommonInferredMrowMixin)(SVGmrow)));
    exports.SVGinferredMrow = SVGinferredMrow;
},
689: /* mathjax-full/js/output/common/Wrappers/mrow.js */ function _(require, module, exports, __esModule, __esExport) {
    var __extends = (this && this.__extends) || (function () {
        var extendStatics = function (d, b) {
            extendStatics = Object.setPrototypeOf ||
                ({ __proto__: [] } instanceof Array && function (d, b) { d.__proto__ = b; }) ||
                function (d, b) { for (var p in b)
                    if (Object.prototype.hasOwnProperty.call(b, p))
                        d[p] = b[p]; };
            return extendStatics(d, b);
        };
        return function (d, b) {
            if (typeof b !== "function" && b !== null)
                throw new TypeError("Class extends value " + String(b) + " is not a constructor or null");
            extendStatics(d, b);
            function __() { this.constructor = d; }
            d.prototype = b === null ? Object.create(b) : (__.prototype = b.prototype, new __());
        };
    })();
    var __read = (this && this.__read) || function (o, n) {
        var m = typeof Symbol === "function" && o[Symbol.iterator];
        if (!m)
            return o;
        var i = m.call(o), r, ar = [], e;
        try {
            while ((n === void 0 || n-- > 0) && !(r = i.next()).done)
                ar.push(r.value);
        }
        catch (error) {
            e = { error: error };
        }
        finally {
            try {
                if (r && !r.done && (m = i["return"]))
                    m.call(i);
            }
            finally {
                if (e)
                    throw e.error;
            }
        }
        return ar;
    };
    var __spreadArray = (this && this.__spreadArray) || function (to, from, pack) {
        if (pack || arguments.length === 2)
            for (var i = 0, l = from.length, ar; i < l; i++) {
                if (ar || !(i in from)) {
                    if (!ar)
                        ar = Array.prototype.slice.call(from, 0, i);
                    ar[i] = from[i];
                }
            }
        return to.concat(ar || Array.prototype.slice.call(from));
    };
    var __values = (this && this.__values) || function (o) {
        var s = typeof Symbol === "function" && Symbol.iterator, m = s && o[s], i = 0;
        if (m)
            return m.call(o);
        if (o && typeof o.length === "number")
            return {
                next: function () {
                    if (o && i >= o.length)
                        o = void 0;
                    return { value: o && o[i++], done: !o };
                }
            };
        throw new TypeError(s ? "Object is not iterable." : "Symbol.iterator is not defined.");
    };
    __esModule();
    var BBox_js_1 = require(681) /* ../../../util/BBox.js */;
    function CommonMrowMixin(Base) {
        return (function (_super) {
            __extends(class_1, _super);
            function class_1() {
                var e_1, _a;
                var args = [];
                for (var _i = 0; _i < arguments.length; _i++) {
                    args[_i] = arguments[_i];
                }
                var _this = _super.apply(this, __spreadArray([], __read(args), false)) || this;
                _this.stretchChildren();
                try {
                    for (var _b = __values(_this.childNodes), _c = _b.next(); !_c.done; _c = _b.next()) {
                        var child = _c.value;
                        if (child.bbox.pwidth) {
                            _this.bbox.pwidth = BBox_js_1.BBox.fullWidth;
                            break;
                        }
                    }
                }
                catch (e_1_1) {
                    e_1 = { error: e_1_1 };
                }
                finally {
                    try {
                        if (_c && !_c.done && (_a = _b.return))
                            _a.call(_b);
                    }
                    finally {
                        if (e_1)
                            throw e_1.error;
                    }
                }
                return _this;
            }
            Object.defineProperty(class_1.prototype, "fixesPWidth", {
                get: function () {
                    return false;
                },
                enumerable: false,
                configurable: true
            });
            class_1.prototype.stretchChildren = function () {
                var e_2, _a, e_3, _b, e_4, _c;
                var stretchy = [];
                try {
                    for (var _d = __values(this.childNodes), _e = _d.next(); !_e.done; _e = _d.next()) {
                        var child = _e.value;
                        if (child.canStretch(1)) {
                            stretchy.push(child);
                        }
                    }
                }
                catch (e_2_1) {
                    e_2 = { error: e_2_1 };
                }
                finally {
                    try {
                        if (_e && !_e.done && (_a = _d.return))
                            _a.call(_d);
                    }
                    finally {
                        if (e_2)
                            throw e_2.error;
                    }
                }
                var count = stretchy.length;
                var nodeCount = this.childNodes.length;
                if (count && nodeCount > 1) {
                    var H = 0, D = 0;
                    var all = (count > 1 && count === nodeCount);
                    try {
                        for (var _f = __values(this.childNodes), _g = _f.next(); !_g.done; _g = _f.next()) {
                            var child = _g.value;
                            var noStretch = (child.stretch.dir === 0);
                            if (all || noStretch) {
                                var _h = child.getOuterBBox(noStretch), h = _h.h, d = _h.d, rscale = _h.rscale;
                                h *= rscale;
                                d *= rscale;
                                if (h > H)
                                    H = h;
                                if (d > D)
                                    D = d;
                            }
                        }
                    }
                    catch (e_3_1) {
                        e_3 = { error: e_3_1 };
                    }
                    finally {
                        try {
                            if (_g && !_g.done && (_b = _f.return))
                                _b.call(_f);
                        }
                        finally {
                            if (e_3)
                                throw e_3.error;
                        }
                    }
                    try {
                        for (var stretchy_1 = __values(stretchy), stretchy_1_1 = stretchy_1.next(); !stretchy_1_1.done; stretchy_1_1 = stretchy_1.next()) {
                            var child = stretchy_1_1.value;
                            child.coreMO().getStretchedVariant([H, D]);
                        }
                    }
                    catch (e_4_1) {
                        e_4 = { error: e_4_1 };
                    }
                    finally {
                        try {
                            if (stretchy_1_1 && !stretchy_1_1.done && (_c = stretchy_1.return))
                                _c.call(stretchy_1);
                        }
                        finally {
                            if (e_4)
                                throw e_4.error;
                        }
                    }
                }
            };
            return class_1;
        }(Base));
    }
    exports.CommonMrowMixin = CommonMrowMixin;
    function CommonInferredMrowMixin(Base) {
        return (function (_super) {
            __extends(class_2, _super);
            function class_2() {
                return _super !== null && _super.apply(this, arguments) || this;
            }
            class_2.prototype.getScale = function () {
                this.bbox.scale = this.parent.bbox.scale;
                this.bbox.rscale = 1;
            };
            return class_2;
        }(Base));
    }
    exports.CommonInferredMrowMixin = CommonInferredMrowMixin;
},
690: /* mathjax-full/js/core/MmlTree/MmlNodes/mrow.js */ function _(require, module, exports, __esModule, __esExport) {
    var __extends = (this && this.__extends) || (function () {
        var extendStatics = function (d, b) {
            extendStatics = Object.setPrototypeOf ||
                ({ __proto__: [] } instanceof Array && function (d, b) { d.__proto__ = b; }) ||
                function (d, b) { for (var p in b)
                    if (Object.prototype.hasOwnProperty.call(b, p))
                        d[p] = b[p]; };
            return extendStatics(d, b);
        };
        return function (d, b) {
            if (typeof b !== "function" && b !== null)
                throw new TypeError("Class extends value " + String(b) + " is not a constructor or null");
            extendStatics(d, b);
            function __() { this.constructor = d; }
            d.prototype = b === null ? Object.create(b) : (__.prototype = b.prototype, new __());
        };
    })();
    var __assign = (this && this.__assign) || function () {
        __assign = Object.assign || function (t) {
            for (var s, i = 1, n = arguments.length; i < n; i++) {
                s = arguments[i];
                for (var p in s)
                    if (Object.prototype.hasOwnProperty.call(s, p))
                        t[p] = s[p];
            }
            return t;
        };
        return __assign.apply(this, arguments);
    };
    var __values = (this && this.__values) || function (o) {
        var s = typeof Symbol === "function" && Symbol.iterator, m = s && o[s], i = 0;
        if (m)
            return m.call(o);
        if (o && typeof o.length === "number")
            return {
                next: function () {
                    if (o && i >= o.length)
                        o = void 0;
                    return { value: o && o[i++], done: !o };
                }
            };
        throw new TypeError(s ? "Object is not iterable." : "Symbol.iterator is not defined.");
    };
    __esModule();
    var MmlNode_js_1 = require(639) /* ../MmlNode.js */;
    var MmlMrow = (function (_super) {
        __extends(MmlMrow, _super);
        function MmlMrow() {
            var _this = _super !== null && _super.apply(this, arguments) || this;
            _this._core = null;
            return _this;
        }
        Object.defineProperty(MmlMrow.prototype, "kind", {
            get: function () {
                return 'mrow';
            },
            enumerable: false,
            configurable: true
        });
        Object.defineProperty(MmlMrow.prototype, "isSpacelike", {
            get: function () {
                var e_1, _a;
                try {
                    for (var _b = __values(this.childNodes), _c = _b.next(); !_c.done; _c = _b.next()) {
                        var child = _c.value;
                        if (!child.isSpacelike) {
                            return false;
                        }
                    }
                }
                catch (e_1_1) {
                    e_1 = { error: e_1_1 };
                }
                finally {
                    try {
                        if (_c && !_c.done && (_a = _b.return))
                            _a.call(_b);
                    }
                    finally {
                        if (e_1)
                            throw e_1.error;
                    }
                }
                return true;
            },
            enumerable: false,
            configurable: true
        });
        Object.defineProperty(MmlMrow.prototype, "isEmbellished", {
            get: function () {
                var e_2, _a;
                var embellished = false;
                var i = 0;
                try {
                    for (var _b = __values(this.childNodes), _c = _b.next(); !_c.done; _c = _b.next()) {
                        var child = _c.value;
                        if (child) {
                            if (child.isEmbellished) {
                                if (embellished) {
                                    return false;
                                }
                                embellished = true;
                                this._core = i;
                            }
                            else if (!child.isSpacelike) {
                                return false;
                            }
                        }
                        i++;
                    }
                }
                catch (e_2_1) {
                    e_2 = { error: e_2_1 };
                }
                finally {
                    try {
                        if (_c && !_c.done && (_a = _b.return))
                            _a.call(_b);
                    }
                    finally {
                        if (e_2)
                            throw e_2.error;
                    }
                }
                return embellished;
            },
            enumerable: false,
            configurable: true
        });
        MmlMrow.prototype.core = function () {
            if (!this.isEmbellished || this._core == null) {
                return this;
            }
            return this.childNodes[this._core];
        };
        MmlMrow.prototype.coreMO = function () {
            if (!this.isEmbellished || this._core == null) {
                return this;
            }
            return this.childNodes[this._core].coreMO();
        };
        MmlMrow.prototype.nonSpaceLength = function () {
            var e_3, _a;
            var n = 0;
            try {
                for (var _b = __values(this.childNodes), _c = _b.next(); !_c.done; _c = _b.next()) {
                    var child = _c.value;
                    if (child && !child.isSpacelike) {
                        n++;
                    }
                }
            }
            catch (e_3_1) {
                e_3 = { error: e_3_1 };
            }
            finally {
                try {
                    if (_c && !_c.done && (_a = _b.return))
                        _a.call(_b);
                }
                finally {
                    if (e_3)
                        throw e_3.error;
                }
            }
            return n;
        };
        MmlMrow.prototype.firstNonSpace = function () {
            var e_4, _a;
            try {
                for (var _b = __values(this.childNodes), _c = _b.next(); !_c.done; _c = _b.next()) {
                    var child = _c.value;
                    if (child && !child.isSpacelike) {
                        return child;
                    }
                }
            }
            catch (e_4_1) {
                e_4 = { error: e_4_1 };
            }
            finally {
                try {
                    if (_c && !_c.done && (_a = _b.return))
                        _a.call(_b);
                }
                finally {
                    if (e_4)
                        throw e_4.error;
                }
            }
            return null;
        };
        MmlMrow.prototype.lastNonSpace = function () {
            var i = this.childNodes.length;
            while (--i >= 0) {
                var child = this.childNodes[i];
                if (child && !child.isSpacelike) {
                    return child;
                }
            }
            return null;
        };
        MmlMrow.prototype.setTeXclass = function (prev) {
            var e_5, _a, e_6, _b;
            if (this.getProperty('open') != null || this.getProperty('close') != null) {
                this.getPrevClass(prev);
                prev = null;
                try {
                    for (var _c = __values(this.childNodes), _d = _c.next(); !_d.done; _d = _c.next()) {
                        var child = _d.value;
                        prev = child.setTeXclass(prev);
                    }
                }
                catch (e_5_1) {
                    e_5 = { error: e_5_1 };
                }
                finally {
                    try {
                        if (_d && !_d.done && (_a = _c.return))
                            _a.call(_c);
                    }
                    finally {
                        if (e_5)
                            throw e_5.error;
                    }
                }
                if (this.texClass == null) {
                    this.texClass = MmlNode_js_1.TEXCLASS.INNER;
                }
            }
            else {
                try {
                    for (var _e = __values(this.childNodes), _f = _e.next(); !_f.done; _f = _e.next()) {
                        var child = _f.value;
                        prev = child.setTeXclass(prev);
                    }
                }
                catch (e_6_1) {
                    e_6 = { error: e_6_1 };
                }
                finally {
                    try {
                        if (_f && !_f.done && (_b = _e.return))
                            _b.call(_e);
                    }
                    finally {
                        if (e_6)
                            throw e_6.error;
                    }
                }
                if (this.childNodes[0]) {
                    this.updateTeXclass(this.childNodes[0]);
                }
            }
            return prev;
        };
        MmlMrow.defaults = __assign({}, MmlNode_js_1.AbstractMmlNode.defaults);
        return MmlMrow;
    }(MmlNode_js_1.AbstractMmlNode));
    exports.MmlMrow = MmlMrow;
    var MmlInferredMrow = (function (_super) {
        __extends(MmlInferredMrow, _super);
        function MmlInferredMrow() {
            return _super !== null && _super.apply(this, arguments) || this;
        }
        Object.defineProperty(MmlInferredMrow.prototype, "kind", {
            get: function () {
                return 'inferredMrow';
            },
            enumerable: false,
            configurable: true
        });
        Object.defineProperty(MmlInferredMrow.prototype, "isInferred", {
            get: function () {
                return true;
            },
            enumerable: false,
            configurable: true
        });
        Object.defineProperty(MmlInferredMrow.prototype, "notParent", {
            get: function () {
                return true;
            },
            enumerable: false,
            configurable: true
        });
        MmlInferredMrow.prototype.toString = function () {
            return '[' + this.childNodes.join(',') + ']';
        };
        MmlInferredMrow.defaults = MmlMrow.defaults;
        return MmlInferredMrow;
    }(MmlMrow));
    exports.MmlInferredMrow = MmlInferredMrow;
},
691: /* mathjax-full/js/output/svg/Wrappers/mi.js */ function _(require, module, exports, __esModule, __esExport) {
    var __extends = (this && this.__extends) || (function () {
        var extendStatics = function (d, b) {
            extendStatics = Object.setPrototypeOf ||
                ({ __proto__: [] } instanceof Array && function (d, b) { d.__proto__ = b; }) ||
                function (d, b) { for (var p in b)
                    if (Object.prototype.hasOwnProperty.call(b, p))
                        d[p] = b[p]; };
            return extendStatics(d, b);
        };
        return function (d, b) {
            if (typeof b !== "function" && b !== null)
                throw new TypeError("Class extends value " + String(b) + " is not a constructor or null");
            extendStatics(d, b);
            function __() { this.constructor = d; }
            d.prototype = b === null ? Object.create(b) : (__.prototype = b.prototype, new __());
        };
    })();
    __esModule();
    var Wrapper_js_1 = require(680) /* ../Wrapper.js */;
    var mi_js_1 = require(692) /* ../../common/Wrappers/mi.js */;
    var mi_js_2 = require(693) /* ../../../core/MmlTree/MmlNodes/mi.js */;
    var SVGmi = (function (_super) {
        __extends(SVGmi, _super);
        function SVGmi() {
            return _super !== null && _super.apply(this, arguments) || this;
        }
        SVGmi.kind = mi_js_2.MmlMi.prototype.kind;
        return SVGmi;
    }((0, mi_js_1.CommonMiMixin)(Wrapper_js_1.SVGWrapper)));
    exports.SVGmi = SVGmi;
},
692: /* mathjax-full/js/output/common/Wrappers/mi.js */ function _(require, module, exports, __esModule, __esExport) {
    var __extends = (this && this.__extends) || (function () {
        var extendStatics = function (d, b) {
            extendStatics = Object.setPrototypeOf ||
                ({ __proto__: [] } instanceof Array && function (d, b) { d.__proto__ = b; }) ||
                function (d, b) { for (var p in b)
                    if (Object.prototype.hasOwnProperty.call(b, p))
                        d[p] = b[p]; };
            return extendStatics(d, b);
        };
        return function (d, b) {
            if (typeof b !== "function" && b !== null)
                throw new TypeError("Class extends value " + String(b) + " is not a constructor or null");
            extendStatics(d, b);
            function __() { this.constructor = d; }
            d.prototype = b === null ? Object.create(b) : (__.prototype = b.prototype, new __());
        };
    })();
    __esModule();
    function CommonMiMixin(Base) {
        return (function (_super) {
            __extends(class_1, _super);
            function class_1() {
                return _super !== null && _super.apply(this, arguments) || this;
            }
            class_1.prototype.computeBBox = function (bbox, _recompute) {
                if (_recompute === void 0) {
                    _recompute = false;
                }
                _super.prototype.computeBBox.call(this, bbox);
                this.copySkewIC(bbox);
            };
            return class_1;
        }(Base));
    }
    exports.CommonMiMixin = CommonMiMixin;
},
693: /* mathjax-full/js/core/MmlTree/MmlNodes/mi.js */ function _(require, module, exports, __esModule, __esExport) {
    var __extends = (this && this.__extends) || (function () {
        var extendStatics = function (d, b) {
            extendStatics = Object.setPrototypeOf ||
                ({ __proto__: [] } instanceof Array && function (d, b) { d.__proto__ = b; }) ||
                function (d, b) { for (var p in b)
                    if (Object.prototype.hasOwnProperty.call(b, p))
                        d[p] = b[p]; };
            return extendStatics(d, b);
        };
        return function (d, b) {
            if (typeof b !== "function" && b !== null)
                throw new TypeError("Class extends value " + String(b) + " is not a constructor or null");
            extendStatics(d, b);
            function __() { this.constructor = d; }
            d.prototype = b === null ? Object.create(b) : (__.prototype = b.prototype, new __());
        };
    })();
    var __assign = (this && this.__assign) || function () {
        __assign = Object.assign || function (t) {
            for (var s, i = 1, n = arguments.length; i < n; i++) {
                s = arguments[i];
                for (var p in s)
                    if (Object.prototype.hasOwnProperty.call(s, p))
                        t[p] = s[p];
            }
            return t;
        };
        return __assign.apply(this, arguments);
    };
    __esModule();
    var MmlNode_js_1 = require(639) /* ../MmlNode.js */;
    var MmlMi = (function (_super) {
        __extends(MmlMi, _super);
        function MmlMi() {
            var _this = _super !== null && _super.apply(this, arguments) || this;
            _this.texclass = MmlNode_js_1.TEXCLASS.ORD;
            return _this;
        }
        Object.defineProperty(MmlMi.prototype, "kind", {
            get: function () {
                return 'mi';
            },
            enumerable: false,
            configurable: true
        });
        MmlMi.prototype.setInheritedAttributes = function (attributes, display, level, prime) {
            if (attributes === void 0) {
                attributes = {};
            }
            if (display === void 0) {
                display = false;
            }
            if (level === void 0) {
                level = 0;
            }
            if (prime === void 0) {
                prime = false;
            }
            _super.prototype.setInheritedAttributes.call(this, attributes, display, level, prime);
            var text = this.getText();
            if (text.match(MmlMi.singleCharacter) && !attributes.mathvariant) {
                this.attributes.setInherited('mathvariant', 'italic');
            }
        };
        MmlMi.prototype.setTeXclass = function (prev) {
            this.getPrevClass(prev);
            var name = this.getText();
            if (name.length > 1 && name.match(MmlMi.operatorName) &&
                this.attributes.get('mathvariant') === 'normal' &&
                this.getProperty('autoOP') === undefined &&
                this.getProperty('texClass') === undefined) {
                this.texClass = MmlNode_js_1.TEXCLASS.OP;
                this.setProperty('autoOP', true);
            }
            return this;
        };
        MmlMi.defaults = __assign({}, MmlNode_js_1.AbstractMmlTokenNode.defaults);
        MmlMi.operatorName = /^[a-z][a-z0-9]*$/i;
        MmlMi.singleCharacter = /^[\uD800-\uDBFF]?.[\u0300-\u036F\u1AB0-\u1ABE\u1DC0-\u1DFF\u20D0-\u20EF]*$/;
        return MmlMi;
    }(MmlNode_js_1.AbstractMmlTokenNode));
    exports.MmlMi = MmlMi;
},
694: /* mathjax-full/js/output/svg/Wrappers/mo.js */ function _(require, module, exports, __esModule, __esExport) {
    var __extends = (this && this.__extends) || (function () {
        var extendStatics = function (d, b) {
            extendStatics = Object.setPrototypeOf ||
                ({ __proto__: [] } instanceof Array && function (d, b) { d.__proto__ = b; }) ||
                function (d, b) { for (var p in b)
                    if (Object.prototype.hasOwnProperty.call(b, p))
                        d[p] = b[p]; };
            return extendStatics(d, b);
        };
        return function (d, b) {
            if (typeof b !== "function" && b !== null)
                throw new TypeError("Class extends value " + String(b) + " is not a constructor or null");
            extendStatics(d, b);
            function __() { this.constructor = d; }
            d.prototype = b === null ? Object.create(b) : (__.prototype = b.prototype, new __());
        };
    })();
    var __values = (this && this.__values) || function (o) {
        var s = typeof Symbol === "function" && Symbol.iterator, m = s && o[s], i = 0;
        if (m)
            return m.call(o);
        if (o && typeof o.length === "number")
            return {
                next: function () {
                    if (o && i >= o.length)
                        o = void 0;
                    return { value: o && o[i++], done: !o };
                }
            };
        throw new TypeError(s ? "Object is not iterable." : "Symbol.iterator is not defined.");
    };
    var __read = (this && this.__read) || function (o, n) {
        var m = typeof Symbol === "function" && o[Symbol.iterator];
        if (!m)
            return o;
        var i = m.call(o), r, ar = [], e;
        try {
            while ((n === void 0 || n-- > 0) && !(r = i.next()).done)
                ar.push(r.value);
        }
        catch (error) {
            e = { error: error };
        }
        finally {
            try {
                if (r && !r.done && (m = i["return"]))
                    m.call(i);
            }
            finally {
                if (e)
                    throw e.error;
            }
        }
        return ar;
    };
    __esModule();
    var Wrapper_js_1 = require(680) /* ../Wrapper.js */;
    var mo_js_1 = require(695) /* ../../common/Wrappers/mo.js */;
    var mo_js_2 = require(643) /* ../../../core/MmlTree/MmlNodes/mo.js */;
    var VFUZZ = 0.1;
    var HFUZZ = 0.1;
    var SVGmo = (function (_super) {
        __extends(SVGmo, _super);
        function SVGmo() {
            return _super !== null && _super.apply(this, arguments) || this;
        }
        SVGmo.prototype.toSVG = function (parent) {
            var attributes = this.node.attributes;
            var symmetric = attributes.get('symmetric') && this.stretch.dir !== 2;
            var stretchy = this.stretch.dir !== 0;
            if (stretchy && this.size === null) {
                this.getStretchedVariant([]);
            }
            var svg = this.standardSVGnode(parent);
            if (stretchy && this.size < 0) {
                this.stretchSVG();
            }
            else {
                var u = (symmetric || attributes.get('largeop') ? this.fixed(this.getCenterOffset()) : '0');
                var v = (this.node.getProperty('mathaccent') ? this.fixed(this.getAccentOffset()) : '0');
                if (u !== '0' || v !== '0') {
                    this.adaptor.setAttribute(svg, 'transform', "translate(".concat(v, " ").concat(u, ")"));
                }
                this.addChildren(svg);
            }
        };
        SVGmo.prototype.stretchSVG = function () {
            var stretch = this.stretch.stretch;
            var variants = this.getStretchVariants();
            var bbox = this.getBBox();
            if (this.stretch.dir === 1) {
                this.stretchVertical(stretch, variants, bbox);
            }
            else {
                this.stretchHorizontal(stretch, variants, bbox);
            }
        };
        SVGmo.prototype.getStretchVariants = function () {
            var e_1, _a;
            var c = this.stretch.c || this.getText().codePointAt(0);
            var variants = [];
            try {
                for (var _b = __values(this.stretch.stretch.keys()), _c = _b.next(); !_c.done; _c = _b.next()) {
                    var i = _c.value;
                    variants[i] = this.font.getStretchVariant(c, i);
                }
            }
            catch (e_1_1) {
                e_1 = { error: e_1_1 };
            }
            finally {
                try {
                    if (_c && !_c.done && (_a = _b.return))
                        _a.call(_b);
                }
                finally {
                    if (e_1)
                        throw e_1.error;
                }
            }
            return variants;
        };
        SVGmo.prototype.stretchVertical = function (stretch, variant, bbox) {
            var h = bbox.h, d = bbox.d, w = bbox.w;
            var T = this.addTop(stretch[0], variant[0], h, w);
            var B = this.addBot(stretch[2], variant[2], d, w);
            if (stretch.length === 4) {
                var _a = __read(this.addMidV(stretch[3], variant[3], w), 2), H = _a[0], D = _a[1];
                this.addExtV(stretch[1], variant[1], h, 0, T, H, w);
                this.addExtV(stretch[1], variant[1], 0, d, D, B, w);
            }
            else {
                this.addExtV(stretch[1], variant[1], h, d, T, B, w);
            }
        };
        SVGmo.prototype.stretchHorizontal = function (stretch, variant, bbox) {
            var w = bbox.w;
            var L = this.addLeft(stretch[0], variant[0]);
            var R = this.addRight(stretch[2], variant[2], w);
            if (stretch.length === 4) {
                var _a = __read(this.addMidH(stretch[3], variant[3], w), 2), x1 = _a[0], x2 = _a[1];
                var w2 = w / 2;
                this.addExtH(stretch[1], variant[1], w2, L, w2 - x1);
                this.addExtH(stretch[1], variant[1], w2, x2 - w2, R, w2);
            }
            else {
                this.addExtH(stretch[1], variant[1], w, L, R);
            }
        };
        SVGmo.prototype.getChar = function (n, variant) {
            var char = this.font.getChar(variant, n) || [0, 0, 0, null];
            return [char[0], char[1], char[2], char[3] || {}];
        };
        SVGmo.prototype.addGlyph = function (n, variant, x, y, parent) {
            if (parent === void 0) {
                parent = null;
            }
            return this.placeChar(n, x, y, parent || this.element, variant);
        };
        SVGmo.prototype.addTop = function (n, v, H, W) {
            if (!n)
                return 0;
            var _a = __read(this.getChar(n, v), 3), h = _a[0], d = _a[1], w = _a[2];
            this.addGlyph(n, v, (W - w) / 2, H - h);
            return h + d;
        };
        SVGmo.prototype.addExtV = function (n, v, H, D, T, B, W) {
            var _this = this;
            if (!n)
                return;
            T = Math.max(0, T - VFUZZ);
            B = Math.max(0, B - VFUZZ);
            var adaptor = this.adaptor;
            var _a = __read(this.getChar(n, v), 3), h = _a[0], d = _a[1], w = _a[2];
            var Y = H + D - T - B;
            var s = 1.5 * Y / (h + d);
            var y = (s * (h - d) - Y) / 2;
            if (Y <= 0)
                return;
            var svg = this.svg('svg', {
                width: this.fixed(w), height: this.fixed(Y),
                y: this.fixed(B - D), x: this.fixed((W - w) / 2),
                viewBox: [0, y, w, Y].map(function (x) { return _this.fixed(x); }).join(' ')
            });
            this.addGlyph(n, v, 0, 0, svg);
            var glyph = adaptor.lastChild(svg);
            adaptor.setAttribute(glyph, 'transform', "scale(1,".concat(this.jax.fixed(s), ")"));
            adaptor.append(this.element, svg);
        };
        SVGmo.prototype.addBot = function (n, v, D, W) {
            if (!n)
                return 0;
            var _a = __read(this.getChar(n, v), 3), h = _a[0], d = _a[1], w = _a[2];
            this.addGlyph(n, v, (W - w) / 2, d - D);
            return h + d;
        };
        SVGmo.prototype.addMidV = function (n, v, W) {
            if (!n)
                return [0, 0];
            var _a = __read(this.getChar(n, v), 3), h = _a[0], d = _a[1], w = _a[2];
            var y = (d - h) / 2 + this.font.params.axis_height;
            this.addGlyph(n, v, (W - w) / 2, y);
            return [h + y, d - y];
        };
        SVGmo.prototype.addLeft = function (n, v) {
            return (n ? this.addGlyph(n, v, 0, 0) : 0);
        };
        SVGmo.prototype.addExtH = function (n, v, W, L, R, x) {
            var _this = this;
            if (x === void 0) {
                x = 0;
            }
            if (!n)
                return;
            R = Math.max(0, R - HFUZZ);
            L = Math.max(0, L - HFUZZ);
            var adaptor = this.adaptor;
            var _a = __read(this.getChar(n, v), 3), h = _a[0], d = _a[1], w = _a[2];
            var X = W - L - R;
            var Y = h + d + 2 * VFUZZ;
            var s = 1.5 * (X / w);
            var D = -(d + VFUZZ);
            if (X <= 0)
                return;
            var svg = this.svg('svg', {
                width: this.fixed(X), height: this.fixed(Y),
                x: this.fixed(x + L), y: this.fixed(D),
                viewBox: [(s * w - X) / 2, D, X, Y].map(function (x) { return _this.fixed(x); }).join(' ')
            });
            this.addGlyph(n, v, 0, 0, svg);
            var glyph = adaptor.lastChild(svg);
            adaptor.setAttribute(glyph, 'transform', 'scale(' + this.jax.fixed(s) + ',1)');
            adaptor.append(this.element, svg);
        };
        SVGmo.prototype.addRight = function (n, v, W) {
            if (!n)
                return 0;
            var w = this.getChar(n, v)[2];
            return this.addGlyph(n, v, W - w, 0);
        };
        SVGmo.prototype.addMidH = function (n, v, W) {
            if (!n)
                return [0, 0];
            var w = this.getChar(n, v)[2];
            this.addGlyph(n, v, (W - w) / 2, 0);
            return [(W - w) / 2, (W + w) / 2];
        };
        SVGmo.kind = mo_js_2.MmlMo.prototype.kind;
        return SVGmo;
    }((0, mo_js_1.CommonMoMixin)(Wrapper_js_1.SVGWrapper)));
    exports.SVGmo = SVGmo;
},
695: /* mathjax-full/js/output/common/Wrappers/mo.js */ function _(require, module, exports, __esModule, __esExport) {
    var __extends = (this && this.__extends) || (function () {
        var extendStatics = function (d, b) {
            extendStatics = Object.setPrototypeOf ||
                ({ __proto__: [] } instanceof Array && function (d, b) { d.__proto__ = b; }) ||
                function (d, b) { for (var p in b)
                    if (Object.prototype.hasOwnProperty.call(b, p))
                        d[p] = b[p]; };
            return extendStatics(d, b);
        };
        return function (d, b) {
            if (typeof b !== "function" && b !== null)
                throw new TypeError("Class extends value " + String(b) + " is not a constructor or null");
            extendStatics(d, b);
            function __() { this.constructor = d; }
            d.prototype = b === null ? Object.create(b) : (__.prototype = b.prototype, new __());
        };
    })();
    var __assign = (this && this.__assign) || function () {
        __assign = Object.assign || function (t) {
            for (var s, i = 1, n = arguments.length; i < n; i++) {
                s = arguments[i];
                for (var p in s)
                    if (Object.prototype.hasOwnProperty.call(s, p))
                        t[p] = s[p];
            }
            return t;
        };
        return __assign.apply(this, arguments);
    };
    var __read = (this && this.__read) || function (o, n) {
        var m = typeof Symbol === "function" && o[Symbol.iterator];
        if (!m)
            return o;
        var i = m.call(o), r, ar = [], e;
        try {
            while ((n === void 0 || n-- > 0) && !(r = i.next()).done)
                ar.push(r.value);
        }
        catch (error) {
            e = { error: error };
        }
        finally {
            try {
                if (r && !r.done && (m = i["return"]))
                    m.call(i);
            }
            finally {
                if (e)
                    throw e.error;
            }
        }
        return ar;
    };
    var __spreadArray = (this && this.__spreadArray) || function (to, from, pack) {
        if (pack || arguments.length === 2)
            for (var i = 0, l = from.length, ar; i < l; i++) {
                if (ar || !(i in from)) {
                    if (!ar)
                        ar = Array.prototype.slice.call(from, 0, i);
                    ar[i] = from[i];
                }
            }
        return to.concat(ar || Array.prototype.slice.call(from));
    };
    var __values = (this && this.__values) || function (o) {
        var s = typeof Symbol === "function" && Symbol.iterator, m = s && o[s], i = 0;
        if (m)
            return m.call(o);
        if (o && typeof o.length === "number")
            return {
                next: function () {
                    if (o && i >= o.length)
                        o = void 0;
                    return { value: o && o[i++], done: !o };
                }
            };
        throw new TypeError(s ? "Object is not iterable." : "Symbol.iterator is not defined.");
    };
    var _a;
    __esModule();
    var BBox_js_1 = require(681) /* ../../../util/BBox.js */;
    var string_js_1 = require(636) /* ../../../util/string.js */;
    var FontData_js_1 = require(684) /* ../FontData.js */;
    exports.DirectionVH = (_a = {},
        _a[1] = 'v',
        _a[2] = 'h',
        _a);
    function CommonMoMixin(Base) {
        return (function (_super) {
            __extends(class_1, _super);
            function class_1() {
                var args = [];
                for (var _i = 0; _i < arguments.length; _i++) {
                    args[_i] = arguments[_i];
                }
                var _this = _super.apply(this, __spreadArray([], __read(args), false)) || this;
                _this.size = null;
                _this.isAccent = _this.node.isAccent;
                return _this;
            }
            class_1.prototype.computeBBox = function (bbox, _recompute) {
                if (_recompute === void 0) {
                    _recompute = false;
                }
                this.protoBBox(bbox);
                if (this.node.attributes.get('symmetric') &&
                    this.stretch.dir !== 2) {
                    var d = this.getCenterOffset(bbox);
                    bbox.h += d;
                    bbox.d -= d;
                }
                if (this.node.getProperty('mathaccent') &&
                    (this.stretch.dir === 0 || this.size >= 0)) {
                    bbox.w = 0;
                }
            };
            class_1.prototype.protoBBox = function (bbox) {
                var stretchy = (this.stretch.dir !== 0);
                if (stretchy && this.size === null) {
                    this.getStretchedVariant([0]);
                }
                if (stretchy && this.size < 0)
                    return;
                _super.prototype.computeBBox.call(this, bbox);
                this.copySkewIC(bbox);
            };
            class_1.prototype.getAccentOffset = function () {
                var bbox = BBox_js_1.BBox.empty();
                this.protoBBox(bbox);
                return -bbox.w / 2;
            };
            class_1.prototype.getCenterOffset = function (bbox) {
                if (bbox === void 0) {
                    bbox = null;
                }
                if (!bbox) {
                    bbox = BBox_js_1.BBox.empty();
                    _super.prototype.computeBBox.call(this, bbox);
                }
                return ((bbox.h + bbox.d) / 2 + this.font.params.axis_height) - bbox.h;
            };
            class_1.prototype.getVariant = function () {
                if (this.node.attributes.get('largeop')) {
                    this.variant = (this.node.attributes.get('displaystyle') ? '-largeop' : '-smallop');
                    return;
                }
                if (!this.node.attributes.getExplicit('mathvariant') &&
                    this.node.getProperty('pseudoscript') === false) {
                    this.variant = '-tex-variant';
                    return;
                }
                _super.prototype.getVariant.call(this);
            };
            class_1.prototype.canStretch = function (direction) {
                if (this.stretch.dir !== 0) {
                    return this.stretch.dir === direction;
                }
                var attributes = this.node.attributes;
                if (!attributes.get('stretchy'))
                    return false;
                var c = this.getText();
                if (Array.from(c).length !== 1)
                    return false;
                var delim = this.font.getDelimiter(c.codePointAt(0));
                this.stretch = (delim && delim.dir === direction ? delim : FontData_js_1.NOSTRETCH);
                return this.stretch.dir !== 0;
            };
            class_1.prototype.getStretchedVariant = function (WH, exact) {
                var e_1, _a;
                if (exact === void 0) {
                    exact = false;
                }
                if (this.stretch.dir !== 0) {
                    var D = this.getWH(WH);
                    var min = this.getSize('minsize', 0);
                    var max = this.getSize('maxsize', Infinity);
                    var mathaccent = this.node.getProperty('mathaccent');
                    D = Math.max(min, Math.min(max, D));
                    var df = this.font.params.delimiterfactor / 1000;
                    var ds = this.font.params.delimitershortfall;
                    var m = (min || exact ? D : mathaccent ? Math.min(D / df, D + ds) : Math.max(D * df, D - ds));
                    var delim = this.stretch;
                    var c = delim.c || this.getText().codePointAt(0);
                    var i = 0;
                    if (delim.sizes) {
                        try {
                            for (var _b = __values(delim.sizes), _c = _b.next(); !_c.done; _c = _b.next()) {
                                var d = _c.value;
                                if (d >= m) {
                                    if (mathaccent && i) {
                                        i--;
                                    }
                                    this.variant = this.font.getSizeVariant(c, i);
                                    this.size = i;
                                    if (delim.schar && delim.schar[i]) {
                                        this.stretch = __assign(__assign({}, this.stretch), { c: delim.schar[i] });
                                    }
                                    return;
                                }
                                i++;
                            }
                        }
                        catch (e_1_1) {
                            e_1 = { error: e_1_1 };
                        }
                        finally {
                            try {
                                if (_c && !_c.done && (_a = _b.return))
                                    _a.call(_b);
                            }
                            finally {
                                if (e_1)
                                    throw e_1.error;
                            }
                        }
                    }
                    if (delim.stretch) {
                        this.size = -1;
                        this.invalidateBBox();
                        this.getStretchBBox(WH, this.checkExtendedHeight(D, delim), delim);
                    }
                    else {
                        this.variant = this.font.getSizeVariant(c, i - 1);
                        this.size = i - 1;
                    }
                }
            };
            class_1.prototype.getSize = function (name, value) {
                var attributes = this.node.attributes;
                if (attributes.isSet(name)) {
                    value = this.length2em(attributes.get(name), 1, 1);
                }
                return value;
            };
            class_1.prototype.getWH = function (WH) {
                if (WH.length === 0)
                    return 0;
                if (WH.length === 1)
                    return WH[0];
                var _a = __read(WH, 2), H = _a[0], D = _a[1];
                var a = this.font.params.axis_height;
                return (this.node.attributes.get('symmetric') ? 2 * Math.max(H - a, D + a) : H + D);
            };
            class_1.prototype.getStretchBBox = function (WHD, D, C) {
                var _a;
                if (C.hasOwnProperty('min') && C.min > D) {
                    D = C.min;
                }
                var _b = __read(C.HDW, 3), h = _b[0], d = _b[1], w = _b[2];
                if (this.stretch.dir === 1) {
                    _a = __read(this.getBaseline(WHD, D, C), 2), h = _a[0], d = _a[1];
                }
                else {
                    w = D;
                }
                this.bbox.h = h;
                this.bbox.d = d;
                this.bbox.w = w;
            };
            class_1.prototype.getBaseline = function (WHD, HD, C) {
                var hasWHD = (WHD.length === 2 && WHD[0] + WHD[1] === HD);
                var symmetric = this.node.attributes.get('symmetric');
                var _a = __read((hasWHD ? WHD : [HD, 0]), 2), H = _a[0], D = _a[1];
                var _b = __read([H + D, 0], 2), h = _b[0], d = _b[1];
                if (symmetric) {
                    var a = this.font.params.axis_height;
                    if (hasWHD) {
                        h = 2 * Math.max(H - a, D + a);
                    }
                    d = h / 2 - a;
                }
                else if (hasWHD) {
                    d = D;
                }
                else {
                    var _c = __read((C.HDW || [.75, .25]), 2), ch = _c[0], cd = _c[1];
                    d = cd * (h / (ch + cd));
                }
                return [h - d, d];
            };
            class_1.prototype.checkExtendedHeight = function (D, C) {
                if (C.fullExt) {
                    var _a = __read(C.fullExt, 2), extSize = _a[0], endSize = _a[1];
                    var n = Math.ceil(Math.max(0, D - endSize) / extSize);
                    D = endSize + n * extSize;
                }
                return D;
            };
            class_1.prototype.remapChars = function (chars) {
                var primes = this.node.getProperty('primes');
                if (primes) {
                    return (0, string_js_1.unicodeChars)(primes);
                }
                if (chars.length === 1) {
                    var parent_1 = this.node.coreParent().parent;
                    var isAccent = this.isAccent && !parent_1.isKind('mrow');
                    var map = (isAccent ? 'accent' : 'mo');
                    var text = this.font.getRemappedChar(map, chars[0]);
                    if (text) {
                        chars = this.unicodeChars(text, this.variant);
                    }
                }
                return chars;
            };
            return class_1;
        }(Base));
    }
    exports.CommonMoMixin = CommonMoMixin;
},
696: /* mathjax-full/js/output/svg/Wrappers/mn.js */ function _(require, module, exports, __esModule, __esExport) {
    var __extends = (this && this.__extends) || (function () {
        var extendStatics = function (d, b) {
            extendStatics = Object.setPrototypeOf ||
                ({ __proto__: [] } instanceof Array && function (d, b) { d.__proto__ = b; }) ||
                function (d, b) { for (var p in b)
                    if (Object.prototype.hasOwnProperty.call(b, p))
                        d[p] = b[p]; };
            return extendStatics(d, b);
        };
        return function (d, b) {
            if (typeof b !== "function" && b !== null)
                throw new TypeError("Class extends value " + String(b) + " is not a constructor or null");
            extendStatics(d, b);
            function __() { this.constructor = d; }
            d.prototype = b === null ? Object.create(b) : (__.prototype = b.prototype, new __());
        };
    })();
    __esModule();
    var Wrapper_js_1 = require(680) /* ../Wrapper.js */;
    var mn_js_1 = require(697) /* ../../common/Wrappers/mn.js */;
    var mn_js_2 = require(698) /* ../../../core/MmlTree/MmlNodes/mn.js */;
    var SVGmn = (function (_super) {
        __extends(SVGmn, _super);
        function SVGmn() {
            return _super !== null && _super.apply(this, arguments) || this;
        }
        SVGmn.kind = mn_js_2.MmlMn.prototype.kind;
        return SVGmn;
    }((0, mn_js_1.CommonMnMixin)(Wrapper_js_1.SVGWrapper)));
    exports.SVGmn = SVGmn;
},
697: /* mathjax-full/js/output/common/Wrappers/mn.js */ function _(require, module, exports, __esModule, __esExport) {
    var __extends = (this && this.__extends) || (function () {
        var extendStatics = function (d, b) {
            extendStatics = Object.setPrototypeOf ||
                ({ __proto__: [] } instanceof Array && function (d, b) { d.__proto__ = b; }) ||
                function (d, b) { for (var p in b)
                    if (Object.prototype.hasOwnProperty.call(b, p))
                        d[p] = b[p]; };
            return extendStatics(d, b);
        };
        return function (d, b) {
            if (typeof b !== "function" && b !== null)
                throw new TypeError("Class extends value " + String(b) + " is not a constructor or null");
            extendStatics(d, b);
            function __() { this.constructor = d; }
            d.prototype = b === null ? Object.create(b) : (__.prototype = b.prototype, new __());
        };
    })();
    __esModule();
    function CommonMnMixin(Base) {
        return (function (_super) {
            __extends(class_1, _super);
            function class_1() {
                return _super !== null && _super.apply(this, arguments) || this;
            }
            class_1.prototype.remapChars = function (chars) {
                if (chars.length) {
                    var text = this.font.getRemappedChar('mn', chars[0]);
                    if (text) {
                        var c = this.unicodeChars(text, this.variant);
                        if (c.length === 1) {
                            chars[0] = c[0];
                        }
                        else {
                            chars = c.concat(chars.slice(1));
                        }
                    }
                }
                return chars;
            };
            return class_1;
        }(Base));
    }
    exports.CommonMnMixin = CommonMnMixin;
},
698: /* mathjax-full/js/core/MmlTree/MmlNodes/mn.js */ function _(require, module, exports, __esModule, __esExport) {
    var __extends = (this && this.__extends) || (function () {
        var extendStatics = function (d, b) {
            extendStatics = Object.setPrototypeOf ||
                ({ __proto__: [] } instanceof Array && function (d, b) { d.__proto__ = b; }) ||
                function (d, b) { for (var p in b)
                    if (Object.prototype.hasOwnProperty.call(b, p))
                        d[p] = b[p]; };
            return extendStatics(d, b);
        };
        return function (d, b) {
            if (typeof b !== "function" && b !== null)
                throw new TypeError("Class extends value " + String(b) + " is not a constructor or null");
            extendStatics(d, b);
            function __() { this.constructor = d; }
            d.prototype = b === null ? Object.create(b) : (__.prototype = b.prototype, new __());
        };
    })();
    var __assign = (this && this.__assign) || function () {
        __assign = Object.assign || function (t) {
            for (var s, i = 1, n = arguments.length; i < n; i++) {
                s = arguments[i];
                for (var p in s)
                    if (Object.prototype.hasOwnProperty.call(s, p))
                        t[p] = s[p];
            }
            return t;
        };
        return __assign.apply(this, arguments);
    };
    __esModule();
    var MmlNode_js_1 = require(639) /* ../MmlNode.js */;
    var MmlMn = (function (_super) {
        __extends(MmlMn, _super);
        function MmlMn() {
            var _this = _super !== null && _super.apply(this, arguments) || this;
            _this.texclass = MmlNode_js_1.TEXCLASS.ORD;
            return _this;
        }
        Object.defineProperty(MmlMn.prototype, "kind", {
            get: function () {
                return 'mn';
            },
            enumerable: false,
            configurable: true
        });
        MmlMn.defaults = __assign({}, MmlNode_js_1.AbstractMmlTokenNode.defaults);
        return MmlMn;
    }(MmlNode_js_1.AbstractMmlTokenNode));
    exports.MmlMn = MmlMn;
},
699: /* mathjax-full/js/output/svg/Wrappers/ms.js */ function _(require, module, exports, __esModule, __esExport) {
    var __extends = (this && this.__extends) || (function () {
        var extendStatics = function (d, b) {
            extendStatics = Object.setPrototypeOf ||
                ({ __proto__: [] } instanceof Array && function (d, b) { d.__proto__ = b; }) ||
                function (d, b) { for (var p in b)
                    if (Object.prototype.hasOwnProperty.call(b, p))
                        d[p] = b[p]; };
            return extendStatics(d, b);
        };
        return function (d, b) {
            if (typeof b !== "function" && b !== null)
                throw new TypeError("Class extends value " + String(b) + " is not a constructor or null");
            extendStatics(d, b);
            function __() { this.constructor = d; }
            d.prototype = b === null ? Object.create(b) : (__.prototype = b.prototype, new __());
        };
    })();
    __esModule();
    var Wrapper_js_1 = require(680) /* ../Wrapper.js */;
    var ms_js_1 = require(700) /* ../../common/Wrappers/ms.js */;
    var ms_js_2 = require(701) /* ../../../core/MmlTree/MmlNodes/ms.js */;
    var SVGms = (function (_super) {
        __extends(SVGms, _super);
        function SVGms() {
            return _super !== null && _super.apply(this, arguments) || this;
        }
        SVGms.kind = ms_js_2.MmlMs.prototype.kind;
        return SVGms;
    }((0, ms_js_1.CommonMsMixin)(Wrapper_js_1.SVGWrapper)));
    exports.SVGms = SVGms;
},
700: /* mathjax-full/js/output/common/Wrappers/ms.js */ function _(require, module, exports, __esModule, __esExport) {
    var __extends = (this && this.__extends) || (function () {
        var extendStatics = function (d, b) {
            extendStatics = Object.setPrototypeOf ||
                ({ __proto__: [] } instanceof Array && function (d, b) { d.__proto__ = b; }) ||
                function (d, b) { for (var p in b)
                    if (Object.prototype.hasOwnProperty.call(b, p))
                        d[p] = b[p]; };
            return extendStatics(d, b);
        };
        return function (d, b) {
            if (typeof b !== "function" && b !== null)
                throw new TypeError("Class extends value " + String(b) + " is not a constructor or null");
            extendStatics(d, b);
            function __() { this.constructor = d; }
            d.prototype = b === null ? Object.create(b) : (__.prototype = b.prototype, new __());
        };
    })();
    var __read = (this && this.__read) || function (o, n) {
        var m = typeof Symbol === "function" && o[Symbol.iterator];
        if (!m)
            return o;
        var i = m.call(o), r, ar = [], e;
        try {
            while ((n === void 0 || n-- > 0) && !(r = i.next()).done)
                ar.push(r.value);
        }
        catch (error) {
            e = { error: error };
        }
        finally {
            try {
                if (r && !r.done && (m = i["return"]))
                    m.call(i);
            }
            finally {
                if (e)
                    throw e.error;
            }
        }
        return ar;
    };
    var __spreadArray = (this && this.__spreadArray) || function (to, from, pack) {
        if (pack || arguments.length === 2)
            for (var i = 0, l = from.length, ar; i < l; i++) {
                if (ar || !(i in from)) {
                    if (!ar)
                        ar = Array.prototype.slice.call(from, 0, i);
                    ar[i] = from[i];
                }
            }
        return to.concat(ar || Array.prototype.slice.call(from));
    };
    __esModule();
    function CommonMsMixin(Base) {
        return (function (_super) {
            __extends(class_1, _super);
            function class_1() {
                var args = [];
                for (var _i = 0; _i < arguments.length; _i++) {
                    args[_i] = arguments[_i];
                }
                var _this = _super.apply(this, __spreadArray([], __read(args), false)) || this;
                var attributes = _this.node.attributes;
                var quotes = attributes.getList('lquote', 'rquote');
                if (_this.variant !== 'monospace') {
                    if (!attributes.isSet('lquote') && quotes.lquote === '"')
                        quotes.lquote = '\u201C';
                    if (!attributes.isSet('rquote') && quotes.rquote === '"')
                        quotes.rquote = '\u201D';
                }
                _this.childNodes.unshift(_this.createText(quotes.lquote));
                _this.childNodes.push(_this.createText(quotes.rquote));
                return _this;
            }
            class_1.prototype.createText = function (text) {
                var node = this.wrap(this.mmlText(text));
                node.parent = this;
                return node;
            };
            return class_1;
        }(Base));
    }
    exports.CommonMsMixin = CommonMsMixin;
},
701: /* mathjax-full/js/core/MmlTree/MmlNodes/ms.js */ function _(require, module, exports, __esModule, __esExport) {
    var __extends = (this && this.__extends) || (function () {
        var extendStatics = function (d, b) {
            extendStatics = Object.setPrototypeOf ||
                ({ __proto__: [] } instanceof Array && function (d, b) { d.__proto__ = b; }) ||
                function (d, b) { for (var p in b)
                    if (Object.prototype.hasOwnProperty.call(b, p))
                        d[p] = b[p]; };
            return extendStatics(d, b);
        };
        return function (d, b) {
            if (typeof b !== "function" && b !== null)
                throw new TypeError("Class extends value " + String(b) + " is not a constructor or null");
            extendStatics(d, b);
            function __() { this.constructor = d; }
            d.prototype = b === null ? Object.create(b) : (__.prototype = b.prototype, new __());
        };
    })();
    var __assign = (this && this.__assign) || function () {
        __assign = Object.assign || function (t) {
            for (var s, i = 1, n = arguments.length; i < n; i++) {
                s = arguments[i];
                for (var p in s)
                    if (Object.prototype.hasOwnProperty.call(s, p))
                        t[p] = s[p];
            }
            return t;
        };
        return __assign.apply(this, arguments);
    };
    __esModule();
    var MmlNode_js_1 = require(639) /* ../MmlNode.js */;
    var MmlMs = (function (_super) {
        __extends(MmlMs, _super);
        function MmlMs() {
            var _this = _super !== null && _super.apply(this, arguments) || this;
            _this.texclass = MmlNode_js_1.TEXCLASS.ORD;
            return _this;
        }
        Object.defineProperty(MmlMs.prototype, "kind", {
            get: function () {
                return 'ms';
            },
            enumerable: false,
            configurable: true
        });
        MmlMs.defaults = __assign(__assign({}, MmlNode_js_1.AbstractMmlTokenNode.defaults), { lquote: '"', rquote: '"' });
        return MmlMs;
    }(MmlNode_js_1.AbstractMmlTokenNode));
    exports.MmlMs = MmlMs;
},
702: /* mathjax-full/js/output/svg/Wrappers/mtext.js */ function _(require, module, exports, __esModule, __esExport) {
    var __extends = (this && this.__extends) || (function () {
        var extendStatics = function (d, b) {
            extendStatics = Object.setPrototypeOf ||
                ({ __proto__: [] } instanceof Array && function (d, b) { d.__proto__ = b; }) ||
                function (d, b) { for (var p in b)
                    if (Object.prototype.hasOwnProperty.call(b, p))
                        d[p] = b[p]; };
            return extendStatics(d, b);
        };
        return function (d, b) {
            if (typeof b !== "function" && b !== null)
                throw new TypeError("Class extends value " + String(b) + " is not a constructor or null");
            extendStatics(d, b);
            function __() { this.constructor = d; }
            d.prototype = b === null ? Object.create(b) : (__.prototype = b.prototype, new __());
        };
    })();
    __esModule();
    var Wrapper_js_1 = require(680) /* ../Wrapper.js */;
    var mtext_js_1 = require(703) /* ../../common/Wrappers/mtext.js */;
    var mtext_js_2 = require(704) /* ../../../core/MmlTree/MmlNodes/mtext.js */;
    var SVGmtext = (function (_super) {
        __extends(SVGmtext, _super);
        function SVGmtext() {
            return _super !== null && _super.apply(this, arguments) || this;
        }
        SVGmtext.kind = mtext_js_2.MmlMtext.prototype.kind;
        return SVGmtext;
    }((0, mtext_js_1.CommonMtextMixin)(Wrapper_js_1.SVGWrapper)));
    exports.SVGmtext = SVGmtext;
},
703: /* mathjax-full/js/output/common/Wrappers/mtext.js */ function _(require, module, exports, __esModule, __esExport) {
    var __extends = (this && this.__extends) || (function () {
        var extendStatics = function (d, b) {
            extendStatics = Object.setPrototypeOf ||
                ({ __proto__: [] } instanceof Array && function (d, b) { d.__proto__ = b; }) ||
                function (d, b) { for (var p in b)
                    if (Object.prototype.hasOwnProperty.call(b, p))
                        d[p] = b[p]; };
            return extendStatics(d, b);
        };
        return function (d, b) {
            if (typeof b !== "function" && b !== null)
                throw new TypeError("Class extends value " + String(b) + " is not a constructor or null");
            extendStatics(d, b);
            function __() { this.constructor = d; }
            d.prototype = b === null ? Object.create(b) : (__.prototype = b.prototype, new __());
        };
    })();
    __esModule();
    function CommonMtextMixin(Base) {
        var _a;
        return _a = (function (_super) {
            __extends(class_1, _super);
            function class_1() {
                return _super !== null && _super.apply(this, arguments) || this;
            }
            class_1.prototype.getVariant = function () {
                var options = this.jax.options;
                var data = this.jax.math.outputData;
                var merror = ((!!data.merrorFamily || !!options.merrorFont) && this.node.Parent.isKind('merror'));
                if (!!data.mtextFamily || !!options.mtextFont || merror) {
                    var variant = this.node.attributes.get('mathvariant');
                    var font = this.constructor.INHERITFONTS[variant] || this.jax.font.getCssFont(variant);
                    var family = font[0] || (merror ? data.merrorFamily || options.merrorFont :
                        data.mtextFamily || options.mtextFont);
                    this.variant = this.explicitVariant(family, font[2] ? 'bold' : '', font[1] ? 'italic' : '');
                    return;
                }
                _super.prototype.getVariant.call(this);
            };
            return class_1;
        }(Base)),
            _a.INHERITFONTS = {
                normal: ['', false, false],
                bold: ['', false, true],
                italic: ['', true, false],
                'bold-italic': ['', true, true]
            },
            _a;
    }
    exports.CommonMtextMixin = CommonMtextMixin;
},
704: /* mathjax-full/js/core/MmlTree/MmlNodes/mtext.js */ function _(require, module, exports, __esModule, __esExport) {
    var __extends = (this && this.__extends) || (function () {
        var extendStatics = function (d, b) {
            extendStatics = Object.setPrototypeOf ||
                ({ __proto__: [] } instanceof Array && function (d, b) { d.__proto__ = b; }) ||
                function (d, b) { for (var p in b)
                    if (Object.prototype.hasOwnProperty.call(b, p))
                        d[p] = b[p]; };
            return extendStatics(d, b);
        };
        return function (d, b) {
            if (typeof b !== "function" && b !== null)
                throw new TypeError("Class extends value " + String(b) + " is not a constructor or null");
            extendStatics(d, b);
            function __() { this.constructor = d; }
            d.prototype = b === null ? Object.create(b) : (__.prototype = b.prototype, new __());
        };
    })();
    var __assign = (this && this.__assign) || function () {
        __assign = Object.assign || function (t) {
            for (var s, i = 1, n = arguments.length; i < n; i++) {
                s = arguments[i];
                for (var p in s)
                    if (Object.prototype.hasOwnProperty.call(s, p))
                        t[p] = s[p];
            }
            return t;
        };
        return __assign.apply(this, arguments);
    };
    __esModule();
    var MmlNode_js_1 = require(639) /* ../MmlNode.js */;
    var MmlMtext = (function (_super) {
        __extends(MmlMtext, _super);
        function MmlMtext() {
            var _this = _super !== null && _super.apply(this, arguments) || this;
            _this.texclass = MmlNode_js_1.TEXCLASS.ORD;
            return _this;
        }
        Object.defineProperty(MmlMtext.prototype, "kind", {
            get: function () {
                return 'mtext';
            },
            enumerable: false,
            configurable: true
        });
        Object.defineProperty(MmlMtext.prototype, "isSpacelike", {
            get: function () {
                return true;
            },
            enumerable: false,
            configurable: true
        });
        MmlMtext.defaults = __assign({}, MmlNode_js_1.AbstractMmlTokenNode.defaults);
        return MmlMtext;
    }(MmlNode_js_1.AbstractMmlTokenNode));
    exports.MmlMtext = MmlMtext;
},
705: /* mathjax-full/js/output/svg/Wrappers/merror.js */ function _(require, module, exports, __esModule, __esExport) {
    var __extends = (this && this.__extends) || (function () {
        var extendStatics = function (d, b) {
            extendStatics = Object.setPrototypeOf ||
                ({ __proto__: [] } instanceof Array && function (d, b) { d.__proto__ = b; }) ||
                function (d, b) { for (var p in b)
                    if (Object.prototype.hasOwnProperty.call(b, p))
                        d[p] = b[p]; };
            return extendStatics(d, b);
        };
        return function (d, b) {
            if (typeof b !== "function" && b !== null)
                throw new TypeError("Class extends value " + String(b) + " is not a constructor or null");
            extendStatics(d, b);
            function __() { this.constructor = d; }
            d.prototype = b === null ? Object.create(b) : (__.prototype = b.prototype, new __());
        };
    })();
    __esModule();
    var Wrapper_js_1 = require(680) /* ../Wrapper.js */;
    var merror_js_1 = require(706) /* ../../../core/MmlTree/MmlNodes/merror.js */;
    var SVGmerror = (function (_super) {
        __extends(SVGmerror, _super);
        function SVGmerror() {
            return _super !== null && _super.apply(this, arguments) || this;
        }
        SVGmerror.prototype.toSVG = function (parent) {
            var svg = this.standardSVGnode(parent);
            var _a = this.getBBox(), h = _a.h, d = _a.d, w = _a.w;
            this.adaptor.append(this.element, this.svg('rect', {
                'data-background': true,
                width: this.fixed(w), height: this.fixed(h + d), y: this.fixed(-d)
            }));
            var title = this.node.attributes.get('title');
            if (title) {
                this.adaptor.append(this.element, this.svg('title', {}, [this.adaptor.text(title)]));
            }
            this.addChildren(svg);
        };
        SVGmerror.kind = merror_js_1.MmlMerror.prototype.kind;
        SVGmerror.styles = {
            'g[data-mml-node="merror"] > g': {
                fill: 'red',
                stroke: 'red'
            },
            'g[data-mml-node="merror"] > rect[data-background]': {
                fill: 'yellow',
                stroke: 'none'
            }
        };
        return SVGmerror;
    }(Wrapper_js_1.SVGWrapper));
    exports.SVGmerror = SVGmerror;
},
706: /* mathjax-full/js/core/MmlTree/MmlNodes/merror.js */ function _(require, module, exports, __esModule, __esExport) {
    var __extends = (this && this.__extends) || (function () {
        var extendStatics = function (d, b) {
            extendStatics = Object.setPrototypeOf ||
                ({ __proto__: [] } instanceof Array && function (d, b) { d.__proto__ = b; }) ||
                function (d, b) { for (var p in b)
                    if (Object.prototype.hasOwnProperty.call(b, p))
                        d[p] = b[p]; };
            return extendStatics(d, b);
        };
        return function (d, b) {
            if (typeof b !== "function" && b !== null)
                throw new TypeError("Class extends value " + String(b) + " is not a constructor or null");
            extendStatics(d, b);
            function __() { this.constructor = d; }
            d.prototype = b === null ? Object.create(b) : (__.prototype = b.prototype, new __());
        };
    })();
    var __assign = (this && this.__assign) || function () {
        __assign = Object.assign || function (t) {
            for (var s, i = 1, n = arguments.length; i < n; i++) {
                s = arguments[i];
                for (var p in s)
                    if (Object.prototype.hasOwnProperty.call(s, p))
                        t[p] = s[p];
            }
            return t;
        };
        return __assign.apply(this, arguments);
    };
    __esModule();
    var MmlNode_js_1 = require(639) /* ../MmlNode.js */;
    var MmlMerror = (function (_super) {
        __extends(MmlMerror, _super);
        function MmlMerror() {
            var _this = _super !== null && _super.apply(this, arguments) || this;
            _this.texclass = MmlNode_js_1.TEXCLASS.ORD;
            return _this;
        }
        Object.defineProperty(MmlMerror.prototype, "kind", {
            get: function () {
                return 'merror';
            },
            enumerable: false,
            configurable: true
        });
        Object.defineProperty(MmlMerror.prototype, "arity", {
            get: function () {
                return -1;
            },
            enumerable: false,
            configurable: true
        });
        Object.defineProperty(MmlMerror.prototype, "linebreakContainer", {
            get: function () {
                return true;
            },
            enumerable: false,
            configurable: true
        });
        MmlMerror.defaults = __assign({}, MmlNode_js_1.AbstractMmlNode.defaults);
        return MmlMerror;
    }(MmlNode_js_1.AbstractMmlNode));
    exports.MmlMerror = MmlMerror;
},
707: /* mathjax-full/js/output/svg/Wrappers/mspace.js */ function _(require, module, exports, __esModule, __esExport) {
    var __extends = (this && this.__extends) || (function () {
        var extendStatics = function (d, b) {
            extendStatics = Object.setPrototypeOf ||
                ({ __proto__: [] } instanceof Array && function (d, b) { d.__proto__ = b; }) ||
                function (d, b) { for (var p in b)
                    if (Object.prototype.hasOwnProperty.call(b, p))
                        d[p] = b[p]; };
            return extendStatics(d, b);
        };
        return function (d, b) {
            if (typeof b !== "function" && b !== null)
                throw new TypeError("Class extends value " + String(b) + " is not a constructor or null");
            extendStatics(d, b);
            function __() { this.constructor = d; }
            d.prototype = b === null ? Object.create(b) : (__.prototype = b.prototype, new __());
        };
    })();
    __esModule();
    var Wrapper_js_1 = require(680) /* ../Wrapper.js */;
    var mspace_js_1 = require(708) /* ../../common/Wrappers/mspace.js */;
    var mspace_js_2 = require(709) /* ../../../core/MmlTree/MmlNodes/mspace.js */;
    var SVGmspace = (function (_super) {
        __extends(SVGmspace, _super);
        function SVGmspace() {
            return _super !== null && _super.apply(this, arguments) || this;
        }
        SVGmspace.kind = mspace_js_2.MmlMspace.prototype.kind;
        return SVGmspace;
    }((0, mspace_js_1.CommonMspaceMixin)(Wrapper_js_1.SVGWrapper)));
    exports.SVGmspace = SVGmspace;
},
708: /* mathjax-full/js/output/common/Wrappers/mspace.js */ function _(require, module, exports, __esModule, __esExport) {
    var __extends = (this && this.__extends) || (function () {
        var extendStatics = function (d, b) {
            extendStatics = Object.setPrototypeOf ||
                ({ __proto__: [] } instanceof Array && function (d, b) { d.__proto__ = b; }) ||
                function (d, b) { for (var p in b)
                    if (Object.prototype.hasOwnProperty.call(b, p))
                        d[p] = b[p]; };
            return extendStatics(d, b);
        };
        return function (d, b) {
            if (typeof b !== "function" && b !== null)
                throw new TypeError("Class extends value " + String(b) + " is not a constructor or null");
            extendStatics(d, b);
            function __() { this.constructor = d; }
            d.prototype = b === null ? Object.create(b) : (__.prototype = b.prototype, new __());
        };
    })();
    __esModule();
    function CommonMspaceMixin(Base) {
        return (function (_super) {
            __extends(class_1, _super);
            function class_1() {
                return _super !== null && _super.apply(this, arguments) || this;
            }
            class_1.prototype.computeBBox = function (bbox, _recompute) {
                if (_recompute === void 0) {
                    _recompute = false;
                }
                var attributes = this.node.attributes;
                bbox.w = this.length2em(attributes.get('width'), 0);
                bbox.h = this.length2em(attributes.get('height'), 0);
                bbox.d = this.length2em(attributes.get('depth'), 0);
            };
            class_1.prototype.handleVariant = function () {
            };
            return class_1;
        }(Base));
    }
    exports.CommonMspaceMixin = CommonMspaceMixin;
},
709: /* mathjax-full/js/core/MmlTree/MmlNodes/mspace.js */ function _(require, module, exports, __esModule, __esExport) {
    var __extends = (this && this.__extends) || (function () {
        var extendStatics = function (d, b) {
            extendStatics = Object.setPrototypeOf ||
                ({ __proto__: [] } instanceof Array && function (d, b) { d.__proto__ = b; }) ||
                function (d, b) { for (var p in b)
                    if (Object.prototype.hasOwnProperty.call(b, p))
                        d[p] = b[p]; };
            return extendStatics(d, b);
        };
        return function (d, b) {
            if (typeof b !== "function" && b !== null)
                throw new TypeError("Class extends value " + String(b) + " is not a constructor or null");
            extendStatics(d, b);
            function __() { this.constructor = d; }
            d.prototype = b === null ? Object.create(b) : (__.prototype = b.prototype, new __());
        };
    })();
    var __assign = (this && this.__assign) || function () {
        __assign = Object.assign || function (t) {
            for (var s, i = 1, n = arguments.length; i < n; i++) {
                s = arguments[i];
                for (var p in s)
                    if (Object.prototype.hasOwnProperty.call(s, p))
                        t[p] = s[p];
            }
            return t;
        };
        return __assign.apply(this, arguments);
    };
    __esModule();
    var MmlNode_js_1 = require(639) /* ../MmlNode.js */;
    var MmlMspace = (function (_super) {
        __extends(MmlMspace, _super);
        function MmlMspace() {
            var _this = _super !== null && _super.apply(this, arguments) || this;
            _this.texclass = MmlNode_js_1.TEXCLASS.NONE;
            return _this;
        }
        MmlMspace.prototype.setTeXclass = function (prev) {
            return prev;
        };
        Object.defineProperty(MmlMspace.prototype, "kind", {
            get: function () {
                return 'mspace';
            },
            enumerable: false,
            configurable: true
        });
        Object.defineProperty(MmlMspace.prototype, "arity", {
            get: function () {
                return 0;
            },
            enumerable: false,
            configurable: true
        });
        Object.defineProperty(MmlMspace.prototype, "isSpacelike", {
            get: function () {
                return true;
            },
            enumerable: false,
            configurable: true
        });
        Object.defineProperty(MmlMspace.prototype, "hasNewline", {
            get: function () {
                var attributes = this.attributes;
                return (attributes.getExplicit('width') == null && attributes.getExplicit('height') == null &&
                    attributes.getExplicit('depth') == null && attributes.get('linebreak') === 'newline');
            },
            enumerable: false,
            configurable: true
        });
        MmlMspace.defaults = __assign(__assign({}, MmlNode_js_1.AbstractMmlTokenNode.defaults), { width: '0em', height: '0ex', depth: '0ex', linebreak: 'auto' });
        return MmlMspace;
    }(MmlNode_js_1.AbstractMmlTokenNode));
    exports.MmlMspace = MmlMspace;
},
710: /* mathjax-full/js/output/svg/Wrappers/mpadded.js */ function _(require, module, exports, __esModule, __esExport) {
    var __extends = (this && this.__extends) || (function () {
        var extendStatics = function (d, b) {
            extendStatics = Object.setPrototypeOf ||
                ({ __proto__: [] } instanceof Array && function (d, b) { d.__proto__ = b; }) ||
                function (d, b) { for (var p in b)
                    if (Object.prototype.hasOwnProperty.call(b, p))
                        d[p] = b[p]; };
            return extendStatics(d, b);
        };
        return function (d, b) {
            if (typeof b !== "function" && b !== null)
                throw new TypeError("Class extends value " + String(b) + " is not a constructor or null");
            extendStatics(d, b);
            function __() { this.constructor = d; }
            d.prototype = b === null ? Object.create(b) : (__.prototype = b.prototype, new __());
        };
    })();
    var __read = (this && this.__read) || function (o, n) {
        var m = typeof Symbol === "function" && o[Symbol.iterator];
        if (!m)
            return o;
        var i = m.call(o), r, ar = [], e;
        try {
            while ((n === void 0 || n-- > 0) && !(r = i.next()).done)
                ar.push(r.value);
        }
        catch (error) {
            e = { error: error };
        }
        finally {
            try {
                if (r && !r.done && (m = i["return"]))
                    m.call(i);
            }
            finally {
                if (e)
                    throw e.error;
            }
        }
        return ar;
    };
    __esModule();
    var Wrapper_js_1 = require(680) /* ../Wrapper.js */;
    var mpadded_js_1 = require(711) /* ../../common/Wrappers/mpadded.js */;
    var mpadded_js_2 = require(712) /* ../../../core/MmlTree/MmlNodes/mpadded.js */;
    var SVGmpadded = (function (_super) {
        __extends(SVGmpadded, _super);
        function SVGmpadded() {
            return _super !== null && _super.apply(this, arguments) || this;
        }
        SVGmpadded.prototype.toSVG = function (parent) {
            var svg = this.standardSVGnode(parent);
            var _a = __read(this.getDimens(), 9), dw = _a[5], x = _a[6], y = _a[7], dx = _a[8];
            var align = this.node.attributes.get('data-align') || 'left';
            var X = x + dx - (dw < 0 && align !== 'left' ? align === 'center' ? dw / 2 : dw : 0);
            if (X || y) {
                svg = this.adaptor.append(svg, this.svg('g'));
                this.place(X, y, svg);
            }
            this.addChildren(svg);
        };
        SVGmpadded.kind = mpadded_js_2.MmlMpadded.prototype.kind;
        return SVGmpadded;
    }((0, mpadded_js_1.CommonMpaddedMixin)(Wrapper_js_1.SVGWrapper)));
    exports.SVGmpadded = SVGmpadded;
},
711: /* mathjax-full/js/output/common/Wrappers/mpadded.js */ function _(require, module, exports, __esModule, __esExport) {
    var __extends = (this && this.__extends) || (function () {
        var extendStatics = function (d, b) {
            extendStatics = Object.setPrototypeOf ||
                ({ __proto__: [] } instanceof Array && function (d, b) { d.__proto__ = b; }) ||
                function (d, b) { for (var p in b)
                    if (Object.prototype.hasOwnProperty.call(b, p))
                        d[p] = b[p]; };
            return extendStatics(d, b);
        };
        return function (d, b) {
            if (typeof b !== "function" && b !== null)
                throw new TypeError("Class extends value " + String(b) + " is not a constructor or null");
            extendStatics(d, b);
            function __() { this.constructor = d; }
            d.prototype = b === null ? Object.create(b) : (__.prototype = b.prototype, new __());
        };
    })();
    var __read = (this && this.__read) || function (o, n) {
        var m = typeof Symbol === "function" && o[Symbol.iterator];
        if (!m)
            return o;
        var i = m.call(o), r, ar = [], e;
        try {
            while ((n === void 0 || n-- > 0) && !(r = i.next()).done)
                ar.push(r.value);
        }
        catch (error) {
            e = { error: error };
        }
        finally {
            try {
                if (r && !r.done && (m = i["return"]))
                    m.call(i);
            }
            finally {
                if (e)
                    throw e.error;
            }
        }
        return ar;
    };
    __esModule();
    function CommonMpaddedMixin(Base) {
        return (function (_super) {
            __extends(class_1, _super);
            function class_1() {
                return _super !== null && _super.apply(this, arguments) || this;
            }
            class_1.prototype.getDimens = function () {
                var values = this.node.attributes.getList('width', 'height', 'depth', 'lspace', 'voffset');
                var bbox = this.childNodes[0].getBBox();
                var w = bbox.w, h = bbox.h, d = bbox.d;
                var W = w, H = h, D = d, x = 0, y = 0, dx = 0;
                if (values.width !== '')
                    w = this.dimen(values.width, bbox, 'w', 0);
                if (values.height !== '')
                    h = this.dimen(values.height, bbox, 'h', 0);
                if (values.depth !== '')
                    d = this.dimen(values.depth, bbox, 'd', 0);
                if (values.voffset !== '')
                    y = this.dimen(values.voffset, bbox);
                if (values.lspace !== '')
                    x = this.dimen(values.lspace, bbox);
                var align = this.node.attributes.get('data-align');
                if (align) {
                    dx = this.getAlignX(w, bbox, align);
                }
                return [H, D, W, h - H, d - D, w - W, x, y, dx];
            };
            class_1.prototype.dimen = function (length, bbox, d, m) {
                if (d === void 0) {
                    d = '';
                }
                if (m === void 0) {
                    m = null;
                }
                length = String(length);
                var match = length.match(/width|height|depth/);
                var size = (match ? bbox[match[0].charAt(0)] :
                    (d ? bbox[d] : 0));
                var dimen = (this.length2em(length, size) || 0);
                if (length.match(/^[-+]/) && d) {
                    dimen += size;
                }
                if (m != null) {
                    dimen = Math.max(m, dimen);
                }
                return dimen;
            };
            class_1.prototype.computeBBox = function (bbox, recompute) {
                if (recompute === void 0) {
                    recompute = false;
                }
                var _a = __read(this.getDimens(), 6), H = _a[0], D = _a[1], W = _a[2], dh = _a[3], dd = _a[4], dw = _a[5];
                bbox.w = W + dw;
                bbox.h = H + dh;
                bbox.d = D + dd;
                this.setChildPWidths(recompute, bbox.w);
            };
            class_1.prototype.getWrapWidth = function (_i) {
                return this.getBBox().w;
            };
            class_1.prototype.getChildAlign = function (_i) {
                return this.node.attributes.get('data-align') || 'left';
            };
            return class_1;
        }(Base));
    }
    exports.CommonMpaddedMixin = CommonMpaddedMixin;
},
712: /* mathjax-full/js/core/MmlTree/MmlNodes/mpadded.js */ function _(require, module, exports, __esModule, __esExport) {
    var __extends = (this && this.__extends) || (function () {
        var extendStatics = function (d, b) {
            extendStatics = Object.setPrototypeOf ||
                ({ __proto__: [] } instanceof Array && function (d, b) { d.__proto__ = b; }) ||
                function (d, b) { for (var p in b)
                    if (Object.prototype.hasOwnProperty.call(b, p))
                        d[p] = b[p]; };
            return extendStatics(d, b);
        };
        return function (d, b) {
            if (typeof b !== "function" && b !== null)
                throw new TypeError("Class extends value " + String(b) + " is not a constructor or null");
            extendStatics(d, b);
            function __() { this.constructor = d; }
            d.prototype = b === null ? Object.create(b) : (__.prototype = b.prototype, new __());
        };
    })();
    var __assign = (this && this.__assign) || function () {
        __assign = Object.assign || function (t) {
            for (var s, i = 1, n = arguments.length; i < n; i++) {
                s = arguments[i];
                for (var p in s)
                    if (Object.prototype.hasOwnProperty.call(s, p))
                        t[p] = s[p];
            }
            return t;
        };
        return __assign.apply(this, arguments);
    };
    __esModule();
    var MmlNode_js_1 = require(639) /* ../MmlNode.js */;
    var MmlMpadded = (function (_super) {
        __extends(MmlMpadded, _super);
        function MmlMpadded() {
            return _super !== null && _super.apply(this, arguments) || this;
        }
        Object.defineProperty(MmlMpadded.prototype, "kind", {
            get: function () {
                return 'mpadded';
            },
            enumerable: false,
            configurable: true
        });
        MmlMpadded.defaults = __assign(__assign({}, MmlNode_js_1.AbstractMmlLayoutNode.defaults), { width: '', height: '', depth: '', lspace: 0, voffset: 0 });
        return MmlMpadded;
    }(MmlNode_js_1.AbstractMmlLayoutNode));
    exports.MmlMpadded = MmlMpadded;
},
713: /* mathjax-full/js/output/svg/Wrappers/mphantom.js */ function _(require, module, exports, __esModule, __esExport) {
    var __extends = (this && this.__extends) || (function () {
        var extendStatics = function (d, b) {
            extendStatics = Object.setPrototypeOf ||
                ({ __proto__: [] } instanceof Array && function (d, b) { d.__proto__ = b; }) ||
                function (d, b) { for (var p in b)
                    if (Object.prototype.hasOwnProperty.call(b, p))
                        d[p] = b[p]; };
            return extendStatics(d, b);
        };
        return function (d, b) {
            if (typeof b !== "function" && b !== null)
                throw new TypeError("Class extends value " + String(b) + " is not a constructor or null");
            extendStatics(d, b);
            function __() { this.constructor = d; }
            d.prototype = b === null ? Object.create(b) : (__.prototype = b.prototype, new __());
        };
    })();
    __esModule();
    var Wrapper_js_1 = require(680) /* ../Wrapper.js */;
    var mphantom_js_1 = require(714) /* ../../../core/MmlTree/MmlNodes/mphantom.js */;
    var SVGmphantom = (function (_super) {
        __extends(SVGmphantom, _super);
        function SVGmphantom() {
            return _super !== null && _super.apply(this, arguments) || this;
        }
        SVGmphantom.prototype.toSVG = function (parent) {
            this.standardSVGnode(parent);
        };
        SVGmphantom.kind = mphantom_js_1.MmlMphantom.prototype.kind;
        return SVGmphantom;
    }(Wrapper_js_1.SVGWrapper));
    exports.SVGmphantom = SVGmphantom;
},
714: /* mathjax-full/js/core/MmlTree/MmlNodes/mphantom.js */ function _(require, module, exports, __esModule, __esExport) {
    var __extends = (this && this.__extends) || (function () {
        var extendStatics = function (d, b) {
            extendStatics = Object.setPrototypeOf ||
                ({ __proto__: [] } instanceof Array && function (d, b) { d.__proto__ = b; }) ||
                function (d, b) { for (var p in b)
                    if (Object.prototype.hasOwnProperty.call(b, p))
                        d[p] = b[p]; };
            return extendStatics(d, b);
        };
        return function (d, b) {
            if (typeof b !== "function" && b !== null)
                throw new TypeError("Class extends value " + String(b) + " is not a constructor or null");
            extendStatics(d, b);
            function __() { this.constructor = d; }
            d.prototype = b === null ? Object.create(b) : (__.prototype = b.prototype, new __());
        };
    })();
    var __assign = (this && this.__assign) || function () {
        __assign = Object.assign || function (t) {
            for (var s, i = 1, n = arguments.length; i < n; i++) {
                s = arguments[i];
                for (var p in s)
                    if (Object.prototype.hasOwnProperty.call(s, p))
                        t[p] = s[p];
            }
            return t;
        };
        return __assign.apply(this, arguments);
    };
    __esModule();
    var MmlNode_js_1 = require(639) /* ../MmlNode.js */;
    var MmlMphantom = (function (_super) {
        __extends(MmlMphantom, _super);
        function MmlMphantom() {
            var _this = _super !== null && _super.apply(this, arguments) || this;
            _this.texclass = MmlNode_js_1.TEXCLASS.ORD;
            return _this;
        }
        Object.defineProperty(MmlMphantom.prototype, "kind", {
            get: function () {
                return 'mphantom';
            },
            enumerable: false,
            configurable: true
        });
        MmlMphantom.defaults = __assign({}, MmlNode_js_1.AbstractMmlLayoutNode.defaults);
        return MmlMphantom;
    }(MmlNode_js_1.AbstractMmlLayoutNode));
    exports.MmlMphantom = MmlMphantom;
},
715: /* mathjax-full/js/output/svg/Wrappers/mfrac.js */ function _(require, module, exports, __esModule, __esExport) {
    var __extends = (this && this.__extends) || (function () {
        var extendStatics = function (d, b) {
            extendStatics = Object.setPrototypeOf ||
                ({ __proto__: [] } instanceof Array && function (d, b) { d.__proto__ = b; }) ||
                function (d, b) { for (var p in b)
                    if (Object.prototype.hasOwnProperty.call(b, p))
                        d[p] = b[p]; };
            return extendStatics(d, b);
        };
        return function (d, b) {
            if (typeof b !== "function" && b !== null)
                throw new TypeError("Class extends value " + String(b) + " is not a constructor or null");
            extendStatics(d, b);
            function __() { this.constructor = d; }
            d.prototype = b === null ? Object.create(b) : (__.prototype = b.prototype, new __());
        };
    })();
    var __read = (this && this.__read) || function (o, n) {
        var m = typeof Symbol === "function" && o[Symbol.iterator];
        if (!m)
            return o;
        var i = m.call(o), r, ar = [], e;
        try {
            while ((n === void 0 || n-- > 0) && !(r = i.next()).done)
                ar.push(r.value);
        }
        catch (error) {
            e = { error: error };
        }
        finally {
            try {
                if (r && !r.done && (m = i["return"]))
                    m.call(i);
            }
            finally {
                if (e)
                    throw e.error;
            }
        }
        return ar;
    };
    __esModule();
    var Wrapper_js_1 = require(680) /* ../Wrapper.js */;
    var mfrac_js_1 = require(716) /* ../../common/Wrappers/mfrac.js */;
    var mfrac_js_2 = require(717) /* ../../../core/MmlTree/MmlNodes/mfrac.js */;
    var SVGmfrac = (function (_super) {
        __extends(SVGmfrac, _super);
        function SVGmfrac() {
            return _super !== null && _super.apply(this, arguments) || this;
        }
        SVGmfrac.prototype.toSVG = function (parent) {
            this.standardSVGnode(parent);
            var _a = this.node.attributes.getList('linethickness', 'bevelled'), linethickness = _a.linethickness, bevelled = _a.bevelled;
            var display = this.isDisplay();
            if (bevelled) {
                this.makeBevelled(display);
            }
            else {
                var thickness = this.length2em(String(linethickness), .06);
                if (thickness === 0) {
                    this.makeAtop(display);
                }
                else {
                    this.makeFraction(display, thickness);
                }
            }
        };
        SVGmfrac.prototype.makeFraction = function (display, t) {
            var svg = this.element;
            var _a = this.node.attributes.getList('numalign', 'denomalign'), numalign = _a.numalign, denomalign = _a.denomalign;
            var _b = __read(this.childNodes, 2), num = _b[0], den = _b[1];
            var nbox = num.getOuterBBox();
            var dbox = den.getOuterBBox();
            var tex = this.font.params;
            var a = tex.axis_height;
            var d = .1;
            var pad = (this.node.getProperty('withDelims') ? 0 : tex.nulldelimiterspace);
            var W = Math.max((nbox.L + nbox.w + nbox.R) * nbox.rscale, (dbox.L + dbox.w + dbox.R) * dbox.rscale);
            var nx = this.getAlignX(W, nbox, numalign) + d + pad;
            var dx = this.getAlignX(W, dbox, denomalign) + d + pad;
            var _c = this.getTUV(display, t), T = _c.T, u = _c.u, v = _c.v;
            num.toSVG(svg);
            num.place(nx, a + T + Math.max(nbox.d * nbox.rscale, u));
            den.toSVG(svg);
            den.place(dx, a - T - Math.max(dbox.h * dbox.rscale, v));
            this.adaptor.append(svg, this.svg('rect', {
                width: this.fixed(W + 2 * d), height: this.fixed(t),
                x: this.fixed(pad), y: this.fixed(a - t / 2)
            }));
        };
        SVGmfrac.prototype.makeAtop = function (display) {
            var svg = this.element;
            var _a = this.node.attributes.getList('numalign', 'denomalign'), numalign = _a.numalign, denomalign = _a.denomalign;
            var _b = __read(this.childNodes, 2), num = _b[0], den = _b[1];
            var nbox = num.getOuterBBox();
            var dbox = den.getOuterBBox();
            var tex = this.font.params;
            var pad = (this.node.getProperty('withDelims') ? 0 : tex.nulldelimiterspace);
            var W = Math.max((nbox.L + nbox.w + nbox.R) * nbox.rscale, (dbox.L + dbox.w + dbox.R) * dbox.rscale);
            var nx = this.getAlignX(W, nbox, numalign) + pad;
            var dx = this.getAlignX(W, dbox, denomalign) + pad;
            var _c = this.getUVQ(display), u = _c.u, v = _c.v;
            num.toSVG(svg);
            num.place(nx, u);
            den.toSVG(svg);
            den.place(dx, -v);
        };
        SVGmfrac.prototype.makeBevelled = function (display) {
            var svg = this.element;
            var _a = __read(this.childNodes, 2), num = _a[0], den = _a[1];
            var _b = this.getBevelData(display), u = _b.u, v = _b.v, delta = _b.delta, nbox = _b.nbox, dbox = _b.dbox;
            var w = (nbox.L + nbox.w + nbox.R) * nbox.rscale;
            num.toSVG(svg);
            this.bevel.toSVG(svg);
            den.toSVG(svg);
            num.place(nbox.L * nbox.rscale, u);
            this.bevel.place(w - delta / 2, 0);
            den.place(w + this.bevel.getOuterBBox().w + dbox.L * dbox.rscale - delta, v);
        };
        SVGmfrac.kind = mfrac_js_2.MmlMfrac.prototype.kind;
        return SVGmfrac;
    }((0, mfrac_js_1.CommonMfracMixin)(Wrapper_js_1.SVGWrapper)));
    exports.SVGmfrac = SVGmfrac;
},
716: /* mathjax-full/js/output/common/Wrappers/mfrac.js */ function _(require, module, exports, __esModule, __esExport) {
    var __extends = (this && this.__extends) || (function () {
        var extendStatics = function (d, b) {
            extendStatics = Object.setPrototypeOf ||
                ({ __proto__: [] } instanceof Array && function (d, b) { d.__proto__ = b; }) ||
                function (d, b) { for (var p in b)
                    if (Object.prototype.hasOwnProperty.call(b, p))
                        d[p] = b[p]; };
            return extendStatics(d, b);
        };
        return function (d, b) {
            if (typeof b !== "function" && b !== null)
                throw new TypeError("Class extends value " + String(b) + " is not a constructor or null");
            extendStatics(d, b);
            function __() { this.constructor = d; }
            d.prototype = b === null ? Object.create(b) : (__.prototype = b.prototype, new __());
        };
    })();
    var __read = (this && this.__read) || function (o, n) {
        var m = typeof Symbol === "function" && o[Symbol.iterator];
        if (!m)
            return o;
        var i = m.call(o), r, ar = [], e;
        try {
            while ((n === void 0 || n-- > 0) && !(r = i.next()).done)
                ar.push(r.value);
        }
        catch (error) {
            e = { error: error };
        }
        finally {
            try {
                if (r && !r.done && (m = i["return"]))
                    m.call(i);
            }
            finally {
                if (e)
                    throw e.error;
            }
        }
        return ar;
    };
    var __spreadArray = (this && this.__spreadArray) || function (to, from, pack) {
        if (pack || arguments.length === 2)
            for (var i = 0, l = from.length, ar; i < l; i++) {
                if (ar || !(i in from)) {
                    if (!ar)
                        ar = Array.prototype.slice.call(from, 0, i);
                    ar[i] = from[i];
                }
            }
        return to.concat(ar || Array.prototype.slice.call(from));
    };
    __esModule();
    function CommonMfracMixin(Base) {
        return (function (_super) {
            __extends(class_1, _super);
            function class_1() {
                var args = [];
                for (var _i = 0; _i < arguments.length; _i++) {
                    args[_i] = arguments[_i];
                }
                var _this = _super.apply(this, __spreadArray([], __read(args), false)) || this;
                _this.bevel = null;
                _this.pad = (_this.node.getProperty('withDelims') ? 0 : _this.font.params.nulldelimiterspace);
                if (_this.node.attributes.get('bevelled')) {
                    var H = _this.getBevelData(_this.isDisplay()).H;
                    var bevel = _this.bevel = _this.createMo('/');
                    bevel.node.attributes.set('symmetric', true);
                    bevel.canStretch(1);
                    bevel.getStretchedVariant([H], true);
                }
                return _this;
            }
            class_1.prototype.computeBBox = function (bbox, recompute) {
                if (recompute === void 0) {
                    recompute = false;
                }
                bbox.empty();
                var _a = this.node.attributes.getList('linethickness', 'bevelled'), linethickness = _a.linethickness, bevelled = _a.bevelled;
                var display = this.isDisplay();
                var w = null;
                if (bevelled) {
                    this.getBevelledBBox(bbox, display);
                }
                else {
                    var thickness = this.length2em(String(linethickness), .06);
                    w = -2 * this.pad;
                    if (thickness === 0) {
                        this.getAtopBBox(bbox, display);
                    }
                    else {
                        this.getFractionBBox(bbox, display, thickness);
                        w -= .2;
                    }
                    w += bbox.w;
                }
                bbox.clean();
                this.setChildPWidths(recompute, w);
            };
            class_1.prototype.getFractionBBox = function (bbox, display, t) {
                var nbox = this.childNodes[0].getOuterBBox();
                var dbox = this.childNodes[1].getOuterBBox();
                var tex = this.font.params;
                var a = tex.axis_height;
                var _a = this.getTUV(display, t), T = _a.T, u = _a.u, v = _a.v;
                bbox.combine(nbox, 0, a + T + Math.max(nbox.d * nbox.rscale, u));
                bbox.combine(dbox, 0, a - T - Math.max(dbox.h * dbox.rscale, v));
                bbox.w += 2 * this.pad + .2;
            };
            class_1.prototype.getTUV = function (display, t) {
                var tex = this.font.params;
                var a = tex.axis_height;
                var T = (display ? 3.5 : 1.5) * t;
                return { T: (display ? 3.5 : 1.5) * t,
                    u: (display ? tex.num1 : tex.num2) - a - T,
                    v: (display ? tex.denom1 : tex.denom2) + a - T };
            };
            class_1.prototype.getAtopBBox = function (bbox, display) {
                var _a = this.getUVQ(display), u = _a.u, v = _a.v, nbox = _a.nbox, dbox = _a.dbox;
                bbox.combine(nbox, 0, u);
                bbox.combine(dbox, 0, -v);
                bbox.w += 2 * this.pad;
            };
            class_1.prototype.getUVQ = function (display) {
                var nbox = this.childNodes[0].getOuterBBox();
                var dbox = this.childNodes[1].getOuterBBox();
                var tex = this.font.params;
                var _a = __read((display ? [tex.num1, tex.denom1] : [tex.num3, tex.denom2]), 2), u = _a[0], v = _a[1];
                var p = (display ? 7 : 3) * tex.rule_thickness;
                var q = (u - nbox.d * nbox.scale) - (dbox.h * dbox.scale - v);
                if (q < p) {
                    u += (p - q) / 2;
                    v += (p - q) / 2;
                    q = p;
                }
                return { u: u, v: v, q: q, nbox: nbox, dbox: dbox };
            };
            class_1.prototype.getBevelledBBox = function (bbox, display) {
                var _a = this.getBevelData(display), u = _a.u, v = _a.v, delta = _a.delta, nbox = _a.nbox, dbox = _a.dbox;
                var lbox = this.bevel.getOuterBBox();
                bbox.combine(nbox, 0, u);
                bbox.combine(lbox, bbox.w - delta / 2, 0);
                bbox.combine(dbox, bbox.w - delta / 2, v);
            };
            class_1.prototype.getBevelData = function (display) {
                var nbox = this.childNodes[0].getOuterBBox();
                var dbox = this.childNodes[1].getOuterBBox();
                var delta = (display ? .4 : .15);
                var H = Math.max(nbox.scale * (nbox.h + nbox.d), dbox.scale * (dbox.h + dbox.d)) + 2 * delta;
                var a = this.font.params.axis_height;
                var u = nbox.scale * (nbox.d - nbox.h) / 2 + a + delta;
                var v = dbox.scale * (dbox.d - dbox.h) / 2 + a - delta;
                return { H: H, delta: delta, u: u, v: v, nbox: nbox, dbox: dbox };
            };
            class_1.prototype.canStretch = function (_direction) {
                return false;
            };
            class_1.prototype.isDisplay = function () {
                var _a = this.node.attributes.getList('displaystyle', 'scriptlevel'), displaystyle = _a.displaystyle, scriptlevel = _a.scriptlevel;
                return displaystyle && scriptlevel === 0;
            };
            class_1.prototype.getWrapWidth = function (i) {
                var attributes = this.node.attributes;
                if (attributes.get('bevelled')) {
                    return this.childNodes[i].getOuterBBox().w;
                }
                var w = this.getBBox().w;
                var thickness = this.length2em(attributes.get('linethickness'));
                return w - (thickness ? .2 : 0) - 2 * this.pad;
            };
            class_1.prototype.getChildAlign = function (i) {
                var attributes = this.node.attributes;
                return (attributes.get('bevelled') ? 'left' : attributes.get(['numalign', 'denomalign'][i]));
            };
            return class_1;
        }(Base));
    }
    exports.CommonMfracMixin = CommonMfracMixin;
},
717: /* mathjax-full/js/core/MmlTree/MmlNodes/mfrac.js */ function _(require, module, exports, __esModule, __esExport) {
    var __extends = (this && this.__extends) || (function () {
        var extendStatics = function (d, b) {
            extendStatics = Object.setPrototypeOf ||
                ({ __proto__: [] } instanceof Array && function (d, b) { d.__proto__ = b; }) ||
                function (d, b) { for (var p in b)
                    if (Object.prototype.hasOwnProperty.call(b, p))
                        d[p] = b[p]; };
            return extendStatics(d, b);
        };
        return function (d, b) {
            if (typeof b !== "function" && b !== null)
                throw new TypeError("Class extends value " + String(b) + " is not a constructor or null");
            extendStatics(d, b);
            function __() { this.constructor = d; }
            d.prototype = b === null ? Object.create(b) : (__.prototype = b.prototype, new __());
        };
    })();
    var __assign = (this && this.__assign) || function () {
        __assign = Object.assign || function (t) {
            for (var s, i = 1, n = arguments.length; i < n; i++) {
                s = arguments[i];
                for (var p in s)
                    if (Object.prototype.hasOwnProperty.call(s, p))
                        t[p] = s[p];
            }
            return t;
        };
        return __assign.apply(this, arguments);
    };
    var __values = (this && this.__values) || function (o) {
        var s = typeof Symbol === "function" && Symbol.iterator, m = s && o[s], i = 0;
        if (m)
            return m.call(o);
        if (o && typeof o.length === "number")
            return {
                next: function () {
                    if (o && i >= o.length)
                        o = void 0;
                    return { value: o && o[i++], done: !o };
                }
            };
        throw new TypeError(s ? "Object is not iterable." : "Symbol.iterator is not defined.");
    };
    __esModule();
    var MmlNode_js_1 = require(639) /* ../MmlNode.js */;
    var MmlMfrac = (function (_super) {
        __extends(MmlMfrac, _super);
        function MmlMfrac() {
            return _super !== null && _super.apply(this, arguments) || this;
        }
        Object.defineProperty(MmlMfrac.prototype, "kind", {
            get: function () {
                return 'mfrac';
            },
            enumerable: false,
            configurable: true
        });
        Object.defineProperty(MmlMfrac.prototype, "arity", {
            get: function () {
                return 2;
            },
            enumerable: false,
            configurable: true
        });
        Object.defineProperty(MmlMfrac.prototype, "linebreakContainer", {
            get: function () {
                return true;
            },
            enumerable: false,
            configurable: true
        });
        MmlMfrac.prototype.setTeXclass = function (prev) {
            var e_1, _a;
            this.getPrevClass(prev);
            try {
                for (var _b = __values(this.childNodes), _c = _b.next(); !_c.done; _c = _b.next()) {
                    var child = _c.value;
                    child.setTeXclass(null);
                }
            }
            catch (e_1_1) {
                e_1 = { error: e_1_1 };
            }
            finally {
                try {
                    if (_c && !_c.done && (_a = _b.return))
                        _a.call(_b);
                }
                finally {
                    if (e_1)
                        throw e_1.error;
                }
            }
            return this;
        };
        MmlMfrac.prototype.setChildInheritedAttributes = function (attributes, display, level, prime) {
            if (!display || level > 0) {
                level++;
            }
            this.childNodes[0].setInheritedAttributes(attributes, false, level, prime);
            this.childNodes[1].setInheritedAttributes(attributes, false, level, true);
        };
        MmlMfrac.defaults = __assign(__assign({}, MmlNode_js_1.AbstractMmlBaseNode.defaults), { linethickness: 'medium', numalign: 'center', denomalign: 'center', bevelled: false });
        return MmlMfrac;
    }(MmlNode_js_1.AbstractMmlBaseNode));
    exports.MmlMfrac = MmlMfrac;
},
718: /* mathjax-full/js/output/svg/Wrappers/msqrt.js */ function _(require, module, exports, __esModule, __esExport) {
    var __extends = (this && this.__extends) || (function () {
        var extendStatics = function (d, b) {
            extendStatics = Object.setPrototypeOf ||
                ({ __proto__: [] } instanceof Array && function (d, b) { d.__proto__ = b; }) ||
                function (d, b) { for (var p in b)
                    if (Object.prototype.hasOwnProperty.call(b, p))
                        d[p] = b[p]; };
            return extendStatics(d, b);
        };
        return function (d, b) {
            if (typeof b !== "function" && b !== null)
                throw new TypeError("Class extends value " + String(b) + " is not a constructor or null");
            extendStatics(d, b);
            function __() { this.constructor = d; }
            d.prototype = b === null ? Object.create(b) : (__.prototype = b.prototype, new __());
        };
    })();
    __esModule();
    var Wrapper_js_1 = require(680) /* ../Wrapper.js */;
    var msqrt_js_1 = require(719) /* ../../common/Wrappers/msqrt.js */;
    var msqrt_js_2 = require(720) /* ../../../core/MmlTree/MmlNodes/msqrt.js */;
    var SVGmsqrt = (function (_super) {
        __extends(SVGmsqrt, _super);
        function SVGmsqrt() {
            var _this = _super !== null && _super.apply(this, arguments) || this;
            _this.dx = 0;
            return _this;
        }
        SVGmsqrt.prototype.toSVG = function (parent) {
            var surd = this.childNodes[this.surd];
            var base = this.childNodes[this.base];
            var root = (this.root ? this.childNodes[this.root] : null);
            var sbox = surd.getBBox();
            var bbox = base.getOuterBBox();
            var q = this.getPQ(sbox)[1];
            var t = this.font.params.rule_thickness * this.bbox.scale;
            var H = bbox.h + q + t;
            var SVG = this.standardSVGnode(parent);
            var BASE = this.adaptor.append(SVG, this.svg('g'));
            this.addRoot(SVG, root, sbox, H);
            surd.toSVG(SVG);
            surd.place(this.dx, H - sbox.h);
            base.toSVG(BASE);
            base.place(this.dx + sbox.w, 0);
            this.adaptor.append(SVG, this.svg('rect', {
                width: this.fixed(bbox.w), height: this.fixed(t),
                x: this.fixed(this.dx + sbox.w), y: this.fixed(H - t)
            }));
        };
        SVGmsqrt.prototype.addRoot = function (_ROOT, _root, _sbox, _H) {
        };
        SVGmsqrt.kind = msqrt_js_2.MmlMsqrt.prototype.kind;
        return SVGmsqrt;
    }((0, msqrt_js_1.CommonMsqrtMixin)(Wrapper_js_1.SVGWrapper)));
    exports.SVGmsqrt = SVGmsqrt;
},
719: /* mathjax-full/js/output/common/Wrappers/msqrt.js */ function _(require, module, exports, __esModule, __esExport) {
    var __extends = (this && this.__extends) || (function () {
        var extendStatics = function (d, b) {
            extendStatics = Object.setPrototypeOf ||
                ({ __proto__: [] } instanceof Array && function (d, b) { d.__proto__ = b; }) ||
                function (d, b) { for (var p in b)
                    if (Object.prototype.hasOwnProperty.call(b, p))
                        d[p] = b[p]; };
            return extendStatics(d, b);
        };
        return function (d, b) {
            if (typeof b !== "function" && b !== null)
                throw new TypeError("Class extends value " + String(b) + " is not a constructor or null");
            extendStatics(d, b);
            function __() { this.constructor = d; }
            d.prototype = b === null ? Object.create(b) : (__.prototype = b.prototype, new __());
        };
    })();
    var __read = (this && this.__read) || function (o, n) {
        var m = typeof Symbol === "function" && o[Symbol.iterator];
        if (!m)
            return o;
        var i = m.call(o), r, ar = [], e;
        try {
            while ((n === void 0 || n-- > 0) && !(r = i.next()).done)
                ar.push(r.value);
        }
        catch (error) {
            e = { error: error };
        }
        finally {
            try {
                if (r && !r.done && (m = i["return"]))
                    m.call(i);
            }
            finally {
                if (e)
                    throw e.error;
            }
        }
        return ar;
    };
    var __spreadArray = (this && this.__spreadArray) || function (to, from, pack) {
        if (pack || arguments.length === 2)
            for (var i = 0, l = from.length, ar; i < l; i++) {
                if (ar || !(i in from)) {
                    if (!ar)
                        ar = Array.prototype.slice.call(from, 0, i);
                    ar[i] = from[i];
                }
            }
        return to.concat(ar || Array.prototype.slice.call(from));
    };
    __esModule();
    var BBox_js_1 = require(681) /* ../../../util/BBox.js */;
    function CommonMsqrtMixin(Base) {
        return (function (_super) {
            __extends(class_1, _super);
            function class_1() {
                var args = [];
                for (var _i = 0; _i < arguments.length; _i++) {
                    args[_i] = arguments[_i];
                }
                var _this = _super.apply(this, __spreadArray([], __read(args), false)) || this;
                var surd = _this.createMo('\u221A');
                surd.canStretch(1);
                var _a = _this.childNodes[_this.base].getOuterBBox(), h = _a.h, d = _a.d;
                var t = _this.font.params.rule_thickness;
                var p = (_this.node.attributes.get('displaystyle') ? _this.font.params.x_height : t);
                _this.surdH = h + d + 2 * t + p / 4;
                surd.getStretchedVariant([_this.surdH - d, d], true);
                return _this;
            }
            Object.defineProperty(class_1.prototype, "base", {
                get: function () {
                    return 0;
                },
                enumerable: false,
                configurable: true
            });
            Object.defineProperty(class_1.prototype, "surd", {
                get: function () {
                    return 1;
                },
                enumerable: false,
                configurable: true
            });
            Object.defineProperty(class_1.prototype, "root", {
                get: function () {
                    return null;
                },
                enumerable: false,
                configurable: true
            });
            class_1.prototype.createMo = function (text) {
                var node = _super.prototype.createMo.call(this, text);
                this.childNodes.push(node);
                return node;
            };
            class_1.prototype.computeBBox = function (bbox, recompute) {
                if (recompute === void 0) {
                    recompute = false;
                }
                var surdbox = this.childNodes[this.surd].getBBox();
                var basebox = new BBox_js_1.BBox(this.childNodes[this.base].getOuterBBox());
                var q = this.getPQ(surdbox)[1];
                var t = this.font.params.rule_thickness;
                var H = basebox.h + q + t;
                var _a = __read(this.getRootDimens(surdbox, H), 1), x = _a[0];
                bbox.h = H + t;
                this.combineRootBBox(bbox, surdbox, H);
                bbox.combine(surdbox, x, H - surdbox.h);
                bbox.combine(basebox, x + surdbox.w, 0);
                bbox.clean();
                this.setChildPWidths(recompute);
            };
            class_1.prototype.combineRootBBox = function (_bbox, _sbox, _H) {
            };
            class_1.prototype.getPQ = function (sbox) {
                var t = this.font.params.rule_thickness;
                var p = (this.node.attributes.get('displaystyle') ? this.font.params.x_height : t);
                var q = (sbox.h + sbox.d > this.surdH ?
                    ((sbox.h + sbox.d) - (this.surdH - 2 * t - p / 2)) / 2 :
                    t + p / 4);
                return [p, q];
            };
            class_1.prototype.getRootDimens = function (_sbox, _H) {
                return [0, 0, 0, 0];
            };
            return class_1;
        }(Base));
    }
    exports.CommonMsqrtMixin = CommonMsqrtMixin;
},
720: /* mathjax-full/js/core/MmlTree/MmlNodes/msqrt.js */ function _(require, module, exports, __esModule, __esExport) {
    var __extends = (this && this.__extends) || (function () {
        var extendStatics = function (d, b) {
            extendStatics = Object.setPrototypeOf ||
                ({ __proto__: [] } instanceof Array && function (d, b) { d.__proto__ = b; }) ||
                function (d, b) { for (var p in b)
                    if (Object.prototype.hasOwnProperty.call(b, p))
                        d[p] = b[p]; };
            return extendStatics(d, b);
        };
        return function (d, b) {
            if (typeof b !== "function" && b !== null)
                throw new TypeError("Class extends value " + String(b) + " is not a constructor or null");
            extendStatics(d, b);
            function __() { this.constructor = d; }
            d.prototype = b === null ? Object.create(b) : (__.prototype = b.prototype, new __());
        };
    })();
    var __assign = (this && this.__assign) || function () {
        __assign = Object.assign || function (t) {
            for (var s, i = 1, n = arguments.length; i < n; i++) {
                s = arguments[i];
                for (var p in s)
                    if (Object.prototype.hasOwnProperty.call(s, p))
                        t[p] = s[p];
            }
            return t;
        };
        return __assign.apply(this, arguments);
    };
    __esModule();
    var MmlNode_js_1 = require(639) /* ../MmlNode.js */;
    var MmlMsqrt = (function (_super) {
        __extends(MmlMsqrt, _super);
        function MmlMsqrt() {
            var _this = _super !== null && _super.apply(this, arguments) || this;
            _this.texclass = MmlNode_js_1.TEXCLASS.ORD;
            return _this;
        }
        Object.defineProperty(MmlMsqrt.prototype, "kind", {
            get: function () {
                return 'msqrt';
            },
            enumerable: false,
            configurable: true
        });
        Object.defineProperty(MmlMsqrt.prototype, "arity", {
            get: function () {
                return -1;
            },
            enumerable: false,
            configurable: true
        });
        Object.defineProperty(MmlMsqrt.prototype, "linebreakContainer", {
            get: function () {
                return true;
            },
            enumerable: false,
            configurable: true
        });
        MmlMsqrt.prototype.setTeXclass = function (prev) {
            this.getPrevClass(prev);
            this.childNodes[0].setTeXclass(null);
            return this;
        };
        MmlMsqrt.prototype.setChildInheritedAttributes = function (attributes, display, level, _prime) {
            this.childNodes[0].setInheritedAttributes(attributes, display, level, true);
        };
        MmlMsqrt.defaults = __assign({}, MmlNode_js_1.AbstractMmlNode.defaults);
        return MmlMsqrt;
    }(MmlNode_js_1.AbstractMmlNode));
    exports.MmlMsqrt = MmlMsqrt;
},
721: /* mathjax-full/js/output/svg/Wrappers/mroot.js */ function _(require, module, exports, __esModule, __esExport) {
    var __extends = (this && this.__extends) || (function () {
        var extendStatics = function (d, b) {
            extendStatics = Object.setPrototypeOf ||
                ({ __proto__: [] } instanceof Array && function (d, b) { d.__proto__ = b; }) ||
                function (d, b) { for (var p in b)
                    if (Object.prototype.hasOwnProperty.call(b, p))
                        d[p] = b[p]; };
            return extendStatics(d, b);
        };
        return function (d, b) {
            if (typeof b !== "function" && b !== null)
                throw new TypeError("Class extends value " + String(b) + " is not a constructor or null");
            extendStatics(d, b);
            function __() { this.constructor = d; }
            d.prototype = b === null ? Object.create(b) : (__.prototype = b.prototype, new __());
        };
    })();
    var __read = (this && this.__read) || function (o, n) {
        var m = typeof Symbol === "function" && o[Symbol.iterator];
        if (!m)
            return o;
        var i = m.call(o), r, ar = [], e;
        try {
            while ((n === void 0 || n-- > 0) && !(r = i.next()).done)
                ar.push(r.value);
        }
        catch (error) {
            e = { error: error };
        }
        finally {
            try {
                if (r && !r.done && (m = i["return"]))
                    m.call(i);
            }
            finally {
                if (e)
                    throw e.error;
            }
        }
        return ar;
    };
    __esModule();
    var msqrt_js_1 = require(718) /* ./msqrt.js */;
    var mroot_js_1 = require(722) /* ../../common/Wrappers/mroot.js */;
    var mroot_js_2 = require(723) /* ../../../core/MmlTree/MmlNodes/mroot.js */;
    var SVGmroot = (function (_super) {
        __extends(SVGmroot, _super);
        function SVGmroot() {
            return _super !== null && _super.apply(this, arguments) || this;
        }
        SVGmroot.prototype.addRoot = function (ROOT, root, sbox, H) {
            root.toSVG(ROOT);
            var _a = __read(this.getRootDimens(sbox, H), 3), x = _a[0], h = _a[1], dx = _a[2];
            var bbox = root.getOuterBBox();
            root.place(dx * bbox.rscale, h);
            this.dx = x;
        };
        SVGmroot.kind = mroot_js_2.MmlMroot.prototype.kind;
        return SVGmroot;
    }((0, mroot_js_1.CommonMrootMixin)(msqrt_js_1.SVGmsqrt)));
    exports.SVGmroot = SVGmroot;
},
722: /* mathjax-full/js/output/common/Wrappers/mroot.js */ function _(require, module, exports, __esModule, __esExport) {
    var __extends = (this && this.__extends) || (function () {
        var extendStatics = function (d, b) {
            extendStatics = Object.setPrototypeOf ||
                ({ __proto__: [] } instanceof Array && function (d, b) { d.__proto__ = b; }) ||
                function (d, b) { for (var p in b)
                    if (Object.prototype.hasOwnProperty.call(b, p))
                        d[p] = b[p]; };
            return extendStatics(d, b);
        };
        return function (d, b) {
            if (typeof b !== "function" && b !== null)
                throw new TypeError("Class extends value " + String(b) + " is not a constructor or null");
            extendStatics(d, b);
            function __() { this.constructor = d; }
            d.prototype = b === null ? Object.create(b) : (__.prototype = b.prototype, new __());
        };
    })();
    __esModule();
    function CommonMrootMixin(Base) {
        return (function (_super) {
            __extends(class_1, _super);
            function class_1() {
                return _super !== null && _super.apply(this, arguments) || this;
            }
            Object.defineProperty(class_1.prototype, "surd", {
                get: function () {
                    return 2;
                },
                enumerable: false,
                configurable: true
            });
            Object.defineProperty(class_1.prototype, "root", {
                get: function () {
                    return 1;
                },
                enumerable: false,
                configurable: true
            });
            class_1.prototype.combineRootBBox = function (BBOX, sbox, H) {
                var bbox = this.childNodes[this.root].getOuterBBox();
                var h = this.getRootDimens(sbox, H)[1];
                BBOX.combine(bbox, 0, h);
            };
            class_1.prototype.getRootDimens = function (sbox, H) {
                var surd = this.childNodes[this.surd];
                var bbox = this.childNodes[this.root].getOuterBBox();
                var offset = (surd.size < 0 ? .5 : .6) * sbox.w;
                var w = bbox.w, rscale = bbox.rscale;
                var W = Math.max(w, offset / rscale);
                var dx = Math.max(0, W - w);
                var h = this.rootHeight(bbox, sbox, surd.size, H);
                var x = W * rscale - offset;
                return [x, h, dx];
            };
            class_1.prototype.rootHeight = function (rbox, sbox, size, H) {
                var h = sbox.h + sbox.d;
                var b = (size < 0 ? 1.9 : .55 * h) - (h - H);
                return b + Math.max(0, rbox.d * rbox.rscale);
            };
            return class_1;
        }(Base));
    }
    exports.CommonMrootMixin = CommonMrootMixin;
},
723: /* mathjax-full/js/core/MmlTree/MmlNodes/mroot.js */ function _(require, module, exports, __esModule, __esExport) {
    var __extends = (this && this.__extends) || (function () {
        var extendStatics = function (d, b) {
            extendStatics = Object.setPrototypeOf ||
                ({ __proto__: [] } instanceof Array && function (d, b) { d.__proto__ = b; }) ||
                function (d, b) { for (var p in b)
                    if (Object.prototype.hasOwnProperty.call(b, p))
                        d[p] = b[p]; };
            return extendStatics(d, b);
        };
        return function (d, b) {
            if (typeof b !== "function" && b !== null)
                throw new TypeError("Class extends value " + String(b) + " is not a constructor or null");
            extendStatics(d, b);
            function __() { this.constructor = d; }
            d.prototype = b === null ? Object.create(b) : (__.prototype = b.prototype, new __());
        };
    })();
    var __assign = (this && this.__assign) || function () {
        __assign = Object.assign || function (t) {
            for (var s, i = 1, n = arguments.length; i < n; i++) {
                s = arguments[i];
                for (var p in s)
                    if (Object.prototype.hasOwnProperty.call(s, p))
                        t[p] = s[p];
            }
            return t;
        };
        return __assign.apply(this, arguments);
    };
    __esModule();
    var MmlNode_js_1 = require(639) /* ../MmlNode.js */;
    var MmlMroot = (function (_super) {
        __extends(MmlMroot, _super);
        function MmlMroot() {
            var _this = _super !== null && _super.apply(this, arguments) || this;
            _this.texclass = MmlNode_js_1.TEXCLASS.ORD;
            return _this;
        }
        Object.defineProperty(MmlMroot.prototype, "kind", {
            get: function () {
                return 'mroot';
            },
            enumerable: false,
            configurable: true
        });
        Object.defineProperty(MmlMroot.prototype, "arity", {
            get: function () {
                return 2;
            },
            enumerable: false,
            configurable: true
        });
        MmlMroot.prototype.setTeXclass = function (prev) {
            this.getPrevClass(prev);
            this.childNodes[0].setTeXclass(null);
            this.childNodes[1].setTeXclass(null);
            return this;
        };
        MmlMroot.prototype.setChildInheritedAttributes = function (attributes, display, level, prime) {
            this.childNodes[0].setInheritedAttributes(attributes, display, level, true);
            this.childNodes[1].setInheritedAttributes(attributes, false, level + 2, prime);
        };
        MmlMroot.defaults = __assign({}, MmlNode_js_1.AbstractMmlNode.defaults);
        return MmlMroot;
    }(MmlNode_js_1.AbstractMmlNode));
    exports.MmlMroot = MmlMroot;
},
724: /* mathjax-full/js/output/svg/Wrappers/mfenced.js */ function _(require, module, exports, __esModule, __esExport) {
    var __extends = (this && this.__extends) || (function () {
        var extendStatics = function (d, b) {
            extendStatics = Object.setPrototypeOf ||
                ({ __proto__: [] } instanceof Array && function (d, b) { d.__proto__ = b; }) ||
                function (d, b) { for (var p in b)
                    if (Object.prototype.hasOwnProperty.call(b, p))
                        d[p] = b[p]; };
            return extendStatics(d, b);
        };
        return function (d, b) {
            if (typeof b !== "function" && b !== null)
                throw new TypeError("Class extends value " + String(b) + " is not a constructor or null");
            extendStatics(d, b);
            function __() { this.constructor = d; }
            d.prototype = b === null ? Object.create(b) : (__.prototype = b.prototype, new __());
        };
    })();
    var __values = (this && this.__values) || function (o) {
        var s = typeof Symbol === "function" && Symbol.iterator, m = s && o[s], i = 0;
        if (m)
            return m.call(o);
        if (o && typeof o.length === "number")
            return {
                next: function () {
                    if (o && i >= o.length)
                        o = void 0;
                    return { value: o && o[i++], done: !o };
                }
            };
        throw new TypeError(s ? "Object is not iterable." : "Symbol.iterator is not defined.");
    };
    __esModule();
    var Wrapper_js_1 = require(680) /* ../Wrapper.js */;
    var mfenced_js_1 = require(725) /* ../../common/Wrappers/mfenced.js */;
    var mfenced_js_2 = require(726) /* ../../../core/MmlTree/MmlNodes/mfenced.js */;
    var SVGmfenced = (function (_super) {
        __extends(SVGmfenced, _super);
        function SVGmfenced() {
            return _super !== null && _super.apply(this, arguments) || this;
        }
        SVGmfenced.prototype.toSVG = function (parent) {
            var svg = this.standardSVGnode(parent);
            this.setChildrenParent(this.mrow);
            this.mrow.toSVG(svg);
            this.setChildrenParent(this);
        };
        SVGmfenced.prototype.setChildrenParent = function (parent) {
            var e_1, _a;
            try {
                for (var _b = __values(this.childNodes), _c = _b.next(); !_c.done; _c = _b.next()) {
                    var child = _c.value;
                    child.parent = parent;
                }
            }
            catch (e_1_1) {
                e_1 = { error: e_1_1 };
            }
            finally {
                try {
                    if (_c && !_c.done && (_a = _b.return))
                        _a.call(_b);
                }
                finally {
                    if (e_1)
                        throw e_1.error;
                }
            }
        };
        SVGmfenced.kind = mfenced_js_2.MmlMfenced.prototype.kind;
        return SVGmfenced;
    }((0, mfenced_js_1.CommonMfencedMixin)(Wrapper_js_1.SVGWrapper)));
    exports.SVGmfenced = SVGmfenced;
},
725: /* mathjax-full/js/output/common/Wrappers/mfenced.js */ function _(require, module, exports, __esModule, __esExport) {
    var __extends = (this && this.__extends) || (function () {
        var extendStatics = function (d, b) {
            extendStatics = Object.setPrototypeOf ||
                ({ __proto__: [] } instanceof Array && function (d, b) { d.__proto__ = b; }) ||
                function (d, b) { for (var p in b)
                    if (Object.prototype.hasOwnProperty.call(b, p))
                        d[p] = b[p]; };
            return extendStatics(d, b);
        };
        return function (d, b) {
            if (typeof b !== "function" && b !== null)
                throw new TypeError("Class extends value " + String(b) + " is not a constructor or null");
            extendStatics(d, b);
            function __() { this.constructor = d; }
            d.prototype = b === null ? Object.create(b) : (__.prototype = b.prototype, new __());
        };
    })();
    var __read = (this && this.__read) || function (o, n) {
        var m = typeof Symbol === "function" && o[Symbol.iterator];
        if (!m)
            return o;
        var i = m.call(o), r, ar = [], e;
        try {
            while ((n === void 0 || n-- > 0) && !(r = i.next()).done)
                ar.push(r.value);
        }
        catch (error) {
            e = { error: error };
        }
        finally {
            try {
                if (r && !r.done && (m = i["return"]))
                    m.call(i);
            }
            finally {
                if (e)
                    throw e.error;
            }
        }
        return ar;
    };
    var __spreadArray = (this && this.__spreadArray) || function (to, from, pack) {
        if (pack || arguments.length === 2)
            for (var i = 0, l = from.length, ar; i < l; i++) {
                if (ar || !(i in from)) {
                    if (!ar)
                        ar = Array.prototype.slice.call(from, 0, i);
                    ar[i] = from[i];
                }
            }
        return to.concat(ar || Array.prototype.slice.call(from));
    };
    var __values = (this && this.__values) || function (o) {
        var s = typeof Symbol === "function" && Symbol.iterator, m = s && o[s], i = 0;
        if (m)
            return m.call(o);
        if (o && typeof o.length === "number")
            return {
                next: function () {
                    if (o && i >= o.length)
                        o = void 0;
                    return { value: o && o[i++], done: !o };
                }
            };
        throw new TypeError(s ? "Object is not iterable." : "Symbol.iterator is not defined.");
    };
    __esModule();
    function CommonMfencedMixin(Base) {
        return (function (_super) {
            __extends(class_1, _super);
            function class_1() {
                var args = [];
                for (var _i = 0; _i < arguments.length; _i++) {
                    args[_i] = arguments[_i];
                }
                var _this = _super.apply(this, __spreadArray([], __read(args), false)) || this;
                _this.mrow = null;
                _this.createMrow();
                _this.addMrowChildren();
                return _this;
            }
            class_1.prototype.createMrow = function () {
                var mmlFactory = this.node.factory;
                var mrow = mmlFactory.create('inferredMrow');
                mrow.inheritAttributesFrom(this.node);
                this.mrow = this.wrap(mrow);
                this.mrow.parent = this;
            };
            class_1.prototype.addMrowChildren = function () {
                var e_1, _a;
                var mfenced = this.node;
                var mrow = this.mrow;
                this.addMo(mfenced.open);
                if (this.childNodes.length) {
                    mrow.childNodes.push(this.childNodes[0]);
                }
                var i = 0;
                try {
                    for (var _b = __values(this.childNodes.slice(1)), _c = _b.next(); !_c.done; _c = _b.next()) {
                        var child = _c.value;
                        this.addMo(mfenced.separators[i++]);
                        mrow.childNodes.push(child);
                    }
                }
                catch (e_1_1) {
                    e_1 = { error: e_1_1 };
                }
                finally {
                    try {
                        if (_c && !_c.done && (_a = _b.return))
                            _a.call(_b);
                    }
                    finally {
                        if (e_1)
                            throw e_1.error;
                    }
                }
                this.addMo(mfenced.close);
                mrow.stretchChildren();
            };
            class_1.prototype.addMo = function (node) {
                if (!node)
                    return;
                var mo = this.wrap(node);
                this.mrow.childNodes.push(mo);
                mo.parent = this.mrow;
            };
            class_1.prototype.computeBBox = function (bbox, recompute) {
                if (recompute === void 0) {
                    recompute = false;
                }
                bbox.updateFrom(this.mrow.getOuterBBox());
                this.setChildPWidths(recompute);
            };
            return class_1;
        }(Base));
    }
    exports.CommonMfencedMixin = CommonMfencedMixin;
},
726: /* mathjax-full/js/core/MmlTree/MmlNodes/mfenced.js */ function _(require, module, exports, __esModule, __esExport) {
    var __extends = (this && this.__extends) || (function () {
        var extendStatics = function (d, b) {
            extendStatics = Object.setPrototypeOf ||
                ({ __proto__: [] } instanceof Array && function (d, b) { d.__proto__ = b; }) ||
                function (d, b) { for (var p in b)
                    if (Object.prototype.hasOwnProperty.call(b, p))
                        d[p] = b[p]; };
            return extendStatics(d, b);
        };
        return function (d, b) {
            if (typeof b !== "function" && b !== null)
                throw new TypeError("Class extends value " + String(b) + " is not a constructor or null");
            extendStatics(d, b);
            function __() { this.constructor = d; }
            d.prototype = b === null ? Object.create(b) : (__.prototype = b.prototype, new __());
        };
    })();
    var __assign = (this && this.__assign) || function () {
        __assign = Object.assign || function (t) {
            for (var s, i = 1, n = arguments.length; i < n; i++) {
                s = arguments[i];
                for (var p in s)
                    if (Object.prototype.hasOwnProperty.call(s, p))
                        t[p] = s[p];
            }
            return t;
        };
        return __assign.apply(this, arguments);
    };
    var __values = (this && this.__values) || function (o) {
        var s = typeof Symbol === "function" && Symbol.iterator, m = s && o[s], i = 0;
        if (m)
            return m.call(o);
        if (o && typeof o.length === "number")
            return {
                next: function () {
                    if (o && i >= o.length)
                        o = void 0;
                    return { value: o && o[i++], done: !o };
                }
            };
        throw new TypeError(s ? "Object is not iterable." : "Symbol.iterator is not defined.");
    };
    __esModule();
    var MmlNode_js_1 = require(639) /* ../MmlNode.js */;
    var MmlMfenced = (function (_super) {
        __extends(MmlMfenced, _super);
        function MmlMfenced() {
            var _this = _super !== null && _super.apply(this, arguments) || this;
            _this.texclass = MmlNode_js_1.TEXCLASS.INNER;
            _this.separators = [];
            _this.open = null;
            _this.close = null;
            return _this;
        }
        Object.defineProperty(MmlMfenced.prototype, "kind", {
            get: function () {
                return 'mfenced';
            },
            enumerable: false,
            configurable: true
        });
        MmlMfenced.prototype.setTeXclass = function (prev) {
            this.getPrevClass(prev);
            if (this.open) {
                prev = this.open.setTeXclass(prev);
            }
            if (this.childNodes[0]) {
                prev = this.childNodes[0].setTeXclass(prev);
            }
            for (var i = 1, m = this.childNodes.length; i < m; i++) {
                if (this.separators[i - 1]) {
                    prev = this.separators[i - 1].setTeXclass(prev);
                }
                if (this.childNodes[i]) {
                    prev = this.childNodes[i].setTeXclass(prev);
                }
            }
            if (this.close) {
                prev = this.close.setTeXclass(prev);
            }
            this.updateTeXclass(this.open);
            return prev;
        };
        MmlMfenced.prototype.setChildInheritedAttributes = function (attributes, display, level, prime) {
            var e_1, _a;
            this.addFakeNodes();
            try {
                for (var _b = __values([this.open, this.close].concat(this.separators)), _c = _b.next(); !_c.done; _c = _b.next()) {
                    var child = _c.value;
                    if (child) {
                        child.setInheritedAttributes(attributes, display, level, prime);
                    }
                }
            }
            catch (e_1_1) {
                e_1 = { error: e_1_1 };
            }
            finally {
                try {
                    if (_c && !_c.done && (_a = _b.return))
                        _a.call(_b);
                }
                finally {
                    if (e_1)
                        throw e_1.error;
                }
            }
            _super.prototype.setChildInheritedAttributes.call(this, attributes, display, level, prime);
        };
        MmlMfenced.prototype.addFakeNodes = function () {
            var e_2, _a;
            var _b = this.attributes.getList('open', 'close', 'separators'), open = _b.open, close = _b.close, separators = _b.separators;
            open = open.replace(/[ \t\n\r]/g, '');
            close = close.replace(/[ \t\n\r]/g, '');
            separators = separators.replace(/[ \t\n\r]/g, '');
            if (open) {
                this.open = this.fakeNode(open, { fence: true, form: 'prefix' }, MmlNode_js_1.TEXCLASS.OPEN);
            }
            if (separators) {
                while (separators.length < this.childNodes.length - 1) {
                    separators += separators.charAt(separators.length - 1);
                }
                var i = 0;
                try {
                    for (var _c = __values(this.childNodes.slice(1)), _d = _c.next(); !_d.done; _d = _c.next()) {
                        var child = _d.value;
                        if (child) {
                            this.separators.push(this.fakeNode(separators.charAt(i++)));
                        }
                    }
                }
                catch (e_2_1) {
                    e_2 = { error: e_2_1 };
                }
                finally {
                    try {
                        if (_d && !_d.done && (_a = _c.return))
                            _a.call(_c);
                    }
                    finally {
                        if (e_2)
                            throw e_2.error;
                    }
                }
            }
            if (close) {
                this.close = this.fakeNode(close, { fence: true, form: 'postfix' }, MmlNode_js_1.TEXCLASS.CLOSE);
            }
        };
        MmlMfenced.prototype.fakeNode = function (c, properties, texClass) {
            if (properties === void 0) {
                properties = {};
            }
            if (texClass === void 0) {
                texClass = null;
            }
            var text = this.factory.create('text').setText(c);
            var node = this.factory.create('mo', properties, [text]);
            node.texClass = texClass;
            node.parent = this;
            return node;
        };
        MmlMfenced.defaults = __assign(__assign({}, MmlNode_js_1.AbstractMmlNode.defaults), { open: '(', close: ')', separators: ',' });
        return MmlMfenced;
    }(MmlNode_js_1.AbstractMmlNode));
    exports.MmlMfenced = MmlMfenced;
},
727: /* mathjax-full/js/output/svg/Wrappers/msubsup.js */ function _(require, module, exports, __esModule, __esExport) {
    var __extends = (this && this.__extends) || (function () {
        var extendStatics = function (d, b) {
            extendStatics = Object.setPrototypeOf ||
                ({ __proto__: [] } instanceof Array && function (d, b) { d.__proto__ = b; }) ||
                function (d, b) { for (var p in b)
                    if (Object.prototype.hasOwnProperty.call(b, p))
                        d[p] = b[p]; };
            return extendStatics(d, b);
        };
        return function (d, b) {
            if (typeof b !== "function" && b !== null)
                throw new TypeError("Class extends value " + String(b) + " is not a constructor or null");
            extendStatics(d, b);
            function __() { this.constructor = d; }
            d.prototype = b === null ? Object.create(b) : (__.prototype = b.prototype, new __());
        };
    })();
    var __read = (this && this.__read) || function (o, n) {
        var m = typeof Symbol === "function" && o[Symbol.iterator];
        if (!m)
            return o;
        var i = m.call(o), r, ar = [], e;
        try {
            while ((n === void 0 || n-- > 0) && !(r = i.next()).done)
                ar.push(r.value);
        }
        catch (error) {
            e = { error: error };
        }
        finally {
            try {
                if (r && !r.done && (m = i["return"]))
                    m.call(i);
            }
            finally {
                if (e)
                    throw e.error;
            }
        }
        return ar;
    };
    __esModule();
    var scriptbase_js_1 = require(728) /* ./scriptbase.js */;
    var msubsup_js_1 = require(730) /* ../../common/Wrappers/msubsup.js */;
    var msubsup_js_2 = require(730) /* ../../common/Wrappers/msubsup.js */;
    var msubsup_js_3 = require(730) /* ../../common/Wrappers/msubsup.js */;
    var msubsup_js_4 = require(731) /* ../../../core/MmlTree/MmlNodes/msubsup.js */;
    var SVGmsub = (function (_super) {
        __extends(SVGmsub, _super);
        function SVGmsub() {
            return _super !== null && _super.apply(this, arguments) || this;
        }
        SVGmsub.kind = msubsup_js_4.MmlMsub.prototype.kind;
        return SVGmsub;
    }((0, msubsup_js_1.CommonMsubMixin)(scriptbase_js_1.SVGscriptbase)));
    exports.SVGmsub = SVGmsub;
    var SVGmsup = (function (_super) {
        __extends(SVGmsup, _super);
        function SVGmsup() {
            return _super !== null && _super.apply(this, arguments) || this;
        }
        SVGmsup.kind = msubsup_js_4.MmlMsup.prototype.kind;
        return SVGmsup;
    }((0, msubsup_js_2.CommonMsupMixin)(scriptbase_js_1.SVGscriptbase)));
    exports.SVGmsup = SVGmsup;
    var SVGmsubsup = (function (_super) {
        __extends(SVGmsubsup, _super);
        function SVGmsubsup() {
            return _super !== null && _super.apply(this, arguments) || this;
        }
        SVGmsubsup.prototype.toSVG = function (parent) {
            var svg = this.standardSVGnode(parent);
            var _a = __read([this.baseChild, this.supChild, this.subChild], 3), base = _a[0], sup = _a[1], sub = _a[2];
            var w = this.getBaseWidth();
            var x = this.getAdjustedIc();
            var _b = __read(this.getUVQ(), 2), u = _b[0], v = _b[1];
            base.toSVG(svg);
            sup.toSVG(svg);
            sub.toSVG(svg);
            sub.place(w, v);
            sup.place(w + x, u);
        };
        SVGmsubsup.kind = msubsup_js_4.MmlMsubsup.prototype.kind;
        return SVGmsubsup;
    }((0, msubsup_js_3.CommonMsubsupMixin)(scriptbase_js_1.SVGscriptbase)));
    exports.SVGmsubsup = SVGmsubsup;
},
728: /* mathjax-full/js/output/svg/Wrappers/scriptbase.js */ function _(require, module, exports, __esModule, __esExport) {
    var __extends = (this && this.__extends) || (function () {
        var extendStatics = function (d, b) {
            extendStatics = Object.setPrototypeOf ||
                ({ __proto__: [] } instanceof Array && function (d, b) { d.__proto__ = b; }) ||
                function (d, b) { for (var p in b)
                    if (Object.prototype.hasOwnProperty.call(b, p))
                        d[p] = b[p]; };
            return extendStatics(d, b);
        };
        return function (d, b) {
            if (typeof b !== "function" && b !== null)
                throw new TypeError("Class extends value " + String(b) + " is not a constructor or null");
            extendStatics(d, b);
            function __() { this.constructor = d; }
            d.prototype = b === null ? Object.create(b) : (__.prototype = b.prototype, new __());
        };
    })();
    var __read = (this && this.__read) || function (o, n) {
        var m = typeof Symbol === "function" && o[Symbol.iterator];
        if (!m)
            return o;
        var i = m.call(o), r, ar = [], e;
        try {
            while ((n === void 0 || n-- > 0) && !(r = i.next()).done)
                ar.push(r.value);
        }
        catch (error) {
            e = { error: error };
        }
        finally {
            try {
                if (r && !r.done && (m = i["return"]))
                    m.call(i);
            }
            finally {
                if (e)
                    throw e.error;
            }
        }
        return ar;
    };
    __esModule();
    var Wrapper_js_1 = require(680) /* ../Wrapper.js */;
    var scriptbase_js_1 = require(729) /* ../../common/Wrappers/scriptbase.js */;
    var SVGscriptbase = (function (_super) {
        __extends(SVGscriptbase, _super);
        function SVGscriptbase() {
            return _super !== null && _super.apply(this, arguments) || this;
        }
        SVGscriptbase.prototype.toSVG = function (parent) {
            var svg = this.standardSVGnode(parent);
            var w = this.getBaseWidth();
            var _a = __read(this.getOffset(), 2), x = _a[0], v = _a[1];
            this.baseChild.toSVG(svg);
            this.scriptChild.toSVG(svg);
            this.scriptChild.place(w + x, v);
        };
        SVGscriptbase.kind = 'scriptbase';
        return SVGscriptbase;
    }((0, scriptbase_js_1.CommonScriptbaseMixin)(Wrapper_js_1.SVGWrapper)));
    exports.SVGscriptbase = SVGscriptbase;
},
729: /* mathjax-full/js/output/common/Wrappers/scriptbase.js */ function _(require, module, exports, __esModule, __esExport) {
    var __extends = (this && this.__extends) || (function () {
        var extendStatics = function (d, b) {
            extendStatics = Object.setPrototypeOf ||
                ({ __proto__: [] } instanceof Array && function (d, b) { d.__proto__ = b; }) ||
                function (d, b) { for (var p in b)
                    if (Object.prototype.hasOwnProperty.call(b, p))
                        d[p] = b[p]; };
            return extendStatics(d, b);
        };
        return function (d, b) {
            if (typeof b !== "function" && b !== null)
                throw new TypeError("Class extends value " + String(b) + " is not a constructor or null");
            extendStatics(d, b);
            function __() { this.constructor = d; }
            d.prototype = b === null ? Object.create(b) : (__.prototype = b.prototype, new __());
        };
    })();
    var __read = (this && this.__read) || function (o, n) {
        var m = typeof Symbol === "function" && o[Symbol.iterator];
        if (!m)
            return o;
        var i = m.call(o), r, ar = [], e;
        try {
            while ((n === void 0 || n-- > 0) && !(r = i.next()).done)
                ar.push(r.value);
        }
        catch (error) {
            e = { error: error };
        }
        finally {
            try {
                if (r && !r.done && (m = i["return"]))
                    m.call(i);
            }
            finally {
                if (e)
                    throw e.error;
            }
        }
        return ar;
    };
    var __spreadArray = (this && this.__spreadArray) || function (to, from, pack) {
        if (pack || arguments.length === 2)
            for (var i = 0, l = from.length, ar; i < l; i++) {
                if (ar || !(i in from)) {
                    if (!ar)
                        ar = Array.prototype.slice.call(from, 0, i);
                    ar[i] = from[i];
                }
            }
        return to.concat(ar || Array.prototype.slice.call(from));
    };
    var __values = (this && this.__values) || function (o) {
        var s = typeof Symbol === "function" && Symbol.iterator, m = s && o[s], i = 0;
        if (m)
            return m.call(o);
        if (o && typeof o.length === "number")
            return {
                next: function () {
                    if (o && i >= o.length)
                        o = void 0;
                    return { value: o && o[i++], done: !o };
                }
            };
        throw new TypeError(s ? "Object is not iterable." : "Symbol.iterator is not defined.");
    };
    __esModule();
    var MmlNode_js_1 = require(639) /* ../../../core/MmlTree/MmlNode.js */;
    function CommonScriptbaseMixin(Base) {
        var _a;
        return _a = (function (_super) {
            __extends(class_1, _super);
            function class_1() {
                var args = [];
                for (var _i = 0; _i < arguments.length; _i++) {
                    args[_i] = arguments[_i];
                }
                var _this = _super.apply(this, __spreadArray([], __read(args), false)) || this;
                _this.baseScale = 1;
                _this.baseIc = 0;
                _this.baseRemoveIc = false;
                _this.baseIsChar = false;
                _this.baseHasAccentOver = null;
                _this.baseHasAccentUnder = null;
                _this.isLineAbove = false;
                _this.isLineBelow = false;
                _this.isMathAccent = false;
                var core = _this.baseCore = _this.getBaseCore();
                if (!core)
                    return _this;
                _this.setBaseAccentsFor(core);
                _this.baseScale = _this.getBaseScale();
                _this.baseIc = _this.getBaseIc();
                _this.baseIsChar = _this.isCharBase();
                _this.isMathAccent = _this.baseIsChar &&
                    (_this.scriptChild && !!_this.scriptChild.coreMO().node.getProperty('mathaccent'));
                _this.checkLineAccents();
                _this.baseRemoveIc = !_this.isLineAbove && !_this.isLineBelow &&
                    (!_this.constructor.useIC || _this.isMathAccent);
                return _this;
            }
            Object.defineProperty(class_1.prototype, "baseChild", {
                get: function () {
                    return this.childNodes[this.node.base];
                },
                enumerable: false,
                configurable: true
            });
            Object.defineProperty(class_1.prototype, "scriptChild", {
                get: function () {
                    return this.childNodes[1];
                },
                enumerable: false,
                configurable: true
            });
            class_1.prototype.getBaseCore = function () {
                var core = this.getSemanticBase() || this.childNodes[0];
                while (core &&
                    ((core.childNodes.length === 1 &&
                        (core.node.isKind('mrow') ||
                            (core.node.isKind('TeXAtom') && core.node.texClass !== MmlNode_js_1.TEXCLASS.VCENTER) ||
                            core.node.isKind('mstyle') || core.node.isKind('mpadded') ||
                            core.node.isKind('mphantom') || core.node.isKind('semantics'))) ||
                        (core.node.isKind('munderover') && core.isMathAccent))) {
                    this.setBaseAccentsFor(core);
                    core = core.childNodes[0];
                }
                if (!core) {
                    this.baseHasAccentOver = this.baseHasAccentUnder = false;
                }
                return core || this.childNodes[0];
            };
            class_1.prototype.setBaseAccentsFor = function (core) {
                if (core.node.isKind('munderover')) {
                    if (this.baseHasAccentOver === null) {
                        this.baseHasAccentOver = !!core.node.attributes.get('accent');
                    }
                    if (this.baseHasAccentUnder === null) {
                        this.baseHasAccentUnder = !!core.node.attributes.get('accentunder');
                    }
                }
            };
            class_1.prototype.getSemanticBase = function () {
                var fence = this.node.attributes.getExplicit('data-semantic-fencepointer');
                return this.getBaseFence(this.baseChild, fence);
            };
            class_1.prototype.getBaseFence = function (fence, id) {
                var e_1, _a;
                if (!fence || !fence.node.attributes || !id) {
                    return null;
                }
                if (fence.node.attributes.getExplicit('data-semantic-id') === id) {
                    return fence;
                }
                try {
                    for (var _b = __values(fence.childNodes), _c = _b.next(); !_c.done; _c = _b.next()) {
                        var child = _c.value;
                        var result = this.getBaseFence(child, id);
                        if (result) {
                            return result;
                        }
                    }
                }
                catch (e_1_1) {
                    e_1 = { error: e_1_1 };
                }
                finally {
                    try {
                        if (_c && !_c.done && (_a = _b.return))
                            _a.call(_b);
                    }
                    finally {
                        if (e_1)
                            throw e_1.error;
                    }
                }
                return null;
            };
            class_1.prototype.getBaseScale = function () {
                var child = this.baseCore;
                var scale = 1;
                while (child && child !== this) {
                    var bbox = child.getOuterBBox();
                    scale *= bbox.rscale;
                    child = child.parent;
                }
                return scale;
            };
            class_1.prototype.getBaseIc = function () {
                return this.baseCore.getOuterBBox().ic * this.baseScale;
            };
            class_1.prototype.getAdjustedIc = function () {
                var bbox = this.baseCore.getOuterBBox();
                return (bbox.ic ? 1.05 * bbox.ic + .05 : 0) * this.baseScale;
            };
            class_1.prototype.isCharBase = function () {
                var base = this.baseCore;
                return (((base.node.isKind('mo') && base.size === null) ||
                    base.node.isKind('mi') || base.node.isKind('mn')) &&
                    base.bbox.rscale === 1 && Array.from(base.getText()).length === 1);
            };
            class_1.prototype.checkLineAccents = function () {
                if (!this.node.isKind('munderover'))
                    return;
                if (this.node.isKind('mover')) {
                    this.isLineAbove = this.isLineAccent(this.scriptChild);
                }
                else if (this.node.isKind('munder')) {
                    this.isLineBelow = this.isLineAccent(this.scriptChild);
                }
                else {
                    var mml = this;
                    this.isLineAbove = this.isLineAccent(mml.overChild);
                    this.isLineBelow = this.isLineAccent(mml.underChild);
                }
            };
            class_1.prototype.isLineAccent = function (script) {
                var node = script.coreMO().node;
                return (node.isToken && node.getText() === '\u2015');
            };
            class_1.prototype.getBaseWidth = function () {
                var bbox = this.baseChild.getOuterBBox();
                return bbox.w * bbox.rscale - (this.baseRemoveIc ? this.baseIc : 0) + this.font.params.extra_ic;
            };
            class_1.prototype.computeBBox = function (bbox, recompute) {
                if (recompute === void 0) {
                    recompute = false;
                }
                var w = this.getBaseWidth();
                var _a = __read(this.getOffset(), 2), x = _a[0], y = _a[1];
                bbox.append(this.baseChild.getOuterBBox());
                bbox.combine(this.scriptChild.getOuterBBox(), w + x, y);
                bbox.w += this.font.params.scriptspace;
                bbox.clean();
                this.setChildPWidths(recompute);
            };
            class_1.prototype.getOffset = function () {
                return [0, 0];
            };
            class_1.prototype.baseCharZero = function (n) {
                var largeop = !!this.baseCore.node.attributes.get('largeop');
                var scale = this.baseScale;
                return (this.baseIsChar && !largeop && scale === 1 ? 0 : n);
            };
            class_1.prototype.getV = function () {
                var bbox = this.baseCore.getOuterBBox();
                var sbox = this.scriptChild.getOuterBBox();
                var tex = this.font.params;
                var subscriptshift = this.length2em(this.node.attributes.get('subscriptshift'), tex.sub1);
                return Math.max(this.baseCharZero(bbox.d * this.baseScale + tex.sub_drop * sbox.rscale), subscriptshift, sbox.h * sbox.rscale - (4 / 5) * tex.x_height);
            };
            class_1.prototype.getU = function () {
                var bbox = this.baseCore.getOuterBBox();
                var sbox = this.scriptChild.getOuterBBox();
                var tex = this.font.params;
                var attr = this.node.attributes.getList('displaystyle', 'superscriptshift');
                var prime = this.node.getProperty('texprimestyle');
                var p = prime ? tex.sup3 : (attr.displaystyle ? tex.sup1 : tex.sup2);
                var superscriptshift = this.length2em(attr.superscriptshift, p);
                return Math.max(this.baseCharZero(bbox.h * this.baseScale - tex.sup_drop * sbox.rscale), superscriptshift, sbox.d * sbox.rscale + (1 / 4) * tex.x_height);
            };
            class_1.prototype.hasMovableLimits = function () {
                var display = this.node.attributes.get('displaystyle');
                var mo = this.baseChild.coreMO().node;
                return (!display && !!mo.attributes.get('movablelimits'));
            };
            class_1.prototype.getOverKU = function (basebox, overbox) {
                var accent = this.node.attributes.get('accent');
                var tex = this.font.params;
                var d = overbox.d * overbox.rscale;
                var t = tex.rule_thickness * tex.separation_factor;
                var delta = (this.baseHasAccentOver ? t : 0);
                var T = (this.isLineAbove ? 3 * tex.rule_thickness : t);
                var k = (accent ? T : Math.max(tex.big_op_spacing1, tex.big_op_spacing3 - Math.max(0, d))) - delta;
                return [k, basebox.h * basebox.rscale + k + d];
            };
            class_1.prototype.getUnderKV = function (basebox, underbox) {
                var accent = this.node.attributes.get('accentunder');
                var tex = this.font.params;
                var h = underbox.h * underbox.rscale;
                var t = tex.rule_thickness * tex.separation_factor;
                var delta = (this.baseHasAccentUnder ? t : 0);
                var T = (this.isLineBelow ? 3 * tex.rule_thickness : t);
                var k = (accent ? T : Math.max(tex.big_op_spacing2, tex.big_op_spacing4 - h)) - delta;
                return [k, -(basebox.d * basebox.rscale + k + h)];
            };
            class_1.prototype.getDeltaW = function (boxes, delta) {
                var e_2, _a, e_3, _b;
                if (delta === void 0) {
                    delta = [0, 0, 0];
                }
                var align = this.node.attributes.get('align');
                var widths = boxes.map(function (box) { return box.w * box.rscale; });
                widths[0] -= (this.baseRemoveIc && !this.baseCore.node.attributes.get('largeop') ? this.baseIc : 0);
                var w = Math.max.apply(Math, __spreadArray([], __read(widths), false));
                var dw = [];
                var m = 0;
                try {
                    for (var _c = __values(widths.keys()), _d = _c.next(); !_d.done; _d = _c.next()) {
                        var i = _d.value;
                        dw[i] = (align === 'center' ? (w - widths[i]) / 2 :
                            align === 'right' ? w - widths[i] : 0) + delta[i];
                        if (dw[i] < m) {
                            m = -dw[i];
                        }
                    }
                }
                catch (e_2_1) {
                    e_2 = { error: e_2_1 };
                }
                finally {
                    try {
                        if (_d && !_d.done && (_a = _c.return))
                            _a.call(_c);
                    }
                    finally {
                        if (e_2)
                            throw e_2.error;
                    }
                }
                if (m) {
                    try {
                        for (var _e = __values(dw.keys()), _f = _e.next(); !_f.done; _f = _e.next()) {
                            var i = _f.value;
                            dw[i] += m;
                        }
                    }
                    catch (e_3_1) {
                        e_3 = { error: e_3_1 };
                    }
                    finally {
                        try {
                            if (_f && !_f.done && (_b = _e.return))
                                _b.call(_e);
                        }
                        finally {
                            if (e_3)
                                throw e_3.error;
                        }
                    }
                }
                [1, 2].map(function (i) { return dw[i] += (boxes[i] ? boxes[i].dx * boxes[0].scale : 0); });
                return dw;
            };
            class_1.prototype.getDelta = function (noskew) {
                if (noskew === void 0) {
                    noskew = false;
                }
                var accent = this.node.attributes.get('accent');
                var _a = this.baseCore.getOuterBBox(), sk = _a.sk, ic = _a.ic;
                return ((accent && !noskew ? sk : 0) + this.font.skewIcFactor * ic) * this.baseScale;
            };
            class_1.prototype.stretchChildren = function () {
                var e_4, _a, e_5, _b, e_6, _c;
                var stretchy = [];
                try {
                    for (var _d = __values(this.childNodes), _e = _d.next(); !_e.done; _e = _d.next()) {
                        var child = _e.value;
                        if (child.canStretch(2)) {
                            stretchy.push(child);
                        }
                    }
                }
                catch (e_4_1) {
                    e_4 = { error: e_4_1 };
                }
                finally {
                    try {
                        if (_e && !_e.done && (_a = _d.return))
                            _a.call(_d);
                    }
                    finally {
                        if (e_4)
                            throw e_4.error;
                    }
                }
                var count = stretchy.length;
                var nodeCount = this.childNodes.length;
                if (count && nodeCount > 1) {
                    var W = 0;
                    var all = (count > 1 && count === nodeCount);
                    try {
                        for (var _f = __values(this.childNodes), _g = _f.next(); !_g.done; _g = _f.next()) {
                            var child = _g.value;
                            var noStretch = (child.stretch.dir === 0);
                            if (all || noStretch) {
                                var _h = child.getOuterBBox(noStretch), w = _h.w, rscale = _h.rscale;
                                if (w * rscale > W)
                                    W = w * rscale;
                            }
                        }
                    }
                    catch (e_5_1) {
                        e_5 = { error: e_5_1 };
                    }
                    finally {
                        try {
                            if (_g && !_g.done && (_b = _f.return))
                                _b.call(_f);
                        }
                        finally {
                            if (e_5)
                                throw e_5.error;
                        }
                    }
                    try {
                        for (var stretchy_1 = __values(stretchy), stretchy_1_1 = stretchy_1.next(); !stretchy_1_1.done; stretchy_1_1 = stretchy_1.next()) {
                            var child = stretchy_1_1.value;
                            child.coreMO().getStretchedVariant([W / child.bbox.rscale]);
                        }
                    }
                    catch (e_6_1) {
                        e_6 = { error: e_6_1 };
                    }
                    finally {
                        try {
                            if (stretchy_1_1 && !stretchy_1_1.done && (_c = stretchy_1.return))
                                _c.call(stretchy_1);
                        }
                        finally {
                            if (e_6)
                                throw e_6.error;
                        }
                    }
                }
            };
            return class_1;
        }(Base)),
            _a.useIC = true,
            _a;
    }
    exports.CommonScriptbaseMixin = CommonScriptbaseMixin;
},
730: /* mathjax-full/js/output/common/Wrappers/msubsup.js */ function _(require, module, exports, __esModule, __esExport) {
    var __extends = (this && this.__extends) || (function () {
        var extendStatics = function (d, b) {
            extendStatics = Object.setPrototypeOf ||
                ({ __proto__: [] } instanceof Array && function (d, b) { d.__proto__ = b; }) ||
                function (d, b) { for (var p in b)
                    if (Object.prototype.hasOwnProperty.call(b, p))
                        d[p] = b[p]; };
            return extendStatics(d, b);
        };
        return function (d, b) {
            if (typeof b !== "function" && b !== null)
                throw new TypeError("Class extends value " + String(b) + " is not a constructor or null");
            extendStatics(d, b);
            function __() { this.constructor = d; }
            d.prototype = b === null ? Object.create(b) : (__.prototype = b.prototype, new __());
        };
    })();
    var __read = (this && this.__read) || function (o, n) {
        var m = typeof Symbol === "function" && o[Symbol.iterator];
        if (!m)
            return o;
        var i = m.call(o), r, ar = [], e;
        try {
            while ((n === void 0 || n-- > 0) && !(r = i.next()).done)
                ar.push(r.value);
        }
        catch (error) {
            e = { error: error };
        }
        finally {
            try {
                if (r && !r.done && (m = i["return"]))
                    m.call(i);
            }
            finally {
                if (e)
                    throw e.error;
            }
        }
        return ar;
    };
    __esModule();
    function CommonMsubMixin(Base) {
        var _a;
        return _a = (function (_super) {
            __extends(class_1, _super);
            function class_1() {
                return _super !== null && _super.apply(this, arguments) || this;
            }
            Object.defineProperty(class_1.prototype, "scriptChild", {
                get: function () {
                    return this.childNodes[this.node.sub];
                },
                enumerable: false,
                configurable: true
            });
            class_1.prototype.getOffset = function () {
                return [0, -this.getV()];
            };
            return class_1;
        }(Base)),
            _a.useIC = false,
            _a;
    }
    exports.CommonMsubMixin = CommonMsubMixin;
    function CommonMsupMixin(Base) {
        return (function (_super) {
            __extends(class_2, _super);
            function class_2() {
                return _super !== null && _super.apply(this, arguments) || this;
            }
            Object.defineProperty(class_2.prototype, "scriptChild", {
                get: function () {
                    return this.childNodes[this.node.sup];
                },
                enumerable: false,
                configurable: true
            });
            class_2.prototype.getOffset = function () {
                var x = this.getAdjustedIc() - (this.baseRemoveIc ? 0 : this.baseIc);
                return [x, this.getU()];
            };
            return class_2;
        }(Base));
    }
    exports.CommonMsupMixin = CommonMsupMixin;
    function CommonMsubsupMixin(Base) {
        var _a;
        return _a = (function (_super) {
            __extends(class_3, _super);
            function class_3() {
                var _this = _super !== null && _super.apply(this, arguments) || this;
                _this.UVQ = null;
                return _this;
            }
            Object.defineProperty(class_3.prototype, "subChild", {
                get: function () {
                    return this.childNodes[this.node.sub];
                },
                enumerable: false,
                configurable: true
            });
            Object.defineProperty(class_3.prototype, "supChild", {
                get: function () {
                    return this.childNodes[this.node.sup];
                },
                enumerable: false,
                configurable: true
            });
            class_3.prototype.computeBBox = function (bbox, recompute) {
                if (recompute === void 0) {
                    recompute = false;
                }
                var basebox = this.baseChild.getOuterBBox();
                var _a = __read([this.subChild.getOuterBBox(), this.supChild.getOuterBBox()], 2), subbox = _a[0], supbox = _a[1];
                bbox.empty();
                bbox.append(basebox);
                var w = this.getBaseWidth();
                var x = this.getAdjustedIc();
                var _b = __read(this.getUVQ(), 2), u = _b[0], v = _b[1];
                bbox.combine(subbox, w, v);
                bbox.combine(supbox, w + x, u);
                bbox.w += this.font.params.scriptspace;
                bbox.clean();
                this.setChildPWidths(recompute);
            };
            class_3.prototype.getUVQ = function (subbox, supbox) {
                if (subbox === void 0) {
                    subbox = this.subChild.getOuterBBox();
                }
                if (supbox === void 0) {
                    supbox = this.supChild.getOuterBBox();
                }
                var basebox = this.baseCore.getOuterBBox();
                if (this.UVQ)
                    return this.UVQ;
                var tex = this.font.params;
                var t = 3 * tex.rule_thickness;
                var subscriptshift = this.length2em(this.node.attributes.get('subscriptshift'), tex.sub2);
                var drop = this.baseCharZero(basebox.d * this.baseScale + tex.sub_drop * subbox.rscale);
                var _a = __read([this.getU(), Math.max(drop, subscriptshift)], 2), u = _a[0], v = _a[1];
                var q = (u - supbox.d * supbox.rscale) - (subbox.h * subbox.rscale - v);
                if (q < t) {
                    v += t - q;
                    var p = (4 / 5) * tex.x_height - (u - supbox.d * supbox.rscale);
                    if (p > 0) {
                        u += p;
                        v -= p;
                    }
                }
                u = Math.max(this.length2em(this.node.attributes.get('superscriptshift'), u), u);
                v = Math.max(this.length2em(this.node.attributes.get('subscriptshift'), v), v);
                q = (u - supbox.d * supbox.rscale) - (subbox.h * subbox.rscale - v);
                this.UVQ = [u, -v, q];
                return this.UVQ;
            };
            return class_3;
        }(Base)),
            _a.useIC = false,
            _a;
    }
    exports.CommonMsubsupMixin = CommonMsubsupMixin;
},
731: /* mathjax-full/js/core/MmlTree/MmlNodes/msubsup.js */ function _(require, module, exports, __esModule, __esExport) {
    var __extends = (this && this.__extends) || (function () {
        var extendStatics = function (d, b) {
            extendStatics = Object.setPrototypeOf ||
                ({ __proto__: [] } instanceof Array && function (d, b) { d.__proto__ = b; }) ||
                function (d, b) { for (var p in b)
                    if (Object.prototype.hasOwnProperty.call(b, p))
                        d[p] = b[p]; };
            return extendStatics(d, b);
        };
        return function (d, b) {
            if (typeof b !== "function" && b !== null)
                throw new TypeError("Class extends value " + String(b) + " is not a constructor or null");
            extendStatics(d, b);
            function __() { this.constructor = d; }
            d.prototype = b === null ? Object.create(b) : (__.prototype = b.prototype, new __());
        };
    })();
    var __assign = (this && this.__assign) || function () {
        __assign = Object.assign || function (t) {
            for (var s, i = 1, n = arguments.length; i < n; i++) {
                s = arguments[i];
                for (var p in s)
                    if (Object.prototype.hasOwnProperty.call(s, p))
                        t[p] = s[p];
            }
            return t;
        };
        return __assign.apply(this, arguments);
    };
    __esModule();
    var MmlNode_js_1 = require(639) /* ../MmlNode.js */;
    var MmlMsubsup = (function (_super) {
        __extends(MmlMsubsup, _super);
        function MmlMsubsup() {
            return _super !== null && _super.apply(this, arguments) || this;
        }
        Object.defineProperty(MmlMsubsup.prototype, "kind", {
            get: function () {
                return 'msubsup';
            },
            enumerable: false,
            configurable: true
        });
        Object.defineProperty(MmlMsubsup.prototype, "arity", {
            get: function () {
                return 3;
            },
            enumerable: false,
            configurable: true
        });
        Object.defineProperty(MmlMsubsup.prototype, "base", {
            get: function () {
                return 0;
            },
            enumerable: false,
            configurable: true
        });
        Object.defineProperty(MmlMsubsup.prototype, "sub", {
            get: function () {
                return 1;
            },
            enumerable: false,
            configurable: true
        });
        Object.defineProperty(MmlMsubsup.prototype, "sup", {
            get: function () {
                return 2;
            },
            enumerable: false,
            configurable: true
        });
        MmlMsubsup.prototype.setChildInheritedAttributes = function (attributes, display, level, prime) {
            var nodes = this.childNodes;
            nodes[0].setInheritedAttributes(attributes, display, level, prime);
            nodes[1].setInheritedAttributes(attributes, false, level + 1, prime || this.sub === 1);
            if (!nodes[2]) {
                return;
            }
            nodes[2].setInheritedAttributes(attributes, false, level + 1, prime || this.sub === 2);
        };
        MmlMsubsup.defaults = __assign(__assign({}, MmlNode_js_1.AbstractMmlBaseNode.defaults), { subscriptshift: '', superscriptshift: '' });
        return MmlMsubsup;
    }(MmlNode_js_1.AbstractMmlBaseNode));
    exports.MmlMsubsup = MmlMsubsup;
    var MmlMsub = (function (_super) {
        __extends(MmlMsub, _super);
        function MmlMsub() {
            return _super !== null && _super.apply(this, arguments) || this;
        }
        Object.defineProperty(MmlMsub.prototype, "kind", {
            get: function () {
                return 'msub';
            },
            enumerable: false,
            configurable: true
        });
        Object.defineProperty(MmlMsub.prototype, "arity", {
            get: function () {
                return 2;
            },
            enumerable: false,
            configurable: true
        });
        MmlMsub.defaults = __assign({}, MmlMsubsup.defaults);
        return MmlMsub;
    }(MmlMsubsup));
    exports.MmlMsub = MmlMsub;
    var MmlMsup = (function (_super) {
        __extends(MmlMsup, _super);
        function MmlMsup() {
            return _super !== null && _super.apply(this, arguments) || this;
        }
        Object.defineProperty(MmlMsup.prototype, "kind", {
            get: function () {
                return 'msup';
            },
            enumerable: false,
            configurable: true
        });
        Object.defineProperty(MmlMsup.prototype, "arity", {
            get: function () {
                return 2;
            },
            enumerable: false,
            configurable: true
        });
        Object.defineProperty(MmlMsup.prototype, "sup", {
            get: function () {
                return 1;
            },
            enumerable: false,
            configurable: true
        });
        Object.defineProperty(MmlMsup.prototype, "sub", {
            get: function () {
                return 2;
            },
            enumerable: false,
            configurable: true
        });
        MmlMsup.defaults = __assign({}, MmlMsubsup.defaults);
        return MmlMsup;
    }(MmlMsubsup));
    exports.MmlMsup = MmlMsup;
},
732: /* mathjax-full/js/output/svg/Wrappers/munderover.js */ function _(require, module, exports, __esModule, __esExport) {
    var __extends = (this && this.__extends) || (function () {
        var extendStatics = function (d, b) {
            extendStatics = Object.setPrototypeOf ||
                ({ __proto__: [] } instanceof Array && function (d, b) { d.__proto__ = b; }) ||
                function (d, b) { for (var p in b)
                    if (Object.prototype.hasOwnProperty.call(b, p))
                        d[p] = b[p]; };
            return extendStatics(d, b);
        };
        return function (d, b) {
            if (typeof b !== "function" && b !== null)
                throw new TypeError("Class extends value " + String(b) + " is not a constructor or null");
            extendStatics(d, b);
            function __() { this.constructor = d; }
            d.prototype = b === null ? Object.create(b) : (__.prototype = b.prototype, new __());
        };
    })();
    var __read = (this && this.__read) || function (o, n) {
        var m = typeof Symbol === "function" && o[Symbol.iterator];
        if (!m)
            return o;
        var i = m.call(o), r, ar = [], e;
        try {
            while ((n === void 0 || n-- > 0) && !(r = i.next()).done)
                ar.push(r.value);
        }
        catch (error) {
            e = { error: error };
        }
        finally {
            try {
                if (r && !r.done && (m = i["return"]))
                    m.call(i);
            }
            finally {
                if (e)
                    throw e.error;
            }
        }
        return ar;
    };
    __esModule();
    var msubsup_js_1 = require(727) /* ./msubsup.js */;
    var munderover_js_1 = require(733) /* ../../common/Wrappers/munderover.js */;
    var munderover_js_2 = require(733) /* ../../common/Wrappers/munderover.js */;
    var munderover_js_3 = require(733) /* ../../common/Wrappers/munderover.js */;
    var munderover_js_4 = require(734) /* ../../../core/MmlTree/MmlNodes/munderover.js */;
    var SVGmunder = (function (_super) {
        __extends(SVGmunder, _super);
        function SVGmunder() {
            return _super !== null && _super.apply(this, arguments) || this;
        }
        SVGmunder.prototype.toSVG = function (parent) {
            if (this.hasMovableLimits()) {
                _super.prototype.toSVG.call(this, parent);
                return;
            }
            var svg = this.standardSVGnode(parent);
            var _a = __read([this.baseChild, this.scriptChild], 2), base = _a[0], script = _a[1];
            var _b = __read([base.getOuterBBox(), script.getOuterBBox()], 2), bbox = _b[0], sbox = _b[1];
            base.toSVG(svg);
            script.toSVG(svg);
            var delta = (this.isLineBelow ? 0 : this.getDelta(true));
            var v = this.getUnderKV(bbox, sbox)[1];
            var _c = __read(this.getDeltaW([bbox, sbox], [0, -delta]), 2), bx = _c[0], sx = _c[1];
            base.place(bx, 0);
            script.place(sx, v);
        };
        SVGmunder.kind = munderover_js_4.MmlMunder.prototype.kind;
        return SVGmunder;
    }((0, munderover_js_1.CommonMunderMixin)(msubsup_js_1.SVGmsub)));
    exports.SVGmunder = SVGmunder;
    var SVGmover = (function (_super) {
        __extends(SVGmover, _super);
        function SVGmover() {
            return _super !== null && _super.apply(this, arguments) || this;
        }
        SVGmover.prototype.toSVG = function (parent) {
            if (this.hasMovableLimits()) {
                _super.prototype.toSVG.call(this, parent);
                return;
            }
            var svg = this.standardSVGnode(parent);
            var _a = __read([this.baseChild, this.scriptChild], 2), base = _a[0], script = _a[1];
            var _b = __read([base.getOuterBBox(), script.getOuterBBox()], 2), bbox = _b[0], sbox = _b[1];
            base.toSVG(svg);
            script.toSVG(svg);
            var delta = (this.isLineAbove ? 0 : this.getDelta());
            var u = this.getOverKU(bbox, sbox)[1];
            var _c = __read(this.getDeltaW([bbox, sbox], [0, delta]), 2), bx = _c[0], sx = _c[1];
            base.place(bx, 0);
            script.place(sx, u);
        };
        SVGmover.kind = munderover_js_4.MmlMover.prototype.kind;
        return SVGmover;
    }((0, munderover_js_2.CommonMoverMixin)(msubsup_js_1.SVGmsup)));
    exports.SVGmover = SVGmover;
    var SVGmunderover = (function (_super) {
        __extends(SVGmunderover, _super);
        function SVGmunderover() {
            return _super !== null && _super.apply(this, arguments) || this;
        }
        SVGmunderover.prototype.toSVG = function (parent) {
            if (this.hasMovableLimits()) {
                _super.prototype.toSVG.call(this, parent);
                return;
            }
            var svg = this.standardSVGnode(parent);
            var _a = __read([this.baseChild, this.overChild, this.underChild], 3), base = _a[0], over = _a[1], under = _a[2];
            var _b = __read([base.getOuterBBox(), over.getOuterBBox(), under.getOuterBBox()], 3), bbox = _b[0], obox = _b[1], ubox = _b[2];
            base.toSVG(svg);
            under.toSVG(svg);
            over.toSVG(svg);
            var delta = this.getDelta();
            var u = this.getOverKU(bbox, obox)[1];
            var v = this.getUnderKV(bbox, ubox)[1];
            var _c = __read(this.getDeltaW([bbox, ubox, obox], [0, this.isLineBelow ? 0 : -delta, this.isLineAbove ? 0 : delta]), 3), bx = _c[0], ux = _c[1], ox = _c[2];
            base.place(bx, 0);
            under.place(ux, v);
            over.place(ox, u);
        };
        SVGmunderover.kind = munderover_js_4.MmlMunderover.prototype.kind;
        return SVGmunderover;
    }((0, munderover_js_3.CommonMunderoverMixin)(msubsup_js_1.SVGmsubsup)));
    exports.SVGmunderover = SVGmunderover;
},
733: /* mathjax-full/js/output/common/Wrappers/munderover.js */ function _(require, module, exports, __esModule, __esExport) {
    var __extends = (this && this.__extends) || (function () {
        var extendStatics = function (d, b) {
            extendStatics = Object.setPrototypeOf ||
                ({ __proto__: [] } instanceof Array && function (d, b) { d.__proto__ = b; }) ||
                function (d, b) { for (var p in b)
                    if (Object.prototype.hasOwnProperty.call(b, p))
                        d[p] = b[p]; };
            return extendStatics(d, b);
        };
        return function (d, b) {
            if (typeof b !== "function" && b !== null)
                throw new TypeError("Class extends value " + String(b) + " is not a constructor or null");
            extendStatics(d, b);
            function __() { this.constructor = d; }
            d.prototype = b === null ? Object.create(b) : (__.prototype = b.prototype, new __());
        };
    })();
    var __read = (this && this.__read) || function (o, n) {
        var m = typeof Symbol === "function" && o[Symbol.iterator];
        if (!m)
            return o;
        var i = m.call(o), r, ar = [], e;
        try {
            while ((n === void 0 || n-- > 0) && !(r = i.next()).done)
                ar.push(r.value);
        }
        catch (error) {
            e = { error: error };
        }
        finally {
            try {
                if (r && !r.done && (m = i["return"]))
                    m.call(i);
            }
            finally {
                if (e)
                    throw e.error;
            }
        }
        return ar;
    };
    var __spreadArray = (this && this.__spreadArray) || function (to, from, pack) {
        if (pack || arguments.length === 2)
            for (var i = 0, l = from.length, ar; i < l; i++) {
                if (ar || !(i in from)) {
                    if (!ar)
                        ar = Array.prototype.slice.call(from, 0, i);
                    ar[i] = from[i];
                }
            }
        return to.concat(ar || Array.prototype.slice.call(from));
    };
    __esModule();
    function CommonMunderMixin(Base) {
        return (function (_super) {
            __extends(class_1, _super);
            function class_1() {
                var args = [];
                for (var _i = 0; _i < arguments.length; _i++) {
                    args[_i] = arguments[_i];
                }
                var _this = _super.apply(this, __spreadArray([], __read(args), false)) || this;
                _this.stretchChildren();
                return _this;
            }
            Object.defineProperty(class_1.prototype, "scriptChild", {
                get: function () {
                    return this.childNodes[this.node.under];
                },
                enumerable: false,
                configurable: true
            });
            class_1.prototype.computeBBox = function (bbox, recompute) {
                if (recompute === void 0) {
                    recompute = false;
                }
                if (this.hasMovableLimits()) {
                    _super.prototype.computeBBox.call(this, bbox, recompute);
                    return;
                }
                bbox.empty();
                var basebox = this.baseChild.getOuterBBox();
                var underbox = this.scriptChild.getOuterBBox();
                var v = this.getUnderKV(basebox, underbox)[1];
                var delta = (this.isLineBelow ? 0 : this.getDelta(true));
                var _a = __read(this.getDeltaW([basebox, underbox], [0, -delta]), 2), bw = _a[0], uw = _a[1];
                bbox.combine(basebox, bw, 0);
                bbox.combine(underbox, uw, v);
                bbox.d += this.font.params.big_op_spacing5;
                bbox.clean();
                this.setChildPWidths(recompute);
            };
            return class_1;
        }(Base));
    }
    exports.CommonMunderMixin = CommonMunderMixin;
    function CommonMoverMixin(Base) {
        return (function (_super) {
            __extends(class_2, _super);
            function class_2() {
                var args = [];
                for (var _i = 0; _i < arguments.length; _i++) {
                    args[_i] = arguments[_i];
                }
                var _this = _super.apply(this, __spreadArray([], __read(args), false)) || this;
                _this.stretchChildren();
                return _this;
            }
            Object.defineProperty(class_2.prototype, "scriptChild", {
                get: function () {
                    return this.childNodes[this.node.over];
                },
                enumerable: false,
                configurable: true
            });
            class_2.prototype.computeBBox = function (bbox) {
                if (this.hasMovableLimits()) {
                    _super.prototype.computeBBox.call(this, bbox);
                    return;
                }
                bbox.empty();
                var basebox = this.baseChild.getOuterBBox();
                var overbox = this.scriptChild.getOuterBBox();
                if (this.node.attributes.get('accent')) {
                    basebox.h = Math.max(basebox.h, this.font.params.x_height * basebox.scale);
                }
                var u = this.getOverKU(basebox, overbox)[1];
                var delta = (this.isLineAbove ? 0 : this.getDelta());
                var _a = __read(this.getDeltaW([basebox, overbox], [0, delta]), 2), bw = _a[0], ow = _a[1];
                bbox.combine(basebox, bw, 0);
                bbox.combine(overbox, ow, u);
                bbox.h += this.font.params.big_op_spacing5;
                bbox.clean();
            };
            return class_2;
        }(Base));
    }
    exports.CommonMoverMixin = CommonMoverMixin;
    function CommonMunderoverMixin(Base) {
        return (function (_super) {
            __extends(class_3, _super);
            function class_3() {
                var args = [];
                for (var _i = 0; _i < arguments.length; _i++) {
                    args[_i] = arguments[_i];
                }
                var _this = _super.apply(this, __spreadArray([], __read(args), false)) || this;
                _this.stretchChildren();
                return _this;
            }
            Object.defineProperty(class_3.prototype, "underChild", {
                get: function () {
                    return this.childNodes[this.node.under];
                },
                enumerable: false,
                configurable: true
            });
            Object.defineProperty(class_3.prototype, "overChild", {
                get: function () {
                    return this.childNodes[this.node.over];
                },
                enumerable: false,
                configurable: true
            });
            Object.defineProperty(class_3.prototype, "subChild", {
                get: function () {
                    return this.underChild;
                },
                enumerable: false,
                configurable: true
            });
            Object.defineProperty(class_3.prototype, "supChild", {
                get: function () {
                    return this.overChild;
                },
                enumerable: false,
                configurable: true
            });
            class_3.prototype.computeBBox = function (bbox) {
                if (this.hasMovableLimits()) {
                    _super.prototype.computeBBox.call(this, bbox);
                    return;
                }
                bbox.empty();
                var overbox = this.overChild.getOuterBBox();
                var basebox = this.baseChild.getOuterBBox();
                var underbox = this.underChild.getOuterBBox();
                if (this.node.attributes.get('accent')) {
                    basebox.h = Math.max(basebox.h, this.font.params.x_height * basebox.scale);
                }
                var u = this.getOverKU(basebox, overbox)[1];
                var v = this.getUnderKV(basebox, underbox)[1];
                var delta = this.getDelta();
                var _a = __read(this.getDeltaW([basebox, underbox, overbox], [0, this.isLineBelow ? 0 : -delta, this.isLineAbove ? 0 : delta]), 3), bw = _a[0], uw = _a[1], ow = _a[2];
                bbox.combine(basebox, bw, 0);
                bbox.combine(overbox, ow, u);
                bbox.combine(underbox, uw, v);
                var z = this.font.params.big_op_spacing5;
                bbox.h += z;
                bbox.d += z;
                bbox.clean();
            };
            return class_3;
        }(Base));
    }
    exports.CommonMunderoverMixin = CommonMunderoverMixin;
},
734: /* mathjax-full/js/core/MmlTree/MmlNodes/munderover.js */ function _(require, module, exports, __esModule, __esExport) {
    var __extends = (this && this.__extends) || (function () {
        var extendStatics = function (d, b) {
            extendStatics = Object.setPrototypeOf ||
                ({ __proto__: [] } instanceof Array && function (d, b) { d.__proto__ = b; }) ||
                function (d, b) { for (var p in b)
                    if (Object.prototype.hasOwnProperty.call(b, p))
                        d[p] = b[p]; };
            return extendStatics(d, b);
        };
        return function (d, b) {
            if (typeof b !== "function" && b !== null)
                throw new TypeError("Class extends value " + String(b) + " is not a constructor or null");
            extendStatics(d, b);
            function __() { this.constructor = d; }
            d.prototype = b === null ? Object.create(b) : (__.prototype = b.prototype, new __());
        };
    })();
    var __assign = (this && this.__assign) || function () {
        __assign = Object.assign || function (t) {
            for (var s, i = 1, n = arguments.length; i < n; i++) {
                s = arguments[i];
                for (var p in s)
                    if (Object.prototype.hasOwnProperty.call(s, p))
                        t[p] = s[p];
            }
            return t;
        };
        return __assign.apply(this, arguments);
    };
    __esModule();
    var MmlNode_js_1 = require(639) /* ../MmlNode.js */;
    var MmlMunderover = (function (_super) {
        __extends(MmlMunderover, _super);
        function MmlMunderover() {
            return _super !== null && _super.apply(this, arguments) || this;
        }
        Object.defineProperty(MmlMunderover.prototype, "kind", {
            get: function () {
                return 'munderover';
            },
            enumerable: false,
            configurable: true
        });
        Object.defineProperty(MmlMunderover.prototype, "arity", {
            get: function () {
                return 3;
            },
            enumerable: false,
            configurable: true
        });
        Object.defineProperty(MmlMunderover.prototype, "base", {
            get: function () {
                return 0;
            },
            enumerable: false,
            configurable: true
        });
        Object.defineProperty(MmlMunderover.prototype, "under", {
            get: function () {
                return 1;
            },
            enumerable: false,
            configurable: true
        });
        Object.defineProperty(MmlMunderover.prototype, "over", {
            get: function () {
                return 2;
            },
            enumerable: false,
            configurable: true
        });
        Object.defineProperty(MmlMunderover.prototype, "linebreakContainer", {
            get: function () {
                return true;
            },
            enumerable: false,
            configurable: true
        });
        MmlMunderover.prototype.setChildInheritedAttributes = function (attributes, display, level, prime) {
            var nodes = this.childNodes;
            nodes[0].setInheritedAttributes(attributes, display, level, prime || !!nodes[this.over]);
            var force = !!(!display && nodes[0].coreMO().attributes.get('movablelimits'));
            var ACCENTS = this.constructor.ACCENTS;
            nodes[1].setInheritedAttributes(attributes, false, this.getScriptlevel(ACCENTS[1], force, level), prime || this.under === 1);
            this.setInheritedAccent(1, ACCENTS[1], display, level, prime, force);
            if (!nodes[2]) {
                return;
            }
            nodes[2].setInheritedAttributes(attributes, false, this.getScriptlevel(ACCENTS[2], force, level), prime || this.under === 2);
            this.setInheritedAccent(2, ACCENTS[2], display, level, prime, force);
        };
        MmlMunderover.prototype.getScriptlevel = function (accent, force, level) {
            if (force || !this.attributes.get(accent)) {
                level++;
            }
            return level;
        };
        MmlMunderover.prototype.setInheritedAccent = function (n, accent, display, level, prime, force) {
            var node = this.childNodes[n];
            if (this.attributes.getExplicit(accent) == null && node.isEmbellished) {
                var value = node.coreMO().attributes.get('accent');
                this.attributes.setInherited(accent, value);
                if (value !== this.attributes.getDefault(accent)) {
                    node.setInheritedAttributes({}, display, this.getScriptlevel(accent, force, level), prime);
                }
            }
        };
        MmlMunderover.defaults = __assign(__assign({}, MmlNode_js_1.AbstractMmlBaseNode.defaults), { accent: false, accentunder: false, align: 'center' });
        MmlMunderover.ACCENTS = ['', 'accentunder', 'accent'];
        return MmlMunderover;
    }(MmlNode_js_1.AbstractMmlBaseNode));
    exports.MmlMunderover = MmlMunderover;
    var MmlMunder = (function (_super) {
        __extends(MmlMunder, _super);
        function MmlMunder() {
            return _super !== null && _super.apply(this, arguments) || this;
        }
        Object.defineProperty(MmlMunder.prototype, "kind", {
            get: function () {
                return 'munder';
            },
            enumerable: false,
            configurable: true
        });
        Object.defineProperty(MmlMunder.prototype, "arity", {
            get: function () {
                return 2;
            },
            enumerable: false,
            configurable: true
        });
        MmlMunder.defaults = __assign({}, MmlMunderover.defaults);
        return MmlMunder;
    }(MmlMunderover));
    exports.MmlMunder = MmlMunder;
    var MmlMover = (function (_super) {
        __extends(MmlMover, _super);
        function MmlMover() {
            return _super !== null && _super.apply(this, arguments) || this;
        }
        Object.defineProperty(MmlMover.prototype, "kind", {
            get: function () {
                return 'mover';
            },
            enumerable: false,
            configurable: true
        });
        Object.defineProperty(MmlMover.prototype, "arity", {
            get: function () {
                return 2;
            },
            enumerable: false,
            configurable: true
        });
        Object.defineProperty(MmlMover.prototype, "over", {
            get: function () {
                return 1;
            },
            enumerable: false,
            configurable: true
        });
        Object.defineProperty(MmlMover.prototype, "under", {
            get: function () {
                return 2;
            },
            enumerable: false,
            configurable: true
        });
        MmlMover.defaults = __assign({}, MmlMunderover.defaults);
        MmlMover.ACCENTS = ['', 'accent', 'accentunder'];
        return MmlMover;
    }(MmlMunderover));
    exports.MmlMover = MmlMover;
},
735: /* mathjax-full/js/output/svg/Wrappers/mmultiscripts.js */ function _(require, module, exports, __esModule, __esExport) {
    var __extends = (this && this.__extends) || (function () {
        var extendStatics = function (d, b) {
            extendStatics = Object.setPrototypeOf ||
                ({ __proto__: [] } instanceof Array && function (d, b) { d.__proto__ = b; }) ||
                function (d, b) { for (var p in b)
                    if (Object.prototype.hasOwnProperty.call(b, p))
                        d[p] = b[p]; };
            return extendStatics(d, b);
        };
        return function (d, b) {
            if (typeof b !== "function" && b !== null)
                throw new TypeError("Class extends value " + String(b) + " is not a constructor or null");
            extendStatics(d, b);
            function __() { this.constructor = d; }
            d.prototype = b === null ? Object.create(b) : (__.prototype = b.prototype, new __());
        };
    })();
    var __read = (this && this.__read) || function (o, n) {
        var m = typeof Symbol === "function" && o[Symbol.iterator];
        if (!m)
            return o;
        var i = m.call(o), r, ar = [], e;
        try {
            while ((n === void 0 || n-- > 0) && !(r = i.next()).done)
                ar.push(r.value);
        }
        catch (error) {
            e = { error: error };
        }
        finally {
            try {
                if (r && !r.done && (m = i["return"]))
                    m.call(i);
            }
            finally {
                if (e)
                    throw e.error;
            }
        }
        return ar;
    };
    __esModule();
    var msubsup_js_1 = require(727) /* ./msubsup.js */;
    var mmultiscripts_js_1 = require(736) /* ../../common/Wrappers/mmultiscripts.js */;
    var mmultiscripts_js_2 = require(737) /* ../../../core/MmlTree/MmlNodes/mmultiscripts.js */;
    var string_js_1 = require(636) /* ../../../util/string.js */;
    function AlignX(align) {
        return {
            left: function (_w, _W) { return 0; },
            center: function (w, W) { return (W - w) / 2; },
            right: function (w, W) { return W - w; }
        }[align] || (function (_w, _W) { return 0; });
    }
    exports.AlignX = AlignX;
    var SVGmmultiscripts = (function (_super) {
        __extends(SVGmmultiscripts, _super);
        function SVGmmultiscripts() {
            return _super !== null && _super.apply(this, arguments) || this;
        }
        SVGmmultiscripts.prototype.toSVG = function (parent) {
            var svg = this.standardSVGnode(parent);
            var data = this.scriptData;
            var scriptalign = this.node.getProperty('scriptalign') || 'right left';
            var _a = __read((0, string_js_1.split)(scriptalign + ' ' + scriptalign), 2), preAlign = _a[0], postAlign = _a[1];
            var sub = this.combinePrePost(data.sub, data.psub);
            var sup = this.combinePrePost(data.sup, data.psup);
            var _b = __read(this.getUVQ(sub, sup), 2), u = _b[0], v = _b[1];
            var x = 0;
            if (data.numPrescripts) {
                x = this.addScripts(.05, u, v, this.firstPrescript, data.numPrescripts, preAlign);
            }
            var base = this.baseChild;
            base.toSVG(svg);
            base.place(x, 0);
            x += base.getOuterBBox().w;
            if (data.numScripts) {
                this.addScripts(x, u, v, 1, data.numScripts, postAlign);
            }
        };
        SVGmmultiscripts.prototype.addScripts = function (x, u, v, i, n, align) {
            var adaptor = this.adaptor;
            var alignX = AlignX(align);
            var supRow = adaptor.append(this.element, this.svg('g'));
            var subRow = adaptor.append(this.element, this.svg('g'));
            this.place(x, u, supRow);
            this.place(x, v, subRow);
            var m = i + 2 * n;
            var dx = 0;
            while (i < m) {
                var _a = __read([this.childNodes[i++], this.childNodes[i++]], 2), sub = _a[0], sup = _a[1];
                var _b = __read([sub.getOuterBBox(), sup.getOuterBBox()], 2), subbox = _b[0], supbox = _b[1];
                var _c = __read([subbox.rscale, supbox.rscale], 2), subr = _c[0], supr = _c[1];
                var w = Math.max(subbox.w * subr, supbox.w * supr);
                sub.toSVG(subRow);
                sup.toSVG(supRow);
                sub.place(dx + alignX(subbox.w * subr, w), 0);
                sup.place(dx + alignX(supbox.w * supr, w), 0);
                dx += w;
            }
            return x + dx;
        };
        SVGmmultiscripts.kind = mmultiscripts_js_2.MmlMmultiscripts.prototype.kind;
        return SVGmmultiscripts;
    }((0, mmultiscripts_js_1.CommonMmultiscriptsMixin)(msubsup_js_1.SVGmsubsup)));
    exports.SVGmmultiscripts = SVGmmultiscripts;
},
736: /* mathjax-full/js/output/common/Wrappers/mmultiscripts.js */ function _(require, module, exports, __esModule, __esExport) {
    var __extends = (this && this.__extends) || (function () {
        var extendStatics = function (d, b) {
            extendStatics = Object.setPrototypeOf ||
                ({ __proto__: [] } instanceof Array && function (d, b) { d.__proto__ = b; }) ||
                function (d, b) { for (var p in b)
                    if (Object.prototype.hasOwnProperty.call(b, p))
                        d[p] = b[p]; };
            return extendStatics(d, b);
        };
        return function (d, b) {
            if (typeof b !== "function" && b !== null)
                throw new TypeError("Class extends value " + String(b) + " is not a constructor or null");
            extendStatics(d, b);
            function __() { this.constructor = d; }
            d.prototype = b === null ? Object.create(b) : (__.prototype = b.prototype, new __());
        };
    })();
    var __read = (this && this.__read) || function (o, n) {
        var m = typeof Symbol === "function" && o[Symbol.iterator];
        if (!m)
            return o;
        var i = m.call(o), r, ar = [], e;
        try {
            while ((n === void 0 || n-- > 0) && !(r = i.next()).done)
                ar.push(r.value);
        }
        catch (error) {
            e = { error: error };
        }
        finally {
            try {
                if (r && !r.done && (m = i["return"]))
                    m.call(i);
            }
            finally {
                if (e)
                    throw e.error;
            }
        }
        return ar;
    };
    var __spreadArray = (this && this.__spreadArray) || function (to, from, pack) {
        if (pack || arguments.length === 2)
            for (var i = 0, l = from.length, ar; i < l; i++) {
                if (ar || !(i in from)) {
                    if (!ar)
                        ar = Array.prototype.slice.call(from, 0, i);
                    ar[i] = from[i];
                }
            }
        return to.concat(ar || Array.prototype.slice.call(from));
    };
    var __values = (this && this.__values) || function (o) {
        var s = typeof Symbol === "function" && Symbol.iterator, m = s && o[s], i = 0;
        if (m)
            return m.call(o);
        if (o && typeof o.length === "number")
            return {
                next: function () {
                    if (o && i >= o.length)
                        o = void 0;
                    return { value: o && o[i++], done: !o };
                }
            };
        throw new TypeError(s ? "Object is not iterable." : "Symbol.iterator is not defined.");
    };
    __esModule();
    var BBox_js_1 = require(681) /* ../../../util/BBox.js */;
    exports.NextScript = {
        base: 'subList',
        subList: 'supList',
        supList: 'subList',
        psubList: 'psupList',
        psupList: 'psubList',
    };
    exports.ScriptNames = ['sup', 'sup', 'psup', 'psub'];
    function CommonMmultiscriptsMixin(Base) {
        return (function (_super) {
            __extends(class_1, _super);
            function class_1() {
                var args = [];
                for (var _i = 0; _i < arguments.length; _i++) {
                    args[_i] = arguments[_i];
                }
                var _this = _super.apply(this, __spreadArray([], __read(args), false)) || this;
                _this.scriptData = null;
                _this.firstPrescript = 0;
                _this.getScriptData();
                return _this;
            }
            class_1.prototype.combinePrePost = function (pre, post) {
                var bbox = new BBox_js_1.BBox(pre);
                bbox.combine(post, 0, 0);
                return bbox;
            };
            class_1.prototype.computeBBox = function (bbox, recompute) {
                if (recompute === void 0) {
                    recompute = false;
                }
                var scriptspace = this.font.params.scriptspace;
                var data = this.scriptData;
                var sub = this.combinePrePost(data.sub, data.psub);
                var sup = this.combinePrePost(data.sup, data.psup);
                var _a = __read(this.getUVQ(sub, sup), 2), u = _a[0], v = _a[1];
                bbox.empty();
                if (data.numPrescripts) {
                    bbox.combine(data.psup, scriptspace, u);
                    bbox.combine(data.psub, scriptspace, v);
                }
                bbox.append(data.base);
                if (data.numScripts) {
                    var w = bbox.w;
                    bbox.combine(data.sup, w, u);
                    bbox.combine(data.sub, w, v);
                    bbox.w += scriptspace;
                }
                bbox.clean();
                this.setChildPWidths(recompute);
            };
            class_1.prototype.getScriptData = function () {
                var data = this.scriptData = {
                    base: null, sub: BBox_js_1.BBox.empty(), sup: BBox_js_1.BBox.empty(), psub: BBox_js_1.BBox.empty(), psup: BBox_js_1.BBox.empty(),
                    numPrescripts: 0, numScripts: 0
                };
                var lists = this.getScriptBBoxLists();
                this.combineBBoxLists(data.sub, data.sup, lists.subList, lists.supList);
                this.combineBBoxLists(data.psub, data.psup, lists.psubList, lists.psupList);
                data.base = lists.base[0];
                data.numPrescripts = lists.psubList.length;
                data.numScripts = lists.subList.length;
            };
            class_1.prototype.getScriptBBoxLists = function () {
                var e_1, _a;
                var lists = {
                    base: [], subList: [], supList: [], psubList: [], psupList: []
                };
                var script = 'base';
                try {
                    for (var _b = __values(this.childNodes), _c = _b.next(); !_c.done; _c = _b.next()) {
                        var child = _c.value;
                        if (child.node.isKind('mprescripts')) {
                            script = 'psubList';
                        }
                        else {
                            lists[script].push(child.getOuterBBox());
                            script = exports.NextScript[script];
                        }
                    }
                }
                catch (e_1_1) {
                    e_1 = { error: e_1_1 };
                }
                finally {
                    try {
                        if (_c && !_c.done && (_a = _b.return))
                            _a.call(_b);
                    }
                    finally {
                        if (e_1)
                            throw e_1.error;
                    }
                }
                this.firstPrescript = lists.subList.length + lists.supList.length + 2;
                this.padLists(lists.subList, lists.supList);
                this.padLists(lists.psubList, lists.psupList);
                return lists;
            };
            class_1.prototype.padLists = function (list1, list2) {
                if (list1.length > list2.length) {
                    list2.push(BBox_js_1.BBox.empty());
                }
            };
            class_1.prototype.combineBBoxLists = function (bbox1, bbox2, list1, list2) {
                for (var i = 0; i < list1.length; i++) {
                    var _a = __read(this.getScaledWHD(list1[i]), 3), w1 = _a[0], h1 = _a[1], d1 = _a[2];
                    var _b = __read(this.getScaledWHD(list2[i]), 3), w2 = _b[0], h2 = _b[1], d2 = _b[2];
                    var w = Math.max(w1, w2);
                    bbox1.w += w;
                    bbox2.w += w;
                    if (h1 > bbox1.h)
                        bbox1.h = h1;
                    if (d1 > bbox1.d)
                        bbox1.d = d1;
                    if (h2 > bbox2.h)
                        bbox2.h = h2;
                    if (d2 > bbox2.d)
                        bbox2.d = d2;
                }
            };
            class_1.prototype.getScaledWHD = function (bbox) {
                var w = bbox.w, h = bbox.h, d = bbox.d, rscale = bbox.rscale;
                return [w * rscale, h * rscale, d * rscale];
            };
            class_1.prototype.getUVQ = function (subbox, supbox) {
                var _a;
                if (!this.UVQ) {
                    var _b = __read([0, 0, 0], 3), u = _b[0], v = _b[1], q = _b[2];
                    if (subbox.h === 0 && subbox.d === 0) {
                        u = this.getU();
                    }
                    else if (supbox.h === 0 && supbox.d === 0) {
                        u = -this.getV();
                    }
                    else {
                        _a = __read(_super.prototype.getUVQ.call(this, subbox, supbox), 3), u = _a[0], v = _a[1], q = _a[2];
                    }
                    this.UVQ = [u, v, q];
                }
                return this.UVQ;
            };
            return class_1;
        }(Base));
    }
    exports.CommonMmultiscriptsMixin = CommonMmultiscriptsMixin;
},
737: /* mathjax-full/js/core/MmlTree/MmlNodes/mmultiscripts.js */ function _(require, module, exports, __esModule, __esExport) {
    var __extends = (this && this.__extends) || (function () {
        var extendStatics = function (d, b) {
            extendStatics = Object.setPrototypeOf ||
                ({ __proto__: [] } instanceof Array && function (d, b) { d.__proto__ = b; }) ||
                function (d, b) { for (var p in b)
                    if (Object.prototype.hasOwnProperty.call(b, p))
                        d[p] = b[p]; };
            return extendStatics(d, b);
        };
        return function (d, b) {
            if (typeof b !== "function" && b !== null)
                throw new TypeError("Class extends value " + String(b) + " is not a constructor or null");
            extendStatics(d, b);
            function __() { this.constructor = d; }
            d.prototype = b === null ? Object.create(b) : (__.prototype = b.prototype, new __());
        };
    })();
    var __assign = (this && this.__assign) || function () {
        __assign = Object.assign || function (t) {
            for (var s, i = 1, n = arguments.length; i < n; i++) {
                s = arguments[i];
                for (var p in s)
                    if (Object.prototype.hasOwnProperty.call(s, p))
                        t[p] = s[p];
            }
            return t;
        };
        return __assign.apply(this, arguments);
    };
    __esModule();
    var MmlNode_js_1 = require(639) /* ../MmlNode.js */;
    var msubsup_js_1 = require(731) /* ./msubsup.js */;
    var MmlMmultiscripts = (function (_super) {
        __extends(MmlMmultiscripts, _super);
        function MmlMmultiscripts() {
            return _super !== null && _super.apply(this, arguments) || this;
        }
        Object.defineProperty(MmlMmultiscripts.prototype, "kind", {
            get: function () {
                return 'mmultiscripts';
            },
            enumerable: false,
            configurable: true
        });
        Object.defineProperty(MmlMmultiscripts.prototype, "arity", {
            get: function () {
                return 1;
            },
            enumerable: false,
            configurable: true
        });
        MmlMmultiscripts.prototype.setChildInheritedAttributes = function (attributes, display, level, prime) {
            this.childNodes[0].setInheritedAttributes(attributes, display, level, prime);
            var prescripts = false;
            for (var i = 1, n = 0; i < this.childNodes.length; i++) {
                var child = this.childNodes[i];
                if (child.isKind('mprescripts')) {
                    if (!prescripts) {
                        prescripts = true;
                        if (i % 2 === 0) {
                            var mrow = this.factory.create('mrow');
                            this.childNodes.splice(i, 0, mrow);
                            mrow.parent = this;
                            i++;
                        }
                    }
                }
                else {
                    var primestyle = prime || (n % 2 === 0);
                    child.setInheritedAttributes(attributes, false, level + 1, primestyle);
                    n++;
                }
            }
            if (this.childNodes.length % 2 === (prescripts ? 1 : 0)) {
                this.appendChild(this.factory.create('mrow'));
                this.childNodes[this.childNodes.length - 1].setInheritedAttributes(attributes, false, level + 1, prime);
            }
        };
        MmlMmultiscripts.prototype.verifyChildren = function (options) {
            var prescripts = false;
            var fix = options['fixMmultiscripts'];
            for (var i = 0; i < this.childNodes.length; i++) {
                var child = this.childNodes[i];
                if (child.isKind('mprescripts')) {
                    if (prescripts) {
                        child.mError(child.kind + ' can only appear once in ' + this.kind, options, true);
                    }
                    else {
                        prescripts = true;
                        if (i % 2 === 0 && !fix) {
                            this.mError('There must be an equal number of prescripts of each type', options);
                        }
                    }
                }
            }
            if (this.childNodes.length % 2 === (prescripts ? 1 : 0) && !fix) {
                this.mError('There must be an equal number of scripts of each type', options);
            }
            _super.prototype.verifyChildren.call(this, options);
        };
        MmlMmultiscripts.defaults = __assign({}, msubsup_js_1.MmlMsubsup.defaults);
        return MmlMmultiscripts;
    }(msubsup_js_1.MmlMsubsup));
    exports.MmlMmultiscripts = MmlMmultiscripts;
    var MmlMprescripts = (function (_super) {
        __extends(MmlMprescripts, _super);
        function MmlMprescripts() {
            return _super !== null && _super.apply(this, arguments) || this;
        }
        Object.defineProperty(MmlMprescripts.prototype, "kind", {
            get: function () {
                return 'mprescripts';
            },
            enumerable: false,
            configurable: true
        });
        Object.defineProperty(MmlMprescripts.prototype, "arity", {
            get: function () {
                return 0;
            },
            enumerable: false,
            configurable: true
        });
        MmlMprescripts.prototype.verifyTree = function (options) {
            _super.prototype.verifyTree.call(this, options);
            if (this.parent && !this.parent.isKind('mmultiscripts')) {
                this.mError(this.kind + ' must be a child of mmultiscripts', options, true);
            }
        };
        MmlMprescripts.defaults = __assign({}, MmlNode_js_1.AbstractMmlNode.defaults);
        return MmlMprescripts;
    }(MmlNode_js_1.AbstractMmlNode));
    exports.MmlMprescripts = MmlMprescripts;
    var MmlNone = (function (_super) {
        __extends(MmlNone, _super);
        function MmlNone() {
            return _super !== null && _super.apply(this, arguments) || this;
        }
        Object.defineProperty(MmlNone.prototype, "kind", {
            get: function () {
                return 'none';
            },
            enumerable: false,
            configurable: true
        });
        Object.defineProperty(MmlNone.prototype, "arity", {
            get: function () {
                return 0;
            },
            enumerable: false,
            configurable: true
        });
        MmlNone.prototype.verifyTree = function (options) {
            _super.prototype.verifyTree.call(this, options);
            if (this.parent && !this.parent.isKind('mmultiscripts')) {
                this.mError(this.kind + ' must be a child of mmultiscripts', options, true);
            }
        };
        MmlNone.defaults = __assign({}, MmlNode_js_1.AbstractMmlNode.defaults);
        return MmlNone;
    }(MmlNode_js_1.AbstractMmlNode));
    exports.MmlNone = MmlNone;
},
738: /* mathjax-full/js/output/svg/Wrappers/mtable.js */ function _(require, module, exports, __esModule, __esExport) {
    var __extends = (this && this.__extends) || (function () {
        var extendStatics = function (d, b) {
            extendStatics = Object.setPrototypeOf ||
                ({ __proto__: [] } instanceof Array && function (d, b) { d.__proto__ = b; }) ||
                function (d, b) { for (var p in b)
                    if (Object.prototype.hasOwnProperty.call(b, p))
                        d[p] = b[p]; };
            return extendStatics(d, b);
        };
        return function (d, b) {
            if (typeof b !== "function" && b !== null)
                throw new TypeError("Class extends value " + String(b) + " is not a constructor or null");
            extendStatics(d, b);
            function __() { this.constructor = d; }
            d.prototype = b === null ? Object.create(b) : (__.prototype = b.prototype, new __());
        };
    })();
    var __read = (this && this.__read) || function (o, n) {
        var m = typeof Symbol === "function" && o[Symbol.iterator];
        if (!m)
            return o;
        var i = m.call(o), r, ar = [], e;
        try {
            while ((n === void 0 || n-- > 0) && !(r = i.next()).done)
                ar.push(r.value);
        }
        catch (error) {
            e = { error: error };
        }
        finally {
            try {
                if (r && !r.done && (m = i["return"]))
                    m.call(i);
            }
            finally {
                if (e)
                    throw e.error;
            }
        }
        return ar;
    };
    var __spreadArray = (this && this.__spreadArray) || function (to, from, pack) {
        if (pack || arguments.length === 2)
            for (var i = 0, l = from.length, ar; i < l; i++) {
                if (ar || !(i in from)) {
                    if (!ar)
                        ar = Array.prototype.slice.call(from, 0, i);
                    ar[i] = from[i];
                }
            }
        return to.concat(ar || Array.prototype.slice.call(from));
    };
    __esModule();
    var Wrapper_js_1 = require(680) /* ../Wrapper.js */;
    var mtable_js_1 = require(739) /* ../../common/Wrappers/mtable.js */;
    var mtable_js_2 = require(741) /* ../../../core/MmlTree/MmlNodes/mtable.js */;
    var CLASSPREFIX = 'mjx-';
    var SVGmtable = (function (_super) {
        __extends(SVGmtable, _super);
        function SVGmtable(factory, node, parent) {
            if (parent === void 0) {
                parent = null;
            }
            var _this = _super.call(this, factory, node, parent) || this;
            var def = { 'data-labels': true };
            if (_this.isTop) {
                def.transform = 'matrix(1 0 0 -1 0 0)';
            }
            _this.labels = _this.svg('g', def);
            return _this;
        }
        SVGmtable.prototype.toSVG = function (parent) {
            var svg = this.standardSVGnode(parent);
            this.placeRows(svg);
            this.handleColumnLines(svg);
            this.handleRowLines(svg);
            this.handleFrame(svg);
            var dx = this.handlePWidth(svg);
            this.handleLabels(svg, parent, dx);
        };
        SVGmtable.prototype.placeRows = function (svg) {
            var _a, _b, _c;
            var equal = this.node.attributes.get('equalrows');
            var _d = this.getTableData(), H = _d.H, D = _d.D;
            var HD = this.getEqualRowHeight();
            var rSpace = this.getRowHalfSpacing();
            var rLines = __spreadArray(__spreadArray([this.fLine], __read(this.rLines), false), [this.fLine], false);
            var y = this.getBBox().h - rLines[0];
            for (var i = 0; i < this.numRows; i++) {
                var row = this.childNodes[i];
                _a = __read(this.getRowHD(equal, HD, H[i], D[i]), 2), row.H = _a[0], row.D = _a[1];
                _b = __read([rSpace[i], rSpace[i + 1]], 2), row.tSpace = _b[0], row.bSpace = _b[1];
                _c = __read([rLines[i], rLines[i + 1]], 2), row.tLine = _c[0], row.bLine = _c[1];
                row.toSVG(svg);
                row.place(0, y - rSpace[i] - row.H);
                y -= rSpace[i] + row.H + row.D + rSpace[i + 1] + rLines[i + 1];
            }
        };
        SVGmtable.prototype.getRowHD = function (equal, HD, H, D) {
            return (equal ? [(HD + H - D) / 2, (HD - H + D) / 2] : [H, D]);
        };
        SVGmtable.prototype.handleColor = function () {
            _super.prototype.handleColor.call(this);
            var rect = this.firstChild();
            if (rect) {
                this.adaptor.setAttribute(rect, 'width', this.fixed(this.getWidth()));
            }
        };
        SVGmtable.prototype.handleColumnLines = function (svg) {
            if (this.node.attributes.get('columnlines') === 'none')
                return;
            var lines = this.getColumnAttributes('columnlines');
            if (!lines)
                return;
            var cSpace = this.getColumnHalfSpacing();
            var cLines = this.cLines;
            var cWidth = this.getComputedWidths();
            var x = this.fLine;
            for (var i = 0; i < lines.length; i++) {
                x += cSpace[i] + cWidth[i] + cSpace[i + 1];
                if (lines[i] !== 'none') {
                    this.adaptor.append(svg, this.makeVLine(x, lines[i], cLines[i]));
                }
                x += cLines[i];
            }
        };
        SVGmtable.prototype.handleRowLines = function (svg) {
            if (this.node.attributes.get('rowlines') === 'none')
                return;
            var lines = this.getRowAttributes('rowlines');
            if (!lines)
                return;
            var equal = this.node.attributes.get('equalrows');
            var _a = this.getTableData(), H = _a.H, D = _a.D;
            var HD = this.getEqualRowHeight();
            var rSpace = this.getRowHalfSpacing();
            var rLines = this.rLines;
            var y = this.getBBox().h - this.fLine;
            for (var i = 0; i < lines.length; i++) {
                var _b = __read(this.getRowHD(equal, HD, H[i], D[i]), 2), rH = _b[0], rD = _b[1];
                y -= rSpace[i] + rH + rD + rSpace[i + 1];
                if (lines[i] !== 'none') {
                    this.adaptor.append(svg, this.makeHLine(y, lines[i], rLines[i]));
                }
                y -= rLines[i];
            }
        };
        SVGmtable.prototype.handleFrame = function (svg) {
            if (this.frame && this.fLine) {
                var _a = this.getBBox(), h = _a.h, d = _a.d, w = _a.w;
                var style = this.node.attributes.get('frame');
                this.adaptor.append(svg, this.makeFrame(w, h, d, style));
            }
        };
        SVGmtable.prototype.handlePWidth = function (svg) {
            if (!this.pWidth) {
                return 0;
            }
            var _a = this.getBBox(), w = _a.w, L = _a.L, R = _a.R;
            var W = L + this.pWidth + R;
            var align = this.getAlignShift()[0];
            var CW = Math.max(this.isTop ? W : 0, this.container.getWrapWidth(this.containerI)) - L - R;
            var dw = w - (this.pWidth > CW ? CW : this.pWidth);
            var dx = (align === 'left' ? 0 : align === 'right' ? dw : dw / 2);
            if (dx) {
                var table = this.svg('g', {}, this.adaptor.childNodes(svg));
                this.place(dx, 0, table);
                this.adaptor.append(svg, table);
            }
            return dx;
        };
        SVGmtable.prototype.lineClass = function (style) {
            return CLASSPREFIX + style;
        };
        SVGmtable.prototype.makeFrame = function (w, h, d, style) {
            var t = this.fLine;
            return this.svg('rect', this.setLineThickness(t, style, {
                'data-frame': true, 'class': this.lineClass(style),
                width: this.fixed(w - t), height: this.fixed(h + d - t),
                x: this.fixed(t / 2), y: this.fixed(t / 2 - d)
            }));
        };
        SVGmtable.prototype.makeVLine = function (x, style, t) {
            var _a = this.getBBox(), h = _a.h, d = _a.d;
            var dt = (style === 'dotted' ? t / 2 : 0);
            var X = this.fixed(x + t / 2);
            return this.svg('line', this.setLineThickness(t, style, {
                'data-line': 'v', 'class': this.lineClass(style),
                x1: X, y1: this.fixed(dt - d), x2: X, y2: this.fixed(h - dt)
            }));
        };
        SVGmtable.prototype.makeHLine = function (y, style, t) {
            var w = this.getBBox().w;
            var dt = (style === 'dotted' ? t / 2 : 0);
            var Y = this.fixed(y - t / 2);
            return this.svg('line', this.setLineThickness(t, style, {
                'data-line': 'h', 'class': this.lineClass(style),
                x1: this.fixed(dt), y1: Y, x2: this.fixed(w - dt), y2: Y
            }));
        };
        SVGmtable.prototype.setLineThickness = function (t, style, properties) {
            if (t !== .07) {
                properties['stroke-thickness'] = this.fixed(t);
                if (style !== 'solid') {
                    properties['stroke-dasharray'] = (style === 'dotted' ? '0,' : '') + this.fixed(2 * t);
                }
            }
            return properties;
        };
        SVGmtable.prototype.handleLabels = function (svg, _parent, dx) {
            if (!this.hasLabels)
                return;
            var labels = this.labels;
            var attributes = this.node.attributes;
            var side = attributes.get('side');
            this.spaceLabels();
            this.isTop ? this.topTable(svg, labels, side) : this.subTable(svg, labels, side, dx);
        };
        SVGmtable.prototype.spaceLabels = function () {
            var adaptor = this.adaptor;
            var h = this.getBBox().h;
            var L = this.getTableData().L;
            var space = this.getRowHalfSpacing();
            var y = h - this.fLine;
            var current = adaptor.firstChild(this.labels);
            for (var i = 0; i < this.numRows; i++) {
                var row = this.childNodes[i];
                if (row.node.isKind('mlabeledtr')) {
                    var cell = row.childNodes[0];
                    y -= space[i] + row.H;
                    row.placeCell(cell, { x: 0, y: y, w: L, lSpace: 0, rSpace: 0, lLine: 0, rLine: 0 });
                    y -= row.D + space[i + 1] + this.rLines[i];
                    current = adaptor.next(current);
                }
                else {
                    y -= space[i] + row.H + row.D + space[i + 1] + this.rLines[i];
                }
            }
        };
        SVGmtable.prototype.topTable = function (svg, labels, side) {
            var adaptor = this.adaptor;
            var _a = this.getBBox(), h = _a.h, d = _a.d, w = _a.w, L = _a.L, R = _a.R;
            var W = L + (this.pWidth || w) + R;
            var LW = this.getTableData().L;
            var _b = __read(this.getPadAlignShift(side), 3), align = _b[1], shift = _b[2];
            var dx = shift + (align === 'right' ? -W : align === 'center' ? -W / 2 : 0) + L;
            var matrix = 'matrix(1 0 0 -1 0 0)';
            var scale = "scale(".concat(this.jax.fixed((this.font.params.x_height * 1000) / this.metrics.ex, 2), ")");
            var transform = "translate(0 ".concat(this.fixed(h), ") ").concat(matrix, " ").concat(scale);
            var table = this.svg('svg', {
                'data-table': true,
                preserveAspectRatio: (align === 'left' ? 'xMinYMid' : align === 'right' ? 'xMaxYMid' : 'xMidYMid'),
                viewBox: [this.fixed(-dx), this.fixed(-h), 1, this.fixed(h + d)].join(' ')
            }, [
                this.svg('g', { transform: matrix }, adaptor.childNodes(svg))
            ]);
            labels = this.svg('svg', {
                'data-labels': true,
                preserveAspectRatio: (side === 'left' ? 'xMinYMid' : 'xMaxYMid'),
                viewBox: [side === 'left' ? 0 : this.fixed(LW), this.fixed(-h), 1, this.fixed(h + d)].join(' ')
            }, [labels]);
            adaptor.append(svg, this.svg('g', { transform: transform }, [table, labels]));
            this.place(-L, 0, svg);
        };
        SVGmtable.prototype.subTable = function (svg, labels, side, dx) {
            var adaptor = this.adaptor;
            var _a = this.getBBox(), w = _a.w, L = _a.L, R = _a.R;
            var W = L + (this.pWidth || w) + R;
            var labelW = this.getTableData().L;
            var align = this.getAlignShift()[0];
            var CW = Math.max(W, this.container.getWrapWidth(this.containerI));
            this.place(side === 'left' ?
                (align === 'left' ? 0 : align === 'right' ? W - CW + dx : (W - CW) / 2 + dx) - L :
                (align === 'left' ? CW : align === 'right' ? W + dx : (CW + W) / 2 + dx) - L - labelW, 0, labels);
            adaptor.append(svg, labels);
        };
        SVGmtable.kind = mtable_js_2.MmlMtable.prototype.kind;
        SVGmtable.styles = {
            'g[data-mml-node="mtable"] > line[data-line], svg[data-table] > g > line[data-line]': {
                'stroke-width': '70px',
                fill: 'none'
            },
            'g[data-mml-node="mtable"] > rect[data-frame], svg[data-table] > g > rect[data-frame]': {
                'stroke-width': '70px',
                fill: 'none'
            },
            'g[data-mml-node="mtable"] > .mjx-dashed, svg[data-table] > g > .mjx-dashed': {
                'stroke-dasharray': '140'
            },
            'g[data-mml-node="mtable"] > .mjx-dotted, svg[data-table] > g > .mjx-dotted': {
                'stroke-linecap': 'round',
                'stroke-dasharray': '0,140'
            },
            'g[data-mml-node="mtable"] > g > svg': {
                overflow: 'visible'
            }
        };
        return SVGmtable;
    }((0, mtable_js_1.CommonMtableMixin)(Wrapper_js_1.SVGWrapper)));
    exports.SVGmtable = SVGmtable;
},
739: /* mathjax-full/js/output/common/Wrappers/mtable.js */ function _(require, module, exports, __esModule, __esExport) {
    var __extends = (this && this.__extends) || (function () {
        var extendStatics = function (d, b) {
            extendStatics = Object.setPrototypeOf ||
                ({ __proto__: [] } instanceof Array && function (d, b) { d.__proto__ = b; }) ||
                function (d, b) { for (var p in b)
                    if (Object.prototype.hasOwnProperty.call(b, p))
                        d[p] = b[p]; };
            return extendStatics(d, b);
        };
        return function (d, b) {
            if (typeof b !== "function" && b !== null)
                throw new TypeError("Class extends value " + String(b) + " is not a constructor or null");
            extendStatics(d, b);
            function __() { this.constructor = d; }
            d.prototype = b === null ? Object.create(b) : (__.prototype = b.prototype, new __());
        };
    })();
    var __read = (this && this.__read) || function (o, n) {
        var m = typeof Symbol === "function" && o[Symbol.iterator];
        if (!m)
            return o;
        var i = m.call(o), r, ar = [], e;
        try {
            while ((n === void 0 || n-- > 0) && !(r = i.next()).done)
                ar.push(r.value);
        }
        catch (error) {
            e = { error: error };
        }
        finally {
            try {
                if (r && !r.done && (m = i["return"]))
                    m.call(i);
            }
            finally {
                if (e)
                    throw e.error;
            }
        }
        return ar;
    };
    var __spreadArray = (this && this.__spreadArray) || function (to, from, pack) {
        if (pack || arguments.length === 2)
            for (var i = 0, l = from.length, ar; i < l; i++) {
                if (ar || !(i in from)) {
                    if (!ar)
                        ar = Array.prototype.slice.call(from, 0, i);
                    ar[i] = from[i];
                }
            }
        return to.concat(ar || Array.prototype.slice.call(from));
    };
    var __values = (this && this.__values) || function (o) {
        var s = typeof Symbol === "function" && Symbol.iterator, m = s && o[s], i = 0;
        if (m)
            return m.call(o);
        if (o && typeof o.length === "number")
            return {
                next: function () {
                    if (o && i >= o.length)
                        o = void 0;
                    return { value: o && o[i++], done: !o };
                }
            };
        throw new TypeError(s ? "Object is not iterable." : "Symbol.iterator is not defined.");
    };
    __esModule();
    var BBox_js_1 = require(681) /* ../../../util/BBox.js */;
    var string_js_1 = require(636) /* ../../../util/string.js */;
    var numeric_js_1 = require(740) /* ../../../util/numeric.js */;
    function CommonMtableMixin(Base) {
        return (function (_super) {
            __extends(class_1, _super);
            function class_1() {
                var args = [];
                for (var _i = 0; _i < arguments.length; _i++) {
                    args[_i] = arguments[_i];
                }
                var _this = _super.apply(this, __spreadArray([], __read(args), false)) || this;
                _this.numCols = 0;
                _this.numRows = 0;
                _this.data = null;
                _this.pwidthCells = [];
                _this.pWidth = 0;
                _this.numCols = (0, numeric_js_1.max)(_this.tableRows.map(function (row) { return row.numCells; }));
                _this.numRows = _this.childNodes.length;
                _this.hasLabels = _this.childNodes.reduce(function (value, row) { return value || row.node.isKind('mlabeledtr'); }, false);
                _this.findContainer();
                _this.isTop = !_this.container || (_this.container.node.isKind('math') && !_this.container.parent);
                if (_this.isTop) {
                    _this.jax.table = _this;
                }
                _this.getPercentageWidth();
                var attributes = _this.node.attributes;
                _this.frame = attributes.get('frame') !== 'none';
                _this.fLine = (_this.frame && attributes.get('frame') ? .07 : 0);
                _this.fSpace = (_this.frame ? _this.convertLengths(_this.getAttributeArray('framespacing')) : [0, 0]);
                _this.cSpace = _this.convertLengths(_this.getColumnAttributes('columnspacing'));
                _this.rSpace = _this.convertLengths(_this.getRowAttributes('rowspacing'));
                _this.cLines = _this.getColumnAttributes('columnlines').map(function (x) { return (x === 'none' ? 0 : .07); });
                _this.rLines = _this.getRowAttributes('rowlines').map(function (x) { return (x === 'none' ? 0 : .07); });
                _this.cWidths = _this.getColumnWidths();
                _this.stretchRows();
                _this.stretchColumns();
                return _this;
            }
            Object.defineProperty(class_1.prototype, "tableRows", {
                get: function () {
                    return this.childNodes;
                },
                enumerable: false,
                configurable: true
            });
            class_1.prototype.findContainer = function () {
                var node = this;
                var parent = node.parent;
                while (parent && (parent.node.notParent || parent.node.isKind('mrow'))) {
                    node = parent;
                    parent = parent.parent;
                }
                this.container = parent;
                this.containerI = node.node.childPosition();
            };
            class_1.prototype.getPercentageWidth = function () {
                if (this.hasLabels) {
                    this.bbox.pwidth = BBox_js_1.BBox.fullWidth;
                }
                else {
                    var width = this.node.attributes.get('width');
                    if ((0, string_js_1.isPercent)(width)) {
                        this.bbox.pwidth = width;
                    }
                }
            };
            class_1.prototype.stretchRows = function () {
                var equal = this.node.attributes.get('equalrows');
                var HD = (equal ? this.getEqualRowHeight() : 0);
                var _a = (equal ? this.getTableData() : { H: [0], D: [0] }), H = _a.H, D = _a.D;
                var rows = this.tableRows;
                for (var i = 0; i < this.numRows; i++) {
                    var hd = (equal ? [(HD + H[i] - D[i]) / 2, (HD - H[i] + D[i]) / 2] : null);
                    rows[i].stretchChildren(hd);
                }
            };
            class_1.prototype.stretchColumns = function () {
                for (var i = 0; i < this.numCols; i++) {
                    var width = (typeof this.cWidths[i] === 'number' ? this.cWidths[i] : null);
                    this.stretchColumn(i, width);
                }
            };
            class_1.prototype.stretchColumn = function (i, W) {
                var e_1, _a, e_2, _b, e_3, _c;
                var stretchy = [];
                try {
                    for (var _d = __values(this.tableRows), _e = _d.next(); !_e.done; _e = _d.next()) {
                        var row = _e.value;
                        var cell = row.getChild(i);
                        if (cell) {
                            var child = cell.childNodes[0];
                            if (child.stretch.dir === 0 &&
                                child.canStretch(2)) {
                                stretchy.push(child);
                            }
                        }
                    }
                }
                catch (e_1_1) {
                    e_1 = { error: e_1_1 };
                }
                finally {
                    try {
                        if (_e && !_e.done && (_a = _d.return))
                            _a.call(_d);
                    }
                    finally {
                        if (e_1)
                            throw e_1.error;
                    }
                }
                var count = stretchy.length;
                var nodeCount = this.childNodes.length;
                if (count && nodeCount > 1) {
                    if (W === null) {
                        W = 0;
                        var all = (count > 1 && count === nodeCount);
                        try {
                            for (var _f = __values(this.tableRows), _g = _f.next(); !_g.done; _g = _f.next()) {
                                var row = _g.value;
                                var cell = row.getChild(i);
                                if (cell) {
                                    var child = cell.childNodes[0];
                                    var noStretch = (child.stretch.dir === 0);
                                    if (all || noStretch) {
                                        var w = child.getBBox(noStretch).w;
                                        if (w > W) {
                                            W = w;
                                        }
                                    }
                                }
                            }
                        }
                        catch (e_2_1) {
                            e_2 = { error: e_2_1 };
                        }
                        finally {
                            try {
                                if (_g && !_g.done && (_b = _f.return))
                                    _b.call(_f);
                            }
                            finally {
                                if (e_2)
                                    throw e_2.error;
                            }
                        }
                    }
                    try {
                        for (var stretchy_1 = __values(stretchy), stretchy_1_1 = stretchy_1.next(); !stretchy_1_1.done; stretchy_1_1 = stretchy_1.next()) {
                            var child = stretchy_1_1.value;
                            child.coreMO().getStretchedVariant([W]);
                        }
                    }
                    catch (e_3_1) {
                        e_3 = { error: e_3_1 };
                    }
                    finally {
                        try {
                            if (stretchy_1_1 && !stretchy_1_1.done && (_c = stretchy_1.return))
                                _c.call(stretchy_1);
                        }
                        finally {
                            if (e_3)
                                throw e_3.error;
                        }
                    }
                }
            };
            class_1.prototype.getTableData = function () {
                if (this.data) {
                    return this.data;
                }
                var H = new Array(this.numRows).fill(0);
                var D = new Array(this.numRows).fill(0);
                var W = new Array(this.numCols).fill(0);
                var NH = new Array(this.numRows);
                var ND = new Array(this.numRows);
                var LW = [0];
                var rows = this.tableRows;
                for (var j = 0; j < rows.length; j++) {
                    var M = 0;
                    var row = rows[j];
                    var align = row.node.attributes.get('rowalign');
                    for (var i = 0; i < row.numCells; i++) {
                        var cell = row.getChild(i);
                        M = this.updateHDW(cell, i, j, align, H, D, W, M);
                        this.recordPWidthCell(cell, i);
                    }
                    NH[j] = H[j];
                    ND[j] = D[j];
                    if (row.labeled) {
                        M = this.updateHDW(row.childNodes[0], 0, j, align, H, D, LW, M);
                    }
                    this.extendHD(j, H, D, M);
                    this.extendHD(j, NH, ND, M);
                }
                var L = LW[0];
                this.data = { H: H, D: D, W: W, NH: NH, ND: ND, L: L };
                return this.data;
            };
            class_1.prototype.updateHDW = function (cell, i, j, align, H, D, W, M) {
                var _a = cell.getBBox(), h = _a.h, d = _a.d, w = _a.w;
                var scale = cell.parent.bbox.rscale;
                if (cell.parent.bbox.rscale !== 1) {
                    h *= scale;
                    d *= scale;
                    w *= scale;
                }
                if (this.node.getProperty('useHeight')) {
                    if (h < .75)
                        h = .75;
                    if (d < .25)
                        d = .25;
                }
                var m = 0;
                align = cell.node.attributes.get('rowalign') || align;
                if (align !== 'baseline' && align !== 'axis') {
                    m = h + d;
                    h = d = 0;
                }
                if (h > H[j])
                    H[j] = h;
                if (d > D[j])
                    D[j] = d;
                if (m > M)
                    M = m;
                if (W && w > W[i])
                    W[i] = w;
                return M;
            };
            class_1.prototype.extendHD = function (i, H, D, M) {
                var d = (M - (H[i] + D[i])) / 2;
                if (d < .00001)
                    return;
                H[i] += d;
                D[i] += d;
            };
            class_1.prototype.recordPWidthCell = function (cell, i) {
                if (cell.childNodes[0] && cell.childNodes[0].getBBox().pwidth) {
                    this.pwidthCells.push([cell, i]);
                }
            };
            class_1.prototype.computeBBox = function (bbox, _recompute) {
                if (_recompute === void 0) {
                    _recompute = false;
                }
                var _a = this.getTableData(), H = _a.H, D = _a.D;
                var height, width;
                if (this.node.attributes.get('equalrows')) {
                    var HD = this.getEqualRowHeight();
                    height = (0, numeric_js_1.sum)([].concat(this.rLines, this.rSpace)) + HD * this.numRows;
                }
                else {
                    height = (0, numeric_js_1.sum)(H.concat(D, this.rLines, this.rSpace));
                }
                height += 2 * (this.fLine + this.fSpace[1]);
                var CW = this.getComputedWidths();
                width = (0, numeric_js_1.sum)(CW.concat(this.cLines, this.cSpace)) + 2 * (this.fLine + this.fSpace[0]);
                var w = this.node.attributes.get('width');
                if (w !== 'auto') {
                    width = Math.max(this.length2em(w, 0) + 2 * this.fLine, width);
                }
                var _b = __read(this.getBBoxHD(height), 2), h = _b[0], d = _b[1];
                bbox.h = h;
                bbox.d = d;
                bbox.w = width;
                var _c = __read(this.getBBoxLR(), 2), L = _c[0], R = _c[1];
                bbox.L = L;
                bbox.R = R;
                if (!(0, string_js_1.isPercent)(w)) {
                    this.setColumnPWidths();
                }
            };
            class_1.prototype.setChildPWidths = function (_recompute, cwidth, _clear) {
                var width = this.node.attributes.get('width');
                if (!(0, string_js_1.isPercent)(width))
                    return false;
                if (!this.hasLabels) {
                    this.bbox.pwidth = '';
                    this.container.bbox.pwidth = '';
                }
                var _a = this.bbox, w = _a.w, L = _a.L, R = _a.R;
                var labelInWidth = this.node.attributes.get('data-width-includes-label');
                var W = Math.max(w, this.length2em(width, Math.max(cwidth, L + w + R))) - (labelInWidth ? L + R : 0);
                var cols = (this.node.attributes.get('equalcolumns') ?
                    Array(this.numCols).fill(this.percent(1 / Math.max(1, this.numCols))) :
                    this.getColumnAttributes('columnwidth', 0));
                this.cWidths = this.getColumnWidthsFixed(cols, W);
                var CW = this.getComputedWidths();
                this.pWidth = (0, numeric_js_1.sum)(CW.concat(this.cLines, this.cSpace)) + 2 * (this.fLine + this.fSpace[0]);
                if (this.isTop) {
                    this.bbox.w = this.pWidth;
                }
                this.setColumnPWidths();
                if (this.pWidth !== w) {
                    this.parent.invalidateBBox();
                }
                return this.pWidth !== w;
            };
            class_1.prototype.setColumnPWidths = function () {
                var e_4, _a;
                var W = this.cWidths;
                try {
                    for (var _b = __values(this.pwidthCells), _c = _b.next(); !_c.done; _c = _b.next()) {
                        var _d = __read(_c.value, 2), cell = _d[0], i = _d[1];
                        if (cell.setChildPWidths(false, W[i])) {
                            cell.invalidateBBox();
                            cell.getBBox();
                        }
                    }
                }
                catch (e_4_1) {
                    e_4 = { error: e_4_1 };
                }
                finally {
                    try {
                        if (_c && !_c.done && (_a = _b.return))
                            _a.call(_b);
                    }
                    finally {
                        if (e_4)
                            throw e_4.error;
                    }
                }
            };
            class_1.prototype.getBBoxHD = function (height) {
                var _a = __read(this.getAlignmentRow(), 2), align = _a[0], row = _a[1];
                if (row === null) {
                    var a = this.font.params.axis_height;
                    var h2 = height / 2;
                    var HD = {
                        top: [0, height],
                        center: [h2, h2],
                        bottom: [height, 0],
                        baseline: [h2, h2],
                        axis: [h2 + a, h2 - a]
                    };
                    return HD[align] || [h2, h2];
                }
                else {
                    var y = this.getVerticalPosition(row, align);
                    return [y, height - y];
                }
            };
            class_1.prototype.getBBoxLR = function () {
                if (this.hasLabels) {
                    var attributes = this.node.attributes;
                    var side = attributes.get('side');
                    var _a = __read(this.getPadAlignShift(side), 2), pad = _a[0], align = _a[1];
                    var labels = this.hasLabels && !!attributes.get('data-width-includes-label');
                    if (labels && this.frame && this.fSpace[0]) {
                        pad -= this.fSpace[0];
                    }
                    return (align === 'center' && !labels ? [pad, pad] :
                        side === 'left' ? [pad, 0] : [0, pad]);
                }
                return [0, 0];
            };
            class_1.prototype.getPadAlignShift = function (side) {
                var L = this.getTableData().L;
                var sep = this.length2em(this.node.attributes.get('minlabelspacing'));
                var pad = L + sep;
                var _a = __read((this.styles == null ? ['', ''] :
                    [this.styles.get('padding-left'), this.styles.get('padding-right')]), 2), lpad = _a[0], rpad = _a[1];
                if (lpad || rpad) {
                    pad = Math.max(pad, this.length2em(lpad || '0'), this.length2em(rpad || '0'));
                }
                var _b = __read(this.getAlignShift(), 2), align = _b[0], shift = _b[1];
                if (align === side) {
                    shift = (side === 'left' ? Math.max(pad, shift) - pad : Math.min(-pad, shift) + pad);
                }
                return [pad, align, shift];
            };
            class_1.prototype.getAlignShift = function () {
                return (this.isTop ? _super.prototype.getAlignShift.call(this) :
                    [this.container.getChildAlign(this.containerI), 0]);
            };
            class_1.prototype.getWidth = function () {
                return this.pWidth || this.getBBox().w;
            };
            class_1.prototype.getEqualRowHeight = function () {
                var _a = this.getTableData(), H = _a.H, D = _a.D;
                var HD = Array.from(H.keys()).map(function (i) { return H[i] + D[i]; });
                return Math.max.apply(Math, HD);
            };
            class_1.prototype.getComputedWidths = function () {
                var _this = this;
                var W = this.getTableData().W;
                var CW = Array.from(W.keys()).map(function (i) {
                    return (typeof _this.cWidths[i] === 'number' ? _this.cWidths[i] : W[i]);
                });
                if (this.node.attributes.get('equalcolumns')) {
                    CW = Array(CW.length).fill((0, numeric_js_1.max)(CW));
                }
                return CW;
            };
            class_1.prototype.getColumnWidths = function () {
                var width = this.node.attributes.get('width');
                if (this.node.attributes.get('equalcolumns')) {
                    return this.getEqualColumns(width);
                }
                var swidths = this.getColumnAttributes('columnwidth', 0);
                if (width === 'auto') {
                    return this.getColumnWidthsAuto(swidths);
                }
                if ((0, string_js_1.isPercent)(width)) {
                    return this.getColumnWidthsPercent(swidths);
                }
                return this.getColumnWidthsFixed(swidths, this.length2em(width));
            };
            class_1.prototype.getEqualColumns = function (width) {
                var n = Math.max(1, this.numCols);
                var cwidth;
                if (width === 'auto') {
                    var W = this.getTableData().W;
                    cwidth = (0, numeric_js_1.max)(W);
                }
                else if ((0, string_js_1.isPercent)(width)) {
                    cwidth = this.percent(1 / n);
                }
                else {
                    var w = (0, numeric_js_1.sum)([].concat(this.cLines, this.cSpace)) + 2 * this.fSpace[0];
                    cwidth = Math.max(0, this.length2em(width) - w) / n;
                }
                return Array(this.numCols).fill(cwidth);
            };
            class_1.prototype.getColumnWidthsAuto = function (swidths) {
                var _this = this;
                return swidths.map(function (x) {
                    if (x === 'auto' || x === 'fit')
                        return null;
                    if ((0, string_js_1.isPercent)(x))
                        return x;
                    return _this.length2em(x);
                });
            };
            class_1.prototype.getColumnWidthsPercent = function (swidths) {
                var _this = this;
                var hasFit = swidths.indexOf('fit') >= 0;
                var W = (hasFit ? this.getTableData() : { W: null }).W;
                return Array.from(swidths.keys()).map(function (i) {
                    var x = swidths[i];
                    if (x === 'fit')
                        return null;
                    if (x === 'auto')
                        return (hasFit ? W[i] : null);
                    if ((0, string_js_1.isPercent)(x))
                        return x;
                    return _this.length2em(x);
                });
            };
            class_1.prototype.getColumnWidthsFixed = function (swidths, width) {
                var _this = this;
                var indices = Array.from(swidths.keys());
                var fit = indices.filter(function (i) { return swidths[i] === 'fit'; });
                var auto = indices.filter(function (i) { return swidths[i] === 'auto'; });
                var n = fit.length || auto.length;
                var W = (n ? this.getTableData() : { W: null }).W;
                var cwidth = width - (0, numeric_js_1.sum)([].concat(this.cLines, this.cSpace)) - 2 * this.fSpace[0];
                var dw = cwidth;
                indices.forEach(function (i) {
                    var x = swidths[i];
                    dw -= (x === 'fit' || x === 'auto' ? W[i] : _this.length2em(x, cwidth));
                });
                var fw = (n && dw > 0 ? dw / n : 0);
                return indices.map(function (i) {
                    var x = swidths[i];
                    if (x === 'fit')
                        return W[i] + fw;
                    if (x === 'auto')
                        return W[i] + (fit.length === 0 ? fw : 0);
                    return _this.length2em(x, cwidth);
                });
            };
            class_1.prototype.getVerticalPosition = function (i, align) {
                var equal = this.node.attributes.get('equalrows');
                var _a = this.getTableData(), H = _a.H, D = _a.D;
                var HD = (equal ? this.getEqualRowHeight() : 0);
                var space = this.getRowHalfSpacing();
                var y = this.fLine;
                for (var j = 0; j < i; j++) {
                    y += space[j] + (equal ? HD : H[j] + D[j]) + space[j + 1] + this.rLines[j];
                }
                var _b = __read((equal ? [(HD + H[i] - D[i]) / 2, (HD - H[i] + D[i]) / 2] : [H[i], D[i]]), 2), h = _b[0], d = _b[1];
                var offset = {
                    top: 0,
                    center: space[i] + (h + d) / 2,
                    bottom: space[i] + h + d + space[i + 1],
                    baseline: space[i] + h,
                    axis: space[i] + h - .25
                };
                y += offset[align] || 0;
                return y;
            };
            class_1.prototype.getEmHalfSpacing = function (fspace, space, scale) {
                if (scale === void 0) {
                    scale = 1;
                }
                var fspaceEm = this.em(fspace * scale);
                var spaceEm = this.addEm(space, 2 / scale);
                spaceEm.unshift(fspaceEm);
                spaceEm.push(fspaceEm);
                return spaceEm;
            };
            class_1.prototype.getRowHalfSpacing = function () {
                var space = this.rSpace.map(function (x) { return x / 2; });
                space.unshift(this.fSpace[1]);
                space.push(this.fSpace[1]);
                return space;
            };
            class_1.prototype.getColumnHalfSpacing = function () {
                var space = this.cSpace.map(function (x) { return x / 2; });
                space.unshift(this.fSpace[0]);
                space.push(this.fSpace[0]);
                return space;
            };
            class_1.prototype.getAlignmentRow = function () {
                var _a = __read((0, string_js_1.split)(this.node.attributes.get('align')), 2), align = _a[0], row = _a[1];
                if (row == null)
                    return [align, null];
                var i = parseInt(row);
                if (i < 0)
                    i += this.numRows + 1;
                return [align, i < 1 || i > this.numRows ? null : i - 1];
            };
            class_1.prototype.getColumnAttributes = function (name, i) {
                if (i === void 0) {
                    i = 1;
                }
                var n = this.numCols - i;
                var columns = this.getAttributeArray(name);
                if (columns.length === 0)
                    return null;
                while (columns.length < n) {
                    columns.push(columns[columns.length - 1]);
                }
                if (columns.length > n) {
                    columns.splice(n);
                }
                return columns;
            };
            class_1.prototype.getRowAttributes = function (name, i) {
                if (i === void 0) {
                    i = 1;
                }
                var n = this.numRows - i;
                var rows = this.getAttributeArray(name);
                if (rows.length === 0)
                    return null;
                while (rows.length < n) {
                    rows.push(rows[rows.length - 1]);
                }
                if (rows.length > n) {
                    rows.splice(n);
                }
                return rows;
            };
            class_1.prototype.getAttributeArray = function (name) {
                var value = this.node.attributes.get(name);
                if (!value)
                    return [this.node.attributes.getDefault(name)];
                return (0, string_js_1.split)(value);
            };
            class_1.prototype.addEm = function (list, n) {
                var _this = this;
                if (n === void 0) {
                    n = 1;
                }
                if (!list)
                    return null;
                return list.map(function (x) { return _this.em(x / n); });
            };
            class_1.prototype.convertLengths = function (list) {
                var _this = this;
                if (!list)
                    return null;
                return list.map(function (x) { return _this.length2em(x); });
            };
            return class_1;
        }(Base));
    }
    exports.CommonMtableMixin = CommonMtableMixin;
},
740: /* mathjax-full/js/util/numeric.js */ function _(require, module, exports, __esModule, __esExport) {
    __esModule();
    function sum(A) {
        return A.reduce(function (a, b) { return a + b; }, 0);
    }
    exports.sum = sum;
    function max(A) {
        return A.reduce(function (a, b) { return Math.max(a, b); }, 0);
    }
    exports.max = max;
},
741: /* mathjax-full/js/core/MmlTree/MmlNodes/mtable.js */ function _(require, module, exports, __esModule, __esExport) {
    var __extends = (this && this.__extends) || (function () {
        var extendStatics = function (d, b) {
            extendStatics = Object.setPrototypeOf ||
                ({ __proto__: [] } instanceof Array && function (d, b) { d.__proto__ = b; }) ||
                function (d, b) { for (var p in b)
                    if (Object.prototype.hasOwnProperty.call(b, p))
                        d[p] = b[p]; };
            return extendStatics(d, b);
        };
        return function (d, b) {
            if (typeof b !== "function" && b !== null)
                throw new TypeError("Class extends value " + String(b) + " is not a constructor or null");
            extendStatics(d, b);
            function __() { this.constructor = d; }
            d.prototype = b === null ? Object.create(b) : (__.prototype = b.prototype, new __());
        };
    })();
    var __assign = (this && this.__assign) || function () {
        __assign = Object.assign || function (t) {
            for (var s, i = 1, n = arguments.length; i < n; i++) {
                s = arguments[i];
                for (var p in s)
                    if (Object.prototype.hasOwnProperty.call(s, p))
                        t[p] = s[p];
            }
            return t;
        };
        return __assign.apply(this, arguments);
    };
    var __values = (this && this.__values) || function (o) {
        var s = typeof Symbol === "function" && Symbol.iterator, m = s && o[s], i = 0;
        if (m)
            return m.call(o);
        if (o && typeof o.length === "number")
            return {
                next: function () {
                    if (o && i >= o.length)
                        o = void 0;
                    return { value: o && o[i++], done: !o };
                }
            };
        throw new TypeError(s ? "Object is not iterable." : "Symbol.iterator is not defined.");
    };
    __esModule();
    var MmlNode_js_1 = require(639) /* ../MmlNode.js */;
    var string_js_1 = require(636) /* ../../../util/string.js */;
    var MmlMtable = (function (_super) {
        __extends(MmlMtable, _super);
        function MmlMtable() {
            var _this = _super !== null && _super.apply(this, arguments) || this;
            _this.properties = {
                useHeight: true
            };
            _this.texclass = MmlNode_js_1.TEXCLASS.ORD;
            return _this;
        }
        Object.defineProperty(MmlMtable.prototype, "kind", {
            get: function () {
                return 'mtable';
            },
            enumerable: false,
            configurable: true
        });
        Object.defineProperty(MmlMtable.prototype, "linebreakContainer", {
            get: function () {
                return true;
            },
            enumerable: false,
            configurable: true
        });
        MmlMtable.prototype.setInheritedAttributes = function (attributes, display, level, prime) {
            var e_1, _a;
            try {
                for (var indentAttributes_1 = __values(MmlNode_js_1.indentAttributes), indentAttributes_1_1 = indentAttributes_1.next(); !indentAttributes_1_1.done; indentAttributes_1_1 = indentAttributes_1.next()) {
                    var name_1 = indentAttributes_1_1.value;
                    if (attributes[name_1]) {
                        this.attributes.setInherited(name_1, attributes[name_1][1]);
                    }
                    if (this.attributes.getExplicit(name_1) !== undefined) {
                        delete (this.attributes.getAllAttributes())[name_1];
                    }
                }
            }
            catch (e_1_1) {
                e_1 = { error: e_1_1 };
            }
            finally {
                try {
                    if (indentAttributes_1_1 && !indentAttributes_1_1.done && (_a = indentAttributes_1.return))
                        _a.call(indentAttributes_1);
                }
                finally {
                    if (e_1)
                        throw e_1.error;
                }
            }
            _super.prototype.setInheritedAttributes.call(this, attributes, display, level, prime);
        };
        MmlMtable.prototype.setChildInheritedAttributes = function (attributes, display, level, _prime) {
            var e_2, _a, e_3, _b;
            try {
                for (var _c = __values(this.childNodes), _d = _c.next(); !_d.done; _d = _c.next()) {
                    var child = _d.value;
                    if (!child.isKind('mtr')) {
                        this.replaceChild(this.factory.create('mtr'), child)
                            .appendChild(child);
                    }
                }
            }
            catch (e_2_1) {
                e_2 = { error: e_2_1 };
            }
            finally {
                try {
                    if (_d && !_d.done && (_a = _c.return))
                        _a.call(_c);
                }
                finally {
                    if (e_2)
                        throw e_2.error;
                }
            }
            level = this.getProperty('scriptlevel') || level;
            display = !!(this.attributes.getExplicit('displaystyle') || this.attributes.getDefault('displaystyle'));
            attributes = this.addInheritedAttributes(attributes, {
                columnalign: this.attributes.get('columnalign'),
                rowalign: 'center'
            });
            var cramped = this.attributes.getExplicit('data-cramped');
            var ralign = (0, string_js_1.split)(this.attributes.get('rowalign'));
            try {
                for (var _e = __values(this.childNodes), _f = _e.next(); !_f.done; _f = _e.next()) {
                    var child = _f.value;
                    attributes.rowalign[1] = ralign.shift() || attributes.rowalign[1];
                    child.setInheritedAttributes(attributes, display, level, !!cramped);
                }
            }
            catch (e_3_1) {
                e_3 = { error: e_3_1 };
            }
            finally {
                try {
                    if (_f && !_f.done && (_b = _e.return))
                        _b.call(_e);
                }
                finally {
                    if (e_3)
                        throw e_3.error;
                }
            }
        };
        MmlMtable.prototype.verifyChildren = function (options) {
            var mtr = null;
            var factory = this.factory;
            for (var i = 0; i < this.childNodes.length; i++) {
                var child = this.childNodes[i];
                if (child.isKind('mtr')) {
                    mtr = null;
                }
                else {
                    var isMtd = child.isKind('mtd');
                    if (mtr) {
                        this.removeChild(child);
                        i--;
                    }
                    else {
                        mtr = this.replaceChild(factory.create('mtr'), child);
                    }
                    mtr.appendChild(isMtd ? child : factory.create('mtd', {}, [child]));
                    if (!options['fixMtables']) {
                        child.parent.removeChild(child);
                        child.parent = this;
                        isMtd && mtr.appendChild(factory.create('mtd'));
                        var merror = child.mError('Children of ' + this.kind + ' must be mtr or mlabeledtr', options, isMtd);
                        mtr.childNodes[mtr.childNodes.length - 1].appendChild(merror);
                    }
                }
            }
            _super.prototype.verifyChildren.call(this, options);
        };
        MmlMtable.prototype.setTeXclass = function (prev) {
            var e_4, _a;
            this.getPrevClass(prev);
            try {
                for (var _b = __values(this.childNodes), _c = _b.next(); !_c.done; _c = _b.next()) {
                    var child = _c.value;
                    child.setTeXclass(null);
                }
            }
            catch (e_4_1) {
                e_4 = { error: e_4_1 };
            }
            finally {
                try {
                    if (_c && !_c.done && (_a = _b.return))
                        _a.call(_b);
                }
                finally {
                    if (e_4)
                        throw e_4.error;
                }
            }
            return this;
        };
        MmlMtable.defaults = __assign(__assign({}, MmlNode_js_1.AbstractMmlNode.defaults), { align: 'axis', rowalign: 'baseline', columnalign: 'center', groupalign: '{left}', alignmentscope: true, columnwidth: 'auto', width: 'auto', rowspacing: '1ex', columnspacing: '.8em', rowlines: 'none', columnlines: 'none', frame: 'none', framespacing: '0.4em 0.5ex', equalrows: false, equalcolumns: false, displaystyle: false, side: 'right', minlabelspacing: '0.8em' });
        return MmlMtable;
    }(MmlNode_js_1.AbstractMmlNode));
    exports.MmlMtable = MmlMtable;
},
742: /* mathjax-full/js/output/svg/Wrappers/mtr.js */ function _(require, module, exports, __esModule, __esExport) {
    var __extends = (this && this.__extends) || (function () {
        var extendStatics = function (d, b) {
            extendStatics = Object.setPrototypeOf ||
                ({ __proto__: [] } instanceof Array && function (d, b) { d.__proto__ = b; }) ||
                function (d, b) { for (var p in b)
                    if (Object.prototype.hasOwnProperty.call(b, p))
                        d[p] = b[p]; };
            return extendStatics(d, b);
        };
        return function (d, b) {
            if (typeof b !== "function" && b !== null)
                throw new TypeError("Class extends value " + String(b) + " is not a constructor or null");
            extendStatics(d, b);
            function __() { this.constructor = d; }
            d.prototype = b === null ? Object.create(b) : (__.prototype = b.prototype, new __());
        };
    })();
    var __read = (this && this.__read) || function (o, n) {
        var m = typeof Symbol === "function" && o[Symbol.iterator];
        if (!m)
            return o;
        var i = m.call(o), r, ar = [], e;
        try {
            while ((n === void 0 || n-- > 0) && !(r = i.next()).done)
                ar.push(r.value);
        }
        catch (error) {
            e = { error: error };
        }
        finally {
            try {
                if (r && !r.done && (m = i["return"]))
                    m.call(i);
            }
            finally {
                if (e)
                    throw e.error;
            }
        }
        return ar;
    };
    var __spreadArray = (this && this.__spreadArray) || function (to, from, pack) {
        if (pack || arguments.length === 2)
            for (var i = 0, l = from.length, ar; i < l; i++) {
                if (ar || !(i in from)) {
                    if (!ar)
                        ar = Array.prototype.slice.call(from, 0, i);
                    ar[i] = from[i];
                }
            }
        return to.concat(ar || Array.prototype.slice.call(from));
    };
    __esModule();
    var Wrapper_js_1 = require(680) /* ../Wrapper.js */;
    var mtr_js_1 = require(743) /* ../../common/Wrappers/mtr.js */;
    var mtr_js_2 = require(743) /* ../../common/Wrappers/mtr.js */;
    var mtr_js_3 = require(744) /* ../../../core/MmlTree/MmlNodes/mtr.js */;
    var SVGmtr = (function (_super) {
        __extends(SVGmtr, _super);
        function SVGmtr() {
            return _super !== null && _super.apply(this, arguments) || this;
        }
        SVGmtr.prototype.toSVG = function (parent) {
            var svg = this.standardSVGnode(parent);
            this.placeCells(svg);
            this.placeColor();
        };
        SVGmtr.prototype.placeCells = function (svg) {
            var cSpace = this.parent.getColumnHalfSpacing();
            var cLines = __spreadArray(__spreadArray([this.parent.fLine], __read(this.parent.cLines), false), [this.parent.fLine], false);
            var cWidth = this.parent.getComputedWidths();
            var scale = 1 / this.getBBox().rscale;
            var x = cLines[0];
            for (var i = 0; i < this.numCells; i++) {
                var child = this.getChild(i);
                child.toSVG(svg);
                x += this.placeCell(child, {
                    x: x, y: 0, lSpace: cSpace[i] * scale, rSpace: cSpace[i + 1] * scale, w: cWidth[i] * scale,
                    lLine: cLines[i] * scale, rLine: cLines[i + 1] * scale
                });
            }
        };
        SVGmtr.prototype.placeCell = function (cell, sizes) {
            var x = sizes.x, y = sizes.y, lSpace = sizes.lSpace, w = sizes.w, rSpace = sizes.rSpace, lLine = sizes.lLine, rLine = sizes.rLine;
            var scale = 1 / this.getBBox().rscale;
            var _a = __read([this.H * scale, this.D * scale], 2), h = _a[0], d = _a[1];
            var _b = __read([this.tSpace * scale, this.bSpace * scale], 2), t = _b[0], b = _b[1];
            var _c = __read(cell.placeCell(x + lSpace, y, w, h, d), 2), dx = _c[0], dy = _c[1];
            var W = lSpace + w + rSpace;
            cell.placeColor(-(dx + lSpace + lLine / 2), -(d + b + dy), W + (lLine + rLine) / 2, h + d + t + b);
            return W + rLine;
        };
        SVGmtr.prototype.placeColor = function () {
            var scale = 1 / this.getBBox().rscale;
            var adaptor = this.adaptor;
            var child = this.firstChild();
            if (child && adaptor.kind(child) === 'rect' && adaptor.getAttribute(child, 'data-bgcolor')) {
                var _a = __read([(this.tLine / 2) * scale, (this.bLine / 2) * scale], 2), TL = _a[0], BL = _a[1];
                var _b = __read([this.tSpace * scale, this.bSpace * scale], 2), TS = _b[0], BS = _b[1];
                var _c = __read([this.H * scale, this.D * scale], 2), H = _c[0], D = _c[1];
                adaptor.setAttribute(child, 'y', this.fixed(-(D + BS + BL)));
                adaptor.setAttribute(child, 'width', this.fixed(this.parent.getWidth() * scale));
                adaptor.setAttribute(child, 'height', this.fixed(TL + TS + H + D + BS + BL));
            }
        };
        SVGmtr.kind = mtr_js_3.MmlMtr.prototype.kind;
        return SVGmtr;
    }((0, mtr_js_1.CommonMtrMixin)(Wrapper_js_1.SVGWrapper)));
    exports.SVGmtr = SVGmtr;
    var SVGmlabeledtr = (function (_super) {
        __extends(SVGmlabeledtr, _super);
        function SVGmlabeledtr() {
            return _super !== null && _super.apply(this, arguments) || this;
        }
        SVGmlabeledtr.prototype.toSVG = function (parent) {
            _super.prototype.toSVG.call(this, parent);
            var child = this.childNodes[0];
            if (child) {
                child.toSVG(this.parent.labels);
            }
        };
        SVGmlabeledtr.kind = mtr_js_3.MmlMlabeledtr.prototype.kind;
        return SVGmlabeledtr;
    }((0, mtr_js_2.CommonMlabeledtrMixin)(SVGmtr)));
    exports.SVGmlabeledtr = SVGmlabeledtr;
},
743: /* mathjax-full/js/output/common/Wrappers/mtr.js */ function _(require, module, exports, __esModule, __esExport) {
    var __extends = (this && this.__extends) || (function () {
        var extendStatics = function (d, b) {
            extendStatics = Object.setPrototypeOf ||
                ({ __proto__: [] } instanceof Array && function (d, b) { d.__proto__ = b; }) ||
                function (d, b) { for (var p in b)
                    if (Object.prototype.hasOwnProperty.call(b, p))
                        d[p] = b[p]; };
            return extendStatics(d, b);
        };
        return function (d, b) {
            if (typeof b !== "function" && b !== null)
                throw new TypeError("Class extends value " + String(b) + " is not a constructor or null");
            extendStatics(d, b);
            function __() { this.constructor = d; }
            d.prototype = b === null ? Object.create(b) : (__.prototype = b.prototype, new __());
        };
    })();
    var __values = (this && this.__values) || function (o) {
        var s = typeof Symbol === "function" && Symbol.iterator, m = s && o[s], i = 0;
        if (m)
            return m.call(o);
        if (o && typeof o.length === "number")
            return {
                next: function () {
                    if (o && i >= o.length)
                        o = void 0;
                    return { value: o && o[i++], done: !o };
                }
            };
        throw new TypeError(s ? "Object is not iterable." : "Symbol.iterator is not defined.");
    };
    __esModule();
    function CommonMtrMixin(Base) {
        return (function (_super) {
            __extends(class_1, _super);
            function class_1() {
                return _super !== null && _super.apply(this, arguments) || this;
            }
            Object.defineProperty(class_1.prototype, "fixesPWidth", {
                get: function () {
                    return false;
                },
                enumerable: false,
                configurable: true
            });
            Object.defineProperty(class_1.prototype, "numCells", {
                get: function () {
                    return this.childNodes.length;
                },
                enumerable: false,
                configurable: true
            });
            Object.defineProperty(class_1.prototype, "labeled", {
                get: function () {
                    return false;
                },
                enumerable: false,
                configurable: true
            });
            Object.defineProperty(class_1.prototype, "tableCells", {
                get: function () {
                    return this.childNodes;
                },
                enumerable: false,
                configurable: true
            });
            class_1.prototype.getChild = function (i) {
                return this.childNodes[i];
            };
            class_1.prototype.getChildBBoxes = function () {
                return this.childNodes.map(function (cell) { return cell.getBBox(); });
            };
            class_1.prototype.stretchChildren = function (HD) {
                var e_1, _a, e_2, _b, e_3, _c;
                if (HD === void 0) {
                    HD = null;
                }
                var stretchy = [];
                var children = (this.labeled ? this.childNodes.slice(1) : this.childNodes);
                try {
                    for (var children_1 = __values(children), children_1_1 = children_1.next(); !children_1_1.done; children_1_1 = children_1.next()) {
                        var mtd = children_1_1.value;
                        var child = mtd.childNodes[0];
                        if (child.canStretch(1)) {
                            stretchy.push(child);
                        }
                    }
                }
                catch (e_1_1) {
                    e_1 = { error: e_1_1 };
                }
                finally {
                    try {
                        if (children_1_1 && !children_1_1.done && (_a = children_1.return))
                            _a.call(children_1);
                    }
                    finally {
                        if (e_1)
                            throw e_1.error;
                    }
                }
                var count = stretchy.length;
                var nodeCount = this.childNodes.length;
                if (count && nodeCount > 1) {
                    if (HD === null) {
                        var H = 0, D = 0;
                        var all = (count > 1 && count === nodeCount);
                        try {
                            for (var children_2 = __values(children), children_2_1 = children_2.next(); !children_2_1.done; children_2_1 = children_2.next()) {
                                var mtd = children_2_1.value;
                                var child = mtd.childNodes[0];
                                var noStretch = (child.stretch.dir === 0);
                                if (all || noStretch) {
                                    var _d = child.getBBox(noStretch), h = _d.h, d = _d.d;
                                    if (h > H) {
                                        H = h;
                                    }
                                    if (d > D) {
                                        D = d;
                                    }
                                }
                            }
                        }
                        catch (e_2_1) {
                            e_2 = { error: e_2_1 };
                        }
                        finally {
                            try {
                                if (children_2_1 && !children_2_1.done && (_b = children_2.return))
                                    _b.call(children_2);
                            }
                            finally {
                                if (e_2)
                                    throw e_2.error;
                            }
                        }
                        HD = [H, D];
                    }
                    try {
                        for (var stretchy_1 = __values(stretchy), stretchy_1_1 = stretchy_1.next(); !stretchy_1_1.done; stretchy_1_1 = stretchy_1.next()) {
                            var child = stretchy_1_1.value;
                            child.coreMO().getStretchedVariant(HD);
                        }
                    }
                    catch (e_3_1) {
                        e_3 = { error: e_3_1 };
                    }
                    finally {
                        try {
                            if (stretchy_1_1 && !stretchy_1_1.done && (_c = stretchy_1.return))
                                _c.call(stretchy_1);
                        }
                        finally {
                            if (e_3)
                                throw e_3.error;
                        }
                    }
                }
            };
            return class_1;
        }(Base));
    }
    exports.CommonMtrMixin = CommonMtrMixin;
    function CommonMlabeledtrMixin(Base) {
        return (function (_super) {
            __extends(class_2, _super);
            function class_2() {
                return _super !== null && _super.apply(this, arguments) || this;
            }
            Object.defineProperty(class_2.prototype, "numCells", {
                get: function () {
                    return Math.max(0, this.childNodes.length - 1);
                },
                enumerable: false,
                configurable: true
            });
            Object.defineProperty(class_2.prototype, "labeled", {
                get: function () {
                    return true;
                },
                enumerable: false,
                configurable: true
            });
            Object.defineProperty(class_2.prototype, "tableCells", {
                get: function () {
                    return this.childNodes.slice(1);
                },
                enumerable: false,
                configurable: true
            });
            class_2.prototype.getChild = function (i) {
                return this.childNodes[i + 1];
            };
            class_2.prototype.getChildBBoxes = function () {
                return this.childNodes.slice(1).map(function (cell) { return cell.getBBox(); });
            };
            return class_2;
        }(Base));
    }
    exports.CommonMlabeledtrMixin = CommonMlabeledtrMixin;
},
744: /* mathjax-full/js/core/MmlTree/MmlNodes/mtr.js */ function _(require, module, exports, __esModule, __esExport) {
    var __extends = (this && this.__extends) || (function () {
        var extendStatics = function (d, b) {
            extendStatics = Object.setPrototypeOf ||
                ({ __proto__: [] } instanceof Array && function (d, b) { d.__proto__ = b; }) ||
                function (d, b) { for (var p in b)
                    if (Object.prototype.hasOwnProperty.call(b, p))
                        d[p] = b[p]; };
            return extendStatics(d, b);
        };
        return function (d, b) {
            if (typeof b !== "function" && b !== null)
                throw new TypeError("Class extends value " + String(b) + " is not a constructor or null");
            extendStatics(d, b);
            function __() { this.constructor = d; }
            d.prototype = b === null ? Object.create(b) : (__.prototype = b.prototype, new __());
        };
    })();
    var __assign = (this && this.__assign) || function () {
        __assign = Object.assign || function (t) {
            for (var s, i = 1, n = arguments.length; i < n; i++) {
                s = arguments[i];
                for (var p in s)
                    if (Object.prototype.hasOwnProperty.call(s, p))
                        t[p] = s[p];
            }
            return t;
        };
        return __assign.apply(this, arguments);
    };
    var __values = (this && this.__values) || function (o) {
        var s = typeof Symbol === "function" && Symbol.iterator, m = s && o[s], i = 0;
        if (m)
            return m.call(o);
        if (o && typeof o.length === "number")
            return {
                next: function () {
                    if (o && i >= o.length)
                        o = void 0;
                    return { value: o && o[i++], done: !o };
                }
            };
        throw new TypeError(s ? "Object is not iterable." : "Symbol.iterator is not defined.");
    };
    __esModule();
    var MmlNode_js_1 = require(639) /* ../MmlNode.js */;
    var Attributes_js_1 = require(640) /* ../Attributes.js */;
    var string_js_1 = require(636) /* ../../../util/string.js */;
    var MmlMtr = (function (_super) {
        __extends(MmlMtr, _super);
        function MmlMtr() {
            return _super !== null && _super.apply(this, arguments) || this;
        }
        Object.defineProperty(MmlMtr.prototype, "kind", {
            get: function () {
                return 'mtr';
            },
            enumerable: false,
            configurable: true
        });
        Object.defineProperty(MmlMtr.prototype, "linebreakContainer", {
            get: function () {
                return true;
            },
            enumerable: false,
            configurable: true
        });
        MmlMtr.prototype.setChildInheritedAttributes = function (attributes, display, level, prime) {
            var e_1, _a, e_2, _b;
            try {
                for (var _c = __values(this.childNodes), _d = _c.next(); !_d.done; _d = _c.next()) {
                    var child = _d.value;
                    if (!child.isKind('mtd')) {
                        this.replaceChild(this.factory.create('mtd'), child)
                            .appendChild(child);
                    }
                }
            }
            catch (e_1_1) {
                e_1 = { error: e_1_1 };
            }
            finally {
                try {
                    if (_d && !_d.done && (_a = _c.return))
                        _a.call(_c);
                }
                finally {
                    if (e_1)
                        throw e_1.error;
                }
            }
            var calign = (0, string_js_1.split)(this.attributes.get('columnalign'));
            if (this.arity === 1) {
                calign.unshift(this.parent.attributes.get('side'));
            }
            attributes = this.addInheritedAttributes(attributes, {
                rowalign: this.attributes.get('rowalign'),
                columnalign: 'center'
            });
            try {
                for (var _e = __values(this.childNodes), _f = _e.next(); !_f.done; _f = _e.next()) {
                    var child = _f.value;
                    attributes.columnalign[1] = calign.shift() || attributes.columnalign[1];
                    child.setInheritedAttributes(attributes, display, level, prime);
                }
            }
            catch (e_2_1) {
                e_2 = { error: e_2_1 };
            }
            finally {
                try {
                    if (_f && !_f.done && (_b = _e.return))
                        _b.call(_e);
                }
                finally {
                    if (e_2)
                        throw e_2.error;
                }
            }
        };
        MmlMtr.prototype.verifyChildren = function (options) {
            var e_3, _a;
            if (this.parent && !this.parent.isKind('mtable')) {
                this.mError(this.kind + ' can only be a child of an mtable', options, true);
                return;
            }
            try {
                for (var _b = __values(this.childNodes), _c = _b.next(); !_c.done; _c = _b.next()) {
                    var child = _c.value;
                    if (!child.isKind('mtd')) {
                        var mtd = this.replaceChild(this.factory.create('mtd'), child);
                        mtd.appendChild(child);
                        if (!options['fixMtables']) {
                            child.mError('Children of ' + this.kind + ' must be mtd', options);
                        }
                    }
                }
            }
            catch (e_3_1) {
                e_3 = { error: e_3_1 };
            }
            finally {
                try {
                    if (_c && !_c.done && (_a = _b.return))
                        _a.call(_b);
                }
                finally {
                    if (e_3)
                        throw e_3.error;
                }
            }
            _super.prototype.verifyChildren.call(this, options);
        };
        MmlMtr.prototype.setTeXclass = function (prev) {
            var e_4, _a;
            this.getPrevClass(prev);
            try {
                for (var _b = __values(this.childNodes), _c = _b.next(); !_c.done; _c = _b.next()) {
                    var child = _c.value;
                    child.setTeXclass(null);
                }
            }
            catch (e_4_1) {
                e_4 = { error: e_4_1 };
            }
            finally {
                try {
                    if (_c && !_c.done && (_a = _b.return))
                        _a.call(_b);
                }
                finally {
                    if (e_4)
                        throw e_4.error;
                }
            }
            return this;
        };
        MmlMtr.defaults = __assign(__assign({}, MmlNode_js_1.AbstractMmlNode.defaults), { rowalign: Attributes_js_1.INHERIT, columnalign: Attributes_js_1.INHERIT, groupalign: Attributes_js_1.INHERIT });
        return MmlMtr;
    }(MmlNode_js_1.AbstractMmlNode));
    exports.MmlMtr = MmlMtr;
    var MmlMlabeledtr = (function (_super) {
        __extends(MmlMlabeledtr, _super);
        function MmlMlabeledtr() {
            return _super !== null && _super.apply(this, arguments) || this;
        }
        Object.defineProperty(MmlMlabeledtr.prototype, "kind", {
            get: function () {
                return 'mlabeledtr';
            },
            enumerable: false,
            configurable: true
        });
        Object.defineProperty(MmlMlabeledtr.prototype, "arity", {
            get: function () {
                return 1;
            },
            enumerable: false,
            configurable: true
        });
        return MmlMlabeledtr;
    }(MmlMtr));
    exports.MmlMlabeledtr = MmlMlabeledtr;
},
745: /* mathjax-full/js/output/svg/Wrappers/mtd.js */ function _(require, module, exports, __esModule, __esExport) {
    var __extends = (this && this.__extends) || (function () {
        var extendStatics = function (d, b) {
            extendStatics = Object.setPrototypeOf ||
                ({ __proto__: [] } instanceof Array && function (d, b) { d.__proto__ = b; }) ||
                function (d, b) { for (var p in b)
                    if (Object.prototype.hasOwnProperty.call(b, p))
                        d[p] = b[p]; };
            return extendStatics(d, b);
        };
        return function (d, b) {
            if (typeof b !== "function" && b !== null)
                throw new TypeError("Class extends value " + String(b) + " is not a constructor or null");
            extendStatics(d, b);
            function __() { this.constructor = d; }
            d.prototype = b === null ? Object.create(b) : (__.prototype = b.prototype, new __());
        };
    })();
    __esModule();
    var Wrapper_js_1 = require(680) /* ../Wrapper.js */;
    var mtd_js_1 = require(746) /* ../../common/Wrappers/mtd.js */;
    var mtd_js_2 = require(747) /* ../../../core/MmlTree/MmlNodes/mtd.js */;
    var SVGmtd = (function (_super) {
        __extends(SVGmtd, _super);
        function SVGmtd() {
            return _super !== null && _super.apply(this, arguments) || this;
        }
        SVGmtd.prototype.placeCell = function (x, y, W, H, D) {
            var bbox = this.getBBox();
            var h = Math.max(bbox.h, .75);
            var d = Math.max(bbox.d, .25);
            var calign = this.node.attributes.get('columnalign');
            var ralign = this.node.attributes.get('rowalign');
            var alignX = this.getAlignX(W, bbox, calign);
            var alignY = this.getAlignY(H, D, h, d, ralign);
            this.place(x + alignX, y + alignY);
            return [alignX, alignY];
        };
        SVGmtd.prototype.placeColor = function (x, y, W, H) {
            var adaptor = this.adaptor;
            var child = this.firstChild();
            if (child && adaptor.kind(child) === 'rect' && adaptor.getAttribute(child, 'data-bgcolor')) {
                adaptor.setAttribute(child, 'x', this.fixed(x));
                adaptor.setAttribute(child, 'y', this.fixed(y));
                adaptor.setAttribute(child, 'width', this.fixed(W));
                adaptor.setAttribute(child, 'height', this.fixed(H));
            }
        };
        SVGmtd.kind = mtd_js_2.MmlMtd.prototype.kind;
        return SVGmtd;
    }((0, mtd_js_1.CommonMtdMixin)(Wrapper_js_1.SVGWrapper)));
    exports.SVGmtd = SVGmtd;
},
746: /* mathjax-full/js/output/common/Wrappers/mtd.js */ function _(require, module, exports, __esModule, __esExport) {
    var __extends = (this && this.__extends) || (function () {
        var extendStatics = function (d, b) {
            extendStatics = Object.setPrototypeOf ||
                ({ __proto__: [] } instanceof Array && function (d, b) { d.__proto__ = b; }) ||
                function (d, b) { for (var p in b)
                    if (Object.prototype.hasOwnProperty.call(b, p))
                        d[p] = b[p]; };
            return extendStatics(d, b);
        };
        return function (d, b) {
            if (typeof b !== "function" && b !== null)
                throw new TypeError("Class extends value " + String(b) + " is not a constructor or null");
            extendStatics(d, b);
            function __() { this.constructor = d; }
            d.prototype = b === null ? Object.create(b) : (__.prototype = b.prototype, new __());
        };
    })();
    __esModule();
    function CommonMtdMixin(Base) {
        return (function (_super) {
            __extends(class_1, _super);
            function class_1() {
                return _super !== null && _super.apply(this, arguments) || this;
            }
            Object.defineProperty(class_1.prototype, "fixesPWidth", {
                get: function () {
                    return false;
                },
                enumerable: false,
                configurable: true
            });
            class_1.prototype.invalidateBBox = function () {
                this.bboxComputed = false;
            };
            class_1.prototype.getWrapWidth = function (_j) {
                var table = this.parent.parent;
                var row = this.parent;
                var i = this.node.childPosition() - (row.labeled ? 1 : 0);
                return (typeof (table.cWidths[i]) === 'number' ? table.cWidths[i] : table.getTableData().W[i]);
            };
            class_1.prototype.getChildAlign = function (_i) {
                return this.node.attributes.get('columnalign');
            };
            return class_1;
        }(Base));
    }
    exports.CommonMtdMixin = CommonMtdMixin;
},
747: /* mathjax-full/js/core/MmlTree/MmlNodes/mtd.js */ function _(require, module, exports, __esModule, __esExport) {
    var __extends = (this && this.__extends) || (function () {
        var extendStatics = function (d, b) {
            extendStatics = Object.setPrototypeOf ||
                ({ __proto__: [] } instanceof Array && function (d, b) { d.__proto__ = b; }) ||
                function (d, b) { for (var p in b)
                    if (Object.prototype.hasOwnProperty.call(b, p))
                        d[p] = b[p]; };
            return extendStatics(d, b);
        };
        return function (d, b) {
            if (typeof b !== "function" && b !== null)
                throw new TypeError("Class extends value " + String(b) + " is not a constructor or null");
            extendStatics(d, b);
            function __() { this.constructor = d; }
            d.prototype = b === null ? Object.create(b) : (__.prototype = b.prototype, new __());
        };
    })();
    var __assign = (this && this.__assign) || function () {
        __assign = Object.assign || function (t) {
            for (var s, i = 1, n = arguments.length; i < n; i++) {
                s = arguments[i];
                for (var p in s)
                    if (Object.prototype.hasOwnProperty.call(s, p))
                        t[p] = s[p];
            }
            return t;
        };
        return __assign.apply(this, arguments);
    };
    __esModule();
    var MmlNode_js_1 = require(639) /* ../MmlNode.js */;
    var Attributes_js_1 = require(640) /* ../Attributes.js */;
    var MmlMtd = (function (_super) {
        __extends(MmlMtd, _super);
        function MmlMtd() {
            return _super !== null && _super.apply(this, arguments) || this;
        }
        Object.defineProperty(MmlMtd.prototype, "kind", {
            get: function () {
                return 'mtd';
            },
            enumerable: false,
            configurable: true
        });
        Object.defineProperty(MmlMtd.prototype, "arity", {
            get: function () {
                return -1;
            },
            enumerable: false,
            configurable: true
        });
        Object.defineProperty(MmlMtd.prototype, "linebreakContainer", {
            get: function () {
                return true;
            },
            enumerable: false,
            configurable: true
        });
        MmlMtd.prototype.verifyChildren = function (options) {
            if (this.parent && !this.parent.isKind('mtr')) {
                this.mError(this.kind + ' can only be a child of an mtr or mlabeledtr', options, true);
                return;
            }
            _super.prototype.verifyChildren.call(this, options);
        };
        MmlMtd.prototype.setTeXclass = function (prev) {
            this.getPrevClass(prev);
            this.childNodes[0].setTeXclass(null);
            return this;
        };
        MmlMtd.defaults = __assign(__assign({}, MmlNode_js_1.AbstractMmlBaseNode.defaults), { rowspan: 1, columnspan: 1, rowalign: Attributes_js_1.INHERIT, columnalign: Attributes_js_1.INHERIT, groupalign: Attributes_js_1.INHERIT });
        return MmlMtd;
    }(MmlNode_js_1.AbstractMmlBaseNode));
    exports.MmlMtd = MmlMtd;
},
748: /* mathjax-full/js/output/svg/Wrappers/maction.js */ function _(require, module, exports, __esModule, __esExport) {
    var __extends = (this && this.__extends) || (function () {
        var extendStatics = function (d, b) {
            extendStatics = Object.setPrototypeOf ||
                ({ __proto__: [] } instanceof Array && function (d, b) { d.__proto__ = b; }) ||
                function (d, b) { for (var p in b)
                    if (Object.prototype.hasOwnProperty.call(b, p))
                        d[p] = b[p]; };
            return extendStatics(d, b);
        };
        return function (d, b) {
            if (typeof b !== "function" && b !== null)
                throw new TypeError("Class extends value " + String(b) + " is not a constructor or null");
            extendStatics(d, b);
            function __() { this.constructor = d; }
            d.prototype = b === null ? Object.create(b) : (__.prototype = b.prototype, new __());
        };
    })();
    __esModule();
    var Wrapper_js_1 = require(680) /* ../Wrapper.js */;
    var maction_js_1 = require(749) /* ../../common/Wrappers/maction.js */;
    var maction_js_2 = require(749) /* ../../common/Wrappers/maction.js */;
    var maction_js_3 = require(750) /* ../../../core/MmlTree/MmlNodes/maction.js */;
    var SVGmaction = (function (_super) {
        __extends(SVGmaction, _super);
        function SVGmaction() {
            return _super !== null && _super.apply(this, arguments) || this;
        }
        SVGmaction.prototype.toSVG = function (parent) {
            var svg = this.standardSVGnode(parent);
            var child = this.selected;
            var _a = child.getOuterBBox(), h = _a.h, d = _a.d, w = _a.w;
            this.adaptor.append(this.element, this.svg('rect', {
                width: this.fixed(w), height: this.fixed(h + d), y: this.fixed(-d),
                fill: 'none', 'pointer-events': 'all'
            }));
            child.toSVG(svg);
            var bbox = child.getOuterBBox();
            if (child.element) {
                child.place(bbox.L * bbox.rscale, 0);
            }
            this.action(this, this.data);
        };
        SVGmaction.prototype.setEventHandler = function (type, handler) {
            this.element.addEventListener(type, handler);
        };
        SVGmaction.kind = maction_js_3.MmlMaction.prototype.kind;
        SVGmaction.styles = {
            '[jax="SVG"] mjx-tool': {
                display: 'inline-block',
                position: 'relative',
                width: 0, height: 0
            },
            '[jax="SVG"] mjx-tool > mjx-tip': {
                position: 'absolute',
                top: 0, left: 0
            },
            'mjx-tool > mjx-tip': {
                display: 'inline-block',
                padding: '.2em',
                border: '1px solid #888',
                'font-size': '70%',
                'background-color': '#F8F8F8',
                color: 'black',
                'box-shadow': '2px 2px 5px #AAAAAA'
            },
            'g[data-mml-node="maction"][data-toggle]': {
                cursor: 'pointer'
            },
            'mjx-status': {
                display: 'block',
                position: 'fixed',
                left: '1em',
                bottom: '1em',
                'min-width': '25%',
                padding: '.2em .4em',
                border: '1px solid #888',
                'font-size': '90%',
                'background-color': '#F8F8F8',
                color: 'black'
            }
        };
        SVGmaction.actions = new Map([
            ['toggle', [function (node, _data) {
                        node.adaptor.setAttribute(node.element, 'data-toggle', node.node.attributes.get('selection'));
                        var math = node.factory.jax.math;
                        var document = node.factory.jax.document;
                        var mml = node.node;
                        node.setEventHandler('click', function (event) {
                            if (!math.end.node) {
                                math.start.node = math.end.node = math.typesetRoot;
                                math.start.n = math.end.n = 0;
                            }
                            mml.nextToggleSelection();
                            math.rerender(document);
                            event.stopPropagation();
                        });
                    }, {}]],
            ['tooltip', [function (node, data) {
                        var tip = node.childNodes[1];
                        if (!tip)
                            return;
                        var rect = node.firstChild();
                        if (tip.node.isKind('mtext')) {
                            var text = tip.node.getText();
                            node.adaptor.insert(node.svg('title', {}, [node.text(text)]), rect);
                        }
                        else {
                            var adaptor_1 = node.adaptor;
                            var container_1 = node.jax.container;
                            var math = node.node.factory.create('math', {}, [node.childNodes[1].node]);
                            var tool_1 = node.html('mjx-tool', {}, [node.html('mjx-tip')]);
                            var hidden_1 = adaptor_1.append(rect, node.svg('foreignObject', { style: { display: 'none' } }, [tool_1]));
                            node.jax.processMath(math, adaptor_1.firstChild(tool_1));
                            node.childNodes[1].node.parent = node.node;
                            node.setEventHandler('mouseover', function (event) {
                                data.stopTimers(node, data);
                                data.hoverTimer.set(node, setTimeout(function () {
                                    adaptor_1.setStyle(tool_1, 'left', '0');
                                    adaptor_1.setStyle(tool_1, 'top', '0');
                                    adaptor_1.append(container_1, tool_1);
                                    var tbox = adaptor_1.nodeBBox(tool_1);
                                    var nbox = adaptor_1.nodeBBox(node.element);
                                    var dx = (nbox.right - tbox.left) / node.metrics.em + node.dx;
                                    var dy = (nbox.bottom - tbox.bottom) / node.metrics.em + node.dy;
                                    adaptor_1.setStyle(tool_1, 'left', node.px(dx));
                                    adaptor_1.setStyle(tool_1, 'top', node.px(dy));
                                }, data.postDelay));
                                event.stopPropagation();
                            });
                            node.setEventHandler('mouseout', function (event) {
                                data.stopTimers(node, data);
                                var timer = setTimeout(function () { return adaptor_1.append(hidden_1, tool_1); }, data.clearDelay);
                                data.clearTimer.set(node, timer);
                                event.stopPropagation();
                            });
                        }
                    }, maction_js_2.TooltipData]],
            ['statusline', [function (node, data) {
                        var tip = node.childNodes[1];
                        if (!tip)
                            return;
                        if (tip.node.isKind('mtext')) {
                            var adaptor_2 = node.adaptor;
                            var text_1 = tip.node.getText();
                            adaptor_2.setAttribute(node.element, 'data-statusline', text_1);
                            node.setEventHandler('mouseover', function (event) {
                                if (data.status === null) {
                                    var body = adaptor_2.body(adaptor_2.document);
                                    data.status = adaptor_2.append(body, node.html('mjx-status', {}, [node.text(text_1)]));
                                }
                                event.stopPropagation();
                            });
                            node.setEventHandler('mouseout', function (event) {
                                if (data.status) {
                                    adaptor_2.remove(data.status);
                                    data.status = null;
                                }
                                event.stopPropagation();
                            });
                        }
                    }, {
                        status: null
                    }]]
        ]);
        return SVGmaction;
    }((0, maction_js_1.CommonMactionMixin)(Wrapper_js_1.SVGWrapper)));
    exports.SVGmaction = SVGmaction;
},
749: /* mathjax-full/js/output/common/Wrappers/maction.js */ function _(require, module, exports, __esModule, __esExport) {
    var __extends = (this && this.__extends) || (function () {
        var extendStatics = function (d, b) {
            extendStatics = Object.setPrototypeOf ||
                ({ __proto__: [] } instanceof Array && function (d, b) { d.__proto__ = b; }) ||
                function (d, b) { for (var p in b)
                    if (Object.prototype.hasOwnProperty.call(b, p))
                        d[p] = b[p]; };
            return extendStatics(d, b);
        };
        return function (d, b) {
            if (typeof b !== "function" && b !== null)
                throw new TypeError("Class extends value " + String(b) + " is not a constructor or null");
            extendStatics(d, b);
            function __() { this.constructor = d; }
            d.prototype = b === null ? Object.create(b) : (__.prototype = b.prototype, new __());
        };
    })();
    var __read = (this && this.__read) || function (o, n) {
        var m = typeof Symbol === "function" && o[Symbol.iterator];
        if (!m)
            return o;
        var i = m.call(o), r, ar = [], e;
        try {
            while ((n === void 0 || n-- > 0) && !(r = i.next()).done)
                ar.push(r.value);
        }
        catch (error) {
            e = { error: error };
        }
        finally {
            try {
                if (r && !r.done && (m = i["return"]))
                    m.call(i);
            }
            finally {
                if (e)
                    throw e.error;
            }
        }
        return ar;
    };
    var __spreadArray = (this && this.__spreadArray) || function (to, from, pack) {
        if (pack || arguments.length === 2)
            for (var i = 0, l = from.length, ar; i < l; i++) {
                if (ar || !(i in from)) {
                    if (!ar)
                        ar = Array.prototype.slice.call(from, 0, i);
                    ar[i] = from[i];
                }
            }
        return to.concat(ar || Array.prototype.slice.call(from));
    };
    __esModule();
    var string_js_1 = require(636) /* ../../../util/string.js */;
    exports.TooltipData = {
        dx: '.2em',
        dy: '.1em',
        postDelay: 600,
        clearDelay: 100,
        hoverTimer: new Map(),
        clearTimer: new Map(),
        stopTimers: function (node, data) {
            if (data.clearTimer.has(node)) {
                clearTimeout(data.clearTimer.get(node));
                data.clearTimer.delete(node);
            }
            if (data.hoverTimer.has(node)) {
                clearTimeout(data.hoverTimer.get(node));
                data.hoverTimer.delete(node);
            }
        }
    };
    function CommonMactionMixin(Base) {
        return (function (_super) {
            __extends(class_1, _super);
            function class_1() {
                var args = [];
                for (var _i = 0; _i < arguments.length; _i++) {
                    args[_i] = arguments[_i];
                }
                var _this = _super.apply(this, __spreadArray([], __read(args), false)) || this;
                var actions = _this.constructor.actions;
                var action = _this.node.attributes.get('actiontype');
                var _a = __read(actions.get(action) || [(function (_node, _data) { }), {}], 2), handler = _a[0], data = _a[1];
                _this.action = handler;
                _this.data = data;
                _this.getParameters();
                return _this;
            }
            Object.defineProperty(class_1.prototype, "selected", {
                get: function () {
                    var selection = this.node.attributes.get('selection');
                    var i = Math.max(1, Math.min(this.childNodes.length, selection)) - 1;
                    return this.childNodes[i] || this.wrap(this.node.selected);
                },
                enumerable: false,
                configurable: true
            });
            class_1.prototype.getParameters = function () {
                var offsets = this.node.attributes.get('data-offsets');
                var _a = __read((0, string_js_1.split)(offsets || ''), 2), dx = _a[0], dy = _a[1];
                this.dx = this.length2em(dx || exports.TooltipData.dx);
                this.dy = this.length2em(dy || exports.TooltipData.dy);
            };
            class_1.prototype.computeBBox = function (bbox, recompute) {
                if (recompute === void 0) {
                    recompute = false;
                }
                bbox.updateFrom(this.selected.getOuterBBox());
                this.selected.setChildPWidths(recompute);
            };
            return class_1;
        }(Base));
    }
    exports.CommonMactionMixin = CommonMactionMixin;
},
750: /* mathjax-full/js/core/MmlTree/MmlNodes/maction.js */ function _(require, module, exports, __esModule, __esExport) {
    var __extends = (this && this.__extends) || (function () {
        var extendStatics = function (d, b) {
            extendStatics = Object.setPrototypeOf ||
                ({ __proto__: [] } instanceof Array && function (d, b) { d.__proto__ = b; }) ||
                function (d, b) { for (var p in b)
                    if (Object.prototype.hasOwnProperty.call(b, p))
                        d[p] = b[p]; };
            return extendStatics(d, b);
        };
        return function (d, b) {
            if (typeof b !== "function" && b !== null)
                throw new TypeError("Class extends value " + String(b) + " is not a constructor or null");
            extendStatics(d, b);
            function __() { this.constructor = d; }
            d.prototype = b === null ? Object.create(b) : (__.prototype = b.prototype, new __());
        };
    })();
    var __assign = (this && this.__assign) || function () {
        __assign = Object.assign || function (t) {
            for (var s, i = 1, n = arguments.length; i < n; i++) {
                s = arguments[i];
                for (var p in s)
                    if (Object.prototype.hasOwnProperty.call(s, p))
                        t[p] = s[p];
            }
            return t;
        };
        return __assign.apply(this, arguments);
    };
    __esModule();
    var MmlNode_js_1 = require(639) /* ../MmlNode.js */;
    var MmlMaction = (function (_super) {
        __extends(MmlMaction, _super);
        function MmlMaction() {
            return _super !== null && _super.apply(this, arguments) || this;
        }
        Object.defineProperty(MmlMaction.prototype, "kind", {
            get: function () {
                return 'maction';
            },
            enumerable: false,
            configurable: true
        });
        Object.defineProperty(MmlMaction.prototype, "arity", {
            get: function () {
                return 1;
            },
            enumerable: false,
            configurable: true
        });
        Object.defineProperty(MmlMaction.prototype, "selected", {
            get: function () {
                var selection = this.attributes.get('selection');
                var i = Math.max(1, Math.min(this.childNodes.length, selection)) - 1;
                return this.childNodes[i] || this.factory.create('mrow');
            },
            enumerable: false,
            configurable: true
        });
        Object.defineProperty(MmlMaction.prototype, "isEmbellished", {
            get: function () {
                return this.selected.isEmbellished;
            },
            enumerable: false,
            configurable: true
        });
        Object.defineProperty(MmlMaction.prototype, "isSpacelike", {
            get: function () {
                return this.selected.isSpacelike;
            },
            enumerable: false,
            configurable: true
        });
        MmlMaction.prototype.core = function () {
            return this.selected.core();
        };
        MmlMaction.prototype.coreMO = function () {
            return this.selected.coreMO();
        };
        MmlMaction.prototype.verifyAttributes = function (options) {
            _super.prototype.verifyAttributes.call(this, options);
            if (this.attributes.get('actiontype') !== 'toggle' &&
                this.attributes.getExplicit('selection') !== undefined) {
                var attributes = this.attributes.getAllAttributes();
                delete attributes.selection;
            }
        };
        MmlMaction.prototype.setTeXclass = function (prev) {
            if (this.attributes.get('actiontype') === 'tooltip' && this.childNodes[1]) {
                this.childNodes[1].setTeXclass(null);
            }
            var selected = this.selected;
            prev = selected.setTeXclass(prev);
            this.updateTeXclass(selected);
            return prev;
        };
        MmlMaction.prototype.nextToggleSelection = function () {
            var selection = Math.max(1, this.attributes.get('selection') + 1);
            if (selection > this.childNodes.length) {
                selection = 1;
            }
            this.attributes.set('selection', selection);
        };
        MmlMaction.defaults = __assign(__assign({}, MmlNode_js_1.AbstractMmlNode.defaults), { actiontype: 'toggle', selection: 1 });
        return MmlMaction;
    }(MmlNode_js_1.AbstractMmlNode));
    exports.MmlMaction = MmlMaction;
},
751: /* mathjax-full/js/output/svg/Wrappers/menclose.js */ function _(require, module, exports, __esModule, __esExport) {
    var __extends = (this && this.__extends) || (function () {
        var extendStatics = function (d, b) {
            extendStatics = Object.setPrototypeOf ||
                ({ __proto__: [] } instanceof Array && function (d, b) { d.__proto__ = b; }) ||
                function (d, b) { for (var p in b)
                    if (Object.prototype.hasOwnProperty.call(b, p))
                        d[p] = b[p]; };
            return extendStatics(d, b);
        };
        return function (d, b) {
            if (typeof b !== "function" && b !== null)
                throw new TypeError("Class extends value " + String(b) + " is not a constructor or null");
            extendStatics(d, b);
            function __() { this.constructor = d; }
            d.prototype = b === null ? Object.create(b) : (__.prototype = b.prototype, new __());
        };
    })();
    var __createBinding = (this && this.__createBinding) || (Object.create ? (function (o, m, k, k2) {
        if (k2 === undefined)
            k2 = k;
        var desc = Object.getOwnPropertyDescriptor(m, k);
        if (!desc || ("get" in desc ? !m.__esModule : desc.writable || desc.configurable)) {
            desc = { enumerable: true, get: function () { return m[k]; } };
        }
        Object.defineProperty(o, k2, desc);
    }) : (function (o, m, k, k2) {
        if (k2 === undefined)
            k2 = k;
        o[k2] = m[k];
    }));
    var __setModuleDefault = (this && this.__setModuleDefault) || (Object.create ? (function (o, v) {
        Object.defineProperty(o, "default", { enumerable: true, value: v });
    }) : function (o, v) {
        o["default"] = v;
    });
    var __importStar = (this && this.__importStar) || function (mod) {
        if (mod && mod.__esModule)
            return mod;
        var result = {};
        if (mod != null)
            for (var k in mod)
                if (k !== "default" && Object.prototype.hasOwnProperty.call(mod, k))
                    __createBinding(result, mod, k);
        __setModuleDefault(result, mod);
        return result;
    };
    var __values = (this && this.__values) || function (o) {
        var s = typeof Symbol === "function" && Symbol.iterator, m = s && o[s], i = 0;
        if (m)
            return m.call(o);
        if (o && typeof o.length === "number")
            return {
                next: function () {
                    if (o && i >= o.length)
                        o = void 0;
                    return { value: o && o[i++], done: !o };
                }
            };
        throw new TypeError(s ? "Object is not iterable." : "Symbol.iterator is not defined.");
    };
    var __read = (this && this.__read) || function (o, n) {
        var m = typeof Symbol === "function" && o[Symbol.iterator];
        if (!m)
            return o;
        var i = m.call(o), r, ar = [], e;
        try {
            while ((n === void 0 || n-- > 0) && !(r = i.next()).done)
                ar.push(r.value);
        }
        catch (error) {
            e = { error: error };
        }
        finally {
            try {
                if (r && !r.done && (m = i["return"]))
                    m.call(i);
            }
            finally {
                if (e)
                    throw e.error;
            }
        }
        return ar;
    };
    __esModule();
    var Wrapper_js_1 = require(680) /* ../Wrapper.js */;
    var menclose_js_1 = require(752) /* ../../common/Wrappers/menclose.js */;
    var Notation = __importStar(require(754) /* ../Notation.js */);
    var menclose_js_2 = require(755) /* ../../../core/MmlTree/MmlNodes/menclose.js */;
    var SVGmenclose = (function (_super) {
        __extends(SVGmenclose, _super);
        function SVGmenclose() {
            return _super !== null && _super.apply(this, arguments) || this;
        }
        SVGmenclose.prototype.toSVG = function (parent) {
            var e_1, _a;
            var svg = this.standardSVGnode(parent);
            var left = this.getBBoxExtenders()[3];
            var def = {};
            if (left > 0) {
                def.transform = 'translate(' + this.fixed(left) + ', 0)';
            }
            var block = this.adaptor.append(svg, this.svg('g', def));
            if (this.renderChild) {
                this.renderChild(this, block);
            }
            else {
                this.childNodes[0].toSVG(block);
            }
            try {
                for (var _b = __values(Object.keys(this.notations)), _c = _b.next(); !_c.done; _c = _b.next()) {
                    var name_1 = _c.value;
                    var notation = this.notations[name_1];
                    !notation.renderChild && notation.renderer(this, svg);
                }
            }
            catch (e_1_1) {
                e_1 = { error: e_1_1 };
            }
            finally {
                try {
                    if (_c && !_c.done && (_a = _b.return))
                        _a.call(_b);
                }
                finally {
                    if (e_1)
                        throw e_1.error;
                }
            }
        };
        SVGmenclose.prototype.arrow = function (W, a, double, offset, dist) {
            if (offset === void 0) {
                offset = '';
            }
            if (dist === void 0) {
                dist = 0;
            }
            var _a = this.getBBox(), w = _a.w, h = _a.h, d = _a.d;
            var dw = (W - w) / 2;
            var m = (h - d) / 2;
            var t = this.thickness;
            var t2 = t / 2;
            var _b = __read([t * this.arrowhead.x, t * this.arrowhead.y, t * this.arrowhead.dx], 3), x = _b[0], y = _b[1], dx = _b[2];
            var arrow = (double ?
                this.fill('M', w + dw, m, 'l', -(x + dx), y, 'l', dx, t2 - y, 'L', x - dw, m + t2, 'l', dx, y - t2, 'l', -(x + dx), -y, 'l', x + dx, -y, 'l', -dx, y - t2, 'L', w + dw - x, m - t2, 'l', -dx, t2 - y, 'Z') :
                this.fill('M', w + dw, m, 'l', -(x + dx), y, 'l', dx, t2 - y, 'L', -dw, m + t2, 'l', 0, -t, 'L', w + dw - x, m - t2, 'l', -dx, t2 - y, 'Z'));
            var transform = [];
            if (dist) {
                transform.push(offset === 'X' ? "translate(".concat(this.fixed(-dist), " 0)") : "translate(0 ".concat(this.fixed(dist), ")"));
            }
            if (a) {
                var A = this.jax.fixed(-a * 180 / Math.PI);
                transform.push("rotate(".concat(A, " ").concat(this.fixed(w / 2), " ").concat(this.fixed(m), ")"));
            }
            if (transform.length) {
                this.adaptor.setAttribute(arrow, 'transform', transform.join(' '));
            }
            return arrow;
        };
        SVGmenclose.prototype.line = function (pq) {
            var _a = __read(pq, 4), x1 = _a[0], y1 = _a[1], x2 = _a[2], y2 = _a[3];
            return this.svg('line', {
                x1: this.fixed(x1), y1: this.fixed(y1),
                x2: this.fixed(x2), y2: this.fixed(y2),
                'stroke-width': this.fixed(this.thickness)
            });
        };
        SVGmenclose.prototype.box = function (w, h, d, r) {
            if (r === void 0) {
                r = 0;
            }
            var t = this.thickness;
            var def = {
                x: this.fixed(t / 2), y: this.fixed(t / 2 - d),
                width: this.fixed(w - t), height: this.fixed(h + d - t),
                fill: 'none', 'stroke-width': this.fixed(t)
            };
            if (r) {
                def.rx = this.fixed(r);
            }
            return this.svg('rect', def);
        };
        SVGmenclose.prototype.ellipse = function (w, h, d) {
            var t = this.thickness;
            return this.svg('ellipse', {
                rx: this.fixed((w - t) / 2), ry: this.fixed((h + d - t) / 2),
                cx: this.fixed(w / 2), cy: this.fixed((h - d) / 2),
                'fill': 'none', 'stroke-width': this.fixed(t)
            });
        };
        SVGmenclose.prototype.path = function (join) {
            var _this = this;
            var P = [];
            for (var _i = 1; _i < arguments.length; _i++) {
                P[_i - 1] = arguments[_i];
            }
            return this.svg('path', {
                d: P.map(function (x) { return (typeof x === 'string' ? x : _this.fixed(x)); }).join(' '),
                style: { 'stroke-width': this.fixed(this.thickness) },
                'stroke-linecap': 'round', 'stroke-linejoin': join,
                fill: 'none'
            });
        };
        SVGmenclose.prototype.fill = function () {
            var _this = this;
            var P = [];
            for (var _i = 0; _i < arguments.length; _i++) {
                P[_i] = arguments[_i];
            }
            return this.svg('path', {
                d: P.map(function (x) { return (typeof x === 'string' ? x : _this.fixed(x)); }).join(' ')
            });
        };
        SVGmenclose.kind = menclose_js_2.MmlMenclose.prototype.kind;
        SVGmenclose.notations = new Map([
            Notation.Border('top'),
            Notation.Border('right'),
            Notation.Border('bottom'),
            Notation.Border('left'),
            Notation.Border2('actuarial', 'top', 'right'),
            Notation.Border2('madruwb', 'bottom', 'right'),
            Notation.DiagonalStrike('up'),
            Notation.DiagonalStrike('down'),
            ['horizontalstrike', {
                    renderer: Notation.RenderLine('horizontal', 'Y'),
                    bbox: function (node) { return [0, node.padding, 0, node.padding]; }
                }],
            ['verticalstrike', {
                    renderer: Notation.RenderLine('vertical', 'X'),
                    bbox: function (node) { return [node.padding, 0, node.padding, 0]; }
                }],
            ['box', {
                    renderer: function (node, _child) {
                        var _a = node.getBBox(), w = _a.w, h = _a.h, d = _a.d;
                        node.adaptor.append(node.element, node.box(w, h, d));
                    },
                    bbox: Notation.fullBBox,
                    border: Notation.fullBorder,
                    remove: 'left right top bottom'
                }],
            ['roundedbox', {
                    renderer: function (node, _child) {
                        var _a = node.getBBox(), w = _a.w, h = _a.h, d = _a.d;
                        var r = node.thickness + node.padding;
                        node.adaptor.append(node.element, node.box(w, h, d, r));
                    },
                    bbox: Notation.fullBBox
                }],
            ['circle', {
                    renderer: function (node, _child) {
                        var _a = node.getBBox(), w = _a.w, h = _a.h, d = _a.d;
                        node.adaptor.append(node.element, node.ellipse(w, h, d));
                    },
                    bbox: Notation.fullBBox
                }],
            ['phasorangle', {
                    renderer: function (node, _child) {
                        var _a = node.getBBox(), w = _a.w, h = _a.h, d = _a.d;
                        var a = node.getArgMod(1.75 * node.padding, h + d)[0];
                        var t = node.thickness / 2;
                        var HD = h + d;
                        var cos = Math.cos(a);
                        node.adaptor.append(node.element, node.path('mitre', 'M', w, t - d, 'L', t + cos * t, t - d, 'L', cos * HD + t, HD - d - t));
                    },
                    bbox: function (node) {
                        var p = node.padding / 2;
                        var t = node.thickness;
                        return [2 * p, p, p + t, 3 * p + t];
                    },
                    border: function (node) { return [0, 0, node.thickness, 0]; },
                    remove: 'bottom'
                }],
            Notation.Arrow('up'),
            Notation.Arrow('down'),
            Notation.Arrow('left'),
            Notation.Arrow('right'),
            Notation.Arrow('updown'),
            Notation.Arrow('leftright'),
            Notation.DiagonalArrow('updiagonal'),
            Notation.DiagonalArrow('northeast'),
            Notation.DiagonalArrow('southeast'),
            Notation.DiagonalArrow('northwest'),
            Notation.DiagonalArrow('southwest'),
            Notation.DiagonalArrow('northeastsouthwest'),
            Notation.DiagonalArrow('northwestsoutheast'),
            ['longdiv', {
                    renderer: function (node, _child) {
                        var _a = node.getBBox(), w = _a.w, h = _a.h, d = _a.d;
                        var t = node.thickness / 2;
                        var p = node.padding;
                        node.adaptor.append(node.element, node.path('round', 'M', t, t - d, 'a', p - t / 2, (h + d) / 2 - 4 * t, 0, '0,1', 0, h + d - 2 * t, 'L', w - t, h - t));
                    },
                    bbox: function (node) {
                        var p = node.padding;
                        var t = node.thickness;
                        return [p + t, p, p, 2 * p + t / 2];
                    }
                }],
            ['radical', {
                    renderer: function (node, child) {
                        node.msqrt.toSVG(child);
                        var left = node.sqrtTRBL()[3];
                        node.place(-left, 0, child);
                    },
                    init: function (node) {
                        node.msqrt = node.createMsqrt(node.childNodes[0]);
                    },
                    bbox: function (node) { return node.sqrtTRBL(); },
                    renderChild: true
                }]
        ]);
        return SVGmenclose;
    }((0, menclose_js_1.CommonMencloseMixin)(Wrapper_js_1.SVGWrapper)));
    exports.SVGmenclose = SVGmenclose;
},
752: /* mathjax-full/js/output/common/Wrappers/menclose.js */ function _(require, module, exports, __esModule, __esExport) {
    var __extends = (this && this.__extends) || (function () {
        var extendStatics = function (d, b) {
            extendStatics = Object.setPrototypeOf ||
                ({ __proto__: [] } instanceof Array && function (d, b) { d.__proto__ = b; }) ||
                function (d, b) { for (var p in b)
                    if (Object.prototype.hasOwnProperty.call(b, p))
                        d[p] = b[p]; };
            return extendStatics(d, b);
        };
        return function (d, b) {
            if (typeof b !== "function" && b !== null)
                throw new TypeError("Class extends value " + String(b) + " is not a constructor or null");
            extendStatics(d, b);
            function __() { this.constructor = d; }
            d.prototype = b === null ? Object.create(b) : (__.prototype = b.prototype, new __());
        };
    })();
    var __createBinding = (this && this.__createBinding) || (Object.create ? (function (o, m, k, k2) {
        if (k2 === undefined)
            k2 = k;
        var desc = Object.getOwnPropertyDescriptor(m, k);
        if (!desc || ("get" in desc ? !m.__esModule : desc.writable || desc.configurable)) {
            desc = { enumerable: true, get: function () { return m[k]; } };
        }
        Object.defineProperty(o, k2, desc);
    }) : (function (o, m, k, k2) {
        if (k2 === undefined)
            k2 = k;
        o[k2] = m[k];
    }));
    var __setModuleDefault = (this && this.__setModuleDefault) || (Object.create ? (function (o, v) {
        Object.defineProperty(o, "default", { enumerable: true, value: v });
    }) : function (o, v) {
        o["default"] = v;
    });
    var __importStar = (this && this.__importStar) || function (mod) {
        if (mod && mod.__esModule)
            return mod;
        var result = {};
        if (mod != null)
            for (var k in mod)
                if (k !== "default" && Object.prototype.hasOwnProperty.call(mod, k))
                    __createBinding(result, mod, k);
        __setModuleDefault(result, mod);
        return result;
    };
    var __read = (this && this.__read) || function (o, n) {
        var m = typeof Symbol === "function" && o[Symbol.iterator];
        if (!m)
            return o;
        var i = m.call(o), r, ar = [], e;
        try {
            while ((n === void 0 || n-- > 0) && !(r = i.next()).done)
                ar.push(r.value);
        }
        catch (error) {
            e = { error: error };
        }
        finally {
            try {
                if (r && !r.done && (m = i["return"]))
                    m.call(i);
            }
            finally {
                if (e)
                    throw e.error;
            }
        }
        return ar;
    };
    var __spreadArray = (this && this.__spreadArray) || function (to, from, pack) {
        if (pack || arguments.length === 2)
            for (var i = 0, l = from.length, ar; i < l; i++) {
                if (ar || !(i in from)) {
                    if (!ar)
                        ar = Array.prototype.slice.call(from, 0, i);
                    ar[i] = from[i];
                }
            }
        return to.concat(ar || Array.prototype.slice.call(from));
    };
    var __values = (this && this.__values) || function (o) {
        var s = typeof Symbol === "function" && Symbol.iterator, m = s && o[s], i = 0;
        if (m)
            return m.call(o);
        if (o && typeof o.length === "number")
            return {
                next: function () {
                    if (o && i >= o.length)
                        o = void 0;
                    return { value: o && o[i++], done: !o };
                }
            };
        throw new TypeError(s ? "Object is not iterable." : "Symbol.iterator is not defined.");
    };
    __esModule();
    var Notation = __importStar(require(753) /* ../Notation.js */);
    var string_js_1 = require(636) /* ../../../util/string.js */;
    function CommonMencloseMixin(Base) {
        return (function (_super) {
            __extends(class_1, _super);
            function class_1() {
                var args = [];
                for (var _i = 0; _i < arguments.length; _i++) {
                    args[_i] = arguments[_i];
                }
                var _this = _super.apply(this, __spreadArray([], __read(args), false)) || this;
                _this.notations = {};
                _this.renderChild = null;
                _this.msqrt = null;
                _this.padding = Notation.PADDING;
                _this.thickness = Notation.THICKNESS;
                _this.arrowhead = { x: Notation.ARROWX, y: Notation.ARROWY, dx: Notation.ARROWDX };
                _this.TRBL = [0, 0, 0, 0];
                _this.getParameters();
                _this.getNotations();
                _this.removeRedundantNotations();
                _this.initializeNotations();
                _this.TRBL = _this.getBBoxExtenders();
                return _this;
            }
            class_1.prototype.getParameters = function () {
                var attributes = this.node.attributes;
                var padding = attributes.get('data-padding');
                if (padding !== undefined) {
                    this.padding = this.length2em(padding, Notation.PADDING);
                }
                var thickness = attributes.get('data-thickness');
                if (thickness !== undefined) {
                    this.thickness = this.length2em(thickness, Notation.THICKNESS);
                }
                var arrowhead = attributes.get('data-arrowhead');
                if (arrowhead !== undefined) {
                    var _b = __read((0, string_js_1.split)(arrowhead), 3), x = _b[0], y = _b[1], dx = _b[2];
                    this.arrowhead = {
                        x: (x ? parseFloat(x) : Notation.ARROWX),
                        y: (y ? parseFloat(y) : Notation.ARROWY),
                        dx: (dx ? parseFloat(dx) : Notation.ARROWDX)
                    };
                }
            };
            class_1.prototype.getNotations = function () {
                var e_1, _b;
                var Notations = this.constructor.notations;
                try {
                    for (var _c = __values((0, string_js_1.split)(this.no