"""
The POTENTIAL PREDATORY JOURNALS were extracted from https://beallslist.net/standalone-journals/

Using the following script (With some additional manual adjustments after extraction, like removing journals indexed by DOAJ):

var links = Array.from(document.querySelectorAll("li a"));
links = links.map(x => ({name: x.text, url: x.href}));
console.log(JSON.stringify(links));

"""

POTENTIAL_PREDATORY_JOURNALS = [
    {"name":"Academic Exchange Quarterly","url":"http://www.rapidintellect.com/AEQweb/"},
    {"name":"Academic Research Reviews","url":"http://academicreviews.us/Default.aspx"},
    {"name":"Academy of Contemporary Research Journal ","url":"http://aocrj.org/"},
    {"name":"ACME Intellects","url":"http://www.acmeintellects.org/"},
    {"name":"Acta  de Gerencia Ciencia","url":"http://www.cagena.com/"},
    {"name":"Acta Advances in Agricultural Sciences","url":"http://www.aaasjournal.com/"},
    {"name":"Acta Kinesiologica","url":"http://www.actakin.com/"},
    {"name":"Acta Medica International","url":"http://www.tmu.ac.in/acta_publications.htm"},
    {"name":"Acta Scientiae et Intellectus","url":"http://www.actaint.com/"},
    {"name":"Acta Velit","url":"http://actavelit.com/"},
    {"name":"Advance Journals of Engineering Mathematics and Computer Sciences","url":"http://ajemc.in/index.php/ajemc"},
    {"name":"Advance Research Journal of Multidisciplinary Discoveries","url":"http://www.journalresearchijf.com/"},
    {"name":"The Advanced Science Journal","url":"http://advancedscience.org/"},
    {"name":"Advances in Aerospace Science and Technology","url":"http://www.scirp.org/journal/AAST"},
    {"name":"Advances in Biomedicine and Pharmacy","url":"http://www.thescientificpub.com/"},
    {"name":"Advances in Forestry Letter","url":"http://www.afl-journal.org/index.aspx"},
    {"name":"Advances in Science, Technology and Engineering Systems Journal","url":"http://www.astesj.com/"},
    {"name":"Afrasian Journal of Humanities and Social Sciences","url":"http://www.aajhss.org/index.php/aajhss"},
    {"name":"African Journal of Traditional, Complementary and Alternative Medicines","url":"http://journals.sfu.ca/africanem/index.php/ajtcam/index"},
    {"name":"Aging","url":"http://www.impactaging.com/index.html"},
    {"name":"Ahead International Journal of Recent Research Review","url":"http://www.aijrrr.com/"},
    {"name":"Al Ameen Journal of Medical Sciences","url":"http://ajms.alameenmedical.org/"},
    {"name":"Aloy Journal of Soft Computing and Applications","url":"http://ajsca.org/"},
    {"name":"American Based Research Journal","url":"http://www.abrj.org/"},
    {"name":"American International Journal of Contemporary Research","url":"http://aijcrnet.com/"},
    {"name":"American International Journal of Contemporary Scientific Research","url":"http://www.americanij.com/"},
    {"name":"American Journal of Advanced Agricultural Research","url":"http://www.esterdjipress.org/index.php/AJAAR"},
    {"name":"American Journal of Advanced Drug Delivery","url":"http://ojadd.com/index.php/AJADD"},
    {"name":"American Journal of Advanced Scientific Research","url":"http://www.esterdjipress.org/index.php/AJAAR"},
    {"name":"American Journal of Advances in Medical Science","url":"http://www.arnaca.com/"},
    {"name":"American Journal of Biotechnology and Medical Research","url":"http://my.ejmanager.com/ajbmr/"},
    {"name":"American Journal of Engineering Research","url":"http://www.ajer.org/"},
    {"name":"American Journal of Essential Oils and Natural Products","url":"http://essencejournal.com/index.html"},
    {"name":"American Journal of Innovative Research and Applied Sciences","url":"http://american-jiras.com/"},
    {"name":"American Journal of Pharmacy and Health Research","url":"http://www.ajphr.com/"},
    {"name":"American Journal of PharmTech Research","url":"http://www.ajptr.com/"},
    {"name":"American Journal of Phytomedicine and Clinical Therapeutics","url":"http://www.ajpct.org/"},
    {"name":"American Journal of Research Communication","url":"http://www.usa-journals.com/"},
    {"name":"American Journal of Scientific Research","url":"http://www.americanjournalofscientificresearch.com/"},
    {"name":"American Journal of Social issues and Humanities ","url":"http://www.ajsih.org/index.php/ajsih"},
    {"name":"American Research Thoughts","url":"http://researchthoughts.us/Default.aspx"},
    {"name":"American Scientific Research Journal for Engineering, Technology, and Sciences","url":"http://asrjetsjournal.org/"},
    {"name":"American Transactions on Engineering & Applied Sciences","url":"http://tuengr.com/ATEAS/index.html"},
    {"name":"Anglisticum","url":"http://www.anglisticum.mk/index.php"},
    {"name":"Annals of EURASIAN MEDICIN","url":"http://www.aemed.eu/en/index.php"},
    {"name":"Annals of British Medical Sciences","url":"http://abmsj.co.uk/index.htm"},
    {"name":"Annals of Clinical Case Reports","url":"http://anncaserep.com/"},
    {"name":"Annals of International Medical and Dental Research","url":"http://aimdrjournal.com/"},
    {"name":"Annals of Medical and Biomedical Sciences","url":"http://ambs-journal.co.uk/"},
    {"name":"Annals of Phytomedicine","url":"http://ukaazpublications.com/publications/index.php"},
    {"name":"Applied Research Journal","url":"http://arjournal.org/"},
    {"name":"Archives Des Sciences Journal","url":"http://www.sciencesarchive.com/"},
    {"name":"ARNACA American Journal of Advances in Medical Science","url":"http://arnaca.com/"},
    {"name":"ARPN Journal of Science and Technology","url":"http://ejournalofscience.org/"},
    {"name":"ARPN Journal of Systems and Software","url":"http://www.scientific-journals.org/"},
    {"name":"Asia Pacific Journal of Education, Arts and Sciences","url":"http://apjeas.apjmr.com/"},
    {"name":"Asia Pacific Journal of Multidisciplinary Research","url":"http://www.apjmr.com/"},
    {"name":"Asian Pacific Journal of Natural Products","url":"http://ainstin.com/asian-pacific-journal-of-natural-products"},
    {"name":"Asian Pacific Journal of Pharmacy and Phytochemistry","url":"http://apjpp.com/"},
    {"name":"Asia-Pacific Journal of Research","url":"http://apjor.com/index.php"},
    {"name":"Asian Journal of Applied Science and Engineering","url":"http://ajase.weebly.com/"},
    {"name":"Asian Journal of Biomedical and Pharmaceutical Sciences","url":"http://www.jbiopharm.com/index.php/ajbp"},
    {"name":"Asian Journal of Chemistry","url":"http://www.asianjournalofchemistry.co.in/Home.aspx"},
    {"name":"Asian Journal of Health and Medical Sciences","url":"http://www.ajhms.org/"},
    {"name":"Asian Journal of Humanities and Social Sciences","url":"http://ajhss.org/"},
    {"name":"Asian Journal of Business and Management Sciences","url":"http://www.ajbms.org/index.php"},
    {"name":"Asian Journal of Mathematics and Applications","url":"http://scienceasia.asia/index.php/ama"},
    {"name":"Asian Journal of Multidisciplinary Studies","url":"http://www.ajms.co.in/sites/ajms/index.php/ajms"},
    {"name":"Asian Journal of Pharmaceutical and Health Sciences","url":"http://ajphs.com/"},
    {"name":"Asian Journal of Pharmacy and Life Science","url":"http://www.ajpls.com/index.html"},
    {"name":"Asian Journal of Pharmaceutical Research and Health Care","url":"http://jprhc.in/index.php"},
    {"name":"Asian Journal of Science and Technology","url":"http://www.journalajst.com/"},
    {"name":"Asian Pacific Journal of Health Sciences","url":"http://www.apjhs.com/index.html"},
    {"name":"Asian Pacific Journal of Tropical Disease","url":"http://www.apjtcm.com/"},
    {"name":"Asian Research Journal of Business Management","url":"http://www.arjbm.com/index.php"},
    {"name":"Australasian Journal of Herpetology","url":"http://www.smuggled.com/AJHFP1.htm"},
    {"name":"JCR","url":"https://mjl.clarivate.com/search-results?issn=1836-1935"},
    {"name":"Australian Journal of Basic and Applied Sciences","url":"http://www.ajbasweb.com/"},
    {"name":"Australian Journal of Business and Management Research","url":"http://www.ajbmr.com/index.php"},
    {"name":"Astronomical Review","url":"http://journals.ke-i.org/index.php/AstRv"},
    {"name":"Averroes European Medical Journal","url":"http://www.averroes-emj.com/"},
    {"name":"Ayupharm: International Journal of Ayurveda and Allied Sciences","url":"http://www.ayurpharm.com/"},
    {"name":"Ayushdhar","url":"http://ayushdhara.in/index.php/ayushdhara"},
    {"name":"Bio Bulletin","url":"http://www.biobulletin.com/"},
    {"name":"Bioinformation","url":"http://bioinformation.net/"},
    {"name":"Biointerface Research in Applied Chemistry","url":"http://biointerfaceresearch.com/"},
    {"name":"Biomaterials and Tissue Engineering Bulletin","url":"http://btebulletin.com/"},
    {"name":"Biomedical & Pharmacology Journa","url":"http://www.biomedpharmajournal.org/"},
    {"name":"Biomedical Engineering Review","url":"http://journals.ke-i.org/index.php/bme"},
    {"name":"Bionano Frontier","url":"http://bionanofrontier.org/"},
    {"name":"Biopharm Journal","url":"http://www.biopharmj.com/"},
    {"name":"The Bioscan","url":"http://www.thebioscan.in/index.htm"},
    {"name":"Bioresearch Bulletin","url":"http://bioresonline.org/"},
    {"name":"Bioscience and Bioengineering Communications","url":"http://www.bioscibioeng.com/"},
    {"name":"Bioscience Biotechnology Research Communications","url":"http://www.bbrc.in/"},
    {"name":"Bioscience Discovery","url":"http://biosciencediscovery.com/index.html#gsc.tab=0"},
    {"name":"Biosciences, Biotechnology Research Asia","url":"http://www.biotech-asia.org/"},
    {"name":"Biosciences International","url":"http://biosciencesjournal.info/index.php/biointl/"},
    {"name":"Biotechnological Research","url":"http://www.biotechnologicalresearch-journal.com/"},
    {"name":"Botany Journal","url":"http://plantsjournal.com/"},
    {"name":"British Biomedical Bulletin","url":"http://bbbulletin.org/"},
    {"name":"British Journal of Economics, Finance and Management Sciences","url":"http://www.ajournal.co.uk/BJEFM.htm"},
    {"name":"British Journal of Interdisciplinary Studies","url":"http://www.bjis-online.org/index.php/bjis"},
    {"name":"British Journal of Medical and Health Research","url":"http://www.bjmhr.com/index.php"},
    {"name":"British Journal of Science","url":"http://www.ajournal.co.uk/index.htm"},
    {"name":"Buletin Teknologi Makanan","url":"http://www.btmjournal.com/index.html"},
    {"name":"Bulletin of Applied and Research Science","url":"http://www.barsjournal.net/"},
    {"name":"Bulletin of Mathematical Sciences & Applications","url":"http://www.bmsa.us/index.php"},
    {"name":"Bulletin of Pharmaceutical Research","url":"http://journal.appconnect.in/"},
    {"name":"Bulletin of Society for Mathematical Services and Standards","url":"http://www.jsomass.com/index.php"},
    {"name":"Business and Economics Journal","url":"http://www.irbejournal.com/"},
    {"name":"The Business Review, Cambridge","url":"http://www.jaabc.com/brc.html"},
    {"name":"Calodema","url":"http://www.calodema.com/"},
    {"name":"Canadian Chemical Transactions","url":"http://canchemtrans.ca/"},
    {"name":"Canadian International Journal of Science and Technology","url":"http://www.tcsse.org/#!journal/ct84"},
    {"name":"Canadian Journal of Basic and Applied Sciences","url":"http://www.cjbas.com/"},
    {"name":"Canadian Journal of Biotechnology","url":"http://www.canadianjbiotech.com/index.php"},
    {"name":"Canadian Journal of Pure and Applied Sciences","url":"http://www.cjpas.net/"},
    {"name":"Canadian Scientific Journal","url":"http://csjournal.ca/"},
    {"name":"Cancer Research Frontiers","url":"http://cancer-research-frontiers.org/"},
    {"name":"Cardiology and Cardiovascular Medicine","url":"http://www.cardiolcardiovascmed.com/"},
    {"name":"Caribbean Journal of Science and Technology","url":"http://caribjscitech.com/"},
    {"name":"Case Study and Case Report","url":"http://www.scopemed.org/?jid=23"},
    {"name":"Caspian Sea Journal","url":"http://csjonline.org/index.php"},
    {"name":"Cellular and Molecular Biology","url":"http://www.cellmolbiol.com/"},
    {"name":"Cellular and Molecular Biology","url":"http://www.omicsonline.com/open-access/cellular-and-molecular-biology.php"},
    {"name":"Centrum","url":"http://www.centrum.mk/"},
    {"name":"Chemical Science Transactions","url":"http://www.e-journals.in/"},
    {"name":"Chemistry Research Journal","url":"http://chemrj.org/"},
    {"name":"Clinics in Oncology","url":"http://www.clinicsinoncology.com/"},
    {"name":"Clinics in Surgery","url":"http://www.clinicsinsurgery.com/"},
    {"name":"Columban Journal of Life Sciences","url":"http://cjlscience.org/"},
    {"name":"Communications on Applied Electronics","url":"http://www.caeaccess.org/"},
    {"name":"Computational Research Progress in Applied Science & Engineering","url":"http://www.crpase.com/"},
    {"name":"Computer Science Chronicle","url":"http://www.cschronicle.org/"},
    {"name":"Computer Science Journal","url":"http://comsj.org/"},
    {"name":"Contemporary Research in India","url":"http://www.contemporaryresearchindia.net/"},
    {"name":"Contemporary Sociological Global Review","url":"http://www.csgr.syllabapress.us/index.html"},
    {"name":"The Criterion: An International Journal in English","url":"http://www.the-criterion.com/"},
    {"name":"Current Biotica","url":"http://www.currentbiotica.com/"},
    {"name":"Current Botany","url":"http://currentbotany.org/index.php/currbotany/"},
    {"name":"Current Discovery","url":"http://www.ijcdi.com/"},
    {"name":"Current Trends in Technology and Sciences","url":"http://www.ctts.in/"},
    {"name":"DAV International Journal of Science","url":"http://davjournal.com/"},
    {"name":"Dawn Journal","url":"http://thedawnjournal.com/"},
    {"name":"Der Pharma Chemica","url":"http://derpharmachemica.com/"},
    {"name":"Direct Research Journals","url":"http://directresearchjournals.org/index.html"},
    {"name":"Diyala Journal for Pure Science","url":"http://www.sciencesmag.uodiyala.edu.iq/"},
    {"name":"East European Science Journal","url":"http://eesa-journal.com/en/"},
    {"name":"Eastern Academic Journal","url":"http://www.e-acadjournal.org/"},
    {"name":"Eastern European Scientific Journal","url":"http://journale.auris-verlag.de/index.php/EESJ"},
    {"name":"E-Library Science Research Journal","url":"http://lsrj.in/Default1.aspx"},
    {"name":"Ecoforum","url":"http://www.ecoforumjournal.ro/index.php/eco"},
    {"name":"Ecoletra.com Scientific eJournal","url":"http://ebook.ecoletra.com/ecoletra-com-scientific-ejournal"},
    {"name":"EDUVED Global Management Research","url":"http://egmr.eduved.org/"},
    {"name":"Eduved, International Journal of Interdisciplinary Research","url":"http://www.eduved.org/"},
    {"name":"Electronic Journal of Biology","url":"http://www.ejbio.com/"},
    {"name":"Electronic Journal of Engineering and Technology","url":"http://www.ejet.org.uk/index.html"},
    {"name":"Electronic Journal of Geotechnical Engineering","url":"http://www.ejge.com/"},
    {"name":"Electronic Journal of Vocational Colleges","url":"http://www.ejovoc.org/default.aspx"},
    {"name":"Elixir International Journal","url":"http://www.elixirpublishers.com/"},
    {"name":"Elixir Online  Journal","url":"http://www.elixirjournal.org/"},
    {"name":"Engineering & IT Journal","url":"http://www.eitjournal.com/"},
    {"name":"Engineering Physics and Thermodynamics Journal","url":"http://djphys.org/"},
    {"name":"Engineering Research Journal","url":"http://www.mnf-eng.com/"},
    {"name":"Entomology and Applied Science Letters","url":"http://easletters.com/"},
    {"name":"ESSENCE: International Journal for Environmental Rehabilitation and Conservation","url":"http://essence-journal.com/"},
    {"name":"Euro-Afro Journal of Arts and Social Sciences","url":"http://euro-afrojournals.com/index.php"},
    {"name":"European Academic Research","url":"http://www.euacademic.org/Default.aspx"},
    {"name":"European Chemical Bulletin","url":"http://www.eurchembull.com/index.php/ECB"},
    {"name":"European Environmental Sciences and Ecology Journal","url":"http://www.eesej.eu/"},
    {"name":"European International Journal of Science and Humanities","url":"http://www.eijsr.org/"},
    {"name":"European International Journal of Science and Technology","url":"http://www.cekinfo.org.uk/EIJST"},
    {"name":"European Journal of Academic Essays","url":"http://euroessays.org/"},
    {"name":"European Journal of Advanced Computer Science","url":"http://eujcs.eu/"},
    {"name":"European Journal of Advances in Engineering & Technology","url":"http://ejaet.com/theme.php?go=home"},
    {"name":"European Journal of Biomedical and Pharmaceutical Sciences","url":"http://www.ejbps.com/"},
    {"name":"European Journal of Biotechnology and Bioscience","url":"http://www.biotechjournal.info/"},
    {"name":"European Journal of Business and Social Sciences","url":"http://www.ejbss.com/home.aspx"},
    {"name":"European Journal of Chemistry","url":"http://www.eurjchem.com/index.php/eurjchem"},
    {"name":"European Journal of Contemporary Economics and Management","url":"http://ejcem.eu/"},
    {"name":"European Journal of Economics, Finance and Administrative Sciences","url":"http://www.europeanjournalofeconomicsfinanceandadministrativesciences.com/"},
    {"name":"European Journal of Educational Research","url":"http://eurojedu.com/"},
    {"name":"European Journal of Educational Sciences","url":"http://www.ejes.eu/"},
    {"name":"European Journal of Engineering Research and Science","url":"http://www.ejers.org/index.php/ejers"},
    {"name":"European Journal of Natural History","url":"http://world-science.ru/euro/"},
    {"name":"European Journal of Pharmaceutical and Medical Research","url":"http://www.ejpmr.com/"},
    {"name":"European Journal of Science and Theology","url":"http://www.ejst.tuiasi.ro/"},
    {"name":"European Journal of Scientific Research","url":"http://www.europeanjournalofscientificresearch.com/"},
    {"name":"European Journal of Social Sciences","url":"http://www.europeanjournalofsocialsciences.com/index.html"},
    {"name":"European Journal of Sustainable Development","url":"http://www.ecsdev.org/"},
    {"name":"European Law and Politics Journal","url":"http://elpjournal.eu/"},
    {"name":"European Online Journal of Natural and Social Sciences","url":"http://european-science.com/eojnss/index"},
    {"name":"European Scientific Journal","url":"http://eujournal.org/index.php/esj"},
    {"name":"Experiment","url":"http://www.experimentjournal.com/"},
    {"name":"First Independent Scientific Journal","url":"http://firjournal.com.ua/"},
    {"name":"FLUIDS: International Journal of Medical Fluid Management","url":"http://www.fluidsjournal.org/"},
    {"name":"Food Biology","url":"http://foodbiology.org/index.php/foodbio/"},
    {"name":"FOREX Technical Journal Library","url":"http://www.forexjournal.co.in/Index.aspx"},
    {"name":"Frontiers in Aerospace Engineering","url":"http://www.fae-journal.org/index.aspx"},
    {"name":"Functional Analysis: Theory, Method & Applications","url":"http://jfatma.com/index.php"},
    {"name":"G-Journal of Environmental Science and Technology","url":"http://gjestenv.com/"},
    {"name":"G-Journal of Education, Social Science and Humanities","url":"http://gjestenv.com/"},
    {"name":"Galaxy: International Multidisciplinary Research Journal","url":"http://www.galaxyimrj.com/"},
    {"name":"Genes & Cancer","url":"http://www.impactjournals.com/Genes&Cancer/"},
    {"name":"Generics and Biosimilars Initiative Journal","url":"http://gabi-journal.net/"},
    {"name":"Genetics and Molecular Research","url":"http://www.geneticsmr.com/"},
    {"name":"Geodynamics Research International Bulletin","url":"http://www.geo-dynamica.com/"},
    {"name":"Global Journal for Research Analysis","url":"http://worldwidejournals.com/gra/"},
    {"name":"Global Journal of Advanced Engineering Technologies and Sciences","url":"http://www.gjaets.com/"},
    {"name":"Global Journal of Advanced Research ","url":"http://www.gjar.org/"},
    {"name":"Global Journal of Animal Scientific Research","url":"http://www.gjasr.com/"},
    {"name":"Global Journal of Business and Social Science","url":"http://www.gjbss.com/"},
    {"name":"Global Journal of Business and Social Science Review","url":"http://www.gjbssr.org/"},
    {"name":"Global Journal of Engineering Science and Research Management","url":"http://www.gjesrm.com/"},
    {"name":"Global Journal of Management Science and Technology","url":"http://gjmst.com/index.htm"},
    {"name":"Global Journal of Medical and Health Sciences","url":"http://globaljmhs.org/"},
    {"name":"Global Journal of Medicine and Public Health","url":"http://www.gjmedph.org/"},
    {"name":"Global Journal of Multidisciplinary Studies","url":"http://www.gjms.co.in/index.php/gjms/index"},
    {"name":"Global Media Journal","url":"http://www.globalmediajournal.com/"},
    {"name":"Golden Research Thoughts","url":"http://aygrt.isrj.org/Default.aspx"},
    {"name":"Global Scholastic Research Journal","url":"http://globalscholasticresearch.org/"},
    {"name":"HCTL Open International Journal of Technology Innovations and Research","url":"http://ijtir.hctl.org/"},
    {"name":"Hiperboreea Journal","url":"http://revistahiperboreea.ro/"},
    {"name":"HortFlora Research Spectrum","url":"http://hortflorajournal.com/"},
    {"name":"Hygeia: Journal for Drugs and Medicines","url":"http://www.hygeiajournal.com/"},
    {"name":"IARS’ International Research Journal","url":"http://www.irj.iars.info/index.php"},
    {"name":"Ideal Journal of Arts and Humanities","url":"http://ijah.truescholar.org/"},
    {"name":"Ideal Journal of Engineering and Applied Sciences","url":"http://ijeas.truescholar.org/"},
    {"name":"Ideal Journal of Economics and Management Sciences","url":"http://ijems.truescholar.org/"},
    {"name":"Ideal Journal of Pure and Applied Sciences","url":"http://ijopas.truescholar.org/"},
    {"name":"Ideal Journal of Education and Policy Studies","url":"http://ijeps.truescholar.org/"},
    {"name":"Ideal Journal of Psychology and Theology","url":"http://ijopat.truescholar.org/"},
    {"name":"Indian Journal of Advanced Nursing","url":"http://ijan.co.in/"},
    {"name":"Indian Journal of Applied-Basic Medical Sciences","url":"http://www.themedicalacademy.in/"},
    {"name":"Indian Journal of Applied Research","url":"http://www.theglobaljournals.com/ijar/index.php"},
    {"name":"Indian Journal of Drugs","url":"http://drugresearch.in/"},
    {"name":"Indian Journal of Medical Research and Pharmaceutical Sciences","url":"http://www.ijmrps.com/"},
    {"name":"Indian Journal of Natural Sciences","url":"http://tnsroindia.org.in/journals.html"},
    {"name":"Indian Journal of Pharmaceutical and Biological Research","url":"http://ijpbr.in/"},
    {"name":"Indian Journal of Pharmaceutical Science & Research","url":"http://www.ijpsrjournal.com/index.php"},
    {"name":"Indian Journal of Research Anvikshiki","url":"http://www.anvikshikijournal.com/"},
    {"name":"Indian Journal of Research in Pharmacy and Biotechnology","url":"http://www.ijrpb.com/"},
    {"name":"Indian Journal of Scientific Research ","url":"http://www.ijsr.in/index.php"},
    {"name":"Indian Journal of Scientific Research and Technology","url":"http://www.indjsrt.com/"},
    {"name":"Indian Research Journal of Pharmacy and Science","url":"http://irjps.in/"},
    {"name":"Indian Scholar","url":"http://www.indianscholar.co.in/"},
    {"name":"Indian Streams Research Journal","url":"http://isrj.org/Default.aspx"},
    {"name":"Indo American Journal of Pharmaceutical Research","url":"http://www.iajpr.com/"},
    {"name":"Indo American Journal of Pharmaceutical Sciences","url":"http://iajps.com/"},
    {"name":"Indo-Global Journal of Pharmaceutical Sciences","url":"http://iglobaljournal.com/"},
    {"name":"Industrial Science Journal","url":"http://www.industrialscience.org/Default.aspx"},
    {"name":"INFORMATION-An International Interdisciplinary Journal","url":"http://www.information-iii.org/information_journal.html"},
    {"name":"Innovations in Pharmaceuticals and Pharmacotherapy","url":"http://www.innpharmacotherapy.com/Default.aspx"},
    {"name":"Institute of Electrical & Electronics Engineers Advanced Journal","url":"http://www.ieeeaj.com/"},
    {"name":"Integrated Journal of British","url":"http://www.ijbritish.com/"},
    {"name":"Interdisciplinary Journal of Contemporary Research in Business","url":"http://ijcrb.webs.com/"},
    {"name":"Interdisciplinary Journal of Research in Business","url":"http://www.idjrb.com/index.php"},
    {"name":"Interdisciplinary Toxicology","url":"http://www.intertox.sav.sk/"},
    {"name":"Internal Medicine Review","url":"http://internalmedicinereview.org/index.php/imr"},
    {"name":"International Advanced Research Journal in Science, Engineering and Technology","url":"http://iarjset.com/"},
    {"name":"International Archives of BioMedical and Clinical Research","url":"http://iabcr.org/"},
    {"name":"International Archives of Medicine","url":"http://www.intarchmed.com/"},
    {"name":"International Ayurvedic Medical Journal","url":"http://www.iamj.in/"},
    {"name":"The International Asian Research Journal ","url":"http://www.tiarj.com/"},
    {"name":"International Biology Review","url":"http://journals.ke-i.org/index.php/IBR"},
    {"name":"International Bulletin of Business Administration","url":"http://www.internationalbulletinofbusinessadministration.com/"},
    {"name":"International Cardiovascular Forum","url":"http://icfjournal.org/"},
    {"name":"International Cardiovascular Forum","url":"http://journals.sfu.ca/icfj/index.php/icfj/index"},
    {"name":"International Chemistry Review","url":"http://journals.ke-i.org/index.php/icr"},
    {"name":"International Design Journal","url":"http://www.journal.faa-design.com/index.htm"},
    {"name":"International Economic Letters","url":"http://www.ielonline.eu/"},
    {"name":"International Education and Research Journal","url":"http://www.ierj.in/"},
    {"name":"International Educational E-Journal","url":"http://oiirj.org/oiirj/ejournal/"},
    {"name":"International Educational Scientific Research Journal","url":"http://iesrj.com/"},
    {"name":"International Interdisciplinary Journal of Education","url":"http://iijoe.org/"},
    {"name":"International Interdisciplinary Journal of Scientific Research","url":"http://www.iijsr.org/"},
    {"name":"International Journal & Magazine of Engineering, Technology, Management and Research","url":"http://www.ijmetmr.com/"},
    {"name":"International Journal Advances in Social Science and Humanities ","url":"http://www.ijassh.com/index.php"},
    {"name":"International Journal and Bulletin of Multidisciplinary Research","url":"http://www.ijnmr.com/"},
    {"name":"International Journal for Advanced Review and Research in Pharmacy","url":"http://www.ijarrp.com/"},
    {"name":"International Journal for Development of Computer Science and Technology","url":"http://ijdcst.com/Default.aspx"},
    {"name":"International Journal for Innovation Education and Research","url":"http://www.ijier.net/"},
    {"name":"International Journal for Innovative Research in Multidisciplinary Field","url":"http://ijirmf.com/"},
    {"name":"International Journal for Innovative Research in Science and Technology","url":"http://www.ijirst.org/"},
    {"name":"International Journal for Modern Trends in Science and Technology","url":"http://www.ijmtst.com/index.html"},
    {"name":"International Journal for Pharmaceutical Research Scholars","url":"http://www.ijprs.com/"},
    {"name":"International Journal for Research & Development in Technology","url":"http://ijrdt.org/"},
    {"name":"International Journal for Research in Applied Science and Engineering Technology","url":"http://www.ijraset.com/"},
    {"name":"International Journal for Research in Emerging Science and Technology","url":"http://ijrest.net/"},
    {"name":"International Journal for Research in Engineering Application & Management","url":"http://www.ijream.org/"},
    {"name":"International Journal for Scientific Research & Development","url":"http://www.ijsrd.com/"},
    {"name":"International Journal for Technological Research in Engineering","url":"http://www.ijtre.com/home/"},
    {"name":"International Journal of Abdominal Research","url":"http://blackhorse.nazwa.pl/public_html/ojs/index.php/ijar"},
    {"name":"International Journal of Academic Research","url":"http://www.ijar.org.in/index.php"},
    {"name":"International Journal of Academic Studies","url":"http://www.ijacademicstudies.com/"},
    {"name":"International Journal of Advance Computing Techniques and Applications","url":"http://www.ijacta.com/index.php/ojs"},
    {"name":"International Journal of Advance Engineering and Research Development","url":"http://www.ijaerd.com/"},
    {"name":"International Journal of Advance Foundation and Research in Computer","url":"http://www.ijafrc.org/"},
    {"name":"International Journal of Advance Foundation and Research in Science and Engineering","url":"http://ijafrse.org/"},
    {"name":"International Journal of Advance Research and Innovation","url":"http://www.ijari.org/"},
    {"name":"International Journal of Advance Research and Innovative Ideas in Education","url":"http://ijariie.com/"},
    {"name":"International Journal of Advance Research, Ideas and Innovations in Technology ","url":"http://www.ijariit.com/"},
    {"name":"International Journal of Advance Research in Computer Science And Management","url":"http://www.ijarcsms.com/"},
    {"name":"International Journal of Advance Research in Science and Engineering","url":"http://www.ijarse.com/"},
    {"name":"International Journal of Advanced Academic Research","url":"http://www.ijaar.org/"},
    {"name":"International Journal of Advanced and Innovative Research","url":"http://ijair.jctjournals.com/"},
    {"name":"International Journal of Advanced Computer Technology","url":"http://www.ijact.org/"},
    {"name":"International Journal of Advanced Computer Technology","url":"http://ijact.in/"},
    {"name":"International Journal of Advanced Education and Research","url":"http://www.alleducationjournal.com/"},
    {"name":"International Journal of Advanced Engineering and Management Research","url":"http://www.ijaemr.com/"},
    {"name":"International Journal of Advanced Engineering and Nano Technology","url":"http://www.ijaent.org/"},
    {"name":"International Journal of Advanced Engineering Applications","url":"http://fragrancejournals.com/"},
    {"name":"International Journal of Advanced Engineering, Management and Science","url":"http://ijaems.com/"},
    {"name":"International Journal of Advanced Engineering Research and Applications","url":"http://www.ijaera.org/"},
    {"name":"International Journal of Advanced Engineering Research and Science","url":"http://www.ijaers.com/"},
    {"name":"International Journal of Advanced Engineering Science and Technological Research","url":"http://www.ader.org.in/"},
    {"name":"International Journal of Advanced Engineering Science and Technological Research","url":"http://www.aestjournal.org/"},
    {"name":"International Journal of Advanced Information in Arts Science and Management","url":"http://www.ijaiasm.com/"},
    {"name":"International Journal of Advanced Information Science and Technology","url":"http://www.ijaist.com/"},
    {"name":"International Journal of Advanced Life Sciences","url":"http://ijals.com/"},
    {"name":"International Journal of Advanced Multidisciplinary Research","url":"http://ijarm.com/index.html"},
    {"name":"International Journal of Advanced Networking and Applications","url":"http://www.ijana.in/"},
    {"name":"International Journal of Advanced Research","url":"http://www.journalijar.com/index.php"},
    {"name":"International Journal of Advanced Research and Review","url":"http://www.ijarr.in/"},
    {"name":"International Journal of Advanced Research in Applied Science and Technology","url":"http://ijarast.com/"},
    {"name":"International Journal of Advanced Research in Biological Sciences","url":"http://www.ijarbs.com/"},
    {"name":"International Journal of Advanced Research in Biology, Ecology, Science and Technology","url":"http://www.ijarbest.com/"},
    {"name":"International Journal of Advanced Research in Computer and Communication Engineering","url":"http://www.ijarcce.com/"},
    {"name":"International Journal of Advanced Research in Computer Science and Electronics Engineering","url":"http://ijarcsee.org/index.php/IJARCSEE"},
    {"name":"International Journal of Advanced Research in Computer Science and Software Engineering","url":"http://www.ijarcsse.com/"},
    {"name":"International Journal of Advanced Research in Computer Science & Technology","url":"http://www.ijarcst.com/index.html"},
    {"name":"International Journal of Advanced Research in Education & Technology","url":"http://ijaret.com/"},
    {"name":"International Journal of Advanced Research in Electrical, Electronics and Instrumentation Engineering","url":"http://www.ijareeie.com/"},
    {"name":"International Journal of Advanced Research in Engineering & Management","url":"http://www.ijarem.org/"},
    {"name":"International Journal of Advanced Research in Engineering and Science","url":"http://www.ijares.com/"},
    {"name":"International Journal of Advanced Research in Mechanical Engineering & Technology","url":"http://ijarmet.com/"},
    {"name":"International Journal of Advanced Research in Science and Technology","url":"http://www.ijarst.com/"},
    {"name":"International Journal of Advanced Research in Science, Engineering and Technology","url":"http://www.ijarset.com/"},
    {"name":"International Journal of Advanced Science and Engineering Technology","url":"http://www.ijaset.com/"},
    {"name":"International Journal of Advanced Scientific Research & Development","url":"https://www.ijasrd.org/in/"},
    {"name":"International Journal of Advanced Technology and Innovative Research","url":"http://www.ijatir.org/"},
    {"name":"International Journal of Advanced Technology in Engineering and Science","url":"http://www.ijates.com/"},
    {"name":"International Journal of Advanced Technology and Engineering Research","url":"http://www.ijater.com/"},
    {"name":"International Journal of Advanced Technology and Science","url":"http://www.ijats.org/"},
    {"name":"International Journal of Advanced Trends in Computer Applications","url":"http://ijatca.com/"},
    {"name":"International Journal of Advancement in Engineering Technology, Management & Applied Science","url":"http://www.ijaetmas.com/"},
    {"name":"International Journal of Advancements in Mechanical and Aeronautical Engineering","url":"http://www.ijamae.uamae.org/editorial_board.html"},
    {"name":"International Journal of Advancements in Research & Technology ","url":"http://www.ijoart.org/"},
    {"name":"International Journal of Advances in Applied Mathematics and Mechanics","url":"http://www.ijaamm.com/"},
    {"name":"International Journal of Advances in Engineering","url":"http://www.ijae.in/"},
    {"name":"International Journal of Advances in Engineering & Technology","url":"http://www.ijaet.org/"},
    {"name":"International Journal of Advances in Interdisciplinary Research","url":"https://www.academiascholarlyjournal.org/ijasrr"},
    {"name":"International Journal of Advances in Management and Economics","url":"http://www.managementjournal.info/"},
    {"name":"International Journal of Advances in Management, Economics and Entrepreneurship","url":"http://www.ijamee.info/"},
    {"name":"International Journal of Advances in Mathematics","url":"http://adv-math.com/"},
    {"name":"International Journal of Advances in Pharmaceutical Research","url":"http://www.ijapronline.org/index.php"},
    {"name":"International Journal of Advances in Power Systems ","url":"http://www.ijaps.org/Index/"},
    {"name":"International Journal of Advances in Social Science and Humanities","url":"http://www.ijassh.com/index.php"},
    {"name":"International Journal of Advent Research in Computer and Electronics","url":"http://ijarce.com/"},
    {"name":"International Journal of Aerospace and Mechanical Engineering","url":"http://www.ijamejournals.com/"},
    {"name":"International Journal of Agriculture and Crop Sciences","url":"http://ijagcs.com/"},
    {"name":"International Journal of Agriculture and Environmental Research","url":"http://ijaer.in/index.php"},
    {"name":"International Journal of Agriculture Innovations and Research","url":"http://ijair.org/"},
    {"name":"International Journal of Agricultural, Forestry & Plantation","url":"http://ijafp.com/"},
    {"name":"International Journal of Agricultural Sciences and Veterinary Medicine","url":"http://www.ijasvm.com/"},
    {"name":"International Journal of Agronomy & Plant Production","url":"http://www.ijappjournal.com/"},
    {"name":"International Journal of All Research Education & Scientific Methods","url":"http://www.ijaresm.com/"},
    {"name":"International Journal of Application or Innovation in Engineering & Management","url":"http://www.ijaiem.org/"},
    {"name":"International Journal of Applied and Pure Science and Agriculture","url":"http://ijapsa.com/"},
    {"name":"International Journal of Applied Biology and Pharmaceutical Technology","url":"http://www.ijabpt.com/index.html"},
    {"name":"International Journal of Applied Dental Sciences","url":"http://www.oraljournal.com/"},
    {"name":"International Journal of Applied Economic Studies","url":"http://sijournals.com/IJAE/"},
    {"name":"International Journal of Applied Information Systems","url":"http://www.ijais.org/"},
    {"name":"International Journal of Applied Linguistics & English Literature","url":"http://www.journals.aiac.org.au/index.php/IJALEL"},
    {"name":"International Journal of Applied Pharmaceutical & Biological Research","url":"http://www.ijapbr.com/"},
    {"name":"International Journal of Applied Pharmaceutical Sciences and Biological Sciences","url":"http://ijapsbs.com/"},
    {"name":"International Journal of Applied Research","url":"http://www.allresearchjournal.com/"},
    {"name":"International Journal of Applied Research & Studies","url":"http://www.ijars.in/"},
    {"name":"International Journal of Applied Research in Natural Products","url":"http://www.ijarnp.org/index.php/ijarnp"},
    {"name":"International Journal of Applied Science Engineering and Management","url":"http://www.ijasem.com/"},
    {"name":"International Journal of Applied Sciences and Biotechnology","url":"http://ijasbt.org/"},
    {"name":"International Journal of Applied Sciences and Engineering","url":"http://www.ijapscengr.com/"},
    {"name":"International Journal of Architecture, Civil Engineering and Urban Design","url":"http://iaajs.com/ijacu/"},
    {"name":"International Journal of Artificial Intelligence and Mechatronics","url":"http://www.ijaim.org/"},
    {"name":"International Journal of Art and Humanity Science","url":"http://www.ijahs.com/"},
    {"name":"International Journal of Arts and Commerce","url":"http://www.ijac.org.uk/"},
    {"name":"International Journal of Arts and Entrepreneurship","url":"http://www.ijsse.org/index.php?option=com_content&view=article&id=67&Itemid=63"},
    {"name":"International Journal of Arts, Humanities and Management Studies","url":"http://ijahms.com/"},
    {"name":"International Journal of Arts Humanities and Social Sciences","url":"http://www.ijahss.com/"},
    {"name":"International Journal of Ayurveda and Pharma Research","url":"http://ijapr.in/"},
    {"name":"International Journal of Ayurveda and Pharmaceutical Chemistry","url":"http://ijapc.com/"},
    {"name":"International Journal of Basic and Applied Science","url":"http://www.insikapub.com/"},
    {"name":"International Journal of Basic Medical Sciences and Pharmacy ","url":"http://www.ijbmsp.org/index.php/IJBMSP/index"},
    {"name":"International Journal of Basic Sciences and Applied Computing","url":"http://www.ijbsac.org/"},
    {"name":"International Journal of Basic Sciences and Applied Research","url":"https://https://www.textroad.com/Basic%20and%20Applied%20Scientific%20Research-Scope.html"},
    {"name":"International Journal of Bio","url":"http://www.ijobio.com/"},
    {"name":"International Journal of Bioassays","url":"https://www.ijbio.com/index.php/ijb"},
    {"name":"International Journal of Biological & Pharmaceutical Research","url":"http://www.ijbpr.com/"},
    {"name":"International Journal of Biological and Chemical Sciences","url":"http://www.ifgdg.org/index.php?option=com_content&view=featured&Itemid=564"},
    {"name":"International Journal of Biology, Pharmacy and Allied Sciences","url":"http://www.ijbpas.com/"},
    {"name":"International Journal of Biomedical Science","url":"http://www.ijbs.org/HomePage.aspx"},
    {"name":"International Journal of Biosciences and Nanosciences","url":"http://ijbsans.com/index.html"},
    {"name":"International Journal of Business and Administration Research Review","url":"http://www.ijbarr.com/"},
    {"name":"International Journal of Business and Commerce","url":"http://www.ijbcnet.com/"},
    {"name":"The International Journal of Business & Management","url":"http://www.theijbm.com/"},
    {"name":"International Journal of Business and Management Invention","url":"http://www.ijbmi.org/index.html"},
    {"name":"International Journal of Business and Social Research","url":"http://thejournalofbusiness.org/index.php/site"},
    {"name":"International Journal of Business Management and Economic Research","url":"http://www.ijbmer.com/index.php"},
    {"name":"International Journal of Business Management and Economic Studies","url":"http://www.ijbmes.com/"},
    {"name":"International Journal of Business Marketing and Management","url":"http://www.ijbmm.com/"},
    {"name":"International Journal of Business Quantitative Economics and Applied Management Research","url":"http://ijbemr.com/"},
    {"name":"International Journal of Business Tourism & Applied Sciences","url":"http://www.ijbts-journal.com/"},
    {"name":"International Journal of Case Studies","url":"http://www.casestudiesjournal.com/"},
    {"name":"International Journal of Chemical and Pharmaceutical Sciences","url":"http://www.ijcps.com/"},
    {"name":"International Journal of Chemical Science and Technology","url":"http://www.ijcst.net/"},
    {"name":"International Journal of Chemical Studies","url":"http://www.chemijournal.com/"},
    {"name":"International Journal of Civil, Mechanical and Energy Science","url":"http://ijcmes.com/"},
    {"name":"International Journal of Clinical and Diagnostic Research","url":"http://ijcdr.net/index.php"},
    {"name":"International Journal of Clinical Cases and Investigations","url":"http://ijcci.info/"},
    {"name":"International Journal of Collaborative Research on Internal Medicine & Public Health ","url":"http://www.iomcworld.com/ijcrimph/"},
    {"name":"International Journal of Commerce and Management Research","url":"http://www.managejournal.com/"},
    {"name":"International Journal of Communication and Health","url":"http://communicationandhealth.ro/"},
    {"name":"International Journal of Communication Networks and Information Security","url":"http://www.ijcnis.org/"},
    {"name":"International Journal of Comprehensive Research in Biological Sciences","url":"http://ijcrbs.com/index.php"},
    {"name":"International Journal of Computation and Applied Sciences","url":"https://ijocaas.com/"},
    {"name":"International Journal of Computational Engineering Research","url":"http://www.ijceronline.com/"},
    {"name":"International Journal of Computational Science, Mathematics and Engineering","url":"http://www.ijcsme.com/"},
    {"name":"International Journal of Computer & Electronics Research","url":"http://ijcer.org/"},
    {"name":"International Journal of Computer & Communication Engineering Research","url":"http://www.ijccer.org/"},
    {"name":"International Journal of Computer and Information Technology","url":"http://www.ijcit.com/"},
    {"name":"International Journal of Computer Applications","url":"http://www.ijcaonline.org/"},
    {"name":"International Journal of Computer Application and Engineering Technology","url":"http://www.ijcaet.net/"},
    {"name":"International Journal of Computer Applications in Engineering Sciences","url":"http://www.caesjournals.org/"},
    {"name":"International Journal of Computer Applications Technology and Research","url":"http://www.ijcat.com/Default"},
    {"name":"International Journal of Computer Engineering & Applications","url":"http://www.ijcea.com/"},
    {"name":"International Journal of Computer Engineering in Research Trends","url":"http://ijcert.org/"},
    {"name":"International Journal of Computer Networks and Applications","url":"http://www.ijcna.org/"},
    {"name":"International Journal of Computer Networks and Communications Security","url":"http://ijcncs.org/"},
    {"name":"International Journal of Computer Science & Communication Security","url":"http://www.ijcscs.org/"},
    {"name":"International Journal of Computer Science and Business Informatics","url":"http://www.ijcsbi.org/index.php/ijcsbi"},
    {"name":"International Journal of Computer Science and Communication Networks","url":"http://www.ijcscn.com/"},
    {"name":"International Journal of Computer Science and Information Security","url":"https://sites.google.com/site/ijcsis/"},
    {"name":"International Journal of Computer Science and Information Technologies","url":"http://www.ijcsit.com/index.php"},
    {"name":"International Journal of Computer Science and Mobile Computing","url":"http://www.ijcsmc.com/"},
    {"name":"International Journal of Computer Science and Network","url":"http://ijcsn.org/"},
    {"name":"International Journal of Computer Science and Network Security","url":"http://ijcsns.org/"},
    {"name":"International Journal of Computer Science and Software Engineering","url":"http://ijcsse.org/"},
    {"name":"International Journal of Computer Science and Technology","url":"http://ijcst.com/"},
    {"name":"International Journal of Computer Science and Telecommunications","url":"http://www.ijcst.org/"},
    {"name":"International Journal of Computer Science Engineering","url":"http://www.ijcse.net/index.php"},
    {"name":"International Journal of Computer Science Engineering and Technology","url":"http://ijcset.net/"},
    {"name":"International Journal of Computer Science, Information Technology, & Security","url":"http://ijcsits.org/"},
    {"name":"International Journal of Computer Science Issues","url":"http://ijcsi.org/index.php"},
    {"name":"International Journal of Computer Science Trends and Technology","url":"http://www.ijcstjournal.org/"},
    {"name":"International Journal of Computer Systems","url":"http://www.ijcsonline.com/"},
    {"name":"International Journal of Computer Technology and Applications","url":"http://www.ijcta.com/index.php"},
    {"name":"International Journal of Computer Technology and Electronics Engineering","url":"http://www.ijctee.org/"},
    {"name":"International Journal of Computing Academic Research","url":"http://www.meacse.org/ijcar/"},
    {"name":"International Journal of Computing and Corporate Research","url":"http://www.ijccr.com/"},
    {"name":"International Journal of Computing Science and Information Technology","url":"http://ijcsit.org/"},
    {"name":"International Journal of Conference Proceedings","url":"http://jocponline.com/"},
    {"name":"International Journal of Contemporary Applied Sciences","url":"http://ijcas.net/"},
    {"name":"International Journal of Contemporary Medical Research","url":"http://www.ijcmr.com/"},
    {"name":"International Journal of Contemporary Research and Review","url":"http://ijcrr.in/index.php/ijcrr"},
    {"name":"International Journal of Core Engineering and Management","url":"http://ijcem.in/"},
    {"name":"International Journal of Current Advanced Research","url":"http://journalijcar.org/"},
    {"name":"International Journal of Current Agricultural Sciences","url":"http://www.journalijcas.com/"},
    {"name":"International Journal of Current Business and Social Sciences","url":"https://scholarlyoa.com/individual-journals/International%20Journal%20of%20Current%20Business%20and%20Social%20Sciences%20(IJCBSS)"},
    {"name":"International Journal of Current Engineering Sciences","url":"http://www.journalijces.com/"},
    {"name":"International Journal of Current Innovation Research ","url":"http://journalijcir.com/"},
    {"name":"International Journal of Current Medical and Pharmaceutical Research","url":"http://journalcmpr.com/"},
    {"name":"International Journal of Current Medical Sciences","url":"http://journalijcmes.com/"},
    {"name":"International Journal of Current Microbiology and Applied Sciences","url":"http://www.ijcmas.com/"},
    {"name":"International Journal of Current Multidisciplinary Studies","url":"http://international%20journal%20of%20current%20multidisciplinary%20studies/"},
    {"name":"International Journal of Current Pharmaceutical Review and Research","url":"http://ijcpr.com/"},
    {"name":"International Journal of Current Research","url":"http://www.journalcra.com/"},
    {"name":"International Journal of Current Research and Academic Review","url":"http://www.ijcrar.com/"},
    {"name":"International Journal of Current Research and Review","url":"http://www.ijcrr.com/current_issue.html"},
    {"name":"International Journal of Current Research in Chemistry and Pharmaceutical Sciences","url":"http://www.ijcrcps.com/"},
    {"name":"International Journal of Current Research in  Life Sciences","url":"http://www.ijcrls.com/"},
    {"name":"International Journal of Current Research in Multidisciplinary","url":"http://www.ijcrm.com/"},
    {"name":"International Journal of Current Science","url":"http://currentsciencejournal.info/index.html"},
    {"name":"International Journal of Current Science and Technology","url":"http://www.journalijcst.com/"},
    {"name":"International Journal of Dental and Health Sciences","url":"http://www.ijdhs.com/home.html"},
    {"name":"International Journal of Dermatopathology and Surgery","url":"http://dermatopathologyjournal.com/"},
    {"name":"International Journal of Development and Sustainability","url":"http://isdsnet.com/journal.html"},
    {"name":"International Journal of Development Research","url":"http://www.journalijdr.com/"},
    {"name":"International Journal of Digital Communication and Networks","url":"http://ijdcn.co.in/"},
    {"name":"International Journal of Digital Library Services","url":"http://www.ijodls.in/"},
    {"name":"International Journal of Drug Development and Research","url":"http://www.ijddr.in/"},
    {"name":"International Journal of E-Computer Science Evolution","url":"http://www.ijecse.com/"},
    {"name":"International Journal of Economics and Finance","url":"http://www.ijsse.org/index.php?option=com_content&view=article&id=548&Itemid=82"},
    {"name":"International Journal of Economics and Research","url":"http://www.ijeronline.com/"},
    {"name":"International Journal of Economics, Commerce and Management","url":"http://ijecm.co.uk/"},
    {"name":"International Journal of Economics, Finance and Management","url":"http://www.ejournalofbusiness.org/"},
    {"name":"International Journal of Education and Applied Research","url":"http://ijear.org/"},
    {"name":"International Journal of Education and Psychological Research","url":"http://ijepr.org/"},
    {"name":"International Journal of Education and Research","url":"http://www.ijern.com/index.php"},
    {"name":"International Journal of Education and Social Science","url":"http://www.ijessnet.com/"},
    {"name":"The International Journal of Educational and Psychological Assessment","url":"https://sites.google.com/site/tijepa2012/home"},
    {"name":"International Journal of Educational Investigations","url":"http://www.ijeionline.com/"},
    {"name":"International Journal of Electrical and Electronics Engineers","url":"http://www.arresearchpublication.com/"},
    {"name":"International Journal of Electrical, Electronics and Computers","url":"http://eecjournal.com/"},
    {"name":"International Journal of Electrical, Electronics and Mechanical Controls","url":"http://www.ijeemc.com/"},
    {"name":"International Journal of Electrical Energy","url":"http://www.ijoee.org/"},
    {"name":"International Journal of Electrochemical Science","url":"http://www.electrochemsci.org/"},
    {"name":"International Journal of Electronics & Communication Technology","url":"http://iject.org/"},
    {"name":"International Journal of Electronics and Information Engineering","url":"http://ijeie.jalaxy.com.tw/"},
    {"name":"International Journal of Electronics Communication and Computer Engineering","url":"http://www.ijecce.org/"},
    {"name":"International Journal of Electronics Communication and Computer Technology","url":"http://www.ijecct.org/index.htm"},
    {"name":"International Journal of Emerging Engineering Research and Technology","url":"http://www.ijeert.org/"},
    {"name":"International Journal of Emerging Research in Management and Technology ","url":"http://www.ermt.net/"},
    {"name":"International Journal of Emerging Science and Engineering ","url":"http://www.ijese.org/"},
    {"name":"International Journal of Emerging Sciences","url":"http://ijes.info/index.html"},
    {"name":"International Journal of Emerging Technologies and Innovative Research","url":"http://www.jetir.org/"},
    {"name":"International Journal of Emerging Technology & Research","url":"http://www.ijetr.org/"},
    {"name":"International Journal of Emerging Technology and Advanced Engineering","url":"http://www.ijetae.com/index.html"},
    {"name":"International Journal of Emerging Trends in Electrical and Electronics","url":"http://www.ijetee.org/"},
    {"name":"International Journal of Emerging Trends in Pharmaceutical Sciences","url":"http://ijetps.com/"},
    {"name":"International Journal of Emerging Trends in Research","url":"http://www.ijoetr.com/"},
    {"name":"International Journal of Emerging Trends in Science and Technology","url":"http://igmpublication.org/ijetst.in/"},
    {"name":"International Journal of Energy & Technology","url":"http://www.journal-enertech.eu/"},
    {"name":"International Journal of Energy and Water Resources","url":"http://international%20journal%20of%20energy%20and%20water%20resources%20%28ijewr%29/"},
    {"name":"International Journal of Engineering & Science Research","url":"http://www.ijesr.org/"},
    {"name":"International Journal of Engineering and Advanced Research Technology","url":"https://www.ijeart.com/"},
    {"name":"International Journal of Engineering and Advanced Technology","url":"http://www.ijeat.org/"},
    {"name":"International Journal of Engineering and Applied Sciences","url":"http://eaas-journal.org/"},
    {"name":"International Journal of Engineering and Applied Sciences","url":"http://www.ijeas.org/"},
    {"name":"International Journal of Engineering and Computer Science","url":"http://www.ijecs.in/"},
    {"name":"International Journal of Engineering and Innovative Technology","url":"http://ijeit.com/index.php"},
    {"name":"International Journal of Engineering and Management Research","url":"http://www.ijemr.net/"},
    {"name":"International Journal of Engineering and Science","url":"http://www.theijes.com/"},
    {"name":"International Journal of Engineering and Science Invention","url":"http://www.ijesi.org/index.html"},
    {"name":"International Journal of Engineering & Technology","url":"http://www.iet-journals.org/"},
    {"name":"International Journal of Engineering and Technology","url":"http://www.ijetch.org/"},
    {"name":"International Journal of Engineering Applied Science and Technology","url":"http://www.ijeast.com/"},
    {"name":"International Journal of Engineering Associates","url":"http://ijea.jctjournals.com/"},
    {"name":"International Journal of Engineering Development and Research","url":"http://www.ijedr.org/index.php"},
    {"name":"International Journal of Engineering Innovations and Research","url":"http://ijeir.org/"},
    {"name":"International Journal of Engineering Inventions","url":"http://www.ijeijournal.com/index.html"},
    {"name":"International Journal of Engineering Maths and Computer Science","url":"http://ijemcs.in/index.php/ijemcs"},
    {"name":"International Journal of Engineering Research","url":"http://www.ijer.in/ijer/"},
    {"name":"International Journal of Engineering Research and Applications","url":"http://www.ijera.com/index.html"},
    {"name":"International Journal of Engineering Research and Computer Science","url":"http://ijercs.in/"},
    {"name":"International Journal of Engineering Research and Development","url":"http://www.ijerd.com/"},
    {"name":"International Journal of Engineering Research and General Science","url":"http://www.ijergs.org/"},
    {"name":"International Journal of Engineering Research & Management","url":"https://www.ijerm.com/"},
    {"name":"International Journal of Engineering Research & Science","url":"http://www.ijoer.com/"},
    {"name":"International Journal of Engineering Research and Science & Technology","url":"http://www.ijerst.com/index.php"},
    {"name":"International Journal of Engineering Research & Technology","url":"https://www.ijert.org/"},
    {"name":"International Journal of Engineering Researches and Management Studies","url":"http://www.ijerms.com/"},
    {"name":"International Journal of Engineering Science & Advanced Technology","url":"http://ijesat.org/"},
    {"name":"International Journal of Engineering Science and Computing","url":"http://ijesc.org/"},
    {"name":"International Journal of Engineering Science and Generic Research","url":"http://ijesar.in/home/index"},
    {"name":"International Journal of Engineering Science and Innovative Technology","url":"http://www.ijesit.com/"},
    {"name":"International Journal of Engineering, Science and Technology","url":"http://www.ijest-ng.com/"},
    {"name":"International Journal of Engineering Science Invention-Research & Development","url":"http://www.ijesird.com/"},
    {"name":"International Journal of Engineering Sciences & Research Technology","url":"http://www.ijesrt.com/index.html"},
    {"name":"International Journal of Engineering Sciences & Management","url":"http://www.ijesmr.com/"},
    {"name":"International Journal of Engineering Technologies and Management Research","url":"http://www.ijetmr.com/index.html"},
    {"name":"International Journal of Engineering Technology and Computer Research","url":"http://ijetcr.org/"},
    {"name":"International Journal of Engineering Technology and Management","url":"http://ijetm.org/"},
    {"name":"International Journal of Engineering Technology and Scientific Innovation","url":"http://www.ijetsi.org/"},
    {"name":"International Journal of Engineering Technology, Management and Applied Sciences","url":"http://www.ijetmas.com/"},
    {"name":"International Journal of Engineering Trends and Applications","url":"http://www.ijetajournal.org/"},
    {"name":"International Journal of Engineering Trends and Technology","url":"http://ijettjournal.org/"},
    {"name":"International Journal of English and Education","url":"http://ijee.org/"},
    {"name":"International Journal of English Language & Translation Studies","url":"http://eltsjournal.org/"},
    {"name":"International Journal of English Language , Literature & Humanities","url":"http://ijellh.com/"},
    {"name":"International Journal of English Language, Literature and Translation Studies","url":"http://www.ijelr.in/"},
    {"name":"International Journal of English Research","url":"http://www.englishresearchjournal.com/"},
    {"name":"International Journal of Enterprise Computing and Business Systems","url":"http://www.ijecbs.com/"},
    {"name":"International Journal of Environment","url":"http://benjapan.org/ije/"},
    {"name":"International Journal of Environmental & Agriculture Research","url":"http://www.ijoear.com/"},
    {"name":"International Journal of Environment, Agriculture and Biotechnology","url":"http://ijeab.com/"},
    {"name":"International Journal of Environmental Science and Development","url":"http://www.ijesd.org/"},
    {"name":"International Journal of Farming and Allied Sciences","url":"http://ijfas.com/"},
    {"name":"International Journal of Fauna and Biological Studies","url":"http://www.faunajournal.com/"},
    {"name":"International Journal of Fisheries and Aquatic Studies","url":"http://www.fisheriesjournal.com/"},
    {"name":"International Journal of Food and Nutritional Sciences","url":"http://www.ijfans.com/index.php"},
    {"name":"International Journal of Fundamental & Applied Sciences","url":"http://www.bma.org.in/IJFAS.aspx"},
    {"name":"International Journal of Global Communications","url":"http://ijgc.jalaxy.com.tw/"},
    {"name":"International Journal of Global Ideas","url":"http://journalglobalideas.com/"},
    {"name":"International Journal of Governance","url":"http://www.ijgovernance.com/"},
    {"name":"International Journal of Green and Herbal Chemistry","url":"http://www.ijghc.com/"},
    {"name":"International Journal of Health Research","url":"http://www.ijhr.org/"},
    {"name":"International Journal of Health Research in Modern Integrated Medical Sciences","url":"http://ijhrmims.com/index.php"},
    {"name":"International Journal of Health Sciences and Research","url":"http://www.ijhsr.org/"},
    {"name":"International Journal of Herbal Medicine","url":"http://www.florajournal.com/"},
    {"name":"International Journal of Hindi Research","url":"http://www.hindijournal.com/"},
    {"name":"International Journal of History, Arts and Culture","url":"http://newhistoryjournal.com/"},
    {"name":"International Journal of Home Science","url":"http://www.homesciencejournal.com/board.html"},
    {"name":"International Journal of Human Resource and Procurement","url":"http://www.ijsse.org/index.php?option=com_content&view=article&id=69&Itemid=68"},
    {"name":"International Journal of Human Sciences","url":"http://www.j-humansciences.com/"},
    {"name":"International Journal of Humanities and Cultural Studies","url":"http://www.ijhcs.com/index.php/ijhcs"},
    {"name":"International Journal of Humanities and Social Science Invention","url":"http://www.ijhssi.org/"},
    {"name":"International Journal of Humanities and Social Science Research","url":"http://www.socialresearchjournals.com/"},
    {"name":"The International Journal of Humanities & Social Studies","url":"http://www.theijhss.com/"},
    {"name":"International Journal of Humanities & Social Sciences","url":"http://aajhss.org/index.php/ijhss/index"},
    {"name":"International Journal of Humanities and Religion","url":"http://humanitiesjournal.info/index.php/ijhr/"},
    {"name":"International Journal of Humanities, Engineering and Pharmaceutical Sciences","url":"http://ijheps.org/"},
    {"name":"International Journal of Indian Psychology","url":"http://ijip.in/"},
    {"name":"International Journal of Information and Communication Technology Research","url":"http://esjournals.org/index.php"},
    {"name":"International Journal of Information and Communication Technology Trends","url":"http://www.ijictt.ictt.info/"},
    {"name":"International Journal of Information and Education Technology","url":"http://www.ijiet.org/"},
    {"name":"International Journal of Information Research","url":"http://www.spoars.org/journal/"},
    {"name":"International Journal of Information Research and Review","url":"http://www.ijirr.com/"},
    {"name":"International Journal of Information Sources and Services","url":"http://www.ijss.in/"},
    {"name":"International Journal of Information Technology & Business Management","url":"http://www.jitbm.com/"},
    {"name":"International Journal of Information Technology & Computer Science","url":"http://ijitcs.com/"},
    {"name":"International Journal of Information Technology and Electrical Engineering","url":"http://www.iteejournal.org/"},
    {"name":"International Journal of Informative and Futuristic Research","url":"http://ijifr.com/"},
    {"name":"International Journal of Innovation and Research in Educational Sciences","url":"http://www.ijires.org/"},
    {"name":"International Journal of Innovation in Science and Mathematics","url":"http://www.ijism.org/"},
    {"name":"International Journal of Innovation Research","url":"http://www.journalijir.com/"},
    {"name":"International Journal of Innovations in Engineering and Technology","url":"http://ijiet.com/"},
    {"name":"International Journal of Innovations in Engineering Research and Technology","url":"http://www.ijiert.org/"},
    {"name":"International Journal of Innovation Science and Research","url":"http://www.ijisr.com/"},
    {"name":"International Journal of Innovative and Applied Research","url":"http://journalijiar.com/"},
    {"name":"International Journal of Innovative and Emerging Research in Engineering","url":"http://ijiere.com/"},
    {"name":"International Journal of Innovative Computer Science & Engineering","url":"http://ijicse.in/"},
    {"name":"International Journal of Innovative Concepts in Research","url":"http://www.ijicr.com/"},
    {"name":"International Journal of Innovative Ideas","url":"http://www.publishtopublic.com/"},
    {"name":"International Journal of Innovative Interdisciplinary Research","url":"http://www.auamii.com/journal.html"},
    {"name":"International Journal of Innovative Pharmaceutical Research","url":"http://www.ijipr.com/"},
    {"name":"International Journal of Innovative Research & Advanced Studies","url":"http://www.ijiras.com/"},
    {"name":"International Journal of Innovative Research and Creative Technology","url":"http://www.ijirct.org/index.php"},
    {"name":"International Journal of Innovative Research and Development","url":"http://www.ijird.com/"},
    {"name":"International Journal of Innovative Research and Studies","url":"http://www.ijirs.com/"},
    {"name":"International Journal of Innovative Research in Advanced Engineering","url":"http://ijirae.com/"},
    {"name":"International Journal of Innovative Research in Computer and Communication Engineering","url":"http://www.ijircce.com/"},
    {"name":"International Journal of Innovative Research in Electrical, Electronics, Instrumentation and Control Engineering","url":"http://www.ijireeice.com/"},
    {"name":"International Journal of Innovative Research in Computer Science & Technology","url":"http://www.ijircst.org/"},
    {"name":"International Journal of Innovative Research in Engineering & Multidisciplinary Physical Sciences","url":"http://ijirmps.com/"},
    {"name":"International Journal of Innovative Research in Engineering and Management","url":"http://www.ijirem.org/IJIREM/Home.aspx"},
    {"name":"International Journal of Innovative Research in Medical Science","url":"http://ijirms.in/"},
    {"name":"International Journal of Innovative  Research in Science and Engineering","url":"http://www.ijirse.in/index.html"},
    {"name":"International Journal of Innovative Research in Science, Engineering and Technology","url":"http://www.ijirset.com/"},
    {"name":"International Journal of Innovative Research in Technology","url":"http://www.ijirt.org/index.php"},
    {"name":"International Journal of Innovative Research in Technology & Science","url":"http://www.ijirts.org/"},
    {"name":"International Journal of Innovative Science Engineering and Technology","url":"http://www.ijiset.com/"},
    {"name":"International Journal of Innovative Science and Modern Engineering","url":"http://www.ijisme.org/"},
    {"name":"International Journal of Innovative Studies in Sciences and Engineering Technology","url":"http://ijisset.org/"},
    {"name":"International Journal of Innovative Technologies","url":"http://ijitech.org/index.php"},
    {"name":"International Journal of Innovative Technology and Exploring Engineering","url":"http://www.ijitee.org/"},
    {"name":"International Journal of Innovative Technology and Research","url":"http://www.ijitr.com/"},
    {"name":"International Journal of Innovative Trends in Engineering","url":"http://www.ijite.com/"},
    {"name":"International Journal of Integrated Computer Applications & Research","url":"http://ijicar.net/"},
    {"name":"International Journal of Integrated Medical Research","url":"http://www.ijoimr.com/"},
    {"name":"International Journal of Interdisciplinary and Multidisciplinary Studies","url":"http://www.ijims.com/current.php"},
    {"name":"International Journal of Interdisciplinary Research in Science, Society and Culture","url":"http://ijirssc.in/site/"},
    {"name":"International Journal of Interdisciplinary Scientific Research","url":"http://www.iijsr.org/"},
    {"name":"International Journal of Inventions in Pharmaceutical Sciences","url":"http://www.ijips.net/"},
    {"name":"International Journal of Inventive Engineering and Sciences","url":"http://www.ijies.org/"},
    {"name":"The International Journal of Knowledge, Innovation and Entreprenurship","url":"http://ijkie.org/index.html"},
    {"name":"International Journal of Language and Applied Linguistics","url":"http://www.khatesefid.com/journal/index.html"},
    {"name":"International Journal of Language Learning and Applied Linguistics World","url":"http://www.ijllalw.org/"},
    {"name":"International Journal of Language Sciences","url":"http://www.intjls.com/"},
    {"name":"International Journal of Languages, Literature and Linguistics","url":"http://www.ijlll.org/"},
    {"name":"International Journal of Latest Research in Engineering and Computing","url":"http://www.ijlrec.com/"},
    {"name":"International Journal of Latest Research in Engineering and Technology","url":"http://www.ijlret.com/"},
    {"name":"International Journal of Latest Technology in Engineering, Management & Applied Science","url":"http://www.ijltemas.in/"},
    {"name":"International Journal of Latest Trends in Engineering and Technology","url":"http://www.ijltet.org/"},
    {"name":"International Journal of Latest Trends in Engineering, Science and Technology","url":"http://www.ijltest.org/"},
    {"name":"International Journal of Law and Legal Jurisprudence Studies","url":"http://ijlljs.in/"},
    {"name":"International Journal of Law and Management Studies","url":"http://ijlms.in/"},
    {"name":"International Journal of Law Research","url":"http://www.lawresearchjournal.com/"},
    {"name":"International Journal of Learning, Teaching and Educational Research","url":"http://www.ijlter.org/index.php/ijlter/index"},
    {"name":"International Journal of Liberal Arts & Social Science","url":"http://www.ijlass.org/"},
    {"name":"International Journal of Life science and Pharma Research","url":"http://www.ijlpr.com/"},
    {"name":"International Journal of Life Sciences Biotechnology and Pharma Research","url":"http://www.ijlbpr.com/index.php"},
    {"name":"International Journal of Life-Sciences Scientific Research","url":"http://ijlssr.com/"},
    {"name":"International Journal of Linguistics, Social and Natural Sciences","url":"http://www.ijlsns.com/"},
    {"name":"International Journal of Livestock Research","url":"http://www.scopemed.org/?jid=68/"},
    {"name":"The International Journal of Management","url":"http://www.theijm.com/"},
    {"name":"International Journal of Management, Accounting & Economics (IJMAE)","url":"http://iaajs.com/ijmae/"},
    {"name":"International Journal of Management and Business Studies","url":"http://ijmbs.com/"},
    {"name":"International Journal of Management and Research","url":"http://ijmr.humanjournals.com/"},
    {"name":"International Journal of Management and Social Science Research Review","url":"http://ijmsrr.com/"},
    {"name":"International Journal of Management, Economics and Social Sciences","url":"http://www.ijmess.com/index.php"},
    {"name":"International Journal of Management Research and Business Strategy","url":"http://www.ijmrbs.com/"},
    {"name":"International Journal of Management Research and Review","url":"http://ijmrr.com/"},
    {"name":"International Journal of Management Sciences and Business Research","url":"http://www.ijmsbr.com/"},
    {"name":"International Journal of Mathematical Archive","url":"http://www.ijma.info/index.php/ijma"},
    {"name":"International Journal of Mathematical Research & Science","url":"http://www.ijmrs.org/"},
    {"name":"International Journal of Mathematical Sciences & Applications","url":"http://ijmsa.yolasite.com/"},
    {"name":"International Journal of Mathematics And Computer Research","url":"http://ijmcr.in/index.php"},
    {"name":"International Journal of Mathematics and Soft Computing","url":"http://www.ijmsc.com/index.php/ijmsc/index"},
    {"name":"International Journal of Mathematics and Statistics Invention","url":"http://www.ijmsi.org/index.html"},
    {"name":"International Journal of Mechanical Engineering and Information Technology","url":"http://igmpublication.org/ijmeit/"},
    {"name":"International Journal of Medical and Health Research","url":"http://www.medicalsjournals.com/"},
    {"name":"International Journal Of Medical and Health Sciences","url":"http://www.ijmhs.net/"},
    {"name":"International Journal of Medical Research","url":"http://www.scopemed.org/?jid=76"},
    {"name":"International Journal of Medical Research & Health Sciences","url":"http://ijmrhs.com/"},
    {"name":"International Journal of Medical Research & Review","url":"http://www.ijmrr.in/Default.aspx?pageid=1"},
    {"name":"International Journal of Medical Research and Pharmaceutical Sciences","url":"http://www.ijmrpsjournal.com/"},
    {"name":"International Journal of Medical Research Professionals","url":"http://ijmrp.com/"},
    {"name":"International Journal of Medical Science and Education","url":"http://www.ijmse.com/"},
    {"name":"International Journal of Medical Science and Public Health","url":"http://www.ijmsph.com/"},
    {"name":"International Journal of Medical Science Research and Practice","url":"http://www.ijmsrp.com/"},
    {"name":"International Journal of Medical Sciences and Health Care","url":"http://www.ijmshc.com/"},
    {"name":"International Journal of Medical Students","url":"http://www.ijms.info/ojs/index.php/IJMS/index"},
    {"name":"International Journal of Medicine and Biosciences","url":"http://www.ijmbonline.com/"},
    {"name":"International Journal of Medicobiologial Research","url":"http://www.ijmedres.com/"},
    {"name":"International Journal of MediPharm Research","url":"http://www.medipharmsai.com/"},
    {"name":"International Journal of Modern Chemistry and Applied Science","url":"http://www.ijcasonline.com/"},
    {"name":"International Journal of Modern Engineering Research","url":"http://www.ijmer.com/"},
    {"name":"International Journal of Modern Sciences and Engineering Technology","url":"https://www.ijmset.com/home.html"},
    {"name":"International Journal of Mosquito Research","url":"http://dipterajournal.com/"},
    {"name":"International Journal of Multidisciplinary and Current Research","url":"http://ijmcr.com/"},
    {"name":"International Journal of Multidisciplinary and Scientific Emerging Research","url":"http://www.ijmser.com/"},
    {"name":"International Journal of Multidisciplinary and Scientific Emerging Research","url":"http://www.ijesm.com/"},
    {"name":"International Journal of Multidisciplinary Education and Research","url":"http://www.newresearchjournal.com/"},
    {"name":"International Journal of Multidisciplinary Educational Research","url":"http://www.ijmer.in/"},
    {"name":"International Journal of Multidisciplinary Health Sciences","url":"http://www.ijomhs.org/"},
    {"name":"International Journal of Multidisciplinary Research and Development","url":"http://allsubjectjournal.com/"},
    {"name":"International Journal of Multidisciplinary Research and Information","url":"http://www.journalijmri.com/"},
    {"name":"International Journal of Multidisciplinary Research and Modern Education","url":"http://rdmodernresearch.org/"},
    {"name":"International Journal Of Multidisciplinary Research and Review","url":"http://journalmrr.com/"},
    {"name":"International Journal of Multidisciplinary Research Review","url":"http://www.ijmdrr.com/"},
    {"name":"International Journal of Multidisciplinary Sciences and Engineering","url":"http://www.ijmse.org/"},
    {"name":"International Journal of Nanofluids and Nanoparticles","url":"http://international%20journal%20of%20nanofluids%20and%20nanoparticles/"},
    {"name":"International Journal of Network Security","url":"http://ijns.jalaxy.com.tw/"},
    {"name":"International Journal of Network Service and Technologies","url":"http://ijnst.jalaxy.com.tw/"},
    {"name":"International Journal of New Innovations in Engineering and Technology","url":"http://www.ijniet.org/"},
    {"name":"International Journal of New Technologies in Science and Engineering","url":"http://www.ijntse.com/"},
    {"name":"International Journal of New Technology and Research","url":"https://www.ijntr.org/"},
    {"name":"International Journal of New Trends in Arts, Sports & Science Education","url":"http://www.ijtase.net/ojs/index.php/IJTASE"},
    {"name":"International Journal of Novel Trends in Pharmaceutical Sciences","url":"http://www.ijntps.org/"},
    {"name":"International Journal of Nursing","url":"http://www.ijnonline.com/"},
    {"name":"International Journal of Obstetrics and Gynaecology Research","url":"http://www.ijogr.com/"},
    {"name":"International Journal of Oral Health and Medical Research","url":"http://ijohmr.com/"},
    {"name":"International Journal of Oncology Science","url":"http://oncologyscience.com/"},
    {"name":"International Journal of Orthopaedics Sciences ","url":"http://www.orthopaper.com/"},
    {"name":"International Journal of Pediatrics","url":"http://ijp.mums.ac.ir/"},
    {"name":"International Journal of Pharma and Bio Sciences","url":"http://www.ijpbs.net/index.html"},
    {"name":"International Journal of Pharma Professional’s Research","url":"http://www.ijppronline.in/"},
    {"name":"International Journal of Pharmaceutical & Research Science","url":"http://www.ijprsjournal.com/index.html"},
    {"name":"International Journal of Pharmaceutical and Biological Science Archive","url":"http://www.ijpba.in/index.php/ijpba"},
    {"name":"International Journal of Pharmaceutical and Biomedical Research","url":"http://www.pharmscidirect.com/"},
    {"name":"International Journal of Pharmaceutical and Clinical Research","url":"http://ijpcr.com/"},
    {"name":"International Journal of Pharmaceutical and Phytopharmacological Research","url":"http://www.eijppr.com/"},
    {"name":"International Journal of Pharmaceutical Quality Assurance and Pharmaceutical Analysis","url":"http://ijpqa.com/"},
    {"name":"International Journal of Pharmaceutical Research and Applications","url":"http://www.ijprajournal.com/index.html"},
    {"name":"International Journal of Pharmaceutical Research and Bioscience","url":"http://www.ijprbs.com/"},
    {"name":"International Journal of Pharmaceutical Research and Development","url":"http://www.ijprd.com/"},
    {"name":"International Journal of Pharmaceutical Science Invention","url":"http://www.ijpsi.org/"},
    {"name":"International Journal of Pharmaceutical Sciences and Business Management","url":"http://www.ijpsbm.com/"},
    {"name":"International Journal of Pharmaceutical Sciences and Drug Research","url":"http://www.ijpsdr.com/index.htm"},
    {"name":"International Journal of Pharmaceutical Sciences and Research","url":"http://www.ijpsr.com/index.html"},
    {"name":"International Journal of Pharmaceutical Sciences Letters","url":"http://ijpsl.com/"},
    {"name":"International Journal of Pharmaceutical Sciences Review and Research","url":"http://www.globalresearchonline.net/"},
    {"name":"International Journal of Pharmaceuticals and Health Care Research","url":"http://www.ijphr.com/"},
    {"name":"International Journal of Pharmacognosy","url":"http://www.ijpjournal.com/"},
    {"name":"International Journal of Pharmacognosy and Phytochemical Research","url":"http://ijppr.com/"},
    {"name":"International Journal of Pharmacology and Physiology","url":"http://my.ejmanager.com/ijpp/"},
    {"name":"International Journal of Pharmacy","url":"http://www.pharmascholars.com/"},
    {"name":"International Journal of Pharmacy & Industrial Research","url":"http://www.ijpir.com/%20"},
    {"name":"International Journal of Pharmacy and Pharmaceutical Research","url":"http://ijppr.humanjournals.com/"},
    {"name":"International Journal of Pharmacy and Pharmaceutical Sciences","url":"http://www.ijppsjournal.com/"},
    {"name":"International Journal of Pharmacy and Technology","url":"http://www.ijptonline.com/"},
    {"name":"International Journal of Physical Education, Sports and Health","url":"http://www.kheljournal.com/"},
    {"name":"International Journal of Physiotherapy","url":"https://www.ijphy.org/"},
    {"name":"International Journal of Plant, Animal and Environmental Sciences","url":"http://www.ijpaes.com/"},
    {"name":"International Journal of Power Electronics Engineering","url":"http://www.ijpee.com/index.php/ijpee"},
    {"name":"International Journal of Precious Engineering Research and Applications","url":"http://www.ijpera.com/"},
    {"name":"International Journal of Printing, Packaging & Allied Sciences","url":"http://ijppas.com/index.php"},
    {"name":"International Journal of Psycho-Educational Sciences","url":"http://www.arees.org/journal/about-journal"},
    {"name":"International Journal of Psychology and Behavioral Research","url":"http://ijpbrjournal.com/"},
    {"name":"International Journal of Pure & Applied Bioscience","url":"http://www.ijpab.com/"},
    {"name":"International Journal of Pure and Applied Zoology","url":"http://www.ijpaz.com/index.php/ijpaz"},
    {"name":"International Journal of Recent Advances in Multidisciplinary Research","url":"http://www.ijramr.com/"},
    {"name":"International Journal of Recent Development in Engineering and Technology","url":"http://www.ijrdet.com/index.php"},
    {"name":"International Journal of Recent Engineering Research and Development","url":"http://www.ijrerd.com/"},
    {"name":"International Journal of Recent Research and Applied Studies","url":"http://www.ijrras.com/"},
    {"name":"International Journal of Recent Research in Science, Engineering and Technology ","url":"http://www.ijrrset.com/"},
    {"name":"International Journal of Recent Scientific Research","url":"http://www.recentscientific.com/"},
    {"name":"International Journal of Recent Technology and Engineering","url":"http://www.ijrte.org/"},
    {"name":"International Journal of Recent Trends in Electrical & Electronics Engineering","url":"https://scholarlyoa.com/individual-journals/International%20Journal%20of%20Recent%20trends%20in%20Electrical%20&%20Electronics%20Engineering%20(IJRTE)"},
    {"name":"International Journal of Recent Trends in Engineering & Research","url":"http://www.ijrter.com/"},
    {"name":"International Journal of Remote Sensing and Geoscience","url":"http://www.ijrsg.com/"},
    {"name":"International Journal of Renewable Energy Research","url":"http://www.ijrer.org/ijrer/index.php/ijrer/index"},
    {"name":"International Journal of Research and Current Development","url":"http://www.journalijrcd.com/"},
    {"name":"International Journal of Research and Development in Pharmacy & Life Sciences","url":"http://www.ijrdpl.com/"},
    {"name":"International Journal of Research and Development in Technology & Management Sciences Kailash","url":"http://journal.rtmonline.in/"},
    {"name":"International Journal of Research and Engineering","url":"http://ijre.org/"},
    {"name":"International Journal of Research and Innovation in Computer Engineering","url":"http://www.ijrice.com/"},
    {"name":"International Journal of Research and Science Publication","url":"http://www.ijrsp.org/"},
    {"name":"International Journal of Research Culture Society","url":"http://ijrcs.in/"},
    {"name":"International Journal of Research Development ","url":"http://forefrontcorpo.wix.com/ijord"},
    {"name":"International Journal of Research GRANTHAALAYAH","url":"http://granthaalayah.com/index.html"},
    {"name":"International Journal of Research in Advanced Engineering and Technology","url":"http://www.engineeringresearchjournal.com/"},
    {"name":"International Journal of Research In Advanced Engineering Technologies","url":"http://www.ijraet.com/"},
    {"name":"International Journal of Research in Aeronautical and Mechanical Engineering","url":"http://www.ijrame.com/"},
    {"name":"International Journal of Research in Agricultural Sciences","url":"http://ijras.org/"},
    {"name":"International Journal of Research in Agriculture and Forestry","url":"http://www.ijraf.org/"},
    {"name":"International Journal of Research in Ayurveda and Pharmacy","url":"http://www.ijrap.net/"},
    {"name":"International Journal of Research in Business Studies and Management","url":"http://www.ijrbsm.org/"},
    {"name":"International Journal of Research in Computer and Communication Technology","url":"http://www.ijrcct.org/index.php/ojs"},
    {"name":"International Journal of Research in Computer Engineering & Electronics","url":"http://www.ijrcee.org/index.php/ijrcee"},
    {"name":"International Journal of Research in Computer Science","url":"http://www.ijorcs.org/"},
    {"name":"International Journal of Research in Computer Technology","url":"http://www.opusinfo.in/ijrct/index.php/ijrct/information/readers"},
    {"name":"International Journal of Research in Education and Science","url":"http://www.ijres.net/"},
    {"name":"International Journal of Research in Education and Social Science","url":"http://www.ijress.com/"},
    {"name":"International Journal of Research in Electronics & Communication Technology","url":"http://ijrect.com/"},
    {"name":"International Journal of Research in Engineering and Advanced Technology","url":"http://www.ijreat.org/"},
    {"name":"International Journal of Research in Engineering and Science","url":"http://www.ijres.org/index.html"},
    {"name":"nternational Journal of Research in Engineering and Science","url":"http://www.mgijournal.com/"},
    {"name":"International Journal of Research in Engineering and Technology","url":"http://ijret.org/"},
    {"name":"International Journal of Research in Humanities and Social Sciences","url":"http://www.ijrhss.org/"},
    {"name":"International Journal of Research in Library Science","url":"http://ijrls.in/"},
    {"name":"International Journal of Research in Management & Business Studies","url":"http://ijrmbs.com/"},
    {"name":"International Journal of Research in Mechanical Engineering and Technology","url":"http://www.ijrmet.com/"},
    {"name":"International Journal of Research in Medical & Applied Sciences","url":"http://ijrmas.org/"},
    {"name":"International Journal of Research in Medical and Dental Sciences","url":"https://edas.info/web/ijrmds/index.html"},
    {"name":"International Journal of Research in Pharmacy and Biosciences","url":"http://www.ijrpb.org/"},
    {"name":"International Journal of Research in Pharmacy and Science","url":"http://www.ijrpsonline.com/index.php"},
    {"name":"International Journal of Research in Science & Engineering","url":"http://ijrise.org/home"},
    {"name":"International Journal of Research in Science & Technology","url":"http://www.ijrst.com/index.php"},
    {"name":"International Journal of Research in Wireless Systems","url":"http://www.ijrws.org/index.php/ijrws"},
    {"name":"International Journal of Research Methodology","url":"http://ijrm.humanjournals.com/"},
    {"name":"International Journal of Research Publications in Engineering and Technology ","url":"http://www.ijrpet.org/"},
    {"name":"International Journal of Research Science and Management","url":"http://www.ijrsm.com/"},
    {"name":"International Journal of Review in Applied and Social Sciences","url":"http://www.ijrass.com/"},
    {"name":"International Journal of Review in Life Sciences","url":"https://pharmascope.org/ijrls/"},
    {"name":"International Journal of Review in Life Sciences","url":"http://www.ijrls.com/"},
    {"name":"International Journal of Reviews in Computing","url":"http://www.ijric.org/index.php"},
    {"name":"International Journal of Reviews, Surveys and Research ","url":"http://www.ijrsr.com/"},
    {"name":"International Journal of Sanskrit Research","url":"http://www.sanskritjournal.com/"},
    {"name":"International Journal of Science and Advanced Technology","url":"http://www.ijsat.com/"},
    {"name":"International Journal of Science & Engineering Development Research","url":"http://www.ijsdr.org/index.php"},
    {"name":"International Journal of Science and Engineering Applications","url":"http://www.ijsea.com/index"},
    {"name":"International Journal of Science and Engineering Investigations","url":"http://www.ijsei.com/"},
    {"name":"The International Journal of Science & Technoledge","url":"http://www.theijst.com/"},
    {"name":"International Journal of Science and Research","url":"http://www.ijsr.net/"},
    {"name":"International Journal of Science and Research Methodology","url":"http://ijsrm.humanjournals.com/"},
    {"name":"International Journal of Science and Technology","url":"http://ejournalofsciences.org/"},
    {"name":"International Journal of Science & Technology","url":"http://www.journalofsciences-technology.org/"},
    {"name":"International Journal of Science Commerce and Humanities","url":"http://www.ijsch.com/journaluk/Publisher-69"},
    {"name":"International Journal of Science Culture and Sport","url":"http://www.iscsjournal.com/Anasayfa.Aspx"},
    {"name":"International Journal of Science Engineering and Advance Technology","url":"http://www.ijseat.com/index.php/ijseat"},
    {"name":"International Journal of Science, Engineering and Technology Research ","url":"http://ijsetr.org/"},
    {"name":"International Journal of Science Environment and Technology","url":"http://www.ijset.net/"},
    {"name":"International Journal of Science Innovations and Discoveries","url":"http://www.ijsidonline.info/"},
    {"name":"International Journal of Science Technology and Engineering","url":"http://www.ijste.org/"},
    {"name":"International Journal Of Science Technology & Management","url":"http://www.ijstm.com/"},
    {"name":"International Journal of Sciences","url":"http://www.ijsciences.com/"},
    {"name":"International Journal of Sciences and Applied Research","url":"http://www.ijsar.in/"},
    {"name":"International Journal of Scientific & Technology Research","url":"http://www.ijstr.org/"},
    {"name":"International Journal of Scientific and Engineering Research","url":"http://www.ijser.org/"},
    {"name":"International Journal of Scientific and Research","url":"http://journalijsr.com/"},
    {"name":"International Journal of Scientific and Research Publications","url":"http://www.ijsrp.org/"},
    {"name":"International Journal of Scientific and Technical Advancements","url":"http://www.ijsta.com/"},
    {"name":"International Journal of Scientific Engineering and Applied Science","url":"http://ijseas.com/"},
    {"name":"International Journal of Scientific Engineering and Technology","url":"http://ijset.com/ijset/"},
    {"name":"International Journal of Scientific Engineering and Technology Research","url":"http://ijsetr.com/"},
    {"name":"International Journal of Scientific Progress & Research","url":"http://www.ijspr.com/index.php"},
    {"name":"International Journal of Scientific Research","url":"http://www.ijscr.com/index.html"},
    {"name":"International Journal of Scientific Research","url":"http://worldwidejournals.com/ijsr/"},
    {"name":"International Journal of Scientific Research & Management Studies","url":"http://www.ijsrms.com/home/index.html"},
    {"name":"International Journal of Scientific Research and Application","url":"http://ijsra.com/"},
    {"name":"International Journal Of Scientific Research And Education","url":"http://ijsae.in/"},
    {"name":"International Journal of Scientific Research and Engineering Trends","url":"http://www.ijsret.com/"},
    {"name":"International Journal of Scientific Research and Innovative Technology","url":"http://www.ijsrit.com/"},
    {"name":"International Journal of Scientific Research and Management","url":"http://www.ijsrm.in/"},
    {"name":"International Journal of Scientific Research in Education","url":"http://www.ijsre.com/"},
    {"name":"International Journal of Scientific Research in Information Systems and Engineering","url":"http://www.ijsrise.com/index.php/ijsrise"},
    {"name":"International Journal of Scientific Study","url":"http://www.ijss-sn.com/"},
    {"name":"International Journal of Signal Processing Systems","url":"http://international%20journal%20of%20signal%20processing%20systems%20%28ijsps%29/"},
    {"name":"The International Journal of Social and Applied Sciences","url":"http://ijsas.webs.com/indexing"},
    {"name":"International Journal of Social Science & Economic Research","url":"http://ijsser.org/index.php"},
    {"name":"International Journal of Social Science and Humanity","url":"http://www.ijssh.org/"},
    {"name":"The International Journal of Social Sciences","url":"http://www.tijoss.com/index.html"},
    {"name":"International Journal of Social Sciences and Education","url":"http://www.ijsse.com/"},
    {"name":"International Journal of Social Sciences and Entrepreneurship","url":"http://www.ijsse.org/"},
    {"name":"International Journal of Society and Technology","url":"http://jst.vlsiengineers.in/ojs1/index.php/jst"},
    {"name":"International Journal of Society, Culture & Language","url":"http://ijscl.net/"},
    {"name":"International Journal of Soft Computing and Engineering","url":"http://www.ijsce.org/"},
    {"name":"International Journal of Sport Studies","url":"http://ijssjournal.com/"},
    {"name":"OIDA International Journal of Sustainable Development","url":"http://www.ontariointernational.org/Publications.html"},
    {"name":"International Journal of Teacher Educational Research","url":"http://ijter.com/"},
    {"name":"International Journal of Technical Research and Applications","url":"http://www.ijtra.com/index.php"},
    {"name":"International Journal of Technical Research and Innovation","url":"http://www.ijtri.org/"},
    {"name":"International Journal of Technology and Computing","url":"http://www.ijtc.org/ijtc.html"},
    {"name":"International Journal of Technology, Education, and Resource Management","url":"http://www.ijterm.org/index.php/IJTERM/index"},
    {"name":"International Journal of Technology Enhancements and Emerging Engineering Research","url":"http://www.ijteee.org/"},
    {"name":"International Journal of Technology, Management and Humanities","url":"http://www.ijtmh.com/"},
    {"name":"International Journal of Therapeutic Applications","url":"http://journal.npaa.in/"},
    {"name":"International Journal of Toxicological and Pharmacological Research","url":"http://ijtpr.com/"},
    {"name":"International Journal of Trend in Research and Development","url":"http://www.ijtrd.com/"},
    {"name":"International Journal of Trends in Economics Management and Technology ","url":"http://www.ijtemt.org/"},
    {"name":"International Journal of Universal Pharmacy and Bio Sciences","url":"http://www.ijupbs.com/Home.aspx"},
    {"name":"International Journal of Veterinary Science","url":"http://www.ijvets.com/"},
    {"name":"International Journal of Wind and Renewable Energy","url":"http://www.ijwre.org/index.php"},
    {"name":"International Journal of Wisdom Based Computing","url":"http://www.wisdombasedcomputing.com/index.html"},
    {"name":"International Journal of World Research","url":"http://apjor.com/ijrp/"},
    {"name":"International Journal on Recent and Innovation Trends in Computing and Communication","url":"http://ijritcc.org/"},
    {"name":"International Journal on Recent Technologies in Mechanical and Electrical Engineering","url":"http://www.ijrmee.org/"},
    {"name":"International Journal on Recent Trends in Life Science and Mathematics","url":"http://www.ijlsm.org/"},
    {"name":"International Journal on Research Methodologies in Physics and Chemistry","url":"http://www.ijrpc.org/"},
    {"name":"International Journal Online of Humanities","url":"http://ijohmn.com/"},
    {"name":"International Letters of Chemistry, Physics and Astronomy","url":"http://www.ilcpa.pl/"},
    {"name":"International Letters of Natural Sciences","url":"http://www.ilns.pl/"},
    {"name":"International Letters of Social and Humanistic Sciences","url":"http://www.ilshs.pl/"},
    {"name":"International Multidisciplinary Research Journal","url":"http://irjs.info/index.php/irjs/"},
    {"name":"International Multispeciality Journal of Health","url":"http://imjhealth.org/"},
    {"name":"International Online Journal of Primary Education","url":"http://www.iojpe.org/ojs/index.php/IOJPE"},
    {"name":"International Proceedings of Chemical, Biological and Environmental Engineering","url":"http://www.ipcbee.com/"},
    {"name":"International Refereed Journal Of Architecture and Design","url":"http://www.mtddergisi.com/eng/"},
    {"name":"International Refereed Journal of Engineering and Science","url":"http://www.irjes.com/"},
    {"name":"International Research and Publications in Medical Sciences","url":"http://www.irpms.com/"},
    {"name":"International Research Journal of Advanced Engineering in Frontiers","url":"http://irjef.net/"},
    {"name":"International Research Journal of Applied and Basic Sciences","url":"http://www.irjabs.com/en/"},
    {"name":"International Research Journal of Applied Finance","url":"https://irjaf.com/"},
    {"name":"International Research Journal of Engineering and Technology","url":"https://www.irjet.net/"},
    {"name":"International Research Journal of Engineering and Technology","url":"https://irjet.org/"},
    {"name":"International Research Journal of Finance and Economics","url":"http://www.internationalresearchjournaloffinanceandeconomics.com/"},
    {"name":"International Research Journal of Management Sciences","url":"http://irjmsjournal.com/"},
    {"name":"International Research Journal of Multidisciplinary Science & Technology","url":"http://www.irjmrs.com/"},
    {"name":"International Research Journal of Pharmaceutical and Applied Sciences","url":"http://www.irjpas.com/"},
    {"name":"International Research Journal of Pharmaceutical Sciences","url":"http://irjps.info/index.php/IRJPS/index"},
    {"name":"International Research Journal of Pharmacy","url":"http://www.irjponline.com/"},
    {"name":"International Research Journal of Sustainable Science & Engineering","url":"http://irjse.com/"},
    {"name":"International Researchers","url":"http://iresearcher.org/index.html"},
    {"name":"International Review of Basic and Applied Sciences","url":"http://irbas.academyirmbr.com/journalmain.php"},
    {"name":"International Review of Management and Business Research","url":"http://www.irmbrjournal.com/index.php"},
    {"name":"International Review of Social Sciences and Humanities","url":"http://www.irssh.com/"},
    {"name":"International Science and Investigation Journal","url":"http://isijournal.info/journals/index.php/ISIJ"},
    {"name":"International Scientific Investigations","url":"http://isi-journal.org/"},
    {"name":"International Scientific Journal Theoretical & Applied Science","url":"http://www.t-science.org/"},
    {"name":"International Scientific Research Journal","url":"http://www.irj.science/"},
    {"name":"International Technical Sciences Journal","url":"http://itsj.org/"},
    {"name":"Invention Journal of Research Technology in Engineering & Management","url":"http://www.ijrtem.com/"},
    {"name":"IOSR Journal of Engineering","url":"http://www.iosrjen.org/"},
    {"name":"Italian Journal of Science & Engineering","url":"http://ijournalse.org/index.php/IJSE"},
    {"name":"JACOTECH","url":"http://www.jacotech.org/"},
    {"name":"Jai Maa Saraswati Gyandayini","url":"http://www.jmsjournals.in/"},
    {"name":"Journal of Accounting, Ethics & Public Policy","url":"http://www.jaepp.org/"},
    {"name":"Journal de Afrikana","url":"http://www.jdeafrikana.com/home.html"},
    {"name":"Journal der Pharmazie Forschung","url":"http://www.rapsr.com/"},
    {"name":"Journal for Research","url":"http://www.journal4research.org/index.php"},
    {"name":"Journal Francophone de Cas Clinique","url":"http://jfcc.fr/"},
    {"name":"Journal of Advanced Agricultural Technologies","url":"http://www.joaat.com/"},
    {"name":"Journal of Advanced Studies in Agricultural, Biological and Environmental Sciences","url":"http://jabe.in/"},
    {"name":"Journal of Advances in Civil Engineering","url":"http://djcivil.org/"},
    {"name":"Journal of Advances in Electronics and Communication Engineering","url":"http://www.djjames.org/"},
    {"name":"Journal of Advances in Information Technology","url":"http://www.jait.us/"},
    {"name":"Journal of Advances in Internal Medicine","url":"http://www.aimjournal.org/index.php"},
    {"name":"Journal of Advances in Science and Technology","url":"http://www.jadbm.com/"},
    {"name":"Journal of Advances in Social Science and Humanities","url":"http://www.jassh.in/index.php/jassh"},
    {"name":"Journal of Agriculture, Forestry & Environmental Sciences","url":"http://jafes.eduved.org/"},
    {"name":"Journal of American Academic Research","url":"http://www.american-journals.com/"},
    {"name":"The Journal of American Academy of Business, Cambridge","url":"http://www.jaabc.com/journal.htm"},
    {"name":"The Journal of American Business Review, Cambridge","url":"http://www.jaabc.com/jabrc.html"},
    {"name":"Journal of American Physicians and Surgeons","url":"http://www.jpands.org/"},
    {"name":"Journal of Anaesthesia and Critical Care Case Reports","url":"http://jaccr.com/"},
    {"name":"Journal of Analytical Research","url":"http://www.researchanalytica.com/index.php"},
    {"name":"Journal of Animal and Plant Sciences","url":"http://www.m.elewa.org/JAPS/"},
    {"name":"Journal of Animal and Poultry Sciences","url":"http://www.japsc.com/"},
    {"name":"Journal of Applicable Chemistry","url":"http://www.joac.info/"},
    {"name":"Journal of Applied Biology & Biotechnology ","url":"http://jabonline.in/"},
    {"name":"Journal of Applied Economics and Business","url":"http://www.aebjournal.org/index.php"},
    {"name":"Journal of Applied Linguistics and Language Research","url":"http://www.jallr.com/index.php/JALLR"},
    {"name":"Journal of Applied Linguistics (Dubai)","url":"http://www.iaajs.com/jal/"},
    {"name":"Journal of Applied Management and Investments","url":"http://www.jami.org.ua/"},
    {"name":"Journal of Applied Pharmacy","url":"http://japharmacy.com/master/Default.aspx"},
    {"name":"Journal of Applied Pharmaceutical Science","url":"http://www.japsonline.com/index.php"},
    {"name":"Journal of Arts and Humanities","url":"http://theartsjournal.org/index.php/site"},
    {"name":"Journal of Automation and Control Engineering","url":"http://www.joace.org/"},
    {"name":"Journal of Ayurveda and Integrated Medical Sciences","url":"http://www.jaims.in/index.php/jaims"},
    {"name":"Journal of Ayurveda and Holistic Medicine","url":"http://www.jahm.in/"},
    {"name":"Journal of Basic and Environmental Sciences","url":"http://jbesci.org/"},
    {"name":"Journal of Behavioral Health","url":"http://www.scopemed.org/?jid=57"},
    {"name":"Journal of Behavioral Sciences in Asia","url":"http://www.joursa.com/"},
    {"name":"Journal of Bio Innovation","url":"http://www.jbino.com/index.htm"},
    {"name":"Journal of Biological and Scientific Opinion","url":"http://www.jbsoweb.com/"},
    {"name":"Journal of Biological Sciences and Medicine","url":"http://www.jbscim.com/"},
    {"name":"Journal of Biomedical and Pharmaceutical Research","url":"http://jbpr.in/index.php/jbpr"},
    {"name":"Journal of Bioscience and Technology","url":"http://www.jbstonline.com/"},
    {"name":"Journal of Biospectracal","url":"http://journalofbiospectracal.com/"},
    {"name":"Journal of Business Management and Applied Economics","url":"http://jbmae.scientificpapers.org/"},
    {"name":"Journal of Business Management and Economic Studies","url":"http://www.jbmes.com/index.html"},
    {"name":"Journal of Business Studies Quarterly","url":"http://jbsq.org/"},
    {"name":"Journal of Chemical and Pharmaceutical Research","url":"http://jocpr.com/"},
    {"name":"Journal of Chemical and Pharmaceutical Sciences","url":"http://jchps.com/"},
    {"name":"Journal of Chemical, Biological and Physical Sciences","url":"http://www.jcbsc.org/index.php"},
    {"name":"Journal of Clean Energy Technologies","url":"http://www.jocet.org/"},
    {"name":"Journal of Clinical and Analytical Medicine","url":"http://www.jcam.com.tr/en/index.php"},
    {"name":"Journal of Communications Technology, Electronics and Computer Science","url":"https://www.jctecs.com/index.php/com"},
    {"name":"Journal of Computers","url":"http://www.jcomputers.us/"},
    {"name":"Journal of Computing","url":"http://www.journalofcomputing.org/"},
    {"name":"Journal of Computing Technologies","url":"http://jctjournals.com/"},
    {"name":"Journal of Contemporary Issues in Business Research","url":"http://jcibr.webs.com/"},
    {"name":"Journal of Contemporary Management Sciences","url":"http://jmsciences.com/Presentation/Client/Home.aspx"},
    {"name":"Journal of Contemporary Medical Education","url":"http://www.scopemed.org/?jid=63"},
    {"name":"Journal of Coastal Life Medicine","url":"http://jclmm.com/"},
    {"name":"Journal of Cosmology","url":"http://journalofcosmology.com/"},
    {"name":"Journal of Current Pharma Research","url":"http://www.cpronline.in/"},
    {"name":"Journal of Current Research in Science","url":"http://www.jcrs010.com/"},
    {"name":"Journal of Current Trends in Big Data Analytics","url":"http://jctbda.ijkie.org/index.html"},
    {"name":"Journal of Drug Discovery and Therapeutics","url":"http://jddt.in/index.php/jddt"},
    {"name":"Journal of Economics and Banking","url":"http://journals.ke-i.org/index.php/econ"},
    {"name":"Journal of Economics and Engineering","url":"http://www.eu-print.org/iqt.php"},
    {"name":"Journal of Economics and Political Economy","url":"http://www.ijepe.com/index.php/JEPE"},
    {"name":"Journal of Economics, Business and Management","url":"http://joebm.com/"},
    {"name":"Journal of Education and Social Science","url":"http://jesoc.com/"},
    {"name":"Journal of Education and Sociology","url":"http://www.eu-print.org/teh.php"},
    {"name":"Journal of ELT and Applied Linguistics","url":"http://www.jeltal.com/"},
    {"name":"Journal of Electrical Engineering","url":"http://www.jee.ro/index.php"},
    {"name":"Journal of Electrical Engineering and Science","url":"http://djeee.org/"},
    {"name":"Journal of Emerging Trends in Computing and Information Sciences","url":"http://cisjournal.org/"},
    {"name":"Journal of English Language and Literature","url":"http://joell.in/"},
    {"name":"Journal of Engineering and Applied Mathematics","url":"http://djmaths.org/"},
    {"name":"Journal of Engineering Innovation & Research","url":"http://jeir.org/"},
    {"name":"Journal of Entomology and Zoology Studies ","url":"http://entomoljournal.com/"},
    {"name":"Journal of Environment and Life Sciences","url":"http://www.imedpharm.com/journals/index.php/JELS/index"},
    {"name":"Journal of Environmental and Occupational Science","url":"http://www.jenvos.com/"},
    {"name":"Journal of Environmental Biology","url":"http://www.jeb.co.in/"},
    {"name":"Journal of Environmental Hydrology","url":"http://www.hydroweb.com/journal-hydrology.html"},
    {"name":"Journal of Environmental Nanotechnology","url":"http://www.nanoient.org/journal-of-environmental-nanotechnology.php"},
    {"name":"Journal of Environmental Research and Development","url":"http://www.jerad.org/"},
    {"name":"Journal of Environmental Science, Computer Science and Engineering & Technology","url":"http://www.jecet.org/"},
    {"name":"Journal of Evidence Based Medicine and Healthcare","url":"http://www.jebmh.com/index.php"},
    {"name":"Journal of Evolution of Research in Dermatology and Venerology","url":"http://www.jerdv.com/"},
    {"name":"Journal of Evolution of Research in Human Physiology","url":"http://www.jerhp.com/"},
    {"name":"Journal of Evolution of Research in Medical Microbiology","url":"http://jermm.com/index.php"},
    {"name":"Journal of Evolution of Research in Medical Pharmacology","url":"http://www.jermp.com/index.php"},
    {"name":"Journal of Evolution of Research in Paediatrics and Neonatology","url":"http://www.jerpn.com/"},
    {"name":"Journal of Excellence in Computer Science and Engineering","url":"http://djcse.in/"},
    {"name":"Journal of Experimental Biology and Agricultural Sciences","url":"http://www.jebas.org/"},
    {"name":"Journal of Experimental Sciences","url":"http://jexpsciences.com/"},
    {"name":"Journal of Financial Education","url":"http://jfedweb.org/jfedpage.html"},
    {"name":"Journal of Food, Agriculture and Environment","url":"http://world-food.net/products/scientific-journal-jfae/"},
    {"name":"Journal of Fundamental and Applied Sciences","url":"http://journal%20of%20fundamental%20and%20applied%20sciences/"},
    {"name":"Journal of Genetic and Environmental Resources Conservation","url":"http://www.jgerc.com/"},
    {"name":"Journal of Geotechnical and Transportation Engineering","url":"http://jgtte.com/"},
    {"name":"Journal of Global Biosciences","url":"http://www.mutagens.co.in/"},
    {"name":"Journal of Global Business Management","url":"http://www.jgbm.org/"},
    {"name":"Journal of Global Innovations in Agricultural and Social Sciences","url":"http://jgiass.com/"},
    {"name":"Journal of Global Research in Computer Science","url":"http://www.jgrcs.info/index.php/jgrcs"},
    {"name":"Journal of Health Economics and Outcomes Research","url":"http://www.jheor.org/"},
    {"name":"Journal of Health, Sport and Tourism","url":"http://www.eu-print.org/tur.php"},
    {"name":"Journal of HerbMed Pharmacology","url":"http://www.herbmedpharmacol.com/"},
    {"name":"Journal of Human Resource and Adult Learning","url":"http://www.hraljournal.com/"},
    {"name":"Journal of Humanities and Cultural Studies R&D","url":"http://jrsdjournal.wix.com/humanities-cultural"},
    {"name":"Journal of Hydrology and Environment Research","url":"http://jher.org/"},
    {"name":"JCR","url":"http://mjl.clarivate.com/cgi-bin/jrnlst/jlresults.cgi?PC=MASTER&ISSN=1312-773X"},
    {"name":"Journal of Industrial and Intelligent Information","url":"http://www.jiii.org/"},
    {"name":"Journal of Information Management","url":"http://splpjim.org/"},
    {"name":"Journal of Innovations in Applied Pharmaceutical Science","url":"http://www.jiapsonline.com/"},
    {"name":"Journal of Innovations in Pharmaceuticals and Biological Sciences","url":"http://www.jipbs.com/"},
    {"name":"Journal of Innovative Biology","url":"http://jibresearch.com/"},
    {"name":"Journal of Innovative Engineering","url":"http://www.jieonline.org/"},
    {"name":"Journal of Innovative Research and Solutions","url":"http://www.jirasindia.com/"},
    {"name":"Journal of Intercultural Ethnopharmacology","url":"http://www.jicep.com/"},
    {"name":"Journal of Interdisciplinary Histopathology","url":"http://www.scopemed.org/?jid=60"},
    {"name":"Journal of International Academic Research for Multidisciplinary","url":"http://www.jiarm.com/home.html"},
    {"name":"Journal of International Anatolia Sport Science","url":"http://www.jiasscience.com/Anasayfa.Aspx"},
    {"name":"Journal of International Environmental Application & Science","url":"http://www.jieas.com/index.html"},
    {"name":"Journal of International Management Studies","url":"http://www.jimsjournal.org/index.html"},
    {"name":"Journal of Internet Banking and Commerce","url":"http://www.icommercecentral.com/"},
    {"name":"Journal of Investigational Biochemistry","url":"http://www.scopemed.org/?jid=61"},
    {"name":"Journal of Knowledge Management, Economics and Information Technology","url":"http://www.scientificpapers.org/"},
    {"name":"Journal of Language and Literature","url":"http://www.eu-print.org/filo.php"},
    {"name":"Journal of Law and Ethics","url":"http://www.eu-print.org/etika.php"},
    {"name":"Journal of Materials and Environmental Science","url":"http://www.jmaterenvironsci.com/"},
    {"name":"Journal of Mathematics and Computer Science","url":"http://www.tjmcs.com/index.php"},
    {"name":"Journal of Mathematics and Technology","url":"http://www.eu-print.org/riy.php"},
    {"name":"Journal of Media & Mass Communication","url":"http://www.jmmc.org/"},
    {"name":"Journal of Media Critiques","url":"http://www.mediacritiques.net/index.php/jmc"},
    {"name":"Journal of Medical Science and Technology","url":"http://www.jmst.webs.com/"},
    {"name":"Journal of Molecular Pathophysiology","url":"http://www.scopemed.org/?jid=66"},
    {"name":"Journal of Nano Innovation","url":"http://nanoinnovationjournal.com/"},
    {"name":"Journal of Natural Products","url":"http://journalofnaturalproducts.com/"},
    {"name":"Journal of Novel Applied Sciences","url":"http://jnasci.org/"},
    {"name":"Journal of Medical Biomedical and Applied Sciences","url":"http://www.jmbm.in/index.php/jmbm"},
    {"name":"Journal of Medical Pharmaceutical and Allied Sciences","url":"http://www.jmpas.com/index.php"},
    {"name":"The Journal of Medical Research","url":"http://medicinearticle.com/"},
    {"name":"Journal of Medical Research and Practice","url":"http://jmrp.info/index.php/jmrp"},
    {"name":"Journal of Medical Science and Clinical Research","url":"http://jmscr.igmpublication.org/home/"},
    {"name":"Plants Journal / Journal of Medicinal Plants Studies","url":"http://www.plantsjournal.com/"},
    {"name":"Journal of Middle East and North Africa Sciences","url":"http://www.jomenas.org/home.html"},
    {"name":"Journal of Middle East Applied Science and Technology","url":"http://jmeast.webs.com/"},
    {"name":"Journal of Microbiology and Antimicrobial Agents","url":"http://jmaa.co.uk/"},
    {"name":"Journal of Modern Science & Heritage","url":"http://www.jmsh.eu/"},
    {"name":"Journal of Modern Science And Technology","url":"http://jmstpapers.com/editorial_board"},
    {"name":"Journal of Multidisciplinary Developments","url":"http://www.jomude.com/index.php/index/index"},
    {"name":"Journal of Multidisciplinary Engineering Science and Technology","url":"http://www.jmest.org/"},
    {"name":"Journal of Multidisciplinary Engineering Science Studies","url":"http://jmess.org/"},
    {"name":"Journal of Nature and Science","url":"http://www.jnsci.org/"},
    {"name":"Journal of Neurology & Neuromedicine","url":"http://www.jneurology.com/index.php"},
    {"name":"Journal of New Sciences","url":"http://www.jnsciences.org/"},
    {"name":"Journal of Nonlinear Science and Applications","url":"http://www.emis.de/journals/TJNSA/"},
    {"name":"Journal of Pharmaceutical and Bioanalytical Science ","url":"http://www.jpbscience.com/"},
    {"name":"Journal of Pharmaceutical and Biological Sciences","url":"http://www.jpabs.org/"},
    {"name":"Journal of Pharmaceutical and Biomedical Sciences","url":"http://www.jpbms.info/"},
    {"name":"Journal of Pharmaceutical and Scientific Innovation","url":"http://jpsionline.com/"},
    {"name":"Journal of Pharmaceutical, Chemical and Biological Sciences","url":"http://www.jpcbs.info/Home_Page.html"},
    {"name":"Journal of Pharmacognosy and Phytochemistry","url":"http://www.phytojournal.com/"},
    {"name":"Journal of Pharmacy Practice and Community Medicine","url":"http://www.jppcm.org/"},
    {"name":"Journal of Pharmacy Research","url":"http://jpronline.info/index.php/jpr/index"},
    {"name":"Journal of Physical Education Research","url":"http://www.joper.org/"},
    {"name":"Journal of Physical Therapy Science","url":"https://www.jstage.jst.go.jp/browse/jpts"},
    {"name":"Journal of Psychology and Theology","url":"http://www.dinz.info/"},
    {"name":"Journal of Postharvest Technology","url":"http://jpht.info/index.php/jpht/"},
    {"name":"Journal of Process Management New Technologies International","url":"http://journal%20of%20process%20management%20new%20technologies%20international%20%28jpmnt%29/"},
    {"name":"Journal of Rare Diseases Research & Treatment","url":"http://rarediseasesjournal.com/index.php"},
    {"name":" Journal of Reading and Literacy","url":"https://journalofreadingandliteracy.wordpress.com/"},
    {"name":"Journal of Research in Anaesthesology and Pain Medicine","url":"http://www.jrapm.com/"},
    {"name":"Journal of Research in Biology","url":"http://www.jresearchbiology.com/"},
    {"name":"Journal of Research in Computers and Technology","url":"http://www.jrctonline.com/"},
    {"name":"Journal of Research in Forensic Medicine and Toxicology","url":"http://www.jrfmt.com/"},
    {"name":"Journal of Research in General Surgery and Laparoscopy","url":"http://www.jegsl.com/"},
    {"name":"Journal of Research in Human Anatomy and Embryology","url":"http://www.jrhae.com/"},
    {"name":"Journal of Research in Obstetrics, Gynaecology and Infertility","url":"http://www.jrogi.com/"},
    {"name":"Journal of Research in Preventive and Social Medicine","url":"http://www.jrpsm.com/"},
    {"name":"Journal of Research in Psychiatry and Behavioural Sciences","url":"http://www.jrpbs.com/"},
    {"name":"Journal of Research in Psychiatry and Behavioural Sciences","url":"http://www.jrpbs.com/"},
    {"name":"Journal of Research in Radiodiagnosis, Teleradiology and Imaging","url":"http://www.jrrti.com/"},
    {"name":"Journal of Research in Traditional Medicine","url":"http://www.tmjournal.org/"},
    {"name":"Journal of Science","url":"http://www.journalofscience.net/"},
    {"name":"Journal of Science and Its Applications","url":"http://naukpublication.org/index.php/JOURNAL_SCIENCE_APPLICATIONS"},
    {"name":"Journal of Science and Technology Advances","url":"http://www.imedpharm.com/journals/index.php/JSTA"},
    {"name":"Journal of Science Editing","url":"http://journalofscienceediting.org/"},
    {"name":"Journal of Scientific and Engineering Research","url":"http://jsaer.com/"},
    {"name":"Journal of Scientific Letters","url":"http://www.jslsci.org/"},
    {"name":"Journal of Scientific Research and Development","url":"http://jsrad.org/"},
    {"name":"Journal of Scientific Research and Development","url":"http://jsrd.org/index.html"},
    {"name":"Journal of Scientific Research in Pharmacy","url":"http://www.jsrponline.com/"},
    {"name":"Journal of Scientific Research in Physical & Mathematical Sciences","url":"http://www.jsrpms.com/index.php"},
    {"name":"Journal of Scientific Theory and Methods","url":"http://journalofscientifictheoryandmethods.com/"},
    {"name":"Journal of Social Issues & Humanities","url":"http://www.journalsih.com/index.html"},
    {"name":"Journal of Software","url":"http://www.jsoftware.us/"},
    {"name":"Journal of Spectroscopy and Molecular Physics","url":"http://journal%20of%20spectroscopy%20and%20molecular%20physics/"},
    {"name":"Journal of Surgery & Patient Care","url":"http://surgeryopenaccess.com/"},
    {"name":"Journal of Telecommunications","url":"http://www.journaloftelecommunications.co.uk/home"},
    {"name":"Journal of The International Association of Advanced Technology and Science","url":"http://www.jiaats.com/index.php"},
    {"name":"Journal of Theoretical and Applied Information Technology","url":"http://www.jatit.org/index.php"},
    {"name":"Journal of Trends in the Development of Machinery and Associated Technology","url":"http://www.tmt.unze.ba/proceedings2014.php"},
    {"name":"Jundishapur Journal of Health Sciences","url":"http://jjhsci.com/"},
    {"name":"Junior Scientific Researcher","url":"http://www.jsrpublishing.com/"},
    {"name":"Kashmir Economic Review","url":"http://ker.ajku.edu.pk/"},
    {"name":"LangLit","url":"http://www.langlit.org/"},
    {"name":"Lecture Notes on Software Engineering","url":"http://www.lnse.org/"},
    {"name":"Legal Research Development","url":"http://lrdjournal.com/"},
    {"name":"Letters in Applied NanoBioScience","url":"http://nanobioletters.com/"},
    {"name":"LiBRI: Linguistic and Literary Broad Research and Innovation","url":"http://www.edusoft.ro/brain/index.php/libri"},
    {"name":"Lingua: International Journal of Linguistics, Literature and Culture","url":"http://ijllc.eu/"},
    {"name":"Lokavishkar International E-Journal","url":"http://liirj.org/"},
    {"name":"The Macrotheme Review","url":"http://macrotheme.com/home"},
    {"name":"Malti: International Hindi e-Research Journal","url":"http://www.maltihindijournal.info/"},
    {"name":"Mathematical and Computational Applications","url":"http://mcajournal.cbu.edu.tr/"},
    {"name":"Mechanics, Materials Science & Engineering Journal","url":"http://mmse.xyz/en/"},
    {"name":"Medical Research Archives","url":"http://journals.ke-i.org/index.php/mra"},
    {"name":"Medico Research Chronicles","url":"http://www.medrech.com/"},
    {"name":"Mediterranean Journal of Biosciences","url":"http://ojs.medjbio.com/index.php/medjbio"},
    {"name":"Mediterranean Journal of Chemistry","url":"http://www.medjchem.com/index.php/medjchem/index"},
    {"name":"Mediterranean Journal of Modeling & Simulation","url":"https://sites.google.com/site/lesimjms/home"},
    {"name":"Mediterranean Journal of Physics","url":"http://ojs.medjphysics.com/index.php/medjphysics"},
    {"name":"MedLife Clinics","url":"http://medlifeclinics.org/demo/"},
    {"name":"Modern Behavioral Science","url":"http://pwriters.com/index.php/mbs/index"},
    {"name":"The Modern Journal of Applied Linguistics","url":"http://www.mjal.org/index.htm"},
    {"name":"Modern Journal of Language Teaching Methods","url":"http://www.mjltm.com/index.php"},
    {"name":"Multidisciplinary Scientific Reviewer","url":"http://oiirj.org/oiirj/msr/"},
    {"name":"Munis Entomology & Zoology","url":"http://www.munisentzool.org/"},
    {"name":"NanoWorld Journal","url":"http://www.jnanoworld.com/index.php"},
    {"name":"National Journal of Basic Medical Sciences","url":"http://njbms.com/"},
    {"name":"National Journal of Community Medicine","url":"http://www.njcmindia.org/home"},
    {"name":"National Journal of Medical and Dental Research","url":"http://njmdr.org/"},
    {"name":"National Journal of Physiology, Pharmacy, and Pharmacology","url":"http://www.njppp.com/"},
    {"name":"Norwegian Journal of Development of the International Science","url":"http://www.njd-iscience.com/njdis/"},
    {"name":"OIDA International Journal of Sustainable Development","url":"http://www.ontariointernational.org/Publications.html"},
    {"name":"Oncoscience","url":"http://www.impactjournals.com/oncoscience/index.php"},
    {"name":"Oncotarget","url":"http://www.impactjournals.com/oncotarget/index.php?journal=oncotarget&page=index"},
    {"name":"Online International Interdisciplinary Research Journal","url":"http://oiirj.org/oiirj/"},
    {"name":"Online Journal of Communication and Media Technologies","url":"http://www.ojcmt.net/"},
    {"name":"The Online Journal of Distance Education and e-Learning","url":"http://tojdel.net/"},
    {"name":"Online Journal of Library & Information Science","url":"http://ojlis.sel.org.pk/"},
    {"name":"The Online Journal of New Horizons in Education","url":"http://www.tojned.net/"},
    {"name":"The Online Journal of Science and Technology","url":"http://www.tojsat.net/"},
    {"name":"Open Access Journal of Science and Technology","url":"http://oajost.com/"},
    {"name":"Open Journal of Clinical & Medical Sciences","url":"http://jclinmedsciences.com/index.html"},
    {"name":"Open Journal of Clinical & Medical Case Reports","url":"http://jclinmedcasereports.com/index.html"},
    {"name":"Oriental Journal of Computer Science and Technology","url":"http://www.computerscijournal.org/"},
    {"name":"Paripex Indian Journal of Research","url":"http://worldwidejournals.com/paripex/"},
    {"name":"Path of Science","url":"http://pathofscience.org/index.php/ps"},
    {"name":"Pattern Recognition in Physics","url":"http://www.pattern-recognition-in-physics.com/"},
    {"name":"People’s Journal of Scientific Research","url":"http://www.pjsr.org/Home.html"},
    {"name":"Pharma Innovation","url":"http://www.thepharmajournal.com/"},
    {"name":"The Pharma Research (Journal)","url":"http://www.thepharmaresearch.info/"},
    {"name":"Pharmaceutical and Biological Evaluations","url":"http://www.onlinepbe.com/index.php/PBE/index"},
    {"name":"Pharmaceutical and Chemical Journal","url":"http://tpcj.org/"},
    {"name":"Pharmacie Globale: International Journal of Comprehensive Pharmacy","url":"http://pharmacie-globale.info/"},
    {"name":"Pharmacognosy: Journal of Pharmacognosy and Phytochemistry","url":"http://www.phytojournal.com/"},
    {"name":"Pharmacologia","url":"http://pharmacologia.com/"},
    {"name":"PharmacologyOnline","url":"http://pharmacologyonline.silae.it/front"},
    {"name":"PHARMANEST: An International Journal of Advances in Pharmaceutical Sciences","url":"http://www.pharmanest.net/"},
    {"name":"Physical Education and Sports Research Journal","url":"http://pe.lsrj.in/"},
    {"name":"Plant Digest","url":"http://plantdigest.co.uk/index.php"},
    {"name":"Professionals Center for Business Research","url":"http://pcbr.net/"},
    {"name":"Progress in Physics","url":"http://www.ptep-online.com/"},
    {"name":"Pyxis Journal","url":"http://pyxis-journal.ru/"},
    {"name":"PunarnaV","url":"http://www.punarnav.com/"},
    {"name":"Quarterly Physics Review","url":"http://journals.ke-i.org/index.php/qpr"},
    {"name":"Reef Resources Assessment and Management Technical Paper","url":"http://behaviorsciences.com/"},
    {"name":"Remedy Open Access","url":"http://remedyoa.com/"},
    {"name":"Research","url":"http://www.labome.org/"},
    {"name":"Research (French version)","url":"http://www.labome.fr/"},
    {"name":"Research Ambition","url":"http://researchambition.com/"},
    {"name":"Research Chronicler","url":"http://research-chronicler.com/reschro/index.asp"},
    {"name":"Research Chronicles","url":"http://www.reschrone.com/"},
    {"name":"Research Dimension","url":"http://rd.researchdirection.org/Default.aspx"},
    {"name":"Research Directions","url":"http://researchdirection.org/Default.aspx"},
    {"name":"Research in Biotechnology","url":"http://www.researchinbiotechnology.com/home"},
    {"name":"Research in Pharmacy and Health Sciences","url":"http://www.rphsonline.com/"},
    {"name":"Research Innovator","url":"http://research-chronicler.com/resinv/index.asp"},
    {"name":"Research Inspiration","url":"http://researchinspiration.com/"},
    {"name":"Research Inventy: International Journal of Engineering and Science","url":"http://www.researchinventy.com/index.html"},
    {"name":"Research Journal of Life Sciences, Bioinformatics, Pharmaceutical, and Chemical Sciences","url":"http://rjlbpcs.com/"},
    {"name":"Research Journal of Pharmaceutical, Biological and Chemical Sciences","url":"http://www.rjpbcs.com/index.html"},
    {"name":"Research Opinions in Animal and Veterinary Sciences","url":"http://www.roavs.com/"},
    {"name":"Research Revolution","url":"http://www.researchrevolution.in/index.php"},
    {"name":"Research Scholar","url":"http://www.researchscholar.co.in/"},
    {"name":"ResearchDesk","url":"http://researchdesk.net/"},
    {"name":"Researchers World – Journal of Arts Science & Commerce","url":"http://www.researchersworld.com/index.html"},
    {"name":"Review of Research","url":"http://ror.isrj.org/"},
    {"name":"Reviews of Progress","url":"http://reviewsofprogress.org/"},
    {"name":"Revista Electrónica de las Ciencias Computacionales e Informática","url":"http://www.reci.org.mx/"},
    {"name":"Revista Iberoamericana de Ciencas","url":"http://www.reibci.org/"},
    {"name":"Revista Iberoamericana de Contaduría, Economía y Administración","url":"http://www.ricea.org.mx/"},
    {"name":"Revista Iberoamericana de las Ciencias Biológicas y Agropecuarias","url":"http://ciba.org/"},
    {"name":"Revista Iberoamericana de las Ciencias Biológicas y Agropecuarias","url":"http://www.ciba.org.mx/"},
    {"name":"Revista Iberoamericana de las Ciencias de la Salud","url":"http://www.rics.org.mx/"},
    {"name":"Revista Iberoamericana de las Ciencias Sociales y Humanísticas","url":"http://www.ricsh.org.mxmx/"},
    {"name":"Revista Iberoamericana para la Investigación y el Desarrollo Educativo","url":"http://www.ride.org.mx/"},
    {"name":"Romanian Biotechnological Letters","url":"http://www.rombio.eu/"},
    {"name":"Sanskruti International Multidisciplinary Research Journal","url":"http://www.journals.savap.org.pk/"},
    {"name":"Scholarly Research Exchange","url":"http://srej.wc.lt/"},
    {"name":"Scholars World- International Refereed Multidisciplinary Journal Of Contemporary Research","url":"http://scholarsworld.net/english/"},
    {"name":"Science and Engineering Applications","url":"http://jfips.com/"},
    {"name":"Science International","url":"http://www.scienceinternational.com/"},
    {"name":"Science International (Lahore)","url":"http://sci-int.com/"},
    {"name":"Science Park","url":"http://www.scienceparks.in/Default.aspx"},
    {"name":"Science Postprint","url":"http://www.spp-j.com/"},
    {"name":"Science Research Reporter","url":"http://www.jsrr.in/"},
    {"name":"Science Reuters","url":"http://www.sciencereuters.com/"},
    {"name":"Scientific Light","url":"http://www.slg-journal.com/home"},
    {"name":"Scientific Research Journal","url":"http://www.scirj.org/"},
    {"name":"Scientific Research Journal of India","url":"https://sites.google.com/site/scientificrji/"},
    {"name":"Scientific Researches","url":"http://science-research.com/"},
    {"name":"Scientific Transactions in Environment and Technovation","url":"http://scientific%20transactions%20in%20environment%20and%20technovation/"},
    {"name":"Scientific World","url":"http://scientificworld.co.uk/"},
    {"name":"Scitech Journal","url":"http://www.thescitech.com/"},
    {"name":"Scottish Journal of Arts, Social Sciences and Scientific Studies","url":"http://scottishjournal.co.uk/"},
    {"name":"SCRO Annual Report Journal","url":"http://scroreport.com/index.php/SCROAR/index"},
    {"name":"Sensors & Transducers Journal","url":"http://www.sensorsportal.com/HTML/DIGEST/Journal_Subscription.htm"},
    {"name":"Seventh Sense Research Group Journal","url":"http://ssrgj.blogspot.com/"},
    {"name":"Shiraz E-Medical Journal","url":"http://emedicalj.com/"},
    {"name":"Shiv Rudraksha International Journal of Advanced Research in Engineering & Management","url":"http://www.srijarem.in/"},
    {"name":"Smart & Young","url":"http://smartandyoung.com.ua/uk/"},
    {"name":"Smart Nanosystems in Engineering and Medicine","url":"http://gintem.org/"},
    {"name":"South Asian Journal of Food Technology and Environment","url":"http://www.sweft.in/"},
    {"name":"South Asian Journal of Mathematics","url":"http://www.sajm.com.nu/index.htm"},
    {"name":"South Indian Journal Of Biological Sciences","url":"http://www.sijbs.com/index.html/"},
    {"name":"South Pacific Journal of Technology and Science","url":"http://spjts.com/"},
    {"name":"South Pacific Journal of Pharma and Bio Sciences","url":"http://spjpbs.com/"},
    {"name":"Sport Science","url":"http://www.sposci.com/index.html"},
    {"name":"Swedish Journal of Scientific Research","url":"https://sjsr.se/en/home.php"},
    {"name":"Swiss Journal of Research in Business and Social Science","url":"http://www.sjrbss.com/"},
    {"name":"Tactful Management Research Journal","url":"http://tmgt.lsrj.in/"},
    {"name":"Technical Journal of Engineering and Applied Sciences","url":"http://tjeas.com/"},
    {"name":"Technics Technologies Education Management","url":"http://www.ttem.ba/index.html"},
    {"name":"Translational Medicine and Biotechnology","url":"http://oiirj.org/oiirj/tmb/"},
    {"name":"Transnational Journal of Science and Technology","url":"http://www.tjournal.org/"},
    {"name":"Transworld Medical Journal","url":"http://www.tmjournals.com/"},
    {"name":"Trends Journal of Sciences Research","url":"http://www.tjsr.org/"},
    {"name":"Tropical Plant Research","url":"http://www.tropicalplantresearch.com/"},
    {"name":"Turkish Journal of Scientific Research","url":"http://tjsrjournal.com/"},
    {"name":"Turkish Online Journal of Educational Technology","url":"http://www.tojet.net/"},
    {"name":"Ultra Engineer","url":"http://www.ultra-engineer.org/"},
    {"name":"Ulutas Genetic Research Journal","url":"http://www.geneticresearchjournal.com/"},
    {"name":"The Ulutas Medical Journal","url":"http://www.ulutasmedicaljournal.com/"},
    {"name":"Universal Journal of Applied Computer Science and Technology","url":"http://uniascit.in/index.php"},
    {"name":"Universal Journal of Computer Science and Engineering Technology","url":"http://www.unicse.org/"},
    {"name":"Universal Journal of Pharmaceutical Research","url":"http://www.ujpr.org/"},
    {"name":"Universal Journal of Pharmacy","url":"http://www.ujponline.com/"},
    {"name":"Universe of Emerging Technology and Science","url":"http://www.uniets.com/"},
    {"name":"Visi Jurnal Akademik","url":"http://www.visijurnal.com/"},
    {"name":"Weberbauerella","url":"http://weberbauerella.org/"},
    {"name":"Weekly Science International Research Journal","url":"http://www.weeklyscience.org/Default.aspx"},
    {"name":"World Academy of Informatics and Management Sciences","url":"http://www.waims.co.in/index.aspx"},
    {"name":"World Applied Sciences Journal","url":"http://www.wasj.org/"},
    {"name":"World Essays Journal","url":"http://worldessaysj.com/en/"},
    {"name":"World Journal of Innovative Research","url":"https://www.wjir.org/"},
    {"name":"World Journal of Engineering Research and Technology","url":"http://www.wjert.org/"},
    {"name":"World Journal of Pharmaceutical and Medical Research","url":"http://www.wjpmr.com/"},
    {"name":"World Journal of Pharmaceutical and Life Sciences","url":"http://wjpls.org/home"},
    {"name":"World Journal of Pharmaceutical Research","url":"http://www.wjpr.net/"},
    {"name":"World Journal of Pharmaceutical Sciences ","url":"http://www.wjpsonline.org/"},
    {"name":"World Journal of Pharmacy and Pharmaceutical Sciences","url":"http://www.wjpps.com/"},
    {"name":"World Journal of Research and Review","url":"https://www.wjrr.org/"},
    {"name":"World Journal of Science and Technology","url":"http://worldjournalofscience.com/"},
    {"name":"World Medical Student Journal","url":"http://worldmsjournal.org/index.php/worldmsj"},
    {"name":"World Scientific News","url":"http://www.worldscientificnews.com/"},
    {"name":"World Wide Journal of Multidisciplinary Research and Development","url":"http://wwjmrd.com/"},
    {"name":"Adalya Journal","url":"http://adalyajournal.com/"},
    {"name":"Advances in Fixed Point Theory","url":"http://scik.org/index.php/afpt"},
    {"name":"Aegaeum","url":"http://aegaeum.com/"},
    {"name":"Agrociencia","url":"http://www.colopos.mx/"},
    {"name":"AGU International Journal of Engineering & Technology","url":"http://aguijet.com/"},
    {"name":"AGU International Journal of Professional Studies & Research","url":"http://aguijpsr.com/"},
    {"name":"AGU International Journal of Research in Social Science & Humanities","url":"http://aguijrssh.com/"},
    {"name":"Annals of Clinical and Medical Case Reports","url":"https://acmcasereport.com/"},
    {"name":"Annals of Clinical and Medical Case Reports","url":"http://acmcaserep.com/"},
    {"name":"Annals of Dental Specialty","url":"https://annalsofdentalspecialty.net.in/en"},
    {"name":"American Journal of Biomedical Science & Research","url":"https://biomedgrid.com/"},
    {"name":"American Journal of Humanities and Social Sciences Research","url":"https://www.ajhssr.com/"},
    {"name":"American Journal of Multidisciplinary Research and Development","url":"https://www.ajmrd.com/"},
    {"name":"Amphibian & Reptile Conservation","url":"http://amphibian-reptile-conservation.org/"},
    {"name":"Arabian Journal of Medical Sciences","url":"http://www.ajms.tk/"},
    {"name":"Archives of Applied Medicine","url":"https://aoamj.org/"},
    {"name":"ARCTIC Journal","url":"http://arcticjournal.org/index.html"},
    {"name":"Asian Journal of Applied Science and Technology","url":"http://www.ajast.net/"},
    {"name":"Asian Journal of Emerging Research","url":"http://amscentral.com/ajer/"},
    {"name":"Aurora’s International Journal of Computing​","url":"http://www.aurora-journal.com/"},
    {"name":"Biomedical Journal of Scientific & Technical Research","url":"https://biomedres.us/"},
    {"name":"Biomedical Journal of Scientific & Technical Research","url":"http://openaccessjournal.us/"},
    {"name":"BOREAL ENVIRONMENT RESEARCH","url":"http://borenv.com/"},
    {"name":"British Journal of Biomedical Research","url":"http://bjbmr.org/"},
    {"name":"British Journal of Medical & Health Sciences","url":"http://jmhsci.org/"},
    {"name":"British Journal of Pharmaceutical and Medical Research​","url":"https://www.bjpmr.org/"},
    {"name":"Canadian Journal of Biomedical Research and Technology","url":"https://biomedress.com/"},
    {"name":"CCAMLR Science","url":"http://www.ccamlrscience.com/"},
    {"name":"Cell Medicine","url":"https://www.cognizantcommunication.com/journal-titles/cell-medicine"},
    {"name":"Core Evidence","url":"https://www.dovepress.com/core-evidence-journal"},
    {"name":"Current Biomarker Findings","url":"https://www.dovepress.com/current-biomarker-findings-journal"},
    {"name":"Current Neurobiology","url":"http://currentneurobiology.org/"},
    {"name":"Current Science","url":"http://currentscience.org/"},
    {"name":"Danish Scientific Journal","url":"http://www.danish-journal.com/"},
    {"name":"Degenerative Neurological and Neuromuscular Disease","url":"https://www.dovepress.com/degenerative-neurological-and-neuromuscular-disease-journal"},
    {"name":"Disseminate Knowledge","url":"http://www.sjvndk.com/"},
    {"name":"Estudos de Psicologia (Campinas)","url":"http://www.scielo.br/estpsi"},
    {"name":"European Journal of General Dentistry","url":"http://www.ejgd.org/"},
    {"name":"European Journal of Molecular & Clinical Medicine","url":"https://ejmcm.com/"},
    {"name":"FOURRAGES","url":"http://afpf-asso.com/"},
    {"name":"Global Journal of Advance Research on Classical and Modern Geometries","url":"http://geometry-math-journal.ro/"},
    {"name":"Global Journal of Engineering Science and Researches","url":"http://www.gjesr.com/"},
    {"name":"Global Journal of Research on Medicinal Plants & Indigenous Medicine","url":"http://www.gjrmi.com/"},
    {"name":"Global Scientific Journal – GSJ Publication","url":"http://www.globalscientificjournal.com/"},
    {"name":"High Technology Letters","url":"http://www.gjstx-e.cn/"},
    {"name":"IARTEM e-journal","url":"http://biriwa.com/iartem/ejournal/"},
    {"name":"IBMRD’s Journal of Management Research","url":"http://www.ibmrdjournal.com/"},
    {"name":"Iconic Research & Engineering Journals","url":"http://www.irejournals.com/"},
    {"name":"The IIOAB Journal","url":"https://iioab-journal.webs.com/"},
    {"name":"IJPUB – International Peer Reviewed, Open Access Journal","url":"http://ijpub.org/"},
    {"name":"International Journal of Creative Research Thoughts","url":"http://ijcrt.org/"},
    {"name":"Indian Journal of Public Health Research and Development","url":"http://www.ijphrd.com/"},
    {"name":"Indonesian Journal of Business Finance and Accounting","url":"http://thomson.id/index.php/ijbfa"},
    {"name":"Indonesian Journal of Management and Business Economics","url":"http://thomson.id/index.php/ijmbe"},
    {"name":"Interciencia","url":"http://intercienciajournal.com/"},
    {"name":"International New Arts and Sciences Research Journal​","url":"http://www.artsandsciencesjournal.com/"},
    {"name":"International Bulletin of Drug Research","url":"http://www.ibdr.in/"},
    {"name":"International Education and Leadership","url":"http://www.jielusa.org/"},
    {"name":"International Educational Applied Research Journal","url":"http://iearj.com/"},
    {"name":"International Invention of Scientific Journal","url":"http://www.iisj.in/index.php/iisj"},
    {"name":"International Journal for Engineering and Emerging Technologies","url":"http://www.ijfeet.com/"},
    {"name":"International Journal of Advanced Computer Research","url":"http://accentsjournals.org/journals.php?journalsId=103"},
    {"name":"International Journal of Advanced Research in Computer Engineering & Technology","url":"http://ijarcet.org/"},
    {"name":"International Journal of Advanced Research in Education Technology and Management","url":"http://ijaretm.com/"},
    {"name":"International Journal of Advanced Research in Electronics and Communication Engineering","url":"http://ijarece.org/"},
    {"name":"International Journal of Advanced Research in Innovative Discoveries in Engineering and Applications","url":"http://ijaridea.com/"},
    {"name":"International Journal of Advanced Research in Management, Architecture, Technology and Engineering","url":"http://www.ijarmate.com/"},
    {"name":"International Journal of Advanced Research and Publications","url":"http://www.ijarp.org/"},
    {"name":"International Journal of Advanced Research Trends in Engineering and Technology","url":"http://ijartet.com/"},
    {"name":"International Journal of Advanced Scientific Research","url":"http://www.allscientificjournal.com/"},
    {"name":"International Journal of Agriculture, Environment and Bioresearch","url":"http://ijaeb.org/"},
    {"name":"International Journal of Agriculture and Biosciences","url":"http://www.ijagbio.com/"},
    {"name":"International Journal of Biopharmaceutics","url":"https://www.ijbonline.com/"},
    {"name":"International Journal of Business and Information","url":"https://ijbi.org/ijbi"},
    {"name":"International Journal of Business Management and Commerce","url":"http://www.ijbmcnet.com/"},
    {"name":"International Journal of Basic & Clinical Pharmacology","url":"http://www.ijbcp.com/"},
    {"name":"International Journal of Communication and Computer Technologies","url":"http://ijccts.org/"},
    {"name":"International Journal of Computer Science and Management Studies","url":"http://www.ijcsms.com/"},
    {"name":"International Journal of Computer Science and Mobile Computing","url":"https://www.ijcsmc.com/"},
    {"name":"IJPUB","url":"http://ijpub.org/"},
    {"name":"International Journal of Dental Science and Innovative Research","url":"https://www.ijdsir.com/"},
    {"name":"International Journal of Education and Science Research Review","url":"http://ijesrr.org/"},
    {"name":"International Journal of Electronics, Communication and Soft Computing Science and Engineering","url":"http://www.ijecscse.org/"},
    {"name":"International Journal of Electronics and Computer Science Engineering","url":"http://www.ijecse.org/"},
    {"name":"International Journal of Engineering, Economics And Management","url":"http://ijeem.org/"},
    {"name":"International Journal of Engineering Research and Sports Science","url":"http://www.ijerss.com/"},
    {"name":"International Journal of Engineering Science Technology And Research","url":"http://ijestr.com/"},
    {"name":"International Journal of Engineering Studies and Technical Approach","url":"http://ijesta.com/"},
    {"name":"International Journal of Eurasia Social Sciences","url":"http://www.ijoess.com/Anasayfa.Aspx"},
    {"name":"International Journal of Health Medicine and Current Research","url":"http://ijhmcr.com/"},
    {"name":"International Journal of Innovative Science and Research Technology","url":"https://ijisrt.com/"},
    {"name":"International Journal of Innovative Technology and Adaptive Management","url":"http://www.ijitam.org/"},
    {"name":"International Journal of Innovative Technology and Creative Engineering","url":"http://www.ijitce.co.uk/"},
    {"name":"International Journal of Latest Research in Humanities and Social Science","url":"http://www.ijlrhss.com/"},
    {"name":"International Journal of Learning and Teaching","url":"http://www.ijlt.org/"},
    {"name":"International Journal of Lifescience and Pharma Research","url":"http://www.ijlpr.com/"},
    {"name":"International Journal of Materials, Mechanics and Manufacturing","url":"http://www.ijmmm.org/"},
    {"name":"International Journal of Medical, Health Science and Internal Research","url":"http://www.ijmhsir.com/"},
    {"name":"International Journal of Medical Science and Advanced Clinical Research","url":"https://www.ijmacr.com/"},
    {"name":"International Journal of Medical Science and Applied Research","url":"https://www.ijmsar.com/"},
    {"name":"International Journal of Medical Science and Diagnosis Research","url":"https://www.ijmsdr.com/"},
    {"name":"International Journal of Medical Science and Innovative Research","url":"https://www.ijmsir.com/"},
    {"name":"International Journal of Medicine and Biomedical Research","url":"http://www.ijmbr.com/"},
    {"name":"International Journal of Medicine and Public Health","url":"http://www.ijmedph.org/"},
    {"name":"International Journal of Modern Trends in Engineering and Science","url":"http://ijmtes.com/"},
    {"name":"International Journal of Multidisciplinary Approach & Studies","url":"http://ijmas.com/"},
    {"name":"International Journal of Multidisciplinary Consortium","url":"http://ijmc.rtmonline.in/"},
    {"name":"International Journal of Nanomedicine","url":"https://www.dovepress.com/international-journal-of-nanomedicine-journal"},
    {"name":"International Journal of Novel Research and Development","url":"http://www.ijnrd.org/"},
    {"name":"International Journal of Preclinical and Pharmaceutical Research","url":"http://preclinicaljournal.com/"},
    {"name":"International Journal of Pharmaceutical Research and Allied Sciences","url":"https://ijpras.com/"},
    {"name":"International Journal of Reproduction, Contraception, Obstetrics and Gynecology","url":"http://www.ijrcog.org/"},
    {"name":"International Journal of Research and Applications","url":"http://ijraonline.com/"},
    {"name":"International Journal of Research in Computer Applications and Robotics","url":"http://www.ijrcar.com/"},
    {"name":"International Journal of Research in Medical Sciences","url":"http://www.msjonline.org/"},
    {"name":"International Journal of Scientific Engineering and Science","url":"http://ijses.com/"},
    {"name":"International Journal of Scientific Management and Development","url":"http://www.ijsmd.com/"},
    {"name":"International Journal of Scientific Research Engineering & Technology","url":"http://ijsret.org/"},
    {"name":"International Journal of Social Science and Business","url":"https://www.ijssb.com/"},
    {"name":"International Journal of Social Sciences and Information Technology","url":"https://www.ijssit.com/main/"},
    {"name":"International Journal of Trend in Scientific Research and Development","url":"https://www.ijtsrd.com/"},
    {"name":"International Journal of Zoology Studies","url":"http://www.zoologyjournals.com/"},
    {"name":"International Medical Journal","url":"https://www.seronijihou.com/"},
    {"name":"International Refereed Journal of Scientific Research in Engineering","url":"http://irjsre.com/"},
    {"name":"International Research Journal of Advanced Engineering and Science","url":"http://www.irjaes.com/"},
    {"name":"International Review of Humanities and Scientific Research","url":"https://www.irhsr.org/"},
    {"name":"Internet Journal of Rheumatology and Clinical Immunology","url":"https://www.chanrejournals.com/index.php/rheumatology/index"},
    {"name":"Iraqi National Journal of Chemistry","url":"http://iqnjc.com/"},
    {"name":"Istoriâ Zmievskogo kraâ","url":"https://colovrat.at.ua/"},
    {"name":"Journal of Academia and Industrial Research","url":"http://jairjp.com/"},
    {"name":"Journal of Accounting and Applied Business Research","url":"https://jaaabr.com/"},
    {"name":"Journal of Advanced Medical and Dental Sciences Research","url":"http://jamdsr.com/"},
    {"name":"Journal of Applied Bio-Science, Medicine, and Biology","url":"http://jabs.eu5.org/"},
    {"name":"Journal of Arts, Literature, Humanities and Social Sciences","url":"http://www.jalhss.com/index.php/jalhss"},
    {"name":"Journal of Engineering Technology","url":"http://www.joetsite.com/"},
    {"name":"Journal of English Language Teaching and Linguistics","url":"http://jeltl.org/"},
    {"name":"Journal of FisheriesSciences.com","url":"http://www.fisheriessciences.com/"},
    {"name":"Journal of Global Pharma Technology","url":"https://jgpt.co.in/"},
    {"name":"Journal of Multidisciplinary Academic Tourism","url":"http://dergipark.gov.tr/jomat"},
    {"name":"Journal of International Dental and Medical Research","url":"https://www.jidmr.com/"},
    {"name":"Journal of International Oral Health","url":"http://www.jioh.org/"},
    {"name":"Journal of Pharmacology and Pharmacotherapeutics","url":"http://www.jpharmacol.com/"},
    {"name":"Journal of Research in Ecology","url":"http://ecologyresearch.info/"},
    {"name":"Journal of Research and Opinion","url":"http://researchopinion.info/"},
    {"name":"Journal of Scientometric Research","url":"http://www.jscires.org/"},
    {"name":"Journal of Southwest Jiaotong University","url":"http://www.jsju.org/index.php/journal"},
    {"name":"Journal of Talent Development and Excellence","url":"http://www.iratde.com/"},
    {"name":"Journal of University of Shanghai for Science and Technology","url":"https://jusst.org/"},
    {"name":"Journal of Xi’an Shiyou University","url":"https://www.xisdxjxsu.asia/"},
    {"name":"Journal of Xi’an University of Architecture & Technology","url":"http://www.xajzkjdx.cn/"},
    {"name":"Journal of Xidian University","url":"http://xadzkjdx.cn/"},
    {"name":"Journal of the Pancreas","url":"http://www.joplink.net/"},
    {"name":"Jurnal Teknologi Informasi Dan Komunikasi Dalam Pendidikan","url":"http://jurnal.unimed.ac.id/2012/index.php/teknologi"},
    {"name":"Jurnal Teknologi Pendidikan","url":"http://jurnal.unimed.ac.id/2012/index.php/jtp"},
    {"name":"Jurnalul de Chirurgie","url":"http://jurnaluldechirurgie.ro/"},
    {"name":"MAGNT Research Report","url":"http://brisjast.com/"},
    {"name":"Material Science Research India","url":"http://www.materialsciencejournal.org/"},
    {"name":"Mechanics, Materials Science & Engineering Journal","url":"https://mmse.xyz/en/"},
    {"name":"Medical – Surgical Nursing Journal","url":"http://medsnj.com/en/index.html"},
    {"name":"Mintage Journal of Pharmaceutical and Medical Sciences","url":"http://www.mintagejournals.com/"},
    {"name":"Mitteilungen Klosterneuburg","url":"http://mitt-klosterneuburg.com/index.html"},
    {"name":"Mitteilungen Saechsischer Entomologen","url":"http://jamespublications.com/Mitteilungen_Saechsischer_Entomologen"},
    {"name":"Mugla Journal of  Science and Technology","url":"http://dergipark.gov.tr/muglajsci"},
    {"name":"National Journal of Commerce and Management","url":"http://njcm.pratibha-spandan.org/"},
    {"name":"The New American Journal of Medicine","url":"http://www.najmed.org/index.php"},
    {"name":"North American Journal of Medical Sciences","url":"http://www.najms.org/"},
    {"name":"Nursing and Midwifery Studies","url":"http://www.nmsjournal.com/"},
    {"name":"Oncology, Gastroenterology and Hepatology Reports","url":"http://www.oghreports.org/"},
    {"name":"Opción","url":"http://www.scieloopcion.com/"},
    {"name":"Oriental Journal of Chemistry","url":"http://www.orientjchem.org/"},
    {"name":"Paideuma Journal of Research","url":"http://paideumajournal.com/"},
    {"name":"Paideuma Journal of Research","url":"http://pjrpublication.com/"},
    {"name":"Palma Journal","url":"http://www.palmajournal.org/"},
    {"name":"Pharmacognosy Magazine","url":"http://www.phcog.com/"},
    {"name":"Pharmacognosy Research","url":"http://www.phcogres.com/"},
    {"name":"Pharmacognosy Reviews","url":"http://www.phcogrev.com/"},
    {"name":"Pioneer-scientists","url":"http://pioneer-scientists.org/"},
    {"name":"POLISH POLAR RESEARCH","url":"http://www.polishpolar.com/"},
    {"name":"Preslia Journal","url":"http://presliajournal.com/"},
    {"name":"Research on Modern Higher Education","url":"http://www.remhe.org/"},
    {"name":"Research Revolution","url":"http://www.researchrevolution.in/"},
    {"name":"Revista de Educacion","url":"http://revistaeducacion.org/"},
    {"name":"Revistas Electrónicas UACh","url":"http://www.ausrevista.info/"},
    {"name":"Revistas Electrónicas UACh","url":"http://www.ausrevista.com/"},
    {"name":"RGUSH Journal of Pharmaceutical Sciences","url":"http://www.rjps.in/"},
    {"name":"Signa Vitae – Journal of Intensive Care and Emergency Medicine","url":"http://www.signavitae.com/"},
    {"name":"Singaporean Journal of Business Economics and Management Studies","url":"https://www.singaporeanjbem.com/"},
    {"name":"Society: Politics, Economics, Law","url":"http://dom-hors.ru/"},
    {"name":"Taylors Science Gate","url":"http://taylorspublications.com/"},
    {"name":"Taylors Science Gate","url":"http://taylorspub.com/"},
    {"name":"Technology Reports of Kansai University","url":"http://kansaiuniversityreports.com/"},
    {"name":"TEST: Engineering & Management","url":"http://www.testmagzine.biz/"},
    {"name":"The Turkish Nephrology, Dialysis and Transplantation Journal","url":"http://www.tndt.org/"},
    {"name":"World Journal of Environmental Biosciences","url":"http://www.environmentaljournals.org/"},
    {"name":"World Nutrition, WPHNA","url":"https://worldnutritionjournal.org/index.php/wn"}
]

from urllib.parse import urlparse

POTENTIAL_PREDATORY_JOURNALS_HOSTS = set([urlparse(x.get("url")).netloc.replace("www.", "") for x in POTENTIAL_PREDATORY_JOURNALS])
POTENTIAL_PREDATORY_JOURNALS_NAMES = set([x.get("name").lower() for x in POTENTIAL_PREDATORY_JOURNALS])
