# coding=utf-8
# *** WARNING: this file was generated by the Pulumi SDK Generator. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from .. import _utilities

__all__ = [
    'ConfigurationSetDeliveryOptionsArgs',
    'ConfigurationSetEventDestinationCloudWatchDestinationArgs',
    'ConfigurationSetEventDestinationDimensionConfigurationArgs',
    'ConfigurationSetEventDestinationEventDestinationArgs',
    'ConfigurationSetEventDestinationKinesisFirehoseDestinationArgs',
    'ConfigurationSetEventDestinationSnsDestinationArgs',
    'ConfigurationSetReputationOptionsArgs',
    'ConfigurationSetSendingOptionsArgs',
    'ConfigurationSetSuppressionOptionsArgs',
    'ConfigurationSetTrackingOptionsArgs',
    'ContactListTagArgs',
    'ContactListTopicArgs',
    'ReceiptFilterFilterArgs',
    'ReceiptFilterIpFilterArgs',
    'ReceiptRuleActionArgs',
    'ReceiptRuleAddHeaderActionArgs',
    'ReceiptRuleBounceActionArgs',
    'ReceiptRuleLambdaActionArgs',
    'ReceiptRuleRuleArgs',
    'ReceiptRuleS3ActionArgs',
    'ReceiptRuleSNSActionArgs',
    'ReceiptRuleStopActionArgs',
    'ReceiptRuleWorkmailActionArgs',
    'TemplateArgs',
]

@pulumi.input_type
class ConfigurationSetDeliveryOptionsArgs:
    def __init__(__self__, *,
                 sending_pool_name: Optional[pulumi.Input[str]] = None,
                 tls_policy: Optional[pulumi.Input[str]] = None):
        """
        An object that defines the dedicated IP pool that is used to send emails that you send using the configuration set.
        :param pulumi.Input[str] sending_pool_name: The name of the dedicated IP pool to associate with the configuration set.
        :param pulumi.Input[str] tls_policy: Specifies whether messages that use the configuration set are required to use Transport Layer Security (TLS). If the value is Require , messages are only delivered if a TLS connection can be established. If the value is Optional , messages can be delivered in plain text if a TLS connection can't be established.
        """
        if sending_pool_name is not None:
            pulumi.set(__self__, "sending_pool_name", sending_pool_name)
        if tls_policy is not None:
            pulumi.set(__self__, "tls_policy", tls_policy)

    @property
    @pulumi.getter(name="sendingPoolName")
    def sending_pool_name(self) -> Optional[pulumi.Input[str]]:
        """
        The name of the dedicated IP pool to associate with the configuration set.
        """
        return pulumi.get(self, "sending_pool_name")

    @sending_pool_name.setter
    def sending_pool_name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "sending_pool_name", value)

    @property
    @pulumi.getter(name="tlsPolicy")
    def tls_policy(self) -> Optional[pulumi.Input[str]]:
        """
        Specifies whether messages that use the configuration set are required to use Transport Layer Security (TLS). If the value is Require , messages are only delivered if a TLS connection can be established. If the value is Optional , messages can be delivered in plain text if a TLS connection can't be established.
        """
        return pulumi.get(self, "tls_policy")

    @tls_policy.setter
    def tls_policy(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "tls_policy", value)


@pulumi.input_type
class ConfigurationSetEventDestinationCloudWatchDestinationArgs:
    def __init__(__self__, *,
                 dimension_configurations: Optional[pulumi.Input[Sequence[pulumi.Input['ConfigurationSetEventDestinationDimensionConfigurationArgs']]]] = None):
        """
        An object that contains the names, default values, and sources of the dimensions associated with an Amazon CloudWatch event destination.
        :param pulumi.Input[Sequence[pulumi.Input['ConfigurationSetEventDestinationDimensionConfigurationArgs']]] dimension_configurations: A list of dimensions upon which to categorize your emails when you publish email sending events to Amazon CloudWatch.
        """
        if dimension_configurations is not None:
            pulumi.set(__self__, "dimension_configurations", dimension_configurations)

    @property
    @pulumi.getter(name="dimensionConfigurations")
    def dimension_configurations(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['ConfigurationSetEventDestinationDimensionConfigurationArgs']]]]:
        """
        A list of dimensions upon which to categorize your emails when you publish email sending events to Amazon CloudWatch.
        """
        return pulumi.get(self, "dimension_configurations")

    @dimension_configurations.setter
    def dimension_configurations(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['ConfigurationSetEventDestinationDimensionConfigurationArgs']]]]):
        pulumi.set(self, "dimension_configurations", value)


@pulumi.input_type
class ConfigurationSetEventDestinationDimensionConfigurationArgs:
    def __init__(__self__, *,
                 default_dimension_value: pulumi.Input[str],
                 dimension_name: pulumi.Input[str],
                 dimension_value_source: pulumi.Input[str]):
        """
        A list of dimensions upon which to categorize your emails when you publish email sending events to Amazon CloudWatch.
        :param pulumi.Input[str] default_dimension_value: The default value of the dimension that is published to Amazon CloudWatch if you do not provide the value of the dimension when you send an email.
        :param pulumi.Input[str] dimension_name: The name of an Amazon CloudWatch dimension associated with an email sending metric.
        :param pulumi.Input[str] dimension_value_source: The place where Amazon SES finds the value of a dimension to publish to Amazon CloudWatch. To use the message tags that you specify using an X-SES-MESSAGE-TAGS header or a parameter to the SendEmail/SendRawEmail API, specify messageTag. To use your own email headers, specify emailHeader. To put a custom tag on any link included in your email, specify linkTag.
        """
        pulumi.set(__self__, "default_dimension_value", default_dimension_value)
        pulumi.set(__self__, "dimension_name", dimension_name)
        pulumi.set(__self__, "dimension_value_source", dimension_value_source)

    @property
    @pulumi.getter(name="defaultDimensionValue")
    def default_dimension_value(self) -> pulumi.Input[str]:
        """
        The default value of the dimension that is published to Amazon CloudWatch if you do not provide the value of the dimension when you send an email.
        """
        return pulumi.get(self, "default_dimension_value")

    @default_dimension_value.setter
    def default_dimension_value(self, value: pulumi.Input[str]):
        pulumi.set(self, "default_dimension_value", value)

    @property
    @pulumi.getter(name="dimensionName")
    def dimension_name(self) -> pulumi.Input[str]:
        """
        The name of an Amazon CloudWatch dimension associated with an email sending metric.
        """
        return pulumi.get(self, "dimension_name")

    @dimension_name.setter
    def dimension_name(self, value: pulumi.Input[str]):
        pulumi.set(self, "dimension_name", value)

    @property
    @pulumi.getter(name="dimensionValueSource")
    def dimension_value_source(self) -> pulumi.Input[str]:
        """
        The place where Amazon SES finds the value of a dimension to publish to Amazon CloudWatch. To use the message tags that you specify using an X-SES-MESSAGE-TAGS header or a parameter to the SendEmail/SendRawEmail API, specify messageTag. To use your own email headers, specify emailHeader. To put a custom tag on any link included in your email, specify linkTag.
        """
        return pulumi.get(self, "dimension_value_source")

    @dimension_value_source.setter
    def dimension_value_source(self, value: pulumi.Input[str]):
        pulumi.set(self, "dimension_value_source", value)


@pulumi.input_type
class ConfigurationSetEventDestinationEventDestinationArgs:
    def __init__(__self__, *,
                 matching_event_types: pulumi.Input[Sequence[pulumi.Input[str]]],
                 cloud_watch_destination: Optional[pulumi.Input['ConfigurationSetEventDestinationCloudWatchDestinationArgs']] = None,
                 enabled: Optional[pulumi.Input[bool]] = None,
                 kinesis_firehose_destination: Optional[pulumi.Input['ConfigurationSetEventDestinationKinesisFirehoseDestinationArgs']] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 sns_destination: Optional[pulumi.Input['ConfigurationSetEventDestinationSnsDestinationArgs']] = None):
        """
        :param pulumi.Input[Sequence[pulumi.Input[str]]] matching_event_types: The type of email sending events, send, reject, bounce, complaint, delivery, open, click, renderingFailure.
        :param pulumi.Input['ConfigurationSetEventDestinationCloudWatchDestinationArgs'] cloud_watch_destination: An object that contains the names, default values, and sources of the dimensions associated with an Amazon CloudWatch event destination.
        :param pulumi.Input[bool] enabled: Sets whether Amazon SES publishes events to this destination when you send an email with the associated configuration set. Set to true to enable publishing to this destination; set to false to prevent publishing to this destination. The default value is false.   
        :param pulumi.Input['ConfigurationSetEventDestinationKinesisFirehoseDestinationArgs'] kinesis_firehose_destination: An object that contains the delivery stream ARN and the IAM role ARN associated with an Amazon Kinesis Firehose event destination.
        :param pulumi.Input[str] name: The name of the event destination set.
        :param pulumi.Input['ConfigurationSetEventDestinationSnsDestinationArgs'] sns_destination: An object that contains SNS topic ARN associated event destination.
        """
        pulumi.set(__self__, "matching_event_types", matching_event_types)
        if cloud_watch_destination is not None:
            pulumi.set(__self__, "cloud_watch_destination", cloud_watch_destination)
        if enabled is not None:
            pulumi.set(__self__, "enabled", enabled)
        if kinesis_firehose_destination is not None:
            pulumi.set(__self__, "kinesis_firehose_destination", kinesis_firehose_destination)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if sns_destination is not None:
            pulumi.set(__self__, "sns_destination", sns_destination)

    @property
    @pulumi.getter(name="matchingEventTypes")
    def matching_event_types(self) -> pulumi.Input[Sequence[pulumi.Input[str]]]:
        """
        The type of email sending events, send, reject, bounce, complaint, delivery, open, click, renderingFailure.
        """
        return pulumi.get(self, "matching_event_types")

    @matching_event_types.setter
    def matching_event_types(self, value: pulumi.Input[Sequence[pulumi.Input[str]]]):
        pulumi.set(self, "matching_event_types", value)

    @property
    @pulumi.getter(name="cloudWatchDestination")
    def cloud_watch_destination(self) -> Optional[pulumi.Input['ConfigurationSetEventDestinationCloudWatchDestinationArgs']]:
        """
        An object that contains the names, default values, and sources of the dimensions associated with an Amazon CloudWatch event destination.
        """
        return pulumi.get(self, "cloud_watch_destination")

    @cloud_watch_destination.setter
    def cloud_watch_destination(self, value: Optional[pulumi.Input['ConfigurationSetEventDestinationCloudWatchDestinationArgs']]):
        pulumi.set(self, "cloud_watch_destination", value)

    @property
    @pulumi.getter
    def enabled(self) -> Optional[pulumi.Input[bool]]:
        """
        Sets whether Amazon SES publishes events to this destination when you send an email with the associated configuration set. Set to true to enable publishing to this destination; set to false to prevent publishing to this destination. The default value is false.   
        """
        return pulumi.get(self, "enabled")

    @enabled.setter
    def enabled(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "enabled", value)

    @property
    @pulumi.getter(name="kinesisFirehoseDestination")
    def kinesis_firehose_destination(self) -> Optional[pulumi.Input['ConfigurationSetEventDestinationKinesisFirehoseDestinationArgs']]:
        """
        An object that contains the delivery stream ARN and the IAM role ARN associated with an Amazon Kinesis Firehose event destination.
        """
        return pulumi.get(self, "kinesis_firehose_destination")

    @kinesis_firehose_destination.setter
    def kinesis_firehose_destination(self, value: Optional[pulumi.Input['ConfigurationSetEventDestinationKinesisFirehoseDestinationArgs']]):
        pulumi.set(self, "kinesis_firehose_destination", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[str]]:
        """
        The name of the event destination set.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter(name="snsDestination")
    def sns_destination(self) -> Optional[pulumi.Input['ConfigurationSetEventDestinationSnsDestinationArgs']]:
        """
        An object that contains SNS topic ARN associated event destination.
        """
        return pulumi.get(self, "sns_destination")

    @sns_destination.setter
    def sns_destination(self, value: Optional[pulumi.Input['ConfigurationSetEventDestinationSnsDestinationArgs']]):
        pulumi.set(self, "sns_destination", value)


@pulumi.input_type
class ConfigurationSetEventDestinationKinesisFirehoseDestinationArgs:
    def __init__(__self__, *,
                 delivery_stream_arn: pulumi.Input[str],
                 i_am_role_arn: pulumi.Input[str]):
        """
        An object that contains the delivery stream ARN and the IAM role ARN associated with an Amazon Kinesis Firehose event destination.
        :param pulumi.Input[str] delivery_stream_arn: The ARN of the Amazon Kinesis Firehose stream that email sending events should be published to.
        :param pulumi.Input[str] i_am_role_arn: The ARN of the IAM role under which Amazon SES publishes email sending events to the Amazon Kinesis Firehose stream.
        """
        pulumi.set(__self__, "delivery_stream_arn", delivery_stream_arn)
        pulumi.set(__self__, "i_am_role_arn", i_am_role_arn)

    @property
    @pulumi.getter(name="deliveryStreamARN")
    def delivery_stream_arn(self) -> pulumi.Input[str]:
        """
        The ARN of the Amazon Kinesis Firehose stream that email sending events should be published to.
        """
        return pulumi.get(self, "delivery_stream_arn")

    @delivery_stream_arn.setter
    def delivery_stream_arn(self, value: pulumi.Input[str]):
        pulumi.set(self, "delivery_stream_arn", value)

    @property
    @pulumi.getter(name="iAMRoleARN")
    def i_am_role_arn(self) -> pulumi.Input[str]:
        """
        The ARN of the IAM role under which Amazon SES publishes email sending events to the Amazon Kinesis Firehose stream.
        """
        return pulumi.get(self, "i_am_role_arn")

    @i_am_role_arn.setter
    def i_am_role_arn(self, value: pulumi.Input[str]):
        pulumi.set(self, "i_am_role_arn", value)


@pulumi.input_type
class ConfigurationSetEventDestinationSnsDestinationArgs:
    def __init__(__self__, *,
                 topic_arn: pulumi.Input[str]):
        """
        An object that contains SNS topic ARN associated event destination.
        """
        pulumi.set(__self__, "topic_arn", topic_arn)

    @property
    @pulumi.getter(name="topicARN")
    def topic_arn(self) -> pulumi.Input[str]:
        return pulumi.get(self, "topic_arn")

    @topic_arn.setter
    def topic_arn(self, value: pulumi.Input[str]):
        pulumi.set(self, "topic_arn", value)


@pulumi.input_type
class ConfigurationSetReputationOptionsArgs:
    def __init__(__self__, *,
                 reputation_metrics_enabled: Optional[pulumi.Input[bool]] = None):
        """
        An object that defines whether or not Amazon SES collects reputation metrics for the emails that you send that use the configuration set.
        :param pulumi.Input[bool] reputation_metrics_enabled: If true , tracking of reputation metrics is enabled for the configuration set. If false , tracking of reputation metrics is disabled for the configuration set.
        """
        if reputation_metrics_enabled is not None:
            pulumi.set(__self__, "reputation_metrics_enabled", reputation_metrics_enabled)

    @property
    @pulumi.getter(name="reputationMetricsEnabled")
    def reputation_metrics_enabled(self) -> Optional[pulumi.Input[bool]]:
        """
        If true , tracking of reputation metrics is enabled for the configuration set. If false , tracking of reputation metrics is disabled for the configuration set.
        """
        return pulumi.get(self, "reputation_metrics_enabled")

    @reputation_metrics_enabled.setter
    def reputation_metrics_enabled(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "reputation_metrics_enabled", value)


@pulumi.input_type
class ConfigurationSetSendingOptionsArgs:
    def __init__(__self__, *,
                 sending_enabled: Optional[pulumi.Input[bool]] = None):
        """
        An object that defines whether or not Amazon SES can send email that you send using the configuration set.
        """
        if sending_enabled is not None:
            pulumi.set(__self__, "sending_enabled", sending_enabled)

    @property
    @pulumi.getter(name="sendingEnabled")
    def sending_enabled(self) -> Optional[pulumi.Input[bool]]:
        return pulumi.get(self, "sending_enabled")

    @sending_enabled.setter
    def sending_enabled(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "sending_enabled", value)


@pulumi.input_type
class ConfigurationSetSuppressionOptionsArgs:
    def __init__(__self__, *,
                 suppressed_reasons: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None):
        """
        An object that contains information about the suppression list preferences for your account.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] suppressed_reasons: A list that contains the reasons that email addresses are automatically added to the suppression list for your account.
        """
        if suppressed_reasons is not None:
            pulumi.set(__self__, "suppressed_reasons", suppressed_reasons)

    @property
    @pulumi.getter(name="suppressedReasons")
    def suppressed_reasons(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        A list that contains the reasons that email addresses are automatically added to the suppression list for your account.
        """
        return pulumi.get(self, "suppressed_reasons")

    @suppressed_reasons.setter
    def suppressed_reasons(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "suppressed_reasons", value)


@pulumi.input_type
class ConfigurationSetTrackingOptionsArgs:
    def __init__(__self__, *,
                 custom_redirect_domain: Optional[pulumi.Input[str]] = None):
        """
        An object that defines the open and click tracking options for emails that you send using the configuration set.
        :param pulumi.Input[str] custom_redirect_domain: The domain to use for tracking open and click events.
        """
        if custom_redirect_domain is not None:
            pulumi.set(__self__, "custom_redirect_domain", custom_redirect_domain)

    @property
    @pulumi.getter(name="customRedirectDomain")
    def custom_redirect_domain(self) -> Optional[pulumi.Input[str]]:
        """
        The domain to use for tracking open and click events.
        """
        return pulumi.get(self, "custom_redirect_domain")

    @custom_redirect_domain.setter
    def custom_redirect_domain(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "custom_redirect_domain", value)


@pulumi.input_type
class ContactListTagArgs:
    def __init__(__self__, *,
                 key: pulumi.Input[str],
                 value: pulumi.Input[str]):
        pulumi.set(__self__, "key", key)
        pulumi.set(__self__, "value", value)

    @property
    @pulumi.getter
    def key(self) -> pulumi.Input[str]:
        return pulumi.get(self, "key")

    @key.setter
    def key(self, value: pulumi.Input[str]):
        pulumi.set(self, "key", value)

    @property
    @pulumi.getter
    def value(self) -> pulumi.Input[str]:
        return pulumi.get(self, "value")

    @value.setter
    def value(self, value: pulumi.Input[str]):
        pulumi.set(self, "value", value)


@pulumi.input_type
class ContactListTopicArgs:
    def __init__(__self__, *,
                 default_subscription_status: pulumi.Input[str],
                 display_name: pulumi.Input[str],
                 topic_name: pulumi.Input[str],
                 description: Optional[pulumi.Input[str]] = None):
        """
        :param pulumi.Input[str] display_name: The display name of the topic.
        :param pulumi.Input[str] topic_name: The name of the topic.
        :param pulumi.Input[str] description: The description of the topic.
        """
        pulumi.set(__self__, "default_subscription_status", default_subscription_status)
        pulumi.set(__self__, "display_name", display_name)
        pulumi.set(__self__, "topic_name", topic_name)
        if description is not None:
            pulumi.set(__self__, "description", description)

    @property
    @pulumi.getter(name="defaultSubscriptionStatus")
    def default_subscription_status(self) -> pulumi.Input[str]:
        return pulumi.get(self, "default_subscription_status")

    @default_subscription_status.setter
    def default_subscription_status(self, value: pulumi.Input[str]):
        pulumi.set(self, "default_subscription_status", value)

    @property
    @pulumi.getter(name="displayName")
    def display_name(self) -> pulumi.Input[str]:
        """
        The display name of the topic.
        """
        return pulumi.get(self, "display_name")

    @display_name.setter
    def display_name(self, value: pulumi.Input[str]):
        pulumi.set(self, "display_name", value)

    @property
    @pulumi.getter(name="topicName")
    def topic_name(self) -> pulumi.Input[str]:
        """
        The name of the topic.
        """
        return pulumi.get(self, "topic_name")

    @topic_name.setter
    def topic_name(self, value: pulumi.Input[str]):
        pulumi.set(self, "topic_name", value)

    @property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[str]]:
        """
        The description of the topic.
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "description", value)


@pulumi.input_type
class ReceiptFilterFilterArgs:
    def __init__(__self__, *,
                 ip_filter: pulumi.Input['ReceiptFilterIpFilterArgs'],
                 name: Optional[pulumi.Input[str]] = None):
        pulumi.set(__self__, "ip_filter", ip_filter)
        if name is not None:
            pulumi.set(__self__, "name", name)

    @property
    @pulumi.getter(name="ipFilter")
    def ip_filter(self) -> pulumi.Input['ReceiptFilterIpFilterArgs']:
        return pulumi.get(self, "ip_filter")

    @ip_filter.setter
    def ip_filter(self, value: pulumi.Input['ReceiptFilterIpFilterArgs']):
        pulumi.set(self, "ip_filter", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[str]]:
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "name", value)


@pulumi.input_type
class ReceiptFilterIpFilterArgs:
    def __init__(__self__, *,
                 cidr: pulumi.Input[str],
                 policy: pulumi.Input[str]):
        pulumi.set(__self__, "cidr", cidr)
        pulumi.set(__self__, "policy", policy)

    @property
    @pulumi.getter
    def cidr(self) -> pulumi.Input[str]:
        return pulumi.get(self, "cidr")

    @cidr.setter
    def cidr(self, value: pulumi.Input[str]):
        pulumi.set(self, "cidr", value)

    @property
    @pulumi.getter
    def policy(self) -> pulumi.Input[str]:
        return pulumi.get(self, "policy")

    @policy.setter
    def policy(self, value: pulumi.Input[str]):
        pulumi.set(self, "policy", value)


@pulumi.input_type
class ReceiptRuleActionArgs:
    def __init__(__self__, *,
                 add_header_action: Optional[pulumi.Input['ReceiptRuleAddHeaderActionArgs']] = None,
                 bounce_action: Optional[pulumi.Input['ReceiptRuleBounceActionArgs']] = None,
                 lambda_action: Optional[pulumi.Input['ReceiptRuleLambdaActionArgs']] = None,
                 s3_action: Optional[pulumi.Input['ReceiptRuleS3ActionArgs']] = None,
                 s_ns_action: Optional[pulumi.Input['ReceiptRuleSNSActionArgs']] = None,
                 stop_action: Optional[pulumi.Input['ReceiptRuleStopActionArgs']] = None,
                 workmail_action: Optional[pulumi.Input['ReceiptRuleWorkmailActionArgs']] = None):
        if add_header_action is not None:
            pulumi.set(__self__, "add_header_action", add_header_action)
        if bounce_action is not None:
            pulumi.set(__self__, "bounce_action", bounce_action)
        if lambda_action is not None:
            pulumi.set(__self__, "lambda_action", lambda_action)
        if s3_action is not None:
            pulumi.set(__self__, "s3_action", s3_action)
        if s_ns_action is not None:
            pulumi.set(__self__, "s_ns_action", s_ns_action)
        if stop_action is not None:
            pulumi.set(__self__, "stop_action", stop_action)
        if workmail_action is not None:
            pulumi.set(__self__, "workmail_action", workmail_action)

    @property
    @pulumi.getter(name="addHeaderAction")
    def add_header_action(self) -> Optional[pulumi.Input['ReceiptRuleAddHeaderActionArgs']]:
        return pulumi.get(self, "add_header_action")

    @add_header_action.setter
    def add_header_action(self, value: Optional[pulumi.Input['ReceiptRuleAddHeaderActionArgs']]):
        pulumi.set(self, "add_header_action", value)

    @property
    @pulumi.getter(name="bounceAction")
    def bounce_action(self) -> Optional[pulumi.Input['ReceiptRuleBounceActionArgs']]:
        return pulumi.get(self, "bounce_action")

    @bounce_action.setter
    def bounce_action(self, value: Optional[pulumi.Input['ReceiptRuleBounceActionArgs']]):
        pulumi.set(self, "bounce_action", value)

    @property
    @pulumi.getter(name="lambdaAction")
    def lambda_action(self) -> Optional[pulumi.Input['ReceiptRuleLambdaActionArgs']]:
        return pulumi.get(self, "lambda_action")

    @lambda_action.setter
    def lambda_action(self, value: Optional[pulumi.Input['ReceiptRuleLambdaActionArgs']]):
        pulumi.set(self, "lambda_action", value)

    @property
    @pulumi.getter(name="s3Action")
    def s3_action(self) -> Optional[pulumi.Input['ReceiptRuleS3ActionArgs']]:
        return pulumi.get(self, "s3_action")

    @s3_action.setter
    def s3_action(self, value: Optional[pulumi.Input['ReceiptRuleS3ActionArgs']]):
        pulumi.set(self, "s3_action", value)

    @property
    @pulumi.getter(name="sNSAction")
    def s_ns_action(self) -> Optional[pulumi.Input['ReceiptRuleSNSActionArgs']]:
        return pulumi.get(self, "s_ns_action")

    @s_ns_action.setter
    def s_ns_action(self, value: Optional[pulumi.Input['ReceiptRuleSNSActionArgs']]):
        pulumi.set(self, "s_ns_action", value)

    @property
    @pulumi.getter(name="stopAction")
    def stop_action(self) -> Optional[pulumi.Input['ReceiptRuleStopActionArgs']]:
        return pulumi.get(self, "stop_action")

    @stop_action.setter
    def stop_action(self, value: Optional[pulumi.Input['ReceiptRuleStopActionArgs']]):
        pulumi.set(self, "stop_action", value)

    @property
    @pulumi.getter(name="workmailAction")
    def workmail_action(self) -> Optional[pulumi.Input['ReceiptRuleWorkmailActionArgs']]:
        return pulumi.get(self, "workmail_action")

    @workmail_action.setter
    def workmail_action(self, value: Optional[pulumi.Input['ReceiptRuleWorkmailActionArgs']]):
        pulumi.set(self, "workmail_action", value)


@pulumi.input_type
class ReceiptRuleAddHeaderActionArgs:
    def __init__(__self__, *,
                 header_name: pulumi.Input[str],
                 header_value: pulumi.Input[str]):
        pulumi.set(__self__, "header_name", header_name)
        pulumi.set(__self__, "header_value", header_value)

    @property
    @pulumi.getter(name="headerName")
    def header_name(self) -> pulumi.Input[str]:
        return pulumi.get(self, "header_name")

    @header_name.setter
    def header_name(self, value: pulumi.Input[str]):
        pulumi.set(self, "header_name", value)

    @property
    @pulumi.getter(name="headerValue")
    def header_value(self) -> pulumi.Input[str]:
        return pulumi.get(self, "header_value")

    @header_value.setter
    def header_value(self, value: pulumi.Input[str]):
        pulumi.set(self, "header_value", value)


@pulumi.input_type
class ReceiptRuleBounceActionArgs:
    def __init__(__self__, *,
                 message: pulumi.Input[str],
                 sender: pulumi.Input[str],
                 smtp_reply_code: pulumi.Input[str],
                 status_code: Optional[pulumi.Input[str]] = None,
                 topic_arn: Optional[pulumi.Input[str]] = None):
        pulumi.set(__self__, "message", message)
        pulumi.set(__self__, "sender", sender)
        pulumi.set(__self__, "smtp_reply_code", smtp_reply_code)
        if status_code is not None:
            pulumi.set(__self__, "status_code", status_code)
        if topic_arn is not None:
            pulumi.set(__self__, "topic_arn", topic_arn)

    @property
    @pulumi.getter
    def message(self) -> pulumi.Input[str]:
        return pulumi.get(self, "message")

    @message.setter
    def message(self, value: pulumi.Input[str]):
        pulumi.set(self, "message", value)

    @property
    @pulumi.getter
    def sender(self) -> pulumi.Input[str]:
        return pulumi.get(self, "sender")

    @sender.setter
    def sender(self, value: pulumi.Input[str]):
        pulumi.set(self, "sender", value)

    @property
    @pulumi.getter(name="smtpReplyCode")
    def smtp_reply_code(self) -> pulumi.Input[str]:
        return pulumi.get(self, "smtp_reply_code")

    @smtp_reply_code.setter
    def smtp_reply_code(self, value: pulumi.Input[str]):
        pulumi.set(self, "smtp_reply_code", value)

    @property
    @pulumi.getter(name="statusCode")
    def status_code(self) -> Optional[pulumi.Input[str]]:
        return pulumi.get(self, "status_code")

    @status_code.setter
    def status_code(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "status_code", value)

    @property
    @pulumi.getter(name="topicArn")
    def topic_arn(self) -> Optional[pulumi.Input[str]]:
        return pulumi.get(self, "topic_arn")

    @topic_arn.setter
    def topic_arn(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "topic_arn", value)


@pulumi.input_type
class ReceiptRuleLambdaActionArgs:
    def __init__(__self__, *,
                 function_arn: pulumi.Input[str],
                 invocation_type: Optional[pulumi.Input[str]] = None,
                 topic_arn: Optional[pulumi.Input[str]] = None):
        pulumi.set(__self__, "function_arn", function_arn)
        if invocation_type is not None:
            pulumi.set(__self__, "invocation_type", invocation_type)
        if topic_arn is not None:
            pulumi.set(__self__, "topic_arn", topic_arn)

    @property
    @pulumi.getter(name="functionArn")
    def function_arn(self) -> pulumi.Input[str]:
        return pulumi.get(self, "function_arn")

    @function_arn.setter
    def function_arn(self, value: pulumi.Input[str]):
        pulumi.set(self, "function_arn", value)

    @property
    @pulumi.getter(name="invocationType")
    def invocation_type(self) -> Optional[pulumi.Input[str]]:
        return pulumi.get(self, "invocation_type")

    @invocation_type.setter
    def invocation_type(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "invocation_type", value)

    @property
    @pulumi.getter(name="topicArn")
    def topic_arn(self) -> Optional[pulumi.Input[str]]:
        return pulumi.get(self, "topic_arn")

    @topic_arn.setter
    def topic_arn(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "topic_arn", value)


@pulumi.input_type
class ReceiptRuleRuleArgs:
    def __init__(__self__, *,
                 actions: Optional[pulumi.Input[Sequence[pulumi.Input['ReceiptRuleActionArgs']]]] = None,
                 enabled: Optional[pulumi.Input[bool]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 recipients: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 scan_enabled: Optional[pulumi.Input[bool]] = None,
                 tls_policy: Optional[pulumi.Input[str]] = None):
        if actions is not None:
            pulumi.set(__self__, "actions", actions)
        if enabled is not None:
            pulumi.set(__self__, "enabled", enabled)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if recipients is not None:
            pulumi.set(__self__, "recipients", recipients)
        if scan_enabled is not None:
            pulumi.set(__self__, "scan_enabled", scan_enabled)
        if tls_policy is not None:
            pulumi.set(__self__, "tls_policy", tls_policy)

    @property
    @pulumi.getter
    def actions(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['ReceiptRuleActionArgs']]]]:
        return pulumi.get(self, "actions")

    @actions.setter
    def actions(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['ReceiptRuleActionArgs']]]]):
        pulumi.set(self, "actions", value)

    @property
    @pulumi.getter
    def enabled(self) -> Optional[pulumi.Input[bool]]:
        return pulumi.get(self, "enabled")

    @enabled.setter
    def enabled(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "enabled", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[str]]:
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter
    def recipients(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        return pulumi.get(self, "recipients")

    @recipients.setter
    def recipients(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "recipients", value)

    @property
    @pulumi.getter(name="scanEnabled")
    def scan_enabled(self) -> Optional[pulumi.Input[bool]]:
        return pulumi.get(self, "scan_enabled")

    @scan_enabled.setter
    def scan_enabled(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "scan_enabled", value)

    @property
    @pulumi.getter(name="tlsPolicy")
    def tls_policy(self) -> Optional[pulumi.Input[str]]:
        return pulumi.get(self, "tls_policy")

    @tls_policy.setter
    def tls_policy(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "tls_policy", value)


@pulumi.input_type
class ReceiptRuleS3ActionArgs:
    def __init__(__self__, *,
                 bucket_name: pulumi.Input[str],
                 kms_key_arn: Optional[pulumi.Input[str]] = None,
                 object_key_prefix: Optional[pulumi.Input[str]] = None,
                 topic_arn: Optional[pulumi.Input[str]] = None):
        pulumi.set(__self__, "bucket_name", bucket_name)
        if kms_key_arn is not None:
            pulumi.set(__self__, "kms_key_arn", kms_key_arn)
        if object_key_prefix is not None:
            pulumi.set(__self__, "object_key_prefix", object_key_prefix)
        if topic_arn is not None:
            pulumi.set(__self__, "topic_arn", topic_arn)

    @property
    @pulumi.getter(name="bucketName")
    def bucket_name(self) -> pulumi.Input[str]:
        return pulumi.get(self, "bucket_name")

    @bucket_name.setter
    def bucket_name(self, value: pulumi.Input[str]):
        pulumi.set(self, "bucket_name", value)

    @property
    @pulumi.getter(name="kmsKeyArn")
    def kms_key_arn(self) -> Optional[pulumi.Input[str]]:
        return pulumi.get(self, "kms_key_arn")

    @kms_key_arn.setter
    def kms_key_arn(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "kms_key_arn", value)

    @property
    @pulumi.getter(name="objectKeyPrefix")
    def object_key_prefix(self) -> Optional[pulumi.Input[str]]:
        return pulumi.get(self, "object_key_prefix")

    @object_key_prefix.setter
    def object_key_prefix(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "object_key_prefix", value)

    @property
    @pulumi.getter(name="topicArn")
    def topic_arn(self) -> Optional[pulumi.Input[str]]:
        return pulumi.get(self, "topic_arn")

    @topic_arn.setter
    def topic_arn(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "topic_arn", value)


@pulumi.input_type
class ReceiptRuleSNSActionArgs:
    def __init__(__self__, *,
                 encoding: Optional[pulumi.Input[str]] = None,
                 topic_arn: Optional[pulumi.Input[str]] = None):
        if encoding is not None:
            pulumi.set(__self__, "encoding", encoding)
        if topic_arn is not None:
            pulumi.set(__self__, "topic_arn", topic_arn)

    @property
    @pulumi.getter
    def encoding(self) -> Optional[pulumi.Input[str]]:
        return pulumi.get(self, "encoding")

    @encoding.setter
    def encoding(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "encoding", value)

    @property
    @pulumi.getter(name="topicArn")
    def topic_arn(self) -> Optional[pulumi.Input[str]]:
        return pulumi.get(self, "topic_arn")

    @topic_arn.setter
    def topic_arn(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "topic_arn", value)


@pulumi.input_type
class ReceiptRuleStopActionArgs:
    def __init__(__self__, *,
                 scope: pulumi.Input[str],
                 topic_arn: Optional[pulumi.Input[str]] = None):
        pulumi.set(__self__, "scope", scope)
        if topic_arn is not None:
            pulumi.set(__self__, "topic_arn", topic_arn)

    @property
    @pulumi.getter
    def scope(self) -> pulumi.Input[str]:
        return pulumi.get(self, "scope")

    @scope.setter
    def scope(self, value: pulumi.Input[str]):
        pulumi.set(self, "scope", value)

    @property
    @pulumi.getter(name="topicArn")
    def topic_arn(self) -> Optional[pulumi.Input[str]]:
        return pulumi.get(self, "topic_arn")

    @topic_arn.setter
    def topic_arn(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "topic_arn", value)


@pulumi.input_type
class ReceiptRuleWorkmailActionArgs:
    def __init__(__self__, *,
                 organization_arn: pulumi.Input[str],
                 topic_arn: Optional[pulumi.Input[str]] = None):
        pulumi.set(__self__, "organization_arn", organization_arn)
        if topic_arn is not None:
            pulumi.set(__self__, "topic_arn", topic_arn)

    @property
    @pulumi.getter(name="organizationArn")
    def organization_arn(self) -> pulumi.Input[str]:
        return pulumi.get(self, "organization_arn")

    @organization_arn.setter
    def organization_arn(self, value: pulumi.Input[str]):
        pulumi.set(self, "organization_arn", value)

    @property
    @pulumi.getter(name="topicArn")
    def topic_arn(self) -> Optional[pulumi.Input[str]]:
        return pulumi.get(self, "topic_arn")

    @topic_arn.setter
    def topic_arn(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "topic_arn", value)


@pulumi.input_type
class TemplateArgs:
    def __init__(__self__, *,
                 subject_part: pulumi.Input[str],
                 html_part: Optional[pulumi.Input[str]] = None,
                 template_name: Optional[pulumi.Input[str]] = None,
                 text_part: Optional[pulumi.Input[str]] = None):
        """
        The content of the email, composed of a subject line, an HTML part, and a text-only part
        :param pulumi.Input[str] subject_part: The subject line of the email.
        :param pulumi.Input[str] html_part: The HTML body of the email.
        :param pulumi.Input[str] template_name: The name of the template.
        :param pulumi.Input[str] text_part: The email body that is visible to recipients whose email clients do not display HTML content.
        """
        pulumi.set(__self__, "subject_part", subject_part)
        if html_part is not None:
            pulumi.set(__self__, "html_part", html_part)
        if template_name is not None:
            pulumi.set(__self__, "template_name", template_name)
        if text_part is not None:
            pulumi.set(__self__, "text_part", text_part)

    @property
    @pulumi.getter(name="subjectPart")
    def subject_part(self) -> pulumi.Input[str]:
        """
        The subject line of the email.
        """
        return pulumi.get(self, "subject_part")

    @subject_part.setter
    def subject_part(self, value: pulumi.Input[str]):
        pulumi.set(self, "subject_part", value)

    @property
    @pulumi.getter(name="htmlPart")
    def html_part(self) -> Optional[pulumi.Input[str]]:
        """
        The HTML body of the email.
        """
        return pulumi.get(self, "html_part")

    @html_part.setter
    def html_part(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "html_part", value)

    @property
    @pulumi.getter(name="templateName")
    def template_name(self) -> Optional[pulumi.Input[str]]:
        """
        The name of the template.
        """
        return pulumi.get(self, "template_name")

    @template_name.setter
    def template_name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "template_name", value)

    @property
    @pulumi.getter(name="textPart")
    def text_part(self) -> Optional[pulumi.Input[str]]:
        """
        The email body that is visible to recipients whose email clients do not display HTML content.
        """
        return pulumi.get(self, "text_part")

    @text_part.setter
    def text_part(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "text_part", value)


