# coding=utf-8
# *** WARNING: this file was generated by the Pulumi SDK Generator. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from .. import _utilities
from . import outputs
from ._enums import *
from ._inputs import *

__all__ = ['NamespaceArgs', 'Namespace']

@pulumi.input_type
class NamespaceArgs:
    def __init__(__self__, *,
                 admin_user_password: Optional[pulumi.Input[str]] = None,
                 admin_username: Optional[pulumi.Input[str]] = None,
                 db_name: Optional[pulumi.Input[str]] = None,
                 default_iam_role_arn: Optional[pulumi.Input[str]] = None,
                 final_snapshot_name: Optional[pulumi.Input[str]] = None,
                 final_snapshot_retention_period: Optional[pulumi.Input[int]] = None,
                 iam_roles: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 kms_key_id: Optional[pulumi.Input[str]] = None,
                 log_exports: Optional[pulumi.Input[Sequence[pulumi.Input['NamespaceLogExport']]]] = None,
                 namespace_name: Optional[pulumi.Input[str]] = None,
                 tags: Optional[pulumi.Input[Sequence[pulumi.Input['NamespaceTagArgs']]]] = None):
        """
        The set of arguments for constructing a Namespace resource.
        :param pulumi.Input[str] admin_user_password: The password associated with the admin user for the namespace that is being created. Password must be at least 8 characters in length, should be any printable ASCII character. Must contain at least one lowercase letter, one uppercase letter and one decimal digit.
        :param pulumi.Input[str] admin_username: The user name associated with the admin user for the namespace that is being created. Only alphanumeric characters and underscores are allowed. It should start with an alphabet.
        :param pulumi.Input[str] db_name: The database name associated for the namespace that is being created. Only alphanumeric characters and underscores are allowed. It should start with an alphabet.
        :param pulumi.Input[str] default_iam_role_arn: The default IAM role ARN for the namespace that is being created.
        :param pulumi.Input[str] final_snapshot_name: The name of the namespace the source snapshot was created from. Please specify the name if needed before deleting namespace
        :param pulumi.Input[int] final_snapshot_retention_period: The number of days to retain automated snapshot in the destination region after they are copied from the source region. If the value is -1, the manual snapshot is retained indefinitely. The value must be either -1 or an integer between 1 and 3,653.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] iam_roles: A list of AWS Identity and Access Management (IAM) roles that can be used by the namespace to access other AWS services. You must supply the IAM roles in their Amazon Resource Name (ARN) format. The Default role limit for each request is 10.
        :param pulumi.Input[str] kms_key_id: The AWS Key Management Service (KMS) key ID of the encryption key that you want to use to encrypt data in the namespace.
        :param pulumi.Input[Sequence[pulumi.Input['NamespaceLogExport']]] log_exports: The collection of log types to be exported provided by the customer. Should only be one of the three supported log types: userlog, useractivitylog and connectionlog
        :param pulumi.Input[str] namespace_name: A unique identifier for the namespace. You use this identifier to refer to the namespace for any subsequent namespace operations such as deleting or modifying. All alphabetical characters must be lower case. Namespace name should be unique for all namespaces within an AWS account.
        :param pulumi.Input[Sequence[pulumi.Input['NamespaceTagArgs']]] tags: The list of tags for the namespace.
        """
        if admin_user_password is not None:
            pulumi.set(__self__, "admin_user_password", admin_user_password)
        if admin_username is not None:
            pulumi.set(__self__, "admin_username", admin_username)
        if db_name is not None:
            pulumi.set(__self__, "db_name", db_name)
        if default_iam_role_arn is not None:
            pulumi.set(__self__, "default_iam_role_arn", default_iam_role_arn)
        if final_snapshot_name is not None:
            pulumi.set(__self__, "final_snapshot_name", final_snapshot_name)
        if final_snapshot_retention_period is not None:
            pulumi.set(__self__, "final_snapshot_retention_period", final_snapshot_retention_period)
        if iam_roles is not None:
            pulumi.set(__self__, "iam_roles", iam_roles)
        if kms_key_id is not None:
            pulumi.set(__self__, "kms_key_id", kms_key_id)
        if log_exports is not None:
            pulumi.set(__self__, "log_exports", log_exports)
        if namespace_name is not None:
            pulumi.set(__self__, "namespace_name", namespace_name)
        if tags is not None:
            pulumi.set(__self__, "tags", tags)

    @property
    @pulumi.getter(name="adminUserPassword")
    def admin_user_password(self) -> Optional[pulumi.Input[str]]:
        """
        The password associated with the admin user for the namespace that is being created. Password must be at least 8 characters in length, should be any printable ASCII character. Must contain at least one lowercase letter, one uppercase letter and one decimal digit.
        """
        return pulumi.get(self, "admin_user_password")

    @admin_user_password.setter
    def admin_user_password(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "admin_user_password", value)

    @property
    @pulumi.getter(name="adminUsername")
    def admin_username(self) -> Optional[pulumi.Input[str]]:
        """
        The user name associated with the admin user for the namespace that is being created. Only alphanumeric characters and underscores are allowed. It should start with an alphabet.
        """
        return pulumi.get(self, "admin_username")

    @admin_username.setter
    def admin_username(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "admin_username", value)

    @property
    @pulumi.getter(name="dbName")
    def db_name(self) -> Optional[pulumi.Input[str]]:
        """
        The database name associated for the namespace that is being created. Only alphanumeric characters and underscores are allowed. It should start with an alphabet.
        """
        return pulumi.get(self, "db_name")

    @db_name.setter
    def db_name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "db_name", value)

    @property
    @pulumi.getter(name="defaultIamRoleArn")
    def default_iam_role_arn(self) -> Optional[pulumi.Input[str]]:
        """
        The default IAM role ARN for the namespace that is being created.
        """
        return pulumi.get(self, "default_iam_role_arn")

    @default_iam_role_arn.setter
    def default_iam_role_arn(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "default_iam_role_arn", value)

    @property
    @pulumi.getter(name="finalSnapshotName")
    def final_snapshot_name(self) -> Optional[pulumi.Input[str]]:
        """
        The name of the namespace the source snapshot was created from. Please specify the name if needed before deleting namespace
        """
        return pulumi.get(self, "final_snapshot_name")

    @final_snapshot_name.setter
    def final_snapshot_name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "final_snapshot_name", value)

    @property
    @pulumi.getter(name="finalSnapshotRetentionPeriod")
    def final_snapshot_retention_period(self) -> Optional[pulumi.Input[int]]:
        """
        The number of days to retain automated snapshot in the destination region after they are copied from the source region. If the value is -1, the manual snapshot is retained indefinitely. The value must be either -1 or an integer between 1 and 3,653.
        """
        return pulumi.get(self, "final_snapshot_retention_period")

    @final_snapshot_retention_period.setter
    def final_snapshot_retention_period(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "final_snapshot_retention_period", value)

    @property
    @pulumi.getter(name="iamRoles")
    def iam_roles(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        A list of AWS Identity and Access Management (IAM) roles that can be used by the namespace to access other AWS services. You must supply the IAM roles in their Amazon Resource Name (ARN) format. The Default role limit for each request is 10.
        """
        return pulumi.get(self, "iam_roles")

    @iam_roles.setter
    def iam_roles(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "iam_roles", value)

    @property
    @pulumi.getter(name="kmsKeyId")
    def kms_key_id(self) -> Optional[pulumi.Input[str]]:
        """
        The AWS Key Management Service (KMS) key ID of the encryption key that you want to use to encrypt data in the namespace.
        """
        return pulumi.get(self, "kms_key_id")

    @kms_key_id.setter
    def kms_key_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "kms_key_id", value)

    @property
    @pulumi.getter(name="logExports")
    def log_exports(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['NamespaceLogExport']]]]:
        """
        The collection of log types to be exported provided by the customer. Should only be one of the three supported log types: userlog, useractivitylog and connectionlog
        """
        return pulumi.get(self, "log_exports")

    @log_exports.setter
    def log_exports(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['NamespaceLogExport']]]]):
        pulumi.set(self, "log_exports", value)

    @property
    @pulumi.getter(name="namespaceName")
    def namespace_name(self) -> Optional[pulumi.Input[str]]:
        """
        A unique identifier for the namespace. You use this identifier to refer to the namespace for any subsequent namespace operations such as deleting or modifying. All alphabetical characters must be lower case. Namespace name should be unique for all namespaces within an AWS account.
        """
        return pulumi.get(self, "namespace_name")

    @namespace_name.setter
    def namespace_name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "namespace_name", value)

    @property
    @pulumi.getter
    def tags(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['NamespaceTagArgs']]]]:
        """
        The list of tags for the namespace.
        """
        return pulumi.get(self, "tags")

    @tags.setter
    def tags(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['NamespaceTagArgs']]]]):
        pulumi.set(self, "tags", value)


class Namespace(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 admin_user_password: Optional[pulumi.Input[str]] = None,
                 admin_username: Optional[pulumi.Input[str]] = None,
                 db_name: Optional[pulumi.Input[str]] = None,
                 default_iam_role_arn: Optional[pulumi.Input[str]] = None,
                 final_snapshot_name: Optional[pulumi.Input[str]] = None,
                 final_snapshot_retention_period: Optional[pulumi.Input[int]] = None,
                 iam_roles: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 kms_key_id: Optional[pulumi.Input[str]] = None,
                 log_exports: Optional[pulumi.Input[Sequence[pulumi.Input['NamespaceLogExport']]]] = None,
                 namespace_name: Optional[pulumi.Input[str]] = None,
                 tags: Optional[pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['NamespaceTagArgs']]]]] = None,
                 __props__=None):
        """
        Definition of AWS::RedshiftServerless::Namespace Resource Type

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[str] admin_user_password: The password associated with the admin user for the namespace that is being created. Password must be at least 8 characters in length, should be any printable ASCII character. Must contain at least one lowercase letter, one uppercase letter and one decimal digit.
        :param pulumi.Input[str] admin_username: The user name associated with the admin user for the namespace that is being created. Only alphanumeric characters and underscores are allowed. It should start with an alphabet.
        :param pulumi.Input[str] db_name: The database name associated for the namespace that is being created. Only alphanumeric characters and underscores are allowed. It should start with an alphabet.
        :param pulumi.Input[str] default_iam_role_arn: The default IAM role ARN for the namespace that is being created.
        :param pulumi.Input[str] final_snapshot_name: The name of the namespace the source snapshot was created from. Please specify the name if needed before deleting namespace
        :param pulumi.Input[int] final_snapshot_retention_period: The number of days to retain automated snapshot in the destination region after they are copied from the source region. If the value is -1, the manual snapshot is retained indefinitely. The value must be either -1 or an integer between 1 and 3,653.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] iam_roles: A list of AWS Identity and Access Management (IAM) roles that can be used by the namespace to access other AWS services. You must supply the IAM roles in their Amazon Resource Name (ARN) format. The Default role limit for each request is 10.
        :param pulumi.Input[str] kms_key_id: The AWS Key Management Service (KMS) key ID of the encryption key that you want to use to encrypt data in the namespace.
        :param pulumi.Input[Sequence[pulumi.Input['NamespaceLogExport']]] log_exports: The collection of log types to be exported provided by the customer. Should only be one of the three supported log types: userlog, useractivitylog and connectionlog
        :param pulumi.Input[str] namespace_name: A unique identifier for the namespace. You use this identifier to refer to the namespace for any subsequent namespace operations such as deleting or modifying. All alphabetical characters must be lower case. Namespace name should be unique for all namespaces within an AWS account.
        :param pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['NamespaceTagArgs']]]] tags: The list of tags for the namespace.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: Optional[NamespaceArgs] = None,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Definition of AWS::RedshiftServerless::Namespace Resource Type

        :param str resource_name: The name of the resource.
        :param NamespaceArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(NamespaceArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 admin_user_password: Optional[pulumi.Input[str]] = None,
                 admin_username: Optional[pulumi.Input[str]] = None,
                 db_name: Optional[pulumi.Input[str]] = None,
                 default_iam_role_arn: Optional[pulumi.Input[str]] = None,
                 final_snapshot_name: Optional[pulumi.Input[str]] = None,
                 final_snapshot_retention_period: Optional[pulumi.Input[int]] = None,
                 iam_roles: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 kms_key_id: Optional[pulumi.Input[str]] = None,
                 log_exports: Optional[pulumi.Input[Sequence[pulumi.Input['NamespaceLogExport']]]] = None,
                 namespace_name: Optional[pulumi.Input[str]] = None,
                 tags: Optional[pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['NamespaceTagArgs']]]]] = None,
                 __props__=None):
        if opts is None:
            opts = pulumi.ResourceOptions()
        else:
            opts = copy.copy(opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.version is None:
            opts.version = _utilities.get_version()
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = NamespaceArgs.__new__(NamespaceArgs)

            __props__.__dict__["admin_user_password"] = admin_user_password
            __props__.__dict__["admin_username"] = admin_username
            __props__.__dict__["db_name"] = db_name
            __props__.__dict__["default_iam_role_arn"] = default_iam_role_arn
            __props__.__dict__["final_snapshot_name"] = final_snapshot_name
            __props__.__dict__["final_snapshot_retention_period"] = final_snapshot_retention_period
            __props__.__dict__["iam_roles"] = iam_roles
            __props__.__dict__["kms_key_id"] = kms_key_id
            __props__.__dict__["log_exports"] = log_exports
            __props__.__dict__["namespace_name"] = namespace_name
            __props__.__dict__["tags"] = tags
            __props__.__dict__["namespace"] = None
        super(Namespace, __self__).__init__(
            'aws-native:redshiftserverless:Namespace',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None) -> 'Namespace':
        """
        Get an existing Namespace resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = NamespaceArgs.__new__(NamespaceArgs)

        __props__.__dict__["admin_user_password"] = None
        __props__.__dict__["admin_username"] = None
        __props__.__dict__["db_name"] = None
        __props__.__dict__["default_iam_role_arn"] = None
        __props__.__dict__["final_snapshot_name"] = None
        __props__.__dict__["final_snapshot_retention_period"] = None
        __props__.__dict__["iam_roles"] = None
        __props__.__dict__["kms_key_id"] = None
        __props__.__dict__["log_exports"] = None
        __props__.__dict__["namespace"] = None
        __props__.__dict__["namespace_name"] = None
        __props__.__dict__["tags"] = None
        return Namespace(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter(name="adminUserPassword")
    def admin_user_password(self) -> pulumi.Output[Optional[str]]:
        """
        The password associated with the admin user for the namespace that is being created. Password must be at least 8 characters in length, should be any printable ASCII character. Must contain at least one lowercase letter, one uppercase letter and one decimal digit.
        """
        return pulumi.get(self, "admin_user_password")

    @property
    @pulumi.getter(name="adminUsername")
    def admin_username(self) -> pulumi.Output[Optional[str]]:
        """
        The user name associated with the admin user for the namespace that is being created. Only alphanumeric characters and underscores are allowed. It should start with an alphabet.
        """
        return pulumi.get(self, "admin_username")

    @property
    @pulumi.getter(name="dbName")
    def db_name(self) -> pulumi.Output[Optional[str]]:
        """
        The database name associated for the namespace that is being created. Only alphanumeric characters and underscores are allowed. It should start with an alphabet.
        """
        return pulumi.get(self, "db_name")

    @property
    @pulumi.getter(name="defaultIamRoleArn")
    def default_iam_role_arn(self) -> pulumi.Output[Optional[str]]:
        """
        The default IAM role ARN for the namespace that is being created.
        """
        return pulumi.get(self, "default_iam_role_arn")

    @property
    @pulumi.getter(name="finalSnapshotName")
    def final_snapshot_name(self) -> pulumi.Output[Optional[str]]:
        """
        The name of the namespace the source snapshot was created from. Please specify the name if needed before deleting namespace
        """
        return pulumi.get(self, "final_snapshot_name")

    @property
    @pulumi.getter(name="finalSnapshotRetentionPeriod")
    def final_snapshot_retention_period(self) -> pulumi.Output[Optional[int]]:
        """
        The number of days to retain automated snapshot in the destination region after they are copied from the source region. If the value is -1, the manual snapshot is retained indefinitely. The value must be either -1 or an integer between 1 and 3,653.
        """
        return pulumi.get(self, "final_snapshot_retention_period")

    @property
    @pulumi.getter(name="iamRoles")
    def iam_roles(self) -> pulumi.Output[Optional[Sequence[str]]]:
        """
        A list of AWS Identity and Access Management (IAM) roles that can be used by the namespace to access other AWS services. You must supply the IAM roles in their Amazon Resource Name (ARN) format. The Default role limit for each request is 10.
        """
        return pulumi.get(self, "iam_roles")

    @property
    @pulumi.getter(name="kmsKeyId")
    def kms_key_id(self) -> pulumi.Output[Optional[str]]:
        """
        The AWS Key Management Service (KMS) key ID of the encryption key that you want to use to encrypt data in the namespace.
        """
        return pulumi.get(self, "kms_key_id")

    @property
    @pulumi.getter(name="logExports")
    def log_exports(self) -> pulumi.Output[Optional[Sequence['NamespaceLogExport']]]:
        """
        The collection of log types to be exported provided by the customer. Should only be one of the three supported log types: userlog, useractivitylog and connectionlog
        """
        return pulumi.get(self, "log_exports")

    @property
    @pulumi.getter
    def namespace(self) -> pulumi.Output['outputs.Namespace']:
        return pulumi.get(self, "namespace")

    @property
    @pulumi.getter(name="namespaceName")
    def namespace_name(self) -> pulumi.Output[str]:
        """
        A unique identifier for the namespace. You use this identifier to refer to the namespace for any subsequent namespace operations such as deleting or modifying. All alphabetical characters must be lower case. Namespace name should be unique for all namespaces within an AWS account.
        """
        return pulumi.get(self, "namespace_name")

    @property
    @pulumi.getter
    def tags(self) -> pulumi.Output[Optional[Sequence['outputs.NamespaceTag']]]:
        """
        The list of tags for the namespace.
        """
        return pulumi.get(self, "tags")

