# coding=utf-8
# *** WARNING: this file was generated by the Pulumi SDK Generator. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from .. import _utilities

__all__ = ['LayerVersionPermissionArgs', 'LayerVersionPermission']

@pulumi.input_type
class LayerVersionPermissionArgs:
    def __init__(__self__, *,
                 action: pulumi.Input[str],
                 layer_version_arn: pulumi.Input[str],
                 principal: pulumi.Input[str],
                 organization_id: Optional[pulumi.Input[str]] = None):
        """
        The set of arguments for constructing a LayerVersionPermission resource.
        """
        pulumi.set(__self__, "action", action)
        pulumi.set(__self__, "layer_version_arn", layer_version_arn)
        pulumi.set(__self__, "principal", principal)
        if organization_id is not None:
            pulumi.set(__self__, "organization_id", organization_id)

    @property
    @pulumi.getter
    def action(self) -> pulumi.Input[str]:
        return pulumi.get(self, "action")

    @action.setter
    def action(self, value: pulumi.Input[str]):
        pulumi.set(self, "action", value)

    @property
    @pulumi.getter(name="layerVersionArn")
    def layer_version_arn(self) -> pulumi.Input[str]:
        return pulumi.get(self, "layer_version_arn")

    @layer_version_arn.setter
    def layer_version_arn(self, value: pulumi.Input[str]):
        pulumi.set(self, "layer_version_arn", value)

    @property
    @pulumi.getter
    def principal(self) -> pulumi.Input[str]:
        return pulumi.get(self, "principal")

    @principal.setter
    def principal(self, value: pulumi.Input[str]):
        pulumi.set(self, "principal", value)

    @property
    @pulumi.getter(name="organizationId")
    def organization_id(self) -> Optional[pulumi.Input[str]]:
        return pulumi.get(self, "organization_id")

    @organization_id.setter
    def organization_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "organization_id", value)


warnings.warn("""LayerVersionPermission is not yet supported by AWS Native, so its creation will currently fail. Please use the classic AWS provider, if possible.""", DeprecationWarning)


class LayerVersionPermission(pulumi.CustomResource):
    warnings.warn("""LayerVersionPermission is not yet supported by AWS Native, so its creation will currently fail. Please use the classic AWS provider, if possible.""", DeprecationWarning)

    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 action: Optional[pulumi.Input[str]] = None,
                 layer_version_arn: Optional[pulumi.Input[str]] = None,
                 organization_id: Optional[pulumi.Input[str]] = None,
                 principal: Optional[pulumi.Input[str]] = None,
                 __props__=None):
        """
        Resource Type definition for AWS::Lambda::LayerVersionPermission

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: LayerVersionPermissionArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Resource Type definition for AWS::Lambda::LayerVersionPermission

        :param str resource_name: The name of the resource.
        :param LayerVersionPermissionArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(LayerVersionPermissionArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 action: Optional[pulumi.Input[str]] = None,
                 layer_version_arn: Optional[pulumi.Input[str]] = None,
                 organization_id: Optional[pulumi.Input[str]] = None,
                 principal: Optional[pulumi.Input[str]] = None,
                 __props__=None):
        pulumi.log.warn("""LayerVersionPermission is deprecated: LayerVersionPermission is not yet supported by AWS Native, so its creation will currently fail. Please use the classic AWS provider, if possible.""")
        if opts is None:
            opts = pulumi.ResourceOptions()
        else:
            opts = copy.copy(opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.version is None:
            opts.version = _utilities.get_version()
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = LayerVersionPermissionArgs.__new__(LayerVersionPermissionArgs)

            if action is None and not opts.urn:
                raise TypeError("Missing required property 'action'")
            __props__.__dict__["action"] = action
            if layer_version_arn is None and not opts.urn:
                raise TypeError("Missing required property 'layer_version_arn'")
            __props__.__dict__["layer_version_arn"] = layer_version_arn
            __props__.__dict__["organization_id"] = organization_id
            if principal is None and not opts.urn:
                raise TypeError("Missing required property 'principal'")
            __props__.__dict__["principal"] = principal
        super(LayerVersionPermission, __self__).__init__(
            'aws-native:lambda:LayerVersionPermission',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None) -> 'LayerVersionPermission':
        """
        Get an existing LayerVersionPermission resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = LayerVersionPermissionArgs.__new__(LayerVersionPermissionArgs)

        __props__.__dict__["action"] = None
        __props__.__dict__["layer_version_arn"] = None
        __props__.__dict__["organization_id"] = None
        __props__.__dict__["principal"] = None
        return LayerVersionPermission(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter
    def action(self) -> pulumi.Output[str]:
        return pulumi.get(self, "action")

    @property
    @pulumi.getter(name="layerVersionArn")
    def layer_version_arn(self) -> pulumi.Output[str]:
        return pulumi.get(self, "layer_version_arn")

    @property
    @pulumi.getter(name="organizationId")
    def organization_id(self) -> pulumi.Output[Optional[str]]:
        return pulumi.get(self, "organization_id")

    @property
    @pulumi.getter
    def principal(self) -> pulumi.Output[str]:
        return pulumi.get(self, "principal")

