# coding=utf-8
# *** WARNING: this file was generated by the Pulumi SDK Generator. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from .. import _utilities
from . import outputs
from ._enums import *
from ._inputs import *

__all__ = ['FleetArgs', 'Fleet']

@pulumi.input_type
class FleetArgs:
    def __init__(__self__, *,
                 build_id: Optional[pulumi.Input[str]] = None,
                 certificate_configuration: Optional[pulumi.Input['FleetCertificateConfigurationArgs']] = None,
                 description: Optional[pulumi.Input[str]] = None,
                 desired_ec2_instances: Optional[pulumi.Input[int]] = None,
                 e_c2_inbound_permissions: Optional[pulumi.Input[Sequence[pulumi.Input['FleetIpPermissionArgs']]]] = None,
                 e_c2_instance_type: Optional[pulumi.Input[str]] = None,
                 fleet_type: Optional[pulumi.Input['FleetType']] = None,
                 instance_role_arn: Optional[pulumi.Input[str]] = None,
                 locations: Optional[pulumi.Input[Sequence[pulumi.Input['FleetLocationConfigurationArgs']]]] = None,
                 log_paths: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 max_size: Optional[pulumi.Input[int]] = None,
                 metric_groups: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 min_size: Optional[pulumi.Input[int]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 new_game_session_protection_policy: Optional[pulumi.Input['FleetNewGameSessionProtectionPolicy']] = None,
                 peer_vpc_aws_account_id: Optional[pulumi.Input[str]] = None,
                 peer_vpc_id: Optional[pulumi.Input[str]] = None,
                 resource_creation_limit_policy: Optional[pulumi.Input['FleetResourceCreationLimitPolicyArgs']] = None,
                 runtime_configuration: Optional[pulumi.Input['FleetRuntimeConfigurationArgs']] = None,
                 script_id: Optional[pulumi.Input[str]] = None,
                 server_launch_parameters: Optional[pulumi.Input[str]] = None,
                 server_launch_path: Optional[pulumi.Input[str]] = None):
        """
        The set of arguments for constructing a Fleet resource.
        :param pulumi.Input[str] build_id: A unique identifier for a build to be deployed on the new fleet. If you are deploying the fleet with a custom game build, you must specify this property. The build must have been successfully uploaded to Amazon GameLift and be in a READY status. This fleet setting cannot be changed once the fleet is created.
        :param pulumi.Input['FleetCertificateConfigurationArgs'] certificate_configuration: Indicates whether to generate a TLS/SSL certificate for the new fleet. TLS certificates are used for encrypting traffic between game clients and game servers running on GameLift. If this parameter is not set, certificate generation is disabled. This fleet setting cannot be changed once the fleet is created.
        :param pulumi.Input[str] description: A human-readable description of a fleet.
        :param pulumi.Input[int] desired_ec2_instances: [DEPRECATED] The number of EC2 instances that you want this fleet to host. When creating a new fleet, GameLift automatically sets this value to "1" and initiates a single instance. Once the fleet is active, update this value to trigger GameLift to add or remove instances from the fleet.
        :param pulumi.Input[Sequence[pulumi.Input['FleetIpPermissionArgs']]] e_c2_inbound_permissions: A range of IP addresses and port settings that allow inbound traffic to connect to server processes on an Amazon GameLift server.
        :param pulumi.Input[str] e_c2_instance_type: The name of an EC2 instance type that is supported in Amazon GameLift. A fleet instance type determines the computing resources of each instance in the fleet, including CPU, memory, storage, and networking capacity. Amazon GameLift supports the following EC2 instance types. See Amazon EC2 Instance Types for detailed descriptions.
        :param pulumi.Input['FleetType'] fleet_type: Indicates whether to use On-Demand instances or Spot instances for this fleet. If empty, the default is ON_DEMAND. Both categories of instances use identical hardware and configurations based on the instance type selected for this fleet.
        :param pulumi.Input[str] instance_role_arn: A unique identifier for an AWS IAM role that manages access to your AWS services. With an instance role ARN set, any application that runs on an instance in this fleet can assume the role, including install scripts, server processes, and daemons (background processes). Create a role or look up a role's ARN from the IAM dashboard in the AWS Management Console.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] log_paths: This parameter is no longer used. When hosting a custom game build, specify where Amazon GameLift should store log files using the Amazon GameLift server API call ProcessReady()
        :param pulumi.Input[int] max_size: [DEPRECATED] The maximum value that is allowed for the fleet's instance count. When creating a new fleet, GameLift automatically sets this value to "1". Once the fleet is active, you can change this value.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] metric_groups: The name of an Amazon CloudWatch metric group. A metric group aggregates the metrics for all fleets in the group. Specify a string containing the metric group name. You can use an existing name or use a new name to create a new metric group. Currently, this parameter can have only one string.
        :param pulumi.Input[int] min_size: [DEPRECATED] The minimum value allowed for the fleet's instance count. When creating a new fleet, GameLift automatically sets this value to "0". After the fleet is active, you can change this value.
        :param pulumi.Input[str] name: A descriptive label that is associated with a fleet. Fleet names do not need to be unique.
        :param pulumi.Input['FleetNewGameSessionProtectionPolicy'] new_game_session_protection_policy: A game session protection policy to apply to all game sessions hosted on instances in this fleet. When protected, active game sessions cannot be terminated during a scale-down event. If this parameter is not set, instances in this fleet default to no protection. You can change a fleet's protection policy to affect future game sessions on the fleet. You can also set protection for individual game sessions.
        :param pulumi.Input[str] peer_vpc_aws_account_id: A unique identifier for the AWS account with the VPC that you want to peer your Amazon GameLift fleet with. You can find your account ID in the AWS Management Console under account settings.
        :param pulumi.Input[str] peer_vpc_id: A unique identifier for a VPC with resources to be accessed by your Amazon GameLift fleet. The VPC must be in the same Region as your fleet. To look up a VPC ID, use the VPC Dashboard in the AWS Management Console.
        :param pulumi.Input['FleetResourceCreationLimitPolicyArgs'] resource_creation_limit_policy: A policy that limits the number of game sessions an individual player can create over a span of time for this fleet.
        :param pulumi.Input['FleetRuntimeConfigurationArgs'] runtime_configuration: Instructions for launching server processes on each instance in the fleet. Server processes run either a custom game build executable or a Realtime script. The runtime configuration defines the server executables or launch script file, launch parameters, and the number of processes to run concurrently on each instance. When creating a fleet, the runtime configuration must have at least one server process configuration; otherwise the request fails with an invalid request exception.
               
               This parameter is required unless the parameters ServerLaunchPath and ServerLaunchParameters are defined. Runtime configuration has replaced these parameters, but fleets that use them will continue to work.
        :param pulumi.Input[str] script_id: A unique identifier for a Realtime script to be deployed on a new Realtime Servers fleet. The script must have been successfully uploaded to Amazon GameLift. This fleet setting cannot be changed once the fleet is created.
               
               Note: It is not currently possible to use the !Ref command to reference a script created with a CloudFormation template for the fleet property ScriptId. Instead, use Fn::GetAtt Script.Arn or Fn::GetAtt Script.Id to retrieve either of these properties as input for ScriptId. Alternatively, enter a ScriptId string manually.
        :param pulumi.Input[str] server_launch_parameters: This parameter is no longer used but is retained for backward compatibility. Instead, specify server launch parameters in the RuntimeConfiguration parameter. A request must specify either a runtime configuration or values for both ServerLaunchParameters and ServerLaunchPath.
        :param pulumi.Input[str] server_launch_path: This parameter is no longer used. Instead, specify a server launch path using the RuntimeConfiguration parameter. Requests that specify a server launch path and launch parameters instead of a runtime configuration will continue to work.
        """
        if build_id is not None:
            pulumi.set(__self__, "build_id", build_id)
        if certificate_configuration is not None:
            pulumi.set(__self__, "certificate_configuration", certificate_configuration)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if desired_ec2_instances is not None:
            pulumi.set(__self__, "desired_ec2_instances", desired_ec2_instances)
        if e_c2_inbound_permissions is not None:
            pulumi.set(__self__, "e_c2_inbound_permissions", e_c2_inbound_permissions)
        if e_c2_instance_type is not None:
            pulumi.set(__self__, "e_c2_instance_type", e_c2_instance_type)
        if fleet_type is not None:
            pulumi.set(__self__, "fleet_type", fleet_type)
        if instance_role_arn is not None:
            pulumi.set(__self__, "instance_role_arn", instance_role_arn)
        if locations is not None:
            pulumi.set(__self__, "locations", locations)
        if log_paths is not None:
            pulumi.set(__self__, "log_paths", log_paths)
        if max_size is not None:
            pulumi.set(__self__, "max_size", max_size)
        if metric_groups is not None:
            pulumi.set(__self__, "metric_groups", metric_groups)
        if min_size is not None:
            pulumi.set(__self__, "min_size", min_size)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if new_game_session_protection_policy is not None:
            pulumi.set(__self__, "new_game_session_protection_policy", new_game_session_protection_policy)
        if peer_vpc_aws_account_id is not None:
            pulumi.set(__self__, "peer_vpc_aws_account_id", peer_vpc_aws_account_id)
        if peer_vpc_id is not None:
            pulumi.set(__self__, "peer_vpc_id", peer_vpc_id)
        if resource_creation_limit_policy is not None:
            pulumi.set(__self__, "resource_creation_limit_policy", resource_creation_limit_policy)
        if runtime_configuration is not None:
            pulumi.set(__self__, "runtime_configuration", runtime_configuration)
        if script_id is not None:
            pulumi.set(__self__, "script_id", script_id)
        if server_launch_parameters is not None:
            pulumi.set(__self__, "server_launch_parameters", server_launch_parameters)
        if server_launch_path is not None:
            pulumi.set(__self__, "server_launch_path", server_launch_path)

    @property
    @pulumi.getter(name="buildId")
    def build_id(self) -> Optional[pulumi.Input[str]]:
        """
        A unique identifier for a build to be deployed on the new fleet. If you are deploying the fleet with a custom game build, you must specify this property. The build must have been successfully uploaded to Amazon GameLift and be in a READY status. This fleet setting cannot be changed once the fleet is created.
        """
        return pulumi.get(self, "build_id")

    @build_id.setter
    def build_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "build_id", value)

    @property
    @pulumi.getter(name="certificateConfiguration")
    def certificate_configuration(self) -> Optional[pulumi.Input['FleetCertificateConfigurationArgs']]:
        """
        Indicates whether to generate a TLS/SSL certificate for the new fleet. TLS certificates are used for encrypting traffic between game clients and game servers running on GameLift. If this parameter is not set, certificate generation is disabled. This fleet setting cannot be changed once the fleet is created.
        """
        return pulumi.get(self, "certificate_configuration")

    @certificate_configuration.setter
    def certificate_configuration(self, value: Optional[pulumi.Input['FleetCertificateConfigurationArgs']]):
        pulumi.set(self, "certificate_configuration", value)

    @property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[str]]:
        """
        A human-readable description of a fleet.
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "description", value)

    @property
    @pulumi.getter(name="desiredEC2Instances")
    def desired_ec2_instances(self) -> Optional[pulumi.Input[int]]:
        """
        [DEPRECATED] The number of EC2 instances that you want this fleet to host. When creating a new fleet, GameLift automatically sets this value to "1" and initiates a single instance. Once the fleet is active, update this value to trigger GameLift to add or remove instances from the fleet.
        """
        return pulumi.get(self, "desired_ec2_instances")

    @desired_ec2_instances.setter
    def desired_ec2_instances(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "desired_ec2_instances", value)

    @property
    @pulumi.getter(name="eC2InboundPermissions")
    def e_c2_inbound_permissions(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['FleetIpPermissionArgs']]]]:
        """
        A range of IP addresses and port settings that allow inbound traffic to connect to server processes on an Amazon GameLift server.
        """
        return pulumi.get(self, "e_c2_inbound_permissions")

    @e_c2_inbound_permissions.setter
    def e_c2_inbound_permissions(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['FleetIpPermissionArgs']]]]):
        pulumi.set(self, "e_c2_inbound_permissions", value)

    @property
    @pulumi.getter(name="eC2InstanceType")
    def e_c2_instance_type(self) -> Optional[pulumi.Input[str]]:
        """
        The name of an EC2 instance type that is supported in Amazon GameLift. A fleet instance type determines the computing resources of each instance in the fleet, including CPU, memory, storage, and networking capacity. Amazon GameLift supports the following EC2 instance types. See Amazon EC2 Instance Types for detailed descriptions.
        """
        return pulumi.get(self, "e_c2_instance_type")

    @e_c2_instance_type.setter
    def e_c2_instance_type(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "e_c2_instance_type", value)

    @property
    @pulumi.getter(name="fleetType")
    def fleet_type(self) -> Optional[pulumi.Input['FleetType']]:
        """
        Indicates whether to use On-Demand instances or Spot instances for this fleet. If empty, the default is ON_DEMAND. Both categories of instances use identical hardware and configurations based on the instance type selected for this fleet.
        """
        return pulumi.get(self, "fleet_type")

    @fleet_type.setter
    def fleet_type(self, value: Optional[pulumi.Input['FleetType']]):
        pulumi.set(self, "fleet_type", value)

    @property
    @pulumi.getter(name="instanceRoleARN")
    def instance_role_arn(self) -> Optional[pulumi.Input[str]]:
        """
        A unique identifier for an AWS IAM role that manages access to your AWS services. With an instance role ARN set, any application that runs on an instance in this fleet can assume the role, including install scripts, server processes, and daemons (background processes). Create a role or look up a role's ARN from the IAM dashboard in the AWS Management Console.
        """
        return pulumi.get(self, "instance_role_arn")

    @instance_role_arn.setter
    def instance_role_arn(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "instance_role_arn", value)

    @property
    @pulumi.getter
    def locations(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['FleetLocationConfigurationArgs']]]]:
        return pulumi.get(self, "locations")

    @locations.setter
    def locations(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['FleetLocationConfigurationArgs']]]]):
        pulumi.set(self, "locations", value)

    @property
    @pulumi.getter(name="logPaths")
    def log_paths(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        This parameter is no longer used. When hosting a custom game build, specify where Amazon GameLift should store log files using the Amazon GameLift server API call ProcessReady()
        """
        return pulumi.get(self, "log_paths")

    @log_paths.setter
    def log_paths(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "log_paths", value)

    @property
    @pulumi.getter(name="maxSize")
    def max_size(self) -> Optional[pulumi.Input[int]]:
        """
        [DEPRECATED] The maximum value that is allowed for the fleet's instance count. When creating a new fleet, GameLift automatically sets this value to "1". Once the fleet is active, you can change this value.
        """
        return pulumi.get(self, "max_size")

    @max_size.setter
    def max_size(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "max_size", value)

    @property
    @pulumi.getter(name="metricGroups")
    def metric_groups(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        The name of an Amazon CloudWatch metric group. A metric group aggregates the metrics for all fleets in the group. Specify a string containing the metric group name. You can use an existing name or use a new name to create a new metric group. Currently, this parameter can have only one string.
        """
        return pulumi.get(self, "metric_groups")

    @metric_groups.setter
    def metric_groups(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "metric_groups", value)

    @property
    @pulumi.getter(name="minSize")
    def min_size(self) -> Optional[pulumi.Input[int]]:
        """
        [DEPRECATED] The minimum value allowed for the fleet's instance count. When creating a new fleet, GameLift automatically sets this value to "0". After the fleet is active, you can change this value.
        """
        return pulumi.get(self, "min_size")

    @min_size.setter
    def min_size(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "min_size", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[str]]:
        """
        A descriptive label that is associated with a fleet. Fleet names do not need to be unique.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter(name="newGameSessionProtectionPolicy")
    def new_game_session_protection_policy(self) -> Optional[pulumi.Input['FleetNewGameSessionProtectionPolicy']]:
        """
        A game session protection policy to apply to all game sessions hosted on instances in this fleet. When protected, active game sessions cannot be terminated during a scale-down event. If this parameter is not set, instances in this fleet default to no protection. You can change a fleet's protection policy to affect future game sessions on the fleet. You can also set protection for individual game sessions.
        """
        return pulumi.get(self, "new_game_session_protection_policy")

    @new_game_session_protection_policy.setter
    def new_game_session_protection_policy(self, value: Optional[pulumi.Input['FleetNewGameSessionProtectionPolicy']]):
        pulumi.set(self, "new_game_session_protection_policy", value)

    @property
    @pulumi.getter(name="peerVpcAwsAccountId")
    def peer_vpc_aws_account_id(self) -> Optional[pulumi.Input[str]]:
        """
        A unique identifier for the AWS account with the VPC that you want to peer your Amazon GameLift fleet with. You can find your account ID in the AWS Management Console under account settings.
        """
        return pulumi.get(self, "peer_vpc_aws_account_id")

    @peer_vpc_aws_account_id.setter
    def peer_vpc_aws_account_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "peer_vpc_aws_account_id", value)

    @property
    @pulumi.getter(name="peerVpcId")
    def peer_vpc_id(self) -> Optional[pulumi.Input[str]]:
        """
        A unique identifier for a VPC with resources to be accessed by your Amazon GameLift fleet. The VPC must be in the same Region as your fleet. To look up a VPC ID, use the VPC Dashboard in the AWS Management Console.
        """
        return pulumi.get(self, "peer_vpc_id")

    @peer_vpc_id.setter
    def peer_vpc_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "peer_vpc_id", value)

    @property
    @pulumi.getter(name="resourceCreationLimitPolicy")
    def resource_creation_limit_policy(self) -> Optional[pulumi.Input['FleetResourceCreationLimitPolicyArgs']]:
        """
        A policy that limits the number of game sessions an individual player can create over a span of time for this fleet.
        """
        return pulumi.get(self, "resource_creation_limit_policy")

    @resource_creation_limit_policy.setter
    def resource_creation_limit_policy(self, value: Optional[pulumi.Input['FleetResourceCreationLimitPolicyArgs']]):
        pulumi.set(self, "resource_creation_limit_policy", value)

    @property
    @pulumi.getter(name="runtimeConfiguration")
    def runtime_configuration(self) -> Optional[pulumi.Input['FleetRuntimeConfigurationArgs']]:
        """
        Instructions for launching server processes on each instance in the fleet. Server processes run either a custom game build executable or a Realtime script. The runtime configuration defines the server executables or launch script file, launch parameters, and the number of processes to run concurrently on each instance. When creating a fleet, the runtime configuration must have at least one server process configuration; otherwise the request fails with an invalid request exception.

        This parameter is required unless the parameters ServerLaunchPath and ServerLaunchParameters are defined. Runtime configuration has replaced these parameters, but fleets that use them will continue to work.
        """
        return pulumi.get(self, "runtime_configuration")

    @runtime_configuration.setter
    def runtime_configuration(self, value: Optional[pulumi.Input['FleetRuntimeConfigurationArgs']]):
        pulumi.set(self, "runtime_configuration", value)

    @property
    @pulumi.getter(name="scriptId")
    def script_id(self) -> Optional[pulumi.Input[str]]:
        """
        A unique identifier for a Realtime script to be deployed on a new Realtime Servers fleet. The script must have been successfully uploaded to Amazon GameLift. This fleet setting cannot be changed once the fleet is created.

        Note: It is not currently possible to use the !Ref command to reference a script created with a CloudFormation template for the fleet property ScriptId. Instead, use Fn::GetAtt Script.Arn or Fn::GetAtt Script.Id to retrieve either of these properties as input for ScriptId. Alternatively, enter a ScriptId string manually.
        """
        return pulumi.get(self, "script_id")

    @script_id.setter
    def script_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "script_id", value)

    @property
    @pulumi.getter(name="serverLaunchParameters")
    def server_launch_parameters(self) -> Optional[pulumi.Input[str]]:
        """
        This parameter is no longer used but is retained for backward compatibility. Instead, specify server launch parameters in the RuntimeConfiguration parameter. A request must specify either a runtime configuration or values for both ServerLaunchParameters and ServerLaunchPath.
        """
        return pulumi.get(self, "server_launch_parameters")

    @server_launch_parameters.setter
    def server_launch_parameters(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "server_launch_parameters", value)

    @property
    @pulumi.getter(name="serverLaunchPath")
    def server_launch_path(self) -> Optional[pulumi.Input[str]]:
        """
        This parameter is no longer used. Instead, specify a server launch path using the RuntimeConfiguration parameter. Requests that specify a server launch path and launch parameters instead of a runtime configuration will continue to work.
        """
        return pulumi.get(self, "server_launch_path")

    @server_launch_path.setter
    def server_launch_path(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "server_launch_path", value)


class Fleet(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 build_id: Optional[pulumi.Input[str]] = None,
                 certificate_configuration: Optional[pulumi.Input[pulumi.InputType['FleetCertificateConfigurationArgs']]] = None,
                 description: Optional[pulumi.Input[str]] = None,
                 desired_ec2_instances: Optional[pulumi.Input[int]] = None,
                 e_c2_inbound_permissions: Optional[pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['FleetIpPermissionArgs']]]]] = None,
                 e_c2_instance_type: Optional[pulumi.Input[str]] = None,
                 fleet_type: Optional[pulumi.Input['FleetType']] = None,
                 instance_role_arn: Optional[pulumi.Input[str]] = None,
                 locations: Optional[pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['FleetLocationConfigurationArgs']]]]] = None,
                 log_paths: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 max_size: Optional[pulumi.Input[int]] = None,
                 metric_groups: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 min_size: Optional[pulumi.Input[int]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 new_game_session_protection_policy: Optional[pulumi.Input['FleetNewGameSessionProtectionPolicy']] = None,
                 peer_vpc_aws_account_id: Optional[pulumi.Input[str]] = None,
                 peer_vpc_id: Optional[pulumi.Input[str]] = None,
                 resource_creation_limit_policy: Optional[pulumi.Input[pulumi.InputType['FleetResourceCreationLimitPolicyArgs']]] = None,
                 runtime_configuration: Optional[pulumi.Input[pulumi.InputType['FleetRuntimeConfigurationArgs']]] = None,
                 script_id: Optional[pulumi.Input[str]] = None,
                 server_launch_parameters: Optional[pulumi.Input[str]] = None,
                 server_launch_path: Optional[pulumi.Input[str]] = None,
                 __props__=None):
        """
        The AWS::GameLift::Fleet resource creates an Amazon GameLift (GameLift) fleet to host game servers.  A fleet is a set of EC2 instances, each of which can host multiple game sessions.

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[str] build_id: A unique identifier for a build to be deployed on the new fleet. If you are deploying the fleet with a custom game build, you must specify this property. The build must have been successfully uploaded to Amazon GameLift and be in a READY status. This fleet setting cannot be changed once the fleet is created.
        :param pulumi.Input[pulumi.InputType['FleetCertificateConfigurationArgs']] certificate_configuration: Indicates whether to generate a TLS/SSL certificate for the new fleet. TLS certificates are used for encrypting traffic between game clients and game servers running on GameLift. If this parameter is not set, certificate generation is disabled. This fleet setting cannot be changed once the fleet is created.
        :param pulumi.Input[str] description: A human-readable description of a fleet.
        :param pulumi.Input[int] desired_ec2_instances: [DEPRECATED] The number of EC2 instances that you want this fleet to host. When creating a new fleet, GameLift automatically sets this value to "1" and initiates a single instance. Once the fleet is active, update this value to trigger GameLift to add or remove instances from the fleet.
        :param pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['FleetIpPermissionArgs']]]] e_c2_inbound_permissions: A range of IP addresses and port settings that allow inbound traffic to connect to server processes on an Amazon GameLift server.
        :param pulumi.Input[str] e_c2_instance_type: The name of an EC2 instance type that is supported in Amazon GameLift. A fleet instance type determines the computing resources of each instance in the fleet, including CPU, memory, storage, and networking capacity. Amazon GameLift supports the following EC2 instance types. See Amazon EC2 Instance Types for detailed descriptions.
        :param pulumi.Input['FleetType'] fleet_type: Indicates whether to use On-Demand instances or Spot instances for this fleet. If empty, the default is ON_DEMAND. Both categories of instances use identical hardware and configurations based on the instance type selected for this fleet.
        :param pulumi.Input[str] instance_role_arn: A unique identifier for an AWS IAM role that manages access to your AWS services. With an instance role ARN set, any application that runs on an instance in this fleet can assume the role, including install scripts, server processes, and daemons (background processes). Create a role or look up a role's ARN from the IAM dashboard in the AWS Management Console.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] log_paths: This parameter is no longer used. When hosting a custom game build, specify where Amazon GameLift should store log files using the Amazon GameLift server API call ProcessReady()
        :param pulumi.Input[int] max_size: [DEPRECATED] The maximum value that is allowed for the fleet's instance count. When creating a new fleet, GameLift automatically sets this value to "1". Once the fleet is active, you can change this value.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] metric_groups: The name of an Amazon CloudWatch metric group. A metric group aggregates the metrics for all fleets in the group. Specify a string containing the metric group name. You can use an existing name or use a new name to create a new metric group. Currently, this parameter can have only one string.
        :param pulumi.Input[int] min_size: [DEPRECATED] The minimum value allowed for the fleet's instance count. When creating a new fleet, GameLift automatically sets this value to "0". After the fleet is active, you can change this value.
        :param pulumi.Input[str] name: A descriptive label that is associated with a fleet. Fleet names do not need to be unique.
        :param pulumi.Input['FleetNewGameSessionProtectionPolicy'] new_game_session_protection_policy: A game session protection policy to apply to all game sessions hosted on instances in this fleet. When protected, active game sessions cannot be terminated during a scale-down event. If this parameter is not set, instances in this fleet default to no protection. You can change a fleet's protection policy to affect future game sessions on the fleet. You can also set protection for individual game sessions.
        :param pulumi.Input[str] peer_vpc_aws_account_id: A unique identifier for the AWS account with the VPC that you want to peer your Amazon GameLift fleet with. You can find your account ID in the AWS Management Console under account settings.
        :param pulumi.Input[str] peer_vpc_id: A unique identifier for a VPC with resources to be accessed by your Amazon GameLift fleet. The VPC must be in the same Region as your fleet. To look up a VPC ID, use the VPC Dashboard in the AWS Management Console.
        :param pulumi.Input[pulumi.InputType['FleetResourceCreationLimitPolicyArgs']] resource_creation_limit_policy: A policy that limits the number of game sessions an individual player can create over a span of time for this fleet.
        :param pulumi.Input[pulumi.InputType['FleetRuntimeConfigurationArgs']] runtime_configuration: Instructions for launching server processes on each instance in the fleet. Server processes run either a custom game build executable or a Realtime script. The runtime configuration defines the server executables or launch script file, launch parameters, and the number of processes to run concurrently on each instance. When creating a fleet, the runtime configuration must have at least one server process configuration; otherwise the request fails with an invalid request exception.
               
               This parameter is required unless the parameters ServerLaunchPath and ServerLaunchParameters are defined. Runtime configuration has replaced these parameters, but fleets that use them will continue to work.
        :param pulumi.Input[str] script_id: A unique identifier for a Realtime script to be deployed on a new Realtime Servers fleet. The script must have been successfully uploaded to Amazon GameLift. This fleet setting cannot be changed once the fleet is created.
               
               Note: It is not currently possible to use the !Ref command to reference a script created with a CloudFormation template for the fleet property ScriptId. Instead, use Fn::GetAtt Script.Arn or Fn::GetAtt Script.Id to retrieve either of these properties as input for ScriptId. Alternatively, enter a ScriptId string manually.
        :param pulumi.Input[str] server_launch_parameters: This parameter is no longer used but is retained for backward compatibility. Instead, specify server launch parameters in the RuntimeConfiguration parameter. A request must specify either a runtime configuration or values for both ServerLaunchParameters and ServerLaunchPath.
        :param pulumi.Input[str] server_launch_path: This parameter is no longer used. Instead, specify a server launch path using the RuntimeConfiguration parameter. Requests that specify a server launch path and launch parameters instead of a runtime configuration will continue to work.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: Optional[FleetArgs] = None,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        The AWS::GameLift::Fleet resource creates an Amazon GameLift (GameLift) fleet to host game servers.  A fleet is a set of EC2 instances, each of which can host multiple game sessions.

        :param str resource_name: The name of the resource.
        :param FleetArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(FleetArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 build_id: Optional[pulumi.Input[str]] = None,
                 certificate_configuration: Optional[pulumi.Input[pulumi.InputType['FleetCertificateConfigurationArgs']]] = None,
                 description: Optional[pulumi.Input[str]] = None,
                 desired_ec2_instances: Optional[pulumi.Input[int]] = None,
                 e_c2_inbound_permissions: Optional[pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['FleetIpPermissionArgs']]]]] = None,
                 e_c2_instance_type: Optional[pulumi.Input[str]] = None,
                 fleet_type: Optional[pulumi.Input['FleetType']] = None,
                 instance_role_arn: Optional[pulumi.Input[str]] = None,
                 locations: Optional[pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['FleetLocationConfigurationArgs']]]]] = None,
                 log_paths: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 max_size: Optional[pulumi.Input[int]] = None,
                 metric_groups: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 min_size: Optional[pulumi.Input[int]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 new_game_session_protection_policy: Optional[pulumi.Input['FleetNewGameSessionProtectionPolicy']] = None,
                 peer_vpc_aws_account_id: Optional[pulumi.Input[str]] = None,
                 peer_vpc_id: Optional[pulumi.Input[str]] = None,
                 resource_creation_limit_policy: Optional[pulumi.Input[pulumi.InputType['FleetResourceCreationLimitPolicyArgs']]] = None,
                 runtime_configuration: Optional[pulumi.Input[pulumi.InputType['FleetRuntimeConfigurationArgs']]] = None,
                 script_id: Optional[pulumi.Input[str]] = None,
                 server_launch_parameters: Optional[pulumi.Input[str]] = None,
                 server_launch_path: Optional[pulumi.Input[str]] = None,
                 __props__=None):
        if opts is None:
            opts = pulumi.ResourceOptions()
        else:
            opts = copy.copy(opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.version is None:
            opts.version = _utilities.get_version()
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = FleetArgs.__new__(FleetArgs)

            __props__.__dict__["build_id"] = build_id
            __props__.__dict__["certificate_configuration"] = certificate_configuration
            __props__.__dict__["description"] = description
            __props__.__dict__["desired_ec2_instances"] = desired_ec2_instances
            __props__.__dict__["e_c2_inbound_permissions"] = e_c2_inbound_permissions
            __props__.__dict__["e_c2_instance_type"] = e_c2_instance_type
            __props__.__dict__["fleet_type"] = fleet_type
            __props__.__dict__["instance_role_arn"] = instance_role_arn
            __props__.__dict__["locations"] = locations
            __props__.__dict__["log_paths"] = log_paths
            __props__.__dict__["max_size"] = max_size
            __props__.__dict__["metric_groups"] = metric_groups
            __props__.__dict__["min_size"] = min_size
            __props__.__dict__["name"] = name
            __props__.__dict__["new_game_session_protection_policy"] = new_game_session_protection_policy
            __props__.__dict__["peer_vpc_aws_account_id"] = peer_vpc_aws_account_id
            __props__.__dict__["peer_vpc_id"] = peer_vpc_id
            __props__.__dict__["resource_creation_limit_policy"] = resource_creation_limit_policy
            __props__.__dict__["runtime_configuration"] = runtime_configuration
            __props__.__dict__["script_id"] = script_id
            __props__.__dict__["server_launch_parameters"] = server_launch_parameters
            __props__.__dict__["server_launch_path"] = server_launch_path
            __props__.__dict__["fleet_id"] = None
        super(Fleet, __self__).__init__(
            'aws-native:gamelift:Fleet',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None) -> 'Fleet':
        """
        Get an existing Fleet resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = FleetArgs.__new__(FleetArgs)

        __props__.__dict__["build_id"] = None
        __props__.__dict__["certificate_configuration"] = None
        __props__.__dict__["description"] = None
        __props__.__dict__["desired_ec2_instances"] = None
        __props__.__dict__["e_c2_inbound_permissions"] = None
        __props__.__dict__["e_c2_instance_type"] = None
        __props__.__dict__["fleet_id"] = None
        __props__.__dict__["fleet_type"] = None
        __props__.__dict__["instance_role_arn"] = None
        __props__.__dict__["locations"] = None
        __props__.__dict__["log_paths"] = None
        __props__.__dict__["max_size"] = None
        __props__.__dict__["metric_groups"] = None
        __props__.__dict__["min_size"] = None
        __props__.__dict__["name"] = None
        __props__.__dict__["new_game_session_protection_policy"] = None
        __props__.__dict__["peer_vpc_aws_account_id"] = None
        __props__.__dict__["peer_vpc_id"] = None
        __props__.__dict__["resource_creation_limit_policy"] = None
        __props__.__dict__["runtime_configuration"] = None
        __props__.__dict__["script_id"] = None
        __props__.__dict__["server_launch_parameters"] = None
        __props__.__dict__["server_launch_path"] = None
        return Fleet(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter(name="buildId")
    def build_id(self) -> pulumi.Output[Optional[str]]:
        """
        A unique identifier for a build to be deployed on the new fleet. If you are deploying the fleet with a custom game build, you must specify this property. The build must have been successfully uploaded to Amazon GameLift and be in a READY status. This fleet setting cannot be changed once the fleet is created.
        """
        return pulumi.get(self, "build_id")

    @property
    @pulumi.getter(name="certificateConfiguration")
    def certificate_configuration(self) -> pulumi.Output[Optional['outputs.FleetCertificateConfiguration']]:
        """
        Indicates whether to generate a TLS/SSL certificate for the new fleet. TLS certificates are used for encrypting traffic between game clients and game servers running on GameLift. If this parameter is not set, certificate generation is disabled. This fleet setting cannot be changed once the fleet is created.
        """
        return pulumi.get(self, "certificate_configuration")

    @property
    @pulumi.getter
    def description(self) -> pulumi.Output[Optional[str]]:
        """
        A human-readable description of a fleet.
        """
        return pulumi.get(self, "description")

    @property
    @pulumi.getter(name="desiredEC2Instances")
    def desired_ec2_instances(self) -> pulumi.Output[Optional[int]]:
        """
        [DEPRECATED] The number of EC2 instances that you want this fleet to host. When creating a new fleet, GameLift automatically sets this value to "1" and initiates a single instance. Once the fleet is active, update this value to trigger GameLift to add or remove instances from the fleet.
        """
        return pulumi.get(self, "desired_ec2_instances")

    @property
    @pulumi.getter(name="eC2InboundPermissions")
    def e_c2_inbound_permissions(self) -> pulumi.Output[Optional[Sequence['outputs.FleetIpPermission']]]:
        """
        A range of IP addresses and port settings that allow inbound traffic to connect to server processes on an Amazon GameLift server.
        """
        return pulumi.get(self, "e_c2_inbound_permissions")

    @property
    @pulumi.getter(name="eC2InstanceType")
    def e_c2_instance_type(self) -> pulumi.Output[Optional[str]]:
        """
        The name of an EC2 instance type that is supported in Amazon GameLift. A fleet instance type determines the computing resources of each instance in the fleet, including CPU, memory, storage, and networking capacity. Amazon GameLift supports the following EC2 instance types. See Amazon EC2 Instance Types for detailed descriptions.
        """
        return pulumi.get(self, "e_c2_instance_type")

    @property
    @pulumi.getter(name="fleetId")
    def fleet_id(self) -> pulumi.Output[str]:
        """
        Unique fleet ID
        """
        return pulumi.get(self, "fleet_id")

    @property
    @pulumi.getter(name="fleetType")
    def fleet_type(self) -> pulumi.Output[Optional['FleetType']]:
        """
        Indicates whether to use On-Demand instances or Spot instances for this fleet. If empty, the default is ON_DEMAND. Both categories of instances use identical hardware and configurations based on the instance type selected for this fleet.
        """
        return pulumi.get(self, "fleet_type")

    @property
    @pulumi.getter(name="instanceRoleARN")
    def instance_role_arn(self) -> pulumi.Output[Optional[str]]:
        """
        A unique identifier for an AWS IAM role that manages access to your AWS services. With an instance role ARN set, any application that runs on an instance in this fleet can assume the role, including install scripts, server processes, and daemons (background processes). Create a role or look up a role's ARN from the IAM dashboard in the AWS Management Console.
        """
        return pulumi.get(self, "instance_role_arn")

    @property
    @pulumi.getter
    def locations(self) -> pulumi.Output[Optional[Sequence['outputs.FleetLocationConfiguration']]]:
        return pulumi.get(self, "locations")

    @property
    @pulumi.getter(name="logPaths")
    def log_paths(self) -> pulumi.Output[Optional[Sequence[str]]]:
        """
        This parameter is no longer used. When hosting a custom game build, specify where Amazon GameLift should store log files using the Amazon GameLift server API call ProcessReady()
        """
        return pulumi.get(self, "log_paths")

    @property
    @pulumi.getter(name="maxSize")
    def max_size(self) -> pulumi.Output[Optional[int]]:
        """
        [DEPRECATED] The maximum value that is allowed for the fleet's instance count. When creating a new fleet, GameLift automatically sets this value to "1". Once the fleet is active, you can change this value.
        """
        return pulumi.get(self, "max_size")

    @property
    @pulumi.getter(name="metricGroups")
    def metric_groups(self) -> pulumi.Output[Optional[Sequence[str]]]:
        """
        The name of an Amazon CloudWatch metric group. A metric group aggregates the metrics for all fleets in the group. Specify a string containing the metric group name. You can use an existing name or use a new name to create a new metric group. Currently, this parameter can have only one string.
        """
        return pulumi.get(self, "metric_groups")

    @property
    @pulumi.getter(name="minSize")
    def min_size(self) -> pulumi.Output[Optional[int]]:
        """
        [DEPRECATED] The minimum value allowed for the fleet's instance count. When creating a new fleet, GameLift automatically sets this value to "0". After the fleet is active, you can change this value.
        """
        return pulumi.get(self, "min_size")

    @property
    @pulumi.getter
    def name(self) -> pulumi.Output[Optional[str]]:
        """
        A descriptive label that is associated with a fleet. Fleet names do not need to be unique.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter(name="newGameSessionProtectionPolicy")
    def new_game_session_protection_policy(self) -> pulumi.Output[Optional['FleetNewGameSessionProtectionPolicy']]:
        """
        A game session protection policy to apply to all game sessions hosted on instances in this fleet. When protected, active game sessions cannot be terminated during a scale-down event. If this parameter is not set, instances in this fleet default to no protection. You can change a fleet's protection policy to affect future game sessions on the fleet. You can also set protection for individual game sessions.
        """
        return pulumi.get(self, "new_game_session_protection_policy")

    @property
    @pulumi.getter(name="peerVpcAwsAccountId")
    def peer_vpc_aws_account_id(self) -> pulumi.Output[Optional[str]]:
        """
        A unique identifier for the AWS account with the VPC that you want to peer your Amazon GameLift fleet with. You can find your account ID in the AWS Management Console under account settings.
        """
        return pulumi.get(self, "peer_vpc_aws_account_id")

    @property
    @pulumi.getter(name="peerVpcId")
    def peer_vpc_id(self) -> pulumi.Output[Optional[str]]:
        """
        A unique identifier for a VPC with resources to be accessed by your Amazon GameLift fleet. The VPC must be in the same Region as your fleet. To look up a VPC ID, use the VPC Dashboard in the AWS Management Console.
        """
        return pulumi.get(self, "peer_vpc_id")

    @property
    @pulumi.getter(name="resourceCreationLimitPolicy")
    def resource_creation_limit_policy(self) -> pulumi.Output[Optional['outputs.FleetResourceCreationLimitPolicy']]:
        """
        A policy that limits the number of game sessions an individual player can create over a span of time for this fleet.
        """
        return pulumi.get(self, "resource_creation_limit_policy")

    @property
    @pulumi.getter(name="runtimeConfiguration")
    def runtime_configuration(self) -> pulumi.Output[Optional['outputs.FleetRuntimeConfiguration']]:
        """
        Instructions for launching server processes on each instance in the fleet. Server processes run either a custom game build executable or a Realtime script. The runtime configuration defines the server executables or launch script file, launch parameters, and the number of processes to run concurrently on each instance. When creating a fleet, the runtime configuration must have at least one server process configuration; otherwise the request fails with an invalid request exception.

        This parameter is required unless the parameters ServerLaunchPath and ServerLaunchParameters are defined. Runtime configuration has replaced these parameters, but fleets that use them will continue to work.
        """
        return pulumi.get(self, "runtime_configuration")

    @property
    @pulumi.getter(name="scriptId")
    def script_id(self) -> pulumi.Output[Optional[str]]:
        """
        A unique identifier for a Realtime script to be deployed on a new Realtime Servers fleet. The script must have been successfully uploaded to Amazon GameLift. This fleet setting cannot be changed once the fleet is created.

        Note: It is not currently possible to use the !Ref command to reference a script created with a CloudFormation template for the fleet property ScriptId. Instead, use Fn::GetAtt Script.Arn or Fn::GetAtt Script.Id to retrieve either of these properties as input for ScriptId. Alternatively, enter a ScriptId string manually.
        """
        return pulumi.get(self, "script_id")

    @property
    @pulumi.getter(name="serverLaunchParameters")
    def server_launch_parameters(self) -> pulumi.Output[Optional[str]]:
        """
        This parameter is no longer used but is retained for backward compatibility. Instead, specify server launch parameters in the RuntimeConfiguration parameter. A request must specify either a runtime configuration or values for both ServerLaunchParameters and ServerLaunchPath.
        """
        return pulumi.get(self, "server_launch_parameters")

    @property
    @pulumi.getter(name="serverLaunchPath")
    def server_launch_path(self) -> pulumi.Output[Optional[str]]:
        """
        This parameter is no longer used. Instead, specify a server launch path using the RuntimeConfiguration parameter. Requests that specify a server launch path and launch parameters instead of a runtime configuration will continue to work.
        """
        return pulumi.get(self, "server_launch_path")

