# coding=utf-8
# *** WARNING: this file was generated by the Pulumi SDK Generator. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from .. import _utilities
from . import outputs
from ._inputs import *

__all__ = ['AppBlockArgs', 'AppBlock']

@pulumi.input_type
class AppBlockArgs:
    def __init__(__self__, *,
                 setup_script_details: pulumi.Input['AppBlockScriptDetailsArgs'],
                 source_s3_location: pulumi.Input['AppBlockS3LocationArgs'],
                 description: Optional[pulumi.Input[str]] = None,
                 display_name: Optional[pulumi.Input[str]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 tags: Optional[pulumi.Input[Sequence[pulumi.Input['AppBlockTagArgs']]]] = None):
        """
        The set of arguments for constructing a AppBlock resource.
        """
        pulumi.set(__self__, "setup_script_details", setup_script_details)
        pulumi.set(__self__, "source_s3_location", source_s3_location)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if display_name is not None:
            pulumi.set(__self__, "display_name", display_name)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if tags is not None:
            pulumi.set(__self__, "tags", tags)

    @property
    @pulumi.getter(name="setupScriptDetails")
    def setup_script_details(self) -> pulumi.Input['AppBlockScriptDetailsArgs']:
        return pulumi.get(self, "setup_script_details")

    @setup_script_details.setter
    def setup_script_details(self, value: pulumi.Input['AppBlockScriptDetailsArgs']):
        pulumi.set(self, "setup_script_details", value)

    @property
    @pulumi.getter(name="sourceS3Location")
    def source_s3_location(self) -> pulumi.Input['AppBlockS3LocationArgs']:
        return pulumi.get(self, "source_s3_location")

    @source_s3_location.setter
    def source_s3_location(self, value: pulumi.Input['AppBlockS3LocationArgs']):
        pulumi.set(self, "source_s3_location", value)

    @property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[str]]:
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "description", value)

    @property
    @pulumi.getter(name="displayName")
    def display_name(self) -> Optional[pulumi.Input[str]]:
        return pulumi.get(self, "display_name")

    @display_name.setter
    def display_name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "display_name", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[str]]:
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter
    def tags(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['AppBlockTagArgs']]]]:
        return pulumi.get(self, "tags")

    @tags.setter
    def tags(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['AppBlockTagArgs']]]]):
        pulumi.set(self, "tags", value)


class AppBlock(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 description: Optional[pulumi.Input[str]] = None,
                 display_name: Optional[pulumi.Input[str]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 setup_script_details: Optional[pulumi.Input[pulumi.InputType['AppBlockScriptDetailsArgs']]] = None,
                 source_s3_location: Optional[pulumi.Input[pulumi.InputType['AppBlockS3LocationArgs']]] = None,
                 tags: Optional[pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['AppBlockTagArgs']]]]] = None,
                 __props__=None):
        """
        Resource Type definition for AWS::AppStream::AppBlock

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: AppBlockArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Resource Type definition for AWS::AppStream::AppBlock

        :param str resource_name: The name of the resource.
        :param AppBlockArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(AppBlockArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 description: Optional[pulumi.Input[str]] = None,
                 display_name: Optional[pulumi.Input[str]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 setup_script_details: Optional[pulumi.Input[pulumi.InputType['AppBlockScriptDetailsArgs']]] = None,
                 source_s3_location: Optional[pulumi.Input[pulumi.InputType['AppBlockS3LocationArgs']]] = None,
                 tags: Optional[pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['AppBlockTagArgs']]]]] = None,
                 __props__=None):
        if opts is None:
            opts = pulumi.ResourceOptions()
        else:
            opts = copy.copy(opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.version is None:
            opts.version = _utilities.get_version()
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = AppBlockArgs.__new__(AppBlockArgs)

            __props__.__dict__["description"] = description
            __props__.__dict__["display_name"] = display_name
            __props__.__dict__["name"] = name
            if setup_script_details is None and not opts.urn:
                raise TypeError("Missing required property 'setup_script_details'")
            __props__.__dict__["setup_script_details"] = setup_script_details
            if source_s3_location is None and not opts.urn:
                raise TypeError("Missing required property 'source_s3_location'")
            __props__.__dict__["source_s3_location"] = source_s3_location
            __props__.__dict__["tags"] = tags
            __props__.__dict__["arn"] = None
            __props__.__dict__["created_time"] = None
        super(AppBlock, __self__).__init__(
            'aws-native:appstream:AppBlock',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None) -> 'AppBlock':
        """
        Get an existing AppBlock resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = AppBlockArgs.__new__(AppBlockArgs)

        __props__.__dict__["arn"] = None
        __props__.__dict__["created_time"] = None
        __props__.__dict__["description"] = None
        __props__.__dict__["display_name"] = None
        __props__.__dict__["name"] = None
        __props__.__dict__["setup_script_details"] = None
        __props__.__dict__["source_s3_location"] = None
        __props__.__dict__["tags"] = None
        return AppBlock(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter
    def arn(self) -> pulumi.Output[str]:
        return pulumi.get(self, "arn")

    @property
    @pulumi.getter(name="createdTime")
    def created_time(self) -> pulumi.Output[str]:
        return pulumi.get(self, "created_time")

    @property
    @pulumi.getter
    def description(self) -> pulumi.Output[Optional[str]]:
        return pulumi.get(self, "description")

    @property
    @pulumi.getter(name="displayName")
    def display_name(self) -> pulumi.Output[Optional[str]]:
        return pulumi.get(self, "display_name")

    @property
    @pulumi.getter
    def name(self) -> pulumi.Output[str]:
        return pulumi.get(self, "name")

    @property
    @pulumi.getter(name="setupScriptDetails")
    def setup_script_details(self) -> pulumi.Output['outputs.AppBlockScriptDetails']:
        return pulumi.get(self, "setup_script_details")

    @property
    @pulumi.getter(name="sourceS3Location")
    def source_s3_location(self) -> pulumi.Output['outputs.AppBlockS3Location']:
        return pulumi.get(self, "source_s3_location")

    @property
    @pulumi.getter
    def tags(self) -> pulumi.Output[Optional[Sequence['outputs.AppBlockTag']]]:
        return pulumi.get(self, "tags")

