# Generated by the protocol buffer compiler.  DO NOT EDIT!
# sources: xds/type/matcher/v3/matcher.proto, xds/type/matcher/v3/regex.proto, xds/type/matcher/v3/string.proto
# plugin: python-betterproto
from dataclasses import dataclass
from typing import (
    Dict,
    List,
)

import betterproto

from ....core import v3 as ___core_v3__


@dataclass(eq=False, repr=False)
class RegexMatcher(betterproto.Message):
    """A regex matcher designed for safety when used with untrusted input."""

    google_re2: "RegexMatcherGoogleRe2" = betterproto.message_field(
        1, group="engine_type"
    )
    """Google's RE2 regex engine."""

    regex: str = betterproto.string_field(2)
    """
    The regex match string. The string must be supported by the configured
    engine.
    """


@dataclass(eq=False, repr=False)
class RegexMatcherGoogleRe2(betterproto.Message):
    """
    Google's `RE2 <https://github.com/google/re2>`_ regex engine. The regex
    string must adhere to the documented `syntax
    <https://github.com/google/re2/wiki/Syntax>`_. The engine is designed to
    complete execution in linear time as well as limit the amount of memory
    used. Envoy supports program size checking via runtime. The runtime keys
    `re2.max_program_size.error_level` and `re2.max_program_size.warn_level`
    can be set to integers as the maximum program size or complexity that a
    compiled regex can have before an exception is thrown or a warning is
    logged, respectively. `re2.max_program_size.error_level` defaults to 100,
    and `re2.max_program_size.warn_level` has no default if unset (will not
    check/log a warning). Envoy emits two stats for tracking the program size
    of regexes: the histogram `re2.program_size`, which records the program
    size, and the counter `re2.exceeded_warn_level`, which is incremented each
    time the program size exceeds the warn level threshold.
    """

    pass


@dataclass(eq=False, repr=False)
class StringMatcher(betterproto.Message):
    """Specifies the way to match a string. [#next-free-field: 8]"""

    exact: str = betterproto.string_field(1, group="match_pattern")
    """
    The input string must match exactly the string specified here. Examples: *
    *abc* only matches the value *abc*.
    """

    prefix: str = betterproto.string_field(2, group="match_pattern")
    """
    The input string must have the prefix specified here. Note: empty prefix is
    not allowed, please use regex instead. Examples: * *abc* matches the value
    *abc.xyz*
    """

    suffix: str = betterproto.string_field(3, group="match_pattern")
    """
    The input string must have the suffix specified here. Note: empty prefix is
    not allowed, please use regex instead. Examples: * *abc* matches the value
    *xyz.abc*
    """

    safe_regex: "RegexMatcher" = betterproto.message_field(5, group="match_pattern")
    """The input string must match the regular expression specified here."""

    contains: str = betterproto.string_field(7, group="match_pattern")
    """
    The input string must have the substring specified here. Note: empty
    contains match is not allowed, please use regex instead. Examples: * *abc*
    matches the value *xyz.abc.def*
    """

    ignore_case: bool = betterproto.bool_field(6)
    """
    If true, indicates the exact/prefix/suffix matching should be case
    insensitive. This has no effect for the safe_regex match. For example, the
    matcher *data* will match both input string *Data* and *data* if set to
    true.
    """


@dataclass(eq=False, repr=False)
class ListStringMatcher(betterproto.Message):
    """Specifies a list of ways to match a string."""

    patterns: List["StringMatcher"] = betterproto.message_field(1)


@dataclass(eq=False, repr=False)
class Matcher(betterproto.Message):
    """
    A matcher, which may traverse a matching tree in order to result in a match
    action. During matching, the tree will be traversed until a match is found,
    or if no match is found the action specified by the most specific
    on_no_match will be evaluated. As an on_no_match might result in another
    matching tree being evaluated, this process might repeat several times
    until the final OnMatch (or no match) is decided.
    """

    matcher_list: "MatcherMatcherList" = betterproto.message_field(
        1, group="matcher_type"
    )
    """A linear list of matchers to evaluate."""

    matcher_tree: "MatcherMatcherTree" = betterproto.message_field(
        2, group="matcher_type"
    )
    """A match tree to evaluate."""

    on_no_match: "MatcherOnMatch" = betterproto.message_field(3)
    """
    Optional OnMatch to use if no matcher above matched (e.g., if there are no
    matchers specified above, or if none of the matches specified above
    succeeded). If no matcher above matched and this field is not populated,
    the match will be considered unsuccessful.
    """


@dataclass(eq=False, repr=False)
class MatcherOnMatch(betterproto.Message):
    """What to do if a match is successful."""

    matcher: "Matcher" = betterproto.message_field(1, group="on_match")
    """
    Nested matcher to evaluate. If the nested matcher does not match and does
    not specify on_no_match, then this matcher is considered not to have
    matched, even if a predicate at this level or above returned true.
    """

    action: "___core_v3__.TypedExtensionConfig" = betterproto.message_field(
        2, group="on_match"
    )
    """Protocol-specific action to take."""


@dataclass(eq=False, repr=False)
class MatcherMatcherList(betterproto.Message):
    """
    A linear list of field matchers. The field matchers are evaluated in order,
    and the first match wins.
    """

    matchers: List["MatcherMatcherListFieldMatcher"] = betterproto.message_field(1)
    """A list of matchers. First match wins."""


@dataclass(eq=False, repr=False)
class MatcherMatcherListPredicate(betterproto.Message):
    """Predicate to determine if a match is successful."""

    single_predicate: "MatcherMatcherListPredicateSinglePredicate" = (
        betterproto.message_field(1, group="match_type")
    )
    """A single predicate to evaluate."""

    or_matcher: "MatcherMatcherListPredicatePredicateList" = betterproto.message_field(
        2, group="match_type"
    )
    """A list of predicates to be OR-ed together."""

    and_matcher: "MatcherMatcherListPredicatePredicateList" = betterproto.message_field(
        3, group="match_type"
    )
    """A list of predicates to be AND-ed together."""

    not_matcher: "MatcherMatcherListPredicate" = betterproto.message_field(
        4, group="match_type"
    )
    """The invert of a predicate"""


@dataclass(eq=False, repr=False)
class MatcherMatcherListPredicateSinglePredicate(betterproto.Message):
    """Predicate for a single input field."""

    input: "___core_v3__.TypedExtensionConfig" = betterproto.message_field(1)
    """
    Protocol-specific specification of input field to match on. [#extension-
    category: envoy.matching.common_inputs]
    """

    value_match: "StringMatcher" = betterproto.message_field(2, group="matcher")
    """Built-in string matcher."""

    custom_match: "___core_v3__.TypedExtensionConfig" = betterproto.message_field(
        3, group="matcher"
    )
    """
    Extension for custom matching logic. [#extension-category:
    envoy.matching.input_matchers]
    """


@dataclass(eq=False, repr=False)
class MatcherMatcherListPredicatePredicateList(betterproto.Message):
    """
    A list of two or more matchers. Used to allow using a list within a oneof.
    """

    predicate: List["MatcherMatcherListPredicate"] = betterproto.message_field(1)


@dataclass(eq=False, repr=False)
class MatcherMatcherListFieldMatcher(betterproto.Message):
    """An individual matcher."""

    predicate: "MatcherMatcherListPredicate" = betterproto.message_field(1)
    """Determines if the match succeeds."""

    on_match: "MatcherOnMatch" = betterproto.message_field(2)
    """What to do if the match succeeds."""


@dataclass(eq=False, repr=False)
class MatcherMatcherTree(betterproto.Message):
    input: "___core_v3__.TypedExtensionConfig" = betterproto.message_field(1)
    """Protocol-specific specification of input field to match on."""

    exact_match_map: "MatcherMatcherTreeMatchMap" = betterproto.message_field(
        2, group="tree_type"
    )
    prefix_match_map: "MatcherMatcherTreeMatchMap" = betterproto.message_field(
        3, group="tree_type"
    )
    """Longest matching prefix wins."""

    custom_match: "___core_v3__.TypedExtensionConfig" = betterproto.message_field(
        4, group="tree_type"
    )
    """Extension for custom matching logic."""


@dataclass(eq=False, repr=False)
class MatcherMatcherTreeMatchMap(betterproto.Message):
    """
    A map of configured matchers. Used to allow using a map within a oneof.
    """

    map: Dict[str, "MatcherOnMatch"] = betterproto.map_field(
        1, betterproto.TYPE_STRING, betterproto.TYPE_MESSAGE
    )
