# Generated by the protocol buffer compiler.  DO NOT EDIT!
# sources: opencensus/proto/trace/v1/trace.proto, opencensus/proto/trace/v1/trace_config.proto
# plugin: python-betterproto
from dataclasses import dataclass
from datetime import datetime
from typing import (
    Dict,
    List,
    Optional,
)

import betterproto

from ...resource import v1 as __resource_v1__


class ConstantSamplerConstantDecision(betterproto.Enum):
    """
    How spans should be sampled: - Always off - Always on - Always follow the
    parent Span's decision (off if no parent).
    """

    ALWAYS_OFF = 0
    ALWAYS_ON = 1
    ALWAYS_PARENT = 2


class SpanSpanKind(betterproto.Enum):
    """
    Type of span. Can be used to specify additional relationships between spans
    in addition to a parent/child relationship.
    """

    SPAN_KIND_UNSPECIFIED = 0
    """Unspecified."""

    SERVER = 1
    """
    Indicates that the span covers server-side handling of an RPC or other
    remote network request.
    """

    CLIENT = 2
    """
    Indicates that the span covers the client-side wrapper around an RPC or
    other remote request.
    """


class SpanTimeEventMessageEventType(betterproto.Enum):
    """Indicates whether the message was sent or received."""

    TYPE_UNSPECIFIED = 0
    """Unknown event type."""

    SENT = 1
    """Indicates a sent message."""

    RECEIVED = 2
    """Indicates a received message."""


class SpanLinkType(betterproto.Enum):
    """
    The relationship of the current span relative to the linked span: child,
    parent, or unspecified.
    """

    TYPE_UNSPECIFIED = 0
    """
    The relationship of the two spans is unknown, or known but other than
    parent-child.
    """

    CHILD_LINKED_SPAN = 1
    """The linked span is a child of the current span."""

    PARENT_LINKED_SPAN = 2
    """The linked span is a parent of the current span."""


@dataclass(eq=False, repr=False)
class TraceConfig(betterproto.Message):
    """
    Global configuration of the trace service. All fields must be specified, or
    the default (zero) values will be used for each type.
    """

    probability_sampler: "ProbabilitySampler" = betterproto.message_field(
        1, group="sampler"
    )
    constant_sampler: "ConstantSampler" = betterproto.message_field(2, group="sampler")
    rate_limiting_sampler: "RateLimitingSampler" = betterproto.message_field(
        3, group="sampler"
    )
    max_number_of_attributes: int = betterproto.int64_field(4)
    """The global default max number of attributes per span."""

    max_number_of_annotations: int = betterproto.int64_field(5)
    """The global default max number of annotation events per span."""

    max_number_of_message_events: int = betterproto.int64_field(6)
    """The global default max number of message events per span."""

    max_number_of_links: int = betterproto.int64_field(7)
    """The global default max number of link entries per span."""


@dataclass(eq=False, repr=False)
class ProbabilitySampler(betterproto.Message):
    """
    Sampler that tries to uniformly sample traces with a given probability. The
    probability of sampling a trace is equal to that of the specified
    probability.
    """

    sampling_probability: float = betterproto.double_field(1)
    """The desired probability of sampling. Must be within [0.0, 1.0]."""


@dataclass(eq=False, repr=False)
class ConstantSampler(betterproto.Message):
    """Sampler that always makes a constant decision on span sampling."""

    decision: "ConstantSamplerConstantDecision" = betterproto.enum_field(1)


@dataclass(eq=False, repr=False)
class RateLimitingSampler(betterproto.Message):
    """Sampler that tries to sample with a rate per time window."""

    qps: int = betterproto.int64_field(1)
    """Rate per second."""


@dataclass(eq=False, repr=False)
class Span(betterproto.Message):
    """
    A span represents a single operation within a trace. Spans can be nested to
    form a trace tree. Spans may also be linked to other spans from the same or
    different trace. And form graphs. Often, a trace contains a root span that
    describes the end-to-end latency, and one or more subspans for its sub-
    operations. A trace can also contain multiple root spans, or none at all.
    Spans do not need to be contiguous - there may be gaps or overlaps between
    spans in a trace. The next id is 17. TODO(bdrutu): Add an example.
    """

    trace_id: bytes = betterproto.bytes_field(1)
    """
    A unique identifier for a trace. All spans from the same trace share the
    same `trace_id`. The ID is a 16-byte array. An ID with all zeroes is
    considered invalid. This field is semantically required. Receiver should
    generate new random trace_id if empty or invalid trace_id was received.
    This field is required.
    """

    span_id: bytes = betterproto.bytes_field(2)
    """
    A unique identifier for a span within a trace, assigned when the span is
    created. The ID is an 8-byte array. An ID with all zeroes is considered
    invalid. This field is semantically required. Receiver should generate new
    random span_id if empty or invalid span_id was received. This field is
    required.
    """

    tracestate: "SpanTracestate" = betterproto.message_field(15)
    """The Tracestate on the span."""

    parent_span_id: bytes = betterproto.bytes_field(3)
    """
    The `span_id` of this span's parent span. If this is a root span, then this
    field must be empty. The ID is an 8-byte array.
    """

    name: "TruncatableString" = betterproto.message_field(4)
    """
    A description of the span's operation. For example, the name can be a
    qualified method name or a file name and a line number where the operation
    is called. A best practice is to use the same display name at the same call
    point in an application. This makes it easier to correlate spans in
    different traces. This field is semantically required to be set to non-
    empty string. When null or empty string received - receiver may use string
    "name" as a replacement. There might be smarted algorithms implemented by
    receiver to fix the empty span name. This field is required.
    """

    kind: "SpanSpanKind" = betterproto.enum_field(14)
    """
    Distinguishes between spans generated in a particular context. For example,
    two spans with the same name may be distinguished using `CLIENT` (caller)
    and `SERVER` (callee) to identify queueing latency associated with the
    span.
    """

    start_time: datetime = betterproto.message_field(5)
    """
    The start time of the span. On the client side, this is the time kept by
    the local machine where the span execution starts. On the server side, this
    is the time when the server's application handler starts running. This
    field is semantically required. When not set on receive - receiver should
    set it to the value of end_time field if it was set. Or to the current time
    if neither was set. It is important to keep end_time > start_time for
    consistency. This field is required.
    """

    end_time: datetime = betterproto.message_field(6)
    """
    The end time of the span. On the client side, this is the time kept by the
    local machine where the span execution ends. On the server side, this is
    the time when the server application handler stops running. This field is
    semantically required. When not set on receive - receiver should set it to
    start_time value. It is important to keep end_time > start_time for
    consistency. This field is required.
    """

    attributes: "SpanAttributes" = betterproto.message_field(7)
    """A set of attributes on the span."""

    stack_trace: "StackTrace" = betterproto.message_field(8)
    """A stack trace captured at the start of the span."""

    time_events: "SpanTimeEvents" = betterproto.message_field(9)
    """The included time events."""

    links: "SpanLinks" = betterproto.message_field(10)
    """The included links."""

    status: "Status" = betterproto.message_field(11)
    """
    An optional final status for this span. Semantically when Status wasn't set
    it is means span ended without errors and assume Status.Ok (code = 0).
    """

    resource: "__resource_v1__.Resource" = betterproto.message_field(16)
    """
    An optional resource that is associated with this span. If not set, this
    span  should be part of a batch that does include the resource information,
    unless resource  information is unknown.
    """

    same_process_as_parent_span: Optional[bool] = betterproto.message_field(
        12, wraps=betterproto.TYPE_BOOL
    )
    """
    A highly recommended but not required flag that identifies when a trace
    crosses a process boundary. True when the parent_span belongs to the same
    process as the current span. This flag is most commonly used to indicate
    the need to adjust time as clocks in different processes may not be
    synchronized.
    """

    child_span_count: Optional[int] = betterproto.message_field(
        13, wraps=betterproto.TYPE_UINT32
    )
    """
    An optional number of child spans that were generated while this span was
    active. If set, allows an implementation to detect missing child spans.
    """


@dataclass(eq=False, repr=False)
class SpanTracestate(betterproto.Message):
    """
    This field conveys information about request position in multiple
    distributed tracing graphs. It is a list of Tracestate.Entry with a maximum
    of 32 members in the list. See the https://github.com/w3c/distributed-
    tracing for more details about this field.
    """

    entries: List["SpanTracestateEntry"] = betterproto.message_field(1)
    """A list of entries that represent the Tracestate."""


@dataclass(eq=False, repr=False)
class SpanTracestateEntry(betterproto.Message):
    key: str = betterproto.string_field(1)
    """
    The key must begin with a lowercase letter, and can only contain lowercase
    letters 'a'-'z', digits '0'-'9', underscores '_', dashes '-', asterisks
    '*', and forward slashes '/'.
    """

    value: str = betterproto.string_field(2)
    """
    The value is opaque string up to 256 characters printable ASCII RFC0020
    characters (i.e., the range 0x20 to 0x7E) except ',' and '='. Note that
    this also excludes tabs, newlines, carriage returns, etc.
    """


@dataclass(eq=False, repr=False)
class SpanAttributes(betterproto.Message):
    """A set of attributes, each with a key and a value."""

    attribute_map: Dict[str, "AttributeValue"] = betterproto.map_field(
        1, betterproto.TYPE_STRING, betterproto.TYPE_MESSAGE
    )
    """
    The set of attributes. The value can be a string, an integer, a double or
    the Boolean values `true` or `false`. Note, global attributes like  server
    name can be set as tags using resource API. Examples of attributes:
    "/http/user_agent": "Mozilla/5.0 (Macintosh; Intel Mac OS X 10_14_2)
    AppleWebKit/537.36 (KHTML, like Gecko) Chrome/71.0.3578.98 Safari/537.36"
    "/http/server_latency": 300     "abc.com/myattribute": true
    "abc.com/score": 10.239
    """

    dropped_attributes_count: int = betterproto.int32_field(2)
    """
    The number of attributes that were discarded. Attributes can be discarded
    because their keys are too long or because there are too many attributes.
    If this value is 0, then no attributes were dropped.
    """


@dataclass(eq=False, repr=False)
class SpanTimeEvent(betterproto.Message):
    """A time-stamped annotation or message event in the Span."""

    time: datetime = betterproto.message_field(1)
    """The time the event occurred."""

    annotation: "SpanTimeEventAnnotation" = betterproto.message_field(2, group="value")
    """A text annotation with a set of attributes."""

    message_event: "SpanTimeEventMessageEvent" = betterproto.message_field(
        3, group="value"
    )
    """An event describing a message sent/received between Spans."""


@dataclass(eq=False, repr=False)
class SpanTimeEventAnnotation(betterproto.Message):
    """A text annotation with a set of attributes."""

    description: "TruncatableString" = betterproto.message_field(1)
    """A user-supplied message describing the event."""

    attributes: "SpanAttributes" = betterproto.message_field(2)
    """A set of attributes on the annotation."""


@dataclass(eq=False, repr=False)
class SpanTimeEventMessageEvent(betterproto.Message):
    """An event describing a message sent/received between Spans."""

    type: "SpanTimeEventMessageEventType" = betterproto.enum_field(1)
    """
    The type of MessageEvent. Indicates whether the message was sent or
    received.
    """

    id: int = betterproto.uint64_field(2)
    """
    An identifier for the MessageEvent's message that can be used to match SENT
    and RECEIVED MessageEvents. For example, this field could represent a
    sequence ID for a streaming RPC. It is recommended to be unique within a
    Span.
    """

    uncompressed_size: int = betterproto.uint64_field(3)
    """The number of uncompressed bytes sent or received."""

    compressed_size: int = betterproto.uint64_field(4)
    """
    The number of compressed bytes sent or received. If zero, assumed to be the
    same size as uncompressed.
    """


@dataclass(eq=False, repr=False)
class SpanTimeEvents(betterproto.Message):
    """
    A collection of `TimeEvent`s. A `TimeEvent` is a time-stamped annotation on
    the span, consisting of either user-supplied key-value pairs, or details of
    a message sent/received between Spans.
    """

    time_event: List["SpanTimeEvent"] = betterproto.message_field(1)
    """A collection of `TimeEvent`s."""

    dropped_annotations_count: int = betterproto.int32_field(2)
    """
    The number of dropped annotations in all the included time events. If the
    value is 0, then no annotations were dropped.
    """

    dropped_message_events_count: int = betterproto.int32_field(3)
    """
    The number of dropped message events in all the included time events. If
    the value is 0, then no message events were dropped.
    """


@dataclass(eq=False, repr=False)
class SpanLink(betterproto.Message):
    """
    A pointer from the current span to another span in the same trace or in a
    different trace. For example, this can be used in batching operations,
    where a single batch handler processes multiple requests from different
    traces or when the handler receives a request from a different project.
    """

    trace_id: bytes = betterproto.bytes_field(1)
    """
    A unique identifier of a trace that this linked span is part of. The ID is
    a  16-byte array.
    """

    span_id: bytes = betterproto.bytes_field(2)
    """A unique identifier for the linked span. The ID is an 8-byte array."""

    type: "SpanLinkType" = betterproto.enum_field(3)
    """The relationship of the current span relative to the linked span."""

    attributes: "SpanAttributes" = betterproto.message_field(4)
    """A set of attributes on the link."""


@dataclass(eq=False, repr=False)
class SpanLinks(betterproto.Message):
    """
    A collection of links, which are references from this span to a span in the
    same or different trace.
    """

    link: List["SpanLink"] = betterproto.message_field(1)
    """A collection of links."""

    dropped_links_count: int = betterproto.int32_field(2)
    """
    The number of dropped links after the maximum size was enforced. If this
    value is 0, then no links were dropped.
    """


@dataclass(eq=False, repr=False)
class Status(betterproto.Message):
    """
    The `Status` type defines a logical error model that is suitable for
    different programming environments, including REST APIs and RPC APIs. This
    proto's fields are a subset of those of [google.rpc.Status](https://github.
    com/googleapis/googleapis/blob/master/google/rpc/status.proto), which is
    used by [gRPC](https://github.com/grpc).
    """

    code: int = betterproto.int32_field(1)
    """
    The status code. This is optional field. It is safe to assume 0 (OK) when
    not set.
    """

    message: str = betterproto.string_field(2)
    """A developer-facing error message, which should be in English."""


@dataclass(eq=False, repr=False)
class AttributeValue(betterproto.Message):
    """The value of an Attribute."""

    string_value: "TruncatableString" = betterproto.message_field(1, group="value")
    """A string up to 256 bytes long."""

    int_value: int = betterproto.int64_field(2, group="value")
    """A 64-bit signed integer."""

    bool_value: bool = betterproto.bool_field(3, group="value")
    """A Boolean value represented by `true` or `false`."""

    double_value: float = betterproto.double_field(4, group="value")
    """A double value."""


@dataclass(eq=False, repr=False)
class StackTrace(betterproto.Message):
    """The call stack which originated this span."""

    stack_frames: "StackTraceStackFrames" = betterproto.message_field(1)
    """Stack frames in this stack trace."""

    stack_trace_hash_id: int = betterproto.uint64_field(2)
    """
    The hash ID is used to conserve network bandwidth for duplicate stack
    traces within a single trace. Often multiple spans will have identical
    stack traces. The first occurrence of a stack trace should contain both
    `stack_frames` and a value in `stack_trace_hash_id`. Subsequent spans
    within the same request can refer to that stack trace by setting only
    `stack_trace_hash_id`. TODO: describe how to deal with the case where
    stack_trace_hash_id is zero because it was not set.
    """


@dataclass(eq=False, repr=False)
class StackTraceStackFrame(betterproto.Message):
    """A single stack frame in a stack trace."""

    function_name: "TruncatableString" = betterproto.message_field(1)
    """
    The fully-qualified name that uniquely identifies the function or method
    that is active in this frame.
    """

    original_function_name: "TruncatableString" = betterproto.message_field(2)
    """
    An un-mangled function name, if `function_name` is
    [mangled](http://www.avabodh.com/cxxin/namemangling.html). The name can be
    fully qualified.
    """

    file_name: "TruncatableString" = betterproto.message_field(3)
    """The name of the source file where the function call appears."""

    line_number: int = betterproto.int64_field(4)
    """The line number in `file_name` where the function call appears."""

    column_number: int = betterproto.int64_field(5)
    """
    The column number where the function call appears, if available. This is
    important in JavaScript because of its anonymous functions.
    """

    load_module: "Module" = betterproto.message_field(6)
    """The binary module from where the code was loaded."""

    source_version: "TruncatableString" = betterproto.message_field(7)
    """The version of the deployed source code."""


@dataclass(eq=False, repr=False)
class StackTraceStackFrames(betterproto.Message):
    """A collection of stack frames, which can be truncated."""

    frame: List["StackTraceStackFrame"] = betterproto.message_field(1)
    """Stack frames in this call stack."""

    dropped_frames_count: int = betterproto.int32_field(2)
    """
    The number of stack frames that were dropped because there were too many
    stack frames. If this value is 0, then no stack frames were dropped.
    """


@dataclass(eq=False, repr=False)
class Module(betterproto.Message):
    """A description of a binary module."""

    module: "TruncatableString" = betterproto.message_field(1)
    """
    TODO: document the meaning of this field. For example: main binary, kernel
    modules, and dynamic libraries such as libc.so, sharedlib.so.
    """

    build_id: "TruncatableString" = betterproto.message_field(2)
    """A unique identifier for the module, usually a hash of its contents."""


@dataclass(eq=False, repr=False)
class TruncatableString(betterproto.Message):
    """A string that might be shortened to a specified length."""

    value: str = betterproto.string_field(1)
    """
    The shortened string. For example, if the original string was 500 bytes
    long and the limit of the string was 128 bytes, then this value contains
    the first 128 bytes of the 500-byte string. Note that truncation always
    happens on a character boundary, to ensure that a truncated string is still
    valid UTF-8. Because it may contain multi-byte characters, the size of the
    truncated string may be less than the truncation limit.
    """

    truncated_byte_count: int = betterproto.int32_field(2)
    """
    The number of bytes removed from the original string. If this value is 0,
    then the string was not shortened.
    """
