# Generated by the protocol buffer compiler.  DO NOT EDIT!
# sources: io/prometheus/client/metrics.proto
# plugin: python-betterproto
from dataclasses import dataclass
from datetime import datetime
from typing import List

import betterproto


class MetricType(betterproto.Enum):
    COUNTER = 0
    """COUNTER must use the Metric field "counter"."""

    GAUGE = 1
    """GAUGE must use the Metric field "gauge"."""

    SUMMARY = 2
    """SUMMARY must use the Metric field "summary"."""

    UNTYPED = 3
    """UNTYPED must use the Metric field "untyped"."""

    HISTOGRAM = 4
    """HISTOGRAM must use the Metric field "histogram"."""

    GAUGE_HISTOGRAM = 5
    """GAUGE_HISTOGRAM must use the Metric field "histogram"."""


@dataclass(eq=False, repr=False)
class LabelPair(betterproto.Message):
    name: str = betterproto.string_field(1)
    value: str = betterproto.string_field(2)


@dataclass(eq=False, repr=False)
class Gauge(betterproto.Message):
    value: float = betterproto.double_field(1)


@dataclass(eq=False, repr=False)
class Counter(betterproto.Message):
    value: float = betterproto.double_field(1)
    exemplar: "Exemplar" = betterproto.message_field(2)


@dataclass(eq=False, repr=False)
class Quantile(betterproto.Message):
    quantile: float = betterproto.double_field(1)
    value: float = betterproto.double_field(2)


@dataclass(eq=False, repr=False)
class Summary(betterproto.Message):
    sample_count: int = betterproto.uint64_field(1)
    sample_sum: float = betterproto.double_field(2)
    quantile: List["Quantile"] = betterproto.message_field(3)


@dataclass(eq=False, repr=False)
class Untyped(betterproto.Message):
    value: float = betterproto.double_field(1)


@dataclass(eq=False, repr=False)
class Histogram(betterproto.Message):
    sample_count: int = betterproto.uint64_field(1)
    sample_count_float: float = betterproto.double_field(4)
    sample_sum: float = betterproto.double_field(2)
    bucket: List["Bucket"] = betterproto.message_field(3)
    """Buckets for the conventional histogram."""

    schema: int = betterproto.sint32_field(5)
    """
    schema defines the bucket schema. Currently, valid numbers are -4 <= n <=
    8. They are all for base-2 bucket schemas, where 1 is a bucket boundary in
    each case, and then each power of two is divided into 2^n logarithmic
    buckets. Or in other words, each bucket boundary is the previous boundary
    times 2^(2^-n). In the future, more bucket schemas may be added using
    numbers < -4 or > 8.
    """

    zero_threshold: float = betterproto.double_field(6)
    zero_count: int = betterproto.uint64_field(7)
    zero_count_float: float = betterproto.double_field(8)
    negative_span: List["BucketSpan"] = betterproto.message_field(9)
    """Negative buckets for the native histogram."""

    negative_delta: List[int] = betterproto.sint64_field(10)
    """
    Use either "negative_delta" or "negative_count", the former for regular
    histograms with integer counts, the latter for float histograms.
    """

    negative_count: List[float] = betterproto.double_field(11)
    positive_span: List["BucketSpan"] = betterproto.message_field(12)
    """Positive buckets for the native histogram."""

    positive_delta: List[int] = betterproto.sint64_field(13)
    """
    Use either "positive_delta" or "positive_count", the former for regular
    histograms with integer counts, the latter for float histograms.
    """

    positive_count: List[float] = betterproto.double_field(14)


@dataclass(eq=False, repr=False)
class Bucket(betterproto.Message):
    """
    A Bucket of a conventional histogram, each of which is treated as an
    individual counter-like time series by Prometheus.
    """

    cumulative_count: int = betterproto.uint64_field(1)
    cumulative_count_float: float = betterproto.double_field(4)
    upper_bound: float = betterproto.double_field(2)
    exemplar: "Exemplar" = betterproto.message_field(3)


@dataclass(eq=False, repr=False)
class BucketSpan(betterproto.Message):
    """
    A BucketSpan defines a number of consecutive buckets in a native histogram
    with their offset. Logically, it would be more straightforward to include
    the bucket counts in the Span. However, the protobuf representation is more
    compact in the way the data is structured here (with all the buckets in a
    single array separate from the Spans).
    """

    offset: int = betterproto.sint32_field(1)
    length: int = betterproto.uint32_field(2)


@dataclass(eq=False, repr=False)
class Exemplar(betterproto.Message):
    label: List["LabelPair"] = betterproto.message_field(1)
    value: float = betterproto.double_field(2)
    timestamp: datetime = betterproto.message_field(3)


@dataclass(eq=False, repr=False)
class Metric(betterproto.Message):
    label: List["LabelPair"] = betterproto.message_field(1)
    gauge: "Gauge" = betterproto.message_field(2)
    counter: "Counter" = betterproto.message_field(3)
    summary: "Summary" = betterproto.message_field(4)
    untyped: "Untyped" = betterproto.message_field(5)
    histogram: "Histogram" = betterproto.message_field(7)
    timestamp_ms: int = betterproto.int64_field(6)


@dataclass(eq=False, repr=False)
class MetricFamily(betterproto.Message):
    name: str = betterproto.string_field(1)
    help: str = betterproto.string_field(2)
    type: "MetricType" = betterproto.enum_field(3)
    metric: List["Metric"] = betterproto.message_field(4)
