# Generated by the protocol buffer compiler.  DO NOT EDIT!
# sources: google/api/expr/v1alpha1/checked.proto, google/api/expr/v1alpha1/syntax.proto
# plugin: python-betterproto
import warnings
from dataclasses import dataclass
from datetime import (
    datetime,
    timedelta,
)
from typing import (
    Dict,
    List,
)

import betterproto
import betterproto.lib.google.protobuf as betterproto_lib_google_protobuf


class TypePrimitiveType(betterproto.Enum):
    """CEL primitive types."""

    PRIMITIVE_TYPE_UNSPECIFIED = 0
    """Unspecified type."""

    BOOL = 1
    """Boolean type."""

    INT64 = 2
    """Int64 type. Proto-based integer values are widened to int64."""

    UINT64 = 3
    """
    Uint64 type. Proto-based unsigned integer values are widened to uint64.
    """

    DOUBLE = 4
    """Double type. Proto-based float values are widened to double values."""

    STRING = 5
    """String type."""

    BYTES = 6
    """Bytes type."""


class TypeWellKnownType(betterproto.Enum):
    """Well-known protobuf types treated with first-class support in CEL."""

    WELL_KNOWN_TYPE_UNSPECIFIED = 0
    """Unspecified type."""

    ANY = 1
    """
    Well-known protobuf.Any type. Any types are a polymorphic message type.
    During type-checking they are treated like `DYN` types, but at runtime they
    are resolved to a specific message type specified at evaluation time.
    """

    TIMESTAMP = 2
    """
    Well-known protobuf.Timestamp type, internally referenced as `timestamp`.
    """

    DURATION = 3
    """
    Well-known protobuf.Duration type, internally referenced as `duration`.
    """


@dataclass(eq=False, repr=False)
class ParsedExpr(betterproto.Message):
    """
    An expression together with source information as returned by the parser.
    """

    expr: "Expr" = betterproto.message_field(2)
    """The parsed expression."""

    source_info: "SourceInfo" = betterproto.message_field(3)
    """The source info derived from input that generated the parsed `expr`."""


@dataclass(eq=False, repr=False)
class Expr(betterproto.Message):
    """
    An abstract representation of a common expression. Expressions are
    abstractly represented as a collection of identifiers, select statements,
    function calls, literals, and comprehensions. All operators with the
    exception of the '.' operator are modelled as function calls. This makes it
    easy to represent new operators into the existing AST. All references
    within expressions must resolve to a [Decl][google.api.expr.v1alpha1.Decl]
    provided at type-check for an expression to be valid. A reference may
    either be a bare identifier `name` or a qualified identifier
    `google.api.name`. References may either refer to a value or a function
    declaration. For example, the expression
    `google.api.name.startsWith('expr')` references the declaration
    `google.api.name` within a
    [Expr.Select][google.api.expr.v1alpha1.Expr.Select] expression, and the
    function declaration `startsWith`.
    """

    id: int = betterproto.int64_field(2)
    """
    Required. An id assigned to this node by the parser which is unique in a
    given expression tree. This is used to associate type information and other
    attributes to a node in the parse tree.
    """

    const_expr: "Constant" = betterproto.message_field(3, group="expr_kind")
    """A literal expression."""

    ident_expr: "ExprIdent" = betterproto.message_field(4, group="expr_kind")
    """An identifier expression."""

    select_expr: "ExprSelect" = betterproto.message_field(5, group="expr_kind")
    """A field selection expression, e.g. `request.auth`."""

    call_expr: "ExprCall" = betterproto.message_field(6, group="expr_kind")
    """
    A call expression, including calls to predefined functions and operators.
    """

    list_expr: "ExprCreateList" = betterproto.message_field(7, group="expr_kind")
    """A list creation expression."""

    struct_expr: "ExprCreateStruct" = betterproto.message_field(8, group="expr_kind")
    """A map or message creation expression."""

    comprehension_expr: "ExprComprehension" = betterproto.message_field(
        9, group="expr_kind"
    )
    """A comprehension expression."""


@dataclass(eq=False, repr=False)
class ExprIdent(betterproto.Message):
    """An identifier expression. e.g. `request`."""

    name: str = betterproto.string_field(1)
    """
    Required. Holds a single, unqualified identifier, possibly preceded by a
    '.'. Qualified names are represented by the
    [Expr.Select][google.api.expr.v1alpha1.Expr.Select] expression.
    """


@dataclass(eq=False, repr=False)
class ExprSelect(betterproto.Message):
    """A field selection expression. e.g. `request.auth`."""

    operand: "Expr" = betterproto.message_field(1)
    """
    Required. The target of the selection expression. For example, in the
    select expression `request.auth`, the `request` portion of the expression
    is the `operand`.
    """

    field: str = betterproto.string_field(2)
    """
    Required. The name of the field to select. For example, in the select
    expression `request.auth`, the `auth` portion of the expression would be
    the `field`.
    """

    test_only: bool = betterproto.bool_field(3)
    """
    Whether the select is to be interpreted as a field presence test. This
    results from the macro `has(request.auth)`.
    """


@dataclass(eq=False, repr=False)
class ExprCall(betterproto.Message):
    """
    A call expression, including calls to predefined functions and operators.
    For example, `value == 10`, `size(map_value)`.
    """

    target: "Expr" = betterproto.message_field(1)
    """
    The target of an method call-style expression. For example, `x` in `x.f()`.
    """

    function: str = betterproto.string_field(2)
    """Required. The name of the function or method being called."""

    args: List["Expr"] = betterproto.message_field(3)
    """The arguments."""


@dataclass(eq=False, repr=False)
class ExprCreateList(betterproto.Message):
    """
    A list creation expression. Lists may either be homogenous, e.g. `[1, 2,
    3]`, or heterogeneous, e.g. `dyn([1, 'hello', 2.0])`
    """

    elements: List["Expr"] = betterproto.message_field(1)
    """The elements part of the list."""


@dataclass(eq=False, repr=False)
class ExprCreateStruct(betterproto.Message):
    """
    A map or message creation expression. Maps are constructed as `{'key_name':
    'value'}`. Message construction is similar, but prefixed with a type name
    and composed of field ids: `types.MyType{field_id: 'value'}`.
    """

    message_name: str = betterproto.string_field(1)
    """
    The type name of the message to be created, empty when creating map
    literals.
    """

    entries: List["ExprCreateStructEntry"] = betterproto.message_field(2)
    """The entries in the creation expression."""


@dataclass(eq=False, repr=False)
class ExprCreateStructEntry(betterproto.Message):
    """Represents an entry."""

    id: int = betterproto.int64_field(1)
    """
    Required. An id assigned to this node by the parser which is unique in a
    given expression tree. This is used to associate type information and other
    attributes to the node.
    """

    field_key: str = betterproto.string_field(2, group="key_kind")
    """The field key for a message creator statement."""

    map_key: "Expr" = betterproto.message_field(3, group="key_kind")
    """The key expression for a map creation statement."""

    value: "Expr" = betterproto.message_field(4)
    """
    Required. The value assigned to the key. If the optional_entry field is
    true, the expression must resolve to an optional-typed value. If the
    optional value is present, the key will be set; however, if the optional
    value is absent, the key will be unset.
    """

    optional_entry: bool = betterproto.bool_field(5)
    """Whether the key-value pair is optional."""


@dataclass(eq=False, repr=False)
class ExprComprehension(betterproto.Message):
    """
    A comprehension expression applied to a list or map. Comprehensions are not
    part of the core syntax, but enabled with macros. A macro matches a
    specific call signature within a parsed AST and replaces the call with an
    alternate AST block. Macro expansion happens at parse time. The following
    macros are supported within CEL: Aggregate type macros may be applied to
    all elements in a list or all keys in a map: *  `all`, `exists`,
    `exists_one` -  test a predicate expression against    the inputs and
    return `true` if the predicate is satisfied for all,    any, or only one
    value `list.all(x, x < 10)`. *  `filter` - test a predicate expression
    against the inputs and return    the subset of elements which satisfy the
    predicate:    `payments.filter(p, p > 1000)`. *  `map` - apply an
    expression to all elements in the input and return the    output aggregate
    type: `[1, 2, 3].map(i, i * i)`. The `has(m.x)` macro tests whether the
    property `x` is present in struct `m`. The semantics of this macro depend
    on the type of `m`. For proto2 messages `has(m.x)` is defined as 'defined,
    but not set`. For proto3, the macro tests whether the property is set to
    its default. For map and struct types, the macro tests whether the property
    `x` is defined on `m`.
    """

    iter_var: str = betterproto.string_field(1)
    """The name of the iteration variable."""

    iter_range: "Expr" = betterproto.message_field(2)
    """The range over which var iterates."""

    accu_var: str = betterproto.string_field(3)
    """The name of the variable used for accumulation of the result."""

    accu_init: "Expr" = betterproto.message_field(4)
    """The initial value of the accumulator."""

    loop_condition: "Expr" = betterproto.message_field(5)
    """
    An expression which can contain iter_var and accu_var. Returns false when
    the result has been computed and may be used as a hint to short-circuit the
    remainder of the comprehension.
    """

    loop_step: "Expr" = betterproto.message_field(6)
    """
    An expression which can contain iter_var and accu_var. Computes the next
    value of accu_var.
    """

    result: "Expr" = betterproto.message_field(7)
    """An expression which can contain accu_var. Computes the result."""


@dataclass(eq=False, repr=False)
class Constant(betterproto.Message):
    """
    Represents a primitive literal. Named 'Constant' here for backwards
    compatibility. This is similar as the primitives supported in the well-
    known type `google.protobuf.Value`, but richer so it can represent CEL's
    full range of primitives. Lists and structs are not included as constants
    as these aggregate types may contain [Expr][google.api.expr.v1alpha1.Expr]
    elements which require evaluation and are thus not constant. Examples of
    literals include: `"hello"`, `b'bytes'`, `1u`, `4.2`, `-2`, `true`, `null`.
    """

    null_value: "betterproto_lib_google_protobuf.NullValue" = betterproto.enum_field(
        1, group="constant_kind"
    )
    """null value."""

    bool_value: bool = betterproto.bool_field(2, group="constant_kind")
    """boolean value."""

    int64_value: int = betterproto.int64_field(3, group="constant_kind")
    """int64 value."""

    uint64_value: int = betterproto.uint64_field(4, group="constant_kind")
    """uint64 value."""

    double_value: float = betterproto.double_field(5, group="constant_kind")
    """double value."""

    string_value: str = betterproto.string_field(6, group="constant_kind")
    """string value."""

    bytes_value: bytes = betterproto.bytes_field(7, group="constant_kind")
    """bytes value."""

    duration_value: timedelta = betterproto.message_field(8, group="constant_kind")
    """
    protobuf.Duration value. Deprecated: duration is no longer considered a
    builtin cel type.
    """

    timestamp_value: datetime = betterproto.message_field(9, group="constant_kind")
    """
    protobuf.Timestamp value. Deprecated: timestamp is no longer considered a
    builtin cel type.
    """

    def __post_init__(self) -> None:
        super().__post_init__()
        if self.is_set("duration_value"):
            warnings.warn("Constant.duration_value is deprecated", DeprecationWarning)
        if self.is_set("timestamp_value"):
            warnings.warn("Constant.timestamp_value is deprecated", DeprecationWarning)


@dataclass(eq=False, repr=False)
class SourceInfo(betterproto.Message):
    """Source information collected at parse time."""

    syntax_version: str = betterproto.string_field(1)
    """The syntax version of the source, e.g. `cel1`."""

    location: str = betterproto.string_field(2)
    """
    The location name. All position information attached to an expression is
    relative to this location. The location could be a file, UI element, or
    similar. For example, `acme/app/AnvilPolicy.cel`.
    """

    line_offsets: List[int] = betterproto.int32_field(3)
    """
    Monotonically increasing list of code point offsets where newlines `\n`
    appear. The line number of a given position is the index `i` where for a
    given `id` the `line_offsets[i] < id_positions[id] < line_offsets[i+1]`.
    The column may be derivd from `id_positions[id] - line_offsets[i]`.
    """

    positions: Dict[int, int] = betterproto.map_field(
        4, betterproto.TYPE_INT64, betterproto.TYPE_INT32
    )
    """
    A map from the parse node id (e.g. `Expr.id`) to the code point offset
    within the source.
    """

    macro_calls: Dict[int, "Expr"] = betterproto.map_field(
        5, betterproto.TYPE_INT64, betterproto.TYPE_MESSAGE
    )
    """
    A map from the parse node id where a macro replacement was made to the call
    `Expr` that resulted in a macro expansion. For example, `has(value.field)`
    is a function call that is replaced by a `test_only` field selection in the
    AST. Likewise, the call `list.exists(e, e > 10)` translates to a
    comprehension expression. The key in the map corresponds to the expression
    id of the expanded macro, and the value is the call `Expr` that was
    replaced.
    """


@dataclass(eq=False, repr=False)
class SourcePosition(betterproto.Message):
    """A specific position in source."""

    location: str = betterproto.string_field(1)
    """The soucre location name (e.g. file name)."""

    offset: int = betterproto.int32_field(2)
    """The UTF-8 code unit offset."""

    line: int = betterproto.int32_field(3)
    """
    The 1-based index of the starting line in the source text where the issue
    occurs, or 0 if unknown.
    """

    column: int = betterproto.int32_field(4)
    """
    The 0-based index of the starting position within the line of source text
    where the issue occurs.  Only meaningful if line is nonzero.
    """


@dataclass(eq=False, repr=False)
class CheckedExpr(betterproto.Message):
    """A CEL expression which has been successfully type checked."""

    reference_map: Dict[int, "Reference"] = betterproto.map_field(
        2, betterproto.TYPE_INT64, betterproto.TYPE_MESSAGE
    )
    """
    A map from expression ids to resolved references. The following entries are
    in this table: - An Ident or Select expression is represented here if it
    resolves to a   declaration. For instance, if `a.b.c` is represented by
    `select(select(id(a), b), c)`, and `a.b` resolves to a declaration,   while
    `c` is a field selection, then the reference is attached to the   nested
    select expression (but not to the id or or the outer select).   In turn, if
    `a` resolves to a declaration and `b.c` are field selections,   the
    reference is attached to the ident expression. - Every Call expression has
    an entry here, identifying the function being   called. - Every
    CreateStruct expression for a message has an entry, identifying   the
    message.
    """

    type_map: Dict[int, "Type"] = betterproto.map_field(
        3, betterproto.TYPE_INT64, betterproto.TYPE_MESSAGE
    )
    """
    A map from expression ids to types. Every expression node which has a type
    different than DYN has a mapping here. If an expression has type DYN, it is
    omitted from this map to save space.
    """

    source_info: "SourceInfo" = betterproto.message_field(5)
    """
    The source info derived from input that generated the parsed `expr` and any
    optimizations made during the type-checking pass.
    """

    expr_version: str = betterproto.string_field(6)
    """
    The expr version indicates the major / minor version number of the `expr`
    representation. The most common reason for a version change will be to
    indicate to the CEL runtimes that transformations have been performed on
    the expr during static analysis. In some cases, this will save the runtime
    the work of applying the same or similar transformations prior to
    evaluation.
    """

    expr: "Expr" = betterproto.message_field(4)
    """
    The checked expression. Semantically equivalent to the parsed `expr`, but
    may have structural differences.
    """


@dataclass(eq=False, repr=False)
class Type(betterproto.Message):
    """Represents a CEL type."""

    dyn: "betterproto_lib_google_protobuf.Empty" = betterproto.message_field(
        1, group="type_kind"
    )
    """Dynamic type."""

    null: "betterproto_lib_google_protobuf.NullValue" = betterproto.enum_field(
        2, group="type_kind"
    )
    """Null value."""

    primitive: "TypePrimitiveType" = betterproto.enum_field(3, group="type_kind")
    """Primitive types: `true`, `1u`, `-2.0`, `'string'`, `b'bytes'`."""

    wrapper: "TypePrimitiveType" = betterproto.enum_field(4, group="type_kind")
    """Wrapper of a primitive type, e.g. `google.protobuf.Int64Value`."""

    well_known: "TypeWellKnownType" = betterproto.enum_field(5, group="type_kind")
    """Well-known protobuf type such as `google.protobuf.Timestamp`."""

    list_type: "TypeListType" = betterproto.message_field(6, group="type_kind")
    """
    Parameterized list with elements of `list_type`, e.g. `list<timestamp>`.
    """

    map_type: "TypeMapType" = betterproto.message_field(7, group="type_kind")
    """Parameterized map with typed keys and values."""

    function: "TypeFunctionType" = betterproto.message_field(8, group="type_kind")
    """Function type."""

    message_type: str = betterproto.string_field(9, group="type_kind")
    """
    Protocol buffer message type. The `message_type` string specifies the
    qualified message type name. For example, `google.plus.Profile`.
    """

    type_param: str = betterproto.string_field(10, group="type_kind")
    """
    Type param type. The `type_param` string specifies the type parameter name,
    e.g. `list<E>` would be a `list_type` whose element type was a `type_param`
    type named `E`.
    """

    type: "Type" = betterproto.message_field(11, group="type_kind")
    """
    Type type. The `type` value specifies the target type. e.g. int is type
    with a target type of `Primitive.INT`.
    """

    error: "betterproto_lib_google_protobuf.Empty" = betterproto.message_field(
        12, group="type_kind"
    )
    """
    Error type. During type-checking if an expression is an error, its type is
    propagated as the `ERROR` type. This permits the type-checker to discover
    other errors present in the expression.
    """

    abstract_type: "TypeAbstractType" = betterproto.message_field(14, group="type_kind")
    """Abstract, application defined type."""


@dataclass(eq=False, repr=False)
class TypeListType(betterproto.Message):
    """List type with typed elements, e.g. `list<example.proto.MyMessage>`."""

    elem_type: "Type" = betterproto.message_field(1)
    """The element type."""


@dataclass(eq=False, repr=False)
class TypeMapType(betterproto.Message):
    """
    Map type with parameterized key and value types, e.g. `map<string, int>`.
    """

    key_type: "Type" = betterproto.message_field(1)
    """The type of the key."""

    value_type: "Type" = betterproto.message_field(2)
    """The type of the value."""


@dataclass(eq=False, repr=False)
class TypeFunctionType(betterproto.Message):
    """Function type with result and arg types."""

    result_type: "Type" = betterproto.message_field(1)
    """Result type of the function."""

    arg_types: List["Type"] = betterproto.message_field(2)
    """Argument types of the function."""


@dataclass(eq=False, repr=False)
class TypeAbstractType(betterproto.Message):
    """Application defined abstract type."""

    name: str = betterproto.string_field(1)
    """The fully qualified name of this abstract type."""

    parameter_types: List["Type"] = betterproto.message_field(2)
    """Parameter types for this abstract type."""


@dataclass(eq=False, repr=False)
class Decl(betterproto.Message):
    """
    Represents a declaration of a named value or function. A declaration is
    part of the contract between the expression, the agent evaluating that
    expression, and the caller requesting evaluation.
    """

    name: str = betterproto.string_field(1)
    """
    The fully qualified name of the declaration. Declarations are organized in
    containers and this represents the full path to the declaration in its
    container, as in `google.api.expr.Decl`. Declarations used as [FunctionDecl
    .Overload][google.api.expr.v1alpha1.Decl.FunctionDecl.Overload] parameters
    may or may not have a name depending on whether the overload is function
    declaration or a function definition containing a result
    [Expr][google.api.expr.v1alpha1.Expr].
    """

    ident: "DeclIdentDecl" = betterproto.message_field(2, group="decl_kind")
    """Identifier declaration."""

    function: "DeclFunctionDecl" = betterproto.message_field(3, group="decl_kind")
    """Function declaration."""


@dataclass(eq=False, repr=False)
class DeclIdentDecl(betterproto.Message):
    """
    Identifier declaration which specifies its type and optional `Expr` value.
    An identifier without a value is a declaration that must be provided at
    evaluation time. An identifier with a value should resolve to a constant,
    but may be used in conjunction with other identifiers bound at evaluation
    time.
    """

    type: "Type" = betterproto.message_field(1)
    """Required. The type of the identifier."""

    value: "Constant" = betterproto.message_field(2)
    """
    The constant value of the identifier. If not specified, the identifier must
    be supplied at evaluation time.
    """

    doc: str = betterproto.string_field(3)
    """Documentation string for the identifier."""


@dataclass(eq=False, repr=False)
class DeclFunctionDecl(betterproto.Message):
    """
    Function declaration specifies one or more overloads which indicate the
    function's parameter types and return type. Functions have no observable
    side-effects (there may be side-effects like logging which are not
    observable from CEL).
    """

    overloads: List["DeclFunctionDeclOverload"] = betterproto.message_field(1)
    """
    Required. List of function overloads, must contain at least one overload.
    """


@dataclass(eq=False, repr=False)
class DeclFunctionDeclOverload(betterproto.Message):
    """
    An overload indicates a function's parameter types and return type, and may
    optionally include a function body described in terms of
    [Expr][google.api.expr.v1alpha1.Expr] values. Functions overloads are
    declared in either a function or method call-style. For methods, the
    `params[0]` is the expected type of the target receiver. Overloads must
    have non-overlapping argument types after erasure of all parameterized type
    variables (similar as type erasure in Java).
    """

    overload_id: str = betterproto.string_field(1)
    """
    Required. Globally unique overload name of the function which reflects the
    function name and argument types. This will be used by a
    [Reference][google.api.expr.v1alpha1.Reference] to indicate the
    `overload_id` that was resolved for the function `name`.
    """

    params: List["Type"] = betterproto.message_field(2)
    """
    List of function parameter [Type][google.api.expr.v1alpha1.Type] values.
    Param types are disjoint after generic type parameters have been replaced
    with the type `DYN`. Since the `DYN` type is compatible with any other
    type, this means that if `A` is a type parameter, the function types
    `int<A>` and `int<int>` are not disjoint. Likewise, `map<string, string>`
    is not disjoint from `map<K, V>`. When the `result_type` of a function is a
    generic type param, the type param name also appears as the `type` of on at
    least one params.
    """

    type_params: List[str] = betterproto.string_field(3)
    """
    The type param names associated with the function declaration. For example,
    `function ex<K,V>(K key, map<K, V> map) : V` would yield the type params of
    `K, V`.
    """

    result_type: "Type" = betterproto.message_field(4)
    """
    Required. The result type of the function. For example, the operator
    `string.isEmpty()` would have `result_type` of `kind: BOOL`.
    """

    is_instance_function: bool = betterproto.bool_field(5)
    """
    Whether the function is to be used in a method call-style `x.f(...)` or a
    function call-style `f(x, ...)`. For methods, the first parameter
    declaration, `params[0]` is the expected type of the target receiver.
    """

    doc: str = betterproto.string_field(6)
    """Documentation string for the overload."""


@dataclass(eq=False, repr=False)
class Reference(betterproto.Message):
    """Describes a resolved reference to a declaration."""

    name: str = betterproto.string_field(1)
    """The fully qualified name of the declaration."""

    overload_id: List[str] = betterproto.string_field(3)
    """
    For references to functions, this is a list of `Overload.overload_id`
    values which match according to typing rules. If the list has more than one
    element, overload resolution among the presented candidates must happen at
    runtime because of dynamic types. The type checker attempts to narrow down
    this list as much as possible. Empty if this is not a reference to a
    [Decl.FunctionDecl][google.api.expr.v1alpha1.Decl.FunctionDecl].
    """

    value: "Constant" = betterproto.message_field(4)
    """
    For references to constants, this may contain the value of the constant if
    known at compile time.
    """
