# Generated by the protocol buffer compiler.  DO NOT EDIT!
# sources: envoy/type/v3/hash_policy.proto, envoy/type/v3/http.proto, envoy/type/v3/http_status.proto, envoy/type/v3/percent.proto, envoy/type/v3/range.proto, envoy/type/v3/ratelimit_strategy.proto, envoy/type/v3/ratelimit_unit.proto, envoy/type/v3/semantic_version.proto, envoy/type/v3/token_bucket.proto
# plugin: python-betterproto
from dataclasses import dataclass
from datetime import timedelta
from typing import Optional

import betterproto


class FractionalPercentDenominatorType(betterproto.Enum):
    """Fraction percentages support several fixed denominator values."""

    HUNDRED = 0
    """100. **Example**: 1/100 = 1%."""

    TEN_THOUSAND = 1
    """10,000. **Example**: 1/10000 = 0.01%."""

    MILLION = 2
    """1,000,000. **Example**: 1/1000000 = 0.0001%."""


class CodecClientType(betterproto.Enum):
    HTTP1 = 0
    HTTP2 = 1
    HTTP3 = 2
    """
    [#not-implemented-hide:] QUIC implementation is not production ready yet.
    Use this enum with caution to prevent accidental execution of QUIC code.
    I.e. `!= HTTP2` is no longer sufficient to distinguish HTTP1 and HTTP2
    traffic.
    """


class StatusCode(betterproto.Enum):
    """
    HTTP response codes supported in Envoy. For more details:
    https://www.iana.org/assignments/http-status-codes/http-status-codes.xhtml
    """

    Empty = 0
    """
    Empty - This code not part of the HTTP status code specification, but it is
    needed for proto `enum` type.
    """

    Continue = 100
    OK = 200
    Created = 201
    Accepted = 202
    NonAuthoritativeInformation = 203
    NoContent = 204
    ResetContent = 205
    PartialContent = 206
    MultiStatus = 207
    AlreadyReported = 208
    IMUsed = 226
    MultipleChoices = 300
    MovedPermanently = 301
    Found = 302
    SeeOther = 303
    NotModified = 304
    UseProxy = 305
    TemporaryRedirect = 307
    PermanentRedirect = 308
    BadRequest = 400
    Unauthorized = 401
    PaymentRequired = 402
    Forbidden = 403
    NotFound = 404
    MethodNotAllowed = 405
    NotAcceptable = 406
    ProxyAuthenticationRequired = 407
    RequestTimeout = 408
    Conflict = 409
    Gone = 410
    LengthRequired = 411
    PreconditionFailed = 412
    PayloadTooLarge = 413
    URITooLong = 414
    UnsupportedMediaType = 415
    RangeNotSatisfiable = 416
    ExpectationFailed = 417
    MisdirectedRequest = 421
    UnprocessableEntity = 422
    Locked = 423
    FailedDependency = 424
    UpgradeRequired = 426
    PreconditionRequired = 428
    TooManyRequests = 429
    RequestHeaderFieldsTooLarge = 431
    InternalServerError = 500
    NotImplemented = 501
    BadGateway = 502
    ServiceUnavailable = 503
    GatewayTimeout = 504
    HTTPVersionNotSupported = 505
    VariantAlsoNegotiates = 506
    InsufficientStorage = 507
    LoopDetected = 508
    NotExtended = 510
    NetworkAuthenticationRequired = 511


class RateLimitUnit(betterproto.Enum):
    """Identifies the unit of of time for rate limit."""

    UNKNOWN = 0
    """The time unit is not known."""

    SECOND = 1
    """The time unit representing a second."""

    MINUTE = 2
    """The time unit representing a minute."""

    HOUR = 3
    """The time unit representing an hour."""

    DAY = 4
    """The time unit representing a day."""


class RateLimitStrategyBlanketRule(betterproto.Enum):
    """Choose between allow all and deny all."""

    ALLOW_ALL = 0
    DENY_ALL = 1


@dataclass(eq=False, repr=False)
class Percent(betterproto.Message):
    """Identifies a percentage, in the range [0.0, 100.0]."""

    value: float = betterproto.double_field(1)


@dataclass(eq=False, repr=False)
class FractionalPercent(betterproto.Message):
    """
    A fractional percentage is used in cases in which for performance reasons
    performing floating point to integer conversions during randomness
    calculations is undesirable. The message includes both a numerator and
    denominator that together determine the final fractional value. *
    **Example**: 1/100 = 1%. * **Example**: 3/10000 = 0.03%.
    """

    numerator: int = betterproto.uint32_field(1)
    """Specifies the numerator. Defaults to 0."""

    denominator: "FractionalPercentDenominatorType" = betterproto.enum_field(2)
    """
    Specifies the denominator. If the denominator specified is less than the
    numerator, the final fractional percentage is capped at 1 (100%).
    """


@dataclass(eq=False, repr=False)
class SemanticVersion(betterproto.Message):
    """
    Envoy uses SemVer (https://semver.org/). Major/minor versions indicate
    expected behaviors and APIs, the patch version field is used only for
    security fixes and can be generally ignored.
    """

    major_number: int = betterproto.uint32_field(1)
    minor_number: int = betterproto.uint32_field(2)
    patch: int = betterproto.uint32_field(3)


@dataclass(eq=False, repr=False)
class Int64Range(betterproto.Message):
    """
    Specifies the int64 start and end of the range using half-open interval
    semantics [start, end).
    """

    start: int = betterproto.int64_field(1)
    """start of the range (inclusive)"""

    end: int = betterproto.int64_field(2)
    """end of the range (exclusive)"""


@dataclass(eq=False, repr=False)
class Int32Range(betterproto.Message):
    """
    Specifies the int32 start and end of the range using half-open interval
    semantics [start, end).
    """

    start: int = betterproto.int32_field(1)
    """start of the range (inclusive)"""

    end: int = betterproto.int32_field(2)
    """end of the range (exclusive)"""


@dataclass(eq=False, repr=False)
class DoubleRange(betterproto.Message):
    """
    Specifies the double start and end of the range using half-open interval
    semantics [start, end).
    """

    start: float = betterproto.double_field(1)
    """start of the range (inclusive)"""

    end: float = betterproto.double_field(2)
    """end of the range (exclusive)"""


@dataclass(eq=False, repr=False)
class HttpStatus(betterproto.Message):
    """HTTP status."""

    code: "StatusCode" = betterproto.enum_field(1)
    """Supplies HTTP response code."""


@dataclass(eq=False, repr=False)
class TokenBucket(betterproto.Message):
    """Configures a token bucket, typically used for rate limiting."""

    max_tokens: int = betterproto.uint32_field(1)
    """
    The maximum tokens that the bucket can hold. This is also the number of
    tokens that the bucket initially contains.
    """

    tokens_per_fill: Optional[int] = betterproto.message_field(
        2, wraps=betterproto.TYPE_UINT32
    )
    """
    The number of tokens added to the bucket during each fill interval. If not
    specified, defaults to a single token.
    """

    fill_interval: timedelta = betterproto.message_field(3)
    """
    The fill interval that tokens are added to the bucket. During each fill
    interval ``tokens_per_fill`` are added to the bucket. The bucket will never
    contain more than ``max_tokens`` tokens.
    """


@dataclass(eq=False, repr=False)
class RateLimitStrategy(betterproto.Message):
    blanket_rule: "RateLimitStrategyBlanketRule" = betterproto.enum_field(
        1, group="strategy"
    )
    """Allow or Deny the requests. If unset, allow all."""

    requests_per_time_unit: "RateLimitStrategyRequestsPerTimeUnit" = (
        betterproto.message_field(2, group="strategy")
    )
    """
    Best-effort limit of the number of requests per time unit, f.e. requests
    per second. Does not prescribe any specific rate limiting algorithm, see
    :ref:`RequestsPerTimeUnit
    <envoy_v3_api_msg_type.v3.RateLimitStrategy.RequestsPerTimeUnit>` for
    details.
    """

    token_bucket: "TokenBucket" = betterproto.message_field(3, group="strategy")
    """
    Limit the requests by consuming tokens from the Token Bucket. Allow the
    same number of requests as the number of tokens available in the token
    bucket.
    """


@dataclass(eq=False, repr=False)
class RateLimitStrategyRequestsPerTimeUnit(betterproto.Message):
    """
    Best-effort limit of the number of requests per time unit. Allows to
    specify the desired requests per second (RPS, QPS), requests per minute
    (QPM, RPM), etc., without specifying a rate limiting algorithm
    implementation. ``RequestsPerTimeUnit`` strategy does not demand any
    specific rate limiting algorithm to be used (in contrast to the
    :ref:`TokenBucket <envoy_v3_api_msg_type.v3.TokenBucket>`, for example). It
    implies that the implementation details of rate limiting algorithm are
    irrelevant as long as the configured number of "requests per time unit" is
    achieved. Note that the ``TokenBucket`` is still a valid implementation of
    the ``RequestsPerTimeUnit`` strategy, and may be chosen to enforce the rate
    limit. However, there's no guarantee it will be the ``TokenBucket`` in
    particular, and not the Leaky Bucket, the Sliding Window, or any other rate
    limiting algorithm that fulfills the requirements.
    """

    requests_per_time_unit: int = betterproto.uint64_field(1)
    """
    The desired number of requests per :ref:`time_unit <envoy_v3_api_field_type
    .v3.RateLimitStrategy.RequestsPerTimeUnit.time_unit>` to allow. If set to
    ``0``, deny all (equivalent to ``BlanketRule.DENY_ALL``). .. note::   Note
    that the algorithm implementation determines the course of action for the
    requests   over the limit. As long as the ``requests_per_time_unit``
    converges on the desired value,   it's allowed to treat this field as a
    soft-limit: allow bursts, redistribute the allowance   over time, etc.
    """

    time_unit: "RateLimitUnit" = betterproto.enum_field(2)
    """
    The unit of time. Ignored when :ref:`requests_per_time_unit <envoy_v3_api_f
    ield_type.v3.RateLimitStrategy.RequestsPerTimeUnit.requests_per_time_unit>`
    is ``0`` (deny all).
    """


@dataclass(eq=False, repr=False)
class HashPolicy(betterproto.Message):
    """Specifies the hash policy"""

    source_ip: "HashPolicySourceIp" = betterproto.message_field(
        1, group="policy_specifier"
    )
    filter_state: "HashPolicyFilterState" = betterproto.message_field(
        2, group="policy_specifier"
    )


@dataclass(eq=False, repr=False)
class HashPolicySourceIp(betterproto.Message):
    """
    The source IP will be used to compute the hash used by hash-based load
    balancing algorithms.
    """

    pass


@dataclass(eq=False, repr=False)
class HashPolicyFilterState(betterproto.Message):
    """
    An Object in the :ref:`filterState
    <arch_overview_data_sharing_between_filters>` will be used to compute the
    hash used by hash-based load balancing algorithms.
    """

    key: str = betterproto.string_field(1)
    """
    The name of the Object in the filterState, which is an Envoy::Hashable
    object. If there is no data associated with the key, or the stored object
    is not Envoy::Hashable, no hash will be produced.
    """
