# Generated by the protocol buffer compiler.  DO NOT EDIT!
# sources: envoy/service/status/v3/csds.proto
# plugin: python-betterproto
import warnings
from dataclasses import dataclass
from datetime import datetime
from typing import (
    TYPE_CHECKING,
    AsyncIterable,
    AsyncIterator,
    Dict,
    Iterable,
    List,
    Optional,
    Union,
)

import betterproto
import betterproto.lib.google.protobuf as betterproto_lib_google_protobuf
import grpclib
from betterproto.grpc.grpclib_server import ServiceBase

from ....admin import v3 as ___admin_v3__
from ....config.core import v3 as ___config_core_v3__
from ....type.matcher import v3 as ___type_matcher_v3__


if TYPE_CHECKING:
    import grpclib.server
    from betterproto.grpc.grpclib_client import MetadataLike
    from grpclib.metadata import Deadline


class ConfigStatus(betterproto.Enum):
    """Status of a config from a management server view."""

    UNKNOWN = 0
    """Status info is not available/unknown."""

    SYNCED = 1
    """Management server has sent the config to client and received ACK."""

    NOT_SENT = 2
    """Config is not sent."""

    STALE = 3
    """
    Management server has sent the config to client but hasn’t received
    ACK/NACK.
    """

    ERROR = 4
    """
    Management server has sent the config to client but received NACK. The
    attached config dump will be the latest config (the rejected one), since it
    is the persisted version in the management server.
    """


class ClientConfigStatus(betterproto.Enum):
    """Config status from a client-side view."""

    CLIENT_UNKNOWN = 0
    """Config status is not available/unknown."""

    CLIENT_REQUESTED = 1
    """
    Client requested the config but hasn't received any config from management
    server yet.
    """

    CLIENT_ACKED = 2
    """Client received the config and replied with ACK."""

    CLIENT_NACKED = 3
    """
    Client received the config and replied with NACK. Notably, the attached
    config dump is not the NACKed version, but the most recent accepted one. If
    no config is accepted yet, the attached config dump will be empty.
    """


@dataclass(eq=False, repr=False)
class ClientStatusRequest(betterproto.Message):
    """
    Request for client status of clients identified by a list of NodeMatchers.
    """

    node_matchers: List["___type_matcher_v3__.NodeMatcher"] = betterproto.message_field(
        1
    )
    """
    Management server can use these match criteria to identify clients. The
    match follows OR semantics.
    """

    node: "___config_core_v3__.Node" = betterproto.message_field(2)
    """The node making the csds request."""


@dataclass(eq=False, repr=False)
class PerXdsConfig(betterproto.Message):
    """Detailed config (per xDS) with status. [#next-free-field: 8]"""

    status: "ConfigStatus" = betterproto.enum_field(1)
    """
    Config status generated by management servers. Will not be present if the
    CSDS server is an xDS client.
    """

    client_status: "ClientConfigStatus" = betterproto.enum_field(7)
    """
    Client config status is populated by xDS clients. Will not be present if
    the CSDS server is an xDS server. No matter what the client config status
    is, xDS clients should always dump the most recent accepted xDS config. ..
    attention::   This field is deprecated. Use :ref:`ClientResourceStatus
    <envoy_v3_api_enum_admin.v3.ClientResourceStatus>` for per-resource
    config status instead.
    """

    listener_config: "___admin_v3__.ListenersConfigDump" = betterproto.message_field(
        2, group="per_xds_config"
    )
    cluster_config: "___admin_v3__.ClustersConfigDump" = betterproto.message_field(
        3, group="per_xds_config"
    )
    route_config: "___admin_v3__.RoutesConfigDump" = betterproto.message_field(
        4, group="per_xds_config"
    )
    scoped_route_config: "___admin_v3__.ScopedRoutesConfigDump" = (
        betterproto.message_field(5, group="per_xds_config")
    )
    endpoint_config: "___admin_v3__.EndpointsConfigDump" = betterproto.message_field(
        6, group="per_xds_config"
    )

    def __post_init__(self) -> None:
        super().__post_init__()
        if self.is_set("client_status"):
            warnings.warn(
                "PerXdsConfig.client_status is deprecated", DeprecationWarning
            )


@dataclass(eq=False, repr=False)
class ClientConfig(betterproto.Message):
    """All xds configs for a particular client."""

    node: "___config_core_v3__.Node" = betterproto.message_field(1)
    """Node for a particular client."""

    xds_config: List["PerXdsConfig"] = betterproto.message_field(2)
    """
    This field is deprecated in favor of generic_xds_configs which is much
    simpler and uniform in structure.
    """

    generic_xds_configs: List[
        "ClientConfigGenericXdsConfig"
    ] = betterproto.message_field(3)
    """
    Represents generic xDS config and the exact config structure depends on the
    type URL (like Cluster if it is CDS)
    """

    def __post_init__(self) -> None:
        super().__post_init__()
        if self.is_set("xds_config"):
            warnings.warn("ClientConfig.xds_config is deprecated", DeprecationWarning)


@dataclass(eq=False, repr=False)
class ClientConfigGenericXdsConfig(betterproto.Message):
    """
    GenericXdsConfig is used to specify the config status and the dump of any
    xDS resource identified by their type URL. It is the generalized version of
    the now deprecated ListenersConfigDump, ClustersConfigDump etc [#next-free-
    field: 10]
    """

    type_url: str = betterproto.string_field(1)
    """
    Type_url represents the fully qualified name of xDS resource type like
    envoy.v3.Cluster, envoy.v3.ClusterLoadAssignment etc.
    """

    name: str = betterproto.string_field(2)
    """Name of the xDS resource"""

    version_info: str = betterproto.string_field(3)
    """
    This is the :ref:`version_info
    <envoy_v3_api_field_service.discovery.v3.DiscoveryResponse.version_info>`
    in the last processed xDS discovery response. If there are only static
    bootstrap listeners, this field will be ""
    """

    xds_config: "betterproto_lib_google_protobuf.Any" = betterproto.message_field(4)
    """The xDS resource config. Actual content depends on the type"""

    last_updated: datetime = betterproto.message_field(5)
    """Timestamp when the xDS resource was last updated"""

    config_status: "ConfigStatus" = betterproto.enum_field(6)
    """
    Per xDS resource config status. It is generated by management servers. It
    will not be present if the CSDS server is an xDS client.
    """

    client_status: "___admin_v3__.ClientResourceStatus" = betterproto.enum_field(7)
    """Per xDS resource status from the view of a xDS client"""

    error_state: "___admin_v3__.UpdateFailureState" = betterproto.message_field(8)
    """
    Set if the last update failed, cleared after the next successful update.
    The *error_state* field contains the rejected version of this particular
    resource along with the reason and timestamp. For successfully updated or
    acknowledged resource, this field should be empty. [#not-implemented-hide:]
    """

    is_static_resource: bool = betterproto.bool_field(9)
    """
    Is static resource is true if it is specified in the config supplied
    through the file at the startup.
    """


@dataclass(eq=False, repr=False)
class ClientStatusResponse(betterproto.Message):
    config: List["ClientConfig"] = betterproto.message_field(1)
    """Client configs for the clients specified in the ClientStatusRequest."""


class ClientStatusDiscoveryServiceStub(betterproto.ServiceStub):
    async def stream_client_status(
        self,
        client_status_request_iterator: Union[
            AsyncIterable["ClientStatusRequest"], Iterable["ClientStatusRequest"]
        ],
        *,
        timeout: Optional[float] = None,
        deadline: Optional["Deadline"] = None,
        metadata: Optional["MetadataLike"] = None
    ) -> AsyncIterator["ClientStatusResponse"]:
        async for response in self._stream_stream(
            "/envoy.service.status.v3.ClientStatusDiscoveryService/StreamClientStatus",
            client_status_request_iterator,
            ClientStatusRequest,
            ClientStatusResponse,
            timeout=timeout,
            deadline=deadline,
            metadata=metadata,
        ):
            yield response

    async def fetch_client_status(
        self,
        client_status_request: "ClientStatusRequest",
        *,
        timeout: Optional[float] = None,
        deadline: Optional["Deadline"] = None,
        metadata: Optional["MetadataLike"] = None
    ) -> "ClientStatusResponse":
        return await self._unary_unary(
            "/envoy.service.status.v3.ClientStatusDiscoveryService/FetchClientStatus",
            client_status_request,
            ClientStatusResponse,
            timeout=timeout,
            deadline=deadline,
            metadata=metadata,
        )


class ClientStatusDiscoveryServiceBase(ServiceBase):
    async def stream_client_status(
        self, client_status_request_iterator: AsyncIterator["ClientStatusRequest"]
    ) -> AsyncIterator["ClientStatusResponse"]:
        raise grpclib.GRPCError(grpclib.const.Status.UNIMPLEMENTED)

    async def fetch_client_status(
        self, client_status_request: "ClientStatusRequest"
    ) -> "ClientStatusResponse":
        raise grpclib.GRPCError(grpclib.const.Status.UNIMPLEMENTED)

    async def __rpc_stream_client_status(
        self, stream: "grpclib.server.Stream[ClientStatusRequest, ClientStatusResponse]"
    ) -> None:
        request = stream.__aiter__()
        await self._call_rpc_handler_server_stream(
            self.stream_client_status,
            stream,
            request,
        )

    async def __rpc_fetch_client_status(
        self, stream: "grpclib.server.Stream[ClientStatusRequest, ClientStatusResponse]"
    ) -> None:
        request = await stream.recv_message()
        response = await self.fetch_client_status(request)
        await stream.send_message(response)

    def __mapping__(self) -> Dict[str, grpclib.const.Handler]:
        return {
            "/envoy.service.status.v3.ClientStatusDiscoveryService/StreamClientStatus": grpclib.const.Handler(
                self.__rpc_stream_client_status,
                grpclib.const.Cardinality.STREAM_STREAM,
                ClientStatusRequest,
                ClientStatusResponse,
            ),
            "/envoy.service.status.v3.ClientStatusDiscoveryService/FetchClientStatus": grpclib.const.Handler(
                self.__rpc_fetch_client_status,
                grpclib.const.Cardinality.UNARY_UNARY,
                ClientStatusRequest,
                ClientStatusResponse,
            ),
        }
