# Generated by the protocol buffer compiler.  DO NOT EDIT!
# sources: envoy/service/status/v2/csds.proto
# plugin: python-betterproto
from dataclasses import dataclass
from typing import (
    TYPE_CHECKING,
    AsyncIterable,
    AsyncIterator,
    Dict,
    Iterable,
    List,
    Optional,
    Union,
)

import betterproto
import grpclib
from betterproto.grpc.grpclib_server import ServiceBase

from ....admin import v2alpha as ___admin_v2_alpha__
from ....api.v2 import core as ___api_v2_core__
from ....type import matcher as ___type_matcher__


if TYPE_CHECKING:
    import grpclib.server
    from betterproto.grpc.grpclib_client import MetadataLike
    from grpclib.metadata import Deadline


class ConfigStatus(betterproto.Enum):
    """Status of a config."""

    UNKNOWN = 0
    """Status info is not available/unknown."""

    SYNCED = 1
    """Management server has sent the config to client and received ACK."""

    NOT_SENT = 2
    """Config is not sent."""

    STALE = 3
    """
    Management server has sent the config to client but hasn’t received
    ACK/NACK.
    """

    ERROR = 4
    """Management server has sent the config to client but received NACK."""


@dataclass(eq=False, repr=False)
class ClientStatusRequest(betterproto.Message):
    """
    Request for client status of clients identified by a list of NodeMatchers.
    """

    node_matchers: List["___type_matcher__.NodeMatcher"] = betterproto.message_field(1)
    """
    Management server can use these match criteria to identify clients. The
    match follows OR semantics.
    """


@dataclass(eq=False, repr=False)
class PerXdsConfig(betterproto.Message):
    """Detailed config (per xDS) with status. [#next-free-field: 6]"""

    status: "ConfigStatus" = betterproto.enum_field(1)
    listener_config: "___admin_v2_alpha__.ListenersConfigDump" = (
        betterproto.message_field(2, group="per_xds_config")
    )
    cluster_config: "___admin_v2_alpha__.ClustersConfigDump" = (
        betterproto.message_field(3, group="per_xds_config")
    )
    route_config: "___admin_v2_alpha__.RoutesConfigDump" = betterproto.message_field(
        4, group="per_xds_config"
    )
    scoped_route_config: "___admin_v2_alpha__.ScopedRoutesConfigDump" = (
        betterproto.message_field(5, group="per_xds_config")
    )


@dataclass(eq=False, repr=False)
class ClientConfig(betterproto.Message):
    """All xds configs for a particular client."""

    node: "___api_v2_core__.Node" = betterproto.message_field(1)
    """Node for a particular client."""

    xds_config: List["PerXdsConfig"] = betterproto.message_field(2)


@dataclass(eq=False, repr=False)
class ClientStatusResponse(betterproto.Message):
    config: List["ClientConfig"] = betterproto.message_field(1)
    """Client configs for the clients specified in the ClientStatusRequest."""


class ClientStatusDiscoveryServiceStub(betterproto.ServiceStub):
    async def stream_client_status(
        self,
        client_status_request_iterator: Union[
            AsyncIterable["ClientStatusRequest"], Iterable["ClientStatusRequest"]
        ],
        *,
        timeout: Optional[float] = None,
        deadline: Optional["Deadline"] = None,
        metadata: Optional["MetadataLike"] = None
    ) -> AsyncIterator["ClientStatusResponse"]:
        async for response in self._stream_stream(
            "/envoy.service.status.v2.ClientStatusDiscoveryService/StreamClientStatus",
            client_status_request_iterator,
            ClientStatusRequest,
            ClientStatusResponse,
            timeout=timeout,
            deadline=deadline,
            metadata=metadata,
        ):
            yield response

    async def fetch_client_status(
        self,
        client_status_request: "ClientStatusRequest",
        *,
        timeout: Optional[float] = None,
        deadline: Optional["Deadline"] = None,
        metadata: Optional["MetadataLike"] = None
    ) -> "ClientStatusResponse":
        return await self._unary_unary(
            "/envoy.service.status.v2.ClientStatusDiscoveryService/FetchClientStatus",
            client_status_request,
            ClientStatusResponse,
            timeout=timeout,
            deadline=deadline,
            metadata=metadata,
        )


class ClientStatusDiscoveryServiceBase(ServiceBase):
    async def stream_client_status(
        self, client_status_request_iterator: AsyncIterator["ClientStatusRequest"]
    ) -> AsyncIterator["ClientStatusResponse"]:
        raise grpclib.GRPCError(grpclib.const.Status.UNIMPLEMENTED)

    async def fetch_client_status(
        self, client_status_request: "ClientStatusRequest"
    ) -> "ClientStatusResponse":
        raise grpclib.GRPCError(grpclib.const.Status.UNIMPLEMENTED)

    async def __rpc_stream_client_status(
        self, stream: "grpclib.server.Stream[ClientStatusRequest, ClientStatusResponse]"
    ) -> None:
        request = stream.__aiter__()
        await self._call_rpc_handler_server_stream(
            self.stream_client_status,
            stream,
            request,
        )

    async def __rpc_fetch_client_status(
        self, stream: "grpclib.server.Stream[ClientStatusRequest, ClientStatusResponse]"
    ) -> None:
        request = await stream.recv_message()
        response = await self.fetch_client_status(request)
        await stream.send_message(response)

    def __mapping__(self) -> Dict[str, grpclib.const.Handler]:
        return {
            "/envoy.service.status.v2.ClientStatusDiscoveryService/StreamClientStatus": grpclib.const.Handler(
                self.__rpc_stream_client_status,
                grpclib.const.Cardinality.STREAM_STREAM,
                ClientStatusRequest,
                ClientStatusResponse,
            ),
            "/envoy.service.status.v2.ClientStatusDiscoveryService/FetchClientStatus": grpclib.const.Handler(
                self.__rpc_fetch_client_status,
                grpclib.const.Cardinality.UNARY_UNARY,
                ClientStatusRequest,
                ClientStatusResponse,
            ),
        }
