# Generated by the protocol buffer compiler.  DO NOT EDIT!
# sources: envoy/service/ratelimit/v3/rls.proto
# plugin: python-betterproto
from dataclasses import dataclass
from datetime import (
    datetime,
    timedelta,
)
from typing import (
    TYPE_CHECKING,
    Dict,
    List,
    Optional,
)

import betterproto
import betterproto.lib.google.protobuf as betterproto_lib_google_protobuf
import grpclib
from betterproto.grpc.grpclib_server import ServiceBase

from ....config.core import v3 as ___config_core_v3__
from ....extensions.common.ratelimit import v3 as ___extensions_common_ratelimit_v3__


if TYPE_CHECKING:
    import grpclib.server
    from betterproto.grpc.grpclib_client import MetadataLike
    from grpclib.metadata import Deadline


class RateLimitResponseCode(betterproto.Enum):
    UNKNOWN = 0
    """The response code is not known."""

    OK = 1
    """
    The response code to notify that the number of requests are under limit.
    """

    OVER_LIMIT = 2
    """
    The response code to notify that the number of requests are over limit.
    """


class RateLimitResponseRateLimitUnit(betterproto.Enum):
    """
    Identifies the unit of of time for rate limit. [#comment: replace by
    envoy/type/v3/ratelimit_unit.proto in v4]
    """

    UNKNOWN = 0
    """The time unit is not known."""

    SECOND = 1
    """The time unit representing a second."""

    MINUTE = 2
    """The time unit representing a minute."""

    HOUR = 3
    """The time unit representing an hour."""

    DAY = 4
    """The time unit representing a day."""


@dataclass(eq=False, repr=False)
class RateLimitRequest(betterproto.Message):
    """
    Main message for a rate limit request. The rate limit service is designed
    to be fully generic in the sense that it can operate on arbitrary
    hierarchical key/value pairs. The loaded configuration will parse the
    request and find the most specific limit to apply. In addition, a
    RateLimitRequest can contain multiple "descriptors" to limit on. When
    multiple descriptors are provided, the server will limit on *ALL* of them
    and return an OVER_LIMIT response if any of them are over limit. This
    enables more complex application level rate limiting scenarios if desired.
    """

    domain: str = betterproto.string_field(1)
    """
    All rate limit requests must specify a domain. This enables the
    configuration to be per application without fear of overlap. E.g., "envoy".
    """

    descriptors: List[
        "___extensions_common_ratelimit_v3__.RateLimitDescriptor"
    ] = betterproto.message_field(2)
    """
    All rate limit requests must specify at least one RateLimitDescriptor. Each
    descriptor is processed by the service (see below). If any of the
    descriptors are over limit, the entire request is considered to be over
    limit.
    """

    hits_addend: int = betterproto.uint32_field(3)
    """
    Rate limit requests can optionally specify the number of hits a request
    adds to the matched limit. If the value is not set in the message, a
    request increases the matched limit by 1.
    """


@dataclass(eq=False, repr=False)
class RateLimitResponse(betterproto.Message):
    """A response from a ShouldRateLimit call. [#next-free-field: 8]"""

    overall_code: "RateLimitResponseCode" = betterproto.enum_field(1)
    """
    The overall response code which takes into account all of the descriptors
    that were passed in the RateLimitRequest message.
    """

    statuses: List["RateLimitResponseDescriptorStatus"] = betterproto.message_field(2)
    """
    A list of DescriptorStatus messages which matches the length of the
    descriptor list passed in the RateLimitRequest. This can be used by the
    caller to determine which individual descriptors failed and/or what the
    currently configured limits are for all of them.
    """

    response_headers_to_add: List[
        "___config_core_v3__.HeaderValue"
    ] = betterproto.message_field(3)
    """A list of headers to add to the response"""

    request_headers_to_add: List[
        "___config_core_v3__.HeaderValue"
    ] = betterproto.message_field(4)
    """A list of headers to add to the request when forwarded"""

    raw_body: bytes = betterproto.bytes_field(5)
    """
    A response body to send to the downstream client when the response code is
    not OK.
    """

    dynamic_metadata: "betterproto_lib_google_protobuf.Struct" = (
        betterproto.message_field(6)
    )
    """
    Optional response metadata that will be emitted as dynamic metadata to be
    consumed by the next filter. This metadata lives in a namespace specified
    by the canonical name of extension filter that requires it: -
    :ref:`envoy.filters.http.ratelimit
    <config_http_filters_ratelimit_dynamic_metadata>` for HTTP filter. -
    :ref:`envoy.filters.network.ratelimit
    <config_network_filters_ratelimit_dynamic_metadata>` for network filter. -
    :ref:`envoy.filters.thrift.rate_limit
    <config_thrift_filters_rate_limit_dynamic_metadata>` for Thrift filter.
    """

    quota: "RateLimitResponseQuota" = betterproto.message_field(7)
    """
    Quota is available for a request if its entire descriptor set has cached
    quota available. This is a union of all descriptors in the descriptor set.
    Clients can use the quota for future matches if and only if the descriptor
    set matches what was sent in the request that originated this response. If
    quota is available, a RLS request will not be made and the quota will be
    reduced by 1. If quota is not available (i.e., a cached entry doesn't exist
    for a RLS descriptor set), a RLS request will be triggered. If the server
    did not provide a quota, such as the quota message is empty then the
    request admission is determined by the :ref:`overall_code
    <envoy_v3_api_field_service.ratelimit.v3.RateLimitResponse.overall_code>`.
    If there is not sufficient quota and the cached entry exists for a RLS
    descriptor set is out-of-quota but not expired, the request will be treated
    as OVER_LIMIT. [#not-implemented-hide:]
    """


@dataclass(eq=False, repr=False)
class RateLimitResponseRateLimit(betterproto.Message):
    """
    Defines an actual rate limit in terms of requests per unit of time and the
    unit itself.
    """

    name: str = betterproto.string_field(3)
    """A name or description of this limit."""

    requests_per_unit: int = betterproto.uint32_field(1)
    """The number of requests per unit of time."""

    unit: "RateLimitResponseRateLimitUnit" = betterproto.enum_field(2)
    """The unit of time."""


@dataclass(eq=False, repr=False)
class RateLimitResponseQuota(betterproto.Message):
    """
    Cacheable quota for responses. Quota can be granted at different levels:
    either for each individual descriptor or for the whole descriptor set. This
    is a certain number of requests over a period of time. The client may cache
    this result and apply the effective RateLimitResponse to future matching
    requests without querying rate limit service. When quota expires due to
    timeout, a new RLS request will also be made. The implementation may choose
    to preemptively query the rate limit server for more quota on or before
    expiration or before the available quota runs out. [#not-implemented-hide:]
    """

    requests: int = betterproto.uint32_field(1)
    """Number of matching requests granted in quota. Must be 1 or more."""

    valid_until: datetime = betterproto.message_field(2, group="expiration_specifier")
    """Point in time at which the quota expires."""

    id: str = betterproto.string_field(3)
    """
    The unique id that is associated with each Quota either at individual
    descriptor level or whole descriptor set level. For a matching policy with
    boolean logic, for example, match: "request.headers['environment'] ==
    'staging' || request.headers['environment'] == 'dev'"), the request_headers
    action produces a distinct list of descriptors for each possible value of
    the ‘environment’ header even though the granted quota is same. Thus, the
    client will use this id information (returned from RLS server) to correctly
    correlate the multiple descriptors/descriptor sets that have been granted
    with same quota (i.e., share the same quota among multiple descriptors or
    descriptor sets.) If id is empty, this id field will be ignored. If quota
    for the same id changes (e.g. due to configuration update), the old quota
    will be overridden by the new one. Shared quotas referenced by ID will
    still adhere to expiration after `valid_until`.
    """


@dataclass(eq=False, repr=False)
class RateLimitResponseDescriptorStatus(betterproto.Message):
    """[#next-free-field: 6]"""

    code: "RateLimitResponseCode" = betterproto.enum_field(1)
    """The response code for an individual descriptor."""

    current_limit: "RateLimitResponseRateLimit" = betterproto.message_field(2)
    """
    The current limit as configured by the server. Useful for debugging, etc.
    """

    limit_remaining: int = betterproto.uint32_field(3)
    """The limit remaining in the current time unit."""

    duration_until_reset: timedelta = betterproto.message_field(4)
    """Duration until reset of the current limit window."""

    quota: "RateLimitResponseQuota" = betterproto.message_field(5)
    """
    Quota is available for a request if its descriptor set has cached quota
    available for all descriptors. This is for each individual descriptor in
    the descriptor set. The client will perform matches for each individual
    descriptor against available per-descriptor quota. If quota is available, a
    RLS request will not be made and the quota will be reduced by 1 for all
    matching descriptors. If there is not sufficient quota, there are three
    cases: 1. A cached entry exists for a RLS descriptor that is out-of-quota,
    but not expired.    In this case, the request will be treated as
    OVER_LIMIT. 2. Some RLS descriptors have a cached entry that has valid
    quota but some RLS descriptors    have no cached entry. This will trigger a
    new RLS request.    When the result is returned, a single unit will be
    consumed from the quota for all    matching descriptors.    If the server
    did not provide a quota, such as the quota message is empty for some of
    the descriptors, then the request admission is determined by the
    :ref:`overall_code
    <envoy_v3_api_field_service.ratelimit.v3.RateLimitResponse.overall_code>`.
    3. All RLS descriptors lack a cached entry, this will trigger a new RLS
    request,    When the result is returned, a single unit will be consumed
    from the quota for all    matching descriptors.    If the server did not
    provide a quota, such as the quota message is empty for some of    the
    descriptors, then the request admission is determined by the
    :ref:`overall_code
    <envoy_v3_api_field_service.ratelimit.v3.RateLimitResponse.overall_code>`.
    [#not-implemented-hide:]
    """


class RateLimitServiceStub(betterproto.ServiceStub):
    async def should_rate_limit(
        self,
        rate_limit_request: "RateLimitRequest",
        *,
        timeout: Optional[float] = None,
        deadline: Optional["Deadline"] = None,
        metadata: Optional["MetadataLike"] = None
    ) -> "RateLimitResponse":
        return await self._unary_unary(
            "/envoy.service.ratelimit.v3.RateLimitService/ShouldRateLimit",
            rate_limit_request,
            RateLimitResponse,
            timeout=timeout,
            deadline=deadline,
            metadata=metadata,
        )


class RateLimitServiceBase(ServiceBase):
    async def should_rate_limit(
        self, rate_limit_request: "RateLimitRequest"
    ) -> "RateLimitResponse":
        raise grpclib.GRPCError(grpclib.const.Status.UNIMPLEMENTED)

    async def __rpc_should_rate_limit(
        self, stream: "grpclib.server.Stream[RateLimitRequest, RateLimitResponse]"
    ) -> None:
        request = await stream.recv_message()
        response = await self.should_rate_limit(request)
        await stream.send_message(response)

    def __mapping__(self) -> Dict[str, grpclib.const.Handler]:
        return {
            "/envoy.service.ratelimit.v3.RateLimitService/ShouldRateLimit": grpclib.const.Handler(
                self.__rpc_should_rate_limit,
                grpclib.const.Cardinality.UNARY_UNARY,
                RateLimitRequest,
                RateLimitResponse,
            ),
        }
