# Generated by the protocol buffer compiler.  DO NOT EDIT!
# sources: envoy/service/load_stats/v3/lrs.proto
# plugin: python-betterproto
from dataclasses import dataclass
from datetime import timedelta
from typing import (
    TYPE_CHECKING,
    AsyncIterable,
    AsyncIterator,
    Dict,
    Iterable,
    List,
    Optional,
    Union,
)

import betterproto
import grpclib
from betterproto.grpc.grpclib_server import ServiceBase

from ....config.core import v3 as ___config_core_v3__
from ....config.endpoint import v3 as ___config_endpoint_v3__


if TYPE_CHECKING:
    import grpclib.server
    from betterproto.grpc.grpclib_client import MetadataLike
    from grpclib.metadata import Deadline


@dataclass(eq=False, repr=False)
class LoadStatsRequest(betterproto.Message):
    """A load report Envoy sends to the management server."""

    node: "___config_core_v3__.Node" = betterproto.message_field(1)
    """Node identifier for Envoy instance."""

    cluster_stats: List[
        "___config_endpoint_v3__.ClusterStats"
    ] = betterproto.message_field(2)
    """A list of load stats to report."""


@dataclass(eq=False, repr=False)
class LoadStatsResponse(betterproto.Message):
    """
    The management server sends envoy a LoadStatsResponse with all clusters it
    is interested in learning load stats about.
    """

    clusters: List[str] = betterproto.string_field(1)
    """
    Clusters to report stats for. Not populated if ``send_all_clusters`` is
    true.
    """

    send_all_clusters: bool = betterproto.bool_field(4)
    """
    If true, the client should send all clusters it knows about. Only clients
    that advertise the "envoy.lrs.supports_send_all_clusters" capability in
    their :ref:`client_features<envoy_v3_api_field_config.core.v3.Node.client_f
    eatures>` field will honor this field.
    """

    load_reporting_interval: timedelta = betterproto.message_field(2)
    """
    The minimum interval of time to collect stats over. This is only a minimum
    for two reasons: 1. There may be some delay from when the timer fires until
    stats sampling occurs. 2. For clusters that were already feature in the
    previous ``LoadStatsResponse``, any traffic    that is observed in between
    the corresponding previous ``LoadStatsRequest`` and this
    ``LoadStatsResponse`` will also be accumulated and billed to the cluster.
    This avoids a period    of inobservability that might otherwise exists
    between the messages. New clusters are not    subject to this
    consideration.
    """

    report_endpoint_granularity: bool = betterproto.bool_field(3)
    """
    Set to ``true`` if the management server supports endpoint granularity
    report.
    """


class LoadReportingServiceStub(betterproto.ServiceStub):
    async def stream_load_stats(
        self,
        load_stats_request_iterator: Union[
            AsyncIterable["LoadStatsRequest"], Iterable["LoadStatsRequest"]
        ],
        *,
        timeout: Optional[float] = None,
        deadline: Optional["Deadline"] = None,
        metadata: Optional["MetadataLike"] = None
    ) -> AsyncIterator["LoadStatsResponse"]:
        async for response in self._stream_stream(
            "/envoy.service.load_stats.v3.LoadReportingService/StreamLoadStats",
            load_stats_request_iterator,
            LoadStatsRequest,
            LoadStatsResponse,
            timeout=timeout,
            deadline=deadline,
            metadata=metadata,
        ):
            yield response


class LoadReportingServiceBase(ServiceBase):
    async def stream_load_stats(
        self, load_stats_request_iterator: AsyncIterator["LoadStatsRequest"]
    ) -> AsyncIterator["LoadStatsResponse"]:
        raise grpclib.GRPCError(grpclib.const.Status.UNIMPLEMENTED)

    async def __rpc_stream_load_stats(
        self, stream: "grpclib.server.Stream[LoadStatsRequest, LoadStatsResponse]"
    ) -> None:
        request = stream.__aiter__()
        await self._call_rpc_handler_server_stream(
            self.stream_load_stats,
            stream,
            request,
        )

    def __mapping__(self) -> Dict[str, grpclib.const.Handler]:
        return {
            "/envoy.service.load_stats.v3.LoadReportingService/StreamLoadStats": grpclib.const.Handler(
                self.__rpc_stream_load_stats,
                grpclib.const.Cardinality.STREAM_STREAM,
                LoadStatsRequest,
                LoadStatsResponse,
            ),
        }
