# Generated by the protocol buffer compiler.  DO NOT EDIT!
# sources: envoy/service/health/v3/hds.proto
# plugin: python-betterproto
import warnings
from dataclasses import dataclass
from datetime import timedelta
from typing import (
    TYPE_CHECKING,
    AsyncIterable,
    AsyncIterator,
    Dict,
    Iterable,
    List,
    Optional,
    Union,
)

import betterproto
import grpclib
from betterproto.grpc.grpclib_server import ServiceBase

from ....config.cluster import v3 as ___config_cluster_v3__
from ....config.core import v3 as ___config_core_v3__
from ....config.endpoint import v3 as ___config_endpoint_v3__


if TYPE_CHECKING:
    import grpclib.server
    from betterproto.grpc.grpclib_client import MetadataLike
    from grpclib.metadata import Deadline


class CapabilityProtocol(betterproto.Enum):
    """
    Different Envoy instances may have different capabilities (e.g. Redis)
    and/or have ports enabled for different protocols.
    """

    HTTP = 0
    TCP = 1
    REDIS = 2


@dataclass(eq=False, repr=False)
class Capability(betterproto.Message):
    """
    Defines supported protocols etc, so the management server can assign proper
    endpoints to healthcheck.
    """

    health_check_protocols: List["CapabilityProtocol"] = betterproto.enum_field(1)


@dataclass(eq=False, repr=False)
class HealthCheckRequest(betterproto.Message):
    node: "___config_core_v3__.Node" = betterproto.message_field(1)
    capability: "Capability" = betterproto.message_field(2)


@dataclass(eq=False, repr=False)
class EndpointHealth(betterproto.Message):
    endpoint: "___config_endpoint_v3__.Endpoint" = betterproto.message_field(1)
    health_status: "___config_core_v3__.HealthStatus" = betterproto.enum_field(2)


@dataclass(eq=False, repr=False)
class LocalityEndpointsHealth(betterproto.Message):
    """Group endpoint health by locality under each cluster."""

    locality: "___config_core_v3__.Locality" = betterproto.message_field(1)
    endpoints_health: List["EndpointHealth"] = betterproto.message_field(2)


@dataclass(eq=False, repr=False)
class ClusterEndpointsHealth(betterproto.Message):
    """
    The health status of endpoints in a cluster. The cluster name and locality
    should match the corresponding fields in ClusterHealthCheck message.
    """

    cluster_name: str = betterproto.string_field(1)
    locality_endpoints_health: List[
        "LocalityEndpointsHealth"
    ] = betterproto.message_field(2)


@dataclass(eq=False, repr=False)
class EndpointHealthResponse(betterproto.Message):
    endpoints_health: List["EndpointHealth"] = betterproto.message_field(1)
    """Deprecated - Flat list of endpoint health information."""

    cluster_endpoints_health: List[
        "ClusterEndpointsHealth"
    ] = betterproto.message_field(2)
    """Organize Endpoint health information by cluster."""

    def __post_init__(self) -> None:
        super().__post_init__()
        if self.is_set("endpoints_health"):
            warnings.warn(
                "EndpointHealthResponse.endpoints_health is deprecated",
                DeprecationWarning,
            )


@dataclass(eq=False, repr=False)
class HealthCheckRequestOrEndpointHealthResponse(betterproto.Message):
    health_check_request: "HealthCheckRequest" = betterproto.message_field(
        1, group="request_type"
    )
    endpoint_health_response: "EndpointHealthResponse" = betterproto.message_field(
        2, group="request_type"
    )


@dataclass(eq=False, repr=False)
class LocalityEndpoints(betterproto.Message):
    locality: "___config_core_v3__.Locality" = betterproto.message_field(1)
    endpoints: List["___config_endpoint_v3__.Endpoint"] = betterproto.message_field(2)


@dataclass(eq=False, repr=False)
class ClusterHealthCheck(betterproto.Message):
    """
    The cluster name and locality is provided to Envoy for the endpoints that
    it health checks to support statistics reporting, logging and debugging by
    the Envoy instance (outside of HDS). For maximum usefulness, it should
    match the same cluster structure as that provided by EDS.
    """

    cluster_name: str = betterproto.string_field(1)
    health_checks: List["___config_core_v3__.HealthCheck"] = betterproto.message_field(
        2
    )
    locality_endpoints: List["LocalityEndpoints"] = betterproto.message_field(3)
    transport_socket_matches: List[
        "___config_cluster_v3__.ClusterTransportSocketMatch"
    ] = betterproto.message_field(4)
    """
    Optional map that gets filtered by
    :ref:`health_checks.transport_socket_match_criteria <envoy_v3_api_field_con
    fig.core.v3.HealthCheck.transport_socket_match_criteria>` on connection
    when health checking. For more details, see
    :ref:`config.cluster.v3.Cluster.transport_socket_matches
    <envoy_v3_api_field_config.cluster.v3.Cluster.transport_socket_matches>`.
    """


@dataclass(eq=False, repr=False)
class HealthCheckSpecifier(betterproto.Message):
    cluster_health_checks: List["ClusterHealthCheck"] = betterproto.message_field(1)
    interval: timedelta = betterproto.message_field(2)
    """The default is 1 second."""


@dataclass(eq=False, repr=False)
class HdsDummy(betterproto.Message):
    """
    [#not-implemented-hide:] Not configuration. Workaround c++ protobuf issue
    with importing services: https://github.com/google/protobuf/issues/4221 and
    protoxform to upgrade the file.
    """

    pass


class HealthDiscoveryServiceStub(betterproto.ServiceStub):
    async def stream_health_check(
        self,
        health_check_request_or_endpoint_health_response_iterator: Union[
            AsyncIterable["HealthCheckRequestOrEndpointHealthResponse"],
            Iterable["HealthCheckRequestOrEndpointHealthResponse"],
        ],
        *,
        timeout: Optional[float] = None,
        deadline: Optional["Deadline"] = None,
        metadata: Optional["MetadataLike"] = None
    ) -> AsyncIterator["HealthCheckSpecifier"]:
        async for response in self._stream_stream(
            "/envoy.service.health.v3.HealthDiscoveryService/StreamHealthCheck",
            health_check_request_or_endpoint_health_response_iterator,
            HealthCheckRequestOrEndpointHealthResponse,
            HealthCheckSpecifier,
            timeout=timeout,
            deadline=deadline,
            metadata=metadata,
        ):
            yield response

    async def fetch_health_check(
        self,
        health_check_request_or_endpoint_health_response: "HealthCheckRequestOrEndpointHealthResponse",
        *,
        timeout: Optional[float] = None,
        deadline: Optional["Deadline"] = None,
        metadata: Optional["MetadataLike"] = None
    ) -> "HealthCheckSpecifier":
        return await self._unary_unary(
            "/envoy.service.health.v3.HealthDiscoveryService/FetchHealthCheck",
            health_check_request_or_endpoint_health_response,
            HealthCheckSpecifier,
            timeout=timeout,
            deadline=deadline,
            metadata=metadata,
        )


class HealthDiscoveryServiceBase(ServiceBase):
    async def stream_health_check(
        self,
        health_check_request_or_endpoint_health_response_iterator: AsyncIterator[
            "HealthCheckRequestOrEndpointHealthResponse"
        ],
    ) -> AsyncIterator["HealthCheckSpecifier"]:
        raise grpclib.GRPCError(grpclib.const.Status.UNIMPLEMENTED)

    async def fetch_health_check(
        self,
        health_check_request_or_endpoint_health_response: "HealthCheckRequestOrEndpointHealthResponse",
    ) -> "HealthCheckSpecifier":
        raise grpclib.GRPCError(grpclib.const.Status.UNIMPLEMENTED)

    async def __rpc_stream_health_check(
        self,
        stream: "grpclib.server.Stream[HealthCheckRequestOrEndpointHealthResponse, HealthCheckSpecifier]",
    ) -> None:
        request = stream.__aiter__()
        await self._call_rpc_handler_server_stream(
            self.stream_health_check,
            stream,
            request,
        )

    async def __rpc_fetch_health_check(
        self,
        stream: "grpclib.server.Stream[HealthCheckRequestOrEndpointHealthResponse, HealthCheckSpecifier]",
    ) -> None:
        request = await stream.recv_message()
        response = await self.fetch_health_check(request)
        await stream.send_message(response)

    def __mapping__(self) -> Dict[str, grpclib.const.Handler]:
        return {
            "/envoy.service.health.v3.HealthDiscoveryService/StreamHealthCheck": grpclib.const.Handler(
                self.__rpc_stream_health_check,
                grpclib.const.Cardinality.STREAM_STREAM,
                HealthCheckRequestOrEndpointHealthResponse,
                HealthCheckSpecifier,
            ),
            "/envoy.service.health.v3.HealthDiscoveryService/FetchHealthCheck": grpclib.const.Handler(
                self.__rpc_fetch_health_check,
                grpclib.const.Cardinality.UNARY_UNARY,
                HealthCheckRequestOrEndpointHealthResponse,
                HealthCheckSpecifier,
            ),
        }
