# Generated by the protocol buffer compiler.  DO NOT EDIT!
# sources: envoy/service/ext_proc/v3/external_processor.proto
# plugin: python-betterproto
from dataclasses import dataclass
from typing import (
    TYPE_CHECKING,
    AsyncIterable,
    AsyncIterator,
    Dict,
    Iterable,
    List,
    Optional,
    Union,
)

import betterproto
import betterproto.lib.google.protobuf as betterproto_lib_google_protobuf
import grpclib
from betterproto.grpc.grpclib_server import ServiceBase

from ....config.core import v3 as ___config_core_v3__
from ....extensions.filters.http.ext_proc import (
    v3 as ___extensions_filters_http_ext_proc_v3__,
)
from ....type import v3 as ___type_v3__


if TYPE_CHECKING:
    import grpclib.server
    from betterproto.grpc.grpclib_client import MetadataLike
    from grpclib.metadata import Deadline


class CommonResponseResponseStatus(betterproto.Enum):
    CONTINUE = 0
    """
    Apply the mutation instructions in this message to the request or response,
    and then continue processing the filter stream as normal. This is the
    default.
    """

    CONTINUE_AND_REPLACE = 1
    """
    Apply the specified header mutation, replace the body with the body
    specified in the body mutation (if present), and do not send any further
    messages for this request or response even if the processing mode is
    configured to do so. When used in response to a request_headers or
    response_headers message, this status makes it possible to either
    completely replace the body while discarding the original body, or to add a
    body to a message that formerly did not have one. In other words, this
    response makes it possible to turn an HTTP GET into a POST, PUT, or PATCH.
    """


@dataclass(eq=False, repr=False)
class ProcessingRequest(betterproto.Message):
    """
    This represents the different types of messages that Envoy can send to an
    external processing server. [#next-free-field: 8]
    """

    async_mode: bool = betterproto.bool_field(1)
    """
    Specify whether the filter that sent this request is running in synchronous
    or asynchronous mode. The choice of synchronous or asynchronous mode can be
    set in the filter configuration, and defaults to false. * A value of
    ``false`` indicates that the server must respond   to this message by
    either sending back a matching ProcessingResponse message,   or by closing
    the stream. * A value of ``true`` indicates that the server must not
    respond to this   message, although it may still close the stream to
    indicate that no more messages   are needed.
    """

    request_headers: "HttpHeaders" = betterproto.message_field(2, group="request")
    """
    Information about the HTTP request headers, as well as peer info and
    additional properties. Unless ``async_mode`` is ``true``, the server must
    send back a HeaderResponse message, an ImmediateResponse message, or close
    the stream.
    """

    response_headers: "HttpHeaders" = betterproto.message_field(3, group="request")
    """
    Information about the HTTP response headers, as well as peer info and
    additional properties. Unless ``async_mode`` is ``true``, the server must
    send back a HeaderResponse message or close the stream.
    """

    request_body: "HttpBody" = betterproto.message_field(4, group="request")
    """
    A chunk of the HTTP request body. Unless ``async_mode`` is true, the server
    must send back a BodyResponse message, an ImmediateResponse message, or
    close the stream.
    """

    response_body: "HttpBody" = betterproto.message_field(5, group="request")
    """
    A chunk of the HTTP request body. Unless ``async_mode`` is ``true``, the
    server must send back a BodyResponse message or close the stream.
    """

    request_trailers: "HttpTrailers" = betterproto.message_field(6, group="request")
    """
    The HTTP trailers for the request path. Unless ``async_mode`` is ``true``,
    the server must send back a TrailerResponse message or close the stream.
    This message is only sent if the trailers processing mode is set to
    ``SEND``. If there are no trailers on the original downstream request, then
    this message will only be sent (with empty trailers waiting to be
    populated) if the processing mode is set before the request headers are
    sent, such as in the filter configuration.
    """

    response_trailers: "HttpTrailers" = betterproto.message_field(7, group="request")
    """
    The HTTP trailers for the response path. Unless ``async_mode`` is ``true``,
    the server must send back a TrailerResponse message or close the stream.
    This message is only sent if the trailers processing mode is set to
    ``SEND``. If there are no trailers on the original downstream request, then
    this message will only be sent (with empty trailers waiting to be
    populated) if the processing mode is set before the request headers are
    sent, such as in the filter configuration.
    """


@dataclass(eq=False, repr=False)
class ProcessingResponse(betterproto.Message):
    """
    For every ProcessingRequest received by the server with the ``async_mode``
    field set to false, the server must send back exactly one
    ProcessingResponse message. [#next-free-field: 10]
    """

    request_headers: "HeadersResponse" = betterproto.message_field(1, group="response")
    """
    The server must send back this message in response to a message with the
    ``request_headers`` field set.
    """

    response_headers: "HeadersResponse" = betterproto.message_field(2, group="response")
    """
    The server must send back this message in response to a message with the
    ``response_headers`` field set.
    """

    request_body: "BodyResponse" = betterproto.message_field(3, group="response")
    """
    The server must send back this message in response to a message with the
    ``request_body`` field set.
    """

    response_body: "BodyResponse" = betterproto.message_field(4, group="response")
    """
    The server must send back this message in response to a message with the
    ``response_body`` field set.
    """

    request_trailers: "TrailersResponse" = betterproto.message_field(
        5, group="response"
    )
    """
    The server must send back this message in response to a message with the
    ``request_trailers`` field set.
    """

    response_trailers: "TrailersResponse" = betterproto.message_field(
        6, group="response"
    )
    """
    The server must send back this message in response to a message with the
    ``response_trailers`` field set.
    """

    immediate_response: "ImmediateResponse" = betterproto.message_field(
        7, group="response"
    )
    """
    If specified, attempt to create a locally generated response, send it
    downstream, and stop processing additional filters and ignore any
    additional messages received from the remote server for this request or
    response. If a response has already started -- for example, if this message
    is sent response to a ``response_body`` message -- then this will either
    ship the reply directly to the downstream codec, or reset the stream.
    """

    dynamic_metadata: "betterproto_lib_google_protobuf.Struct" = (
        betterproto.message_field(8)
    )
    """
    [#not-implemented-hide:] Optional metadata that will be emitted as dynamic
    metadata to be consumed by the next filter. This metadata will be placed in
    the namespace ``envoy.filters.http.ext_proc``.
    """

    mode_override: "___extensions_filters_http_ext_proc_v3__.ProcessingMode" = (
        betterproto.message_field(9)
    )
    """
    Override how parts of the HTTP request and response are processed for the
    duration of this particular request/response only. Servers may use this to
    intelligently control how requests are processed based on the headers and
    other metadata that they see.
    """


@dataclass(eq=False, repr=False)
class HttpHeaders(betterproto.Message):
    """
    This message is sent to the external server when the HTTP request and
    responses are first received.
    """

    headers: "___config_core_v3__.HeaderMap" = betterproto.message_field(1)
    """
    The HTTP request headers. All header keys will be lower-cased, because HTTP
    header keys are case-insensitive.
    """

    attributes: Dict[
        str, "betterproto_lib_google_protobuf.Struct"
    ] = betterproto.map_field(2, betterproto.TYPE_STRING, betterproto.TYPE_MESSAGE)
    """
    [#not-implemented-hide:] The values of properties selected by the
    ``request_attributes`` or ``response_attributes`` list in the
    configuration. Each entry in the list is populated from the standard
    :ref:`attributes <arch_overview_attributes>` supported across Envoy.
    """

    end_of_stream: bool = betterproto.bool_field(3)
    """
    If true, then there is no message body associated with this request or
    response.
    """


@dataclass(eq=False, repr=False)
class HttpBody(betterproto.Message):
    """
    This message contains the message body that Envoy sends to the external
    server.
    """

    body: bytes = betterproto.bytes_field(1)
    end_of_stream: bool = betterproto.bool_field(2)


@dataclass(eq=False, repr=False)
class HttpTrailers(betterproto.Message):
    """This message contains the trailers."""

    trailers: "___config_core_v3__.HeaderMap" = betterproto.message_field(1)


@dataclass(eq=False, repr=False)
class HeadersResponse(betterproto.Message):
    """This message must be sent in response to an HttpHeaders message."""

    response: "CommonResponse" = betterproto.message_field(1)


@dataclass(eq=False, repr=False)
class TrailersResponse(betterproto.Message):
    """This message must be sent in response to an HttpTrailers message."""

    header_mutation: "HeaderMutation" = betterproto.message_field(1)
    """Instructions on how to manipulate the trailers"""


@dataclass(eq=False, repr=False)
class BodyResponse(betterproto.Message):
    """This message must be sent in response to an HttpBody message."""

    response: "CommonResponse" = betterproto.message_field(1)


@dataclass(eq=False, repr=False)
class CommonResponse(betterproto.Message):
    """
    This message contains common fields between header and body responses.
    [#next-free-field: 6]
    """

    status: "CommonResponseResponseStatus" = betterproto.enum_field(1)
    """
    If set, provide additional direction on how the Envoy proxy should handle
    the rest of the HTTP filter chain.
    """

    header_mutation: "HeaderMutation" = betterproto.message_field(2)
    """
    Instructions on how to manipulate the headers. When responding to an
    HttpBody request, header mutations will only take effect if the current
    processing mode for the body is BUFFERED.
    """

    body_mutation: "BodyMutation" = betterproto.message_field(3)
    """
    Replace the body of the last message sent to the remote server on this
    stream. If responding to an HttpBody request, simply replace or clear the
    body chunk that was sent with that request. Body mutations only take effect
    in response to ``body`` messages and are ignored otherwise.
    """

    trailers: "___config_core_v3__.HeaderMap" = betterproto.message_field(4)
    """
    [#not-implemented-hide:] Add new trailers to the message. This may be used
    when responding to either a HttpHeaders or HttpBody message, but only if
    this message is returned along with the CONTINUE_AND_REPLACE status.
    """

    clear_route_cache: bool = betterproto.bool_field(5)
    """
    Clear the route cache for the current request. This is necessary if the
    remote server modified headers that are used to calculate the route.
    """


@dataclass(eq=False, repr=False)
class ImmediateResponse(betterproto.Message):
    """
    This message causes the filter to attempt to create a locally generated
    response, send it  downstream, stop processing additional filters, and
    ignore any additional messages received from the remote server for this
    request or response. If a response has already started, then  this will
    either ship the reply directly to the downstream codec, or reset the
    stream. [#next-free-field: 6]
    """

    status: "___type_v3__.HttpStatus" = betterproto.message_field(1)
    """The response code to return"""

    headers: "HeaderMutation" = betterproto.message_field(2)
    """
    Apply changes to the default headers, which will include content-type.
    """

    body: str = betterproto.string_field(3)
    """
    The message body to return with the response which is sent using the
    text/plain content type, or encoded in the grpc-message header.
    """

    grpc_status: "GrpcStatus" = betterproto.message_field(4)
    """If set, then include a gRPC status trailer."""

    details: str = betterproto.string_field(5)
    """
    A string detailing why this local reply was sent, which may be included in
    log and debug output (e.g. this populates the %RESPONSE_CODE_DETAILS%
    command operator field for use in access logging).
    """


@dataclass(eq=False, repr=False)
class GrpcStatus(betterproto.Message):
    """
    This message specifies a gRPC status for an ImmediateResponse message.
    """

    status: int = betterproto.uint32_field(1)
    """The actual gRPC status"""


@dataclass(eq=False, repr=False)
class HeaderMutation(betterproto.Message):
    """
    Change HTTP headers or trailers by appending, replacing, or removing
    headers.
    """

    set_headers: List[
        "___config_core_v3__.HeaderValueOption"
    ] = betterproto.message_field(1)
    """
    Add or replace HTTP headers. Attempts to set the value of any ``x-envoy``
    header, and attempts to set the ``:method``, ``:authority``, ``:scheme``,
    or ``host`` headers will be ignored.
    """

    remove_headers: List[str] = betterproto.string_field(2)
    """
    Remove these HTTP headers. Attempts to remove system headers -- any header
    starting with ``:``, plus ``host`` -- will be ignored.
    """


@dataclass(eq=False, repr=False)
class BodyMutation(betterproto.Message):
    """
    Replace the entire message body chunk received in the corresponding
    HttpBody message with this new body, or clear the body.
    """

    body: bytes = betterproto.bytes_field(1, group="mutation")
    """The entire body to replace"""

    clear_body: bool = betterproto.bool_field(2, group="mutation")
    """Clear the corresponding body chunk"""


class ExternalProcessorStub(betterproto.ServiceStub):
    async def process(
        self,
        processing_request_iterator: Union[
            AsyncIterable["ProcessingRequest"], Iterable["ProcessingRequest"]
        ],
        *,
        timeout: Optional[float] = None,
        deadline: Optional["Deadline"] = None,
        metadata: Optional["MetadataLike"] = None
    ) -> AsyncIterator["ProcessingResponse"]:
        async for response in self._stream_stream(
            "/envoy.service.ext_proc.v3.ExternalProcessor/Process",
            processing_request_iterator,
            ProcessingRequest,
            ProcessingResponse,
            timeout=timeout,
            deadline=deadline,
            metadata=metadata,
        ):
            yield response


class ExternalProcessorBase(ServiceBase):
    async def process(
        self, processing_request_iterator: AsyncIterator["ProcessingRequest"]
    ) -> AsyncIterator["ProcessingResponse"]:
        raise grpclib.GRPCError(grpclib.const.Status.UNIMPLEMENTED)

    async def __rpc_process(
        self, stream: "grpclib.server.Stream[ProcessingRequest, ProcessingResponse]"
    ) -> None:
        request = stream.__aiter__()
        await self._call_rpc_handler_server_stream(
            self.process,
            stream,
            request,
        )

    def __mapping__(self) -> Dict[str, grpclib.const.Handler]:
        return {
            "/envoy.service.ext_proc.v3.ExternalProcessor/Process": grpclib.const.Handler(
                self.__rpc_process,
                grpclib.const.Cardinality.STREAM_STREAM,
                ProcessingRequest,
                ProcessingResponse,
            ),
        }
