# Generated by the protocol buffer compiler.  DO NOT EDIT!
# sources: envoy/service/event_reporting/v2alpha/event_reporting_service.proto
# plugin: python-betterproto
from dataclasses import dataclass
from typing import (
    TYPE_CHECKING,
    AsyncIterable,
    AsyncIterator,
    Dict,
    Iterable,
    List,
    Optional,
    Union,
)

import betterproto
import betterproto.lib.google.protobuf as betterproto_lib_google_protobuf
import grpclib
from betterproto.grpc.grpclib_server import ServiceBase

from ....api.v2 import core as ___api_v2_core__


if TYPE_CHECKING:
    import grpclib.server
    from betterproto.grpc.grpclib_client import MetadataLike
    from grpclib.metadata import Deadline


@dataclass(eq=False, repr=False)
class StreamEventsRequest(betterproto.Message):
    """
    [#not-implemented-hide:] An events envoy sends to the management server.
    """

    identifier: "StreamEventsRequestIdentifier" = betterproto.message_field(1)
    """
    Identifier data that will only be sent in the first message on the stream.
    This is effectively structured metadata and is a performance optimization.
    """

    events: List["betterproto_lib_google_protobuf.Any"] = betterproto.message_field(2)
    """
    Batch of events. When the stream is already active, it will be the events
    occurred since the last message had been sent. If the server receives
    unknown event type, it should silently ignore it. The following events are
    supported: * :ref:`HealthCheckEvent
    <envoy_api_msg_data.core.v2alpha.HealthCheckEvent>` *
    :ref:`OutlierDetectionEvent
    <envoy_api_msg_data.cluster.v2alpha.OutlierDetectionEvent>`
    """


@dataclass(eq=False, repr=False)
class StreamEventsRequestIdentifier(betterproto.Message):
    node: "___api_v2_core__.Node" = betterproto.message_field(1)
    """The node sending the event messages over the stream."""


@dataclass(eq=False, repr=False)
class StreamEventsResponse(betterproto.Message):
    """
    [#not-implemented-hide:] The management server may send envoy a
    StreamEventsResponse to tell which events the server is interested in. In
    future, with aggregated event reporting service, this message will contain,
    for example, clusters the envoy should send events for, or event types the
    server wants to process.
    """

    pass


class EventReportingServiceStub(betterproto.ServiceStub):
    async def stream_events(
        self,
        stream_events_request_iterator: Union[
            AsyncIterable["StreamEventsRequest"], Iterable["StreamEventsRequest"]
        ],
        *,
        timeout: Optional[float] = None,
        deadline: Optional["Deadline"] = None,
        metadata: Optional["MetadataLike"] = None
    ) -> AsyncIterator["StreamEventsResponse"]:
        async for response in self._stream_stream(
            "/envoy.service.event_reporting.v2alpha.EventReportingService/StreamEvents",
            stream_events_request_iterator,
            StreamEventsRequest,
            StreamEventsResponse,
            timeout=timeout,
            deadline=deadline,
            metadata=metadata,
        ):
            yield response


class EventReportingServiceBase(ServiceBase):
    async def stream_events(
        self, stream_events_request_iterator: AsyncIterator["StreamEventsRequest"]
    ) -> AsyncIterator["StreamEventsResponse"]:
        raise grpclib.GRPCError(grpclib.const.Status.UNIMPLEMENTED)

    async def __rpc_stream_events(
        self, stream: "grpclib.server.Stream[StreamEventsRequest, StreamEventsResponse]"
    ) -> None:
        request = stream.__aiter__()
        await self._call_rpc_handler_server_stream(
            self.stream_events,
            stream,
            request,
        )

    def __mapping__(self) -> Dict[str, grpclib.const.Handler]:
        return {
            "/envoy.service.event_reporting.v2alpha.EventReportingService/StreamEvents": grpclib.const.Handler(
                self.__rpc_stream_events,
                grpclib.const.Cardinality.STREAM_STREAM,
                StreamEventsRequest,
                StreamEventsResponse,
            ),
        }
