# Generated by the protocol buffer compiler.  DO NOT EDIT!
# sources: envoy/service/discovery/v3/ads.proto, envoy/service/discovery/v3/discovery.proto
# plugin: python-betterproto
from dataclasses import dataclass
from datetime import timedelta
from typing import (
    TYPE_CHECKING,
    AsyncIterable,
    AsyncIterator,
    Dict,
    Iterable,
    List,
    Optional,
    Union,
)

import betterproto
import betterproto.lib.google.protobuf as betterproto_lib_google_protobuf
import grpclib
from betterproto.grpc.grpclib_server import ServiceBase

from .....google import rpc as ____google_rpc__
from ....config.core import v3 as ___config_core_v3__


if TYPE_CHECKING:
    import grpclib.server
    from betterproto.grpc.grpclib_client import MetadataLike
    from grpclib.metadata import Deadline


@dataclass(eq=False, repr=False)
class ResourceLocator(betterproto.Message):
    """Specifies a resource to be subscribed to."""

    name: str = betterproto.string_field(1)
    """The resource name to subscribe to."""

    dynamic_parameters: Dict[str, str] = betterproto.map_field(
        2, betterproto.TYPE_STRING, betterproto.TYPE_STRING
    )
    """
    A set of dynamic parameters used to match against the dynamic parameter
    constraints on the resource. This allows clients to select between multiple
    variants of the same resource.
    """


@dataclass(eq=False, repr=False)
class ResourceName(betterproto.Message):
    """Specifies a concrete resource name."""

    name: str = betterproto.string_field(1)
    """The name of the resource."""

    dynamic_parameter_constraints: "DynamicParameterConstraints" = (
        betterproto.message_field(2)
    )
    """
    Dynamic parameter constraints associated with this resource. To be used by
    client-side caches (including xDS proxies) when matching subscribed
    resource locators.
    """


@dataclass(eq=False, repr=False)
class DiscoveryRequest(betterproto.Message):
    """
    A DiscoveryRequest requests a set of versioned resources of the same type
    for a given Envoy node on some API. [#next-free-field: 8]
    """

    version_info: str = betterproto.string_field(1)
    """
    The version_info provided in the request messages will be the version_info
    received with the most recent successfully processed response or empty on
    the first request. It is expected that no new request is sent after a
    response is received until the Envoy instance is ready to ACK/NACK the new
    configuration. ACK/NACK takes place by returning the new API config version
    as applied or the previous API config version respectively. Each type_url
    (see below) has an independent version associated with it.
    """

    node: "___config_core_v3__.Node" = betterproto.message_field(2)
    """The node making the request."""

    resource_names: List[str] = betterproto.string_field(3)
    """
    List of resources to subscribe to, e.g. list of cluster names or a route
    configuration name. If this is empty, all resources for the API are
    returned. LDS/CDS may have empty resource_names, which will cause all
    resources for the Envoy instance to be returned. The LDS and CDS responses
    will then imply a number of resources that need to be fetched via EDS/RDS,
    which will be explicitly enumerated in resource_names.
    """

    resource_locators: List["ResourceLocator"] = betterproto.message_field(7)
    """
    [#not-implemented-hide:] Alternative to ``resource_names`` field that
    allows specifying dynamic parameters along with each resource name. Clients
    that populate this field must be able to handle responses from the server
    where resources are wrapped in a Resource message. Note that it is legal
    for a request to have some resources listed in ``resource_names`` and
    others in ``resource_locators``.
    """

    type_url: str = betterproto.string_field(4)
    """
    Type of the resource that is being requested, e.g.
    "type.googleapis.com/envoy.api.v2.ClusterLoadAssignment". This is implicit
    in requests made via singleton xDS APIs such as CDS, LDS, etc. but is
    required for ADS.
    """

    response_nonce: str = betterproto.string_field(5)
    """
    nonce corresponding to DiscoveryResponse being ACK/NACKed. See above
    discussion on version_info and the DiscoveryResponse nonce comment. This
    may be empty only if 1) this is a non-persistent-stream xDS such as HTTP,
    or 2) the client has not yet accepted an update in this xDS stream (unlike
    delta, where it is populated only for new explicit ACKs).
    """

    error_detail: "____google_rpc__.Status" = betterproto.message_field(6)
    """
    This is populated when the previous :ref:`DiscoveryResponse
    <envoy_v3_api_msg_service.discovery.v3.DiscoveryResponse>` failed to update
    configuration. The ``message`` field in ``error_details`` provides the
    Envoy internal exception related to the failure. It is only intended for
    consumption during manual debugging, the string provided is not guaranteed
    to be stable across Envoy versions.
    """


@dataclass(eq=False, repr=False)
class DiscoveryResponse(betterproto.Message):
    """[#next-free-field: 7]"""

    version_info: str = betterproto.string_field(1)
    """The version of the response data."""

    resources: List["betterproto_lib_google_protobuf.Any"] = betterproto.message_field(
        2
    )
    """
    The response resources. These resources are typed and depend on the API
    being called.
    """

    canary: bool = betterproto.bool_field(3)
    """
    [#not-implemented-hide:] Canary is used to support two Envoy command line
    flags: * --terminate-on-canary-transition-failure. When set, Envoy is able
    to   terminate if it detects that configuration is stuck at canary.
    Consider   this example sequence of updates:   - Management server applies
    a canary config successfully.   - Management server rolls back to a
    production config.   - Envoy rejects the new production config.   Since
    there is no sensible way to continue receiving configuration   updates,
    Envoy will then terminate and apply production config from a   clean slate.
    * --dry-run-canary. When set, a canary response will never be applied, only
    validated via a dry run.
    """

    type_url: str = betterproto.string_field(4)
    """
    Type URL for resources. Identifies the xDS API when muxing over ADS. Must
    be consistent with the type_url in the 'resources' repeated Any (if non-
    empty).
    """

    nonce: str = betterproto.string_field(5)
    """
    For gRPC based subscriptions, the nonce provides a way to explicitly ack a
    specific DiscoveryResponse in a following DiscoveryRequest. Additional
    messages may have been sent by Envoy to the management server for the
    previous version on the stream prior to this DiscoveryResponse, that were
    unprocessed at response send time. The nonce allows the management server
    to ignore any further DiscoveryRequests for the previous version until a
    DiscoveryRequest bearing the nonce. The nonce is optional and is not
    required for non-stream based xDS implementations.
    """

    control_plane: "___config_core_v3__.ControlPlane" = betterproto.message_field(6)
    """The control plane instance that sent the response."""


@dataclass(eq=False, repr=False)
class DeltaDiscoveryRequest(betterproto.Message):
    """
    DeltaDiscoveryRequest and DeltaDiscoveryResponse are used in a new gRPC
    endpoint for Delta xDS. With Delta xDS, the DeltaDiscoveryResponses do not
    need to include a full snapshot of the tracked resources. Instead,
    DeltaDiscoveryResponses are a diff to the state of a xDS client. In Delta
    XDS there are per-resource versions, which allow tracking state at the
    resource granularity. An xDS Delta session is always in the context of a
    gRPC bidirectional stream. This allows the xDS server to keep track of the
    state of xDS clients connected to it. In Delta xDS the nonce field is
    required and used to pair DeltaDiscoveryResponse to a DeltaDiscoveryRequest
    ACK or NACK. Optionally, a response message level system_version_info is
    present for debugging purposes only. DeltaDiscoveryRequest plays two
    independent roles. Any DeltaDiscoveryRequest can be either or both of: [1]
    informing the server of what resources the client has gained/lost interest
    in (using resource_names_subscribe and resource_names_unsubscribe), or [2]
    (N)ACKing an earlier resource update from the server (using response_nonce,
    with presence of error_detail making it a NACK). Additionally, the first
    message (for a given type_url) of a reconnected gRPC stream has a third
    role: informing the server of the resources (and their versions) that the
    client already possesses, using the initial_resource_versions field. As
    with state-of-the-world, when multiple resource types are multiplexed
    (ADS), all requests/acknowledgments/updates are logically walled off by
    type_url: a Cluster ACK exists in a completely separate world from a prior
    Route NACK. In particular, initial_resource_versions being sent at the
    "start" of every gRPC stream actually entails a message for each type_url,
    each with its own initial_resource_versions. [#next-free-field: 10]
    """

    node: "___config_core_v3__.Node" = betterproto.message_field(1)
    """The node making the request."""

    type_url: str = betterproto.string_field(2)
    """
    Type of the resource that is being requested, e.g.
    ``type.googleapis.com/envoy.api.v2.ClusterLoadAssignment``. This does not
    need to be set if resources are only referenced via
    ``xds_resource_subscribe`` and ``xds_resources_unsubscribe``.
    """

    resource_names_subscribe: List[str] = betterproto.string_field(3)
    """
    DeltaDiscoveryRequests allow the client to add or remove individual
    resources to the set of tracked resources in the context of a stream. All
    resource names in the resource_names_subscribe list are added to the set of
    tracked resources and all resource names in the resource_names_unsubscribe
    list are removed from the set of tracked resources. *Unlike* state-of-the-
    world xDS, an empty resource_names_subscribe or resource_names_unsubscribe
    list simply means that no resources are to be added or removed to the
    resource list. *Like* state-of-the-world xDS, the server must send updates
    for all tracked resources, but can also send updates for resources the
    client has not subscribed to. NOTE: the server must respond with all
    resources listed in resource_names_subscribe, even if it believes the
    client has the most recent version of them. The reason: the client may have
    dropped them, but then regained interest before it had a chance to send the
    unsubscribe message. See DeltaSubscriptionStateTest.RemoveThenAdd. These
    two fields can be set in any DeltaDiscoveryRequest, including ACKs and
    initial_resource_versions. A list of Resource names to add to the list of
    tracked resources.
    """

    resource_names_unsubscribe: List[str] = betterproto.string_field(4)
    """
    A list of Resource names to remove from the list of tracked resources.
    """

    resource_locators_subscribe: List["ResourceLocator"] = betterproto.message_field(8)
    """
    [#not-implemented-hide:] Alternative to ``resource_names_subscribe`` field
    that allows specifying dynamic parameters along with each resource name.
    Note that it is legal for a request to have some resources listed in
    ``resource_names_subscribe`` and others in ``resource_locators_subscribe``.
    """

    resource_locators_unsubscribe: List["ResourceLocator"] = betterproto.message_field(
        9
    )
    """
    [#not-implemented-hide:] Alternative to ``resource_names_unsubscribe``
    field that allows specifying dynamic parameters along with each resource
    name. Note that it is legal for a request to have some resources listed in
    ``resource_names_unsubscribe`` and others in
    ``resource_locators_unsubscribe``.
    """

    initial_resource_versions: Dict[str, str] = betterproto.map_field(
        5, betterproto.TYPE_STRING, betterproto.TYPE_STRING
    )
    """
    Informs the server of the versions of the resources the xDS client knows
    of, to enable the client to continue the same logical xDS session even in
    the face of gRPC stream reconnection. It will not be populated: [1] in the
    very first stream of a session, since the client will not yet have any
    resources,  [2] in any message after the first in a stream (for a given
    type_url), since the server will already be correctly tracking the client's
    state. (In ADS, the first message *of each type_url* of a reconnected
    stream populates this map.) The map's keys are names of xDS resources known
    to the xDS client. The map's values are opaque resource versions.
    """

    response_nonce: str = betterproto.string_field(6)
    """
    When the DeltaDiscoveryRequest is a ACK or NACK message in response to a
    previous DeltaDiscoveryResponse, the response_nonce must be the nonce in
    the DeltaDiscoveryResponse. Otherwise (unlike in DiscoveryRequest)
    response_nonce must be omitted.
    """

    error_detail: "____google_rpc__.Status" = betterproto.message_field(7)
    """
    This is populated when the previous :ref:`DiscoveryResponse
    <envoy_v3_api_msg_service.discovery.v3.DiscoveryResponse>` failed to update
    configuration. The ``message`` field in ``error_details`` provides the
    Envoy internal exception related to the failure.
    """


@dataclass(eq=False, repr=False)
class DeltaDiscoveryResponse(betterproto.Message):
    """[#next-free-field: 9]"""

    system_version_info: str = betterproto.string_field(1)
    """The version of the response data (used for debugging)."""

    resources: List["Resource"] = betterproto.message_field(2)
    """
    The response resources. These are typed resources, whose types must match
    the type_url field.
    """

    type_url: str = betterproto.string_field(4)
    """
    Type URL for resources. Identifies the xDS API when muxing over ADS. Must
    be consistent with the type_url in the Any within 'resources' if
    'resources' is non-empty.
    """

    removed_resources: List[str] = betterproto.string_field(6)
    """
    Resources names of resources that have be deleted and to be removed from
    the xDS Client. Removed resources for missing resources can be ignored.
    """

    removed_resource_names: List["ResourceName"] = betterproto.message_field(8)
    """
    Alternative to removed_resources that allows specifying which variant of a
    resource is being removed. This variant must be used for any resource for
    which dynamic parameter constraints were sent to the client.
    """

    nonce: str = betterproto.string_field(5)
    """
    The nonce provides a way for DeltaDiscoveryRequests to uniquely reference a
    DeltaDiscoveryResponse when (N)ACKing. The nonce is required.
    """

    control_plane: "___config_core_v3__.ControlPlane" = betterproto.message_field(7)
    """
    [#not-implemented-hide:] The control plane instance that sent the response.
    """


@dataclass(eq=False, repr=False)
class DynamicParameterConstraints(betterproto.Message):
    """
    A set of dynamic parameter constraints associated with a variant of an
    individual xDS resource. These constraints determine whether the resource
    matches a subscription based on the set of dynamic parameters in the
    subscription, as specified in the :ref:`ResourceLocator.dynamic_parameters<
    envoy_v3_api_field_service.discovery.v3.ResourceLocator.dynamic_parameters>
    ` field. This allows xDS implementations (clients, servers, and caching
    proxies) to determine which variant of a resource is appropriate for a
    given client.
    """

    constraint: "DynamicParameterConstraintsSingleConstraint" = (
        betterproto.message_field(1, group="type")
    )
    """A single constraint to evaluate."""

    or_constraints: "DynamicParameterConstraintsConstraintList" = (
        betterproto.message_field(2, group="type")
    )
    """
    A list of constraints that match if any one constraint in the list matches.
    """

    and_constraints: "DynamicParameterConstraintsConstraintList" = (
        betterproto.message_field(3, group="type")
    )
    """A list of constraints that must all match."""

    not_constraints: "DynamicParameterConstraints" = betterproto.message_field(
        4, group="type"
    )
    """The inverse (NOT) of a set of constraints."""


@dataclass(eq=False, repr=False)
class DynamicParameterConstraintsSingleConstraint(betterproto.Message):
    """A single constraint for a given key."""

    key: str = betterproto.string_field(1)
    """The key to match against."""

    value: str = betterproto.string_field(2, group="constraint_type")
    """Matches this exact value."""

    exists: "DynamicParameterConstraintsSingleConstraintExists" = (
        betterproto.message_field(3, group="constraint_type")
    )
    """
    Key is present (matches any value except for the key being absent). This
    allows setting a default constraint for clients that do not send a key at
    all, while there may be other clients that need special configuration based
    on that key.
    """


@dataclass(eq=False, repr=False)
class DynamicParameterConstraintsSingleConstraintExists(betterproto.Message):
    pass


@dataclass(eq=False, repr=False)
class DynamicParameterConstraintsConstraintList(betterproto.Message):
    constraints: List["DynamicParameterConstraints"] = betterproto.message_field(1)


@dataclass(eq=False, repr=False)
class Resource(betterproto.Message):
    """[#next-free-field: 10]"""

    name: str = betterproto.string_field(3)
    """
    The resource's name, to distinguish it from others of the same type of
    resource. Only one of ``name`` or ``resource_name`` may be set.
    """

    resource_name: "ResourceName" = betterproto.message_field(8)
    """
    Alternative to the ``name`` field, to be used when the server supports
    multiple variants of the named resource that are differentiated by dynamic
    parameter constraints. Only one of ``name`` or ``resource_name`` may be
    set.
    """

    aliases: List[str] = betterproto.string_field(4)
    """The aliases are a list of other names that this resource can go by."""

    version: str = betterproto.string_field(1)
    """
    The resource level version. It allows xDS to track the state of individual
    resources.
    """

    resource: "betterproto_lib_google_protobuf.Any" = betterproto.message_field(2)
    """The resource being tracked."""

    ttl: timedelta = betterproto.message_field(6)
    """
    Time-to-live value for the resource. For each resource, a timer is started.
    The timer is reset each time the resource is received with a new TTL. If
    the resource is received with no TTL set, the timer is removed for the
    resource. Upon expiration of the timer, the configuration for the resource
    will be removed. The TTL can be refreshed or changed by sending a response
    that doesn't change the resource version. In this case the resource field
    does not need to be populated, which allows for light-weight "heartbeat"
    updates to keep a resource with a TTL alive. The TTL feature is meant to
    support configurations that should be removed in the event of a management
    server failure. For example, the feature may be used for fault injection
    testing where the fault injection should be terminated in the event that
    Envoy loses contact with the management server.
    """

    cache_control: "ResourceCacheControl" = betterproto.message_field(7)
    """Cache control properties for the resource. [#not-implemented-hide:]"""

    metadata: "___config_core_v3__.Metadata" = betterproto.message_field(9)
    """
    The Metadata field can be used to provide additional information for the
    resource. E.g. the trace data for debugging.
    """


@dataclass(eq=False, repr=False)
class ResourceCacheControl(betterproto.Message):
    """Cache control properties for the resource. [#not-implemented-hide:]"""

    do_not_cache: bool = betterproto.bool_field(1)
    """
    If true, xDS proxies may not cache this resource. Note that this does not
    apply to clients other than xDS proxies, which must cache resources for
    their own use, regardless of the value of this field.
    """


@dataclass(eq=False, repr=False)
class AdsDummy(betterproto.Message):
    """
    [#not-implemented-hide:] Not configuration. Workaround c++ protobuf issue
    with importing services: https://github.com/google/protobuf/issues/4221
    """

    pass


class AggregatedDiscoveryServiceStub(betterproto.ServiceStub):
    async def stream_aggregated_resources(
        self,
        discovery_request_iterator: Union[
            AsyncIterable["DiscoveryRequest"], Iterable["DiscoveryRequest"]
        ],
        *,
        timeout: Optional[float] = None,
        deadline: Optional["Deadline"] = None,
        metadata: Optional["MetadataLike"] = None
    ) -> AsyncIterator["DiscoveryResponse"]:
        async for response in self._stream_stream(
            "/envoy.service.discovery.v3.AggregatedDiscoveryService/StreamAggregatedResources",
            discovery_request_iterator,
            DiscoveryRequest,
            DiscoveryResponse,
            timeout=timeout,
            deadline=deadline,
            metadata=metadata,
        ):
            yield response

    async def delta_aggregated_resources(
        self,
        delta_discovery_request_iterator: Union[
            AsyncIterable["DeltaDiscoveryRequest"], Iterable["DeltaDiscoveryRequest"]
        ],
        *,
        timeout: Optional[float] = None,
        deadline: Optional["Deadline"] = None,
        metadata: Optional["MetadataLike"] = None
    ) -> AsyncIterator["DeltaDiscoveryResponse"]:
        async for response in self._stream_stream(
            "/envoy.service.discovery.v3.AggregatedDiscoveryService/DeltaAggregatedResources",
            delta_discovery_request_iterator,
            DeltaDiscoveryRequest,
            DeltaDiscoveryResponse,
            timeout=timeout,
            deadline=deadline,
            metadata=metadata,
        ):
            yield response


class AggregatedDiscoveryServiceBase(ServiceBase):
    async def stream_aggregated_resources(
        self, discovery_request_iterator: AsyncIterator["DiscoveryRequest"]
    ) -> AsyncIterator["DiscoveryResponse"]:
        raise grpclib.GRPCError(grpclib.const.Status.UNIMPLEMENTED)

    async def delta_aggregated_resources(
        self, delta_discovery_request_iterator: AsyncIterator["DeltaDiscoveryRequest"]
    ) -> AsyncIterator["DeltaDiscoveryResponse"]:
        raise grpclib.GRPCError(grpclib.const.Status.UNIMPLEMENTED)

    async def __rpc_stream_aggregated_resources(
        self, stream: "grpclib.server.Stream[DiscoveryRequest, DiscoveryResponse]"
    ) -> None:
        request = stream.__aiter__()
        await self._call_rpc_handler_server_stream(
            self.stream_aggregated_resources,
            stream,
            request,
        )

    async def __rpc_delta_aggregated_resources(
        self,
        stream: "grpclib.server.Stream[DeltaDiscoveryRequest, DeltaDiscoveryResponse]",
    ) -> None:
        request = stream.__aiter__()
        await self._call_rpc_handler_server_stream(
            self.delta_aggregated_resources,
            stream,
            request,
        )

    def __mapping__(self) -> Dict[str, grpclib.const.Handler]:
        return {
            "/envoy.service.discovery.v3.AggregatedDiscoveryService/StreamAggregatedResources": grpclib.const.Handler(
                self.__rpc_stream_aggregated_resources,
                grpclib.const.Cardinality.STREAM_STREAM,
                DiscoveryRequest,
                DiscoveryResponse,
            ),
            "/envoy.service.discovery.v3.AggregatedDiscoveryService/DeltaAggregatedResources": grpclib.const.Handler(
                self.__rpc_delta_aggregated_resources,
                grpclib.const.Cardinality.STREAM_STREAM,
                DeltaDiscoveryRequest,
                DeltaDiscoveryResponse,
            ),
        }
