# Generated by the protocol buffer compiler.  DO NOT EDIT!
# sources: envoy/extensions/transport_sockets/tls/v3/cert.proto, envoy/extensions/transport_sockets/tls/v3/common.proto, envoy/extensions/transport_sockets/tls/v3/secret.proto, envoy/extensions/transport_sockets/tls/v3/tls.proto, envoy/extensions/transport_sockets/tls/v3/tls_spiffe_validator_config.proto
# plugin: python-betterproto
import warnings
from dataclasses import dataclass
from datetime import timedelta
from typing import (
    List,
    Optional,
)

import betterproto
import betterproto.lib.google.protobuf as betterproto_lib_google_protobuf

from .....config.core import v3 as ____config_core_v3__
from .....type.matcher import v3 as ____type_matcher_v3__


class TlsParametersTlsProtocol(betterproto.Enum):
    TLS_AUTO = 0
    """Envoy will choose the optimal TLS version."""

    TLSv1_0 = 1
    """TLS 1.0"""

    TLSv1_1 = 2
    """TLS 1.1"""

    TLSv1_2 = 3
    """TLS 1.2"""

    TLSv1_3 = 4
    """TLS 1.3"""


class SubjectAltNameMatcherSanType(betterproto.Enum):
    """
    Indicates the choice of GeneralName as defined in section 4.2.1.5 of RFC
    5280 to match against.
    """

    SAN_TYPE_UNSPECIFIED = 0
    EMAIL = 1
    DNS = 2
    URI = 3
    IP_ADDRESS = 4


class CertificateValidationContextTrustChainVerification(betterproto.Enum):
    """Peer certificate verification mode."""

    VERIFY_TRUST_CHAIN = 0
    """
    Perform default certificate verification (e.g., against CA / verification
    lists)
    """

    ACCEPT_UNTRUSTED = 1
    """
    Connections where the certificate fails verification will be permitted. For
    HTTP connections, the result of certificate verification can be used in
    route matching. ( see :ref:`validated <envoy_v3_api_field_config.route.v3.R
    outeMatch.TlsContextMatchOptions.validated>` ).
    """


class DownstreamTlsContextOcspStaplePolicy(betterproto.Enum):
    LENIENT_STAPLING = 0
    """
    OCSP responses are optional. If an OCSP response is absent or expired, the
    associated certificate will be used for connections without an OCSP staple.
    """

    STRICT_STAPLING = 1
    """
    OCSP responses are optional. If an OCSP response is absent, the associated
    certificate will be used without an OCSP staple. If a response is provided
    but is expired, the associated certificate will not be used for subsequent
    connections. If no suitable certificate is found, the connection is
    rejected.
    """

    MUST_STAPLE = 2
    """
    OCSP responses are required. Configuration will fail if a certificate is
    provided without an OCSP response. If a response expires, the associated
    certificate will not be used connections. If no suitable certificate is
    found, the connection is rejected.
    """


@dataclass(eq=False, repr=False)
class TlsParameters(betterproto.Message):
    tls_minimum_protocol_version: "TlsParametersTlsProtocol" = betterproto.enum_field(1)
    """
    Minimum TLS protocol version. By default, it's ``TLSv1_2`` for both clients
    and servers. TLS protocol versions below TLSv1_2 require setting compatible
    ciphers with the ``cipher_suites`` setting as the default ciphers no longer
    include compatible ciphers. .. attention::   Using TLS protocol versions
    below TLSv1_2 has serious security considerations and risks.
    """

    tls_maximum_protocol_version: "TlsParametersTlsProtocol" = betterproto.enum_field(2)
    """
    Maximum TLS protocol version. By default, it's ``TLSv1_2`` for clients and
    ``TLSv1_3`` for servers.
    """

    cipher_suites: List[str] = betterproto.string_field(3)
    """
    If specified, the TLS listener will only support the specified `cipher list
    <https://commondatastorage.googleapis.com/chromium-boringssl-
    docs/ssl.h.html#Cipher-suite-configuration>`_ when negotiating TLS 1.0-1.2
    (this setting has no effect when negotiating TLS 1.3). If not specified, a
    default list will be used. Defaults are different for server (downstream)
    and client (upstream) TLS configurations. Defaults will change over time in
    response to security considerations; If you care, configure it instead of
    using the default. In non-FIPS builds, the default server cipher list is:
    .. code-block:: none   [ECDHE-ECDSA-AES128-GCM-SHA256|ECDHE-ECDSA-
    CHACHA20-POLY1305]   [ECDHE-RSA-AES128-GCM-SHA256|ECDHE-RSA-
    CHACHA20-POLY1305]   ECDHE-ECDSA-AES256-GCM-SHA384   ECDHE-RSA-AES256-GCM-
    SHA384 In builds using :ref:`BoringSSL FIPS <arch_overview_ssl_fips>`, the
    default server cipher list is: .. code-block:: none   ECDHE-ECDSA-
    AES128-GCM-SHA256   ECDHE-RSA-AES128-GCM-SHA256   ECDHE-ECDSA-AES256-GCM-
    SHA384   ECDHE-RSA-AES256-GCM-SHA384 In non-FIPS builds, the default client
    cipher list is: .. code-block:: none   [ECDHE-ECDSA-AES128-GCM-
    SHA256|ECDHE-ECDSA-CHACHA20-POLY1305]   [ECDHE-RSA-AES128-GCM-SHA256|ECDHE-
    RSA-CHACHA20-POLY1305]   ECDHE-ECDSA-AES256-GCM-SHA384   ECDHE-RSA-
    AES256-GCM-SHA384 In builds using :ref:`BoringSSL FIPS
    <arch_overview_ssl_fips>`, the default client cipher list is: .. code-
    block:: none   ECDHE-ECDSA-AES128-GCM-SHA256   ECDHE-RSA-AES128-GCM-SHA256
    ECDHE-ECDSA-AES256-GCM-SHA384   ECDHE-RSA-AES256-GCM-SHA384
    """

    ecdh_curves: List[str] = betterproto.string_field(4)
    """
    If specified, the TLS connection will only support the specified ECDH
    curves. If not specified, the default curves will be used. In non-FIPS
    builds, the default curves are: .. code-block:: none   X25519   P-256 In
    builds using :ref:`BoringSSL FIPS <arch_overview_ssl_fips>`, the default
    curve is: .. code-block:: none   P-256
    """


@dataclass(eq=False, repr=False)
class PrivateKeyProvider(betterproto.Message):
    """
    BoringSSL private key method configuration. The private key methods are
    used for external (potentially asynchronous) signing and decryption
    operations. Some use cases for private key methods would be TPM support and
    TLS acceleration.
    """

    provider_name: str = betterproto.string_field(1)
    """
    Private key method provider name. The name must match a supported private
    key method provider type.
    """

    typed_config: "betterproto_lib_google_protobuf.Any" = betterproto.message_field(
        3, group="config_type"
    )


@dataclass(eq=False, repr=False)
class TlsCertificate(betterproto.Message):
    """[#next-free-field: 9]"""

    certificate_chain: "____config_core_v3__.DataSource" = betterproto.message_field(1)
    """
    The TLS certificate chain. If ``certificate_chain`` is a filesystem path, a
    watch will be added to the parent directory for any file moves to support
    rotation. This currently only applies to dynamic secrets, when the
    ``TlsCertificate`` is delivered via SDS.
    """

    private_key: "____config_core_v3__.DataSource" = betterproto.message_field(2)
    """
    The TLS private key. If ``private_key`` is a filesystem path, a watch will
    be added to the parent directory for any file moves to support rotation.
    This currently only applies to dynamic secrets, when the ``TlsCertificate``
    is delivered via SDS.
    """

    pkcs12: "____config_core_v3__.DataSource" = betterproto.message_field(8)
    """
    ``Pkcs12`` data containing TLS certificate, chain, and private key. If
    ``pkcs12`` is a filesystem path, the file will be read, but no watch will
    be added to the parent directory, since ``pkcs12`` isn't used by SDS. This
    field is mutually exclusive with ``certificate_chain``, ``private_key`` and
    ``private_key_provider``. This can't be marked as ``oneof`` due to API
    compatibility reasons. Setting both :ref:`private_key <envoy_v3_api_field_e
    xtensions.transport_sockets.tls.v3.TlsCertificate.private_key>`,
    :ref:`certificate_chain <envoy_v3_api_field_extensions.transport_sockets.tl
    s.v3.TlsCertificate.certificate_chain>`, or :ref:`private_key_provider <env
    oy_v3_api_field_extensions.transport_sockets.tls.v3.TlsCertificate.private_
    key_provider>` and :ref:`pkcs12 <envoy_v3_api_field_extensions.transport_so
    ckets.tls.v3.TlsCertificate.pkcs12>` fields will result in an error. Use
    :ref:`password <envoy_v3_api_field_extensions.transport_sockets.tls.v3.TlsC
    ertificate.password>` to specify the password to unprotect the ``PKCS12``
    data, if necessary.
    """

    watched_directory: "____config_core_v3__.WatchedDirectory" = (
        betterproto.message_field(7)
    )
    """
    If specified, updates of file-based ``certificate_chain`` and
    ``private_key`` sources will be triggered by this watch. The
    certificate/key pair will be read together and validated for atomic read
    consistency (i.e. no intervening modification occurred between cert/key
    read, verified by file hash comparisons). This allows explicit control over
    the path watched, by default the parent directories of the filesystem paths
    in ``certificate_chain`` and ``private_key`` are watched if this field is
    not specified. This only applies when a ``TlsCertificate`` is delivered by
    SDS with references to filesystem paths. See the :ref:`SDS key rotation
    <sds_key_rotation>` documentation for further details.
    """

    private_key_provider: "PrivateKeyProvider" = betterproto.message_field(6)
    """
    BoringSSL private key method provider. This is an alternative to
    :ref:`private_key <envoy_v3_api_field_extensions.transport_sockets.tls.v3.T
    lsCertificate.private_key>` field. This can't be marked as ``oneof`` due to
    API compatibility reasons. Setting both :ref:`private_key <envoy_v3_api_fie
    ld_extensions.transport_sockets.tls.v3.TlsCertificate.private_key>` and
    :ref:`private_key_provider <envoy_v3_api_field_extensions.transport_sockets
    .tls.v3.TlsCertificate.private_key_provider>` fields will result in an
    error.
    """

    password: "____config_core_v3__.DataSource" = betterproto.message_field(3)
    """
    The password to decrypt the TLS private key. If this field is not set, it
    is assumed that the TLS private key is not password encrypted.
    """

    ocsp_staple: "____config_core_v3__.DataSource" = betterproto.message_field(4)
    """
    The OCSP response to be stapled with this certificate during the handshake.
    The response must be DER-encoded and may only be  provided via ``filename``
    or ``inline_bytes``. The response may pertain to only one certificate.
    """

    signed_certificate_timestamp: List[
        "____config_core_v3__.DataSource"
    ] = betterproto.message_field(5)
    """[#not-implemented-hide:]"""


@dataclass(eq=False, repr=False)
class TlsSessionTicketKeys(betterproto.Message):
    keys: List["____config_core_v3__.DataSource"] = betterproto.message_field(1)
    """
    Keys for encrypting and decrypting TLS session tickets. The first key in
    the array contains the key to encrypt all new sessions created by this
    context. All keys are candidates for decrypting received tickets. This
    allows for easy rotation of keys by, for example, putting the new key
    first, and the previous key second. If :ref:`session_ticket_keys <envoy_v3_
    api_field_extensions.transport_sockets.tls.v3.DownstreamTlsContext.session_
    ticket_keys>` is not specified, the TLS library will still support resuming
    sessions via tickets, but it will use an internally-generated and managed
    key, so sessions cannot be resumed across hot restarts or on different
    hosts. Each key must contain exactly 80 bytes of cryptographically-secure
    random data. For example, the output of ``openssl rand 80``. .. attention::
    Using this feature has serious security considerations and risks. Improper
    handling of keys   may result in loss of secrecy in connections, even if
    ciphers supporting perfect forward   secrecy are used. See
    https://www.imperialviolet.org/2013/06/27/botchingpfs.html for some
    discussion. To minimize the risk, you must:   * Keep the session ticket
    keys at least as secure as your TLS certificate private keys   * Rotate
    session ticket keys at least daily, and preferably hourly   * Always
    generate keys using a cryptographically-secure random data source
    """


@dataclass(eq=False, repr=False)
class CertificateProviderPluginInstance(betterproto.Message):
    """
    Indicates a certificate to be obtained from a named CertificateProvider
    plugin instance. The plugin instances are defined in the client's bootstrap
    file. The plugin allows certificates to be fetched/refreshed over the
    network asynchronously with respect to the TLS handshake. [#not-
    implemented-hide:]
    """

    instance_name: str = betterproto.string_field(1)
    """
    Provider instance name. If not present, defaults to "default". Instance
    names should generally be defined not in terms of the underlying provider
    implementation (e.g., "file_watcher") but rather in terms of the function
    of the certificates (e.g., "foo_deployment_identity").
    """

    certificate_name: str = betterproto.string_field(2)
    """
    Opaque name used to specify certificate instances or types. For example,
    "ROOTCA" to specify a root-certificate (validation context) or
    "example.com" to specify a certificate for a particular domain. Not all
    provider instances will actually use this field, so the value defaults to
    the empty string.
    """


@dataclass(eq=False, repr=False)
class SubjectAltNameMatcher(betterproto.Message):
    """
    Matcher for subject alternative names, to match both type and value of the
    SAN.
    """

    san_type: "SubjectAltNameMatcherSanType" = betterproto.enum_field(1)
    """
    Specification of type of SAN. Note that the default enum value is an
    invalid choice.
    """

    matcher: "____type_matcher_v3__.StringMatcher" = betterproto.message_field(2)
    """Matcher for SAN value."""


@dataclass(eq=False, repr=False)
class CertificateValidationContext(betterproto.Message):
    """[#next-free-field: 17]"""

    trusted_ca: "____config_core_v3__.DataSource" = betterproto.message_field(1)
    """
    TLS certificate data containing certificate authority certificates to use
    in verifying a presented peer certificate (e.g. server certificate for
    clusters or client certificate for listeners). If not specified and a peer
    certificate is presented it will not be verified. By default, a client
    certificate is optional, unless one of the additional options
    (:ref:`require_client_certificate <envoy_v3_api_field_extensions.transport_
    sockets.tls.v3.DownstreamTlsContext.require_client_certificate>`,
    :ref:`verify_certificate_spki <envoy_v3_api_field_extensions.transport_sock
    ets.tls.v3.CertificateValidationContext.verify_certificate_spki>`,
    :ref:`verify_certificate_hash <envoy_v3_api_field_extensions.transport_sock
    ets.tls.v3.CertificateValidationContext.verify_certificate_hash>`, or
    :ref:`match_typed_subject_alt_names <envoy_v3_api_field_extensions.transpor
    t_sockets.tls.v3.CertificateValidationContext.match_typed_subject_alt_names
    >`) is also specified. It can optionally contain certificate revocation
    lists, in which case Envoy will verify that the presented peer certificate
    has not been revoked by one of the included CRLs. Note that if a CRL is
    provided for any certificate authority in a trust chain, a CRL must be
    provided for all certificate authorities in that chain. Failure to do so
    will result in verification failure for both revoked and unrevoked
    certificates from that chain. The behavior of requiring all certificates to
    contain CRLs if any do can be altered by setting
    :ref:`only_verify_leaf_cert_crl <envoy_v3_api_field_extensions.transport_so
    ckets.tls.v3.CertificateValidationContext.only_verify_leaf_cert_crl>` true.
    If set to true, only the final certificate in the chain undergoes CRL
    verification. See :ref:`the TLS overview
    <arch_overview_ssl_enabling_verification>` for a list of common system CA
    locations. If ``trusted_ca`` is a filesystem path, a watch will be added to
    the parent directory for any file moves to support rotation. This currently
    only applies to dynamic secrets, when the ``CertificateValidationContext``
    is delivered via SDS. Only one of ``trusted_ca`` and
    ``ca_certificate_provider_instance`` may be specified. [#next-major-
    version: This field and watched_directory below should ideally be moved
    into a separate sub-message, since there's no point in specifying the
    latter field without this one.]
    """

    ca_certificate_provider_instance: "CertificateProviderPluginInstance" = (
        betterproto.message_field(13)
    )
    """
    Certificate provider instance for fetching TLS certificates. Only one of
    ``trusted_ca`` and ``ca_certificate_provider_instance`` may be specified.
    [#not-implemented-hide:]
    """

    watched_directory: "____config_core_v3__.WatchedDirectory" = (
        betterproto.message_field(11)
    )
    """
    If specified, updates of a file-based ``trusted_ca`` source will be
    triggered by this watch. This allows explicit control over the path
    watched, by default the parent directory of the filesystem path in
    ``trusted_ca`` is watched if this field is not specified. This only applies
    when a ``CertificateValidationContext`` is delivered by SDS with references
    to filesystem paths. See the :ref:`SDS key rotation <sds_key_rotation>`
    documentation for further details.
    """

    verify_certificate_spki: List[str] = betterproto.string_field(3)
    """
    An optional list of base64-encoded SHA-256 hashes. If specified, Envoy will
    verify that the SHA-256 of the DER-encoded Subject Public Key Information
    (SPKI) of the presented certificate matches one of the specified values. A
    base64-encoded SHA-256 of the Subject Public Key Information (SPKI) of the
    certificate can be generated with the following command: .. code-block::
    bash   $ openssl x509 -in path/to/client.crt -noout -pubkey     | openssl
    pkey -pubin -outform DER     | openssl dgst -sha256 -binary     | openssl
    enc -base64   NvqYIYSbgK2vCJpQhObf77vv+bQWtc5ek5RIOwPiC9A= This is the
    format used in HTTP Public Key Pinning. When both:
    :ref:`verify_certificate_hash <envoy_v3_api_field_extensions.transport_sock
    ets.tls.v3.CertificateValidationContext.verify_certificate_hash>` and
    :ref:`verify_certificate_spki <envoy_v3_api_field_extensions.transport_sock
    ets.tls.v3.CertificateValidationContext.verify_certificate_spki>` are
    specified, a hash matching value from either of the lists will result in
    the certificate being accepted. .. attention::   This option is preferred
    over :ref:`verify_certificate_hash   <envoy_v3_api_field_extensions.transpo
    rt_sockets.tls.v3.CertificateValidationContext.verify_certificate_hash>`,
    because SPKI is tied to a private key, so it doesn't change when the
    certificate   is renewed using the same private key.
    """

    verify_certificate_hash: List[str] = betterproto.string_field(2)
    """
    An optional list of hex-encoded SHA-256 hashes. If specified, Envoy will
    verify that the SHA-256 of the DER-encoded presented certificate matches
    one of the specified values. A hex-encoded SHA-256 of the certificate can
    be generated with the following command: .. code-block:: bash   $ openssl
    x509 -in path/to/client.crt -outform DER | openssl dgst -sha256 | cut -d" "
    -f2   df6ff72fe9116521268f6f2dd4966f51df479883fe7037b39f75916ac3049d1a A
    long hex-encoded and colon-separated SHA-256 (a.k.a. "fingerprint") of the
    certificate can be generated with the following command: .. code-block::
    bash   $ openssl x509 -in path/to/client.crt -noout -fingerprint -sha256 |
    cut -d"=" -f2   DF:6F:F7:2F:E9:11:65:21:26:8F:6F:2D:D4:96:6F:51:DF:47:98:83
    :FE:70:37:B3:9F:75:91:6A:C3:04:9D:1A Both of those formats are acceptable.
    When both: :ref:`verify_certificate_hash <envoy_v3_api_field_extensions.tra
    nsport_sockets.tls.v3.CertificateValidationContext.verify_certificate_hash>
    ` and :ref:`verify_certificate_spki <envoy_v3_api_field_extensions.transpor
    t_sockets.tls.v3.CertificateValidationContext.verify_certificate_spki>` are
    specified, a hash matching value from either of the lists will result in
    the certificate being accepted.
    """

    match_typed_subject_alt_names: List[
        "SubjectAltNameMatcher"
    ] = betterproto.message_field(15)
    """
    An optional list of Subject Alternative name matchers. If specified, Envoy
    will verify that the Subject Alternative Name of the presented certificate
    matches one of the specified matchers. The matching uses "any" semantics,
    that is to say, the SAN is verified if at least one matcher is matched.
    When a certificate has wildcard DNS SAN entries, to match a specific
    client, it should be configured with exact match type in the :ref:`string
    matcher <envoy_v3_api_msg_type.matcher.v3.StringMatcher>`. For example if
    the certificate has "\*.example.com" as DNS SAN entry, to allow only
    "api.example.com", it should be configured as shown below. .. code-block::
    yaml  match_typed_subject_alt_names:  - san_type: DNS    matcher:
    exact: "api.example.com" .. attention::   Subject Alternative Names are
    easily spoofable and verifying only them is insecure,   therefore this
    option must be used together with :ref:`trusted_ca   <envoy_v3_api_field_ex
    tensions.transport_sockets.tls.v3.CertificateValidationContext.trusted_ca>`
    .
    """

    match_subject_alt_names: List[
        "____type_matcher_v3__.StringMatcher"
    ] = betterproto.message_field(9)
    """
    This field is deprecated in favor of :ref:`match_typed_subject_alt_names <e
    nvoy_v3_api_field_extensions.transport_sockets.tls.v3.CertificateValidation
    Context.match_typed_subject_alt_names>`. Note that if both this field and
    :ref:`match_typed_subject_alt_names <envoy_v3_api_field_extensions.transpor
    t_sockets.tls.v3.CertificateValidationContext.match_typed_subject_alt_names
    >` are specified, the former (deprecated field) is ignored.
    """

    require_signed_certificate_timestamp: Optional[bool] = betterproto.message_field(
        6, wraps=betterproto.TYPE_BOOL
    )
    """[#not-implemented-hide:] Must present signed certificate time-stamp."""

    crl: "____config_core_v3__.DataSource" = betterproto.message_field(7)
    """
    An optional `certificate revocation list
    <https://en.wikipedia.org/wiki/Certificate_revocation_list>`_ (in PEM
    format). If specified, Envoy will verify that the presented peer
    certificate has not been revoked by this CRL. If this DataSource contains
    multiple CRLs, all of them will be used. Note that if a CRL is provided for
    any certificate authority in a trust chain, a CRL must be provided for all
    certificate authorities in that chain. Failure to do so will result in
    verification failure for both revoked and unrevoked certificates from that
    chain. This default behavior can be altered by setting
    :ref:`only_verify_leaf_cert_crl <envoy_v3_api_field_extensions.transport_so
    ckets.tls.v3.CertificateValidationContext.only_verify_leaf_cert_crl>` to
    true.
    """

    allow_expired_certificate: bool = betterproto.bool_field(8)
    """If specified, Envoy will not reject expired certificates."""

    trust_chain_verification: "CertificateValidationContextTrustChainVerification" = (
        betterproto.enum_field(10)
    )
    """Certificate trust chain verification mode."""

    custom_validator_config: "____config_core_v3__.TypedExtensionConfig" = (
        betterproto.message_field(12)
    )
    """
    The configuration of an extension specific certificate validator. If
    specified, all validation is done by the specified validator, and the
    behavior of all other validation settings is defined by the specified
    validator (and may be entirely ignored, unused, and unvalidated). Refer to
    the documentation for the specified validator. If you do not want a custom
    validation algorithm, do not set this field. [#extension-category:
    envoy.tls.cert_validator]
    """

    only_verify_leaf_cert_crl: bool = betterproto.bool_field(14)
    """
    If this option is set to true, only the certificate at the end of the
    certificate chain will be subject to validation by :ref:`CRL <envoy_v3_api_
    field_extensions.transport_sockets.tls.v3.CertificateValidationContext.crl>
    `.
    """

    max_verify_depth: Optional[int] = betterproto.message_field(
        16, wraps=betterproto.TYPE_UINT32
    )
    """
    Config for the max number of intermediate certificates in chain that are
    parsed during verification. This does not include the leaf certificate. If
    configured, and the certificate chain is longer than allowed, the
    certificates above the limit are ignored, and certificate validation will
    fail. The default limit is 100, though this can be system-dependent.
    https://www.openssl.org/docs/man1.1.1/man3/SSL_CTX_set_verify_depth.html
    """

    def __post_init__(self) -> None:
        super().__post_init__()
        if self.is_set("match_subject_alt_names"):
            warnings.warn(
                "CertificateValidationContext.match_subject_alt_names is deprecated",
                DeprecationWarning,
            )


@dataclass(eq=False, repr=False)
class GenericSecret(betterproto.Message):
    secret: "____config_core_v3__.DataSource" = betterproto.message_field(1)
    """Secret of generic type and is available to filters."""


@dataclass(eq=False, repr=False)
class SdsSecretConfig(betterproto.Message):
    name: str = betterproto.string_field(1)
    """
    Name by which the secret can be uniquely referred to. When both name and
    config are specified, then secret can be fetched and/or reloaded via SDS.
    When only name is specified, then secret will be loaded from static
    resources.
    """

    sds_config: "____config_core_v3__.ConfigSource" = betterproto.message_field(2)


@dataclass(eq=False, repr=False)
class Secret(betterproto.Message):
    """[#next-free-field: 6]"""

    name: str = betterproto.string_field(1)
    """
    Name (FQDN, UUID, SPKI, SHA256, etc.) by which the secret can be uniquely
    referred to.
    """

    tls_certificate: "TlsCertificate" = betterproto.message_field(2, group="type")
    session_ticket_keys: "TlsSessionTicketKeys" = betterproto.message_field(
        3, group="type"
    )
    validation_context: "CertificateValidationContext" = betterproto.message_field(
        4, group="type"
    )
    generic_secret: "GenericSecret" = betterproto.message_field(5, group="type")


@dataclass(eq=False, repr=False)
class UpstreamTlsContext(betterproto.Message):
    common_tls_context: "CommonTlsContext" = betterproto.message_field(1)
    """
    Common TLS context settings. .. attention::   Server certificate
    verification is not enabled by default. Configure   :ref:`trusted_ca<envoy_
    v3_api_field_extensions.transport_sockets.tls.v3.CertificateValidationConte
    xt.trusted_ca>` to enable   verification.
    """

    sni: str = betterproto.string_field(2)
    """SNI string to use when creating TLS backend connections."""

    allow_renegotiation: bool = betterproto.bool_field(3)
    """
    If true, server-initiated TLS renegotiation will be allowed. .. attention::
    TLS renegotiation is considered insecure and shouldn't be used unless
    absolutely necessary.
    """

    max_session_keys: Optional[int] = betterproto.message_field(
        4, wraps=betterproto.TYPE_UINT32
    )
    """
    Maximum number of session keys (Pre-Shared Keys for TLSv1.3+, Session IDs
    and Session Tickets for TLSv1.2 and older) to store for the purpose of
    session resumption. Defaults to 1, setting this to 0 disables session
    resumption.
    """


@dataclass(eq=False, repr=False)
class DownstreamTlsContext(betterproto.Message):
    """[#next-free-field: 9]"""

    common_tls_context: "CommonTlsContext" = betterproto.message_field(1)
    """Common TLS context settings."""

    require_client_certificate: Optional[bool] = betterproto.message_field(
        2, wraps=betterproto.TYPE_BOOL
    )
    """
    If specified, Envoy will reject connections without a valid client
    certificate.
    """

    require_sni: Optional[bool] = betterproto.message_field(
        3, wraps=betterproto.TYPE_BOOL
    )
    """
    If specified, Envoy will reject connections without a valid and matching
    SNI. [#not-implemented-hide:]
    """

    session_ticket_keys: "TlsSessionTicketKeys" = betterproto.message_field(
        4, group="session_ticket_keys_type"
    )
    """TLS session ticket key settings."""

    session_ticket_keys_sds_secret_config: "SdsSecretConfig" = (
        betterproto.message_field(5, group="session_ticket_keys_type")
    )
    """Config for fetching TLS session ticket keys via SDS API."""

    disable_stateless_session_resumption: bool = betterproto.bool_field(
        7, group="session_ticket_keys_type"
    )
    """
    Config for controlling stateless TLS session resumption: setting this to
    true will cause the TLS server to not issue TLS session tickets for the
    purposes of stateless TLS session resumption. If set to false, the TLS
    server will issue TLS session tickets and encrypt/decrypt them using the
    keys specified through either :ref:`session_ticket_keys <envoy_v3_api_field
    _extensions.transport_sockets.tls.v3.DownstreamTlsContext.session_ticket_ke
    ys>` or :ref:`session_ticket_keys_sds_secret_config <envoy_v3_api_field_ext
    ensions.transport_sockets.tls.v3.DownstreamTlsContext.session_ticket_keys_s
    ds_secret_config>`. If this config is set to false and no keys are
    explicitly configured, the TLS server will issue TLS session tickets and
    encrypt/decrypt them using an internally-generated and managed key, with
    the implication that sessions cannot be resumed across hot restarts or on
    different hosts.
    """

    session_timeout: timedelta = betterproto.message_field(6)
    """
    If specified, ``session_timeout`` will change the maximum lifetime (in
    seconds) of the TLS session. Currently this value is used as a hint for the
    `TLS session ticket lifetime (for TLSv1.2)
    <https://tools.ietf.org/html/rfc5077#section-5.6>`_. Only seconds can be
    specified (fractional seconds are ignored).
    """

    ocsp_staple_policy: "DownstreamTlsContextOcspStaplePolicy" = betterproto.enum_field(
        8
    )
    """
    Config for whether to use certificates if they do not have an accompanying
    OCSP response or if the response expires at runtime. Defaults to
    LENIENT_STAPLING
    """


@dataclass(eq=False, repr=False)
class TlsKeyLog(betterproto.Message):
    """
    TLS key log configuration. The key log file format is "format used by NSS
    for its SSLKEYLOGFILE debugging output" (text taken from openssl man page)
    """

    path: str = betterproto.string_field(1)
    """The path to save the TLS key log."""

    local_address_range: List[
        "____config_core_v3__.CidrRange"
    ] = betterproto.message_field(2)
    """
    The local IP address that will be used to filter the connection which
    should save the TLS key log If it is not set, any local IP address  will be
    matched.
    """

    remote_address_range: List[
        "____config_core_v3__.CidrRange"
    ] = betterproto.message_field(3)
    """
    The remote IP address that will be used to filter the connection which
    should save the TLS key log If it is not set, any remote IP address will be
    matched.
    """


@dataclass(eq=False, repr=False)
class CommonTlsContext(betterproto.Message):
    """
    TLS context shared by both client and server TLS contexts. [#next-free-
    field: 16]
    """

    tls_params: "TlsParameters" = betterproto.message_field(1)
    """TLS protocol versions, cipher suites etc."""

    tls_certificates: List["TlsCertificate"] = betterproto.message_field(2)
    """
    :ref:`Multiple TLS certificates <arch_overview_ssl_cert_select>` can be
    associated with the same context to allow both RSA and ECDSA certificates.
    Only a single TLS certificate is supported in client contexts. In server
    contexts, the first RSA certificate is used for clients that only support
    RSA and the first ECDSA certificate is used for clients that support ECDSA.
    Only one of ``tls_certificates``, ``tls_certificate_sds_secret_configs``,
    and ``tls_certificate_provider_instance`` may be used. [#next-major-
    version: These mutually exclusive fields should ideally be in a oneof, but
    it's not legal to put a repeated field in a oneof. In the next major
    version, we should rework this to avoid this problem.]
    """

    tls_certificate_sds_secret_configs: List[
        "SdsSecretConfig"
    ] = betterproto.message_field(6)
    """
    Configs for fetching TLS certificates via SDS API. Note SDS API allows
    certificates to be fetched/refreshed over the network asynchronously with
    respect to the TLS handshake. The same number and types of certificates as
    :ref:`tls_certificates <envoy_v3_api_field_extensions.transport_sockets.tls
    .v3.CommonTlsContext.tls_certificates>` are valid in the the certificates
    fetched through this setting. Only one of ``tls_certificates``,
    ``tls_certificate_sds_secret_configs``, and
    ``tls_certificate_provider_instance`` may be used. [#next-major-version:
    These mutually exclusive fields should ideally be in a oneof, but it's not
    legal to put a repeated field in a oneof. In the next major version, we
    should rework this to avoid this problem.]
    """

    tls_certificate_provider_instance: "CertificateProviderPluginInstance" = (
        betterproto.message_field(14)
    )
    """
    Certificate provider instance for fetching TLS certs. Only one of
    ``tls_certificates``, ``tls_certificate_sds_secret_configs``, and
    ``tls_certificate_provider_instance`` may be used. [#not-implemented-hide:]
    """

    tls_certificate_certificate_provider: "CommonTlsContextCertificateProvider" = (
        betterproto.message_field(9)
    )
    """
    Certificate provider for fetching TLS certificates. [#not-implemented-
    hide:]
    """

    tls_certificate_certificate_provider_instance: "CommonTlsContextCertificateProviderInstance" = betterproto.message_field(
        11
    )
    """
    Certificate provider instance for fetching TLS certificates. [#not-
    implemented-hide:]
    """

    validation_context: "CertificateValidationContext" = betterproto.message_field(
        3, group="validation_context_type"
    )
    """How to validate peer certificates."""

    validation_context_sds_secret_config: "SdsSecretConfig" = betterproto.message_field(
        7, group="validation_context_type"
    )
    """
    Config for fetching validation context via SDS API. Note SDS API allows
    certificates to be fetched/refreshed over the network asynchronously with
    respect to the TLS handshake.
    """

    combined_validation_context: "CommonTlsContextCombinedCertificateValidationContext" = betterproto.message_field(
        8, group="validation_context_type"
    )
    """
    Combined certificate validation context holds a default
    CertificateValidationContext and SDS config. When SDS server returns
    dynamic CertificateValidationContext, both dynamic and default
    CertificateValidationContext are merged into a new
    CertificateValidationContext for validation. This merge is done by
    Message::MergeFrom(), so dynamic CertificateValidationContext overwrites
    singular fields in default CertificateValidationContext, and concatenates
    repeated fields to default CertificateValidationContext, and logical OR is
    applied to boolean fields.
    """

    validation_context_certificate_provider: "CommonTlsContextCertificateProvider" = (
        betterproto.message_field(10, group="validation_context_type")
    )
    """
    Certificate provider for fetching validation context. [#not-implemented-
    hide:]
    """

    validation_context_certificate_provider_instance: "CommonTlsContextCertificateProviderInstance" = betterproto.message_field(
        12, group="validation_context_type"
    )
    """
    Certificate provider instance for fetching validation context. [#not-
    implemented-hide:]
    """

    alpn_protocols: List[str] = betterproto.string_field(4)
    """
    Supplies the list of ALPN protocols that the listener should expose. In
    practice this is likely to be set to one of two values (see the
    :ref:`codec_type <envoy_v3_api_field_extensions.filters.network.http_connec
    tion_manager.v3.HttpConnectionManager.codec_type>` parameter in the HTTP
    connection manager for more information): * "h2,http/1.1" If the listener
    is going to support both HTTP/2 and HTTP/1.1. * "http/1.1" If the listener
    is only going to support HTTP/1.1. There is no default for this parameter.
    If empty, Envoy will not expose ALPN.
    """

    custom_handshaker: "____config_core_v3__.TypedExtensionConfig" = (
        betterproto.message_field(13)
    )
    """
    Custom TLS handshaker. If empty, defaults to native TLS handshaking
    behavior.
    """

    key_log: "TlsKeyLog" = betterproto.message_field(15)
    """TLS key log configuration"""

    def __post_init__(self) -> None:
        super().__post_init__()
        if self.is_set("tls_certificate_certificate_provider"):
            warnings.warn(
                "CommonTlsContext.tls_certificate_certificate_provider is deprecated",
                DeprecationWarning,
            )
        if self.is_set("tls_certificate_certificate_provider_instance"):
            warnings.warn(
                "CommonTlsContext.tls_certificate_certificate_provider_instance is deprecated",
                DeprecationWarning,
            )
        if self.is_set("validation_context_certificate_provider"):
            warnings.warn(
                "CommonTlsContext.validation_context_certificate_provider is deprecated",
                DeprecationWarning,
            )
        if self.is_set("validation_context_certificate_provider_instance"):
            warnings.warn(
                "CommonTlsContext.validation_context_certificate_provider_instance is deprecated",
                DeprecationWarning,
            )


@dataclass(eq=False, repr=False)
class CommonTlsContextCertificateProvider(betterproto.Message):
    """
    Config for Certificate provider to get certificates. This provider should
    allow certificates to be fetched/refreshed over the network asynchronously
    with respect to the TLS handshake. DEPRECATED: This message is not
    currently used, but if we ever do need it, we will want to move it out of
    CommonTlsContext and into common.proto, similar to the existing
    CertificateProviderPluginInstance message. [#not-implemented-hide:]
    """

    name: str = betterproto.string_field(1)
    """
    opaque name used to specify certificate instances or types. For example,
    "ROOTCA" to specify a root-certificate (validation context) or "TLS" to
    specify a new tls-certificate.
    """

    typed_config: "____config_core_v3__.TypedExtensionConfig" = (
        betterproto.message_field(2, group="config")
    )


@dataclass(eq=False, repr=False)
class CommonTlsContextCertificateProviderInstance(betterproto.Message):
    """
    Similar to CertificateProvider above, but allows the provider instances to
    be configured on the client side instead of being sent from the control
    plane. DEPRECATED: This message was moved outside of CommonTlsContext and
    now lives in common.proto. [#not-implemented-hide:]
    """

    instance_name: str = betterproto.string_field(1)
    """
    Provider instance name. This name must be defined in the client's
    configuration (e.g., a bootstrap file) to correspond to a provider instance
    (i.e., the same data in the typed_config field that would be sent in the
    CertificateProvider message if the config was sent by the control plane).
    If not present, defaults to "default". Instance names should generally be
    defined not in terms of the underlying provider implementation (e.g.,
    "file_watcher") but rather in terms of the function of the certificates
    (e.g., "foo_deployment_identity").
    """

    certificate_name: str = betterproto.string_field(2)
    """
    Opaque name used to specify certificate instances or types. For example,
    "ROOTCA" to specify a root-certificate (validation context) or
    "example.com" to specify a certificate for a particular domain. Not all
    provider instances will actually use this field, so the value defaults to
    the empty string.
    """


@dataclass(eq=False, repr=False)
class CommonTlsContextCombinedCertificateValidationContext(betterproto.Message):
    default_validation_context: "CertificateValidationContext" = (
        betterproto.message_field(1)
    )
    """How to validate peer certificates."""

    validation_context_sds_secret_config: "SdsSecretConfig" = betterproto.message_field(
        2
    )
    """
    Config for fetching validation context via SDS API. Note SDS API allows
    certificates to be fetched/refreshed over the network asynchronously with
    respect to the TLS handshake.
    """

    validation_context_certificate_provider: "CommonTlsContextCertificateProvider" = (
        betterproto.message_field(3)
    )
    """
    Certificate provider for fetching CA certs. This will populate the
    ``default_validation_context.trusted_ca`` field. [#not-implemented-hide:]
    """

    validation_context_certificate_provider_instance: "CommonTlsContextCertificateProviderInstance" = betterproto.message_field(
        4
    )
    """
    Certificate provider instance for fetching CA certs. This will populate the
    ``default_validation_context.trusted_ca`` field. [#not-implemented-hide:]
    """

    def __post_init__(self) -> None:
        super().__post_init__()
        if self.is_set("validation_context_certificate_provider"):
            warnings.warn(
                "CommonTlsContextCombinedCertificateValidationContext.validation_context_certificate_provider is deprecated",
                DeprecationWarning,
            )
        if self.is_set("validation_context_certificate_provider_instance"):
            warnings.warn(
                "CommonTlsContextCombinedCertificateValidationContext.validation_context_certificate_provider_instance is deprecated",
                DeprecationWarning,
            )


@dataclass(eq=False, repr=False)
class SpiffeCertValidatorConfig(betterproto.Message):
    """
    Configuration specific to the `SPIFFE <https://github.com/spiffe/spiffe>`_
    certificate validator. Example: .. validated-code-block:: yaml   :type-
    name:
    envoy.extensions.transport_sockets.tls.v3.CertificateValidationContext
    custom_validator_config:     name: envoy.tls.cert_validator.spiffe
    typed_config:       "@type": type.googleapis.com/envoy.extensions.transport
    _sockets.tls.v3.SPIFFECertValidatorConfig       trust_domains:       -
    name: foo.com         trust_bundle:           filename: "foo.pem"       -
    name: envoy.com         trust_bundle:           filename: "envoy.pem" In
    this example, a presented peer certificate whose SAN matches
    ``spiffe//foo.com/**`` is validated against the "foo.pem" x.509
    certificate. All the trust bundles are isolated from each other, so no
    trust domain can mint a SVID belonging to another trust domain. That means,
    in this example, a SVID signed by ``envoy.com``'s CA with
    ``spiffe//foo.com/**`` SAN would be rejected since Envoy selects the trust
    bundle according to the presented SAN before validate the certificate. Note
    that SPIFFE validator inherits and uses the following options from
    :ref:`CertificateValidationContext <envoy_v3_api_msg_extensions.transport_s
    ockets.tls.v3.CertificateValidationContext>`. -
    :ref:`allow_expired_certificate <envoy_v3_api_field_extensions.transport_so
    ckets.tls.v3.CertificateValidationContext.allow_expired_certificate>` to
    allow expired certificates. - :ref:`match_typed_subject_alt_names <envoy_v3
    _api_field_extensions.transport_sockets.tls.v3.CertificateValidationContext
    .match_typed_subject_alt_names>` to match **URI** SAN of certificates.
    Unlike the default validator, SPIFFE validator only matches **URI** SAN
    (which equals to SVID in SPIFFE terminology) and ignore other SAN types.
    """

    trust_domains: List[
        "SpiffeCertValidatorConfigTrustDomain"
    ] = betterproto.message_field(1)
    """
    This field specifies trust domains used for validating incoming
    X.509-SVID(s).
    """


@dataclass(eq=False, repr=False)
class SpiffeCertValidatorConfigTrustDomain(betterproto.Message):
    name: str = betterproto.string_field(1)
    """
    Name of the trust domain, ``example.com``, ``foo.bar.gov`` for example.
    Note that this must *not* have "spiffe://" prefix.
    """

    trust_bundle: "____config_core_v3__.DataSource" = betterproto.message_field(2)
    """
    Specify a data source holding x.509 trust bundle used for validating
    incoming SVID(s) in this trust domain.
    """
