# Generated by the protocol buffer compiler.  DO NOT EDIT!
# sources: envoy/extensions/filters/udp/udp_proxy/v3/route.proto, envoy/extensions/filters/udp/udp_proxy/v3/udp_proxy.proto
# plugin: python-betterproto
import warnings
from dataclasses import dataclass
from datetime import timedelta
from typing import List

import betterproto

from .......xds.type.matcher import v3 as ______xds_type_matcher_v3__
from ......config.accesslog import v3 as _____config_accesslog_v3__
from ......config.core import v3 as _____config_core_v3__


@dataclass(eq=False, repr=False)
class UdpProxyConfig(betterproto.Message):
    """Configuration for the UDP proxy filter. [#next-free-field: 10]"""

    stat_prefix: str = betterproto.string_field(1)
    """The stat prefix used when emitting UDP proxy filter stats."""

    cluster: str = betterproto.string_field(2, group="route_specifier")
    """
    The upstream cluster to connect to. This field is deprecated in favor of
    :ref:`matcher <envoy_v3_api_field_extensions.filters.udp.udp_proxy.v3.UdpPr
    oxyConfig.matcher>`.
    """

    matcher: "______xds_type_matcher_v3__.Matcher" = betterproto.message_field(
        9, group="route_specifier"
    )
    """
    The match tree to use when resolving route actions for incoming requests.
    See :ref:`Routing <config_udp_listener_filters_udp_proxy_routing>` for more
    information.
    """

    idle_timeout: timedelta = betterproto.message_field(3)
    """
    The idle timeout for sessions. Idle is defined as no datagrams between
    received or sent by the session. The default if not specified is 1 minute.
    """

    use_original_src_ip: bool = betterproto.bool_field(4)
    """
    Use the remote downstream IP address as the sender IP address when sending
    packets to upstream hosts. This option requires Envoy to be run with the
    ``CAP_NET_ADMIN`` capability on Linux. And the IPv6 stack must be enabled
    on Linux kernel. This option does not preserve the remote downstream port.
    If this option is enabled, the IP address of sent datagrams will be changed
    to the remote downstream IP address. This means that Envoy will not receive
    packets that are sent by upstream hosts because the upstream hosts will
    send the packets with the remote downstream IP address as the destination.
    All packets will be routed to the remote downstream directly if there are
    route rules on the upstream host side. There are two options to return the
    packets back to the remote downstream. The first one is to use DSR (Direct
    Server Return). The other one is to configure routing rules on the upstream
    hosts to forward all packets back to Envoy and configure iptables rules on
    the host running Envoy to forward all packets from upstream hosts to the
    Envoy process so that Envoy can forward the packets to the downstream. If
    the platform does not support this option, Envoy will raise a configuration
    error.
    """

    hash_policies: List["UdpProxyConfigHashPolicy"] = betterproto.message_field(5)
    """
    Optional configuration for UDP proxy hash policies. If hash_policies is not
    set, the hash-based load balancing algorithms will select a host randomly.
    Currently the number of hash policies is limited to 1.
    """

    upstream_socket_config: "_____config_core_v3__.UdpSocketConfig" = (
        betterproto.message_field(6)
    )
    """
    UDP socket configuration for upstream sockets. The default for
    :ref:`prefer_gro
    <envoy_v3_api_field_config.core.v3.UdpSocketConfig.prefer_gro>` is true for
    upstream sockets as the assumption is datagrams will be received from a
    single source.
    """

    use_per_packet_load_balancing: bool = betterproto.bool_field(7)
    """
    Perform per packet load balancing (upstream host selection) on each
    received data chunk. The default if not specified is false, that means each
    data chunk is forwarded to upstream host selected on first chunk receival
    for that "session" (identified by source IP/port and local IP/port).
    """

    access_log: List[
        "_____config_accesslog_v3__.AccessLog"
    ] = betterproto.message_field(8)
    """
    Configuration for access logs emitted by the UDP proxy. Note that certain
    UDP specific data is emitted as :ref:`Dynamic Metadata
    <config_access_log_format_dynamic_metadata>`.
    """

    def __post_init__(self) -> None:
        super().__post_init__()
        if self.is_set("cluster"):
            warnings.warn("UdpProxyConfig.cluster is deprecated", DeprecationWarning)


@dataclass(eq=False, repr=False)
class UdpProxyConfigHashPolicy(betterproto.Message):
    """
    Specifies the UDP hash policy. The packets can be routed by hash policy.
    """

    source_ip: bool = betterproto.bool_field(1, group="policy_specifier")
    """
    The source IP will be used to compute the hash used by hash-based load
    balancing algorithms.
    """

    key: str = betterproto.string_field(2, group="policy_specifier")
    """
    A given key will be used to compute the hash used by hash-based load
    balancing algorithms. In certain cases there is a need to direct different
    UDP streams jointly towards the selected set of endpoints. A possible use-
    case is VoIP telephony, where media (RTP) and its corresponding control
    (RTCP) belong to the same logical session, although they travel in separate
    streams. To ensure that these pair of streams are load-balanced on session
    level (instead of individual stream level), dynamically created listeners
    can use the same hash key for each stream in the session.
    """


@dataclass(eq=False, repr=False)
class Route(betterproto.Message):
    cluster: str = betterproto.string_field(1)
    """
    Indicates the upstream cluster to which the request should be routed.
    """
