# Generated by the protocol buffer compiler.  DO NOT EDIT!
# sources: envoy/extensions/filters/network/dubbo_proxy/v3/dubbo_proxy.proto, envoy/extensions/filters/network/dubbo_proxy/v3/route.proto
# plugin: python-betterproto
import warnings
from dataclasses import dataclass
from typing import (
    Dict,
    List,
)

import betterproto
import betterproto.lib.google.protobuf as betterproto_lib_google_protobuf

from ......config.core import v3 as _____config_core_v3__
from ......config.route import v3 as _____config_route_v3__
from ......type import v3 as _____type_v3__
from ......type.matcher import v3 as _____type_matcher_v3__


class ProtocolType(betterproto.Enum):
    """Dubbo Protocol types supported by Envoy."""

    Dubbo = 0
    """the default protocol."""


class SerializationType(betterproto.Enum):
    """Dubbo Serialization types supported by Envoy."""

    Hessian2 = 0
    """the default serialization protocol."""


@dataclass(eq=False, repr=False)
class RouteConfiguration(betterproto.Message):
    """[#next-free-field: 6]"""

    name: str = betterproto.string_field(1)
    """
    The name of the route configuration. Reserved for future use in
    asynchronous route discovery.
    """

    interface: str = betterproto.string_field(2)
    """
    The interface name of the service. Wildcard interface are supported in the
    suffix or prefix form. e.g. ``*.methods.add`` will match
    ``com.dev.methods.add``, ``com.prod.methods.add``, etc.
    ``com.dev.methods.*`` will match ``com.dev.methods.add``,
    ``com.dev.methods.update``, etc. Special wildcard ``*`` matching any
    interface. .. note::  The wildcard will not match the empty string.  e.g.
    ``*.methods.add`` will match ``com.dev.methods.add`` but not
    ``.methods.add``.
    """

    group: str = betterproto.string_field(3)
    """Which group does the interface belong to."""

    version: str = betterproto.string_field(4)
    """The version number of the interface."""

    routes: List["Route"] = betterproto.message_field(5)
    """
    The list of routes that will be matched, in order, against incoming
    requests. The first route that matches will be used.
    """


@dataclass(eq=False, repr=False)
class Route(betterproto.Message):
    match: "RouteMatch" = betterproto.message_field(1)
    """Route matching parameters."""

    route: "RouteAction" = betterproto.message_field(2)
    """Route request to some upstream cluster."""


@dataclass(eq=False, repr=False)
class RouteMatch(betterproto.Message):
    method: "MethodMatch" = betterproto.message_field(1)
    """Method level routing matching."""

    headers: List["_____config_route_v3__.HeaderMatcher"] = betterproto.message_field(2)
    """
    Specifies a set of headers that the route should match on. The router will
    check the request’s headers against all the specified headers in the route
    config. A match will happen if all the headers in the route are present in
    the request with the same values (or based on presence if the value field
    is not in the config).
    """


@dataclass(eq=False, repr=False)
class RouteAction(betterproto.Message):
    cluster: str = betterproto.string_field(1, group="cluster_specifier")
    """
    Indicates the upstream cluster to which the request should be routed.
    """

    weighted_clusters: "_____config_route_v3__.WeightedCluster" = (
        betterproto.message_field(2, group="cluster_specifier")
    )
    """
    Multiple upstream clusters can be specified for a given route. The request
    is routed to one of the upstream clusters based on weights assigned to each
    cluster. Currently ClusterWeight only supports the name and weight fields.
    """

    metadata_match: "_____config_core_v3__.Metadata" = betterproto.message_field(3)
    """
    Optional endpoint metadata match criteria used by the subset load balancer.
    Only endpoints in the upstream cluster with metadata matching what is set
    in this field will be considered for load balancing. The filter name should
    be specified as ``envoy.lb``.
    """


@dataclass(eq=False, repr=False)
class MethodMatch(betterproto.Message):
    name: "_____type_matcher_v3__.StringMatcher" = betterproto.message_field(1)
    """The name of the method."""

    params_match: Dict[
        int, "MethodMatchParameterMatchSpecifier"
    ] = betterproto.map_field(2, betterproto.TYPE_UINT32, betterproto.TYPE_MESSAGE)
    """
    Method parameter definition. The key is the parameter index, starting from
    0. The value is the parameter matching type.
    """


@dataclass(eq=False, repr=False)
class MethodMatchParameterMatchSpecifier(betterproto.Message):
    """The parameter matching type."""

    exact_match: str = betterproto.string_field(3, group="parameter_match_specifier")
    """
    If specified, header match will be performed based on the value of the
    header.
    """

    range_match: "_____type_v3__.Int64Range" = betterproto.message_field(
        4, group="parameter_match_specifier"
    )
    """
    If specified, header match will be performed based on range. The rule will
    match if the request header value is within this range. The entire request
    header value must represent an integer in base 10 notation: consisting of
    an optional plus or minus sign followed by a sequence of digits. The rule
    will not match if the header value does not represent an integer. Match
    will fail for empty values, floating point numbers or if only a subsequence
    of the header value is an integer. Examples: * For range [-10,0), route
    will match for header value -1, but not for 0,   "somestring", 10.9,
    "-1somestring"
    """


@dataclass(eq=False, repr=False)
class MultipleRouteConfiguration(betterproto.Message):
    name: str = betterproto.string_field(1)
    """
    The name of the named route configurations. This name is used in
    asynchronous route discovery.
    """

    route_config: List["RouteConfiguration"] = betterproto.message_field(4)
    """The route table of the dubbo connection manager."""


@dataclass(eq=False, repr=False)
class Drds(betterproto.Message):
    config_source: "_____config_core_v3__.ConfigSource" = betterproto.message_field(1)
    """
    Configuration source specifier. In case of ``api_config_source`` only
    aggregated ``api_type`` is supported.
    """

    route_config_name: str = betterproto.string_field(2)
    """
    The name of the multiple route configuration. This allows to use different
    multiple route configurations. Tells which multiple route configuration
    should be fetched from the configuration source. Leave unspecified is also
    valid and means the unnamed multiple route configuration.
    """


@dataclass(eq=False, repr=False)
class DubboProxy(betterproto.Message):
    """[#next-free-field: 8]"""

    stat_prefix: str = betterproto.string_field(1)
    """The human readable prefix to use when emitting statistics."""

    protocol_type: "ProtocolType" = betterproto.enum_field(2)
    """Configure the protocol used."""

    serialization_type: "SerializationType" = betterproto.enum_field(3)
    """Configure the serialization protocol used."""

    route_config: List["RouteConfiguration"] = betterproto.message_field(4)
    """
    The route table for the connection manager is static and is specified in
    this property. .. note::   This field is deprecated. Please use ``drds`` or
    ``multiple_route_config`` first.
    """

    drds: "Drds" = betterproto.message_field(6, group="route_specifier")
    """
    Use xDS to fetch the route configuration. It is invalid to define both
    ``route_config`` and ``drds``.
    """

    multiple_route_config: "MultipleRouteConfiguration" = betterproto.message_field(
        7, group="route_specifier"
    )
    dubbo_filters: List["DubboFilter"] = betterproto.message_field(5)
    """
    A list of individual Dubbo filters that make up the filter chain for
    requests made to the Dubbo proxy. Order matters as the filters are
    processed sequentially. For backwards compatibility, if no dubbo_filters
    are specified, a default Dubbo router filter
    (``envoy.filters.dubbo.router``) is used.
    """

    def __post_init__(self) -> None:
        super().__post_init__()
        if self.is_set("route_config"):
            warnings.warn("DubboProxy.route_config is deprecated", DeprecationWarning)


@dataclass(eq=False, repr=False)
class DubboFilter(betterproto.Message):
    """DubboFilter configures a Dubbo filter."""

    name: str = betterproto.string_field(1)
    """
    The name of the filter to instantiate. The name must match a supported
    filter.
    """

    config: "betterproto_lib_google_protobuf.Any" = betterproto.message_field(2)
    """
    Filter specific configuration which depends on the filter being
    instantiated. See the supported filters for further documentation.
    """
