# Generated by the protocol buffer compiler.  DO NOT EDIT!
# sources: envoy/extensions/filters/http/ext_proc/v3/ext_proc.proto, envoy/extensions/filters/http/ext_proc/v3/processing_mode.proto
# plugin: python-betterproto
from dataclasses import dataclass
from datetime import timedelta
from typing import List

import betterproto

from ......config.common.mutation_rules import (
    v3 as _____config_common_mutation_rules_v3__,
)
from ......config.core import v3 as _____config_core_v3__


class ProcessingModeHeaderSendMode(betterproto.Enum):
    """Control how headers and trailers are handled"""

    DEFAULT = 0
    """
    The default HeaderSendMode depends on which part of the message is being
    processed. By default, request and response headers are sent, while
    trailers are skipped.
    """

    SEND = 1
    """Send the header or trailer."""

    SKIP = 2
    """Do not send the header or trailer."""


class ProcessingModeBodySendMode(betterproto.Enum):
    """Control how the request and response bodies are handled"""

    NONE = 0
    """Do not send the body at all. This is the default."""

    STREAMED = 1
    """Stream the body to the server in pieces as they arrive at the proxy."""

    BUFFERED = 2
    """
    Buffer the message body in memory and send the entire body at once. If the
    body exceeds the configured buffer limit, then the downstream system will
    receive an error.
    """

    BUFFERED_PARTIAL = 3
    """
    Buffer the message body in memory and send the entire body in one chunk. If
    the body exceeds the configured buffer limit, then the body contents up to
    the buffer limit will be sent.
    """


@dataclass(eq=False, repr=False)
class ProcessingMode(betterproto.Message):
    """[#next-free-field: 7]"""

    request_header_mode: "ProcessingModeHeaderSendMode" = betterproto.enum_field(1)
    """How to handle the request header. Default is "SEND"."""

    response_header_mode: "ProcessingModeHeaderSendMode" = betterproto.enum_field(2)
    """How to handle the response header. Default is "SEND"."""

    request_body_mode: "ProcessingModeBodySendMode" = betterproto.enum_field(3)
    """How to handle the request body. Default is "NONE"."""

    response_body_mode: "ProcessingModeBodySendMode" = betterproto.enum_field(4)
    """How do handle the response body. Default is "NONE"."""

    request_trailer_mode: "ProcessingModeHeaderSendMode" = betterproto.enum_field(5)
    """How to handle the request trailers. Default is "SKIP"."""

    response_trailer_mode: "ProcessingModeHeaderSendMode" = betterproto.enum_field(6)
    """How to handle the response trailers. Default is "SKIP"."""


@dataclass(eq=False, repr=False)
class ExternalProcessor(betterproto.Message):
    """[#next-free-field: 10]"""

    grpc_service: "_____config_core_v3__.GrpcService" = betterproto.message_field(1)
    """
    Configuration for the gRPC service that the filter will communicate with.
    The filter supports both the "Envoy" and "Google" gRPC clients.
    """

    failure_mode_allow: bool = betterproto.bool_field(2)
    """
    By default, if the gRPC stream cannot be established, or if it is closed
    prematurely with an error, the filter will fail. Specifically, if the
    response headers have not yet been delivered, then it will return a 500
    error downstream. If they have been delivered, then instead the HTTP stream
    to the downstream client will be reset. With this parameter set to true,
    however, then if the gRPC stream is prematurely closed or could not be
    opened, processing continues without error.
    """

    processing_mode: "ProcessingMode" = betterproto.message_field(3)
    """
    Specifies default options for how HTTP headers, trailers, and bodies are
    sent. See ProcessingMode for details.
    """

    async_mode: bool = betterproto.bool_field(4)
    """
    [#not-implemented-hide:] If true, send each part of the HTTP request or
    response specified by ProcessingMode asynchronously -- in other words, send
    the message on the gRPC stream and then continue filter processing. If
    false, which is the default, suspend filter execution after each message is
    sent to the remote service and wait up to "message_timeout" for a reply.
    """

    request_attributes: List[str] = betterproto.string_field(5)
    """
    [#not-implemented-hide:] Envoy provides a number of :ref:`attributes
    <arch_overview_attributes>` for expressive policies. Each attribute name
    provided in this field will be matched against that list and populated in
    the request_headers message. See the :ref:`attribute documentation
    <arch_overview_request_attributes>` for the list of supported attributes
    and their types.
    """

    response_attributes: List[str] = betterproto.string_field(6)
    """
    [#not-implemented-hide:] Envoy provides a number of :ref:`attributes
    <arch_overview_attributes>` for expressive policies. Each attribute name
    provided in this field will be matched against that list and populated in
    the response_headers message. See the :ref:`attribute documentation
    <arch_overview_attributes>` for the list of supported attributes and their
    types.
    """

    message_timeout: timedelta = betterproto.message_field(7)
    """
    Specifies the timeout for each individual message sent on the stream and
    when the filter is running in synchronous mode. Whenever the proxy sends a
    message on the stream that requires a response, it will reset this timer,
    and will stop processing and return an error (subject to the processing
    mode) if the timer expires before a matching response. is received. There
    is no timeout when the filter is running in asynchronous mode. Default is
    200 milliseconds.
    """

    stat_prefix: str = betterproto.string_field(8)
    """
    Optional additional prefix to use when emitting statistics. This allows to
    distinguish emitted statistics between configured *ext_proc* filters in an
    HTTP filter chain.
    """

    mutation_rules: "_____config_common_mutation_rules_v3__.HeaderMutationRules" = (
        betterproto.message_field(9)
    )
    """
    Rules that determine what modifications an external processing server may
    make to message headers. If not set, all headers may be modified except for
    "host", ":authority", ":scheme", ":method", and headers that start with the
    header prefix set via :ref:`header_prefix
    <envoy_v3_api_field_config.bootstrap.v3.Bootstrap.header_prefix>` (which is
    usually "x-envoy").
    """


@dataclass(eq=False, repr=False)
class ExtProcPerRoute(betterproto.Message):
    """
    Extra settings that may be added to per-route configuration for a virtual
    host or cluster.
    """

    disabled: bool = betterproto.bool_field(1, group="override")
    """
    Disable the filter for this particular vhost or route. If disabled is
    specified in multiple per-filter-configs, the most specific one will be
    used.
    """

    overrides: "ExtProcOverrides" = betterproto.message_field(2, group="override")
    """
    Override aspects of the configuration for this route. A set of overrides in
    a more specific configuration will override a "disabled" flag set in a
    less-specific one.
    """


@dataclass(eq=False, repr=False)
class ExtProcOverrides(betterproto.Message):
    """Overrides that may be set on a per-route basis [#next-free-field: 6]"""

    processing_mode: "ProcessingMode" = betterproto.message_field(1)
    """Set a different processing mode for this route than the default."""

    async_mode: bool = betterproto.bool_field(2)
    """
    [#not-implemented-hide:] Set a different asynchronous processing option
    than the default.
    """

    request_attributes: List[str] = betterproto.string_field(3)
    """
    [#not-implemented-hide:] Set different optional attributes than the default
    setting of the ``request_attributes`` field.
    """

    response_attributes: List[str] = betterproto.string_field(4)
    """
    [#not-implemented-hide:] Set different optional properties than the default
    setting of the ``response_attributes`` field.
    """

    grpc_service: "_____config_core_v3__.GrpcService" = betterproto.message_field(5)
    """Set a different gRPC service for this route than the default."""
