# Generated by the protocol buffer compiler.  DO NOT EDIT!
# sources: envoy/extensions/common/dynamic_forward_proxy/v3/dns_cache.proto
# plugin: python-betterproto
import warnings
from dataclasses import dataclass
from datetime import timedelta
from typing import (
    List,
    Optional,
)

import betterproto

from .....config.cluster import v3 as ____config_cluster_v3__
from .....config.common.key_value import v3 as ____config_common_key_value_v3__
from .....config.core import v3 as ____config_core_v3__


@dataclass(eq=False, repr=False)
class DnsCacheCircuitBreakers(betterproto.Message):
    """Configuration of circuit breakers for resolver."""

    max_pending_requests: Optional[int] = betterproto.message_field(
        1, wraps=betterproto.TYPE_UINT32
    )
    """
    The maximum number of pending requests that Envoy will allow to the
    resolver. If not specified, the default is 1024.
    """


@dataclass(eq=False, repr=False)
class DnsCacheConfig(betterproto.Message):
    """
    Configuration for the dynamic forward proxy DNS cache. See the
    :ref:`architecture overview <arch_overview_http_dynamic_forward_proxy>` for
    more information. [#next-free-field: 15]
    """

    name: str = betterproto.string_field(1)
    """
    The name of the cache. Multiple named caches allow independent dynamic
    forward proxy configurations to operate within a single Envoy process using
    different configurations. All configurations with the same name *must*
    otherwise have the same settings when referenced from different
    configuration components. Configuration will fail to load if this is not
    the case.
    """

    dns_lookup_family: "____config_cluster_v3__.ClusterDnsLookupFamily" = (
        betterproto.enum_field(2)
    )
    """
    The DNS lookup family to use during resolution.
    [#comment:TODO(mattklein123): Figure out how to support IPv4/IPv6 "happy
    eyeballs" mode. The way this might work is a new lookup family which
    returns both IPv4 and IPv6 addresses, and then configures a host to have a
    primary and fall back address. With this, we could very likely build a
    "happy eyeballs" connection pool which would race the primary / fall back
    address and return the one that wins. This same method could potentially
    also be used for QUIC to TCP fall back.]
    """

    dns_refresh_rate: timedelta = betterproto.message_field(3)
    """
    The DNS refresh rate for unresolved DNS hosts. If not specified defaults to
    60s. The refresh rate is rounded to the closest millisecond, and must be at
    least 1ms. Once a host has been resolved, the refresh rate will be the DNS
    TTL, capped at a minimum of ``dns_min_refresh_rate``.
    """

    dns_min_refresh_rate: timedelta = betterproto.message_field(14)
    """
    The minimum rate that DNS resolution will occur. Per ``dns_refresh_rate``,
    once a host is resolved, the DNS TTL will be used, with a minimum set by
    ``dns_min_refresh_rate``. ``dns_min_refresh_rate`` defaults to 5s and must
    also be >= 5s.
    """

    host_ttl: timedelta = betterproto.message_field(4)
    """
    The TTL for hosts that are unused. Hosts that have not been used in the
    configured time interval will be purged. If not specified defaults to 5m.
    .. note:   The TTL is only checked at the time of DNS refresh, as specified
    by ``dns_refresh_rate``. This   means that if the configured TTL is shorter
    than the refresh rate the host may not be removed   immediately.  .. note:
    The TTL has no relation to DNS TTL and is only used to control Envoy's
    resource usage.
    """

    max_hosts: Optional[int] = betterproto.message_field(
        5, wraps=betterproto.TYPE_UINT32
    )
    """
    The maximum number of hosts that the cache will hold. If not specified
    defaults to 1024. .. note:   The implementation is approximate and enforced
    independently on each worker thread, thus   it is possible for the maximum
    hosts in the cache to go slightly above the configured   value depending on
    timing. This is similar to how other circuit breakers work.
    """

    dns_failure_refresh_rate: "____config_cluster_v3__.ClusterRefreshRate" = (
        betterproto.message_field(6)
    )
    """
    If the DNS failure refresh rate is specified, this is used as the cache's
    DNS refresh rate when DNS requests are failing. If this setting is not
    specified, the failure refresh rate defaults to the dns_refresh_rate.
    """

    dns_cache_circuit_breaker: "DnsCacheCircuitBreakers" = betterproto.message_field(7)
    """
    The config of circuit breakers for resolver. It provides a configurable
    threshold. Envoy will use dns cache circuit breakers with default settings
    even if this value is not set.
    """

    use_tcp_for_dns_lookups: bool = betterproto.bool_field(8)
    """
    Always use TCP queries instead of UDP queries for DNS lookups. This field
    is deprecated in favor of ``dns_resolution_config`` which aggregates all of
    the DNS resolver configuration in a single message.
    """

    dns_resolution_config: "____config_core_v3__.DnsResolutionConfig" = (
        betterproto.message_field(9)
    )
    """
    DNS resolution configuration which includes the underlying dns resolver
    addresses and options. This field is deprecated in favor of
    :ref:`typed_dns_resolver_config <envoy_v3_api_field_extensions.common.dynam
    ic_forward_proxy.v3.DnsCacheConfig.typed_dns_resolver_config>`.
    """

    typed_dns_resolver_config: "____config_core_v3__.TypedExtensionConfig" = (
        betterproto.message_field(12)
    )
    """
    DNS resolver type configuration extension. This extension can be used to
    configure c-ares, apple, or any other DNS resolver types and the related
    parameters. For example, an object of :ref:`CaresDnsResolverConfig <envoy_v
    3_api_msg_extensions.network.dns_resolver.cares.v3.CaresDnsResolverConfig>`
    can be packed into this ``typed_dns_resolver_config``. This configuration
    replaces the :ref:`dns_resolution_config <envoy_v3_api_field_extensions.com
    mon.dynamic_forward_proxy.v3.DnsCacheConfig.dns_resolution_config>`
    configuration. During the transition period when both
    ``dns_resolution_config`` and ``typed_dns_resolver_config`` exists, when
    ``typed_dns_resolver_config`` is in place, Envoy will use it and ignore
    ``dns_resolution_config``. When ``typed_dns_resolver_config`` is missing,
    the default behavior is in place. [#extension-category:
    envoy.network.dns_resolver]
    """

    preresolve_hostnames: List[
        "____config_core_v3__.SocketAddress"
    ] = betterproto.message_field(10)
    """
    Hostnames that should be preresolved into the cache upon creation. This
    might provide a performance improvement, in the form of cache hits, for
    hostnames that are going to be resolved during steady state and are known
    at config load time.
    """

    dns_query_timeout: timedelta = betterproto.message_field(11)
    """
    The timeout used for DNS queries. This timeout is independent of any
    timeout and retry policy used by the underlying DNS implementation (e.g.,
    c-areas and Apple DNS) which are opaque. Setting this timeout will ensure
    that queries succeed or fail within the specified time frame and are then
    retried using the standard refresh rates. Defaults to 5s if not set.
    """

    key_value_config: "____config_common_key_value_v3__.KeyValueStoreConfig" = (
        betterproto.message_field(13)
    )
    """
    [#not-implemented-hide:] Configuration to flush the DNS cache to long term
    storage.
    """

    def __post_init__(self) -> None:
        super().__post_init__()
        if self.is_set("use_tcp_for_dns_lookups"):
            warnings.warn(
                "DnsCacheConfig.use_tcp_for_dns_lookups is deprecated",
                DeprecationWarning,
            )
        if self.is_set("dns_resolution_config"):
            warnings.warn(
                "DnsCacheConfig.dns_resolution_config is deprecated", DeprecationWarning
            )
