# Generated by the protocol buffer compiler.  DO NOT EDIT!
# sources: envoy/data/tap/v3/common.proto, envoy/data/tap/v3/http.proto, envoy/data/tap/v3/transport.proto, envoy/data/tap/v3/wrapper.proto
# plugin: python-betterproto
from dataclasses import dataclass
from datetime import datetime
from typing import List

import betterproto

from ....config.core import v3 as ___config_core_v3__


@dataclass(eq=False, repr=False)
class Body(betterproto.Message):
    """
    Wrapper for tapped body data. This includes HTTP request/response body,
    transport socket received and transmitted data, etc.
    """

    as_bytes: bytes = betterproto.bytes_field(1, group="body_type")
    """
    Body data as bytes. By default, tap body data will be present in this
    field, as the proto ``bytes`` type can contain any valid byte.
    """

    as_string: str = betterproto.string_field(2, group="body_type")
    """
    Body data as string. This field is only used when the
    :ref:`JSON_BODY_AS_STRING <envoy_v3_api_enum_value_config.tap.v3.OutputSink
    .Format.JSON_BODY_AS_STRING>` sink format type is selected. See the
    documentation for that option for why this is useful.
    """

    truncated: bool = betterproto.bool_field(3)
    """
    Specifies whether body data has been truncated to fit within the specified
    :ref:`max_buffered_rx_bytes
    <envoy_v3_api_field_config.tap.v3.OutputConfig.max_buffered_rx_bytes>` and
    :ref:`max_buffered_tx_bytes
    <envoy_v3_api_field_config.tap.v3.OutputConfig.max_buffered_tx_bytes>`
    settings.
    """


@dataclass(eq=False, repr=False)
class Connection(betterproto.Message):
    """Connection properties."""

    local_address: "___config_core_v3__.Address" = betterproto.message_field(2)
    """Local address."""

    remote_address: "___config_core_v3__.Address" = betterproto.message_field(3)
    """Remote address."""


@dataclass(eq=False, repr=False)
class SocketEvent(betterproto.Message):
    """Event in a socket trace."""

    timestamp: datetime = betterproto.message_field(1)
    """Timestamp for event."""

    read: "SocketEventRead" = betterproto.message_field(2, group="event_selector")
    write: "SocketEventWrite" = betterproto.message_field(3, group="event_selector")
    closed: "SocketEventClosed" = betterproto.message_field(4, group="event_selector")


@dataclass(eq=False, repr=False)
class SocketEventRead(betterproto.Message):
    """Data read by Envoy from the transport socket."""

    data: "Body" = betterproto.message_field(1)
    """Binary data read."""


@dataclass(eq=False, repr=False)
class SocketEventWrite(betterproto.Message):
    """Data written by Envoy to the transport socket."""

    data: "Body" = betterproto.message_field(1)
    """Binary data written."""

    end_stream: bool = betterproto.bool_field(2)
    """Stream was half closed after this write."""


@dataclass(eq=False, repr=False)
class SocketEventClosed(betterproto.Message):
    """The connection was closed."""

    pass


@dataclass(eq=False, repr=False)
class SocketBufferedTrace(betterproto.Message):
    """
    Sequence of read/write events that constitute a buffered trace on a socket.
    [#next-free-field: 6]
    """

    trace_id: int = betterproto.uint64_field(1)
    """
    Trace ID unique to the originating Envoy only. Trace IDs can repeat and
    should not be used for long term stable uniqueness. Matches connection IDs
    used in Envoy logs.
    """

    connection: "Connection" = betterproto.message_field(2)
    """Connection properties."""

    events: List["SocketEvent"] = betterproto.message_field(3)
    """Sequence of observed events."""

    read_truncated: bool = betterproto.bool_field(4)
    """
    Set to true if read events were truncated due to the
    :ref:`max_buffered_rx_bytes
    <envoy_v3_api_field_config.tap.v3.OutputConfig.max_buffered_rx_bytes>`
    setting.
    """

    write_truncated: bool = betterproto.bool_field(5)
    """
    Set to true if write events were truncated due to the
    :ref:`max_buffered_tx_bytes
    <envoy_v3_api_field_config.tap.v3.OutputConfig.max_buffered_tx_bytes>`
    setting.
    """


@dataclass(eq=False, repr=False)
class SocketStreamedTraceSegment(betterproto.Message):
    """
    A streamed socket trace segment. Multiple segments make up a full trace.
    """

    trace_id: int = betterproto.uint64_field(1)
    """
    Trace ID unique to the originating Envoy only. Trace IDs can repeat and
    should not be used for long term stable uniqueness. Matches connection IDs
    used in Envoy logs.
    """

    connection: "Connection" = betterproto.message_field(2, group="message_piece")
    """Connection properties."""

    event: "SocketEvent" = betterproto.message_field(3, group="message_piece")
    """Socket event."""


@dataclass(eq=False, repr=False)
class HttpBufferedTrace(betterproto.Message):
    """A fully buffered HTTP trace message."""

    request: "HttpBufferedTraceMessage" = betterproto.message_field(1)
    """Request message."""

    response: "HttpBufferedTraceMessage" = betterproto.message_field(2)
    """Response message."""


@dataclass(eq=False, repr=False)
class HttpBufferedTraceMessage(betterproto.Message):
    """HTTP message wrapper."""

    headers: List["___config_core_v3__.HeaderValue"] = betterproto.message_field(1)
    """Message headers."""

    body: "Body" = betterproto.message_field(2)
    """Message body."""

    trailers: List["___config_core_v3__.HeaderValue"] = betterproto.message_field(3)
    """Message trailers."""


@dataclass(eq=False, repr=False)
class HttpStreamedTraceSegment(betterproto.Message):
    """
    A streamed HTTP trace segment. Multiple segments make up a full trace.
    [#next-free-field: 8]
    """

    trace_id: int = betterproto.uint64_field(1)
    """
    Trace ID unique to the originating Envoy only. Trace IDs can repeat and
    should not be used for long term stable uniqueness.
    """

    request_headers: "___config_core_v3__.HeaderMap" = betterproto.message_field(
        2, group="message_piece"
    )
    """Request headers."""

    request_body_chunk: "Body" = betterproto.message_field(3, group="message_piece")
    """Request body chunk."""

    request_trailers: "___config_core_v3__.HeaderMap" = betterproto.message_field(
        4, group="message_piece"
    )
    """Request trailers."""

    response_headers: "___config_core_v3__.HeaderMap" = betterproto.message_field(
        5, group="message_piece"
    )
    """Response headers."""

    response_body_chunk: "Body" = betterproto.message_field(6, group="message_piece")
    """Response body chunk."""

    response_trailers: "___config_core_v3__.HeaderMap" = betterproto.message_field(
        7, group="message_piece"
    )
    """Response trailers."""


@dataclass(eq=False, repr=False)
class TraceWrapper(betterproto.Message):
    """
    Wrapper for all fully buffered and streamed tap traces that Envoy emits.
    This is required for sending traces over gRPC APIs or more easily
    persisting binary messages to files.
    """

    http_buffered_trace: "HttpBufferedTrace" = betterproto.message_field(
        1, group="trace"
    )
    """An HTTP buffered tap trace."""

    http_streamed_trace_segment: "HttpStreamedTraceSegment" = betterproto.message_field(
        2, group="trace"
    )
    """An HTTP streamed tap trace segment."""

    socket_buffered_trace: "SocketBufferedTrace" = betterproto.message_field(
        3, group="trace"
    )
    """A socket buffered tap trace."""

    socket_streamed_trace_segment: "SocketStreamedTraceSegment" = (
        betterproto.message_field(4, group="trace")
    )
    """A socket streamed tap trace segment."""
