# Generated by the protocol buffer compiler.  DO NOT EDIT!
# sources: envoy/data/dns/v2alpha/dns_table.proto
# plugin: python-betterproto
from dataclasses import dataclass
from datetime import timedelta
from typing import List

import betterproto

from ....type import matcher as ___type_matcher__


@dataclass(eq=False, repr=False)
class DnsTable(betterproto.Message):
    """
    This message contains the configuration for the DNS Filter if populated
    from the control plane
    """

    external_retry_count: int = betterproto.uint32_field(1)
    """
    Control how many times envoy makes an attempt to forward a query to an
    external server
    """

    virtual_domains: List["DnsTableDnsVirtualDomain"] = betterproto.message_field(2)
    """Fully qualified domain names for which Envoy will respond to queries"""

    known_suffixes: List["___type_matcher__.StringMatcher"] = betterproto.message_field(
        3
    )
    """
    This field serves to help Envoy determine whether it can authoritatively
    answer a query for a name matching a suffix in this list. If the query name
    does not match a suffix in this list, Envoy will forward the query to an
    upstream DNS server
    """


@dataclass(eq=False, repr=False)
class DnsTableAddressList(betterproto.Message):
    """
    This message contains a list of IP addresses returned for a query for a
    known name
    """

    address: List[str] = betterproto.string_field(1)
    """
    This field contains a well formed IP address that is returned in the answer
    for a name query. The address field can be an IPv4 or IPv6 address. Address
    family detection is done automatically when Envoy parses the string. Since
    this field is repeated, Envoy will return one randomly chosen entry from
    this list in the DNS response. The random index will vary per query so that
    we prevent clients pinning on a single address for a configured domain
    """


@dataclass(eq=False, repr=False)
class DnsTableDnsEndpoint(betterproto.Message):
    """
    This message type is extensible and can contain a list of addresses or
    dictate some other method for resolving the addresses for an endpoint
    """

    address_list: "DnsTableAddressList" = betterproto.message_field(
        1, group="endpoint_config"
    )


@dataclass(eq=False, repr=False)
class DnsTableDnsVirtualDomain(betterproto.Message):
    name: str = betterproto.string_field(1)
    """The domain name for which Envoy will respond to query requests"""

    endpoint: "DnsTableDnsEndpoint" = betterproto.message_field(2)
    """
    The configuration containing the method to determine the address of this
    endpoint
    """

    answer_ttl: timedelta = betterproto.message_field(3)
    """Sets the TTL in dns answers from Envoy returned to the client"""
