# Generated by the protocol buffer compiler.  DO NOT EDIT!
# sources: envoy/config/route/v3/route.proto, envoy/config/route/v3/route_components.proto, envoy/config/route/v3/scoped_route.proto
# plugin: python-betterproto
import warnings
from dataclasses import dataclass
from datetime import timedelta
from typing import (
    Dict,
    List,
    Optional,
)

import betterproto
import betterproto.lib.google.protobuf as betterproto_lib_google_protobuf

from .....xds.type.matcher import v3 as ____xds_type_matcher_v3__
from ....type import v3 as ___type_v3__
from ....type.matcher import v3 as ___type_matcher_v3__
from ....type.metadata import v3 as ___type_metadata_v3__
from ....type.tracing import v3 as ___type_tracing_v3__
from ...core import v3 as __core_v3__


class VirtualHostTlsRequirementType(betterproto.Enum):
    NONE = 0
    """No TLS requirement for the virtual host."""

    EXTERNAL_ONLY = 1
    """
    External requests must use TLS. If a request is external and it is not
    using TLS, a 301 redirect will be sent telling the client to use HTTPS.
    """

    ALL = 2
    """
    All requests must use TLS. If a request is not using TLS, a 301 redirect
    will be sent telling the client to use HTTPS.
    """


class RouteActionClusterNotFoundResponseCode(betterproto.Enum):
    SERVICE_UNAVAILABLE = 0
    """HTTP status code - 503 Service Unavailable."""

    NOT_FOUND = 1
    """HTTP status code - 404 Not Found."""

    INTERNAL_SERVER_ERROR = 2
    """HTTP status code - 500 Internal Server Error."""


class RouteActionInternalRedirectAction(betterproto.Enum):
    """
    Configures :ref:`internal redirect <arch_overview_internal_redirects>`
    behavior. [#next-major-version: remove this definition - it's defined in
    the InternalRedirectPolicy message.]
    """

    PASS_THROUGH_INTERNAL_REDIRECT = 0
    HANDLE_INTERNAL_REDIRECT = 1


class RetryPolicyResetHeaderFormat(betterproto.Enum):
    SECONDS = 0
    UNIX_TIMESTAMP = 1


class RedirectActionRedirectResponseCode(betterproto.Enum):
    MOVED_PERMANENTLY = 0
    """Moved Permanently HTTP Status Code - 301."""

    FOUND = 1
    """Found HTTP Status Code - 302."""

    SEE_OTHER = 2
    """See Other HTTP Status Code - 303."""

    TEMPORARY_REDIRECT = 3
    """Temporary Redirect HTTP Status Code - 307."""

    PERMANENT_REDIRECT = 4
    """Permanent Redirect HTTP Status Code - 308."""


class RateLimitActionMetaDataSource(betterproto.Enum):
    DYNAMIC = 0
    """Query :ref:`dynamic metadata <well_known_dynamic_metadata>`"""

    ROUTE_ENTRY = 1
    """
    Query :ref:`route entry metadata
    <envoy_v3_api_field_config.route.v3.Route.metadata>`
    """


@dataclass(eq=False, repr=False)
class VirtualHost(betterproto.Message):
    """
    The top level element in the routing configuration is a virtual host. Each
    virtual host has a logical name as well as a set of domains that get routed
    to it based on the incoming request's host header. This allows a single
    listener to service multiple top level domain path trees. Once a virtual
    host is selected based on the domain, the routes are processed in order to
    see which upstream cluster to route to or whether to perform a redirect.
    [#next-free-field: 23]
    """

    name: str = betterproto.string_field(1)
    """
    The logical name of the virtual host. This is used when emitting certain
    statistics but is not relevant for routing.
    """

    domains: List[str] = betterproto.string_field(2)
    """
    A list of domains (host/authority header) that will be matched to this
    virtual host. Wildcard hosts are supported in the suffix or prefix form.
    Domain search order:  1. Exact domain names: ``www.foo.com``.  2. Suffix
    domain wildcards: ``*.foo.com`` or ``*-bar.foo.com``.  3. Prefix domain
    wildcards: ``foo.*`` or ``foo-*``.  4. Special wildcard ``*`` matching any
    domain. .. note::   The wildcard will not match the empty string.   e.g.
    ``*-bar.foo.com`` will match ``baz-bar.foo.com`` but not ``-bar.foo.com``.
    The longest wildcards match first.   Only a single virtual host in the
    entire route configuration can match on ``*``. A domain   must be unique
    across all virtual hosts or the config will fail to load. Domains cannot
    contain control characters. This is validated by the well_known_regex
    HTTP_HEADER_VALUE.
    """

    routes: List["Route"] = betterproto.message_field(3)
    """
    The list of routes that will be matched, in order, for incoming requests.
    The first route that matches will be used. Only one of this and ``matcher``
    can be specified.
    """

    matcher: "____xds_type_matcher_v3__.Matcher" = betterproto.message_field(21)
    """
    [#next-major-version: This should be included in a oneof with routes
    wrapped in a message.] The match tree to use when resolving route actions
    for incoming requests. Only one of this and ``routes`` can be specified.
    """

    require_tls: "VirtualHostTlsRequirementType" = betterproto.enum_field(4)
    """
    Specifies the type of TLS enforcement the virtual host expects. If this
    option is not specified, there is no TLS requirement for the virtual host.
    """

    virtual_clusters: List["VirtualCluster"] = betterproto.message_field(5)
    """
    A list of virtual clusters defined for this virtual host. Virtual clusters
    are used for additional statistics gathering.
    """

    rate_limits: List["RateLimit"] = betterproto.message_field(6)
    """
    Specifies a set of rate limit configurations that will be applied to the
    virtual host.
    """

    request_headers_to_add: List[
        "__core_v3__.HeaderValueOption"
    ] = betterproto.message_field(7)
    """
    Specifies a list of HTTP headers that should be added to each request
    handled by this virtual host. Headers specified at this level are applied
    after headers from enclosed :ref:`envoy_v3_api_msg_config.route.v3.Route`
    and before headers from the enclosing
    :ref:`envoy_v3_api_msg_config.route.v3.RouteConfiguration`. For more
    information, including details on header value syntax, see the
    documentation on :ref:`custom request headers
    <config_http_conn_man_headers_custom_request_headers>`.
    """

    request_headers_to_remove: List[str] = betterproto.string_field(13)
    """
    Specifies a list of HTTP headers that should be removed from each request
    handled by this virtual host.
    """

    response_headers_to_add: List[
        "__core_v3__.HeaderValueOption"
    ] = betterproto.message_field(10)
    """
    Specifies a list of HTTP headers that should be added to each response
    handled by this virtual host. Headers specified at this level are applied
    after headers from enclosed :ref:`envoy_v3_api_msg_config.route.v3.Route`
    and before headers from the enclosing
    :ref:`envoy_v3_api_msg_config.route.v3.RouteConfiguration`. For more
    information, including details on header value syntax, see the
    documentation on :ref:`custom request headers
    <config_http_conn_man_headers_custom_request_headers>`.
    """

    response_headers_to_remove: List[str] = betterproto.string_field(11)
    """
    Specifies a list of HTTP headers that should be removed from each response
    handled by this virtual host.
    """

    cors: "CorsPolicy" = betterproto.message_field(8)
    """
    Indicates that the virtual host has a CORS policy. This field is ignored if
    related cors policy is found in the :ref:`VirtualHost.typed_per_filter_conf
    ig<envoy_v3_api_field_config.route.v3.VirtualHost.typed_per_filter_config>`
    . .. attention::   This option has been deprecated. Please use   :ref:`Virt
    ualHost.typed_per_filter_config<envoy_v3_api_field_config.route.v3.VirtualH
    ost.typed_per_filter_config>`   to configure the CORS HTTP filter.
    """

    typed_per_filter_config: Dict[
        str, "betterproto_lib_google_protobuf.Any"
    ] = betterproto.map_field(15, betterproto.TYPE_STRING, betterproto.TYPE_MESSAGE)
    """
    The per_filter_config field can be used to provide virtual host-specific
    configurations for filters. The key should match the :ref:`filter config
    name <envoy_v3_api_field_extensions.filters.network.http_connection_manager
    .v3.HttpFilter.name>`. The canonical filter name (e.g.,
    ``envoy.filters.http.buffer`` for the HTTP buffer filter) can also be used
    for the backwards compatibility. If there is no entry referred by the
    filter config name, the entry referred by the canonical filter name will be
    provided to the filters as fallback. Use of this field is filter specific;
    see the :ref:`HTTP filter documentation <config_http_filters>` for if and
    how it is utilized. [#comment: An entry's value may be wrapped in a
    :ref:`FilterConfig<envoy_v3_api_msg_config.route.v3.FilterConfig>` message
    to specify additional options.]
    """

    include_request_attempt_count: bool = betterproto.bool_field(14)
    """
    Decides whether the :ref:`x-envoy-attempt-count
    <config_http_filters_router_x-envoy-attempt-count>` header should be
    included in the upstream request. Setting this option will cause it to
    override any existing header value, so in the case of two Envoys on the
    request path with this option enabled, the upstream will see the attempt
    count as perceived by the second Envoy. Defaults to false. This header is
    unaffected by the :ref:`suppress_envoy_headers <envoy_v3_api_field_extensio
    ns.filters.http.router.v3.Router.suppress_envoy_headers>` flag. [#next-
    major-version: rename to include_attempt_count_in_request.]
    """

    include_attempt_count_in_response: bool = betterproto.bool_field(19)
    """
    Decides whether the :ref:`x-envoy-attempt-count
    <config_http_filters_router_x-envoy-attempt-count>` header should be
    included in the downstream response. Setting this option will cause the
    router to override any existing header value, so in the case of two Envoys
    on the request path with this option enabled, the downstream will see the
    attempt count as perceived by the Envoy closest upstream from itself.
    Defaults to false. This header is unaffected by the
    :ref:`suppress_envoy_headers <envoy_v3_api_field_extensions.filters.http.ro
    uter.v3.Router.suppress_envoy_headers>` flag.
    """

    retry_policy: "RetryPolicy" = betterproto.message_field(16)
    """
    Indicates the retry policy for all routes in this virtual host. Note that
    setting a route level entry will take precedence over this config and it'll
    be treated independently (e.g.: values are not inherited).
    """

    retry_policy_typed_config: "betterproto_lib_google_protobuf.Any" = (
        betterproto.message_field(20)
    )
    """
    [#not-implemented-hide:] Specifies the configuration for retry policy
    extension. Note that setting a route level entry will take precedence over
    this config and it'll be treated independently (e.g.: values are not
    inherited). :ref:`Retry policy
    <envoy_v3_api_field_config.route.v3.VirtualHost.retry_policy>` should not
    be set if this field is used.
    """

    hedge_policy: "HedgePolicy" = betterproto.message_field(17)
    """
    Indicates the hedge policy for all routes in this virtual host. Note that
    setting a route level entry will take precedence over this config and it'll
    be treated independently (e.g.: values are not inherited).
    """

    per_request_buffer_limit_bytes: Optional[int] = betterproto.message_field(
        18, wraps=betterproto.TYPE_UINT32
    )
    """
    The maximum bytes which will be buffered for retries and shadowing. If set
    and a route-specific limit is not set, the bytes actually buffered will be
    the minimum value of this and the listener
    per_connection_buffer_limit_bytes.
    """

    request_mirror_policies: List[
        "RouteActionRequestMirrorPolicy"
    ] = betterproto.message_field(22)
    """
    Specify a set of default request mirroring policies for every route under
    this virtual host. It takes precedence over the route config mirror policy
    entirely. That is, policies are not merged, the most specific non-empty one
    becomes the mirror policies.
    """

    def __post_init__(self) -> None:
        super().__post_init__()
        if self.is_set("cors"):
            warnings.warn("VirtualHost.cors is deprecated", DeprecationWarning)


@dataclass(eq=False, repr=False)
class FilterAction(betterproto.Message):
    """A filter-defined action type."""

    action: "betterproto_lib_google_protobuf.Any" = betterproto.message_field(1)


@dataclass(eq=False, repr=False)
class Route(betterproto.Message):
    """
    A route is both a specification of how to match a request as well as an
    indication of what to do next (e.g., redirect, forward, rewrite, etc.). ..
    attention::   Envoy supports routing on HTTP method via :ref:`header
    matching   <envoy_v3_api_msg_config.route.v3.HeaderMatcher>`. [#next-free-
    field: 20]
    """

    name: str = betterproto.string_field(14)
    """Name for the route."""

    match: "RouteMatch" = betterproto.message_field(1)
    """Route matching parameters."""

    route: "RouteAction" = betterproto.message_field(2, group="action")
    """Route request to some upstream cluster."""

    redirect: "RedirectAction" = betterproto.message_field(3, group="action")
    """Return a redirect."""

    direct_response: "DirectResponseAction" = betterproto.message_field(
        7, group="action"
    )
    """Return an arbitrary HTTP response directly, without proxying."""

    filter_action: "FilterAction" = betterproto.message_field(17, group="action")
    """
    [#not-implemented-hide:] A filter-defined action (e.g., it could
    dynamically generate the RouteAction). [#comment: TODO(samflattery): Remove
    cleanup in route_fuzz_test.cc when implemented]
    """

    non_forwarding_action: "NonForwardingAction" = betterproto.message_field(
        18, group="action"
    )
    """
    [#not-implemented-hide:] An action used when the route will generate a
    response directly, without forwarding to an upstream host. This will be
    used in non-proxy xDS clients like the gRPC server. It could also be used
    in the future in Envoy for a filter that directly generates responses for
    requests.
    """

    metadata: "__core_v3__.Metadata" = betterproto.message_field(4)
    """
    The Metadata field can be used to provide additional information about the
    route. It can be used for configuration, stats, and logging. The metadata
    should go under the filter namespace that will need it. For instance, if
    the metadata is intended for the Router filter, the filter name should be
    specified as ``envoy.filters.http.router``.
    """

    decorator: "Decorator" = betterproto.message_field(5)
    """Decorator for the matched route."""

    typed_per_filter_config: Dict[
        str, "betterproto_lib_google_protobuf.Any"
    ] = betterproto.map_field(13, betterproto.TYPE_STRING, betterproto.TYPE_MESSAGE)
    """
    The per_filter_config field can be used to provide route-specific
    configurations for filters. The key should match the :ref:`filter config
    name <envoy_v3_api_field_extensions.filters.network.http_connection_manager
    .v3.HttpFilter.name>`. The canonical filter name (e.g.,
    ``envoy.filters.http.buffer`` for the HTTP buffer filter) can also be used
    for the backwards compatibility. If there is no entry referred by the
    filter config name, the entry referred by the canonical filter name will be
    provided to the filters as fallback. Use of this field is filter specific;
    see the :ref:`HTTP filter documentation <config_http_filters>` for if and
    how it is utilized. [#comment: An entry's value may be wrapped in a
    :ref:`FilterConfig<envoy_v3_api_msg_config.route.v3.FilterConfig>` message
    to specify additional options.]
    """

    request_headers_to_add: List[
        "__core_v3__.HeaderValueOption"
    ] = betterproto.message_field(9)
    """
    Specifies a set of headers that will be added to requests matching this
    route. Headers specified at this level are applied before headers from the
    enclosing :ref:`envoy_v3_api_msg_config.route.v3.VirtualHost` and
    :ref:`envoy_v3_api_msg_config.route.v3.RouteConfiguration`. For more
    information, including details on header value syntax, see the
    documentation on :ref:`custom request headers
    <config_http_conn_man_headers_custom_request_headers>`.
    """

    request_headers_to_remove: List[str] = betterproto.string_field(12)
    """
    Specifies a list of HTTP headers that should be removed from each request
    matching this route.
    """

    response_headers_to_add: List[
        "__core_v3__.HeaderValueOption"
    ] = betterproto.message_field(10)
    """
    Specifies a set of headers that will be added to responses to requests
    matching this route. Headers specified at this level are applied before
    headers from the enclosing
    :ref:`envoy_v3_api_msg_config.route.v3.VirtualHost` and
    :ref:`envoy_v3_api_msg_config.route.v3.RouteConfiguration`. For more
    information, including details on header value syntax, see the
    documentation on :ref:`custom request headers
    <config_http_conn_man_headers_custom_request_headers>`.
    """

    response_headers_to_remove: List[str] = betterproto.string_field(11)
    """
    Specifies a list of HTTP headers that should be removed from each response
    to requests matching this route.
    """

    tracing: "Tracing" = betterproto.message_field(15)
    """
    Presence of the object defines whether the connection manager's tracing
    configuration is overridden by this route specific instance.
    """

    per_request_buffer_limit_bytes: Optional[int] = betterproto.message_field(
        16, wraps=betterproto.TYPE_UINT32
    )
    """
    The maximum bytes which will be buffered for retries and shadowing. If set,
    the bytes actually buffered will be the minimum value of this and the
    listener per_connection_buffer_limit_bytes.
    """

    stat_prefix: str = betterproto.string_field(19)
    """
    The human readable prefix to use when emitting statistics for this
    endpoint. The statistics are rooted at vhost.<virtual host
    name>.route.<stat_prefix>. This should be set for highly critical endpoints
    that one wishes to get “per-route” statistics on. If not set, endpoint
    statistics are not generated. The emitted statistics are the same as those
    documented for :ref:`virtual clusters
    <config_http_filters_router_vcluster_stats>`. .. warning::    We do not
    recommend setting up a stat prefix for    every application endpoint. This
    is both not easily maintainable and    statistics use a non-trivial amount
    of memory(approximately 1KiB per route).
    """


@dataclass(eq=False, repr=False)
class WeightedCluster(betterproto.Message):
    """
    Compared to the :ref:`cluster
    <envoy_v3_api_field_config.route.v3.RouteAction.cluster>` field that
    specifies a single upstream cluster as the target of a request, the
    :ref:`weighted_clusters
    <envoy_v3_api_field_config.route.v3.RouteAction.weighted_clusters>` option
    allows for specification of multiple upstream clusters along with weights
    that indicate the percentage of traffic to be forwarded to each cluster.
    The router selects an upstream cluster based on the weights.
    """

    clusters: List["WeightedClusterClusterWeight"] = betterproto.message_field(1)
    """Specifies one or more upstream clusters associated with the route."""

    total_weight: Optional[int] = betterproto.message_field(
        3, wraps=betterproto.TYPE_UINT32
    )
    """
    Specifies the total weight across all clusters. The sum of all cluster
    weights must equal this value, if this is greater than 0. This field is now
    deprecated, and the client will use the sum of all cluster weights. It is
    up to the management server to supply the correct weights.
    """

    runtime_key_prefix: str = betterproto.string_field(2)
    """
    Specifies the runtime key prefix that should be used to construct the
    runtime keys associated with each cluster. When the ``runtime_key_prefix``
    is specified, the router will look for weights associated with each
    upstream cluster under the key ``runtime_key_prefix`` + ``.`` +
    ``cluster[i].name`` where ``cluster[i]`` denotes an entry in the clusters
    array field. If the runtime key for the cluster does not exist, the value
    specified in the configuration file will be used as the default weight. See
    the :ref:`runtime documentation <operations_runtime>` for how key names map
    to the underlying implementation.
    """

    header_name: str = betterproto.string_field(4, group="random_value_specifier")
    """
    Specifies the header name that is used to look up the random value passed
    in the request header. This is used to ensure consistent cluster picking
    across multiple proxy levels for weighted traffic. If header is not present
    or invalid, Envoy will fall back to use the internally generated random
    value. This header is expected to be single-valued header as we only want
    to have one selected value throughout the process for the consistency. And
    the value is a unsigned number between 0 and UINT64_MAX.
    """

    def __post_init__(self) -> None:
        super().__post_init__()
        if self.is_set("total_weight"):
            warnings.warn(
                "WeightedCluster.total_weight is deprecated", DeprecationWarning
            )


@dataclass(eq=False, repr=False)
class WeightedClusterClusterWeight(betterproto.Message):
    """[#next-free-field: 13]"""

    name: str = betterproto.string_field(1)
    """
    Only one of ``name`` and ``cluster_header`` may be specified. [#next-major-
    version: Need to add back the validation rule: (validate.rules).string =
    {min_len: 1}] Name of the upstream cluster. The cluster must exist in the
    :ref:`cluster manager configuration <config_cluster_manager>`.
    """

    cluster_header: str = betterproto.string_field(12)
    """
    Only one of ``name`` and ``cluster_header`` may be specified. [#next-major-
    version: Need to add back the validation rule: (validate.rules).string =
    {min_len: 1 }] Envoy will determine the cluster to route to by reading the
    value of the HTTP header named by cluster_header from the request headers.
    If the header is not found or the referenced cluster does not exist, Envoy
    will return a 404 response. .. attention::   Internally, Envoy always uses
    the HTTP/2 ``:authority`` header to represent the HTTP/1   ``Host`` header.
    Thus, if attempting to match on ``Host``, match on ``:authority`` instead.
    .. note::   If the header appears multiple times only the first value is
    used.
    """

    weight: Optional[int] = betterproto.message_field(2, wraps=betterproto.TYPE_UINT32)
    """
    The weight of the cluster. This value is relative to the other clusters'
    weights. When a request matches the route, the choice of an upstream
    cluster is determined by its weight. The sum of weights across all entries
    in the clusters array must be greater than 0.
    """

    metadata_match: "__core_v3__.Metadata" = betterproto.message_field(3)
    """
    Optional endpoint metadata match criteria used by the subset load balancer.
    Only endpoints in the upstream cluster with metadata matching what is set
    in this field will be considered for load balancing. Note that this will be
    merged with what's provided in :ref:`RouteAction.metadata_match
    <envoy_v3_api_field_config.route.v3.RouteAction.metadata_match>`, with
    values here taking precedence. The filter name should be specified as
    ``envoy.lb``.
    """

    request_headers_to_add: List[
        "__core_v3__.HeaderValueOption"
    ] = betterproto.message_field(4)
    """
    Specifies a list of headers to be added to requests when this cluster is
    selected through the enclosing
    :ref:`envoy_v3_api_msg_config.route.v3.RouteAction`. Headers specified at
    this level are applied before headers from the enclosing
    :ref:`envoy_v3_api_msg_config.route.v3.Route`,
    :ref:`envoy_v3_api_msg_config.route.v3.VirtualHost`, and
    :ref:`envoy_v3_api_msg_config.route.v3.RouteConfiguration`. For more
    information, including details on header value syntax, see the
    documentation on :ref:`custom request headers
    <config_http_conn_man_headers_custom_request_headers>`.
    """

    request_headers_to_remove: List[str] = betterproto.string_field(9)
    """
    Specifies a list of HTTP headers that should be removed from each request
    when this cluster is selected through the enclosing
    :ref:`envoy_v3_api_msg_config.route.v3.RouteAction`.
    """

    response_headers_to_add: List[
        "__core_v3__.HeaderValueOption"
    ] = betterproto.message_field(5)
    """
    Specifies a list of headers to be added to responses when this cluster is
    selected through the enclosing
    :ref:`envoy_v3_api_msg_config.route.v3.RouteAction`. Headers specified at
    this level are applied before headers from the enclosing
    :ref:`envoy_v3_api_msg_config.route.v3.Route`,
    :ref:`envoy_v3_api_msg_config.route.v3.VirtualHost`, and
    :ref:`envoy_v3_api_msg_config.route.v3.RouteConfiguration`. For more
    information, including details on header value syntax, see the
    documentation on :ref:`custom request headers
    <config_http_conn_man_headers_custom_request_headers>`.
    """

    response_headers_to_remove: List[str] = betterproto.string_field(6)
    """
    Specifies a list of headers to be removed from responses when this cluster
    is selected through the enclosing
    :ref:`envoy_v3_api_msg_config.route.v3.RouteAction`.
    """

    typed_per_filter_config: Dict[
        str, "betterproto_lib_google_protobuf.Any"
    ] = betterproto.map_field(10, betterproto.TYPE_STRING, betterproto.TYPE_MESSAGE)
    """
    The per_filter_config field can be used to provide weighted cluster-
    specific configurations for filters. The key should match the :ref:`filter
    config name <envoy_v3_api_field_extensions.filters.network.http_connection_
    manager.v3.HttpFilter.name>`. The canonical filter name (e.g.,
    ``envoy.filters.http.buffer`` for the HTTP buffer filter) can also be used
    for the backwards compatibility. If there is no entry referred by the
    filter config name, the entry referred by the canonical filter name will be
    provided to the filters as fallback. Use of this field is filter specific;
    see the :ref:`HTTP filter documentation <config_http_filters>` for if and
    how it is utilized. [#comment: An entry's value may be wrapped in a
    :ref:`FilterConfig<envoy_v3_api_msg_config.route.v3.FilterConfig>` message
    to specify additional options.]
    """

    host_rewrite_literal: str = betterproto.string_field(
        11, group="host_rewrite_specifier"
    )
    """
    Indicates that during forwarding, the host header will be swapped with this
    value.
    """


@dataclass(eq=False, repr=False)
class ClusterSpecifierPlugin(betterproto.Message):
    """Configuration for a cluster specifier plugin."""

    extension: "__core_v3__.TypedExtensionConfig" = betterproto.message_field(1)
    """The name of the plugin and its opaque configuration."""

    is_optional: bool = betterproto.bool_field(2)
    """
    If is_optional is not set or is set to false and the plugin defined by this
    message is not a supported type, the containing resource is NACKed. If
    is_optional is set to true, the resource would not be NACKed for this
    reason. In this case, routes referencing this plugin's name would not be
    treated as an illegal configuration, but would result in a failure if the
    route is selected.
    """


@dataclass(eq=False, repr=False)
class RouteMatch(betterproto.Message):
    """[#next-free-field: 16]"""

    prefix: str = betterproto.string_field(1, group="path_specifier")
    """
    If specified, the route is a prefix rule meaning that the prefix must match
    the beginning of the ``:path`` header.
    """

    path: str = betterproto.string_field(2, group="path_specifier")
    """
    If specified, the route is an exact path rule meaning that the path must
    exactly match the ``:path`` header once the query string is removed.
    """

    safe_regex: "___type_matcher_v3__.RegexMatcher" = betterproto.message_field(
        10, group="path_specifier"
    )
    """
    If specified, the route is a regular expression rule meaning that the regex
    must match the ``:path`` header once the query string is removed. The
    entire path (without the query string) must match the regex. The rule will
    not match if only a subsequence of the ``:path`` header matches the regex.
    [#next-major-version: In the v3 API we should redo how path specification
    works such that we utilize StringMatcher, and additionally have consistent
    options around whether we strip query strings, do a case sensitive match,
    etc. In the interim it will be too disruptive to deprecate the existing
    options. We should even consider whether we want to do away with
    path_specifier entirely and just rely on a set of header matchers which can
    already match on :path, etc. The issue with that is it is unclear how to
    generically deal with query string stripping. This needs more thought.]
    """

    connect_matcher: "RouteMatchConnectMatcher" = betterproto.message_field(
        12, group="path_specifier"
    )
    """
    If this is used as the matcher, the matcher will only match CONNECT
    requests. Note that this will not match HTTP/2 upgrade-style CONNECT
    requests (WebSocket and the like) as they are normalized in Envoy as
    HTTP/1.1 style upgrades. This is the only way to match CONNECT requests for
    HTTP/1.1. For HTTP/2, where Extended CONNECT requests may have a path, the
    path matchers will work if there is a path present. Note that CONNECT
    support is currently considered alpha in Envoy. [#comment: TODO(htuch):
    Replace the above comment with an alpha tag.]
    """

    path_separated_prefix: str = betterproto.string_field(14, group="path_specifier")
    """
    If specified, the route is a path-separated prefix rule meaning that the
    ``:path`` header (without the query string) must either exactly match the
    ``path_separated_prefix`` or have it as a prefix, followed by ``/`` For
    example, ``/api/dev`` would match ``/api/dev``, ``/api/dev/``,
    ``/api/dev/v1``, and ``/api/dev?param=true`` but would not match
    ``/api/developer`` Expect the value to not contain ``?`` or ``#`` and not
    to end in ``/``
    """

    path_match_policy: "__core_v3__.TypedExtensionConfig" = betterproto.message_field(
        15, group="path_specifier"
    )
    """[#extension-category: envoy.path.match]"""

    case_sensitive: Optional[bool] = betterproto.message_field(
        4, wraps=betterproto.TYPE_BOOL
    )
    """
    Indicates that prefix/path matching should be case sensitive. The default
    is true. Ignored for safe_regex matching.
    """

    runtime_fraction: "__core_v3__.RuntimeFractionalPercent" = (
        betterproto.message_field(9)
    )
    """
    Indicates that the route should additionally match on a runtime key. Every
    time the route is considered for a match, it must also fall under the
    percentage of matches indicated by this field. For some fraction N/D, a
    random number in the range [0,D) is selected. If the number is <= the value
    of the numerator N, or if the key is not present, the default value, the
    router continues to evaluate the remaining match criteria. A
    runtime_fraction route configuration can be used to roll out route changes
    in a gradual manner without full code/config deploys. Refer to the
    :ref:`traffic shifting
    <config_http_conn_man_route_table_traffic_splitting_shift>` docs for
    additional documentation. .. note::    Parsing this field is implemented
    such that the runtime key's data may be represented    as a
    FractionalPercent proto represented as JSON/YAML and may also be
    represented as an    integer with the assumption that the value is an
    integral percentage out of 100. For    instance, a runtime key lookup
    returning the value "42" would parse as a FractionalPercent    whose
    numerator is 42 and denominator is HUNDRED. This preserves legacy
    semantics.
    """

    headers: List["HeaderMatcher"] = betterproto.message_field(6)
    """
    Specifies a set of headers that the route should match on. The router will
    check the request’s headers against all the specified headers in the route
    config. A match will happen if all the headers in the route are present in
    the request with the same values (or based on presence if the value field
    is not in the config).
    """

    query_parameters: List["QueryParameterMatcher"] = betterproto.message_field(7)
    """
    Specifies a set of URL query parameters on which the route should match.
    The router will check the query string from the ``path`` header against all
    the specified query parameters. If the number of specified query parameters
    is nonzero, they all must match the ``path`` header's query string for a
    match to occur. .. note::    If query parameters are used to pass request
    message fields when    `grpc_json_transcoder <https://www.envoyproxy.io/doc
    s/envoy/latest/configuration/http/http_filters/grpc_json_transcoder_filter>
    `_    is used, the transcoded message fields maybe different. The query
    parameters are    url encoded, but the message fields are not. For example,
    if a query    parameter is "foo%20bar", the message field will be "foo
    bar".
    """

    grpc: "RouteMatchGrpcRouteMatchOptions" = betterproto.message_field(8)
    """
    If specified, only gRPC requests will be matched. The router will check
    that the content-type header has a application/grpc or one of the various
    application/grpc+ values.
    """

    tls_context: "RouteMatchTlsContextMatchOptions" = betterproto.message_field(11)
    """
    If specified, the client tls context will be matched against the defined
    match options. [#next-major-version: unify with RBAC]
    """

    dynamic_metadata: List[
        "___type_matcher_v3__.MetadataMatcher"
    ] = betterproto.message_field(13)
    """
    Specifies a set of dynamic metadata matchers on which the route should
    match. The router will check the dynamic metadata against all the specified
    dynamic metadata matchers. If the number of specified dynamic metadata
    matchers is nonzero, they all must match the dynamic metadata for a match
    to occur.
    """


@dataclass(eq=False, repr=False)
class RouteMatchGrpcRouteMatchOptions(betterproto.Message):
    pass


@dataclass(eq=False, repr=False)
class RouteMatchTlsContextMatchOptions(betterproto.Message):
    presented: Optional[bool] = betterproto.message_field(
        1, wraps=betterproto.TYPE_BOOL
    )
    """
    If specified, the route will match against whether or not a certificate is
    presented. If not specified, certificate presentation status (true or
    false) will not be considered when route matching.
    """

    validated: Optional[bool] = betterproto.message_field(
        2, wraps=betterproto.TYPE_BOOL
    )
    """
    If specified, the route will match against whether or not a certificate is
    validated. If not specified, certificate validation status (true or false)
    will not be considered when route matching.
    """


@dataclass(eq=False, repr=False)
class RouteMatchConnectMatcher(betterproto.Message):
    """An extensible message for matching CONNECT requests."""

    pass


@dataclass(eq=False, repr=False)
class CorsPolicy(betterproto.Message):
    """
    Cors policy configuration. .. attention::   This message has been
    deprecated. Please use   :ref:`CorsPolicy in filter extension
    <envoy_v3_api_msg_extensions.filters.http.cors.v3.CorsPolicy>`   as as
    alternative. [#next-free-field: 13]
    """

    allow_origin_string_match: List[
        "___type_matcher_v3__.StringMatcher"
    ] = betterproto.message_field(11)
    """
    Specifies string patterns that match allowed origins. An origin is allowed
    if any of the string matchers match.
    """

    allow_methods: str = betterproto.string_field(2)
    """
    Specifies the content for the ``access-control-allow-methods`` header.
    """

    allow_headers: str = betterproto.string_field(3)
    """
    Specifies the content for the ``access-control-allow-headers`` header.
    """

    expose_headers: str = betterproto.string_field(4)
    """
    Specifies the content for the ``access-control-expose-headers`` header.
    """

    max_age: str = betterproto.string_field(5)
    """Specifies the content for the ``access-control-max-age`` header."""

    allow_credentials: Optional[bool] = betterproto.message_field(
        6, wraps=betterproto.TYPE_BOOL
    )
    """Specifies whether the resource allows credentials."""

    filter_enabled: "__core_v3__.RuntimeFractionalPercent" = betterproto.message_field(
        9, group="enabled_specifier"
    )
    """
    Specifies the % of requests for which the CORS filter is enabled. If
    neither ``enabled``, ``filter_enabled``, nor ``shadow_enabled`` are
    specified, the CORS filter will be enabled for 100% of the requests. If
    :ref:`runtime_key
    <envoy_v3_api_field_config.core.v3.RuntimeFractionalPercent.runtime_key>`
    is specified, Envoy will lookup the runtime key to get the percentage of
    requests to filter.
    """

    shadow_enabled: "__core_v3__.RuntimeFractionalPercent" = betterproto.message_field(
        10
    )
    """
    Specifies the % of requests for which the CORS policies will be evaluated
    and tracked, but not enforced. This field is intended to be used when
    ``filter_enabled`` and ``enabled`` are off. One of those fields have to
    explicitly disable the filter in order for this setting to take effect. If
    :ref:`runtime_key
    <envoy_v3_api_field_config.core.v3.RuntimeFractionalPercent.runtime_key>`
    is specified, Envoy will lookup the runtime key to get the percentage of
    requests for which it will evaluate and track the request's ``Origin`` to
    determine if it's valid but will not enforce any policies.
    """

    allow_private_network_access: Optional[bool] = betterproto.message_field(
        12, wraps=betterproto.TYPE_BOOL
    )
    """
    Specify whether allow requests whose target server's IP address is more
    private than that from which the request initiator was fetched. More
    details refer to https://developer.chrome.com/blog/private-network-access-
    preflight.
    """


@dataclass(eq=False, repr=False)
class RouteAction(betterproto.Message):
    """[#next-free-field: 42]"""

    cluster: str = betterproto.string_field(1, group="cluster_specifier")
    """
    Indicates the upstream cluster to which the request should be routed to.
    """

    cluster_header: str = betterproto.string_field(2, group="cluster_specifier")
    """
    Envoy will determine the cluster to route to by reading the value of the
    HTTP header named by cluster_header from the request headers. If the header
    is not found or the referenced cluster does not exist, Envoy will return a
    404 response. .. attention::   Internally, Envoy always uses the HTTP/2
    ``:authority`` header to represent the HTTP/1   ``Host`` header. Thus, if
    attempting to match on ``Host``, match on ``:authority`` instead. .. note::
    If the header appears multiple times only the first value is used.
    """

    weighted_clusters: "WeightedCluster" = betterproto.message_field(
        3, group="cluster_specifier"
    )
    """
    Multiple upstream clusters can be specified for a given route. The request
    is routed to one of the upstream clusters based on weights assigned to each
    cluster. See :ref:`traffic splitting
    <config_http_conn_man_route_table_traffic_splitting_split>` for additional
    documentation.
    """

    cluster_specifier_plugin: str = betterproto.string_field(
        37, group="cluster_specifier"
    )
    """
    Name of the cluster specifier plugin to use to determine the cluster for
    requests on this route. The cluster specifier plugin name must be defined
    in the associated :ref:`cluster specifier plugins <envoy_v3_api_field_confi
    g.route.v3.RouteConfiguration.cluster_specifier_plugins>` in the :ref:`name
    <envoy_v3_api_field_config.core.v3.TypedExtensionConfig.name>` field.
    """

    inline_cluster_specifier_plugin: "ClusterSpecifierPlugin" = (
        betterproto.message_field(39, group="cluster_specifier")
    )
    """
    Custom cluster specifier plugin configuration to use to determine the
    cluster for requests on this route.
    """

    cluster_not_found_response_code: "RouteActionClusterNotFoundResponseCode" = (
        betterproto.enum_field(20)
    )
    """
    The HTTP status code to use when configured cluster is not found. The
    default response code is 503 Service Unavailable.
    """

    metadata_match: "__core_v3__.Metadata" = betterproto.message_field(4)
    """
    Optional endpoint metadata match criteria used by the subset load balancer.
    Only endpoints in the upstream cluster with metadata matching what's set in
    this field will be considered for load balancing. If using
    :ref:`weighted_clusters
    <envoy_v3_api_field_config.route.v3.RouteAction.weighted_clusters>`,
    metadata will be merged, with values provided there taking precedence. The
    filter name should be specified as ``envoy.lb``.
    """

    prefix_rewrite: str = betterproto.string_field(5)
    """
    Indicates that during forwarding, the matched prefix (or path) should be
    swapped with this value. This option allows application URLs to be rooted
    at a different path from those exposed at the reverse proxy layer. The
    router filter will place the original path before rewrite into the
    :ref:`x-envoy-original-path <config_http_filters_router_x-envoy-original-
    path>` header. Only one of :ref:`regex_rewrite
    <envoy_v3_api_field_config.route.v3.RouteAction.regex_rewrite>`
    :ref:`path_rewrite_policy
    <envoy_v3_api_field_config.route.v3.RouteAction.path_rewrite_policy>`, or
    :ref:`prefix_rewrite
    <envoy_v3_api_field_config.route.v3.RouteAction.prefix_rewrite>` may be
    specified. .. attention::   Pay careful attention to the use of trailing
    slashes in the   :ref:`route's match
    <envoy_v3_api_field_config.route.v3.Route.match>` prefix value.   Stripping
    a prefix from a path requires multiple Routes to handle all cases. For
    example,   rewriting ``/prefix`` to ``/`` and ``/prefix/etc`` to ``/etc``
    cannot be done in a single   :ref:`Route
    <envoy_v3_api_msg_config.route.v3.Route>`, as shown by the below config
    entries:   .. code-block:: yaml     - match:         prefix: "/prefix/"
    route:         prefix_rewrite: "/"     - match:         prefix: "/prefix"
    route:         prefix_rewrite: "/"   Having above entries in the config,
    requests to ``/prefix`` will be stripped to ``/``, while   requests to
    ``/prefix/etc`` will be stripped to ``/etc``.
    """

    regex_rewrite: "___type_matcher_v3__.RegexMatchAndSubstitute" = (
        betterproto.message_field(32)
    )
    """
    Indicates that during forwarding, portions of the path that match the
    pattern should be rewritten, even allowing the substitution of capture
    groups from the pattern into the new path as specified by the rewrite
    substitution string. This is useful to allow application paths to be
    rewritten in a way that is aware of segments with variable content like
    identifiers. The router filter will place the original path as it was
    before the rewrite into the :ref:`x-envoy-original-path
    <config_http_filters_router_x-envoy-original-path>` header. Only one of
    :ref:`regex_rewrite
    <envoy_v3_api_field_config.route.v3.RouteAction.regex_rewrite>`,
    :ref:`prefix_rewrite
    <envoy_v3_api_field_config.route.v3.RouteAction.prefix_rewrite>`, or
    :ref:`path_rewrite_policy
    <envoy_v3_api_field_config.route.v3.RouteAction.path_rewrite_policy>`] may
    be specified. Examples using Google's `RE2
    <https://github.com/google/re2>`_ engine: * The path pattern
    ``^/service/([^/]+)(/.*)$`` paired with a substitution   string of
    ``\2/instance/\1`` would transform ``/service/foo/v1/api``   into
    ``/v1/api/instance/foo``. * The pattern ``one`` paired with a substitution
    string of ``two`` would   transform ``/xxx/one/yyy/one/zzz`` into
    ``/xxx/two/yyy/two/zzz``. * The pattern ``^(.*?)one(.*)$`` paired with a
    substitution string of   ``\1two\2`` would replace only the first
    occurrence of ``one``,   transforming path ``/xxx/one/yyy/one/zzz`` into
    ``/xxx/two/yyy/one/zzz``. * The pattern ``(?i)/xxx/`` paired with a
    substitution string of ``/yyy/``   would do a case-insensitive match and
    transform path ``/aaa/XxX/bbb`` to   ``/aaa/yyy/bbb``.
    """

    path_rewrite_policy: "__core_v3__.TypedExtensionConfig" = betterproto.message_field(
        41
    )
    """[#extension-category: envoy.path.rewrite]"""

    host_rewrite_literal: str = betterproto.string_field(
        6, group="host_rewrite_specifier"
    )
    """
    Indicates that during forwarding, the host header will be swapped with this
    value. Using this option will append the
    :ref:`config_http_conn_man_headers_x-forwarded-host` header if
    :ref:`append_x_forwarded_host
    <envoy_v3_api_field_config.route.v3.RouteAction.append_x_forwarded_host>`
    is set.
    """

    auto_host_rewrite: Optional[bool] = betterproto.message_field(
        7, wraps=betterproto.TYPE_BOOL, group="host_rewrite_specifier"
    )
    """
    Indicates that during forwarding, the host header will be swapped with the
    hostname of the upstream host chosen by the cluster manager. This option is
    applicable only when the destination cluster for a route is of type
    ``strict_dns`` or ``logical_dns``. Setting this to true with other cluster
    types has no effect. Using this option will append the
    :ref:`config_http_conn_man_headers_x-forwarded-host` header if
    :ref:`append_x_forwarded_host
    <envoy_v3_api_field_config.route.v3.RouteAction.append_x_forwarded_host>`
    is set.
    """

    host_rewrite_header: str = betterproto.string_field(
        29, group="host_rewrite_specifier"
    )
    """
    Indicates that during forwarding, the host header will be swapped with the
    content of given downstream or :ref:`custom
    <config_http_conn_man_headers_custom_request_headers>` header. If header
    value is empty, host header is left intact. Using this option will append
    the :ref:`config_http_conn_man_headers_x-forwarded-host` header if
    :ref:`append_x_forwarded_host
    <envoy_v3_api_field_config.route.v3.RouteAction.append_x_forwarded_host>`
    is set. .. attention::   Pay attention to the potential security
    implications of using this option. Provided header   must come from trusted
    source. .. note::   If the header appears multiple times only the first
    value is used.
    """

    host_rewrite_path_regex: "___type_matcher_v3__.RegexMatchAndSubstitute" = (
        betterproto.message_field(35, group="host_rewrite_specifier")
    )
    """
    Indicates that during forwarding, the host header will be swapped with the
    result of the regex substitution executed on path value with query and
    fragment removed. This is useful for transitioning variable content between
    path segment and subdomain. Using this option will append the
    :ref:`config_http_conn_man_headers_x-forwarded-host` header if
    :ref:`append_x_forwarded_host
    <envoy_v3_api_field_config.route.v3.RouteAction.append_x_forwarded_host>`
    is set. For example with the following config:   .. code-block:: yaml
    host_rewrite_path_regex:       pattern:         google_re2: {}
    regex: "^/(.+)/.+$"       substitution: \1 Would rewrite the host header to
    ``envoyproxy.io`` given the path ``/envoyproxy.io/some/path``.
    """

    append_x_forwarded_host: bool = betterproto.bool_field(38)
    """
    If set, then a host rewrite action (one of :ref:`host_rewrite_literal
    <envoy_v3_api_field_config.route.v3.RouteAction.host_rewrite_literal>`,
    :ref:`auto_host_rewrite
    <envoy_v3_api_field_config.route.v3.RouteAction.auto_host_rewrite>`,
    :ref:`host_rewrite_header
    <envoy_v3_api_field_config.route.v3.RouteAction.host_rewrite_header>`, or
    :ref:`host_rewrite_path_regex
    <envoy_v3_api_field_config.route.v3.RouteAction.host_rewrite_path_regex>`)
    causes the original value of the host header, if any, to be appended to the
    :ref:`config_http_conn_man_headers_x-forwarded-host` HTTP header.
    """

    timeout: timedelta = betterproto.message_field(8)
    """
    Specifies the upstream timeout for the route. If not specified, the default
    is 15s. This spans between the point at which the entire downstream request
    (i.e. end-of-stream) has been processed and when the upstream response has
    been completely processed. A value of 0 will disable the route's timeout.
    .. note::   This timeout includes all retries. See also
    :ref:`config_http_filters_router_x-envoy-upstream-rq-timeout-ms`,
    :ref:`config_http_filters_router_x-envoy-upstream-rq-per-try-timeout-ms`,
    and the   :ref:`retry overview <arch_overview_http_routing_retry>`.
    """

    idle_timeout: timedelta = betterproto.message_field(24)
    """
    Specifies the idle timeout for the route. If not specified, there is no
    per-route idle timeout, although the connection manager wide
    :ref:`stream_idle_timeout <envoy_v3_api_field_extensions.filters.network.ht
    tp_connection_manager.v3.HttpConnectionManager.stream_idle_timeout>` will
    still apply. A value of 0 will completely disable the route's idle timeout,
    even if a connection manager stream idle timeout is configured. The idle
    timeout is distinct to :ref:`timeout
    <envoy_v3_api_field_config.route.v3.RouteAction.timeout>`, which provides
    an upper bound on the upstream response time; :ref:`idle_timeout
    <envoy_v3_api_field_config.route.v3.RouteAction.idle_timeout>` instead
    bounds the amount of time the request's stream may be idle. After header
    decoding, the idle timeout will apply on downstream and upstream request
    events. Each time an encode/decode event for headers or data is processed
    for the stream, the timer will be reset. If the timeout fires, the stream
    is terminated with a 408 Request Timeout error code if no upstream response
    header has been received, otherwise a stream reset occurs. If the
    :ref:`overload action <config_overload_manager_overload_actions>`
    "envoy.overload_actions.reduce_timeouts" is configured, this timeout is
    scaled according to the value for :ref:`HTTP_DOWNSTREAM_STREAM_IDLE <envoy_
    v3_api_enum_value_config.overload.v3.ScaleTimersOverloadActionConfig.TimerT
    ype.HTTP_DOWNSTREAM_STREAM_IDLE>`.
    """

    early_data_policy: "__core_v3__.TypedExtensionConfig" = betterproto.message_field(
        40
    )
    """
    Specifies how to send request over TLS early data. If absent, allows `safe
    HTTP requests <https://www.rfc-editor.org/rfc/rfc7231#section-4.2.1>`_ to
    be sent on early data. [#extension-category: envoy.route.early_data_policy]
    """

    retry_policy: "RetryPolicy" = betterproto.message_field(9)
    """
    Indicates that the route has a retry policy. Note that if this is set,
    it'll take precedence over the virtual host level retry policy entirely
    (e.g.: policies are not merged, most internal one becomes the enforced
    policy).
    """

    retry_policy_typed_config: "betterproto_lib_google_protobuf.Any" = (
        betterproto.message_field(33)
    )
    """
    [#not-implemented-hide:] Specifies the configuration for retry policy
    extension. Note that if this is set, it'll take precedence over the virtual
    host level retry policy entirely (e.g.: policies are not merged, most
    internal one becomes the enforced policy). :ref:`Retry policy
    <envoy_v3_api_field_config.route.v3.VirtualHost.retry_policy>` should not
    be set if this field is used.
    """

    request_mirror_policies: List[
        "RouteActionRequestMirrorPolicy"
    ] = betterproto.message_field(30)
    """
    Specify a set of route request mirroring policies. It takes precedence over
    the virtual host and route config mirror policy entirely. That is, policies
    are not merged, the most specific non-empty one becomes the mirror
    policies.
    """

    priority: "__core_v3__.RoutingPriority" = betterproto.enum_field(11)
    """
    Optionally specifies the :ref:`routing priority
    <arch_overview_http_routing_priority>`.
    """

    rate_limits: List["RateLimit"] = betterproto.message_field(13)
    """
    Specifies a set of rate limit configurations that could be applied to the
    route.
    """

    include_vh_rate_limits: Optional[bool] = betterproto.message_field(
        14, wraps=betterproto.TYPE_BOOL
    )
    """
    Specifies if the rate limit filter should include the virtual host rate
    limits. By default, if the route configured rate limits, the virtual host
    :ref:`rate_limits
    <envoy_v3_api_field_config.route.v3.VirtualHost.rate_limits>` are not
    applied to the request. This field is deprecated. Please use
    :ref:`vh_rate_limits <envoy_v3_api_field_extensions.filters.http.ratelimit.
    v3.RateLimitPerRoute.vh_rate_limits>`
    """

    hash_policy: List["RouteActionHashPolicy"] = betterproto.message_field(15)
    """
    Specifies a list of hash policies to use for ring hash load balancing. Each
    hash policy is evaluated individually and the combined result is used to
    route the request. The method of combination is deterministic such that
    identical lists of hash policies will produce the same hash. Since a hash
    policy examines specific parts of a request, it can fail to produce a hash
    (i.e. if the hashed header is not present). If (and only if) all configured
    hash policies fail to generate a hash, no hash will be produced for the
    route. In this case, the behavior is the same as if no hash policies were
    specified (i.e. the ring hash load balancer will choose a random backend).
    If a hash policy has the "terminal" attribute set to true, and there is
    already a hash generated, the hash is returned immediately, ignoring the
    rest of the hash policy list.
    """

    cors: "CorsPolicy" = betterproto.message_field(17)
    """
    Indicates that the route has a CORS policy. This field is ignored if
    related cors policy is found in the :ref:`Route.typed_per_filter_config<env
    oy_v3_api_field_config.route.v3.Route.typed_per_filter_config>` or :ref:`We
    ightedCluster.ClusterWeight.typed_per_filter_config<envoy_v3_api_field_conf
    ig.route.v3.WeightedCluster.ClusterWeight.typed_per_filter_config>`. ..
    attention::   This option has been deprecated. Please use   :ref:`Route.typ
    ed_per_filter_config<envoy_v3_api_field_config.route.v3.Route.typed_per_fil
    ter_config>` or   :ref:`WeightedCluster.ClusterWeight.typed_per_filter_conf
    ig<envoy_v3_api_field_config.route.v3.WeightedCluster.ClusterWeight.typed_p
    er_filter_config>`   to configure the CORS HTTP filter.
    """

    max_grpc_timeout: timedelta = betterproto.message_field(23)
    """
    Deprecated by :ref:`grpc_timeout_header_max <envoy_v3_api_field_config.rout
    e.v3.RouteAction.MaxStreamDuration.grpc_timeout_header_max>` If present,
    and the request is a gRPC request, use the `grpc-timeout header
    <https://github.com/grpc/grpc/blob/master/doc/PROTOCOL-HTTP2.md>`_, or its
    default value (infinity) instead of :ref:`timeout
    <envoy_v3_api_field_config.route.v3.RouteAction.timeout>`, but limit the
    applied timeout to the maximum value specified here. If configured as 0,
    the maximum allowed timeout for gRPC requests is infinity. If not
    configured at all, the ``grpc-timeout`` header is not used and gRPC
    requests time out like any other requests using :ref:`timeout
    <envoy_v3_api_field_config.route.v3.RouteAction.timeout>` or its default.
    This can be used to prevent unexpected upstream request timeouts due to
    potentially long time gaps between gRPC request and response in gRPC
    streaming mode. .. note::    If a timeout is specified using
    :ref:`config_http_filters_router_x-envoy-upstream-rq-timeout-ms`, it takes
    precedence over `grpc-timeout header
    <https://github.com/grpc/grpc/blob/master/doc/PROTOCOL-HTTP2.md>`_, when
    both are present. See also    :ref:`config_http_filters_router_x-envoy-
    upstream-rq-timeout-ms`,    :ref:`config_http_filters_router_x-envoy-
    upstream-rq-per-try-timeout-ms`, and the    :ref:`retry overview
    <arch_overview_http_routing_retry>`.
    """

    grpc_timeout_offset: timedelta = betterproto.message_field(28)
    """
    Deprecated by :ref:`grpc_timeout_header_offset <envoy_v3_api_field_config.r
    oute.v3.RouteAction.MaxStreamDuration.grpc_timeout_header_offset>`. If
    present, Envoy will adjust the timeout provided by the ``grpc-timeout``
    header by subtracting the provided duration from the header. This is useful
    in allowing Envoy to set its global timeout to be less than that of the
    deadline imposed by the calling client, which makes it more likely that
    Envoy will handle the timeout instead of having the call canceled by the
    client. The offset will only be applied if the provided grpc_timeout is
    greater than the offset. This ensures that the offset will only ever
    decrease the timeout and never set it to 0 (meaning infinity).
    """

    upgrade_configs: List["RouteActionUpgradeConfig"] = betterproto.message_field(25)
    internal_redirect_policy: "InternalRedirectPolicy" = betterproto.message_field(34)
    """
    If present, Envoy will try to follow an upstream redirect response instead
    of proxying the response back to the downstream. An upstream redirect
    response is defined by :ref:`redirect_response_codes <envoy_v3_api_field_co
    nfig.route.v3.InternalRedirectPolicy.redirect_response_codes>`.
    """

    internal_redirect_action: "RouteActionInternalRedirectAction" = (
        betterproto.enum_field(26)
    )
    max_internal_redirects: Optional[int] = betterproto.message_field(
        31, wraps=betterproto.TYPE_UINT32
    )
    """
    An internal redirect is handled, iff the number of previous internal
    redirects that a downstream request has encountered is lower than this
    value, and :ref:`internal_redirect_action
    <envoy_v3_api_field_config.route.v3.RouteAction.internal_redirect_action>`
    is set to :ref:`HANDLE_INTERNAL_REDIRECT <envoy_v3_api_enum_value_config.ro
    ute.v3.RouteAction.InternalRedirectAction.HANDLE_INTERNAL_REDIRECT>` In the
    case where a downstream request is bounced among multiple routes by
    internal redirect, the first route that hits this threshold, or has
    :ref:`internal_redirect_action
    <envoy_v3_api_field_config.route.v3.RouteAction.internal_redirect_action>`
    set to :ref:`PASS_THROUGH_INTERNAL_REDIRECT <envoy_v3_api_enum_value_config
    .route.v3.RouteAction.InternalRedirectAction.PASS_THROUGH_INTERNAL_REDIRECT
    >` will pass the redirect back to downstream. If not specified, at most one
    redirect will be followed.
    """

    hedge_policy: "HedgePolicy" = betterproto.message_field(27)
    """
    Indicates that the route has a hedge policy. Note that if this is set,
    it'll take precedence over the virtual host level hedge policy entirely
    (e.g.: policies are not merged, most internal one becomes the enforced
    policy).
    """

    max_stream_duration: "RouteActionMaxStreamDuration" = betterproto.message_field(36)
    """Specifies the maximum stream duration for this route."""

    def __post_init__(self) -> None:
        super().__post_init__()
        if self.is_set("include_vh_rate_limits"):
            warnings.warn(
                "RouteAction.include_vh_rate_limits is deprecated", DeprecationWarning
            )
        if self.is_set("cors"):
            warnings.warn("RouteAction.cors is deprecated", DeprecationWarning)
        if self.is_set("max_grpc_timeout"):
            warnings.warn(
                "RouteAction.max_grpc_timeout is deprecated", DeprecationWarning
            )
        if self.is_set("grpc_timeout_offset"):
            warnings.warn(
                "RouteAction.grpc_timeout_offset is deprecated", DeprecationWarning
            )
        if self.is_set("internal_redirect_action"):
            warnings.warn(
                "RouteAction.internal_redirect_action is deprecated", DeprecationWarning
            )
        if self.is_set("max_internal_redirects"):
            warnings.warn(
                "RouteAction.max_internal_redirects is deprecated", DeprecationWarning
            )


@dataclass(eq=False, repr=False)
class RouteActionRequestMirrorPolicy(betterproto.Message):
    """
    The router is capable of shadowing traffic from one cluster to another. The
    current implementation is "fire and forget," meaning Envoy will not wait
    for the shadow cluster to respond before returning the response from the
    primary cluster. All normal statistics are collected for the shadow cluster
    making this feature useful for testing. During shadowing, the
    host/authority header is altered such that ``-shadow`` is appended. This is
    useful for logging. For example, ``cluster1`` becomes ``cluster1-shadow``.
    .. note::   Shadowing will not be triggered if the primary cluster does not
    exist. .. note::   Shadowing doesn't support Http CONNECT and upgrades.
    [#next-free-field: 6]
    """

    cluster: str = betterproto.string_field(1)
    """
    Only one of ``cluster`` and ``cluster_header`` can be specified. [#next-
    major-version: Need to add back the validation rule:
    (validate.rules).string = {min_len: 1}] Specifies the cluster that requests
    will be mirrored to. The cluster must exist in the cluster manager
    configuration.
    """

    cluster_header: str = betterproto.string_field(5)
    """
    Only one of ``cluster`` and ``cluster_header`` can be specified. Envoy will
    determine the cluster to route to by reading the value of the HTTP header
    named by cluster_header from the request headers. Only the first value in
    header is used, and no shadow request will happen if the value is not found
    in headers. Envoy will not wait for the shadow cluster to respond before
    returning the response from the primary cluster. .. attention::
    Internally, Envoy always uses the HTTP/2 ``:authority`` header to represent
    the HTTP/1   ``Host`` header. Thus, if attempting to match on ``Host``,
    match on ``:authority`` instead. .. note::   If the header appears multiple
    times only the first value is used.
    """

    runtime_fraction: "__core_v3__.RuntimeFractionalPercent" = (
        betterproto.message_field(3)
    )
    """
    If not specified, all requests to the target cluster will be mirrored. If
    specified, this field takes precedence over the ``runtime_key`` field and
    requests must also fall under the percentage of matches indicated by this
    field. For some fraction N/D, a random number in the range [0,D) is
    selected. If the number is <= the value of the numerator N, or if the key
    is not present, the default value, the request will be mirrored.
    """

    trace_sampled: Optional[bool] = betterproto.message_field(
        4, wraps=betterproto.TYPE_BOOL
    )
    """Determines if the trace span should be sampled. Defaults to true."""


@dataclass(eq=False, repr=False)
class RouteActionHashPolicy(betterproto.Message):
    """
    Specifies the route's hashing policy if the upstream cluster uses a hashing
    :ref:`load balancer <arch_overview_load_balancing_types>`. [#next-free-
    field: 7]
    """

    header: "RouteActionHashPolicyHeader" = betterproto.message_field(
        1, group="policy_specifier"
    )
    """Header hash policy."""

    cookie: "RouteActionHashPolicyCookie" = betterproto.message_field(
        2, group="policy_specifier"
    )
    """Cookie hash policy."""

    connection_properties: "RouteActionHashPolicyConnectionProperties" = (
        betterproto.message_field(3, group="policy_specifier")
    )
    """Connection properties hash policy."""

    query_parameter: "RouteActionHashPolicyQueryParameter" = betterproto.message_field(
        5, group="policy_specifier"
    )
    """Query parameter hash policy."""

    filter_state: "RouteActionHashPolicyFilterState" = betterproto.message_field(
        6, group="policy_specifier"
    )
    """Filter state hash policy."""

    terminal: bool = betterproto.bool_field(4)
    """
    The flag that short-circuits the hash computing. This field provides a
    'fallback' style of configuration: "if a terminal policy doesn't work,
    fallback to rest of the policy list", it saves time when the terminal
    policy works. If true, and there is already a hash computed, ignore rest of
    the list of hash polices. For example, if the following hash methods are
    configured:  ========= ========  specifier terminal  ========= ========
    Header A  true  Header B  false  Header C  false  ========= ======== The
    generateHash process ends if policy "header A" generates a hash, as it's a
    terminal policy.
    """


@dataclass(eq=False, repr=False)
class RouteActionHashPolicyHeader(betterproto.Message):
    header_name: str = betterproto.string_field(1)
    """
    The name of the request header that will be used to obtain the hash key. If
    the request header is not present, no hash will be produced.
    """

    regex_rewrite: "___type_matcher_v3__.RegexMatchAndSubstitute" = (
        betterproto.message_field(2)
    )
    """
    If specified, the request header value will be rewritten and used to
    produce the hash key.
    """


@dataclass(eq=False, repr=False)
class RouteActionHashPolicyCookie(betterproto.Message):
    """
    Envoy supports two types of cookie affinity: 1. Passive. Envoy takes a
    cookie that's present in the cookies header and    hashes on its value. 2.
    Generated. Envoy generates and sets a cookie with an expiration (TTL)    on
    the first request from the client in its response to the client,    based
    on the endpoint the request gets sent to. The client then    presents this
    on the next and all subsequent requests. The hash of    this is sufficient
    to ensure these requests get sent to the same    endpoint. The cookie is
    generated by hashing the source and    destination ports and addresses so
    that multiple independent HTTP2    streams on the same connection will
    independently receive the same    cookie, even if they arrive at the Envoy
    simultaneously.
    """

    name: str = betterproto.string_field(1)
    """
    The name of the cookie that will be used to obtain the hash key. If the
    cookie is not present and ttl below is not set, no hash will be produced.
    """

    ttl: timedelta = betterproto.message_field(2)
    """
    If specified, a cookie with the TTL will be generated if the cookie is not
    present. If the TTL is present and zero, the generated cookie will be a
    session cookie.
    """

    path: str = betterproto.string_field(3)
    """
    The name of the path for the cookie. If no path is specified here, no path
    will be set for the cookie.
    """


@dataclass(eq=False, repr=False)
class RouteActionHashPolicyConnectionProperties(betterproto.Message):
    source_ip: bool = betterproto.bool_field(1)
    """Hash on source IP address."""


@dataclass(eq=False, repr=False)
class RouteActionHashPolicyQueryParameter(betterproto.Message):
    name: str = betterproto.string_field(1)
    """
    The name of the URL query parameter that will be used to obtain the hash
    key. If the parameter is not present, no hash will be produced. Query
    parameter names are case-sensitive.
    """


@dataclass(eq=False, repr=False)
class RouteActionHashPolicyFilterState(betterproto.Message):
    key: str = betterproto.string_field(1)
    """
    The name of the Object in the per-request filterState, which is an
    Envoy::Hashable object. If there is no data associated with the key, or the
    stored object is not Envoy::Hashable, no hash will be produced.
    """


@dataclass(eq=False, repr=False)
class RouteActionUpgradeConfig(betterproto.Message):
    """
    Allows enabling and disabling upgrades on a per-route basis. This overrides
    any enabled/disabled upgrade filter chain specified in the
    HttpConnectionManager :ref:`upgrade_configs <envoy_v3_api_field_extensions.
    filters.network.http_connection_manager.v3.HttpConnectionManager.upgrade_co
    nfigs>` but does not affect any custom filter chain specified there.
    """

    upgrade_type: str = betterproto.string_field(1)
    """
    The case-insensitive name of this upgrade, e.g. "websocket". For each
    upgrade type present in upgrade_configs, requests with Upgrade:
    [upgrade_type] will be proxied upstream.
    """

    enabled: Optional[bool] = betterproto.message_field(2, wraps=betterproto.TYPE_BOOL)
    """
    Determines if upgrades are available on this route. Defaults to true.
    """

    connect_config: "RouteActionUpgradeConfigConnectConfig" = betterproto.message_field(
        3
    )
    """
    Configuration for sending data upstream as a raw data payload. This is used
    for CONNECT requests, when forwarding CONNECT payload as raw TCP. Note that
    CONNECT support is currently considered alpha in Envoy. [#comment:
    TODO(htuch): Replace the above comment with an alpha tag.]
    """


@dataclass(eq=False, repr=False)
class RouteActionUpgradeConfigConnectConfig(betterproto.Message):
    """
    Configuration for sending data upstream as a raw data payload. This is used
    for CONNECT or POST requests, when forwarding request payload as raw TCP.
    """

    proxy_protocol_config: "__core_v3__.ProxyProtocolConfig" = (
        betterproto.message_field(1)
    )
    """
    If present, the proxy protocol header will be prepended to the CONNECT
    payload sent upstream.
    """

    allow_post: bool = betterproto.bool_field(2)
    """
    If set, the route will also allow forwarding POST payload as raw TCP.
    """


@dataclass(eq=False, repr=False)
class RouteActionMaxStreamDuration(betterproto.Message):
    max_stream_duration: timedelta = betterproto.message_field(1)
    """
    Specifies the maximum duration allowed for streams on the route. If not
    specified, the value from the :ref:`max_stream_duration <envoy_v3_api_field
    _config.core.v3.HttpProtocolOptions.max_stream_duration>` field in
    :ref:`HttpConnectionManager.common_http_protocol_options <envoy_v3_api_fiel
    d_extensions.filters.network.http_connection_manager.v3.HttpConnectionManag
    er.common_http_protocol_options>` is used. If this field is set explicitly
    to zero, any HttpConnectionManager max_stream_duration timeout will be
    disabled for this route.
    """

    grpc_timeout_header_max: timedelta = betterproto.message_field(2)
    """
    If present, and the request contains a `grpc-timeout header
    <https://github.com/grpc/grpc/blob/master/doc/PROTOCOL-HTTP2.md>`_, use
    that value as the ``max_stream_duration``, but limit the applied timeout to
    the maximum value specified here. If set to 0, the ``grpc-timeout`` header
    is used without modification.
    """

    grpc_timeout_header_offset: timedelta = betterproto.message_field(3)
    """
    If present, Envoy will adjust the timeout provided by the ``grpc-timeout``
    header by subtracting the provided duration from the header. This is useful
    for allowing Envoy to set its global timeout to be less than that of the
    deadline imposed by the calling client, which makes it more likely that
    Envoy will handle the timeout instead of having the call canceled by the
    client. If, after applying the offset, the resulting timeout is zero or
    negative, the stream will timeout immediately.
    """


@dataclass(eq=False, repr=False)
class RetryPolicy(betterproto.Message):
    """
    HTTP retry :ref:`architecture overview <arch_overview_http_routing_retry>`.
    [#next-free-field: 14]
    """

    retry_on: str = betterproto.string_field(1)
    """
    Specifies the conditions under which retry takes place. These are the same
    conditions documented for :ref:`config_http_filters_router_x-envoy-retry-
    on` and :ref:`config_http_filters_router_x-envoy-retry-grpc-on`.
    """

    num_retries: Optional[int] = betterproto.message_field(
        2, wraps=betterproto.TYPE_UINT32
    )
    """
    Specifies the allowed number of retries. This parameter is optional and
    defaults to 1. These are the same conditions documented for
    :ref:`config_http_filters_router_x-envoy-max-retries`.
    """

    per_try_timeout: timedelta = betterproto.message_field(3)
    """
    Specifies a non-zero upstream timeout per retry attempt (including the
    initial attempt). This parameter is optional. The same conditions
    documented for :ref:`config_http_filters_router_x-envoy-upstream-rq-per-
    try-timeout-ms` apply. .. note::   If left unspecified, Envoy will use the
    global   :ref:`route timeout
    <envoy_v3_api_field_config.route.v3.RouteAction.timeout>` for the request.
    Consequently, when using a :ref:`5xx <config_http_filters_router_x-envoy-
    retry-on>` based   retry policy, a request that times out will not be
    retried as the total timeout budget   would have been exhausted.
    """

    per_try_idle_timeout: timedelta = betterproto.message_field(13)
    """
    Specifies an upstream idle timeout per retry attempt (including the initial
    attempt). This parameter is optional and if absent there is no per try idle
    timeout. The semantics of the per try idle timeout are similar to the
    :ref:`route idle timeout
    <envoy_v3_api_field_config.route.v3.RouteAction.timeout>` and :ref:`stream
    idle timeout <envoy_v3_api_field_extensions.filters.network.http_connection
    _manager.v3.HttpConnectionManager.stream_idle_timeout>` both enforced by
    the HTTP connection manager. The difference is that this idle timeout is
    enforced by the router for each individual attempt and thus after all
    previous filters have run, as opposed to *before* all previous filters run
    for the other idle timeouts. This timeout is useful in cases in which total
    request timeout is bounded by a number of retries and a
    :ref:`per_try_timeout
    <envoy_v3_api_field_config.route.v3.RetryPolicy.per_try_timeout>`, but
    there is a desire to ensure each try is making incremental progress. Note
    also that similar to :ref:`per_try_timeout
    <envoy_v3_api_field_config.route.v3.RetryPolicy.per_try_timeout>`, this
    idle timeout does not start until after both the entire request has been
    received by the router *and* a connection pool connection has been
    obtained. Unlike :ref:`per_try_timeout
    <envoy_v3_api_field_config.route.v3.RetryPolicy.per_try_timeout>`, the idle
    timer continues once the response starts streaming back to the downstream
    client. This ensures that response data continues to make progress without
    using one of the HTTP connection manager idle timeouts.
    """

    retry_priority: "RetryPolicyRetryPriority" = betterproto.message_field(4)
    """
    Specifies an implementation of a RetryPriority which is used to determine
    the distribution of load across priorities used for retries. Refer to
    :ref:`retry plugin configuration <arch_overview_http_retry_plugins>` for
    more details.
    """

    retry_host_predicate: List[
        "RetryPolicyRetryHostPredicate"
    ] = betterproto.message_field(5)
    """
    Specifies a collection of RetryHostPredicates that will be consulted when
    selecting a host for retries. If any of the predicates reject the host,
    host selection will be reattempted. Refer to :ref:`retry plugin
    configuration <arch_overview_http_retry_plugins>` for more details.
    """

    retry_options_predicates: List[
        "__core_v3__.TypedExtensionConfig"
    ] = betterproto.message_field(12)
    """
    Retry options predicates that will be applied prior to retrying a request.
    These predicates allow customizing request behavior between retries.
    [#comment: add [#extension-category: envoy.retry_options_predicates] when
    there are built-in extensions]
    """

    host_selection_retry_max_attempts: int = betterproto.int64_field(6)
    """
    The maximum number of times host selection will be reattempted before
    giving up, at which point the host that was last selected will be routed
    to. If unspecified, this will default to retrying once.
    """

    retriable_status_codes: List[int] = betterproto.uint32_field(7)
    """
    HTTP status codes that should trigger a retry in addition to those
    specified by retry_on.
    """

    retry_back_off: "RetryPolicyRetryBackOff" = betterproto.message_field(8)
    """
    Specifies parameters that control exponential retry back off. This
    parameter is optional, in which case the default base interval is 25
    milliseconds or, if set, the current value of the
    ``upstream.base_retry_backoff_ms`` runtime parameter. The default maximum
    interval is 10 times the base interval. The documentation for
    :ref:`config_http_filters_router_x-envoy-max-retries` describes Envoy's
    back-off algorithm.
    """

    rate_limited_retry_back_off: "RetryPolicyRateLimitedRetryBackOff" = (
        betterproto.message_field(11)
    )
    """
    Specifies parameters that control a retry back-off strategy that is used
    when the request is rate limited by the upstream server. The server may
    return a response header like ``Retry-After`` or ``X-RateLimit-Reset`` to
    provide feedback to the client on how long to wait before retrying. If
    configured, this back-off strategy will be used instead of the default
    exponential back off strategy (configured using ``retry_back_off``)
    whenever a response includes the matching headers.
    """

    retriable_headers: List["HeaderMatcher"] = betterproto.message_field(9)
    """
    HTTP response headers that trigger a retry if present in the response. A
    retry will be triggered if any of the header matches match the upstream
    response headers. The field is only consulted if 'retriable-headers' retry
    policy is active.
    """

    retriable_request_headers: List["HeaderMatcher"] = betterproto.message_field(10)
    """
    HTTP headers which must be present in the request for retries to be
    attempted.
    """


@dataclass(eq=False, repr=False)
class RetryPolicyRetryPriority(betterproto.Message):
    name: str = betterproto.string_field(1)
    typed_config: "betterproto_lib_google_protobuf.Any" = betterproto.message_field(
        3, group="config_type"
    )


@dataclass(eq=False, repr=False)
class RetryPolicyRetryHostPredicate(betterproto.Message):
    name: str = betterproto.string_field(1)
    typed_config: "betterproto_lib_google_protobuf.Any" = betterproto.message_field(
        3, group="config_type"
    )


@dataclass(eq=False, repr=False)
class RetryPolicyRetryBackOff(betterproto.Message):
    base_interval: timedelta = betterproto.message_field(1)
    """
    Specifies the base interval between retries. This parameter is required and
    must be greater than zero. Values less than 1 ms are rounded up to 1 ms.
    See :ref:`config_http_filters_router_x-envoy-max-retries` for a discussion
    of Envoy's back-off algorithm.
    """

    max_interval: timedelta = betterproto.message_field(2)
    """
    Specifies the maximum interval between retries. This parameter is optional,
    but must be greater than or equal to the ``base_interval`` if set. The
    default is 10 times the ``base_interval``. See
    :ref:`config_http_filters_router_x-envoy-max-retries` for a discussion of
    Envoy's back-off algorithm.
    """


@dataclass(eq=False, repr=False)
class RetryPolicyResetHeader(betterproto.Message):
    name: str = betterproto.string_field(1)
    """
    The name of the reset header. .. note::   If the header appears multiple
    times only the first value is used.
    """

    format: "RetryPolicyResetHeaderFormat" = betterproto.enum_field(2)
    """The format of the reset header."""


@dataclass(eq=False, repr=False)
class RetryPolicyRateLimitedRetryBackOff(betterproto.Message):
    """
    A retry back-off strategy that applies when the upstream server rate limits
    the request. Given this configuration: .. code-block:: yaml
    rate_limited_retry_back_off:     reset_headers:     - name: Retry-After
    format: SECONDS     - name: X-RateLimit-Reset       format: UNIX_TIMESTAMP
    max_interval: "300s" The following algorithm will apply:  1. If the
    response contains the header ``Retry-After`` its value must be on     the
    form ``120`` (an integer that represents the number of seconds to     wait
    before retrying). If so, this value is used as the back-off interval.  2.
    Otherwise, if the response contains the header ``X-RateLimit-Reset`` its
    value must be on the form ``1595320702`` (an integer that represents the
    point in time at which to retry, as a Unix timestamp in seconds). If so,
    the current time is subtracted from this value and the result is used as
    the back-off interval.  3. Otherwise, Envoy will use the default
    :ref:`exponential back-off
    <envoy_v3_api_field_config.route.v3.RetryPolicy.retry_back_off>`
    strategy. No matter which format is used, if the resulting back-off
    interval exceeds ``max_interval`` it is discarded and the next header in
    ``reset_headers`` is tried. If a request timeout is configured for the
    route it will further limit how long the request will be allowed to run. To
    prevent many clients retrying at the same point in time jitter is added to
    the back-off interval, so the resulting interval is decided by taking:
    ``random(interval, interval * 1.5)``. .. attention::   Configuring
    ``rate_limited_retry_back_off`` will not by itself cause a request   to be
    retried. You will still need to configure the right retry policy to match
    the responses from the upstream server.
    """

    reset_headers: List["RetryPolicyResetHeader"] = betterproto.message_field(1)
    """
    Specifies the reset headers (like ``Retry-After`` or ``X-RateLimit-Reset``)
    to match against the response. Headers are tried in order, and matched case
    insensitive. The first header to be parsed successfully is used. If no
    headers match the default exponential back-off is used instead.
    """

    max_interval: timedelta = betterproto.message_field(2)
    """
    Specifies the maximum back off interval that Envoy will allow. If a reset
    header contains an interval longer than this then it will be discarded and
    the next header will be tried. Defaults to 300 seconds.
    """


@dataclass(eq=False, repr=False)
class HedgePolicy(betterproto.Message):
    """
    HTTP request hedging :ref:`architecture overview
    <arch_overview_http_routing_hedging>`.
    """

    initial_requests: Optional[int] = betterproto.message_field(
        1, wraps=betterproto.TYPE_UINT32
    )
    """
    Specifies the number of initial requests that should be sent upstream. Must
    be at least 1. Defaults to 1. [#not-implemented-hide:]
    """

    additional_request_chance: "___type_v3__.FractionalPercent" = (
        betterproto.message_field(2)
    )
    """
    Specifies a probability that an additional upstream request should be sent
    on top of what is specified by initial_requests. Defaults to 0. [#not-
    implemented-hide:]
    """

    hedge_on_per_try_timeout: bool = betterproto.bool_field(3)
    """
    Indicates that a hedged request should be sent when the per-try timeout is
    hit. This means that a retry will be issued without resetting the original
    request, leaving multiple upstream requests in flight. The first request to
    complete successfully will be the one returned to the caller. * At any
    time, a successful response (i.e. not triggering any of the retry-on
    conditions) would be returned to the client. * Before per-try timeout, an
    error response (per retry-on conditions) would be retried immediately or
    returned ot the client   if there are no more retries left. * After per-try
    timeout, an error response would be discarded, as a retry in the form of a
    hedged request is already in progress. Note: For this to have effect, you
    must have a :ref:`RetryPolicy
    <envoy_v3_api_msg_config.route.v3.RetryPolicy>` that retries at least one
    error code and specifies a maximum number of retries. Defaults to false.
    """


@dataclass(eq=False, repr=False)
class RedirectAction(betterproto.Message):
    """[#next-free-field: 10]"""

    https_redirect: bool = betterproto.bool_field(4, group="scheme_rewrite_specifier")
    """The scheme portion of the URL will be swapped with "https"."""

    scheme_redirect: str = betterproto.string_field(7, group="scheme_rewrite_specifier")
    """The scheme portion of the URL will be swapped with this value."""

    host_redirect: str = betterproto.string_field(1)
    """The host portion of the URL will be swapped with this value."""

    port_redirect: int = betterproto.uint32_field(8)
    """The port value of the URL will be swapped with this value."""

    path_redirect: str = betterproto.string_field(2, group="path_rewrite_specifier")
    """
    The path portion of the URL will be swapped with this value. Please note
    that query string in path_redirect will override the request's query string
    and will not be stripped. For example, let's say we have the following
    routes: - match: { path: "/old-path-1" }   redirect: { path_redirect:
    "/new-path-1" } - match: { path: "/old-path-2" }   redirect: {
    path_redirect: "/new-path-2", strip-query: "true" } - match: { path: "/old-
    path-3" }   redirect: { path_redirect: "/new-path-3?foo=1", strip_query:
    "true" } 1. if request uri is "/old-path-1?bar=1", users will be redirected
    to "/new-path-1?bar=1" 2. if request uri is "/old-path-2?bar=1", users will
    be redirected to "/new-path-2" 3. if request uri is "/old-path-3?bar=1",
    users will be redirected to "/new-path-3?foo=1"
    """

    prefix_rewrite: str = betterproto.string_field(5, group="path_rewrite_specifier")
    """
    Indicates that during redirection, the matched prefix (or path) should be
    swapped with this value. This option allows redirect URLs be dynamically
    created based on the request. .. attention::   Pay attention to the use of
    trailing slashes as mentioned in   :ref:`RouteAction's prefix_rewrite
    <envoy_v3_api_field_config.route.v3.RouteAction.prefix_rewrite>`.
    """

    regex_rewrite: "___type_matcher_v3__.RegexMatchAndSubstitute" = (
        betterproto.message_field(9, group="path_rewrite_specifier")
    )
    """
    Indicates that during redirect, portions of the path that match the pattern
    should be rewritten, even allowing the substitution of capture groups from
    the pattern into the new path as specified by the rewrite substitution
    string. This is useful to allow application paths to be rewritten in a way
    that is aware of segments with variable content like identifiers. Examples
    using Google's `RE2 <https://github.com/google/re2>`_ engine: * The path
    pattern ``^/service/([^/]+)(/.*)$`` paired with a substitution   string of
    ``\2/instance/\1`` would transform ``/service/foo/v1/api``   into
    ``/v1/api/instance/foo``. * The pattern ``one`` paired with a substitution
    string of ``two`` would   transform ``/xxx/one/yyy/one/zzz`` into
    ``/xxx/two/yyy/two/zzz``. * The pattern ``^(.*?)one(.*)$`` paired with a
    substitution string of   ``\1two\2`` would replace only the first
    occurrence of ``one``,   transforming path ``/xxx/one/yyy/one/zzz`` into
    ``/xxx/two/yyy/one/zzz``. * The pattern ``(?i)/xxx/`` paired with a
    substitution string of ``/yyy/``   would do a case-insensitive match and
    transform path ``/aaa/XxX/bbb`` to   ``/aaa/yyy/bbb``.
    """

    response_code: "RedirectActionRedirectResponseCode" = betterproto.enum_field(3)
    """
    The HTTP status code to use in the redirect response. The default response
    code is MOVED_PERMANENTLY (301).
    """

    strip_query: bool = betterproto.bool_field(6)
    """
    Indicates that during redirection, the query portion of the URL will be
    removed. Default value is false.
    """


@dataclass(eq=False, repr=False)
class DirectResponseAction(betterproto.Message):
    status: int = betterproto.uint32_field(1)
    """Specifies the HTTP response status to be returned."""

    body: "__core_v3__.DataSource" = betterproto.message_field(2)
    """
    Specifies the content of the response body. If this setting is omitted, no
    body is included in the generated response. .. note::   Headers can be
    specified using ``response_headers_to_add`` in the enclosing
    :ref:`envoy_v3_api_msg_config.route.v3.Route`,
    :ref:`envoy_v3_api_msg_config.route.v3.RouteConfiguration` or
    :ref:`envoy_v3_api_msg_config.route.v3.VirtualHost`.
    """


@dataclass(eq=False, repr=False)
class NonForwardingAction(betterproto.Message):
    """[#not-implemented-hide:]"""

    pass


@dataclass(eq=False, repr=False)
class Decorator(betterproto.Message):
    operation: str = betterproto.string_field(1)
    """
    The operation name associated with the request matched to this route. If
    tracing is enabled, this information will be used as the span name reported
    for this request. .. note::   For ingress (inbound) requests, or egress
    (outbound) responses, this value may be overridden   by the :ref:`x-envoy-
    decorator-operation   <config_http_filters_router_x-envoy-decorator-
    operation>` header.
    """

    propagate: Optional[bool] = betterproto.message_field(
        2, wraps=betterproto.TYPE_BOOL
    )
    """
    Whether the decorated details should be propagated to the other party. The
    default is true.
    """


@dataclass(eq=False, repr=False)
class Tracing(betterproto.Message):
    client_sampling: "___type_v3__.FractionalPercent" = betterproto.message_field(1)
    """
    Target percentage of requests managed by this HTTP connection manager that
    will be force traced if the :ref:`x-client-trace-id
    <config_http_conn_man_headers_x-client-trace-id>` header is set. This field
    is a direct analog for the runtime variable 'tracing.client_sampling' in
    the :ref:`HTTP Connection Manager <config_http_conn_man_runtime>`. Default:
    100%
    """

    random_sampling: "___type_v3__.FractionalPercent" = betterproto.message_field(2)
    """
    Target percentage of requests managed by this HTTP connection manager that
    will be randomly selected for trace generation, if not requested by the
    client or not forced. This field is a direct analog for the runtime
    variable 'tracing.random_sampling' in the :ref:`HTTP Connection Manager
    <config_http_conn_man_runtime>`. Default: 100%
    """

    overall_sampling: "___type_v3__.FractionalPercent" = betterproto.message_field(3)
    """
    Target percentage of requests managed by this HTTP connection manager that
    will be traced after all other sampling checks have been applied (client-
    directed, force tracing, random sampling). This field functions as an upper
    limit on the total configured sampling rate. For instance, setting
    client_sampling to 100% but overall_sampling to 1% will result in only 1%
    of client requests with the appropriate headers to be force traced. This
    field is a direct analog for the runtime variable 'tracing.global_enabled'
    in the :ref:`HTTP Connection Manager <config_http_conn_man_runtime>`.
    Default: 100%
    """

    custom_tags: List["___type_tracing_v3__.CustomTag"] = betterproto.message_field(4)
    """
    A list of custom tags with unique tag name to create tags for the active
    span. It will take effect after merging with the :ref:`corresponding
    configuration <envoy_v3_api_field_extensions.filters.network.http_connectio
    n_manager.v3.HttpConnectionManager.Tracing.custom_tags>` configured in the
    HTTP connection manager. If two tags with the same name are configured each
    in the HTTP connection manager and the route level, the one configured here
    takes priority.
    """


@dataclass(eq=False, repr=False)
class VirtualCluster(betterproto.Message):
    """
    A virtual cluster is a way of specifying a regex matching rule against
    certain important endpoints such that statistics are generated explicitly
    for the matched requests. The reason this is useful is that when doing
    prefix/path matching Envoy does not always know what the application
    considers to be an endpoint. Thus, it’s impossible for Envoy to generically
    emit per endpoint statistics. However, often systems have highly critical
    endpoints that they wish to get “perfect” statistics on. Virtual cluster
    statistics are perfect in the sense that they are emitted on the downstream
    side such that they include network level failures. Documentation for
    :ref:`virtual cluster statistics
    <config_http_filters_router_vcluster_stats>`. .. note::    Virtual clusters
    are a useful tool, but we do not recommend setting up a virtual cluster for
    every application endpoint. This is both not easily maintainable and as
    well the matching and    statistics output are not free.
    """

    headers: List["HeaderMatcher"] = betterproto.message_field(4)
    """
    Specifies a list of header matchers to use for matching requests. Each
    specified header must match. The pseudo-headers ``:path`` and ``:method``
    can be used to match the request path and method, respectively.
    """

    name: str = betterproto.string_field(2)
    """
    Specifies the name of the virtual cluster. The virtual cluster name as well
    as the virtual host name are used when emitting statistics. The statistics
    are emitted by the router filter and are documented :ref:`here
    <config_http_filters_router_stats>`.
    """


@dataclass(eq=False, repr=False)
class RateLimit(betterproto.Message):
    """
    Global rate limiting :ref:`architecture overview
    <arch_overview_global_rate_limit>`. Also applies to Local rate limiting
    :ref:`using descriptors
    <config_http_filters_local_rate_limit_descriptors>`.
    """

    stage: Optional[int] = betterproto.message_field(1, wraps=betterproto.TYPE_UINT32)
    """
    Refers to the stage set in the filter. The rate limit configuration only
    applies to filters with the same stage number. The default stage number is
    0. .. note::   The filter supports a range of 0 - 10 inclusively for stage
    numbers.
    """

    disable_key: str = betterproto.string_field(2)
    """
    The key to be set in runtime to disable this rate limit configuration.
    """

    actions: List["RateLimitAction"] = betterproto.message_field(3)
    """
    A list of actions that are to be applied for this rate limit configuration.
    Order matters as the actions are processed sequentially and the descriptor
    is composed by appending descriptor entries in that sequence. If an action
    cannot append a descriptor entry, no descriptor is generated for the
    configuration. See :ref:`composing actions
    <config_http_filters_rate_limit_composing_actions>` for additional
    documentation.
    """

    limit: "RateLimitOverride" = betterproto.message_field(4)
    """
    An optional limit override to be appended to the descriptor produced by
    this rate limit configuration. If the override value is invalid or cannot
    be resolved from metadata, no override is provided. See :ref:`rate limit
    override <config_http_filters_rate_limit_rate_limit_override>` for more
    information.
    """


@dataclass(eq=False, repr=False)
class RateLimitAction(betterproto.Message):
    """[#next-free-field: 11]"""

    source_cluster: "RateLimitActionSourceCluster" = betterproto.message_field(
        1, group="action_specifier"
    )
    """Rate limit on source cluster."""

    destination_cluster: "RateLimitActionDestinationCluster" = (
        betterproto.message_field(2, group="action_specifier")
    )
    """Rate limit on destination cluster."""

    request_headers: "RateLimitActionRequestHeaders" = betterproto.message_field(
        3, group="action_specifier"
    )
    """Rate limit on request headers."""

    remote_address: "RateLimitActionRemoteAddress" = betterproto.message_field(
        4, group="action_specifier"
    )
    """Rate limit on remote address."""

    generic_key: "RateLimitActionGenericKey" = betterproto.message_field(
        5, group="action_specifier"
    )
    """Rate limit on a generic key."""

    header_value_match: "RateLimitActionHeaderValueMatch" = betterproto.message_field(
        6, group="action_specifier"
    )
    """Rate limit on the existence of request headers."""

    dynamic_metadata: "RateLimitActionDynamicMetaData" = betterproto.message_field(
        7, group="action_specifier"
    )
    """
    Rate limit on dynamic metadata. .. attention::   This field has been
    deprecated in favor of the :ref:`metadata
    <envoy_v3_api_field_config.route.v3.RateLimit.Action.metadata>` field
    """

    metadata: "RateLimitActionMetaData" = betterproto.message_field(
        8, group="action_specifier"
    )
    """Rate limit on metadata."""

    extension: "__core_v3__.TypedExtensionConfig" = betterproto.message_field(
        9, group="action_specifier"
    )
    """
    Rate limit descriptor extension. See the rate limit descriptor extensions
    documentation. :ref:`HTTP matching input functions
    <arch_overview_matching_api>` are permitted as descriptor extensions. The
    input functions are only looked up if there is no rate limit descriptor
    extension matching the type URL. [#extension-category:
    envoy.rate_limit_descriptors]
    """

    masked_remote_address: "RateLimitActionMaskedRemoteAddress" = (
        betterproto.message_field(10, group="action_specifier")
    )
    """Rate limit on masked remote address."""

    def __post_init__(self) -> None:
        super().__post_init__()
        if self.is_set("dynamic_metadata"):
            warnings.warn(
                "RateLimitAction.dynamic_metadata is deprecated", DeprecationWarning
            )


@dataclass(eq=False, repr=False)
class RateLimitActionSourceCluster(betterproto.Message):
    """
    The following descriptor entry is appended to the descriptor: .. code-
    block:: cpp   ("source_cluster", "<local service cluster>") <local service
    cluster> is derived from the :option:`--service-cluster` option.
    """

    pass


@dataclass(eq=False, repr=False)
class RateLimitActionDestinationCluster(betterproto.Message):
    """
    The following descriptor entry is appended to the descriptor: .. code-
    block:: cpp   ("destination_cluster", "<routed target cluster>") Once a
    request matches against a route table rule, a routed cluster is determined
    by one of the following :ref:`route table configuration
    <envoy_v3_api_msg_config.route.v3.RouteConfiguration>` settings: *
    :ref:`cluster <envoy_v3_api_field_config.route.v3.RouteAction.cluster>`
    indicates the upstream cluster   to route to. * :ref:`weighted_clusters
    <envoy_v3_api_field_config.route.v3.RouteAction.weighted_clusters>`
    chooses a cluster randomly from a set of clusters with attributed weight. *
    :ref:`cluster_header
    <envoy_v3_api_field_config.route.v3.RouteAction.cluster_header>` indicates
    which   header in the request contains the target cluster.
    """

    pass


@dataclass(eq=False, repr=False)
class RateLimitActionRequestHeaders(betterproto.Message):
    """
    The following descriptor entry is appended when a header contains a key
    that matches the ``header_name``: .. code-block:: cpp
    ("<descriptor_key>", "<header_value_queried_from_header>")
    """

    header_name: str = betterproto.string_field(1)
    """
    The header name to be queried from the request headers. The header’s value
    is used to populate the value of the descriptor entry for the
    descriptor_key.
    """

    descriptor_key: str = betterproto.string_field(2)
    """The key to use in the descriptor entry."""

    skip_if_absent: bool = betterproto.bool_field(3)
    """
    If set to true, Envoy skips the descriptor while calling rate limiting
    service when header is not present in the request. By default it skips
    calling the rate limiting service if this header is not present in the
    request.
    """


@dataclass(eq=False, repr=False)
class RateLimitActionRemoteAddress(betterproto.Message):
    """
    The following descriptor entry is appended to the descriptor and is
    populated using the trusted address from :ref:`x-forwarded-for
    <config_http_conn_man_headers_x-forwarded-for>`: .. code-block:: cpp
    ("remote_address", "<trusted address from x-forwarded-for>")
    """

    pass


@dataclass(eq=False, repr=False)
class RateLimitActionMaskedRemoteAddress(betterproto.Message):
    """
    The following descriptor entry is appended to the descriptor and is
    populated using the masked address from :ref:`x-forwarded-for
    <config_http_conn_man_headers_x-forwarded-for>`: .. code-block:: cpp
    ("masked_remote_address", "<masked address from x-forwarded-for>")
    """

    v4_prefix_mask_len: Optional[int] = betterproto.message_field(
        1, wraps=betterproto.TYPE_UINT32
    )
    """
    Length of prefix mask len for IPv4 (e.g. 0, 32). Defaults to 32 when unset.
    For example, trusted address from x-forwarded-for is ``192.168.1.1``, the
    descriptor entry is ("masked_remote_address", "192.168.1.1/32"); if mask
    len is 24, the descriptor entry is ("masked_remote_address",
    "192.168.1.0/24").
    """

    v6_prefix_mask_len: Optional[int] = betterproto.message_field(
        2, wraps=betterproto.TYPE_UINT32
    )
    """
    Length of prefix mask len for IPv6 (e.g. 0, 128). Defaults to 128 when
    unset. For example, trusted address from x-forwarded-for is
    ``2001:abcd:ef01:2345:6789:abcd:ef01:234``, the descriptor entry is
    ("masked_remote_address", "2001:abcd:ef01:2345:6789:abcd:ef01:234/128"); if
    mask len is 64, the descriptor entry is ("masked_remote_address",
    "2001:abcd:ef01:2345::/64").
    """


@dataclass(eq=False, repr=False)
class RateLimitActionGenericKey(betterproto.Message):
    """
    The following descriptor entry is appended to the descriptor: .. code-
    block:: cpp   ("generic_key", "<descriptor_value>")
    """

    descriptor_value: str = betterproto.string_field(1)
    """The value to use in the descriptor entry."""

    descriptor_key: str = betterproto.string_field(2)
    """
    An optional key to use in the descriptor entry. If not set it defaults to
    'generic_key' as the descriptor key.
    """


@dataclass(eq=False, repr=False)
class RateLimitActionHeaderValueMatch(betterproto.Message):
    """
    The following descriptor entry is appended to the descriptor: .. code-
    block:: cpp   ("header_match", "<descriptor_value>")
    """

    descriptor_key: str = betterproto.string_field(4)
    """
    The key to use in the descriptor entry. Defaults to ``header_match``.
    """

    descriptor_value: str = betterproto.string_field(1)
    """The value to use in the descriptor entry."""

    expect_match: Optional[bool] = betterproto.message_field(
        2, wraps=betterproto.TYPE_BOOL
    )
    """
    If set to true, the action will append a descriptor entry when the request
    matches the headers. If set to false, the action will append a descriptor
    entry when the request does not match the headers. The default value is
    true.
    """

    headers: List["HeaderMatcher"] = betterproto.message_field(3)
    """
    Specifies a set of headers that the rate limit action should match on. The
    action will check the request’s headers against all the specified headers
    in the config. A match will happen if all the headers in the config are
    present in the request with the same values (or based on presence if the
    value field is not in the config).
    """


@dataclass(eq=False, repr=False)
class RateLimitActionDynamicMetaData(betterproto.Message):
    """
    The following descriptor entry is appended when the :ref:`dynamic metadata
    <well_known_dynamic_metadata>` contains a key value: .. code-block:: cpp
    ("<descriptor_key>", "<value_queried_from_dynamic_metadata>") ..
    attention::   This action has been deprecated in favor of the
    :ref:`metadata
    <envoy_v3_api_msg_config.route.v3.RateLimit.Action.MetaData>` action
    """

    descriptor_key: str = betterproto.string_field(1)
    """The key to use in the descriptor entry."""

    metadata_key: "___type_metadata_v3__.MetadataKey" = betterproto.message_field(2)
    """
    Metadata struct that defines the key and path to retrieve the string value.
    A match will only happen if the value in the dynamic metadata is of type
    string.
    """

    default_value: str = betterproto.string_field(3)
    """
    An optional value to use if ``metadata_key`` is empty. If not set and no
    value is present under the metadata_key then no descriptor is generated.
    """


@dataclass(eq=False, repr=False)
class RateLimitActionMetaData(betterproto.Message):
    """
    The following descriptor entry is appended when the metadata contains a key
    value: .. code-block:: cpp   ("<descriptor_key>",
    "<value_queried_from_metadata>")
    """

    descriptor_key: str = betterproto.string_field(1)
    """The key to use in the descriptor entry."""

    metadata_key: "___type_metadata_v3__.MetadataKey" = betterproto.message_field(2)
    """
    Metadata struct that defines the key and path to retrieve the string value.
    A match will only happen if the value in the metadata is of type string.
    """

    default_value: str = betterproto.string_field(3)
    """
    An optional value to use if ``metadata_key`` is empty. If not set and no
    value is present under the metadata_key then no descriptor is generated.
    """

    source: "RateLimitActionMetaDataSource" = betterproto.enum_field(4)
    """Source of metadata"""


@dataclass(eq=False, repr=False)
class RateLimitOverride(betterproto.Message):
    dynamic_metadata: "RateLimitOverrideDynamicMetadata" = betterproto.message_field(
        1, group="override_specifier"
    )
    """Limit override from dynamic metadata."""


@dataclass(eq=False, repr=False)
class RateLimitOverrideDynamicMetadata(betterproto.Message):
    """Fetches the override from the dynamic metadata."""

    metadata_key: "___type_metadata_v3__.MetadataKey" = betterproto.message_field(1)
    """
    Metadata struct that defines the key and path to retrieve the struct value.
    The value must be a struct containing an integer "requests_per_unit"
    property and a "unit" property with a value parseable to
    :ref:`RateLimitUnit enum <envoy_v3_api_enum_type.v3.RateLimitUnit>`
    """


@dataclass(eq=False, repr=False)
class HeaderMatcher(betterproto.Message):
    """
    .. attention::   Internally, Envoy always uses the HTTP/2 ``:authority``
    header to represent the HTTP/1 ``Host``   header. Thus, if attempting to
    match on ``Host``, match on ``:authority`` instead. .. attention::   To
    route on HTTP method, use the special HTTP/2 ``:method`` header. This works
    for both   HTTP/1 and HTTP/2 as Envoy normalizes headers. E.g.,   .. code-
    block:: json     {       "name": ":method",       "exact_match": "POST"
    } .. attention::   In the absence of any header match specifier, match will
    default to :ref:`present_match
    <envoy_v3_api_field_config.route.v3.HeaderMatcher.present_match>`. i.e, a
    request that has the :ref:`name
    <envoy_v3_api_field_config.route.v3.HeaderMatcher.name>` header will match,
    regardless of the header's   value.  [#next-major-version: HeaderMatcher
    should be refactored to use StringMatcher.] [#next-free-field: 15]
    """

    name: str = betterproto.string_field(1)
    """Specifies the name of the header in the request."""

    exact_match: str = betterproto.string_field(4, group="header_match_specifier")
    """
    If specified, header match will be performed based on the value of the
    header. This field is deprecated. Please use :ref:`string_match
    <envoy_v3_api_field_config.route.v3.HeaderMatcher.string_match>`.
    """

    safe_regex_match: "___type_matcher_v3__.RegexMatcher" = betterproto.message_field(
        11, group="header_match_specifier"
    )
    """
    If specified, this regex string is a regular expression rule which implies
    the entire request header value must match the regex. The rule will not
    match if only a subsequence of the request header value matches the regex.
    This field is deprecated. Please use :ref:`string_match
    <envoy_v3_api_field_config.route.v3.HeaderMatcher.string_match>`.
    """

    range_match: "___type_v3__.Int64Range" = betterproto.message_field(
        6, group="header_match_specifier"
    )
    """
    If specified, header match will be performed based on range. The rule will
    match if the request header value is within this range. The entire request
    header value must represent an integer in base 10 notation: consisting of
    an optional plus or minus sign followed by a sequence of digits. The rule
    will not match if the header value does not represent an integer. Match
    will fail for empty values, floating point numbers or if only a subsequence
    of the header value is an integer. Examples: * For range [-10,0), route
    will match for header value -1, but not for 0, ``somestring``, 10.9,
    ``-1somestring``
    """

    present_match: bool = betterproto.bool_field(7, group="header_match_specifier")
    """
    If specified as true, header match will be performed based on whether the
    header is in the request. If specified as false, header match will be
    performed based on whether the header is absent.
    """

    prefix_match: str = betterproto.string_field(9, group="header_match_specifier")
    """
    If specified, header match will be performed based on the prefix of the
    header value. Note: empty prefix is not allowed, please use present_match
    instead. This field is deprecated. Please use :ref:`string_match
    <envoy_v3_api_field_config.route.v3.HeaderMatcher.string_match>`. Examples:
    * The prefix ``abcd`` matches the value ``abcdxyz``, but not for
    ``abcxyz``.
    """

    suffix_match: str = betterproto.string_field(10, group="header_match_specifier")
    """
    If specified, header match will be performed based on the suffix of the
    header value. Note: empty suffix is not allowed, please use present_match
    instead. This field is deprecated. Please use :ref:`string_match
    <envoy_v3_api_field_config.route.v3.HeaderMatcher.string_match>`. Examples:
    * The suffix ``abcd`` matches the value ``xyzabcd``, but not for
    ``xyzbcd``.
    """

    contains_match: str = betterproto.string_field(12, group="header_match_specifier")
    """
    If specified, header match will be performed based on whether the header
    value contains the given value or not. Note: empty contains match is not
    allowed, please use present_match instead. This field is deprecated. Please
    use :ref:`string_match
    <envoy_v3_api_field_config.route.v3.HeaderMatcher.string_match>`. Examples:
    * The value ``abcd`` matches the value ``xyzabcdpqr``, but not for
    ``xyzbcdpqr``.
    """

    string_match: "___type_matcher_v3__.StringMatcher" = betterproto.message_field(
        13, group="header_match_specifier"
    )
    """
    If specified, header match will be performed based on the string match of
    the header value.
    """

    invert_match: bool = betterproto.bool_field(8)
    """
    If specified, the match result will be inverted before checking. Defaults
    to false. Examples: * The regex ``\d{3}`` does not match the value
    ``1234``, so it will match when inverted. * The range [-10,0) will match
    the value -1, so it will not match when inverted.
    """

    treat_missing_header_as_empty: bool = betterproto.bool_field(14)
    """
    If specified, for any header match rule, if the header match rule specified
    header does not exist, this header value will be treated as empty. Defaults
    to false. Examples: * The header match rule specified header "header1" to
    range match of [0, 10],   :ref:`invert_match
    <envoy_v3_api_field_config.route.v3.HeaderMatcher.invert_match>`   is set
    to true and :ref:`treat_missing_header_as_empty <envoy_v3_api_field_config.
    route.v3.HeaderMatcher.treat_missing_header_as_empty>`   is set to true;
    The "header1" header is not present. The match rule will   treat the
    "header1" as an empty header. The empty header does not match the range,
    so it will match when inverted. * The header match rule specified header
    "header2" to range match of [0, 10],   :ref:`invert_match
    <envoy_v3_api_field_config.route.v3.HeaderMatcher.invert_match>`   is set
    to true and :ref:`treat_missing_header_as_empty <envoy_v3_api_field_config.
    route.v3.HeaderMatcher.treat_missing_header_as_empty>`   is set to false;
    The "header2" header is not present and the header   matcher rule for
    "header2" will be ignored so it will not match. * The header match rule
    specified header "header3" to a string regex match   ``^$`` which means an
    empty string, and   :ref:`treat_missing_header_as_empty <envoy_v3_api_field
    _config.route.v3.HeaderMatcher.treat_missing_header_as_empty>`   is set to
    true; The "header3" header is not present.   The match rule will treat the
    "header3" header as an empty header so it will match. * The header match
    rule specified header "header4" to a string regex match   ``^$`` which
    means an empty string, and   :ref:`treat_missing_header_as_empty <envoy_v3_
    api_field_config.route.v3.HeaderMatcher.treat_missing_header_as_empty>`
    is set to false; The "header4" header is not present.   The match rule for
    "header4" will be ignored so it will not match.
    """

    def __post_init__(self) -> None:
        super().__post_init__()
        if self.is_set("exact_match"):
            warnings.warn("HeaderMatcher.exact_match is deprecated", DeprecationWarning)
        if self.is_set("safe_regex_match"):
            warnings.warn(
                "HeaderMatcher.safe_regex_match is deprecated", DeprecationWarning
            )
        if self.is_set("prefix_match"):
            warnings.warn(
                "HeaderMatcher.prefix_match is deprecated", DeprecationWarning
            )
        if self.is_set("suffix_match"):
            warnings.warn(
                "HeaderMatcher.suffix_match is deprecated", DeprecationWarning
            )
        if self.is_set("contains_match"):
            warnings.warn(
                "HeaderMatcher.contains_match is deprecated", DeprecationWarning
            )


@dataclass(eq=False, repr=False)
class QueryParameterMatcher(betterproto.Message):
    """
    Query parameter matching treats the query string of a request's :path
    header as an ampersand-separated list of keys and/or key=value elements.
    [#next-free-field: 7]
    """

    name: str = betterproto.string_field(1)
    """
    Specifies the name of a key that must be present in the requested
    ``path``'s query string.
    """

    string_match: "___type_matcher_v3__.StringMatcher" = betterproto.message_field(
        5, group="query_parameter_match_specifier"
    )
    """
    Specifies whether a query parameter value should match against a string.
    """

    present_match: bool = betterproto.bool_field(
        6, group="query_parameter_match_specifier"
    )
    """Specifies whether a query parameter should be present."""


@dataclass(eq=False, repr=False)
class InternalRedirectPolicy(betterproto.Message):
    """
    HTTP Internal Redirect :ref:`architecture overview
    <arch_overview_internal_redirects>`.
    """

    max_internal_redirects: Optional[int] = betterproto.message_field(
        1, wraps=betterproto.TYPE_UINT32
    )
    """
    An internal redirect is not handled, unless the number of previous internal
    redirects that a downstream request has encountered is lower than this
    value. In the case where a downstream request is bounced among multiple
    routes by internal redirect, the first route that hits this threshold, or
    does not set :ref:`internal_redirect_policy
    <envoy_v3_api_field_config.route.v3.RouteAction.internal_redirect_policy>`
    will pass the redirect back to downstream. If not specified, at most one
    redirect will be followed.
    """

    redirect_response_codes: List[int] = betterproto.uint32_field(2)
    """
    Defines what upstream response codes are allowed to trigger internal
    redirect. If unspecified, only 302 will be treated as internal redirect.
    Only 301, 302, 303, 307 and 308 are valid values. Any other codes will be
    ignored.
    """

    predicates: List["__core_v3__.TypedExtensionConfig"] = betterproto.message_field(3)
    """
    Specifies a list of predicates that are queried when an upstream response
    is deemed to trigger an internal redirect by all other criteria. Any
    predicate in the list can reject the redirect, causing the response to be
    proxied to downstream. [#extension-category:
    envoy.internal_redirect_predicates]
    """

    allow_cross_scheme_redirect: bool = betterproto.bool_field(4)
    """
    Allow internal redirect to follow a target URI with a different scheme than
    the value of x-forwarded-proto. The default is false.
    """


@dataclass(eq=False, repr=False)
class FilterConfig(betterproto.Message):
    """
    A simple wrapper for an HTTP filter config. This is intended to be used as
    a wrapper for the map value in :ref:`VirtualHost.typed_per_filter_config<en
    voy_v3_api_field_config.route.v3.VirtualHost.typed_per_filter_config>`, :re
    f:`Route.typed_per_filter_config<envoy_v3_api_field_config.route.v3.Route.t
    yped_per_filter_config>`, or :ref:`WeightedCluster.ClusterWeight.typed_per_
    filter_config<envoy_v3_api_field_config.route.v3.WeightedCluster.ClusterWei
    ght.typed_per_filter_config>` to add additional flags to the filter. [#not-
    implemented-hide:]
    """

    config: "betterproto_lib_google_protobuf.Any" = betterproto.message_field(1)
    """The filter config."""

    is_optional: bool = betterproto.bool_field(2)
    """
    If true, the filter is optional, meaning that if the client does not
    support the specified filter, it may ignore the map entry rather than
    rejecting the config.
    """


@dataclass(eq=False, repr=False)
class RouteConfiguration(betterproto.Message):
    """[#next-free-field: 17]"""

    name: str = betterproto.string_field(1)
    """
    The name of the route configuration. For example, it might match
    :ref:`route_config_name <envoy_v3_api_field_extensions.filters.network.http
    _connection_manager.v3.Rds.route_config_name>` in :ref:`envoy_v3_api_msg_ex
    tensions.filters.network.http_connection_manager.v3.Rds`.
    """

    virtual_hosts: List["VirtualHost"] = betterproto.message_field(2)
    """An array of virtual hosts that make up the route table."""

    vhds: "Vhds" = betterproto.message_field(9)
    """
    An array of virtual hosts will be dynamically loaded via the VHDS API. Both
    ``virtual_hosts`` and ``vhds`` fields will be used when present.
    ``virtual_hosts`` can be used for a base routing table or for infrequently
    changing virtual hosts. ``vhds`` is used for on-demand discovery of virtual
    hosts. The contents of these two fields will be merged to generate a
    routing table for a given RouteConfiguration, with ``vhds`` derived
    configuration taking precedence.
    """

    internal_only_headers: List[str] = betterproto.string_field(3)
    """
    Optionally specifies a list of HTTP headers that the connection manager
    will consider to be internal only. If they are found on external requests
    they will be cleaned prior to filter invocation. See
    :ref:`config_http_conn_man_headers_x-envoy-internal` for more information.
    """

    response_headers_to_add: List[
        "__core_v3__.HeaderValueOption"
    ] = betterproto.message_field(4)
    """
    Specifies a list of HTTP headers that should be added to each response that
    the connection manager encodes. Headers specified at this level are applied
    after headers from any enclosed
    :ref:`envoy_v3_api_msg_config.route.v3.VirtualHost` or
    :ref:`envoy_v3_api_msg_config.route.v3.RouteAction`. For more information,
    including details on header value syntax, see the documentation on
    :ref:`custom request headers
    <config_http_conn_man_headers_custom_request_headers>`.
    """

    response_headers_to_remove: List[str] = betterproto.string_field(5)
    """
    Specifies a list of HTTP headers that should be removed from each response
    that the connection manager encodes.
    """

    request_headers_to_add: List[
        "__core_v3__.HeaderValueOption"
    ] = betterproto.message_field(6)
    """
    Specifies a list of HTTP headers that should be added to each request
    routed by the HTTP connection manager. Headers specified at this level are
    applied after headers from any enclosed
    :ref:`envoy_v3_api_msg_config.route.v3.VirtualHost` or
    :ref:`envoy_v3_api_msg_config.route.v3.RouteAction`. For more information,
    including details on header value syntax, see the documentation on
    :ref:`custom request headers
    <config_http_conn_man_headers_custom_request_headers>`.
    """

    request_headers_to_remove: List[str] = betterproto.string_field(8)
    """
    Specifies a list of HTTP headers that should be removed from each request
    routed by the HTTP connection manager.
    """

    most_specific_header_mutations_wins: bool = betterproto.bool_field(10)
    """
    By default, headers that should be added/removed are evaluated from most to
    least specific: * route level * virtual host level * connection manager
    level To allow setting overrides at the route or virtual host level, this
    order can be reversed by setting this option to true. Defaults to false.
    """

    validate_clusters: Optional[bool] = betterproto.message_field(
        7, wraps=betterproto.TYPE_BOOL
    )
    """
    An optional boolean that specifies whether the clusters that the route
    table refers to will be validated by the cluster manager. If set to true
    and a route refers to a non-existent cluster, the route table will not
    load. If set to false and a route refers to a non-existent cluster, the
    route table will load and the router filter will return a 404 if the route
    is selected at runtime. This setting defaults to true if the route table is
    statically defined via the :ref:`route_config <envoy_v3_api_field_extension
    s.filters.network.http_connection_manager.v3.HttpConnectionManager.route_co
    nfig>` option. This setting default to false if the route table is loaded
    dynamically via the :ref:`rds <envoy_v3_api_field_extensions.filters.networ
    k.http_connection_manager.v3.HttpConnectionManager.rds>` option. Users may
    wish to override the default behavior in certain cases (for example when
    using CDS with a static route table).
    """

    max_direct_response_body_size_bytes: Optional[int] = betterproto.message_field(
        11, wraps=betterproto.TYPE_UINT32
    )
    """
    The maximum bytes of the response :ref:`direct response body
    <envoy_v3_api_field_config.route.v3.DirectResponseAction.body>` size. If
    not specified the default is 4096. .. warning::   Envoy currently holds the
    content of :ref:`direct response body
    <envoy_v3_api_field_config.route.v3.DirectResponseAction.body>` in memory.
    Be careful setting   this to be larger than the default 4KB, since the
    allocated memory for direct response body   is not subject to data plane
    buffering controls.
    """

    cluster_specifier_plugins: List[
        "ClusterSpecifierPlugin"
    ] = betterproto.message_field(12)
    """
    A list of plugins and their configurations which may be used by a
    :ref:`cluster specifier plugin name
    <envoy_v3_api_field_config.route.v3.RouteAction.cluster_specifier_plugin>`
    within the route. All ``extension.name`` fields in this list must be
    unique.
    """

    request_mirror_policies: List[
        "RouteActionRequestMirrorPolicy"
    ] = betterproto.message_field(13)
    """
    Specify a set of default request mirroring policies which apply to all
    routes under its virtual hosts. Note that policies are not merged, the most
    specific non-empty one becomes the mirror policies.
    """

    ignore_port_in_host_matching: bool = betterproto.bool_field(14)
    """
    By default, port in :authority header (if any) is used in host matching.
    With this option enabled, Envoy will ignore the port number in the
    :authority header (if any) when picking VirtualHost. NOTE: this option will
    not strip the port number (if any) contained in route config
    :ref:`envoy_v3_api_msg_config.route.v3.VirtualHost`.domains field.
    """

    ignore_path_parameters_in_path_matching: bool = betterproto.bool_field(15)
    """
    Ignore path-parameters in path-matching. Before RFC3986, URI were
    like(RFC1808): <scheme>://<net_loc>/<path>;<params>?<query>#<fragment>
    Envoy by default takes ":path" as "<path>;<params>". For users who want to
    only match path on the "<path>" portion, this option should be true.
    """

    typed_per_filter_config: Dict[
        str, "betterproto_lib_google_protobuf.Any"
    ] = betterproto.map_field(16, betterproto.TYPE_STRING, betterproto.TYPE_MESSAGE)
    """
    The typed_per_filter_config field can be used to provide RouteConfiguration
    level per filter config. The key should match the :ref:`filter config name 
    <envoy_v3_api_field_extensions.filters.network.http_connection_manager.v3.H
    ttpFilter.name>`. The canonical filter name (e.g.,
    ``envoy.filters.http.buffer`` for the HTTP buffer filter) can also be used
    for the backwards compatibility. If there is no entry referred by the
    filter config name, the entry referred by the canonical filter name will be
    provided to the filters as fallback. Use of this field is filter specific;
    see the :ref:`HTTP filter documentation <config_http_filters>` for if and
    how it is utilized. [#comment: An entry's value may be wrapped in a
    :ref:`FilterConfig<envoy_v3_api_msg_config.route.v3.FilterConfig>` message
    to specify additional options.]
    """


@dataclass(eq=False, repr=False)
class Vhds(betterproto.Message):
    config_source: "__core_v3__.ConfigSource" = betterproto.message_field(1)
    """Configuration source specifier for VHDS."""


@dataclass(eq=False, repr=False)
class ScopedRouteConfiguration(betterproto.Message):
    """
    Specifies a routing scope, which associates a
    :ref:`Key<envoy_v3_api_msg_config.route.v3.ScopedRouteConfiguration.Key>`
    to a :ref:`envoy_v3_api_msg_config.route.v3.RouteConfiguration`. The
    :ref:`envoy_v3_api_msg_config.route.v3.RouteConfiguration` can be obtained
    dynamically via RDS (:ref:`route_configuration_name<envoy_v3_api_field_conf
    ig.route.v3.ScopedRouteConfiguration.route_configuration_name>`) or
    specified inline (:ref:`route_configuration<envoy_v3_api_field_config.route
    .v3.ScopedRouteConfiguration.route_configuration>`). The HTTP connection
    manager builds up a table consisting of these Key to RouteConfiguration
    mappings, and looks up the RouteConfiguration to use per request according
    to the algorithm specified in the :ref:`scope_key_builder<envoy_v3_api_fiel
    d_extensions.filters.network.http_connection_manager.v3.ScopedRoutes.scope_
    key_builder>` assigned to the HttpConnectionManager. For example, with the
    following configurations (in YAML): HttpConnectionManager config: .. code::
    ...   scoped_routes:     name: foo-scoped-routes     scope_key_builder:
    fragments:         - header_value_extractor:             name: X-Route-
    Selector             element_separator: ,             element:
    separator: =               key: vip ScopedRouteConfiguration resources
    (specified statically via :ref:`scoped_route_configurations_list<envoy_v3_a
    pi_field_extensions.filters.network.http_connection_manager.v3.ScopedRoutes
    .scoped_route_configurations_list>` or obtained dynamically via SRDS): ..
    code::  (1)   name: route-scope1   route_configuration_name: route-config1
    key:      fragments:        - string_key: 172.10.10.20  (2)   name: route-
    scope2   route_configuration_name: route-config2   key:     fragments:
    - string_key: 172.20.20.30 A request from a client such as: .. code::
    GET / HTTP/1.1     Host: foo.com     X-Route-Selector: vip=172.10.10.20
    would result in the routing table defined by the ``route-config1``
    RouteConfiguration being assigned to the HTTP request/stream. [#next-free-
    field: 6]
    """

    on_demand: bool = betterproto.bool_field(4)
    """Whether the RouteConfiguration should be loaded on demand."""

    name: str = betterproto.string_field(1)
    """The name assigned to the routing scope."""

    route_configuration_name: str = betterproto.string_field(2)
    """
    The resource name to use for a
    :ref:`envoy_v3_api_msg_service.discovery.v3.DiscoveryRequest` to an RDS
    server to fetch the
    :ref:`envoy_v3_api_msg_config.route.v3.RouteConfiguration` associated with
    this scope.
    """

    route_configuration: "RouteConfiguration" = betterproto.message_field(5)
    """
    The :ref:`envoy_v3_api_msg_config.route.v3.RouteConfiguration` associated
    with the scope.
    """

    key: "ScopedRouteConfigurationKey" = betterproto.message_field(3)
    """The key to match against."""


@dataclass(eq=False, repr=False)
class ScopedRouteConfigurationKey(betterproto.Message):
    """
    Specifies a key which is matched against the output of the :ref:`scope_key_
    builder<envoy_v3_api_field_extensions.filters.network.http_connection_manag
    er.v3.ScopedRoutes.scope_key_builder>` specified in the
    HttpConnectionManager. The matching is done per HTTP request and is
    dependent on the order of the fragments contained in the Key.
    """

    fragments: List["ScopedRouteConfigurationKeyFragment"] = betterproto.message_field(
        1
    )
    """
    The ordered set of fragments to match against. The order must match the
    fragments in the corresponding :ref:`scope_key_builder<envoy_v3_api_field_e
    xtensions.filters.network.http_connection_manager.v3.ScopedRoutes.scope_key
    _builder>`.
    """


@dataclass(eq=False, repr=False)
class ScopedRouteConfigurationKeyFragment(betterproto.Message):
    string_key: str = betterproto.string_field(1, group="type")
    """A string to match against."""
