# Generated by the protocol buffer compiler.  DO NOT EDIT!
# sources: envoy/config/overload/v3/overload.proto
# plugin: python-betterproto
from dataclasses import dataclass
from datetime import timedelta
from typing import List

import betterproto
import betterproto.lib.google.protobuf as betterproto_lib_google_protobuf

from ....type import v3 as ___type_v3__


class ScaleTimersOverloadActionConfigTimerType(betterproto.Enum):
    UNSPECIFIED = 0
    """
    Unsupported value; users must explicitly specify the timer they want
    scaled.
    """

    HTTP_DOWNSTREAM_CONNECTION_IDLE = 1
    """
    Adjusts the idle timer for downstream HTTP connections that takes effect
    when there are no active streams. This affects the value of
    :ref:`HttpConnectionManager.common_http_protocol_options.idle_timeout
    <envoy_v3_api_field_config.core.v3.HttpProtocolOptions.idle_timeout>`
    """

    HTTP_DOWNSTREAM_STREAM_IDLE = 2
    """
    Adjusts the idle timer for HTTP streams initiated by downstream clients.
    This affects the value of :ref:`RouteAction.idle_timeout
    <envoy_v3_api_field_config.route.v3.RouteAction.idle_timeout>` and
    :ref:`HttpConnectionManager.stream_idle_timeout <envoy_v3_api_field_extensi
    ons.filters.network.http_connection_manager.v3.HttpConnectionManager.stream
    _idle_timeout>`
    """

    TRANSPORT_SOCKET_CONNECT = 3
    """
    Adjusts the timer for how long downstream clients have to finish transport-
    level negotiations before the connection is closed. This affects the value
    of :ref:`FilterChain.transport_socket_connect_timeout <envoy_v3_api_field_c
    onfig.listener.v3.FilterChain.transport_socket_connect_timeout>`.
    """


@dataclass(eq=False, repr=False)
class ResourceMonitor(betterproto.Message):
    name: str = betterproto.string_field(1)
    """
    The name of the resource monitor to instantiate. Must match a registered
    resource monitor type. See the :ref:`extensions listed in typed_config
    below <extension_category_envoy.resource_monitors>` for the default list of
    available resource monitor.
    """

    typed_config: "betterproto_lib_google_protobuf.Any" = betterproto.message_field(
        3, group="config_type"
    )


@dataclass(eq=False, repr=False)
class ThresholdTrigger(betterproto.Message):
    value: float = betterproto.double_field(1)
    """
    If the resource pressure is greater than or equal to this value, the
    trigger will enter saturation.
    """


@dataclass(eq=False, repr=False)
class ScaledTrigger(betterproto.Message):
    scaling_threshold: float = betterproto.double_field(1)
    """
    If the resource pressure is greater than this value, the trigger will be in
    the :ref:`scaling <arch_overview_overload_manager-triggers-state>` state
    with value ``(pressure - scaling_threshold) / (saturation_threshold -
    scaling_threshold)``.
    """

    saturation_threshold: float = betterproto.double_field(2)
    """
    If the resource pressure is greater than this value, the trigger will enter
    saturation.
    """


@dataclass(eq=False, repr=False)
class Trigger(betterproto.Message):
    name: str = betterproto.string_field(1)
    """The name of the resource this is a trigger for."""

    threshold: "ThresholdTrigger" = betterproto.message_field(2, group="trigger_oneof")
    scaled: "ScaledTrigger" = betterproto.message_field(3, group="trigger_oneof")


@dataclass(eq=False, repr=False)
class ScaleTimersOverloadActionConfig(betterproto.Message):
    """
    Typed configuration for the "envoy.overload_actions.reduce_timeouts"
    action. See :ref:`the docs <config_overload_manager_reducing_timeouts>` for
    an example of how to configure the action with different timeouts and
    minimum values.
    """

    timer_scale_factors: List[
        "ScaleTimersOverloadActionConfigScaleTimer"
    ] = betterproto.message_field(1)
    """A set of timer scaling rules to be applied."""


@dataclass(eq=False, repr=False)
class ScaleTimersOverloadActionConfigScaleTimer(betterproto.Message):
    timer: "ScaleTimersOverloadActionConfigTimerType" = betterproto.enum_field(1)
    """The type of timer this minimum applies to."""

    min_timeout: timedelta = betterproto.message_field(2, group="overload_adjust")
    """Sets the minimum duration as an absolute value."""

    min_scale: "___type_v3__.Percent" = betterproto.message_field(
        3, group="overload_adjust"
    )
    """Sets the minimum duration as a percentage of the maximum value."""


@dataclass(eq=False, repr=False)
class OverloadAction(betterproto.Message):
    name: str = betterproto.string_field(1)
    """
    The name of the overload action. This is just a well-known string that
    listeners can use for registering callbacks. Custom overload actions should
    be named using reverse DNS to ensure uniqueness.
    """

    triggers: List["Trigger"] = betterproto.message_field(2)
    """
    A set of triggers for this action. The state of the action is the maximum
    state of all triggers, which can be scaling between 0 and 1 or saturated.
    Listeners are notified when the overload action changes state.
    """

    typed_config: "betterproto_lib_google_protobuf.Any" = betterproto.message_field(3)
    """Configuration for the action being instantiated."""


@dataclass(eq=False, repr=False)
class BufferFactoryConfig(betterproto.Message):
    """
    Configuration for which accounts the WatermarkBuffer Factories should
    track.
    """

    minimum_account_to_track_power_of_two: int = betterproto.uint32_field(1)
    """
    The minimum power of two at which Envoy starts tracking an account. Envoy
    has 8 power of two buckets starting with the provided exponent below.
    Concretely the 1st bucket contains accounts for streams that use
    [2^minimum_account_to_track_power_of_two,
    2^(minimum_account_to_track_power_of_two + 1)) bytes. With the 8th bucket
    tracking accounts >= 128 * 2^minimum_account_to_track_power_of_two. The
    maximum value is 56, since we're using uint64_t for bytes counting, and
    that's the last value that would use the 8 buckets. In practice, we don't
    expect the proxy to be holding 2^56 bytes. If omitted, Envoy should not do
    any tracking.
    """


@dataclass(eq=False, repr=False)
class OverloadManager(betterproto.Message):
    refresh_interval: timedelta = betterproto.message_field(1)
    """The interval for refreshing resource usage."""

    resource_monitors: List["ResourceMonitor"] = betterproto.message_field(2)
    """The set of resources to monitor."""

    actions: List["OverloadAction"] = betterproto.message_field(3)
    """The set of overload actions."""

    buffer_factory_config: "BufferFactoryConfig" = betterproto.message_field(4)
    """Configuration for buffer factory."""
