# Generated by the protocol buffer compiler.  DO NOT EDIT!
# sources: envoy/config/listener/v3/api_listener.proto, envoy/config/listener/v3/listener.proto, envoy/config/listener/v3/listener_components.proto, envoy/config/listener/v3/quic_config.proto, envoy/config/listener/v3/udp_listener_config.proto
# plugin: python-betterproto
import warnings
from dataclasses import dataclass
from datetime import timedelta
from typing import (
    List,
    Optional,
)

import betterproto
import betterproto.lib.google.protobuf as betterproto_lib_google_protobuf

from .....xds.core import v3 as ____xds_core_v3__
from .....xds.type.matcher import v3 as ____xds_type_matcher_v3__
from ....type import v3 as ___type_v3__
from ...accesslog import v3 as __accesslog_v3__
from ...core import v3 as __core_v3__


class FilterChainMatchConnectionSourceType(betterproto.Enum):
    ANY = 0
    """Any connection source matches."""

    SAME_IP_OR_LOOPBACK = 1
    """Match a connection originating from the same host."""

    EXTERNAL = 2
    """Match a connection originating from a different host."""


class ListenerDrainType(betterproto.Enum):
    DEFAULT = 0
    """
    Drain in response to calling /healthcheck/fail admin endpoint (along with
    the health check filter), listener removal/modification, and hot restart.
    """

    MODIFY_ONLY = 1
    """
    Drain in response to listener removal/modification and hot restart. This
    setting does not include /healthcheck/fail. This setting may be desirable
    if Envoy is hosting both ingress and egress listeners.
    """


@dataclass(eq=False, repr=False)
class Filter(betterproto.Message):
    """[#next-free-field: 6]"""

    name: str = betterproto.string_field(1)
    """The name of the filter configuration."""

    typed_config: "betterproto_lib_google_protobuf.Any" = betterproto.message_field(
        4, group="config_type"
    )
    """
    Filter specific configuration which depends on the filter being
    instantiated. See the supported filters for further documentation.
    [#extension-category: envoy.filters.network]
    """

    config_discovery: "__core_v3__.ExtensionConfigSource" = betterproto.message_field(
        5, group="config_type"
    )
    """
    Configuration source specifier for an extension configuration discovery
    service. In case of a failure and without the default configuration, the
    listener closes the connections. [#not-implemented-hide:]
    """


@dataclass(eq=False, repr=False)
class FilterChainMatch(betterproto.Message):
    """
    Specifies the match criteria for selecting a specific filter chain for a
    listener. In order for a filter chain to be selected, *ALL* of its criteria
    must be fulfilled by the incoming connection, properties of which are set
    by the networking stack and/or listener filters. The following order
    applies: 1. Destination port. 2. Destination IP address. 3. Server name
    (e.g. SNI for TLS protocol), 4. Transport protocol. 5. Application
    protocols (e.g. ALPN for TLS protocol). 6. Directly connected source IP
    address (this will only be different from the source IP address    when
    using a listener filter that overrides the source address, such as the
    :ref:`Proxy Protocol    listener filter
    <config_listener_filters_proxy_protocol>`). 7. Source type (e.g. any, local
    or external network). 8. Source IP address. 9. Source port. For criteria
    that allow ranges or wildcards, the most specific value in any of the
    configured filter chains that matches the incoming connection is going to
    be used (e.g. for SNI ``www.example.com`` the most specific match would be
    ``www.example.com``, then ``*.example.com``, then ``*.com``, then any
    filter chain without ``server_names`` requirements). A different way to
    reason about the filter chain matches: Suppose there exists N filter
    chains. Prune the filter chain set using the above 8 steps. In each step,
    filter chains which most specifically matches the attributes continue to
    the next step. The listener guarantees at most 1 filter chain is left after
    all of the steps. Example: For destination port, filter chains specifying
    the destination port of incoming traffic are the most specific match. If
    none of the filter chains specifies the exact destination port, the filter
    chains which do not specify ports are the most specific match. Filter
    chains specifying the wrong port can never be the most specific match.
    [#comment: Implemented rules are kept in the preference order, with
    deprecated fields listed at the end, because that's how we want to list
    them in the docs. [#comment:TODO(PiotrSikora): Add support for configurable
    precedence of the rules] [#next-free-field: 14]
    """

    destination_port: Optional[int] = betterproto.message_field(
        8, wraps=betterproto.TYPE_UINT32
    )
    """
    Optional destination port to consider when use_original_dst is set on the
    listener in determining a filter chain match.
    """

    prefix_ranges: List["__core_v3__.CidrRange"] = betterproto.message_field(3)
    """
    If non-empty, an IP address and prefix length to match addresses when the
    listener is bound to 0.0.0.0/:: or when use_original_dst is specified.
    """

    address_suffix: str = betterproto.string_field(4)
    """
    If non-empty, an IP address and suffix length to match addresses when the
    listener is bound to 0.0.0.0/:: or when use_original_dst is specified.
    [#not-implemented-hide:]
    """

    suffix_len: Optional[int] = betterproto.message_field(
        5, wraps=betterproto.TYPE_UINT32
    )
    """[#not-implemented-hide:]"""

    direct_source_prefix_ranges: List[
        "__core_v3__.CidrRange"
    ] = betterproto.message_field(13)
    """
    The criteria is satisfied if the directly connected source IP address of
    the downstream connection is contained in at least one of the specified
    subnets. If the parameter is not specified or the list is empty, the
    directly connected source IP address is ignored.
    """

    source_type: "FilterChainMatchConnectionSourceType" = betterproto.enum_field(12)
    """
    Specifies the connection source IP match type. Can be any, local or
    external network.
    """

    source_prefix_ranges: List["__core_v3__.CidrRange"] = betterproto.message_field(6)
    """
    The criteria is satisfied if the source IP address of the downstream
    connection is contained in at least one of the specified subnets. If the
    parameter is not specified or the list is empty, the source IP address is
    ignored.
    """

    source_ports: List[int] = betterproto.uint32_field(7)
    """
    The criteria is satisfied if the source port of the downstream connection
    is contained in at least one of the specified ports. If the parameter is
    not specified, the source port is ignored.
    """

    server_names: List[str] = betterproto.string_field(11)
    """
    If non-empty, a list of server names (e.g. SNI for TLS protocol) to
    consider when determining a filter chain match. Those values will be
    compared against the server names of a new connection, when detected by one
    of the listener filters. The server name will be matched against all
    wildcard domains, i.e. ``www.example.com`` will be first matched against
    ``www.example.com``, then ``*.example.com``, then ``*.com``. Note that
    partial wildcards are not supported, and values like ``*w.example.com`` are
    invalid. .. attention::   See the :ref:`FAQ entry <faq_how_to_setup_sni>`
    on how to configure SNI for more   information.
    """

    transport_protocol: str = betterproto.string_field(9)
    """
    If non-empty, a transport protocol to consider when determining a filter
    chain match. This value will be compared against the transport protocol of
    a new connection, when it's detected by one of the listener filters.
    Suggested values include: * ``raw_buffer`` - default, used when no
    transport protocol is detected, * ``tls`` - set by
    :ref:`envoy.filters.listener.tls_inspector
    <config_listener_filters_tls_inspector>`   when TLS protocol is detected.
    """

    application_protocols: List[str] = betterproto.string_field(10)
    """
    If non-empty, a list of application protocols (e.g. ALPN for TLS protocol)
    to consider when determining a filter chain match. Those values will be
    compared against the application protocols of a new connection, when
    detected by one of the listener filters. Suggested values include: *
    ``http/1.1`` - set by :ref:`envoy.filters.listener.tls_inspector
    <config_listener_filters_tls_inspector>`, * ``h2`` - set by
    :ref:`envoy.filters.listener.tls_inspector
    <config_listener_filters_tls_inspector>` .. attention::   Currently, only
    :ref:`TLS Inspector <config_listener_filters_tls_inspector>` provides
    application protocol detection based on the requested   `ALPN
    <https://en.wikipedia.org/wiki/Application-Layer_Protocol_Negotiation>`_
    values.   However, the use of ALPN is pretty much limited to the HTTP/2
    traffic on the Internet,   and matching on values other than ``h2`` is
    going to lead to a lot of false negatives,   unless all connecting clients
    are known to use ALPN.
    """


@dataclass(eq=False, repr=False)
class FilterChain(betterproto.Message):
    """
    A filter chain wraps a set of match criteria, an option TLS context, a set
    of filters, and various other parameters. [#next-free-field: 10]
    """

    filter_chain_match: "FilterChainMatch" = betterproto.message_field(1)
    """The criteria to use when matching a connection to this filter chain."""

    filters: List["Filter"] = betterproto.message_field(3)
    """
    A list of individual network filters that make up the filter chain for
    connections established with the listener. Order matters as the filters are
    processed sequentially as connection events happen. Note: If the filter
    list is empty, the connection will close by default. For QUIC listeners,
    network filters other than HTTP Connection Manager (HCM) can be created,
    but due to differences in the connection implementation compared to TCP,
    the onData() method will never be called. Therefore, network filters for
    QUIC listeners should only expect to do work at the start of a new
    connection (i.e. in onNewConnection()). HCM must be the last (or only)
    filter in the chain.
    """

    use_proxy_proto: Optional[bool] = betterproto.message_field(
        4, wraps=betterproto.TYPE_BOOL
    )
    """
    Whether the listener should expect a PROXY protocol V1 header on new
    connections. If this option is enabled, the listener will assume that that
    remote address of the connection is the one specified in the header. Some
    load balancers including the AWS ELB support this option. If the option is
    absent or set to false, Envoy will use the physical peer address of the
    connection as the remote address. This field is deprecated. Add a
    :ref:`PROXY protocol listener filter
    <config_listener_filters_proxy_protocol>` explicitly instead.
    """

    metadata: "__core_v3__.Metadata" = betterproto.message_field(5)
    """[#not-implemented-hide:] filter chain metadata."""

    transport_socket: "__core_v3__.TransportSocket" = betterproto.message_field(6)
    """
    Optional custom transport socket implementation to use for downstream
    connections. To setup TLS, set a transport socket with name
    ``envoy.transport_sockets.tls`` and :ref:`DownstreamTlsContext <envoy_v3_ap
    i_msg_extensions.transport_sockets.tls.v3.DownstreamTlsContext>` in the
    ``typed_config``. If no transport socket configuration is specified, new
    connections will be set up with plaintext. [#extension-category:
    envoy.transport_sockets.downstream]
    """

    transport_socket_connect_timeout: timedelta = betterproto.message_field(9)
    """
    If present and nonzero, the amount of time to allow incoming connections to
    complete any transport socket negotiations. If this expires before the
    transport reports connection establishment, the connection is summarily
    closed.
    """

    name: str = betterproto.string_field(7)
    """
    The unique name (or empty) by which this filter chain is known. Note:
    :ref:`filter_chain_matcher
    <envoy_v3_api_field_config.listener.v3.Listener.filter_chain_matcher>`
    requires that filter chains are uniquely named within a listener.
    """

    on_demand_configuration: "FilterChainOnDemandConfiguration" = (
        betterproto.message_field(8)
    )
    """
    [#not-implemented-hide:] The configuration to specify whether the filter
    chain will be built on-demand. If this field is not empty, the filter chain
    will be built on-demand. Otherwise, the filter chain will be built normally
    and block listener warming.
    """

    def __post_init__(self) -> None:
        super().__post_init__()
        if self.is_set("use_proxy_proto"):
            warnings.warn(
                "FilterChain.use_proxy_proto is deprecated", DeprecationWarning
            )


@dataclass(eq=False, repr=False)
class FilterChainOnDemandConfiguration(betterproto.Message):
    """
    The configuration for on-demand filter chain. If this field is not empty in
    FilterChain message, a filter chain will be built on-demand. On-demand
    filter chains help speedup the warming up of listeners since the building
    and initialization of an on-demand filter chain will be postponed to the
    arrival of new connection requests that require this filter chain. Filter
    chains that are not often used can be set as on-demand.
    """

    rebuild_timeout: timedelta = betterproto.message_field(1)
    """
    The timeout to wait for filter chain placeholders to complete rebuilding.
    1. If this field is set to 0, timeout is disabled. 2. If not specified, a
    default timeout of 15s is used. Rebuilding will wait until dependencies are
    ready, have failed, or this timeout is reached. Upon failure or timeout,
    all connections related to this filter chain will be closed. Rebuilding
    will start again on the next new connection.
    """


@dataclass(eq=False, repr=False)
class ListenerFilterChainMatchPredicate(betterproto.Message):
    """
    Listener filter chain match configuration. This is a recursive structure
    which allows complex nested match configurations to be built using various
    logical operators. Examples: * Matches if the destination port is 3306. ..
    code-block:: yaml  destination_port_range:   start: 3306   end: 3307 *
    Matches if the destination port is 3306 or 15000. .. code-block:: yaml
    or_match:    rules:      - destination_port_range:          start: 3306
    end: 3307      - destination_port_range:          start: 15000
    end: 15001 [#next-free-field: 6]
    """

    or_match: "ListenerFilterChainMatchPredicateMatchSet" = betterproto.message_field(
        1, group="rule"
    )
    """
    A set that describes a logical OR. If any member of the set matches, the
    match configuration matches.
    """

    and_match: "ListenerFilterChainMatchPredicateMatchSet" = betterproto.message_field(
        2, group="rule"
    )
    """
    A set that describes a logical AND. If all members of the set match, the
    match configuration matches.
    """

    not_match: "ListenerFilterChainMatchPredicate" = betterproto.message_field(
        3, group="rule"
    )
    """
    A negation match. The match configuration will match if the negated match
    condition matches.
    """

    any_match: bool = betterproto.bool_field(4, group="rule")
    """The match configuration will always match."""

    destination_port_range: "___type_v3__.Int32Range" = betterproto.message_field(
        5, group="rule"
    )
    """
    Match destination port. Particularly, the match evaluation must use the
    recovered local port if the owning listener filter is after :ref:`an
    original_dst listener filter <config_listener_filters_original_dst>`.
    """


@dataclass(eq=False, repr=False)
class ListenerFilterChainMatchPredicateMatchSet(betterproto.Message):
    """A set of match configurations used for logical operations."""

    rules: List["ListenerFilterChainMatchPredicate"] = betterproto.message_field(1)
    """The list of rules that make up the set."""


@dataclass(eq=False, repr=False)
class ListenerFilter(betterproto.Message):
    """[#next-free-field: 6]"""

    name: str = betterproto.string_field(1)
    """The name of the filter configuration."""

    typed_config: "betterproto_lib_google_protobuf.Any" = betterproto.message_field(
        3, group="config_type"
    )
    """
    Filter specific configuration which depends on the filter being
    instantiated. See the supported filters for further documentation.
    [#extension-category: envoy.filters.listener,envoy.filters.udp_listener]
    """

    config_discovery: "__core_v3__.ExtensionConfigSource" = betterproto.message_field(
        5, group="config_type"
    )
    """
    Configuration source specifier for an extension configuration discovery
    service. In case of a failure and without the default configuration, the
    listener closes the connections.
    """

    filter_disabled: "ListenerFilterChainMatchPredicate" = betterproto.message_field(4)
    """
    Optional match predicate used to disable the filter. The filter is enabled
    when this field is empty. See :ref:`ListenerFilterChainMatchPredicate
    <envoy_v3_api_msg_config.listener.v3.ListenerFilterChainMatchPredicate>`
    for further examples.
    """


@dataclass(eq=False, repr=False)
class QuicProtocolOptions(betterproto.Message):
    """
    Configuration specific to the UDP QUIC listener. [#next-free-field: 8]
    """

    quic_protocol_options: "__core_v3__.QuicProtocolOptions" = (
        betterproto.message_field(1)
    )
    idle_timeout: timedelta = betterproto.message_field(2)
    """
    Maximum number of milliseconds that connection will be alive when there is
    no network activity. If it is less than 1ms, Envoy will use 1ms. 300000ms
    if not specified.
    """

    crypto_handshake_timeout: timedelta = betterproto.message_field(3)
    """
    Connection timeout in milliseconds before the crypto handshake is finished.
    If it is less than 5000ms, Envoy will use 5000ms. 20000ms if not specified.
    """

    enabled: "__core_v3__.RuntimeFeatureFlag" = betterproto.message_field(4)
    """
    Runtime flag that controls whether the listener is enabled or not. If not
    specified, defaults to enabled.
    """

    packets_to_read_to_connection_count_ratio: Optional[
        int
    ] = betterproto.message_field(5, wraps=betterproto.TYPE_UINT32)
    """
    A multiplier to number of connections which is used to determine how many
    packets to read per event loop. A reasonable number should allow the
    listener to process enough payload but not starve TCP and other UDP sockets
    and also prevent long event loop duration. The default value is 32. This
    means if there are N QUIC connections, the total number of packets to read
    in each read event will be 32 * N. The actual number of packets to read in
    total by the UDP listener is also bound by 6000, regardless of this field
    or how many connections there are.
    """

    crypto_stream_config: "__core_v3__.TypedExtensionConfig" = (
        betterproto.message_field(6)
    )
    """
    Configure which implementation of ``quic::QuicCryptoClientStreamBase`` to
    be used for this listener. If not specified the :ref:`QUICHE default one
    configured by <envoy_v3_api_msg_extensions.quic.crypto_stream.v3.CryptoServ
    erStreamConfig>` will be used. [#extension-category:
    envoy.quic.server.crypto_stream]
    """

    proof_source_config: "__core_v3__.TypedExtensionConfig" = betterproto.message_field(
        7
    )
    """
    Configure which implementation of ``quic::ProofSource`` to be used for this
    listener. If not specified the :ref:`default one configured by
    <envoy_v3_api_msg_extensions.quic.proof_source.v3.ProofSourceConfig>` will
    be used. [#extension-category: envoy.quic.proof_source]
    """


@dataclass(eq=False, repr=False)
class ApiListener(betterproto.Message):
    """
    Describes a type of API listener, which is used in non-proxy clients. The
    type of API exposed to the non-proxy application depends on the type of API
    listener.
    """

    api_listener: "betterproto_lib_google_protobuf.Any" = betterproto.message_field(1)
    """
    The type in this field determines the type of API listener. At present, the
    following types are supported: envoy.extensions.filters.network.http_connec
    tion_manager.v3.HttpConnectionManager (HTTP) envoy.extensions.filters.netwo
    rk.http_connection_manager.v3.EnvoyMobileHttpConnectionManager (HTTP)
    [#next-major-version: In the v3 API, replace this Any field with a oneof
    containing the specific config message for each type of API listener. We
    could not do this in v2 because it would have caused circular dependencies
    for go protos: lds.proto depends on this file, and
    http_connection_manager.proto depends on rds.proto, which is in the same
    directory as lds.proto, so lds.proto cannot depend on this file.]
    """


@dataclass(eq=False, repr=False)
class UdpListenerConfig(betterproto.Message):
    """[#next-free-field: 9]"""

    downstream_socket_config: "__core_v3__.UdpSocketConfig" = betterproto.message_field(
        5
    )
    """
    UDP socket configuration for the listener. The default for :ref:`prefer_gro
    <envoy_v3_api_field_config.core.v3.UdpSocketConfig.prefer_gro>` is false
    for listener sockets. If receiving a large amount of datagrams from a small
    number of sources, it may be worthwhile to enable this option after
    performance testing.
    """

    quic_options: "QuicProtocolOptions" = betterproto.message_field(7)
    """
    Configuration for QUIC protocol. If empty, QUIC will not be enabled on this
    listener. Set to the default object to enable QUIC without modifying any
    additional options.
    """

    udp_packet_packet_writer_config: "__core_v3__.TypedExtensionConfig" = (
        betterproto.message_field(8)
    )
    """
    Configuration for the UDP packet writer. If empty, HTTP/3 will use GSO if
    available (:ref:`UdpDefaultWriterFactory <envoy_v3_api_msg_extensions.udp_p
    acket_writer.v3.UdpGsoBatchWriterFactory>`) or the default kernel sendmsg
    if not, (:ref:`UdpDefaultWriterFactory <envoy_v3_api_msg_extensions.udp_pac
    ket_writer.v3.UdpDefaultWriterFactory>`) and raw UDP will use kernel
    sendmsg. [#extension-category: envoy.udp_packet_writer]
    """


@dataclass(eq=False, repr=False)
class ActiveRawUdpListenerConfig(betterproto.Message):
    pass


@dataclass(eq=False, repr=False)
class AdditionalAddress(betterproto.Message):
    """The additional address the listener is listening on."""

    address: "__core_v3__.Address" = betterproto.message_field(1)
    socket_options: "__core_v3__.SocketOptionsOverride" = betterproto.message_field(2)
    """
    [#not-implemented-hide:] Additional socket options that may not be present
    in Envoy source code or precompiled binaries. If specified, this will
    override the :ref:`socket_options
    <envoy_v3_api_field_config.listener.v3.Listener.socket_options>` in the
    listener. If specified with no :ref:`socket_options
    <envoy_v3_api_field_config.core.v3.SocketOptionsOverride.socket_options>`
    or an empty list of :ref:`socket_options
    <envoy_v3_api_field_config.core.v3.SocketOptionsOverride.socket_options>`,
    it means no socket option will apply.
    """


@dataclass(eq=False, repr=False)
class ListenerCollection(betterproto.Message):
    """
    Listener list collections. Entries are ``Listener`` resources or
    references. [#not-implemented-hide:]
    """

    entries: List["____xds_core_v3__.CollectionEntry"] = betterproto.message_field(1)


@dataclass(eq=False, repr=False)
class Listener(betterproto.Message):
    """[#next-free-field: 34]"""

    name: str = betterproto.string_field(1)
    """
    The unique name by which this listener is known. If no name is provided,
    Envoy will allocate an internal UUID for the listener. If the listener is
    to be dynamically updated or removed via :ref:`LDS <config_listeners_lds>`
    a unique name must be provided.
    """

    address: "__core_v3__.Address" = betterproto.message_field(2)
    """
    The address that the listener should listen on. In general, the address
    must be unique, though that is governed by the bind rules of the OS. E.g.,
    multiple listeners can listen on port 0 on Linux as the actual port will be
    allocated by the OS. Required unless ``api_listener`` or
    ``listener_specifier`` is populated.
    """

    additional_addresses: List["AdditionalAddress"] = betterproto.message_field(33)
    """
    The additional addresses the listener should listen on. The addresses must
    be unique across all listeners. Multiple addresses with port 0 can be
    supplied. When using multiple addresses in a single listener, all addresses
    use the same protocol, and multiple internal addresses are not supported.
    """

    stat_prefix: str = betterproto.string_field(28)
    """
    Optional prefix to use on listener stats. If empty, the stats will be
    rooted at ``listener.<address as string>.``. If non-empty, stats will be
    rooted at ``listener.<stat_prefix>.``.
    """

    filter_chains: List["FilterChain"] = betterproto.message_field(3)
    """
    A list of filter chains to consider for this listener. The
    :ref:`FilterChain <envoy_v3_api_msg_config.listener.v3.FilterChain>` with
    the most specific :ref:`FilterChainMatch
    <envoy_v3_api_msg_config.listener.v3.FilterChainMatch>` criteria is used on
    a connection. Example using SNI for filter chain selection can be found in
    the :ref:`FAQ entry <faq_how_to_setup_sni>`.
    """

    filter_chain_matcher: "____xds_type_matcher_v3__.Matcher" = (
        betterproto.message_field(32)
    )
    """
    :ref:`Matcher API <arch_overview_matching_listener>` resolving the filter
    chain name from the network properties. This matcher is used as a
    replacement for the filter chain match condition :ref:`filter_chain_match
    <envoy_v3_api_field_config.listener.v3.FilterChain.filter_chain_match>`. If
    specified, all :ref:`filter_chains
    <envoy_v3_api_field_config.listener.v3.Listener.filter_chains>` must have a
    non-empty and unique :ref:`name
    <envoy_v3_api_field_config.listener.v3.FilterChain.name>` field and not
    specify :ref:`filter_chain_match
    <envoy_v3_api_field_config.listener.v3.FilterChain.filter_chain_match>`
    field. .. note::  Once matched, each connection is permanently bound to its
    filter chain.  If the matcher changes but the filter chain remains the
    same, the  connections bound to the filter chain are not drained. If,
    however, the  filter chain is removed or structurally modified, then the
    drain for its  connections is initiated.
    """

    use_original_dst: Optional[bool] = betterproto.message_field(
        4, wraps=betterproto.TYPE_BOOL
    )
    """
    If a connection is redirected using ``iptables``, the port on which the
    proxy receives it might be different from the original destination address.
    When this flag is set to true, the listener hands off redirected
    connections to the listener associated with the original destination
    address. If there is no listener associated with the original destination
    address, the connection is handled by the listener that receives it.
    Defaults to false.
    """

    default_filter_chain: "FilterChain" = betterproto.message_field(25)
    """
    The default filter chain if none of the filter chain matches. If no default
    filter chain is supplied, the connection will be closed. The filter chain
    match is ignored in this field.
    """

    per_connection_buffer_limit_bytes: Optional[int] = betterproto.message_field(
        5, wraps=betterproto.TYPE_UINT32
    )
    """
    Soft limit on size of the listener’s new connection read and write buffers.
    If unspecified, an implementation defined default is applied (1MiB).
    """

    metadata: "__core_v3__.Metadata" = betterproto.message_field(6)
    """Listener metadata."""

    deprecated_v1: "ListenerDeprecatedV1" = betterproto.message_field(7)
    """[#not-implemented-hide:]"""

    drain_type: "ListenerDrainType" = betterproto.enum_field(8)
    """The type of draining to perform at a listener-wide level."""

    listener_filters: List["ListenerFilter"] = betterproto.message_field(9)
    """
    Listener filters have the opportunity to manipulate and augment the
    connection metadata that is used in connection filter chain matching, for
    example. These filters are run before any in :ref:`filter_chains
    <envoy_v3_api_field_config.listener.v3.Listener.filter_chains>`. Order
    matters as the filters are processed sequentially right after a socket has
    been accepted by the listener, and before a connection is created. UDP
    Listener filters can be specified when the protocol in the listener socket
    address in :ref:`protocol
    <envoy_v3_api_field_config.core.v3.SocketAddress.protocol>` is :ref:`UDP
    <envoy_v3_api_enum_value_config.core.v3.SocketAddress.Protocol.UDP>`.
    """

    listener_filters_timeout: timedelta = betterproto.message_field(15)
    """
    The timeout to wait for all listener filters to complete operation. If the
    timeout is reached, the accepted socket is closed without a connection
    being created unless ``continue_on_listener_filters_timeout`` is set to
    true. Specify 0 to disable the timeout. If not specified, a default timeout
    of 15s is used.
    """

    continue_on_listener_filters_timeout: bool = betterproto.bool_field(17)
    """
    Whether a connection should be created when listener filters timeout.
    Default is false. .. attention::   Some listener filters, such as
    :ref:`Proxy Protocol filter   <config_listener_filters_proxy_protocol>`,
    should not be used with this option. It will cause   unexpected behavior
    when a connection is created.
    """

    transparent: Optional[bool] = betterproto.message_field(
        10, wraps=betterproto.TYPE_BOOL
    )
    """
    Whether the listener should be set as a transparent socket. When this flag
    is set to true, connections can be redirected to the listener using an
    ``iptables`` ``TPROXY`` target, in which case the original source and
    destination addresses and ports are preserved on accepted connections. This
    flag should be used in combination with :ref:`an original_dst
    <config_listener_filters_original_dst>` :ref:`listener filter
    <envoy_v3_api_field_config.listener.v3.Listener.listener_filters>` to mark
    the connections' local addresses as "restored." This can be used to hand
    off each redirected connection to another listener associated with the
    connection's destination address. Direct connections to the socket without
    using ``TPROXY`` cannot be distinguished from connections redirected using
    ``TPROXY`` and are therefore treated as if they were redirected. When this
    flag is set to false, the listener's socket is explicitly reset as non-
    transparent. Setting this flag requires Envoy to run with the
    ``CAP_NET_ADMIN`` capability. When this flag is not set (default), the
    socket is not modified, i.e. the transparent option is neither set nor
    reset.
    """

    freebind: Optional[bool] = betterproto.message_field(
        11, wraps=betterproto.TYPE_BOOL
    )
    """
    Whether the listener should set the ``IP_FREEBIND`` socket option. When
    this flag is set to true, listeners can be bound to an IP address that is
    not configured on the system running Envoy. When this flag is set to false,
    the option ``IP_FREEBIND`` is disabled on the socket. When this flag is not
    set (default), the socket is not modified, i.e. the option is neither
    enabled nor disabled.
    """

    socket_options: List["__core_v3__.SocketOption"] = betterproto.message_field(13)
    """
    Additional socket options that may not be present in Envoy source code or
    precompiled binaries.
    """

    tcp_fast_open_queue_length: Optional[int] = betterproto.message_field(
        12, wraps=betterproto.TYPE_UINT32
    )
    """
    Whether the listener should accept TCP Fast Open (TFO) connections. When
    this flag is set to a value greater than 0, the option TCP_FASTOPEN is
    enabled on the socket, with a queue length of the specified size (see
    `details in RFC7413 <https://tools.ietf.org/html/rfc7413#section-5.1>`_).
    When this flag is set to 0, the option TCP_FASTOPEN is disabled on the
    socket. When this flag is not set (default), the socket is not modified,
    i.e. the option is neither enabled nor disabled. On Linux, the
    net.ipv4.tcp_fastopen kernel parameter must include flag 0x2 to enable
    TCP_FASTOPEN. See `ip-sysctl.txt
    <https://www.kernel.org/doc/Documentation/networking/ip-sysctl.txt>`_. On
    macOS, only values of 0, 1, and unset are valid; other values may result in
    an error. To set the queue length on macOS, set the
    net.inet.tcp.fastopen_backlog kernel parameter.
    """

    traffic_direction: "__core_v3__.TrafficDirection" = betterproto.enum_field(16)
    """
    Specifies the intended direction of the traffic relative to the local
    Envoy. This property is required on Windows for listeners using the
    original destination filter, see :ref:`Original Destination
    <config_listener_filters_original_dst>`.
    """

    udp_listener_config: "UdpListenerConfig" = betterproto.message_field(18)
    """
    If the protocol in the listener socket address in :ref:`protocol
    <envoy_v3_api_field_config.core.v3.SocketAddress.protocol>` is :ref:`UDP
    <envoy_v3_api_enum_value_config.core.v3.SocketAddress.Protocol.UDP>`, this
    field specifies UDP listener specific configuration.
    """

    api_listener: "ApiListener" = betterproto.message_field(19)
    """
    Used to represent an API listener, which is used in non-proxy clients. The
    type of API exposed to the non-proxy application depends on the type of API
    listener. When this field is set, no other field except for
    :ref:`name<envoy_v3_api_field_config.listener.v3.Listener.name>` should be
    set. .. note::  Currently only one ApiListener can be installed; and it can
    only be done via bootstrap config,  not LDS. [#next-major-version: In the
    v3 API, instead of this messy approach where the socket listener fields are
    directly in the top-level Listener message and the API listener types are
    in the ApiListener message, the socket listener messages should be in their
    own message, and the top-level Listener should essentially be a oneof that
    selects between the socket listener and the various types of API listener.
    That way, a given Listener message can structurally only contain the fields
    of the relevant type.]
    """

    connection_balance_config: "ListenerConnectionBalanceConfig" = (
        betterproto.message_field(20)
    )
    """
    The listener's connection balancer configuration, currently only applicable
    to TCP listeners. If no configuration is specified, Envoy will not attempt
    to balance active connections between worker threads. In the scenario that
    the listener X redirects all the connections to the listeners Y1 and Y2 by
    setting :ref:`use_original_dst
    <envoy_v3_api_field_config.listener.v3.Listener.use_original_dst>` in X and
    :ref:`bind_to_port
    <envoy_v3_api_field_config.listener.v3.Listener.bind_to_port>` to false in
    Y1 and Y2, it is recommended to disable the balance config in listener X to
    avoid the cost of balancing, and enable the balance config in Y1 and Y2 to
    balance the connections among the workers.
    """

    reuse_port: bool = betterproto.bool_field(21)
    """Deprecated. Use ``enable_reuse_port`` instead."""

    enable_reuse_port: Optional[bool] = betterproto.message_field(
        29, wraps=betterproto.TYPE_BOOL
    )
    """
    When this flag is set to true, listeners set the ``SO_REUSEPORT`` socket
    option and create one socket for each worker thread. This makes inbound
    connections distribute among worker threads roughly evenly in cases where
    there are a high number of connections. When this flag is set to false, all
    worker threads share one socket. This field defaults to true. ..
    attention::   Although this field defaults to true, it has different
    behavior on different platforms. See   the following text for more
    information. * On Linux, reuse_port is respected for both TCP and UDP
    listeners. It also works correctly   with hot restart. * On macOS,
    reuse_port for TCP does not do what it does on Linux. Instead of load
    balancing,   the last socket wins and receives all connections/packets. For
    TCP, reuse_port is force   disabled and the user is warned. For UDP, it is
    enabled, but only one worker will receive   packets. For QUIC/H3, SW
    routing will send packets to other workers. For "raw" UDP, only   a single
    worker will currently receive packets. * On Windows, reuse_port for TCP has
    undefined behavior. It is force disabled and the user   is warned similar
    to macOS. It is left enabled for UDP with undefined behavior currently.
    """

    access_log: List["__accesslog_v3__.AccessLog"] = betterproto.message_field(22)
    """
    Configuration for :ref:`access logs <arch_overview_access_logs>` emitted by
    this listener.
    """

    tcp_backlog_size: Optional[int] = betterproto.message_field(
        24, wraps=betterproto.TYPE_UINT32
    )
    """
    The maximum length a tcp listener's pending connections queue can grow to.
    If no value is provided net.core.somaxconn will be used on Linux and 128
    otherwise.
    """

    bind_to_port: Optional[bool] = betterproto.message_field(
        26, wraps=betterproto.TYPE_BOOL
    )
    """
    Whether the listener should bind to the port. A listener that doesn't bind
    can only receive connections redirected from other listeners that set
    :ref:`use_original_dst
    <envoy_v3_api_field_config.listener.v3.Listener.use_original_dst>` to true.
    Default is true.
    """

    internal_listener: "ListenerInternalListenerConfig" = betterproto.message_field(
        27, group="listener_specifier"
    )
    """
    Used to represent an internal listener which does not listen on OSI L4
    address but can be used by the :ref:`envoy cluster
    <envoy_v3_api_msg_config.cluster.v3.Cluster>` to create a user space
    connection to. The internal listener acts as a TCP listener. It supports
    listener filters and network filter chains. Upstream clusters refer to the
    internal listeners by their :ref:`name
    <envoy_v3_api_field_config.listener.v3.Listener.name>`. :ref:`Address
    <envoy_v3_api_field_config.listener.v3.Listener.address>` must not be set
    on the internal listeners. There are some limitations that are derived from
    the implementation. The known limitations include: *
    :ref:`ConnectionBalanceConfig
    <envoy_v3_api_msg_config.listener.v3.Listener.ConnectionBalanceConfig>` is
    not   allowed because both the cluster connection and the listener
    connection must be owned by the same dispatcher. * :ref:`tcp_backlog_size
    <envoy_v3_api_field_config.listener.v3.Listener.tcp_backlog_size>` *
    :ref:`freebind <envoy_v3_api_field_config.listener.v3.Listener.freebind>` *
    :ref:`transparent
    <envoy_v3_api_field_config.listener.v3.Listener.transparent>`
    """

    enable_mptcp: bool = betterproto.bool_field(30)
    """
    Enable MPTCP (multi-path TCP) on this listener. Clients will be allowed to
    establish MPTCP connections. Non-MPTCP clients will fall back to regular
    TCP.
    """

    ignore_global_conn_limit: bool = betterproto.bool_field(31)
    """
    Whether the listener should limit connections based upon the value of
    :ref:`global_downstream_max_connections
    <config_overload_manager_limiting_connections>`.
    """

    def __post_init__(self) -> None:
        super().__post_init__()
        if self.is_set("deprecated_v1"):
            warnings.warn("Listener.deprecated_v1 is deprecated", DeprecationWarning)
        if self.is_set("reuse_port"):
            warnings.warn("Listener.reuse_port is deprecated", DeprecationWarning)


@dataclass(eq=False, repr=False)
class ListenerDeprecatedV1(betterproto.Message):
    """[#not-implemented-hide:]"""

    bind_to_port: Optional[bool] = betterproto.message_field(
        1, wraps=betterproto.TYPE_BOOL
    )
    """
    Whether the listener should bind to the port. A listener that doesn't bind
    can only receive connections redirected from other listeners that set
    use_original_dst parameter to true. Default is true. This is deprecated.
    Use :ref:`Listener.bind_to_port
    <envoy_v3_api_field_config.listener.v3.Listener.bind_to_port>`
    """


@dataclass(eq=False, repr=False)
class ListenerConnectionBalanceConfig(betterproto.Message):
    """Configuration for listener connection balancing."""

    exact_balance: "ListenerConnectionBalanceConfigExactBalance" = (
        betterproto.message_field(1, group="balance_type")
    )
    """If specified, the listener will use the exact connection balancer."""

    extend_balance: "__core_v3__.TypedExtensionConfig" = betterproto.message_field(
        2, group="balance_type"
    )
    """
    The listener will use the connection balancer according to ``type_url``. If
    ``type_url`` is invalid, Envoy will not attempt to balance active
    connections between worker threads. [#extension-category:
    envoy.network.connection_balance]
    """


@dataclass(eq=False, repr=False)
class ListenerConnectionBalanceConfigExactBalance(betterproto.Message):
    """
    A connection balancer implementation that does exact balancing. This means
    that a lock is held during balancing so that connection counts are nearly
    exactly balanced between worker threads. This is "nearly" exact in the
    sense that a connection might close in parallel thus making the counts
    incorrect, but this should be rectified on the next accept. This balancer
    sacrifices accept throughput for accuracy and should be used when there are
    a small number of connections that rarely cycle (e.g., service mesh gRPC
    egress).
    """

    pass


@dataclass(eq=False, repr=False)
class ListenerInternalListenerConfig(betterproto.Message):
    """
    Configuration for envoy internal listener. All the future internal listener
    features should be added here.
    """

    pass
