# Generated by the protocol buffer compiler.  DO NOT EDIT!
# sources: envoy/config/filter/network/dubbo_proxy/v2alpha1/dubbo_proxy.proto, envoy/config/filter/network/dubbo_proxy/v2alpha1/route.proto
# plugin: python-betterproto
from dataclasses import dataclass
from typing import (
    Dict,
    List,
)

import betterproto
import betterproto.lib.google.protobuf as betterproto_lib_google_protobuf

from ...... import type as _____type__
from ......api.v2 import route as _____api_v2_route__
from ......type import matcher as _____type_matcher__


class ProtocolType(betterproto.Enum):
    """Dubbo Protocol types supported by Envoy."""

    Dubbo = 0
    """the default protocol."""


class SerializationType(betterproto.Enum):
    """Dubbo Serialization types supported by Envoy."""

    Hessian2 = 0
    """the default serialization protocol."""


@dataclass(eq=False, repr=False)
class RouteConfiguration(betterproto.Message):
    """[#next-free-field: 6]"""

    name: str = betterproto.string_field(1)
    """
    The name of the route configuration. Reserved for future use in
    asynchronous route discovery.
    """

    interface: str = betterproto.string_field(2)
    """The interface name of the service."""

    group: str = betterproto.string_field(3)
    """Which group does the interface belong to."""

    version: str = betterproto.string_field(4)
    """The version number of the interface."""

    routes: List["Route"] = betterproto.message_field(5)
    """
    The list of routes that will be matched, in order, against incoming
    requests. The first route that matches will be used.
    """


@dataclass(eq=False, repr=False)
class Route(betterproto.Message):
    match: "RouteMatch" = betterproto.message_field(1)
    """Route matching parameters."""

    route: "RouteAction" = betterproto.message_field(2)
    """Route request to some upstream cluster."""


@dataclass(eq=False, repr=False)
class RouteMatch(betterproto.Message):
    method: "MethodMatch" = betterproto.message_field(1)
    """Method level routing matching."""

    headers: List["_____api_v2_route__.HeaderMatcher"] = betterproto.message_field(2)
    """
    Specifies a set of headers that the route should match on. The router will
    check the request’s headers against all the specified headers in the route
    config. A match will happen if all the headers in the route are present in
    the request with the same values (or based on presence if the value field
    is not in the config).
    """


@dataclass(eq=False, repr=False)
class RouteAction(betterproto.Message):
    cluster: str = betterproto.string_field(1, group="cluster_specifier")
    """
    Indicates the upstream cluster to which the request should be routed.
    """

    weighted_clusters: "_____api_v2_route__.WeightedCluster" = (
        betterproto.message_field(2, group="cluster_specifier")
    )
    """
    Multiple upstream clusters can be specified for a given route. The request
    is routed to one of the upstream clusters based on weights assigned to each
    cluster. Currently ClusterWeight only supports the name and weight fields.
    """


@dataclass(eq=False, repr=False)
class MethodMatch(betterproto.Message):
    name: "_____type_matcher__.StringMatcher" = betterproto.message_field(1)
    """The name of the method."""

    params_match: Dict[
        int, "MethodMatchParameterMatchSpecifier"
    ] = betterproto.map_field(2, betterproto.TYPE_UINT32, betterproto.TYPE_MESSAGE)
    """
    Method parameter definition. The key is the parameter index, starting from
    0. The value is the parameter matching type.
    """


@dataclass(eq=False, repr=False)
class MethodMatchParameterMatchSpecifier(betterproto.Message):
    """The parameter matching type."""

    exact_match: str = betterproto.string_field(3, group="parameter_match_specifier")
    """
    If specified, header match will be performed based on the value of the
    header.
    """

    range_match: "_____type__.Int64Range" = betterproto.message_field(
        4, group="parameter_match_specifier"
    )
    """
    If specified, header match will be performed based on range. The rule will
    match if the request header value is within this range. The entire request
    header value must represent an integer in base 10 notation: consisting of
    an optional plus or minus sign followed by a sequence of digits. The rule
    will not match if the header value does not represent an integer. Match
    will fail for empty values, floating point numbers or if only a subsequence
    of the header value is an integer. Examples: * For range [-10,0), route
    will match for header value -1, but not for 0,   "somestring", 10.9,
    "-1somestring"
    """


@dataclass(eq=False, repr=False)
class DubboProxy(betterproto.Message):
    """[#next-free-field: 6]"""

    stat_prefix: str = betterproto.string_field(1)
    """The human readable prefix to use when emitting statistics."""

    protocol_type: "ProtocolType" = betterproto.enum_field(2)
    """Configure the protocol used."""

    serialization_type: "SerializationType" = betterproto.enum_field(3)
    """Configure the serialization protocol used."""

    route_config: List["RouteConfiguration"] = betterproto.message_field(4)
    """
    The route table for the connection manager is static and is specified in
    this property.
    """

    dubbo_filters: List["DubboFilter"] = betterproto.message_field(5)
    """
    A list of individual Dubbo filters that make up the filter chain for
    requests made to the Dubbo proxy. Order matters as the filters are
    processed sequentially. For backwards compatibility, if no dubbo_filters
    are specified, a default Dubbo router filter (`envoy.filters.dubbo.router`)
    is used.
    """


@dataclass(eq=False, repr=False)
class DubboFilter(betterproto.Message):
    """DubboFilter configures a Dubbo filter."""

    name: str = betterproto.string_field(1)
    """
    The name of the filter to instantiate. The name must match a supported
    filter.
    """

    config: "betterproto_lib_google_protobuf.Any" = betterproto.message_field(2)
    """
    Filter specific configuration which depends on the filter being
    instantiated. See the supported filters for further documentation.
    """
