# Generated by the protocol buffer compiler.  DO NOT EDIT!
# sources: envoy/config/common/matcher/v3/matcher.proto
# plugin: python-betterproto
from dataclasses import dataclass
from typing import (
    Dict,
    List,
)

import betterproto

from .....type.matcher import v3 as ____type_matcher_v3__
from ....core import v3 as ___core_v3__
from ....route import v3 as ___route_v3__


@dataclass(eq=False, repr=False)
class Matcher(betterproto.Message):
    """
    A matcher, which may traverse a matching tree in order to result in a match
    action. During matching, the tree will be traversed until a match is found,
    or if no match is found the action specified by the most specific
    on_no_match will be evaluated. As an on_no_match might result in another
    matching tree being evaluated, this process might repeat several times
    until the final OnMatch (or no match) is decided.
    """

    matcher_list: "MatcherMatcherList" = betterproto.message_field(
        1, group="matcher_type"
    )
    """A linear list of matchers to evaluate."""

    matcher_tree: "MatcherMatcherTree" = betterproto.message_field(
        2, group="matcher_type"
    )
    """A match tree to evaluate."""

    on_no_match: "MatcherOnMatch" = betterproto.message_field(3)
    """
    Optional OnMatch to use if the matcher failed. If specified, the OnMatch is
    used, and the matcher is considered to have matched. If not specified, the
    matcher is considered not to have matched.
    """


@dataclass(eq=False, repr=False)
class MatcherOnMatch(betterproto.Message):
    """What to do if a match is successful."""

    matcher: "Matcher" = betterproto.message_field(1, group="on_match")
    """
    Nested matcher to evaluate. If the nested matcher does not match and does
    not specify on_no_match, then this matcher is considered not to have
    matched, even if a predicate at this level or above returned true.
    """

    action: "___core_v3__.TypedExtensionConfig" = betterproto.message_field(
        2, group="on_match"
    )
    """Protocol-specific action to take."""


@dataclass(eq=False, repr=False)
class MatcherMatcherList(betterproto.Message):
    """
    A linear list of field matchers. The field matchers are evaluated in order,
    and the first match wins.
    """

    matchers: List["MatcherMatcherListFieldMatcher"] = betterproto.message_field(1)
    """A list of matchers. First match wins."""


@dataclass(eq=False, repr=False)
class MatcherMatcherListPredicate(betterproto.Message):
    """Predicate to determine if a match is successful."""

    single_predicate: "MatcherMatcherListPredicateSinglePredicate" = (
        betterproto.message_field(1, group="match_type")
    )
    """A single predicate to evaluate."""

    or_matcher: "MatcherMatcherListPredicatePredicateList" = betterproto.message_field(
        2, group="match_type"
    )
    """A list of predicates to be OR-ed together."""

    and_matcher: "MatcherMatcherListPredicatePredicateList" = betterproto.message_field(
        3, group="match_type"
    )
    """A list of predicates to be AND-ed together."""

    not_matcher: "MatcherMatcherListPredicate" = betterproto.message_field(
        4, group="match_type"
    )
    """The invert of a predicate"""


@dataclass(eq=False, repr=False)
class MatcherMatcherListPredicateSinglePredicate(betterproto.Message):
    """Predicate for a single input field."""

    input: "___core_v3__.TypedExtensionConfig" = betterproto.message_field(1)
    """
    Protocol-specific specification of input field to match on. [#extension-
    category: envoy.matching.common_inputs]
    """

    value_match: "____type_matcher_v3__.StringMatcher" = betterproto.message_field(
        2, group="matcher"
    )
    """Built-in string matcher."""

    custom_match: "___core_v3__.TypedExtensionConfig" = betterproto.message_field(
        3, group="matcher"
    )
    """
    Extension for custom matching logic. [#extension-category:
    envoy.matching.input_matchers]
    """


@dataclass(eq=False, repr=False)
class MatcherMatcherListPredicatePredicateList(betterproto.Message):
    """
    A list of two or more matchers. Used to allow using a list within a oneof.
    """

    predicate: List["MatcherMatcherListPredicate"] = betterproto.message_field(1)


@dataclass(eq=False, repr=False)
class MatcherMatcherListFieldMatcher(betterproto.Message):
    """An individual matcher."""

    predicate: "MatcherMatcherListPredicate" = betterproto.message_field(1)
    """Determines if the match succeeds."""

    on_match: "MatcherOnMatch" = betterproto.message_field(2)
    """What to do if the match succeeds."""


@dataclass(eq=False, repr=False)
class MatcherMatcherTree(betterproto.Message):
    input: "___core_v3__.TypedExtensionConfig" = betterproto.message_field(1)
    """Protocol-specific specification of input field to match on."""

    exact_match_map: "MatcherMatcherTreeMatchMap" = betterproto.message_field(
        2, group="tree_type"
    )
    prefix_match_map: "MatcherMatcherTreeMatchMap" = betterproto.message_field(
        3, group="tree_type"
    )
    """Longest matching prefix wins."""

    custom_match: "___core_v3__.TypedExtensionConfig" = betterproto.message_field(
        4, group="tree_type"
    )
    """Extension for custom matching logic."""


@dataclass(eq=False, repr=False)
class MatcherMatcherTreeMatchMap(betterproto.Message):
    """
    A map of configured matchers. Used to allow using a map within a oneof.
    """

    map: Dict[str, "MatcherOnMatch"] = betterproto.map_field(
        1, betterproto.TYPE_STRING, betterproto.TYPE_MESSAGE
    )


@dataclass(eq=False, repr=False)
class MatchPredicate(betterproto.Message):
    """
    Match configuration. This is a recursive structure which allows complex
    nested match configurations to be built using various logical operators.
    [#next-free-field: 11]
    """

    or_match: "MatchPredicateMatchSet" = betterproto.message_field(1, group="rule")
    """
    A set that describes a logical OR. If any member of the set matches, the
    match configuration matches.
    """

    and_match: "MatchPredicateMatchSet" = betterproto.message_field(2, group="rule")
    """
    A set that describes a logical AND. If all members of the set match, the
    match configuration matches.
    """

    not_match: "MatchPredicate" = betterproto.message_field(3, group="rule")
    """
    A negation match. The match configuration will match if the negated match
    condition matches.
    """

    any_match: bool = betterproto.bool_field(4, group="rule")
    """The match configuration will always match."""

    http_request_headers_match: "HttpHeadersMatch" = betterproto.message_field(
        5, group="rule"
    )
    """HTTP request headers match configuration."""

    http_request_trailers_match: "HttpHeadersMatch" = betterproto.message_field(
        6, group="rule"
    )
    """HTTP request trailers match configuration."""

    http_response_headers_match: "HttpHeadersMatch" = betterproto.message_field(
        7, group="rule"
    )
    """HTTP response headers match configuration."""

    http_response_trailers_match: "HttpHeadersMatch" = betterproto.message_field(
        8, group="rule"
    )
    """HTTP response trailers match configuration."""

    http_request_generic_body_match: "HttpGenericBodyMatch" = betterproto.message_field(
        9, group="rule"
    )
    """HTTP request generic body match configuration."""

    http_response_generic_body_match: "HttpGenericBodyMatch" = (
        betterproto.message_field(10, group="rule")
    )
    """HTTP response generic body match configuration."""


@dataclass(eq=False, repr=False)
class MatchPredicateMatchSet(betterproto.Message):
    """A set of match configurations used for logical operations."""

    rules: List["MatchPredicate"] = betterproto.message_field(1)
    """The list of rules that make up the set."""


@dataclass(eq=False, repr=False)
class HttpHeadersMatch(betterproto.Message):
    """HTTP headers match configuration."""

    headers: List["___route_v3__.HeaderMatcher"] = betterproto.message_field(1)
    """HTTP headers to match."""


@dataclass(eq=False, repr=False)
class HttpGenericBodyMatch(betterproto.Message):
    """
    HTTP generic body match configuration. List of text strings and hex strings
    to be located in HTTP body. All specified strings must be found in the HTTP
    body for positive match. The search may be limited to specified number of
    bytes from the body start. .. attention::   Searching for patterns in HTTP
    body is potentially cpu intensive. For each specified pattern, http body is
    scanned byte by byte to find a match.   If multiple patterns are specified,
    the process is repeated for each pattern. If location of a pattern is
    known, ``bytes_limit`` should be specified   to scan only part of the http
    body.
    """

    bytes_limit: int = betterproto.uint32_field(1)
    """
    Limits search to specified number of bytes - default zero (no limit - match
    entire captured buffer).
    """

    patterns: List["HttpGenericBodyMatchGenericTextMatch"] = betterproto.message_field(
        2
    )
    """List of patterns to match."""


@dataclass(eq=False, repr=False)
class HttpGenericBodyMatchGenericTextMatch(betterproto.Message):
    string_match: str = betterproto.string_field(1, group="rule")
    """Text string to be located in HTTP body."""

    binary_match: bytes = betterproto.bytes_field(2, group="rule")
    """Sequence of bytes to be located in HTTP body."""
