# Generated by the protocol buffer compiler.  DO NOT EDIT!
# sources: envoy/config/bootstrap/v3/bootstrap.proto
# plugin: python-betterproto
import warnings
from dataclasses import dataclass
from datetime import timedelta
from typing import (
    Dict,
    List,
    Optional,
)

import betterproto
import betterproto.lib.google.protobuf as betterproto_lib_google_protobuf

from ....extensions.transport_sockets.tls import (
    v3 as ___extensions_transport_sockets_tls_v3__,
)
from ....type import v3 as ___type_v3__
from ...accesslog import v3 as __accesslog_v3__
from ...cluster import v3 as __cluster_v3__
from ...core import v3 as __core_v3__
from ...listener import v3 as __listener_v3__
from ...metrics import v3 as __metrics_v3__
from ...overload import v3 as __overload_v3__
from ...trace import v3 as __trace_v3__


class WatchdogWatchdogActionWatchdogEvent(betterproto.Enum):
    """
    The events are fired in this order: KILL, MULTIKILL, MEGAMISS, MISS. Within
    an event type, actions execute in the order they are configured. For
    KILL/MULTIKILL there is a default PANIC that will run after the registered
    actions and kills the process if it wasn't already killed. It might be
    useful to specify several debug actions, and possibly an alternate FATAL
    action.
    """

    UNKNOWN = 0
    KILL = 1
    MULTIKILL = 2
    MEGAMISS = 3
    MISS = 4


class CustomInlineHeaderInlineHeaderType(betterproto.Enum):
    REQUEST_HEADER = 0
    REQUEST_TRAILER = 1
    RESPONSE_HEADER = 2
    RESPONSE_TRAILER = 3


@dataclass(eq=False, repr=False)
class Bootstrap(betterproto.Message):
    """
    Bootstrap :ref:`configuration overview <config_overview_bootstrap>`.
    [#next-free-field: 36]
    """

    node: "__core_v3__.Node" = betterproto.message_field(1)
    """
    Node identity to present to the management server and for instance
    identification purposes (e.g. in generated headers).
    """

    node_context_params: List[str] = betterproto.string_field(26)
    """
    A list of :ref:`Node <envoy_v3_api_msg_config.core.v3.Node>` field names
    that will be included in the context parameters of the effective xdstp://
    URL that is sent in a discovery request when resource locators are used for
    LDS/CDS. Any non-string field will have its JSON encoding set as the
    context parameter value, with the exception of metadata, which will be
    flattened (see example below). The supported field names are: - "cluster" -
    "id" - "locality.region" - "locality.sub_zone" - "locality.zone" -
    "metadata" - "user_agent_build_version.metadata" -
    "user_agent_build_version.version" - "user_agent_name" -
    "user_agent_version" The node context parameters act as a base layer
    dictionary for the context parameters (i.e. more specific resource specific
    context parameters will override). Field names will be prefixed with
    “udpa.node.” when included in context parameters. For example, if
    node_context_params is ``["user_agent_name", "metadata"]``, the implied
    context parameters might be::   node.user_agent_name: "envoy"
    node.metadata.foo: "{\"bar\": \"baz\"}"   node.metadata.some: "42"
    node.metadata.thing: "\"thing\"" [#not-implemented-hide:]
    """

    static_resources: "BootstrapStaticResources" = betterproto.message_field(2)
    """Statically specified resources."""

    dynamic_resources: "BootstrapDynamicResources" = betterproto.message_field(3)
    """xDS configuration sources."""

    cluster_manager: "ClusterManager" = betterproto.message_field(4)
    """
    Configuration for the cluster manager which owns all upstream clusters
    within the server.
    """

    hds_config: "__core_v3__.ApiConfigSource" = betterproto.message_field(14)
    """
    Health discovery service config option. (:ref:`core.ApiConfigSource
    <envoy_v3_api_msg_config.core.v3.ApiConfigSource>`)
    """

    flags_path: str = betterproto.string_field(5)
    """Optional file system path to search for startup flag files."""

    stats_sinks: List["__metrics_v3__.StatsSink"] = betterproto.message_field(6)
    """Optional set of stats sinks."""

    stats_config: "__metrics_v3__.StatsConfig" = betterproto.message_field(13)
    """Configuration for internal processing of stats."""

    stats_flush_interval: timedelta = betterproto.message_field(7)
    """
    Optional duration between flushes to configured stats sinks. For
    performance reasons Envoy latches counters and only flushes counters and
    gauges at a periodic interval. If not specified the default is 5000ms (5
    seconds). Only one of ``stats_flush_interval`` or ``stats_flush_on_admin``
    can be set. Duration must be at least 1ms and at most 5 min.
    """

    stats_flush_on_admin: bool = betterproto.bool_field(29, group="stats_flush")
    """
    Flush stats to sinks only when queried for on the admin interface. If set,
    a flush timer is not created. Only one of ``stats_flush_on_admin`` or
    ``stats_flush_interval`` can be set.
    """

    watchdog: "Watchdog" = betterproto.message_field(8)
    """
    Optional watchdog configuration. This is for a single watchdog
    configuration for the entire system. Deprecated in favor of ``watchdogs``
    which has finer granularity.
    """

    watchdogs: "Watchdogs" = betterproto.message_field(27)
    """
    Optional watchdogs configuration. This is used for specifying different
    watchdogs for the different subsystems. [#extension-category:
    envoy.guarddog_actions]
    """

    tracing: "__trace_v3__.Tracing" = betterproto.message_field(9)
    """
    Configuration for an external tracing provider. .. attention::  This field
    has been deprecated in favor of
    :ref:`HttpConnectionManager.Tracing.provider  <envoy_v3_api_field_extension
    s.filters.network.http_connection_manager.v3.HttpConnectionManager.Tracing.
    provider>`.
    """

    layered_runtime: "LayeredRuntime" = betterproto.message_field(17)
    """
    Configuration for the runtime configuration provider. If not specified, a
    “null” provider will be used which will result in all defaults being used.
    """

    admin: "Admin" = betterproto.message_field(12)
    """Configuration for the local administration HTTP server."""

    overload_manager: "__overload_v3__.OverloadManager" = betterproto.message_field(15)
    """Optional overload manager configuration."""

    enable_dispatcher_stats: bool = betterproto.bool_field(16)
    """
    Enable :ref:`stats for event dispatcher <operations_performance>`, defaults
    to false. Note that this records a value for each iteration of the event
    loop on every thread. This should normally be minimal overhead, but when
    using :ref:`statsd <envoy_v3_api_msg_config.metrics.v3.StatsdSink>`, it
    will send each observed value over the wire individually because the statsd
    protocol doesn't have any way to represent a histogram summary. Be aware
    that this can be a very large volume of data.
    """

    header_prefix: str = betterproto.string_field(18)
    """
    Optional string which will be used in lieu of x-envoy in prefixing headers.
    For example, if this string is present and set to X-Foo, then x-envoy-
    retry-on will be transformed into x-foo-retry-on etc. Note this applies to
    the headers Envoy will generate, the headers Envoy will sanitize, and the
    headers Envoy will trust for core code and core extensions only. Be VERY
    careful making changes to this string, especially in multi-layer Envoy
    deployments or deployments using extensions which are not upstream.
    """

    stats_server_version_override: Optional[int] = betterproto.message_field(
        19, wraps=betterproto.TYPE_UINT64
    )
    """
    Optional proxy version which will be used to set the value of
    :ref:`server.version statistic <server_statistics>` if specified. Envoy
    will not process this value, it will be sent as is to :ref:`stats sinks
    <envoy_v3_api_msg_config.metrics.v3.StatsSink>`.
    """

    use_tcp_for_dns_lookups: bool = betterproto.bool_field(20)
    """
    Always use TCP queries instead of UDP queries for DNS lookups. This may be
    overridden on a per-cluster basis in cds_config, when :ref:`dns_resolvers
    <envoy_v3_api_field_config.cluster.v3.Cluster.dns_resolvers>` and
    :ref:`use_tcp_for_dns_lookups
    <envoy_v3_api_field_config.cluster.v3.Cluster.use_tcp_for_dns_lookups>` are
    specified. This field is deprecated in favor of ``dns_resolution_config``
    which aggregates all of the DNS resolver configuration in a single message.
    """

    dns_resolution_config: "__core_v3__.DnsResolutionConfig" = (
        betterproto.message_field(30)
    )
    """
    DNS resolution configuration which includes the underlying dns resolver
    addresses and options. This may be overridden on a per-cluster basis in
    cds_config, when :ref:`dns_resolution_config
    <envoy_v3_api_field_config.cluster.v3.Cluster.dns_resolution_config>` is
    specified. This field is deprecated in favor of
    :ref:`typed_dns_resolver_config <envoy_v3_api_field_config.bootstrap.v3.Boo
    tstrap.typed_dns_resolver_config>`.
    """

    typed_dns_resolver_config: "__core_v3__.TypedExtensionConfig" = (
        betterproto.message_field(31)
    )
    """
    DNS resolver type configuration extension. This extension can be used to
    configure c-ares, apple, or any other DNS resolver types and the related
    parameters. For example, an object of :ref:`CaresDnsResolverConfig <envoy_v
    3_api_msg_extensions.network.dns_resolver.cares.v3.CaresDnsResolverConfig>`
    can be packed into this ``typed_dns_resolver_config``. This configuration
    replaces the :ref:`dns_resolution_config
    <envoy_v3_api_field_config.bootstrap.v3.Bootstrap.dns_resolution_config>`
    configuration. During the transition period when both
    ``dns_resolution_config`` and ``typed_dns_resolver_config`` exists, when
    ``typed_dns_resolver_config`` is in place, Envoy will use it and ignore
    ``dns_resolution_config``. When ``typed_dns_resolver_config`` is missing,
    the default behavior is in place. [#extension-category:
    envoy.network.dns_resolver]
    """

    bootstrap_extensions: List[
        "__core_v3__.TypedExtensionConfig"
    ] = betterproto.message_field(21)
    """
    Specifies optional bootstrap extensions to be instantiated at startup time.
    Each item contains extension specific configuration. [#extension-category:
    envoy.bootstrap]
    """

    fatal_actions: List["FatalAction"] = betterproto.message_field(28)
    """
    Specifies optional extensions instantiated at startup time and invoked
    during crash time on the request that caused the crash.
    """

    config_sources: List["__core_v3__.ConfigSource"] = betterproto.message_field(22)
    """
    Configuration sources that will participate in xdstp:// URL authority
    resolution. The algorithm is as follows: 1. The authority field is taken
    from the xdstp:// URL, call    this ``resource_authority``. 2.
    ``resource_authority`` is compared against the authorities in any peer
    ``ConfigSource``. The peer ``ConfigSource`` is the configuration source
    message which would have been used unconditionally for resolution    with
    opaque resource names. If there is a match with an authority, the    peer
    ``ConfigSource`` message is used. 3. ``resource_authority`` is compared
    sequentially with the authorities in    each configuration source in
    ``config_sources``. The first ``ConfigSource``    to match wins. 4. As a
    fallback, if no configuration source matches, then
    ``default_config_source`` is used. 5. If ``default_config_source`` is not
    specified, resolution fails. [#not-implemented-hide:]
    """

    default_config_source: "__core_v3__.ConfigSource" = betterproto.message_field(23)
    """
    Default configuration source for xdstp:// URLs if all other resolution
    fails. [#not-implemented-hide:]
    """

    default_socket_interface: str = betterproto.string_field(24)
    """
    Optional overriding of default socket interface. The value must be the name
    of one of the socket interface factories initialized through a bootstrap
    extension
    """

    certificate_provider_instances: Dict[
        str, "__core_v3__.TypedExtensionConfig"
    ] = betterproto.map_field(25, betterproto.TYPE_STRING, betterproto.TYPE_MESSAGE)
    """
    Global map of CertificateProvider instances. These instances are referred
    to by name in the
    :ref:`CommonTlsContext.CertificateProviderInstance.instance_name <envoy_v3_
    api_field_extensions.transport_sockets.tls.v3.CommonTlsContext.CertificateP
    roviderInstance.instance_name>` field. [#not-implemented-hide:]
    """

    inline_headers: List["CustomInlineHeader"] = betterproto.message_field(32)
    """
    Specifies a set of headers that need to be registered as inline header.
    This configuration allows users to customize the inline headers on-demand
    at Envoy startup without modifying Envoy's source code. Note that the 'set-
    cookie' header cannot be registered as inline header.
    """

    perf_tracing_file_path: str = betterproto.string_field(33)
    """
    Optional path to a file with performance tracing data created by "Perfetto"
    SDK in binary ProtoBuf format. The default value is "envoy.pftrace".
    """

    default_regex_engine: "__core_v3__.TypedExtensionConfig" = (
        betterproto.message_field(34)
    )
    """
    Optional overriding of default regex engine. If the value is not specified,
    Google RE2 will be used by default. [#extension-category:
    envoy.regex_engines]
    """

    xds_delegate_extension: "__core_v3__.TypedExtensionConfig" = (
        betterproto.message_field(35)
    )
    """
    Optional XdsResourcesDelegate configuration, which allows plugging custom
    logic into both fetch and load events during xDS processing. If a value is
    not specified, no XdsResourcesDelegate will be used. TODO(abeyad): Add
    public-facing documentation. [#not-implemented-hide:]
    """

    def __post_init__(self) -> None:
        super().__post_init__()
        if self.is_set("watchdog"):
            warnings.warn("Bootstrap.watchdog is deprecated", DeprecationWarning)
        if self.is_set("tracing"):
            warnings.warn("Bootstrap.tracing is deprecated", DeprecationWarning)
        if self.is_set("use_tcp_for_dns_lookups"):
            warnings.warn(
                "Bootstrap.use_tcp_for_dns_lookups is deprecated", DeprecationWarning
            )
        if self.is_set("dns_resolution_config"):
            warnings.warn(
                "Bootstrap.dns_resolution_config is deprecated", DeprecationWarning
            )


@dataclass(eq=False, repr=False)
class BootstrapStaticResources(betterproto.Message):
    listeners: List["__listener_v3__.Listener"] = betterproto.message_field(1)
    """
    Static :ref:`Listeners <envoy_v3_api_msg_config.listener.v3.Listener>`.
    These listeners are available regardless of LDS configuration.
    """

    clusters: List["__cluster_v3__.Cluster"] = betterproto.message_field(2)
    """
    If a network based configuration source is specified for :ref:`cds_config <
    envoy_v3_api_field_config.bootstrap.v3.Bootstrap.DynamicResources.cds_confi
    g>`, it's necessary to have some initial cluster definitions available to
    allow Envoy to know how to speak to the management server. These cluster
    definitions may not use :ref:`EDS <arch_overview_dynamic_config_eds>` (i.e.
    they should be static IP or DNS-based).
    """

    secrets: List[
        "___extensions_transport_sockets_tls_v3__.Secret"
    ] = betterproto.message_field(3)
    """
    These static secrets can be used by :ref:`SdsSecretConfig
    <envoy_v3_api_msg_extensions.transport_sockets.tls.v3.SdsSecretConfig>`
    """


@dataclass(eq=False, repr=False)
class BootstrapDynamicResources(betterproto.Message):
    """[#next-free-field: 7]"""

    lds_config: "__core_v3__.ConfigSource" = betterproto.message_field(1)
    """
    All :ref:`Listeners <envoy_v3_api_msg_config.listener.v3.Listener>` are
    provided by a single :ref:`LDS <arch_overview_dynamic_config_lds>`
    configuration source.
    """

    lds_resources_locator: str = betterproto.string_field(5)
    """
    xdstp:// resource locator for listener collection. [#not-implemented-hide:]
    """

    cds_config: "__core_v3__.ConfigSource" = betterproto.message_field(2)
    """
    All post-bootstrap :ref:`Cluster
    <envoy_v3_api_msg_config.cluster.v3.Cluster>` definitions are provided by a
    single :ref:`CDS <arch_overview_dynamic_config_cds>` configuration source.
    """

    cds_resources_locator: str = betterproto.string_field(6)
    """
    xdstp:// resource locator for cluster collection. [#not-implemented-hide:]
    """

    ads_config: "__core_v3__.ApiConfigSource" = betterproto.message_field(3)
    """
    A single :ref:`ADS <config_overview_ads>` source may be optionally
    specified. This must have :ref:`api_type
    <envoy_v3_api_field_config.core.v3.ApiConfigSource.api_type>` :ref:`GRPC
    <envoy_v3_api_enum_value_config.core.v3.ApiConfigSource.ApiType.GRPC>`.
    Only :ref:`ConfigSources <envoy_v3_api_msg_config.core.v3.ConfigSource>`
    that have the :ref:`ads
    <envoy_v3_api_field_config.core.v3.ConfigSource.ads>` field set will be
    streamed on the ADS channel.
    """


@dataclass(eq=False, repr=False)
class Admin(betterproto.Message):
    """
    Administration interface :ref:`operations documentation
    <operations_admin_interface>`. [#next-free-field: 7]
    """

    access_log: List["__accesslog_v3__.AccessLog"] = betterproto.message_field(5)
    """
    Configuration for :ref:`access logs <arch_overview_access_logs>` emitted by
    the administration server.
    """

    access_log_path: str = betterproto.string_field(1)
    """
    The path to write the access log for the administration server. If no
    access log is desired specify ‘/dev/null’. This is only required if
    :ref:`address <envoy_v3_api_field_config.bootstrap.v3.Admin.address>` is
    set. Deprecated in favor of ``access_log`` which offers more options.
    """

    profile_path: str = betterproto.string_field(2)
    """
    The cpu profiler output path for the administration server. If no profile
    path is specified, the default is ‘/var/log/envoy/envoy.prof’.
    """

    address: "__core_v3__.Address" = betterproto.message_field(3)
    """
    The TCP address that the administration server will listen on. If not
    specified, Envoy will not start an administration server.
    """

    socket_options: List["__core_v3__.SocketOption"] = betterproto.message_field(4)
    """
    Additional socket options that may not be present in Envoy source code or
    precompiled binaries.
    """

    ignore_global_conn_limit: bool = betterproto.bool_field(6)
    """
    Indicates whether :ref:`global_downstream_max_connections
    <config_overload_manager_limiting_connections>` should apply to the admin
    interface or not.
    """

    def __post_init__(self) -> None:
        super().__post_init__()
        if self.is_set("access_log_path"):
            warnings.warn("Admin.access_log_path is deprecated", DeprecationWarning)


@dataclass(eq=False, repr=False)
class ClusterManager(betterproto.Message):
    """
    Cluster manager :ref:`architecture overview
    <arch_overview_cluster_manager>`.
    """

    local_cluster_name: str = betterproto.string_field(1)
    """
    Name of the local cluster (i.e., the cluster that owns the Envoy running
    this configuration). In order to enable :ref:`zone aware routing
    <arch_overview_load_balancing_zone_aware_routing>` this option must be set.
    If ``local_cluster_name`` is defined then :ref:`clusters
    <envoy_v3_api_msg_config.cluster.v3.Cluster>` must be defined in the
    :ref:`Bootstrap static cluster resources <envoy_v3_api_field_config.bootstr
    ap.v3.Bootstrap.StaticResources.clusters>`. This is unrelated to the
    :option:`--service-cluster` option which does not `affect zone aware
    routing <https://github.com/envoyproxy/envoy/issues/774>`_.
    """

    outlier_detection: "ClusterManagerOutlierDetection" = betterproto.message_field(2)
    """Optional global configuration for outlier detection."""

    upstream_bind_config: "__core_v3__.BindConfig" = betterproto.message_field(3)
    """
    Optional configuration used to bind newly established upstream connections.
    This may be overridden on a per-cluster basis by upstream_bind_config in
    the cds_config.
    """

    load_stats_config: "__core_v3__.ApiConfigSource" = betterproto.message_field(4)
    """
    A management server endpoint to stream load stats to via
    ``StreamLoadStats``. This must have :ref:`api_type
    <envoy_v3_api_field_config.core.v3.ApiConfigSource.api_type>` :ref:`GRPC
    <envoy_v3_api_enum_value_config.core.v3.ApiConfigSource.ApiType.GRPC>`.
    """


@dataclass(eq=False, repr=False)
class ClusterManagerOutlierDetection(betterproto.Message):
    event_log_path: str = betterproto.string_field(1)
    """Specifies the path to the outlier event log."""

    event_service: "__core_v3__.EventServiceConfig" = betterproto.message_field(2)
    """
    [#not-implemented-hide:] The gRPC service for the outlier detection event
    service. If empty, outlier detection events won't be sent to a remote
    endpoint.
    """


@dataclass(eq=False, repr=False)
class Watchdogs(betterproto.Message):
    """
    Allows you to specify different watchdog configs for different subsystems.
    This allows finer tuned policies for the watchdog. If a subsystem is
    omitted the default values for that system will be used.
    """

    main_thread_watchdog: "Watchdog" = betterproto.message_field(1)
    """Watchdog for the main thread."""

    worker_watchdog: "Watchdog" = betterproto.message_field(2)
    """Watchdog for the worker threads."""


@dataclass(eq=False, repr=False)
class Watchdog(betterproto.Message):
    """
    Envoy process watchdog configuration. When configured, this monitors for
    nonresponsive threads and kills the process after the configured
    thresholds. See the :ref:`watchdog documentation
    <operations_performance_watchdog>` for more information. [#next-free-field:
    8]
    """

    actions: List["WatchdogWatchdogAction"] = betterproto.message_field(7)
    """
    Register actions that will fire on given WatchDog events. See
    ``WatchDogAction`` for priority of events.
    """

    miss_timeout: timedelta = betterproto.message_field(1)
    """
    The duration after which Envoy counts a nonresponsive thread in the
    ``watchdog_miss`` statistic. If not specified the default is 200ms.
    """

    megamiss_timeout: timedelta = betterproto.message_field(2)
    """
    The duration after which Envoy counts a nonresponsive thread in the
    ``watchdog_mega_miss`` statistic. If not specified the default is 1000ms.
    """

    kill_timeout: timedelta = betterproto.message_field(3)
    """
    If a watched thread has been nonresponsive for this duration, assume a
    programming error and kill the entire Envoy process. Set to 0 to disable
    kill behavior. If not specified the default is 0 (disabled).
    """

    max_kill_timeout_jitter: timedelta = betterproto.message_field(6)
    """
    Defines the maximum jitter used to adjust the ``kill_timeout`` if
    ``kill_timeout`` is enabled. Enabling this feature would help to reduce
    risk of synchronized watchdog kill events across proxies due to external
    triggers. Set to 0 to disable. If not specified the default is 0
    (disabled).
    """

    multikill_timeout: timedelta = betterproto.message_field(4)
    """
    If ``max(2, ceil(registered_threads * Fraction(*multikill_threshold*)))``
    threads have been nonresponsive for at least this duration kill the entire
    Envoy process. Set to 0 to disable this behavior. If not specified the
    default is 0 (disabled).
    """

    multikill_threshold: "___type_v3__.Percent" = betterproto.message_field(5)
    """
    Sets the threshold for ``multikill_timeout`` in terms of the percentage of
    nonresponsive threads required for the ``multikill_timeout``. If not
    specified the default is 0.
    """


@dataclass(eq=False, repr=False)
class WatchdogWatchdogAction(betterproto.Message):
    config: "__core_v3__.TypedExtensionConfig" = betterproto.message_field(1)
    """Extension specific configuration for the action."""

    event: "WatchdogWatchdogActionWatchdogEvent" = betterproto.enum_field(2)


@dataclass(eq=False, repr=False)
class FatalAction(betterproto.Message):
    """
    Fatal actions to run while crashing. Actions can be safe (meaning they are
    async-signal safe) or unsafe. We run all safe actions before we run unsafe
    actions. If using an unsafe action that could get stuck or deadlock, it
    important to have an out of band system to terminate the process. The
    interface for the extension is
    ``Envoy::Server::Configuration::FatalAction``. ``FatalAction`` extensions
    live in the ``envoy.extensions.fatal_actions`` API namespace.
    """

    config: "__core_v3__.TypedExtensionConfig" = betterproto.message_field(1)
    """
    Extension specific configuration for the action. It's expected to conform
    to the ``Envoy::Server::Configuration::FatalAction`` interface.
    """


@dataclass(eq=False, repr=False)
class Runtime(betterproto.Message):
    """Runtime :ref:`configuration overview <config_runtime>` (deprecated)."""

    symlink_root: str = betterproto.string_field(1)
    """
    The implementation assumes that the file system tree is accessed via a
    symbolic link. An atomic link swap is used when a new tree should be
    switched to. This parameter specifies the path to the symbolic link. Envoy
    will watch the location for changes and reload the file system tree when
    they happen. If this parameter is not set, there will be no disk based
    runtime.
    """

    subdirectory: str = betterproto.string_field(2)
    """
    Specifies the subdirectory to load within the root directory. This is
    useful if multiple systems share the same delivery mechanism. Envoy
    configuration elements can be contained in a dedicated subdirectory.
    """

    override_subdirectory: str = betterproto.string_field(3)
    """
    Specifies an optional subdirectory to load within the root directory. If
    specified and the directory exists, configuration values within this
    directory will override those found in the primary subdirectory. This is
    useful when Envoy is deployed across many different types of servers.
    Sometimes it is useful to have a per service cluster directory for runtime
    configuration. See below for exactly how the override directory is used.
    """

    base: "betterproto_lib_google_protobuf.Struct" = betterproto.message_field(4)
    """
    Static base runtime. This will be :ref:`overridden
    <config_runtime_layering>` by other runtime layers, e.g. disk or admin.
    This follows the :ref:`runtime protobuf JSON representation encoding
    <config_runtime_proto_json>`.
    """


@dataclass(eq=False, repr=False)
class RuntimeLayer(betterproto.Message):
    """[#next-free-field: 6]"""

    name: str = betterproto.string_field(1)
    """
    Descriptive name for the runtime layer. This is only used for the runtime
    :http:get:`/runtime` output.
    """

    static_layer: "betterproto_lib_google_protobuf.Struct" = betterproto.message_field(
        2, group="layer_specifier"
    )
    """
    :ref:`Static runtime <config_runtime_bootstrap>` layer. This follows the
    :ref:`runtime protobuf JSON representation encoding
    <config_runtime_proto_json>`. Unlike static xDS resources, this static
    layer is overridable by later layers in the runtime virtual filesystem.
    """

    disk_layer: "RuntimeLayerDiskLayer" = betterproto.message_field(
        3, group="layer_specifier"
    )
    admin_layer: "RuntimeLayerAdminLayer" = betterproto.message_field(
        4, group="layer_specifier"
    )
    rtds_layer: "RuntimeLayerRtdsLayer" = betterproto.message_field(
        5, group="layer_specifier"
    )


@dataclass(eq=False, repr=False)
class RuntimeLayerDiskLayer(betterproto.Message):
    """:ref:`Disk runtime <config_runtime_local_disk>` layer."""

    symlink_root: str = betterproto.string_field(1)
    """
    The implementation assumes that the file system tree is accessed via a
    symbolic link. An atomic link swap is used when a new tree should be
    switched to. This parameter specifies the path to the symbolic link. Envoy
    will watch the location for changes and reload the file system tree when
    they happen. See documentation on runtime :ref:`atomicity
    <config_runtime_atomicity>` for further details on how reloads are treated.
    """

    subdirectory: str = betterproto.string_field(3)
    """
    Specifies the subdirectory to load within the root directory. This is
    useful if multiple systems share the same delivery mechanism. Envoy
    configuration elements can be contained in a dedicated subdirectory.
    """

    append_service_cluster: bool = betterproto.bool_field(2)
    """
    :ref:`Append <config_runtime_local_disk_service_cluster_subdirs>` the
    service cluster to the path under symlink root.
    """


@dataclass(eq=False, repr=False)
class RuntimeLayerAdminLayer(betterproto.Message):
    """:ref:`Admin console runtime <config_runtime_admin>` layer."""

    pass


@dataclass(eq=False, repr=False)
class RuntimeLayerRtdsLayer(betterproto.Message):
    """:ref:`Runtime Discovery Service (RTDS) <config_runtime_rtds>` layer."""

    name: str = betterproto.string_field(1)
    """Resource to subscribe to at ``rtds_config`` for the RTDS layer."""

    rtds_config: "__core_v3__.ConfigSource" = betterproto.message_field(2)
    """RTDS configuration source."""


@dataclass(eq=False, repr=False)
class LayeredRuntime(betterproto.Message):
    """Runtime :ref:`configuration overview <config_runtime>`."""

    layers: List["RuntimeLayer"] = betterproto.message_field(1)
    """
    The :ref:`layers <config_runtime_layering>` of the runtime. This is ordered
    such that later layers in the list overlay earlier entries.
    """


@dataclass(eq=False, repr=False)
class CustomInlineHeader(betterproto.Message):
    """
    Used to specify the header that needs to be registered as an inline header.
    If request or response contain multiple headers with the same name and the
    header name is registered as an inline header. Then multiple headers will
    be folded into one, and multiple header values will be concatenated by a
    suitable delimiter. The delimiter is generally a comma. For example, if
    'foo' is registered as an inline header, and the headers contains the
    following two headers: .. code-block:: text   foo: bar   foo: eep Then they
    will eventually be folded into: .. code-block:: text   foo: bar, eep Inline
    headers provide O(1) search performance, but each inline header imposes an
    additional memory overhead on all instances of the corresponding type of
    HeaderMap or TrailerMap.
    """

    inline_header_name: str = betterproto.string_field(1)
    """
    The name of the header that is expected to be set as the inline header.
    """

    inline_header_type: "CustomInlineHeaderInlineHeaderType" = betterproto.enum_field(2)
    """
    The type of the header that is expected to be set as the inline header.
    """
