# Generated by the protocol buffer compiler.  DO NOT EDIT!
# sources: envoy/config/accesslog/v2/als.proto, envoy/config/accesslog/v2/file.proto
# plugin: python-betterproto
from dataclasses import dataclass
from datetime import timedelta
from typing import (
    List,
    Optional,
)

import betterproto
import betterproto.lib.google.protobuf as betterproto_lib_google_protobuf

from ....api.v2 import core as ___api_v2_core__


@dataclass(eq=False, repr=False)
class HttpGrpcAccessLogConfig(betterproto.Message):
    """
    Configuration for the built-in *envoy.access_loggers.http_grpc*
    :ref:`AccessLog <envoy_api_msg_config.filter.accesslog.v2.AccessLog>`. This
    configuration will populate :ref:`StreamAccessLogsMessage.http_logs
    <envoy_api_field_service.accesslog.v2.StreamAccessLogsMessage.http_logs>`.
    [#extension: envoy.access_loggers.http_grpc]
    """

    common_config: "CommonGrpcAccessLogConfig" = betterproto.message_field(1)
    additional_request_headers_to_log: List[str] = betterproto.string_field(2)
    """
    Additional request headers to log in
    :ref:`HTTPRequestProperties.request_headers
    <envoy_api_field_data.accesslog.v2.HTTPRequestProperties.request_headers>`.
    """

    additional_response_headers_to_log: List[str] = betterproto.string_field(3)
    """
    Additional response headers to log in
    :ref:`HTTPResponseProperties.response_headers <envoy_api_field_data.accessl
    og.v2.HTTPResponseProperties.response_headers>`.
    """

    additional_response_trailers_to_log: List[str] = betterproto.string_field(4)
    """
    Additional response trailers to log in
    :ref:`HTTPResponseProperties.response_trailers <envoy_api_field_data.access
    log.v2.HTTPResponseProperties.response_trailers>`.
    """


@dataclass(eq=False, repr=False)
class TcpGrpcAccessLogConfig(betterproto.Message):
    """
    Configuration for the built-in *envoy.access_loggers.tcp_grpc* type. This
    configuration will populate *StreamAccessLogsMessage.tcp_logs*.
    [#extension: envoy.access_loggers.tcp_grpc]
    """

    common_config: "CommonGrpcAccessLogConfig" = betterproto.message_field(1)


@dataclass(eq=False, repr=False)
class CommonGrpcAccessLogConfig(betterproto.Message):
    """Common configuration for gRPC access logs. [#next-free-field: 6]"""

    log_name: str = betterproto.string_field(1)
    """
    The friendly name of the access log to be returned in
    :ref:`StreamAccessLogsMessage.Identifier
    <envoy_api_msg_service.accesslog.v2.StreamAccessLogsMessage.Identifier>`.
    This allows the access log server to differentiate between different access
    logs coming from the same Envoy.
    """

    grpc_service: "___api_v2_core__.GrpcService" = betterproto.message_field(2)
    """The gRPC service for the access log service."""

    buffer_flush_interval: timedelta = betterproto.message_field(3)
    """
    Interval for flushing access logs to the gRPC stream. Logger will flush
    requests every time this interval is elapsed, or when batch size limit is
    hit, whichever comes first. Defaults to 1 second.
    """

    buffer_size_bytes: Optional[int] = betterproto.message_field(
        4, wraps=betterproto.TYPE_UINT32
    )
    """
    Soft size limit in bytes for access log entries buffer. Logger will buffer
    requests until this limit it hit, or every time flush interval is elapsed,
    whichever comes first. Setting it to zero effectively disables the
    batching. Defaults to 16384.
    """

    filter_state_objects_to_log: List[str] = betterproto.string_field(5)
    """
    Additional filter state objects to log in :ref:`filter_state_objects
    <envoy_api_field_data.accesslog.v2.AccessLogCommon.filter_state_objects>`.
    Logger will call `FilterState::Object::serializeAsProto` to serialize the
    filter state object.
    """


@dataclass(eq=False, repr=False)
class FileAccessLog(betterproto.Message):
    """
    Custom configuration for an :ref:`AccessLog
    <envoy_api_msg_config.filter.accesslog.v2.AccessLog>` that writes log
    entries directly to a file. Configures the built-in
    *envoy.access_loggers.file* AccessLog.
    """

    path: str = betterproto.string_field(1)
    """A path to a local file to which to write the access log entries."""

    format: str = betterproto.string_field(2, group="access_log_format")
    """
    Access log :ref:`format string<config_access_log_format_strings>`. Envoy
    supports :ref:`custom access log formats <config_access_log_format>` as
    well as a :ref:`default format <config_access_log_default_format>`.
    """

    json_format: "betterproto_lib_google_protobuf.Struct" = betterproto.message_field(
        3, group="access_log_format"
    )
    """
    Access log :ref:`format dictionary<config_access_log_format_dictionaries>`.
    All values are rendered as strings.
    """

    typed_json_format: "betterproto_lib_google_protobuf.Struct" = (
        betterproto.message_field(4, group="access_log_format")
    )
    """
    Access log :ref:`format dictionary<config_access_log_format_dictionaries>`.
    Values are rendered as strings, numbers, or boolean values as appropriate.
    Nested JSON objects may be produced by some command operators
    (e.g.FILTER_STATE or DYNAMIC_METADATA). See the documentation for a
    specific command operator for details.
    """
