# Generated by the protocol buffer compiler.  DO NOT EDIT!
# sources: envoy/api/v2/cds.proto, envoy/api/v2/cluster.proto, envoy/api/v2/discovery.proto, envoy/api/v2/eds.proto, envoy/api/v2/endpoint.proto, envoy/api/v2/lds.proto, envoy/api/v2/listener.proto, envoy/api/v2/rds.proto, envoy/api/v2/route.proto, envoy/api/v2/scoped_route.proto, envoy/api/v2/srds.proto
# plugin: python-betterproto
import warnings
from dataclasses import dataclass
from datetime import timedelta
from typing import (
    TYPE_CHECKING,
    AsyncIterable,
    AsyncIterator,
    Dict,
    Iterable,
    List,
    Optional,
    Union,
)

import betterproto
import betterproto.lib.google.protobuf as betterproto_lib_google_protobuf
import grpclib
from betterproto.grpc.grpclib_server import ServiceBase

from ....google import rpc as ___google_rpc__
from ... import type as __type__
from ...config.filter.accesslog import v2 as __config_filter_accesslog_v2__
from ...config.listener import v2 as __config_listener_v2__
from . import (
    auth,
    cluster,
    core,
    endpoint,
    listener,
    route,
)


if TYPE_CHECKING:
    import grpclib.server
    from betterproto.grpc.grpclib_client import MetadataLike
    from grpclib.metadata import Deadline


class ClusterDiscoveryType(betterproto.Enum):
    """
    Refer to :ref:`service discovery type
    <arch_overview_service_discovery_types>` for an explanation on each type.
    """

    STATIC = 0
    """
    Refer to the :ref:`static discovery
    type<arch_overview_service_discovery_types_static>` for an explanation.
    """

    STRICT_DNS = 1
    """
    Refer to the :ref:`strict DNS discovery
    type<arch_overview_service_discovery_types_strict_dns>` for an explanation.
    """

    LOGICAL_DNS = 2
    """
    Refer to the :ref:`logical DNS discovery
    type<arch_overview_service_discovery_types_logical_dns>` for an
    explanation.
    """

    EDS = 3
    """
    Refer to the :ref:`service discovery
    type<arch_overview_service_discovery_types_eds>` for an explanation.
    """

    ORIGINAL_DST = 4
    """
    Refer to the :ref:`original destination discovery
    type<arch_overview_service_discovery_types_original_destination>` for an
    explanation.
    """


class ClusterLbPolicy(betterproto.Enum):
    """
    Refer to :ref:`load balancer type <arch_overview_load_balancing_types>`
    architecture overview section for information on each type.
    """

    ROUND_ROBIN = 0
    """
    Refer to the :ref:`round robin load balancing
    policy<arch_overview_load_balancing_types_round_robin>` for an explanation.
    """

    LEAST_REQUEST = 1
    """
    Refer to the :ref:`least request load balancing
    policy<arch_overview_load_balancing_types_least_request>` for an
    explanation.
    """

    RING_HASH = 2
    """
    Refer to the :ref:`ring hash load balancing
    policy<arch_overview_load_balancing_types_ring_hash>` for an explanation.
    """

    RANDOM = 3
    """
    Refer to the :ref:`random load balancing
    policy<arch_overview_load_balancing_types_random>` for an explanation.
    """

    ORIGINAL_DST_LB = 4
    """
    Refer to the :ref:`original destination load balancing
    policy<arch_overview_load_balancing_types_original_destination>` for an
    explanation. .. attention::   **This load balancing policy is deprecated**.
    Use CLUSTER_PROVIDED instead.
    """

    MAGLEV = 5
    """
    Refer to the :ref:`Maglev load balancing
    policy<arch_overview_load_balancing_types_maglev>` for an explanation.
    """

    CLUSTER_PROVIDED = 6
    """
    This load balancer type must be specified if the configured cluster
    provides a cluster specific load balancer. Consult the configured cluster's
    documentation for whether to set this option or not.
    """

    LOAD_BALANCING_POLICY_CONFIG = 7
    """
    [#not-implemented-hide:] Use the new :ref:`load_balancing_policy
    <envoy_api_field_Cluster.load_balancing_policy>` field to determine the LB
    policy. [#next-major-version: In the v3 API, we should consider deprecating
    the lb_policy field and instead using the new load_balancing_policy field
    as the one and only mechanism for configuring this.]
    """


class ClusterDnsLookupFamily(betterproto.Enum):
    """
    When V4_ONLY is selected, the DNS resolver will only perform a lookup for
    addresses in the IPv4 family. If V6_ONLY is selected, the DNS resolver will
    only perform a lookup for addresses in the IPv6 family. If AUTO is
    specified, the DNS resolver will first perform a lookup for addresses in
    the IPv6 family and fallback to a lookup for addresses in the IPv4 family.
    For cluster types other than
    :ref:`STRICT_DNS<envoy_api_enum_value_Cluster.DiscoveryType.STRICT_DNS>`
    and
    :ref:`LOGICAL_DNS<envoy_api_enum_value_Cluster.DiscoveryType.LOGICAL_DNS>`,
    this setting is ignored.
    """

    AUTO = 0
    V4_ONLY = 1
    V6_ONLY = 2


class ClusterClusterProtocolSelection(betterproto.Enum):
    USE_CONFIGURED_PROTOCOL = 0
    """
    Cluster can only operate on one of the possible upstream protocols
    (HTTP1.1, HTTP2). If :ref:`http2_protocol_options
    <envoy_api_field_Cluster.http2_protocol_options>` are present, HTTP2 will
    be used, otherwise HTTP1.1 will be used.
    """

    USE_DOWNSTREAM_PROTOCOL = 1
    """
    Use HTTP1.1 or HTTP2, depending on which one is used on the downstream
    connection.
    """


class ClusterLbSubsetConfigLbSubsetFallbackPolicy(betterproto.Enum):
    """
    If NO_FALLBACK is selected, a result equivalent to no healthy hosts is
    reported. If ANY_ENDPOINT is selected, any cluster endpoint may be returned
    (subject to policy, health checks, etc). If DEFAULT_SUBSET is selected,
    load balancing is performed over the endpoints matching the values from the
    default_subset field.
    """

    NO_FALLBACK = 0
    ANY_ENDPOINT = 1
    DEFAULT_SUBSET = 2


class ClusterLbSubsetConfigLbSubsetSelectorLbSubsetSelectorFallbackPolicy(
    betterproto.Enum
):
    """Allows to override top level fallback policy per selector."""

    NOT_DEFINED = 0
    """If NOT_DEFINED top level config fallback policy is used instead."""

    NO_FALLBACK = 1
    """
    If NO_FALLBACK is selected, a result equivalent to no healthy hosts is
    reported.
    """

    ANY_ENDPOINT = 2
    """
    If ANY_ENDPOINT is selected, any cluster endpoint may be returned (subject
    to policy, health checks, etc).
    """

    DEFAULT_SUBSET = 3
    """
    If DEFAULT_SUBSET is selected, load balancing is performed over the
    endpoints matching the values from the default_subset field.
    """

    KEYS_SUBSET = 4
    """
    If KEYS_SUBSET is selected, subset selector matching is performed again
    with metadata keys reduced to :ref:`fallback_keys_subset<envoy_api_field_Cl
    uster.LbSubsetConfig.LbSubsetSelector.fallback_keys_subset>`. It allows for
    a fallback to a different, less specific selector if some of the keys of
    the selector are considered optional.
    """


class ClusterRingHashLbConfigHashFunction(betterproto.Enum):
    """The hash function used to hash hosts onto the ketama ring."""

    XX_HASH = 0
    """
    Use `xxHash <https://github.com/Cyan4973/xxHash>`_, this is the default
    hash function.
    """

    MURMUR_HASH_2 = 1
    """
    Use `MurmurHash2 <https://sites.google.com/site/murmurhash/>`_, this is
    compatible with std:hash<string> in GNU libstdc++ 3.4.20 or above. This is
    typically the case when compiled on Linux and not macOS.
    """


class ListenerDrainType(betterproto.Enum):
    DEFAULT = 0
    """
    Drain in response to calling /healthcheck/fail admin endpoint (along with
    the health check filter), listener removal/modification, and hot restart.
    """

    MODIFY_ONLY = 1
    """
    Drain in response to listener removal/modification and hot restart. This
    setting does not include /healthcheck/fail. This setting may be desirable
    if Envoy is hosting both ingress and egress listeners.
    """


@dataclass(eq=False, repr=False)
class DiscoveryRequest(betterproto.Message):
    """
    A DiscoveryRequest requests a set of versioned resources of the same type
    for a given Envoy node on some API. [#next-free-field: 7]
    """

    version_info: str = betterproto.string_field(1)
    """
    The version_info provided in the request messages will be the version_info
    received with the most recent successfully processed response or empty on
    the first request. It is expected that no new request is sent after a
    response is received until the Envoy instance is ready to ACK/NACK the new
    configuration. ACK/NACK takes place by returning the new API config version
    as applied or the previous API config version respectively. Each type_url
    (see below) has an independent version associated with it.
    """

    node: "core.Node" = betterproto.message_field(2)
    """The node making the request."""

    resource_names: List[str] = betterproto.string_field(3)
    """
    List of resources to subscribe to, e.g. list of cluster names or a route
    configuration name. If this is empty, all resources for the API are
    returned. LDS/CDS may have empty resource_names, which will cause all
    resources for the Envoy instance to be returned. The LDS and CDS responses
    will then imply a number of resources that need to be fetched via EDS/RDS,
    which will be explicitly enumerated in resource_names.
    """

    type_url: str = betterproto.string_field(4)
    """
    Type of the resource that is being requested, e.g.
    "type.googleapis.com/envoy.api.v2.ClusterLoadAssignment". This is implicit
    in requests made via singleton xDS APIs such as CDS, LDS, etc. but is
    required for ADS.
    """

    response_nonce: str = betterproto.string_field(5)
    """
    nonce corresponding to DiscoveryResponse being ACK/NACKed. See above
    discussion on version_info and the DiscoveryResponse nonce comment. This
    may be empty only if 1) this is a non-persistent-stream xDS such as HTTP,
    or 2) the client has not yet accepted an update in this xDS stream (unlike
    delta, where it is populated only for new explicit ACKs).
    """

    error_detail: "___google_rpc__.Status" = betterproto.message_field(6)
    """
    This is populated when the previous :ref:`DiscoveryResponse
    <envoy_api_msg_DiscoveryResponse>` failed to update configuration. The
    *message* field in *error_details* provides the Envoy internal exception
    related to the failure. It is only intended for consumption during manual
    debugging, the string provided is not guaranteed to be stable across Envoy
    versions.
    """


@dataclass(eq=False, repr=False)
class DiscoveryResponse(betterproto.Message):
    """[#next-free-field: 7]"""

    version_info: str = betterproto.string_field(1)
    """The version of the response data."""

    resources: List["betterproto_lib_google_protobuf.Any"] = betterproto.message_field(
        2
    )
    """
    The response resources. These resources are typed and depend on the API
    being called.
    """

    canary: bool = betterproto.bool_field(3)
    """
    [#not-implemented-hide:] Canary is used to support two Envoy command line
    flags: * --terminate-on-canary-transition-failure. When set, Envoy is able
    to   terminate if it detects that configuration is stuck at canary.
    Consider   this example sequence of updates:   - Management server applies
    a canary config successfully.   - Management server rolls back to a
    production config.   - Envoy rejects the new production config.   Since
    there is no sensible way to continue receiving configuration   updates,
    Envoy will then terminate and apply production config from a   clean slate.
    * --dry-run-canary. When set, a canary response will never be applied, only
    validated via a dry run.
    """

    type_url: str = betterproto.string_field(4)
    """
    Type URL for resources. Identifies the xDS API when muxing over ADS. Must
    be consistent with the type_url in the 'resources' repeated Any (if non-
    empty).
    """

    nonce: str = betterproto.string_field(5)
    """
    For gRPC based subscriptions, the nonce provides a way to explicitly ack a
    specific DiscoveryResponse in a following DiscoveryRequest. Additional
    messages may have been sent by Envoy to the management server for the
    previous version on the stream prior to this DiscoveryResponse, that were
    unprocessed at response send time. The nonce allows the management server
    to ignore any further DiscoveryRequests for the previous version until a
    DiscoveryRequest bearing the nonce. The nonce is optional and is not
    required for non-stream based xDS implementations.
    """

    control_plane: "core.ControlPlane" = betterproto.message_field(6)
    """
    [#not-implemented-hide:] The control plane instance that sent the response.
    """


@dataclass(eq=False, repr=False)
class DeltaDiscoveryRequest(betterproto.Message):
    """
    DeltaDiscoveryRequest and DeltaDiscoveryResponse are used in a new gRPC
    endpoint for Delta xDS. With Delta xDS, the DeltaDiscoveryResponses do not
    need to include a full snapshot of the tracked resources. Instead,
    DeltaDiscoveryResponses are a diff to the state of a xDS client. In Delta
    XDS there are per-resource versions, which allow tracking state at the
    resource granularity. An xDS Delta session is always in the context of a
    gRPC bidirectional stream. This allows the xDS server to keep track of the
    state of xDS clients connected to it. In Delta xDS the nonce field is
    required and used to pair DeltaDiscoveryResponse to a DeltaDiscoveryRequest
    ACK or NACK. Optionally, a response message level system_version_info is
    present for debugging purposes only. DeltaDiscoveryRequest plays two
    independent roles. Any DeltaDiscoveryRequest can be either or both of: [1]
    informing the server of what resources the client has gained/lost interest
    in (using resource_names_subscribe and resource_names_unsubscribe), or [2]
    (N)ACKing an earlier resource update from the server (using response_nonce,
    with presence of error_detail making it a NACK). Additionally, the first
    message (for a given type_url) of a reconnected gRPC stream has a third
    role: informing the server of the resources (and their versions) that the
    client already possesses, using the initial_resource_versions field. As
    with state-of-the-world, when multiple resource types are multiplexed
    (ADS), all requests/acknowledgments/updates are logically walled off by
    type_url: a Cluster ACK exists in a completely separate world from a prior
    Route NACK. In particular, initial_resource_versions being sent at the
    "start" of every gRPC stream actually entails a message for each type_url,
    each with its own initial_resource_versions. [#next-free-field: 8]
    """

    node: "core.Node" = betterproto.message_field(1)
    """The node making the request."""

    type_url: str = betterproto.string_field(2)
    """
    Type of the resource that is being requested, e.g.
    "type.googleapis.com/envoy.api.v2.ClusterLoadAssignment".
    """

    resource_names_subscribe: List[str] = betterproto.string_field(3)
    """
    DeltaDiscoveryRequests allow the client to add or remove individual
    resources to the set of tracked resources in the context of a stream. All
    resource names in the resource_names_subscribe list are added to the set of
    tracked resources and all resource names in the resource_names_unsubscribe
    list are removed from the set of tracked resources. *Unlike* state-of-the-
    world xDS, an empty resource_names_subscribe or resource_names_unsubscribe
    list simply means that no resources are to be added or removed to the
    resource list. *Like* state-of-the-world xDS, the server must send updates
    for all tracked resources, but can also send updates for resources the
    client has not subscribed to. NOTE: the server must respond with all
    resources listed in resource_names_subscribe, even if it believes the
    client has the most recent version of them. The reason: the client may have
    dropped them, but then regained interest before it had a chance to send the
    unsubscribe message. See DeltaSubscriptionStateTest.RemoveThenAdd. These
    two fields can be set in any DeltaDiscoveryRequest, including ACKs and
    initial_resource_versions. A list of Resource names to add to the list of
    tracked resources.
    """

    resource_names_unsubscribe: List[str] = betterproto.string_field(4)
    """
    A list of Resource names to remove from the list of tracked resources.
    """

    initial_resource_versions: Dict[str, str] = betterproto.map_field(
        5, betterproto.TYPE_STRING, betterproto.TYPE_STRING
    )
    """
    Informs the server of the versions of the resources the xDS client knows
    of, to enable the client to continue the same logical xDS session even in
    the face of gRPC stream reconnection. It will not be populated: [1] in the
    very first stream of a session, since the client will not yet have any
    resources,  [2] in any message after the first in a stream (for a given
    type_url), since the server will already be correctly tracking the client's
    state. (In ADS, the first message *of each type_url* of a reconnected
    stream populates this map.) The map's keys are names of xDS resources known
    to the xDS client. The map's values are opaque resource versions.
    """

    response_nonce: str = betterproto.string_field(6)
    """
    When the DeltaDiscoveryRequest is a ACK or NACK message in response to a
    previous DeltaDiscoveryResponse, the response_nonce must be the nonce in
    the DeltaDiscoveryResponse. Otherwise (unlike in DiscoveryRequest)
    response_nonce must be omitted.
    """

    error_detail: "___google_rpc__.Status" = betterproto.message_field(7)
    """
    This is populated when the previous :ref:`DiscoveryResponse
    <envoy_api_msg_DiscoveryResponse>` failed to update configuration. The
    *message* field in *error_details* provides the Envoy internal exception
    related to the failure.
    """


@dataclass(eq=False, repr=False)
class DeltaDiscoveryResponse(betterproto.Message):
    """[#next-free-field: 7]"""

    system_version_info: str = betterproto.string_field(1)
    """The version of the response data (used for debugging)."""

    resources: List["Resource"] = betterproto.message_field(2)
    """
    The response resources. These are typed resources, whose types must match
    the type_url field.
    """

    type_url: str = betterproto.string_field(4)
    """
    Type URL for resources. Identifies the xDS API when muxing over ADS. Must
    be consistent with the type_url in the Any within 'resources' if
    'resources' is non-empty.
    """

    removed_resources: List[str] = betterproto.string_field(6)
    """
    Resources names of resources that have be deleted and to be removed from
    the xDS Client. Removed resources for missing resources can be ignored.
    """

    nonce: str = betterproto.string_field(5)
    """
    The nonce provides a way for DeltaDiscoveryRequests to uniquely reference a
    DeltaDiscoveryResponse when (N)ACKing. The nonce is required.
    """


@dataclass(eq=False, repr=False)
class Resource(betterproto.Message):
    name: str = betterproto.string_field(3)
    """
    The resource's name, to distinguish it from others of the same type of
    resource.
    """

    aliases: List[str] = betterproto.string_field(4)
    """The aliases are a list of other names that this resource can go by."""

    version: str = betterproto.string_field(1)
    """
    The resource level version. It allows xDS to track the state of individual
    resources.
    """

    resource: "betterproto_lib_google_protobuf.Any" = betterproto.message_field(2)
    """The resource being tracked."""


@dataclass(eq=False, repr=False)
class RouteConfiguration(betterproto.Message):
    """[#next-free-field: 11]"""

    name: str = betterproto.string_field(1)
    """
    The name of the route configuration. For example, it might match
    :ref:`route_config_name <envoy_api_field_config.filter.network.http_connect
    ion_manager.v2.Rds.route_config_name>` in
    :ref:`envoy_api_msg_config.filter.network.http_connection_manager.v2.Rds`.
    """

    virtual_hosts: List["route.VirtualHost"] = betterproto.message_field(2)
    """An array of virtual hosts that make up the route table."""

    vhds: "Vhds" = betterproto.message_field(9)
    """
    An array of virtual hosts will be dynamically loaded via the VHDS API. Both
    *virtual_hosts* and *vhds* fields will be used when present.
    *virtual_hosts* can be used for a base routing table or for infrequently
    changing virtual hosts. *vhds* is used for on-demand discovery of virtual
    hosts. The contents of these two fields will be merged to generate a
    routing table for a given RouteConfiguration, with *vhds* derived
    configuration taking precedence.
    """

    internal_only_headers: List[str] = betterproto.string_field(3)
    """
    Optionally specifies a list of HTTP headers that the connection manager
    will consider to be internal only. If they are found on external requests
    they will be cleaned prior to filter invocation. See
    :ref:`config_http_conn_man_headers_x-envoy-internal` for more information.
    """

    response_headers_to_add: List["core.HeaderValueOption"] = betterproto.message_field(
        4
    )
    """
    Specifies a list of HTTP headers that should be added to each response that
    the connection manager encodes. Headers specified at this level are applied
    after headers from any enclosed :ref:`envoy_api_msg_route.VirtualHost` or
    :ref:`envoy_api_msg_route.RouteAction`. For more information, including
    details on header value syntax, see the documentation on :ref:`custom
    request headers <config_http_conn_man_headers_custom_request_headers>`.
    """

    response_headers_to_remove: List[str] = betterproto.string_field(5)
    """
    Specifies a list of HTTP headers that should be removed from each response
    that the connection manager encodes.
    """

    request_headers_to_add: List["core.HeaderValueOption"] = betterproto.message_field(
        6
    )
    """
    Specifies a list of HTTP headers that should be added to each request
    routed by the HTTP connection manager. Headers specified at this level are
    applied after headers from any enclosed
    :ref:`envoy_api_msg_route.VirtualHost` or
    :ref:`envoy_api_msg_route.RouteAction`. For more information, including
    details on header value syntax, see the documentation on :ref:`custom
    request headers <config_http_conn_man_headers_custom_request_headers>`.
    """

    request_headers_to_remove: List[str] = betterproto.string_field(8)
    """
    Specifies a list of HTTP headers that should be removed from each request
    routed by the HTTP connection manager.
    """

    most_specific_header_mutations_wins: bool = betterproto.bool_field(10)
    """
    By default, headers that should be added/removed are evaluated from most to
    least specific: * route level * virtual host level * connection manager
    level To allow setting overrides at the route or virtual host level, this
    order can be reversed by setting this option to true. Defaults to false.
    [#next-major-version: In the v3 API, this will default to true.]
    """

    validate_clusters: Optional[bool] = betterproto.message_field(
        7, wraps=betterproto.TYPE_BOOL
    )
    """
    An optional boolean that specifies whether the clusters that the route
    table refers to will be validated by the cluster manager. If set to true
    and a route refers to a non-existent cluster, the route table will not
    load. If set to false and a route refers to a non-existent cluster, the
    route table will load and the router filter will return a 404 if the route
    is selected at runtime. This setting defaults to true if the route table is
    statically defined via the :ref:`route_config <envoy_api_field_config.filte
    r.network.http_connection_manager.v2.HttpConnectionManager.route_config>`
    option. This setting default to false if the route table is loaded
    dynamically via the :ref:`rds <envoy_api_field_config.filter.network.http_c
    onnection_manager.v2.HttpConnectionManager.rds>` option. Users may wish to
    override the default behavior in certain cases (for example when using CDS
    with a static route table).
    """


@dataclass(eq=False, repr=False)
class Vhds(betterproto.Message):
    config_source: "core.ConfigSource" = betterproto.message_field(1)
    """Configuration source specifier for VHDS."""


@dataclass(eq=False, repr=False)
class RdsDummy(betterproto.Message):
    """
    [#not-implemented-hide:] Not configuration. Workaround c++ protobuf issue
    with importing services: https://github.com/google/protobuf/issues/4221 and
    protoxform to upgrade the file.
    """

    pass


@dataclass(eq=False, repr=False)
class ClusterLoadAssignment(betterproto.Message):
    """
    Each route from RDS will map to a single cluster or traffic split across
    clusters using weights expressed in the RDS WeightedCluster. With EDS, each
    cluster is treated independently from a LB perspective, with LB taking
    place between the Localities within a cluster and at a finer granularity
    between the hosts within a locality. The percentage of traffic for each
    endpoint is determined by both its load_balancing_weight, and the
    load_balancing_weight of its locality. First, a locality will be selected,
    then an endpoint within that locality will be chose based on its weight.
    [#next-free-field: 6]
    """

    cluster_name: str = betterproto.string_field(1)
    """
    Name of the cluster. This will be the :ref:`service_name
    <envoy_api_field_Cluster.EdsClusterConfig.service_name>` value if specified
    in the cluster :ref:`EdsClusterConfig
    <envoy_api_msg_Cluster.EdsClusterConfig>`.
    """

    endpoints: List["endpoint.LocalityLbEndpoints"] = betterproto.message_field(2)
    """List of endpoints to load balance to."""

    named_endpoints: Dict[str, "endpoint.Endpoint"] = betterproto.map_field(
        5, betterproto.TYPE_STRING, betterproto.TYPE_MESSAGE
    )
    """
    Map of named endpoints that can be referenced in LocalityLbEndpoints.
    [#not-implemented-hide:]
    """

    policy: "ClusterLoadAssignmentPolicy" = betterproto.message_field(4)
    """Load balancing policy settings."""


@dataclass(eq=False, repr=False)
class ClusterLoadAssignmentPolicy(betterproto.Message):
    """Load balancing policy settings. [#next-free-field: 6]"""

    drop_overloads: List[
        "ClusterLoadAssignmentPolicyDropOverload"
    ] = betterproto.message_field(2)
    """
    Action to trim the overall incoming traffic to protect the upstream hosts.
    This action allows protection in case the hosts are unable to recover from
    an outage, or unable to autoscale or unable to handle incoming traffic
    volume for any reason. At the client each category is applied one after the
    other to generate the 'actual' drop percentage on all outgoing traffic. For
    example: .. code-block:: json  { "drop_overloads": [      { "category":
    "throttle", "drop_percentage": 60 }      { "category": "lb",
    "drop_percentage": 50 }  ]} The actual drop percentages applied to the
    traffic at the clients will be    "throttle"_drop = 60%    "lb"_drop = 20%
    // 50% of the remaining 'actual' load, which is 40%.
    actual_outgoing_load = 20% // remaining after applying all categories.
    [#not-implemented-hide:]
    """

    overprovisioning_factor: Optional[int] = betterproto.message_field(
        3, wraps=betterproto.TYPE_UINT32
    )
    """
    Priority levels and localities are considered overprovisioned with this
    factor (in percentage). This means that we don't consider a priority level
    or locality unhealthy until the percentage of healthy hosts multiplied by
    the overprovisioning factor drops below 100. With the default value
    140(1.4), Envoy doesn't consider a priority level or a locality unhealthy
    until their percentage of healthy hosts drops below 72%. For example: ..
    code-block:: json  { "overprovisioning_factor": 100 } Read more at
    :ref:`priority levels <arch_overview_load_balancing_priority_levels>` and
    :ref:`localities <arch_overview_load_balancing_locality_weighted_lb>`.
    """

    endpoint_stale_after: timedelta = betterproto.message_field(4)
    """
    The max time until which the endpoints from this assignment can be used. If
    no new assignments are received before this time expires the endpoints are
    considered stale and should be marked unhealthy. Defaults to 0 which means
    endpoints never go stale.
    """

    disable_overprovisioning: bool = betterproto.bool_field(5)
    """
    The flag to disable overprovisioning. If it is set to true,
    :ref:`overprovisioning factor
    <arch_overview_load_balancing_overprovisioning_factor>` will be ignored and
    Envoy will not perform graceful failover between priority levels or
    localities as endpoints become unhealthy. Otherwise Envoy will perform
    graceful failover as :ref:`overprovisioning factor
    <arch_overview_load_balancing_overprovisioning_factor>` suggests. [#not-
    implemented-hide:]
    """

    def __post_init__(self) -> None:
        super().__post_init__()
        if self.is_set("disable_overprovisioning"):
            warnings.warn(
                "ClusterLoadAssignmentPolicy.disable_overprovisioning is deprecated",
                DeprecationWarning,
            )


@dataclass(eq=False, repr=False)
class ClusterLoadAssignmentPolicyDropOverload(betterproto.Message):
    """[#not-implemented-hide:]"""

    category: str = betterproto.string_field(1)
    """Identifier for the policy specifying the drop."""

    drop_percentage: "__type__.FractionalPercent" = betterproto.message_field(2)
    """Percentage of traffic that should be dropped for the category."""


@dataclass(eq=False, repr=False)
class Cluster(betterproto.Message):
    """Configuration for a single upstream cluster. [#next-free-field: 48]"""

    transport_socket_matches: List[
        "ClusterTransportSocketMatch"
    ] = betterproto.message_field(43)
    """
    Configuration to use different transport sockets for different endpoints.
    The entry of *envoy.transport_socket_match* in the
    :ref:`LbEndpoint.Metadata <envoy_api_field_endpoint.LbEndpoint.metadata>`
    is used to match against the transport sockets as they appear in the list.
    The first :ref:`match <envoy_api_msg_Cluster.TransportSocketMatch>` is
    used. For example, with the following match .. code-block:: yaml
    transport_socket_matches:  - name: "enableMTLS"    match:      acceptMTLS:
    true    transport_socket:      name: envoy.transport_sockets.tls
    config: { ... } # tls socket configuration  - name: "defaultToPlaintext"
    match: {}    transport_socket:      name:
    envoy.transport_sockets.raw_buffer Connections to the endpoints whose
    metadata value under *envoy.transport_socket_match* having
    "acceptMTLS"/"true" key/value pair use the "enableMTLS" socket
    configuration. If a :ref:`socket match
    <envoy_api_msg_Cluster.TransportSocketMatch>` with empty match criteria is
    provided, that always match any endpoint. For example, the
    "defaultToPlaintext" socket match in case above. If an endpoint metadata's
    value under *envoy.transport_socket_match* does not match any
    *TransportSocketMatch*, socket configuration fallbacks to use the
    *tls_context* or *transport_socket* specified in this cluster. This field
    allows gradual and flexible transport socket configuration changes. The
    metadata of endpoints in EDS can indicate transport socket capabilities.
    For example, an endpoint's metadata can have two key value pairs as
    "acceptMTLS": "true", "acceptPlaintext": "true". While some other
    endpoints, only accepting plaintext traffic has "acceptPlaintext": "true"
    metadata information. Then the xDS server can configure the CDS to a
    client, Envoy A, to send mutual TLS traffic for endpoints with
    "acceptMTLS": "true", by adding a corresponding *TransportSocketMatch* in
    this field. Other client Envoys receive CDS without
    *transport_socket_match* set, and still send plain text traffic to the same
    cluster. [#comment:TODO(incfly): add a detailed architecture doc on
    intended usage.]
    """

    name: str = betterproto.string_field(1)
    """
    Supplies the name of the cluster which must be unique across all clusters.
    The cluster name is used when emitting :ref:`statistics
    <config_cluster_manager_cluster_stats>` if :ref:`alt_stat_name
    <envoy_api_field_Cluster.alt_stat_name>` is not provided. Any ``:`` in the
    cluster name will be converted to ``_`` when emitting statistics.
    """

    alt_stat_name: str = betterproto.string_field(28)
    """
    An optional alternative to the cluster name to be used while emitting
    stats. Any ``:`` in the name will be converted to ``_`` when emitting
    statistics. This should not be confused with :ref:`Router Filter Header
    <config_http_filters_router_x-envoy-upstream-alt-stat-name>`.
    """

    type: "ClusterDiscoveryType" = betterproto.enum_field(
        2, group="cluster_discovery_type"
    )
    """
    The :ref:`service discovery type <arch_overview_service_discovery_types>`
    to use for resolving the cluster.
    """

    cluster_type: "ClusterCustomClusterType" = betterproto.message_field(
        38, group="cluster_discovery_type"
    )
    """The custom cluster type."""

    eds_cluster_config: "ClusterEdsClusterConfig" = betterproto.message_field(3)
    """Configuration to use for EDS updates for the Cluster."""

    connect_timeout: timedelta = betterproto.message_field(4)
    """The timeout for new network connections to hosts in the cluster."""

    per_connection_buffer_limit_bytes: Optional[int] = betterproto.message_field(
        5, wraps=betterproto.TYPE_UINT32
    )
    """
    Soft limit on size of the cluster’s connections read and write buffers. If
    unspecified, an implementation defined default is applied (1MiB).
    """

    lb_policy: "ClusterLbPolicy" = betterproto.enum_field(6)
    """
    The :ref:`load balancer type <arch_overview_load_balancing_types>` to use
    when picking a host in the cluster.
    """

    hosts: List["core.Address"] = betterproto.message_field(7)
    """
    If the service discovery type is
    :ref:`STATIC<envoy_api_enum_value_Cluster.DiscoveryType.STATIC>`,
    :ref:`STRICT_DNS<envoy_api_enum_value_Cluster.DiscoveryType.STRICT_DNS>` or
    :ref:`LOGICAL_DNS<envoy_api_enum_value_Cluster.DiscoveryType.LOGICAL_DNS>`,
    then hosts is required. .. attention::   **This field is deprecated**. Set
    the   :ref:`load_assignment<envoy_api_field_Cluster.load_assignment>` field
    instead.
    """

    load_assignment: "ClusterLoadAssignment" = betterproto.message_field(33)
    """
    Setting this is required for specifying members of
    :ref:`STATIC<envoy_api_enum_value_Cluster.DiscoveryType.STATIC>`,
    :ref:`STRICT_DNS<envoy_api_enum_value_Cluster.DiscoveryType.STRICT_DNS>` or
    :ref:`LOGICAL_DNS<envoy_api_enum_value_Cluster.DiscoveryType.LOGICAL_DNS>`
    clusters. This field supersedes the *hosts* field in the v2 API. ..
    attention::   Setting this allows non-EDS cluster types to contain embedded
    EDS equivalent   :ref:`endpoint
    assignments<envoy_api_msg_ClusterLoadAssignment>`.
    """

    health_checks: List["core.HealthCheck"] = betterproto.message_field(8)
    """
    Optional :ref:`active health checking <arch_overview_health_checking>`
    configuration for the cluster. If no configuration is specified no health
    checking will be done and all cluster members will be considered healthy at
    all times.
    """

    max_requests_per_connection: Optional[int] = betterproto.message_field(
        9, wraps=betterproto.TYPE_UINT32
    )
    """
    Optional maximum requests for a single upstream connection. This parameter
    is respected by both the HTTP/1.1 and HTTP/2 connection pool
    implementations. If not specified, there is no limit. Setting this
    parameter to 1 will effectively disable keep alive.
    """

    circuit_breakers: "cluster.CircuitBreakers" = betterproto.message_field(10)
    """
    Optional :ref:`circuit breaking <arch_overview_circuit_break>` for the
    cluster.
    """

    tls_context: "auth.UpstreamTlsContext" = betterproto.message_field(11)
    """
    The TLS configuration for connections to the upstream cluster. ..
    attention::   **This field is deprecated**. Use `transport_socket` with
    name `tls` instead. If both are   set, `transport_socket` takes priority.
    """

    upstream_http_protocol_options: "core.UpstreamHttpProtocolOptions" = (
        betterproto.message_field(46)
    )
    """
    HTTP protocol options that are applied only to upstream HTTP connections.
    These options apply to all HTTP versions.
    """

    common_http_protocol_options: "core.HttpProtocolOptions" = (
        betterproto.message_field(29)
    )
    """
    Additional options when handling HTTP requests upstream. These options will
    be applicable to both HTTP1 and HTTP2 requests.
    """

    http_protocol_options: "core.Http1ProtocolOptions" = betterproto.message_field(13)
    """Additional options when handling HTTP1 requests."""

    http2_protocol_options: "core.Http2ProtocolOptions" = betterproto.message_field(14)
    """
    Even if default HTTP2 protocol options are desired, this field must be set
    so that Envoy will assume that the upstream supports HTTP/2 when making new
    HTTP connection pool connections. Currently, Envoy only supports prior
    knowledge for upstream connections. Even if TLS is used with ALPN,
    `http2_protocol_options` must be specified. As an aside this allows HTTP/2
    connections to happen over plain text.
    """

    extension_protocol_options: Dict[
        str, "betterproto_lib_google_protobuf.Struct"
    ] = betterproto.map_field(35, betterproto.TYPE_STRING, betterproto.TYPE_MESSAGE)
    """
    The extension_protocol_options field is used to provide extension-specific
    protocol options for upstream connections. The key should match the
    extension filter name, such as "envoy.filters.network.thrift_proxy". See
    the extension's documentation for details on specific options.
    """

    typed_extension_protocol_options: Dict[
        str, "betterproto_lib_google_protobuf.Any"
    ] = betterproto.map_field(36, betterproto.TYPE_STRING, betterproto.TYPE_MESSAGE)
    """
    The extension_protocol_options field is used to provide extension-specific
    protocol options for upstream connections. The key should match the
    extension filter name, such as "envoy.filters.network.thrift_proxy". See
    the extension's documentation for details on specific options.
    """

    dns_refresh_rate: timedelta = betterproto.message_field(16)
    """
    If the DNS refresh rate is specified and the cluster type is either
    :ref:`STRICT_DNS<envoy_api_enum_value_Cluster.DiscoveryType.STRICT_DNS>`,
    or
    :ref:`LOGICAL_DNS<envoy_api_enum_value_Cluster.DiscoveryType.LOGICAL_DNS>`,
    this value is used as the cluster’s DNS refresh rate. The value configured
    must be at least 1ms. If this setting is not specified, the value defaults
    to 5000ms. For cluster types other than
    :ref:`STRICT_DNS<envoy_api_enum_value_Cluster.DiscoveryType.STRICT_DNS>`
    and
    :ref:`LOGICAL_DNS<envoy_api_enum_value_Cluster.DiscoveryType.LOGICAL_DNS>`
    this setting is ignored.
    """

    dns_failure_refresh_rate: "ClusterRefreshRate" = betterproto.message_field(44)
    """
    If the DNS failure refresh rate is specified and the cluster type is either
    :ref:`STRICT_DNS<envoy_api_enum_value_Cluster.DiscoveryType.STRICT_DNS>`,
    or
    :ref:`LOGICAL_DNS<envoy_api_enum_value_Cluster.DiscoveryType.LOGICAL_DNS>`,
    this is used as the cluster’s DNS refresh rate when requests are failing.
    If this setting is not specified, the failure refresh rate defaults to the
    DNS refresh rate. For cluster types other than
    :ref:`STRICT_DNS<envoy_api_enum_value_Cluster.DiscoveryType.STRICT_DNS>`
    and
    :ref:`LOGICAL_DNS<envoy_api_enum_value_Cluster.DiscoveryType.LOGICAL_DNS>`
    this setting is ignored.
    """

    respect_dns_ttl: bool = betterproto.bool_field(39)
    """
    Optional configuration for setting cluster's DNS refresh rate. If the value
    is set to true, cluster's DNS refresh rate will be set to resource record's
    TTL which comes from DNS resolution.
    """

    dns_lookup_family: "ClusterDnsLookupFamily" = betterproto.enum_field(17)
    """
    The DNS IP address resolution policy. If this setting is not specified, the
    value defaults to
    :ref:`AUTO<envoy_api_enum_value_Cluster.DnsLookupFamily.AUTO>`.
    """

    dns_resolvers: List["core.Address"] = betterproto.message_field(18)
    """
    If DNS resolvers are specified and the cluster type is either
    :ref:`STRICT_DNS<envoy_api_enum_value_Cluster.DiscoveryType.STRICT_DNS>`,
    or
    :ref:`LOGICAL_DNS<envoy_api_enum_value_Cluster.DiscoveryType.LOGICAL_DNS>`,
    this value is used to specify the cluster’s dns resolvers. If this setting
    is not specified, the value defaults to the default resolver, which uses
    /etc/resolv.conf for configuration. For cluster types other than
    :ref:`STRICT_DNS<envoy_api_enum_value_Cluster.DiscoveryType.STRICT_DNS>`
    and
    :ref:`LOGICAL_DNS<envoy_api_enum_value_Cluster.DiscoveryType.LOGICAL_DNS>`
    this setting is ignored. Setting this value causes failure if the
    ``envoy.restart_features.use_apple_api_for_dns_lookups`` runtime value is
    true during server startup. Apple's API only allows overriding DNS
    resolvers via system settings.
    """

    use_tcp_for_dns_lookups: bool = betterproto.bool_field(45)
    """
    [#next-major-version: Reconcile DNS options in a single message.] Always
    use TCP queries instead of UDP queries for DNS lookups. Setting this value
    causes failure if the
    ``envoy.restart_features.use_apple_api_for_dns_lookups`` runtime value is
    true during server startup. Apple' API only uses UDP for DNS resolution.
    """

    outlier_detection: "cluster.OutlierDetection" = betterproto.message_field(19)
    """
    If specified, outlier detection will be enabled for this upstream cluster.
    Each of the configuration values can be overridden via :ref:`runtime values
    <config_cluster_manager_cluster_runtime_outlier_detection>`.
    """

    cleanup_interval: timedelta = betterproto.message_field(20)
    """
    The interval for removing stale hosts from a cluster type :ref:`ORIGINAL_DS
    T<envoy_api_enum_value_Cluster.DiscoveryType.ORIGINAL_DST>`. Hosts are
    considered stale if they have not been used as upstream destinations during
    this interval. New hosts are added to original destination clusters on
    demand as new connections are redirected to Envoy, causing the number of
    hosts in the cluster to grow over time. Hosts that are not stale (they are
    actively used as destinations) are kept in the cluster, which allows
    connections to them remain open, saving the latency that would otherwise be
    spent on opening new connections. If this setting is not specified, the
    value defaults to 5000ms. For cluster types other than :ref:`ORIGINAL_DST<e
    nvoy_api_enum_value_Cluster.DiscoveryType.ORIGINAL_DST>` this setting is
    ignored.
    """

    upstream_bind_config: "core.BindConfig" = betterproto.message_field(21)
    """
    Optional configuration used to bind newly established upstream connections.
    This overrides any bind_config specified in the bootstrap proto. If the
    address and port are empty, no bind will be performed.
    """

    lb_subset_config: "ClusterLbSubsetConfig" = betterproto.message_field(22)
    """Configuration for load balancing subsetting."""

    ring_hash_lb_config: "ClusterRingHashLbConfig" = betterproto.message_field(
        23, group="lb_config"
    )
    """Optional configuration for the Ring Hash load balancing policy."""

    original_dst_lb_config: "ClusterOriginalDstLbConfig" = betterproto.message_field(
        34, group="lb_config"
    )
    """
    Optional configuration for the Original Destination load balancing policy.
    """

    least_request_lb_config: "ClusterLeastRequestLbConfig" = betterproto.message_field(
        37, group="lb_config"
    )
    """Optional configuration for the LeastRequest load balancing policy."""

    common_lb_config: "ClusterCommonLbConfig" = betterproto.message_field(27)
    """Common configuration for all load balancer implementations."""

    transport_socket: "core.TransportSocket" = betterproto.message_field(24)
    """
    Optional custom transport socket implementation to use for upstream
    connections. To setup TLS, set a transport socket with name `tls` and
    :ref:`UpstreamTlsContexts <envoy_api_msg_auth.UpstreamTlsContext>` in the
    `typed_config`. If no transport socket configuration is specified, new
    connections will be set up with plaintext.
    """

    metadata: "core.Metadata" = betterproto.message_field(25)
    """
    The Metadata field can be used to provide additional information about the
    cluster. It can be used for stats, logging, and varying filter behavior.
    Fields should use reverse DNS notation to denote which entity within Envoy
    will need the information. For instance, if the metadata is intended for
    the Router filter, the filter name should be specified as
    *envoy.filters.http.router*.
    """

    protocol_selection: "ClusterClusterProtocolSelection" = betterproto.enum_field(26)
    """
    Determines how Envoy selects the protocol used to speak to upstream hosts.
    """

    upstream_connection_options: "UpstreamConnectionOptions" = (
        betterproto.message_field(30)
    )
    """Optional options for upstream connections."""

    close_connections_on_host_health_failure: bool = betterproto.bool_field(31)
    """
    If an upstream host becomes unhealthy (as determined by the configured
    health checks or outlier detection), immediately close all connections to
    the failed host. .. note::   This is currently only supported for
    connections created by tcp_proxy. .. note::   The current implementation of
    this feature closes all connections immediately when   the unhealthy status
    is detected. If there are a large number of connections open   to an
    upstream host that becomes unhealthy, Envoy may spend a substantial amount
    of   time exclusively closing these connections, and not processing any
    other traffic.
    """

    drain_connections_on_host_removal: bool = betterproto.bool_field(32)
    """
    If set to true, Envoy will ignore the health value of a host when
    processing its removal from service discovery. This means that if active
    health checking is used, Envoy will *not* wait for the endpoint to go
    unhealthy before removing it.
    """

    filters: List["cluster.Filter"] = betterproto.message_field(40)
    """
    An (optional) network filter chain, listed in the order the filters should
    be applied. The chain will be applied to all outgoing connections that
    Envoy makes to the upstream servers of this cluster.
    """

    load_balancing_policy: "LoadBalancingPolicy" = betterproto.message_field(41)
    """
    [#not-implemented-hide:] New mechanism for LB policy configuration. Used
    only if the :ref:`lb_policy<envoy_api_field_Cluster.lb_policy>` field has
    the value :ref:`LOAD_BALANCING_POLICY_CONFIG<envoy_api_enum_value_Cluster.L
    bPolicy.LOAD_BALANCING_POLICY_CONFIG>`.
    """

    lrs_server: "core.ConfigSource" = betterproto.message_field(42)
    """
    [#not-implemented-hide:] If present, tells the client where to send load
    reports via LRS. If not present, the client will fall back to a client-side
    default, which may be either (a) don't send any load reports or (b) send
    load reports for all clusters to a single default server (which may be
    configured in the bootstrap file). Note that if multiple clusters point to
    the same LRS server, the client may choose to create a separate stream for
    each cluster or it may choose to coalesce the data for multiple clusters
    onto a single stream. Either way, the client must make sure to send the
    data for any given cluster on no more than one stream. [#next-major-
    version: In the v3 API, we should consider restructuring this somehow,
    maybe by allowing LRS to go on the ADS stream, or maybe by moving some of
    the negotiation from the LRS stream here.]
    """

    track_timeout_budgets: bool = betterproto.bool_field(47)
    """
    If track_timeout_budgets is true, the :ref:`timeout budget histograms
    <config_cluster_manager_cluster_stats_timeout_budgets>` will be published
    for each request. These show what percentage of a request's per try and
    global timeout was used. A value of 0 would indicate that none of the
    timeout was used or that the timeout was infinite. A value of 100 would
    indicate that the request took the entirety of the timeout given to it.
    """

    def __post_init__(self) -> None:
        super().__post_init__()
        if self.is_set("hosts"):
            warnings.warn("Cluster.hosts is deprecated", DeprecationWarning)
        if self.is_set("tls_context"):
            warnings.warn("Cluster.tls_context is deprecated", DeprecationWarning)
        if self.is_set("extension_protocol_options"):
            warnings.warn(
                "Cluster.extension_protocol_options is deprecated", DeprecationWarning
            )


@dataclass(eq=False, repr=False)
class ClusterTransportSocketMatch(betterproto.Message):
    """
    TransportSocketMatch specifies what transport socket config will be used
    when the match conditions are satisfied.
    """

    name: str = betterproto.string_field(1)
    """The name of the match, used in stats generation."""

    match: "betterproto_lib_google_protobuf.Struct" = betterproto.message_field(2)
    """
    Optional endpoint metadata match criteria. The connection to the endpoint
    with metadata matching what is set in this field will use the transport
    socket configuration specified here. The endpoint's metadata entry in
    *envoy.transport_socket_match* is used to match against the values
    specified in this field.
    """

    transport_socket: "core.TransportSocket" = betterproto.message_field(3)
    """The configuration of the transport socket."""


@dataclass(eq=False, repr=False)
class ClusterCustomClusterType(betterproto.Message):
    """Extended cluster type."""

    name: str = betterproto.string_field(1)
    """
    The type of the cluster to instantiate. The name must match a supported
    cluster type.
    """

    typed_config: "betterproto_lib_google_protobuf.Any" = betterproto.message_field(2)
    """
    Cluster specific configuration which depends on the cluster being
    instantiated. See the supported cluster for further documentation.
    """


@dataclass(eq=False, repr=False)
class ClusterEdsClusterConfig(betterproto.Message):
    """Only valid when discovery type is EDS."""

    eds_config: "core.ConfigSource" = betterproto.message_field(1)
    """Configuration for the source of EDS updates for this Cluster."""

    service_name: str = betterproto.string_field(2)
    """
    Optional alternative to cluster name to present to EDS. This does not have
    the same restrictions as cluster name, i.e. it may be arbitrary length.
    """


@dataclass(eq=False, repr=False)
class ClusterLbSubsetConfig(betterproto.Message):
    """
    Optionally divide the endpoints in this cluster into subsets defined by
    endpoint metadata and selected by route and weighted cluster metadata.
    [#next-free-field: 8]
    """

    fallback_policy: "ClusterLbSubsetConfigLbSubsetFallbackPolicy" = (
        betterproto.enum_field(1)
    )
    """
    The behavior used when no endpoint subset matches the selected route's
    metadata. The value defaults to :ref:`NO_FALLBACK<envoy_api_enum_value_Clus
    ter.LbSubsetConfig.LbSubsetFallbackPolicy.NO_FALLBACK>`.
    """

    default_subset: "betterproto_lib_google_protobuf.Struct" = (
        betterproto.message_field(2)
    )
    """
    Specifies the default subset of endpoints used during fallback if
    fallback_policy is :ref:`DEFAULT_SUBSET<envoy_api_enum_value_Cluster.LbSubs
    etConfig.LbSubsetFallbackPolicy.DEFAULT_SUBSET>`. Each field in
    default_subset is compared to the matching LbEndpoint.Metadata under the
    *envoy.lb* namespace. It is valid for no hosts to match, in which case the
    behavior is the same as a fallback_policy of :ref:`NO_FALLBACK<envoy_api_en
    um_value_Cluster.LbSubsetConfig.LbSubsetFallbackPolicy.NO_FALLBACK>`.
    """

    subset_selectors: List[
        "ClusterLbSubsetConfigLbSubsetSelector"
    ] = betterproto.message_field(3)
    """
    For each entry, LbEndpoint.Metadata's *envoy.lb* namespace is traversed and
    a subset is created for each unique combination of key and value. For
    example: .. code-block:: json   { "subset_selectors": [       { "keys": [
    "version" ] },       { "keys": [ "stage", "hardware_type" ] }   ]} A subset
    is matched when the metadata from the selected route and weighted cluster
    contains the same keys and values as the subset's metadata. The same host
    may appear in multiple subsets.
    """

    locality_weight_aware: bool = betterproto.bool_field(4)
    """
    If true, routing to subsets will take into account the localities and
    locality weights of the endpoints when making the routing decision. There
    are some potential pitfalls associated with enabling this feature, as the
    resulting traffic split after applying both a subset match and locality
    weights might be undesirable. Consider for example a situation in which you
    have 50/50 split across two localities X/Y which have 100 hosts each
    without subsetting. If the subset LB results in X having only 1 host
    selected but Y having 100, then a lot more load is being dumped on the
    single host in X than originally anticipated in the load balancing
    assignment delivered via EDS.
    """

    scale_locality_weight: bool = betterproto.bool_field(5)
    """
    When used with locality_weight_aware, scales the weight of each locality by
    the ratio of hosts in the subset vs hosts in the original subset. This aims
    to even out the load going to an individual locality if said locality is
    disproportionately affected by the subset predicate.
    """

    panic_mode_any: bool = betterproto.bool_field(6)
    """
    If true, when a fallback policy is configured and its corresponding subset
    fails to find a host this will cause any host to be selected instead. This
    is useful when using the default subset as the fallback policy, given the
    default subset might become empty. With this option enabled, if that
    happens the LB will attempt to select a host from the entire cluster.
    """

    list_as_any: bool = betterproto.bool_field(7)
    """
    If true, metadata specified for a metadata key will be matched against the
    corresponding endpoint metadata if the endpoint metadata matches the value
    exactly OR it is a list value and any of the elements in the list matches
    the criteria.
    """


@dataclass(eq=False, repr=False)
class ClusterLbSubsetConfigLbSubsetSelector(betterproto.Message):
    """Specifications for subsets."""

    keys: List[str] = betterproto.string_field(1)
    """List of keys to match with the weighted cluster metadata."""

    fallback_policy: "ClusterLbSubsetConfigLbSubsetSelectorLbSubsetSelectorFallbackPolicy" = betterproto.enum_field(
        2
    )
    """
    The behavior used when no endpoint subset matches the selected route's
    metadata.
    """

    fallback_keys_subset: List[str] = betterproto.string_field(3)
    """
    Subset of
    :ref:`keys<envoy_api_field_Cluster.LbSubsetConfig.LbSubsetSelector.keys>`
    used by :ref:`KEYS_SUBSET<envoy_api_enum_value_Cluster.LbSubsetConfig.LbSub
    setSelector.LbSubsetSelectorFallbackPolicy.KEYS_SUBSET>` fallback policy.
    It has to be a non empty list if KEYS_SUBSET fallback policy is selected.
    For any other fallback policy the parameter is not used and should not be
    set. Only values also present in
    :ref:`keys<envoy_api_field_Cluster.LbSubsetConfig.LbSubsetSelector.keys>`
    are allowed, but `fallback_keys_subset` cannot be equal to `keys`.
    """


@dataclass(eq=False, repr=False)
class ClusterLeastRequestLbConfig(betterproto.Message):
    """Specific configuration for the LeastRequest load balancing policy."""

    choice_count: Optional[int] = betterproto.message_field(
        1, wraps=betterproto.TYPE_UINT32
    )
    """
    The number of random healthy hosts from which the host with the fewest
    active requests will be chosen. Defaults to 2 so that we perform two-choice
    selection if the field is not set.
    """


@dataclass(eq=False, repr=False)
class ClusterRingHashLbConfig(betterproto.Message):
    """
    Specific configuration for the
    :ref:`RingHash<arch_overview_load_balancing_types_ring_hash>` load
    balancing policy.
    """

    minimum_ring_size: Optional[int] = betterproto.message_field(
        1, wraps=betterproto.TYPE_UINT64
    )
    """
    Minimum hash ring size. The larger the ring is (that is, the more hashes
    there are for each provided host) the better the request distribution will
    reflect the desired weights. Defaults to 1024 entries, and limited to 8M
    entries. See also :ref:`maximum_ring_size<envoy_api_field_Cluster.RingHashL
    bConfig.maximum_ring_size>`.
    """

    hash_function: "ClusterRingHashLbConfigHashFunction" = betterproto.enum_field(3)
    """
    The hash function used to hash hosts onto the ketama ring. The value
    defaults to :ref:`XX_HASH<envoy_api_enum_value_Cluster.RingHashLbConfig.Has
    hFunction.XX_HASH>`.
    """

    maximum_ring_size: Optional[int] = betterproto.message_field(
        4, wraps=betterproto.TYPE_UINT64
    )
    """
    Maximum hash ring size. Defaults to 8M entries, and limited to 8M entries,
    but can be lowered to further constrain resource use. See also :ref:`minimu
    m_ring_size<envoy_api_field_Cluster.RingHashLbConfig.minimum_ring_size>`.
    """


@dataclass(eq=False, repr=False)
class ClusterOriginalDstLbConfig(betterproto.Message):
    """
    Specific configuration for the :ref:`Original Destination
    <arch_overview_load_balancing_types_original_destination>` load balancing
    policy.
    """

    use_http_header: bool = betterproto.bool_field(1)
    """
    When true, :ref:`x-envoy-original-dst-host <config_http_conn_man_headers_x-
    envoy-original-dst-host>` can be used to override destination address. ..
    attention::   This header isn't sanitized by default, so enabling this
    feature allows HTTP clients to   route traffic to arbitrary hosts and/or
    ports, which may have serious security   consequences. .. note::   If the
    header appears multiple times only the first value is used.
    """


@dataclass(eq=False, repr=False)
class ClusterCommonLbConfig(betterproto.Message):
    """
    Common configuration for all load balancer implementations. [#next-free-
    field: 8]
    """

    healthy_panic_threshold: "__type__.Percent" = betterproto.message_field(1)
    """
    Configures the :ref:`healthy panic threshold
    <arch_overview_load_balancing_panic_threshold>`. If not specified, the
    default is 50%. To disable panic mode, set to 0%. .. note::   The specified
    percent will be truncated to the nearest 1%.
    """

    zone_aware_lb_config: "ClusterCommonLbConfigZoneAwareLbConfig" = (
        betterproto.message_field(2, group="locality_config_specifier")
    )
    locality_weighted_lb_config: "ClusterCommonLbConfigLocalityWeightedLbConfig" = (
        betterproto.message_field(3, group="locality_config_specifier")
    )
    update_merge_window: timedelta = betterproto.message_field(4)
    """
    If set, all health check/weight/metadata updates that happen within this
    duration will be merged and delivered in one shot when the duration
    expires. The start of the duration is when the first update happens. This
    is useful for big clusters, with potentially noisy deploys that might
    trigger excessive CPU usage due to a constant stream of healthcheck state
    changes or metadata updates. The first set of updates to be seen apply
    immediately (e.g.: a new cluster). Please always keep in mind that the use
    of sandbox technologies may change this behavior. If this is not set, we
    default to a merge window of 1000ms. To disable it, set the merge window to
    0. Note: merging does not apply to cluster membership changes (e.g.:
    adds/removes); this is because merging those updates isn't currently safe.
    See https://github.com/envoyproxy/envoy/pull/3941.
    """

    ignore_new_hosts_until_first_hc: bool = betterproto.bool_field(5)
    """
    If set to true, Envoy will not consider new hosts when computing load
    balancing weights until they have been health checked for the first time.
    This will have no effect unless active health checking is also configured.
    Ignoring a host means that for any load balancing calculations that adjust
    weights based on the ratio of eligible hosts and total hosts (priority
    spillover, locality weighting and panic mode) Envoy will exclude these
    hosts in the denominator. For example, with hosts in two priorities P0 and
    P1, where P0 looks like {healthy, unhealthy (new), unhealthy (new)} and
    where P1 looks like {healthy, healthy} all traffic will still hit P0, as 1
    / (3 - 2) = 1. Enabling this will allow scaling up the number of hosts for
    a given cluster without entering panic mode or triggering priority
    spillover, assuming the hosts pass the first health check. If panic mode is
    triggered, new hosts are still eligible for traffic; they simply do not
    contribute to the calculation when deciding whether panic mode is enabled
    or not.
    """

    close_connections_on_host_set_change: bool = betterproto.bool_field(6)
    """
    If set to `true`, the cluster manager will drain all existing connections
    to upstream hosts whenever hosts are added or removed from the cluster.
    """

    consistent_hashing_lb_config: "ClusterCommonLbConfigConsistentHashingLbConfig" = (
        betterproto.message_field(7)
    )
    """
    Common Configuration for all consistent hashing load balancers (MaglevLb,
    RingHashLb, etc.)
    """


@dataclass(eq=False, repr=False)
class ClusterCommonLbConfigZoneAwareLbConfig(betterproto.Message):
    """
    Configuration for :ref:`zone aware routing
    <arch_overview_load_balancing_zone_aware_routing>`.
    """

    routing_enabled: "__type__.Percent" = betterproto.message_field(1)
    """
    Configures percentage of requests that will be considered for zone aware
    routing if zone aware routing is configured. If not specified, the default
    is 100%. * :ref:`runtime values
    <config_cluster_manager_cluster_runtime_zone_routing>`. * :ref:`Zone aware
    routing support <arch_overview_load_balancing_zone_aware_routing>`.
    """

    min_cluster_size: Optional[int] = betterproto.message_field(
        2, wraps=betterproto.TYPE_UINT64
    )
    """
    Configures minimum upstream cluster size required for zone aware routing If
    upstream cluster size is less than specified, zone aware routing is not
    performed even if zone aware routing is configured. If not specified, the
    default is 6. * :ref:`runtime values
    <config_cluster_manager_cluster_runtime_zone_routing>`. * :ref:`Zone aware
    routing support <arch_overview_load_balancing_zone_aware_routing>`.
    """

    fail_traffic_on_panic: bool = betterproto.bool_field(3)
    """
    If set to true, Envoy will not consider any hosts when the cluster is in
    :ref:`panic mode<arch_overview_load_balancing_panic_threshold>`. Instead,
    the cluster will fail all requests as if all hosts are unhealthy. This can
    help avoid potentially overwhelming a failing service.
    """


@dataclass(eq=False, repr=False)
class ClusterCommonLbConfigLocalityWeightedLbConfig(betterproto.Message):
    """
    Configuration for :ref:`locality weighted load balancing
    <arch_overview_load_balancing_locality_weighted_lb>`
    """

    pass


@dataclass(eq=False, repr=False)
class ClusterCommonLbConfigConsistentHashingLbConfig(betterproto.Message):
    """
    Common Configuration for all consistent hashing load balancers (MaglevLb,
    RingHashLb, etc.)
    """

    use_hostname_for_hashing: bool = betterproto.bool_field(1)
    """
    If set to `true`, the cluster will use hostname instead of the resolved
    address as the key to consistently hash to an upstream host. Only valid for
    StrictDNS clusters with hostnames which resolve to a single IP address.
    """


@dataclass(eq=False, repr=False)
class ClusterRefreshRate(betterproto.Message):
    base_interval: timedelta = betterproto.message_field(1)
    """
    Specifies the base interval between refreshes. This parameter is required
    and must be greater than zero and less than :ref:`max_interval
    <envoy_api_field_Cluster.RefreshRate.max_interval>`.
    """

    max_interval: timedelta = betterproto.message_field(2)
    """
    Specifies the maximum interval between refreshes. This parameter is
    optional, but must be greater than or equal to the :ref:`base_interval
    <envoy_api_field_Cluster.RefreshRate.base_interval>`  if set. The default
    is 10 times the :ref:`base_interval
    <envoy_api_field_Cluster.RefreshRate.base_interval>`.
    """


@dataclass(eq=False, repr=False)
class LoadBalancingPolicy(betterproto.Message):
    """
    [#not-implemented-hide:] Extensible load balancing policy configuration.
    Every LB policy defined via this mechanism will be identified via a unique
    name using reverse DNS notation. If the policy needs configuration
    parameters, it must define a message for its own configuration, which will
    be stored in the config field. The name of the policy will tell clients
    which type of message they should expect to see in the config field. Note
    that there are cases where it is useful to be able to independently select
    LB policies for choosing a locality and for choosing an endpoint within
    that locality. For example, a given deployment may always use the same
    policy to choose the locality, but for choosing the endpoint within the
    locality, some clusters may use weighted-round-robin, while others may use
    some sort of session-based balancing. This can be accomplished via
    hierarchical LB policies, where the parent LB policy creates a child LB
    policy for each locality. For each request, the parent chooses the locality
    and then delegates to the child policy for that locality to choose the
    endpoint within the locality. To facilitate this, the config message for
    the top-level LB policy may include a field of type LoadBalancingPolicy
    that specifies the child policy.
    """

    policies: List["LoadBalancingPolicyPolicy"] = betterproto.message_field(1)
    """
    Each client will iterate over the list in order and stop at the first
    policy that it supports. This provides a mechanism for starting to use new
    LB policies that are not yet supported by all clients.
    """


@dataclass(eq=False, repr=False)
class LoadBalancingPolicyPolicy(betterproto.Message):
    name: str = betterproto.string_field(1)
    """Required. The name of the LB policy."""

    config: "betterproto_lib_google_protobuf.Struct" = betterproto.message_field(2)
    """
    Optional config for the LB policy. No more than one of these two fields may
    be populated.
    """

    typed_config: "betterproto_lib_google_protobuf.Any" = betterproto.message_field(3)

    def __post_init__(self) -> None:
        super().__post_init__()
        if self.is_set("config"):
            warnings.warn(
                "LoadBalancingPolicyPolicy.config is deprecated", DeprecationWarning
            )


@dataclass(eq=False, repr=False)
class UpstreamBindConfig(betterproto.Message):
    """
    An extensible structure containing the address Envoy should bind to when
    establishing upstream connections.
    """

    source_address: "core.Address" = betterproto.message_field(1)
    """
    The address Envoy should bind to when establishing upstream connections.
    """


@dataclass(eq=False, repr=False)
class UpstreamConnectionOptions(betterproto.Message):
    tcp_keepalive: "core.TcpKeepalive" = betterproto.message_field(1)
    """If set then set SO_KEEPALIVE on the socket to enable TCP Keepalives."""


@dataclass(eq=False, repr=False)
class ScopedRouteConfiguration(betterproto.Message):
    """
    Specifies a routing scope, which associates a
    :ref:`Key<envoy_api_msg_ScopedRouteConfiguration.Key>` to a
    :ref:`envoy_api_msg_RouteConfiguration` (identified by its resource name).
    The HTTP connection manager builds up a table consisting of these Key to
    RouteConfiguration mappings, and looks up the RouteConfiguration to use per
    request according to the algorithm specified in the :ref:`scope_key_builder
    <envoy_api_field_config.filter.network.http_connection_manager.v2.ScopedRou
    tes.scope_key_builder>` assigned to the HttpConnectionManager. For example,
    with the following configurations (in YAML): HttpConnectionManager config:
    .. code::   ...   scoped_routes:     name: foo-scoped-routes
    scope_key_builder:       fragments:         - header_value_extractor:
    name: X-Route-Selector             element_separator: ,
    element:               separator: =               key: vip
    ScopedRouteConfiguration resources (specified statically via :ref:`scoped_r
    oute_configurations_list<envoy_api_field_config.filter.network.http_connect
    ion_manager.v2.ScopedRoutes.scoped_route_configurations_list>` or obtained
    dynamically via SRDS): .. code::  (1)   name: route-scope1
    route_configuration_name: route-config1   key:      fragments:        -
    string_key: 172.10.10.20  (2)   name: route-scope2
    route_configuration_name: route-config2   key:     fragments:       -
    string_key: 172.20.20.30 A request from a client such as: .. code::     GET
    / HTTP/1.1     Host: foo.com     X-Route-Selector: vip=172.10.10.20 would
    result in the routing table defined by the `route-config1`
    RouteConfiguration being assigned to the HTTP request/stream.
    """

    name: str = betterproto.string_field(1)
    """The name assigned to the routing scope."""

    route_configuration_name: str = betterproto.string_field(2)
    """
    The resource name to use for a :ref:`envoy_api_msg_DiscoveryRequest` to an
    RDS server to fetch the :ref:`envoy_api_msg_RouteConfiguration` associated
    with this scope.
    """

    key: "ScopedRouteConfigurationKey" = betterproto.message_field(3)
    """The key to match against."""


@dataclass(eq=False, repr=False)
class ScopedRouteConfigurationKey(betterproto.Message):
    """
    Specifies a key which is matched against the output of the :ref:`scope_key_
    builder<envoy_api_field_config.filter.network.http_connection_manager.v2.Sc
    opedRoutes.scope_key_builder>` specified in the HttpConnectionManager. The
    matching is done per HTTP request and is dependent on the order of the
    fragments contained in the Key.
    """

    fragments: List["ScopedRouteConfigurationKeyFragment"] = betterproto.message_field(
        1
    )
    """
    The ordered set of fragments to match against. The order must match the
    fragments in the corresponding :ref:`scope_key_builder<envoy_api_field_conf
    ig.filter.network.http_connection_manager.v2.ScopedRoutes.scope_key_builder
    >`.
    """


@dataclass(eq=False, repr=False)
class ScopedRouteConfigurationKeyFragment(betterproto.Message):
    string_key: str = betterproto.string_field(1, group="type")
    """A string to match against."""


@dataclass(eq=False, repr=False)
class SrdsDummy(betterproto.Message):
    """
    [#not-implemented-hide:] Not configuration. Workaround c++ protobuf issue
    with importing services: https://github.com/google/protobuf/issues/4221 and
    protoxform to upgrade the file.
    """

    pass


@dataclass(eq=False, repr=False)
class EdsDummy(betterproto.Message):
    """
    [#not-implemented-hide:] Not configuration. Workaround c++ protobuf issue
    with importing services: https://github.com/google/protobuf/issues/4221 and
    protoxform to upgrade the file.
    """

    pass


@dataclass(eq=False, repr=False)
class CdsDummy(betterproto.Message):
    """
    [#not-implemented-hide:] Not configuration. Workaround c++ protobuf issue
    with importing services: https://github.com/google/protobuf/issues/4221 and
    protoxform to upgrade the file.
    """

    pass


@dataclass(eq=False, repr=False)
class Listener(betterproto.Message):
    """[#next-free-field: 23]"""

    name: str = betterproto.string_field(1)
    """
    The unique name by which this listener is known. If no name is provided,
    Envoy will allocate an internal UUID for the listener. If the listener is
    to be dynamically updated or removed via :ref:`LDS <config_listeners_lds>`
    a unique name must be provided.
    """

    address: "core.Address" = betterproto.message_field(2)
    """
    The address that the listener should listen on. In general, the address
    must be unique, though that is governed by the bind rules of the OS. E.g.,
    multiple listeners can listen on port 0 on Linux as the actual port will be
    allocated by the OS.
    """

    filter_chains: List["listener.FilterChain"] = betterproto.message_field(3)
    """
    A list of filter chains to consider for this listener. The
    :ref:`FilterChain <envoy_api_msg_listener.FilterChain>` with the most
    specific :ref:`FilterChainMatch <envoy_api_msg_listener.FilterChainMatch>`
    criteria is used on a connection. Example using SNI for filter chain
    selection can be found in the :ref:`FAQ entry <faq_how_to_setup_sni>`.
    """

    use_original_dst: Optional[bool] = betterproto.message_field(
        4, wraps=betterproto.TYPE_BOOL
    )
    """
    If a connection is redirected using *iptables*, the port on which the proxy
    receives it might be different from the original destination address. When
    this flag is set to true, the listener hands off redirected connections to
    the listener associated with the original destination address. If there is
    no listener associated with the original destination address, the
    connection is handled by the listener that receives it. Defaults to false.
    .. attention::   This field is deprecated. Use :ref:`an original_dst
    <config_listener_filters_original_dst>`   :ref:`listener filter
    <envoy_api_field_Listener.listener_filters>` instead.   Note that hand off
    to another listener is *NOT* performed without this flag. Once
    :ref:`FilterChainMatch <envoy_api_msg_listener.FilterChainMatch>` is
    implemented this flag   will be removed, as filter chain matching can be
    used to select a filter chain based on the   restored destination address.
    """

    per_connection_buffer_limit_bytes: Optional[int] = betterproto.message_field(
        5, wraps=betterproto.TYPE_UINT32
    )
    """
    Soft limit on size of the listener’s new connection read and write buffers.
    If unspecified, an implementation defined default is applied (1MiB).
    """

    metadata: "core.Metadata" = betterproto.message_field(6)
    """Listener metadata."""

    deprecated_v1: "ListenerDeprecatedV1" = betterproto.message_field(7)
    """[#not-implemented-hide:]"""

    drain_type: "ListenerDrainType" = betterproto.enum_field(8)
    """The type of draining to perform at a listener-wide level."""

    listener_filters: List["listener.ListenerFilter"] = betterproto.message_field(9)
    """
    Listener filters have the opportunity to manipulate and augment the
    connection metadata that is used in connection filter chain matching, for
    example. These filters are run before any in :ref:`filter_chains
    <envoy_api_field_Listener.filter_chains>`. Order matters as the filters are
    processed sequentially right after a socket has been accepted by the
    listener, and before a connection is created. UDP Listener filters can be
    specified when the protocol in the listener socket address in
    :ref:`protocol <envoy_api_field_core.SocketAddress.protocol>` is :ref:`UDP
    <envoy_api_enum_value_core.SocketAddress.Protocol.UDP>`. UDP listeners
    currently support a single filter.
    """

    listener_filters_timeout: timedelta = betterproto.message_field(15)
    """
    The timeout to wait for all listener filters to complete operation. If the
    timeout is reached, the accepted socket is closed without a connection
    being created unless `continue_on_listener_filters_timeout` is set to true.
    Specify 0 to disable the timeout. If not specified, a default timeout of
    15s is used.
    """

    continue_on_listener_filters_timeout: bool = betterproto.bool_field(17)
    """
    Whether a connection should be created when listener filters timeout.
    Default is false. .. attention::   Some listener filters, such as
    :ref:`Proxy Protocol filter   <config_listener_filters_proxy_protocol>`,
    should not be used with this option. It will cause   unexpected behavior
    when a connection is created.
    """

    transparent: Optional[bool] = betterproto.message_field(
        10, wraps=betterproto.TYPE_BOOL
    )
    """
    Whether the listener should be set as a transparent socket. When this flag
    is set to true, connections can be redirected to the listener using an
    *iptables* *TPROXY* target, in which case the original source and
    destination addresses and ports are preserved on accepted connections. This
    flag should be used in combination with :ref:`an original_dst
    <config_listener_filters_original_dst>` :ref:`listener filter
    <envoy_api_field_Listener.listener_filters>` to mark the connections' local
    addresses as "restored." This can be used to hand off each redirected
    connection to another listener associated with the connection's destination
    address. Direct connections to the socket without using *TPROXY* cannot be
    distinguished from connections redirected using *TPROXY* and are therefore
    treated as if they were redirected. When this flag is set to false, the
    listener's socket is explicitly reset as non-transparent. Setting this flag
    requires Envoy to run with the *CAP_NET_ADMIN* capability. When this flag
    is not set (default), the socket is not modified, i.e. the transparent
    option is neither set nor reset.
    """

    freebind: Optional[bool] = betterproto.message_field(
        11, wraps=betterproto.TYPE_BOOL
    )
    """
    Whether the listener should set the *IP_FREEBIND* socket option. When this
    flag is set to true, listeners can be bound to an IP address that is not
    configured on the system running Envoy. When this flag is set to false, the
    option *IP_FREEBIND* is disabled on the socket. When this flag is not set
    (default), the socket is not modified, i.e. the option is neither enabled
    nor disabled.
    """

    socket_options: List["core.SocketOption"] = betterproto.message_field(13)
    """
    Additional socket options that may not be present in Envoy source code or
    precompiled binaries.
    """

    tcp_fast_open_queue_length: Optional[int] = betterproto.message_field(
        12, wraps=betterproto.TYPE_UINT32
    )
    """
    Whether the listener should accept TCP Fast Open (TFO) connections. When
    this flag is set to a value greater than 0, the option TCP_FASTOPEN is
    enabled on the socket, with a queue length of the specified size (see
    `details in RFC7413 <https://tools.ietf.org/html/rfc7413#section-5.1>`_).
    When this flag is set to 0, the option TCP_FASTOPEN is disabled on the
    socket. When this flag is not set (default), the socket is not modified,
    i.e. the option is neither enabled nor disabled. On Linux, the
    net.ipv4.tcp_fastopen kernel parameter must include flag 0x2 to enable
    TCP_FASTOPEN. See `ip-sysctl.txt
    <https://www.kernel.org/doc/Documentation/networking/ip-sysctl.txt>`_. On
    macOS, only values of 0, 1, and unset are valid; other values may result in
    an error. To set the queue length on macOS, set the
    net.inet.tcp.fastopen_backlog kernel parameter.
    """

    traffic_direction: "core.TrafficDirection" = betterproto.enum_field(16)
    """
    Specifies the intended direction of the traffic relative to the local
    Envoy. This property is required on Windows for listeners using the
    original destination filter, see :ref:`Original Destination
    <config_listener_filters_original_dst>`.
    """

    udp_listener_config: "listener.UdpListenerConfig" = betterproto.message_field(18)
    """
    If the protocol in the listener socket address in :ref:`protocol
    <envoy_api_field_core.SocketAddress.protocol>` is :ref:`UDP
    <envoy_api_enum_value_core.SocketAddress.Protocol.UDP>`, this field
    specifies the actual udp listener to create, i.e. :ref:`udp_listener_name
    <envoy_api_field_listener.UdpListenerConfig.udp_listener_name>` =
    "raw_udp_listener" for creating a packet-oriented UDP listener. If not
    present, treat it as "raw_udp_listener".
    """

    api_listener: "__config_listener_v2__.ApiListener" = betterproto.message_field(19)
    """
    Used to represent an API listener, which is used in non-proxy clients. The
    type of API exposed to the non-proxy application depends on the type of API
    listener. When this field is set, no other field except for
    :ref:`name<envoy_api_field_Listener.name>` should be set. .. note::
    Currently only one ApiListener can be installed; and it can only be done
    via bootstrap config,  not LDS. [#next-major-version: In the v3 API,
    instead of this messy approach where the socket listener fields are
    directly in the top-level Listener message and the API listener types are
    in the ApiListener message, the socket listener messages should be in their
    own message, and the top-level Listener should essentially be a oneof that
    selects between the socket listener and the various types of API listener.
    That way, a given Listener message can structurally only contain the fields
    of the relevant type.]
    """

    connection_balance_config: "ListenerConnectionBalanceConfig" = (
        betterproto.message_field(20)
    )
    """
    The listener's connection balancer configuration, currently only applicable
    to TCP listeners. If no configuration is specified, Envoy will not attempt
    to balance active connections between worker threads.
    """

    reuse_port: bool = betterproto.bool_field(21)
    """
    When this flag is set to true, listeners set the *SO_REUSEPORT* socket
    option and create one socket for each worker thread. This makes inbound
    connections distribute among worker threads roughly evenly in cases where
    there are a high number of connections. When this flag is set to false, all
    worker threads share one socket. Before Linux v4.19-rc1, new TCP
    connections may be rejected during hot restart (see `3rd paragraph in
    'soreuseport' commit message
    <https://github.com/torvalds/linux/commit/c617f398edd4db2b8567a28e89>`_).
    This issue was fixed by `tcp: Avoid TCP syncookie rejected by SO_REUSEPORT
    socket <https://github.com/torvalds/linux/commit/40a1227ea845a37ab197dd1caf
    fb60b047fa36b1>`_.
    """

    access_log: List[
        "__config_filter_accesslog_v2__.AccessLog"
    ] = betterproto.message_field(22)
    """
    Configuration for :ref:`access logs <arch_overview_access_logs>` emitted by
    this listener.
    """

    def __post_init__(self) -> None:
        super().__post_init__()
        if self.is_set("use_original_dst"):
            warnings.warn("Listener.use_original_dst is deprecated", DeprecationWarning)


@dataclass(eq=False, repr=False)
class ListenerDeprecatedV1(betterproto.Message):
    """[#not-implemented-hide:]"""

    bind_to_port: Optional[bool] = betterproto.message_field(
        1, wraps=betterproto.TYPE_BOOL
    )
    """
    Whether the listener should bind to the port. A listener that doesn't bind
    can only receive connections redirected from other listeners that set
    use_original_dst parameter to true. Default is true. This is deprecated in
    v2, all Listeners will bind to their port. An additional filter chain must
    be created for every original destination port this listener may redirect
    to in v2, with the original port specified in the FilterChainMatch
    destination_port field. [#comment:TODO(PiotrSikora): Remove this once
    verified that we no longer need it.]
    """


@dataclass(eq=False, repr=False)
class ListenerConnectionBalanceConfig(betterproto.Message):
    """Configuration for listener connection balancing."""

    exact_balance: "ListenerConnectionBalanceConfigExactBalance" = (
        betterproto.message_field(1, group="balance_type")
    )
    """If specified, the listener will use the exact connection balancer."""


@dataclass(eq=False, repr=False)
class ListenerConnectionBalanceConfigExactBalance(betterproto.Message):
    """
    A connection balancer implementation that does exact balancing. This means
    that a lock is held during balancing so that connection counts are nearly
    exactly balanced between worker threads. This is "nearly" exact in the
    sense that a connection might close in parallel thus making the counts
    incorrect, but this should be rectified on the next accept. This balancer
    sacrifices accept throughput for accuracy and should be used when there are
    a small number of connections that rarely cycle (e.g., service mesh gRPC
    egress).
    """

    pass


@dataclass(eq=False, repr=False)
class LdsDummy(betterproto.Message):
    """
    [#not-implemented-hide:] Not configuration. Workaround c++ protobuf issue
    with importing services: https://github.com/google/protobuf/issues/4221 and
    protoxform to upgrade the file.
    """

    pass


class RouteDiscoveryServiceStub(betterproto.ServiceStub):
    async def stream_routes(
        self,
        discovery_request_iterator: Union[
            AsyncIterable["DiscoveryRequest"], Iterable["DiscoveryRequest"]
        ],
        *,
        timeout: Optional[float] = None,
        deadline: Optional["Deadline"] = None,
        metadata: Optional["MetadataLike"] = None
    ) -> AsyncIterator["DiscoveryResponse"]:
        async for response in self._stream_stream(
            "/envoy.api.v2.RouteDiscoveryService/StreamRoutes",
            discovery_request_iterator,
            DiscoveryRequest,
            DiscoveryResponse,
            timeout=timeout,
            deadline=deadline,
            metadata=metadata,
        ):
            yield response

    async def delta_routes(
        self,
        delta_discovery_request_iterator: Union[
            AsyncIterable["DeltaDiscoveryRequest"], Iterable["DeltaDiscoveryRequest"]
        ],
        *,
        timeout: Optional[float] = None,
        deadline: Optional["Deadline"] = None,
        metadata: Optional["MetadataLike"] = None
    ) -> AsyncIterator["DeltaDiscoveryResponse"]:
        async for response in self._stream_stream(
            "/envoy.api.v2.RouteDiscoveryService/DeltaRoutes",
            delta_discovery_request_iterator,
            DeltaDiscoveryRequest,
            DeltaDiscoveryResponse,
            timeout=timeout,
            deadline=deadline,
            metadata=metadata,
        ):
            yield response

    async def fetch_routes(
        self,
        discovery_request: "DiscoveryRequest",
        *,
        timeout: Optional[float] = None,
        deadline: Optional["Deadline"] = None,
        metadata: Optional["MetadataLike"] = None
    ) -> "DiscoveryResponse":
        return await self._unary_unary(
            "/envoy.api.v2.RouteDiscoveryService/FetchRoutes",
            discovery_request,
            DiscoveryResponse,
            timeout=timeout,
            deadline=deadline,
            metadata=metadata,
        )


class VirtualHostDiscoveryServiceStub(betterproto.ServiceStub):
    async def delta_virtual_hosts(
        self,
        delta_discovery_request_iterator: Union[
            AsyncIterable["DeltaDiscoveryRequest"], Iterable["DeltaDiscoveryRequest"]
        ],
        *,
        timeout: Optional[float] = None,
        deadline: Optional["Deadline"] = None,
        metadata: Optional["MetadataLike"] = None
    ) -> AsyncIterator["DeltaDiscoveryResponse"]:
        async for response in self._stream_stream(
            "/envoy.api.v2.VirtualHostDiscoveryService/DeltaVirtualHosts",
            delta_discovery_request_iterator,
            DeltaDiscoveryRequest,
            DeltaDiscoveryResponse,
            timeout=timeout,
            deadline=deadline,
            metadata=metadata,
        ):
            yield response


class ScopedRoutesDiscoveryServiceStub(betterproto.ServiceStub):
    async def stream_scoped_routes(
        self,
        discovery_request_iterator: Union[
            AsyncIterable["DiscoveryRequest"], Iterable["DiscoveryRequest"]
        ],
        *,
        timeout: Optional[float] = None,
        deadline: Optional["Deadline"] = None,
        metadata: Optional["MetadataLike"] = None
    ) -> AsyncIterator["DiscoveryResponse"]:
        async for response in self._stream_stream(
            "/envoy.api.v2.ScopedRoutesDiscoveryService/StreamScopedRoutes",
            discovery_request_iterator,
            DiscoveryRequest,
            DiscoveryResponse,
            timeout=timeout,
            deadline=deadline,
            metadata=metadata,
        ):
            yield response

    async def delta_scoped_routes(
        self,
        delta_discovery_request_iterator: Union[
            AsyncIterable["DeltaDiscoveryRequest"], Iterable["DeltaDiscoveryRequest"]
        ],
        *,
        timeout: Optional[float] = None,
        deadline: Optional["Deadline"] = None,
        metadata: Optional["MetadataLike"] = None
    ) -> AsyncIterator["DeltaDiscoveryResponse"]:
        async for response in self._stream_stream(
            "/envoy.api.v2.ScopedRoutesDiscoveryService/DeltaScopedRoutes",
            delta_discovery_request_iterator,
            DeltaDiscoveryRequest,
            DeltaDiscoveryResponse,
            timeout=timeout,
            deadline=deadline,
            metadata=metadata,
        ):
            yield response

    async def fetch_scoped_routes(
        self,
        discovery_request: "DiscoveryRequest",
        *,
        timeout: Optional[float] = None,
        deadline: Optional["Deadline"] = None,
        metadata: Optional["MetadataLike"] = None
    ) -> "DiscoveryResponse":
        return await self._unary_unary(
            "/envoy.api.v2.ScopedRoutesDiscoveryService/FetchScopedRoutes",
            discovery_request,
            DiscoveryResponse,
            timeout=timeout,
            deadline=deadline,
            metadata=metadata,
        )


class EndpointDiscoveryServiceStub(betterproto.ServiceStub):
    async def stream_endpoints(
        self,
        discovery_request_iterator: Union[
            AsyncIterable["DiscoveryRequest"], Iterable["DiscoveryRequest"]
        ],
        *,
        timeout: Optional[float] = None,
        deadline: Optional["Deadline"] = None,
        metadata: Optional["MetadataLike"] = None
    ) -> AsyncIterator["DiscoveryResponse"]:
        async for response in self._stream_stream(
            "/envoy.api.v2.EndpointDiscoveryService/StreamEndpoints",
            discovery_request_iterator,
            DiscoveryRequest,
            DiscoveryResponse,
            timeout=timeout,
            deadline=deadline,
            metadata=metadata,
        ):
            yield response

    async def delta_endpoints(
        self,
        delta_discovery_request_iterator: Union[
            AsyncIterable["DeltaDiscoveryRequest"], Iterable["DeltaDiscoveryRequest"]
        ],
        *,
        timeout: Optional[float] = None,
        deadline: Optional["Deadline"] = None,
        metadata: Optional["MetadataLike"] = None
    ) -> AsyncIterator["DeltaDiscoveryResponse"]:
        async for response in self._stream_stream(
            "/envoy.api.v2.EndpointDiscoveryService/DeltaEndpoints",
            delta_discovery_request_iterator,
            DeltaDiscoveryRequest,
            DeltaDiscoveryResponse,
            timeout=timeout,
            deadline=deadline,
            metadata=metadata,
        ):
            yield response

    async def fetch_endpoints(
        self,
        discovery_request: "DiscoveryRequest",
        *,
        timeout: Optional[float] = None,
        deadline: Optional["Deadline"] = None,
        metadata: Optional["MetadataLike"] = None
    ) -> "DiscoveryResponse":
        return await self._unary_unary(
            "/envoy.api.v2.EndpointDiscoveryService/FetchEndpoints",
            discovery_request,
            DiscoveryResponse,
            timeout=timeout,
            deadline=deadline,
            metadata=metadata,
        )


class ClusterDiscoveryServiceStub(betterproto.ServiceStub):
    async def stream_clusters(
        self,
        discovery_request_iterator: Union[
            AsyncIterable["DiscoveryRequest"], Iterable["DiscoveryRequest"]
        ],
        *,
        timeout: Optional[float] = None,
        deadline: Optional["Deadline"] = None,
        metadata: Optional["MetadataLike"] = None
    ) -> AsyncIterator["DiscoveryResponse"]:
        async for response in self._stream_stream(
            "/envoy.api.v2.ClusterDiscoveryService/StreamClusters",
            discovery_request_iterator,
            DiscoveryRequest,
            DiscoveryResponse,
            timeout=timeout,
            deadline=deadline,
            metadata=metadata,
        ):
            yield response

    async def delta_clusters(
        self,
        delta_discovery_request_iterator: Union[
            AsyncIterable["DeltaDiscoveryRequest"], Iterable["DeltaDiscoveryRequest"]
        ],
        *,
        timeout: Optional[float] = None,
        deadline: Optional["Deadline"] = None,
        metadata: Optional["MetadataLike"] = None
    ) -> AsyncIterator["DeltaDiscoveryResponse"]:
        async for response in self._stream_stream(
            "/envoy.api.v2.ClusterDiscoveryService/DeltaClusters",
            delta_discovery_request_iterator,
            DeltaDiscoveryRequest,
            DeltaDiscoveryResponse,
            timeout=timeout,
            deadline=deadline,
            metadata=metadata,
        ):
            yield response

    async def fetch_clusters(
        self,
        discovery_request: "DiscoveryRequest",
        *,
        timeout: Optional[float] = None,
        deadline: Optional["Deadline"] = None,
        metadata: Optional["MetadataLike"] = None
    ) -> "DiscoveryResponse":
        return await self._unary_unary(
            "/envoy.api.v2.ClusterDiscoveryService/FetchClusters",
            discovery_request,
            DiscoveryResponse,
            timeout=timeout,
            deadline=deadline,
            metadata=metadata,
        )


class ListenerDiscoveryServiceStub(betterproto.ServiceStub):
    async def delta_listeners(
        self,
        delta_discovery_request_iterator: Union[
            AsyncIterable["DeltaDiscoveryRequest"], Iterable["DeltaDiscoveryRequest"]
        ],
        *,
        timeout: Optional[float] = None,
        deadline: Optional["Deadline"] = None,
        metadata: Optional["MetadataLike"] = None
    ) -> AsyncIterator["DeltaDiscoveryResponse"]:
        async for response in self._stream_stream(
            "/envoy.api.v2.ListenerDiscoveryService/DeltaListeners",
            delta_discovery_request_iterator,
            DeltaDiscoveryRequest,
            DeltaDiscoveryResponse,
            timeout=timeout,
            deadline=deadline,
            metadata=metadata,
        ):
            yield response

    async def stream_listeners(
        self,
        discovery_request_iterator: Union[
            AsyncIterable["DiscoveryRequest"], Iterable["DiscoveryRequest"]
        ],
        *,
        timeout: Optional[float] = None,
        deadline: Optional["Deadline"] = None,
        metadata: Optional["MetadataLike"] = None
    ) -> AsyncIterator["DiscoveryResponse"]:
        async for response in self._stream_stream(
            "/envoy.api.v2.ListenerDiscoveryService/StreamListeners",
            discovery_request_iterator,
            DiscoveryRequest,
            DiscoveryResponse,
            timeout=timeout,
            deadline=deadline,
            metadata=metadata,
        ):
            yield response

    async def fetch_listeners(
        self,
        discovery_request: "DiscoveryRequest",
        *,
        timeout: Optional[float] = None,
        deadline: Optional["Deadline"] = None,
        metadata: Optional["MetadataLike"] = None
    ) -> "DiscoveryResponse":
        return await self._unary_unary(
            "/envoy.api.v2.ListenerDiscoveryService/FetchListeners",
            discovery_request,
            DiscoveryResponse,
            timeout=timeout,
            deadline=deadline,
            metadata=metadata,
        )


class RouteDiscoveryServiceBase(ServiceBase):
    async def stream_routes(
        self, discovery_request_iterator: AsyncIterator["DiscoveryRequest"]
    ) -> AsyncIterator["DiscoveryResponse"]:
        raise grpclib.GRPCError(grpclib.const.Status.UNIMPLEMENTED)

    async def delta_routes(
        self, delta_discovery_request_iterator: AsyncIterator["DeltaDiscoveryRequest"]
    ) -> AsyncIterator["DeltaDiscoveryResponse"]:
        raise grpclib.GRPCError(grpclib.const.Status.UNIMPLEMENTED)

    async def fetch_routes(
        self, discovery_request: "DiscoveryRequest"
    ) -> "DiscoveryResponse":
        raise grpclib.GRPCError(grpclib.const.Status.UNIMPLEMENTED)

    async def __rpc_stream_routes(
        self, stream: "grpclib.server.Stream[DiscoveryRequest, DiscoveryResponse]"
    ) -> None:
        request = stream.__aiter__()
        await self._call_rpc_handler_server_stream(
            self.stream_routes,
            stream,
            request,
        )

    async def __rpc_delta_routes(
        self,
        stream: "grpclib.server.Stream[DeltaDiscoveryRequest, DeltaDiscoveryResponse]",
    ) -> None:
        request = stream.__aiter__()
        await self._call_rpc_handler_server_stream(
            self.delta_routes,
            stream,
            request,
        )

    async def __rpc_fetch_routes(
        self, stream: "grpclib.server.Stream[DiscoveryRequest, DiscoveryResponse]"
    ) -> None:
        request = await stream.recv_message()
        response = await self.fetch_routes(request)
        await stream.send_message(response)

    def __mapping__(self) -> Dict[str, grpclib.const.Handler]:
        return {
            "/envoy.api.v2.RouteDiscoveryService/StreamRoutes": grpclib.const.Handler(
                self.__rpc_stream_routes,
                grpclib.const.Cardinality.STREAM_STREAM,
                DiscoveryRequest,
                DiscoveryResponse,
            ),
            "/envoy.api.v2.RouteDiscoveryService/DeltaRoutes": grpclib.const.Handler(
                self.__rpc_delta_routes,
                grpclib.const.Cardinality.STREAM_STREAM,
                DeltaDiscoveryRequest,
                DeltaDiscoveryResponse,
            ),
            "/envoy.api.v2.RouteDiscoveryService/FetchRoutes": grpclib.const.Handler(
                self.__rpc_fetch_routes,
                grpclib.const.Cardinality.UNARY_UNARY,
                DiscoveryRequest,
                DiscoveryResponse,
            ),
        }


class VirtualHostDiscoveryServiceBase(ServiceBase):
    async def delta_virtual_hosts(
        self, delta_discovery_request_iterator: AsyncIterator["DeltaDiscoveryRequest"]
    ) -> AsyncIterator["DeltaDiscoveryResponse"]:
        raise grpclib.GRPCError(grpclib.const.Status.UNIMPLEMENTED)

    async def __rpc_delta_virtual_hosts(
        self,
        stream: "grpclib.server.Stream[DeltaDiscoveryRequest, DeltaDiscoveryResponse]",
    ) -> None:
        request = stream.__aiter__()
        await self._call_rpc_handler_server_stream(
            self.delta_virtual_hosts,
            stream,
            request,
        )

    def __mapping__(self) -> Dict[str, grpclib.const.Handler]:
        return {
            "/envoy.api.v2.VirtualHostDiscoveryService/DeltaVirtualHosts": grpclib.const.Handler(
                self.__rpc_delta_virtual_hosts,
                grpclib.const.Cardinality.STREAM_STREAM,
                DeltaDiscoveryRequest,
                DeltaDiscoveryResponse,
            ),
        }


class ScopedRoutesDiscoveryServiceBase(ServiceBase):
    async def stream_scoped_routes(
        self, discovery_request_iterator: AsyncIterator["DiscoveryRequest"]
    ) -> AsyncIterator["DiscoveryResponse"]:
        raise grpclib.GRPCError(grpclib.const.Status.UNIMPLEMENTED)

    async def delta_scoped_routes(
        self, delta_discovery_request_iterator: AsyncIterator["DeltaDiscoveryRequest"]
    ) -> AsyncIterator["DeltaDiscoveryResponse"]:
        raise grpclib.GRPCError(grpclib.const.Status.UNIMPLEMENTED)

    async def fetch_scoped_routes(
        self, discovery_request: "DiscoveryRequest"
    ) -> "DiscoveryResponse":
        raise grpclib.GRPCError(grpclib.const.Status.UNIMPLEMENTED)

    async def __rpc_stream_scoped_routes(
        self, stream: "grpclib.server.Stream[DiscoveryRequest, DiscoveryResponse]"
    ) -> None:
        request = stream.__aiter__()
        await self._call_rpc_handler_server_stream(
            self.stream_scoped_routes,
            stream,
            request,
        )

    async def __rpc_delta_scoped_routes(
        self,
        stream: "grpclib.server.Stream[DeltaDiscoveryRequest, DeltaDiscoveryResponse]",
    ) -> None:
        request = stream.__aiter__()
        await self._call_rpc_handler_server_stream(
            self.delta_scoped_routes,
            stream,
            request,
        )

    async def __rpc_fetch_scoped_routes(
        self, stream: "grpclib.server.Stream[DiscoveryRequest, DiscoveryResponse]"
    ) -> None:
        request = await stream.recv_message()
        response = await self.fetch_scoped_routes(request)
        await stream.send_message(response)

    def __mapping__(self) -> Dict[str, grpclib.const.Handler]:
        return {
            "/envoy.api.v2.ScopedRoutesDiscoveryService/StreamScopedRoutes": grpclib.const.Handler(
                self.__rpc_stream_scoped_routes,
                grpclib.const.Cardinality.STREAM_STREAM,
                DiscoveryRequest,
                DiscoveryResponse,
            ),
            "/envoy.api.v2.ScopedRoutesDiscoveryService/DeltaScopedRoutes": grpclib.const.Handler(
                self.__rpc_delta_scoped_routes,
                grpclib.const.Cardinality.STREAM_STREAM,
                DeltaDiscoveryRequest,
                DeltaDiscoveryResponse,
            ),
            "/envoy.api.v2.ScopedRoutesDiscoveryService/FetchScopedRoutes": grpclib.const.Handler(
                self.__rpc_fetch_scoped_routes,
                grpclib.const.Cardinality.UNARY_UNARY,
                DiscoveryRequest,
                DiscoveryResponse,
            ),
        }


class EndpointDiscoveryServiceBase(ServiceBase):
    async def stream_endpoints(
        self, discovery_request_iterator: AsyncIterator["DiscoveryRequest"]
    ) -> AsyncIterator["DiscoveryResponse"]:
        raise grpclib.GRPCError(grpclib.const.Status.UNIMPLEMENTED)

    async def delta_endpoints(
        self, delta_discovery_request_iterator: AsyncIterator["DeltaDiscoveryRequest"]
    ) -> AsyncIterator["DeltaDiscoveryResponse"]:
        raise grpclib.GRPCError(grpclib.const.Status.UNIMPLEMENTED)

    async def fetch_endpoints(
        self, discovery_request: "DiscoveryRequest"
    ) -> "DiscoveryResponse":
        raise grpclib.GRPCError(grpclib.const.Status.UNIMPLEMENTED)

    async def __rpc_stream_endpoints(
        self, stream: "grpclib.server.Stream[DiscoveryRequest, DiscoveryResponse]"
    ) -> None:
        request = stream.__aiter__()
        await self._call_rpc_handler_server_stream(
            self.stream_endpoints,
            stream,
            request,
        )

    async def __rpc_delta_endpoints(
        self,
        stream: "grpclib.server.Stream[DeltaDiscoveryRequest, DeltaDiscoveryResponse]",
    ) -> None:
        request = stream.__aiter__()
        await self._call_rpc_handler_server_stream(
            self.delta_endpoints,
            stream,
            request,
        )

    async def __rpc_fetch_endpoints(
        self, stream: "grpclib.server.Stream[DiscoveryRequest, DiscoveryResponse]"
    ) -> None:
        request = await stream.recv_message()
        response = await self.fetch_endpoints(request)
        await stream.send_message(response)

    def __mapping__(self) -> Dict[str, grpclib.const.Handler]:
        return {
            "/envoy.api.v2.EndpointDiscoveryService/StreamEndpoints": grpclib.const.Handler(
                self.__rpc_stream_endpoints,
                grpclib.const.Cardinality.STREAM_STREAM,
                DiscoveryRequest,
                DiscoveryResponse,
            ),
            "/envoy.api.v2.EndpointDiscoveryService/DeltaEndpoints": grpclib.const.Handler(
                self.__rpc_delta_endpoints,
                grpclib.const.Cardinality.STREAM_STREAM,
                DeltaDiscoveryRequest,
                DeltaDiscoveryResponse,
            ),
            "/envoy.api.v2.EndpointDiscoveryService/FetchEndpoints": grpclib.const.Handler(
                self.__rpc_fetch_endpoints,
                grpclib.const.Cardinality.UNARY_UNARY,
                DiscoveryRequest,
                DiscoveryResponse,
            ),
        }


class ClusterDiscoveryServiceBase(ServiceBase):
    async def stream_clusters(
        self, discovery_request_iterator: AsyncIterator["DiscoveryRequest"]
    ) -> AsyncIterator["DiscoveryResponse"]:
        raise grpclib.GRPCError(grpclib.const.Status.UNIMPLEMENTED)

    async def delta_clusters(
        self, delta_discovery_request_iterator: AsyncIterator["DeltaDiscoveryRequest"]
    ) -> AsyncIterator["DeltaDiscoveryResponse"]:
        raise grpclib.GRPCError(grpclib.const.Status.UNIMPLEMENTED)

    async def fetch_clusters(
        self, discovery_request: "DiscoveryRequest"
    ) -> "DiscoveryResponse":
        raise grpclib.GRPCError(grpclib.const.Status.UNIMPLEMENTED)

    async def __rpc_stream_clusters(
        self, stream: "grpclib.server.Stream[DiscoveryRequest, DiscoveryResponse]"
    ) -> None:
        request = stream.__aiter__()
        await self._call_rpc_handler_server_stream(
            self.stream_clusters,
            stream,
            request,
        )

    async def __rpc_delta_clusters(
        self,
        stream: "grpclib.server.Stream[DeltaDiscoveryRequest, DeltaDiscoveryResponse]",
    ) -> None:
        request = stream.__aiter__()
        await self._call_rpc_handler_server_stream(
            self.delta_clusters,
            stream,
            request,
        )

    async def __rpc_fetch_clusters(
        self, stream: "grpclib.server.Stream[DiscoveryRequest, DiscoveryResponse]"
    ) -> None:
        request = await stream.recv_message()
        response = await self.fetch_clusters(request)
        await stream.send_message(response)

    def __mapping__(self) -> Dict[str, grpclib.const.Handler]:
        return {
            "/envoy.api.v2.ClusterDiscoveryService/StreamClusters": grpclib.const.Handler(
                self.__rpc_stream_clusters,
                grpclib.const.Cardinality.STREAM_STREAM,
                DiscoveryRequest,
                DiscoveryResponse,
            ),
            "/envoy.api.v2.ClusterDiscoveryService/DeltaClusters": grpclib.const.Handler(
                self.__rpc_delta_clusters,
                grpclib.const.Cardinality.STREAM_STREAM,
                DeltaDiscoveryRequest,
                DeltaDiscoveryResponse,
            ),
            "/envoy.api.v2.ClusterDiscoveryService/FetchClusters": grpclib.const.Handler(
                self.__rpc_fetch_clusters,
                grpclib.const.Cardinality.UNARY_UNARY,
                DiscoveryRequest,
                DiscoveryResponse,
            ),
        }


class ListenerDiscoveryServiceBase(ServiceBase):
    async def delta_listeners(
        self, delta_discovery_request_iterator: AsyncIterator["DeltaDiscoveryRequest"]
    ) -> AsyncIterator["DeltaDiscoveryResponse"]:
        raise grpclib.GRPCError(grpclib.const.Status.UNIMPLEMENTED)

    async def stream_listeners(
        self, discovery_request_iterator: AsyncIterator["DiscoveryRequest"]
    ) -> AsyncIterator["DiscoveryResponse"]:
        raise grpclib.GRPCError(grpclib.const.Status.UNIMPLEMENTED)

    async def fetch_listeners(
        self, discovery_request: "DiscoveryRequest"
    ) -> "DiscoveryResponse":
        raise grpclib.GRPCError(grpclib.const.Status.UNIMPLEMENTED)

    async def __rpc_delta_listeners(
        self,
        stream: "grpclib.server.Stream[DeltaDiscoveryRequest, DeltaDiscoveryResponse]",
    ) -> None:
        request = stream.__aiter__()
        await self._call_rpc_handler_server_stream(
            self.delta_listeners,
            stream,
            request,
        )

    async def __rpc_stream_listeners(
        self, stream: "grpclib.server.Stream[DiscoveryRequest, DiscoveryResponse]"
    ) -> None:
        request = stream.__aiter__()
        await self._call_rpc_handler_server_stream(
            self.stream_listeners,
            stream,
            request,
        )

    async def __rpc_fetch_listeners(
        self, stream: "grpclib.server.Stream[DiscoveryRequest, DiscoveryResponse]"
    ) -> None:
        request = await stream.recv_message()
        response = await self.fetch_listeners(request)
        await stream.send_message(response)

    def __mapping__(self) -> Dict[str, grpclib.const.Handler]:
        return {
            "/envoy.api.v2.ListenerDiscoveryService/DeltaListeners": grpclib.const.Handler(
                self.__rpc_delta_listeners,
                grpclib.const.Cardinality.STREAM_STREAM,
                DeltaDiscoveryRequest,
                DeltaDiscoveryResponse,
            ),
            "/envoy.api.v2.ListenerDiscoveryService/StreamListeners": grpclib.const.Handler(
                self.__rpc_stream_listeners,
                grpclib.const.Cardinality.STREAM_STREAM,
                DiscoveryRequest,
                DiscoveryResponse,
            ),
            "/envoy.api.v2.ListenerDiscoveryService/FetchListeners": grpclib.const.Handler(
                self.__rpc_fetch_listeners,
                grpclib.const.Cardinality.UNARY_UNARY,
                DiscoveryRequest,
                DiscoveryResponse,
            ),
        }
