# Generated by Django 3.2.16 on 2022-10-21 20:46

import datetime

import django.core.validators
from django.db import migrations, models
import django.db.models.deletion


class Migration(migrations.Migration):

    dependencies = [
        ('triggers', '0001_initial'),
    ]

    operations = [
        migrations.CreateModel(
            name='ActionCountCondition',
            fields=[
                ('condition_ptr', models.OneToOneField(auto_created=True, on_delete=django.db.models.deletion.CASCADE, parent_link=True, primary_key=True, serialize=False, to='triggers.condition')),
                ('limit', models.PositiveIntegerField(default=1, help_text='Maximal number of actions that can be triggered for the user.', validators=[django.core.validators.MinValueValidator(1)], verbose_name='action count limit')),
            ],
            options={
                'verbose_name': 'action count',
                'verbose_name_plural': 'action count',
            },
            bases=('triggers.condition',),
        ),
        migrations.CreateModel(
            name='ActionFrequencyCondition',
            fields=[
                ('condition_ptr', models.OneToOneField(auto_created=True, on_delete=django.db.models.deletion.CASCADE, parent_link=True, primary_key=True, serialize=False, to='triggers.condition')),
                ('limit', models.DurationField(default=datetime.timedelta(days=30), help_text='Minimal period of time that should run out before the next action can be triggered.', verbose_name='action frequency limit')),
            ],
            options={
                'verbose_name': 'action frequency',
                'verbose_name_plural': 'action frequency',
            },
            bases=('triggers.condition',),
        ),
        migrations.RemoveField(
            model_name='trigger',
            name='action_count_limit',
        ),
        migrations.RemoveField(
            model_name='trigger',
            name='action_frequency_limit',
        ),
    ]
