<p  align="center">
  <strong>HRID: Human Readable Identifier</strong>
  <br>
  <code>The Human Readable ID Generator Library For Python3</code>
  <br>
</p>

## Usage

Install
```
pip3 install hrid
```

Use in Python code
```python
from hrid import HRID

hruuid = HRID()
uuid = hruuid.generate()
print(uuid)
```

## Why HRID ?
* Extremely easy to remember for comparing to UUID, that why this package named `human readable`, example `red-bird-fly-crazily` versus `206dbaab-526b-41cd-aa6f-7febd82e83ab`. 
* Over 800 bilions alphabet uuid can be generated by default (or many more if include element). Unlikely to generate twice.
* Customizable structure for uuid, eg {`adj`}{`noun`} or {`number`}{`adj`}{`noun`}{`verb`}{`adverd`} or add whatever you want `prefix`, `postfix`

## Credit
* [Dictionary Source](https://github.com/dariusk/corpora)
* [Inspired by Google API Design](https://cloud.google.com/blog/products/gcp/api-design-choosing-between-names-and-identifiers-in-urls)

## License

[MIT](./LICENSE)