"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.EcrImageScanNotify = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const path = require("path");
const events = require("@aws-cdk/aws-events");
const target = require("@aws-cdk/aws-events-targets");
const iam = require("@aws-cdk/aws-iam");
const _lambda = require("@aws-cdk/aws-lambda");
const cdk = require("@aws-cdk/core");
/**
 * @experimental
 */
class EcrImageScanNotify extends cdk.Construct {
    /**
     * @experimental
     */
    constructor(scope, id, props) {
        super(scope, id);
        const lambdaFun = new _lambda.Function(this, 'lambda_fun', {
            handler: 'lambda_function.lambda_handler',
            code: _lambda.Code.fromAsset(path.join(__dirname, '../function')),
            runtime: _lambda.Runtime.PYTHON_3_8,
            timeout: cdk.Duration.minutes(3),
            environment: {
                WEBHOOK_URL: props.webhookUrl,
                CHANNEL: props.channel,
            },
        });
        const ecrReadOnlyPolicyStatement = new iam.PolicyStatement({
            actions: ['ecr:DescribeImages'],
            resources: ['*'],
        });
        lambdaFun.role.addToPrincipalPolicy(ecrReadOnlyPolicyStatement);
        const ecrScanTarget = new target.LambdaFunction(lambdaFun);
        new events.Rule(this, 'EventBusEcrImageScan', {
            ruleName: 'EventBusEcrImageScanRule',
            description: 'ECR Scan and event to lambda to Slack',
            targets: [ecrScanTarget],
            eventPattern: {
                source: ['aws.ecr'],
                detailType: ['ECR Image Scan'],
            },
        });
    }
}
exports.EcrImageScanNotify = EcrImageScanNotify;
_a = JSII_RTTI_SYMBOL_1;
EcrImageScanNotify[_a] = { fqn: "cdk-ecr-image-scan-notify.EcrImageScanNotify", version: "0.0.104" };
//# sourceMappingURL=data:application/json;base64,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