# -*- coding: utf-8 -*-
from setuptools import setup

packages = \
['pydvdcss']

package_data = \
{'': ['*']}

setup_kwargs = {
    'name': 'pydvdcss',
    'version': '1.2.0',
    'description': "Python wrapper for VideoLAN's libdvdcss.",
    'long_description': '![Banner](banner.png?raw=true)\n\n* * *\n\n![Python version tests](https://github.com/rlaPHOENiX/pydvdcss/workflows/Build/badge.svg?branch=master)\n![Python versions](https://img.shields.io/pypi/pyversions/pydvdcss)\n[![PyPI version](https://img.shields.io/pypi/v/pydvdcss)](https://pypi.python.org/pypi/pydvdcss)\n[![GPLv3 license](https://img.shields.io/badge/license-GPLv3-blue)](https://github.com/rlaPHOENiX/pydvdcss/blob/master/LICENSE)\n[![PyPI status](https://img.shields.io/pypi/status/pydvdcss)](https://pypi.python.org/pypi/pydvdcss)\n[![GitHub issues](https://img.shields.io/github/issues/rlaPHOENiX/pydvdcss)](https://github.com/rlaPHOENiX/pydvdcss/issues)\n[![DeepSource issues](https://deepsource.io/gh/rlaPHOENiX/pydvdcss.svg/?label=active+issues)](https://deepsource.io/gh/rlaPHOENiX/pydvdcss/?ref=repository-badge)\n[![Contributors](https://img.shields.io/github/contributors/rlaPHOENiX/pydvdcss)](https://github.com/rlaPHOENiX/pydvdcss/graphs/contributors)\n\n**pydvdcss** is a python wrapper for VideoLAN\'s [libdvdcss].\n\n[libdvdcss] is a simple library designed for accessing DVDs like a block device without having to bother about the\ndecryption.\n\n  [libdvdcss]: <https://www.videolan.org/developers/libdvdcss.html>\n\n```py\nfrom pydvdcss.dvdcss import DvdCss\n\n# ...\n\n# choose device\ndev = "/dev/sr0"  # e.g. \'E:\', `/dev/sr0`, or a path to an ISO file\n\n# use `with` to auto dispose once you leave the tree\n# of course you can also just do `dvdcss = DvdCss()`\nwith DvdCss() as dvdcss:\n\n  # open device\n  dvdcss.open(dev)\n\n  # check if dvd is scrambled\n  if dvdcss.is_scrambled():\n    print("The DVD is scrambled!")\n\n  # read volume id from the ISO 9660 Volume Descriptor Set\n  dvdcss.seek(16)       # seek to sector 16, the first 15 sectors are unused by ISO 9660\n  dvdcss.read(1)        # read one sector amount of data\n  data = dvdcss.buffer  # access the latest read data\n  volume_label = data[40:72].strip().decode()\n  print("%s: %s" % (dev, volume_label))\n  # >> eg. `\'/dev/sr0: THE_IT_CROWD_DISC_1\'`\n\n# make sure you dispose when your done if you didn\'t\n# use `with`, otherwise stuff will get stuck in memory.\n# usage of `with` on DvdCss automatically handles disposing.\n# dvdcss.dispose()\n```\n\n---\n\n## Features\n\n**Portability**\n\nAnything that can run the supported python versions shown above is supported.\n\n**Simplicity**\n\nA DVD player can be built around the `libdvdcss` API using no more than 4 or 5 library calls.\n\n**Freedom**\n\n`libdvdcss` and this wrapper `pydvdcss` are released under the General Public License, ensuring it will stay free, and used only for free software products.\n\n**Just better**\n\nUnlike most similar projects, `libdvdcss` does not require the region of your drive to be set.\n\n## Installation\n\nfrom PyPI:\n\n```shell\n$ python -m pip install --user pydvdcss\n```\n\nor from source-code:\n\n- Source-code may have changes that are not yet tested or stable, and may have regressions.\n- Only install from Source-code if you have a reason, e.g. to test changes.\n- Requires [Poetry] as it\'s used as the build system backend.\n\n  [Poetry]: <https://python-poetry.org/docs/#installation>\n\n```shell\n$ git clone https://github.com/rlaPHOENiX/pydvdcss.git\n$ cd pydvdcss\n$ python -m pip install --user .\n```\n\n## To-do\n\n- [x] Implement dvdcss_open\n- [x] Implement dvdcss_close\n- [x] Implement dvdcss_seek\n- [x] Implement dvdcss_read\n- [x] Implement dvdcss_error\n- [x] Implement dvdcss_is_scrambled\n- [x] Implement `__enter__` and `__exit__` for proper disposing\n- [x] Add handlers for failed find_library calls\n- [X] Add handlers for failed cdll calls\n- [x] Add instructions for installing libdvdcss\n- [x] Add and test support for Windows\n- [x] Add and test support for Mac OS\n- [x] Add and test support for Linux\n- [x] Add function to set DVDCSS_VERBOSE\n- [x] Add function to set DVDCSS_METHOD\n- [ ] Implement dvdcss_readv, not sure how this would be used or implemented\n\n## Functions\n\n### DvdCss.open(psz_target=[string])\n\nOpen a DVD device or directory and return a dvdcss instance.\n\nInitialize the libdvdcss library and open the requested DVD device or directory.\nlibdvdcss checks whether ioctls can be performed on the disc, and when possible,\nthe disc key is retrieved.\n\nopen() returns a handle to be used for all subsequent libdvdcss calls. If an\nerror occurred, NULL is returned.\n\n- **psz_target**: target name, e.g. "/dev/hdc" or "E:".\n\n### DvdCss.close()\n\nClose the DVD and clean up the library.\n\nClose the DVD device and free all the memory allocated by libdvdcss.\nOn return, the dvdcss_t handle is invalidated and may not be used again.\n\n### DvdCss.seek(i_blocks=[int], i_flags=[int;NOFLAGS])\n\nSeek in the disc and change the current key if requested.\n\nThis function seeks to the requested position, in logical blocks.\nReturns the new position in blocks, or a negative value in case an error\nhappened.\n\nTips:\n\n> Use SEEK_MPEG flag when seeking throughout VOB data sectors. It isn\'t needed\n> on the first sector.\n\n> Use SEEK_KEY flag the first time you enter a TITLE. You _can_ always call it\n> in VOB data sectors, however it will be unnecessary and cause slowdowns.\n\n- **i_blocks**: absolute block offset to seek to.\n- **i_flags**: NOFLAGS by default, or you can specify SEEK_KEY or SEEK_MPEG flags.\n\n### DvdCss.read(i_blocks=[int], i_flags=[int;NOFLAGS])\n\nRead from the disc and decrypt data if requested.\n\nThis function reads i_blocks logical blocks from the DVD.\nReturns the amount of blocks read, or a negative value in case an error happened.\n\nTips:\n\n> Get the read contents from the buffer variable of DvdCss instance.\n\n- **i_blocks**: absolute block offset to seek to.\n- **i_flags**: NOFLAGS by default, or you can specify the READ_DECRYPT flag.\n\n### DvdCss.error()\n\nReturn a string containing the latest error that occurred in the given libdvdcss\ninstance.\n\nThis function returns a constant string containing the latest error that occurred\nin libdvdcss. It can be used to format error messages at your convenience in your\napplication.\n\nReturns a null-terminated string containing the latest error message.\n\n### DvdCss.is_scrambled()\n\nCheck if the DVD is scrambled.\n\nReturns True if it\'s scrambled.\n\n---\n\n## [PHOENiX](https://github.com/rlaPHOENiX)\n\n## [LICENSE (GPLv3)](https://github.com/rlaPHOENiX/pydvdcss/blob/master/LICENSE)\n\n## [CONTRIBUTORS](https://github.com/rlaPHOENiX/pydvdcss/graphs/contributors)\n',
    'author': 'PHOENiX',
    'author_email': 'rlaphoenix@pm.me',
    'maintainer': 'PHOENiX',
    'maintainer_email': 'rlaphoenix@pm.me',
    'url': 'https://github.com/rlaphoenix/pydvdcss',
    'packages': packages,
    'package_data': package_data,
    'python_requires': '>=3.5',
}


setup(**setup_kwargs)
