"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.NatGateway = exports.NatGatewayProperty = void 0;
const ros = require("@alicloud/ros-cdk-core");
const vpc_generated_1 = require("./vpc.generated");
Object.defineProperty(exports, "NatGatewayProperty", { enumerable: true, get: function () { return vpc_generated_1.RosNatGateway; } });
/**
 * A ROS resource type:  `ALIYUN::VPC::NatGateway`
 */
class NatGateway extends ros.Resource {
    /**
     * Create a new `ALIYUN::VPC::NatGateway`.
     *
     * Param scope - scope in which this resource is defined
     * Param id    - scoped id of the resource
     * Param props - resource properties
     */
    constructor(scope, id, props, enableResourcePropertyConstraint = true) {
        super(scope, id);
        const rosNatGateway = new vpc_generated_1.RosNatGateway(this, id, {
            description: props.description,
            natGatewayName: props.natGatewayName,
            instanceChargeType: props.instanceChargeType === undefined || props.instanceChargeType === null ? 'PostPaid' : props.instanceChargeType,
            pricingCycle: props.pricingCycle,
            eipBindMode: props.eipBindMode,
            vSwitchId: props.vSwitchId,
            duration: props.duration === undefined || props.duration === null ? 1 : props.duration,
            deletionProtection: props.deletionProtection === undefined || props.deletionProtection === null ? false : props.deletionProtection,
            autoPay: props.autoPay === undefined || props.autoPay === null ? false : props.autoPay,
            natType: props.natType === undefined || props.natType === null ? 'Enhanced' : props.natType,
            internetChargeType: props.internetChargeType,
            deletionForce: props.deletionForce === undefined || props.deletionForce === null ? false : props.deletionForce,
            vpcId: props.vpcId,
            networkType: props.networkType,
            tags: props.tags,
        }, enableResourcePropertyConstraint && this.stack.enableResourcePropertyConstraint);
        this.resource = rosNatGateway;
        this.attrForwardTableId = rosNatGateway.attrForwardTableId;
        this.attrNatGatewayId = rosNatGateway.attrNatGatewayId;
        this.attrSNatTableId = rosNatGateway.attrSNatTableId;
    }
}
exports.NatGateway = NatGateway;
//# sourceMappingURL=data:application/json;base64,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