"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.CommonBandwidthPackageIp = exports.CommonBandwidthPackageIpProperty = void 0;
const ros = require("@alicloud/ros-cdk-core");
const vpc_generated_1 = require("./vpc.generated");
Object.defineProperty(exports, "CommonBandwidthPackageIpProperty", { enumerable: true, get: function () { return vpc_generated_1.RosCommonBandwidthPackageIp; } });
/**
 * A ROS resource type:  `ALIYUN::VPC::CommonBandwidthPackageIp`
 */
class CommonBandwidthPackageIp extends ros.Resource {
    /**
     * Create a new `ALIYUN::VPC::CommonBandwidthPackageIp`.
     *
     * Param scope - scope in which this resource is defined
     * Param id    - scoped id of the resource
     * Param props - resource properties
     */
    constructor(scope, id, props, enableResourcePropertyConstraint = true) {
        super(scope, id);
        const rosCommonBandwidthPackageIp = new vpc_generated_1.RosCommonBandwidthPackageIp(this, id, {
            eips: props.eips,
            bandwidthPackageId: props.bandwidthPackageId,
        }, enableResourcePropertyConstraint && this.stack.enableResourcePropertyConstraint);
        this.resource = rosCommonBandwidthPackageIp;
        this.attrAllocationIds = rosCommonBandwidthPackageIp.attrAllocationIds;
        this.attrIpAddresses = rosCommonBandwidthPackageIp.attrIpAddresses;
    }
}
exports.CommonBandwidthPackageIp = CommonBandwidthPackageIp;
//# sourceMappingURL=data:application/json;base64,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