# -*- coding: utf-8 -*-
from setuptools import setup

packages = \
['mmc_export', 'mmc_export.Formats', 'mmc_export.Helpers']

package_data = \
{'': ['*']}

install_requires = \
['Werkzeug>=2.1.2,<3.0.0',
 'aiohttp-client-cache[filesystem]>=0.7.0,<0.8.0',
 'aiohttp>=3.8.1,<4.0.0',
 'cryptography>=37.0.2,<38.0.0',
 'gql-query-builder>=0.1.7,<0.2.0',
 'jsonpickle>=2.1.0,<3.0.0',
 'keyring>=23.5.1,<24.0.0',
 'murmurhash2>=0.2.10,<0.3.0',
 'pytoml>=0.1.21,<0.2.0',
 'tenacity>=8.0.1,<9.0.0',
 'tomli>=2.0.1,<3.0.0',
 'xxhash>=3.0.0,<4.0.0']

entry_points = \
{'console_scripts': ['mmc-export = mmc_export:main']}

setup_kwargs = {
    'name': 'mmc-export',
    'version': '2.3.5',
    'description': 'Export MMC modpack to other modpack formats',
    'long_description': '# MultiMC advanced exporter\n![PyPI pyversions](https://img.shields.io/pypi/pyversions/mmc-export)\n[![PyPI version](https://img.shields.io/pypi/v/mmc-export?label=mmc-export&color=%2347a637)](https://pypi.org/project/mmc-export)\n[![PyPI downloads](https://img.shields.io/pypi/dm/mmc-export?color=%23894bbf)](https://pypistats.org/packages/mmc-export)\n[![GitHub license](https://img.shields.io/github/license/RozeFound/mmc-export)](/LICENSE)\n\nSince MultiMC export features are very limited, I created a script that solves this problem, with this script you can export MultiMC pack to any popular format (e.g. curseforge, modrinth, packwiz). MultiMC forks which didn\'t changed export format much also supported, PolyMC support approved.\n\n# Features\n\n- Support conversion to:\n    - CurseForge\n    - Modrinth\n    - packwiz\n- Detects downloadable resourcepacks and shaders\n- Supports github parsing[¹](#github-rate-limits)\n- Loose modrinth search\n- User friendly toml config\n- Multiple output formats at once\n\n---\n### GitHub rate limits\n\nGitHub has limited requests per hour (up to 60), this means that if you have more than 60 mods, the rest will be excluded from github search. \nIf you authenticate with GitHub using `mmc-export gh-login`, the limit will be removed and requests will be faster. You can always log out with `mmc-export gh-logout`.\n\nIf you don\'t want to use github search by some reason, you can specify `--exclude-providers GitHub` as argument.\n\n# How to Use\n```\nmmc-export -i modpack.zip -c config.toml -f Modrinth packwiz -o converted_modpacks\n```\nIt\'s recommended to fill config at least with basic info like name and version, some launchers can fail import if these values are empty.\n\n## Sub-commands\n\n`gh-login` - to authrize GitHub \\\n`gh-logout` - to get info how to deauthorize GitHub \n\n`purge-cache` - to purge cache. Available arguments:\n```\n--web: to delete requests cache and downloaded mods\n--files: to delete hashes cache\n--all: equivalent to --web --files, deletes all cache (default)\n```\n\n## Syntax\n```\nmmc-export [sub-command] [-h] [-c CONFIG] -i INPUT -f FORMAT [-o OUTPUT] [-v VERSION] [--modrinth-search SEARCH_TYPE] [--exclude-providers PROVIDERS] [--exclude-forbidden]\n```\n\n### Explanation\n```\n-h --help: prints help\n-i --input: path to modpack, must be zip file exported from MultiMC.\n-c --config: path to config, used to fill the gaps like description or losted mods.\n-f --format: output formats, must be separated by spaces.\n-o --output: directory where converted zip files will be stored.\n-v --version: specify modpack version, will be overriden by config\'s value if exists\n--modrinth-search: modrinth search accuracy\n--exclude-providers: providers you wish to exclude from search\n--exclude-forbidden: set to not ignore CF distribution flag. Must be enabled for public modpacks.\n```\n> All paths can be relative to current working directory or absolute.\n\n`--format` options (case-sensitive): \n- `CurseForge`\n- `Modrinth`\n- `packwiz`\n- `Intermediate` (only for debugging, may contain sensitive data like username)\n\n`--exclude-providers` options (case-sensitive): \n- `CurseForge`\n- `Modrinth`\n- `GitHub`\n\n`--modrinth-search` options:\n- `exact` - by hash (default)\n- `accurate` - by hash or slug\n- `loose` - by hash, slug or long name\n\nThe example for the optional `--config` file [can be found here](example_config.toml). \n\nFor example, if the script says\n\n> No config entry found for resource: ModName\n\nThen you should add **one** of the following entries to the end of the config:\n\n#### Specify source URL\n```\n[[Resource]]\nname = "ModName"\nfilename = "the_name_of_the.jar" \nurl = "https://cdn.modrinth.com/data/abcdefg/versions/1.0.0/the_name_of_the.jar"\n```\n#### Hide the warning\n```\n[[Resource]]\nname = "ModName"\nfilename = "the_name_of_the.jar" \naction = "ignore"\n```\n#### Explicitly move to overrides\n```\n[[Resource]]\nname = "ModName"\nfilename = "the_name_of_the.jar" \naction = "override"\n```\n#### Delete the file altogether\n```\n[[Resource]]\nname = "ModName"\nfilename = "the_name_of_the.jar" \naction = "remove"\n```\n\n# How to Install / Update\n```\npip install -U mmc-export\n```\n',
    'author': 'RozeFound',
    'author_email': None,
    'maintainer': None,
    'maintainer_email': None,
    'url': 'https://github.com/RozeFound/mmc-export',
    'packages': packages,
    'package_data': package_data,
    'install_requires': install_requires,
    'entry_points': entry_points,
    'python_requires': '>=3.10,<4.0',
}


setup(**setup_kwargs)
