from typing import Any, Optional

from botocore.exceptions import ChecksumError as ChecksumError
from botocore.exceptions import ConnectionClosedError as ConnectionClosedError
from botocore.exceptions import ConnectionError as ConnectionError
from botocore.exceptions import EndpointConnectionError as EndpointConnectionError
from botocore.exceptions import ReadTimeoutError as ReadTimeoutError

EXCEPTION_MAP: Any

def delay_exponential(base: Any, growth_factor: Any, attempts: Any) -> Any: ...
def create_exponential_delay_function(base: Any, growth_factor: Any) -> Any: ...
def create_retry_handler(config: Any, operation_name: Optional[Any] = ...) -> Any: ...
def create_retry_action_from_config(
    config: Any, operation_name: Optional[Any] = ...
) -> Any: ...
def create_checker_from_retry_config(
    config: Any, operation_name: Optional[Any] = ...
) -> Any: ...

class RetryHandler:
    def __init__(self, checker: Any, action: Any) -> None: ...
    def __call__(
        self, attempts: Any, response: Any, caught_exception: Any, **kwargs: Any
    ) -> Any: ...

class BaseChecker:
    def __call__(
        self, attempt_number: Any, response: Any, caught_exception: Any
    ) -> Any: ...

class MaxAttemptsDecorator(BaseChecker):
    def __init__(
        self, checker: Any, max_attempts: Any, retryable_exceptions: Optional[Any] = ...
    ) -> None: ...
    def __call__(
        self, attempt_number: Any, response: Any, caught_exception: Any
    ) -> Any: ...

class HTTPStatusCodeChecker(BaseChecker):
    def __init__(self, status_code: Any) -> None: ...

class ServiceErrorCodeChecker(BaseChecker):
    def __init__(self, status_code: Any, error_code: Any) -> None: ...

class MultiChecker(BaseChecker):
    def __init__(self, checkers: Any) -> None: ...
    def __call__(
        self, attempt_number: Any, response: Any, caught_exception: Any
    ) -> Any: ...

class CRC32Checker(BaseChecker):
    def __init__(self, header: Any) -> None: ...

class ExceptionRaiser(BaseChecker): ...
