from typing import Any, Optional

EMPTY_SHA256_HASH: str
PAYLOAD_BUFFER: Any
ISO8601: str
SIGV4_TIMESTAMP: str
SIGNED_HEADERS_BLACKLIST: Any
UNSIGNED_PAYLOAD: str

class BaseSigner:
    REQUIRES_REGION: bool = ...
    def add_auth(self, request: Any) -> None: ...

class SigV2Auth(BaseSigner):
    credentials: Any = ...
    def __init__(self, credentials: Any) -> None: ...
    def calc_signature(self, request: Any, params: Any) -> Any: ...
    def add_auth(self, request: Any) -> Any: ...

class SigV3Auth(BaseSigner):
    credentials: Any = ...
    def __init__(self, credentials: Any) -> None: ...
    def add_auth(self, request: Any) -> None: ...

class SigV4Auth(BaseSigner):
    REQUIRES_REGION: bool = ...
    credentials: Any = ...
    def __init__(
        self, credentials: Any, service_name: Any, region_name: Any
    ) -> None: ...
    def headers_to_sign(self, request: Any) -> Any: ...
    def canonical_query_string(self, request: Any) -> Any: ...
    def canonical_headers(self, headers_to_sign: Any) -> Any: ...
    def signed_headers(self, headers_to_sign: Any) -> Any: ...
    def payload(self, request: Any) -> Any: ...
    def canonical_request(self, request: Any) -> Any: ...
    def scope(self, request: Any) -> Any: ...
    def credential_scope(self, request: Any) -> Any: ...
    def string_to_sign(self, request: Any, canonical_request: Any) -> Any: ...
    def signature(self, string_to_sign: Any, request: Any) -> Any: ...
    def add_auth(self, request: Any) -> None: ...

class S3SigV4Auth(SigV4Auth): ...

class SigV4QueryAuth(SigV4Auth):
    DEFAULT_EXPIRES: int = ...
    def __init__(
        self, credentials: Any, service_name: Any, region_name: Any, expires: Any = ...
    ) -> None: ...

class S3SigV4QueryAuth(SigV4QueryAuth):
    def payload(self, request: Any) -> Any: ...

class S3SigV4PostAuth(SigV4Auth):
    def add_auth(self, request: Any) -> None: ...

class HmacV1Auth(BaseSigner):
    QSAOfInterest: Any = ...
    credentials: Any = ...
    def __init__(
        self,
        credentials: Any,
        service_name: Optional[Any] = ...,
        region_name: Optional[str] = ...,
    ) -> None: ...
    def sign_string(self, string_to_sign: Any) -> Any: ...
    def canonical_standard_headers(self, headers: Any) -> Any: ...
    def canonical_custom_headers(self, headers: Any) -> Any: ...
    def unquote_v(self, nv: Any) -> Any: ...
    def canonical_resource(self, split: Any, auth_path: Optional[Any] = ...) -> Any: ...
    def canonical_string(
        self,
        method: Any,
        split: Any,
        headers: Any,
        expires: Optional[Any] = ...,
        auth_path: Optional[Any] = ...,
    ) -> Any: ...
    def get_signature(
        self,
        method: Any,
        split: Any,
        headers: Any,
        expires: Optional[Any] = ...,
        auth_path: Optional[Any] = ...,
    ) -> Any: ...
    def add_auth(self, request: Any) -> None: ...

class HmacV1QueryAuth(HmacV1Auth):
    DEFAULT_EXPIRES: int = ...
    credentials: Any = ...
    def __init__(self, credentials: Any, expires: Any = ...) -> None: ...

class HmacV1PostAuth(HmacV1Auth):
    def add_auth(self, request: Any) -> None: ...

AUTH_TYPE_MAPS: Any
