#!/usr/bin/env python

#  Copyright (c) 2019 JD Williams
#
#  This file is part of Firefly, a Python SOA framework built by JD Williams. Firefly is free software; you can
#  redistribute it and/or modify it under the terms of the GNU General Public License as published by the
#  Free Software Foundation; either version 3 of the License, or (at your option) any later version.
#
#  Firefly is distributed in the hope that it will be useful, but WITHOUT ANY WARRANTY; without even the
#  implied warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General
#  Public License for more details. You should have received a copy of the GNU Lesser General Public
#  License along with this program.  If not, see <http://www.gnu.org/licenses/>.
#
#  You should have received a copy of the GNU General Public License along with Firefly. If not, see
#  <http://www.gnu.org/licenses/>.

""" Unit tests for the ninja.py file. """

import gyp.generator.ninja as ninja
import unittest
import StringIO
import sys
import TestCommon


class TestPrefixesAndSuffixes(unittest.TestCase):
  def test_BinaryNamesWindows(self):
    # These cannot run on non-Windows as they require a VS installation to
    # correctly handle variable expansion.
    if sys.platform.startswith('win'):
      writer = ninja.NinjaWriter('foo', 'wee', '.', '.', 'build.ninja', '.',
          'build.ninja', 'win')
      spec = { 'target_name': 'wee' }
      self.assertTrue(writer.ComputeOutputFileName(spec, 'executable').
          endswith('.exe'))
      self.assertTrue(writer.ComputeOutputFileName(spec, 'shared_library').
          endswith('.dll'))
      self.assertTrue(writer.ComputeOutputFileName(spec, 'static_library').
          endswith('.lib'))

  def test_BinaryNamesLinux(self):
    writer = ninja.NinjaWriter('foo', 'wee', '.', '.', 'build.ninja', '.',
        'build.ninja', 'linux')
    spec = { 'target_name': 'wee' }
    self.assertTrue('.' not in writer.ComputeOutputFileName(spec,
                                                            'executable'))
    self.assertTrue(writer.ComputeOutputFileName(spec, 'shared_library').
        startswith('lib'))
    self.assertTrue(writer.ComputeOutputFileName(spec, 'static_library').
        startswith('lib'))
    self.assertTrue(writer.ComputeOutputFileName(spec, 'shared_library').
        endswith('.so'))
    self.assertTrue(writer.ComputeOutputFileName(spec, 'static_library').
        endswith('.a'))

if __name__ == '__main__':
  unittest.main()
