import * as cloudwatch from '@aws-cdk/aws-cloudwatch';
import * as iam from '@aws-cdk/aws-iam';
import { Duration } from '@aws-cdk/core';
import { Task } from './states/task';
/**
 * (deprecated) Interface for resources that can be used as tasks.
 *
 * @deprecated replaced by `TaskStateBase`.
 */
export interface IStepFunctionsTask {
    /**
     * (deprecated) Called when the task object is used in a workflow.
     *
     * @deprecated
     */
    bind(task: Task): StepFunctionsTaskConfig;
}
/**
 * (deprecated) Properties that define what kind of task should be created.
 *
 * @deprecated used by `IStepFunctionsTask`. `IStepFunctionsTask` is deprecated and replaced by `TaskStateBase`.
 */
export interface StepFunctionsTaskConfig {
    /**
     * (deprecated) The resource that represents the work to be executed.
     *
     * Either the ARN of a Lambda Function or Activity, or a special
     * ARN.
     *
     * @deprecated
     */
    readonly resourceArn: string;
    /**
     * (deprecated) Parameters pass a collection of key-value pairs, either static values or JSONPath expressions that select from the input.
     *
     * The meaning of these parameters is task-dependent.
     *
     * Its values will be merged with the `parameters` property which is configured directly
     * on the Task state.
     *
     * @default No parameters
     * @see https://docs.aws.amazon.com/step-functions/latest/dg/input-output-inputpath-params.html#input-output-parameters
     * @deprecated
     */
    readonly parameters?: {
        [name: string]: any;
    };
    /**
     * (deprecated) Maximum time between heart beats.
     *
     * If the time between heart beats takes longer than this, a 'Timeout' error is raised.
     *
     * This is only relevant when using an Activity type as resource.
     *
     * @default No heart beat timeout
     * @deprecated
     */
    readonly heartbeat?: Duration;
    /**
     * (deprecated) Additional policy statements to add to the execution role.
     *
     * @default No policy roles
     * @deprecated
     */
    readonly policyStatements?: iam.PolicyStatement[];
    /**
     * (deprecated) Prefix for singular metric names of activity actions.
     *
     * @default No such metrics
     * @deprecated
     */
    readonly metricPrefixSingular?: string;
    /**
     * (deprecated) Prefix for plural metric names of activity actions.
     *
     * @default No such metrics
     * @deprecated
     */
    readonly metricPrefixPlural?: string;
    /**
     * (deprecated) The dimensions to attach to metrics.
     *
     * @default No metrics
     * @deprecated
     */
    readonly metricDimensions?: cloudwatch.DimensionHash;
}
/**
 * Three ways to call an integrated service: Request Response, Run a Job and Wait for a Callback with Task Token.
 *
 * @default FIRE_AND_FORGET
 * @see https://docs.aws.amazon.com/step-functions/latest/dg/connect-to-resource.html
 *
 * Here, they are named as FIRE_AND_FORGET, SYNC and WAIT_FOR_TASK_TOKEN respectfully.
 * @stability stable
 */
export declare enum ServiceIntegrationPattern {
    /**
     * Call a service and progress to the next state immediately after the API call completes.
     *
     * @stability stable
     */
    FIRE_AND_FORGET = "FIRE_AND_FORGET",
    /**
     * Call a service and wait for a job to complete.
     *
     * @stability stable
     */
    SYNC = "SYNC",
    /**
     * Call a service with a task token and wait until that token is returned by SendTaskSuccess/SendTaskFailure with payload.
     *
     * @stability stable
     */
    WAIT_FOR_TASK_TOKEN = "WAIT_FOR_TASK_TOKEN"
}
