/**
 * A Condition for use in a Choice state branch.
 *
 * @stability stable
 */
export declare abstract class Condition {
    /**
     * Matches if variable is present.
     *
     * @stability stable
     */
    static isPresent(variable: string): Condition;
    /**
     * Matches if variable is not present.
     *
     * @stability stable
     */
    static isNotPresent(variable: string): Condition;
    /**
     * Matches if variable is a string.
     *
     * @stability stable
     */
    static isString(variable: string): Condition;
    /**
     * Matches if variable is not a string.
     *
     * @stability stable
     */
    static isNotString(variable: string): Condition;
    /**
     * Matches if variable is numeric.
     *
     * @stability stable
     */
    static isNumeric(variable: string): Condition;
    /**
     * Matches if variable is not numeric.
     *
     * @stability stable
     */
    static isNotNumeric(variable: string): Condition;
    /**
     * Matches if variable is boolean.
     *
     * @stability stable
     */
    static isBoolean(variable: string): Condition;
    /**
     * Matches if variable is not boolean.
     *
     * @stability stable
     */
    static isNotBoolean(variable: string): Condition;
    /**
     * Matches if variable is a timestamp.
     *
     * @stability stable
     */
    static isTimestamp(variable: string): Condition;
    /**
     * Matches if variable is not a timestamp.
     *
     * @stability stable
     */
    static isNotTimestamp(variable: string): Condition;
    /**
     * Matches if variable is not null.
     *
     * @stability stable
     */
    static isNotNull(variable: string): Condition;
    /**
     * Matches if variable is Null.
     *
     * @stability stable
     */
    static isNull(variable: string): Condition;
    /**
     * Matches if a boolean field has the given value.
     *
     * @stability stable
     */
    static booleanEquals(variable: string, value: boolean): Condition;
    /**
     * Matches if a boolean field equals to a value at a given mapping path.
     *
     * @stability stable
     */
    static booleanEqualsJsonPath(variable: string, value: string): Condition;
    /**
     * Matches if a string field equals to a value at a given mapping path.
     *
     * @stability stable
     */
    static stringEqualsJsonPath(variable: string, value: string): Condition;
    /**
     * Matches if a string field has the given value.
     *
     * @stability stable
     */
    static stringEquals(variable: string, value: string): Condition;
    /**
     * Matches if a string field sorts before a given value.
     *
     * @stability stable
     */
    static stringLessThan(variable: string, value: string): Condition;
    /**
     * Matches if a string field sorts before a given value at a particular mapping.
     *
     * @stability stable
     */
    static stringLessThanJsonPath(variable: string, value: string): Condition;
    /**
     * Matches if a string field sorts equal to or before a given value.
     *
     * @stability stable
     */
    static stringLessThanEquals(variable: string, value: string): Condition;
    /**
     * Matches if a string field sorts equal to or before a given mapping.
     *
     * @stability stable
     */
    static stringLessThanEqualsJsonPath(variable: string, value: string): Condition;
    /**
     * Matches if a string field sorts after a given value.
     *
     * @stability stable
     */
    static stringGreaterThan(variable: string, value: string): Condition;
    /**
     * Matches if a string field sorts after a value at a given mapping path.
     *
     * @stability stable
     */
    static stringGreaterThanJsonPath(variable: string, value: string): Condition;
    /**
     * Matches if a string field sorts after or equal to value at a given mapping path.
     *
     * @stability stable
     */
    static stringGreaterThanEqualsJsonPath(variable: string, value: string): Condition;
    /**
     * Matches if a string field sorts after or equal to a given value.
     *
     * @stability stable
     */
    static stringGreaterThanEquals(variable: string, value: string): Condition;
    /**
     * Matches if a numeric field has the given value.
     *
     * @stability stable
     */
    static numberEquals(variable: string, value: number): Condition;
    /**
     * Matches if a numeric field has the value in a given mapping path.
     *
     * @stability stable
     */
    static numberEqualsJsonPath(variable: string, value: string): Condition;
    /**
     * Matches if a numeric field is less than the given value.
     *
     * @stability stable
     */
    static numberLessThan(variable: string, value: number): Condition;
    /**
     * Matches if a numeric field is less than the value at the given mapping path.
     *
     * @stability stable
     */
    static numberLessThanJsonPath(variable: string, value: string): Condition;
    /**
     * Matches if a numeric field is less than or equal to the given value.
     *
     * @stability stable
     */
    static numberLessThanEquals(variable: string, value: number): Condition;
    /**
     * Matches if a numeric field is less than or equal to the numeric value at given mapping path.
     *
     * @stability stable
     */
    static numberLessThanEqualsJsonPath(variable: string, value: string): Condition;
    /**
     * Matches if a numeric field is greater than the given value.
     *
     * @stability stable
     */
    static numberGreaterThan(variable: string, value: number): Condition;
    /**
     * Matches if a numeric field is greater than the value at a given mapping path.
     *
     * @stability stable
     */
    static numberGreaterThanJsonPath(variable: string, value: string): Condition;
    /**
     * Matches if a numeric field is greater than or equal to the given value.
     *
     * @stability stable
     */
    static numberGreaterThanEquals(variable: string, value: number): Condition;
    /**
     * Matches if a numeric field is greater than or equal to the value at a given mapping path.
     *
     * @stability stable
     */
    static numberGreaterThanEqualsJsonPath(variable: string, value: string): Condition;
    /**
     * Matches if a timestamp field is the same time as the given timestamp.
     *
     * @stability stable
     */
    static timestampEquals(variable: string, value: string): Condition;
    /**
     * Matches if a timestamp field is the same time as the timestamp at a given mapping path.
     *
     * @stability stable
     */
    static timestampEqualsJsonPath(variable: string, value: string): Condition;
    /**
     * Matches if a timestamp field is before the given timestamp.
     *
     * @stability stable
     */
    static timestampLessThan(variable: string, value: string): Condition;
    /**
     * Matches if a timestamp field is before the timestamp at a given mapping path.
     *
     * @stability stable
     */
    static timestampLessThanJsonPath(variable: string, value: string): Condition;
    /**
     * Matches if a timestamp field is before or equal to the given timestamp.
     *
     * @stability stable
     */
    static timestampLessThanEquals(variable: string, value: string): Condition;
    /**
     * Matches if a timestamp field is before or equal to the timestamp at a given mapping path.
     *
     * @stability stable
     */
    static timestampLessThanEqualsJsonPath(variable: string, value: string): Condition;
    /**
     * Matches if a timestamp field is after the given timestamp.
     *
     * @stability stable
     */
    static timestampGreaterThan(variable: string, value: string): Condition;
    /**
     * Matches if a timestamp field is after the timestamp at a given mapping path.
     *
     * @stability stable
     */
    static timestampGreaterThanJsonPath(variable: string, value: string): Condition;
    /**
     * Matches if a timestamp field is after or equal to the given timestamp.
     *
     * @stability stable
     */
    static timestampGreaterThanEquals(variable: string, value: string): Condition;
    /**
     * Matches if a timestamp field is after or equal to the timestamp at a given mapping path.
     *
     * @stability stable
     */
    static timestampGreaterThanEqualsJsonPath(variable: string, value: string): Condition;
    /**
     * Matches if a field matches a string pattern that can contain a wild card (*) e.g: log-*.txt or *LATEST*. No other characters other than "*" have any special meaning - * can be escaped: \\*.
     *
     * @stability stable
     */
    static stringMatches(variable: string, value: string): Condition;
    /**
     * Combine two or more conditions with a logical AND.
     *
     * @stability stable
     */
    static and(...conditions: Condition[]): Condition;
    /**
     * Combine two or more conditions with a logical OR.
     *
     * @stability stable
     */
    static or(...conditions: Condition[]): Condition;
    /**
     * Negate a condition.
     *
     * @stability stable
     */
    static not(condition: Condition): Condition;
    /**
     * Render Amazon States Language JSON for the condition.
     *
     * @stability stable
     */
    abstract renderCondition(): any;
}
