# Generated by Django 3.2 on 2021-04-07 14:13

from django.conf import settings
from django.db import migrations, models
import django.db.models.deletion
import uuid


class Migration(migrations.Migration):

    initial = True

    dependencies = [
        migrations.swappable_dependency(settings.AUTH_USER_MODEL),
    ]

    operations = [
        migrations.CreateModel(
            name='Account',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('address', models.CharField(blank=True, max_length=255, null=True)),
                ('crypted_key', models.BinaryField()),
            ],
        ),
        migrations.CreateModel(
            name='Blockchain',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('name', models.CharField(max_length=100)),
                ('endpoint', models.CharField(max_length=255)),
                ('explorer', models.CharField(blank=True, max_length=255, null=True)),
                ('provider_class', models.CharField(choices=[('djtezos.tezos.Provider', 'Tezos'), ('djtezos.fake.Provider', 'Test'), ('djtezos.fake.FailDeploy', 'Test that fails deploy'), ('djtezos.fake.FailWatch', 'Test that fails watch')], default='djtezos.fake.Provider', max_length=255)),
                ('confirmation_blocks', models.IntegerField(default=0)),
                ('description', models.TextField(blank=True)),
                ('is_active', models.BooleanField(default=True)),
            ],
        ),
        migrations.CreateModel(
            name='Transaction',
            fields=[
                ('id', models.UUIDField(default=uuid.uuid4, editable=False, primary_key=True, serialize=False)),
                ('created_at', models.DateTimeField(auto_now_add=True, null=True)),
                ('updated_at', models.DateTimeField(auto_now=True, null=True)),
                ('txhash', models.CharField(blank=True, max_length=255, null=True, unique=True)),
                ('gasprice', models.BigIntegerField(blank=True, null=True)),
                ('gas', models.BigIntegerField(blank=True, null=True)),
                ('contract_address', models.CharField(max_length=255, null=True)),
                ('contract_name', models.CharField(max_length=100, null=True)),
                ('contract_code', models.TextField(blank=True, null=True)),
                ('function', models.CharField(blank=True, max_length=100, null=True)),
                ('args', models.JSONField(default=list, null=True)),
                ('amount', models.PositiveIntegerField(default=0)),
                ('state', models.CharField(choices=[('held', 'Held'), ('deploy', 'To deploy'), ('deploying', 'Deploying'), ('deploy-aborted', 'Deploy aborted'), ('watch', 'To watch'), ('watching', 'Watching'), ('watch-aborted', 'Watch aborted'), ('postdeploy', 'To post-deploy'), ('postdeploying', 'Post-deploying'), ('postdeploy-aborted', 'Postdeploy aborted'), ('done', 'Finished')], db_index=True, default='held', max_length=200)),
                ('error', models.TextField(blank=True)),
                ('history', models.JSONField(default=list)),
                ('contract', models.ForeignKey(blank=True, null=True, on_delete=django.db.models.deletion.CASCADE, related_name='call_set', to='djtezos.transaction')),
                ('receiver', models.ForeignKey(blank=True, null=True, on_delete=django.db.models.deletion.CASCADE, related_name='transactions_received', to='djtezos.account')),
                ('sender', models.ForeignKey(blank=True, null=True, on_delete=django.db.models.deletion.CASCADE, related_name='transactions_sent', to='djtezos.account')),
            ],
        ),
        migrations.AddField(
            model_name='account',
            name='blockchain',
            field=models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, to='djtezos.blockchain'),
        ),
        migrations.AddField(
            model_name='account',
            name='owner',
            field=models.ForeignKey(blank=True, null=True, on_delete=django.db.models.deletion.SET_NULL, to=settings.AUTH_USER_MODEL),
        ),
        migrations.CreateModel(
            name='Call',
            fields=[
            ],
            options={
                'proxy': True,
                'indexes': [],
                'constraints': [],
            },
            bases=('djtezos.transaction',),
        ),
        migrations.CreateModel(
            name='Contract',
            fields=[
            ],
            options={
                'proxy': True,
                'indexes': [],
                'constraints': [],
            },
            bases=('djtezos.transaction',),
        ),
        migrations.CreateModel(
            name='Transfer',
            fields=[
            ],
            options={
                'proxy': True,
                'indexes': [],
                'constraints': [],
            },
            bases=('djtezos.transaction',),
        ),
    ]
